/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.cuda.alternative;

import java.io.Serializable;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.jcurand.JCurand;
import jcuda.jcurand.curandGenerator;
import jcuda.runtime.JCuda;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.cuda.RandomVariableCuda;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class BrownianMotionCudaWithRandomVariableCuda
implements BrownianMotion,
Serializable {
    private static final long serialVersionUID = -5430067621669213475L;
    private final TimeDiscretization timeDiscretization;
    private final int numberOfFactors;
    private final int numberOfPaths;
    private final int seed;
    private final AbstractRandomVariableFactory randomVariableFactory;
    private transient RandomVariable[][] brownianIncrements;
    private final Object brownianIncrementsLazyInitLock = new Object();

    public BrownianMotionCudaWithRandomVariableCuda(TimeDiscretization timeDiscretization, int numberOfFactors, int numberOfPaths, int seed, AbstractRandomVariableFactory randomVariableFactory) {
        this.timeDiscretization = timeDiscretization;
        this.numberOfFactors = numberOfFactors;
        this.numberOfPaths = numberOfPaths;
        this.seed = seed;
        this.randomVariableFactory = new RandomVariableFactory(false);
        this.brownianIncrements = null;
    }

    public BrownianMotionCudaWithRandomVariableCuda(TimeDiscretization timeDiscretization, int numberOfFactors, int numberOfPaths, int seed) {
        this(timeDiscretization, numberOfFactors, numberOfPaths, seed, (AbstractRandomVariableFactory)new RandomVariableFactory());
    }

    public BrownianMotion getCloneWithModifiedSeed(int seed) {
        return new BrownianMotionCudaWithRandomVariableCuda(this.getTimeDiscretization(), this.getNumberOfFactors(), this.getNumberOfPaths(), seed);
    }

    public BrownianMotion getCloneWithModifiedTimeDiscretization(TimeDiscretization newTimeDiscretization) {
        return new BrownianMotionCudaWithRandomVariableCuda(newTimeDiscretization, this.getNumberOfFactors(), this.getNumberOfPaths(), this.getSeed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomVariable getBrownianIncrement(int timeIndex, int factor) {
        Object object = this.brownianIncrementsLazyInitLock;
        synchronized (object) {
            if (this.brownianIncrements == null) {
                this.doGenerateBrownianMotion();
            }
        }
        return this.brownianIncrements[timeIndex][factor];
    }

    private void doGenerateBrownianMotion() {
        if (this.brownianIncrements != null) {
            return;
        }
        JCuda.setExceptionsEnabled((boolean)true);
        JCurand.setExceptionsEnabled((boolean)true);
        JCuda.setLogLevel((LogLevel)LogLevel.LOG_DEBUG);
        RandomVariableCuda rv = new RandomVariableCuda(0.0);
        curandGenerator generator = new curandGenerator();
        JCurand.curandCreateGenerator((curandGenerator)generator, (int)141);
        JCurand.curandSetPseudoRandomGeneratorSeed((curandGenerator)generator, (long)this.seed);
        this.brownianIncrements = new RandomVariable[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors];
        for (int timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double time = this.timeDiscretization.getTime(timeIndex + 1);
            float sqrtOfTimeStep = (float)Math.sqrt(this.timeDiscretization.getTimeStep(timeIndex));
            for (int factor = 0; factor < this.numberOfFactors; ++factor) {
                RandomVariableCuda.DevicePointerReference realizations = RandomVariableCuda.getDevicePointer(this.numberOfPaths);
                JCurand.curandGenerateNormal((curandGenerator)generator, (Pointer)realizations.get(), (long)this.numberOfPaths, (float)0.0f, (float)sqrtOfTimeStep);
                this.brownianIncrements[timeIndex][factor] = RandomVariableCuda.of(time, realizations, this.numberOfPaths);
            }
        }
        JCurand.curandDestroyGenerator((curandGenerator)generator);
    }

    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    public RandomVariable getRandomVariableForConstant(double value) {
        return new RandomVariableCuda(value);
    }

    public int getSeed() {
        return this.seed;
    }

    public String toString() {
        return super.toString() + "\ntimeDiscretizationFromArray: " + this.timeDiscretization.toString() + "\nnumberOfPaths: " + this.numberOfPaths + "\nnumberOfFactors: " + this.numberOfFactors + "\nseed: " + this.seed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrownianMotionCudaWithRandomVariableCuda that = (BrownianMotionCudaWithRandomVariableCuda)o;
        if (this.numberOfFactors != that.numberOfFactors) {
            return false;
        }
        if (this.numberOfPaths != that.numberOfPaths) {
            return false;
        }
        if (this.seed != that.seed) {
            return false;
        }
        return this.timeDiscretization.equals(that.timeDiscretization);
    }

    public RandomVariable getIncrement(int timeIndex, int factor) {
        return this.getBrownianIncrement(timeIndex, factor);
    }

    public int hashCode() {
        int result = this.timeDiscretization.hashCode();
        result = 31 * result + this.numberOfFactors;
        result = 31 * result + this.numberOfPaths;
        result = 31 * result + this.seed;
        return result;
    }
}

