/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.cuda;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.DoubleStream;
import jcuda.LogLevel;
import jcuda.NativePointerObject;
import jcuda.Pointer;
import jcuda.driver.CUcontext;
import jcuda.driver.CUdevice;
import jcuda.driver.CUdeviceptr;
import jcuda.driver.CUfunction;
import jcuda.driver.CUmodule;
import jcuda.driver.JCudaDriver;
import jcuda.runtime.JCuda;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.jcuda.JCudaUtils;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.RandomVariableFromFloatArray;
import net.finmath.stochastic.RandomVariable;

public class RandomVariableCuda
implements RandomVariable {
    private static DeviceMemoryPool deviceMemoryPool = new DeviceMemoryPool();
    private static final long serialVersionUID = 7620120320663270600L;
    private final double time;
    private static final int typePriorityDefault = 20;
    private final int typePriority;
    private final DevicePointerReference realizations;
    private final long size;
    private final double valueIfNonStochastic;
    private static final Logger logger = Logger.getLogger("net.finmath");
    private static final ExecutorService deviceExecutor = Executors.newSingleThreadExecutor();
    public static final CUdevice device = new CUdevice();
    public static final CUcontext context = new CUcontext();
    public static final CUmodule module = new CUmodule();
    private static final CUfunction capByScalar = new CUfunction();
    private static final CUfunction floorByScalar = new CUfunction();
    private static final CUfunction addScalar = new CUfunction();
    private static final CUfunction subScalar = new CUfunction();
    private static final CUfunction busScalar = new CUfunction();
    private static final CUfunction multScalar = new CUfunction();
    private static final CUfunction divScalar = new CUfunction();
    private static final CUfunction vidScalar = new CUfunction();
    private static final CUfunction cuPow = new CUfunction();
    private static final CUfunction cuSqrt = new CUfunction();
    private static final CUfunction cuExp = new CUfunction();
    private static final CUfunction cuLog = new CUfunction();
    private static final CUfunction invert = new CUfunction();
    private static final CUfunction cuAbs = new CUfunction();
    private static final CUfunction cap = new CUfunction();
    private static final CUfunction cuFloor = new CUfunction();
    private static final CUfunction add = new CUfunction();
    private static final CUfunction sub = new CUfunction();
    private static final CUfunction mult = new CUfunction();
    private static final CUfunction cuDiv = new CUfunction();
    private static final CUfunction accrue = new CUfunction();
    private static final CUfunction discount = new CUfunction();
    private static final CUfunction addProduct = new CUfunction();
    private static final CUfunction addProduct_vs = new CUfunction();
    private static final CUfunction reducePartial = new CUfunction();
    private static final CUfunction reduceFloatVectorToDoubleScalar = new CUfunction();
    private static final int reduceGridSize = 1024;

    public static RandomVariableCuda of(double time, DevicePointerReference realizations, long size, int typePriority) {
        RandomVariableCuda randomVariableCuda = new RandomVariableCuda(time, realizations, size, typePriority);
        return randomVariableCuda;
    }

    public static RandomVariableCuda of(double time, DevicePointerReference realizations, long size) {
        RandomVariableCuda randomVariableCuda = new RandomVariableCuda(time, realizations, size, 20);
        return randomVariableCuda;
    }

    private RandomVariableCuda(double time, DevicePointerReference realizations, long size, int typePriority) {
        this.time = time;
        this.realizations = realizations;
        this.size = size;
        this.valueIfNonStochastic = Double.NaN;
        this.typePriority = typePriority;
    }

    public RandomVariableCuda(double value) {
        this(-1.7976931348623157E308, value);
    }

    public RandomVariableCuda(double time, double value, int typePriority) {
        this.time = time;
        this.realizations = null;
        this.size = 1L;
        this.valueIfNonStochastic = value;
        this.typePriority = typePriority;
    }

    public RandomVariableCuda(double time, float[] realisations, int typePriority) {
        this(time, RandomVariableCuda.getDevicePointer(realisations), realisations.length, typePriority);
    }

    public RandomVariableCuda(double time, double value) {
        this(time, value, 20);
    }

    public RandomVariableCuda(double time, float[] realisations) {
        this(time, RandomVariableCuda.getDevicePointer(realisations), realisations.length, 20);
    }

    public RandomVariableCuda(double time, double[] realisations) {
        this(time, RandomVariableCuda.getFloatArray(realisations));
    }

    public RandomVariableCuda(float[] realisations) {
        this(0.0, realisations);
    }

    public static DevicePointerReference getDevicePointer(long size) {
        return deviceMemoryPool.getDevicePointer(size);
    }

    private static DevicePointerReference getDevicePointer(float[] values) {
        return deviceMemoryPool.getDevicePointer(values);
    }

    public static void clean() {
        deviceMemoryPool.clean();
    }

    private static RandomVariableCuda getRandomVariableCuda(RandomVariable randomVariable) {
        if (randomVariable instanceof RandomVariableCuda) {
            return (RandomVariableCuda)randomVariable;
        }
        RandomVariableCuda randomVariableCuda = new RandomVariableCuda(randomVariable.getFiltrationTime(), randomVariable.getRealizations());
        return randomVariableCuda;
    }

    private static float getDeviceFreeMemPercentage() {
        float freeRate;
        try {
            freeRate = deviceExecutor.submit(new Callable<Float>(){

                @Override
                public Float call() {
                    long[] free = new long[1];
                    long[] total = new long[1];
                    JCuda.cudaMemGetInfo((long[])free, (long[])total);
                    float freeRate = (float)free[0] / (float)total[0];
                    return Float.valueOf(freeRate);
                }
            }).get().floatValue();
        }
        catch (InterruptedException | ExecutionException e) {
            float freeRate2 = 0.0f;
            return 0.0f;
        }
        return freeRate;
    }

    private static float[] getFloatArray(double[] arrayOfDouble) {
        float[] arrayOfFloat = new float[arrayOfDouble.length];
        for (int i = 0; i < arrayOfDouble.length; ++i) {
            arrayOfFloat[i] = (float)arrayOfDouble[i];
        }
        return arrayOfFloat;
    }

    private static double[] getDoubleArray(float[] arrayOfFloat) {
        double[] arrayOfDouble = new double[arrayOfFloat.length];
        for (int i = 0; i < arrayOfFloat.length; ++i) {
            arrayOfDouble[i] = arrayOfFloat[i];
        }
        return arrayOfDouble;
    }

    public boolean equals(RandomVariable randomVariable) {
        throw new UnsupportedOperationException();
    }

    public double getFiltrationTime() {
        return this.time;
    }

    public int getTypePriority() {
        return this.typePriority;
    }

    public double get(int pathOrState) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        throw new UnsupportedOperationException();
    }

    public int size() {
        if (this.isDeterministic()) {
            return 1;
        }
        return (int)this.size;
    }

    public double getMin() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        double[] realizations = this.getRealizations();
        double min = Double.MAX_VALUE;
        if (realizations.length != 0) {
            min = realizations[0];
        }
        for (int i = 0; i < realizations.length; ++i) {
            min = Math.min(realizations[i], min);
        }
        return min;
    }

    public double getMax() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        double[] realizations = this.getRealizations();
        double max = -1.7976931348623157E308;
        if (realizations.length != 0) {
            max = realizations[0];
        }
        for (int i = 0; i < realizations.length; ++i) {
            max = Math.max(realizations[i], max);
        }
        return max;
    }

    public double getAverage() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return new RandomVariableFromFloatArray(this.getFiltrationTime(), deviceMemoryPool.getValuesAsFloat(this.realizations, this.size())).getAverage();
    }

    public double getAverage(RandomVariable probabilities) {
        return this.mult(probabilities).getAverage();
    }

    public double getVariance() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double average = this.getAverage();
        return this.squared().getAverage() - average * average;
    }

    public double getVariance(RandomVariable probabilities) {
        double average = this.getAverage(probabilities);
        return this.squared().sub(average * average).getAverage(probabilities);
    }

    public double getSampleVariance() {
        if (this.isDeterministic() || this.size() == 1) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getVariance() * (double)this.size() / (double)(this.size() - 1);
    }

    public double getStandardDeviation() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance());
    }

    public double getStandardDeviation(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return Math.sqrt(this.getVariance(probabilities));
    }

    public double getStandardError() {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation() / Math.sqrt(this.size());
    }

    public double getStandardError(RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return 0.0;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        return this.getStandardDeviation(probabilities) / Math.sqrt(this.size());
    }

    public double getQuantile(double quantile) {
        double[] realizations;
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        double[] realizationsSorted = realizations = this.getRealizations();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValue = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * (1.0 - quantile) - 1.0), 0), this.size() - 1);
        return realizationsSorted[indexOfQuantileValue];
    }

    public double getQuantile(double quantile, RandomVariable probabilities) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        throw new RuntimeException("Method not implemented.");
    }

    public double getQuantileExpectation(double quantileStart, double quantileEnd) {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        if (this.size() == 0) {
            return Double.NaN;
        }
        if (quantileStart > quantileEnd) {
            return this.getQuantileExpectation(quantileEnd, quantileStart);
        }
        double[] realizationsSorted = this.getRealizations();
        Arrays.sort(realizationsSorted);
        int indexOfQuantileValueStart = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileStart - 1.0), 0), this.size() - 1);
        int indexOfQuantileValueEnd = Math.min(Math.max((int)Math.round((double)(this.size() + 1) * quantileEnd - 1.0), 0), this.size() - 1);
        double quantileExpectation = 0.0;
        for (int i = indexOfQuantileValueStart; i <= indexOfQuantileValueEnd; ++i) {
            quantileExpectation += realizationsSorted[i];
        }
        return quantileExpectation /= (double)(indexOfQuantileValueEnd - indexOfQuantileValueStart + 1);
    }

    public double[] getHistogram(double[] intervalPoints) {
        double[] histogramValues = new double[intervalPoints.length + 1];
        if (this.isDeterministic()) {
            Arrays.fill(histogramValues, 0.0);
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                if (!(this.valueIfNonStochastic > intervalPoints[intervalIndex])) continue;
                histogramValues[intervalIndex] = 1.0;
                break;
            }
            histogramValues[intervalPoints.length] = 1.0;
        } else {
            double[] realizationsSorted = this.getRealizations();
            Arrays.sort(realizationsSorted);
            int sampleIndex = 0;
            for (int intervalIndex = 0; intervalIndex < intervalPoints.length; ++intervalIndex) {
                int sampleCount = 0;
                while (sampleIndex < realizationsSorted.length && realizationsSorted[sampleIndex] <= intervalPoints[intervalIndex]) {
                    ++sampleIndex;
                    ++sampleCount;
                }
                histogramValues[intervalIndex] = sampleCount;
            }
            histogramValues[intervalPoints.length] = realizationsSorted.length - sampleIndex;
            if (realizationsSorted.length > 0) {
                int i = 0;
                while (i < histogramValues.length) {
                    int n = i++;
                    histogramValues[n] = histogramValues[n] / (double)realizationsSorted.length;
                }
            }
        }
        return histogramValues;
    }

    public double[][] getHistogram(int numberOfPoints, double standardDeviations) {
        double[] intervalPoints = new double[numberOfPoints];
        double[] anchorPoints = new double[numberOfPoints + 1];
        double center = this.getAverage();
        double radius = standardDeviations * this.getStandardDeviation();
        double stepSize = (double)(numberOfPoints - 1) / 2.0;
        for (int i = 0; i < numberOfPoints; ++i) {
            double alpha = (-((double)(numberOfPoints - 1)) / 2.0 + (double)i) / stepSize;
            intervalPoints[i] = center + alpha * radius;
            anchorPoints[i] = center + alpha * radius - radius / (2.0 * stepSize);
        }
        anchorPoints[numberOfPoints] = center + 1.0 * radius + radius / (2.0 * stepSize);
        double[][] result = new double[][]{anchorPoints, this.getHistogram(intervalPoints)};
        return result;
    }

    public boolean isDeterministic() {
        return this.realizations == null;
    }

    public RandomVariable cache() {
        return this;
    }

    public double[] getRealizations() {
        if (this.isDeterministic()) {
            double[] result = new double[]{this.valueIfNonStochastic};
            return result;
        }
        return RandomVariableCuda.getDoubleArray(deviceMemoryPool.getValuesAsFloat(this.realizations, this.size()));
    }

    public Double doubleValue() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        throw new UnsupportedOperationException("The random variable is non-deterministic");
    }

    public IntToDoubleFunction getOperator() {
        return null;
    }

    public DoubleStream getRealizationsStream() {
        return null;
    }

    public RandomVariable apply(DoubleUnaryOperator function) {
        throw new UnsupportedOperationException();
    }

    public RandomVariable apply(DoubleBinaryOperator operator, RandomVariable argument) {
        throw new UnsupportedOperationException();
    }

    public RandomVariable apply(DoubleTernaryOperator operator, RandomVariable argument1, RandomVariable argument2) {
        throw new UnsupportedOperationException();
    }

    public RandomVariable cap(double cap) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.min(this.valueIfNonStochastic, cap);
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s1(capByScalar, this.size, this.realizations, cap);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable floor(double floor) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.max(this.valueIfNonStochastic, floor);
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s1(floorByScalar, this.size, this.realizations, floor);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable add(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + value;
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s1(addScalar, this.size, this.realizations, value);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable sub(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - value;
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s1(subScalar, this.size, this.realizations, value);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable bus(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = -this.valueIfNonStochastic + value;
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s1(busScalar, this.size, this.realizations, value);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable mult(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * value;
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s1(multScalar, this.size, this.realizations, value);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable div(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / value;
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s1(divScalar, this.size, this.realizations, value);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable vid(double value) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = value / this.valueIfNonStochastic;
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s1(vidScalar, this.size, this.realizations, value);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable pow(double exponent) {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.pow(this.valueIfNonStochastic, exponent);
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s1(cuPow, this.size, this.realizations, exponent);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable average() {
        return new RandomVariableCuda(this.getAverage());
    }

    public RandomVariable squared() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * this.valueIfNonStochastic;
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        return this.mult(this);
    }

    public RandomVariable sqrt() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.sqrt(this.valueIfNonStochastic);
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s0(cuSqrt, this.size, this.realizations);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable invert() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = 1.0 / this.valueIfNonStochastic;
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s0(invert, this.size, this.realizations);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable abs() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.abs(this.valueIfNonStochastic);
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s0(cuAbs, this.size, this.realizations);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariableCuda exp() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.exp(this.valueIfNonStochastic);
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s0(cuExp, this.size, this.realizations);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariableCuda log() {
        if (this.isDeterministic()) {
            double newValueIfNonStochastic = Math.log(this.valueIfNonStochastic);
            return new RandomVariableCuda(this.time, newValueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv1s0(cuLog, this.size, this.realizations);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable sin() {
        throw new UnsupportedOperationException();
    }

    public RandomVariable cos() {
        throw new UnsupportedOperationException();
    }

    public RandomVariable add(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.add((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + randomVariable.doubleValue();
            return new RandomVariableCuda(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return RandomVariableCuda.getRandomVariableCuda(randomVariable).add(this.valueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.add(randomVariable.doubleValue());
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv2s0(add, this.size, this.realizations, RandomVariableCuda.getRandomVariableCuda((RandomVariable)randomVariable).realizations);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable sub(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.bus((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic - randomVariable.doubleValue();
            return new RandomVariableCuda(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return RandomVariableCuda.getRandomVariableCuda(randomVariable).bus(this.valueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.sub(randomVariable.doubleValue());
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv2s0(sub, this.size, this.realizations, RandomVariableCuda.getRandomVariableCuda((RandomVariable)randomVariable).realizations);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable bus(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.sub((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = -this.valueIfNonStochastic + randomVariable.doubleValue();
            return new RandomVariableCuda(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return RandomVariableCuda.getRandomVariableCuda(randomVariable).sub(this.valueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.bus(randomVariable.doubleValue());
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv2s0(sub, this.size, RandomVariableCuda.getRandomVariableCuda((RandomVariable)randomVariable).realizations, this.realizations);
        return RandomVariableCuda.of(this.time, result, this.size());
    }

    public RandomVariable mult(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.mult((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic * randomVariable.doubleValue();
            return new RandomVariableCuda(newTime, newValueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.mult(randomVariable.doubleValue());
        }
        if (this.isDeterministic() && !randomVariable.isDeterministic()) {
            return RandomVariableCuda.getRandomVariableCuda(randomVariable).mult(this.valueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv2s0(mult, this.size, this.realizations, RandomVariableCuda.getRandomVariableCuda((RandomVariable)randomVariable).realizations);
        return RandomVariableCuda.of(newTime, result, this.size());
    }

    public RandomVariable div(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.vid((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic / randomVariable.doubleValue();
            return new RandomVariableCuda(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return RandomVariableCuda.getRandomVariableCuda(randomVariable).vid(this.valueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.div(randomVariable.doubleValue());
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv2s0(cuDiv, this.size, this.realizations, RandomVariableCuda.getRandomVariableCuda((RandomVariable)randomVariable).realizations);
        return RandomVariableCuda.of(newTime, result, this.size());
    }

    public RandomVariable vid(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.vid((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = randomVariable.doubleValue() / this.valueIfNonStochastic;
            return new RandomVariableCuda(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return RandomVariableCuda.getRandomVariableCuda(randomVariable).div(this.valueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.vid(randomVariable.doubleValue());
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv2s0(cuDiv, this.size, RandomVariableCuda.getRandomVariableCuda((RandomVariable)randomVariable).realizations, this.realizations);
        return RandomVariableCuda.of(newTime, result, this.size());
    }

    public RandomVariable cap(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.cap((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = Math.min(this.valueIfNonStochastic, randomVariable.doubleValue());
            return new RandomVariableCuda(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return randomVariable.cap(this.valueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv2s0(cap, this.size, this.realizations, RandomVariableCuda.getRandomVariableCuda((RandomVariable)randomVariable).realizations);
        return RandomVariableCuda.of(newTime, result, this.size());
    }

    public RandomVariable floor(RandomVariable randomVariable) {
        if (randomVariable.getTypePriority() > this.getTypePriority()) {
            return randomVariable.floor((RandomVariable)this);
        }
        double newTime = Math.max(this.time, randomVariable.getFiltrationTime());
        if (this.isDeterministic() && randomVariable.isDeterministic()) {
            double newValueIfNonStochastic = Math.max(this.valueIfNonStochastic, randomVariable.doubleValue());
            return new RandomVariableCuda(newTime, newValueIfNonStochastic);
        }
        if (this.isDeterministic()) {
            return RandomVariableCuda.getRandomVariableCuda(randomVariable).floor(this.valueIfNonStochastic);
        }
        if (randomVariable.isDeterministic()) {
            return this.floor(randomVariable.doubleValue());
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv2s0(cuFloor, this.size, this.realizations, RandomVariableCuda.getRandomVariableCuda((RandomVariable)randomVariable).realizations);
        return RandomVariableCuda.of(newTime, result, this.size());
    }

    public RandomVariable accrue(RandomVariable rate, double periodLength) {
        if (rate.getTypePriority() > this.getTypePriority()) {
            return rate.mult(periodLength).add(1.0).mult((RandomVariable)this);
        }
        double newTime = Math.max(this.time, rate.getFiltrationTime());
        if (rate.isDeterministic()) {
            return this.mult(1.0 + rate.doubleValue() * periodLength);
        }
        if (this.isDeterministic() && !rate.isDeterministic()) {
            return RandomVariableCuda.getRandomVariableCuda(rate.mult(periodLength).add(1.0).mult(this.valueIfNonStochastic));
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv2s1(accrue, this.size, this.realizations, RandomVariableCuda.getRandomVariableCuda((RandomVariable)rate).realizations, periodLength);
        return RandomVariableCuda.of(newTime, result, this.size());
    }

    public RandomVariable discount(RandomVariable rate, double periodLength) {
        if (rate.getTypePriority() > this.getTypePriority()) {
            return rate.mult(periodLength).add(1.0).invert().mult((RandomVariable)this);
        }
        double newTime = Math.max(this.time, rate.getFiltrationTime());
        if (rate.isDeterministic()) {
            return this.div(1.0 + rate.doubleValue() * periodLength);
        }
        if (this.isDeterministic() && !rate.isDeterministic()) {
            if (this.valueIfNonStochastic == 0.0) {
                return this;
            }
            return RandomVariableCuda.getRandomVariableCuda(rate.mult(periodLength).add(1.0)).vid(this.valueIfNonStochastic);
        }
        DevicePointerReference result = deviceMemoryPool.callCudaFunctionv2s1(discount, this.size, this.realizations, RandomVariableCuda.getRandomVariableCuda((RandomVariable)rate).realizations, periodLength);
        return RandomVariableCuda.of(newTime, result, this.size());
    }

    public RandomVariable choose(RandomVariable valueIfTriggerNonNegative, RandomVariable valueIfTriggerNegative) {
        return null;
    }

    public RandomVariable addProduct(RandomVariable factor1, double factor2) {
        if (factor1.getTypePriority() > this.getTypePriority()) {
            return factor1.mult(factor2).add((RandomVariable)this);
        }
        double newTime = Math.max(this.time, factor1.getFiltrationTime());
        if (factor1.isDeterministic()) {
            return this.add(factor1.doubleValue() * factor2);
        }
        if (!this.isDeterministic() && !factor1.isDeterministic()) {
            DevicePointerReference result = deviceMemoryPool.callCudaFunctionv2s1(addProduct_vs, this.size, this.realizations, RandomVariableCuda.getRandomVariableCuda((RandomVariable)factor1).realizations, factor2);
            return RandomVariableCuda.of(newTime, result, this.size());
        }
        return this.add(factor1.mult(factor2));
    }

    public RandomVariable addProduct(RandomVariable factor1, RandomVariable factor2) {
        if (factor1.getTypePriority() > this.getTypePriority() || factor2.getTypePriority() > this.getTypePriority()) {
            return factor1.mult(factor2).add((RandomVariable)this);
        }
        double newTime = Math.max(Math.max(this.time, factor1.getFiltrationTime()), factor2.getFiltrationTime());
        if (this.isDeterministic() && factor1.isDeterministic() && factor2.isDeterministic()) {
            double newValueIfNonStochastic = this.valueIfNonStochastic + factor1.doubleValue() * factor2.doubleValue();
            return new RandomVariableCuda(newTime, newValueIfNonStochastic);
        }
        if (factor1.isDeterministic() && factor2.isDeterministic()) {
            return this.add(factor1.doubleValue() * factor2.doubleValue());
        }
        if (factor2.isDeterministic()) {
            return this.addProduct(factor1, factor2.doubleValue());
        }
        if (factor1.isDeterministic()) {
            return this.addProduct(factor2, factor1.doubleValue());
        }
        if (!(this.isDeterministic() || factor1.isDeterministic() || factor2.isDeterministic())) {
            DevicePointerReference result = deviceMemoryPool.callCudaFunctionv3s0(addProduct, this.size, this.realizations, RandomVariableCuda.getRandomVariableCuda((RandomVariable)factor1).realizations, RandomVariableCuda.getRandomVariableCuda((RandomVariable)factor2).realizations);
            return RandomVariableCuda.of(newTime, result, this.size());
        }
        return this.add(factor1.mult(factor2));
    }

    public RandomVariable addRatio(RandomVariable numerator, RandomVariable denominator) {
        return this.add(numerator.div(denominator));
    }

    public RandomVariable subRatio(RandomVariable numerator, RandomVariable denominator) {
        return this.sub(numerator.div(denominator));
    }

    public RandomVariable isNaN() {
        return null;
    }

    private RandomVariableFromDoubleArray reduceToDouble() {
        int blockSizeX = 1024;
        final int gridSizeX = (int)Math.ceil((double)this.size() / 2.0 / 1024.0);
        final DevicePointerReference reduceVector = RandomVariableCuda.getDevicePointer(2 * gridSizeX);
        deviceMemoryPool.callCudaFunction(reduceFloatVectorToDoubleScalar, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations.get()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{reduceVector.get()})}, gridSizeX, 1024, 6144);
        final double[] result = new double[gridSizeX];
        try {
            deviceExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    JCudaDriver.cuCtxSynchronize();
                    JCudaDriver.cuMemcpyDtoH((Pointer)Pointer.to((double[])result), (CUdeviceptr)reduceVector.get(), (long)(gridSizeX * 8));
                    JCudaDriver.cuCtxSynchronize();
                }
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        return new RandomVariableFromDoubleArray(this.time, result);
    }

    private double reduce() {
        if (this.isDeterministic()) {
            return this.valueIfNonStochastic;
        }
        RandomVariableCuda reduced = this;
        while (reduced.size() > 1) {
            reduced = reduced.reduceBySize(1024);
        }
        return reduced.getRealizations()[0];
    }

    private RandomVariableCuda reduceBySize(int bySize) {
        int blockSizeX = bySize;
        int gridSizeX = (int)Math.ceil((double)this.size() / 2.0 / (double)blockSizeX);
        DevicePointerReference reduceVector = RandomVariableCuda.getDevicePointer(gridSizeX);
        deviceMemoryPool.callCudaFunction(reducePartial, new Pointer[]{Pointer.to((int[])new int[]{this.size()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{this.realizations.get()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{reduceVector.get()})}, gridSizeX, blockSizeX, blockSizeX * 2 * 3);
        return RandomVariableCuda.of(-1.7976931348623157E308, reduceVector, gridSizeX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        DeviceMemoryPool deviceMemoryPool = RandomVariableCuda.deviceMemoryPool;
        synchronized (deviceMemoryPool) {
            JCudaDriver.setExceptionsEnabled((boolean)true);
            JCudaDriver.setLogLevel((LogLevel)LogLevel.LOG_DEBUG);
            String ptxFileName = null;
            try {
                URL cuFileURL = RandomVariableCuda.class.getClassLoader().getResource("net/finmath/montecarlo/RandomVariableCudaKernel.cu");
                ptxFileName = JCudaUtils.preparePtxFile(cuFileURL);
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
            final String ptxFileName2 = ptxFileName;
            deviceExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    JCudaDriver.cuInit((int)0);
                    JCudaDriver.cuDeviceGet((CUdevice)device, (int)0);
                    JCudaDriver.cuCtxCreate((CUcontext)context, (int)0, (CUdevice)device);
                    JCudaDriver.cuModuleLoad((CUmodule)module, (String)ptxFileName2);
                    JCudaDriver.cuModuleGetFunction((CUfunction)capByScalar, (CUmodule)module, (String)"capByScalar");
                    JCudaDriver.cuModuleGetFunction((CUfunction)floorByScalar, (CUmodule)module, (String)"floorByScalar");
                    JCudaDriver.cuModuleGetFunction((CUfunction)addScalar, (CUmodule)module, (String)"addScalar");
                    JCudaDriver.cuModuleGetFunction((CUfunction)subScalar, (CUmodule)module, (String)"subScalar");
                    JCudaDriver.cuModuleGetFunction((CUfunction)busScalar, (CUmodule)module, (String)"busScalar");
                    JCudaDriver.cuModuleGetFunction((CUfunction)multScalar, (CUmodule)module, (String)"multScalar");
                    JCudaDriver.cuModuleGetFunction((CUfunction)divScalar, (CUmodule)module, (String)"divScalar");
                    JCudaDriver.cuModuleGetFunction((CUfunction)vidScalar, (CUmodule)module, (String)"vidScalar");
                    JCudaDriver.cuModuleGetFunction((CUfunction)cuPow, (CUmodule)module, (String)"cuPow");
                    JCudaDriver.cuModuleGetFunction((CUfunction)cuSqrt, (CUmodule)module, (String)"cuSqrt");
                    JCudaDriver.cuModuleGetFunction((CUfunction)cuExp, (CUmodule)module, (String)"cuExp");
                    JCudaDriver.cuModuleGetFunction((CUfunction)cuLog, (CUmodule)module, (String)"cuLog");
                    JCudaDriver.cuModuleGetFunction((CUfunction)invert, (CUmodule)module, (String)"invert");
                    JCudaDriver.cuModuleGetFunction((CUfunction)cuAbs, (CUmodule)module, (String)"cuAbs");
                    JCudaDriver.cuModuleGetFunction((CUfunction)cap, (CUmodule)module, (String)"cap");
                    JCudaDriver.cuModuleGetFunction((CUfunction)cuFloor, (CUmodule)module, (String)"cuFloor");
                    JCudaDriver.cuModuleGetFunction((CUfunction)add, (CUmodule)module, (String)"add");
                    JCudaDriver.cuModuleGetFunction((CUfunction)sub, (CUmodule)module, (String)"sub");
                    JCudaDriver.cuModuleGetFunction((CUfunction)mult, (CUmodule)module, (String)"mult");
                    JCudaDriver.cuModuleGetFunction((CUfunction)cuDiv, (CUmodule)module, (String)"cuDiv");
                    JCudaDriver.cuModuleGetFunction((CUfunction)accrue, (CUmodule)module, (String)"accrue");
                    JCudaDriver.cuModuleGetFunction((CUfunction)discount, (CUmodule)module, (String)"discount");
                    JCudaDriver.cuModuleGetFunction((CUfunction)addProduct, (CUmodule)module, (String)"addProduct");
                    JCudaDriver.cuModuleGetFunction((CUfunction)addProduct_vs, (CUmodule)module, (String)"addProduct_vs");
                    JCudaDriver.cuModuleGetFunction((CUfunction)reducePartial, (CUmodule)module, (String)"reducePartial");
                    JCudaDriver.cuModuleGetFunction((CUfunction)reduceFloatVectorToDoubleScalar, (CUmodule)module, (String)"reduceFloatVectorToDoubleScalar");
                }
            });
        }
    }

    private static class DeviceMemoryPool {
        private final Object lock = new Object();
        private static final Map<Integer, ReferenceQueue<DevicePointerReference>> vectorsToRecycleReferenceQueueMap = new ConcurrentHashMap<Integer, ReferenceQueue<DevicePointerReference>>();
        private static final Map<WeakReference<DevicePointerReference>, CUdeviceptr> vectorsInUseReferenceMap = new ConcurrentHashMap<WeakReference<DevicePointerReference>, CUdeviceptr>();
        private static final float vectorsRecyclerPercentageFreeToStartGC = 0.15f;
        private static final float vectorsRecyclerPercentageFreeToWaitForGC = 0.05f;
        private static final long vectorsRecyclerMaxTimeOutMillis = 1000L;

        private DeviceMemoryPool() {
        }

        public DevicePointerReference getDevicePointer(final long size) {
            if (logger.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Memory pool stats: ");
                stringBuilder.append("  vector sizes: ");
                for (Map.Entry<Integer, ReferenceQueue<DevicePointerReference>> entry : vectorsToRecycleReferenceQueueMap.entrySet()) {
                    stringBuilder.append("    " + entry.getKey());
                }
                stringBuilder.append("  total number of vectors: " + vectorsInUseReferenceMap.size());
                logger.finest(stringBuilder.toString());
            }
            CUdeviceptr cuDevicePtr = null;
            ReferenceQueue vectorsToRecycleReferenceQueue = vectorsToRecycleReferenceQueueMap.computeIfAbsent(new Integer((int)size), key -> {
                logger.info("Creating reference queue for vector size " + size);
                return new ReferenceQueue();
            });
            Reference reference = vectorsToRecycleReferenceQueue.poll();
            if (reference != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Recycling (1) device pointer " + cuDevicePtr + " from " + reference);
                }
                cuDevicePtr = vectorsInUseReferenceMap.remove(reference);
            } else {
                float deviceFreeMemPercentage = RandomVariableCuda.getDeviceFreeMemPercentage();
                if (deviceFreeMemPercentage < 0.15f && deviceFreeMemPercentage >= 0.05f) {
                    System.runFinalization();
                    System.gc();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.fine("Device free memory " + deviceFreeMemPercentage * 100.0f + "%");
                    }
                    try {
                        reference = vectorsToRecycleReferenceQueue.remove(1L);
                    }
                    catch (IllegalArgumentException | InterruptedException exception) {
                        // empty catch block
                    }
                }
                if (reference == null && deviceFreeMemPercentage < 0.05f) {
                    System.gc();
                    long timeOut = 1L;
                    while (reference == null && timeOut < 1000L) {
                        try {
                            reference = vectorsToRecycleReferenceQueue.remove(timeOut);
                            timeOut *= 4L;
                        }
                        catch (IllegalArgumentException | InterruptedException exception) {}
                    }
                    if (reference != null) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Recycling (2) device pointer " + cuDevicePtr + " from " + reference);
                        }
                        cuDevicePtr = vectorsInUseReferenceMap.remove(reference);
                    } else {
                        logger.info("Last resort: Cleaning all unused vectors on device. Device free memory " + deviceFreeMemPercentage * 100.0f + "%");
                        this.clean();
                    }
                }
            }
            if (cuDevicePtr == null) {
                try {
                    cuDevicePtr = deviceExecutor.submit(new Callable<CUdeviceptr>(){

                        @Override
                        public CUdeviceptr call() {
                            CUdeviceptr cuDevicePtr = new CUdeviceptr();
                            int succ = JCudaDriver.cuMemAlloc((CUdeviceptr)cuDevicePtr, (long)(size * 4L));
                            if (succ != 0) {
                                cuDevicePtr = null;
                                String[] cudaErrorName = new String[1];
                                JCudaDriver.cuGetErrorName((int)succ, (String[])cudaErrorName);
                                String[] cudaErrorDescription = new String[1];
                                JCudaDriver.cuGetErrorString((int)succ, (String[])cudaErrorDescription);
                                logger.warning("Failed creating device vector " + cuDevicePtr + " with size=" + size + " with error " + cudaErrorName + ": " + cudaErrorDescription);
                            }
                            return cuDevicePtr;
                        }
                    }).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.severe("Failed to allocate device vector with size=" + size + ". Cause: " + e.getCause());
                }
                if (cuDevicePtr == null) {
                    logger.severe("Failed to allocate device vector with size=" + size);
                    throw new OutOfMemoryError("Failed to allocate device vector with size=" + size);
                }
            }
            DevicePointerReference devicePointerReference = new DevicePointerReference(cuDevicePtr);
            vectorsInUseReferenceMap.put(new WeakReference<DevicePointerReference>(devicePointerReference, vectorsToRecycleReferenceQueue), cuDevicePtr);
            return devicePointerReference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clean() {
            Object object = this.lock;
            synchronized (object) {
                for (ReferenceQueue<DevicePointerReference> vectorsToRecycleReferenceQueue : vectorsToRecycleReferenceQueueMap.values()) {
                    Reference<DevicePointerReference> reference;
                    while ((reference = vectorsToRecycleReferenceQueue.poll()) != null) {
                        final CUdeviceptr cuDevicePtr = vectorsInUseReferenceMap.remove(reference);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Freeing device pointer " + cuDevicePtr + " from " + reference);
                        }
                        try {
                            deviceExecutor.submit(new Runnable(){

                                @Override
                                public void run() {
                                    JCudaDriver.cuCtxSynchronize();
                                    JCudaDriver.cuMemFree((CUdeviceptr)cuDevicePtr);
                                }
                            }).get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            logger.severe("Unable to free pointer " + cuDevicePtr + " from " + reference);
                            throw new RuntimeException(e.getCause());
                        }
                    }
                }
            }
        }

        public DevicePointerReference getDevicePointer(final float[] values) {
            final DevicePointerReference devicePointerReference = this.getDevicePointer(values.length);
            try {
                deviceExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        JCudaDriver.cuCtxSynchronize();
                        JCudaDriver.cuMemcpyHtoD((CUdeviceptr)devicePointerReference.get(), (Pointer)Pointer.to((float[])values), (long)((long)values.length * 4L));
                    }
                }).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
            return devicePointerReference;
        }

        public float[] getValuesAsFloat(final DevicePointerReference devicePtr, final int size) {
            final float[] result = new float[size];
            try {
                deviceExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        JCudaDriver.cuCtxSynchronize();
                        JCudaDriver.cuMemcpyDtoH((Pointer)Pointer.to((float[])result), (CUdeviceptr)devicePtr.get(), (long)(size * 4));
                        JCudaDriver.cuCtxSynchronize();
                    }
                }).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DevicePointerReference callCudaFunctionv1s0(CUfunction function, long resultSize, DevicePointerReference argument1) {
            Object object = this.lock;
            synchronized (object) {
                DevicePointerReference result = this.getDevicePointer(resultSize);
                this.callCudaFunction(function, resultSize, new Pointer[]{Pointer.to((int[])new int[]{(int)resultSize}), Pointer.to((NativePointerObject[])new NativePointerObject[]{argument1.get()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{result.get()})});
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DevicePointerReference callCudaFunctionv2s0(CUfunction function, long resultSize, DevicePointerReference argument1, DevicePointerReference argument2) {
            Object object = this.lock;
            synchronized (object) {
                DevicePointerReference result = this.getDevicePointer(resultSize);
                this.callCudaFunction(function, resultSize, new Pointer[]{Pointer.to((int[])new int[]{(int)resultSize}), Pointer.to((NativePointerObject[])new NativePointerObject[]{argument1.get()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{argument2.get()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{result.get()})});
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DevicePointerReference callCudaFunctionv3s0(CUfunction function, long resultSize, DevicePointerReference argument1, DevicePointerReference argument2, DevicePointerReference argument3) {
            Object object = this.lock;
            synchronized (object) {
                DevicePointerReference result = this.getDevicePointer(resultSize);
                this.callCudaFunction(function, resultSize, new Pointer[]{Pointer.to((int[])new int[]{(int)resultSize}), Pointer.to((NativePointerObject[])new NativePointerObject[]{argument1.get()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{argument2.get()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{argument3.get()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{result.get()})});
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DevicePointerReference callCudaFunctionv1s1(CUfunction function, long resultSize, DevicePointerReference argument1, double value) {
            Object object = this.lock;
            synchronized (object) {
                DevicePointerReference result = this.getDevicePointer(resultSize);
                this.callCudaFunction(function, resultSize, new Pointer[]{Pointer.to((int[])new int[]{(int)resultSize}), Pointer.to((NativePointerObject[])new NativePointerObject[]{argument1.get()}), Pointer.to((float[])new float[]{(float)value}), Pointer.to((NativePointerObject[])new NativePointerObject[]{result.get()})});
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DevicePointerReference callCudaFunctionv2s1(CUfunction function, long resultSize, DevicePointerReference argument1, DevicePointerReference argument2, double value) {
            Object object = this.lock;
            synchronized (object) {
                DevicePointerReference result = this.getDevicePointer(resultSize);
                this.callCudaFunction(function, resultSize, new Pointer[]{Pointer.to((int[])new int[]{(int)resultSize}), Pointer.to((NativePointerObject[])new NativePointerObject[]{argument1.get()}), Pointer.to((NativePointerObject[])new NativePointerObject[]{argument2.get()}), Pointer.to((float[])new float[]{(float)value}), Pointer.to((NativePointerObject[])new NativePointerObject[]{result.get()})});
                return result;
            }
        }

        public void callCudaFunction(CUfunction function, long resultSize, Pointer[] arguments) {
            int blockSizeX = 1024;
            int gridSizeX = (int)Math.ceil((double)resultSize / 1024.0);
            this.callCudaFunction(function, arguments, gridSizeX, 1024, 0);
        }

        public void callCudaFunction(final CUfunction function, Pointer[] arguments, final int gridSizeX, final int blockSizeX, final int sharedMemorySize) {
            final Pointer kernelParameters = Pointer.to((NativePointerObject[])arguments);
            deviceExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    JCudaDriver.cuLaunchKernel((CUfunction)function, (int)gridSizeX, (int)1, (int)1, (int)blockSizeX, (int)1, (int)1, (int)(sharedMemorySize * 4), null, (Pointer)kernelParameters, null);
                }
            });
        }

        static {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        System.gc();
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }).start();
        }
    }

    public static class DevicePointerReference {
        private final CUdeviceptr devicePointer;

        public DevicePointerReference(CUdeviceptr devicePointer) {
            this.devicePointer = devicePointer;
        }

        public CUdeviceptr get() {
            return this.devicePointer;
        }
    }
}

