/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.jcuda;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Arrays;

public class JCudaUtils {
    public static String preparePtxFile(URL cuFileURL) throws IOException, URISyntaxException {
        String ptxFileName;
        File ptxFile;
        String cuFileName = Paths.get(cuFileURL.toURI()).toFile().getAbsolutePath();
        int endIndex = cuFileName.lastIndexOf(46);
        if (endIndex == -1) {
            endIndex = cuFileName.length() - 1;
        }
        if ((ptxFile = new File(ptxFileName = cuFileName.substring(0, endIndex + 1) + "ptx")).exists()) {
            return ptxFileName;
        }
        File cuFile = new File(cuFileName);
        if (!cuFile.exists()) {
            throw new IOException("Input file not found: " + cuFileName);
        }
        String modelString = "-m" + System.getProperty("sun.arch.data.model");
        Object[] command = new String[]{"nvcc", "-arch", "sm_30", "-fmad", "false", modelString, "-ptx", cuFile.getPath(), "-o", ptxFileName};
        System.out.println("Executing\n" + Arrays.toString(command));
        Process process = Runtime.getRuntime().exec((String[])command);
        String errorMessage = new String(JCudaUtils.toByteArray(process.getErrorStream()));
        String outputMessage = new String(JCudaUtils.toByteArray(process.getInputStream()));
        int exitValue = 0;
        try {
            exitValue = process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for nvcc output", e);
        }
        if (exitValue != 0) {
            System.out.println("nvcc process exitValue " + exitValue);
            System.out.println("errorMessage:\n" + errorMessage);
            System.out.println("outputMessage:\n" + outputMessage);
            throw new IOException("Could not create .ptx file: " + errorMessage);
        }
        System.out.println("Finished creating PTX file");
        return ptxFileName;
    }

    private static byte[] toByteArray(InputStream inputStream) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((read = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }
}

