/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.tool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fckeditor.tool.Utils;

public class XHtmlTagTool {
    private String name;
    private Map<String, String> attributes = new HashMap<String, String>();
    private String value;
    public static final String SPACE = " ";

    public XHtmlTagTool(String name) {
        if (Utils.isEmpty(name)) {
            throw new IllegalArgumentException("Parameter 'name' shouldn't be empty!");
        }
        this.name = name;
    }

    public XHtmlTagTool(String name, String value) {
        this(name);
        this.value = value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void addAttribute(String name, String value) {
        if (Utils.isEmpty(name)) {
            throw new IllegalArgumentException("Name is null or empty");
        }
        this.attributes.put(name, value);
    }

    public String toString() {
        StringBuffer tag = new StringBuffer();
        tag.append("<").append(this.name);
        Iterator<String> i$ = this.attributes.keySet().iterator();
        while (i$.hasNext()) {
            String key = i$.next();
            String val = this.attributes.get(key);
            tag.append(' ').append(key).append('=').append('\"').append(val).append('\"');
        }
        if (Utils.isNotEmpty(this.value)) {
            tag.append(">").append(this.value).append("</").append(this.name).append('>');
        } else {
            tag.append(" />");
        }
        return tag.toString();
    }
}

