/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.connector.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import net.fckeditor.connector.Connector;
import net.fckeditor.connector.exception.FolderAlreadyExistsException;
import net.fckeditor.connector.exception.InvalidCurrentFolderException;
import net.fckeditor.connector.exception.InvalidNewFolderNameException;
import net.fckeditor.connector.exception.WriteException;
import net.fckeditor.handlers.RequestCycleHandler;
import net.fckeditor.handlers.ResourceType;
import net.fckeditor.requestcycle.ThreadLocalData;
import net.fckeditor.tool.UtilsFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocalFileSystemConnector
implements Connector {
    protected ServletContext servletContext;

    @Override
    public String fileUpload(ResourceType type, String currentFolder, String fileName, InputStream inputStream) throws InvalidCurrentFolderException, WriteException {
        String absolutePath = this.getRealUserFilesAbsolutePath(RequestCycleHandler.getUserFilesAbsolutePath(ThreadLocalData.getRequest()));
        File typeDir = AbstractLocalFileSystemConnector.getOrCreateResourceTypeDir(absolutePath, type);
        File currentDir = new File(typeDir, currentFolder);
        if (!currentDir.exists() || !currentDir.isDirectory()) {
            throw new InvalidCurrentFolderException();
        }
        File newFile = new File(currentDir, fileName);
        File fileToSave = UtilsFile.getUniqueFile(newFile.getAbsoluteFile());
        try {
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)new FileOutputStream(fileToSave));
        }
        catch (IOException e) {
            throw new WriteException();
        }
        return fileToSave.getName();
    }

    @Override
    public void createFolder(ResourceType type, String currentFolder, String newFolder) throws InvalidCurrentFolderException, InvalidNewFolderNameException, FolderAlreadyExistsException {
        String absolutePath = this.getRealUserFilesAbsolutePath(RequestCycleHandler.getUserFilesAbsolutePath(ThreadLocalData.getRequest()));
        File typeDir = AbstractLocalFileSystemConnector.getOrCreateResourceTypeDir(absolutePath, type);
        File currentDir = new File(typeDir, currentFolder);
        if (!currentDir.exists() || !currentDir.isDirectory()) {
            throw new InvalidCurrentFolderException();
        }
        File newDir = new File(currentDir, newFolder);
        if (newDir.exists()) {
            throw new FolderAlreadyExistsException();
        }
        if (!newDir.mkdir()) {
            throw new InvalidNewFolderNameException();
        }
    }

    @Override
    public List<Map<String, Object>> getFiles(ResourceType type, String currentFolder) throws InvalidCurrentFolderException {
        String absolutePath = this.getRealUserFilesAbsolutePath(RequestCycleHandler.getUserFilesAbsolutePath(ThreadLocalData.getRequest()));
        File typeDir = AbstractLocalFileSystemConnector.getOrCreateResourceTypeDir(absolutePath, type);
        File currentDir = new File(typeDir, currentFolder);
        if (!currentDir.exists() || !currentDir.isDirectory()) {
            throw new InvalidCurrentFolderException();
        }
        File[] fileList = currentDir.listFiles((FileFilter)FileFileFilter.FILE);
        ArrayList<Map<String, Object>> files = new ArrayList<Map<String, Object>>(fileList.length);
        for (File file : fileList) {
            HashMap<String, Object> fileMap = new HashMap<String, Object>(2);
            fileMap.put("name", file.getName());
            fileMap.put("size", new Long(file.length()));
            files.add(fileMap);
        }
        return files;
    }

    @Override
    public List<String> getFolders(ResourceType type, String currentFolder) throws InvalidCurrentFolderException {
        String absolutePath = this.getRealUserFilesAbsolutePath(RequestCycleHandler.getUserFilesAbsolutePath(ThreadLocalData.getRequest()));
        File typeDir = AbstractLocalFileSystemConnector.getOrCreateResourceTypeDir(absolutePath, type);
        File currentDir = new File(typeDir, currentFolder);
        if (!currentDir.exists() || !currentDir.isDirectory()) {
            throw new InvalidCurrentFolderException();
        }
        String[] fileList = currentDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
        return Arrays.asList(fileList);
    }

    protected abstract String getRealUserFilesAbsolutePath(String var1);

    protected static File getOrCreateResourceTypeDir(String baseDir, ResourceType type) {
        File dir = new File(baseDir, type.getPath());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }
}

