/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.connector;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.fckeditor.connector.Connector;
import net.fckeditor.connector.exception.FolderAlreadyExistsException;
import net.fckeditor.connector.exception.InvalidCurrentFolderException;
import net.fckeditor.connector.exception.InvalidNewFolderNameException;
import net.fckeditor.connector.exception.ReadException;
import net.fckeditor.connector.exception.WriteException;
import net.fckeditor.handlers.Command;
import net.fckeditor.handlers.ConnectorHandler;
import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.handlers.RequestCycleHandler;
import net.fckeditor.handlers.ResourceType;
import net.fckeditor.requestcycle.Context;
import net.fckeditor.requestcycle.ThreadLocalData;
import net.fckeditor.response.GetResponse;
import net.fckeditor.response.UploadResponse;
import net.fckeditor.tool.Utils;
import net.fckeditor.tool.UtilsFile;
import net.fckeditor.tool.UtilsResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher {
    private final Logger logger = LoggerFactory.getLogger((Class)Dispatcher.class);
    private Connector connector = ConnectorHandler.getConnector();

    Dispatcher(ServletContext servletContext) throws Exception {
        this.connector.init(servletContext);
    }

    GetResponse doGet(HttpServletRequest request) {
        this.logger.debug("Entering Dispatcher#doGet");
        Context context = ThreadLocalData.getContext();
        context.logBaseParameters();
        GetResponse getResponse = null;
        if (!Command.isValidForGet(context.getCommandStr())) {
            getResponse = GetResponse.getInvalidCommandError();
        } else if (!ResourceType.isValidType(context.getTypeStr())) {
            getResponse = GetResponse.getInvalidResourceTypeError();
        } else if (!UtilsFile.isValidPath(context.getCurrentFolderStr())) {
            getResponse = GetResponse.getInvalidCurrentFolderError();
        } else {
            ResourceType type = context.getResourceType();
            Command command = context.getCommand();
            if ((command.equals(Command.GET_FOLDERS) || command.equals(Command.GET_FOLDERS_AND_FILES)) && !RequestCycleHandler.isEnabledForFileBrowsing(request)) {
                getResponse = GetResponse.getGetResourcesDisabledError();
            } else if (command.equals(Command.CREATE_FOLDER) && !RequestCycleHandler.isCreateFolderEnabled(request)) {
                getResponse = GetResponse.getCreateFolderDisabledError();
            } else {
                try {
                    if (command.equals(Command.CREATE_FOLDER)) {
                        String newFolderNameStr = request.getParameter("NewFolderName");
                        this.logger.debug("Parameter NewFolderName: {}", (Object)newFolderNameStr);
                        String sanitizedNewFolderNameStr = UtilsFile.sanitizeFolderName(newFolderNameStr);
                        if (Utils.isEmpty(sanitizedNewFolderNameStr)) {
                            getResponse = GetResponse.getInvalidNewFolderNameError();
                        } else {
                            this.logger.debug("Parameter NewFolderName (sanitized): {}", (Object)sanitizedNewFolderNameStr);
                            this.connector.createFolder(type, context.getCurrentFolderStr(), sanitizedNewFolderNameStr);
                            getResponse = GetResponse.getOK();
                        }
                    } else if (command.equals(Command.GET_FOLDERS) || command.equals(Command.GET_FOLDERS_AND_FILES)) {
                        String url = UtilsResponse.getUrl(RequestCycleHandler.getUserFilesPath(request), type, context.getCurrentFolderStr());
                        getResponse = this.getFoldersAndOrFiles(command, type, context.getCurrentFolderStr(), url);
                    }
                }
                catch (InvalidCurrentFolderException e) {
                    getResponse = GetResponse.getInvalidCurrentFolderError();
                }
                catch (InvalidNewFolderNameException e) {
                    getResponse = GetResponse.getInvalidNewFolderNameError();
                }
                catch (FolderAlreadyExistsException e) {
                    getResponse = GetResponse.getFolderAlreadyExistsError();
                }
                catch (WriteException e) {
                    getResponse = GetResponse.getCreateFolderWriteError();
                }
                catch (ReadException e) {
                    getResponse = GetResponse.getGetResourcesReadError();
                }
            }
        }
        this.logger.debug("Exiting Dispatcher#doGet");
        return getResponse;
    }

    private GetResponse getFoldersAndOrFiles(Command command, ResourceType type, String currentFolder, String constructedUrl) throws InvalidCurrentFolderException, ReadException {
        GetResponse getResponse = new GetResponse(command, type, currentFolder, constructedUrl);
        getResponse.setFolders(this.connector.getFolders(type, currentFolder));
        if (command.equals(Command.GET_FOLDERS_AND_FILES)) {
            getResponse.setFiles(this.connector.getFiles(type, currentFolder));
        }
        return getResponse;
    }

    UploadResponse doPost(HttpServletRequest request) {
        this.logger.debug("Entering Dispatcher#doPost");
        Context context = ThreadLocalData.getContext();
        context.logBaseParameters();
        UploadResponse uploadResponse = null;
        if (!RequestCycleHandler.isEnabledForFileUpload(request)) {
            uploadResponse = UploadResponse.getFileUploadDisabledError();
        } else if (!Command.isValidForPost(context.getCommandStr())) {
            uploadResponse = UploadResponse.getInvalidCommandError();
        } else if (!ResourceType.isValidType(context.getTypeStr())) {
            uploadResponse = UploadResponse.getInvalidResourceTypeError();
        } else if (!UtilsFile.isValidPath(context.getCurrentFolderStr())) {
            uploadResponse = UploadResponse.getInvalidCurrentFolderError();
        } else {
            ResourceType type = context.getDefaultResourceType();
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            try {
                List items = upload.parseRequest(request);
                FileItem uplFile = (FileItem)items.get(0);
                String fileName = FilenameUtils.getName((String)uplFile.getName());
                this.logger.debug("Parameter NewFile: {}", (Object)fileName);
                if (type.isNotAllowedExtension(FilenameUtils.getExtension((String)fileName))) {
                    uploadResponse = UploadResponse.getInvalidFileTypeError();
                } else if (type.equals(ResourceType.IMAGE) && PropertiesLoader.isSecureImageUploads() && !UtilsFile.isImage(uplFile.getInputStream())) {
                    uploadResponse = UploadResponse.getInvalidFileTypeError();
                } else {
                    String sanitizedFileName = UtilsFile.sanitizeFileName(fileName);
                    this.logger.debug("Parameter NewFile (sanitized): {}", (Object)sanitizedFileName);
                    String newFileName = this.connector.fileUpload(type, context.getCurrentFolderStr(), sanitizedFileName, uplFile.getInputStream());
                    String fileUrl = UtilsResponse.fileUrl(RequestCycleHandler.getUserFilesPath(request), type, context.getCurrentFolderStr(), newFileName);
                    if (sanitizedFileName.equals(newFileName)) {
                        uploadResponse = UploadResponse.getOK(fileUrl);
                    } else {
                        uploadResponse = UploadResponse.getFileRenamedWarning(fileUrl, newFileName);
                        this.logger.debug("Parameter NewFile (renamed): {}", (Object)newFileName);
                    }
                }
                uplFile.delete();
            }
            catch (InvalidCurrentFolderException e) {
                uploadResponse = UploadResponse.getInvalidCurrentFolderError();
            }
            catch (WriteException e) {
                uploadResponse = UploadResponse.getFileUploadWriteError();
            }
            catch (IOException e) {
                uploadResponse = UploadResponse.getFileUploadWriteError();
            }
            catch (FileUploadException e) {
                uploadResponse = UploadResponse.getFileUploadWriteError();
            }
        }
        this.logger.debug("Exiting Dispatcher#doPost");
        return uploadResponse;
    }
}

