/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.tags;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import net.fckeditor.handlers.RequestCycleHandler;
import net.fckeditor.localization.LocalizedMessages;
import net.fckeditor.tool.Compatibility;

public class CheckTag
extends TagSupport {
    private static final long serialVersionUID = -6834095891675681686L;
    private static final String FILE_UPLOAD = "FileUpload";
    @Deprecated
    private static final String FILE_BROWSING = "FileBrowsing";
    private static final String GET_RESOURCES = "GetResources";
    @Deprecated
    private static final String FOLDER_CREATION = "FolderCreation";
    private static final String CREATE_FOLDER = "CreateFolder";
    private static final String COMPATIBLE_BROWSER = "CompatibleBrowser";
    private static final Set<String> commands = new HashSet<String>(6);
    private String command;

    public void setCommand(String command) throws JspTagException {
        if (!commands.contains(command)) {
            throw new JspTagException("You have to provide one of the following commands: " + commands);
        }
        this.command = command;
    }

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        LocalizedMessages lm = LocalizedMessages.getInstance(request);
        String response = null;
        if (this.command.equals(FILE_UPLOAD)) {
            response = RequestCycleHandler.isEnabledForFileUpload(request) ? lm.getFileUploadEnabled() : lm.getFileUploadDisabled();
        }
        if (this.command.equals(FILE_BROWSING) || this.command.equals(GET_RESOURCES)) {
            response = RequestCycleHandler.isEnabledForFileBrowsing(request) ? lm.getGetResourcesEnabled() : lm.getGetResourcesDisabled();
        }
        if (this.command.equals(FOLDER_CREATION) || this.command.equals(CREATE_FOLDER)) {
            response = RequestCycleHandler.isCreateFolderEnabled(request) ? lm.getCreateFolderEnabled() : lm.getCreateFolderDisabled();
        }
        if (this.command.equals(COMPATIBLE_BROWSER)) {
            response = Compatibility.isCompatibleBrowser(request) ? lm.getCompatibleBrowserYes() : lm.getCompatibleBrowserNo();
        }
        try {
            out.print(response);
        }
        catch (IOException e) {
            throw new JspException("Tag response could not be written to the user!", (Throwable)e);
        }
        return 0;
    }

    static {
        commands.add(FILE_UPLOAD);
        commands.add(FILE_BROWSING);
        commands.add(FOLDER_CREATION);
        commands.add(COMPATIBLE_BROWSER);
        commands.add(GET_RESOURCES);
        commands.add(CREATE_FOLDER);
    }
}

