/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.requestcycle;

import javax.servlet.http.HttpServletRequest;
import net.fckeditor.connector.Dispatcher;
import net.fckeditor.handlers.Command;
import net.fckeditor.handlers.ResourceType;
import net.fckeditor.tool.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static final Logger logger = LoggerFactory.getLogger((Class)Dispatcher.class);
    private String typeStr;
    private String commandStr;
    private String currentFolderStr;

    protected Context(HttpServletRequest request) {
        this.commandStr = request.getParameter("Command");
        this.typeStr = request.getParameter("Type");
        this.currentFolderStr = request.getParameter("CurrentFolder");
        if (Utils.isEmpty(this.commandStr) && Utils.isEmpty(this.currentFolderStr)) {
            this.commandStr = "QuickUpload";
            this.currentFolderStr = "/";
            if (Utils.isEmpty(this.typeStr)) {
                this.typeStr = "File";
            }
        }
        if (this.currentFolderStr != null && !this.currentFolderStr.startsWith("/")) {
            this.currentFolderStr = "/".concat(this.currentFolderStr);
        }
    }

    public String getTypeStr() {
        return this.typeStr;
    }

    public ResourceType getDefaultResourceType() {
        return ResourceType.getDefaultResourceType(this.typeStr);
    }

    public ResourceType getResourceType() {
        return ResourceType.getResourceType(this.typeStr);
    }

    public String getCommandStr() {
        return this.commandStr;
    }

    public Command getCommand() {
        return Command.getCommand(this.commandStr);
    }

    public String getCurrentFolderStr() {
        return this.currentFolderStr;
    }

    public void logBaseParameters() {
        logger.debug("Parameter Command: {}", (Object)this.commandStr);
        logger.debug("Parameter Type: {}", (Object)this.typeStr);
        logger.debug("Parameter CurrentFolder: {}", (Object)this.currentFolderStr);
    }
}

