/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.localization;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.localization.LocaleResolver;
import net.fckeditor.tool.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizedMessages {
    private static final Map<Locale, LocalizedMessages> prototypes = Collections.synchronizedMap(new HashMap());
    private static final String DEFAULT_FILENAME = "default_messages.properties";
    private static final String LOCAL_PROPERTIES = "fckeditor_messages";
    private static final Properties defaultProperties = new Properties();
    private Properties properties = new Properties(defaultProperties);
    private static LocaleResolver localeResolver;
    private static final Locale NEUTRAL;
    private static final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalizedMessages getInstance(HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("the request cannot be null");
        }
        Locale locale = LocalizedMessages.getLocaleResolverInstance().resolveLocale(request);
        if (locale == null) {
            locale = NEUTRAL;
        }
        Class clazz = LocalizedMessages.class;
        synchronized (clazz) {
            if (!prototypes.containsKey(locale)) {
                prototypes.put(locale, new LocalizedMessages(locale));
            }
        }
        return prototypes.get(locale);
    }

    private static synchronized LocaleResolver getLocaleResolverInstance() {
        if (localeResolver == null) {
            String className = PropertiesLoader.getLocaleResolverImpl();
            if (Utils.isEmpty(className)) {
                logger.error("Empty LocaleResolver implementation class name provided");
            } else {
                try {
                    Class<?> clazz = Class.forName(className);
                    localeResolver = (LocaleResolver)clazz.newInstance();
                    logger.info("LocaleResolver initialized to {}", (Object)className);
                }
                catch (Throwable e) {
                    logger.error("LocaleResolver implementation {} could not be instantiated", (Object)className);
                    throw new RuntimeException("LocaleResolver implementation " + className + " could not be instantiated", e);
                }
            }
        }
        return localeResolver;
    }

    private LocalizedMessages(Locale locale) {
        ResourceBundle localized = null;
        try {
            localized = ResourceBundle.getBundle(LOCAL_PROPERTIES, locale, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (localized != null && localized.getLocale().getLanguage().equals(locale.getLanguage())) {
            Enumeration<String> keys = localized.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                this.properties.setProperty(key, localized.getString(key));
            }
            logger.debug("Resource bundle for locale '{}' loaded", (Object)locale);
        } else {
            logger.debug("No resource bundle for locale '{}' found, loading default bundle", (Object)locale);
            ResourceBundle base = null;
            try {
                base = ResourceBundle.getBundle(LOCAL_PROPERTIES, NEUTRAL, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (base != null && base.getLocale().equals(NEUTRAL)) {
                Enumeration<String> keys = base.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    this.properties.setProperty(key, base.getString(key));
                }
            }
        }
    }

    private String getMessage(String key) {
        return this.properties.getProperty(key);
    }

    public String getCompatibleBrowserYes() {
        return this.getMessage("editor.compatibleBrowser.yes");
    }

    public String getCompatibleBrowserNo() {
        return this.getMessage("editor.compatibleBrowser.no");
    }

    public String getFileUploadEnabled() {
        return this.getMessage("connector.fileUpload.enabled");
    }

    public String getFileUploadDisabled() {
        return this.getMessage("connector.fileUpload.disabled");
    }

    public String getFileRenamedWarning(String newFileName) {
        return MessageFormat.format(this.getMessage("connector.fileUpload.file_renamed_warning"), newFileName);
    }

    public String getInvalidFileTypeSpecified() {
        return this.getMessage("connector.fileUpload.invalid_file_type_specified");
    }

    public String getFileUploadWriteError() {
        return this.getMessage("connector.fileUpload.write_error");
    }

    public String getGetResourcesEnabled() {
        return this.getMessage("connector.getResources.enabled");
    }

    public String getGetResourcesDisabled() {
        return this.getMessage("connector.getResources.disabled");
    }

    public String getGetResourcesReadError() {
        return this.getMessage("connector.getResources.read_error");
    }

    public String getCreateFolderEnabled() {
        return this.getMessage("connector.createFolder.enabled");
    }

    public String getCreateFolderDisabled() {
        return this.getMessage("connector.createFolder.disabled");
    }

    public String getInvalidCommandSpecified() {
        return this.getMessage("connector.invalid_command_specified");
    }

    public String getFolderAlreadyExistsError() {
        return this.getMessage("connector.createFolder.folder_already_exists_error");
    }

    public String getInvalidNewFolderNameSpecified() {
        return this.getMessage("connector.createFolder.invalid_new_folder_name_specified");
    }

    public String getCreateFolderWriteError() {
        return this.getMessage("connector.createFolder.write_error");
    }

    public String getInvalidResouceTypeSpecified() {
        return this.getMessage("connector.invalid_resource_type_specified");
    }

    public String getInvalidCurrentFolderSpecified() {
        return this.getMessage("connector.invalid_current_folder_specified");
    }

    static {
        NEUTRAL = new Locale("");
        logger = LoggerFactory.getLogger((Class)LocalizedMessages.class);
        InputStream in = LocalizedMessages.class.getResourceAsStream(DEFAULT_FILENAME);
        if (in == null) {
            logger.error("{} not found", (Object)DEFAULT_FILENAME);
            throw new RuntimeException("default_messages.properties not found");
        }
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        try {
            defaultProperties.load(in);
            in.close();
            logger.debug("{} loaded", (Object)DEFAULT_FILENAME);
        }
        catch (Exception e) {
            logger.error("Error while loading {}", (Object)DEFAULT_FILENAME);
            throw new RuntimeException("Error while loading default_messages.properties", e);
        }
    }
}

