/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.tool;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.fckeditor.tool.Utils;

public class Compatibility {
    public static boolean check(String userAgentString) {
        float version;
        if (Utils.isEmpty(userAgentString)) {
            return false;
        }
        if (userAgentString.indexOf("Opera") < 0 && userAgentString.indexOf("mac") < 0 && (version = Compatibility.getBrowserVersion(userAgentString, ".*MSIE ([\\d]+.[\\d]+).*")) != -1.0f && version >= 5.5f) {
            return true;
        }
        version = Compatibility.getBrowserVersion(userAgentString, ".*Gecko/([\\d]+).*");
        if (version != -1.0f && version >= 2.003021E7f) {
            return true;
        }
        version = Compatibility.getBrowserVersion(userAgentString, "Opera/([\\d]+.[\\d]+).*");
        if (version != -1.0f && version >= 9.5f) {
            return true;
        }
        version = Compatibility.getBrowserVersion(userAgentString, ".*Opera ([\\d]+.[\\d]+)");
        if (version != -1.0f && version >= 9.5f) {
            return true;
        }
        version = Compatibility.getBrowserVersion(userAgentString, ".*AppleWebKit/([\\d]+).*");
        return version != -1.0f && version >= 522.0f;
    }

    public static boolean isCompatibleBrowser(HttpServletRequest request) {
        return request == null ? false : Compatibility.check(request.getHeader("user-agent"));
    }

    private static float getBrowserVersion(String userAgent, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(userAgent);
        if (matcher.matches()) {
            try {
                return Float.parseFloat(matcher.group(1));
            }
            catch (NumberFormatException e) {
                return -1.0f;
            }
        }
        return -1.0f;
    }
}

