/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.tags;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.handlers.RequestCycleHandler;
import net.fckeditor.tool.Compatibility;

public class CheckTag
extends TagSupport {
    private static final long serialVersionUID = -6834095891675681686L;
    private static final String FILE_UPLOAD = "FileUpload";
    private static final String FILE_BROWSING = "FileBrowsing";
    private static final String COMPATIBLE_BROWSER = "CompatibleBrowser";
    private static final String PROPERTY_MESSAGE_FILE_BROWSING_DISABLED = "message.enabled_tag.connector.file_browsing.disabled";
    private static final String PROPERTY_MESSAGE_FILE_BROWSING_ENABLED = "message.enabled_tag.connector.file_browsing.enabled";
    private static final String PROPERTY_MESSAGE_FILE_UPLOAD_DISABLED = "message.enabled_tag.connector.file_upload.disalbed";
    private static final String PROPERTY_MESSAGE_FILE_UPLOAD_ENABLED = "message.enabled_tag.connector.file_upload.enabled";
    private static final String PROPERTY_MESSAGE_NOT_COMPATIBLE_BROWSER = "message.enabled_tag.compatible_browser.no";
    private static final String PROPERTY_MESSAGE_COMPATIBLE_BROWSER = "message.enabled_tag.compatible_browser.yes";
    private static Set<String> commands = new HashSet<String>(3);
    private String command;

    public void setCommand(String command) throws JspTagException {
        if (!commands.contains(command)) {
            throw new JspTagException("You have to provide one of the following commands: " + commands);
        }
        this.command = command;
    }

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String response = new String();
        if (this.command.equals(FILE_UPLOAD)) {
            response = RequestCycleHandler.isEnabledForFileUpload(request) ? PropertiesLoader.getProperty(PROPERTY_MESSAGE_FILE_UPLOAD_ENABLED) : PropertiesLoader.getProperty(PROPERTY_MESSAGE_FILE_UPLOAD_DISABLED);
        }
        if (this.command.equals(FILE_BROWSING)) {
            response = RequestCycleHandler.isEnabledForFileBrowsing(request) ? PropertiesLoader.getProperty(PROPERTY_MESSAGE_FILE_BROWSING_ENABLED) : PropertiesLoader.getProperty(PROPERTY_MESSAGE_FILE_BROWSING_DISABLED);
        }
        if (this.command.equals(COMPATIBLE_BROWSER)) {
            response = Compatibility.isCompatibleBrowser(request) ? PropertiesLoader.getProperty(PROPERTY_MESSAGE_COMPATIBLE_BROWSER) : PropertiesLoader.getProperty(PROPERTY_MESSAGE_NOT_COMPATIBLE_BROWSER);
        }
        try {
            out.print(response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    static {
        commands.add(FILE_UPLOAD);
        commands.add(FILE_BROWSING);
        commands.add(COMPATIBLE_BROWSER);
    }
}

