/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor.handlers;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.fckeditor.tool.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    private static final Logger logger;
    private static Properties properties;

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static void setProperty(String key, String value) {
        if (Utils.isEmpty(key)) {
            new IllegalArgumentException("The 'key' of a property schouldn't be null!");
        }
        properties.setProperty(key, value);
    }

    static {
        block5: {
            logger = LoggerFactory.getLogger((Class)PropertiesLoader.class);
            properties = new Properties();
            try {
                properties.load(new BufferedInputStream(PropertiesLoader.class.getResourceAsStream("default.properties")));
                InputStream in = PropertiesLoader.class.getResourceAsStream("/fckeditor.properties");
                if (in == null) {
                    logger.warn("Can't find user properties!");
                    break block5;
                }
                try {
                    properties.load(new BufferedInputStream(in));
                    logger.info("User's properties loaded successfully!");
                }
                catch (IOException e) {
                    logger.error("Error while loading user properties!", (Throwable)e);
                    throw new RuntimeException("Can't load user properties!", e);
                }
            }
            catch (IOException e) {
                logger.error("Error while loading default properties!", (Throwable)e);
                throw new RuntimeException("Can't load default properties!", e);
            }
        }
    }
}

