package facade.amazonaws.services

import scalajs._
import scalajs.js.annotation.JSImport
import scala.scalajs.js.|
import scala.concurrent.Future
import io.scalajs.nodejs
import facade.amazonaws._

package object ec2 {
  type AccountAttributeList                           = js.Array[AccountAttribute]
  type AccountAttributeName                           = String
  type AccountAttributeNameStringList                 = js.Array[AccountAttributeName]
  type AccountAttributeValueList                      = js.Array[AccountAttributeValue]
  type ActiveInstanceSet                              = js.Array[ActiveInstance]
  type ActivityStatus                                 = String
  type AddressList                                    = js.Array[Address]
  type Affinity                                       = String
  type AllocationIdList                               = js.Array[String]
  type AllocationState                                = String
  type AllocationStrategy                             = String
  type AllowedPrincipalSet                            = js.Array[AllowedPrincipal]
  type ArchitectureValues                             = String
  type AssociatedNetworkType                          = String
  type AssociatedTargetNetworkSet                     = js.Array[AssociatedTargetNetwork]
  type AssociationIdList                              = js.Array[String]
  type AssociationStatusCode                          = String
  type AttachmentStatus                               = String
  type AuthorizationRuleSet                           = js.Array[AuthorizationRule]
  type AutoAcceptSharedAttachmentsValue               = String
  type AutoPlacement                                  = String
  type AvailabilityZoneList                           = js.Array[AvailabilityZone]
  type AvailabilityZoneMessageList                    = js.Array[AvailabilityZoneMessage]
  type AvailabilityZoneState                          = String
  type AvailableInstanceCapacityList                  = js.Array[InstanceCapacity]
  type BatchState                                     = String
  type BillingProductList                             = js.Array[String]
  type Blob                                           = nodejs.buffer.Buffer | nodejs.stream.Readable | js.typedarray.TypedArray[_, _] | js.Array[Byte] | String
  type BlockDeviceMappingList                         = js.Array[BlockDeviceMapping]
  type BlockDeviceMappingRequestList                  = js.Array[BlockDeviceMapping]
  type BundleIdStringList                             = js.Array[String]
  type BundleTaskList                                 = js.Array[BundleTask]
  type BundleTaskState                                = String
  type ByoipCidrSet                                   = js.Array[ByoipCidr]
  type ByoipCidrState                                 = String
  type CancelBatchErrorCode                           = String
  type CancelSpotFleetRequestsErrorSet                = js.Array[CancelSpotFleetRequestsErrorItem]
  type CancelSpotFleetRequestsSuccessSet              = js.Array[CancelSpotFleetRequestsSuccessItem]
  type CancelSpotInstanceRequestState                 = String
  type CancelledSpotInstanceRequestList               = js.Array[CancelledSpotInstanceRequest]
  type CapacityReservationIdSet                       = js.Array[String]
  type CapacityReservationInstancePlatform            = String
  type CapacityReservationPreference                  = String
  type CapacityReservationSet                         = js.Array[CapacityReservation]
  type CapacityReservationState                       = String
  type CapacityReservationTenancy                     = String
  type CidrBlockSet                                   = js.Array[CidrBlock]
  type ClassicLinkDnsSupportList                      = js.Array[ClassicLinkDnsSupport]
  type ClassicLinkInstanceList                        = js.Array[ClassicLinkInstance]
  type ClassicLoadBalancers                           = js.Array[ClassicLoadBalancer]
  type ClientCertificateRevocationListStatusCode      = String
  type ClientVpnAuthenticationList                    = js.Array[ClientVpnAuthentication]
  type ClientVpnAuthenticationRequestList             = js.Array[ClientVpnAuthenticationRequest]
  type ClientVpnAuthenticationType                    = String
  type ClientVpnAuthorizationRuleStatusCode           = String
  type ClientVpnConnectionSet                         = js.Array[ClientVpnConnection]
  type ClientVpnConnectionStatusCode                  = String
  type ClientVpnEndpointStatusCode                    = String
  type ClientVpnRouteSet                              = js.Array[ClientVpnRoute]
  type ClientVpnRouteStatusCode                       = String
  type ClientVpnSecurityGroupIdSet                    = js.Array[String]
  type ConnectionNotificationSet                      = js.Array[ConnectionNotification]
  type ConnectionNotificationState                    = String
  type ConnectionNotificationType                     = String
  type ContainerFormat                                = String
  type ConversionIdStringList                         = js.Array[String]
  type ConversionTaskState                            = String
  type CreateFleetErrorsSet                           = js.Array[CreateFleetError]
  type CreateFleetInstancesSet                        = js.Array[CreateFleetInstance]
  type CreateVolumePermissionList                     = js.Array[CreateVolumePermission]
  type CurrencyCodeValues                             = String
  type CustomerGatewayIdStringList                    = js.Array[String]
  type CustomerGatewayList                            = js.Array[CustomerGateway]
  type DatafeedSubscriptionState                      = String
  type DateTime                                       = js.Date
  type DefaultRouteTableAssociationValue              = String
  type DefaultRouteTablePropagationValue              = String
  type DefaultTargetCapacityType                      = String
  type DeleteFleetErrorCode                           = String
  type DeleteFleetErrorSet                            = js.Array[DeleteFleetErrorItem]
  type DeleteFleetSuccessSet                          = js.Array[DeleteFleetSuccessItem]
  type DeleteLaunchTemplateVersionsResponseErrorSet   = js.Array[DeleteLaunchTemplateVersionsResponseErrorItem]
  type DeleteLaunchTemplateVersionsResponseSuccessSet = js.Array[DeleteLaunchTemplateVersionsResponseSuccessItem]
  type DescribeConversionTaskList                     = js.Array[ConversionTask]
  type DescribeFleetsErrorSet                         = js.Array[DescribeFleetError]
  type DescribeFleetsInstancesSet                     = js.Array[DescribeFleetsInstances]
  type DescribeHostReservationsMaxResults             = Int
  type DescribeInstanceCreditSpecificationsMaxResults = Int
  type DescribeInternetGatewaysMaxResults             = Int
  type DescribeNetworkAclsMaxResults                  = Int
  type DescribeVpcPeeringConnectionsMaxResults        = Int
  type DescribeVpcsMaxResults                         = Int
  type DeviceType                                     = String
  type DhcpConfigurationList                          = js.Array[DhcpConfiguration]
  type DhcpConfigurationValueList                     = js.Array[AttributeValue]
  type DhcpOptionsIdStringList                        = js.Array[String]
  type DhcpOptionsList                                = js.Array[DhcpOptions]
  type DiskImageFormat                                = String
  type DiskImageList                                  = js.Array[DiskImage]
  type DnsEntrySet                                    = js.Array[DnsEntry]
  type DnsSupportValue                                = String
  type DomainType                                     = String
  type EgressOnlyInternetGatewayId                    = String
  type EgressOnlyInternetGatewayIdList                = js.Array[EgressOnlyInternetGatewayId]
  type EgressOnlyInternetGatewayList                  = js.Array[EgressOnlyInternetGateway]
  type ElasticGpuAssociationList                      = js.Array[ElasticGpuAssociation]
  type ElasticGpuIdSet                                = js.Array[String]
  type ElasticGpuSet                                  = js.Array[ElasticGpus]
  type ElasticGpuSpecificationList                    = js.Array[ElasticGpuSpecification]
  type ElasticGpuSpecificationResponseList            = js.Array[ElasticGpuSpecificationResponse]
  type ElasticGpuSpecifications                       = js.Array[ElasticGpuSpecification]
  type ElasticGpuState                                = String
  type ElasticGpuStatus                               = String
  type ElasticInferenceAcceleratorAssociationList     = js.Array[ElasticInferenceAcceleratorAssociation]
  type ElasticInferenceAccelerators                   = js.Array[ElasticInferenceAccelerator]
  type EndDateType                                    = String
  type EndpointSet                                    = js.Array[ClientVpnEndpoint]
  type EventCode                                      = String
  type EventType                                      = String
  type ExcessCapacityTerminationPolicy                = String
  type ExecutableByStringList                         = js.Array[String]
  type ExportEnvironment                              = String
  type ExportTaskIdStringList                         = js.Array[String]
  type ExportTaskList                                 = js.Array[ExportTask]
  type ExportTaskState                                = String
  type FilterList                                     = js.Array[Filter]
  type FleetActivityStatus                            = String
  type FleetEventType                                 = String
  type FleetExcessCapacityTerminationPolicy           = String
  type FleetIdSet                                     = js.Array[FleetIdentifier]
  type FleetIdentifier                                = String
  type FleetLaunchTemplateConfigList                  = js.Array[FleetLaunchTemplateConfig]
  type FleetLaunchTemplateConfigListRequest           = js.Array[FleetLaunchTemplateConfigRequest]
  type FleetLaunchTemplateOverridesList               = js.Array[FleetLaunchTemplateOverrides]
  type FleetLaunchTemplateOverridesListRequest        = js.Array[FleetLaunchTemplateOverridesRequest]
  type FleetOnDemandAllocationStrategy                = String
  type FleetSet                                       = js.Array[FleetData]
  type FleetStateCode                                 = String
  type FleetType                                      = String
  type FlowLogSet                                     = js.Array[FlowLog]
  type FlowLogsResourceType                           = String
  type FpgaImageAttributeName                         = String
  type FpgaImageIdList                                = js.Array[String]
  type FpgaImageList                                  = js.Array[FpgaImage]
  type FpgaImageStateCode                             = String
  type GatewayType                                    = String
  type GroupIdStringList                              = js.Array[String]
  type GroupIdentifierList                            = js.Array[GroupIdentifier]
  type GroupIdentifierSet                             = js.Array[SecurityGroupIdentifier]
  type GroupIds                                       = js.Array[String]
  type GroupNameStringList                            = js.Array[String]
  type HistoryRecordSet                               = js.Array[HistoryRecordEntry]
  type HistoryRecords                                 = js.Array[HistoryRecord]
  type HostInstanceList                               = js.Array[HostInstance]
  type HostList                                       = js.Array[Host]
  type HostOfferingSet                                = js.Array[HostOffering]
  type HostReservationIdSet                           = js.Array[String]
  type HostReservationSet                             = js.Array[HostReservation]
  type HostTenancy                                    = String
  type HypervisorType                                 = String
  type IamInstanceProfileAssociationSet               = js.Array[IamInstanceProfileAssociation]
  type IamInstanceProfileAssociationState             = String
  type IdFormatList                                   = js.Array[IdFormat]
  type ImageAttributeName                             = String
  type ImageDiskContainerList                         = js.Array[ImageDiskContainer]
  type ImageIdStringList                              = js.Array[String]
  type ImageList                                      = js.Array[Image]
  type ImageState                                     = String
  type ImageTypeValues                                = String
  type ImportImageTaskList                            = js.Array[ImportImageTask]
  type ImportInstanceVolumeDetailSet                  = js.Array[ImportInstanceVolumeDetailItem]
  type ImportSnapshotTaskList                         = js.Array[ImportSnapshotTask]
  type ImportTaskIdList                               = js.Array[String]
  type InstanceAttributeName                          = String
  type InstanceBlockDeviceMappingList                 = js.Array[InstanceBlockDeviceMapping]
  type InstanceBlockDeviceMappingSpecificationList    = js.Array[InstanceBlockDeviceMappingSpecification]
  type InstanceCountList                              = js.Array[InstanceCount]
  type InstanceCreditSpecificationList                = js.Array[InstanceCreditSpecification]
  type InstanceCreditSpecificationListRequest         = js.Array[InstanceCreditSpecificationRequest]
  type InstanceEventId                                = String
  type InstanceHealthStatus                           = String
  type InstanceId                                     = String
  type InstanceIdSet                                  = js.Array[String]
  type InstanceIdStringList                           = js.Array[String]
  type InstanceIdsSet                                 = js.Array[InstanceId]
  type InstanceInterruptionBehavior                   = String
  type InstanceIpv6AddressList                        = js.Array[InstanceIpv6Address]
  type InstanceIpv6AddressListRequest                 = js.Array[InstanceIpv6AddressRequest]
  type InstanceLifecycle                              = String
  type InstanceLifecycleType                          = String
  type InstanceList                                   = js.Array[Instance]
  type InstanceMatchCriteria                          = String
  type InstanceMonitoringList                         = js.Array[InstanceMonitoring]
  type InstanceNetworkInterfaceList                   = js.Array[InstanceNetworkInterface]
  type InstanceNetworkInterfaceSpecificationList      = js.Array[InstanceNetworkInterfaceSpecification]
  type InstancePrivateIpAddressList                   = js.Array[InstancePrivateIpAddress]
  type InstanceStateChangeList                        = js.Array[InstanceStateChange]
  type InstanceStateName                              = String
  type InstanceStatusDetailsList                      = js.Array[InstanceStatusDetails]
  type InstanceStatusEventList                        = js.Array[InstanceStatusEvent]
  type InstanceStatusList                             = js.Array[InstanceStatus]
  type InstanceType                                   = String
  type InstanceTypeList                               = js.Array[InstanceType]
  type InterfacePermissionType                        = String
  type InternetGatewayAttachmentList                  = js.Array[InternetGatewayAttachment]
  type InternetGatewayList                            = js.Array[InternetGateway]
  type IpPermissionList                               = js.Array[IpPermission]
  type IpRangeList                                    = js.Array[IpRange]
  type IpRanges                                       = js.Array[String]
  type Ipv6Address                                    = String
  type Ipv6AddressList                                = js.Array[String]
  type Ipv6CidrBlockSet                               = js.Array[Ipv6CidrBlock]
  type Ipv6RangeList                                  = js.Array[Ipv6Range]
  type Ipv6SupportValue                               = String
  type KeyNameStringList                              = js.Array[String]
  type KeyPairList                                    = js.Array[KeyPairInfo]
  type LaunchPermissionList                           = js.Array[LaunchPermission]
  type LaunchSpecsList                                = js.Array[SpotFleetLaunchSpecification]
  type LaunchTemplateBlockDeviceMappingList           = js.Array[LaunchTemplateBlockDeviceMapping]
  type LaunchTemplateBlockDeviceMappingRequestList    = js.Array[LaunchTemplateBlockDeviceMappingRequest]
  type LaunchTemplateConfigList                       = js.Array[LaunchTemplateConfig]
  type LaunchTemplateElasticInferenceAcceleratorList  = js.Array[LaunchTemplateElasticInferenceAccelerator]
  type LaunchTemplateElasticInferenceAcceleratorResponseList =
    js.Array[LaunchTemplateElasticInferenceAcceleratorResponse]
  type LaunchTemplateErrorCode = String
  type LaunchTemplateInstanceNetworkInterfaceSpecificationList =
    js.Array[LaunchTemplateInstanceNetworkInterfaceSpecification]
  type LaunchTemplateInstanceNetworkInterfaceSpecificationRequestList =
    js.Array[LaunchTemplateInstanceNetworkInterfaceSpecificationRequest]
  type LaunchTemplateLicenseList                        = js.Array[LaunchTemplateLicenseConfiguration]
  type LaunchTemplateLicenseSpecificationListRequest    = js.Array[LaunchTemplateLicenseConfigurationRequest]
  type LaunchTemplateName                               = String
  type LaunchTemplateNameStringList                     = js.Array[LaunchTemplateName]
  type LaunchTemplateOverridesList                      = js.Array[LaunchTemplateOverrides]
  type LaunchTemplateSet                                = js.Array[LaunchTemplate]
  type LaunchTemplateTagSpecificationList               = js.Array[LaunchTemplateTagSpecification]
  type LaunchTemplateTagSpecificationRequestList        = js.Array[LaunchTemplateTagSpecificationRequest]
  type LaunchTemplateVersionSet                         = js.Array[LaunchTemplateVersion]
  type LicenseList                                      = js.Array[LicenseConfiguration]
  type LicenseSpecificationListRequest                  = js.Array[LicenseConfigurationRequest]
  type ListingState                                     = String
  type ListingStatus                                    = String
  type LoadPermissionList                               = js.Array[LoadPermission]
  type LoadPermissionListRequest                        = js.Array[LoadPermissionRequest]
  type LogDestinationType                               = String
  type MarketType                                       = String
  type MaxResults                                       = Int
  type MonitoringState                                  = String
  type MoveStatus                                       = String
  type MovingAddressStatusSet                           = js.Array[MovingAddressStatus]
  type NatGatewayAddressList                            = js.Array[NatGatewayAddress]
  type NatGatewayList                                   = js.Array[NatGateway]
  type NatGatewayState                                  = String
  type NetworkAclAssociationList                        = js.Array[NetworkAclAssociation]
  type NetworkAclEntryList                              = js.Array[NetworkAclEntry]
  type NetworkAclList                                   = js.Array[NetworkAcl]
  type NetworkInterfaceAttribute                        = String
  type NetworkInterfaceIdList                           = js.Array[String]
  type NetworkInterfaceIpv6AddressesList                = js.Array[NetworkInterfaceIpv6Address]
  type NetworkInterfaceList                             = js.Array[NetworkInterface]
  type NetworkInterfacePermissionIdList                 = js.Array[String]
  type NetworkInterfacePermissionList                   = js.Array[NetworkInterfacePermission]
  type NetworkInterfacePermissionStateCode              = String
  type NetworkInterfacePrivateIpAddressList             = js.Array[NetworkInterfacePrivateIpAddress]
  type NetworkInterfaceStatus                           = String
  type NetworkInterfaceType                             = String
  type NewDhcpConfigurationList                         = js.Array[NewDhcpConfiguration]
  type NextToken                                        = String
  type OccurrenceDayRequestSet                          = js.Array[Int]
  type OccurrenceDaySet                                 = js.Array[Int]
  type OfferingClassType                                = String
  type OfferingTypeValues                               = String
  type OnDemandAllocationStrategy                       = String
  type OperationType                                    = String
  type OwnerStringList                                  = js.Array[String]
  type PaymentOption                                    = String
  type PermissionGroup                                  = String
  type PlacementGroupList                               = js.Array[PlacementGroup]
  type PlacementGroupState                              = String
  type PlacementGroupStringList                         = js.Array[String]
  type PlacementStrategy                                = String
  type PlatformValues                                   = String
  type PoolMaxResults                                   = Int
  type PrefixListIdList                                 = js.Array[PrefixListId]
  type PrefixListIdSet                                  = js.Array[String]
  type PrefixListSet                                    = js.Array[PrefixList]
  type PriceScheduleList                                = js.Array[PriceSchedule]
  type PriceScheduleSpecificationList                   = js.Array[PriceScheduleSpecification]
  type PricingDetailsList                               = js.Array[PricingDetail]
  type PrincipalIdFormatList                            = js.Array[PrincipalIdFormat]
  type PrincipalType                                    = String
  type PrivateIpAddressConfigSet                        = js.Array[ScheduledInstancesPrivateIpAddressConfig]
  type PrivateIpAddressSpecificationList                = js.Array[PrivateIpAddressSpecification]
  type PrivateIpAddressStringList                       = js.Array[String]
  type ProductCodeList                                  = js.Array[ProductCode]
  type ProductCodeStringList                            = js.Array[String]
  type ProductCodeValues                                = String
  type ProductDescriptionList                           = js.Array[String]
  type PropagatingVgwList                               = js.Array[PropagatingVgw]
  type PublicIpStringList                               = js.Array[String]
  type PublicIpv4PoolRangeSet                           = js.Array[PublicIpv4PoolRange]
  type PublicIpv4PoolSet                                = js.Array[PublicIpv4Pool]
  type PurchaseRequestSet                               = js.Array[PurchaseRequest]
  type PurchaseSet                                      = js.Array[Purchase]
  type PurchasedScheduledInstanceSet                    = js.Array[ScheduledInstance]
  type RIProductDescription                             = String
  type ReasonCodesList                                  = js.Array[ReportInstanceReasonCodes]
  type RecurringChargeFrequency                         = String
  type RecurringChargesList                             = js.Array[RecurringCharge]
  type RegionList                                       = js.Array[Region]
  type RegionNameStringList                             = js.Array[String]
  type ReportInstanceReasonCodes                        = String
  type ReportStatusType                                 = String
  type RequestHostIdList                                = js.Array[String]
  type RequestHostIdSet                                 = js.Array[String]
  type ReservationList                                  = js.Array[Reservation]
  type ReservationState                                 = String
  type ReservedInstanceIdSet                            = js.Array[String]
  type ReservedInstanceReservationValueSet              = js.Array[ReservedInstanceReservationValue]
  type ReservedInstanceState                            = String
  type ReservedInstancesConfigurationList               = js.Array[ReservedInstancesConfiguration]
  type ReservedInstancesIdStringList                    = js.Array[String]
  type ReservedInstancesList                            = js.Array[ReservedInstances]
  type ReservedInstancesListingList                     = js.Array[ReservedInstancesListing]
  type ReservedInstancesModificationIdStringList        = js.Array[String]
  type ReservedInstancesModificationList                = js.Array[ReservedInstancesModification]
  type ReservedInstancesModificationResultList          = js.Array[ReservedInstancesModificationResult]
  type ReservedInstancesOfferingIdStringList            = js.Array[String]
  type ReservedInstancesOfferingList                    = js.Array[ReservedInstancesOffering]
  type ReservedIntancesIds                              = js.Array[ReservedInstancesId]
  type ResetFpgaImageAttributeName                      = String
  type ResetImageAttributeName                          = String
  type ResourceIdList                                   = js.Array[String]
  type ResourceList                                     = js.Array[String]
  type ResourceType                                     = String
  type ResponseHostIdList                               = js.Array[String]
  type ResponseHostIdSet                                = js.Array[String]
  type RestorableByStringList                           = js.Array[String]
  type RouteList                                        = js.Array[Route]
  type RouteOrigin                                      = String
  type RouteState                                       = String
  type RouteTableAssociationList                        = js.Array[RouteTableAssociation]
  type RouteTableList                                   = js.Array[RouteTable]
  type RuleAction                                       = String
  type ScheduledInstanceAvailabilitySet                 = js.Array[ScheduledInstanceAvailability]
  type ScheduledInstanceIdRequestSet                    = js.Array[String]
  type ScheduledInstanceSet                             = js.Array[ScheduledInstance]
  type ScheduledInstancesBlockDeviceMappingSet          = js.Array[ScheduledInstancesBlockDeviceMapping]
  type ScheduledInstancesIpv6AddressList                = js.Array[ScheduledInstancesIpv6Address]
  type ScheduledInstancesNetworkInterfaceSet            = js.Array[ScheduledInstancesNetworkInterface]
  type ScheduledInstancesSecurityGroupIdSet             = js.Array[String]
  type SecurityGroupIdStringList                        = js.Array[String]
  type SecurityGroupList                                = js.Array[SecurityGroup]
  type SecurityGroupReferences                          = js.Array[SecurityGroupReference]
  type SecurityGroupStringList                          = js.Array[String]
  type ServiceConfigurationSet                          = js.Array[ServiceConfiguration]
  type ServiceDetailSet                                 = js.Array[ServiceDetail]
  type ServiceState                                     = String
  type ServiceType                                      = String
  type ServiceTypeDetailSet                             = js.Array[ServiceTypeDetail]
  type ShutdownBehavior                                 = String
  type SnapshotAttributeName                            = String
  type SnapshotDetailList                               = js.Array[SnapshotDetail]
  type SnapshotIdStringList                             = js.Array[String]
  type SnapshotList                                     = js.Array[Snapshot]
  type SnapshotState                                    = String
  type SpotAllocationStrategy                           = String
  type SpotFleetRequestConfigSet                        = js.Array[SpotFleetRequestConfig]
  type SpotFleetTagSpecificationList                    = js.Array[SpotFleetTagSpecification]
  type SpotInstanceInterruptionBehavior                 = String
  type SpotInstanceRequestIdList                        = js.Array[String]
  type SpotInstanceRequestList                          = js.Array[SpotInstanceRequest]
  type SpotInstanceState                                = String
  type SpotInstanceType                                 = String
  type SpotPriceHistoryList                             = js.Array[SpotPrice]
  type StaleIpPermissionSet                             = js.Array[StaleIpPermission]
  type StaleSecurityGroupSet                            = js.Array[StaleSecurityGroup]
  type State                                            = String
  type Status                                           = String
  type StatusName                                       = String
  type StatusType                                       = String
  type SubnetCidrBlockStateCode                         = String
  type SubnetIdStringList                               = js.Array[String]
  type SubnetIpv6CidrBlockAssociationSet                = js.Array[SubnetIpv6CidrBlockAssociation]
  type SubnetList                                       = js.Array[Subnet]
  type SubnetState                                      = String
  type SuccessfulInstanceCreditSpecificationSet         = js.Array[SuccessfulInstanceCreditSpecificationItem]
  type SummaryStatus                                    = String
  type TagDescriptionList                               = js.Array[TagDescription]
  type TagList                                          = js.Array[Tag]
  type TagSpecificationList                             = js.Array[TagSpecification]
  type TargetConfigurationRequestSet                    = js.Array[TargetConfigurationRequest]
  type TargetGroups                                     = js.Array[TargetGroup]
  type TargetNetworkSet                                 = js.Array[TargetNetwork]
  type TargetReservationValueSet                        = js.Array[TargetReservationValue]
  type TelemetryStatus                                  = String
  type Tenancy                                          = String
  type TerminateConnectionStatusSet                     = js.Array[TerminateConnectionStatus]
  type TrafficType                                      = String
  type TransitGatewayAssociationState                   = String
  type TransitGatewayAttachmentIdStringList             = js.Array[String]
  type TransitGatewayAttachmentList                     = js.Array[TransitGatewayAttachment]
  type TransitGatewayAttachmentPropagationList          = js.Array[TransitGatewayAttachmentPropagation]
  type TransitGatewayAttachmentResourceType             = String
  type TransitGatewayAttachmentState                    = String
  type TransitGatewayIdStringList                       = js.Array[String]
  type TransitGatewayList                               = js.Array[TransitGateway]
  type TransitGatewayMaxResults                         = Int
  type TransitGatewayPropagationState                   = String
  type TransitGatewayRouteAttachmentList                = js.Array[TransitGatewayRouteAttachment]
  type TransitGatewayRouteList                          = js.Array[TransitGatewayRoute]
  type TransitGatewayRouteState                         = String
  type TransitGatewayRouteTableAssociationList          = js.Array[TransitGatewayRouteTableAssociation]
  type TransitGatewayRouteTableIdStringList             = js.Array[String]
  type TransitGatewayRouteTableList                     = js.Array[TransitGatewayRouteTable]
  type TransitGatewayRouteTablePropagationList          = js.Array[TransitGatewayRouteTablePropagation]
  type TransitGatewayRouteTableState                    = String
  type TransitGatewayRouteType                          = String
  type TransitGatewayState                              = String
  type TransitGatewayVpcAttachmentList                  = js.Array[TransitGatewayVpcAttachment]
  type TransportProtocol                                = String
  type TunnelOptionsList                                = js.Array[VpnTunnelOptionsSpecification]
  type UnsuccessfulInstanceCreditSpecificationErrorCode = String
  type UnsuccessfulInstanceCreditSpecificationSet       = js.Array[UnsuccessfulInstanceCreditSpecificationItem]
  type UnsuccessfulItemList                             = js.Array[UnsuccessfulItem]
  type UnsuccessfulItemSet                              = js.Array[UnsuccessfulItem]
  type UserGroupStringList                              = js.Array[String]
  type UserIdGroupPairList                              = js.Array[UserIdGroupPair]
  type UserIdGroupPairSet                               = js.Array[UserIdGroupPair]
  type UserIdStringList                                 = js.Array[String]
  type ValueStringList                                  = js.Array[String]
  type VersionDescription                               = String
  type VersionStringList                                = js.Array[String]
  type VgwTelemetryList                                 = js.Array[VgwTelemetry]
  type VirtualizationType                               = String
  type VolumeAttachmentList                             = js.Array[VolumeAttachment]
  type VolumeAttachmentState                            = String
  type VolumeAttributeName                              = String
  type VolumeIdStringList                               = js.Array[String]
  type VolumeList                                       = js.Array[Volume]
  type VolumeModificationList                           = js.Array[VolumeModification]
  type VolumeModificationState                          = String
  type VolumeState                                      = String
  type VolumeStatusActionsList                          = js.Array[VolumeStatusAction]
  type VolumeStatusDetailsList                          = js.Array[VolumeStatusDetails]
  type VolumeStatusEventsList                           = js.Array[VolumeStatusEvent]
  type VolumeStatusInfoStatus                           = String
  type VolumeStatusList                                 = js.Array[VolumeStatusItem]
  type VolumeStatusName                                 = String
  type VolumeType                                       = String
  type VpcAttachmentList                                = js.Array[VpcAttachment]
  type VpcAttributeName                                 = String
  type VpcCidrBlockAssociationSet                       = js.Array[VpcCidrBlockAssociation]
  type VpcCidrBlockStateCode                            = String
  type VpcClassicLinkIdList                             = js.Array[String]
  type VpcClassicLinkList                               = js.Array[VpcClassicLink]
  type VpcEndpointConnectionSet                         = js.Array[VpcEndpointConnection]
  type VpcEndpointSet                                   = js.Array[VpcEndpoint]
  type VpcEndpointType                                  = String
  type VpcIdStringList                                  = js.Array[String]
  type VpcIpv6CidrBlockAssociationSet                   = js.Array[VpcIpv6CidrBlockAssociation]
  type VpcList                                          = js.Array[Vpc]
  type VpcPeeringConnectionList                         = js.Array[VpcPeeringConnection]
  type VpcPeeringConnectionStateReasonCode              = String
  type VpcState                                         = String
  type VpcTenancy                                       = String
  type VpnConnectionIdStringList                        = js.Array[String]
  type VpnConnectionList                                = js.Array[VpnConnection]
  type VpnEcmpSupportValue                              = String
  type VpnGatewayIdStringList                           = js.Array[String]
  type VpnGatewayList                                   = js.Array[VpnGateway]
  type VpnProtocol                                      = String
  type VpnState                                         = String
  type VpnStaticRouteList                               = js.Array[VpnStaticRoute]
  type VpnStaticRouteSource                             = String
  type ZoneIdStringList                                 = js.Array[String]
  type ZoneNameStringList                               = js.Array[String]
  type scope                                            = String

  implicit final class EC2Ops(val service: EC2) extends AnyVal {

    def acceptReservedInstancesExchangeQuoteFuture(
        params: AcceptReservedInstancesExchangeQuoteRequest
    ): Future[AcceptReservedInstancesExchangeQuoteResult] =
      service.acceptReservedInstancesExchangeQuote(params).promise.toFuture
    def acceptTransitGatewayVpcAttachmentFuture(
        params: AcceptTransitGatewayVpcAttachmentRequest
    ): Future[AcceptTransitGatewayVpcAttachmentResult] =
      service.acceptTransitGatewayVpcAttachment(params).promise.toFuture
    def acceptVpcEndpointConnectionsFuture(
        params: AcceptVpcEndpointConnectionsRequest
    ): Future[AcceptVpcEndpointConnectionsResult] = service.acceptVpcEndpointConnections(params).promise.toFuture
    def acceptVpcPeeringConnectionFuture(
        params: AcceptVpcPeeringConnectionRequest
    ): Future[AcceptVpcPeeringConnectionResult] = service.acceptVpcPeeringConnection(params).promise.toFuture
    def advertiseByoipCidrFuture(params: AdvertiseByoipCidrRequest): Future[AdvertiseByoipCidrResult] =
      service.advertiseByoipCidr(params).promise.toFuture
    def allocateAddressFuture(params: AllocateAddressRequest): Future[AllocateAddressResult] =
      service.allocateAddress(params).promise.toFuture
    def allocateHostsFuture(params: AllocateHostsRequest): Future[AllocateHostsResult] =
      service.allocateHosts(params).promise.toFuture
    def applySecurityGroupsToClientVpnTargetNetworkFuture(
        params: ApplySecurityGroupsToClientVpnTargetNetworkRequest
    ): Future[ApplySecurityGroupsToClientVpnTargetNetworkResult] =
      service.applySecurityGroupsToClientVpnTargetNetwork(params).promise.toFuture
    def assignIpv6AddressesFuture(params: AssignIpv6AddressesRequest): Future[AssignIpv6AddressesResult] =
      service.assignIpv6Addresses(params).promise.toFuture
    def assignPrivateIpAddressesFuture(params: AssignPrivateIpAddressesRequest): Future[js.Object] =
      service.assignPrivateIpAddresses(params).promise.toFuture
    def associateAddressFuture(params: AssociateAddressRequest): Future[AssociateAddressResult] =
      service.associateAddress(params).promise.toFuture
    def associateClientVpnTargetNetworkFuture(
        params: AssociateClientVpnTargetNetworkRequest
    ): Future[AssociateClientVpnTargetNetworkResult] = service.associateClientVpnTargetNetwork(params).promise.toFuture
    def associateDhcpOptionsFuture(params: AssociateDhcpOptionsRequest): Future[js.Object] =
      service.associateDhcpOptions(params).promise.toFuture
    def associateIamInstanceProfileFuture(
        params: AssociateIamInstanceProfileRequest
    ): Future[AssociateIamInstanceProfileResult] = service.associateIamInstanceProfile(params).promise.toFuture
    def associateRouteTableFuture(params: AssociateRouteTableRequest): Future[AssociateRouteTableResult] =
      service.associateRouteTable(params).promise.toFuture
    def associateSubnetCidrBlockFuture(
        params: AssociateSubnetCidrBlockRequest
    ): Future[AssociateSubnetCidrBlockResult] = service.associateSubnetCidrBlock(params).promise.toFuture
    def associateTransitGatewayRouteTableFuture(
        params: AssociateTransitGatewayRouteTableRequest
    ): Future[AssociateTransitGatewayRouteTableResult] =
      service.associateTransitGatewayRouteTable(params).promise.toFuture
    def associateVpcCidrBlockFuture(params: AssociateVpcCidrBlockRequest): Future[AssociateVpcCidrBlockResult] =
      service.associateVpcCidrBlock(params).promise.toFuture
    def attachClassicLinkVpcFuture(params: AttachClassicLinkVpcRequest): Future[AttachClassicLinkVpcResult] =
      service.attachClassicLinkVpc(params).promise.toFuture
    def attachInternetGatewayFuture(params: AttachInternetGatewayRequest): Future[js.Object] =
      service.attachInternetGateway(params).promise.toFuture
    def attachNetworkInterfaceFuture(params: AttachNetworkInterfaceRequest): Future[AttachNetworkInterfaceResult] =
      service.attachNetworkInterface(params).promise.toFuture
    def attachVolumeFuture(params: AttachVolumeRequest): Future[VolumeAttachment] =
      service.attachVolume(params).promise.toFuture
    def attachVpnGatewayFuture(params: AttachVpnGatewayRequest): Future[AttachVpnGatewayResult] =
      service.attachVpnGateway(params).promise.toFuture
    def authorizeClientVpnIngressFuture(
        params: AuthorizeClientVpnIngressRequest
    ): Future[AuthorizeClientVpnIngressResult] = service.authorizeClientVpnIngress(params).promise.toFuture
    def authorizeSecurityGroupEgressFuture(params: AuthorizeSecurityGroupEgressRequest): Future[js.Object] =
      service.authorizeSecurityGroupEgress(params).promise.toFuture
    def authorizeSecurityGroupIngressFuture(params: AuthorizeSecurityGroupIngressRequest): Future[js.Object] =
      service.authorizeSecurityGroupIngress(params).promise.toFuture
    def bundleInstanceFuture(params: BundleInstanceRequest): Future[BundleInstanceResult] =
      service.bundleInstance(params).promise.toFuture
    def cancelBundleTaskFuture(params: CancelBundleTaskRequest): Future[CancelBundleTaskResult] =
      service.cancelBundleTask(params).promise.toFuture
    def cancelCapacityReservationFuture(
        params: CancelCapacityReservationRequest
    ): Future[CancelCapacityReservationResult] = service.cancelCapacityReservation(params).promise.toFuture
    def cancelConversionTaskFuture(params: CancelConversionRequest): Future[js.Object] =
      service.cancelConversionTask(params).promise.toFuture
    def cancelExportTaskFuture(params: CancelExportTaskRequest): Future[js.Object] =
      service.cancelExportTask(params).promise.toFuture
    def cancelImportTaskFuture(params: CancelImportTaskRequest): Future[CancelImportTaskResult] =
      service.cancelImportTask(params).promise.toFuture
    def cancelReservedInstancesListingFuture(
        params: CancelReservedInstancesListingRequest
    ): Future[CancelReservedInstancesListingResult] = service.cancelReservedInstancesListing(params).promise.toFuture
    def cancelSpotFleetRequestsFuture(params: CancelSpotFleetRequestsRequest): Future[CancelSpotFleetRequestsResponse] =
      service.cancelSpotFleetRequests(params).promise.toFuture
    def cancelSpotInstanceRequestsFuture(
        params: CancelSpotInstanceRequestsRequest
    ): Future[CancelSpotInstanceRequestsResult] = service.cancelSpotInstanceRequests(params).promise.toFuture
    def confirmProductInstanceFuture(params: ConfirmProductInstanceRequest): Future[ConfirmProductInstanceResult] =
      service.confirmProductInstance(params).promise.toFuture
    def copyFpgaImageFuture(params: CopyFpgaImageRequest): Future[CopyFpgaImageResult] =
      service.copyFpgaImage(params).promise.toFuture
    def copyImageFuture(params: CopyImageRequest): Future[CopyImageResult] = service.copyImage(params).promise.toFuture
    def copySnapshotFuture(params: CopySnapshotRequest): Future[CopySnapshotResult] =
      service.copySnapshot(params).promise.toFuture
    def createCapacityReservationFuture(
        params: CreateCapacityReservationRequest
    ): Future[CreateCapacityReservationResult] = service.createCapacityReservation(params).promise.toFuture
    def createClientVpnEndpointFuture(params: CreateClientVpnEndpointRequest): Future[CreateClientVpnEndpointResult] =
      service.createClientVpnEndpoint(params).promise.toFuture
    def createClientVpnRouteFuture(params: CreateClientVpnRouteRequest): Future[CreateClientVpnRouteResult] =
      service.createClientVpnRoute(params).promise.toFuture
    def createCustomerGatewayFuture(params: CreateCustomerGatewayRequest): Future[CreateCustomerGatewayResult] =
      service.createCustomerGateway(params).promise.toFuture
    def createDefaultSubnetFuture(params: CreateDefaultSubnetRequest): Future[CreateDefaultSubnetResult] =
      service.createDefaultSubnet(params).promise.toFuture
    def createDefaultVpcFuture(params: CreateDefaultVpcRequest): Future[CreateDefaultVpcResult] =
      service.createDefaultVpc(params).promise.toFuture
    def createDhcpOptionsFuture(params: CreateDhcpOptionsRequest): Future[CreateDhcpOptionsResult] =
      service.createDhcpOptions(params).promise.toFuture
    def createEgressOnlyInternetGatewayFuture(
        params: CreateEgressOnlyInternetGatewayRequest
    ): Future[CreateEgressOnlyInternetGatewayResult] = service.createEgressOnlyInternetGateway(params).promise.toFuture
    def createFleetFuture(params: CreateFleetRequest): Future[CreateFleetResult] =
      service.createFleet(params).promise.toFuture
    def createFlowLogsFuture(params: CreateFlowLogsRequest): Future[CreateFlowLogsResult] =
      service.createFlowLogs(params).promise.toFuture
    def createFpgaImageFuture(params: CreateFpgaImageRequest): Future[CreateFpgaImageResult] =
      service.createFpgaImage(params).promise.toFuture
    def createImageFuture(params: CreateImageRequest): Future[CreateImageResult] =
      service.createImage(params).promise.toFuture
    def createInstanceExportTaskFuture(
        params: CreateInstanceExportTaskRequest
    ): Future[CreateInstanceExportTaskResult] = service.createInstanceExportTask(params).promise.toFuture
    def createInternetGatewayFuture(params: CreateInternetGatewayRequest): Future[CreateInternetGatewayResult] =
      service.createInternetGateway(params).promise.toFuture
    def createKeyPairFuture(params: CreateKeyPairRequest): Future[KeyPair] =
      service.createKeyPair(params).promise.toFuture
    def createLaunchTemplateFuture(params: CreateLaunchTemplateRequest): Future[CreateLaunchTemplateResult] =
      service.createLaunchTemplate(params).promise.toFuture
    def createLaunchTemplateVersionFuture(
        params: CreateLaunchTemplateVersionRequest
    ): Future[CreateLaunchTemplateVersionResult] = service.createLaunchTemplateVersion(params).promise.toFuture
    def createNatGatewayFuture(params: CreateNatGatewayRequest): Future[CreateNatGatewayResult] =
      service.createNatGateway(params).promise.toFuture
    def createNetworkAclEntryFuture(params: CreateNetworkAclEntryRequest): Future[js.Object] =
      service.createNetworkAclEntry(params).promise.toFuture
    def createNetworkAclFuture(params: CreateNetworkAclRequest): Future[CreateNetworkAclResult] =
      service.createNetworkAcl(params).promise.toFuture
    def createNetworkInterfaceFuture(params: CreateNetworkInterfaceRequest): Future[CreateNetworkInterfaceResult] =
      service.createNetworkInterface(params).promise.toFuture
    def createNetworkInterfacePermissionFuture(
        params: CreateNetworkInterfacePermissionRequest
    ): Future[CreateNetworkInterfacePermissionResult] =
      service.createNetworkInterfacePermission(params).promise.toFuture
    def createPlacementGroupFuture(params: CreatePlacementGroupRequest): Future[js.Object] =
      service.createPlacementGroup(params).promise.toFuture
    def createReservedInstancesListingFuture(
        params: CreateReservedInstancesListingRequest
    ): Future[CreateReservedInstancesListingResult] = service.createReservedInstancesListing(params).promise.toFuture
    def createRouteFuture(params: CreateRouteRequest): Future[CreateRouteResult] =
      service.createRoute(params).promise.toFuture
    def createRouteTableFuture(params: CreateRouteTableRequest): Future[CreateRouteTableResult] =
      service.createRouteTable(params).promise.toFuture
    def createSecurityGroupFuture(params: CreateSecurityGroupRequest): Future[CreateSecurityGroupResult] =
      service.createSecurityGroup(params).promise.toFuture
    def createSnapshotFuture(params: CreateSnapshotRequest): Future[Snapshot] =
      service.createSnapshot(params).promise.toFuture
    def createSpotDatafeedSubscriptionFuture(
        params: CreateSpotDatafeedSubscriptionRequest
    ): Future[CreateSpotDatafeedSubscriptionResult] = service.createSpotDatafeedSubscription(params).promise.toFuture
    def createSubnetFuture(params: CreateSubnetRequest): Future[CreateSubnetResult] =
      service.createSubnet(params).promise.toFuture
    def createTagsFuture(params: CreateTagsRequest): Future[js.Object] = service.createTags(params).promise.toFuture
    def createTransitGatewayFuture(params: CreateTransitGatewayRequest): Future[CreateTransitGatewayResult] =
      service.createTransitGateway(params).promise.toFuture
    def createTransitGatewayRouteFuture(
        params: CreateTransitGatewayRouteRequest
    ): Future[CreateTransitGatewayRouteResult] = service.createTransitGatewayRoute(params).promise.toFuture
    def createTransitGatewayRouteTableFuture(
        params: CreateTransitGatewayRouteTableRequest
    ): Future[CreateTransitGatewayRouteTableResult] = service.createTransitGatewayRouteTable(params).promise.toFuture
    def createTransitGatewayVpcAttachmentFuture(
        params: CreateTransitGatewayVpcAttachmentRequest
    ): Future[CreateTransitGatewayVpcAttachmentResult] =
      service.createTransitGatewayVpcAttachment(params).promise.toFuture
    def createVolumeFuture(params: CreateVolumeRequest): Future[Volume] = service.createVolume(params).promise.toFuture
    def createVpcEndpointConnectionNotificationFuture(
        params: CreateVpcEndpointConnectionNotificationRequest
    ): Future[CreateVpcEndpointConnectionNotificationResult] =
      service.createVpcEndpointConnectionNotification(params).promise.toFuture
    def createVpcEndpointFuture(params: CreateVpcEndpointRequest): Future[CreateVpcEndpointResult] =
      service.createVpcEndpoint(params).promise.toFuture
    def createVpcEndpointServiceConfigurationFuture(
        params: CreateVpcEndpointServiceConfigurationRequest
    ): Future[CreateVpcEndpointServiceConfigurationResult] =
      service.createVpcEndpointServiceConfiguration(params).promise.toFuture
    def createVpcFuture(params: CreateVpcRequest): Future[CreateVpcResult] = service.createVpc(params).promise.toFuture
    def createVpcPeeringConnectionFuture(
        params: CreateVpcPeeringConnectionRequest
    ): Future[CreateVpcPeeringConnectionResult] = service.createVpcPeeringConnection(params).promise.toFuture
    def createVpnConnectionFuture(params: CreateVpnConnectionRequest): Future[CreateVpnConnectionResult] =
      service.createVpnConnection(params).promise.toFuture
    def createVpnConnectionRouteFuture(params: CreateVpnConnectionRouteRequest): Future[js.Object] =
      service.createVpnConnectionRoute(params).promise.toFuture
    def createVpnGatewayFuture(params: CreateVpnGatewayRequest): Future[CreateVpnGatewayResult] =
      service.createVpnGateway(params).promise.toFuture
    def deleteClientVpnEndpointFuture(params: DeleteClientVpnEndpointRequest): Future[DeleteClientVpnEndpointResult] =
      service.deleteClientVpnEndpoint(params).promise.toFuture
    def deleteClientVpnRouteFuture(params: DeleteClientVpnRouteRequest): Future[DeleteClientVpnRouteResult] =
      service.deleteClientVpnRoute(params).promise.toFuture
    def deleteCustomerGatewayFuture(params: DeleteCustomerGatewayRequest): Future[js.Object] =
      service.deleteCustomerGateway(params).promise.toFuture
    def deleteDhcpOptionsFuture(params: DeleteDhcpOptionsRequest): Future[js.Object] =
      service.deleteDhcpOptions(params).promise.toFuture
    def deleteEgressOnlyInternetGatewayFuture(
        params: DeleteEgressOnlyInternetGatewayRequest
    ): Future[DeleteEgressOnlyInternetGatewayResult] = service.deleteEgressOnlyInternetGateway(params).promise.toFuture
    def deleteFleetsFuture(params: DeleteFleetsRequest): Future[DeleteFleetsResult] =
      service.deleteFleets(params).promise.toFuture
    def deleteFlowLogsFuture(params: DeleteFlowLogsRequest): Future[DeleteFlowLogsResult] =
      service.deleteFlowLogs(params).promise.toFuture
    def deleteFpgaImageFuture(params: DeleteFpgaImageRequest): Future[DeleteFpgaImageResult] =
      service.deleteFpgaImage(params).promise.toFuture
    def deleteInternetGatewayFuture(params: DeleteInternetGatewayRequest): Future[js.Object] =
      service.deleteInternetGateway(params).promise.toFuture
    def deleteKeyPairFuture(params: DeleteKeyPairRequest): Future[js.Object] =
      service.deleteKeyPair(params).promise.toFuture
    def deleteLaunchTemplateFuture(params: DeleteLaunchTemplateRequest): Future[DeleteLaunchTemplateResult] =
      service.deleteLaunchTemplate(params).promise.toFuture
    def deleteLaunchTemplateVersionsFuture(
        params: DeleteLaunchTemplateVersionsRequest
    ): Future[DeleteLaunchTemplateVersionsResult] = service.deleteLaunchTemplateVersions(params).promise.toFuture
    def deleteNatGatewayFuture(params: DeleteNatGatewayRequest): Future[DeleteNatGatewayResult] =
      service.deleteNatGateway(params).promise.toFuture
    def deleteNetworkAclEntryFuture(params: DeleteNetworkAclEntryRequest): Future[js.Object] =
      service.deleteNetworkAclEntry(params).promise.toFuture
    def deleteNetworkAclFuture(params: DeleteNetworkAclRequest): Future[js.Object] =
      service.deleteNetworkAcl(params).promise.toFuture
    def deleteNetworkInterfaceFuture(params: DeleteNetworkInterfaceRequest): Future[js.Object] =
      service.deleteNetworkInterface(params).promise.toFuture
    def deleteNetworkInterfacePermissionFuture(
        params: DeleteNetworkInterfacePermissionRequest
    ): Future[DeleteNetworkInterfacePermissionResult] =
      service.deleteNetworkInterfacePermission(params).promise.toFuture
    def deletePlacementGroupFuture(params: DeletePlacementGroupRequest): Future[js.Object] =
      service.deletePlacementGroup(params).promise.toFuture
    def deleteRouteFuture(params: DeleteRouteRequest): Future[js.Object] = service.deleteRoute(params).promise.toFuture
    def deleteRouteTableFuture(params: DeleteRouteTableRequest): Future[js.Object] =
      service.deleteRouteTable(params).promise.toFuture
    def deleteSecurityGroupFuture(params: DeleteSecurityGroupRequest): Future[js.Object] =
      service.deleteSecurityGroup(params).promise.toFuture
    def deleteSnapshotFuture(params: DeleteSnapshotRequest): Future[js.Object] =
      service.deleteSnapshot(params).promise.toFuture
    def deleteSpotDatafeedSubscriptionFuture(params: DeleteSpotDatafeedSubscriptionRequest): Future[js.Object] =
      service.deleteSpotDatafeedSubscription(params).promise.toFuture
    def deleteSubnetFuture(params: DeleteSubnetRequest): Future[js.Object] =
      service.deleteSubnet(params).promise.toFuture
    def deleteTagsFuture(params: DeleteTagsRequest): Future[js.Object] = service.deleteTags(params).promise.toFuture
    def deleteTransitGatewayFuture(params: DeleteTransitGatewayRequest): Future[DeleteTransitGatewayResult] =
      service.deleteTransitGateway(params).promise.toFuture
    def deleteTransitGatewayRouteFuture(
        params: DeleteTransitGatewayRouteRequest
    ): Future[DeleteTransitGatewayRouteResult] = service.deleteTransitGatewayRoute(params).promise.toFuture
    def deleteTransitGatewayRouteTableFuture(
        params: DeleteTransitGatewayRouteTableRequest
    ): Future[DeleteTransitGatewayRouteTableResult] = service.deleteTransitGatewayRouteTable(params).promise.toFuture
    def deleteTransitGatewayVpcAttachmentFuture(
        params: DeleteTransitGatewayVpcAttachmentRequest
    ): Future[DeleteTransitGatewayVpcAttachmentResult] =
      service.deleteTransitGatewayVpcAttachment(params).promise.toFuture
    def deleteVolumeFuture(params: DeleteVolumeRequest): Future[js.Object] =
      service.deleteVolume(params).promise.toFuture
    def deleteVpcEndpointConnectionNotificationsFuture(
        params: DeleteVpcEndpointConnectionNotificationsRequest
    ): Future[DeleteVpcEndpointConnectionNotificationsResult] =
      service.deleteVpcEndpointConnectionNotifications(params).promise.toFuture
    def deleteVpcEndpointServiceConfigurationsFuture(
        params: DeleteVpcEndpointServiceConfigurationsRequest
    ): Future[DeleteVpcEndpointServiceConfigurationsResult] =
      service.deleteVpcEndpointServiceConfigurations(params).promise.toFuture
    def deleteVpcEndpointsFuture(params: DeleteVpcEndpointsRequest): Future[DeleteVpcEndpointsResult] =
      service.deleteVpcEndpoints(params).promise.toFuture
    def deleteVpcFuture(params: DeleteVpcRequest): Future[js.Object] = service.deleteVpc(params).promise.toFuture
    def deleteVpcPeeringConnectionFuture(
        params: DeleteVpcPeeringConnectionRequest
    ): Future[DeleteVpcPeeringConnectionResult] = service.deleteVpcPeeringConnection(params).promise.toFuture
    def deleteVpnConnectionFuture(params: DeleteVpnConnectionRequest): Future[js.Object] =
      service.deleteVpnConnection(params).promise.toFuture
    def deleteVpnConnectionRouteFuture(params: DeleteVpnConnectionRouteRequest): Future[js.Object] =
      service.deleteVpnConnectionRoute(params).promise.toFuture
    def deleteVpnGatewayFuture(params: DeleteVpnGatewayRequest): Future[js.Object] =
      service.deleteVpnGateway(params).promise.toFuture
    def deprovisionByoipCidrFuture(params: DeprovisionByoipCidrRequest): Future[DeprovisionByoipCidrResult] =
      service.deprovisionByoipCidr(params).promise.toFuture
    def deregisterImageFuture(params: DeregisterImageRequest): Future[js.Object] =
      service.deregisterImage(params).promise.toFuture
    def describeAccountAttributesFuture(
        params: DescribeAccountAttributesRequest
    ): Future[DescribeAccountAttributesResult] = service.describeAccountAttributes(params).promise.toFuture
    def describeAddressesFuture(params: DescribeAddressesRequest): Future[DescribeAddressesResult] =
      service.describeAddresses(params).promise.toFuture
    def describeAggregateIdFormatFuture(
        params: DescribeAggregateIdFormatRequest
    ): Future[DescribeAggregateIdFormatResult] = service.describeAggregateIdFormat(params).promise.toFuture
    def describeAvailabilityZonesFuture(
        params: DescribeAvailabilityZonesRequest
    ): Future[DescribeAvailabilityZonesResult] = service.describeAvailabilityZones(params).promise.toFuture
    def describeBundleTasksFuture(params: DescribeBundleTasksRequest): Future[DescribeBundleTasksResult] =
      service.describeBundleTasks(params).promise.toFuture
    def describeByoipCidrsFuture(params: DescribeByoipCidrsRequest): Future[DescribeByoipCidrsResult] =
      service.describeByoipCidrs(params).promise.toFuture
    def describeCapacityReservationsFuture(
        params: DescribeCapacityReservationsRequest
    ): Future[DescribeCapacityReservationsResult] = service.describeCapacityReservations(params).promise.toFuture
    def describeClassicLinkInstancesFuture(
        params: DescribeClassicLinkInstancesRequest
    ): Future[DescribeClassicLinkInstancesResult] = service.describeClassicLinkInstances(params).promise.toFuture
    def describeClientVpnAuthorizationRulesFuture(
        params: DescribeClientVpnAuthorizationRulesRequest
    ): Future[DescribeClientVpnAuthorizationRulesResult] =
      service.describeClientVpnAuthorizationRules(params).promise.toFuture
    def describeClientVpnConnectionsFuture(
        params: DescribeClientVpnConnectionsRequest
    ): Future[DescribeClientVpnConnectionsResult] = service.describeClientVpnConnections(params).promise.toFuture
    def describeClientVpnEndpointsFuture(
        params: DescribeClientVpnEndpointsRequest
    ): Future[DescribeClientVpnEndpointsResult] = service.describeClientVpnEndpoints(params).promise.toFuture
    def describeClientVpnRoutesFuture(params: DescribeClientVpnRoutesRequest): Future[DescribeClientVpnRoutesResult] =
      service.describeClientVpnRoutes(params).promise.toFuture
    def describeClientVpnTargetNetworksFuture(
        params: DescribeClientVpnTargetNetworksRequest
    ): Future[DescribeClientVpnTargetNetworksResult] = service.describeClientVpnTargetNetworks(params).promise.toFuture
    def describeConversionTasksFuture(params: DescribeConversionTasksRequest): Future[DescribeConversionTasksResult] =
      service.describeConversionTasks(params).promise.toFuture
    def describeCustomerGatewaysFuture(
        params: DescribeCustomerGatewaysRequest
    ): Future[DescribeCustomerGatewaysResult] = service.describeCustomerGateways(params).promise.toFuture
    def describeDhcpOptionsFuture(params: DescribeDhcpOptionsRequest): Future[DescribeDhcpOptionsResult] =
      service.describeDhcpOptions(params).promise.toFuture
    def describeEgressOnlyInternetGatewaysFuture(
        params: DescribeEgressOnlyInternetGatewaysRequest
    ): Future[DescribeEgressOnlyInternetGatewaysResult] =
      service.describeEgressOnlyInternetGateways(params).promise.toFuture
    def describeElasticGpusFuture(params: DescribeElasticGpusRequest): Future[DescribeElasticGpusResult] =
      service.describeElasticGpus(params).promise.toFuture
    def describeExportTasksFuture(params: DescribeExportTasksRequest): Future[DescribeExportTasksResult] =
      service.describeExportTasks(params).promise.toFuture
    def describeFleetHistoryFuture(params: DescribeFleetHistoryRequest): Future[DescribeFleetHistoryResult] =
      service.describeFleetHistory(params).promise.toFuture
    def describeFleetInstancesFuture(params: DescribeFleetInstancesRequest): Future[DescribeFleetInstancesResult] =
      service.describeFleetInstances(params).promise.toFuture
    def describeFleetsFuture(params: DescribeFleetsRequest): Future[DescribeFleetsResult] =
      service.describeFleets(params).promise.toFuture
    def describeFlowLogsFuture(params: DescribeFlowLogsRequest): Future[DescribeFlowLogsResult] =
      service.describeFlowLogs(params).promise.toFuture
    def describeFpgaImageAttributeFuture(
        params: DescribeFpgaImageAttributeRequest
    ): Future[DescribeFpgaImageAttributeResult] = service.describeFpgaImageAttribute(params).promise.toFuture
    def describeFpgaImagesFuture(params: DescribeFpgaImagesRequest): Future[DescribeFpgaImagesResult] =
      service.describeFpgaImages(params).promise.toFuture
    def describeHostReservationOfferingsFuture(
        params: DescribeHostReservationOfferingsRequest
    ): Future[DescribeHostReservationOfferingsResult] =
      service.describeHostReservationOfferings(params).promise.toFuture
    def describeHostReservationsFuture(
        params: DescribeHostReservationsRequest
    ): Future[DescribeHostReservationsResult] = service.describeHostReservations(params).promise.toFuture
    def describeHostsFuture(params: DescribeHostsRequest): Future[DescribeHostsResult] =
      service.describeHosts(params).promise.toFuture
    def describeIamInstanceProfileAssociationsFuture(
        params: DescribeIamInstanceProfileAssociationsRequest
    ): Future[DescribeIamInstanceProfileAssociationsResult] =
      service.describeIamInstanceProfileAssociations(params).promise.toFuture
    def describeIdFormatFuture(params: DescribeIdFormatRequest): Future[DescribeIdFormatResult] =
      service.describeIdFormat(params).promise.toFuture
    def describeIdentityIdFormatFuture(
        params: DescribeIdentityIdFormatRequest
    ): Future[DescribeIdentityIdFormatResult] = service.describeIdentityIdFormat(params).promise.toFuture
    def describeImageAttributeFuture(params: DescribeImageAttributeRequest): Future[ImageAttribute] =
      service.describeImageAttribute(params).promise.toFuture
    def describeImagesFuture(params: DescribeImagesRequest): Future[DescribeImagesResult] =
      service.describeImages(params).promise.toFuture
    def describeImportImageTasksFuture(
        params: DescribeImportImageTasksRequest
    ): Future[DescribeImportImageTasksResult] = service.describeImportImageTasks(params).promise.toFuture
    def describeImportSnapshotTasksFuture(
        params: DescribeImportSnapshotTasksRequest
    ): Future[DescribeImportSnapshotTasksResult] = service.describeImportSnapshotTasks(params).promise.toFuture
    def describeInstanceAttributeFuture(params: DescribeInstanceAttributeRequest): Future[InstanceAttribute] =
      service.describeInstanceAttribute(params).promise.toFuture
    def describeInstanceCreditSpecificationsFuture(
        params: DescribeInstanceCreditSpecificationsRequest
    ): Future[DescribeInstanceCreditSpecificationsResult] =
      service.describeInstanceCreditSpecifications(params).promise.toFuture
    def describeInstanceStatusFuture(params: DescribeInstanceStatusRequest): Future[DescribeInstanceStatusResult] =
      service.describeInstanceStatus(params).promise.toFuture
    def describeInstancesFuture(params: DescribeInstancesRequest): Future[DescribeInstancesResult] =
      service.describeInstances(params).promise.toFuture
    def describeInternetGatewaysFuture(
        params: DescribeInternetGatewaysRequest
    ): Future[DescribeInternetGatewaysResult] = service.describeInternetGateways(params).promise.toFuture
    def describeKeyPairsFuture(params: DescribeKeyPairsRequest): Future[DescribeKeyPairsResult] =
      service.describeKeyPairs(params).promise.toFuture
    def describeLaunchTemplateVersionsFuture(
        params: DescribeLaunchTemplateVersionsRequest
    ): Future[DescribeLaunchTemplateVersionsResult] = service.describeLaunchTemplateVersions(params).promise.toFuture
    def describeLaunchTemplatesFuture(params: DescribeLaunchTemplatesRequest): Future[DescribeLaunchTemplatesResult] =
      service.describeLaunchTemplates(params).promise.toFuture
    def describeMovingAddressesFuture(params: DescribeMovingAddressesRequest): Future[DescribeMovingAddressesResult] =
      service.describeMovingAddresses(params).promise.toFuture
    def describeNatGatewaysFuture(params: DescribeNatGatewaysRequest): Future[DescribeNatGatewaysResult] =
      service.describeNatGateways(params).promise.toFuture
    def describeNetworkAclsFuture(params: DescribeNetworkAclsRequest): Future[DescribeNetworkAclsResult] =
      service.describeNetworkAcls(params).promise.toFuture
    def describeNetworkInterfaceAttributeFuture(
        params: DescribeNetworkInterfaceAttributeRequest
    ): Future[DescribeNetworkInterfaceAttributeResult] =
      service.describeNetworkInterfaceAttribute(params).promise.toFuture
    def describeNetworkInterfacePermissionsFuture(
        params: DescribeNetworkInterfacePermissionsRequest
    ): Future[DescribeNetworkInterfacePermissionsResult] =
      service.describeNetworkInterfacePermissions(params).promise.toFuture
    def describeNetworkInterfacesFuture(
        params: DescribeNetworkInterfacesRequest
    ): Future[DescribeNetworkInterfacesResult] = service.describeNetworkInterfaces(params).promise.toFuture
    def describePlacementGroupsFuture(params: DescribePlacementGroupsRequest): Future[DescribePlacementGroupsResult] =
      service.describePlacementGroups(params).promise.toFuture
    def describePrefixListsFuture(params: DescribePrefixListsRequest): Future[DescribePrefixListsResult] =
      service.describePrefixLists(params).promise.toFuture
    def describePrincipalIdFormatFuture(
        params: DescribePrincipalIdFormatRequest
    ): Future[DescribePrincipalIdFormatResult] = service.describePrincipalIdFormat(params).promise.toFuture
    def describePublicIpv4PoolsFuture(params: DescribePublicIpv4PoolsRequest): Future[DescribePublicIpv4PoolsResult] =
      service.describePublicIpv4Pools(params).promise.toFuture
    def describeRegionsFuture(params: DescribeRegionsRequest): Future[DescribeRegionsResult] =
      service.describeRegions(params).promise.toFuture
    def describeReservedInstancesFuture(
        params: DescribeReservedInstancesRequest
    ): Future[DescribeReservedInstancesResult] = service.describeReservedInstances(params).promise.toFuture
    def describeReservedInstancesListingsFuture(
        params: DescribeReservedInstancesListingsRequest
    ): Future[DescribeReservedInstancesListingsResult] =
      service.describeReservedInstancesListings(params).promise.toFuture
    def describeReservedInstancesModificationsFuture(
        params: DescribeReservedInstancesModificationsRequest
    ): Future[DescribeReservedInstancesModificationsResult] =
      service.describeReservedInstancesModifications(params).promise.toFuture
    def describeReservedInstancesOfferingsFuture(
        params: DescribeReservedInstancesOfferingsRequest
    ): Future[DescribeReservedInstancesOfferingsResult] =
      service.describeReservedInstancesOfferings(params).promise.toFuture
    def describeRouteTablesFuture(params: DescribeRouteTablesRequest): Future[DescribeRouteTablesResult] =
      service.describeRouteTables(params).promise.toFuture
    def describeScheduledInstanceAvailabilityFuture(
        params: DescribeScheduledInstanceAvailabilityRequest
    ): Future[DescribeScheduledInstanceAvailabilityResult] =
      service.describeScheduledInstanceAvailability(params).promise.toFuture
    def describeScheduledInstancesFuture(
        params: DescribeScheduledInstancesRequest
    ): Future[DescribeScheduledInstancesResult] = service.describeScheduledInstances(params).promise.toFuture
    def describeSecurityGroupReferencesFuture(
        params: DescribeSecurityGroupReferencesRequest
    ): Future[DescribeSecurityGroupReferencesResult] = service.describeSecurityGroupReferences(params).promise.toFuture
    def describeSecurityGroupsFuture(params: DescribeSecurityGroupsRequest): Future[DescribeSecurityGroupsResult] =
      service.describeSecurityGroups(params).promise.toFuture
    def describeSnapshotAttributeFuture(
        params: DescribeSnapshotAttributeRequest
    ): Future[DescribeSnapshotAttributeResult] = service.describeSnapshotAttribute(params).promise.toFuture
    def describeSnapshotsFuture(params: DescribeSnapshotsRequest): Future[DescribeSnapshotsResult] =
      service.describeSnapshots(params).promise.toFuture
    def describeSpotDatafeedSubscriptionFuture(
        params: DescribeSpotDatafeedSubscriptionRequest
    ): Future[DescribeSpotDatafeedSubscriptionResult] =
      service.describeSpotDatafeedSubscription(params).promise.toFuture
    def describeSpotFleetInstancesFuture(
        params: DescribeSpotFleetInstancesRequest
    ): Future[DescribeSpotFleetInstancesResponse] = service.describeSpotFleetInstances(params).promise.toFuture
    def describeSpotFleetRequestHistoryFuture(
        params: DescribeSpotFleetRequestHistoryRequest
    ): Future[DescribeSpotFleetRequestHistoryResponse] =
      service.describeSpotFleetRequestHistory(params).promise.toFuture
    def describeSpotFleetRequestsFuture(
        params: DescribeSpotFleetRequestsRequest
    ): Future[DescribeSpotFleetRequestsResponse] = service.describeSpotFleetRequests(params).promise.toFuture
    def describeSpotInstanceRequestsFuture(
        params: DescribeSpotInstanceRequestsRequest
    ): Future[DescribeSpotInstanceRequestsResult] = service.describeSpotInstanceRequests(params).promise.toFuture
    def describeSpotPriceHistoryFuture(
        params: DescribeSpotPriceHistoryRequest
    ): Future[DescribeSpotPriceHistoryResult] = service.describeSpotPriceHistory(params).promise.toFuture
    def describeStaleSecurityGroupsFuture(
        params: DescribeStaleSecurityGroupsRequest
    ): Future[DescribeStaleSecurityGroupsResult] = service.describeStaleSecurityGroups(params).promise.toFuture
    def describeSubnetsFuture(params: DescribeSubnetsRequest): Future[DescribeSubnetsResult] =
      service.describeSubnets(params).promise.toFuture
    def describeTagsFuture(params: DescribeTagsRequest): Future[DescribeTagsResult] =
      service.describeTags(params).promise.toFuture
    def describeTransitGatewayAttachmentsFuture(
        params: DescribeTransitGatewayAttachmentsRequest
    ): Future[DescribeTransitGatewayAttachmentsResult] =
      service.describeTransitGatewayAttachments(params).promise.toFuture
    def describeTransitGatewayRouteTablesFuture(
        params: DescribeTransitGatewayRouteTablesRequest
    ): Future[DescribeTransitGatewayRouteTablesResult] =
      service.describeTransitGatewayRouteTables(params).promise.toFuture
    def describeTransitGatewayVpcAttachmentsFuture(
        params: DescribeTransitGatewayVpcAttachmentsRequest
    ): Future[DescribeTransitGatewayVpcAttachmentsResult] =
      service.describeTransitGatewayVpcAttachments(params).promise.toFuture
    def describeTransitGatewaysFuture(params: DescribeTransitGatewaysRequest): Future[DescribeTransitGatewaysResult] =
      service.describeTransitGateways(params).promise.toFuture
    def describeVolumeAttributeFuture(params: DescribeVolumeAttributeRequest): Future[DescribeVolumeAttributeResult] =
      service.describeVolumeAttribute(params).promise.toFuture
    def describeVolumeStatusFuture(params: DescribeVolumeStatusRequest): Future[DescribeVolumeStatusResult] =
      service.describeVolumeStatus(params).promise.toFuture
    def describeVolumesFuture(params: DescribeVolumesRequest): Future[DescribeVolumesResult] =
      service.describeVolumes(params).promise.toFuture
    def describeVolumesModificationsFuture(
        params: DescribeVolumesModificationsRequest
    ): Future[DescribeVolumesModificationsResult] = service.describeVolumesModifications(params).promise.toFuture
    def describeVpcAttributeFuture(params: DescribeVpcAttributeRequest): Future[DescribeVpcAttributeResult] =
      service.describeVpcAttribute(params).promise.toFuture
    def describeVpcClassicLinkDnsSupportFuture(
        params: DescribeVpcClassicLinkDnsSupportRequest
    ): Future[DescribeVpcClassicLinkDnsSupportResult] =
      service.describeVpcClassicLinkDnsSupport(params).promise.toFuture
    def describeVpcClassicLinkFuture(params: DescribeVpcClassicLinkRequest): Future[DescribeVpcClassicLinkResult] =
      service.describeVpcClassicLink(params).promise.toFuture
    def describeVpcEndpointConnectionNotificationsFuture(
        params: DescribeVpcEndpointConnectionNotificationsRequest
    ): Future[DescribeVpcEndpointConnectionNotificationsResult] =
      service.describeVpcEndpointConnectionNotifications(params).promise.toFuture
    def describeVpcEndpointConnectionsFuture(
        params: DescribeVpcEndpointConnectionsRequest
    ): Future[DescribeVpcEndpointConnectionsResult] = service.describeVpcEndpointConnections(params).promise.toFuture
    def describeVpcEndpointServiceConfigurationsFuture(
        params: DescribeVpcEndpointServiceConfigurationsRequest
    ): Future[DescribeVpcEndpointServiceConfigurationsResult] =
      service.describeVpcEndpointServiceConfigurations(params).promise.toFuture
    def describeVpcEndpointServicePermissionsFuture(
        params: DescribeVpcEndpointServicePermissionsRequest
    ): Future[DescribeVpcEndpointServicePermissionsResult] =
      service.describeVpcEndpointServicePermissions(params).promise.toFuture
    def describeVpcEndpointServicesFuture(
        params: DescribeVpcEndpointServicesRequest
    ): Future[DescribeVpcEndpointServicesResult] = service.describeVpcEndpointServices(params).promise.toFuture
    def describeVpcEndpointsFuture(params: DescribeVpcEndpointsRequest): Future[DescribeVpcEndpointsResult] =
      service.describeVpcEndpoints(params).promise.toFuture
    def describeVpcPeeringConnectionsFuture(
        params: DescribeVpcPeeringConnectionsRequest
    ): Future[DescribeVpcPeeringConnectionsResult] = service.describeVpcPeeringConnections(params).promise.toFuture
    def describeVpcsFuture(params: DescribeVpcsRequest): Future[DescribeVpcsResult] =
      service.describeVpcs(params).promise.toFuture
    def describeVpnConnectionsFuture(params: DescribeVpnConnectionsRequest): Future[DescribeVpnConnectionsResult] =
      service.describeVpnConnections(params).promise.toFuture
    def describeVpnGatewaysFuture(params: DescribeVpnGatewaysRequest): Future[DescribeVpnGatewaysResult] =
      service.describeVpnGateways(params).promise.toFuture
    def detachClassicLinkVpcFuture(params: DetachClassicLinkVpcRequest): Future[DetachClassicLinkVpcResult] =
      service.detachClassicLinkVpc(params).promise.toFuture
    def detachInternetGatewayFuture(params: DetachInternetGatewayRequest): Future[js.Object] =
      service.detachInternetGateway(params).promise.toFuture
    def detachNetworkInterfaceFuture(params: DetachNetworkInterfaceRequest): Future[js.Object] =
      service.detachNetworkInterface(params).promise.toFuture
    def detachVolumeFuture(params: DetachVolumeRequest): Future[VolumeAttachment] =
      service.detachVolume(params).promise.toFuture
    def detachVpnGatewayFuture(params: DetachVpnGatewayRequest): Future[js.Object] =
      service.detachVpnGateway(params).promise.toFuture
    def disableTransitGatewayRouteTablePropagationFuture(
        params: DisableTransitGatewayRouteTablePropagationRequest
    ): Future[DisableTransitGatewayRouteTablePropagationResult] =
      service.disableTransitGatewayRouteTablePropagation(params).promise.toFuture
    def disableVgwRoutePropagationFuture(params: DisableVgwRoutePropagationRequest): Future[js.Object] =
      service.disableVgwRoutePropagation(params).promise.toFuture
    def disableVpcClassicLinkDnsSupportFuture(
        params: DisableVpcClassicLinkDnsSupportRequest
    ): Future[DisableVpcClassicLinkDnsSupportResult] = service.disableVpcClassicLinkDnsSupport(params).promise.toFuture
    def disableVpcClassicLinkFuture(params: DisableVpcClassicLinkRequest): Future[DisableVpcClassicLinkResult] =
      service.disableVpcClassicLink(params).promise.toFuture
    def disassociateAddressFuture(params: DisassociateAddressRequest): Future[js.Object] =
      service.disassociateAddress(params).promise.toFuture
    def disassociateClientVpnTargetNetworkFuture(
        params: DisassociateClientVpnTargetNetworkRequest
    ): Future[DisassociateClientVpnTargetNetworkResult] =
      service.disassociateClientVpnTargetNetwork(params).promise.toFuture
    def disassociateIamInstanceProfileFuture(
        params: DisassociateIamInstanceProfileRequest
    ): Future[DisassociateIamInstanceProfileResult] = service.disassociateIamInstanceProfile(params).promise.toFuture
    def disassociateRouteTableFuture(params: DisassociateRouteTableRequest): Future[js.Object] =
      service.disassociateRouteTable(params).promise.toFuture
    def disassociateSubnetCidrBlockFuture(
        params: DisassociateSubnetCidrBlockRequest
    ): Future[DisassociateSubnetCidrBlockResult] = service.disassociateSubnetCidrBlock(params).promise.toFuture
    def disassociateTransitGatewayRouteTableFuture(
        params: DisassociateTransitGatewayRouteTableRequest
    ): Future[DisassociateTransitGatewayRouteTableResult] =
      service.disassociateTransitGatewayRouteTable(params).promise.toFuture
    def disassociateVpcCidrBlockFuture(
        params: DisassociateVpcCidrBlockRequest
    ): Future[DisassociateVpcCidrBlockResult] = service.disassociateVpcCidrBlock(params).promise.toFuture
    def enableTransitGatewayRouteTablePropagationFuture(
        params: EnableTransitGatewayRouteTablePropagationRequest
    ): Future[EnableTransitGatewayRouteTablePropagationResult] =
      service.enableTransitGatewayRouteTablePropagation(params).promise.toFuture
    def enableVgwRoutePropagationFuture(params: EnableVgwRoutePropagationRequest): Future[js.Object] =
      service.enableVgwRoutePropagation(params).promise.toFuture
    def enableVolumeIOFuture(params: EnableVolumeIORequest): Future[js.Object] =
      service.enableVolumeIO(params).promise.toFuture
    def enableVpcClassicLinkDnsSupportFuture(
        params: EnableVpcClassicLinkDnsSupportRequest
    ): Future[EnableVpcClassicLinkDnsSupportResult] = service.enableVpcClassicLinkDnsSupport(params).promise.toFuture
    def enableVpcClassicLinkFuture(params: EnableVpcClassicLinkRequest): Future[EnableVpcClassicLinkResult] =
      service.enableVpcClassicLink(params).promise.toFuture
    def exportClientVpnClientCertificateRevocationListFuture(
        params: ExportClientVpnClientCertificateRevocationListRequest
    ): Future[ExportClientVpnClientCertificateRevocationListResult] =
      service.exportClientVpnClientCertificateRevocationList(params).promise.toFuture
    def exportClientVpnClientConfigurationFuture(
        params: ExportClientVpnClientConfigurationRequest
    ): Future[ExportClientVpnClientConfigurationResult] =
      service.exportClientVpnClientConfiguration(params).promise.toFuture
    def exportTransitGatewayRoutesFuture(
        params: ExportTransitGatewayRoutesRequest
    ): Future[ExportTransitGatewayRoutesResult] = service.exportTransitGatewayRoutes(params).promise.toFuture
    def getConsoleOutputFuture(params: GetConsoleOutputRequest): Future[GetConsoleOutputResult] =
      service.getConsoleOutput(params).promise.toFuture
    def getConsoleScreenshotFuture(params: GetConsoleScreenshotRequest): Future[GetConsoleScreenshotResult] =
      service.getConsoleScreenshot(params).promise.toFuture
    def getHostReservationPurchasePreviewFuture(
        params: GetHostReservationPurchasePreviewRequest
    ): Future[GetHostReservationPurchasePreviewResult] =
      service.getHostReservationPurchasePreview(params).promise.toFuture
    def getLaunchTemplateDataFuture(params: GetLaunchTemplateDataRequest): Future[GetLaunchTemplateDataResult] =
      service.getLaunchTemplateData(params).promise.toFuture
    def getPasswordDataFuture(params: GetPasswordDataRequest): Future[GetPasswordDataResult] =
      service.getPasswordData(params).promise.toFuture
    def getReservedInstancesExchangeQuoteFuture(
        params: GetReservedInstancesExchangeQuoteRequest
    ): Future[GetReservedInstancesExchangeQuoteResult] =
      service.getReservedInstancesExchangeQuote(params).promise.toFuture
    def getTransitGatewayAttachmentPropagationsFuture(
        params: GetTransitGatewayAttachmentPropagationsRequest
    ): Future[GetTransitGatewayAttachmentPropagationsResult] =
      service.getTransitGatewayAttachmentPropagations(params).promise.toFuture
    def getTransitGatewayRouteTableAssociationsFuture(
        params: GetTransitGatewayRouteTableAssociationsRequest
    ): Future[GetTransitGatewayRouteTableAssociationsResult] =
      service.getTransitGatewayRouteTableAssociations(params).promise.toFuture
    def getTransitGatewayRouteTablePropagationsFuture(
        params: GetTransitGatewayRouteTablePropagationsRequest
    ): Future[GetTransitGatewayRouteTablePropagationsResult] =
      service.getTransitGatewayRouteTablePropagations(params).promise.toFuture
    def importClientVpnClientCertificateRevocationListFuture(
        params: ImportClientVpnClientCertificateRevocationListRequest
    ): Future[ImportClientVpnClientCertificateRevocationListResult] =
      service.importClientVpnClientCertificateRevocationList(params).promise.toFuture
    def importImageFuture(params: ImportImageRequest): Future[ImportImageResult] =
      service.importImage(params).promise.toFuture
    def importInstanceFuture(params: ImportInstanceRequest): Future[ImportInstanceResult] =
      service.importInstance(params).promise.toFuture
    def importKeyPairFuture(params: ImportKeyPairRequest): Future[ImportKeyPairResult] =
      service.importKeyPair(params).promise.toFuture
    def importSnapshotFuture(params: ImportSnapshotRequest): Future[ImportSnapshotResult] =
      service.importSnapshot(params).promise.toFuture
    def importVolumeFuture(params: ImportVolumeRequest): Future[ImportVolumeResult] =
      service.importVolume(params).promise.toFuture
    def modifyCapacityReservationFuture(
        params: ModifyCapacityReservationRequest
    ): Future[ModifyCapacityReservationResult] = service.modifyCapacityReservation(params).promise.toFuture
    def modifyClientVpnEndpointFuture(params: ModifyClientVpnEndpointRequest): Future[ModifyClientVpnEndpointResult] =
      service.modifyClientVpnEndpoint(params).promise.toFuture
    def modifyFleetFuture(params: ModifyFleetRequest): Future[ModifyFleetResult] =
      service.modifyFleet(params).promise.toFuture
    def modifyFpgaImageAttributeFuture(
        params: ModifyFpgaImageAttributeRequest
    ): Future[ModifyFpgaImageAttributeResult] = service.modifyFpgaImageAttribute(params).promise.toFuture
    def modifyHostsFuture(params: ModifyHostsRequest): Future[ModifyHostsResult] =
      service.modifyHosts(params).promise.toFuture
    def modifyIdFormatFuture(params: ModifyIdFormatRequest): Future[js.Object] =
      service.modifyIdFormat(params).promise.toFuture
    def modifyIdentityIdFormatFuture(params: ModifyIdentityIdFormatRequest): Future[js.Object] =
      service.modifyIdentityIdFormat(params).promise.toFuture
    def modifyImageAttributeFuture(params: ModifyImageAttributeRequest): Future[js.Object] =
      service.modifyImageAttribute(params).promise.toFuture
    def modifyInstanceAttributeFuture(params: ModifyInstanceAttributeRequest): Future[js.Object] =
      service.modifyInstanceAttribute(params).promise.toFuture
    def modifyInstanceCapacityReservationAttributesFuture(
        params: ModifyInstanceCapacityReservationAttributesRequest
    ): Future[ModifyInstanceCapacityReservationAttributesResult] =
      service.modifyInstanceCapacityReservationAttributes(params).promise.toFuture
    def modifyInstanceCreditSpecificationFuture(
        params: ModifyInstanceCreditSpecificationRequest
    ): Future[ModifyInstanceCreditSpecificationResult] =
      service.modifyInstanceCreditSpecification(params).promise.toFuture
    def modifyInstanceEventStartTimeFuture(
        params: ModifyInstanceEventStartTimeRequest
    ): Future[ModifyInstanceEventStartTimeResult] = service.modifyInstanceEventStartTime(params).promise.toFuture
    def modifyInstancePlacementFuture(params: ModifyInstancePlacementRequest): Future[ModifyInstancePlacementResult] =
      service.modifyInstancePlacement(params).promise.toFuture
    def modifyLaunchTemplateFuture(params: ModifyLaunchTemplateRequest): Future[ModifyLaunchTemplateResult] =
      service.modifyLaunchTemplate(params).promise.toFuture
    def modifyNetworkInterfaceAttributeFuture(params: ModifyNetworkInterfaceAttributeRequest): Future[js.Object] =
      service.modifyNetworkInterfaceAttribute(params).promise.toFuture
    def modifyReservedInstancesFuture(params: ModifyReservedInstancesRequest): Future[ModifyReservedInstancesResult] =
      service.modifyReservedInstances(params).promise.toFuture
    def modifySnapshotAttributeFuture(params: ModifySnapshotAttributeRequest): Future[js.Object] =
      service.modifySnapshotAttribute(params).promise.toFuture
    def modifySpotFleetRequestFuture(params: ModifySpotFleetRequestRequest): Future[ModifySpotFleetRequestResponse] =
      service.modifySpotFleetRequest(params).promise.toFuture
    def modifySubnetAttributeFuture(params: ModifySubnetAttributeRequest): Future[js.Object] =
      service.modifySubnetAttribute(params).promise.toFuture
    def modifyTransitGatewayVpcAttachmentFuture(
        params: ModifyTransitGatewayVpcAttachmentRequest
    ): Future[ModifyTransitGatewayVpcAttachmentResult] =
      service.modifyTransitGatewayVpcAttachment(params).promise.toFuture
    def modifyVolumeAttributeFuture(params: ModifyVolumeAttributeRequest): Future[js.Object] =
      service.modifyVolumeAttribute(params).promise.toFuture
    def modifyVolumeFuture(params: ModifyVolumeRequest): Future[ModifyVolumeResult] =
      service.modifyVolume(params).promise.toFuture
    def modifyVpcAttributeFuture(params: ModifyVpcAttributeRequest): Future[js.Object] =
      service.modifyVpcAttribute(params).promise.toFuture
    def modifyVpcEndpointConnectionNotificationFuture(
        params: ModifyVpcEndpointConnectionNotificationRequest
    ): Future[ModifyVpcEndpointConnectionNotificationResult] =
      service.modifyVpcEndpointConnectionNotification(params).promise.toFuture
    def modifyVpcEndpointFuture(params: ModifyVpcEndpointRequest): Future[ModifyVpcEndpointResult] =
      service.modifyVpcEndpoint(params).promise.toFuture
    def modifyVpcEndpointServiceConfigurationFuture(
        params: ModifyVpcEndpointServiceConfigurationRequest
    ): Future[ModifyVpcEndpointServiceConfigurationResult] =
      service.modifyVpcEndpointServiceConfiguration(params).promise.toFuture
    def modifyVpcEndpointServicePermissionsFuture(
        params: ModifyVpcEndpointServicePermissionsRequest
    ): Future[ModifyVpcEndpointServicePermissionsResult] =
      service.modifyVpcEndpointServicePermissions(params).promise.toFuture
    def modifyVpcPeeringConnectionOptionsFuture(
        params: ModifyVpcPeeringConnectionOptionsRequest
    ): Future[ModifyVpcPeeringConnectionOptionsResult] =
      service.modifyVpcPeeringConnectionOptions(params).promise.toFuture
    def modifyVpcTenancyFuture(params: ModifyVpcTenancyRequest): Future[ModifyVpcTenancyResult] =
      service.modifyVpcTenancy(params).promise.toFuture
    def monitorInstancesFuture(params: MonitorInstancesRequest): Future[MonitorInstancesResult] =
      service.monitorInstances(params).promise.toFuture
    def moveAddressToVpcFuture(params: MoveAddressToVpcRequest): Future[MoveAddressToVpcResult] =
      service.moveAddressToVpc(params).promise.toFuture
    def provisionByoipCidrFuture(params: ProvisionByoipCidrRequest): Future[ProvisionByoipCidrResult] =
      service.provisionByoipCidr(params).promise.toFuture
    def purchaseHostReservationFuture(params: PurchaseHostReservationRequest): Future[PurchaseHostReservationResult] =
      service.purchaseHostReservation(params).promise.toFuture
    def purchaseReservedInstancesOfferingFuture(
        params: PurchaseReservedInstancesOfferingRequest
    ): Future[PurchaseReservedInstancesOfferingResult] =
      service.purchaseReservedInstancesOffering(params).promise.toFuture
    def purchaseScheduledInstancesFuture(
        params: PurchaseScheduledInstancesRequest
    ): Future[PurchaseScheduledInstancesResult] = service.purchaseScheduledInstances(params).promise.toFuture
    def rebootInstancesFuture(params: RebootInstancesRequest): Future[js.Object] =
      service.rebootInstances(params).promise.toFuture
    def registerImageFuture(params: RegisterImageRequest): Future[RegisterImageResult] =
      service.registerImage(params).promise.toFuture
    def rejectTransitGatewayVpcAttachmentFuture(
        params: RejectTransitGatewayVpcAttachmentRequest
    ): Future[RejectTransitGatewayVpcAttachmentResult] =
      service.rejectTransitGatewayVpcAttachment(params).promise.toFuture
    def rejectVpcEndpointConnectionsFuture(
        params: RejectVpcEndpointConnectionsRequest
    ): Future[RejectVpcEndpointConnectionsResult] = service.rejectVpcEndpointConnections(params).promise.toFuture
    def rejectVpcPeeringConnectionFuture(
        params: RejectVpcPeeringConnectionRequest
    ): Future[RejectVpcPeeringConnectionResult] = service.rejectVpcPeeringConnection(params).promise.toFuture
    def releaseAddressFuture(params: ReleaseAddressRequest): Future[js.Object] =
      service.releaseAddress(params).promise.toFuture
    def releaseHostsFuture(params: ReleaseHostsRequest): Future[ReleaseHostsResult] =
      service.releaseHosts(params).promise.toFuture
    def replaceIamInstanceProfileAssociationFuture(
        params: ReplaceIamInstanceProfileAssociationRequest
    ): Future[ReplaceIamInstanceProfileAssociationResult] =
      service.replaceIamInstanceProfileAssociation(params).promise.toFuture
    def replaceNetworkAclAssociationFuture(
        params: ReplaceNetworkAclAssociationRequest
    ): Future[ReplaceNetworkAclAssociationResult] = service.replaceNetworkAclAssociation(params).promise.toFuture
    def replaceNetworkAclEntryFuture(params: ReplaceNetworkAclEntryRequest): Future[js.Object] =
      service.replaceNetworkAclEntry(params).promise.toFuture
    def replaceRouteFuture(params: ReplaceRouteRequest): Future[js.Object] =
      service.replaceRoute(params).promise.toFuture
    def replaceRouteTableAssociationFuture(
        params: ReplaceRouteTableAssociationRequest
    ): Future[ReplaceRouteTableAssociationResult] = service.replaceRouteTableAssociation(params).promise.toFuture
    def replaceTransitGatewayRouteFuture(
        params: ReplaceTransitGatewayRouteRequest
    ): Future[ReplaceTransitGatewayRouteResult] = service.replaceTransitGatewayRoute(params).promise.toFuture
    def reportInstanceStatusFuture(params: ReportInstanceStatusRequest): Future[js.Object] =
      service.reportInstanceStatus(params).promise.toFuture
    def requestSpotFleetFuture(params: RequestSpotFleetRequest): Future[RequestSpotFleetResponse] =
      service.requestSpotFleet(params).promise.toFuture
    def requestSpotInstancesFuture(params: RequestSpotInstancesRequest): Future[RequestSpotInstancesResult] =
      service.requestSpotInstances(params).promise.toFuture
    def resetFpgaImageAttributeFuture(params: ResetFpgaImageAttributeRequest): Future[ResetFpgaImageAttributeResult] =
      service.resetFpgaImageAttribute(params).promise.toFuture
    def resetImageAttributeFuture(params: ResetImageAttributeRequest): Future[js.Object] =
      service.resetImageAttribute(params).promise.toFuture
    def resetInstanceAttributeFuture(params: ResetInstanceAttributeRequest): Future[js.Object] =
      service.resetInstanceAttribute(params).promise.toFuture
    def resetNetworkInterfaceAttributeFuture(params: ResetNetworkInterfaceAttributeRequest): Future[js.Object] =
      service.resetNetworkInterfaceAttribute(params).promise.toFuture
    def resetSnapshotAttributeFuture(params: ResetSnapshotAttributeRequest): Future[js.Object] =
      service.resetSnapshotAttribute(params).promise.toFuture
    def restoreAddressToClassicFuture(params: RestoreAddressToClassicRequest): Future[RestoreAddressToClassicResult] =
      service.restoreAddressToClassic(params).promise.toFuture
    def revokeClientVpnIngressFuture(params: RevokeClientVpnIngressRequest): Future[RevokeClientVpnIngressResult] =
      service.revokeClientVpnIngress(params).promise.toFuture
    def revokeSecurityGroupEgressFuture(params: RevokeSecurityGroupEgressRequest): Future[js.Object] =
      service.revokeSecurityGroupEgress(params).promise.toFuture
    def revokeSecurityGroupIngressFuture(params: RevokeSecurityGroupIngressRequest): Future[js.Object] =
      service.revokeSecurityGroupIngress(params).promise.toFuture
    def runInstancesFuture(params: RunInstancesRequest): Future[Reservation] =
      service.runInstances(params).promise.toFuture
    def runScheduledInstancesFuture(params: RunScheduledInstancesRequest): Future[RunScheduledInstancesResult] =
      service.runScheduledInstances(params).promise.toFuture
    def searchTransitGatewayRoutesFuture(
        params: SearchTransitGatewayRoutesRequest
    ): Future[SearchTransitGatewayRoutesResult] = service.searchTransitGatewayRoutes(params).promise.toFuture
    def startInstancesFuture(params: StartInstancesRequest): Future[StartInstancesResult] =
      service.startInstances(params).promise.toFuture
    def stopInstancesFuture(params: StopInstancesRequest): Future[StopInstancesResult] =
      service.stopInstances(params).promise.toFuture
    def terminateClientVpnConnectionsFuture(
        params: TerminateClientVpnConnectionsRequest
    ): Future[TerminateClientVpnConnectionsResult] = service.terminateClientVpnConnections(params).promise.toFuture
    def terminateInstancesFuture(params: TerminateInstancesRequest): Future[TerminateInstancesResult] =
      service.terminateInstances(params).promise.toFuture
    def unassignIpv6AddressesFuture(params: UnassignIpv6AddressesRequest): Future[UnassignIpv6AddressesResult] =
      service.unassignIpv6Addresses(params).promise.toFuture
    def unassignPrivateIpAddressesFuture(params: UnassignPrivateIpAddressesRequest): Future[js.Object] =
      service.unassignPrivateIpAddresses(params).promise.toFuture
    def unmonitorInstancesFuture(params: UnmonitorInstancesRequest): Future[UnmonitorInstancesResult] =
      service.unmonitorInstances(params).promise.toFuture
    def updateSecurityGroupRuleDescriptionsEgressFuture(
        params: UpdateSecurityGroupRuleDescriptionsEgressRequest
    ): Future[UpdateSecurityGroupRuleDescriptionsEgressResult] =
      service.updateSecurityGroupRuleDescriptionsEgress(params).promise.toFuture
    def updateSecurityGroupRuleDescriptionsIngressFuture(
        params: UpdateSecurityGroupRuleDescriptionsIngressRequest
    ): Future[UpdateSecurityGroupRuleDescriptionsIngressResult] =
      service.updateSecurityGroupRuleDescriptionsIngress(params).promise.toFuture
    def withdrawByoipCidrFuture(params: WithdrawByoipCidrRequest): Future[WithdrawByoipCidrResult] =
      service.withdrawByoipCidr(params).promise.toFuture
  }
}

package ec2 {
  @js.native
  @JSImport("aws-sdk", "EC2")
  class EC2() extends js.Object {
    def this(config: AWSConfig) = this()

    def acceptReservedInstancesExchangeQuote(
        params: AcceptReservedInstancesExchangeQuoteRequest
    ): Request[AcceptReservedInstancesExchangeQuoteResult] = js.native
    def acceptTransitGatewayVpcAttachment(
        params: AcceptTransitGatewayVpcAttachmentRequest
    ): Request[AcceptTransitGatewayVpcAttachmentResult] = js.native
    def acceptVpcEndpointConnections(
        params: AcceptVpcEndpointConnectionsRequest
    ): Request[AcceptVpcEndpointConnectionsResult] = js.native
    def acceptVpcPeeringConnection(
        params: AcceptVpcPeeringConnectionRequest
    ): Request[AcceptVpcPeeringConnectionResult]                                                 = js.native
    def advertiseByoipCidr(params: AdvertiseByoipCidrRequest): Request[AdvertiseByoipCidrResult] = js.native
    def allocateAddress(params: AllocateAddressRequest): Request[AllocateAddressResult]          = js.native
    def allocateHosts(params: AllocateHostsRequest): Request[AllocateHostsResult]                = js.native
    def applySecurityGroupsToClientVpnTargetNetwork(
        params: ApplySecurityGroupsToClientVpnTargetNetworkRequest
    ): Request[ApplySecurityGroupsToClientVpnTargetNetworkResult]                                   = js.native
    def assignIpv6Addresses(params: AssignIpv6AddressesRequest): Request[AssignIpv6AddressesResult] = js.native
    def assignPrivateIpAddresses(params: AssignPrivateIpAddressesRequest): Request[js.Object]       = js.native
    def associateAddress(params: AssociateAddressRequest): Request[AssociateAddressResult]          = js.native
    def associateClientVpnTargetNetwork(
        params: AssociateClientVpnTargetNetworkRequest
    ): Request[AssociateClientVpnTargetNetworkResult]                                 = js.native
    def associateDhcpOptions(params: AssociateDhcpOptionsRequest): Request[js.Object] = js.native
    def associateIamInstanceProfile(
        params: AssociateIamInstanceProfileRequest
    ): Request[AssociateIamInstanceProfileResult]                                                   = js.native
    def associateRouteTable(params: AssociateRouteTableRequest): Request[AssociateRouteTableResult] = js.native
    def associateSubnetCidrBlock(params: AssociateSubnetCidrBlockRequest): Request[AssociateSubnetCidrBlockResult] =
      js.native
    def associateTransitGatewayRouteTable(
        params: AssociateTransitGatewayRouteTableRequest
    ): Request[AssociateTransitGatewayRouteTableResult]                                                      = js.native
    def associateVpcCidrBlock(params: AssociateVpcCidrBlockRequest): Request[AssociateVpcCidrBlockResult]    = js.native
    def attachClassicLinkVpc(params: AttachClassicLinkVpcRequest): Request[AttachClassicLinkVpcResult]       = js.native
    def attachInternetGateway(params: AttachInternetGatewayRequest): Request[js.Object]                      = js.native
    def attachNetworkInterface(params: AttachNetworkInterfaceRequest): Request[AttachNetworkInterfaceResult] = js.native
    def attachVolume(params: AttachVolumeRequest): Request[VolumeAttachment]                                 = js.native
    def attachVpnGateway(params: AttachVpnGatewayRequest): Request[AttachVpnGatewayResult]                   = js.native
    def authorizeClientVpnIngress(params: AuthorizeClientVpnIngressRequest): Request[AuthorizeClientVpnIngressResult] =
      js.native
    def authorizeSecurityGroupEgress(params: AuthorizeSecurityGroupEgressRequest): Request[js.Object]   = js.native
    def authorizeSecurityGroupIngress(params: AuthorizeSecurityGroupIngressRequest): Request[js.Object] = js.native
    def bundleInstance(params: BundleInstanceRequest): Request[BundleInstanceResult]                    = js.native
    def cancelBundleTask(params: CancelBundleTaskRequest): Request[CancelBundleTaskResult]              = js.native
    def cancelCapacityReservation(params: CancelCapacityReservationRequest): Request[CancelCapacityReservationResult] =
      js.native
    def cancelConversionTask(params: CancelConversionRequest): Request[js.Object]          = js.native
    def cancelExportTask(params: CancelExportTaskRequest): Request[js.Object]              = js.native
    def cancelImportTask(params: CancelImportTaskRequest): Request[CancelImportTaskResult] = js.native
    def cancelReservedInstancesListing(
        params: CancelReservedInstancesListingRequest
    ): Request[CancelReservedInstancesListingResult] = js.native
    def cancelSpotFleetRequests(params: CancelSpotFleetRequestsRequest): Request[CancelSpotFleetRequestsResponse] =
      js.native
    def cancelSpotInstanceRequests(
        params: CancelSpotInstanceRequestsRequest
    ): Request[CancelSpotInstanceRequestsResult]                                                             = js.native
    def confirmProductInstance(params: ConfirmProductInstanceRequest): Request[ConfirmProductInstanceResult] = js.native
    def copyFpgaImage(params: CopyFpgaImageRequest): Request[CopyFpgaImageResult]                            = js.native
    def copyImage(params: CopyImageRequest): Request[CopyImageResult]                                        = js.native
    def copySnapshot(params: CopySnapshotRequest): Request[CopySnapshotResult]                               = js.native
    def createCapacityReservation(params: CreateCapacityReservationRequest): Request[CreateCapacityReservationResult] =
      js.native
    def createClientVpnEndpoint(params: CreateClientVpnEndpointRequest): Request[CreateClientVpnEndpointResult] =
      js.native
    def createClientVpnRoute(params: CreateClientVpnRouteRequest): Request[CreateClientVpnRouteResult]    = js.native
    def createCustomerGateway(params: CreateCustomerGatewayRequest): Request[CreateCustomerGatewayResult] = js.native
    def createDefaultSubnet(params: CreateDefaultSubnetRequest): Request[CreateDefaultSubnetResult]       = js.native
    def createDefaultVpc(params: CreateDefaultVpcRequest): Request[CreateDefaultVpcResult]                = js.native
    def createDhcpOptions(params: CreateDhcpOptionsRequest): Request[CreateDhcpOptionsResult]             = js.native
    def createEgressOnlyInternetGateway(
        params: CreateEgressOnlyInternetGatewayRequest
    ): Request[CreateEgressOnlyInternetGatewayResult]                                   = js.native
    def createFleet(params: CreateFleetRequest): Request[CreateFleetResult]             = js.native
    def createFlowLogs(params: CreateFlowLogsRequest): Request[CreateFlowLogsResult]    = js.native
    def createFpgaImage(params: CreateFpgaImageRequest): Request[CreateFpgaImageResult] = js.native
    def createImage(params: CreateImageRequest): Request[CreateImageResult]             = js.native
    def createInstanceExportTask(params: CreateInstanceExportTaskRequest): Request[CreateInstanceExportTaskResult] =
      js.native
    def createInternetGateway(params: CreateInternetGatewayRequest): Request[CreateInternetGatewayResult] = js.native
    def createKeyPair(params: CreateKeyPairRequest): Request[KeyPair]                                     = js.native
    def createLaunchTemplate(params: CreateLaunchTemplateRequest): Request[CreateLaunchTemplateResult]    = js.native
    def createLaunchTemplateVersion(
        params: CreateLaunchTemplateVersionRequest
    ): Request[CreateLaunchTemplateVersionResult]                                                            = js.native
    def createNatGateway(params: CreateNatGatewayRequest): Request[CreateNatGatewayResult]                   = js.native
    def createNetworkAcl(params: CreateNetworkAclRequest): Request[CreateNetworkAclResult]                   = js.native
    def createNetworkAclEntry(params: CreateNetworkAclEntryRequest): Request[js.Object]                      = js.native
    def createNetworkInterface(params: CreateNetworkInterfaceRequest): Request[CreateNetworkInterfaceResult] = js.native
    def createNetworkInterfacePermission(
        params: CreateNetworkInterfacePermissionRequest
    ): Request[CreateNetworkInterfacePermissionResult]                                = js.native
    def createPlacementGroup(params: CreatePlacementGroupRequest): Request[js.Object] = js.native
    def createReservedInstancesListing(
        params: CreateReservedInstancesListingRequest
    ): Request[CreateReservedInstancesListingResult]                                                = js.native
    def createRoute(params: CreateRouteRequest): Request[CreateRouteResult]                         = js.native
    def createRouteTable(params: CreateRouteTableRequest): Request[CreateRouteTableResult]          = js.native
    def createSecurityGroup(params: CreateSecurityGroupRequest): Request[CreateSecurityGroupResult] = js.native
    def createSnapshot(params: CreateSnapshotRequest): Request[Snapshot]                            = js.native
    def createSpotDatafeedSubscription(
        params: CreateSpotDatafeedSubscriptionRequest
    ): Request[CreateSpotDatafeedSubscriptionResult]                                                   = js.native
    def createSubnet(params: CreateSubnetRequest): Request[CreateSubnetResult]                         = js.native
    def createTags(params: CreateTagsRequest): Request[js.Object]                                      = js.native
    def createTransitGateway(params: CreateTransitGatewayRequest): Request[CreateTransitGatewayResult] = js.native
    def createTransitGatewayRoute(params: CreateTransitGatewayRouteRequest): Request[CreateTransitGatewayRouteResult] =
      js.native
    def createTransitGatewayRouteTable(
        params: CreateTransitGatewayRouteTableRequest
    ): Request[CreateTransitGatewayRouteTableResult] = js.native
    def createTransitGatewayVpcAttachment(
        params: CreateTransitGatewayVpcAttachmentRequest
    ): Request[CreateTransitGatewayVpcAttachmentResult]                                       = js.native
    def createVolume(params: CreateVolumeRequest): Request[Volume]                            = js.native
    def createVpc(params: CreateVpcRequest): Request[CreateVpcResult]                         = js.native
    def createVpcEndpoint(params: CreateVpcEndpointRequest): Request[CreateVpcEndpointResult] = js.native
    def createVpcEndpointConnectionNotification(
        params: CreateVpcEndpointConnectionNotificationRequest
    ): Request[CreateVpcEndpointConnectionNotificationResult] = js.native
    def createVpcEndpointServiceConfiguration(
        params: CreateVpcEndpointServiceConfigurationRequest
    ): Request[CreateVpcEndpointServiceConfigurationResult] = js.native
    def createVpcPeeringConnection(
        params: CreateVpcPeeringConnectionRequest
    ): Request[CreateVpcPeeringConnectionResult]                                                    = js.native
    def createVpnConnection(params: CreateVpnConnectionRequest): Request[CreateVpnConnectionResult] = js.native
    def createVpnConnectionRoute(params: CreateVpnConnectionRouteRequest): Request[js.Object]       = js.native
    def createVpnGateway(params: CreateVpnGatewayRequest): Request[CreateVpnGatewayResult]          = js.native
    def deleteClientVpnEndpoint(params: DeleteClientVpnEndpointRequest): Request[DeleteClientVpnEndpointResult] =
      js.native
    def deleteClientVpnRoute(params: DeleteClientVpnRouteRequest): Request[DeleteClientVpnRouteResult] = js.native
    def deleteCustomerGateway(params: DeleteCustomerGatewayRequest): Request[js.Object]                = js.native
    def deleteDhcpOptions(params: DeleteDhcpOptionsRequest): Request[js.Object]                        = js.native
    def deleteEgressOnlyInternetGateway(
        params: DeleteEgressOnlyInternetGatewayRequest
    ): Request[DeleteEgressOnlyInternetGatewayResult]                                                  = js.native
    def deleteFleets(params: DeleteFleetsRequest): Request[DeleteFleetsResult]                         = js.native
    def deleteFlowLogs(params: DeleteFlowLogsRequest): Request[DeleteFlowLogsResult]                   = js.native
    def deleteFpgaImage(params: DeleteFpgaImageRequest): Request[DeleteFpgaImageResult]                = js.native
    def deleteInternetGateway(params: DeleteInternetGatewayRequest): Request[js.Object]                = js.native
    def deleteKeyPair(params: DeleteKeyPairRequest): Request[js.Object]                                = js.native
    def deleteLaunchTemplate(params: DeleteLaunchTemplateRequest): Request[DeleteLaunchTemplateResult] = js.native
    def deleteLaunchTemplateVersions(
        params: DeleteLaunchTemplateVersionsRequest
    ): Request[DeleteLaunchTemplateVersionsResult]                                         = js.native
    def deleteNatGateway(params: DeleteNatGatewayRequest): Request[DeleteNatGatewayResult] = js.native
    def deleteNetworkAcl(params: DeleteNetworkAclRequest): Request[js.Object]              = js.native
    def deleteNetworkAclEntry(params: DeleteNetworkAclEntryRequest): Request[js.Object]    = js.native
    def deleteNetworkInterface(params: DeleteNetworkInterfaceRequest): Request[js.Object]  = js.native
    def deleteNetworkInterfacePermission(
        params: DeleteNetworkInterfacePermissionRequest
    ): Request[DeleteNetworkInterfacePermissionResult]                                                    = js.native
    def deletePlacementGroup(params: DeletePlacementGroupRequest): Request[js.Object]                     = js.native
    def deleteRoute(params: DeleteRouteRequest): Request[js.Object]                                       = js.native
    def deleteRouteTable(params: DeleteRouteTableRequest): Request[js.Object]                             = js.native
    def deleteSecurityGroup(params: DeleteSecurityGroupRequest): Request[js.Object]                       = js.native
    def deleteSnapshot(params: DeleteSnapshotRequest): Request[js.Object]                                 = js.native
    def deleteSpotDatafeedSubscription(params: DeleteSpotDatafeedSubscriptionRequest): Request[js.Object] = js.native
    def deleteSubnet(params: DeleteSubnetRequest): Request[js.Object]                                     = js.native
    def deleteTags(params: DeleteTagsRequest): Request[js.Object]                                         = js.native
    def deleteTransitGateway(params: DeleteTransitGatewayRequest): Request[DeleteTransitGatewayResult]    = js.native
    def deleteTransitGatewayRoute(params: DeleteTransitGatewayRouteRequest): Request[DeleteTransitGatewayRouteResult] =
      js.native
    def deleteTransitGatewayRouteTable(
        params: DeleteTransitGatewayRouteTableRequest
    ): Request[DeleteTransitGatewayRouteTableResult] = js.native
    def deleteTransitGatewayVpcAttachment(
        params: DeleteTransitGatewayVpcAttachmentRequest
    ): Request[DeleteTransitGatewayVpcAttachmentResult]               = js.native
    def deleteVolume(params: DeleteVolumeRequest): Request[js.Object] = js.native
    def deleteVpc(params: DeleteVpcRequest): Request[js.Object]       = js.native
    def deleteVpcEndpointConnectionNotifications(
        params: DeleteVpcEndpointConnectionNotificationsRequest
    ): Request[DeleteVpcEndpointConnectionNotificationsResult] = js.native
    def deleteVpcEndpointServiceConfigurations(
        params: DeleteVpcEndpointServiceConfigurationsRequest
    ): Request[DeleteVpcEndpointServiceConfigurationsResult]                                     = js.native
    def deleteVpcEndpoints(params: DeleteVpcEndpointsRequest): Request[DeleteVpcEndpointsResult] = js.native
    def deleteVpcPeeringConnection(
        params: DeleteVpcPeeringConnectionRequest
    ): Request[DeleteVpcPeeringConnectionResult]                                                       = js.native
    def deleteVpnConnection(params: DeleteVpnConnectionRequest): Request[js.Object]                    = js.native
    def deleteVpnConnectionRoute(params: DeleteVpnConnectionRouteRequest): Request[js.Object]          = js.native
    def deleteVpnGateway(params: DeleteVpnGatewayRequest): Request[js.Object]                          = js.native
    def deprovisionByoipCidr(params: DeprovisionByoipCidrRequest): Request[DeprovisionByoipCidrResult] = js.native
    def deregisterImage(params: DeregisterImageRequest): Request[js.Object]                            = js.native
    def describeAccountAttributes(params: DescribeAccountAttributesRequest): Request[DescribeAccountAttributesResult] =
      js.native
    def describeAddresses(params: DescribeAddressesRequest): Request[DescribeAddressesResult] = js.native
    def describeAggregateIdFormat(params: DescribeAggregateIdFormatRequest): Request[DescribeAggregateIdFormatResult] =
      js.native
    def describeAvailabilityZones(params: DescribeAvailabilityZonesRequest): Request[DescribeAvailabilityZonesResult] =
      js.native
    def describeBundleTasks(params: DescribeBundleTasksRequest): Request[DescribeBundleTasksResult] = js.native
    def describeByoipCidrs(params: DescribeByoipCidrsRequest): Request[DescribeByoipCidrsResult]    = js.native
    def describeCapacityReservations(
        params: DescribeCapacityReservationsRequest
    ): Request[DescribeCapacityReservationsResult] = js.native
    def describeClassicLinkInstances(
        params: DescribeClassicLinkInstancesRequest
    ): Request[DescribeClassicLinkInstancesResult] = js.native
    def describeClientVpnAuthorizationRules(
        params: DescribeClientVpnAuthorizationRulesRequest
    ): Request[DescribeClientVpnAuthorizationRulesResult] = js.native
    def describeClientVpnConnections(
        params: DescribeClientVpnConnectionsRequest
    ): Request[DescribeClientVpnConnectionsResult] = js.native
    def describeClientVpnEndpoints(
        params: DescribeClientVpnEndpointsRequest
    ): Request[DescribeClientVpnEndpointsResult] = js.native
    def describeClientVpnRoutes(params: DescribeClientVpnRoutesRequest): Request[DescribeClientVpnRoutesResult] =
      js.native
    def describeClientVpnTargetNetworks(
        params: DescribeClientVpnTargetNetworksRequest
    ): Request[DescribeClientVpnTargetNetworksResult] = js.native
    def describeConversionTasks(params: DescribeConversionTasksRequest): Request[DescribeConversionTasksResult] =
      js.native
    def describeCustomerGateways(params: DescribeCustomerGatewaysRequest): Request[DescribeCustomerGatewaysResult] =
      js.native
    def describeDhcpOptions(params: DescribeDhcpOptionsRequest): Request[DescribeDhcpOptionsResult] = js.native
    def describeEgressOnlyInternetGateways(
        params: DescribeEgressOnlyInternetGatewaysRequest
    ): Request[DescribeEgressOnlyInternetGatewaysResult]                                                     = js.native
    def describeElasticGpus(params: DescribeElasticGpusRequest): Request[DescribeElasticGpusResult]          = js.native
    def describeExportTasks(params: DescribeExportTasksRequest): Request[DescribeExportTasksResult]          = js.native
    def describeFleetHistory(params: DescribeFleetHistoryRequest): Request[DescribeFleetHistoryResult]       = js.native
    def describeFleetInstances(params: DescribeFleetInstancesRequest): Request[DescribeFleetInstancesResult] = js.native
    def describeFleets(params: DescribeFleetsRequest): Request[DescribeFleetsResult]                         = js.native
    def describeFlowLogs(params: DescribeFlowLogsRequest): Request[DescribeFlowLogsResult]                   = js.native
    def describeFpgaImageAttribute(
        params: DescribeFpgaImageAttributeRequest
    ): Request[DescribeFpgaImageAttributeResult]                                                 = js.native
    def describeFpgaImages(params: DescribeFpgaImagesRequest): Request[DescribeFpgaImagesResult] = js.native
    def describeHostReservationOfferings(
        params: DescribeHostReservationOfferingsRequest
    ): Request[DescribeHostReservationOfferingsResult] = js.native
    def describeHostReservations(params: DescribeHostReservationsRequest): Request[DescribeHostReservationsResult] =
      js.native
    def describeHosts(params: DescribeHostsRequest): Request[DescribeHostsResult] = js.native
    def describeIamInstanceProfileAssociations(
        params: DescribeIamInstanceProfileAssociationsRequest
    ): Request[DescribeIamInstanceProfileAssociationsResult]                               = js.native
    def describeIdFormat(params: DescribeIdFormatRequest): Request[DescribeIdFormatResult] = js.native
    def describeIdentityIdFormat(params: DescribeIdentityIdFormatRequest): Request[DescribeIdentityIdFormatResult] =
      js.native
    def describeImageAttribute(params: DescribeImageAttributeRequest): Request[ImageAttribute] = js.native
    def describeImages(params: DescribeImagesRequest): Request[DescribeImagesResult]           = js.native
    def describeImportImageTasks(params: DescribeImportImageTasksRequest): Request[DescribeImportImageTasksResult] =
      js.native
    def describeImportSnapshotTasks(
        params: DescribeImportSnapshotTasksRequest
    ): Request[DescribeImportSnapshotTasksResult]                                                       = js.native
    def describeInstanceAttribute(params: DescribeInstanceAttributeRequest): Request[InstanceAttribute] = js.native
    def describeInstanceCreditSpecifications(
        params: DescribeInstanceCreditSpecificationsRequest
    ): Request[DescribeInstanceCreditSpecificationsResult]                                                   = js.native
    def describeInstanceStatus(params: DescribeInstanceStatusRequest): Request[DescribeInstanceStatusResult] = js.native
    def describeInstances(params: DescribeInstancesRequest): Request[DescribeInstancesResult]                = js.native
    def describeInternetGateways(params: DescribeInternetGatewaysRequest): Request[DescribeInternetGatewaysResult] =
      js.native
    def describeKeyPairs(params: DescribeKeyPairsRequest): Request[DescribeKeyPairsResult] = js.native
    def describeLaunchTemplateVersions(
        params: DescribeLaunchTemplateVersionsRequest
    ): Request[DescribeLaunchTemplateVersionsResult] = js.native
    def describeLaunchTemplates(params: DescribeLaunchTemplatesRequest): Request[DescribeLaunchTemplatesResult] =
      js.native
    def describeMovingAddresses(params: DescribeMovingAddressesRequest): Request[DescribeMovingAddressesResult] =
      js.native
    def describeNatGateways(params: DescribeNatGatewaysRequest): Request[DescribeNatGatewaysResult] = js.native
    def describeNetworkAcls(params: DescribeNetworkAclsRequest): Request[DescribeNetworkAclsResult] = js.native
    def describeNetworkInterfaceAttribute(
        params: DescribeNetworkInterfaceAttributeRequest
    ): Request[DescribeNetworkInterfaceAttributeResult] = js.native
    def describeNetworkInterfacePermissions(
        params: DescribeNetworkInterfacePermissionsRequest
    ): Request[DescribeNetworkInterfacePermissionsResult] = js.native
    def describeNetworkInterfaces(params: DescribeNetworkInterfacesRequest): Request[DescribeNetworkInterfacesResult] =
      js.native
    def describePlacementGroups(params: DescribePlacementGroupsRequest): Request[DescribePlacementGroupsResult] =
      js.native
    def describePrefixLists(params: DescribePrefixListsRequest): Request[DescribePrefixListsResult] = js.native
    def describePrincipalIdFormat(params: DescribePrincipalIdFormatRequest): Request[DescribePrincipalIdFormatResult] =
      js.native
    def describePublicIpv4Pools(params: DescribePublicIpv4PoolsRequest): Request[DescribePublicIpv4PoolsResult] =
      js.native
    def describeRegions(params: DescribeRegionsRequest): Request[DescribeRegionsResult] = js.native
    def describeReservedInstances(params: DescribeReservedInstancesRequest): Request[DescribeReservedInstancesResult] =
      js.native
    def describeReservedInstancesListings(
        params: DescribeReservedInstancesListingsRequest
    ): Request[DescribeReservedInstancesListingsResult] = js.native
    def describeReservedInstancesModifications(
        params: DescribeReservedInstancesModificationsRequest
    ): Request[DescribeReservedInstancesModificationsResult] = js.native
    def describeReservedInstancesOfferings(
        params: DescribeReservedInstancesOfferingsRequest
    ): Request[DescribeReservedInstancesOfferingsResult]                                            = js.native
    def describeRouteTables(params: DescribeRouteTablesRequest): Request[DescribeRouteTablesResult] = js.native
    def describeScheduledInstanceAvailability(
        params: DescribeScheduledInstanceAvailabilityRequest
    ): Request[DescribeScheduledInstanceAvailabilityResult] = js.native
    def describeScheduledInstances(
        params: DescribeScheduledInstancesRequest
    ): Request[DescribeScheduledInstancesResult] = js.native
    def describeSecurityGroupReferences(
        params: DescribeSecurityGroupReferencesRequest
    ): Request[DescribeSecurityGroupReferencesResult]                                                        = js.native
    def describeSecurityGroups(params: DescribeSecurityGroupsRequest): Request[DescribeSecurityGroupsResult] = js.native
    def describeSnapshotAttribute(params: DescribeSnapshotAttributeRequest): Request[DescribeSnapshotAttributeResult] =
      js.native
    def describeSnapshots(params: DescribeSnapshotsRequest): Request[DescribeSnapshotsResult] = js.native
    def describeSpotDatafeedSubscription(
        params: DescribeSpotDatafeedSubscriptionRequest
    ): Request[DescribeSpotDatafeedSubscriptionResult] = js.native
    def describeSpotFleetInstances(
        params: DescribeSpotFleetInstancesRequest
    ): Request[DescribeSpotFleetInstancesResponse] = js.native
    def describeSpotFleetRequestHistory(
        params: DescribeSpotFleetRequestHistoryRequest
    ): Request[DescribeSpotFleetRequestHistoryResponse] = js.native
    def describeSpotFleetRequests(
        params: DescribeSpotFleetRequestsRequest
    ): Request[DescribeSpotFleetRequestsResponse] = js.native
    def describeSpotInstanceRequests(
        params: DescribeSpotInstanceRequestsRequest
    ): Request[DescribeSpotInstanceRequestsResult] = js.native
    def describeSpotPriceHistory(params: DescribeSpotPriceHistoryRequest): Request[DescribeSpotPriceHistoryResult] =
      js.native
    def describeStaleSecurityGroups(
        params: DescribeStaleSecurityGroupsRequest
    ): Request[DescribeStaleSecurityGroupsResult]                                       = js.native
    def describeSubnets(params: DescribeSubnetsRequest): Request[DescribeSubnetsResult] = js.native
    def describeTags(params: DescribeTagsRequest): Request[DescribeTagsResult]          = js.native
    def describeTransitGatewayAttachments(
        params: DescribeTransitGatewayAttachmentsRequest
    ): Request[DescribeTransitGatewayAttachmentsResult] = js.native
    def describeTransitGatewayRouteTables(
        params: DescribeTransitGatewayRouteTablesRequest
    ): Request[DescribeTransitGatewayRouteTablesResult] = js.native
    def describeTransitGatewayVpcAttachments(
        params: DescribeTransitGatewayVpcAttachmentsRequest
    ): Request[DescribeTransitGatewayVpcAttachmentsResult] = js.native
    def describeTransitGateways(params: DescribeTransitGatewaysRequest): Request[DescribeTransitGatewaysResult] =
      js.native
    def describeVolumeAttribute(params: DescribeVolumeAttributeRequest): Request[DescribeVolumeAttributeResult] =
      js.native
    def describeVolumeStatus(params: DescribeVolumeStatusRequest): Request[DescribeVolumeStatusResult] = js.native
    def describeVolumes(params: DescribeVolumesRequest): Request[DescribeVolumesResult]                = js.native
    def describeVolumesModifications(
        params: DescribeVolumesModificationsRequest
    ): Request[DescribeVolumesModificationsResult]                                                           = js.native
    def describeVpcAttribute(params: DescribeVpcAttributeRequest): Request[DescribeVpcAttributeResult]       = js.native
    def describeVpcClassicLink(params: DescribeVpcClassicLinkRequest): Request[DescribeVpcClassicLinkResult] = js.native
    def describeVpcClassicLinkDnsSupport(
        params: DescribeVpcClassicLinkDnsSupportRequest
    ): Request[DescribeVpcClassicLinkDnsSupportResult] = js.native
    def describeVpcEndpointConnectionNotifications(
        params: DescribeVpcEndpointConnectionNotificationsRequest
    ): Request[DescribeVpcEndpointConnectionNotificationsResult] = js.native
    def describeVpcEndpointConnections(
        params: DescribeVpcEndpointConnectionsRequest
    ): Request[DescribeVpcEndpointConnectionsResult] = js.native
    def describeVpcEndpointServiceConfigurations(
        params: DescribeVpcEndpointServiceConfigurationsRequest
    ): Request[DescribeVpcEndpointServiceConfigurationsResult] = js.native
    def describeVpcEndpointServicePermissions(
        params: DescribeVpcEndpointServicePermissionsRequest
    ): Request[DescribeVpcEndpointServicePermissionsResult] = js.native
    def describeVpcEndpointServices(
        params: DescribeVpcEndpointServicesRequest
    ): Request[DescribeVpcEndpointServicesResult]                                                      = js.native
    def describeVpcEndpoints(params: DescribeVpcEndpointsRequest): Request[DescribeVpcEndpointsResult] = js.native
    def describeVpcPeeringConnections(
        params: DescribeVpcPeeringConnectionsRequest
    ): Request[DescribeVpcPeeringConnectionsResult]                                                          = js.native
    def describeVpcs(params: DescribeVpcsRequest): Request[DescribeVpcsResult]                               = js.native
    def describeVpnConnections(params: DescribeVpnConnectionsRequest): Request[DescribeVpnConnectionsResult] = js.native
    def describeVpnGateways(params: DescribeVpnGatewaysRequest): Request[DescribeVpnGatewaysResult]          = js.native
    def detachClassicLinkVpc(params: DetachClassicLinkVpcRequest): Request[DetachClassicLinkVpcResult]       = js.native
    def detachInternetGateway(params: DetachInternetGatewayRequest): Request[js.Object]                      = js.native
    def detachNetworkInterface(params: DetachNetworkInterfaceRequest): Request[js.Object]                    = js.native
    def detachVolume(params: DetachVolumeRequest): Request[VolumeAttachment]                                 = js.native
    def detachVpnGateway(params: DetachVpnGatewayRequest): Request[js.Object]                                = js.native
    def disableTransitGatewayRouteTablePropagation(
        params: DisableTransitGatewayRouteTablePropagationRequest
    ): Request[DisableTransitGatewayRouteTablePropagationResult]                                          = js.native
    def disableVgwRoutePropagation(params: DisableVgwRoutePropagationRequest): Request[js.Object]         = js.native
    def disableVpcClassicLink(params: DisableVpcClassicLinkRequest): Request[DisableVpcClassicLinkResult] = js.native
    def disableVpcClassicLinkDnsSupport(
        params: DisableVpcClassicLinkDnsSupportRequest
    ): Request[DisableVpcClassicLinkDnsSupportResult]                               = js.native
    def disassociateAddress(params: DisassociateAddressRequest): Request[js.Object] = js.native
    def disassociateClientVpnTargetNetwork(
        params: DisassociateClientVpnTargetNetworkRequest
    ): Request[DisassociateClientVpnTargetNetworkResult] = js.native
    def disassociateIamInstanceProfile(
        params: DisassociateIamInstanceProfileRequest
    ): Request[DisassociateIamInstanceProfileResult]                                      = js.native
    def disassociateRouteTable(params: DisassociateRouteTableRequest): Request[js.Object] = js.native
    def disassociateSubnetCidrBlock(
        params: DisassociateSubnetCidrBlockRequest
    ): Request[DisassociateSubnetCidrBlockResult] = js.native
    def disassociateTransitGatewayRouteTable(
        params: DisassociateTransitGatewayRouteTableRequest
    ): Request[DisassociateTransitGatewayRouteTableResult] = js.native
    def disassociateVpcCidrBlock(params: DisassociateVpcCidrBlockRequest): Request[DisassociateVpcCidrBlockResult] =
      js.native
    def enableTransitGatewayRouteTablePropagation(
        params: EnableTransitGatewayRouteTablePropagationRequest
    ): Request[EnableTransitGatewayRouteTablePropagationResult]                                        = js.native
    def enableVgwRoutePropagation(params: EnableVgwRoutePropagationRequest): Request[js.Object]        = js.native
    def enableVolumeIO(params: EnableVolumeIORequest): Request[js.Object]                              = js.native
    def enableVpcClassicLink(params: EnableVpcClassicLinkRequest): Request[EnableVpcClassicLinkResult] = js.native
    def enableVpcClassicLinkDnsSupport(
        params: EnableVpcClassicLinkDnsSupportRequest
    ): Request[EnableVpcClassicLinkDnsSupportResult] = js.native
    def exportClientVpnClientCertificateRevocationList(
        params: ExportClientVpnClientCertificateRevocationListRequest
    ): Request[ExportClientVpnClientCertificateRevocationListResult] = js.native
    def exportClientVpnClientConfiguration(
        params: ExportClientVpnClientConfigurationRequest
    ): Request[ExportClientVpnClientConfigurationResult] = js.native
    def exportTransitGatewayRoutes(
        params: ExportTransitGatewayRoutesRequest
    ): Request[ExportTransitGatewayRoutesResult]                                                       = js.native
    def getConsoleOutput(params: GetConsoleOutputRequest): Request[GetConsoleOutputResult]             = js.native
    def getConsoleScreenshot(params: GetConsoleScreenshotRequest): Request[GetConsoleScreenshotResult] = js.native
    def getHostReservationPurchasePreview(
        params: GetHostReservationPurchasePreviewRequest
    ): Request[GetHostReservationPurchasePreviewResult]                                                   = js.native
    def getLaunchTemplateData(params: GetLaunchTemplateDataRequest): Request[GetLaunchTemplateDataResult] = js.native
    def getPasswordData(params: GetPasswordDataRequest): Request[GetPasswordDataResult]                   = js.native
    def getReservedInstancesExchangeQuote(
        params: GetReservedInstancesExchangeQuoteRequest
    ): Request[GetReservedInstancesExchangeQuoteResult] = js.native
    def getTransitGatewayAttachmentPropagations(
        params: GetTransitGatewayAttachmentPropagationsRequest
    ): Request[GetTransitGatewayAttachmentPropagationsResult] = js.native
    def getTransitGatewayRouteTableAssociations(
        params: GetTransitGatewayRouteTableAssociationsRequest
    ): Request[GetTransitGatewayRouteTableAssociationsResult] = js.native
    def getTransitGatewayRouteTablePropagations(
        params: GetTransitGatewayRouteTablePropagationsRequest
    ): Request[GetTransitGatewayRouteTablePropagationsResult] = js.native
    def importClientVpnClientCertificateRevocationList(
        params: ImportClientVpnClientCertificateRevocationListRequest
    ): Request[ImportClientVpnClientCertificateRevocationListResult]                 = js.native
    def importImage(params: ImportImageRequest): Request[ImportImageResult]          = js.native
    def importInstance(params: ImportInstanceRequest): Request[ImportInstanceResult] = js.native
    def importKeyPair(params: ImportKeyPairRequest): Request[ImportKeyPairResult]    = js.native
    def importSnapshot(params: ImportSnapshotRequest): Request[ImportSnapshotResult] = js.native
    def importVolume(params: ImportVolumeRequest): Request[ImportVolumeResult]       = js.native
    def modifyCapacityReservation(params: ModifyCapacityReservationRequest): Request[ModifyCapacityReservationResult] =
      js.native
    def modifyClientVpnEndpoint(params: ModifyClientVpnEndpointRequest): Request[ModifyClientVpnEndpointResult] =
      js.native
    def modifyFleet(params: ModifyFleetRequest): Request[ModifyFleetResult] = js.native
    def modifyFpgaImageAttribute(params: ModifyFpgaImageAttributeRequest): Request[ModifyFpgaImageAttributeResult] =
      js.native
    def modifyHosts(params: ModifyHostsRequest): Request[ModifyHostsResult]                 = js.native
    def modifyIdFormat(params: ModifyIdFormatRequest): Request[js.Object]                   = js.native
    def modifyIdentityIdFormat(params: ModifyIdentityIdFormatRequest): Request[js.Object]   = js.native
    def modifyImageAttribute(params: ModifyImageAttributeRequest): Request[js.Object]       = js.native
    def modifyInstanceAttribute(params: ModifyInstanceAttributeRequest): Request[js.Object] = js.native
    def modifyInstanceCapacityReservationAttributes(
        params: ModifyInstanceCapacityReservationAttributesRequest
    ): Request[ModifyInstanceCapacityReservationAttributesResult] = js.native
    def modifyInstanceCreditSpecification(
        params: ModifyInstanceCreditSpecificationRequest
    ): Request[ModifyInstanceCreditSpecificationResult] = js.native
    def modifyInstanceEventStartTime(
        params: ModifyInstanceEventStartTimeRequest
    ): Request[ModifyInstanceEventStartTimeResult] = js.native
    def modifyInstancePlacement(params: ModifyInstancePlacementRequest): Request[ModifyInstancePlacementResult] =
      js.native
    def modifyLaunchTemplate(params: ModifyLaunchTemplateRequest): Request[ModifyLaunchTemplateResult]      = js.native
    def modifyNetworkInterfaceAttribute(params: ModifyNetworkInterfaceAttributeRequest): Request[js.Object] = js.native
    def modifyReservedInstances(params: ModifyReservedInstancesRequest): Request[ModifyReservedInstancesResult] =
      js.native
    def modifySnapshotAttribute(params: ModifySnapshotAttributeRequest): Request[js.Object] = js.native
    def modifySpotFleetRequest(params: ModifySpotFleetRequestRequest): Request[ModifySpotFleetRequestResponse] =
      js.native
    def modifySubnetAttribute(params: ModifySubnetAttributeRequest): Request[js.Object] = js.native
    def modifyTransitGatewayVpcAttachment(
        params: ModifyTransitGatewayVpcAttachmentRequest
    ): Request[ModifyTransitGatewayVpcAttachmentResult]                                       = js.native
    def modifyVolume(params: ModifyVolumeRequest): Request[ModifyVolumeResult]                = js.native
    def modifyVolumeAttribute(params: ModifyVolumeAttributeRequest): Request[js.Object]       = js.native
    def modifyVpcAttribute(params: ModifyVpcAttributeRequest): Request[js.Object]             = js.native
    def modifyVpcEndpoint(params: ModifyVpcEndpointRequest): Request[ModifyVpcEndpointResult] = js.native
    def modifyVpcEndpointConnectionNotification(
        params: ModifyVpcEndpointConnectionNotificationRequest
    ): Request[ModifyVpcEndpointConnectionNotificationResult] = js.native
    def modifyVpcEndpointServiceConfiguration(
        params: ModifyVpcEndpointServiceConfigurationRequest
    ): Request[ModifyVpcEndpointServiceConfigurationResult] = js.native
    def modifyVpcEndpointServicePermissions(
        params: ModifyVpcEndpointServicePermissionsRequest
    ): Request[ModifyVpcEndpointServicePermissionsResult] = js.native
    def modifyVpcPeeringConnectionOptions(
        params: ModifyVpcPeeringConnectionOptionsRequest
    ): Request[ModifyVpcPeeringConnectionOptionsResult]                                          = js.native
    def modifyVpcTenancy(params: ModifyVpcTenancyRequest): Request[ModifyVpcTenancyResult]       = js.native
    def monitorInstances(params: MonitorInstancesRequest): Request[MonitorInstancesResult]       = js.native
    def moveAddressToVpc(params: MoveAddressToVpcRequest): Request[MoveAddressToVpcResult]       = js.native
    def provisionByoipCidr(params: ProvisionByoipCidrRequest): Request[ProvisionByoipCidrResult] = js.native
    def purchaseHostReservation(params: PurchaseHostReservationRequest): Request[PurchaseHostReservationResult] =
      js.native
    def purchaseReservedInstancesOffering(
        params: PurchaseReservedInstancesOfferingRequest
    ): Request[PurchaseReservedInstancesOfferingResult] = js.native
    def purchaseScheduledInstances(
        params: PurchaseScheduledInstancesRequest
    ): Request[PurchaseScheduledInstancesResult]                                  = js.native
    def rebootInstances(params: RebootInstancesRequest): Request[js.Object]       = js.native
    def registerImage(params: RegisterImageRequest): Request[RegisterImageResult] = js.native
    def rejectTransitGatewayVpcAttachment(
        params: RejectTransitGatewayVpcAttachmentRequest
    ): Request[RejectTransitGatewayVpcAttachmentResult] = js.native
    def rejectVpcEndpointConnections(
        params: RejectVpcEndpointConnectionsRequest
    ): Request[RejectVpcEndpointConnectionsResult] = js.native
    def rejectVpcPeeringConnection(
        params: RejectVpcPeeringConnectionRequest
    ): Request[RejectVpcPeeringConnectionResult]                               = js.native
    def releaseAddress(params: ReleaseAddressRequest): Request[js.Object]      = js.native
    def releaseHosts(params: ReleaseHostsRequest): Request[ReleaseHostsResult] = js.native
    def replaceIamInstanceProfileAssociation(
        params: ReplaceIamInstanceProfileAssociationRequest
    ): Request[ReplaceIamInstanceProfileAssociationResult] = js.native
    def replaceNetworkAclAssociation(
        params: ReplaceNetworkAclAssociationRequest
    ): Request[ReplaceNetworkAclAssociationResult]                                        = js.native
    def replaceNetworkAclEntry(params: ReplaceNetworkAclEntryRequest): Request[js.Object] = js.native
    def replaceRoute(params: ReplaceRouteRequest): Request[js.Object]                     = js.native
    def replaceRouteTableAssociation(
        params: ReplaceRouteTableAssociationRequest
    ): Request[ReplaceRouteTableAssociationResult] = js.native
    def replaceTransitGatewayRoute(
        params: ReplaceTransitGatewayRouteRequest
    ): Request[ReplaceTransitGatewayRouteResult]                                                       = js.native
    def reportInstanceStatus(params: ReportInstanceStatusRequest): Request[js.Object]                  = js.native
    def requestSpotFleet(params: RequestSpotFleetRequest): Request[RequestSpotFleetResponse]           = js.native
    def requestSpotInstances(params: RequestSpotInstancesRequest): Request[RequestSpotInstancesResult] = js.native
    def resetFpgaImageAttribute(params: ResetFpgaImageAttributeRequest): Request[ResetFpgaImageAttributeResult] =
      js.native
    def resetImageAttribute(params: ResetImageAttributeRequest): Request[js.Object]                       = js.native
    def resetInstanceAttribute(params: ResetInstanceAttributeRequest): Request[js.Object]                 = js.native
    def resetNetworkInterfaceAttribute(params: ResetNetworkInterfaceAttributeRequest): Request[js.Object] = js.native
    def resetSnapshotAttribute(params: ResetSnapshotAttributeRequest): Request[js.Object]                 = js.native
    def restoreAddressToClassic(params: RestoreAddressToClassicRequest): Request[RestoreAddressToClassicResult] =
      js.native
    def revokeClientVpnIngress(params: RevokeClientVpnIngressRequest): Request[RevokeClientVpnIngressResult] = js.native
    def revokeSecurityGroupEgress(params: RevokeSecurityGroupEgressRequest): Request[js.Object]              = js.native
    def revokeSecurityGroupIngress(params: RevokeSecurityGroupIngressRequest): Request[js.Object]            = js.native
    def runInstances(params: RunInstancesRequest): Request[Reservation]                                      = js.native
    def runScheduledInstances(params: RunScheduledInstancesRequest): Request[RunScheduledInstancesResult]    = js.native
    def searchTransitGatewayRoutes(
        params: SearchTransitGatewayRoutesRequest
    ): Request[SearchTransitGatewayRoutesResult]                                     = js.native
    def startInstances(params: StartInstancesRequest): Request[StartInstancesResult] = js.native
    def stopInstances(params: StopInstancesRequest): Request[StopInstancesResult]    = js.native
    def terminateClientVpnConnections(
        params: TerminateClientVpnConnectionsRequest
    ): Request[TerminateClientVpnConnectionsResult]                                                       = js.native
    def terminateInstances(params: TerminateInstancesRequest): Request[TerminateInstancesResult]          = js.native
    def unassignIpv6Addresses(params: UnassignIpv6AddressesRequest): Request[UnassignIpv6AddressesResult] = js.native
    def unassignPrivateIpAddresses(params: UnassignPrivateIpAddressesRequest): Request[js.Object]         = js.native
    def unmonitorInstances(params: UnmonitorInstancesRequest): Request[UnmonitorInstancesResult]          = js.native
    def updateSecurityGroupRuleDescriptionsEgress(
        params: UpdateSecurityGroupRuleDescriptionsEgressRequest
    ): Request[UpdateSecurityGroupRuleDescriptionsEgressResult] = js.native
    def updateSecurityGroupRuleDescriptionsIngress(
        params: UpdateSecurityGroupRuleDescriptionsIngressRequest
    ): Request[UpdateSecurityGroupRuleDescriptionsIngressResult]                              = js.native
    def withdrawByoipCidr(params: WithdrawByoipCidrRequest): Request[WithdrawByoipCidrResult] = js.native
  }

  /**
    * Contains the parameters for accepting the quote.
    */
  @js.native
  trait AcceptReservedInstancesExchangeQuoteRequest extends js.Object {
    var ReservedInstanceIds: ReservedInstanceIdSet
    var DryRun: js.UndefOr[Boolean]
    var TargetConfigurations: js.UndefOr[TargetConfigurationRequestSet]
  }

  object AcceptReservedInstancesExchangeQuoteRequest {
    def apply(
        ReservedInstanceIds: ReservedInstanceIdSet,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TargetConfigurations: js.UndefOr[TargetConfigurationRequestSet] = js.undefined
    ): AcceptReservedInstancesExchangeQuoteRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReservedInstanceIds" -> ReservedInstanceIds.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TargetConfigurations" -> TargetConfigurations.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[AcceptReservedInstancesExchangeQuoteRequest]
    }
  }

  /**
    * The result of the exchange and whether it was <code>successful</code>.
    */
  @js.native
  trait AcceptReservedInstancesExchangeQuoteResult extends js.Object {
    var ExchangeId: js.UndefOr[String]
  }

  object AcceptReservedInstancesExchangeQuoteResult {
    def apply(
        ExchangeId: js.UndefOr[String] = js.undefined
    ): AcceptReservedInstancesExchangeQuoteResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ExchangeId" -> ExchangeId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[AcceptReservedInstancesExchangeQuoteResult]
    }
  }

  @js.native
  trait AcceptTransitGatewayVpcAttachmentRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AcceptTransitGatewayVpcAttachmentRequest {
    def apply(
        TransitGatewayAttachmentId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AcceptTransitGatewayVpcAttachmentRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AcceptTransitGatewayVpcAttachmentRequest]
    }
  }

  @js.native
  trait AcceptTransitGatewayVpcAttachmentResult extends js.Object {
    var TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment]
  }

  object AcceptTransitGatewayVpcAttachmentResult {
    def apply(
        TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment] = js.undefined
    ): AcceptTransitGatewayVpcAttachmentResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayVpcAttachment" -> TransitGatewayVpcAttachment.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AcceptTransitGatewayVpcAttachmentResult]
    }
  }

  @js.native
  trait AcceptVpcEndpointConnectionsRequest extends js.Object {
    var ServiceId: String
    var VpcEndpointIds: ValueStringList
    var DryRun: js.UndefOr[Boolean]
  }

  object AcceptVpcEndpointConnectionsRequest {
    def apply(
        ServiceId: String,
        VpcEndpointIds: ValueStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AcceptVpcEndpointConnectionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ServiceId"      -> ServiceId.asInstanceOf[js.Any],
        "VpcEndpointIds" -> VpcEndpointIds.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AcceptVpcEndpointConnectionsRequest]
    }
  }

  @js.native
  trait AcceptVpcEndpointConnectionsResult extends js.Object {
    var Unsuccessful: js.UndefOr[UnsuccessfulItemSet]
  }

  object AcceptVpcEndpointConnectionsResult {
    def apply(
        Unsuccessful: js.UndefOr[UnsuccessfulItemSet] = js.undefined
    ): AcceptVpcEndpointConnectionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Unsuccessful" -> Unsuccessful.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AcceptVpcEndpointConnectionsResult]
    }
  }

  @js.native
  trait AcceptVpcPeeringConnectionRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var VpcPeeringConnectionId: js.UndefOr[String]
  }

  object AcceptVpcPeeringConnectionRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        VpcPeeringConnectionId: js.UndefOr[String] = js.undefined
    ): AcceptVpcPeeringConnectionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcPeeringConnectionId" -> VpcPeeringConnectionId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AcceptVpcPeeringConnectionRequest]
    }
  }

  @js.native
  trait AcceptVpcPeeringConnectionResult extends js.Object {
    var VpcPeeringConnection: js.UndefOr[VpcPeeringConnection]
  }

  object AcceptVpcPeeringConnectionResult {
    def apply(
        VpcPeeringConnection: js.UndefOr[VpcPeeringConnection] = js.undefined
    ): AcceptVpcPeeringConnectionResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcPeeringConnection" -> VpcPeeringConnection.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AcceptVpcPeeringConnectionResult]
    }
  }

  /**
    * Describes an account attribute.
    */
  @js.native
  trait AccountAttribute extends js.Object {
    var AttributeName: js.UndefOr[String]
    var AttributeValues: js.UndefOr[AccountAttributeValueList]
  }

  object AccountAttribute {
    def apply(
        AttributeName: js.UndefOr[String] = js.undefined,
        AttributeValues: js.UndefOr[AccountAttributeValueList] = js.undefined
    ): AccountAttribute = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AttributeName" -> AttributeName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AttributeValues" -> AttributeValues.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AccountAttribute]
    }
  }

  object AccountAttributeNameEnum {
    val `supported-platforms` = "supported-platforms"
    val `default-vpc`         = "default-vpc"

    val values = IndexedSeq(`supported-platforms`, `default-vpc`)
  }

  /**
    * Describes a value of an account attribute.
    */
  @js.native
  trait AccountAttributeValue extends js.Object {
    var AttributeValue: js.UndefOr[String]
  }

  object AccountAttributeValue {
    def apply(
        AttributeValue: js.UndefOr[String] = js.undefined
    ): AccountAttributeValue = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AttributeValue" -> AttributeValue.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AccountAttributeValue]
    }
  }

  /**
    * Describes a running instance in a Spot Fleet.
    */
  @js.native
  trait ActiveInstance extends js.Object {
    var InstanceHealth: js.UndefOr[InstanceHealthStatus]
    var InstanceId: js.UndefOr[String]
    var InstanceType: js.UndefOr[String]
    var SpotInstanceRequestId: js.UndefOr[String]
  }

  object ActiveInstance {
    def apply(
        InstanceHealth: js.UndefOr[InstanceHealthStatus] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[String] = js.undefined,
        SpotInstanceRequestId: js.UndefOr[String] = js.undefined
    ): ActiveInstance = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceHealth" -> InstanceHealth.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotInstanceRequestId" -> SpotInstanceRequestId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ActiveInstance]
    }
  }

  object ActivityStatusEnum {
    val error               = "error"
    val pending_fulfillment = "pending_fulfillment"
    val pending_termination = "pending_termination"
    val fulfilled           = "fulfilled"

    val values = IndexedSeq(error, pending_fulfillment, pending_termination, fulfilled)
  }

  /**
    * Describes an Elastic IP address.
    */
  @js.native
  trait Address extends js.Object {
    var AllocationId: js.UndefOr[String]
    var AssociationId: js.UndefOr[String]
    var Domain: js.UndefOr[DomainType]
    var InstanceId: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var NetworkInterfaceOwnerId: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PublicIp: js.UndefOr[String]
    var PublicIpv4Pool: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
  }

  object Address {
    def apply(
        AllocationId: js.UndefOr[String] = js.undefined,
        AssociationId: js.UndefOr[String] = js.undefined,
        Domain: js.UndefOr[DomainType] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        NetworkInterfaceOwnerId: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined,
        PublicIpv4Pool: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): Address = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllocationId" -> AllocationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AssociationId" -> AssociationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Domain" -> Domain.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceId" -> NetworkInterfaceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceOwnerId" -> NetworkInterfaceOwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIp" -> PublicIp.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIpv4Pool" -> PublicIpv4Pool.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[Address]
    }
  }

  @js.native
  trait AdvertiseByoipCidrRequest extends js.Object {
    var Cidr: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AdvertiseByoipCidrRequest {
    def apply(
        Cidr: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AdvertiseByoipCidrRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Cidr" -> Cidr.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AdvertiseByoipCidrRequest]
    }
  }

  @js.native
  trait AdvertiseByoipCidrResult extends js.Object {
    var ByoipCidr: js.UndefOr[ByoipCidr]
  }

  object AdvertiseByoipCidrResult {
    def apply(
        ByoipCidr: js.UndefOr[ByoipCidr] = js.undefined
    ): AdvertiseByoipCidrResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ByoipCidr" -> ByoipCidr.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AdvertiseByoipCidrResult]
    }
  }

  object AffinityEnum {
    val default = "default"
    val host    = "host"

    val values = IndexedSeq(default, host)
  }

  @js.native
  trait AllocateAddressRequest extends js.Object {
    var Address: js.UndefOr[String]
    var Domain: js.UndefOr[DomainType]
    var DryRun: js.UndefOr[Boolean]
    var PublicIpv4Pool: js.UndefOr[String]
  }

  object AllocateAddressRequest {
    def apply(
        Address: js.UndefOr[String] = js.undefined,
        Domain: js.UndefOr[DomainType] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PublicIpv4Pool: js.UndefOr[String] = js.undefined
    ): AllocateAddressRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Address" -> Address.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Domain" -> Domain.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIpv4Pool" -> PublicIpv4Pool.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AllocateAddressRequest]
    }
  }

  @js.native
  trait AllocateAddressResult extends js.Object {
    var AllocationId: js.UndefOr[String]
    var Domain: js.UndefOr[DomainType]
    var PublicIp: js.UndefOr[String]
    var PublicIpv4Pool: js.UndefOr[String]
  }

  object AllocateAddressResult {
    def apply(
        AllocationId: js.UndefOr[String] = js.undefined,
        Domain: js.UndefOr[DomainType] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined,
        PublicIpv4Pool: js.UndefOr[String] = js.undefined
    ): AllocateAddressResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllocationId" -> AllocationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Domain" -> Domain.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIp" -> PublicIp.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIpv4Pool" -> PublicIpv4Pool.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AllocateAddressResult]
    }
  }

  @js.native
  trait AllocateHostsRequest extends js.Object {
    var AvailabilityZone: String
    var InstanceType: String
    var Quantity: Int
    var AutoPlacement: js.UndefOr[AutoPlacement]
    var ClientToken: js.UndefOr[String]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object AllocateHostsRequest {
    def apply(
        AvailabilityZone: String,
        InstanceType: String,
        Quantity: Int,
        AutoPlacement: js.UndefOr[AutoPlacement] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): AllocateHostsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.asInstanceOf[js.Any],
        "InstanceType"     -> InstanceType.asInstanceOf[js.Any],
        "Quantity"         -> Quantity.asInstanceOf[js.Any],
        "AutoPlacement" -> AutoPlacement.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TagSpecifications" -> TagSpecifications.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AllocateHostsRequest]
    }
  }

  /**
    * Contains the output of AllocateHosts.
    */
  @js.native
  trait AllocateHostsResult extends js.Object {
    var HostIds: js.UndefOr[ResponseHostIdList]
  }

  object AllocateHostsResult {
    def apply(
        HostIds: js.UndefOr[ResponseHostIdList] = js.undefined
    ): AllocateHostsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "HostIds" -> HostIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AllocateHostsResult]
    }
  }

  object AllocationStateEnum {
    val available                    = "available"
    val `under-assessment`           = "under-assessment"
    val `permanent-failure`          = "permanent-failure"
    val released                     = "released"
    val `released-permanent-failure` = "released-permanent-failure"

    val values = IndexedSeq(available, `under-assessment`, `permanent-failure`, released, `released-permanent-failure`)
  }

  object AllocationStrategyEnum {
    val lowestPrice = "lowestPrice"
    val diversified = "diversified"

    val values = IndexedSeq(lowestPrice, diversified)
  }

  /**
    * Describes a principal.
    */
  @js.native
  trait AllowedPrincipal extends js.Object {
    var Principal: js.UndefOr[String]
    var PrincipalType: js.UndefOr[PrincipalType]
  }

  object AllowedPrincipal {
    def apply(
        Principal: js.UndefOr[String] = js.undefined,
        PrincipalType: js.UndefOr[PrincipalType] = js.undefined
    ): AllowedPrincipal = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Principal" -> Principal.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrincipalType" -> PrincipalType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AllowedPrincipal]
    }
  }

  @js.native
  trait ApplySecurityGroupsToClientVpnTargetNetworkRequest extends js.Object {
    var ClientVpnEndpointId: String
    var SecurityGroupIds: ClientVpnSecurityGroupIdSet
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ApplySecurityGroupsToClientVpnTargetNetworkRequest {
    def apply(
        ClientVpnEndpointId: String,
        SecurityGroupIds: ClientVpnSecurityGroupIdSet,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ApplySecurityGroupsToClientVpnTargetNetworkRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "SecurityGroupIds"    -> SecurityGroupIds.asInstanceOf[js.Any],
        "VpcId"               -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ApplySecurityGroupsToClientVpnTargetNetworkRequest]
    }
  }

  @js.native
  trait ApplySecurityGroupsToClientVpnTargetNetworkResult extends js.Object {
    var SecurityGroupIds: js.UndefOr[ClientVpnSecurityGroupIdSet]
  }

  object ApplySecurityGroupsToClientVpnTargetNetworkResult {
    def apply(
        SecurityGroupIds: js.UndefOr[ClientVpnSecurityGroupIdSet] = js.undefined
    ): ApplySecurityGroupsToClientVpnTargetNetworkResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SecurityGroupIds" -> SecurityGroupIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ApplySecurityGroupsToClientVpnTargetNetworkResult]
    }
  }

  object ArchitectureValuesEnum {
    val i386   = "i386"
    val x86_64 = "x86_64"
    val arm64  = "arm64"

    val values = IndexedSeq(i386, x86_64, arm64)
  }

  @js.native
  trait AssignIpv6AddressesRequest extends js.Object {
    var NetworkInterfaceId: String
    var Ipv6AddressCount: js.UndefOr[Int]
    var Ipv6Addresses: js.UndefOr[Ipv6AddressList]
  }

  object AssignIpv6AddressesRequest {
    def apply(
        NetworkInterfaceId: String,
        Ipv6AddressCount: js.UndefOr[Int] = js.undefined,
        Ipv6Addresses: js.UndefOr[Ipv6AddressList] = js.undefined
    ): AssignIpv6AddressesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any],
        "Ipv6AddressCount" -> Ipv6AddressCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6Addresses" -> Ipv6Addresses.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssignIpv6AddressesRequest]
    }
  }

  @js.native
  trait AssignIpv6AddressesResult extends js.Object {
    var AssignedIpv6Addresses: js.UndefOr[Ipv6AddressList]
    var NetworkInterfaceId: js.UndefOr[String]
  }

  object AssignIpv6AddressesResult {
    def apply(
        AssignedIpv6Addresses: js.UndefOr[Ipv6AddressList] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined
    ): AssignIpv6AddressesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssignedIpv6Addresses" -> AssignedIpv6Addresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceId" -> NetworkInterfaceId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssignIpv6AddressesResult]
    }
  }

  /**
    * Contains the parameters for AssignPrivateIpAddresses.
    */
  @js.native
  trait AssignPrivateIpAddressesRequest extends js.Object {
    var NetworkInterfaceId: String
    var AllowReassignment: js.UndefOr[Boolean]
    var PrivateIpAddresses: js.UndefOr[PrivateIpAddressStringList]
    var SecondaryPrivateIpAddressCount: js.UndefOr[Int]
  }

  object AssignPrivateIpAddressesRequest {
    def apply(
        NetworkInterfaceId: String,
        AllowReassignment: js.UndefOr[Boolean] = js.undefined,
        PrivateIpAddresses: js.UndefOr[PrivateIpAddressStringList] = js.undefined,
        SecondaryPrivateIpAddressCount: js.UndefOr[Int] = js.undefined
    ): AssignPrivateIpAddressesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any],
        "AllowReassignment" -> AllowReassignment.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddresses" -> PrivateIpAddresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SecondaryPrivateIpAddressCount" -> SecondaryPrivateIpAddressCount.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssignPrivateIpAddressesRequest]
    }
  }

  @js.native
  trait AssociateAddressRequest extends js.Object {
    var AllocationId: js.UndefOr[String]
    var AllowReassociation: js.UndefOr[Boolean]
    var DryRun: js.UndefOr[Boolean]
    var InstanceId: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PublicIp: js.UndefOr[String]
  }

  object AssociateAddressRequest {
    def apply(
        AllocationId: js.UndefOr[String] = js.undefined,
        AllowReassociation: js.UndefOr[Boolean] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): AssociateAddressRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllocationId" -> AllocationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AllowReassociation" -> AllowReassociation.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceId" -> NetworkInterfaceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIp" -> PublicIp.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateAddressRequest]
    }
  }

  @js.native
  trait AssociateAddressResult extends js.Object {
    var AssociationId: js.UndefOr[String]
  }

  object AssociateAddressResult {
    def apply(
        AssociationId: js.UndefOr[String] = js.undefined
    ): AssociateAddressResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociationId" -> AssociationId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateAddressResult]
    }
  }

  @js.native
  trait AssociateClientVpnTargetNetworkRequest extends js.Object {
    var ClientVpnEndpointId: String
    var SubnetId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AssociateClientVpnTargetNetworkRequest {
    def apply(
        ClientVpnEndpointId: String,
        SubnetId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AssociateClientVpnTargetNetworkRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "SubnetId"            -> SubnetId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateClientVpnTargetNetworkRequest]
    }
  }

  @js.native
  trait AssociateClientVpnTargetNetworkResult extends js.Object {
    var AssociationId: js.UndefOr[String]
    var Status: js.UndefOr[AssociationStatus]
  }

  object AssociateClientVpnTargetNetworkResult {
    def apply(
        AssociationId: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[AssociationStatus] = js.undefined
    ): AssociateClientVpnTargetNetworkResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociationId" -> AssociationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateClientVpnTargetNetworkResult]
    }
  }

  @js.native
  trait AssociateDhcpOptionsRequest extends js.Object {
    var DhcpOptionsId: String
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AssociateDhcpOptionsRequest {
    def apply(
        DhcpOptionsId: String,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AssociateDhcpOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DhcpOptionsId" -> DhcpOptionsId.asInstanceOf[js.Any],
        "VpcId"         -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateDhcpOptionsRequest]
    }
  }

  @js.native
  trait AssociateIamInstanceProfileRequest extends js.Object {
    var IamInstanceProfile: IamInstanceProfileSpecification
    var InstanceId: String
  }

  object AssociateIamInstanceProfileRequest {
    def apply(
        IamInstanceProfile: IamInstanceProfileSpecification,
        InstanceId: String
    ): AssociateIamInstanceProfileRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "IamInstanceProfile" -> IamInstanceProfile.asInstanceOf[js.Any],
        "InstanceId"         -> InstanceId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateIamInstanceProfileRequest]
    }
  }

  @js.native
  trait AssociateIamInstanceProfileResult extends js.Object {
    var IamInstanceProfileAssociation: js.UndefOr[IamInstanceProfileAssociation]
  }

  object AssociateIamInstanceProfileResult {
    def apply(
        IamInstanceProfileAssociation: js.UndefOr[IamInstanceProfileAssociation] = js.undefined
    ): AssociateIamInstanceProfileResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "IamInstanceProfileAssociation" -> IamInstanceProfileAssociation.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateIamInstanceProfileResult]
    }
  }

  @js.native
  trait AssociateRouteTableRequest extends js.Object {
    var RouteTableId: String
    var SubnetId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AssociateRouteTableRequest {
    def apply(
        RouteTableId: String,
        SubnetId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AssociateRouteTableRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "RouteTableId" -> RouteTableId.asInstanceOf[js.Any],
        "SubnetId"     -> SubnetId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateRouteTableRequest]
    }
  }

  @js.native
  trait AssociateRouteTableResult extends js.Object {
    var AssociationId: js.UndefOr[String]
  }

  object AssociateRouteTableResult {
    def apply(
        AssociationId: js.UndefOr[String] = js.undefined
    ): AssociateRouteTableResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociationId" -> AssociationId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateRouteTableResult]
    }
  }

  @js.native
  trait AssociateSubnetCidrBlockRequest extends js.Object {
    var Ipv6CidrBlock: String
    var SubnetId: String
  }

  object AssociateSubnetCidrBlockRequest {
    def apply(
        Ipv6CidrBlock: String,
        SubnetId: String
    ): AssociateSubnetCidrBlockRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Ipv6CidrBlock" -> Ipv6CidrBlock.asInstanceOf[js.Any],
        "SubnetId"      -> SubnetId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateSubnetCidrBlockRequest]
    }
  }

  @js.native
  trait AssociateSubnetCidrBlockResult extends js.Object {
    var Ipv6CidrBlockAssociation: js.UndefOr[SubnetIpv6CidrBlockAssociation]
    var SubnetId: js.UndefOr[String]
  }

  object AssociateSubnetCidrBlockResult {
    def apply(
        Ipv6CidrBlockAssociation: js.UndefOr[SubnetIpv6CidrBlockAssociation] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined
    ): AssociateSubnetCidrBlockResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Ipv6CidrBlockAssociation" -> Ipv6CidrBlockAssociation.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateSubnetCidrBlockResult]
    }
  }

  @js.native
  trait AssociateTransitGatewayRouteTableRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AssociateTransitGatewayRouteTableRequest {
    def apply(
        TransitGatewayAttachmentId: String,
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AssociateTransitGatewayRouteTableRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateTransitGatewayRouteTableRequest]
    }
  }

  @js.native
  trait AssociateTransitGatewayRouteTableResult extends js.Object {
    var Association: js.UndefOr[TransitGatewayAssociation]
  }

  object AssociateTransitGatewayRouteTableResult {
    def apply(
        Association: js.UndefOr[TransitGatewayAssociation] = js.undefined
    ): AssociateTransitGatewayRouteTableResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Association" -> Association.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateTransitGatewayRouteTableResult]
    }
  }

  @js.native
  trait AssociateVpcCidrBlockRequest extends js.Object {
    var VpcId: String
    var AmazonProvidedIpv6CidrBlock: js.UndefOr[Boolean]
    var CidrBlock: js.UndefOr[String]
  }

  object AssociateVpcCidrBlockRequest {
    def apply(
        VpcId: String,
        AmazonProvidedIpv6CidrBlock: js.UndefOr[Boolean] = js.undefined,
        CidrBlock: js.UndefOr[String] = js.undefined
    ): AssociateVpcCidrBlockRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId" -> VpcId.asInstanceOf[js.Any],
        "AmazonProvidedIpv6CidrBlock" -> AmazonProvidedIpv6CidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CidrBlock" -> CidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateVpcCidrBlockRequest]
    }
  }

  @js.native
  trait AssociateVpcCidrBlockResult extends js.Object {
    var CidrBlockAssociation: js.UndefOr[VpcCidrBlockAssociation]
    var Ipv6CidrBlockAssociation: js.UndefOr[VpcIpv6CidrBlockAssociation]
    var VpcId: js.UndefOr[String]
  }

  object AssociateVpcCidrBlockResult {
    def apply(
        CidrBlockAssociation: js.UndefOr[VpcCidrBlockAssociation] = js.undefined,
        Ipv6CidrBlockAssociation: js.UndefOr[VpcIpv6CidrBlockAssociation] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): AssociateVpcCidrBlockResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CidrBlockAssociation" -> CidrBlockAssociation.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6CidrBlockAssociation" -> Ipv6CidrBlockAssociation.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociateVpcCidrBlockResult]
    }
  }

  object AssociatedNetworkTypeEnum {
    val vpc = "vpc"

    val values = IndexedSeq(vpc)
  }

  /**
    * Describes a target network that is associated with a Client VPN endpoint. A target network is a subnet in a VPC.
    */
  @js.native
  trait AssociatedTargetNetwork extends js.Object {
    var NetworkId: js.UndefOr[String]
    var NetworkType: js.UndefOr[AssociatedNetworkType]
  }

  object AssociatedTargetNetwork {
    def apply(
        NetworkId: js.UndefOr[String] = js.undefined,
        NetworkType: js.UndefOr[AssociatedNetworkType] = js.undefined
    ): AssociatedTargetNetwork = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkId" -> NetworkId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkType" -> NetworkType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociatedTargetNetwork]
    }
  }

  /**
    * Describes the state of a target network association.
    */
  @js.native
  trait AssociationStatus extends js.Object {
    var Code: js.UndefOr[AssociationStatusCode]
    var Message: js.UndefOr[String]
  }

  object AssociationStatus {
    def apply(
        Code: js.UndefOr[AssociationStatusCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): AssociationStatus = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Message" -> Message.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AssociationStatus]
    }
  }

  object AssociationStatusCodeEnum {
    val associating          = "associating"
    val associated           = "associated"
    val `association-failed` = "association-failed"
    val disassociating       = "disassociating"
    val disassociated        = "disassociated"

    val values = IndexedSeq(associating, associated, `association-failed`, disassociating, disassociated)
  }

  @js.native
  trait AttachClassicLinkVpcRequest extends js.Object {
    var Groups: GroupIdStringList
    var InstanceId: String
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AttachClassicLinkVpcRequest {
    def apply(
        Groups: GroupIdStringList,
        InstanceId: String,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AttachClassicLinkVpcRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Groups"     -> Groups.asInstanceOf[js.Any],
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "VpcId"      -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AttachClassicLinkVpcRequest]
    }
  }

  @js.native
  trait AttachClassicLinkVpcResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object AttachClassicLinkVpcResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): AttachClassicLinkVpcResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AttachClassicLinkVpcResult]
    }
  }

  @js.native
  trait AttachInternetGatewayRequest extends js.Object {
    var InternetGatewayId: String
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AttachInternetGatewayRequest {
    def apply(
        InternetGatewayId: String,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AttachInternetGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InternetGatewayId" -> InternetGatewayId.asInstanceOf[js.Any],
        "VpcId"             -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AttachInternetGatewayRequest]
    }
  }

  /**
    * Contains the parameters for AttachNetworkInterface.
    */
  @js.native
  trait AttachNetworkInterfaceRequest extends js.Object {
    var DeviceIndex: Int
    var InstanceId: String
    var NetworkInterfaceId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AttachNetworkInterfaceRequest {
    def apply(
        DeviceIndex: Int,
        InstanceId: String,
        NetworkInterfaceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AttachNetworkInterfaceRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DeviceIndex"        -> DeviceIndex.asInstanceOf[js.Any],
        "InstanceId"         -> InstanceId.asInstanceOf[js.Any],
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AttachNetworkInterfaceRequest]
    }
  }

  /**
    * Contains the output of AttachNetworkInterface.
    */
  @js.native
  trait AttachNetworkInterfaceResult extends js.Object {
    var AttachmentId: js.UndefOr[String]
  }

  object AttachNetworkInterfaceResult {
    def apply(
        AttachmentId: js.UndefOr[String] = js.undefined
    ): AttachNetworkInterfaceResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AttachmentId" -> AttachmentId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AttachNetworkInterfaceResult]
    }
  }

  /**
    * Contains the parameters for AttachVolume.
    */
  @js.native
  trait AttachVolumeRequest extends js.Object {
    var Device: String
    var InstanceId: String
    var VolumeId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AttachVolumeRequest {
    def apply(
        Device: String,
        InstanceId: String,
        VolumeId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AttachVolumeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Device"     -> Device.asInstanceOf[js.Any],
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "VolumeId"   -> VolumeId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AttachVolumeRequest]
    }
  }

  /**
    * Contains the parameters for AttachVpnGateway.
    */
  @js.native
  trait AttachVpnGatewayRequest extends js.Object {
    var VpcId: String
    var VpnGatewayId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AttachVpnGatewayRequest {
    def apply(
        VpcId: String,
        VpnGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AttachVpnGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId"        -> VpcId.asInstanceOf[js.Any],
        "VpnGatewayId" -> VpnGatewayId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AttachVpnGatewayRequest]
    }
  }

  /**
    * Contains the output of AttachVpnGateway.
    */
  @js.native
  trait AttachVpnGatewayResult extends js.Object {
    var VpcAttachment: js.UndefOr[VpcAttachment]
  }

  object AttachVpnGatewayResult {
    def apply(
        VpcAttachment: js.UndefOr[VpcAttachment] = js.undefined
    ): AttachVpnGatewayResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcAttachment" -> VpcAttachment.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AttachVpnGatewayResult]
    }
  }

  object AttachmentStatusEnum {
    val attaching = "attaching"
    val attached  = "attached"
    val detaching = "detaching"
    val detached  = "detached"

    val values = IndexedSeq(attaching, attached, detaching, detached)
  }

  /**
    * Describes a value for a resource attribute that is a Boolean value.
    */
  @js.native
  trait AttributeBooleanValue extends js.Object {
    var Value: js.UndefOr[Boolean]
  }

  object AttributeBooleanValue {
    def apply(
        Value: js.UndefOr[Boolean] = js.undefined
    ): AttributeBooleanValue = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Value" -> Value.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AttributeBooleanValue]
    }
  }

  /**
    * Describes a value for a resource attribute that is a String.
    */
  @js.native
  trait AttributeValue extends js.Object {
    var Value: js.UndefOr[String]
  }

  object AttributeValue {
    def apply(
        Value: js.UndefOr[String] = js.undefined
    ): AttributeValue = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Value" -> Value.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AttributeValue]
    }
  }

  /**
    * Information about an authorization rule.
    */
  @js.native
  trait AuthorizationRule extends js.Object {
    var AccessAll: js.UndefOr[Boolean]
    var ClientVpnEndpointId: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DestinationCidr: js.UndefOr[String]
    var GroupId: js.UndefOr[String]
    var Status: js.UndefOr[ClientVpnAuthorizationRuleStatus]
  }

  object AuthorizationRule {
    def apply(
        AccessAll: js.UndefOr[Boolean] = js.undefined,
        ClientVpnEndpointId: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DestinationCidr: js.UndefOr[String] = js.undefined,
        GroupId: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[ClientVpnAuthorizationRuleStatus] = js.undefined
    ): AuthorizationRule = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AccessAll" -> AccessAll.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ClientVpnEndpointId" -> ClientVpnEndpointId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DestinationCidr" -> DestinationCidr.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupId" -> GroupId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AuthorizationRule]
    }
  }

  @js.native
  trait AuthorizeClientVpnIngressRequest extends js.Object {
    var ClientVpnEndpointId: String
    var TargetNetworkCidr: String
    var AccessGroupId: js.UndefOr[String]
    var AuthorizeAllGroups: js.UndefOr[Boolean]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object AuthorizeClientVpnIngressRequest {
    def apply(
        ClientVpnEndpointId: String,
        TargetNetworkCidr: String,
        AccessGroupId: js.UndefOr[String] = js.undefined,
        AuthorizeAllGroups: js.UndefOr[Boolean] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AuthorizeClientVpnIngressRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "TargetNetworkCidr"   -> TargetNetworkCidr.asInstanceOf[js.Any],
        "AccessGroupId" -> AccessGroupId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AuthorizeAllGroups" -> AuthorizeAllGroups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AuthorizeClientVpnIngressRequest]
    }
  }

  @js.native
  trait AuthorizeClientVpnIngressResult extends js.Object {
    var Status: js.UndefOr[ClientVpnAuthorizationRuleStatus]
  }

  object AuthorizeClientVpnIngressResult {
    def apply(
        Status: js.UndefOr[ClientVpnAuthorizationRuleStatus] = js.undefined
    ): AuthorizeClientVpnIngressResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AuthorizeClientVpnIngressResult]
    }
  }

  @js.native
  trait AuthorizeSecurityGroupEgressRequest extends js.Object {
    var GroupId: String
    var CidrIp: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var FromPort: js.UndefOr[Int]
    var IpPermissions: js.UndefOr[IpPermissionList]
    var IpProtocol: js.UndefOr[String]
    var SourceSecurityGroupName: js.UndefOr[String]
    var SourceSecurityGroupOwnerId: js.UndefOr[String]
    var ToPort: js.UndefOr[Int]
  }

  object AuthorizeSecurityGroupEgressRequest {
    def apply(
        GroupId: String,
        CidrIp: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        FromPort: js.UndefOr[Int] = js.undefined,
        IpPermissions: js.UndefOr[IpPermissionList] = js.undefined,
        IpProtocol: js.UndefOr[String] = js.undefined,
        SourceSecurityGroupName: js.UndefOr[String] = js.undefined,
        SourceSecurityGroupOwnerId: js.UndefOr[String] = js.undefined,
        ToPort: js.UndefOr[Int] = js.undefined
    ): AuthorizeSecurityGroupEgressRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "GroupId" -> GroupId.asInstanceOf[js.Any],
        "CidrIp" -> CidrIp.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FromPort" -> FromPort.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IpPermissions" -> IpPermissions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IpProtocol" -> IpProtocol.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SourceSecurityGroupName" -> SourceSecurityGroupName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SourceSecurityGroupOwnerId" -> SourceSecurityGroupOwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ToPort" -> ToPort.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AuthorizeSecurityGroupEgressRequest]
    }
  }

  @js.native
  trait AuthorizeSecurityGroupIngressRequest extends js.Object {
    var CidrIp: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var FromPort: js.UndefOr[Int]
    var GroupId: js.UndefOr[String]
    var GroupName: js.UndefOr[String]
    var IpPermissions: js.UndefOr[IpPermissionList]
    var IpProtocol: js.UndefOr[String]
    var SourceSecurityGroupName: js.UndefOr[String]
    var SourceSecurityGroupOwnerId: js.UndefOr[String]
    var ToPort: js.UndefOr[Int]
  }

  object AuthorizeSecurityGroupIngressRequest {
    def apply(
        CidrIp: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        FromPort: js.UndefOr[Int] = js.undefined,
        GroupId: js.UndefOr[String] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined,
        IpPermissions: js.UndefOr[IpPermissionList] = js.undefined,
        IpProtocol: js.UndefOr[String] = js.undefined,
        SourceSecurityGroupName: js.UndefOr[String] = js.undefined,
        SourceSecurityGroupOwnerId: js.UndefOr[String] = js.undefined,
        ToPort: js.UndefOr[Int] = js.undefined
    ): AuthorizeSecurityGroupIngressRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CidrIp" -> CidrIp.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FromPort" -> FromPort.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupId" -> GroupId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupName" -> GroupName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IpPermissions" -> IpPermissions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IpProtocol" -> IpProtocol.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SourceSecurityGroupName" -> SourceSecurityGroupName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SourceSecurityGroupOwnerId" -> SourceSecurityGroupOwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ToPort" -> ToPort.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AuthorizeSecurityGroupIngressRequest]
    }
  }

  object AutoAcceptSharedAttachmentsValueEnum {
    val enable  = "enable"
    val disable = "disable"

    val values = IndexedSeq(enable, disable)
  }

  object AutoPlacementEnum {
    val on  = "on"
    val off = "off"

    val values = IndexedSeq(on, off)
  }

  /**
    * Describes an Availability Zone.
    */
  @js.native
  trait AvailabilityZone extends js.Object {
    var Messages: js.UndefOr[AvailabilityZoneMessageList]
    var RegionName: js.UndefOr[String]
    var State: js.UndefOr[AvailabilityZoneState]
    var ZoneId: js.UndefOr[String]
    var ZoneName: js.UndefOr[String]
  }

  object AvailabilityZone {
    def apply(
        Messages: js.UndefOr[AvailabilityZoneMessageList] = js.undefined,
        RegionName: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[AvailabilityZoneState] = js.undefined,
        ZoneId: js.UndefOr[String] = js.undefined,
        ZoneName: js.UndefOr[String] = js.undefined
    ): AvailabilityZone = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Messages" -> Messages.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RegionName" -> RegionName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ZoneId" -> ZoneId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ZoneName" -> ZoneName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AvailabilityZone]
    }
  }

  /**
    * Describes a message about an Availability Zone.
    */
  @js.native
  trait AvailabilityZoneMessage extends js.Object {
    var Message: js.UndefOr[String]
  }

  object AvailabilityZoneMessage {
    def apply(
        Message: js.UndefOr[String] = js.undefined
    ): AvailabilityZoneMessage = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Message" -> Message.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AvailabilityZoneMessage]
    }
  }

  object AvailabilityZoneStateEnum {
    val available   = "available"
    val information = "information"
    val impaired    = "impaired"
    val unavailable = "unavailable"

    val values = IndexedSeq(available, information, impaired, unavailable)
  }

  /**
    * The capacity information for instances launched onto the Dedicated Host.
    */
  @js.native
  trait AvailableCapacity extends js.Object {
    var AvailableInstanceCapacity: js.UndefOr[AvailableInstanceCapacityList]
    var AvailableVCpus: js.UndefOr[Int]
  }

  object AvailableCapacity {
    def apply(
        AvailableInstanceCapacity: js.UndefOr[AvailableInstanceCapacityList] = js.undefined,
        AvailableVCpus: js.UndefOr[Int] = js.undefined
    ): AvailableCapacity = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailableInstanceCapacity" -> AvailableInstanceCapacity.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AvailableVCpus" -> AvailableVCpus.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[AvailableCapacity]
    }
  }

  object BatchStateEnum {
    val submitted             = "submitted"
    val active                = "active"
    val cancelled             = "cancelled"
    val failed                = "failed"
    val cancelled_running     = "cancelled_running"
    val cancelled_terminating = "cancelled_terminating"
    val modifying             = "modifying"

    val values = IndexedSeq(submitted, active, cancelled, failed, cancelled_running, cancelled_terminating, modifying)
  }

  @js.native
  trait BlobAttributeValue extends js.Object {
    var Value: js.UndefOr[Blob]
  }

  object BlobAttributeValue {
    def apply(
        Value: js.UndefOr[Blob] = js.undefined
    ): BlobAttributeValue = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Value" -> Value.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[BlobAttributeValue]
    }
  }

  /**
    * Describes a block device mapping.
    */
  @js.native
  trait BlockDeviceMapping extends js.Object {
    var DeviceName: js.UndefOr[String]
    var Ebs: js.UndefOr[EbsBlockDevice]
    var NoDevice: js.UndefOr[String]
    var VirtualName: js.UndefOr[String]
  }

  object BlockDeviceMapping {
    def apply(
        DeviceName: js.UndefOr[String] = js.undefined,
        Ebs: js.UndefOr[EbsBlockDevice] = js.undefined,
        NoDevice: js.UndefOr[String] = js.undefined,
        VirtualName: js.UndefOr[String] = js.undefined
    ): BlockDeviceMapping = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DeviceName" -> DeviceName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ebs" -> Ebs.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NoDevice" -> NoDevice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VirtualName" -> VirtualName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[BlockDeviceMapping]
    }
  }

  /**
    * Contains the parameters for BundleInstance.
    */
  @js.native
  trait BundleInstanceRequest extends js.Object {
    var InstanceId: String
    var Storage: Storage
    var DryRun: js.UndefOr[Boolean]
  }

  object BundleInstanceRequest {
    def apply(
        InstanceId: String,
        Storage: Storage,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): BundleInstanceRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "Storage"    -> Storage.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[BundleInstanceRequest]
    }
  }

  /**
    * Contains the output of BundleInstance.
    */
  @js.native
  trait BundleInstanceResult extends js.Object {
    var BundleTask: js.UndefOr[BundleTask]
  }

  object BundleInstanceResult {
    def apply(
        BundleTask: js.UndefOr[BundleTask] = js.undefined
    ): BundleInstanceResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "BundleTask" -> BundleTask.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[BundleInstanceResult]
    }
  }

  /**
    * Describes a bundle task.
    */
  @js.native
  trait BundleTask extends js.Object {
    var BundleId: js.UndefOr[String]
    var BundleTaskError: js.UndefOr[BundleTaskError]
    var InstanceId: js.UndefOr[String]
    var Progress: js.UndefOr[String]
    var StartTime: js.UndefOr[DateTime]
    var State: js.UndefOr[BundleTaskState]
    var Storage: js.UndefOr[Storage]
    var UpdateTime: js.UndefOr[DateTime]
  }

  object BundleTask {
    def apply(
        BundleId: js.UndefOr[String] = js.undefined,
        BundleTaskError: js.UndefOr[BundleTaskError] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        Progress: js.UndefOr[String] = js.undefined,
        StartTime: js.UndefOr[DateTime] = js.undefined,
        State: js.UndefOr[BundleTaskState] = js.undefined,
        Storage: js.UndefOr[Storage] = js.undefined,
        UpdateTime: js.UndefOr[DateTime] = js.undefined
    ): BundleTask = {
      val _fields = IndexedSeq[(String, js.Any)](
        "BundleId" -> BundleId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "BundleTaskError" -> BundleTaskError.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Progress" -> Progress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StartTime" -> StartTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Storage" -> Storage.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UpdateTime" -> UpdateTime.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[BundleTask]
    }
  }

  /**
    * Describes an error for <a>BundleInstance</a>.
    */
  @js.native
  trait BundleTaskError extends js.Object {
    var Code: js.UndefOr[String]
    var Message: js.UndefOr[String]
  }

  object BundleTaskError {
    def apply(
        Code: js.UndefOr[String] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): BundleTaskError = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Message" -> Message.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[BundleTaskError]
    }
  }

  object BundleTaskStateEnum {
    val pending                = "pending"
    val `waiting-for-shutdown` = "waiting-for-shutdown"
    val bundling               = "bundling"
    val storing                = "storing"
    val cancelling             = "cancelling"
    val complete               = "complete"
    val failed                 = "failed"

    val values = IndexedSeq(pending, `waiting-for-shutdown`, bundling, storing, cancelling, complete, failed)
  }

  /**
    * Information about an address range that is provisioned for use with your AWS resources through bring your own IP addresses (BYOIP).
    */
  @js.native
  trait ByoipCidr extends js.Object {
    var Cidr: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var State: js.UndefOr[ByoipCidrState]
    var StatusMessage: js.UndefOr[String]
  }

  object ByoipCidr {
    def apply(
        Cidr: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[ByoipCidrState] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined
    ): ByoipCidr = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Cidr" -> Cidr.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StatusMessage" -> StatusMessage.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ByoipCidr]
    }
  }

  object ByoipCidrStateEnum {
    val advertised            = "advertised"
    val deprovisioned         = "deprovisioned"
    val `failed-deprovision`  = "failed-deprovision"
    val `failed-provision`    = "failed-provision"
    val `pending-deprovision` = "pending-deprovision"
    val `pending-provision`   = "pending-provision"
    val provisioned           = "provisioned"

    val values = IndexedSeq(
      advertised,
      deprovisioned,
      `failed-deprovision`,
      `failed-provision`,
      `pending-deprovision`,
      `pending-provision`,
      provisioned
    )
  }

  object CancelBatchErrorCodeEnum {
    val fleetRequestIdDoesNotExist        = "fleetRequestIdDoesNotExist"
    val fleetRequestIdMalformed           = "fleetRequestIdMalformed"
    val fleetRequestNotInCancellableState = "fleetRequestNotInCancellableState"
    val unexpectedError                   = "unexpectedError"

    val values = IndexedSeq(
      fleetRequestIdDoesNotExist,
      fleetRequestIdMalformed,
      fleetRequestNotInCancellableState,
      unexpectedError
    )
  }

  /**
    * Contains the parameters for CancelBundleTask.
    */
  @js.native
  trait CancelBundleTaskRequest extends js.Object {
    var BundleId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object CancelBundleTaskRequest {
    def apply(
        BundleId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CancelBundleTaskRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "BundleId" -> BundleId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelBundleTaskRequest]
    }
  }

  /**
    * Contains the output of CancelBundleTask.
    */
  @js.native
  trait CancelBundleTaskResult extends js.Object {
    var BundleTask: js.UndefOr[BundleTask]
  }

  object CancelBundleTaskResult {
    def apply(
        BundleTask: js.UndefOr[BundleTask] = js.undefined
    ): CancelBundleTaskResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "BundleTask" -> BundleTask.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelBundleTaskResult]
    }
  }

  @js.native
  trait CancelCapacityReservationRequest extends js.Object {
    var CapacityReservationId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object CancelCapacityReservationRequest {
    def apply(
        CapacityReservationId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CancelCapacityReservationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CapacityReservationId" -> CapacityReservationId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelCapacityReservationRequest]
    }
  }

  @js.native
  trait CancelCapacityReservationResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object CancelCapacityReservationResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): CancelCapacityReservationResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelCapacityReservationResult]
    }
  }

  /**
    * Contains the parameters for CancelConversionTask.
    */
  @js.native
  trait CancelConversionRequest extends js.Object {
    var ConversionTaskId: String
    var DryRun: js.UndefOr[Boolean]
    var ReasonMessage: js.UndefOr[String]
  }

  object CancelConversionRequest {
    def apply(
        ConversionTaskId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ReasonMessage: js.UndefOr[String] = js.undefined
    ): CancelConversionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ConversionTaskId" -> ConversionTaskId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReasonMessage" -> ReasonMessage.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelConversionRequest]
    }
  }

  /**
    * Contains the parameters for CancelExportTask.
    */
  @js.native
  trait CancelExportTaskRequest extends js.Object {
    var ExportTaskId: String
  }

  object CancelExportTaskRequest {
    def apply(
        ExportTaskId: String
    ): CancelExportTaskRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ExportTaskId" -> ExportTaskId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelExportTaskRequest]
    }
  }

  /**
    * Contains the parameters for CancelImportTask.
    */
  @js.native
  trait CancelImportTaskRequest extends js.Object {
    var CancelReason: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var ImportTaskId: js.UndefOr[String]
  }

  object CancelImportTaskRequest {
    def apply(
        CancelReason: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ImportTaskId: js.UndefOr[String] = js.undefined
    ): CancelImportTaskRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CancelReason" -> CancelReason.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImportTaskId" -> ImportTaskId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelImportTaskRequest]
    }
  }

  /**
    * Contains the output for CancelImportTask.
    */
  @js.native
  trait CancelImportTaskResult extends js.Object {
    var ImportTaskId: js.UndefOr[String]
    var PreviousState: js.UndefOr[String]
    var State: js.UndefOr[String]
  }

  object CancelImportTaskResult {
    def apply(
        ImportTaskId: js.UndefOr[String] = js.undefined,
        PreviousState: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[String] = js.undefined
    ): CancelImportTaskResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ImportTaskId" -> ImportTaskId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PreviousState" -> PreviousState.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelImportTaskResult]
    }
  }

  /**
    * Contains the parameters for CancelReservedInstancesListing.
    */
  @js.native
  trait CancelReservedInstancesListingRequest extends js.Object {
    var ReservedInstancesListingId: String
  }

  object CancelReservedInstancesListingRequest {
    def apply(
        ReservedInstancesListingId: String
    ): CancelReservedInstancesListingRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReservedInstancesListingId" -> ReservedInstancesListingId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelReservedInstancesListingRequest]
    }
  }

  /**
    * Contains the output of CancelReservedInstancesListing.
    */
  @js.native
  trait CancelReservedInstancesListingResult extends js.Object {
    var ReservedInstancesListings: js.UndefOr[ReservedInstancesListingList]
  }

  object CancelReservedInstancesListingResult {
    def apply(
        ReservedInstancesListings: js.UndefOr[ReservedInstancesListingList] = js.undefined
    ): CancelReservedInstancesListingResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReservedInstancesListings" -> ReservedInstancesListings.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelReservedInstancesListingResult]
    }
  }

  /**
    * Describes a Spot Fleet error.
    */
  @js.native
  trait CancelSpotFleetRequestsError extends js.Object {
    var Code: js.UndefOr[CancelBatchErrorCode]
    var Message: js.UndefOr[String]
  }

  object CancelSpotFleetRequestsError {
    def apply(
        Code: js.UndefOr[CancelBatchErrorCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): CancelSpotFleetRequestsError = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Message" -> Message.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelSpotFleetRequestsError]
    }
  }

  /**
    * Describes a Spot Fleet request that was not successfully canceled.
    */
  @js.native
  trait CancelSpotFleetRequestsErrorItem extends js.Object {
    var Error: js.UndefOr[CancelSpotFleetRequestsError]
    var SpotFleetRequestId: js.UndefOr[String]
  }

  object CancelSpotFleetRequestsErrorItem {
    def apply(
        Error: js.UndefOr[CancelSpotFleetRequestsError] = js.undefined,
        SpotFleetRequestId: js.UndefOr[String] = js.undefined
    ): CancelSpotFleetRequestsErrorItem = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Error" -> Error.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotFleetRequestId" -> SpotFleetRequestId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelSpotFleetRequestsErrorItem]
    }
  }

  /**
    * Contains the parameters for CancelSpotFleetRequests.
    */
  @js.native
  trait CancelSpotFleetRequestsRequest extends js.Object {
    var SpotFleetRequestIds: ValueStringList
    var TerminateInstances: Boolean
    var DryRun: js.UndefOr[Boolean]
  }

  object CancelSpotFleetRequestsRequest {
    def apply(
        SpotFleetRequestIds: ValueStringList,
        TerminateInstances: Boolean,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CancelSpotFleetRequestsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SpotFleetRequestIds" -> SpotFleetRequestIds.asInstanceOf[js.Any],
        "TerminateInstances"  -> TerminateInstances.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelSpotFleetRequestsRequest]
    }
  }

  /**
    * Contains the output of CancelSpotFleetRequests.
    */
  @js.native
  trait CancelSpotFleetRequestsResponse extends js.Object {
    var SuccessfulFleetRequests: js.UndefOr[CancelSpotFleetRequestsSuccessSet]
    var UnsuccessfulFleetRequests: js.UndefOr[CancelSpotFleetRequestsErrorSet]
  }

  object CancelSpotFleetRequestsResponse {
    def apply(
        SuccessfulFleetRequests: js.UndefOr[CancelSpotFleetRequestsSuccessSet] = js.undefined,
        UnsuccessfulFleetRequests: js.UndefOr[CancelSpotFleetRequestsErrorSet] = js.undefined
    ): CancelSpotFleetRequestsResponse = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SuccessfulFleetRequests" -> SuccessfulFleetRequests.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UnsuccessfulFleetRequests" -> UnsuccessfulFleetRequests.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelSpotFleetRequestsResponse]
    }
  }

  /**
    * Describes a Spot Fleet request that was successfully canceled.
    */
  @js.native
  trait CancelSpotFleetRequestsSuccessItem extends js.Object {
    var CurrentSpotFleetRequestState: js.UndefOr[BatchState]
    var PreviousSpotFleetRequestState: js.UndefOr[BatchState]
    var SpotFleetRequestId: js.UndefOr[String]
  }

  object CancelSpotFleetRequestsSuccessItem {
    def apply(
        CurrentSpotFleetRequestState: js.UndefOr[BatchState] = js.undefined,
        PreviousSpotFleetRequestState: js.UndefOr[BatchState] = js.undefined,
        SpotFleetRequestId: js.UndefOr[String] = js.undefined
    ): CancelSpotFleetRequestsSuccessItem = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CurrentSpotFleetRequestState" -> CurrentSpotFleetRequestState.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PreviousSpotFleetRequestState" -> PreviousSpotFleetRequestState.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotFleetRequestId" -> SpotFleetRequestId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelSpotFleetRequestsSuccessItem]
    }
  }

  object CancelSpotInstanceRequestStateEnum {
    val active    = "active"
    val open      = "open"
    val closed    = "closed"
    val cancelled = "cancelled"
    val completed = "completed"

    val values = IndexedSeq(active, open, closed, cancelled, completed)
  }

  /**
    * Contains the parameters for CancelSpotInstanceRequests.
    */
  @js.native
  trait CancelSpotInstanceRequestsRequest extends js.Object {
    var SpotInstanceRequestIds: SpotInstanceRequestIdList
    var DryRun: js.UndefOr[Boolean]
  }

  object CancelSpotInstanceRequestsRequest {
    def apply(
        SpotInstanceRequestIds: SpotInstanceRequestIdList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CancelSpotInstanceRequestsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SpotInstanceRequestIds" -> SpotInstanceRequestIds.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelSpotInstanceRequestsRequest]
    }
  }

  /**
    * Contains the output of CancelSpotInstanceRequests.
    */
  @js.native
  trait CancelSpotInstanceRequestsResult extends js.Object {
    var CancelledSpotInstanceRequests: js.UndefOr[CancelledSpotInstanceRequestList]
  }

  object CancelSpotInstanceRequestsResult {
    def apply(
        CancelledSpotInstanceRequests: js.UndefOr[CancelledSpotInstanceRequestList] = js.undefined
    ): CancelSpotInstanceRequestsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CancelledSpotInstanceRequests" -> CancelledSpotInstanceRequests.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelSpotInstanceRequestsResult]
    }
  }

  /**
    * Describes a request to cancel a Spot Instance.
    */
  @js.native
  trait CancelledSpotInstanceRequest extends js.Object {
    var SpotInstanceRequestId: js.UndefOr[String]
    var State: js.UndefOr[CancelSpotInstanceRequestState]
  }

  object CancelledSpotInstanceRequest {
    def apply(
        SpotInstanceRequestId: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[CancelSpotInstanceRequestState] = js.undefined
    ): CancelledSpotInstanceRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SpotInstanceRequestId" -> SpotInstanceRequestId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CancelledSpotInstanceRequest]
    }
  }

  /**
    * Describes a Capacity Reservation.
    */
  @js.native
  trait CapacityReservation extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var AvailableInstanceCount: js.UndefOr[Int]
    var CapacityReservationId: js.UndefOr[String]
    var CreateDate: js.UndefOr[DateTime]
    var EbsOptimized: js.UndefOr[Boolean]
    var EndDate: js.UndefOr[DateTime]
    var EndDateType: js.UndefOr[EndDateType]
    var EphemeralStorage: js.UndefOr[Boolean]
    var InstanceMatchCriteria: js.UndefOr[InstanceMatchCriteria]
    var InstancePlatform: js.UndefOr[CapacityReservationInstancePlatform]
    var InstanceType: js.UndefOr[String]
    var State: js.UndefOr[CapacityReservationState]
    var Tags: js.UndefOr[TagList]
    var Tenancy: js.UndefOr[CapacityReservationTenancy]
    var TotalInstanceCount: js.UndefOr[Int]
  }

  object CapacityReservation {
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        AvailableInstanceCount: js.UndefOr[Int] = js.undefined,
        CapacityReservationId: js.UndefOr[String] = js.undefined,
        CreateDate: js.UndefOr[DateTime] = js.undefined,
        EbsOptimized: js.UndefOr[Boolean] = js.undefined,
        EndDate: js.UndefOr[DateTime] = js.undefined,
        EndDateType: js.UndefOr[EndDateType] = js.undefined,
        EphemeralStorage: js.UndefOr[Boolean] = js.undefined,
        InstanceMatchCriteria: js.UndefOr[InstanceMatchCriteria] = js.undefined,
        InstancePlatform: js.UndefOr[CapacityReservationInstancePlatform] = js.undefined,
        InstanceType: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[CapacityReservationState] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        Tenancy: js.UndefOr[CapacityReservationTenancy] = js.undefined,
        TotalInstanceCount: js.UndefOr[Int] = js.undefined
    ): CapacityReservation = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AvailableInstanceCount" -> AvailableInstanceCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CapacityReservationId" -> CapacityReservationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CreateDate" -> CreateDate.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EbsOptimized" -> EbsOptimized.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EndDate" -> EndDate.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EndDateType" -> EndDateType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EphemeralStorage" -> EphemeralStorage.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceMatchCriteria" -> InstanceMatchCriteria.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstancePlatform" -> InstancePlatform.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tenancy" -> Tenancy.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TotalInstanceCount" -> TotalInstanceCount.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CapacityReservation]
    }
  }

  object CapacityReservationInstancePlatformEnum {
    val `Linux/UNIX`                         = "Linux/UNIX"
    val `Red Hat Enterprise Linux`           = "Red Hat Enterprise Linux"
    val `SUSE Linux`                         = "SUSE Linux"
    val Windows                              = "Windows"
    val `Windows with SQL Server`            = "Windows with SQL Server"
    val `Windows with SQL Server Enterprise` = "Windows with SQL Server Enterprise"
    val `Windows with SQL Server Standard`   = "Windows with SQL Server Standard"
    val `Windows with SQL Server Web`        = "Windows with SQL Server Web"
    val `Linux with SQL Server Standard`     = "Linux with SQL Server Standard"
    val `Linux with SQL Server Web`          = "Linux with SQL Server Web"
    val `Linux with SQL Server Enterprise`   = "Linux with SQL Server Enterprise"

    val values = IndexedSeq(
      `Linux/UNIX`,
      `Red Hat Enterprise Linux`,
      `SUSE Linux`,
      Windows,
      `Windows with SQL Server`,
      `Windows with SQL Server Enterprise`,
      `Windows with SQL Server Standard`,
      `Windows with SQL Server Web`,
      `Linux with SQL Server Standard`,
      `Linux with SQL Server Web`,
      `Linux with SQL Server Enterprise`
    )
  }

  object CapacityReservationPreferenceEnum {
    val open = "open"
    val none = "none"

    val values = IndexedSeq(open, none)
  }

  /**
    * Describes an instance's Capacity Reservation targeting option. You can specify only one parameter at a time. If you specify <code>CapacityReservationPreference</code> and <code>CapacityReservationTarget</code>, the request fails.
    *  Use the <code>CapacityReservationPreference</code> parameter to configure the instance to run as an On-Demand Instance or to run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). Use the <code>CapacityReservationTarget</code> parameter to explicitly target a specific Capacity Reservation.
    */
  @js.native
  trait CapacityReservationSpecification extends js.Object {
    var CapacityReservationPreference: js.UndefOr[CapacityReservationPreference]
    var CapacityReservationTarget: js.UndefOr[CapacityReservationTarget]
  }

  object CapacityReservationSpecification {
    def apply(
        CapacityReservationPreference: js.UndefOr[CapacityReservationPreference] = js.undefined,
        CapacityReservationTarget: js.UndefOr[CapacityReservationTarget] = js.undefined
    ): CapacityReservationSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CapacityReservationPreference" -> CapacityReservationPreference.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CapacityReservationTarget" -> CapacityReservationTarget.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CapacityReservationSpecification]
    }
  }

  /**
    * Describes the instance's Capacity Reservation targeting preferences. The action returns the <code>capacityReservationPreference</code> response element if the instance is configured to run in On-Demand capacity, or if it is configured in run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). The action returns the <code>capacityReservationTarget</code> response element if the instance explicily targets a specific Capacity Reservation.
    */
  @js.native
  trait CapacityReservationSpecificationResponse extends js.Object {
    var CapacityReservationPreference: js.UndefOr[CapacityReservationPreference]
    var CapacityReservationTarget: js.UndefOr[CapacityReservationTargetResponse]
  }

  object CapacityReservationSpecificationResponse {
    def apply(
        CapacityReservationPreference: js.UndefOr[CapacityReservationPreference] = js.undefined,
        CapacityReservationTarget: js.UndefOr[CapacityReservationTargetResponse] = js.undefined
    ): CapacityReservationSpecificationResponse = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CapacityReservationPreference" -> CapacityReservationPreference.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CapacityReservationTarget" -> CapacityReservationTarget.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CapacityReservationSpecificationResponse]
    }
  }

  object CapacityReservationStateEnum {
    val active    = "active"
    val expired   = "expired"
    val cancelled = "cancelled"
    val pending   = "pending"
    val failed    = "failed"

    val values = IndexedSeq(active, expired, cancelled, pending, failed)
  }

  /**
    * Describes a target Capacity Reservation.
    */
  @js.native
  trait CapacityReservationTarget extends js.Object {
    var CapacityReservationId: js.UndefOr[String]
  }

  object CapacityReservationTarget {
    def apply(
        CapacityReservationId: js.UndefOr[String] = js.undefined
    ): CapacityReservationTarget = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CapacityReservationId" -> CapacityReservationId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CapacityReservationTarget]
    }
  }

  /**
    * Describes a target Capacity Reservation.
    */
  @js.native
  trait CapacityReservationTargetResponse extends js.Object {
    var CapacityReservationId: js.UndefOr[String]
  }

  object CapacityReservationTargetResponse {
    def apply(
        CapacityReservationId: js.UndefOr[String] = js.undefined
    ): CapacityReservationTargetResponse = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CapacityReservationId" -> CapacityReservationId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CapacityReservationTargetResponse]
    }
  }

  object CapacityReservationTenancyEnum {
    val default   = "default"
    val dedicated = "dedicated"

    val values = IndexedSeq(default, dedicated)
  }

  /**
    * Information about the client certificate used for authentication.
    */
  @js.native
  trait CertificateAuthentication extends js.Object {
    var ClientRootCertificateChain: js.UndefOr[String]
  }

  object CertificateAuthentication {
    def apply(
        ClientRootCertificateChain: js.UndefOr[String] = js.undefined
    ): CertificateAuthentication = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientRootCertificateChain" -> ClientRootCertificateChain.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CertificateAuthentication]
    }
  }

  /**
    * Information about the client certificate to be used for authentication.
    */
  @js.native
  trait CertificateAuthenticationRequest extends js.Object {
    var ClientRootCertificateChainArn: js.UndefOr[String]
  }

  object CertificateAuthenticationRequest {
    def apply(
        ClientRootCertificateChainArn: js.UndefOr[String] = js.undefined
    ): CertificateAuthenticationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientRootCertificateChainArn" -> ClientRootCertificateChainArn.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CertificateAuthenticationRequest]
    }
  }

  /**
    * Provides authorization for Amazon to bring a specific IP address range to a specific AWS account using bring your own IP addresses (BYOIP). For more information, see [[https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip|Prepare to Bring Your Address Range to Your AWS Account]] in the <i>Amazon Elastic Compute Cloud User Guide</i>.
    */
  @js.native
  trait CidrAuthorizationContext extends js.Object {
    var Message: String
    var Signature: String
  }

  object CidrAuthorizationContext {
    def apply(
        Message: String,
        Signature: String
    ): CidrAuthorizationContext = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Message"   -> Message.asInstanceOf[js.Any],
        "Signature" -> Signature.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CidrAuthorizationContext]
    }
  }

  /**
    * Describes an IPv4 CIDR block.
    */
  @js.native
  trait CidrBlock extends js.Object {
    var CidrBlock: js.UndefOr[String]
  }

  object CidrBlock {
    def apply(
        CidrBlock: js.UndefOr[String] = js.undefined
    ): CidrBlock = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CidrBlock" -> CidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CidrBlock]
    }
  }

  /**
    * Describes the ClassicLink DNS support status of a VPC.
    */
  @js.native
  trait ClassicLinkDnsSupport extends js.Object {
    var ClassicLinkDnsSupported: js.UndefOr[Boolean]
    var VpcId: js.UndefOr[String]
  }

  object ClassicLinkDnsSupport {
    def apply(
        ClassicLinkDnsSupported: js.UndefOr[Boolean] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): ClassicLinkDnsSupport = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClassicLinkDnsSupported" -> ClassicLinkDnsSupported.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClassicLinkDnsSupport]
    }
  }

  /**
    * Describes a linked EC2-Classic instance.
    */
  @js.native
  trait ClassicLinkInstance extends js.Object {
    var Groups: js.UndefOr[GroupIdentifierList]
    var InstanceId: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
    var VpcId: js.UndefOr[String]
  }

  object ClassicLinkInstance {
    def apply(
        Groups: js.UndefOr[GroupIdentifierList] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): ClassicLinkInstance = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Groups" -> Groups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClassicLinkInstance]
    }
  }

  /**
    * Describes a Classic Load Balancer.
    */
  @js.native
  trait ClassicLoadBalancer extends js.Object {
    var Name: js.UndefOr[String]
  }

  object ClassicLoadBalancer {
    def apply(
        Name: js.UndefOr[String] = js.undefined
    ): ClassicLoadBalancer = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClassicLoadBalancer]
    }
  }

  /**
    * Describes the Classic Load Balancers to attach to a Spot Fleet. Spot Fleet registers the running Spot Instances with these Classic Load Balancers.
    */
  @js.native
  trait ClassicLoadBalancersConfig extends js.Object {
    var ClassicLoadBalancers: js.UndefOr[ClassicLoadBalancers]
  }

  object ClassicLoadBalancersConfig {
    def apply(
        ClassicLoadBalancers: js.UndefOr[ClassicLoadBalancers] = js.undefined
    ): ClassicLoadBalancersConfig = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClassicLoadBalancers" -> ClassicLoadBalancers.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClassicLoadBalancersConfig]
    }
  }

  /**
    * Describes the state of a client certificate revocation list.
    */
  @js.native
  trait ClientCertificateRevocationListStatus extends js.Object {
    var Code: js.UndefOr[ClientCertificateRevocationListStatusCode]
    var Message: js.UndefOr[String]
  }

  object ClientCertificateRevocationListStatus {
    def apply(
        Code: js.UndefOr[ClientCertificateRevocationListStatusCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): ClientCertificateRevocationListStatus = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Message" -> Message.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClientCertificateRevocationListStatus]
    }
  }

  object ClientCertificateRevocationListStatusCodeEnum {
    val pending = "pending"
    val active  = "active"

    val values = IndexedSeq(pending, active)
  }

  /**
    * Describes the client-specific data.
    */
  @js.native
  trait ClientData extends js.Object {
    var Comment: js.UndefOr[String]
    var UploadEnd: js.UndefOr[DateTime]
    var UploadSize: js.UndefOr[Double]
    var UploadStart: js.UndefOr[DateTime]
  }

  object ClientData {
    def apply(
        Comment: js.UndefOr[String] = js.undefined,
        UploadEnd: js.UndefOr[DateTime] = js.undefined,
        UploadSize: js.UndefOr[Double] = js.undefined,
        UploadStart: js.UndefOr[DateTime] = js.undefined
    ): ClientData = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Comment" -> Comment.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UploadEnd" -> UploadEnd.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UploadSize" -> UploadSize.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UploadStart" -> UploadStart.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClientData]
    }
  }

  /**
    * Describes the authentication methods used by a Client VPN endpoint. Client VPN supports Active Directory and mutual authentication. For more information, see [[https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication|Authentication]] in the <i>AWS Client VPN Administrator Guide</i>.
    */
  @js.native
  trait ClientVpnAuthentication extends js.Object {
    var ActiveDirectory: js.UndefOr[DirectoryServiceAuthentication]
    var MutualAuthentication: js.UndefOr[CertificateAuthentication]
    var Type: js.UndefOr[ClientVpnAuthenticationType]
  }

  object ClientVpnAuthentication {
    def apply(
        ActiveDirectory: js.UndefOr[DirectoryServiceAuthentication] = js.undefined,
        MutualAuthentication: js.UndefOr[CertificateAuthentication] = js.undefined,
        Type: js.UndefOr[ClientVpnAuthenticationType] = js.undefined
    ): ClientVpnAuthentication = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ActiveDirectory" -> ActiveDirectory.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MutualAuthentication" -> MutualAuthentication.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Type" -> Type.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClientVpnAuthentication]
    }
  }

  /**
    * Describes the authentication method to be used by a Client VPN endpoint. Client VPN supports Active Directory and mutual authentication. For more information, see [[https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication|Authentication]] in the <i>AWS Client VPN Administrator Guide</i>.
    */
  @js.native
  trait ClientVpnAuthenticationRequest extends js.Object {
    var ActiveDirectory: js.UndefOr[DirectoryServiceAuthenticationRequest]
    var MutualAuthentication: js.UndefOr[CertificateAuthenticationRequest]
    var Type: js.UndefOr[ClientVpnAuthenticationType]
  }

  object ClientVpnAuthenticationRequest {
    def apply(
        ActiveDirectory: js.UndefOr[DirectoryServiceAuthenticationRequest] = js.undefined,
        MutualAuthentication: js.UndefOr[CertificateAuthenticationRequest] = js.undefined,
        Type: js.UndefOr[ClientVpnAuthenticationType] = js.undefined
    ): ClientVpnAuthenticationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ActiveDirectory" -> ActiveDirectory.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MutualAuthentication" -> MutualAuthentication.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Type" -> Type.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClientVpnAuthenticationRequest]
    }
  }

  object ClientVpnAuthenticationTypeEnum {
    val `certificate-authentication`       = "certificate-authentication"
    val `directory-service-authentication` = "directory-service-authentication"

    val values = IndexedSeq(`certificate-authentication`, `directory-service-authentication`)
  }

  /**
    * Describes the state of an authorization rule.
    */
  @js.native
  trait ClientVpnAuthorizationRuleStatus extends js.Object {
    var Code: js.UndefOr[ClientVpnAuthorizationRuleStatusCode]
    var Message: js.UndefOr[String]
  }

  object ClientVpnAuthorizationRuleStatus {
    def apply(
        Code: js.UndefOr[ClientVpnAuthorizationRuleStatusCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): ClientVpnAuthorizationRuleStatus = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Message" -> Message.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClientVpnAuthorizationRuleStatus]
    }
  }

  object ClientVpnAuthorizationRuleStatusCodeEnum {
    val authorizing = "authorizing"
    val active      = "active"
    val failed      = "failed"
    val revoking    = "revoking"

    val values = IndexedSeq(authorizing, active, failed, revoking)
  }

  /**
    * Describes a client connection.
    */
  @js.native
  trait ClientVpnConnection extends js.Object {
    var ClientIp: js.UndefOr[String]
    var ClientVpnEndpointId: js.UndefOr[String]
    var CommonName: js.UndefOr[String]
    var ConnectionEndTime: js.UndefOr[String]
    var ConnectionEstablishedTime: js.UndefOr[String]
    var ConnectionId: js.UndefOr[String]
    var EgressBytes: js.UndefOr[String]
    var EgressPackets: js.UndefOr[String]
    var IngressBytes: js.UndefOr[String]
    var IngressPackets: js.UndefOr[String]
    var Status: js.UndefOr[ClientVpnConnectionStatus]
    var Timestamp: js.UndefOr[String]
    var Username: js.UndefOr[String]
  }

  object ClientVpnConnection {
    def apply(
        ClientIp: js.UndefOr[String] = js.undefined,
        ClientVpnEndpointId: js.UndefOr[String] = js.undefined,
        CommonName: js.UndefOr[String] = js.undefined,
        ConnectionEndTime: js.UndefOr[String] = js.undefined,
        ConnectionEstablishedTime: js.UndefOr[String] = js.undefined,
        ConnectionId: js.UndefOr[String] = js.undefined,
        EgressBytes: js.UndefOr[String] = js.undefined,
        EgressPackets: js.UndefOr[String] = js.undefined,
        IngressBytes: js.UndefOr[String] = js.undefined,
        IngressPackets: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[ClientVpnConnectionStatus] = js.undefined,
        Timestamp: js.UndefOr[String] = js.undefined,
        Username: js.UndefOr[String] = js.undefined
    ): ClientVpnConnection = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientIp" -> ClientIp.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ClientVpnEndpointId" -> ClientVpnEndpointId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CommonName" -> CommonName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ConnectionEndTime" -> ConnectionEndTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ConnectionEstablishedTime" -> ConnectionEstablishedTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ConnectionId" -> ConnectionId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EgressBytes" -> EgressBytes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EgressPackets" -> EgressPackets.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IngressBytes" -> IngressBytes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IngressPackets" -> IngressPackets.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Timestamp" -> Timestamp.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Username" -> Username.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClientVpnConnection]
    }
  }

  /**
    * Describes the status of a client connection.
    */
  @js.native
  trait ClientVpnConnectionStatus extends js.Object {
    var Code: js.UndefOr[ClientVpnConnectionStatusCode]
    var Message: js.UndefOr[String]
  }

  object ClientVpnConnectionStatus {
    def apply(
        Code: js.UndefOr[ClientVpnConnectionStatusCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): ClientVpnConnectionStatus = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Message" -> Message.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClientVpnConnectionStatus]
    }
  }

  object ClientVpnConnectionStatusCodeEnum {
    val active                = "active"
    val `failed-to-terminate` = "failed-to-terminate"
    val terminating           = "terminating"
    val terminated            = "terminated"

    val values = IndexedSeq(active, `failed-to-terminate`, terminating, terminated)
  }

  /**
    * Describes a Client VPN endpoint.
    */
  @js.native
  trait ClientVpnEndpoint extends js.Object {
    var AssociatedTargetNetworks: js.UndefOr[AssociatedTargetNetworkSet]
    var AuthenticationOptions: js.UndefOr[ClientVpnAuthenticationList]
    var ClientCidrBlock: js.UndefOr[String]
    var ClientVpnEndpointId: js.UndefOr[String]
    var ConnectionLogOptions: js.UndefOr[ConnectionLogResponseOptions]
    var CreationTime: js.UndefOr[String]
    var DeletionTime: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DnsName: js.UndefOr[String]
    var DnsServers: js.UndefOr[ValueStringList]
    var ServerCertificateArn: js.UndefOr[String]
    var SplitTunnel: js.UndefOr[Boolean]
    var Status: js.UndefOr[ClientVpnEndpointStatus]
    var Tags: js.UndefOr[TagList]
    var TransportProtocol: js.UndefOr[TransportProtocol]
    var VpnProtocol: js.UndefOr[VpnProtocol]
  }

  object ClientVpnEndpoint {
    def apply(
        AssociatedTargetNetworks: js.UndefOr[AssociatedTargetNetworkSet] = js.undefined,
        AuthenticationOptions: js.UndefOr[ClientVpnAuthenticationList] = js.undefined,
        ClientCidrBlock: js.UndefOr[String] = js.undefined,
        ClientVpnEndpointId: js.UndefOr[String] = js.undefined,
        ConnectionLogOptions: js.UndefOr[ConnectionLogResponseOptions] = js.undefined,
        CreationTime: js.UndefOr[String] = js.undefined,
        DeletionTime: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DnsName: js.UndefOr[String] = js.undefined,
        DnsServers: js.UndefOr[ValueStringList] = js.undefined,
        ServerCertificateArn: js.UndefOr[String] = js.undefined,
        SplitTunnel: js.UndefOr[Boolean] = js.undefined,
        Status: js.UndefOr[ClientVpnEndpointStatus] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        TransportProtocol: js.UndefOr[TransportProtocol] = js.undefined,
        VpnProtocol: js.UndefOr[VpnProtocol] = js.undefined
    ): ClientVpnEndpoint = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociatedTargetNetworks" -> AssociatedTargetNetworks.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AuthenticationOptions" -> AuthenticationOptions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ClientCidrBlock" -> ClientCidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ClientVpnEndpointId" -> ClientVpnEndpointId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ConnectionLogOptions" -> ConnectionLogOptions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CreationTime" -> CreationTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeletionTime" -> DeletionTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DnsName" -> DnsName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DnsServers" -> DnsServers.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ServerCertificateArn" -> ServerCertificateArn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SplitTunnel" -> SplitTunnel.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransportProtocol" -> TransportProtocol.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpnProtocol" -> VpnProtocol.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClientVpnEndpoint]
    }
  }

  /**
    * Describes the state of a Client VPN endpoint.
    */
  @js.native
  trait ClientVpnEndpointStatus extends js.Object {
    var Code: js.UndefOr[ClientVpnEndpointStatusCode]
    var Message: js.UndefOr[String]
  }

  object ClientVpnEndpointStatus {
    def apply(
        Code: js.UndefOr[ClientVpnEndpointStatusCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): ClientVpnEndpointStatus = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Message" -> Message.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClientVpnEndpointStatus]
    }
  }

  object ClientVpnEndpointStatusCodeEnum {
    val `pending-associate` = "pending-associate"
    val available           = "available"
    val deleting            = "deleting"
    val deleted             = "deleted"

    val values = IndexedSeq(`pending-associate`, available, deleting, deleted)
  }

  /**
    * Information about a Client VPN endpoint route.
    */
  @js.native
  trait ClientVpnRoute extends js.Object {
    var ClientVpnEndpointId: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DestinationCidr: js.UndefOr[String]
    var Origin: js.UndefOr[String]
    var Status: js.UndefOr[ClientVpnRouteStatus]
    var TargetSubnet: js.UndefOr[String]
    var Type: js.UndefOr[String]
  }

  object ClientVpnRoute {
    def apply(
        ClientVpnEndpointId: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DestinationCidr: js.UndefOr[String] = js.undefined,
        Origin: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[ClientVpnRouteStatus] = js.undefined,
        TargetSubnet: js.UndefOr[String] = js.undefined,
        Type: js.UndefOr[String] = js.undefined
    ): ClientVpnRoute = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DestinationCidr" -> DestinationCidr.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Origin" -> Origin.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TargetSubnet" -> TargetSubnet.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Type" -> Type.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClientVpnRoute]
    }
  }

  /**
    * Describes the state of a Client VPN endpoint route.
    */
  @js.native
  trait ClientVpnRouteStatus extends js.Object {
    var Code: js.UndefOr[ClientVpnRouteStatusCode]
    var Message: js.UndefOr[String]
  }

  object ClientVpnRouteStatus {
    def apply(
        Code: js.UndefOr[ClientVpnRouteStatusCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): ClientVpnRouteStatus = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Message" -> Message.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ClientVpnRouteStatus]
    }
  }

  object ClientVpnRouteStatusCodeEnum {
    val creating = "creating"
    val active   = "active"
    val failed   = "failed"
    val deleting = "deleting"

    val values = IndexedSeq(creating, active, failed, deleting)
  }

  @js.native
  trait ConfirmProductInstanceRequest extends js.Object {
    var InstanceId: String
    var ProductCode: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ConfirmProductInstanceRequest {
    def apply(
        InstanceId: String,
        ProductCode: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ConfirmProductInstanceRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId"  -> InstanceId.asInstanceOf[js.Any],
        "ProductCode" -> ProductCode.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ConfirmProductInstanceRequest]
    }
  }

  @js.native
  trait ConfirmProductInstanceResult extends js.Object {
    var OwnerId: js.UndefOr[String]
    var Return: js.UndefOr[Boolean]
  }

  object ConfirmProductInstanceResult {
    def apply(
        OwnerId: js.UndefOr[String] = js.undefined,
        Return: js.UndefOr[Boolean] = js.undefined
    ): ConfirmProductInstanceResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "OwnerId" -> OwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ConfirmProductInstanceResult]
    }
  }

  /**
    * Describes the client connection logging options for the Client VPN endpoint.
    */
  @js.native
  trait ConnectionLogOptions extends js.Object {
    var CloudwatchLogGroup: js.UndefOr[String]
    var CloudwatchLogStream: js.UndefOr[String]
    var Enabled: js.UndefOr[Boolean]
  }

  object ConnectionLogOptions {
    def apply(
        CloudwatchLogGroup: js.UndefOr[String] = js.undefined,
        CloudwatchLogStream: js.UndefOr[String] = js.undefined,
        Enabled: js.UndefOr[Boolean] = js.undefined
    ): ConnectionLogOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CloudwatchLogGroup" -> CloudwatchLogGroup.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CloudwatchLogStream" -> CloudwatchLogStream.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Enabled" -> Enabled.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ConnectionLogOptions]
    }
  }

  /**
    * Information about the client connection logging options for a Client VPN endpoint.
    */
  @js.native
  trait ConnectionLogResponseOptions extends js.Object {
    var CloudwatchLogGroup: js.UndefOr[String]
    var CloudwatchLogStream: js.UndefOr[String]
    var Enabled: js.UndefOr[Boolean]
  }

  object ConnectionLogResponseOptions {
    def apply(
        CloudwatchLogGroup: js.UndefOr[String] = js.undefined,
        CloudwatchLogStream: js.UndefOr[String] = js.undefined,
        Enabled: js.UndefOr[Boolean] = js.undefined
    ): ConnectionLogResponseOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CloudwatchLogGroup" -> CloudwatchLogGroup.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CloudwatchLogStream" -> CloudwatchLogStream.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Enabled" -> Enabled.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ConnectionLogResponseOptions]
    }
  }

  /**
    * Describes a connection notification for a VPC endpoint or VPC endpoint service.
    */
  @js.native
  trait ConnectionNotification extends js.Object {
    var ConnectionEvents: js.UndefOr[ValueStringList]
    var ConnectionNotificationArn: js.UndefOr[String]
    var ConnectionNotificationId: js.UndefOr[String]
    var ConnectionNotificationState: js.UndefOr[ConnectionNotificationState]
    var ConnectionNotificationType: js.UndefOr[ConnectionNotificationType]
    var ServiceId: js.UndefOr[String]
    var VpcEndpointId: js.UndefOr[String]
  }

  object ConnectionNotification {
    def apply(
        ConnectionEvents: js.UndefOr[ValueStringList] = js.undefined,
        ConnectionNotificationArn: js.UndefOr[String] = js.undefined,
        ConnectionNotificationId: js.UndefOr[String] = js.undefined,
        ConnectionNotificationState: js.UndefOr[ConnectionNotificationState] = js.undefined,
        ConnectionNotificationType: js.UndefOr[ConnectionNotificationType] = js.undefined,
        ServiceId: js.UndefOr[String] = js.undefined,
        VpcEndpointId: js.UndefOr[String] = js.undefined
    ): ConnectionNotification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ConnectionEvents" -> ConnectionEvents.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ConnectionNotificationArn" -> ConnectionNotificationArn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ConnectionNotificationId" -> ConnectionNotificationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ConnectionNotificationState" -> ConnectionNotificationState.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ConnectionNotificationType" -> ConnectionNotificationType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ServiceId" -> ServiceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcEndpointId" -> VpcEndpointId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ConnectionNotification]
    }
  }

  object ConnectionNotificationStateEnum {
    val Enabled  = "Enabled"
    val Disabled = "Disabled"

    val values = IndexedSeq(Enabled, Disabled)
  }

  object ConnectionNotificationTypeEnum {
    val Topic = "Topic"

    val values = IndexedSeq(Topic)
  }

  object ContainerFormatEnum {
    val ova = "ova"

    val values = IndexedSeq(ova)
  }

  /**
    * Describes a conversion task.
    */
  @js.native
  trait ConversionTask extends js.Object {
    var ConversionTaskId: js.UndefOr[String]
    var ExpirationTime: js.UndefOr[String]
    var ImportInstance: js.UndefOr[ImportInstanceTaskDetails]
    var ImportVolume: js.UndefOr[ImportVolumeTaskDetails]
    var State: js.UndefOr[ConversionTaskState]
    var StatusMessage: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
  }

  object ConversionTask {
    def apply(
        ConversionTaskId: js.UndefOr[String] = js.undefined,
        ExpirationTime: js.UndefOr[String] = js.undefined,
        ImportInstance: js.UndefOr[ImportInstanceTaskDetails] = js.undefined,
        ImportVolume: js.UndefOr[ImportVolumeTaskDetails] = js.undefined,
        State: js.UndefOr[ConversionTaskState] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): ConversionTask = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ConversionTaskId" -> ConversionTaskId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ExpirationTime" -> ExpirationTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImportInstance" -> ImportInstance.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImportVolume" -> ImportVolume.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StatusMessage" -> StatusMessage.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ConversionTask]
    }
  }

  object ConversionTaskStateEnum {
    val active     = "active"
    val cancelling = "cancelling"
    val cancelled  = "cancelled"
    val completed  = "completed"

    val values = IndexedSeq(active, cancelling, cancelled, completed)
  }

  @js.native
  trait CopyFpgaImageRequest extends js.Object {
    var SourceFpgaImageId: String
    var SourceRegion: String
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Name: js.UndefOr[String]
  }

  object CopyFpgaImageRequest {
    def apply(
        SourceFpgaImageId: String,
        SourceRegion: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Name: js.UndefOr[String] = js.undefined
    ): CopyFpgaImageRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SourceFpgaImageId" -> SourceFpgaImageId.asInstanceOf[js.Any],
        "SourceRegion"      -> SourceRegion.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CopyFpgaImageRequest]
    }
  }

  @js.native
  trait CopyFpgaImageResult extends js.Object {
    var FpgaImageId: js.UndefOr[String]
  }

  object CopyFpgaImageResult {
    def apply(
        FpgaImageId: js.UndefOr[String] = js.undefined
    ): CopyFpgaImageResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FpgaImageId" -> FpgaImageId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CopyFpgaImageResult]
    }
  }

  /**
    * Contains the parameters for CopyImage.
    */
  @js.native
  trait CopyImageRequest extends js.Object {
    var Name: String
    var SourceImageId: String
    var SourceRegion: String
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var KmsKeyId: js.UndefOr[String]
  }

  object CopyImageRequest {
    def apply(
        Name: String,
        SourceImageId: String,
        SourceRegion: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined
    ): CopyImageRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Name"          -> Name.asInstanceOf[js.Any],
        "SourceImageId" -> SourceImageId.asInstanceOf[js.Any],
        "SourceRegion"  -> SourceRegion.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Encrypted" -> Encrypted.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KmsKeyId" -> KmsKeyId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CopyImageRequest]
    }
  }

  /**
    * Contains the output of CopyImage.
    */
  @js.native
  trait CopyImageResult extends js.Object {
    var ImageId: js.UndefOr[String]
  }

  object CopyImageResult {
    def apply(
        ImageId: js.UndefOr[String] = js.undefined
    ): CopyImageResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ImageId" -> ImageId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CopyImageResult]
    }
  }

  /**
    * Contains the parameters for CopySnapshot.
    */
  @js.native
  trait CopySnapshotRequest extends js.Object {
    var SourceRegion: String
    var SourceSnapshotId: String
    var Description: js.UndefOr[String]
    var DestinationRegion: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var KmsKeyId: js.UndefOr[String]
    var PresignedUrl: js.UndefOr[String]
  }

  object CopySnapshotRequest {
    def apply(
        SourceRegion: String,
        SourceSnapshotId: String,
        Description: js.UndefOr[String] = js.undefined,
        DestinationRegion: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        PresignedUrl: js.UndefOr[String] = js.undefined
    ): CopySnapshotRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SourceRegion"     -> SourceRegion.asInstanceOf[js.Any],
        "SourceSnapshotId" -> SourceSnapshotId.asInstanceOf[js.Any],
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DestinationRegion" -> DestinationRegion.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Encrypted" -> Encrypted.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KmsKeyId" -> KmsKeyId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PresignedUrl" -> PresignedUrl.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CopySnapshotRequest]
    }
  }

  /**
    * Contains the output of CopySnapshot.
    */
  @js.native
  trait CopySnapshotResult extends js.Object {
    var SnapshotId: js.UndefOr[String]
  }

  object CopySnapshotResult {
    def apply(
        SnapshotId: js.UndefOr[String] = js.undefined
    ): CopySnapshotResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SnapshotId" -> SnapshotId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CopySnapshotResult]
    }
  }

  /**
    * The CPU options for the instance.
    */
  @js.native
  trait CpuOptions extends js.Object {
    var CoreCount: js.UndefOr[Int]
    var ThreadsPerCore: js.UndefOr[Int]
  }

  object CpuOptions {
    def apply(
        CoreCount: js.UndefOr[Int] = js.undefined,
        ThreadsPerCore: js.UndefOr[Int] = js.undefined
    ): CpuOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CoreCount" -> CoreCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ThreadsPerCore" -> ThreadsPerCore.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CpuOptions]
    }
  }

  /**
    * The CPU options for the instance. Both the core count and threads per core must be specified in the request.
    */
  @js.native
  trait CpuOptionsRequest extends js.Object {
    var CoreCount: js.UndefOr[Int]
    var ThreadsPerCore: js.UndefOr[Int]
  }

  object CpuOptionsRequest {
    def apply(
        CoreCount: js.UndefOr[Int] = js.undefined,
        ThreadsPerCore: js.UndefOr[Int] = js.undefined
    ): CpuOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CoreCount" -> CoreCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ThreadsPerCore" -> ThreadsPerCore.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CpuOptionsRequest]
    }
  }

  @js.native
  trait CreateCapacityReservationRequest extends js.Object {
    var AvailabilityZone: String
    var InstanceCount: Int
    var InstancePlatform: CapacityReservationInstancePlatform
    var InstanceType: String
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var EbsOptimized: js.UndefOr[Boolean]
    var EndDate: js.UndefOr[DateTime]
    var EndDateType: js.UndefOr[EndDateType]
    var EphemeralStorage: js.UndefOr[Boolean]
    var InstanceMatchCriteria: js.UndefOr[InstanceMatchCriteria]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
    var Tenancy: js.UndefOr[CapacityReservationTenancy]
  }

  object CreateCapacityReservationRequest {
    def apply(
        AvailabilityZone: String,
        InstanceCount: Int,
        InstancePlatform: CapacityReservationInstancePlatform,
        InstanceType: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EbsOptimized: js.UndefOr[Boolean] = js.undefined,
        EndDate: js.UndefOr[DateTime] = js.undefined,
        EndDateType: js.UndefOr[EndDateType] = js.undefined,
        EphemeralStorage: js.UndefOr[Boolean] = js.undefined,
        InstanceMatchCriteria: js.UndefOr[InstanceMatchCriteria] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined,
        Tenancy: js.UndefOr[CapacityReservationTenancy] = js.undefined
    ): CreateCapacityReservationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.asInstanceOf[js.Any],
        "InstanceCount"    -> InstanceCount.asInstanceOf[js.Any],
        "InstancePlatform" -> InstancePlatform.asInstanceOf[js.Any],
        "InstanceType"     -> InstanceType.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EbsOptimized" -> EbsOptimized.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EndDate" -> EndDate.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EndDateType" -> EndDateType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EphemeralStorage" -> EphemeralStorage.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceMatchCriteria" -> InstanceMatchCriteria.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TagSpecifications" -> TagSpecifications.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tenancy" -> Tenancy.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateCapacityReservationRequest]
    }
  }

  @js.native
  trait CreateCapacityReservationResult extends js.Object {
    var CapacityReservation: js.UndefOr[CapacityReservation]
  }

  object CreateCapacityReservationResult {
    def apply(
        CapacityReservation: js.UndefOr[CapacityReservation] = js.undefined
    ): CreateCapacityReservationResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CapacityReservation" -> CapacityReservation.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateCapacityReservationResult]
    }
  }

  @js.native
  trait CreateClientVpnEndpointRequest extends js.Object {
    var AuthenticationOptions: ClientVpnAuthenticationRequestList
    var ClientCidrBlock: String
    var ConnectionLogOptions: ConnectionLogOptions
    var ServerCertificateArn: String
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DnsServers: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
    var TransportProtocol: js.UndefOr[TransportProtocol]
  }

  object CreateClientVpnEndpointRequest {
    def apply(
        AuthenticationOptions: ClientVpnAuthenticationRequestList,
        ClientCidrBlock: String,
        ConnectionLogOptions: ConnectionLogOptions,
        ServerCertificateArn: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DnsServers: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined,
        TransportProtocol: js.UndefOr[TransportProtocol] = js.undefined
    ): CreateClientVpnEndpointRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AuthenticationOptions" -> AuthenticationOptions.asInstanceOf[js.Any],
        "ClientCidrBlock"       -> ClientCidrBlock.asInstanceOf[js.Any],
        "ConnectionLogOptions"  -> ConnectionLogOptions.asInstanceOf[js.Any],
        "ServerCertificateArn"  -> ServerCertificateArn.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DnsServers" -> DnsServers.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TagSpecifications" -> TagSpecifications.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransportProtocol" -> TransportProtocol.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateClientVpnEndpointRequest]
    }
  }

  @js.native
  trait CreateClientVpnEndpointResult extends js.Object {
    var ClientVpnEndpointId: js.UndefOr[String]
    var DnsName: js.UndefOr[String]
    var Status: js.UndefOr[ClientVpnEndpointStatus]
  }

  object CreateClientVpnEndpointResult {
    def apply(
        ClientVpnEndpointId: js.UndefOr[String] = js.undefined,
        DnsName: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[ClientVpnEndpointStatus] = js.undefined
    ): CreateClientVpnEndpointResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DnsName" -> DnsName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateClientVpnEndpointResult]
    }
  }

  @js.native
  trait CreateClientVpnRouteRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DestinationCidrBlock: String
    var TargetVpcSubnetId: String
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateClientVpnRouteRequest {
    def apply(
        ClientVpnEndpointId: String,
        DestinationCidrBlock: String,
        TargetVpcSubnetId: String,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateClientVpnRouteRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId"  -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "DestinationCidrBlock" -> DestinationCidrBlock.asInstanceOf[js.Any],
        "TargetVpcSubnetId"    -> TargetVpcSubnetId.asInstanceOf[js.Any],
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateClientVpnRouteRequest]
    }
  }

  @js.native
  trait CreateClientVpnRouteResult extends js.Object {
    var Status: js.UndefOr[ClientVpnRouteStatus]
  }

  object CreateClientVpnRouteResult {
    def apply(
        Status: js.UndefOr[ClientVpnRouteStatus] = js.undefined
    ): CreateClientVpnRouteResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateClientVpnRouteResult]
    }
  }

  /**
    * Contains the parameters for CreateCustomerGateway.
    */
  @js.native
  trait CreateCustomerGatewayRequest extends js.Object {
    var BgpAsn: Int
    var PublicIp: String
    var Type: GatewayType
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateCustomerGatewayRequest {
    def apply(
        BgpAsn: Int,
        PublicIp: String,
        Type: GatewayType,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateCustomerGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "BgpAsn"   -> BgpAsn.asInstanceOf[js.Any],
        "PublicIp" -> PublicIp.asInstanceOf[js.Any],
        "Type"     -> Type.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateCustomerGatewayRequest]
    }
  }

  /**
    * Contains the output of CreateCustomerGateway.
    */
  @js.native
  trait CreateCustomerGatewayResult extends js.Object {
    var CustomerGateway: js.UndefOr[CustomerGateway]
  }

  object CreateCustomerGatewayResult {
    def apply(
        CustomerGateway: js.UndefOr[CustomerGateway] = js.undefined
    ): CreateCustomerGatewayResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CustomerGateway" -> CustomerGateway.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateCustomerGatewayResult]
    }
  }

  @js.native
  trait CreateDefaultSubnetRequest extends js.Object {
    var AvailabilityZone: String
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateDefaultSubnetRequest {
    def apply(
        AvailabilityZone: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateDefaultSubnetRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateDefaultSubnetRequest]
    }
  }

  @js.native
  trait CreateDefaultSubnetResult extends js.Object {
    var Subnet: js.UndefOr[Subnet]
  }

  object CreateDefaultSubnetResult {
    def apply(
        Subnet: js.UndefOr[Subnet] = js.undefined
    ): CreateDefaultSubnetResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Subnet" -> Subnet.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateDefaultSubnetResult]
    }
  }

  @js.native
  trait CreateDefaultVpcRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateDefaultVpcRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateDefaultVpcRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateDefaultVpcRequest]
    }
  }

  @js.native
  trait CreateDefaultVpcResult extends js.Object {
    var Vpc: js.UndefOr[Vpc]
  }

  object CreateDefaultVpcResult {
    def apply(
        Vpc: js.UndefOr[Vpc] = js.undefined
    ): CreateDefaultVpcResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Vpc" -> Vpc.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateDefaultVpcResult]
    }
  }

  @js.native
  trait CreateDhcpOptionsRequest extends js.Object {
    var DhcpConfigurations: NewDhcpConfigurationList
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateDhcpOptionsRequest {
    def apply(
        DhcpConfigurations: NewDhcpConfigurationList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateDhcpOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DhcpConfigurations" -> DhcpConfigurations.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateDhcpOptionsRequest]
    }
  }

  @js.native
  trait CreateDhcpOptionsResult extends js.Object {
    var DhcpOptions: js.UndefOr[DhcpOptions]
  }

  object CreateDhcpOptionsResult {
    def apply(
        DhcpOptions: js.UndefOr[DhcpOptions] = js.undefined
    ): CreateDhcpOptionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DhcpOptions" -> DhcpOptions.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateDhcpOptionsResult]
    }
  }

  @js.native
  trait CreateEgressOnlyInternetGatewayRequest extends js.Object {
    var VpcId: String
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateEgressOnlyInternetGatewayRequest {
    def apply(
        VpcId: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateEgressOnlyInternetGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId" -> VpcId.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateEgressOnlyInternetGatewayRequest]
    }
  }

  @js.native
  trait CreateEgressOnlyInternetGatewayResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var EgressOnlyInternetGateway: js.UndefOr[EgressOnlyInternetGateway]
  }

  object CreateEgressOnlyInternetGatewayResult {
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        EgressOnlyInternetGateway: js.UndefOr[EgressOnlyInternetGateway] = js.undefined
    ): CreateEgressOnlyInternetGatewayResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EgressOnlyInternetGateway" -> EgressOnlyInternetGateway.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateEgressOnlyInternetGatewayResult]
    }
  }

  /**
    * Describes the instances that could not be launched by the fleet.
    */
  @js.native
  trait CreateFleetError extends js.Object {
    var ErrorCode: js.UndefOr[String]
    var ErrorMessage: js.UndefOr[String]
    var LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse]
    var Lifecycle: js.UndefOr[InstanceLifecycle]
  }

  object CreateFleetError {
    def apply(
        ErrorCode: js.UndefOr[String] = js.undefined,
        ErrorMessage: js.UndefOr[String] = js.undefined,
        LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse] = js.undefined,
        Lifecycle: js.UndefOr[InstanceLifecycle] = js.undefined
    ): CreateFleetError = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ErrorCode" -> ErrorCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ErrorMessage" -> ErrorMessage.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateAndOverrides" -> LaunchTemplateAndOverrides.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Lifecycle" -> Lifecycle.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateFleetError]
    }
  }

  /**
    * Describes the instances that were launched by the fleet.
    */
  @js.native
  trait CreateFleetInstance extends js.Object {
    var InstanceIds: js.UndefOr[InstanceIdsSet]
    var InstanceType: js.UndefOr[InstanceType]
    var LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse]
    var Lifecycle: js.UndefOr[InstanceLifecycle]
    var Platform: js.UndefOr[PlatformValues]
  }

  object CreateFleetInstance {
    def apply(
        InstanceIds: js.UndefOr[InstanceIdsSet] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse] = js.undefined,
        Lifecycle: js.UndefOr[InstanceLifecycle] = js.undefined,
        Platform: js.UndefOr[PlatformValues] = js.undefined
    ): CreateFleetInstance = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceIds" -> InstanceIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateAndOverrides" -> LaunchTemplateAndOverrides.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Lifecycle" -> Lifecycle.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Platform" -> Platform.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateFleetInstance]
    }
  }

  @js.native
  trait CreateFleetRequest extends js.Object {
    var LaunchTemplateConfigs: FleetLaunchTemplateConfigListRequest
    var TargetCapacitySpecification: TargetCapacitySpecificationRequest
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var ExcessCapacityTerminationPolicy: js.UndefOr[FleetExcessCapacityTerminationPolicy]
    var OnDemandOptions: js.UndefOr[OnDemandOptionsRequest]
    var ReplaceUnhealthyInstances: js.UndefOr[Boolean]
    var SpotOptions: js.UndefOr[SpotOptionsRequest]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
    var TerminateInstancesWithExpiration: js.UndefOr[Boolean]
    var Type: js.UndefOr[FleetType]
    var ValidFrom: js.UndefOr[DateTime]
    var ValidUntil: js.UndefOr[DateTime]
  }

  object CreateFleetRequest {
    def apply(
        LaunchTemplateConfigs: FleetLaunchTemplateConfigListRequest,
        TargetCapacitySpecification: TargetCapacitySpecificationRequest,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ExcessCapacityTerminationPolicy: js.UndefOr[FleetExcessCapacityTerminationPolicy] = js.undefined,
        OnDemandOptions: js.UndefOr[OnDemandOptionsRequest] = js.undefined,
        ReplaceUnhealthyInstances: js.UndefOr[Boolean] = js.undefined,
        SpotOptions: js.UndefOr[SpotOptionsRequest] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined,
        TerminateInstancesWithExpiration: js.UndefOr[Boolean] = js.undefined,
        Type: js.UndefOr[FleetType] = js.undefined,
        ValidFrom: js.UndefOr[DateTime] = js.undefined,
        ValidUntil: js.UndefOr[DateTime] = js.undefined
    ): CreateFleetRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateConfigs"       -> LaunchTemplateConfigs.asInstanceOf[js.Any],
        "TargetCapacitySpecification" -> TargetCapacitySpecification.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ExcessCapacityTerminationPolicy" -> ExcessCapacityTerminationPolicy.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OnDemandOptions" -> OnDemandOptions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReplaceUnhealthyInstances" -> ReplaceUnhealthyInstances.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotOptions" -> SpotOptions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TagSpecifications" -> TagSpecifications.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TerminateInstancesWithExpiration" -> TerminateInstancesWithExpiration.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Type" -> Type.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ValidFrom" -> ValidFrom.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ValidUntil" -> ValidUntil.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateFleetRequest]
    }
  }

  @js.native
  trait CreateFleetResult extends js.Object {
    var Errors: js.UndefOr[CreateFleetErrorsSet]
    var FleetId: js.UndefOr[FleetIdentifier]
    var Instances: js.UndefOr[CreateFleetInstancesSet]
  }

  object CreateFleetResult {
    def apply(
        Errors: js.UndefOr[CreateFleetErrorsSet] = js.undefined,
        FleetId: js.UndefOr[FleetIdentifier] = js.undefined,
        Instances: js.UndefOr[CreateFleetInstancesSet] = js.undefined
    ): CreateFleetResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Errors" -> Errors.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FleetId" -> FleetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Instances" -> Instances.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateFleetResult]
    }
  }

  @js.native
  trait CreateFlowLogsRequest extends js.Object {
    var ResourceIds: ValueStringList
    var ResourceType: FlowLogsResourceType
    var TrafficType: TrafficType
    var ClientToken: js.UndefOr[String]
    var DeliverLogsPermissionArn: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var LogDestination: js.UndefOr[String]
    var LogDestinationType: js.UndefOr[LogDestinationType]
    var LogGroupName: js.UndefOr[String]
  }

  object CreateFlowLogsRequest {
    def apply(
        ResourceIds: ValueStringList,
        ResourceType: FlowLogsResourceType,
        TrafficType: TrafficType,
        ClientToken: js.UndefOr[String] = js.undefined,
        DeliverLogsPermissionArn: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LogDestination: js.UndefOr[String] = js.undefined,
        LogDestinationType: js.UndefOr[LogDestinationType] = js.undefined,
        LogGroupName: js.UndefOr[String] = js.undefined
    ): CreateFlowLogsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ResourceIds"  -> ResourceIds.asInstanceOf[js.Any],
        "ResourceType" -> ResourceType.asInstanceOf[js.Any],
        "TrafficType"  -> TrafficType.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeliverLogsPermissionArn" -> DeliverLogsPermissionArn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LogDestination" -> LogDestination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LogDestinationType" -> LogDestinationType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LogGroupName" -> LogGroupName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateFlowLogsRequest]
    }
  }

  @js.native
  trait CreateFlowLogsResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var FlowLogIds: js.UndefOr[ValueStringList]
    var Unsuccessful: js.UndefOr[UnsuccessfulItemSet]
  }

  object CreateFlowLogsResult {
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        FlowLogIds: js.UndefOr[ValueStringList] = js.undefined,
        Unsuccessful: js.UndefOr[UnsuccessfulItemSet] = js.undefined
    ): CreateFlowLogsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FlowLogIds" -> FlowLogIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Unsuccessful" -> Unsuccessful.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateFlowLogsResult]
    }
  }

  @js.native
  trait CreateFpgaImageRequest extends js.Object {
    var InputStorageLocation: StorageLocation
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var LogsStorageLocation: js.UndefOr[StorageLocation]
    var Name: js.UndefOr[String]
  }

  object CreateFpgaImageRequest {
    def apply(
        InputStorageLocation: StorageLocation,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LogsStorageLocation: js.UndefOr[StorageLocation] = js.undefined,
        Name: js.UndefOr[String] = js.undefined
    ): CreateFpgaImageRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InputStorageLocation" -> InputStorageLocation.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LogsStorageLocation" -> LogsStorageLocation.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateFpgaImageRequest]
    }
  }

  @js.native
  trait CreateFpgaImageResult extends js.Object {
    var FpgaImageGlobalId: js.UndefOr[String]
    var FpgaImageId: js.UndefOr[String]
  }

  object CreateFpgaImageResult {
    def apply(
        FpgaImageGlobalId: js.UndefOr[String] = js.undefined,
        FpgaImageId: js.UndefOr[String] = js.undefined
    ): CreateFpgaImageResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FpgaImageGlobalId" -> FpgaImageGlobalId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FpgaImageId" -> FpgaImageId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateFpgaImageResult]
    }
  }

  /**
    * Contains the parameters for CreateImage.
    */
  @js.native
  trait CreateImageRequest extends js.Object {
    var InstanceId: String
    var Name: String
    var BlockDeviceMappings: js.UndefOr[BlockDeviceMappingRequestList]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var NoReboot: js.UndefOr[Boolean]
  }

  object CreateImageRequest {
    def apply(
        InstanceId: String,
        Name: String,
        BlockDeviceMappings: js.UndefOr[BlockDeviceMappingRequestList] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        NoReboot: js.UndefOr[Boolean] = js.undefined
    ): CreateImageRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "Name"       -> Name.asInstanceOf[js.Any],
        "BlockDeviceMappings" -> BlockDeviceMappings.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NoReboot" -> NoReboot.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateImageRequest]
    }
  }

  /**
    * Contains the output of CreateImage.
    */
  @js.native
  trait CreateImageResult extends js.Object {
    var ImageId: js.UndefOr[String]
  }

  object CreateImageResult {
    def apply(
        ImageId: js.UndefOr[String] = js.undefined
    ): CreateImageResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ImageId" -> ImageId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateImageResult]
    }
  }

  /**
    * Contains the parameters for CreateInstanceExportTask.
    */
  @js.native
  trait CreateInstanceExportTaskRequest extends js.Object {
    var InstanceId: String
    var Description: js.UndefOr[String]
    var ExportToS3Task: js.UndefOr[ExportToS3TaskSpecification]
    var TargetEnvironment: js.UndefOr[ExportEnvironment]
  }

  object CreateInstanceExportTaskRequest {
    def apply(
        InstanceId: String,
        Description: js.UndefOr[String] = js.undefined,
        ExportToS3Task: js.UndefOr[ExportToS3TaskSpecification] = js.undefined,
        TargetEnvironment: js.UndefOr[ExportEnvironment] = js.undefined
    ): CreateInstanceExportTaskRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ExportToS3Task" -> ExportToS3Task.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TargetEnvironment" -> TargetEnvironment.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateInstanceExportTaskRequest]
    }
  }

  /**
    * Contains the output for CreateInstanceExportTask.
    */
  @js.native
  trait CreateInstanceExportTaskResult extends js.Object {
    var ExportTask: js.UndefOr[ExportTask]
  }

  object CreateInstanceExportTaskResult {
    def apply(
        ExportTask: js.UndefOr[ExportTask] = js.undefined
    ): CreateInstanceExportTaskResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ExportTask" -> ExportTask.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateInstanceExportTaskResult]
    }
  }

  @js.native
  trait CreateInternetGatewayRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateInternetGatewayRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateInternetGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateInternetGatewayRequest]
    }
  }

  @js.native
  trait CreateInternetGatewayResult extends js.Object {
    var InternetGateway: js.UndefOr[InternetGateway]
  }

  object CreateInternetGatewayResult {
    def apply(
        InternetGateway: js.UndefOr[InternetGateway] = js.undefined
    ): CreateInternetGatewayResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InternetGateway" -> InternetGateway.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateInternetGatewayResult]
    }
  }

  @js.native
  trait CreateKeyPairRequest extends js.Object {
    var KeyName: String
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateKeyPairRequest {
    def apply(
        KeyName: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateKeyPairRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "KeyName" -> KeyName.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateKeyPairRequest]
    }
  }

  @js.native
  trait CreateLaunchTemplateRequest extends js.Object {
    var LaunchTemplateData: RequestLaunchTemplateData
    var LaunchTemplateName: LaunchTemplateName
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var VersionDescription: js.UndefOr[VersionDescription]
  }

  object CreateLaunchTemplateRequest {
    def apply(
        LaunchTemplateData: RequestLaunchTemplateData,
        LaunchTemplateName: LaunchTemplateName,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        VersionDescription: js.UndefOr[VersionDescription] = js.undefined
    ): CreateLaunchTemplateRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateData" -> LaunchTemplateData.asInstanceOf[js.Any],
        "LaunchTemplateName" -> LaunchTemplateName.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VersionDescription" -> VersionDescription.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateLaunchTemplateRequest]
    }
  }

  @js.native
  trait CreateLaunchTemplateResult extends js.Object {
    var LaunchTemplate: js.UndefOr[LaunchTemplate]
  }

  object CreateLaunchTemplateResult {
    def apply(
        LaunchTemplate: js.UndefOr[LaunchTemplate] = js.undefined
    ): CreateLaunchTemplateResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplate" -> LaunchTemplate.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateLaunchTemplateResult]
    }
  }

  @js.native
  trait CreateLaunchTemplateVersionRequest extends js.Object {
    var LaunchTemplateData: RequestLaunchTemplateData
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
    var SourceVersion: js.UndefOr[String]
    var VersionDescription: js.UndefOr[VersionDescription]
  }

  object CreateLaunchTemplateVersionRequest {
    def apply(
        LaunchTemplateData: RequestLaunchTemplateData,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined,
        SourceVersion: js.UndefOr[String] = js.undefined,
        VersionDescription: js.UndefOr[VersionDescription] = js.undefined
    ): CreateLaunchTemplateVersionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateData" -> LaunchTemplateData.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateId" -> LaunchTemplateId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateName" -> LaunchTemplateName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SourceVersion" -> SourceVersion.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VersionDescription" -> VersionDescription.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateLaunchTemplateVersionRequest]
    }
  }

  @js.native
  trait CreateLaunchTemplateVersionResult extends js.Object {
    var LaunchTemplateVersion: js.UndefOr[LaunchTemplateVersion]
  }

  object CreateLaunchTemplateVersionResult {
    def apply(
        LaunchTemplateVersion: js.UndefOr[LaunchTemplateVersion] = js.undefined
    ): CreateLaunchTemplateVersionResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateVersion" -> LaunchTemplateVersion.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateLaunchTemplateVersionResult]
    }
  }

  @js.native
  trait CreateNatGatewayRequest extends js.Object {
    var AllocationId: String
    var SubnetId: String
    var ClientToken: js.UndefOr[String]
  }

  object CreateNatGatewayRequest {
    def apply(
        AllocationId: String,
        SubnetId: String,
        ClientToken: js.UndefOr[String] = js.undefined
    ): CreateNatGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllocationId" -> AllocationId.asInstanceOf[js.Any],
        "SubnetId"     -> SubnetId.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateNatGatewayRequest]
    }
  }

  @js.native
  trait CreateNatGatewayResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var NatGateway: js.UndefOr[NatGateway]
  }

  object CreateNatGatewayResult {
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        NatGateway: js.UndefOr[NatGateway] = js.undefined
    ): CreateNatGatewayResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NatGateway" -> NatGateway.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateNatGatewayResult]
    }
  }

  @js.native
  trait CreateNetworkAclEntryRequest extends js.Object {
    var Egress: Boolean
    var NetworkAclId: String
    var Protocol: String
    var RuleAction: RuleAction
    var RuleNumber: Int
    var CidrBlock: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var IcmpTypeCode: js.UndefOr[IcmpTypeCode]
    var Ipv6CidrBlock: js.UndefOr[String]
    var PortRange: js.UndefOr[PortRange]
  }

  object CreateNetworkAclEntryRequest {
    def apply(
        Egress: Boolean,
        NetworkAclId: String,
        Protocol: String,
        RuleAction: RuleAction,
        RuleNumber: Int,
        CidrBlock: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        IcmpTypeCode: js.UndefOr[IcmpTypeCode] = js.undefined,
        Ipv6CidrBlock: js.UndefOr[String] = js.undefined,
        PortRange: js.UndefOr[PortRange] = js.undefined
    ): CreateNetworkAclEntryRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Egress"       -> Egress.asInstanceOf[js.Any],
        "NetworkAclId" -> NetworkAclId.asInstanceOf[js.Any],
        "Protocol"     -> Protocol.asInstanceOf[js.Any],
        "RuleAction"   -> RuleAction.asInstanceOf[js.Any],
        "RuleNumber"   -> RuleNumber.asInstanceOf[js.Any],
        "CidrBlock" -> CidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IcmpTypeCode" -> IcmpTypeCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6CidrBlock" -> Ipv6CidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PortRange" -> PortRange.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateNetworkAclEntryRequest]
    }
  }

  @js.native
  trait CreateNetworkAclRequest extends js.Object {
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateNetworkAclRequest {
    def apply(
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateNetworkAclRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId" -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateNetworkAclRequest]
    }
  }

  @js.native
  trait CreateNetworkAclResult extends js.Object {
    var NetworkAcl: js.UndefOr[NetworkAcl]
  }

  object CreateNetworkAclResult {
    def apply(
        NetworkAcl: js.UndefOr[NetworkAcl] = js.undefined
    ): CreateNetworkAclResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkAcl" -> NetworkAcl.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateNetworkAclResult]
    }
  }

  /**
    * Contains the parameters for CreateNetworkInterfacePermission.
    */
  @js.native
  trait CreateNetworkInterfacePermissionRequest extends js.Object {
    var NetworkInterfaceId: String
    var Permission: InterfacePermissionType
    var AwsAccountId: js.UndefOr[String]
    var AwsService: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateNetworkInterfacePermissionRequest {
    def apply(
        NetworkInterfaceId: String,
        Permission: InterfacePermissionType,
        AwsAccountId: js.UndefOr[String] = js.undefined,
        AwsService: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateNetworkInterfacePermissionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any],
        "Permission"         -> Permission.asInstanceOf[js.Any],
        "AwsAccountId" -> AwsAccountId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AwsService" -> AwsService.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateNetworkInterfacePermissionRequest]
    }
  }

  /**
    * Contains the output of CreateNetworkInterfacePermission.
    */
  @js.native
  trait CreateNetworkInterfacePermissionResult extends js.Object {
    var InterfacePermission: js.UndefOr[NetworkInterfacePermission]
  }

  object CreateNetworkInterfacePermissionResult {
    def apply(
        InterfacePermission: js.UndefOr[NetworkInterfacePermission] = js.undefined
    ): CreateNetworkInterfacePermissionResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InterfacePermission" -> InterfacePermission.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateNetworkInterfacePermissionResult]
    }
  }

  /**
    * Contains the parameters for CreateNetworkInterface.
    */
  @js.native
  trait CreateNetworkInterfaceRequest extends js.Object {
    var SubnetId: String
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Groups: js.UndefOr[SecurityGroupIdStringList]
    var Ipv6AddressCount: js.UndefOr[Int]
    var Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList]
    var PrivateIpAddress: js.UndefOr[String]
    var PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList]
    var SecondaryPrivateIpAddressCount: js.UndefOr[Int]
  }

  object CreateNetworkInterfaceRequest {
    def apply(
        SubnetId: String,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Groups: js.UndefOr[SecurityGroupIdStringList] = js.undefined,
        Ipv6AddressCount: js.UndefOr[Int] = js.undefined,
        Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList] = js.undefined,
        SecondaryPrivateIpAddressCount: js.UndefOr[Int] = js.undefined
    ): CreateNetworkInterfaceRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SubnetId" -> SubnetId.asInstanceOf[js.Any],
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Groups" -> Groups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6AddressCount" -> Ipv6AddressCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6Addresses" -> Ipv6Addresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddresses" -> PrivateIpAddresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SecondaryPrivateIpAddressCount" -> SecondaryPrivateIpAddressCount.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateNetworkInterfaceRequest]
    }
  }

  /**
    * Contains the output of CreateNetworkInterface.
    */
  @js.native
  trait CreateNetworkInterfaceResult extends js.Object {
    var NetworkInterface: js.UndefOr[NetworkInterface]
  }

  object CreateNetworkInterfaceResult {
    def apply(
        NetworkInterface: js.UndefOr[NetworkInterface] = js.undefined
    ): CreateNetworkInterfaceResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkInterface" -> NetworkInterface.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateNetworkInterfaceResult]
    }
  }

  @js.native
  trait CreatePlacementGroupRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var GroupName: js.UndefOr[String]
    var PartitionCount: js.UndefOr[Int]
    var Strategy: js.UndefOr[PlacementStrategy]
  }

  object CreatePlacementGroupRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined,
        PartitionCount: js.UndefOr[Int] = js.undefined,
        Strategy: js.UndefOr[PlacementStrategy] = js.undefined
    ): CreatePlacementGroupRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupName" -> GroupName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PartitionCount" -> PartitionCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Strategy" -> Strategy.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreatePlacementGroupRequest]
    }
  }

  /**
    * Contains the parameters for CreateReservedInstancesListing.
    */
  @js.native
  trait CreateReservedInstancesListingRequest extends js.Object {
    var ClientToken: String
    var InstanceCount: Int
    var PriceSchedules: PriceScheduleSpecificationList
    var ReservedInstancesId: String
  }

  object CreateReservedInstancesListingRequest {
    def apply(
        ClientToken: String,
        InstanceCount: Int,
        PriceSchedules: PriceScheduleSpecificationList,
        ReservedInstancesId: String
    ): CreateReservedInstancesListingRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientToken"         -> ClientToken.asInstanceOf[js.Any],
        "InstanceCount"       -> InstanceCount.asInstanceOf[js.Any],
        "PriceSchedules"      -> PriceSchedules.asInstanceOf[js.Any],
        "ReservedInstancesId" -> ReservedInstancesId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateReservedInstancesListingRequest]
    }
  }

  /**
    * Contains the output of CreateReservedInstancesListing.
    */
  @js.native
  trait CreateReservedInstancesListingResult extends js.Object {
    var ReservedInstancesListings: js.UndefOr[ReservedInstancesListingList]
  }

  object CreateReservedInstancesListingResult {
    def apply(
        ReservedInstancesListings: js.UndefOr[ReservedInstancesListingList] = js.undefined
    ): CreateReservedInstancesListingResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReservedInstancesListings" -> ReservedInstancesListings.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateReservedInstancesListingResult]
    }
  }

  @js.native
  trait CreateRouteRequest extends js.Object {
    var RouteTableId: String
    var DestinationCidrBlock: js.UndefOr[String]
    var DestinationIpv6CidrBlock: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var EgressOnlyInternetGatewayId: js.UndefOr[String]
    var GatewayId: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
    var NatGatewayId: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var TransitGatewayId: js.UndefOr[String]
    var VpcPeeringConnectionId: js.UndefOr[String]
  }

  object CreateRouteRequest {
    def apply(
        RouteTableId: String,
        DestinationCidrBlock: js.UndefOr[String] = js.undefined,
        DestinationIpv6CidrBlock: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EgressOnlyInternetGatewayId: js.UndefOr[String] = js.undefined,
        GatewayId: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        NatGatewayId: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        TransitGatewayId: js.UndefOr[String] = js.undefined,
        VpcPeeringConnectionId: js.UndefOr[String] = js.undefined
    ): CreateRouteRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "RouteTableId" -> RouteTableId.asInstanceOf[js.Any],
        "DestinationCidrBlock" -> DestinationCidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DestinationIpv6CidrBlock" -> DestinationIpv6CidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EgressOnlyInternetGatewayId" -> EgressOnlyInternetGatewayId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GatewayId" -> GatewayId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NatGatewayId" -> NatGatewayId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceId" -> NetworkInterfaceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGatewayId" -> TransitGatewayId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcPeeringConnectionId" -> VpcPeeringConnectionId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateRouteRequest]
    }
  }

  @js.native
  trait CreateRouteResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object CreateRouteResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): CreateRouteResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateRouteResult]
    }
  }

  @js.native
  trait CreateRouteTableRequest extends js.Object {
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateRouteTableRequest {
    def apply(
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateRouteTableRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId" -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateRouteTableRequest]
    }
  }

  @js.native
  trait CreateRouteTableResult extends js.Object {
    var RouteTable: js.UndefOr[RouteTable]
  }

  object CreateRouteTableResult {
    def apply(
        RouteTable: js.UndefOr[RouteTable] = js.undefined
    ): CreateRouteTableResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "RouteTable" -> RouteTable.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateRouteTableResult]
    }
  }

  @js.native
  trait CreateSecurityGroupRequest extends js.Object {
    var Description: String
    var GroupName: String
    var DryRun: js.UndefOr[Boolean]
    var VpcId: js.UndefOr[String]
  }

  object CreateSecurityGroupRequest {
    def apply(
        Description: String,
        GroupName: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): CreateSecurityGroupRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Description" -> Description.asInstanceOf[js.Any],
        "GroupName"   -> GroupName.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateSecurityGroupRequest]
    }
  }

  @js.native
  trait CreateSecurityGroupResult extends js.Object {
    var GroupId: js.UndefOr[String]
  }

  object CreateSecurityGroupResult {
    def apply(
        GroupId: js.UndefOr[String] = js.undefined
    ): CreateSecurityGroupResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "GroupId" -> GroupId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateSecurityGroupResult]
    }
  }

  /**
    * Contains the parameters for CreateSnapshot.
    */
  @js.native
  trait CreateSnapshotRequest extends js.Object {
    var VolumeId: String
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object CreateSnapshotRequest {
    def apply(
        VolumeId: String,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): CreateSnapshotRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VolumeId" -> VolumeId.asInstanceOf[js.Any],
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TagSpecifications" -> TagSpecifications.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateSnapshotRequest]
    }
  }

  /**
    * Contains the parameters for CreateSpotDatafeedSubscription.
    */
  @js.native
  trait CreateSpotDatafeedSubscriptionRequest extends js.Object {
    var Bucket: String
    var DryRun: js.UndefOr[Boolean]
    var Prefix: js.UndefOr[String]
  }

  object CreateSpotDatafeedSubscriptionRequest {
    def apply(
        Bucket: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Prefix: js.UndefOr[String] = js.undefined
    ): CreateSpotDatafeedSubscriptionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Bucket" -> Bucket.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Prefix" -> Prefix.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateSpotDatafeedSubscriptionRequest]
    }
  }

  /**
    * Contains the output of CreateSpotDatafeedSubscription.
    */
  @js.native
  trait CreateSpotDatafeedSubscriptionResult extends js.Object {
    var SpotDatafeedSubscription: js.UndefOr[SpotDatafeedSubscription]
  }

  object CreateSpotDatafeedSubscriptionResult {
    def apply(
        SpotDatafeedSubscription: js.UndefOr[SpotDatafeedSubscription] = js.undefined
    ): CreateSpotDatafeedSubscriptionResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SpotDatafeedSubscription" -> SpotDatafeedSubscription.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateSpotDatafeedSubscriptionResult]
    }
  }

  @js.native
  trait CreateSubnetRequest extends js.Object {
    var CidrBlock: String
    var VpcId: String
    var AvailabilityZone: js.UndefOr[String]
    var AvailabilityZoneId: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Ipv6CidrBlock: js.UndefOr[String]
  }

  object CreateSubnetRequest {
    def apply(
        CidrBlock: String,
        VpcId: String,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        AvailabilityZoneId: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Ipv6CidrBlock: js.UndefOr[String] = js.undefined
    ): CreateSubnetRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CidrBlock" -> CidrBlock.asInstanceOf[js.Any],
        "VpcId"     -> VpcId.asInstanceOf[js.Any],
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AvailabilityZoneId" -> AvailabilityZoneId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6CidrBlock" -> Ipv6CidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateSubnetRequest]
    }
  }

  @js.native
  trait CreateSubnetResult extends js.Object {
    var Subnet: js.UndefOr[Subnet]
  }

  object CreateSubnetResult {
    def apply(
        Subnet: js.UndefOr[Subnet] = js.undefined
    ): CreateSubnetResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Subnet" -> Subnet.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateSubnetResult]
    }
  }

  @js.native
  trait CreateTagsRequest extends js.Object {
    var Resources: ResourceIdList
    var Tags: TagList
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateTagsRequest {
    def apply(
        Resources: ResourceIdList,
        Tags: TagList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateTagsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Resources" -> Resources.asInstanceOf[js.Any],
        "Tags"      -> Tags.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateTagsRequest]
    }
  }

  @js.native
  trait CreateTransitGatewayRequest extends js.Object {
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Options: js.UndefOr[TransitGatewayRequestOptions]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object CreateTransitGatewayRequest {
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Options: js.UndefOr[TransitGatewayRequestOptions] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): CreateTransitGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Options" -> Options.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TagSpecifications" -> TagSpecifications.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateTransitGatewayRequest]
    }
  }

  @js.native
  trait CreateTransitGatewayResult extends js.Object {
    var TransitGateway: js.UndefOr[TransitGateway]
  }

  object CreateTransitGatewayResult {
    def apply(
        TransitGateway: js.UndefOr[TransitGateway] = js.undefined
    ): CreateTransitGatewayResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGateway" -> TransitGateway.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateTransitGatewayResult]
    }
  }

  @js.native
  trait CreateTransitGatewayRouteRequest extends js.Object {
    var DestinationCidrBlock: String
    var TransitGatewayRouteTableId: String
    var Blackhole: js.UndefOr[Boolean]
    var DryRun: js.UndefOr[Boolean]
    var TransitGatewayAttachmentId: js.UndefOr[String]
  }

  object CreateTransitGatewayRouteRequest {
    def apply(
        DestinationCidrBlock: String,
        TransitGatewayRouteTableId: String,
        Blackhole: js.UndefOr[Boolean] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TransitGatewayAttachmentId: js.UndefOr[String] = js.undefined
    ): CreateTransitGatewayRouteRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DestinationCidrBlock"       -> DestinationCidrBlock.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any],
        "Blackhole" -> Blackhole.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateTransitGatewayRouteRequest]
    }
  }

  @js.native
  trait CreateTransitGatewayRouteResult extends js.Object {
    var Route: js.UndefOr[TransitGatewayRoute]
  }

  object CreateTransitGatewayRouteResult {
    def apply(
        Route: js.UndefOr[TransitGatewayRoute] = js.undefined
    ): CreateTransitGatewayRouteResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Route" -> Route.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateTransitGatewayRouteResult]
    }
  }

  @js.native
  trait CreateTransitGatewayRouteTableRequest extends js.Object {
    var TransitGatewayId: String
    var DryRun: js.UndefOr[Boolean]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object CreateTransitGatewayRouteTableRequest {
    def apply(
        TransitGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): CreateTransitGatewayRouteTableRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayId" -> TransitGatewayId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TagSpecifications" -> TagSpecifications.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateTransitGatewayRouteTableRequest]
    }
  }

  @js.native
  trait CreateTransitGatewayRouteTableResult extends js.Object {
    var TransitGatewayRouteTable: js.UndefOr[TransitGatewayRouteTable]
  }

  object CreateTransitGatewayRouteTableResult {
    def apply(
        TransitGatewayRouteTable: js.UndefOr[TransitGatewayRouteTable] = js.undefined
    ): CreateTransitGatewayRouteTableResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayRouteTable" -> TransitGatewayRouteTable.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateTransitGatewayRouteTableResult]
    }
  }

  @js.native
  trait CreateTransitGatewayVpcAttachmentRequest extends js.Object {
    var SubnetIds: ValueStringList
    var TransitGatewayId: String
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
    var Options: js.UndefOr[CreateTransitGatewayVpcAttachmentRequestOptions]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object CreateTransitGatewayVpcAttachmentRequest {
    def apply(
        SubnetIds: ValueStringList,
        TransitGatewayId: String,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Options: js.UndefOr[CreateTransitGatewayVpcAttachmentRequestOptions] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): CreateTransitGatewayVpcAttachmentRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SubnetIds"        -> SubnetIds.asInstanceOf[js.Any],
        "TransitGatewayId" -> TransitGatewayId.asInstanceOf[js.Any],
        "VpcId"            -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Options" -> Options.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TagSpecifications" -> TagSpecifications.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateTransitGatewayVpcAttachmentRequest]
    }
  }

  /**
    * Describes the options for a VPC attachment.
    */
  @js.native
  trait CreateTransitGatewayVpcAttachmentRequestOptions extends js.Object {
    var DnsSupport: js.UndefOr[DnsSupportValue]
    var Ipv6Support: js.UndefOr[Ipv6SupportValue]
  }

  object CreateTransitGatewayVpcAttachmentRequestOptions {
    def apply(
        DnsSupport: js.UndefOr[DnsSupportValue] = js.undefined,
        Ipv6Support: js.UndefOr[Ipv6SupportValue] = js.undefined
    ): CreateTransitGatewayVpcAttachmentRequestOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DnsSupport" -> DnsSupport.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6Support" -> Ipv6Support.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[CreateTransitGatewayVpcAttachmentRequestOptions]
    }
  }

  @js.native
  trait CreateTransitGatewayVpcAttachmentResult extends js.Object {
    var TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment]
  }

  object CreateTransitGatewayVpcAttachmentResult {
    def apply(
        TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment] = js.undefined
    ): CreateTransitGatewayVpcAttachmentResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayVpcAttachment" -> TransitGatewayVpcAttachment.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateTransitGatewayVpcAttachmentResult]
    }
  }

  /**
    * Describes the user or group to be added or removed from the list of create volume permissions for a volume.
    */
  @js.native
  trait CreateVolumePermission extends js.Object {
    var Group: js.UndefOr[PermissionGroup]
    var UserId: js.UndefOr[String]
  }

  object CreateVolumePermission {
    def apply(
        Group: js.UndefOr[PermissionGroup] = js.undefined,
        UserId: js.UndefOr[String] = js.undefined
    ): CreateVolumePermission = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Group" -> Group.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserId" -> UserId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVolumePermission]
    }
  }

  /**
    * Describes modifications to the list of create volume permissions for a volume.
    */
  @js.native
  trait CreateVolumePermissionModifications extends js.Object {
    var Add: js.UndefOr[CreateVolumePermissionList]
    var Remove: js.UndefOr[CreateVolumePermissionList]
  }

  object CreateVolumePermissionModifications {
    def apply(
        Add: js.UndefOr[CreateVolumePermissionList] = js.undefined,
        Remove: js.UndefOr[CreateVolumePermissionList] = js.undefined
    ): CreateVolumePermissionModifications = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Add" -> Add.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Remove" -> Remove.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVolumePermissionModifications]
    }
  }

  /**
    * Contains the parameters for CreateVolume.
    */
  @js.native
  trait CreateVolumeRequest extends js.Object {
    var AvailabilityZone: String
    var DryRun: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var Iops: js.UndefOr[Int]
    var KmsKeyId: js.UndefOr[String]
    var Size: js.UndefOr[Int]
    var SnapshotId: js.UndefOr[String]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
    var VolumeType: js.UndefOr[VolumeType]
  }

  object CreateVolumeRequest {
    def apply(
        AvailabilityZone: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Iops: js.UndefOr[Int] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        Size: js.UndefOr[Int] = js.undefined,
        SnapshotId: js.UndefOr[String] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined,
        VolumeType: js.UndefOr[VolumeType] = js.undefined
    ): CreateVolumeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Encrypted" -> Encrypted.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Iops" -> Iops.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KmsKeyId" -> KmsKeyId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Size" -> Size.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SnapshotId" -> SnapshotId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TagSpecifications" -> TagSpecifications.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeType" -> VolumeType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVolumeRequest]
    }
  }

  @js.native
  trait CreateVpcEndpointConnectionNotificationRequest extends js.Object {
    var ConnectionEvents: ValueStringList
    var ConnectionNotificationArn: String
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var ServiceId: js.UndefOr[String]
    var VpcEndpointId: js.UndefOr[String]
  }

  object CreateVpcEndpointConnectionNotificationRequest {
    def apply(
        ConnectionEvents: ValueStringList,
        ConnectionNotificationArn: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ServiceId: js.UndefOr[String] = js.undefined,
        VpcEndpointId: js.UndefOr[String] = js.undefined
    ): CreateVpcEndpointConnectionNotificationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ConnectionEvents"          -> ConnectionEvents.asInstanceOf[js.Any],
        "ConnectionNotificationArn" -> ConnectionNotificationArn.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ServiceId" -> ServiceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcEndpointId" -> VpcEndpointId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[CreateVpcEndpointConnectionNotificationRequest]
    }
  }

  @js.native
  trait CreateVpcEndpointConnectionNotificationResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var ConnectionNotification: js.UndefOr[ConnectionNotification]
  }

  object CreateVpcEndpointConnectionNotificationResult {
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        ConnectionNotification: js.UndefOr[ConnectionNotification] = js.undefined
    ): CreateVpcEndpointConnectionNotificationResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ConnectionNotification" -> ConnectionNotification.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[CreateVpcEndpointConnectionNotificationResult]
    }
  }

  /**
    * Contains the parameters for CreateVpcEndpoint.
    */
  @js.native
  trait CreateVpcEndpointRequest extends js.Object {
    var ServiceName: String
    var VpcId: String
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var PolicyDocument: js.UndefOr[String]
    var PrivateDnsEnabled: js.UndefOr[Boolean]
    var RouteTableIds: js.UndefOr[ValueStringList]
    var SecurityGroupIds: js.UndefOr[ValueStringList]
    var SubnetIds: js.UndefOr[ValueStringList]
    var VpcEndpointType: js.UndefOr[VpcEndpointType]
  }

  object CreateVpcEndpointRequest {
    def apply(
        ServiceName: String,
        VpcId: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PolicyDocument: js.UndefOr[String] = js.undefined,
        PrivateDnsEnabled: js.UndefOr[Boolean] = js.undefined,
        RouteTableIds: js.UndefOr[ValueStringList] = js.undefined,
        SecurityGroupIds: js.UndefOr[ValueStringList] = js.undefined,
        SubnetIds: js.UndefOr[ValueStringList] = js.undefined,
        VpcEndpointType: js.UndefOr[VpcEndpointType] = js.undefined
    ): CreateVpcEndpointRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ServiceName" -> ServiceName.asInstanceOf[js.Any],
        "VpcId"       -> VpcId.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PolicyDocument" -> PolicyDocument.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateDnsEnabled" -> PrivateDnsEnabled.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RouteTableIds" -> RouteTableIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SecurityGroupIds" -> SecurityGroupIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetIds" -> SubnetIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcEndpointType" -> VpcEndpointType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVpcEndpointRequest]
    }
  }

  /**
    * Contains the output of CreateVpcEndpoint.
    */
  @js.native
  trait CreateVpcEndpointResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var VpcEndpoint: js.UndefOr[VpcEndpoint]
  }

  object CreateVpcEndpointResult {
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        VpcEndpoint: js.UndefOr[VpcEndpoint] = js.undefined
    ): CreateVpcEndpointResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcEndpoint" -> VpcEndpoint.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVpcEndpointResult]
    }
  }

  @js.native
  trait CreateVpcEndpointServiceConfigurationRequest extends js.Object {
    var NetworkLoadBalancerArns: ValueStringList
    var AcceptanceRequired: js.UndefOr[Boolean]
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateVpcEndpointServiceConfigurationRequest {
    def apply(
        NetworkLoadBalancerArns: ValueStringList,
        AcceptanceRequired: js.UndefOr[Boolean] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateVpcEndpointServiceConfigurationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkLoadBalancerArns" -> NetworkLoadBalancerArns.asInstanceOf[js.Any],
        "AcceptanceRequired" -> AcceptanceRequired.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[CreateVpcEndpointServiceConfigurationRequest]
    }
  }

  @js.native
  trait CreateVpcEndpointServiceConfigurationResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var ServiceConfiguration: js.UndefOr[ServiceConfiguration]
  }

  object CreateVpcEndpointServiceConfigurationResult {
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        ServiceConfiguration: js.UndefOr[ServiceConfiguration] = js.undefined
    ): CreateVpcEndpointServiceConfigurationResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ServiceConfiguration" -> ServiceConfiguration.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[CreateVpcEndpointServiceConfigurationResult]
    }
  }

  @js.native
  trait CreateVpcPeeringConnectionRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var PeerOwnerId: js.UndefOr[String]
    var PeerRegion: js.UndefOr[String]
    var PeerVpcId: js.UndefOr[String]
    var VpcId: js.UndefOr[String]
  }

  object CreateVpcPeeringConnectionRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PeerOwnerId: js.UndefOr[String] = js.undefined,
        PeerRegion: js.UndefOr[String] = js.undefined,
        PeerVpcId: js.UndefOr[String] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): CreateVpcPeeringConnectionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PeerOwnerId" -> PeerOwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PeerRegion" -> PeerRegion.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PeerVpcId" -> PeerVpcId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVpcPeeringConnectionRequest]
    }
  }

  @js.native
  trait CreateVpcPeeringConnectionResult extends js.Object {
    var VpcPeeringConnection: js.UndefOr[VpcPeeringConnection]
  }

  object CreateVpcPeeringConnectionResult {
    def apply(
        VpcPeeringConnection: js.UndefOr[VpcPeeringConnection] = js.undefined
    ): CreateVpcPeeringConnectionResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcPeeringConnection" -> VpcPeeringConnection.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVpcPeeringConnectionResult]
    }
  }

  @js.native
  trait CreateVpcRequest extends js.Object {
    var CidrBlock: String
    var AmazonProvidedIpv6CidrBlock: js.UndefOr[Boolean]
    var DryRun: js.UndefOr[Boolean]
    var InstanceTenancy: js.UndefOr[Tenancy]
  }

  object CreateVpcRequest {
    def apply(
        CidrBlock: String,
        AmazonProvidedIpv6CidrBlock: js.UndefOr[Boolean] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        InstanceTenancy: js.UndefOr[Tenancy] = js.undefined
    ): CreateVpcRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CidrBlock" -> CidrBlock.asInstanceOf[js.Any],
        "AmazonProvidedIpv6CidrBlock" -> AmazonProvidedIpv6CidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceTenancy" -> InstanceTenancy.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVpcRequest]
    }
  }

  @js.native
  trait CreateVpcResult extends js.Object {
    var Vpc: js.UndefOr[Vpc]
  }

  object CreateVpcResult {
    def apply(
        Vpc: js.UndefOr[Vpc] = js.undefined
    ): CreateVpcResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Vpc" -> Vpc.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVpcResult]
    }
  }

  /**
    * Contains the parameters for CreateVpnConnection.
    */
  @js.native
  trait CreateVpnConnectionRequest extends js.Object {
    var CustomerGatewayId: String
    var Type: String
    var DryRun: js.UndefOr[Boolean]
    var Options: js.UndefOr[VpnConnectionOptionsSpecification]
    var TransitGatewayId: js.UndefOr[String]
    var VpnGatewayId: js.UndefOr[String]
  }

  object CreateVpnConnectionRequest {
    def apply(
        CustomerGatewayId: String,
        Type: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Options: js.UndefOr[VpnConnectionOptionsSpecification] = js.undefined,
        TransitGatewayId: js.UndefOr[String] = js.undefined,
        VpnGatewayId: js.UndefOr[String] = js.undefined
    ): CreateVpnConnectionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CustomerGatewayId" -> CustomerGatewayId.asInstanceOf[js.Any],
        "Type"              -> Type.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Options" -> Options.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGatewayId" -> TransitGatewayId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpnGatewayId" -> VpnGatewayId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVpnConnectionRequest]
    }
  }

  /**
    * Contains the output of CreateVpnConnection.
    */
  @js.native
  trait CreateVpnConnectionResult extends js.Object {
    var VpnConnection: js.UndefOr[VpnConnection]
  }

  object CreateVpnConnectionResult {
    def apply(
        VpnConnection: js.UndefOr[VpnConnection] = js.undefined
    ): CreateVpnConnectionResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpnConnection" -> VpnConnection.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVpnConnectionResult]
    }
  }

  /**
    * Contains the parameters for CreateVpnConnectionRoute.
    */
  @js.native
  trait CreateVpnConnectionRouteRequest extends js.Object {
    var DestinationCidrBlock: String
    var VpnConnectionId: String
  }

  object CreateVpnConnectionRouteRequest {
    def apply(
        DestinationCidrBlock: String,
        VpnConnectionId: String
    ): CreateVpnConnectionRouteRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DestinationCidrBlock" -> DestinationCidrBlock.asInstanceOf[js.Any],
        "VpnConnectionId"      -> VpnConnectionId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVpnConnectionRouteRequest]
    }
  }

  /**
    * Contains the parameters for CreateVpnGateway.
    */
  @js.native
  trait CreateVpnGatewayRequest extends js.Object {
    var Type: GatewayType
    var AmazonSideAsn: js.UndefOr[Double]
    var AvailabilityZone: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateVpnGatewayRequest {
    def apply(
        Type: GatewayType,
        AmazonSideAsn: js.UndefOr[Double] = js.undefined,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateVpnGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Type" -> Type.asInstanceOf[js.Any],
        "AmazonSideAsn" -> AmazonSideAsn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVpnGatewayRequest]
    }
  }

  /**
    * Contains the output of CreateVpnGateway.
    */
  @js.native
  trait CreateVpnGatewayResult extends js.Object {
    var VpnGateway: js.UndefOr[VpnGateway]
  }

  object CreateVpnGatewayResult {
    def apply(
        VpnGateway: js.UndefOr[VpnGateway] = js.undefined
    ): CreateVpnGatewayResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpnGateway" -> VpnGateway.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreateVpnGatewayResult]
    }
  }

  /**
    * Describes the credit option for CPU usage of a T2 or T3 instance.
    */
  @js.native
  trait CreditSpecification extends js.Object {
    var CpuCredits: js.UndefOr[String]
  }

  object CreditSpecification {
    def apply(
        CpuCredits: js.UndefOr[String] = js.undefined
    ): CreditSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CpuCredits" -> CpuCredits.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreditSpecification]
    }
  }

  /**
    * The credit option for CPU usage of a T2 or T3 instance.
    */
  @js.native
  trait CreditSpecificationRequest extends js.Object {
    var CpuCredits: String
  }

  object CreditSpecificationRequest {
    def apply(
        CpuCredits: String
    ): CreditSpecificationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CpuCredits" -> CpuCredits.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CreditSpecificationRequest]
    }
  }

  object CurrencyCodeValuesEnum {
    val USD = "USD"

    val values = IndexedSeq(USD)
  }

  /**
    * Describes a customer gateway.
    */
  @js.native
  trait CustomerGateway extends js.Object {
    var BgpAsn: js.UndefOr[String]
    var CustomerGatewayId: js.UndefOr[String]
    var IpAddress: js.UndefOr[String]
    var State: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
    var Type: js.UndefOr[String]
  }

  object CustomerGateway {
    def apply(
        BgpAsn: js.UndefOr[String] = js.undefined,
        CustomerGatewayId: js.UndefOr[String] = js.undefined,
        IpAddress: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        Type: js.UndefOr[String] = js.undefined
    ): CustomerGateway = {
      val _fields = IndexedSeq[(String, js.Any)](
        "BgpAsn" -> BgpAsn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CustomerGatewayId" -> CustomerGatewayId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IpAddress" -> IpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Type" -> Type.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[CustomerGateway]
    }
  }

  object DatafeedSubscriptionStateEnum {
    val Active   = "Active"
    val Inactive = "Inactive"

    val values = IndexedSeq(Active, Inactive)
  }

  object DefaultRouteTableAssociationValueEnum {
    val enable  = "enable"
    val disable = "disable"

    val values = IndexedSeq(enable, disable)
  }

  object DefaultRouteTablePropagationValueEnum {
    val enable  = "enable"
    val disable = "disable"

    val values = IndexedSeq(enable, disable)
  }

  object DefaultTargetCapacityTypeEnum {
    val spot        = "spot"
    val `on-demand` = "on-demand"

    val values = IndexedSeq(spot, `on-demand`)
  }

  @js.native
  trait DeleteClientVpnEndpointRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteClientVpnEndpointRequest {
    def apply(
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteClientVpnEndpointRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteClientVpnEndpointRequest]
    }
  }

  @js.native
  trait DeleteClientVpnEndpointResult extends js.Object {
    var Status: js.UndefOr[ClientVpnEndpointStatus]
  }

  object DeleteClientVpnEndpointResult {
    def apply(
        Status: js.UndefOr[ClientVpnEndpointStatus] = js.undefined
    ): DeleteClientVpnEndpointResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteClientVpnEndpointResult]
    }
  }

  @js.native
  trait DeleteClientVpnRouteRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DestinationCidrBlock: String
    var DryRun: js.UndefOr[Boolean]
    var TargetVpcSubnetId: js.UndefOr[String]
  }

  object DeleteClientVpnRouteRequest {
    def apply(
        ClientVpnEndpointId: String,
        DestinationCidrBlock: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TargetVpcSubnetId: js.UndefOr[String] = js.undefined
    ): DeleteClientVpnRouteRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId"  -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "DestinationCidrBlock" -> DestinationCidrBlock.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TargetVpcSubnetId" -> TargetVpcSubnetId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteClientVpnRouteRequest]
    }
  }

  @js.native
  trait DeleteClientVpnRouteResult extends js.Object {
    var Status: js.UndefOr[ClientVpnRouteStatus]
  }

  object DeleteClientVpnRouteResult {
    def apply(
        Status: js.UndefOr[ClientVpnRouteStatus] = js.undefined
    ): DeleteClientVpnRouteResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteClientVpnRouteResult]
    }
  }

  /**
    * Contains the parameters for DeleteCustomerGateway.
    */
  @js.native
  trait DeleteCustomerGatewayRequest extends js.Object {
    var CustomerGatewayId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteCustomerGatewayRequest {
    def apply(
        CustomerGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteCustomerGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CustomerGatewayId" -> CustomerGatewayId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteCustomerGatewayRequest]
    }
  }

  @js.native
  trait DeleteDhcpOptionsRequest extends js.Object {
    var DhcpOptionsId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteDhcpOptionsRequest {
    def apply(
        DhcpOptionsId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteDhcpOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DhcpOptionsId" -> DhcpOptionsId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteDhcpOptionsRequest]
    }
  }

  @js.native
  trait DeleteEgressOnlyInternetGatewayRequest extends js.Object {
    var EgressOnlyInternetGatewayId: EgressOnlyInternetGatewayId
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteEgressOnlyInternetGatewayRequest {
    def apply(
        EgressOnlyInternetGatewayId: EgressOnlyInternetGatewayId,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteEgressOnlyInternetGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "EgressOnlyInternetGatewayId" -> EgressOnlyInternetGatewayId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteEgressOnlyInternetGatewayRequest]
    }
  }

  @js.native
  trait DeleteEgressOnlyInternetGatewayResult extends js.Object {
    var ReturnCode: js.UndefOr[Boolean]
  }

  object DeleteEgressOnlyInternetGatewayResult {
    def apply(
        ReturnCode: js.UndefOr[Boolean] = js.undefined
    ): DeleteEgressOnlyInternetGatewayResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReturnCode" -> ReturnCode.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteEgressOnlyInternetGatewayResult]
    }
  }

  /**
    * Describes an EC2 Fleet error.
    */
  @js.native
  trait DeleteFleetError extends js.Object {
    var Code: js.UndefOr[DeleteFleetErrorCode]
    var Message: js.UndefOr[String]
  }

  object DeleteFleetError {
    def apply(
        Code: js.UndefOr[DeleteFleetErrorCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): DeleteFleetError = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Message" -> Message.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteFleetError]
    }
  }

  object DeleteFleetErrorCodeEnum {
    val fleetIdDoesNotExist      = "fleetIdDoesNotExist"
    val fleetIdMalformed         = "fleetIdMalformed"
    val fleetNotInDeletableState = "fleetNotInDeletableState"
    val unexpectedError          = "unexpectedError"

    val values = IndexedSeq(fleetIdDoesNotExist, fleetIdMalformed, fleetNotInDeletableState, unexpectedError)
  }

  /**
    * Describes an EC2 Fleet that was not successfully deleted.
    */
  @js.native
  trait DeleteFleetErrorItem extends js.Object {
    var Error: js.UndefOr[DeleteFleetError]
    var FleetId: js.UndefOr[FleetIdentifier]
  }

  object DeleteFleetErrorItem {
    def apply(
        Error: js.UndefOr[DeleteFleetError] = js.undefined,
        FleetId: js.UndefOr[FleetIdentifier] = js.undefined
    ): DeleteFleetErrorItem = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Error" -> Error.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FleetId" -> FleetId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteFleetErrorItem]
    }
  }

  /**
    * Describes an EC2 Fleet that was successfully deleted.
    */
  @js.native
  trait DeleteFleetSuccessItem extends js.Object {
    var CurrentFleetState: js.UndefOr[FleetStateCode]
    var FleetId: js.UndefOr[FleetIdentifier]
    var PreviousFleetState: js.UndefOr[FleetStateCode]
  }

  object DeleteFleetSuccessItem {
    def apply(
        CurrentFleetState: js.UndefOr[FleetStateCode] = js.undefined,
        FleetId: js.UndefOr[FleetIdentifier] = js.undefined,
        PreviousFleetState: js.UndefOr[FleetStateCode] = js.undefined
    ): DeleteFleetSuccessItem = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CurrentFleetState" -> CurrentFleetState.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FleetId" -> FleetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PreviousFleetState" -> PreviousFleetState.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteFleetSuccessItem]
    }
  }

  @js.native
  trait DeleteFleetsRequest extends js.Object {
    var FleetIds: FleetIdSet
    var TerminateInstances: Boolean
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteFleetsRequest {
    def apply(
        FleetIds: FleetIdSet,
        TerminateInstances: Boolean,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteFleetsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FleetIds"           -> FleetIds.asInstanceOf[js.Any],
        "TerminateInstances" -> TerminateInstances.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteFleetsRequest]
    }
  }

  @js.native
  trait DeleteFleetsResult extends js.Object {
    var SuccessfulFleetDeletions: js.UndefOr[DeleteFleetSuccessSet]
    var UnsuccessfulFleetDeletions: js.UndefOr[DeleteFleetErrorSet]
  }

  object DeleteFleetsResult {
    def apply(
        SuccessfulFleetDeletions: js.UndefOr[DeleteFleetSuccessSet] = js.undefined,
        UnsuccessfulFleetDeletions: js.UndefOr[DeleteFleetErrorSet] = js.undefined
    ): DeleteFleetsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SuccessfulFleetDeletions" -> SuccessfulFleetDeletions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UnsuccessfulFleetDeletions" -> UnsuccessfulFleetDeletions.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteFleetsResult]
    }
  }

  @js.native
  trait DeleteFlowLogsRequest extends js.Object {
    var FlowLogIds: ValueStringList
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteFlowLogsRequest {
    def apply(
        FlowLogIds: ValueStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteFlowLogsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FlowLogIds" -> FlowLogIds.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteFlowLogsRequest]
    }
  }

  @js.native
  trait DeleteFlowLogsResult extends js.Object {
    var Unsuccessful: js.UndefOr[UnsuccessfulItemSet]
  }

  object DeleteFlowLogsResult {
    def apply(
        Unsuccessful: js.UndefOr[UnsuccessfulItemSet] = js.undefined
    ): DeleteFlowLogsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Unsuccessful" -> Unsuccessful.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteFlowLogsResult]
    }
  }

  @js.native
  trait DeleteFpgaImageRequest extends js.Object {
    var FpgaImageId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteFpgaImageRequest {
    def apply(
        FpgaImageId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteFpgaImageRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FpgaImageId" -> FpgaImageId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteFpgaImageRequest]
    }
  }

  @js.native
  trait DeleteFpgaImageResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object DeleteFpgaImageResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): DeleteFpgaImageResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteFpgaImageResult]
    }
  }

  @js.native
  trait DeleteInternetGatewayRequest extends js.Object {
    var InternetGatewayId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteInternetGatewayRequest {
    def apply(
        InternetGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteInternetGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InternetGatewayId" -> InternetGatewayId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteInternetGatewayRequest]
    }
  }

  @js.native
  trait DeleteKeyPairRequest extends js.Object {
    var KeyName: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteKeyPairRequest {
    def apply(
        KeyName: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteKeyPairRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "KeyName" -> KeyName.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteKeyPairRequest]
    }
  }

  @js.native
  trait DeleteLaunchTemplateRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
  }

  object DeleteLaunchTemplateRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined
    ): DeleteLaunchTemplateRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateId" -> LaunchTemplateId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateName" -> LaunchTemplateName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteLaunchTemplateRequest]
    }
  }

  @js.native
  trait DeleteLaunchTemplateResult extends js.Object {
    var LaunchTemplate: js.UndefOr[LaunchTemplate]
  }

  object DeleteLaunchTemplateResult {
    def apply(
        LaunchTemplate: js.UndefOr[LaunchTemplate] = js.undefined
    ): DeleteLaunchTemplateResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplate" -> LaunchTemplate.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteLaunchTemplateResult]
    }
  }

  @js.native
  trait DeleteLaunchTemplateVersionsRequest extends js.Object {
    var Versions: VersionStringList
    var DryRun: js.UndefOr[Boolean]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
  }

  object DeleteLaunchTemplateVersionsRequest {
    def apply(
        Versions: VersionStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined
    ): DeleteLaunchTemplateVersionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Versions" -> Versions.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateId" -> LaunchTemplateId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateName" -> LaunchTemplateName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteLaunchTemplateVersionsRequest]
    }
  }

  /**
    * Describes a launch template version that could not be deleted.
    */
  @js.native
  trait DeleteLaunchTemplateVersionsResponseErrorItem extends js.Object {
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[String]
    var ResponseError: js.UndefOr[ResponseError]
    var VersionNumber: js.UndefOr[Double]
  }

  object DeleteLaunchTemplateVersionsResponseErrorItem {
    def apply(
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[String] = js.undefined,
        ResponseError: js.UndefOr[ResponseError] = js.undefined,
        VersionNumber: js.UndefOr[Double] = js.undefined
    ): DeleteLaunchTemplateVersionsResponseErrorItem = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateId" -> LaunchTemplateId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateName" -> LaunchTemplateName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ResponseError" -> ResponseError.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VersionNumber" -> VersionNumber.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DeleteLaunchTemplateVersionsResponseErrorItem]
    }
  }

  /**
    * Describes a launch template version that was successfully deleted.
    */
  @js.native
  trait DeleteLaunchTemplateVersionsResponseSuccessItem extends js.Object {
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[String]
    var VersionNumber: js.UndefOr[Double]
  }

  object DeleteLaunchTemplateVersionsResponseSuccessItem {
    def apply(
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[String] = js.undefined,
        VersionNumber: js.UndefOr[Double] = js.undefined
    ): DeleteLaunchTemplateVersionsResponseSuccessItem = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateId" -> LaunchTemplateId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateName" -> LaunchTemplateName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VersionNumber" -> VersionNumber.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DeleteLaunchTemplateVersionsResponseSuccessItem]
    }
  }

  @js.native
  trait DeleteLaunchTemplateVersionsResult extends js.Object {
    var SuccessfullyDeletedLaunchTemplateVersions: js.UndefOr[DeleteLaunchTemplateVersionsResponseSuccessSet]
    var UnsuccessfullyDeletedLaunchTemplateVersions: js.UndefOr[DeleteLaunchTemplateVersionsResponseErrorSet]
  }

  object DeleteLaunchTemplateVersionsResult {
    def apply(
        SuccessfullyDeletedLaunchTemplateVersions: js.UndefOr[DeleteLaunchTemplateVersionsResponseSuccessSet] =
          js.undefined,
        UnsuccessfullyDeletedLaunchTemplateVersions: js.UndefOr[DeleteLaunchTemplateVersionsResponseErrorSet] =
          js.undefined
    ): DeleteLaunchTemplateVersionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SuccessfullyDeletedLaunchTemplateVersions" -> SuccessfullyDeletedLaunchTemplateVersions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UnsuccessfullyDeletedLaunchTemplateVersions" -> UnsuccessfullyDeletedLaunchTemplateVersions.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteLaunchTemplateVersionsResult]
    }
  }

  @js.native
  trait DeleteNatGatewayRequest extends js.Object {
    var NatGatewayId: String
  }

  object DeleteNatGatewayRequest {
    def apply(
        NatGatewayId: String
    ): DeleteNatGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NatGatewayId" -> NatGatewayId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteNatGatewayRequest]
    }
  }

  @js.native
  trait DeleteNatGatewayResult extends js.Object {
    var NatGatewayId: js.UndefOr[String]
  }

  object DeleteNatGatewayResult {
    def apply(
        NatGatewayId: js.UndefOr[String] = js.undefined
    ): DeleteNatGatewayResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NatGatewayId" -> NatGatewayId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteNatGatewayResult]
    }
  }

  @js.native
  trait DeleteNetworkAclEntryRequest extends js.Object {
    var Egress: Boolean
    var NetworkAclId: String
    var RuleNumber: Int
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteNetworkAclEntryRequest {
    def apply(
        Egress: Boolean,
        NetworkAclId: String,
        RuleNumber: Int,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteNetworkAclEntryRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Egress"       -> Egress.asInstanceOf[js.Any],
        "NetworkAclId" -> NetworkAclId.asInstanceOf[js.Any],
        "RuleNumber"   -> RuleNumber.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteNetworkAclEntryRequest]
    }
  }

  @js.native
  trait DeleteNetworkAclRequest extends js.Object {
    var NetworkAclId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteNetworkAclRequest {
    def apply(
        NetworkAclId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteNetworkAclRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkAclId" -> NetworkAclId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteNetworkAclRequest]
    }
  }

  /**
    * Contains the parameters for DeleteNetworkInterfacePermission.
    */
  @js.native
  trait DeleteNetworkInterfacePermissionRequest extends js.Object {
    var NetworkInterfacePermissionId: String
    var DryRun: js.UndefOr[Boolean]
    var Force: js.UndefOr[Boolean]
  }

  object DeleteNetworkInterfacePermissionRequest {
    def apply(
        NetworkInterfacePermissionId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Force: js.UndefOr[Boolean] = js.undefined
    ): DeleteNetworkInterfacePermissionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkInterfacePermissionId" -> NetworkInterfacePermissionId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Force" -> Force.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteNetworkInterfacePermissionRequest]
    }
  }

  /**
    * Contains the output for DeleteNetworkInterfacePermission.
    */
  @js.native
  trait DeleteNetworkInterfacePermissionResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object DeleteNetworkInterfacePermissionResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): DeleteNetworkInterfacePermissionResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteNetworkInterfacePermissionResult]
    }
  }

  /**
    * Contains the parameters for DeleteNetworkInterface.
    */
  @js.native
  trait DeleteNetworkInterfaceRequest extends js.Object {
    var NetworkInterfaceId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteNetworkInterfaceRequest {
    def apply(
        NetworkInterfaceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteNetworkInterfaceRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteNetworkInterfaceRequest]
    }
  }

  @js.native
  trait DeletePlacementGroupRequest extends js.Object {
    var GroupName: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeletePlacementGroupRequest {
    def apply(
        GroupName: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeletePlacementGroupRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "GroupName" -> GroupName.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeletePlacementGroupRequest]
    }
  }

  @js.native
  trait DeleteRouteRequest extends js.Object {
    var RouteTableId: String
    var DestinationCidrBlock: js.UndefOr[String]
    var DestinationIpv6CidrBlock: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteRouteRequest {
    def apply(
        RouteTableId: String,
        DestinationCidrBlock: js.UndefOr[String] = js.undefined,
        DestinationIpv6CidrBlock: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteRouteRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "RouteTableId" -> RouteTableId.asInstanceOf[js.Any],
        "DestinationCidrBlock" -> DestinationCidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DestinationIpv6CidrBlock" -> DestinationIpv6CidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteRouteRequest]
    }
  }

  @js.native
  trait DeleteRouteTableRequest extends js.Object {
    var RouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteRouteTableRequest {
    def apply(
        RouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteRouteTableRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "RouteTableId" -> RouteTableId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteRouteTableRequest]
    }
  }

  @js.native
  trait DeleteSecurityGroupRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var GroupId: js.UndefOr[String]
    var GroupName: js.UndefOr[String]
  }

  object DeleteSecurityGroupRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        GroupId: js.UndefOr[String] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined
    ): DeleteSecurityGroupRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupId" -> GroupId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupName" -> GroupName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteSecurityGroupRequest]
    }
  }

  /**
    * Contains the parameters for DeleteSnapshot.
    */
  @js.native
  trait DeleteSnapshotRequest extends js.Object {
    var SnapshotId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteSnapshotRequest {
    def apply(
        SnapshotId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteSnapshotRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SnapshotId" -> SnapshotId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteSnapshotRequest]
    }
  }

  /**
    * Contains the parameters for DeleteSpotDatafeedSubscription.
    */
  @js.native
  trait DeleteSpotDatafeedSubscriptionRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteSpotDatafeedSubscriptionRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteSpotDatafeedSubscriptionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteSpotDatafeedSubscriptionRequest]
    }
  }

  @js.native
  trait DeleteSubnetRequest extends js.Object {
    var SubnetId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteSubnetRequest {
    def apply(
        SubnetId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteSubnetRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SubnetId" -> SubnetId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteSubnetRequest]
    }
  }

  @js.native
  trait DeleteTagsRequest extends js.Object {
    var Resources: ResourceIdList
    var DryRun: js.UndefOr[Boolean]
    var Tags: js.UndefOr[TagList]
  }

  object DeleteTagsRequest {
    def apply(
        Resources: ResourceIdList,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): DeleteTagsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Resources" -> Resources.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteTagsRequest]
    }
  }

  @js.native
  trait DeleteTransitGatewayRequest extends js.Object {
    var TransitGatewayId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteTransitGatewayRequest {
    def apply(
        TransitGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteTransitGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayId" -> TransitGatewayId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteTransitGatewayRequest]
    }
  }

  @js.native
  trait DeleteTransitGatewayResult extends js.Object {
    var TransitGateway: js.UndefOr[TransitGateway]
  }

  object DeleteTransitGatewayResult {
    def apply(
        TransitGateway: js.UndefOr[TransitGateway] = js.undefined
    ): DeleteTransitGatewayResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGateway" -> TransitGateway.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteTransitGatewayResult]
    }
  }

  @js.native
  trait DeleteTransitGatewayRouteRequest extends js.Object {
    var DestinationCidrBlock: String
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteTransitGatewayRouteRequest {
    def apply(
        DestinationCidrBlock: String,
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteTransitGatewayRouteRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DestinationCidrBlock"       -> DestinationCidrBlock.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteTransitGatewayRouteRequest]
    }
  }

  @js.native
  trait DeleteTransitGatewayRouteResult extends js.Object {
    var Route: js.UndefOr[TransitGatewayRoute]
  }

  object DeleteTransitGatewayRouteResult {
    def apply(
        Route: js.UndefOr[TransitGatewayRoute] = js.undefined
    ): DeleteTransitGatewayRouteResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Route" -> Route.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteTransitGatewayRouteResult]
    }
  }

  @js.native
  trait DeleteTransitGatewayRouteTableRequest extends js.Object {
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteTransitGatewayRouteTableRequest {
    def apply(
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteTransitGatewayRouteTableRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteTransitGatewayRouteTableRequest]
    }
  }

  @js.native
  trait DeleteTransitGatewayRouteTableResult extends js.Object {
    var TransitGatewayRouteTable: js.UndefOr[TransitGatewayRouteTable]
  }

  object DeleteTransitGatewayRouteTableResult {
    def apply(
        TransitGatewayRouteTable: js.UndefOr[TransitGatewayRouteTable] = js.undefined
    ): DeleteTransitGatewayRouteTableResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayRouteTable" -> TransitGatewayRouteTable.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteTransitGatewayRouteTableResult]
    }
  }

  @js.native
  trait DeleteTransitGatewayVpcAttachmentRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteTransitGatewayVpcAttachmentRequest {
    def apply(
        TransitGatewayAttachmentId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteTransitGatewayVpcAttachmentRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteTransitGatewayVpcAttachmentRequest]
    }
  }

  @js.native
  trait DeleteTransitGatewayVpcAttachmentResult extends js.Object {
    var TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment]
  }

  object DeleteTransitGatewayVpcAttachmentResult {
    def apply(
        TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment] = js.undefined
    ): DeleteTransitGatewayVpcAttachmentResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayVpcAttachment" -> TransitGatewayVpcAttachment.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteTransitGatewayVpcAttachmentResult]
    }
  }

  /**
    * Contains the parameters for DeleteVolume.
    */
  @js.native
  trait DeleteVolumeRequest extends js.Object {
    var VolumeId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVolumeRequest {
    def apply(
        VolumeId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVolumeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VolumeId" -> VolumeId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteVolumeRequest]
    }
  }

  @js.native
  trait DeleteVpcEndpointConnectionNotificationsRequest extends js.Object {
    var ConnectionNotificationIds: ValueStringList
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpcEndpointConnectionNotificationsRequest {
    def apply(
        ConnectionNotificationIds: ValueStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpcEndpointConnectionNotificationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ConnectionNotificationIds" -> ConnectionNotificationIds.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DeleteVpcEndpointConnectionNotificationsRequest]
    }
  }

  @js.native
  trait DeleteVpcEndpointConnectionNotificationsResult extends js.Object {
    var Unsuccessful: js.UndefOr[UnsuccessfulItemSet]
  }

  object DeleteVpcEndpointConnectionNotificationsResult {
    def apply(
        Unsuccessful: js.UndefOr[UnsuccessfulItemSet] = js.undefined
    ): DeleteVpcEndpointConnectionNotificationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Unsuccessful" -> Unsuccessful.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DeleteVpcEndpointConnectionNotificationsResult]
    }
  }

  @js.native
  trait DeleteVpcEndpointServiceConfigurationsRequest extends js.Object {
    var ServiceIds: ValueStringList
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpcEndpointServiceConfigurationsRequest {
    def apply(
        ServiceIds: ValueStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpcEndpointServiceConfigurationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ServiceIds" -> ServiceIds.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DeleteVpcEndpointServiceConfigurationsRequest]
    }
  }

  @js.native
  trait DeleteVpcEndpointServiceConfigurationsResult extends js.Object {
    var Unsuccessful: js.UndefOr[UnsuccessfulItemSet]
  }

  object DeleteVpcEndpointServiceConfigurationsResult {
    def apply(
        Unsuccessful: js.UndefOr[UnsuccessfulItemSet] = js.undefined
    ): DeleteVpcEndpointServiceConfigurationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Unsuccessful" -> Unsuccessful.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DeleteVpcEndpointServiceConfigurationsResult]
    }
  }

  /**
    * Contains the parameters for DeleteVpcEndpoints.
    */
  @js.native
  trait DeleteVpcEndpointsRequest extends js.Object {
    var VpcEndpointIds: ValueStringList
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpcEndpointsRequest {
    def apply(
        VpcEndpointIds: ValueStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpcEndpointsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcEndpointIds" -> VpcEndpointIds.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteVpcEndpointsRequest]
    }
  }

  /**
    * Contains the output of DeleteVpcEndpoints.
    */
  @js.native
  trait DeleteVpcEndpointsResult extends js.Object {
    var Unsuccessful: js.UndefOr[UnsuccessfulItemSet]
  }

  object DeleteVpcEndpointsResult {
    def apply(
        Unsuccessful: js.UndefOr[UnsuccessfulItemSet] = js.undefined
    ): DeleteVpcEndpointsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Unsuccessful" -> Unsuccessful.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteVpcEndpointsResult]
    }
  }

  @js.native
  trait DeleteVpcPeeringConnectionRequest extends js.Object {
    var VpcPeeringConnectionId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpcPeeringConnectionRequest {
    def apply(
        VpcPeeringConnectionId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpcPeeringConnectionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcPeeringConnectionId" -> VpcPeeringConnectionId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteVpcPeeringConnectionRequest]
    }
  }

  @js.native
  trait DeleteVpcPeeringConnectionResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object DeleteVpcPeeringConnectionResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpcPeeringConnectionResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteVpcPeeringConnectionResult]
    }
  }

  @js.native
  trait DeleteVpcRequest extends js.Object {
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpcRequest {
    def apply(
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpcRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId" -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteVpcRequest]
    }
  }

  /**
    * Contains the parameters for DeleteVpnConnection.
    */
  @js.native
  trait DeleteVpnConnectionRequest extends js.Object {
    var VpnConnectionId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpnConnectionRequest {
    def apply(
        VpnConnectionId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpnConnectionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpnConnectionId" -> VpnConnectionId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteVpnConnectionRequest]
    }
  }

  /**
    * Contains the parameters for DeleteVpnConnectionRoute.
    */
  @js.native
  trait DeleteVpnConnectionRouteRequest extends js.Object {
    var DestinationCidrBlock: String
    var VpnConnectionId: String
  }

  object DeleteVpnConnectionRouteRequest {
    def apply(
        DestinationCidrBlock: String,
        VpnConnectionId: String
    ): DeleteVpnConnectionRouteRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DestinationCidrBlock" -> DestinationCidrBlock.asInstanceOf[js.Any],
        "VpnConnectionId"      -> VpnConnectionId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteVpnConnectionRouteRequest]
    }
  }

  /**
    * Contains the parameters for DeleteVpnGateway.
    */
  @js.native
  trait DeleteVpnGatewayRequest extends js.Object {
    var VpnGatewayId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpnGatewayRequest {
    def apply(
        VpnGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpnGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpnGatewayId" -> VpnGatewayId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeleteVpnGatewayRequest]
    }
  }

  @js.native
  trait DeprovisionByoipCidrRequest extends js.Object {
    var Cidr: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeprovisionByoipCidrRequest {
    def apply(
        Cidr: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeprovisionByoipCidrRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Cidr" -> Cidr.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeprovisionByoipCidrRequest]
    }
  }

  @js.native
  trait DeprovisionByoipCidrResult extends js.Object {
    var ByoipCidr: js.UndefOr[ByoipCidr]
  }

  object DeprovisionByoipCidrResult {
    def apply(
        ByoipCidr: js.UndefOr[ByoipCidr] = js.undefined
    ): DeprovisionByoipCidrResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ByoipCidr" -> ByoipCidr.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeprovisionByoipCidrResult]
    }
  }

  /**
    * Contains the parameters for DeregisterImage.
    */
  @js.native
  trait DeregisterImageRequest extends js.Object {
    var ImageId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeregisterImageRequest {
    def apply(
        ImageId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeregisterImageRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ImageId" -> ImageId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DeregisterImageRequest]
    }
  }

  @js.native
  trait DescribeAccountAttributesRequest extends js.Object {
    var AttributeNames: js.UndefOr[AccountAttributeNameStringList]
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeAccountAttributesRequest {
    def apply(
        AttributeNames: js.UndefOr[AccountAttributeNameStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeAccountAttributesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AttributeNames" -> AttributeNames.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeAccountAttributesRequest]
    }
  }

  @js.native
  trait DescribeAccountAttributesResult extends js.Object {
    var AccountAttributes: js.UndefOr[AccountAttributeList]
  }

  object DescribeAccountAttributesResult {
    def apply(
        AccountAttributes: js.UndefOr[AccountAttributeList] = js.undefined
    ): DescribeAccountAttributesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AccountAttributes" -> AccountAttributes.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeAccountAttributesResult]
    }
  }

  @js.native
  trait DescribeAddressesRequest extends js.Object {
    var AllocationIds: js.UndefOr[AllocationIdList]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var PublicIps: js.UndefOr[PublicIpStringList]
  }

  object DescribeAddressesRequest {
    def apply(
        AllocationIds: js.UndefOr[AllocationIdList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        PublicIps: js.UndefOr[PublicIpStringList] = js.undefined
    ): DescribeAddressesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllocationIds" -> AllocationIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIps" -> PublicIps.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeAddressesRequest]
    }
  }

  @js.native
  trait DescribeAddressesResult extends js.Object {
    var Addresses: js.UndefOr[AddressList]
  }

  object DescribeAddressesResult {
    def apply(
        Addresses: js.UndefOr[AddressList] = js.undefined
    ): DescribeAddressesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Addresses" -> Addresses.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeAddressesResult]
    }
  }

  @js.native
  trait DescribeAggregateIdFormatRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeAggregateIdFormatRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeAggregateIdFormatRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeAggregateIdFormatRequest]
    }
  }

  @js.native
  trait DescribeAggregateIdFormatResult extends js.Object {
    var Statuses: js.UndefOr[IdFormatList]
    var UseLongIdsAggregated: js.UndefOr[Boolean]
  }

  object DescribeAggregateIdFormatResult {
    def apply(
        Statuses: js.UndefOr[IdFormatList] = js.undefined,
        UseLongIdsAggregated: js.UndefOr[Boolean] = js.undefined
    ): DescribeAggregateIdFormatResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Statuses" -> Statuses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UseLongIdsAggregated" -> UseLongIdsAggregated.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeAggregateIdFormatResult]
    }
  }

  @js.native
  trait DescribeAvailabilityZonesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var ZoneIds: js.UndefOr[ZoneIdStringList]
    var ZoneNames: js.UndefOr[ZoneNameStringList]
  }

  object DescribeAvailabilityZonesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        ZoneIds: js.UndefOr[ZoneIdStringList] = js.undefined,
        ZoneNames: js.UndefOr[ZoneNameStringList] = js.undefined
    ): DescribeAvailabilityZonesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ZoneIds" -> ZoneIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ZoneNames" -> ZoneNames.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeAvailabilityZonesRequest]
    }
  }

  @js.native
  trait DescribeAvailabilityZonesResult extends js.Object {
    var AvailabilityZones: js.UndefOr[AvailabilityZoneList]
  }

  object DescribeAvailabilityZonesResult {
    def apply(
        AvailabilityZones: js.UndefOr[AvailabilityZoneList] = js.undefined
    ): DescribeAvailabilityZonesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZones" -> AvailabilityZones.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeAvailabilityZonesResult]
    }
  }

  /**
    * Contains the parameters for DescribeBundleTasks.
    */
  @js.native
  trait DescribeBundleTasksRequest extends js.Object {
    var BundleIds: js.UndefOr[BundleIdStringList]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
  }

  object DescribeBundleTasksRequest {
    def apply(
        BundleIds: js.UndefOr[BundleIdStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined
    ): DescribeBundleTasksRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "BundleIds" -> BundleIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeBundleTasksRequest]
    }
  }

  /**
    * Contains the output of DescribeBundleTasks.
    */
  @js.native
  trait DescribeBundleTasksResult extends js.Object {
    var BundleTasks: js.UndefOr[BundleTaskList]
  }

  object DescribeBundleTasksResult {
    def apply(
        BundleTasks: js.UndefOr[BundleTaskList] = js.undefined
    ): DescribeBundleTasksResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "BundleTasks" -> BundleTasks.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeBundleTasksResult]
    }
  }

  @js.native
  trait DescribeByoipCidrsRequest extends js.Object {
    var MaxResults: MaxResults
    var DryRun: js.UndefOr[Boolean]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeByoipCidrsRequest {
    def apply(
        MaxResults: MaxResults,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeByoipCidrsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "MaxResults" -> MaxResults.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeByoipCidrsRequest]
    }
  }

  @js.native
  trait DescribeByoipCidrsResult extends js.Object {
    var ByoipCidrs: js.UndefOr[ByoipCidrSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeByoipCidrsResult {
    def apply(
        ByoipCidrs: js.UndefOr[ByoipCidrSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeByoipCidrsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ByoipCidrs" -> ByoipCidrs.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeByoipCidrsResult]
    }
  }

  @js.native
  trait DescribeCapacityReservationsRequest extends js.Object {
    var CapacityReservationIds: js.UndefOr[CapacityReservationIdSet]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeCapacityReservationsRequest {
    def apply(
        CapacityReservationIds: js.UndefOr[CapacityReservationIdSet] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeCapacityReservationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CapacityReservationIds" -> CapacityReservationIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeCapacityReservationsRequest]
    }
  }

  @js.native
  trait DescribeCapacityReservationsResult extends js.Object {
    var CapacityReservations: js.UndefOr[CapacityReservationSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeCapacityReservationsResult {
    def apply(
        CapacityReservations: js.UndefOr[CapacityReservationSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeCapacityReservationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CapacityReservations" -> CapacityReservations.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeCapacityReservationsResult]
    }
  }

  @js.native
  trait DescribeClassicLinkInstancesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var InstanceIds: js.UndefOr[InstanceIdStringList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeClassicLinkInstancesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        InstanceIds: js.UndefOr[InstanceIdStringList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeClassicLinkInstancesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceIds" -> InstanceIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeClassicLinkInstancesRequest]
    }
  }

  @js.native
  trait DescribeClassicLinkInstancesResult extends js.Object {
    var Instances: js.UndefOr[ClassicLinkInstanceList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeClassicLinkInstancesResult {
    def apply(
        Instances: js.UndefOr[ClassicLinkInstanceList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeClassicLinkInstancesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Instances" -> Instances.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeClassicLinkInstancesResult]
    }
  }

  @js.native
  trait DescribeClientVpnAuthorizationRulesRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[MaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnAuthorizationRulesRequest {
    def apply(
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[MaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnAuthorizationRulesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeClientVpnAuthorizationRulesRequest]
    }
  }

  @js.native
  trait DescribeClientVpnAuthorizationRulesResult extends js.Object {
    var AuthorizationRules: js.UndefOr[AuthorizationRuleSet]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnAuthorizationRulesResult {
    def apply(
        AuthorizationRules: js.UndefOr[AuthorizationRuleSet] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnAuthorizationRulesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AuthorizationRules" -> AuthorizationRules.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeClientVpnAuthorizationRulesResult]
    }
  }

  @js.native
  trait DescribeClientVpnConnectionsRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[MaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnConnectionsRequest {
    def apply(
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[MaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnConnectionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeClientVpnConnectionsRequest]
    }
  }

  @js.native
  trait DescribeClientVpnConnectionsResult extends js.Object {
    var Connections: js.UndefOr[ClientVpnConnectionSet]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnConnectionsResult {
    def apply(
        Connections: js.UndefOr[ClientVpnConnectionSet] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnConnectionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Connections" -> Connections.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeClientVpnConnectionsResult]
    }
  }

  @js.native
  trait DescribeClientVpnEndpointsRequest extends js.Object {
    var ClientVpnEndpointIds: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[MaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnEndpointsRequest {
    def apply(
        ClientVpnEndpointIds: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[MaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnEndpointsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointIds" -> ClientVpnEndpointIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeClientVpnEndpointsRequest]
    }
  }

  @js.native
  trait DescribeClientVpnEndpointsResult extends js.Object {
    var ClientVpnEndpoints: js.UndefOr[EndpointSet]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnEndpointsResult {
    def apply(
        ClientVpnEndpoints: js.UndefOr[EndpointSet] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnEndpointsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpoints" -> ClientVpnEndpoints.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeClientVpnEndpointsResult]
    }
  }

  @js.native
  trait DescribeClientVpnRoutesRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[MaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnRoutesRequest {
    def apply(
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[MaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnRoutesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeClientVpnRoutesRequest]
    }
  }

  @js.native
  trait DescribeClientVpnRoutesResult extends js.Object {
    var NextToken: js.UndefOr[NextToken]
    var Routes: js.UndefOr[ClientVpnRouteSet]
  }

  object DescribeClientVpnRoutesResult {
    def apply(
        NextToken: js.UndefOr[NextToken] = js.undefined,
        Routes: js.UndefOr[ClientVpnRouteSet] = js.undefined
    ): DescribeClientVpnRoutesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Routes" -> Routes.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeClientVpnRoutesResult]
    }
  }

  @js.native
  trait DescribeClientVpnTargetNetworksRequest extends js.Object {
    var ClientVpnEndpointId: String
    var AssociationIds: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[MaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnTargetNetworksRequest {
    def apply(
        ClientVpnEndpointId: String,
        AssociationIds: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[MaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnTargetNetworksRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "AssociationIds" -> AssociationIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeClientVpnTargetNetworksRequest]
    }
  }

  @js.native
  trait DescribeClientVpnTargetNetworksResult extends js.Object {
    var ClientVpnTargetNetworks: js.UndefOr[TargetNetworkSet]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnTargetNetworksResult {
    def apply(
        ClientVpnTargetNetworks: js.UndefOr[TargetNetworkSet] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnTargetNetworksResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnTargetNetworks" -> ClientVpnTargetNetworks.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeClientVpnTargetNetworksResult]
    }
  }

  /**
    * Contains the parameters for DescribeConversionTasks.
    */
  @js.native
  trait DescribeConversionTasksRequest extends js.Object {
    var ConversionTaskIds: js.UndefOr[ConversionIdStringList]
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeConversionTasksRequest {
    def apply(
        ConversionTaskIds: js.UndefOr[ConversionIdStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeConversionTasksRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ConversionTaskIds" -> ConversionTaskIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeConversionTasksRequest]
    }
  }

  /**
    * Contains the output for DescribeConversionTasks.
    */
  @js.native
  trait DescribeConversionTasksResult extends js.Object {
    var ConversionTasks: js.UndefOr[DescribeConversionTaskList]
  }

  object DescribeConversionTasksResult {
    def apply(
        ConversionTasks: js.UndefOr[DescribeConversionTaskList] = js.undefined
    ): DescribeConversionTasksResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ConversionTasks" -> ConversionTasks.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeConversionTasksResult]
    }
  }

  /**
    * Contains the parameters for DescribeCustomerGateways.
    */
  @js.native
  trait DescribeCustomerGatewaysRequest extends js.Object {
    var CustomerGatewayIds: js.UndefOr[CustomerGatewayIdStringList]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
  }

  object DescribeCustomerGatewaysRequest {
    def apply(
        CustomerGatewayIds: js.UndefOr[CustomerGatewayIdStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined
    ): DescribeCustomerGatewaysRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CustomerGatewayIds" -> CustomerGatewayIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeCustomerGatewaysRequest]
    }
  }

  /**
    * Contains the output of DescribeCustomerGateways.
    */
  @js.native
  trait DescribeCustomerGatewaysResult extends js.Object {
    var CustomerGateways: js.UndefOr[CustomerGatewayList]
  }

  object DescribeCustomerGatewaysResult {
    def apply(
        CustomerGateways: js.UndefOr[CustomerGatewayList] = js.undefined
    ): DescribeCustomerGatewaysResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CustomerGateways" -> CustomerGateways.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeCustomerGatewaysResult]
    }
  }

  @js.native
  trait DescribeDhcpOptionsRequest extends js.Object {
    var DhcpOptionsIds: js.UndefOr[DhcpOptionsIdStringList]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
  }

  object DescribeDhcpOptionsRequest {
    def apply(
        DhcpOptionsIds: js.UndefOr[DhcpOptionsIdStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined
    ): DescribeDhcpOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DhcpOptionsIds" -> DhcpOptionsIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeDhcpOptionsRequest]
    }
  }

  @js.native
  trait DescribeDhcpOptionsResult extends js.Object {
    var DhcpOptions: js.UndefOr[DhcpOptionsList]
  }

  object DescribeDhcpOptionsResult {
    def apply(
        DhcpOptions: js.UndefOr[DhcpOptionsList] = js.undefined
    ): DescribeDhcpOptionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DhcpOptions" -> DhcpOptions.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeDhcpOptionsResult]
    }
  }

  @js.native
  trait DescribeEgressOnlyInternetGatewaysRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var EgressOnlyInternetGatewayIds: js.UndefOr[EgressOnlyInternetGatewayIdList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeEgressOnlyInternetGatewaysRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EgressOnlyInternetGatewayIds: js.UndefOr[EgressOnlyInternetGatewayIdList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeEgressOnlyInternetGatewaysRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EgressOnlyInternetGatewayIds" -> EgressOnlyInternetGatewayIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeEgressOnlyInternetGatewaysRequest]
    }
  }

  @js.native
  trait DescribeEgressOnlyInternetGatewaysResult extends js.Object {
    var EgressOnlyInternetGateways: js.UndefOr[EgressOnlyInternetGatewayList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeEgressOnlyInternetGatewaysResult {
    def apply(
        EgressOnlyInternetGateways: js.UndefOr[EgressOnlyInternetGatewayList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeEgressOnlyInternetGatewaysResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "EgressOnlyInternetGateways" -> EgressOnlyInternetGateways.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeEgressOnlyInternetGatewaysResult]
    }
  }

  @js.native
  trait DescribeElasticGpusRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var ElasticGpuIds: js.UndefOr[ElasticGpuIdSet]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeElasticGpusRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ElasticGpuIds: js.UndefOr[ElasticGpuIdSet] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeElasticGpusRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticGpuIds" -> ElasticGpuIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeElasticGpusRequest]
    }
  }

  @js.native
  trait DescribeElasticGpusResult extends js.Object {
    var ElasticGpuSet: js.UndefOr[ElasticGpuSet]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeElasticGpusResult {
    def apply(
        ElasticGpuSet: js.UndefOr[ElasticGpuSet] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeElasticGpusResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ElasticGpuSet" -> ElasticGpuSet.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeElasticGpusResult]
    }
  }

  /**
    * Contains the parameters for DescribeExportTasks.
    */
  @js.native
  trait DescribeExportTasksRequest extends js.Object {
    var ExportTaskIds: js.UndefOr[ExportTaskIdStringList]
  }

  object DescribeExportTasksRequest {
    def apply(
        ExportTaskIds: js.UndefOr[ExportTaskIdStringList] = js.undefined
    ): DescribeExportTasksRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ExportTaskIds" -> ExportTaskIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeExportTasksRequest]
    }
  }

  /**
    * Contains the output for DescribeExportTasks.
    */
  @js.native
  trait DescribeExportTasksResult extends js.Object {
    var ExportTasks: js.UndefOr[ExportTaskList]
  }

  object DescribeExportTasksResult {
    def apply(
        ExportTasks: js.UndefOr[ExportTaskList] = js.undefined
    ): DescribeExportTasksResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ExportTasks" -> ExportTasks.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeExportTasksResult]
    }
  }

  /**
    * Describes the instances that could not be launched by the fleet.
    */
  @js.native
  trait DescribeFleetError extends js.Object {
    var ErrorCode: js.UndefOr[String]
    var ErrorMessage: js.UndefOr[String]
    var LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse]
    var Lifecycle: js.UndefOr[InstanceLifecycle]
  }

  object DescribeFleetError {
    def apply(
        ErrorCode: js.UndefOr[String] = js.undefined,
        ErrorMessage: js.UndefOr[String] = js.undefined,
        LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse] = js.undefined,
        Lifecycle: js.UndefOr[InstanceLifecycle] = js.undefined
    ): DescribeFleetError = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ErrorCode" -> ErrorCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ErrorMessage" -> ErrorMessage.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateAndOverrides" -> LaunchTemplateAndOverrides.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Lifecycle" -> Lifecycle.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFleetError]
    }
  }

  @js.native
  trait DescribeFleetHistoryRequest extends js.Object {
    var FleetId: FleetIdentifier
    var StartTime: DateTime
    var DryRun: js.UndefOr[Boolean]
    var EventType: js.UndefOr[FleetEventType]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFleetHistoryRequest {
    def apply(
        FleetId: FleetIdentifier,
        StartTime: DateTime,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EventType: js.UndefOr[FleetEventType] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFleetHistoryRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FleetId"   -> FleetId.asInstanceOf[js.Any],
        "StartTime" -> StartTime.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EventType" -> EventType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFleetHistoryRequest]
    }
  }

  @js.native
  trait DescribeFleetHistoryResult extends js.Object {
    var FleetId: js.UndefOr[FleetIdentifier]
    var HistoryRecords: js.UndefOr[HistoryRecordSet]
    var LastEvaluatedTime: js.UndefOr[DateTime]
    var NextToken: js.UndefOr[String]
    var StartTime: js.UndefOr[DateTime]
  }

  object DescribeFleetHistoryResult {
    def apply(
        FleetId: js.UndefOr[FleetIdentifier] = js.undefined,
        HistoryRecords: js.UndefOr[HistoryRecordSet] = js.undefined,
        LastEvaluatedTime: js.UndefOr[DateTime] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        StartTime: js.UndefOr[DateTime] = js.undefined
    ): DescribeFleetHistoryResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FleetId" -> FleetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HistoryRecords" -> HistoryRecords.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LastEvaluatedTime" -> LastEvaluatedTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StartTime" -> StartTime.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFleetHistoryResult]
    }
  }

  @js.native
  trait DescribeFleetInstancesRequest extends js.Object {
    var FleetId: FleetIdentifier
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFleetInstancesRequest {
    def apply(
        FleetId: FleetIdentifier,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFleetInstancesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FleetId" -> FleetId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFleetInstancesRequest]
    }
  }

  @js.native
  trait DescribeFleetInstancesResult extends js.Object {
    var ActiveInstances: js.UndefOr[ActiveInstanceSet]
    var FleetId: js.UndefOr[FleetIdentifier]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFleetInstancesResult {
    def apply(
        ActiveInstances: js.UndefOr[ActiveInstanceSet] = js.undefined,
        FleetId: js.UndefOr[FleetIdentifier] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFleetInstancesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ActiveInstances" -> ActiveInstances.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FleetId" -> FleetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFleetInstancesResult]
    }
  }

  /**
    * Describes the instances that were launched by the fleet.
    */
  @js.native
  trait DescribeFleetsInstances extends js.Object {
    var InstanceIds: js.UndefOr[InstanceIdsSet]
    var InstanceType: js.UndefOr[InstanceType]
    var LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse]
    var Lifecycle: js.UndefOr[InstanceLifecycle]
    var Platform: js.UndefOr[PlatformValues]
  }

  object DescribeFleetsInstances {
    def apply(
        InstanceIds: js.UndefOr[InstanceIdsSet] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse] = js.undefined,
        Lifecycle: js.UndefOr[InstanceLifecycle] = js.undefined,
        Platform: js.UndefOr[PlatformValues] = js.undefined
    ): DescribeFleetsInstances = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceIds" -> InstanceIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateAndOverrides" -> LaunchTemplateAndOverrides.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Lifecycle" -> Lifecycle.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Platform" -> Platform.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFleetsInstances]
    }
  }

  @js.native
  trait DescribeFleetsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var FleetIds: js.UndefOr[FleetIdSet]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFleetsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        FleetIds: js.UndefOr[FleetIdSet] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFleetsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FleetIds" -> FleetIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFleetsRequest]
    }
  }

  @js.native
  trait DescribeFleetsResult extends js.Object {
    var Fleets: js.UndefOr[FleetSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFleetsResult {
    def apply(
        Fleets: js.UndefOr[FleetSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFleetsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Fleets" -> Fleets.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFleetsResult]
    }
  }

  @js.native
  trait DescribeFlowLogsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filter: js.UndefOr[FilterList]
    var FlowLogIds: js.UndefOr[ValueStringList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFlowLogsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filter: js.UndefOr[FilterList] = js.undefined,
        FlowLogIds: js.UndefOr[ValueStringList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFlowLogsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filter" -> Filter.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FlowLogIds" -> FlowLogIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFlowLogsRequest]
    }
  }

  @js.native
  trait DescribeFlowLogsResult extends js.Object {
    var FlowLogs: js.UndefOr[FlowLogSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFlowLogsResult {
    def apply(
        FlowLogs: js.UndefOr[FlowLogSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFlowLogsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FlowLogs" -> FlowLogs.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFlowLogsResult]
    }
  }

  @js.native
  trait DescribeFpgaImageAttributeRequest extends js.Object {
    var Attribute: FpgaImageAttributeName
    var FpgaImageId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeFpgaImageAttributeRequest {
    def apply(
        Attribute: FpgaImageAttributeName,
        FpgaImageId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeFpgaImageAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Attribute"   -> Attribute.asInstanceOf[js.Any],
        "FpgaImageId" -> FpgaImageId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFpgaImageAttributeRequest]
    }
  }

  @js.native
  trait DescribeFpgaImageAttributeResult extends js.Object {
    var FpgaImageAttribute: js.UndefOr[FpgaImageAttribute]
  }

  object DescribeFpgaImageAttributeResult {
    def apply(
        FpgaImageAttribute: js.UndefOr[FpgaImageAttribute] = js.undefined
    ): DescribeFpgaImageAttributeResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FpgaImageAttribute" -> FpgaImageAttribute.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFpgaImageAttributeResult]
    }
  }

  @js.native
  trait DescribeFpgaImagesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var FpgaImageIds: js.UndefOr[FpgaImageIdList]
    var MaxResults: js.UndefOr[MaxResults]
    var NextToken: js.UndefOr[NextToken]
    var Owners: js.UndefOr[OwnerStringList]
  }

  object DescribeFpgaImagesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        FpgaImageIds: js.UndefOr[FpgaImageIdList] = js.undefined,
        MaxResults: js.UndefOr[MaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined,
        Owners: js.UndefOr[OwnerStringList] = js.undefined
    ): DescribeFpgaImagesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FpgaImageIds" -> FpgaImageIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Owners" -> Owners.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFpgaImagesRequest]
    }
  }

  @js.native
  trait DescribeFpgaImagesResult extends js.Object {
    var FpgaImages: js.UndefOr[FpgaImageList]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeFpgaImagesResult {
    def apply(
        FpgaImages: js.UndefOr[FpgaImageList] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeFpgaImagesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FpgaImages" -> FpgaImages.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeFpgaImagesResult]
    }
  }

  @js.native
  trait DescribeHostReservationOfferingsRequest extends js.Object {
    var Filter: js.UndefOr[FilterList]
    var MaxDuration: js.UndefOr[Int]
    var MaxResults: js.UndefOr[DescribeHostReservationsMaxResults]
    var MinDuration: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var OfferingId: js.UndefOr[String]
  }

  object DescribeHostReservationOfferingsRequest {
    def apply(
        Filter: js.UndefOr[FilterList] = js.undefined,
        MaxDuration: js.UndefOr[Int] = js.undefined,
        MaxResults: js.UndefOr[DescribeHostReservationsMaxResults] = js.undefined,
        MinDuration: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        OfferingId: js.UndefOr[String] = js.undefined
    ): DescribeHostReservationOfferingsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Filter" -> Filter.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxDuration" -> MaxDuration.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MinDuration" -> MinDuration.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OfferingId" -> OfferingId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeHostReservationOfferingsRequest]
    }
  }

  @js.native
  trait DescribeHostReservationOfferingsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var OfferingSet: js.UndefOr[HostOfferingSet]
  }

  object DescribeHostReservationOfferingsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        OfferingSet: js.UndefOr[HostOfferingSet] = js.undefined
    ): DescribeHostReservationOfferingsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OfferingSet" -> OfferingSet.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeHostReservationOfferingsResult]
    }
  }

  @js.native
  trait DescribeHostReservationsRequest extends js.Object {
    var Filter: js.UndefOr[FilterList]
    var HostReservationIdSet: js.UndefOr[HostReservationIdSet]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeHostReservationsRequest {
    def apply(
        Filter: js.UndefOr[FilterList] = js.undefined,
        HostReservationIdSet: js.UndefOr[HostReservationIdSet] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeHostReservationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Filter" -> Filter.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostReservationIdSet" -> HostReservationIdSet.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeHostReservationsRequest]
    }
  }

  @js.native
  trait DescribeHostReservationsResult extends js.Object {
    var HostReservationSet: js.UndefOr[HostReservationSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeHostReservationsResult {
    def apply(
        HostReservationSet: js.UndefOr[HostReservationSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeHostReservationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "HostReservationSet" -> HostReservationSet.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeHostReservationsResult]
    }
  }

  @js.native
  trait DescribeHostsRequest extends js.Object {
    var Filter: js.UndefOr[FilterList]
    var HostIds: js.UndefOr[RequestHostIdList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeHostsRequest {
    def apply(
        Filter: js.UndefOr[FilterList] = js.undefined,
        HostIds: js.UndefOr[RequestHostIdList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeHostsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Filter" -> Filter.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostIds" -> HostIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeHostsRequest]
    }
  }

  @js.native
  trait DescribeHostsResult extends js.Object {
    var Hosts: js.UndefOr[HostList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeHostsResult {
    def apply(
        Hosts: js.UndefOr[HostList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeHostsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Hosts" -> Hosts.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeHostsResult]
    }
  }

  @js.native
  trait DescribeIamInstanceProfileAssociationsRequest extends js.Object {
    var AssociationIds: js.UndefOr[AssociationIdList]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[MaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeIamInstanceProfileAssociationsRequest {
    def apply(
        AssociationIds: js.UndefOr[AssociationIdList] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[MaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeIamInstanceProfileAssociationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociationIds" -> AssociationIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeIamInstanceProfileAssociationsRequest]
    }
  }

  @js.native
  trait DescribeIamInstanceProfileAssociationsResult extends js.Object {
    var IamInstanceProfileAssociations: js.UndefOr[IamInstanceProfileAssociationSet]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeIamInstanceProfileAssociationsResult {
    def apply(
        IamInstanceProfileAssociations: js.UndefOr[IamInstanceProfileAssociationSet] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeIamInstanceProfileAssociationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "IamInstanceProfileAssociations" -> IamInstanceProfileAssociations.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeIamInstanceProfileAssociationsResult]
    }
  }

  @js.native
  trait DescribeIdFormatRequest extends js.Object {
    var Resource: js.UndefOr[String]
  }

  object DescribeIdFormatRequest {
    def apply(
        Resource: js.UndefOr[String] = js.undefined
    ): DescribeIdFormatRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Resource" -> Resource.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeIdFormatRequest]
    }
  }

  @js.native
  trait DescribeIdFormatResult extends js.Object {
    var Statuses: js.UndefOr[IdFormatList]
  }

  object DescribeIdFormatResult {
    def apply(
        Statuses: js.UndefOr[IdFormatList] = js.undefined
    ): DescribeIdFormatResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Statuses" -> Statuses.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeIdFormatResult]
    }
  }

  @js.native
  trait DescribeIdentityIdFormatRequest extends js.Object {
    var PrincipalArn: String
    var Resource: js.UndefOr[String]
  }

  object DescribeIdentityIdFormatRequest {
    def apply(
        PrincipalArn: String,
        Resource: js.UndefOr[String] = js.undefined
    ): DescribeIdentityIdFormatRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "PrincipalArn" -> PrincipalArn.asInstanceOf[js.Any],
        "Resource" -> Resource.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeIdentityIdFormatRequest]
    }
  }

  @js.native
  trait DescribeIdentityIdFormatResult extends js.Object {
    var Statuses: js.UndefOr[IdFormatList]
  }

  object DescribeIdentityIdFormatResult {
    def apply(
        Statuses: js.UndefOr[IdFormatList] = js.undefined
    ): DescribeIdentityIdFormatResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Statuses" -> Statuses.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeIdentityIdFormatResult]
    }
  }

  /**
    * Contains the parameters for DescribeImageAttribute.
    */
  @js.native
  trait DescribeImageAttributeRequest extends js.Object {
    var Attribute: ImageAttributeName
    var ImageId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeImageAttributeRequest {
    def apply(
        Attribute: ImageAttributeName,
        ImageId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeImageAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Attribute" -> Attribute.asInstanceOf[js.Any],
        "ImageId"   -> ImageId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeImageAttributeRequest]
    }
  }

  /**
    * Contains the parameters for DescribeImages.
    */
  @js.native
  trait DescribeImagesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var ExecutableUsers: js.UndefOr[ExecutableByStringList]
    var Filters: js.UndefOr[FilterList]
    var ImageIds: js.UndefOr[ImageIdStringList]
    var Owners: js.UndefOr[OwnerStringList]
  }

  object DescribeImagesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ExecutableUsers: js.UndefOr[ExecutableByStringList] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        ImageIds: js.UndefOr[ImageIdStringList] = js.undefined,
        Owners: js.UndefOr[OwnerStringList] = js.undefined
    ): DescribeImagesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ExecutableUsers" -> ExecutableUsers.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImageIds" -> ImageIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Owners" -> Owners.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeImagesRequest]
    }
  }

  /**
    * Contains the output of DescribeImages.
    */
  @js.native
  trait DescribeImagesResult extends js.Object {
    var Images: js.UndefOr[ImageList]
  }

  object DescribeImagesResult {
    def apply(
        Images: js.UndefOr[ImageList] = js.undefined
    ): DescribeImagesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Images" -> Images.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeImagesResult]
    }
  }

  /**
    * Contains the parameters for DescribeImportImageTasks.
    */
  @js.native
  trait DescribeImportImageTasksRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var ImportTaskIds: js.UndefOr[ImportTaskIdList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeImportImageTasksRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        ImportTaskIds: js.UndefOr[ImportTaskIdList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeImportImageTasksRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImportTaskIds" -> ImportTaskIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeImportImageTasksRequest]
    }
  }

  /**
    * Contains the output for DescribeImportImageTasks.
    */
  @js.native
  trait DescribeImportImageTasksResult extends js.Object {
    var ImportImageTasks: js.UndefOr[ImportImageTaskList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeImportImageTasksResult {
    def apply(
        ImportImageTasks: js.UndefOr[ImportImageTaskList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeImportImageTasksResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ImportImageTasks" -> ImportImageTasks.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeImportImageTasksResult]
    }
  }

  /**
    * Contains the parameters for DescribeImportSnapshotTasks.
    */
  @js.native
  trait DescribeImportSnapshotTasksRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var ImportTaskIds: js.UndefOr[ImportTaskIdList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeImportSnapshotTasksRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        ImportTaskIds: js.UndefOr[ImportTaskIdList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeImportSnapshotTasksRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImportTaskIds" -> ImportTaskIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeImportSnapshotTasksRequest]
    }
  }

  /**
    * Contains the output for DescribeImportSnapshotTasks.
    */
  @js.native
  trait DescribeImportSnapshotTasksResult extends js.Object {
    var ImportSnapshotTasks: js.UndefOr[ImportSnapshotTaskList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeImportSnapshotTasksResult {
    def apply(
        ImportSnapshotTasks: js.UndefOr[ImportSnapshotTaskList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeImportSnapshotTasksResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ImportSnapshotTasks" -> ImportSnapshotTasks.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeImportSnapshotTasksResult]
    }
  }

  @js.native
  trait DescribeInstanceAttributeRequest extends js.Object {
    var Attribute: InstanceAttributeName
    var InstanceId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeInstanceAttributeRequest {
    def apply(
        Attribute: InstanceAttributeName,
        InstanceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeInstanceAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Attribute"  -> Attribute.asInstanceOf[js.Any],
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeInstanceAttributeRequest]
    }
  }

  @js.native
  trait DescribeInstanceCreditSpecificationsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var InstanceIds: js.UndefOr[InstanceIdStringList]
    var MaxResults: js.UndefOr[DescribeInstanceCreditSpecificationsMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInstanceCreditSpecificationsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        InstanceIds: js.UndefOr[InstanceIdStringList] = js.undefined,
        MaxResults: js.UndefOr[DescribeInstanceCreditSpecificationsMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInstanceCreditSpecificationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceIds" -> InstanceIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeInstanceCreditSpecificationsRequest]
    }
  }

  @js.native
  trait DescribeInstanceCreditSpecificationsResult extends js.Object {
    var InstanceCreditSpecifications: js.UndefOr[InstanceCreditSpecificationList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInstanceCreditSpecificationsResult {
    def apply(
        InstanceCreditSpecifications: js.UndefOr[InstanceCreditSpecificationList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInstanceCreditSpecificationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceCreditSpecifications" -> InstanceCreditSpecifications.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeInstanceCreditSpecificationsResult]
    }
  }

  @js.native
  trait DescribeInstanceStatusRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var IncludeAllInstances: js.UndefOr[Boolean]
    var InstanceIds: js.UndefOr[InstanceIdStringList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInstanceStatusRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        IncludeAllInstances: js.UndefOr[Boolean] = js.undefined,
        InstanceIds: js.UndefOr[InstanceIdStringList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInstanceStatusRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IncludeAllInstances" -> IncludeAllInstances.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceIds" -> InstanceIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeInstanceStatusRequest]
    }
  }

  @js.native
  trait DescribeInstanceStatusResult extends js.Object {
    var InstanceStatuses: js.UndefOr[InstanceStatusList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInstanceStatusResult {
    def apply(
        InstanceStatuses: js.UndefOr[InstanceStatusList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInstanceStatusResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceStatuses" -> InstanceStatuses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeInstanceStatusResult]
    }
  }

  @js.native
  trait DescribeInstancesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var InstanceIds: js.UndefOr[InstanceIdStringList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInstancesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        InstanceIds: js.UndefOr[InstanceIdStringList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInstancesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceIds" -> InstanceIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeInstancesRequest]
    }
  }

  @js.native
  trait DescribeInstancesResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Reservations: js.UndefOr[ReservationList]
  }

  object DescribeInstancesResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Reservations: js.UndefOr[ReservationList] = js.undefined
    ): DescribeInstancesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Reservations" -> Reservations.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeInstancesResult]
    }
  }

  @js.native
  trait DescribeInternetGatewaysRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var InternetGatewayIds: js.UndefOr[ValueStringList]
    var MaxResults: js.UndefOr[DescribeInternetGatewaysMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInternetGatewaysRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        InternetGatewayIds: js.UndefOr[ValueStringList] = js.undefined,
        MaxResults: js.UndefOr[DescribeInternetGatewaysMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInternetGatewaysRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InternetGatewayIds" -> InternetGatewayIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeInternetGatewaysRequest]
    }
  }

  @js.native
  trait DescribeInternetGatewaysResult extends js.Object {
    var InternetGateways: js.UndefOr[InternetGatewayList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInternetGatewaysResult {
    def apply(
        InternetGateways: js.UndefOr[InternetGatewayList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInternetGatewaysResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InternetGateways" -> InternetGateways.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeInternetGatewaysResult]
    }
  }

  @js.native
  trait DescribeKeyPairsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var KeyNames: js.UndefOr[KeyNameStringList]
  }

  object DescribeKeyPairsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        KeyNames: js.UndefOr[KeyNameStringList] = js.undefined
    ): DescribeKeyPairsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KeyNames" -> KeyNames.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeKeyPairsRequest]
    }
  }

  @js.native
  trait DescribeKeyPairsResult extends js.Object {
    var KeyPairs: js.UndefOr[KeyPairList]
  }

  object DescribeKeyPairsResult {
    def apply(
        KeyPairs: js.UndefOr[KeyPairList] = js.undefined
    ): DescribeKeyPairsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "KeyPairs" -> KeyPairs.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeKeyPairsResult]
    }
  }

  @js.native
  trait DescribeLaunchTemplateVersionsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
    var MaxResults: js.UndefOr[Int]
    var MaxVersion: js.UndefOr[String]
    var MinVersion: js.UndefOr[String]
    var NextToken: js.UndefOr[String]
    var Versions: js.UndefOr[VersionStringList]
  }

  object DescribeLaunchTemplateVersionsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        MaxVersion: js.UndefOr[String] = js.undefined,
        MinVersion: js.UndefOr[String] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        Versions: js.UndefOr[VersionStringList] = js.undefined
    ): DescribeLaunchTemplateVersionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateId" -> LaunchTemplateId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateName" -> LaunchTemplateName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxVersion" -> MaxVersion.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MinVersion" -> MinVersion.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Versions" -> Versions.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeLaunchTemplateVersionsRequest]
    }
  }

  @js.native
  trait DescribeLaunchTemplateVersionsResult extends js.Object {
    var LaunchTemplateVersions: js.UndefOr[LaunchTemplateVersionSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeLaunchTemplateVersionsResult {
    def apply(
        LaunchTemplateVersions: js.UndefOr[LaunchTemplateVersionSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeLaunchTemplateVersionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateVersions" -> LaunchTemplateVersions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeLaunchTemplateVersionsResult]
    }
  }

  @js.native
  trait DescribeLaunchTemplatesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var LaunchTemplateIds: js.UndefOr[ValueStringList]
    var LaunchTemplateNames: js.UndefOr[LaunchTemplateNameStringList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeLaunchTemplatesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        LaunchTemplateIds: js.UndefOr[ValueStringList] = js.undefined,
        LaunchTemplateNames: js.UndefOr[LaunchTemplateNameStringList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeLaunchTemplatesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateIds" -> LaunchTemplateIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateNames" -> LaunchTemplateNames.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeLaunchTemplatesRequest]
    }
  }

  @js.native
  trait DescribeLaunchTemplatesResult extends js.Object {
    var LaunchTemplates: js.UndefOr[LaunchTemplateSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeLaunchTemplatesResult {
    def apply(
        LaunchTemplates: js.UndefOr[LaunchTemplateSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeLaunchTemplatesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplates" -> LaunchTemplates.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeLaunchTemplatesResult]
    }
  }

  @js.native
  trait DescribeMovingAddressesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var PublicIps: js.UndefOr[ValueStringList]
  }

  object DescribeMovingAddressesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        PublicIps: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeMovingAddressesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIps" -> PublicIps.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeMovingAddressesRequest]
    }
  }

  @js.native
  trait DescribeMovingAddressesResult extends js.Object {
    var MovingAddressStatuses: js.UndefOr[MovingAddressStatusSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeMovingAddressesResult {
    def apply(
        MovingAddressStatuses: js.UndefOr[MovingAddressStatusSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeMovingAddressesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "MovingAddressStatuses" -> MovingAddressStatuses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeMovingAddressesResult]
    }
  }

  @js.native
  trait DescribeNatGatewaysRequest extends js.Object {
    var Filter: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NatGatewayIds: js.UndefOr[ValueStringList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNatGatewaysRequest {
    def apply(
        Filter: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NatGatewayIds: js.UndefOr[ValueStringList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNatGatewaysRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Filter" -> Filter.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NatGatewayIds" -> NatGatewayIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeNatGatewaysRequest]
    }
  }

  @js.native
  trait DescribeNatGatewaysResult extends js.Object {
    var NatGateways: js.UndefOr[NatGatewayList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNatGatewaysResult {
    def apply(
        NatGateways: js.UndefOr[NatGatewayList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNatGatewaysResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NatGateways" -> NatGateways.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeNatGatewaysResult]
    }
  }

  @js.native
  trait DescribeNetworkAclsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeNetworkAclsMaxResults]
    var NetworkAclIds: js.UndefOr[ValueStringList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNetworkAclsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeNetworkAclsMaxResults] = js.undefined,
        NetworkAclIds: js.UndefOr[ValueStringList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNetworkAclsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkAclIds" -> NetworkAclIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeNetworkAclsRequest]
    }
  }

  @js.native
  trait DescribeNetworkAclsResult extends js.Object {
    var NetworkAcls: js.UndefOr[NetworkAclList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNetworkAclsResult {
    def apply(
        NetworkAcls: js.UndefOr[NetworkAclList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNetworkAclsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkAcls" -> NetworkAcls.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeNetworkAclsResult]
    }
  }

  /**
    * Contains the parameters for DescribeNetworkInterfaceAttribute.
    */
  @js.native
  trait DescribeNetworkInterfaceAttributeRequest extends js.Object {
    var NetworkInterfaceId: String
    var Attribute: js.UndefOr[NetworkInterfaceAttribute]
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeNetworkInterfaceAttributeRequest {
    def apply(
        NetworkInterfaceId: String,
        Attribute: js.UndefOr[NetworkInterfaceAttribute] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeNetworkInterfaceAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any],
        "Attribute" -> Attribute.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeNetworkInterfaceAttributeRequest]
    }
  }

  /**
    * Contains the output of DescribeNetworkInterfaceAttribute.
    */
  @js.native
  trait DescribeNetworkInterfaceAttributeResult extends js.Object {
    var Attachment: js.UndefOr[NetworkInterfaceAttachment]
    var Description: js.UndefOr[AttributeValue]
    var Groups: js.UndefOr[GroupIdentifierList]
    var NetworkInterfaceId: js.UndefOr[String]
    var SourceDestCheck: js.UndefOr[AttributeBooleanValue]
  }

  object DescribeNetworkInterfaceAttributeResult {
    def apply(
        Attachment: js.UndefOr[NetworkInterfaceAttachment] = js.undefined,
        Description: js.UndefOr[AttributeValue] = js.undefined,
        Groups: js.UndefOr[GroupIdentifierList] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        SourceDestCheck: js.UndefOr[AttributeBooleanValue] = js.undefined
    ): DescribeNetworkInterfaceAttributeResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Attachment" -> Attachment.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Groups" -> Groups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceId" -> NetworkInterfaceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SourceDestCheck" -> SourceDestCheck.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeNetworkInterfaceAttributeResult]
    }
  }

  /**
    * Contains the parameters for DescribeNetworkInterfacePermissions.
    */
  @js.native
  trait DescribeNetworkInterfacePermissionsRequest extends js.Object {
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NetworkInterfacePermissionIds: js.UndefOr[NetworkInterfacePermissionIdList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNetworkInterfacePermissionsRequest {
    def apply(
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NetworkInterfacePermissionIds: js.UndefOr[NetworkInterfacePermissionIdList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNetworkInterfacePermissionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfacePermissionIds" -> NetworkInterfacePermissionIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeNetworkInterfacePermissionsRequest]
    }
  }

  /**
    * Contains the output for DescribeNetworkInterfacePermissions.
    */
  @js.native
  trait DescribeNetworkInterfacePermissionsResult extends js.Object {
    var NetworkInterfacePermissions: js.UndefOr[NetworkInterfacePermissionList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNetworkInterfacePermissionsResult {
    def apply(
        NetworkInterfacePermissions: js.UndefOr[NetworkInterfacePermissionList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNetworkInterfacePermissionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkInterfacePermissions" -> NetworkInterfacePermissions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeNetworkInterfacePermissionsResult]
    }
  }

  /**
    * Contains the parameters for DescribeNetworkInterfaces.
    */
  @js.native
  trait DescribeNetworkInterfacesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NetworkInterfaceIds: js.UndefOr[NetworkInterfaceIdList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNetworkInterfacesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NetworkInterfaceIds: js.UndefOr[NetworkInterfaceIdList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNetworkInterfacesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceIds" -> NetworkInterfaceIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeNetworkInterfacesRequest]
    }
  }

  /**
    * Contains the output of DescribeNetworkInterfaces.
    */
  @js.native
  trait DescribeNetworkInterfacesResult extends js.Object {
    var NetworkInterfaces: js.UndefOr[NetworkInterfaceList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNetworkInterfacesResult {
    def apply(
        NetworkInterfaces: js.UndefOr[NetworkInterfaceList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNetworkInterfacesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkInterfaces" -> NetworkInterfaces.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeNetworkInterfacesResult]
    }
  }

  @js.native
  trait DescribePlacementGroupsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var GroupNames: js.UndefOr[PlacementGroupStringList]
  }

  object DescribePlacementGroupsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        GroupNames: js.UndefOr[PlacementGroupStringList] = js.undefined
    ): DescribePlacementGroupsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupNames" -> GroupNames.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribePlacementGroupsRequest]
    }
  }

  @js.native
  trait DescribePlacementGroupsResult extends js.Object {
    var PlacementGroups: js.UndefOr[PlacementGroupList]
  }

  object DescribePlacementGroupsResult {
    def apply(
        PlacementGroups: js.UndefOr[PlacementGroupList] = js.undefined
    ): DescribePlacementGroupsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "PlacementGroups" -> PlacementGroups.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribePlacementGroupsResult]
    }
  }

  @js.native
  trait DescribePrefixListsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var PrefixListIds: js.UndefOr[ValueStringList]
  }

  object DescribePrefixListsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        PrefixListIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribePrefixListsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrefixListIds" -> PrefixListIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribePrefixListsRequest]
    }
  }

  @js.native
  trait DescribePrefixListsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var PrefixLists: js.UndefOr[PrefixListSet]
  }

  object DescribePrefixListsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        PrefixLists: js.UndefOr[PrefixListSet] = js.undefined
    ): DescribePrefixListsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrefixLists" -> PrefixLists.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribePrefixListsResult]
    }
  }

  @js.native
  trait DescribePrincipalIdFormatRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var Resources: js.UndefOr[ResourceList]
  }

  object DescribePrincipalIdFormatRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        Resources: js.UndefOr[ResourceList] = js.undefined
    ): DescribePrincipalIdFormatRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Resources" -> Resources.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribePrincipalIdFormatRequest]
    }
  }

  @js.native
  trait DescribePrincipalIdFormatResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Principals: js.UndefOr[PrincipalIdFormatList]
  }

  object DescribePrincipalIdFormatResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Principals: js.UndefOr[PrincipalIdFormatList] = js.undefined
    ): DescribePrincipalIdFormatResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Principals" -> Principals.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribePrincipalIdFormatResult]
    }
  }

  @js.native
  trait DescribePublicIpv4PoolsRequest extends js.Object {
    var MaxResults: js.UndefOr[PoolMaxResults]
    var NextToken: js.UndefOr[NextToken]
    var PoolIds: js.UndefOr[ValueStringList]
  }

  object DescribePublicIpv4PoolsRequest {
    def apply(
        MaxResults: js.UndefOr[PoolMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined,
        PoolIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribePublicIpv4PoolsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PoolIds" -> PoolIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribePublicIpv4PoolsRequest]
    }
  }

  @js.native
  trait DescribePublicIpv4PoolsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var PublicIpv4Pools: js.UndefOr[PublicIpv4PoolSet]
  }

  object DescribePublicIpv4PoolsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        PublicIpv4Pools: js.UndefOr[PublicIpv4PoolSet] = js.undefined
    ): DescribePublicIpv4PoolsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIpv4Pools" -> PublicIpv4Pools.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribePublicIpv4PoolsResult]
    }
  }

  @js.native
  trait DescribeRegionsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var RegionNames: js.UndefOr[RegionNameStringList]
  }

  object DescribeRegionsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        RegionNames: js.UndefOr[RegionNameStringList] = js.undefined
    ): DescribeRegionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RegionNames" -> RegionNames.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeRegionsRequest]
    }
  }

  @js.native
  trait DescribeRegionsResult extends js.Object {
    var Regions: js.UndefOr[RegionList]
  }

  object DescribeRegionsResult {
    def apply(
        Regions: js.UndefOr[RegionList] = js.undefined
    ): DescribeRegionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Regions" -> Regions.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeRegionsResult]
    }
  }

  /**
    * Contains the parameters for DescribeReservedInstancesListings.
    */
  @js.native
  trait DescribeReservedInstancesListingsRequest extends js.Object {
    var Filters: js.UndefOr[FilterList]
    var ReservedInstancesId: js.UndefOr[String]
    var ReservedInstancesListingId: js.UndefOr[String]
  }

  object DescribeReservedInstancesListingsRequest {
    def apply(
        Filters: js.UndefOr[FilterList] = js.undefined,
        ReservedInstancesId: js.UndefOr[String] = js.undefined,
        ReservedInstancesListingId: js.UndefOr[String] = js.undefined
    ): DescribeReservedInstancesListingsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReservedInstancesId" -> ReservedInstancesId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReservedInstancesListingId" -> ReservedInstancesListingId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeReservedInstancesListingsRequest]
    }
  }

  /**
    * Contains the output of DescribeReservedInstancesListings.
    */
  @js.native
  trait DescribeReservedInstancesListingsResult extends js.Object {
    var ReservedInstancesListings: js.UndefOr[ReservedInstancesListingList]
  }

  object DescribeReservedInstancesListingsResult {
    def apply(
        ReservedInstancesListings: js.UndefOr[ReservedInstancesListingList] = js.undefined
    ): DescribeReservedInstancesListingsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReservedInstancesListings" -> ReservedInstancesListings.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeReservedInstancesListingsResult]
    }
  }

  /**
    * Contains the parameters for DescribeReservedInstancesModifications.
    */
  @js.native
  trait DescribeReservedInstancesModificationsRequest extends js.Object {
    var Filters: js.UndefOr[FilterList]
    var NextToken: js.UndefOr[String]
    var ReservedInstancesModificationIds: js.UndefOr[ReservedInstancesModificationIdStringList]
  }

  object DescribeReservedInstancesModificationsRequest {
    def apply(
        Filters: js.UndefOr[FilterList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        ReservedInstancesModificationIds: js.UndefOr[ReservedInstancesModificationIdStringList] = js.undefined
    ): DescribeReservedInstancesModificationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReservedInstancesModificationIds" -> ReservedInstancesModificationIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeReservedInstancesModificationsRequest]
    }
  }

  /**
    * Contains the output of DescribeReservedInstancesModifications.
    */
  @js.native
  trait DescribeReservedInstancesModificationsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var ReservedInstancesModifications: js.UndefOr[ReservedInstancesModificationList]
  }

  object DescribeReservedInstancesModificationsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        ReservedInstancesModifications: js.UndefOr[ReservedInstancesModificationList] = js.undefined
    ): DescribeReservedInstancesModificationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReservedInstancesModifications" -> ReservedInstancesModifications.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeReservedInstancesModificationsResult]
    }
  }

  /**
    * Contains the parameters for DescribeReservedInstancesOfferings.
    */
  @js.native
  trait DescribeReservedInstancesOfferingsRequest extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var IncludeMarketplace: js.UndefOr[Boolean]
    var InstanceTenancy: js.UndefOr[Tenancy]
    var InstanceType: js.UndefOr[InstanceType]
    var MaxDuration: js.UndefOr[Double]
    var MaxInstanceCount: js.UndefOr[Int]
    var MaxResults: js.UndefOr[Int]
    var MinDuration: js.UndefOr[Double]
    var NextToken: js.UndefOr[String]
    var OfferingClass: js.UndefOr[OfferingClassType]
    var OfferingType: js.UndefOr[OfferingTypeValues]
    var ProductDescription: js.UndefOr[RIProductDescription]
    var ReservedInstancesOfferingIds: js.UndefOr[ReservedInstancesOfferingIdStringList]
  }

  object DescribeReservedInstancesOfferingsRequest {
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        IncludeMarketplace: js.UndefOr[Boolean] = js.undefined,
        InstanceTenancy: js.UndefOr[Tenancy] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        MaxDuration: js.UndefOr[Double] = js.undefined,
        MaxInstanceCount: js.UndefOr[Int] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        MinDuration: js.UndefOr[Double] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        OfferingClass: js.UndefOr[OfferingClassType] = js.undefined,
        OfferingType: js.UndefOr[OfferingTypeValues] = js.undefined,
        ProductDescription: js.UndefOr[RIProductDescription] = js.undefined,
        ReservedInstancesOfferingIds: js.UndefOr[ReservedInstancesOfferingIdStringList] = js.undefined
    ): DescribeReservedInstancesOfferingsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IncludeMarketplace" -> IncludeMarketplace.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceTenancy" -> InstanceTenancy.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxDuration" -> MaxDuration.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxInstanceCount" -> MaxInstanceCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MinDuration" -> MinDuration.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OfferingClass" -> OfferingClass.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OfferingType" -> OfferingType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductDescription" -> ProductDescription.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReservedInstancesOfferingIds" -> ReservedInstancesOfferingIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeReservedInstancesOfferingsRequest]
    }
  }

  /**
    * Contains the output of DescribeReservedInstancesOfferings.
    */
  @js.native
  trait DescribeReservedInstancesOfferingsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var ReservedInstancesOfferings: js.UndefOr[ReservedInstancesOfferingList]
  }

  object DescribeReservedInstancesOfferingsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        ReservedInstancesOfferings: js.UndefOr[ReservedInstancesOfferingList] = js.undefined
    ): DescribeReservedInstancesOfferingsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReservedInstancesOfferings" -> ReservedInstancesOfferings.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeReservedInstancesOfferingsResult]
    }
  }

  /**
    * Contains the parameters for DescribeReservedInstances.
    */
  @js.native
  trait DescribeReservedInstancesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var OfferingClass: js.UndefOr[OfferingClassType]
    var OfferingType: js.UndefOr[OfferingTypeValues]
    var ReservedInstancesIds: js.UndefOr[ReservedInstancesIdStringList]
  }

  object DescribeReservedInstancesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        OfferingClass: js.UndefOr[OfferingClassType] = js.undefined,
        OfferingType: js.UndefOr[OfferingTypeValues] = js.undefined,
        ReservedInstancesIds: js.UndefOr[ReservedInstancesIdStringList] = js.undefined
    ): DescribeReservedInstancesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OfferingClass" -> OfferingClass.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OfferingType" -> OfferingType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReservedInstancesIds" -> ReservedInstancesIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeReservedInstancesRequest]
    }
  }

  /**
    * Contains the output for DescribeReservedInstances.
    */
  @js.native
  trait DescribeReservedInstancesResult extends js.Object {
    var ReservedInstances: js.UndefOr[ReservedInstancesList]
  }

  object DescribeReservedInstancesResult {
    def apply(
        ReservedInstances: js.UndefOr[ReservedInstancesList] = js.undefined
    ): DescribeReservedInstancesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReservedInstances" -> ReservedInstances.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeReservedInstancesResult]
    }
  }

  @js.native
  trait DescribeRouteTablesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var RouteTableIds: js.UndefOr[ValueStringList]
  }

  object DescribeRouteTablesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        RouteTableIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeRouteTablesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RouteTableIds" -> RouteTableIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeRouteTablesRequest]
    }
  }

  /**
    * Contains the output of DescribeRouteTables.
    */
  @js.native
  trait DescribeRouteTablesResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var RouteTables: js.UndefOr[RouteTableList]
  }

  object DescribeRouteTablesResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        RouteTables: js.UndefOr[RouteTableList] = js.undefined
    ): DescribeRouteTablesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RouteTables" -> RouteTables.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeRouteTablesResult]
    }
  }

  /**
    * Contains the parameters for DescribeScheduledInstanceAvailability.
    */
  @js.native
  trait DescribeScheduledInstanceAvailabilityRequest extends js.Object {
    var FirstSlotStartTimeRange: SlotDateTimeRangeRequest
    var Recurrence: ScheduledInstanceRecurrenceRequest
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var MaxSlotDurationInHours: js.UndefOr[Int]
    var MinSlotDurationInHours: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeScheduledInstanceAvailabilityRequest {
    def apply(
        FirstSlotStartTimeRange: SlotDateTimeRangeRequest,
        Recurrence: ScheduledInstanceRecurrenceRequest,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        MaxSlotDurationInHours: js.UndefOr[Int] = js.undefined,
        MinSlotDurationInHours: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeScheduledInstanceAvailabilityRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FirstSlotStartTimeRange" -> FirstSlotStartTimeRange.asInstanceOf[js.Any],
        "Recurrence"              -> Recurrence.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxSlotDurationInHours" -> MaxSlotDurationInHours.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MinSlotDurationInHours" -> MinSlotDurationInHours.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeScheduledInstanceAvailabilityRequest]
    }
  }

  /**
    * Contains the output of DescribeScheduledInstanceAvailability.
    */
  @js.native
  trait DescribeScheduledInstanceAvailabilityResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var ScheduledInstanceAvailabilitySet: js.UndefOr[ScheduledInstanceAvailabilitySet]
  }

  object DescribeScheduledInstanceAvailabilityResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        ScheduledInstanceAvailabilitySet: js.UndefOr[ScheduledInstanceAvailabilitySet] = js.undefined
    ): DescribeScheduledInstanceAvailabilityResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ScheduledInstanceAvailabilitySet" -> ScheduledInstanceAvailabilitySet.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeScheduledInstanceAvailabilityResult]
    }
  }

  /**
    * Contains the parameters for DescribeScheduledInstances.
    */
  @js.native
  trait DescribeScheduledInstancesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var ScheduledInstanceIds: js.UndefOr[ScheduledInstanceIdRequestSet]
    var SlotStartTimeRange: js.UndefOr[SlotStartTimeRangeRequest]
  }

  object DescribeScheduledInstancesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        ScheduledInstanceIds: js.UndefOr[ScheduledInstanceIdRequestSet] = js.undefined,
        SlotStartTimeRange: js.UndefOr[SlotStartTimeRangeRequest] = js.undefined
    ): DescribeScheduledInstancesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ScheduledInstanceIds" -> ScheduledInstanceIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SlotStartTimeRange" -> SlotStartTimeRange.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeScheduledInstancesRequest]
    }
  }

  /**
    * Contains the output of DescribeScheduledInstances.
    */
  @js.native
  trait DescribeScheduledInstancesResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var ScheduledInstanceSet: js.UndefOr[ScheduledInstanceSet]
  }

  object DescribeScheduledInstancesResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        ScheduledInstanceSet: js.UndefOr[ScheduledInstanceSet] = js.undefined
    ): DescribeScheduledInstancesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ScheduledInstanceSet" -> ScheduledInstanceSet.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeScheduledInstancesResult]
    }
  }

  @js.native
  trait DescribeSecurityGroupReferencesRequest extends js.Object {
    var GroupId: GroupIds
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeSecurityGroupReferencesRequest {
    def apply(
        GroupId: GroupIds,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeSecurityGroupReferencesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "GroupId" -> GroupId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSecurityGroupReferencesRequest]
    }
  }

  @js.native
  trait DescribeSecurityGroupReferencesResult extends js.Object {
    var SecurityGroupReferenceSet: js.UndefOr[SecurityGroupReferences]
  }

  object DescribeSecurityGroupReferencesResult {
    def apply(
        SecurityGroupReferenceSet: js.UndefOr[SecurityGroupReferences] = js.undefined
    ): DescribeSecurityGroupReferencesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SecurityGroupReferenceSet" -> SecurityGroupReferenceSet.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSecurityGroupReferencesResult]
    }
  }

  @js.native
  trait DescribeSecurityGroupsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var GroupIds: js.UndefOr[GroupIdStringList]
    var GroupNames: js.UndefOr[GroupNameStringList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeSecurityGroupsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        GroupIds: js.UndefOr[GroupIdStringList] = js.undefined,
        GroupNames: js.UndefOr[GroupNameStringList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeSecurityGroupsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupIds" -> GroupIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupNames" -> GroupNames.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSecurityGroupsRequest]
    }
  }

  @js.native
  trait DescribeSecurityGroupsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var SecurityGroups: js.UndefOr[SecurityGroupList]
  }

  object DescribeSecurityGroupsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        SecurityGroups: js.UndefOr[SecurityGroupList] = js.undefined
    ): DescribeSecurityGroupsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SecurityGroups" -> SecurityGroups.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSecurityGroupsResult]
    }
  }

  /**
    * Contains the parameters for DescribeSnapshotAttribute.
    */
  @js.native
  trait DescribeSnapshotAttributeRequest extends js.Object {
    var Attribute: SnapshotAttributeName
    var SnapshotId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeSnapshotAttributeRequest {
    def apply(
        Attribute: SnapshotAttributeName,
        SnapshotId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeSnapshotAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Attribute"  -> Attribute.asInstanceOf[js.Any],
        "SnapshotId" -> SnapshotId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSnapshotAttributeRequest]
    }
  }

  /**
    * Contains the output of DescribeSnapshotAttribute.
    */
  @js.native
  trait DescribeSnapshotAttributeResult extends js.Object {
    var CreateVolumePermissions: js.UndefOr[CreateVolumePermissionList]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var SnapshotId: js.UndefOr[String]
  }

  object DescribeSnapshotAttributeResult {
    def apply(
        CreateVolumePermissions: js.UndefOr[CreateVolumePermissionList] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        SnapshotId: js.UndefOr[String] = js.undefined
    ): DescribeSnapshotAttributeResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CreateVolumePermissions" -> CreateVolumePermissions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductCodes" -> ProductCodes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SnapshotId" -> SnapshotId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSnapshotAttributeResult]
    }
  }

  /**
    * Contains the parameters for DescribeSnapshots.
    */
  @js.native
  trait DescribeSnapshotsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var OwnerIds: js.UndefOr[OwnerStringList]
    var RestorableByUserIds: js.UndefOr[RestorableByStringList]
    var SnapshotIds: js.UndefOr[SnapshotIdStringList]
  }

  object DescribeSnapshotsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        OwnerIds: js.UndefOr[OwnerStringList] = js.undefined,
        RestorableByUserIds: js.UndefOr[RestorableByStringList] = js.undefined,
        SnapshotIds: js.UndefOr[SnapshotIdStringList] = js.undefined
    ): DescribeSnapshotsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OwnerIds" -> OwnerIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RestorableByUserIds" -> RestorableByUserIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SnapshotIds" -> SnapshotIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSnapshotsRequest]
    }
  }

  /**
    * Contains the output of DescribeSnapshots.
    */
  @js.native
  trait DescribeSnapshotsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Snapshots: js.UndefOr[SnapshotList]
  }

  object DescribeSnapshotsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Snapshots: js.UndefOr[SnapshotList] = js.undefined
    ): DescribeSnapshotsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Snapshots" -> Snapshots.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSnapshotsResult]
    }
  }

  /**
    * Contains the parameters for DescribeSpotDatafeedSubscription.
    */
  @js.native
  trait DescribeSpotDatafeedSubscriptionRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeSpotDatafeedSubscriptionRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeSpotDatafeedSubscriptionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSpotDatafeedSubscriptionRequest]
    }
  }

  /**
    * Contains the output of DescribeSpotDatafeedSubscription.
    */
  @js.native
  trait DescribeSpotDatafeedSubscriptionResult extends js.Object {
    var SpotDatafeedSubscription: js.UndefOr[SpotDatafeedSubscription]
  }

  object DescribeSpotDatafeedSubscriptionResult {
    def apply(
        SpotDatafeedSubscription: js.UndefOr[SpotDatafeedSubscription] = js.undefined
    ): DescribeSpotDatafeedSubscriptionResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SpotDatafeedSubscription" -> SpotDatafeedSubscription.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSpotDatafeedSubscriptionResult]
    }
  }

  /**
    * Contains the parameters for DescribeSpotFleetInstances.
    */
  @js.native
  trait DescribeSpotFleetInstancesRequest extends js.Object {
    var SpotFleetRequestId: String
    var DryRun: js.UndefOr[Boolean]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeSpotFleetInstancesRequest {
    def apply(
        SpotFleetRequestId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeSpotFleetInstancesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SpotFleetRequestId" -> SpotFleetRequestId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSpotFleetInstancesRequest]
    }
  }

  /**
    * Contains the output of DescribeSpotFleetInstances.
    */
  @js.native
  trait DescribeSpotFleetInstancesResponse extends js.Object {
    var ActiveInstances: js.UndefOr[ActiveInstanceSet]
    var NextToken: js.UndefOr[String]
    var SpotFleetRequestId: js.UndefOr[String]
  }

  object DescribeSpotFleetInstancesResponse {
    def apply(
        ActiveInstances: js.UndefOr[ActiveInstanceSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        SpotFleetRequestId: js.UndefOr[String] = js.undefined
    ): DescribeSpotFleetInstancesResponse = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ActiveInstances" -> ActiveInstances.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotFleetRequestId" -> SpotFleetRequestId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSpotFleetInstancesResponse]
    }
  }

  /**
    * Contains the parameters for DescribeSpotFleetRequestHistory.
    */
  @js.native
  trait DescribeSpotFleetRequestHistoryRequest extends js.Object {
    var SpotFleetRequestId: String
    var StartTime: DateTime
    var DryRun: js.UndefOr[Boolean]
    var EventType: js.UndefOr[EventType]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeSpotFleetRequestHistoryRequest {
    def apply(
        SpotFleetRequestId: String,
        StartTime: DateTime,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EventType: js.UndefOr[EventType] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeSpotFleetRequestHistoryRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SpotFleetRequestId" -> SpotFleetRequestId.asInstanceOf[js.Any],
        "StartTime"          -> StartTime.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EventType" -> EventType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSpotFleetRequestHistoryRequest]
    }
  }

  /**
    * Contains the output of DescribeSpotFleetRequestHistory.
    */
  @js.native
  trait DescribeSpotFleetRequestHistoryResponse extends js.Object {
    var HistoryRecords: js.UndefOr[HistoryRecords]
    var LastEvaluatedTime: js.UndefOr[DateTime]
    var NextToken: js.UndefOr[String]
    var SpotFleetRequestId: js.UndefOr[String]
    var StartTime: js.UndefOr[DateTime]
  }

  object DescribeSpotFleetRequestHistoryResponse {
    def apply(
        HistoryRecords: js.UndefOr[HistoryRecords] = js.undefined,
        LastEvaluatedTime: js.UndefOr[DateTime] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        SpotFleetRequestId: js.UndefOr[String] = js.undefined,
        StartTime: js.UndefOr[DateTime] = js.undefined
    ): DescribeSpotFleetRequestHistoryResponse = {
      val _fields = IndexedSeq[(String, js.Any)](
        "HistoryRecords" -> HistoryRecords.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LastEvaluatedTime" -> LastEvaluatedTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotFleetRequestId" -> SpotFleetRequestId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StartTime" -> StartTime.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSpotFleetRequestHistoryResponse]
    }
  }

  /**
    * Contains the parameters for DescribeSpotFleetRequests.
    */
  @js.native
  trait DescribeSpotFleetRequestsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var SpotFleetRequestIds: js.UndefOr[ValueStringList]
  }

  object DescribeSpotFleetRequestsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        SpotFleetRequestIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeSpotFleetRequestsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotFleetRequestIds" -> SpotFleetRequestIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSpotFleetRequestsRequest]
    }
  }

  /**
    * Contains the output of DescribeSpotFleetRequests.
    */
  @js.native
  trait DescribeSpotFleetRequestsResponse extends js.Object {
    var NextToken: js.UndefOr[String]
    var SpotFleetRequestConfigs: js.UndefOr[SpotFleetRequestConfigSet]
  }

  object DescribeSpotFleetRequestsResponse {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        SpotFleetRequestConfigs: js.UndefOr[SpotFleetRequestConfigSet] = js.undefined
    ): DescribeSpotFleetRequestsResponse = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotFleetRequestConfigs" -> SpotFleetRequestConfigs.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSpotFleetRequestsResponse]
    }
  }

  /**
    * Contains the parameters for DescribeSpotInstanceRequests.
    */
  @js.native
  trait DescribeSpotInstanceRequestsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var SpotInstanceRequestIds: js.UndefOr[SpotInstanceRequestIdList]
  }

  object DescribeSpotInstanceRequestsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        SpotInstanceRequestIds: js.UndefOr[SpotInstanceRequestIdList] = js.undefined
    ): DescribeSpotInstanceRequestsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotInstanceRequestIds" -> SpotInstanceRequestIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSpotInstanceRequestsRequest]
    }
  }

  /**
    * Contains the output of DescribeSpotInstanceRequests.
    */
  @js.native
  trait DescribeSpotInstanceRequestsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var SpotInstanceRequests: js.UndefOr[SpotInstanceRequestList]
  }

  object DescribeSpotInstanceRequestsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        SpotInstanceRequests: js.UndefOr[SpotInstanceRequestList] = js.undefined
    ): DescribeSpotInstanceRequestsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotInstanceRequests" -> SpotInstanceRequests.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSpotInstanceRequestsResult]
    }
  }

  /**
    * Contains the parameters for DescribeSpotPriceHistory.
    */
  @js.native
  trait DescribeSpotPriceHistoryRequest extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var EndTime: js.UndefOr[DateTime]
    var Filters: js.UndefOr[FilterList]
    var InstanceTypes: js.UndefOr[InstanceTypeList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var ProductDescriptions: js.UndefOr[ProductDescriptionList]
    var StartTime: js.UndefOr[DateTime]
  }

  object DescribeSpotPriceHistoryRequest {
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EndTime: js.UndefOr[DateTime] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        InstanceTypes: js.UndefOr[InstanceTypeList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        ProductDescriptions: js.UndefOr[ProductDescriptionList] = js.undefined,
        StartTime: js.UndefOr[DateTime] = js.undefined
    ): DescribeSpotPriceHistoryRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EndTime" -> EndTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceTypes" -> InstanceTypes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductDescriptions" -> ProductDescriptions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StartTime" -> StartTime.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSpotPriceHistoryRequest]
    }
  }

  /**
    * Contains the output of DescribeSpotPriceHistory.
    */
  @js.native
  trait DescribeSpotPriceHistoryResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var SpotPriceHistory: js.UndefOr[SpotPriceHistoryList]
  }

  object DescribeSpotPriceHistoryResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        SpotPriceHistory: js.UndefOr[SpotPriceHistoryList] = js.undefined
    ): DescribeSpotPriceHistoryResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotPriceHistory" -> SpotPriceHistory.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSpotPriceHistoryResult]
    }
  }

  @js.native
  trait DescribeStaleSecurityGroupsRequest extends js.Object {
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
    var MaxResults: js.UndefOr[MaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeStaleSecurityGroupsRequest {
    def apply(
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        MaxResults: js.UndefOr[MaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeStaleSecurityGroupsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId" -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeStaleSecurityGroupsRequest]
    }
  }

  @js.native
  trait DescribeStaleSecurityGroupsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var StaleSecurityGroupSet: js.UndefOr[StaleSecurityGroupSet]
  }

  object DescribeStaleSecurityGroupsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        StaleSecurityGroupSet: js.UndefOr[StaleSecurityGroupSet] = js.undefined
    ): DescribeStaleSecurityGroupsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StaleSecurityGroupSet" -> StaleSecurityGroupSet.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeStaleSecurityGroupsResult]
    }
  }

  @js.native
  trait DescribeSubnetsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var SubnetIds: js.UndefOr[SubnetIdStringList]
  }

  object DescribeSubnetsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        SubnetIds: js.UndefOr[SubnetIdStringList] = js.undefined
    ): DescribeSubnetsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetIds" -> SubnetIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSubnetsRequest]
    }
  }

  @js.native
  trait DescribeSubnetsResult extends js.Object {
    var Subnets: js.UndefOr[SubnetList]
  }

  object DescribeSubnetsResult {
    def apply(
        Subnets: js.UndefOr[SubnetList] = js.undefined
    ): DescribeSubnetsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Subnets" -> Subnets.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeSubnetsResult]
    }
  }

  @js.native
  trait DescribeTagsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeTagsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeTagsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeTagsRequest]
    }
  }

  @js.native
  trait DescribeTagsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Tags: js.UndefOr[TagDescriptionList]
  }

  object DescribeTagsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagDescriptionList] = js.undefined
    ): DescribeTagsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeTagsResult]
    }
  }

  @js.native
  trait DescribeTransitGatewayAttachmentsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
    var TransitGatewayAttachmentIds: js.UndefOr[TransitGatewayAttachmentIdStringList]
  }

  object DescribeTransitGatewayAttachmentsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayAttachmentIds: js.UndefOr[TransitGatewayAttachmentIdStringList] = js.undefined
    ): DescribeTransitGatewayAttachmentsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGatewayAttachmentIds" -> TransitGatewayAttachmentIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeTransitGatewayAttachmentsRequest]
    }
  }

  @js.native
  trait DescribeTransitGatewayAttachmentsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TransitGatewayAttachments: js.UndefOr[TransitGatewayAttachmentList]
  }

  object DescribeTransitGatewayAttachmentsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayAttachments: js.UndefOr[TransitGatewayAttachmentList] = js.undefined
    ): DescribeTransitGatewayAttachmentsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGatewayAttachments" -> TransitGatewayAttachments.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeTransitGatewayAttachmentsResult]
    }
  }

  @js.native
  trait DescribeTransitGatewayRouteTablesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
    var TransitGatewayRouteTableIds: js.UndefOr[TransitGatewayRouteTableIdStringList]
  }

  object DescribeTransitGatewayRouteTablesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayRouteTableIds: js.UndefOr[TransitGatewayRouteTableIdStringList] = js.undefined
    ): DescribeTransitGatewayRouteTablesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGatewayRouteTableIds" -> TransitGatewayRouteTableIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeTransitGatewayRouteTablesRequest]
    }
  }

  @js.native
  trait DescribeTransitGatewayRouteTablesResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TransitGatewayRouteTables: js.UndefOr[TransitGatewayRouteTableList]
  }

  object DescribeTransitGatewayRouteTablesResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayRouteTables: js.UndefOr[TransitGatewayRouteTableList] = js.undefined
    ): DescribeTransitGatewayRouteTablesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGatewayRouteTables" -> TransitGatewayRouteTables.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeTransitGatewayRouteTablesResult]
    }
  }

  @js.native
  trait DescribeTransitGatewayVpcAttachmentsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
    var TransitGatewayAttachmentIds: js.UndefOr[TransitGatewayAttachmentIdStringList]
  }

  object DescribeTransitGatewayVpcAttachmentsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayAttachmentIds: js.UndefOr[TransitGatewayAttachmentIdStringList] = js.undefined
    ): DescribeTransitGatewayVpcAttachmentsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGatewayAttachmentIds" -> TransitGatewayAttachmentIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeTransitGatewayVpcAttachmentsRequest]
    }
  }

  @js.native
  trait DescribeTransitGatewayVpcAttachmentsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TransitGatewayVpcAttachments: js.UndefOr[TransitGatewayVpcAttachmentList]
  }

  object DescribeTransitGatewayVpcAttachmentsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayVpcAttachments: js.UndefOr[TransitGatewayVpcAttachmentList] = js.undefined
    ): DescribeTransitGatewayVpcAttachmentsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGatewayVpcAttachments" -> TransitGatewayVpcAttachments.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeTransitGatewayVpcAttachmentsResult]
    }
  }

  @js.native
  trait DescribeTransitGatewaysRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
    var TransitGatewayIds: js.UndefOr[TransitGatewayIdStringList]
  }

  object DescribeTransitGatewaysRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayIds: js.UndefOr[TransitGatewayIdStringList] = js.undefined
    ): DescribeTransitGatewaysRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGatewayIds" -> TransitGatewayIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeTransitGatewaysRequest]
    }
  }

  @js.native
  trait DescribeTransitGatewaysResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TransitGateways: js.UndefOr[TransitGatewayList]
  }

  object DescribeTransitGatewaysResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGateways: js.UndefOr[TransitGatewayList] = js.undefined
    ): DescribeTransitGatewaysResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGateways" -> TransitGateways.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeTransitGatewaysResult]
    }
  }

  /**
    * Contains the parameters for DescribeVolumeAttribute.
    */
  @js.native
  trait DescribeVolumeAttributeRequest extends js.Object {
    var Attribute: VolumeAttributeName
    var VolumeId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeVolumeAttributeRequest {
    def apply(
        Attribute: VolumeAttributeName,
        VolumeId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeVolumeAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Attribute" -> Attribute.asInstanceOf[js.Any],
        "VolumeId"  -> VolumeId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVolumeAttributeRequest]
    }
  }

  /**
    * Contains the output of DescribeVolumeAttribute.
    */
  @js.native
  trait DescribeVolumeAttributeResult extends js.Object {
    var AutoEnableIO: js.UndefOr[AttributeBooleanValue]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var VolumeId: js.UndefOr[String]
  }

  object DescribeVolumeAttributeResult {
    def apply(
        AutoEnableIO: js.UndefOr[AttributeBooleanValue] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        VolumeId: js.UndefOr[String] = js.undefined
    ): DescribeVolumeAttributeResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AutoEnableIO" -> AutoEnableIO.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductCodes" -> ProductCodes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeId" -> VolumeId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVolumeAttributeResult]
    }
  }

  /**
    * Contains the parameters for DescribeVolumeStatus.
    */
  @js.native
  trait DescribeVolumeStatusRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var VolumeIds: js.UndefOr[VolumeIdStringList]
  }

  object DescribeVolumeStatusRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        VolumeIds: js.UndefOr[VolumeIdStringList] = js.undefined
    ): DescribeVolumeStatusRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeIds" -> VolumeIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVolumeStatusRequest]
    }
  }

  /**
    * Contains the output of DescribeVolumeStatus.
    */
  @js.native
  trait DescribeVolumeStatusResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var VolumeStatuses: js.UndefOr[VolumeStatusList]
  }

  object DescribeVolumeStatusResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        VolumeStatuses: js.UndefOr[VolumeStatusList] = js.undefined
    ): DescribeVolumeStatusResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeStatuses" -> VolumeStatuses.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVolumeStatusResult]
    }
  }

  @js.native
  trait DescribeVolumesModificationsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var VolumeIds: js.UndefOr[VolumeIdStringList]
  }

  object DescribeVolumesModificationsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        VolumeIds: js.UndefOr[VolumeIdStringList] = js.undefined
    ): DescribeVolumesModificationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeIds" -> VolumeIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVolumesModificationsRequest]
    }
  }

  @js.native
  trait DescribeVolumesModificationsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var VolumesModifications: js.UndefOr[VolumeModificationList]
  }

  object DescribeVolumesModificationsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        VolumesModifications: js.UndefOr[VolumeModificationList] = js.undefined
    ): DescribeVolumesModificationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumesModifications" -> VolumesModifications.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVolumesModificationsResult]
    }
  }

  /**
    * Contains the parameters for DescribeVolumes.
    */
  @js.native
  trait DescribeVolumesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var VolumeIds: js.UndefOr[VolumeIdStringList]
  }

  object DescribeVolumesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        VolumeIds: js.UndefOr[VolumeIdStringList] = js.undefined
    ): DescribeVolumesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeIds" -> VolumeIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVolumesRequest]
    }
  }

  /**
    * Contains the output of DescribeVolumes.
    */
  @js.native
  trait DescribeVolumesResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Volumes: js.UndefOr[VolumeList]
  }

  object DescribeVolumesResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Volumes: js.UndefOr[VolumeList] = js.undefined
    ): DescribeVolumesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Volumes" -> Volumes.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVolumesResult]
    }
  }

  @js.native
  trait DescribeVpcAttributeRequest extends js.Object {
    var Attribute: VpcAttributeName
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeVpcAttributeRequest {
    def apply(
        Attribute: VpcAttributeName,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeVpcAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Attribute" -> Attribute.asInstanceOf[js.Any],
        "VpcId"     -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcAttributeRequest]
    }
  }

  @js.native
  trait DescribeVpcAttributeResult extends js.Object {
    var EnableDnsHostnames: js.UndefOr[AttributeBooleanValue]
    var EnableDnsSupport: js.UndefOr[AttributeBooleanValue]
    var VpcId: js.UndefOr[String]
  }

  object DescribeVpcAttributeResult {
    def apply(
        EnableDnsHostnames: js.UndefOr[AttributeBooleanValue] = js.undefined,
        EnableDnsSupport: js.UndefOr[AttributeBooleanValue] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): DescribeVpcAttributeResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "EnableDnsHostnames" -> EnableDnsHostnames.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EnableDnsSupport" -> EnableDnsSupport.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcAttributeResult]
    }
  }

  @js.native
  trait DescribeVpcClassicLinkDnsSupportRequest extends js.Object {
    var MaxResults: js.UndefOr[MaxResults]
    var NextToken: js.UndefOr[NextToken]
    var VpcIds: js.UndefOr[VpcClassicLinkIdList]
  }

  object DescribeVpcClassicLinkDnsSupportRequest {
    def apply(
        MaxResults: js.UndefOr[MaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined,
        VpcIds: js.UndefOr[VpcClassicLinkIdList] = js.undefined
    ): DescribeVpcClassicLinkDnsSupportRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcIds" -> VpcIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcClassicLinkDnsSupportRequest]
    }
  }

  @js.native
  trait DescribeVpcClassicLinkDnsSupportResult extends js.Object {
    var NextToken: js.UndefOr[NextToken]
    var Vpcs: js.UndefOr[ClassicLinkDnsSupportList]
  }

  object DescribeVpcClassicLinkDnsSupportResult {
    def apply(
        NextToken: js.UndefOr[NextToken] = js.undefined,
        Vpcs: js.UndefOr[ClassicLinkDnsSupportList] = js.undefined
    ): DescribeVpcClassicLinkDnsSupportResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Vpcs" -> Vpcs.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcClassicLinkDnsSupportResult]
    }
  }

  @js.native
  trait DescribeVpcClassicLinkRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var VpcIds: js.UndefOr[VpcClassicLinkIdList]
  }

  object DescribeVpcClassicLinkRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        VpcIds: js.UndefOr[VpcClassicLinkIdList] = js.undefined
    ): DescribeVpcClassicLinkRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcIds" -> VpcIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcClassicLinkRequest]
    }
  }

  @js.native
  trait DescribeVpcClassicLinkResult extends js.Object {
    var Vpcs: js.UndefOr[VpcClassicLinkList]
  }

  object DescribeVpcClassicLinkResult {
    def apply(
        Vpcs: js.UndefOr[VpcClassicLinkList] = js.undefined
    ): DescribeVpcClassicLinkResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Vpcs" -> Vpcs.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcClassicLinkResult]
    }
  }

  @js.native
  trait DescribeVpcEndpointConnectionNotificationsRequest extends js.Object {
    var ConnectionNotificationId: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeVpcEndpointConnectionNotificationsRequest {
    def apply(
        ConnectionNotificationId: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeVpcEndpointConnectionNotificationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ConnectionNotificationId" -> ConnectionNotificationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeVpcEndpointConnectionNotificationsRequest]
    }
  }

  @js.native
  trait DescribeVpcEndpointConnectionNotificationsResult extends js.Object {
    var ConnectionNotificationSet: js.UndefOr[ConnectionNotificationSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeVpcEndpointConnectionNotificationsResult {
    def apply(
        ConnectionNotificationSet: js.UndefOr[ConnectionNotificationSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeVpcEndpointConnectionNotificationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ConnectionNotificationSet" -> ConnectionNotificationSet.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeVpcEndpointConnectionNotificationsResult]
    }
  }

  @js.native
  trait DescribeVpcEndpointConnectionsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeVpcEndpointConnectionsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeVpcEndpointConnectionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcEndpointConnectionsRequest]
    }
  }

  @js.native
  trait DescribeVpcEndpointConnectionsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var VpcEndpointConnections: js.UndefOr[VpcEndpointConnectionSet]
  }

  object DescribeVpcEndpointConnectionsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        VpcEndpointConnections: js.UndefOr[VpcEndpointConnectionSet] = js.undefined
    ): DescribeVpcEndpointConnectionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcEndpointConnections" -> VpcEndpointConnections.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcEndpointConnectionsResult]
    }
  }

  @js.native
  trait DescribeVpcEndpointServiceConfigurationsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var ServiceIds: js.UndefOr[ValueStringList]
  }

  object DescribeVpcEndpointServiceConfigurationsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        ServiceIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeVpcEndpointServiceConfigurationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ServiceIds" -> ServiceIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeVpcEndpointServiceConfigurationsRequest]
    }
  }

  @js.native
  trait DescribeVpcEndpointServiceConfigurationsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var ServiceConfigurations: js.UndefOr[ServiceConfigurationSet]
  }

  object DescribeVpcEndpointServiceConfigurationsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        ServiceConfigurations: js.UndefOr[ServiceConfigurationSet] = js.undefined
    ): DescribeVpcEndpointServiceConfigurationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ServiceConfigurations" -> ServiceConfigurations.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeVpcEndpointServiceConfigurationsResult]
    }
  }

  @js.native
  trait DescribeVpcEndpointServicePermissionsRequest extends js.Object {
    var ServiceId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeVpcEndpointServicePermissionsRequest {
    def apply(
        ServiceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeVpcEndpointServicePermissionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ServiceId" -> ServiceId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeVpcEndpointServicePermissionsRequest]
    }
  }

  @js.native
  trait DescribeVpcEndpointServicePermissionsResult extends js.Object {
    var AllowedPrincipals: js.UndefOr[AllowedPrincipalSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeVpcEndpointServicePermissionsResult {
    def apply(
        AllowedPrincipals: js.UndefOr[AllowedPrincipalSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeVpcEndpointServicePermissionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllowedPrincipals" -> AllowedPrincipals.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DescribeVpcEndpointServicePermissionsResult]
    }
  }

  /**
    * Contains the parameters for DescribeVpcEndpointServices.
    */
  @js.native
  trait DescribeVpcEndpointServicesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var ServiceNames: js.UndefOr[ValueStringList]
  }

  object DescribeVpcEndpointServicesRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        ServiceNames: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeVpcEndpointServicesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ServiceNames" -> ServiceNames.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcEndpointServicesRequest]
    }
  }

  /**
    * Contains the output of DescribeVpcEndpointServices.
    */
  @js.native
  trait DescribeVpcEndpointServicesResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var ServiceDetails: js.UndefOr[ServiceDetailSet]
    var ServiceNames: js.UndefOr[ValueStringList]
  }

  object DescribeVpcEndpointServicesResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        ServiceDetails: js.UndefOr[ServiceDetailSet] = js.undefined,
        ServiceNames: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeVpcEndpointServicesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ServiceDetails" -> ServiceDetails.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ServiceNames" -> ServiceNames.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcEndpointServicesResult]
    }
  }

  /**
    * Contains the parameters for DescribeVpcEndpoints.
    */
  @js.native
  trait DescribeVpcEndpointsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var VpcEndpointIds: js.UndefOr[ValueStringList]
  }

  object DescribeVpcEndpointsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        VpcEndpointIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeVpcEndpointsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcEndpointIds" -> VpcEndpointIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcEndpointsRequest]
    }
  }

  /**
    * Contains the output of DescribeVpcEndpoints.
    */
  @js.native
  trait DescribeVpcEndpointsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var VpcEndpoints: js.UndefOr[VpcEndpointSet]
  }

  object DescribeVpcEndpointsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        VpcEndpoints: js.UndefOr[VpcEndpointSet] = js.undefined
    ): DescribeVpcEndpointsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcEndpoints" -> VpcEndpoints.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcEndpointsResult]
    }
  }

  @js.native
  trait DescribeVpcPeeringConnectionsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeVpcPeeringConnectionsMaxResults]
    var NextToken: js.UndefOr[String]
    var VpcPeeringConnectionIds: js.UndefOr[ValueStringList]
  }

  object DescribeVpcPeeringConnectionsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeVpcPeeringConnectionsMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        VpcPeeringConnectionIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeVpcPeeringConnectionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcPeeringConnectionIds" -> VpcPeeringConnectionIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcPeeringConnectionsRequest]
    }
  }

  @js.native
  trait DescribeVpcPeeringConnectionsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var VpcPeeringConnections: js.UndefOr[VpcPeeringConnectionList]
  }

  object DescribeVpcPeeringConnectionsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        VpcPeeringConnections: js.UndefOr[VpcPeeringConnectionList] = js.undefined
    ): DescribeVpcPeeringConnectionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcPeeringConnections" -> VpcPeeringConnections.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcPeeringConnectionsResult]
    }
  }

  @js.native
  trait DescribeVpcsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeVpcsMaxResults]
    var NextToken: js.UndefOr[String]
    var VpcIds: js.UndefOr[VpcIdStringList]
  }

  object DescribeVpcsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeVpcsMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        VpcIds: js.UndefOr[VpcIdStringList] = js.undefined
    ): DescribeVpcsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcIds" -> VpcIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcsRequest]
    }
  }

  @js.native
  trait DescribeVpcsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Vpcs: js.UndefOr[VpcList]
  }

  object DescribeVpcsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Vpcs: js.UndefOr[VpcList] = js.undefined
    ): DescribeVpcsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Vpcs" -> Vpcs.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpcsResult]
    }
  }

  /**
    * Contains the parameters for DescribeVpnConnections.
    */
  @js.native
  trait DescribeVpnConnectionsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var VpnConnectionIds: js.UndefOr[VpnConnectionIdStringList]
  }

  object DescribeVpnConnectionsRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        VpnConnectionIds: js.UndefOr[VpnConnectionIdStringList] = js.undefined
    ): DescribeVpnConnectionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpnConnectionIds" -> VpnConnectionIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpnConnectionsRequest]
    }
  }

  /**
    * Contains the output of DescribeVpnConnections.
    */
  @js.native
  trait DescribeVpnConnectionsResult extends js.Object {
    var VpnConnections: js.UndefOr[VpnConnectionList]
  }

  object DescribeVpnConnectionsResult {
    def apply(
        VpnConnections: js.UndefOr[VpnConnectionList] = js.undefined
    ): DescribeVpnConnectionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpnConnections" -> VpnConnections.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpnConnectionsResult]
    }
  }

  /**
    * Contains the parameters for DescribeVpnGateways.
    */
  @js.native
  trait DescribeVpnGatewaysRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var VpnGatewayIds: js.UndefOr[VpnGatewayIdStringList]
  }

  object DescribeVpnGatewaysRequest {
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        VpnGatewayIds: js.UndefOr[VpnGatewayIdStringList] = js.undefined
    ): DescribeVpnGatewaysRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpnGatewayIds" -> VpnGatewayIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpnGatewaysRequest]
    }
  }

  /**
    * Contains the output of DescribeVpnGateways.
    */
  @js.native
  trait DescribeVpnGatewaysResult extends js.Object {
    var VpnGateways: js.UndefOr[VpnGatewayList]
  }

  object DescribeVpnGatewaysResult {
    def apply(
        VpnGateways: js.UndefOr[VpnGatewayList] = js.undefined
    ): DescribeVpnGatewaysResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpnGateways" -> VpnGateways.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DescribeVpnGatewaysResult]
    }
  }

  @js.native
  trait DetachClassicLinkVpcRequest extends js.Object {
    var InstanceId: String
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DetachClassicLinkVpcRequest {
    def apply(
        InstanceId: String,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DetachClassicLinkVpcRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "VpcId"      -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DetachClassicLinkVpcRequest]
    }
  }

  @js.native
  trait DetachClassicLinkVpcResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object DetachClassicLinkVpcResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): DetachClassicLinkVpcResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DetachClassicLinkVpcResult]
    }
  }

  @js.native
  trait DetachInternetGatewayRequest extends js.Object {
    var InternetGatewayId: String
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DetachInternetGatewayRequest {
    def apply(
        InternetGatewayId: String,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DetachInternetGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InternetGatewayId" -> InternetGatewayId.asInstanceOf[js.Any],
        "VpcId"             -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DetachInternetGatewayRequest]
    }
  }

  /**
    * Contains the parameters for DetachNetworkInterface.
    */
  @js.native
  trait DetachNetworkInterfaceRequest extends js.Object {
    var AttachmentId: String
    var DryRun: js.UndefOr[Boolean]
    var Force: js.UndefOr[Boolean]
  }

  object DetachNetworkInterfaceRequest {
    def apply(
        AttachmentId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Force: js.UndefOr[Boolean] = js.undefined
    ): DetachNetworkInterfaceRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AttachmentId" -> AttachmentId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Force" -> Force.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DetachNetworkInterfaceRequest]
    }
  }

  /**
    * Contains the parameters for DetachVolume.
    */
  @js.native
  trait DetachVolumeRequest extends js.Object {
    var VolumeId: String
    var Device: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Force: js.UndefOr[Boolean]
    var InstanceId: js.UndefOr[String]
  }

  object DetachVolumeRequest {
    def apply(
        VolumeId: String,
        Device: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Force: js.UndefOr[Boolean] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): DetachVolumeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VolumeId" -> VolumeId.asInstanceOf[js.Any],
        "Device" -> Device.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Force" -> Force.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DetachVolumeRequest]
    }
  }

  /**
    * Contains the parameters for DetachVpnGateway.
    */
  @js.native
  trait DetachVpnGatewayRequest extends js.Object {
    var VpcId: String
    var VpnGatewayId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DetachVpnGatewayRequest {
    def apply(
        VpcId: String,
        VpnGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DetachVpnGatewayRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId"        -> VpcId.asInstanceOf[js.Any],
        "VpnGatewayId" -> VpnGatewayId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DetachVpnGatewayRequest]
    }
  }

  object DeviceTypeEnum {
    val ebs              = "ebs"
    val `instance-store` = "instance-store"

    val values = IndexedSeq(ebs, `instance-store`)
  }

  /**
    * Describes a DHCP configuration option.
    */
  @js.native
  trait DhcpConfiguration extends js.Object {
    var Key: js.UndefOr[String]
    var Values: js.UndefOr[DhcpConfigurationValueList]
  }

  object DhcpConfiguration {
    def apply(
        Key: js.UndefOr[String] = js.undefined,
        Values: js.UndefOr[DhcpConfigurationValueList] = js.undefined
    ): DhcpConfiguration = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Key" -> Key.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Values" -> Values.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DhcpConfiguration]
    }
  }

  /**
    * Describes a set of DHCP options.
    */
  @js.native
  trait DhcpOptions extends js.Object {
    var DhcpConfigurations: js.UndefOr[DhcpConfigurationList]
    var DhcpOptionsId: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
  }

  object DhcpOptions {
    def apply(
        DhcpConfigurations: js.UndefOr[DhcpConfigurationList] = js.undefined,
        DhcpOptionsId: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): DhcpOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DhcpConfigurations" -> DhcpConfigurations.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DhcpOptionsId" -> DhcpOptionsId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OwnerId" -> OwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DhcpOptions]
    }
  }

  /**
    * Describes an Active Directory.
    */
  @js.native
  trait DirectoryServiceAuthentication extends js.Object {
    var DirectoryId: js.UndefOr[String]
  }

  object DirectoryServiceAuthentication {
    def apply(
        DirectoryId: js.UndefOr[String] = js.undefined
    ): DirectoryServiceAuthentication = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DirectoryId" -> DirectoryId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DirectoryServiceAuthentication]
    }
  }

  /**
    * Describes the Active Directory to be used for client authentication.
    */
  @js.native
  trait DirectoryServiceAuthenticationRequest extends js.Object {
    var DirectoryId: js.UndefOr[String]
  }

  object DirectoryServiceAuthenticationRequest {
    def apply(
        DirectoryId: js.UndefOr[String] = js.undefined
    ): DirectoryServiceAuthenticationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DirectoryId" -> DirectoryId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DirectoryServiceAuthenticationRequest]
    }
  }

  @js.native
  trait DisableTransitGatewayRouteTablePropagationRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DisableTransitGatewayRouteTablePropagationRequest {
    def apply(
        TransitGatewayAttachmentId: String,
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DisableTransitGatewayRouteTablePropagationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DisableTransitGatewayRouteTablePropagationRequest]
    }
  }

  @js.native
  trait DisableTransitGatewayRouteTablePropagationResult extends js.Object {
    var Propagation: js.UndefOr[TransitGatewayPropagation]
  }

  object DisableTransitGatewayRouteTablePropagationResult {
    def apply(
        Propagation: js.UndefOr[TransitGatewayPropagation] = js.undefined
    ): DisableTransitGatewayRouteTablePropagationResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Propagation" -> Propagation.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DisableTransitGatewayRouteTablePropagationResult]
    }
  }

  /**
    * Contains the parameters for DisableVgwRoutePropagation.
    */
  @js.native
  trait DisableVgwRoutePropagationRequest extends js.Object {
    var GatewayId: String
    var RouteTableId: String
  }

  object DisableVgwRoutePropagationRequest {
    def apply(
        GatewayId: String,
        RouteTableId: String
    ): DisableVgwRoutePropagationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "GatewayId"    -> GatewayId.asInstanceOf[js.Any],
        "RouteTableId" -> RouteTableId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisableVgwRoutePropagationRequest]
    }
  }

  @js.native
  trait DisableVpcClassicLinkDnsSupportRequest extends js.Object {
    var VpcId: js.UndefOr[String]
  }

  object DisableVpcClassicLinkDnsSupportRequest {
    def apply(
        VpcId: js.UndefOr[String] = js.undefined
    ): DisableVpcClassicLinkDnsSupportRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisableVpcClassicLinkDnsSupportRequest]
    }
  }

  @js.native
  trait DisableVpcClassicLinkDnsSupportResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object DisableVpcClassicLinkDnsSupportResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): DisableVpcClassicLinkDnsSupportResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisableVpcClassicLinkDnsSupportResult]
    }
  }

  @js.native
  trait DisableVpcClassicLinkRequest extends js.Object {
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DisableVpcClassicLinkRequest {
    def apply(
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DisableVpcClassicLinkRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId" -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisableVpcClassicLinkRequest]
    }
  }

  @js.native
  trait DisableVpcClassicLinkResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object DisableVpcClassicLinkResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): DisableVpcClassicLinkResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisableVpcClassicLinkResult]
    }
  }

  @js.native
  trait DisassociateAddressRequest extends js.Object {
    var AssociationId: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var PublicIp: js.UndefOr[String]
  }

  object DisassociateAddressRequest {
    def apply(
        AssociationId: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): DisassociateAddressRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociationId" -> AssociationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIp" -> PublicIp.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisassociateAddressRequest]
    }
  }

  @js.native
  trait DisassociateClientVpnTargetNetworkRequest extends js.Object {
    var AssociationId: String
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DisassociateClientVpnTargetNetworkRequest {
    def apply(
        AssociationId: String,
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DisassociateClientVpnTargetNetworkRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociationId"       -> AssociationId.asInstanceOf[js.Any],
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisassociateClientVpnTargetNetworkRequest]
    }
  }

  @js.native
  trait DisassociateClientVpnTargetNetworkResult extends js.Object {
    var AssociationId: js.UndefOr[String]
    var Status: js.UndefOr[AssociationStatus]
  }

  object DisassociateClientVpnTargetNetworkResult {
    def apply(
        AssociationId: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[AssociationStatus] = js.undefined
    ): DisassociateClientVpnTargetNetworkResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociationId" -> AssociationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisassociateClientVpnTargetNetworkResult]
    }
  }

  @js.native
  trait DisassociateIamInstanceProfileRequest extends js.Object {
    var AssociationId: String
  }

  object DisassociateIamInstanceProfileRequest {
    def apply(
        AssociationId: String
    ): DisassociateIamInstanceProfileRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociationId" -> AssociationId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisassociateIamInstanceProfileRequest]
    }
  }

  @js.native
  trait DisassociateIamInstanceProfileResult extends js.Object {
    var IamInstanceProfileAssociation: js.UndefOr[IamInstanceProfileAssociation]
  }

  object DisassociateIamInstanceProfileResult {
    def apply(
        IamInstanceProfileAssociation: js.UndefOr[IamInstanceProfileAssociation] = js.undefined
    ): DisassociateIamInstanceProfileResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "IamInstanceProfileAssociation" -> IamInstanceProfileAssociation.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisassociateIamInstanceProfileResult]
    }
  }

  @js.native
  trait DisassociateRouteTableRequest extends js.Object {
    var AssociationId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DisassociateRouteTableRequest {
    def apply(
        AssociationId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DisassociateRouteTableRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociationId" -> AssociationId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisassociateRouteTableRequest]
    }
  }

  @js.native
  trait DisassociateSubnetCidrBlockRequest extends js.Object {
    var AssociationId: String
  }

  object DisassociateSubnetCidrBlockRequest {
    def apply(
        AssociationId: String
    ): DisassociateSubnetCidrBlockRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociationId" -> AssociationId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisassociateSubnetCidrBlockRequest]
    }
  }

  @js.native
  trait DisassociateSubnetCidrBlockResult extends js.Object {
    var Ipv6CidrBlockAssociation: js.UndefOr[SubnetIpv6CidrBlockAssociation]
    var SubnetId: js.UndefOr[String]
  }

  object DisassociateSubnetCidrBlockResult {
    def apply(
        Ipv6CidrBlockAssociation: js.UndefOr[SubnetIpv6CidrBlockAssociation] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined
    ): DisassociateSubnetCidrBlockResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Ipv6CidrBlockAssociation" -> Ipv6CidrBlockAssociation.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisassociateSubnetCidrBlockResult]
    }
  }

  @js.native
  trait DisassociateTransitGatewayRouteTableRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DisassociateTransitGatewayRouteTableRequest {
    def apply(
        TransitGatewayAttachmentId: String,
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DisassociateTransitGatewayRouteTableRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DisassociateTransitGatewayRouteTableRequest]
    }
  }

  @js.native
  trait DisassociateTransitGatewayRouteTableResult extends js.Object {
    var Association: js.UndefOr[TransitGatewayAssociation]
  }

  object DisassociateTransitGatewayRouteTableResult {
    def apply(
        Association: js.UndefOr[TransitGatewayAssociation] = js.undefined
    ): DisassociateTransitGatewayRouteTableResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Association" -> Association.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[DisassociateTransitGatewayRouteTableResult]
    }
  }

  @js.native
  trait DisassociateVpcCidrBlockRequest extends js.Object {
    var AssociationId: String
  }

  object DisassociateVpcCidrBlockRequest {
    def apply(
        AssociationId: String
    ): DisassociateVpcCidrBlockRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociationId" -> AssociationId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisassociateVpcCidrBlockRequest]
    }
  }

  @js.native
  trait DisassociateVpcCidrBlockResult extends js.Object {
    var CidrBlockAssociation: js.UndefOr[VpcCidrBlockAssociation]
    var Ipv6CidrBlockAssociation: js.UndefOr[VpcIpv6CidrBlockAssociation]
    var VpcId: js.UndefOr[String]
  }

  object DisassociateVpcCidrBlockResult {
    def apply(
        CidrBlockAssociation: js.UndefOr[VpcCidrBlockAssociation] = js.undefined,
        Ipv6CidrBlockAssociation: js.UndefOr[VpcIpv6CidrBlockAssociation] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): DisassociateVpcCidrBlockResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CidrBlockAssociation" -> CidrBlockAssociation.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6CidrBlockAssociation" -> Ipv6CidrBlockAssociation.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DisassociateVpcCidrBlockResult]
    }
  }

  /**
    * Describes a disk image.
    */
  @js.native
  trait DiskImage extends js.Object {
    var Description: js.UndefOr[String]
    var Image: js.UndefOr[DiskImageDetail]
    var Volume: js.UndefOr[VolumeDetail]
  }

  object DiskImage {
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        Image: js.UndefOr[DiskImageDetail] = js.undefined,
        Volume: js.UndefOr[VolumeDetail] = js.undefined
    ): DiskImage = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Image" -> Image.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Volume" -> Volume.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DiskImage]
    }
  }

  /**
    * Describes a disk image.
    */
  @js.native
  trait DiskImageDescription extends js.Object {
    var Checksum: js.UndefOr[String]
    var Format: js.UndefOr[DiskImageFormat]
    var ImportManifestUrl: js.UndefOr[String]
    var Size: js.UndefOr[Double]
  }

  object DiskImageDescription {
    def apply(
        Checksum: js.UndefOr[String] = js.undefined,
        Format: js.UndefOr[DiskImageFormat] = js.undefined,
        ImportManifestUrl: js.UndefOr[String] = js.undefined,
        Size: js.UndefOr[Double] = js.undefined
    ): DiskImageDescription = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Checksum" -> Checksum.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Format" -> Format.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImportManifestUrl" -> ImportManifestUrl.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Size" -> Size.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DiskImageDescription]
    }
  }

  /**
    * Describes a disk image.
    */
  @js.native
  trait DiskImageDetail extends js.Object {
    var Bytes: Double
    var Format: DiskImageFormat
    var ImportManifestUrl: String
  }

  object DiskImageDetail {
    def apply(
        Bytes: Double,
        Format: DiskImageFormat,
        ImportManifestUrl: String
    ): DiskImageDetail = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Bytes"             -> Bytes.asInstanceOf[js.Any],
        "Format"            -> Format.asInstanceOf[js.Any],
        "ImportManifestUrl" -> ImportManifestUrl.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DiskImageDetail]
    }
  }

  object DiskImageFormatEnum {
    val VMDK = "VMDK"
    val RAW  = "RAW"
    val VHD  = "VHD"

    val values = IndexedSeq(VMDK, RAW, VHD)
  }

  /**
    * Describes a disk image volume.
    */
  @js.native
  trait DiskImageVolumeDescription extends js.Object {
    var Id: js.UndefOr[String]
    var Size: js.UndefOr[Double]
  }

  object DiskImageVolumeDescription {
    def apply(
        Id: js.UndefOr[String] = js.undefined,
        Size: js.UndefOr[Double] = js.undefined
    ): DiskImageVolumeDescription = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Id" -> Id.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Size" -> Size.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DiskImageVolumeDescription]
    }
  }

  /**
    * Describes a DNS entry.
    */
  @js.native
  trait DnsEntry extends js.Object {
    var DnsName: js.UndefOr[String]
    var HostedZoneId: js.UndefOr[String]
  }

  object DnsEntry {
    def apply(
        DnsName: js.UndefOr[String] = js.undefined,
        HostedZoneId: js.UndefOr[String] = js.undefined
    ): DnsEntry = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DnsName" -> DnsName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostedZoneId" -> HostedZoneId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DnsEntry]
    }
  }

  /**
    * Information about the DNS server to be used.
    */
  @js.native
  trait DnsServersOptionsModifyStructure extends js.Object {
    var CustomDnsServers: js.UndefOr[ValueStringList]
    var Enabled: js.UndefOr[Boolean]
  }

  object DnsServersOptionsModifyStructure {
    def apply(
        CustomDnsServers: js.UndefOr[ValueStringList] = js.undefined,
        Enabled: js.UndefOr[Boolean] = js.undefined
    ): DnsServersOptionsModifyStructure = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CustomDnsServers" -> CustomDnsServers.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Enabled" -> Enabled.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[DnsServersOptionsModifyStructure]
    }
  }

  object DnsSupportValueEnum {
    val enable  = "enable"
    val disable = "disable"

    val values = IndexedSeq(enable, disable)
  }

  object DomainTypeEnum {
    val vpc      = "vpc"
    val standard = "standard"

    val values = IndexedSeq(vpc, standard)
  }

  /**
    * Describes a block device for an EBS volume.
    */
  @js.native
  trait EbsBlockDevice extends js.Object {
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var Iops: js.UndefOr[Int]
    var KmsKeyId: js.UndefOr[String]
    var SnapshotId: js.UndefOr[String]
    var VolumeSize: js.UndefOr[Int]
    var VolumeType: js.UndefOr[VolumeType]
  }

  object EbsBlockDevice {
    def apply(
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Iops: js.UndefOr[Int] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        SnapshotId: js.UndefOr[String] = js.undefined,
        VolumeSize: js.UndefOr[Int] = js.undefined,
        VolumeType: js.UndefOr[VolumeType] = js.undefined
    ): EbsBlockDevice = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DeleteOnTermination" -> DeleteOnTermination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Encrypted" -> Encrypted.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Iops" -> Iops.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KmsKeyId" -> KmsKeyId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SnapshotId" -> SnapshotId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeSize" -> VolumeSize.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeType" -> VolumeType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[EbsBlockDevice]
    }
  }

  /**
    * Describes a parameter used to set up an EBS volume in a block device mapping.
    */
  @js.native
  trait EbsInstanceBlockDevice extends js.Object {
    var AttachTime: js.UndefOr[DateTime]
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Status: js.UndefOr[AttachmentStatus]
    var VolumeId: js.UndefOr[String]
  }

  object EbsInstanceBlockDevice {
    def apply(
        AttachTime: js.UndefOr[DateTime] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Status: js.UndefOr[AttachmentStatus] = js.undefined,
        VolumeId: js.UndefOr[String] = js.undefined
    ): EbsInstanceBlockDevice = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AttachTime" -> AttachTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeleteOnTermination" -> DeleteOnTermination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeId" -> VolumeId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[EbsInstanceBlockDevice]
    }
  }

  /**
    * Describes information used to set up an EBS volume specified in a block device mapping.
    */
  @js.native
  trait EbsInstanceBlockDeviceSpecification extends js.Object {
    var DeleteOnTermination: js.UndefOr[Boolean]
    var VolumeId: js.UndefOr[String]
  }

  object EbsInstanceBlockDeviceSpecification {
    def apply(
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        VolumeId: js.UndefOr[String] = js.undefined
    ): EbsInstanceBlockDeviceSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DeleteOnTermination" -> DeleteOnTermination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeId" -> VolumeId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[EbsInstanceBlockDeviceSpecification]
    }
  }

  /**
    * Describes an egress-only internet gateway.
    */
  @js.native
  trait EgressOnlyInternetGateway extends js.Object {
    var Attachments: js.UndefOr[InternetGatewayAttachmentList]
    var EgressOnlyInternetGatewayId: js.UndefOr[EgressOnlyInternetGatewayId]
  }

  object EgressOnlyInternetGateway {
    def apply(
        Attachments: js.UndefOr[InternetGatewayAttachmentList] = js.undefined,
        EgressOnlyInternetGatewayId: js.UndefOr[EgressOnlyInternetGatewayId] = js.undefined
    ): EgressOnlyInternetGateway = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Attachments" -> Attachments.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EgressOnlyInternetGatewayId" -> EgressOnlyInternetGatewayId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[EgressOnlyInternetGateway]
    }
  }

  /**
    * Describes the association between an instance and an Elastic Graphics accelerator.
    */
  @js.native
  trait ElasticGpuAssociation extends js.Object {
    var ElasticGpuAssociationId: js.UndefOr[String]
    var ElasticGpuAssociationState: js.UndefOr[String]
    var ElasticGpuAssociationTime: js.UndefOr[String]
    var ElasticGpuId: js.UndefOr[String]
  }

  object ElasticGpuAssociation {
    def apply(
        ElasticGpuAssociationId: js.UndefOr[String] = js.undefined,
        ElasticGpuAssociationState: js.UndefOr[String] = js.undefined,
        ElasticGpuAssociationTime: js.UndefOr[String] = js.undefined,
        ElasticGpuId: js.UndefOr[String] = js.undefined
    ): ElasticGpuAssociation = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ElasticGpuAssociationId" -> ElasticGpuAssociationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticGpuAssociationState" -> ElasticGpuAssociationState.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticGpuAssociationTime" -> ElasticGpuAssociationTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticGpuId" -> ElasticGpuId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ElasticGpuAssociation]
    }
  }

  /**
    * Describes the status of an Elastic Graphics accelerator.
    */
  @js.native
  trait ElasticGpuHealth extends js.Object {
    var Status: js.UndefOr[ElasticGpuStatus]
  }

  object ElasticGpuHealth {
    def apply(
        Status: js.UndefOr[ElasticGpuStatus] = js.undefined
    ): ElasticGpuHealth = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ElasticGpuHealth]
    }
  }

  /**
    * A specification for an Elastic Graphics accelerator.
    */
  @js.native
  trait ElasticGpuSpecification extends js.Object {
    var Type: String
  }

  object ElasticGpuSpecification {
    def apply(
        Type: String
    ): ElasticGpuSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Type" -> Type.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ElasticGpuSpecification]
    }
  }

  /**
    * Describes an elastic GPU.
    */
  @js.native
  trait ElasticGpuSpecificationResponse extends js.Object {
    var Type: js.UndefOr[String]
  }

  object ElasticGpuSpecificationResponse {
    def apply(
        Type: js.UndefOr[String] = js.undefined
    ): ElasticGpuSpecificationResponse = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Type" -> Type.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ElasticGpuSpecificationResponse]
    }
  }

  object ElasticGpuStateEnum {
    val ATTACHED = "ATTACHED"

    val values = IndexedSeq(ATTACHED)
  }

  object ElasticGpuStatusEnum {
    val OK       = "OK"
    val IMPAIRED = "IMPAIRED"

    val values = IndexedSeq(OK, IMPAIRED)
  }

  /**
    * Describes an Elastic Graphics accelerator.
    */
  @js.native
  trait ElasticGpus extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var ElasticGpuHealth: js.UndefOr[ElasticGpuHealth]
    var ElasticGpuId: js.UndefOr[String]
    var ElasticGpuState: js.UndefOr[ElasticGpuState]
    var ElasticGpuType: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
  }

  object ElasticGpus {
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        ElasticGpuHealth: js.UndefOr[ElasticGpuHealth] = js.undefined,
        ElasticGpuId: js.UndefOr[String] = js.undefined,
        ElasticGpuState: js.UndefOr[ElasticGpuState] = js.undefined,
        ElasticGpuType: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): ElasticGpus = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticGpuHealth" -> ElasticGpuHealth.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticGpuId" -> ElasticGpuId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticGpuState" -> ElasticGpuState.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticGpuType" -> ElasticGpuType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ElasticGpus]
    }
  }

  /**
    * Describes an elastic inference accelerator.
    */
  @js.native
  trait ElasticInferenceAccelerator extends js.Object {
    var Type: String
  }

  object ElasticInferenceAccelerator {
    def apply(
        Type: String
    ): ElasticInferenceAccelerator = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Type" -> Type.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ElasticInferenceAccelerator]
    }
  }

  /**
    * Describes the association between an instance and an elastic inference accelerator.
    */
  @js.native
  trait ElasticInferenceAcceleratorAssociation extends js.Object {
    var ElasticInferenceAcceleratorArn: js.UndefOr[String]
    var ElasticInferenceAcceleratorAssociationId: js.UndefOr[String]
    var ElasticInferenceAcceleratorAssociationState: js.UndefOr[String]
    var ElasticInferenceAcceleratorAssociationTime: js.UndefOr[DateTime]
  }

  object ElasticInferenceAcceleratorAssociation {
    def apply(
        ElasticInferenceAcceleratorArn: js.UndefOr[String] = js.undefined,
        ElasticInferenceAcceleratorAssociationId: js.UndefOr[String] = js.undefined,
        ElasticInferenceAcceleratorAssociationState: js.UndefOr[String] = js.undefined,
        ElasticInferenceAcceleratorAssociationTime: js.UndefOr[DateTime] = js.undefined
    ): ElasticInferenceAcceleratorAssociation = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ElasticInferenceAcceleratorArn" -> ElasticInferenceAcceleratorArn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticInferenceAcceleratorAssociationId" -> ElasticInferenceAcceleratorAssociationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticInferenceAcceleratorAssociationState" -> ElasticInferenceAcceleratorAssociationState.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticInferenceAcceleratorAssociationTime" -> ElasticInferenceAcceleratorAssociationTime.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ElasticInferenceAcceleratorAssociation]
    }
  }

  @js.native
  trait EnableTransitGatewayRouteTablePropagationRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object EnableTransitGatewayRouteTablePropagationRequest {
    def apply(
        TransitGatewayAttachmentId: String,
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): EnableTransitGatewayRouteTablePropagationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[EnableTransitGatewayRouteTablePropagationRequest]
    }
  }

  @js.native
  trait EnableTransitGatewayRouteTablePropagationResult extends js.Object {
    var Propagation: js.UndefOr[TransitGatewayPropagation]
  }

  object EnableTransitGatewayRouteTablePropagationResult {
    def apply(
        Propagation: js.UndefOr[TransitGatewayPropagation] = js.undefined
    ): EnableTransitGatewayRouteTablePropagationResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Propagation" -> Propagation.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[EnableTransitGatewayRouteTablePropagationResult]
    }
  }

  /**
    * Contains the parameters for EnableVgwRoutePropagation.
    */
  @js.native
  trait EnableVgwRoutePropagationRequest extends js.Object {
    var GatewayId: String
    var RouteTableId: String
  }

  object EnableVgwRoutePropagationRequest {
    def apply(
        GatewayId: String,
        RouteTableId: String
    ): EnableVgwRoutePropagationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "GatewayId"    -> GatewayId.asInstanceOf[js.Any],
        "RouteTableId" -> RouteTableId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[EnableVgwRoutePropagationRequest]
    }
  }

  /**
    * Contains the parameters for EnableVolumeIO.
    */
  @js.native
  trait EnableVolumeIORequest extends js.Object {
    var VolumeId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object EnableVolumeIORequest {
    def apply(
        VolumeId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): EnableVolumeIORequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VolumeId" -> VolumeId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[EnableVolumeIORequest]
    }
  }

  @js.native
  trait EnableVpcClassicLinkDnsSupportRequest extends js.Object {
    var VpcId: js.UndefOr[String]
  }

  object EnableVpcClassicLinkDnsSupportRequest {
    def apply(
        VpcId: js.UndefOr[String] = js.undefined
    ): EnableVpcClassicLinkDnsSupportRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[EnableVpcClassicLinkDnsSupportRequest]
    }
  }

  @js.native
  trait EnableVpcClassicLinkDnsSupportResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object EnableVpcClassicLinkDnsSupportResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): EnableVpcClassicLinkDnsSupportResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[EnableVpcClassicLinkDnsSupportResult]
    }
  }

  @js.native
  trait EnableVpcClassicLinkRequest extends js.Object {
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object EnableVpcClassicLinkRequest {
    def apply(
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): EnableVpcClassicLinkRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId" -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[EnableVpcClassicLinkRequest]
    }
  }

  @js.native
  trait EnableVpcClassicLinkResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object EnableVpcClassicLinkResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): EnableVpcClassicLinkResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[EnableVpcClassicLinkResult]
    }
  }

  object EndDateTypeEnum {
    val unlimited = "unlimited"
    val limited   = "limited"

    val values = IndexedSeq(unlimited, limited)
  }

  object EventCodeEnum {
    val `instance-reboot`     = "instance-reboot"
    val `system-reboot`       = "system-reboot"
    val `system-maintenance`  = "system-maintenance"
    val `instance-retirement` = "instance-retirement"
    val `instance-stop`       = "instance-stop"

    val values =
      IndexedSeq(`instance-reboot`, `system-reboot`, `system-maintenance`, `instance-retirement`, `instance-stop`)
  }

  /**
    * Describes a Spot Fleet event.
    */
  @js.native
  trait EventInformation extends js.Object {
    var EventDescription: js.UndefOr[String]
    var EventSubType: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
  }

  object EventInformation {
    def apply(
        EventDescription: js.UndefOr[String] = js.undefined,
        EventSubType: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): EventInformation = {
      val _fields = IndexedSeq[(String, js.Any)](
        "EventDescription" -> EventDescription.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EventSubType" -> EventSubType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[EventInformation]
    }
  }

  object EventTypeEnum {
    val instanceChange     = "instanceChange"
    val fleetRequestChange = "fleetRequestChange"
    val error              = "error"

    val values = IndexedSeq(instanceChange, fleetRequestChange, error)
  }

  object ExcessCapacityTerminationPolicyEnum {
    val noTermination = "noTermination"
    val default       = "default"

    val values = IndexedSeq(noTermination, default)
  }

  @js.native
  trait ExportClientVpnClientCertificateRevocationListRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ExportClientVpnClientCertificateRevocationListRequest {
    def apply(
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ExportClientVpnClientCertificateRevocationListRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ExportClientVpnClientCertificateRevocationListRequest]
    }
  }

  @js.native
  trait ExportClientVpnClientCertificateRevocationListResult extends js.Object {
    var CertificateRevocationList: js.UndefOr[String]
    var Status: js.UndefOr[ClientCertificateRevocationListStatus]
  }

  object ExportClientVpnClientCertificateRevocationListResult {
    def apply(
        CertificateRevocationList: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[ClientCertificateRevocationListStatus] = js.undefined
    ): ExportClientVpnClientCertificateRevocationListResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CertificateRevocationList" -> CertificateRevocationList.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ExportClientVpnClientCertificateRevocationListResult]
    }
  }

  @js.native
  trait ExportClientVpnClientConfigurationRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ExportClientVpnClientConfigurationRequest {
    def apply(
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ExportClientVpnClientConfigurationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ExportClientVpnClientConfigurationRequest]
    }
  }

  @js.native
  trait ExportClientVpnClientConfigurationResult extends js.Object {
    var ClientConfiguration: js.UndefOr[String]
  }

  object ExportClientVpnClientConfigurationResult {
    def apply(
        ClientConfiguration: js.UndefOr[String] = js.undefined
    ): ExportClientVpnClientConfigurationResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientConfiguration" -> ClientConfiguration.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ExportClientVpnClientConfigurationResult]
    }
  }

  object ExportEnvironmentEnum {
    val citrix    = "citrix"
    val vmware    = "vmware"
    val microsoft = "microsoft"

    val values = IndexedSeq(citrix, vmware, microsoft)
  }

  /**
    * Describes an instance export task.
    */
  @js.native
  trait ExportTask extends js.Object {
    var Description: js.UndefOr[String]
    var ExportTaskId: js.UndefOr[String]
    var ExportToS3Task: js.UndefOr[ExportToS3Task]
    var InstanceExportDetails: js.UndefOr[InstanceExportDetails]
    var State: js.UndefOr[ExportTaskState]
    var StatusMessage: js.UndefOr[String]
  }

  object ExportTask {
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        ExportTaskId: js.UndefOr[String] = js.undefined,
        ExportToS3Task: js.UndefOr[ExportToS3Task] = js.undefined,
        InstanceExportDetails: js.UndefOr[InstanceExportDetails] = js.undefined,
        State: js.UndefOr[ExportTaskState] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined
    ): ExportTask = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ExportTaskId" -> ExportTaskId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ExportToS3Task" -> ExportToS3Task.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceExportDetails" -> InstanceExportDetails.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StatusMessage" -> StatusMessage.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ExportTask]
    }
  }

  object ExportTaskStateEnum {
    val active     = "active"
    val cancelling = "cancelling"
    val cancelled  = "cancelled"
    val completed  = "completed"

    val values = IndexedSeq(active, cancelling, cancelled, completed)
  }

  /**
    * Describes the format and location for an instance export task.
    */
  @js.native
  trait ExportToS3Task extends js.Object {
    var ContainerFormat: js.UndefOr[ContainerFormat]
    var DiskImageFormat: js.UndefOr[DiskImageFormat]
    var S3Bucket: js.UndefOr[String]
    var S3Key: js.UndefOr[String]
  }

  object ExportToS3Task {
    def apply(
        ContainerFormat: js.UndefOr[ContainerFormat] = js.undefined,
        DiskImageFormat: js.UndefOr[DiskImageFormat] = js.undefined,
        S3Bucket: js.UndefOr[String] = js.undefined,
        S3Key: js.UndefOr[String] = js.undefined
    ): ExportToS3Task = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ContainerFormat" -> ContainerFormat.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DiskImageFormat" -> DiskImageFormat.map { x =>
          x.asInstanceOf[js.Any]
        },
        "S3Bucket" -> S3Bucket.map { x =>
          x.asInstanceOf[js.Any]
        },
        "S3Key" -> S3Key.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ExportToS3Task]
    }
  }

  /**
    * Describes an instance export task.
    */
  @js.native
  trait ExportToS3TaskSpecification extends js.Object {
    var ContainerFormat: js.UndefOr[ContainerFormat]
    var DiskImageFormat: js.UndefOr[DiskImageFormat]
    var S3Bucket: js.UndefOr[String]
    var S3Prefix: js.UndefOr[String]
  }

  object ExportToS3TaskSpecification {
    def apply(
        ContainerFormat: js.UndefOr[ContainerFormat] = js.undefined,
        DiskImageFormat: js.UndefOr[DiskImageFormat] = js.undefined,
        S3Bucket: js.UndefOr[String] = js.undefined,
        S3Prefix: js.UndefOr[String] = js.undefined
    ): ExportToS3TaskSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ContainerFormat" -> ContainerFormat.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DiskImageFormat" -> DiskImageFormat.map { x =>
          x.asInstanceOf[js.Any]
        },
        "S3Bucket" -> S3Bucket.map { x =>
          x.asInstanceOf[js.Any]
        },
        "S3Prefix" -> S3Prefix.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ExportToS3TaskSpecification]
    }
  }

  @js.native
  trait ExportTransitGatewayRoutesRequest extends js.Object {
    var S3Bucket: String
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
  }

  object ExportTransitGatewayRoutesRequest {
    def apply(
        S3Bucket: String,
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined
    ): ExportTransitGatewayRoutesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "S3Bucket"                   -> S3Bucket.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ExportTransitGatewayRoutesRequest]
    }
  }

  @js.native
  trait ExportTransitGatewayRoutesResult extends js.Object {
    var S3Location: js.UndefOr[String]
  }

  object ExportTransitGatewayRoutesResult {
    def apply(
        S3Location: js.UndefOr[String] = js.undefined
    ): ExportTransitGatewayRoutesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "S3Location" -> S3Location.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ExportTransitGatewayRoutesResult]
    }
  }

  /**
    * A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as tags, attributes, or IDs. The filters supported by a describe operation are documented with the describe operation. For example:
    * * <a>DescribeAvailabilityZones</a>
    *  * <a>DescribeImages</a>
    *  * <a>DescribeInstances</a>
    *  * <a>DescribeKeyPairs</a>
    *  * <a>DescribeSecurityGroups</a>
    *  * <a>DescribeSnapshots</a>
    *  * <a>DescribeSubnets</a>
    *  * <a>DescribeTags</a>
    *  * <a>DescribeVolumes</a>
    *  * <a>DescribeVpcs</a>
    */
  @js.native
  trait Filter extends js.Object {
    var Name: js.UndefOr[String]
    var Values: js.UndefOr[ValueStringList]
  }

  object Filter {
    def apply(
        Name: js.UndefOr[String] = js.undefined,
        Values: js.UndefOr[ValueStringList] = js.undefined
    ): Filter = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Values" -> Values.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[Filter]
    }
  }

  object FleetActivityStatusEnum {
    val error                 = "error"
    val `pending-fulfillment` = "pending-fulfillment"
    val `pending-termination` = "pending-termination"
    val fulfilled             = "fulfilled"

    val values = IndexedSeq(error, `pending-fulfillment`, `pending-termination`, fulfilled)
  }

  /**
    * Describes an EC2 Fleet.
    */
  @js.native
  trait FleetData extends js.Object {
    var ActivityStatus: js.UndefOr[FleetActivityStatus]
    var ClientToken: js.UndefOr[String]
    var CreateTime: js.UndefOr[DateTime]
    var Errors: js.UndefOr[DescribeFleetsErrorSet]
    var ExcessCapacityTerminationPolicy: js.UndefOr[FleetExcessCapacityTerminationPolicy]
    var FleetId: js.UndefOr[FleetIdentifier]
    var FleetState: js.UndefOr[FleetStateCode]
    var FulfilledCapacity: js.UndefOr[Double]
    var FulfilledOnDemandCapacity: js.UndefOr[Double]
    var Instances: js.UndefOr[DescribeFleetsInstancesSet]
    var LaunchTemplateConfigs: js.UndefOr[FleetLaunchTemplateConfigList]
    var OnDemandOptions: js.UndefOr[OnDemandOptions]
    var ReplaceUnhealthyInstances: js.UndefOr[Boolean]
    var SpotOptions: js.UndefOr[SpotOptions]
    var Tags: js.UndefOr[TagList]
    var TargetCapacitySpecification: js.UndefOr[TargetCapacitySpecification]
    var TerminateInstancesWithExpiration: js.UndefOr[Boolean]
    var Type: js.UndefOr[FleetType]
    var ValidFrom: js.UndefOr[DateTime]
    var ValidUntil: js.UndefOr[DateTime]
  }

  object FleetData {
    def apply(
        ActivityStatus: js.UndefOr[FleetActivityStatus] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        CreateTime: js.UndefOr[DateTime] = js.undefined,
        Errors: js.UndefOr[DescribeFleetsErrorSet] = js.undefined,
        ExcessCapacityTerminationPolicy: js.UndefOr[FleetExcessCapacityTerminationPolicy] = js.undefined,
        FleetId: js.UndefOr[FleetIdentifier] = js.undefined,
        FleetState: js.UndefOr[FleetStateCode] = js.undefined,
        FulfilledCapacity: js.UndefOr[Double] = js.undefined,
        FulfilledOnDemandCapacity: js.UndefOr[Double] = js.undefined,
        Instances: js.UndefOr[DescribeFleetsInstancesSet] = js.undefined,
        LaunchTemplateConfigs: js.UndefOr[FleetLaunchTemplateConfigList] = js.undefined,
        OnDemandOptions: js.UndefOr[OnDemandOptions] = js.undefined,
        ReplaceUnhealthyInstances: js.UndefOr[Boolean] = js.undefined,
        SpotOptions: js.UndefOr[SpotOptions] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        TargetCapacitySpecification: js.UndefOr[TargetCapacitySpecification] = js.undefined,
        TerminateInstancesWithExpiration: js.UndefOr[Boolean] = js.undefined,
        Type: js.UndefOr[FleetType] = js.undefined,
        ValidFrom: js.UndefOr[DateTime] = js.undefined,
        ValidUntil: js.UndefOr[DateTime] = js.undefined
    ): FleetData = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ActivityStatus" -> ActivityStatus.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CreateTime" -> CreateTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Errors" -> Errors.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ExcessCapacityTerminationPolicy" -> ExcessCapacityTerminationPolicy.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FleetId" -> FleetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FleetState" -> FleetState.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FulfilledCapacity" -> FulfilledCapacity.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FulfilledOnDemandCapacity" -> FulfilledOnDemandCapacity.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Instances" -> Instances.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateConfigs" -> LaunchTemplateConfigs.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OnDemandOptions" -> OnDemandOptions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReplaceUnhealthyInstances" -> ReplaceUnhealthyInstances.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotOptions" -> SpotOptions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TargetCapacitySpecification" -> TargetCapacitySpecification.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TerminateInstancesWithExpiration" -> TerminateInstancesWithExpiration.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Type" -> Type.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ValidFrom" -> ValidFrom.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ValidUntil" -> ValidUntil.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[FleetData]
    }
  }

  object FleetEventTypeEnum {
    val `instance-change` = "instance-change"
    val `fleet-change`    = "fleet-change"
    val `service-error`   = "service-error"

    val values = IndexedSeq(`instance-change`, `fleet-change`, `service-error`)
  }

  object FleetExcessCapacityTerminationPolicyEnum {
    val `no-termination` = "no-termination"
    val termination      = "termination"

    val values = IndexedSeq(`no-termination`, termination)
  }

  /**
    * Describes a launch template and overrides.
    */
  @js.native
  trait FleetLaunchTemplateConfig extends js.Object {
    var LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecification]
    var Overrides: js.UndefOr[FleetLaunchTemplateOverridesList]
  }

  object FleetLaunchTemplateConfig {
    def apply(
        LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecification] = js.undefined,
        Overrides: js.UndefOr[FleetLaunchTemplateOverridesList] = js.undefined
    ): FleetLaunchTemplateConfig = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateSpecification" -> LaunchTemplateSpecification.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Overrides" -> Overrides.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[FleetLaunchTemplateConfig]
    }
  }

  /**
    * Describes a launch template and overrides.
    */
  @js.native
  trait FleetLaunchTemplateConfigRequest extends js.Object {
    var LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecificationRequest]
    var Overrides: js.UndefOr[FleetLaunchTemplateOverridesListRequest]
  }

  object FleetLaunchTemplateConfigRequest {
    def apply(
        LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecificationRequest] = js.undefined,
        Overrides: js.UndefOr[FleetLaunchTemplateOverridesListRequest] = js.undefined
    ): FleetLaunchTemplateConfigRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateSpecification" -> LaunchTemplateSpecification.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Overrides" -> Overrides.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[FleetLaunchTemplateConfigRequest]
    }
  }

  /**
    * Describes overrides for a launch template.
    */
  @js.native
  trait FleetLaunchTemplateOverrides extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var InstanceType: js.UndefOr[InstanceType]
    var MaxPrice: js.UndefOr[String]
    var Placement: js.UndefOr[PlacementResponse]
    var Priority: js.UndefOr[Double]
    var SubnetId: js.UndefOr[String]
    var WeightedCapacity: js.UndefOr[Double]
  }

  object FleetLaunchTemplateOverrides {
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        MaxPrice: js.UndefOr[String] = js.undefined,
        Placement: js.UndefOr[PlacementResponse] = js.undefined,
        Priority: js.UndefOr[Double] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        WeightedCapacity: js.UndefOr[Double] = js.undefined
    ): FleetLaunchTemplateOverrides = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxPrice" -> MaxPrice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Placement" -> Placement.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Priority" -> Priority.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "WeightedCapacity" -> WeightedCapacity.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[FleetLaunchTemplateOverrides]
    }
  }

  /**
    * Describes overrides for a launch template.
    */
  @js.native
  trait FleetLaunchTemplateOverridesRequest extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var InstanceType: js.UndefOr[InstanceType]
    var MaxPrice: js.UndefOr[String]
    var Placement: js.UndefOr[Placement]
    var Priority: js.UndefOr[Double]
    var SubnetId: js.UndefOr[String]
    var WeightedCapacity: js.UndefOr[Double]
  }

  object FleetLaunchTemplateOverridesRequest {
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        MaxPrice: js.UndefOr[String] = js.undefined,
        Placement: js.UndefOr[Placement] = js.undefined,
        Priority: js.UndefOr[Double] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        WeightedCapacity: js.UndefOr[Double] = js.undefined
    ): FleetLaunchTemplateOverridesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxPrice" -> MaxPrice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Placement" -> Placement.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Priority" -> Priority.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "WeightedCapacity" -> WeightedCapacity.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[FleetLaunchTemplateOverridesRequest]
    }
  }

  /**
    * Describes a launch template.
    */
  @js.native
  trait FleetLaunchTemplateSpecification extends js.Object {
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
    var Version: js.UndefOr[String]
  }

  object FleetLaunchTemplateSpecification {
    def apply(
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined,
        Version: js.UndefOr[String] = js.undefined
    ): FleetLaunchTemplateSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateId" -> LaunchTemplateId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateName" -> LaunchTemplateName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Version" -> Version.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[FleetLaunchTemplateSpecification]
    }
  }

  /**
    * The launch template to use. You must specify either the launch template ID or launch template name in the request.
    */
  @js.native
  trait FleetLaunchTemplateSpecificationRequest extends js.Object {
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
    var Version: js.UndefOr[String]
  }

  object FleetLaunchTemplateSpecificationRequest {
    def apply(
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined,
        Version: js.UndefOr[String] = js.undefined
    ): FleetLaunchTemplateSpecificationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateId" -> LaunchTemplateId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateName" -> LaunchTemplateName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Version" -> Version.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[FleetLaunchTemplateSpecificationRequest]
    }
  }

  object FleetOnDemandAllocationStrategyEnum {
    val `lowest-price` = "lowest-price"
    val prioritized    = "prioritized"

    val values = IndexedSeq(`lowest-price`, prioritized)
  }

  object FleetStateCodeEnum {
    val submitted             = "submitted"
    val active                = "active"
    val deleted               = "deleted"
    val failed                = "failed"
    val `deleted-running`     = "deleted-running"
    val `deleted-terminating` = "deleted-terminating"
    val modifying             = "modifying"

    val values = IndexedSeq(submitted, active, deleted, failed, `deleted-running`, `deleted-terminating`, modifying)
  }

  object FleetTypeEnum {
    val request  = "request"
    val maintain = "maintain"
    val instant  = "instant"

    val values = IndexedSeq(request, maintain, instant)
  }

  /**
    * Describes a flow log.
    */
  @js.native
  trait FlowLog extends js.Object {
    var CreationTime: js.UndefOr[DateTime]
    var DeliverLogsErrorMessage: js.UndefOr[String]
    var DeliverLogsPermissionArn: js.UndefOr[String]
    var DeliverLogsStatus: js.UndefOr[String]
    var FlowLogId: js.UndefOr[String]
    var FlowLogStatus: js.UndefOr[String]
    var LogDestination: js.UndefOr[String]
    var LogDestinationType: js.UndefOr[LogDestinationType]
    var LogGroupName: js.UndefOr[String]
    var ResourceId: js.UndefOr[String]
    var TrafficType: js.UndefOr[TrafficType]
  }

  object FlowLog {
    def apply(
        CreationTime: js.UndefOr[DateTime] = js.undefined,
        DeliverLogsErrorMessage: js.UndefOr[String] = js.undefined,
        DeliverLogsPermissionArn: js.UndefOr[String] = js.undefined,
        DeliverLogsStatus: js.UndefOr[String] = js.undefined,
        FlowLogId: js.UndefOr[String] = js.undefined,
        FlowLogStatus: js.UndefOr[String] = js.undefined,
        LogDestination: js.UndefOr[String] = js.undefined,
        LogDestinationType: js.UndefOr[LogDestinationType] = js.undefined,
        LogGroupName: js.UndefOr[String] = js.undefined,
        ResourceId: js.UndefOr[String] = js.undefined,
        TrafficType: js.UndefOr[TrafficType] = js.undefined
    ): FlowLog = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CreationTime" -> CreationTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeliverLogsErrorMessage" -> DeliverLogsErrorMessage.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeliverLogsPermissionArn" -> DeliverLogsPermissionArn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeliverLogsStatus" -> DeliverLogsStatus.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FlowLogId" -> FlowLogId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FlowLogStatus" -> FlowLogStatus.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LogDestination" -> LogDestination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LogDestinationType" -> LogDestinationType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LogGroupName" -> LogGroupName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ResourceId" -> ResourceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TrafficType" -> TrafficType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[FlowLog]
    }
  }

  object FlowLogsResourceTypeEnum {
    val VPC              = "VPC"
    val Subnet           = "Subnet"
    val NetworkInterface = "NetworkInterface"

    val values = IndexedSeq(VPC, Subnet, NetworkInterface)
  }

  /**
    * Describes an Amazon FPGA image (AFI).
    */
  @js.native
  trait FpgaImage extends js.Object {
    var CreateTime: js.UndefOr[DateTime]
    var DataRetentionSupport: js.UndefOr[Boolean]
    var Description: js.UndefOr[String]
    var FpgaImageGlobalId: js.UndefOr[String]
    var FpgaImageId: js.UndefOr[String]
    var Name: js.UndefOr[String]
    var OwnerAlias: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var PciId: js.UndefOr[PciId]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var Public: js.UndefOr[Boolean]
    var ShellVersion: js.UndefOr[String]
    var State: js.UndefOr[FpgaImageState]
    var Tags: js.UndefOr[TagList]
    var UpdateTime: js.UndefOr[DateTime]
  }

  object FpgaImage {
    def apply(
        CreateTime: js.UndefOr[DateTime] = js.undefined,
        DataRetentionSupport: js.UndefOr[Boolean] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        FpgaImageGlobalId: js.UndefOr[String] = js.undefined,
        FpgaImageId: js.UndefOr[String] = js.undefined,
        Name: js.UndefOr[String] = js.undefined,
        OwnerAlias: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        PciId: js.UndefOr[PciId] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        Public: js.UndefOr[Boolean] = js.undefined,
        ShellVersion: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[FpgaImageState] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        UpdateTime: js.UndefOr[DateTime] = js.undefined
    ): FpgaImage = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CreateTime" -> CreateTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DataRetentionSupport" -> DataRetentionSupport.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FpgaImageGlobalId" -> FpgaImageGlobalId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FpgaImageId" -> FpgaImageId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OwnerAlias" -> OwnerAlias.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OwnerId" -> OwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PciId" -> PciId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductCodes" -> ProductCodes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Public" -> Public.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ShellVersion" -> ShellVersion.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UpdateTime" -> UpdateTime.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[FpgaImage]
    }
  }

  /**
    * Describes an Amazon FPGA image (AFI) attribute.
    */
  @js.native
  trait FpgaImageAttribute extends js.Object {
    var Description: js.UndefOr[String]
    var FpgaImageId: js.UndefOr[String]
    var LoadPermissions: js.UndefOr[LoadPermissionList]
    var Name: js.UndefOr[String]
    var ProductCodes: js.UndefOr[ProductCodeList]
  }

  object FpgaImageAttribute {
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        FpgaImageId: js.UndefOr[String] = js.undefined,
        LoadPermissions: js.UndefOr[LoadPermissionList] = js.undefined,
        Name: js.UndefOr[String] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined
    ): FpgaImageAttribute = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FpgaImageId" -> FpgaImageId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LoadPermissions" -> LoadPermissions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductCodes" -> ProductCodes.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[FpgaImageAttribute]
    }
  }

  object FpgaImageAttributeNameEnum {
    val description    = "description"
    val name           = "name"
    val loadPermission = "loadPermission"
    val productCodes   = "productCodes"

    val values = IndexedSeq(description, name, loadPermission, productCodes)
  }

  /**
    * Describes the state of the bitstream generation process for an Amazon FPGA image (AFI).
    */
  @js.native
  trait FpgaImageState extends js.Object {
    var Code: js.UndefOr[FpgaImageStateCode]
    var Message: js.UndefOr[String]
  }

  object FpgaImageState {
    def apply(
        Code: js.UndefOr[FpgaImageStateCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): FpgaImageState = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Message" -> Message.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[FpgaImageState]
    }
  }

  object FpgaImageStateCodeEnum {
    val pending     = "pending"
    val failed      = "failed"
    val available   = "available"
    val unavailable = "unavailable"

    val values = IndexedSeq(pending, failed, available, unavailable)
  }

  object GatewayTypeEnum {
    val `ipsec.1` = "ipsec.1"

    val values = IndexedSeq(`ipsec.1`)
  }

  @js.native
  trait GetConsoleOutputRequest extends js.Object {
    var InstanceId: String
    var DryRun: js.UndefOr[Boolean]
    var Latest: js.UndefOr[Boolean]
  }

  object GetConsoleOutputRequest {
    def apply(
        InstanceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Latest: js.UndefOr[Boolean] = js.undefined
    ): GetConsoleOutputRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Latest" -> Latest.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GetConsoleOutputRequest]
    }
  }

  @js.native
  trait GetConsoleOutputResult extends js.Object {
    var InstanceId: js.UndefOr[String]
    var Output: js.UndefOr[String]
    var Timestamp: js.UndefOr[DateTime]
  }

  object GetConsoleOutputResult {
    def apply(
        InstanceId: js.UndefOr[String] = js.undefined,
        Output: js.UndefOr[String] = js.undefined,
        Timestamp: js.UndefOr[DateTime] = js.undefined
    ): GetConsoleOutputResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Output" -> Output.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Timestamp" -> Timestamp.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GetConsoleOutputResult]
    }
  }

  @js.native
  trait GetConsoleScreenshotRequest extends js.Object {
    var InstanceId: String
    var DryRun: js.UndefOr[Boolean]
    var WakeUp: js.UndefOr[Boolean]
  }

  object GetConsoleScreenshotRequest {
    def apply(
        InstanceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        WakeUp: js.UndefOr[Boolean] = js.undefined
    ): GetConsoleScreenshotRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "WakeUp" -> WakeUp.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GetConsoleScreenshotRequest]
    }
  }

  @js.native
  trait GetConsoleScreenshotResult extends js.Object {
    var ImageData: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
  }

  object GetConsoleScreenshotResult {
    def apply(
        ImageData: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): GetConsoleScreenshotResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ImageData" -> ImageData.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GetConsoleScreenshotResult]
    }
  }

  @js.native
  trait GetHostReservationPurchasePreviewRequest extends js.Object {
    var HostIdSet: RequestHostIdSet
    var OfferingId: String
  }

  object GetHostReservationPurchasePreviewRequest {
    def apply(
        HostIdSet: RequestHostIdSet,
        OfferingId: String
    ): GetHostReservationPurchasePreviewRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "HostIdSet"  -> HostIdSet.asInstanceOf[js.Any],
        "OfferingId" -> OfferingId.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GetHostReservationPurchasePreviewRequest]
    }
  }

  @js.native
  trait GetHostReservationPurchasePreviewResult extends js.Object {
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var Purchase: js.UndefOr[PurchaseSet]
    var TotalHourlyPrice: js.UndefOr[String]
    var TotalUpfrontPrice: js.UndefOr[String]
  }

  object GetHostReservationPurchasePreviewResult {
    def apply(
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        Purchase: js.UndefOr[PurchaseSet] = js.undefined,
        TotalHourlyPrice: js.UndefOr[String] = js.undefined,
        TotalUpfrontPrice: js.UndefOr[String] = js.undefined
    ): GetHostReservationPurchasePreviewResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CurrencyCode" -> CurrencyCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Purchase" -> Purchase.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TotalHourlyPrice" -> TotalHourlyPrice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TotalUpfrontPrice" -> TotalUpfrontPrice.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GetHostReservationPurchasePreviewResult]
    }
  }

  @js.native
  trait GetLaunchTemplateDataRequest extends js.Object {
    var InstanceId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object GetLaunchTemplateDataRequest {
    def apply(
        InstanceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): GetLaunchTemplateDataRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GetLaunchTemplateDataRequest]
    }
  }

  @js.native
  trait GetLaunchTemplateDataResult extends js.Object {
    var LaunchTemplateData: js.UndefOr[ResponseLaunchTemplateData]
  }

  object GetLaunchTemplateDataResult {
    def apply(
        LaunchTemplateData: js.UndefOr[ResponseLaunchTemplateData] = js.undefined
    ): GetLaunchTemplateDataResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateData" -> LaunchTemplateData.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GetLaunchTemplateDataResult]
    }
  }

  @js.native
  trait GetPasswordDataRequest extends js.Object {
    var InstanceId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object GetPasswordDataRequest {
    def apply(
        InstanceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): GetPasswordDataRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GetPasswordDataRequest]
    }
  }

  @js.native
  trait GetPasswordDataResult extends js.Object {
    var InstanceId: js.UndefOr[String]
    var PasswordData: js.UndefOr[String]
    var Timestamp: js.UndefOr[DateTime]
  }

  object GetPasswordDataResult {
    def apply(
        InstanceId: js.UndefOr[String] = js.undefined,
        PasswordData: js.UndefOr[String] = js.undefined,
        Timestamp: js.UndefOr[DateTime] = js.undefined
    ): GetPasswordDataResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PasswordData" -> PasswordData.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Timestamp" -> Timestamp.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GetPasswordDataResult]
    }
  }

  /**
    * Contains the parameters for GetReservedInstanceExchangeQuote.
    */
  @js.native
  trait GetReservedInstancesExchangeQuoteRequest extends js.Object {
    var ReservedInstanceIds: ReservedInstanceIdSet
    var DryRun: js.UndefOr[Boolean]
    var TargetConfigurations: js.UndefOr[TargetConfigurationRequestSet]
  }

  object GetReservedInstancesExchangeQuoteRequest {
    def apply(
        ReservedInstanceIds: ReservedInstanceIdSet,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TargetConfigurations: js.UndefOr[TargetConfigurationRequestSet] = js.undefined
    ): GetReservedInstancesExchangeQuoteRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReservedInstanceIds" -> ReservedInstanceIds.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TargetConfigurations" -> TargetConfigurations.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GetReservedInstancesExchangeQuoteRequest]
    }
  }

  /**
    * Contains the output of GetReservedInstancesExchangeQuote.
    */
  @js.native
  trait GetReservedInstancesExchangeQuoteResult extends js.Object {
    var CurrencyCode: js.UndefOr[String]
    var IsValidExchange: js.UndefOr[Boolean]
    var OutputReservedInstancesWillExpireAt: js.UndefOr[DateTime]
    var PaymentDue: js.UndefOr[String]
    var ReservedInstanceValueRollup: js.UndefOr[ReservationValue]
    var ReservedInstanceValueSet: js.UndefOr[ReservedInstanceReservationValueSet]
    var TargetConfigurationValueRollup: js.UndefOr[ReservationValue]
    var TargetConfigurationValueSet: js.UndefOr[TargetReservationValueSet]
    var ValidationFailureReason: js.UndefOr[String]
  }

  object GetReservedInstancesExchangeQuoteResult {
    def apply(
        CurrencyCode: js.UndefOr[String] = js.undefined,
        IsValidExchange: js.UndefOr[Boolean] = js.undefined,
        OutputReservedInstancesWillExpireAt: js.UndefOr[DateTime] = js.undefined,
        PaymentDue: js.UndefOr[String] = js.undefined,
        ReservedInstanceValueRollup: js.UndefOr[ReservationValue] = js.undefined,
        ReservedInstanceValueSet: js.UndefOr[ReservedInstanceReservationValueSet] = js.undefined,
        TargetConfigurationValueRollup: js.UndefOr[ReservationValue] = js.undefined,
        TargetConfigurationValueSet: js.UndefOr[TargetReservationValueSet] = js.undefined,
        ValidationFailureReason: js.UndefOr[String] = js.undefined
    ): GetReservedInstancesExchangeQuoteResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CurrencyCode" -> CurrencyCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IsValidExchange" -> IsValidExchange.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OutputReservedInstancesWillExpireAt" -> OutputReservedInstancesWillExpireAt.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PaymentDue" -> PaymentDue.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReservedInstanceValueRollup" -> ReservedInstanceValueRollup.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReservedInstanceValueSet" -> ReservedInstanceValueSet.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TargetConfigurationValueRollup" -> TargetConfigurationValueRollup.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TargetConfigurationValueSet" -> TargetConfigurationValueSet.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ValidationFailureReason" -> ValidationFailureReason.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GetReservedInstancesExchangeQuoteResult]
    }
  }

  @js.native
  trait GetTransitGatewayAttachmentPropagationsRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object GetTransitGatewayAttachmentPropagationsRequest {
    def apply(
        TransitGatewayAttachmentId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): GetTransitGatewayAttachmentPropagationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[GetTransitGatewayAttachmentPropagationsRequest]
    }
  }

  @js.native
  trait GetTransitGatewayAttachmentPropagationsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TransitGatewayAttachmentPropagations: js.UndefOr[TransitGatewayAttachmentPropagationList]
  }

  object GetTransitGatewayAttachmentPropagationsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayAttachmentPropagations: js.UndefOr[TransitGatewayAttachmentPropagationList] = js.undefined
    ): GetTransitGatewayAttachmentPropagationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGatewayAttachmentPropagations" -> TransitGatewayAttachmentPropagations.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[GetTransitGatewayAttachmentPropagationsResult]
    }
  }

  @js.native
  trait GetTransitGatewayRouteTableAssociationsRequest extends js.Object {
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object GetTransitGatewayRouteTableAssociationsRequest {
    def apply(
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): GetTransitGatewayRouteTableAssociationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[GetTransitGatewayRouteTableAssociationsRequest]
    }
  }

  @js.native
  trait GetTransitGatewayRouteTableAssociationsResult extends js.Object {
    var Associations: js.UndefOr[TransitGatewayRouteTableAssociationList]
    var NextToken: js.UndefOr[String]
  }

  object GetTransitGatewayRouteTableAssociationsResult {
    def apply(
        Associations: js.UndefOr[TransitGatewayRouteTableAssociationList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): GetTransitGatewayRouteTableAssociationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Associations" -> Associations.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[GetTransitGatewayRouteTableAssociationsResult]
    }
  }

  @js.native
  trait GetTransitGatewayRouteTablePropagationsRequest extends js.Object {
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object GetTransitGatewayRouteTablePropagationsRequest {
    def apply(
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): GetTransitGatewayRouteTablePropagationsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Filters" -> Filters.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxResults" -> MaxResults.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[GetTransitGatewayRouteTablePropagationsRequest]
    }
  }

  @js.native
  trait GetTransitGatewayRouteTablePropagationsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TransitGatewayRouteTablePropagations: js.UndefOr[TransitGatewayRouteTablePropagationList]
  }

  object GetTransitGatewayRouteTablePropagationsResult {
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayRouteTablePropagations: js.UndefOr[TransitGatewayRouteTablePropagationList] = js.undefined
    ): GetTransitGatewayRouteTablePropagationsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NextToken" -> NextToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TransitGatewayRouteTablePropagations" -> TransitGatewayRouteTablePropagations.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[GetTransitGatewayRouteTablePropagationsResult]
    }
  }

  /**
    * Describes a security group.
    */
  @js.native
  trait GroupIdentifier extends js.Object {
    var GroupId: js.UndefOr[String]
    var GroupName: js.UndefOr[String]
  }

  object GroupIdentifier {
    def apply(
        GroupId: js.UndefOr[String] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined
    ): GroupIdentifier = {
      val _fields = IndexedSeq[(String, js.Any)](
        "GroupId" -> GroupId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupName" -> GroupName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[GroupIdentifier]
    }
  }

  /**
    * Indicates whether your instance is configured for hibernation. This parameter is valid only if the instance meets the [[https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites|hibernation prerequisites]]. Hibernation is currently supported only for Amazon Linux. For more information, see [[https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html|Hibernate Your Instance]] in the <i>Amazon Elastic Compute Cloud User Guide</i>.
    */
  @js.native
  trait HibernationOptions extends js.Object {
    var Configured: js.UndefOr[Boolean]
  }

  object HibernationOptions {
    def apply(
        Configured: js.UndefOr[Boolean] = js.undefined
    ): HibernationOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Configured" -> Configured.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[HibernationOptions]
    }
  }

  /**
    * Indicates whether your instance is configured for hibernation. This parameter is valid only if the instance meets the [[https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites|hibernation prerequisites]]. Hibernation is currently supported only for Amazon Linux. For more information, see [[https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html|Hibernate Your Instance]] in the <i>Amazon Elastic Compute Cloud User Guide</i>.
    */
  @js.native
  trait HibernationOptionsRequest extends js.Object {
    var Configured: js.UndefOr[Boolean]
  }

  object HibernationOptionsRequest {
    def apply(
        Configured: js.UndefOr[Boolean] = js.undefined
    ): HibernationOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Configured" -> Configured.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[HibernationOptionsRequest]
    }
  }

  /**
    * Describes an event in the history of the Spot Fleet request.
    */
  @js.native
  trait HistoryRecord extends js.Object {
    var EventInformation: js.UndefOr[EventInformation]
    var EventType: js.UndefOr[EventType]
    var Timestamp: js.UndefOr[DateTime]
  }

  object HistoryRecord {
    def apply(
        EventInformation: js.UndefOr[EventInformation] = js.undefined,
        EventType: js.UndefOr[EventType] = js.undefined,
        Timestamp: js.UndefOr[DateTime] = js.undefined
    ): HistoryRecord = {
      val _fields = IndexedSeq[(String, js.Any)](
        "EventInformation" -> EventInformation.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EventType" -> EventType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Timestamp" -> Timestamp.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[HistoryRecord]
    }
  }

  /**
    * Describes an event in the history of an EC2 Fleet.
    */
  @js.native
  trait HistoryRecordEntry extends js.Object {
    var EventInformation: js.UndefOr[EventInformation]
    var EventType: js.UndefOr[FleetEventType]
    var Timestamp: js.UndefOr[DateTime]
  }

  object HistoryRecordEntry {
    def apply(
        EventInformation: js.UndefOr[EventInformation] = js.undefined,
        EventType: js.UndefOr[FleetEventType] = js.undefined,
        Timestamp: js.UndefOr[DateTime] = js.undefined
    ): HistoryRecordEntry = {
      val _fields = IndexedSeq[(String, js.Any)](
        "EventInformation" -> EventInformation.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EventType" -> EventType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Timestamp" -> Timestamp.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[HistoryRecordEntry]
    }
  }

  /**
    * Describes the properties of the Dedicated Host.
    */
  @js.native
  trait Host extends js.Object {
    var AllocationTime: js.UndefOr[DateTime]
    var AutoPlacement: js.UndefOr[AutoPlacement]
    var AvailabilityZone: js.UndefOr[String]
    var AvailableCapacity: js.UndefOr[AvailableCapacity]
    var ClientToken: js.UndefOr[String]
    var HostId: js.UndefOr[String]
    var HostProperties: js.UndefOr[HostProperties]
    var HostReservationId: js.UndefOr[String]
    var Instances: js.UndefOr[HostInstanceList]
    var ReleaseTime: js.UndefOr[DateTime]
    var State: js.UndefOr[AllocationState]
    var Tags: js.UndefOr[TagList]
  }

  object Host {
    def apply(
        AllocationTime: js.UndefOr[DateTime] = js.undefined,
        AutoPlacement: js.UndefOr[AutoPlacement] = js.undefined,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        AvailableCapacity: js.UndefOr[AvailableCapacity] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        HostId: js.UndefOr[String] = js.undefined,
        HostProperties: js.UndefOr[HostProperties] = js.undefined,
        HostReservationId: js.UndefOr[String] = js.undefined,
        Instances: js.UndefOr[HostInstanceList] = js.undefined,
        ReleaseTime: js.UndefOr[DateTime] = js.undefined,
        State: js.UndefOr[AllocationState] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): Host = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllocationTime" -> AllocationTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AutoPlacement" -> AutoPlacement.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AvailableCapacity" -> AvailableCapacity.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostId" -> HostId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostProperties" -> HostProperties.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostReservationId" -> HostReservationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Instances" -> Instances.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ReleaseTime" -> ReleaseTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[Host]
    }
  }

  /**
    * Describes an instance running on a Dedicated Host.
    */
  @js.native
  trait HostInstance extends js.Object {
    var InstanceId: js.UndefOr[String]
    var InstanceType: js.UndefOr[String]
  }

  object HostInstance {
    def apply(
        InstanceId: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[String] = js.undefined
    ): HostInstance = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[HostInstance]
    }
  }

  /**
    * Details about the Dedicated Host Reservation offering.
    */
  @js.native
  trait HostOffering extends js.Object {
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var Duration: js.UndefOr[Int]
    var HourlyPrice: js.UndefOr[String]
    var InstanceFamily: js.UndefOr[String]
    var OfferingId: js.UndefOr[String]
    var PaymentOption: js.UndefOr[PaymentOption]
    var UpfrontPrice: js.UndefOr[String]
  }

  object HostOffering {
    def apply(
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        Duration: js.UndefOr[Int] = js.undefined,
        HourlyPrice: js.UndefOr[String] = js.undefined,
        InstanceFamily: js.UndefOr[String] = js.undefined,
        OfferingId: js.UndefOr[String] = js.undefined,
        PaymentOption: js.UndefOr[PaymentOption] = js.undefined,
        UpfrontPrice: js.UndefOr[String] = js.undefined
    ): HostOffering = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CurrencyCode" -> CurrencyCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Duration" -> Duration.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HourlyPrice" -> HourlyPrice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceFamily" -> InstanceFamily.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OfferingId" -> OfferingId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PaymentOption" -> PaymentOption.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UpfrontPrice" -> UpfrontPrice.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[HostOffering]
    }
  }

  /**
    * Describes properties of a Dedicated Host.
    */
  @js.native
  trait HostProperties extends js.Object {
    var Cores: js.UndefOr[Int]
    var InstanceType: js.UndefOr[String]
    var Sockets: js.UndefOr[Int]
    var TotalVCpus: js.UndefOr[Int]
  }

  object HostProperties {
    def apply(
        Cores: js.UndefOr[Int] = js.undefined,
        InstanceType: js.UndefOr[String] = js.undefined,
        Sockets: js.UndefOr[Int] = js.undefined,
        TotalVCpus: js.UndefOr[Int] = js.undefined
    ): HostProperties = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Cores" -> Cores.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Sockets" -> Sockets.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TotalVCpus" -> TotalVCpus.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[HostProperties]
    }
  }

  /**
    * Details about the Dedicated Host Reservation and associated Dedicated Hosts.
    */
  @js.native
  trait HostReservation extends js.Object {
    var Count: js.UndefOr[Int]
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var Duration: js.UndefOr[Int]
    var End: js.UndefOr[DateTime]
    var HostIdSet: js.UndefOr[ResponseHostIdSet]
    var HostReservationId: js.UndefOr[String]
    var HourlyPrice: js.UndefOr[String]
    var InstanceFamily: js.UndefOr[String]
    var OfferingId: js.UndefOr[String]
    var PaymentOption: js.UndefOr[PaymentOption]
    var Start: js.UndefOr[DateTime]
    var State: js.UndefOr[ReservationState]
    var Tags: js.UndefOr[TagList]
    var UpfrontPrice: js.UndefOr[String]
  }

  object HostReservation {
    def apply(
        Count: js.UndefOr[Int] = js.undefined,
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        Duration: js.UndefOr[Int] = js.undefined,
        End: js.UndefOr[DateTime] = js.undefined,
        HostIdSet: js.UndefOr[ResponseHostIdSet] = js.undefined,
        HostReservationId: js.UndefOr[String] = js.undefined,
        HourlyPrice: js.UndefOr[String] = js.undefined,
        InstanceFamily: js.UndefOr[String] = js.undefined,
        OfferingId: js.UndefOr[String] = js.undefined,
        PaymentOption: js.UndefOr[PaymentOption] = js.undefined,
        Start: js.UndefOr[DateTime] = js.undefined,
        State: js.UndefOr[ReservationState] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        UpfrontPrice: js.UndefOr[String] = js.undefined
    ): HostReservation = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Count" -> Count.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CurrencyCode" -> CurrencyCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Duration" -> Duration.map { x =>
          x.asInstanceOf[js.Any]
        },
        "End" -> End.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostIdSet" -> HostIdSet.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostReservationId" -> HostReservationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HourlyPrice" -> HourlyPrice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceFamily" -> InstanceFamily.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OfferingId" -> OfferingId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PaymentOption" -> PaymentOption.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Start" -> Start.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UpfrontPrice" -> UpfrontPrice.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[HostReservation]
    }
  }

  object HostTenancyEnum {
    val dedicated = "dedicated"
    val host      = "host"

    val values = IndexedSeq(dedicated, host)
  }

  object HypervisorTypeEnum {
    val ovm = "ovm"
    val xen = "xen"

    val values = IndexedSeq(ovm, xen)
  }

  /**
    * Describes an IAM instance profile.
    */
  @js.native
  trait IamInstanceProfile extends js.Object {
    var Arn: js.UndefOr[String]
    var Id: js.UndefOr[String]
  }

  object IamInstanceProfile {
    def apply(
        Arn: js.UndefOr[String] = js.undefined,
        Id: js.UndefOr[String] = js.undefined
    ): IamInstanceProfile = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Arn" -> Arn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Id" -> Id.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[IamInstanceProfile]
    }
  }

  /**
    * Describes an association between an IAM instance profile and an instance.
    */
  @js.native
  trait IamInstanceProfileAssociation extends js.Object {
    var AssociationId: js.UndefOr[String]
    var IamInstanceProfile: js.UndefOr[IamInstanceProfile]
    var InstanceId: js.UndefOr[String]
    var State: js.UndefOr[IamInstanceProfileAssociationState]
    var Timestamp: js.UndefOr[DateTime]
  }

  object IamInstanceProfileAssociation {
    def apply(
        AssociationId: js.UndefOr[String] = js.undefined,
        IamInstanceProfile: js.UndefOr[IamInstanceProfile] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[IamInstanceProfileAssociationState] = js.undefined,
        Timestamp: js.UndefOr[DateTime] = js.undefined
    ): IamInstanceProfileAssociation = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociationId" -> AssociationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IamInstanceProfile" -> IamInstanceProfile.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Timestamp" -> Timestamp.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[IamInstanceProfileAssociation]
    }
  }

  object IamInstanceProfileAssociationStateEnum {
    val associating    = "associating"
    val associated     = "associated"
    val disassociating = "disassociating"
    val disassociated  = "disassociated"

    val values = IndexedSeq(associating, associated, disassociating, disassociated)
  }

  /**
    * Describes an IAM instance profile.
    */
  @js.native
  trait IamInstanceProfileSpecification extends js.Object {
    var Arn: js.UndefOr[String]
    var Name: js.UndefOr[String]
  }

  object IamInstanceProfileSpecification {
    def apply(
        Arn: js.UndefOr[String] = js.undefined,
        Name: js.UndefOr[String] = js.undefined
    ): IamInstanceProfileSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Arn" -> Arn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[IamInstanceProfileSpecification]
    }
  }

  /**
    * Describes the ICMP type and code.
    */
  @js.native
  trait IcmpTypeCode extends js.Object {
    var Code: js.UndefOr[Int]
    var Type: js.UndefOr[Int]
  }

  object IcmpTypeCode {
    def apply(
        Code: js.UndefOr[Int] = js.undefined,
        Type: js.UndefOr[Int] = js.undefined
    ): IcmpTypeCode = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Type" -> Type.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[IcmpTypeCode]
    }
  }

  /**
    * Describes the ID format for a resource.
    */
  @js.native
  trait IdFormat extends js.Object {
    var Deadline: js.UndefOr[DateTime]
    var Resource: js.UndefOr[String]
    var UseLongIds: js.UndefOr[Boolean]
  }

  object IdFormat {
    def apply(
        Deadline: js.UndefOr[DateTime] = js.undefined,
        Resource: js.UndefOr[String] = js.undefined,
        UseLongIds: js.UndefOr[Boolean] = js.undefined
    ): IdFormat = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Deadline" -> Deadline.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Resource" -> Resource.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UseLongIds" -> UseLongIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[IdFormat]
    }
  }

  /**
    * Describes an image.
    */
  @js.native
  trait Image extends js.Object {
    var Architecture: js.UndefOr[ArchitectureValues]
    var BlockDeviceMappings: js.UndefOr[BlockDeviceMappingList]
    var CreationDate: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var EnaSupport: js.UndefOr[Boolean]
    var Hypervisor: js.UndefOr[HypervisorType]
    var ImageId: js.UndefOr[String]
    var ImageLocation: js.UndefOr[String]
    var ImageOwnerAlias: js.UndefOr[String]
    var ImageType: js.UndefOr[ImageTypeValues]
    var KernelId: js.UndefOr[String]
    var Name: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var Platform: js.UndefOr[PlatformValues]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var Public: js.UndefOr[Boolean]
    var RamdiskId: js.UndefOr[String]
    var RootDeviceName: js.UndefOr[String]
    var RootDeviceType: js.UndefOr[DeviceType]
    var SriovNetSupport: js.UndefOr[String]
    var State: js.UndefOr[ImageState]
    var StateReason: js.UndefOr[StateReason]
    var Tags: js.UndefOr[TagList]
    var VirtualizationType: js.UndefOr[VirtualizationType]
  }

  object Image {
    def apply(
        Architecture: js.UndefOr[ArchitectureValues] = js.undefined,
        BlockDeviceMappings: js.UndefOr[BlockDeviceMappingList] = js.undefined,
        CreationDate: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        EnaSupport: js.UndefOr[Boolean] = js.undefined,
        Hypervisor: js.UndefOr[HypervisorType] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        ImageLocation: js.UndefOr[String] = js.undefined,
        ImageOwnerAlias: js.UndefOr[String] = js.undefined,
        ImageType: js.UndefOr[ImageTypeValues] = js.undefined,
        KernelId: js.UndefOr[String] = js.undefined,
        Name: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        Platform: js.UndefOr[PlatformValues] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        Public: js.UndefOr[Boolean] = js.undefined,
        RamdiskId: js.UndefOr[String] = js.undefined,
        RootDeviceName: js.UndefOr[String] = js.undefined,
        RootDeviceType: js.UndefOr[DeviceType] = js.undefined,
        SriovNetSupport: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[ImageState] = js.undefined,
        StateReason: js.UndefOr[StateReason] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        VirtualizationType: js.UndefOr[VirtualizationType] = js.undefined
    ): Image = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Architecture" -> Architecture.map { x =>
          x.asInstanceOf[js.Any]
        },
        "BlockDeviceMappings" -> BlockDeviceMappings.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CreationDate" -> CreationDate.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EnaSupport" -> EnaSupport.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Hypervisor" -> Hypervisor.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImageId" -> ImageId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImageLocation" -> ImageLocation.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImageOwnerAlias" -> ImageOwnerAlias.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImageType" -> ImageType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KernelId" -> KernelId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OwnerId" -> OwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Platform" -> Platform.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductCodes" -> ProductCodes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Public" -> Public.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RamdiskId" -> RamdiskId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RootDeviceName" -> RootDeviceName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RootDeviceType" -> RootDeviceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SriovNetSupport" -> SriovNetSupport.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StateReason" -> StateReason.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VirtualizationType" -> VirtualizationType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[Image]
    }
  }

  /**
    * Describes an image attribute.
    */
  @js.native
  trait ImageAttribute extends js.Object {
    var BlockDeviceMappings: js.UndefOr[BlockDeviceMappingList]
    var Description: js.UndefOr[AttributeValue]
    var ImageId: js.UndefOr[String]
    var KernelId: js.UndefOr[AttributeValue]
    var LaunchPermissions: js.UndefOr[LaunchPermissionList]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var RamdiskId: js.UndefOr[AttributeValue]
    var SriovNetSupport: js.UndefOr[AttributeValue]
  }

  object ImageAttribute {
    def apply(
        BlockDeviceMappings: js.UndefOr[BlockDeviceMappingList] = js.undefined,
        Description: js.UndefOr[AttributeValue] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        KernelId: js.UndefOr[AttributeValue] = js.undefined,
        LaunchPermissions: js.UndefOr[LaunchPermissionList] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        RamdiskId: js.UndefOr[AttributeValue] = js.undefined,
        SriovNetSupport: js.UndefOr[AttributeValue] = js.undefined
    ): ImageAttribute = {
      val _fields = IndexedSeq[(String, js.Any)](
        "BlockDeviceMappings" -> BlockDeviceMappings.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImageId" -> ImageId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KernelId" -> KernelId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchPermissions" -> LaunchPermissions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductCodes" -> ProductCodes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RamdiskId" -> RamdiskId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SriovNetSupport" -> SriovNetSupport.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImageAttribute]
    }
  }

  object ImageAttributeNameEnum {
    val description        = "description"
    val kernel             = "kernel"
    val ramdisk            = "ramdisk"
    val launchPermission   = "launchPermission"
    val productCodes       = "productCodes"
    val blockDeviceMapping = "blockDeviceMapping"
    val sriovNetSupport    = "sriovNetSupport"

    val values =
      IndexedSeq(description, kernel, ramdisk, launchPermission, productCodes, blockDeviceMapping, sriovNetSupport)
  }

  /**
    * Describes the disk container object for an import image task.
    */
  @js.native
  trait ImageDiskContainer extends js.Object {
    var Description: js.UndefOr[String]
    var DeviceName: js.UndefOr[String]
    var Format: js.UndefOr[String]
    var SnapshotId: js.UndefOr[String]
    var Url: js.UndefOr[String]
    var UserBucket: js.UndefOr[UserBucket]
  }

  object ImageDiskContainer {
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        DeviceName: js.UndefOr[String] = js.undefined,
        Format: js.UndefOr[String] = js.undefined,
        SnapshotId: js.UndefOr[String] = js.undefined,
        Url: js.UndefOr[String] = js.undefined,
        UserBucket: js.UndefOr[UserBucket] = js.undefined
    ): ImageDiskContainer = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeviceName" -> DeviceName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Format" -> Format.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SnapshotId" -> SnapshotId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Url" -> Url.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserBucket" -> UserBucket.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImageDiskContainer]
    }
  }

  object ImageStateEnum {
    val pending      = "pending"
    val available    = "available"
    val invalid      = "invalid"
    val deregistered = "deregistered"
    val transient    = "transient"
    val failed       = "failed"
    val error        = "error"

    val values = IndexedSeq(pending, available, invalid, deregistered, transient, failed, error)
  }

  object ImageTypeValuesEnum {
    val machine = "machine"
    val kernel  = "kernel"
    val ramdisk = "ramdisk"

    val values = IndexedSeq(machine, kernel, ramdisk)
  }

  @js.native
  trait ImportClientVpnClientCertificateRevocationListRequest extends js.Object {
    var CertificateRevocationList: String
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ImportClientVpnClientCertificateRevocationListRequest {
    def apply(
        CertificateRevocationList: String,
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ImportClientVpnClientCertificateRevocationListRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CertificateRevocationList" -> CertificateRevocationList.asInstanceOf[js.Any],
        "ClientVpnEndpointId"       -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ImportClientVpnClientCertificateRevocationListRequest]
    }
  }

  @js.native
  trait ImportClientVpnClientCertificateRevocationListResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ImportClientVpnClientCertificateRevocationListResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ImportClientVpnClientCertificateRevocationListResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ImportClientVpnClientCertificateRevocationListResult]
    }
  }

  /**
    * Contains the parameters for ImportImage.
    */
  @js.native
  trait ImportImageRequest extends js.Object {
    var Architecture: js.UndefOr[String]
    var ClientData: js.UndefOr[ClientData]
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DiskContainers: js.UndefOr[ImageDiskContainerList]
    var DryRun: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var Hypervisor: js.UndefOr[String]
    var KmsKeyId: js.UndefOr[String]
    var LicenseType: js.UndefOr[String]
    var Platform: js.UndefOr[String]
    var RoleName: js.UndefOr[String]
  }

  object ImportImageRequest {
    def apply(
        Architecture: js.UndefOr[String] = js.undefined,
        ClientData: js.UndefOr[ClientData] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DiskContainers: js.UndefOr[ImageDiskContainerList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Hypervisor: js.UndefOr[String] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        LicenseType: js.UndefOr[String] = js.undefined,
        Platform: js.UndefOr[String] = js.undefined,
        RoleName: js.UndefOr[String] = js.undefined
    ): ImportImageRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Architecture" -> Architecture.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ClientData" -> ClientData.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DiskContainers" -> DiskContainers.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Encrypted" -> Encrypted.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Hypervisor" -> Hypervisor.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KmsKeyId" -> KmsKeyId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LicenseType" -> LicenseType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Platform" -> Platform.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RoleName" -> RoleName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportImageRequest]
    }
  }

  /**
    * Contains the output for ImportImage.
    */
  @js.native
  trait ImportImageResult extends js.Object {
    var Architecture: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var Encrypted: js.UndefOr[Boolean]
    var Hypervisor: js.UndefOr[String]
    var ImageId: js.UndefOr[String]
    var ImportTaskId: js.UndefOr[String]
    var KmsKeyId: js.UndefOr[String]
    var LicenseType: js.UndefOr[String]
    var Platform: js.UndefOr[String]
    var Progress: js.UndefOr[String]
    var SnapshotDetails: js.UndefOr[SnapshotDetailList]
    var Status: js.UndefOr[String]
    var StatusMessage: js.UndefOr[String]
  }

  object ImportImageResult {
    def apply(
        Architecture: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Hypervisor: js.UndefOr[String] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        ImportTaskId: js.UndefOr[String] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        LicenseType: js.UndefOr[String] = js.undefined,
        Platform: js.UndefOr[String] = js.undefined,
        Progress: js.UndefOr[String] = js.undefined,
        SnapshotDetails: js.UndefOr[SnapshotDetailList] = js.undefined,
        Status: js.UndefOr[String] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined
    ): ImportImageResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Architecture" -> Architecture.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Encrypted" -> Encrypted.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Hypervisor" -> Hypervisor.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImageId" -> ImageId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImportTaskId" -> ImportTaskId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KmsKeyId" -> KmsKeyId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LicenseType" -> LicenseType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Platform" -> Platform.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Progress" -> Progress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SnapshotDetails" -> SnapshotDetails.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StatusMessage" -> StatusMessage.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportImageResult]
    }
  }

  /**
    * Describes an import image task.
    */
  @js.native
  trait ImportImageTask extends js.Object {
    var Architecture: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var Encrypted: js.UndefOr[Boolean]
    var Hypervisor: js.UndefOr[String]
    var ImageId: js.UndefOr[String]
    var ImportTaskId: js.UndefOr[String]
    var KmsKeyId: js.UndefOr[String]
    var LicenseType: js.UndefOr[String]
    var Platform: js.UndefOr[String]
    var Progress: js.UndefOr[String]
    var SnapshotDetails: js.UndefOr[SnapshotDetailList]
    var Status: js.UndefOr[String]
    var StatusMessage: js.UndefOr[String]
  }

  object ImportImageTask {
    def apply(
        Architecture: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Hypervisor: js.UndefOr[String] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        ImportTaskId: js.UndefOr[String] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        LicenseType: js.UndefOr[String] = js.undefined,
        Platform: js.UndefOr[String] = js.undefined,
        Progress: js.UndefOr[String] = js.undefined,
        SnapshotDetails: js.UndefOr[SnapshotDetailList] = js.undefined,
        Status: js.UndefOr[String] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined
    ): ImportImageTask = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Architecture" -> Architecture.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Encrypted" -> Encrypted.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Hypervisor" -> Hypervisor.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImageId" -> ImageId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImportTaskId" -> ImportTaskId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KmsKeyId" -> KmsKeyId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LicenseType" -> LicenseType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Platform" -> Platform.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Progress" -> Progress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SnapshotDetails" -> SnapshotDetails.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StatusMessage" -> StatusMessage.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportImageTask]
    }
  }

  /**
    * Describes the launch specification for VM import.
    */
  @js.native
  trait ImportInstanceLaunchSpecification extends js.Object {
    var AdditionalInfo: js.UndefOr[String]
    var Architecture: js.UndefOr[ArchitectureValues]
    var GroupIds: js.UndefOr[SecurityGroupIdStringList]
    var GroupNames: js.UndefOr[SecurityGroupStringList]
    var InstanceInitiatedShutdownBehavior: js.UndefOr[ShutdownBehavior]
    var InstanceType: js.UndefOr[InstanceType]
    var Monitoring: js.UndefOr[Boolean]
    var Placement: js.UndefOr[Placement]
    var PrivateIpAddress: js.UndefOr[String]
    var SubnetId: js.UndefOr[String]
    var UserData: js.UndefOr[UserData]
  }

  object ImportInstanceLaunchSpecification {
    def apply(
        AdditionalInfo: js.UndefOr[String] = js.undefined,
        Architecture: js.UndefOr[ArchitectureValues] = js.undefined,
        GroupIds: js.UndefOr[SecurityGroupIdStringList] = js.undefined,
        GroupNames: js.UndefOr[SecurityGroupStringList] = js.undefined,
        InstanceInitiatedShutdownBehavior: js.UndefOr[ShutdownBehavior] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        Monitoring: js.UndefOr[Boolean] = js.undefined,
        Placement: js.UndefOr[Placement] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        UserData: js.UndefOr[UserData] = js.undefined
    ): ImportInstanceLaunchSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AdditionalInfo" -> AdditionalInfo.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Architecture" -> Architecture.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupIds" -> GroupIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupNames" -> GroupNames.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceInitiatedShutdownBehavior" -> InstanceInitiatedShutdownBehavior.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Monitoring" -> Monitoring.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Placement" -> Placement.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserData" -> UserData.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportInstanceLaunchSpecification]
    }
  }

  /**
    * Contains the parameters for ImportInstance.
    */
  @js.native
  trait ImportInstanceRequest extends js.Object {
    var Platform: PlatformValues
    var Description: js.UndefOr[String]
    var DiskImages: js.UndefOr[DiskImageList]
    var DryRun: js.UndefOr[Boolean]
    var LaunchSpecification: js.UndefOr[ImportInstanceLaunchSpecification]
  }

  object ImportInstanceRequest {
    def apply(
        Platform: PlatformValues,
        Description: js.UndefOr[String] = js.undefined,
        DiskImages: js.UndefOr[DiskImageList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LaunchSpecification: js.UndefOr[ImportInstanceLaunchSpecification] = js.undefined
    ): ImportInstanceRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Platform" -> Platform.asInstanceOf[js.Any],
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DiskImages" -> DiskImages.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchSpecification" -> LaunchSpecification.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportInstanceRequest]
    }
  }

  /**
    * Contains the output for ImportInstance.
    */
  @js.native
  trait ImportInstanceResult extends js.Object {
    var ConversionTask: js.UndefOr[ConversionTask]
  }

  object ImportInstanceResult {
    def apply(
        ConversionTask: js.UndefOr[ConversionTask] = js.undefined
    ): ImportInstanceResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ConversionTask" -> ConversionTask.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportInstanceResult]
    }
  }

  /**
    * Describes an import instance task.
    */
  @js.native
  trait ImportInstanceTaskDetails extends js.Object {
    var Description: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
    var Platform: js.UndefOr[PlatformValues]
    var Volumes: js.UndefOr[ImportInstanceVolumeDetailSet]
  }

  object ImportInstanceTaskDetails {
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        Platform: js.UndefOr[PlatformValues] = js.undefined,
        Volumes: js.UndefOr[ImportInstanceVolumeDetailSet] = js.undefined
    ): ImportInstanceTaskDetails = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Platform" -> Platform.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Volumes" -> Volumes.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportInstanceTaskDetails]
    }
  }

  /**
    * Describes an import volume task.
    */
  @js.native
  trait ImportInstanceVolumeDetailItem extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var BytesConverted: js.UndefOr[Double]
    var Description: js.UndefOr[String]
    var Image: js.UndefOr[DiskImageDescription]
    var Status: js.UndefOr[String]
    var StatusMessage: js.UndefOr[String]
    var Volume: js.UndefOr[DiskImageVolumeDescription]
  }

  object ImportInstanceVolumeDetailItem {
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        BytesConverted: js.UndefOr[Double] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        Image: js.UndefOr[DiskImageDescription] = js.undefined,
        Status: js.UndefOr[String] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined,
        Volume: js.UndefOr[DiskImageVolumeDescription] = js.undefined
    ): ImportInstanceVolumeDetailItem = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "BytesConverted" -> BytesConverted.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Image" -> Image.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StatusMessage" -> StatusMessage.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Volume" -> Volume.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportInstanceVolumeDetailItem]
    }
  }

  @js.native
  trait ImportKeyPairRequest extends js.Object {
    var KeyName: String
    var PublicKeyMaterial: Blob
    var DryRun: js.UndefOr[Boolean]
  }

  object ImportKeyPairRequest {
    def apply(
        KeyName: String,
        PublicKeyMaterial: Blob,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ImportKeyPairRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "KeyName"           -> KeyName.asInstanceOf[js.Any],
        "PublicKeyMaterial" -> PublicKeyMaterial.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportKeyPairRequest]
    }
  }

  @js.native
  trait ImportKeyPairResult extends js.Object {
    var KeyFingerprint: js.UndefOr[String]
    var KeyName: js.UndefOr[String]
  }

  object ImportKeyPairResult {
    def apply(
        KeyFingerprint: js.UndefOr[String] = js.undefined,
        KeyName: js.UndefOr[String] = js.undefined
    ): ImportKeyPairResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "KeyFingerprint" -> KeyFingerprint.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KeyName" -> KeyName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportKeyPairResult]
    }
  }

  /**
    * Contains the parameters for ImportSnapshot.
    */
  @js.native
  trait ImportSnapshotRequest extends js.Object {
    var ClientData: js.UndefOr[ClientData]
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DiskContainer: js.UndefOr[SnapshotDiskContainer]
    var DryRun: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var KmsKeyId: js.UndefOr[String]
    var RoleName: js.UndefOr[String]
  }

  object ImportSnapshotRequest {
    def apply(
        ClientData: js.UndefOr[ClientData] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DiskContainer: js.UndefOr[SnapshotDiskContainer] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        RoleName: js.UndefOr[String] = js.undefined
    ): ImportSnapshotRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientData" -> ClientData.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DiskContainer" -> DiskContainer.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Encrypted" -> Encrypted.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KmsKeyId" -> KmsKeyId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RoleName" -> RoleName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportSnapshotRequest]
    }
  }

  /**
    * Contains the output for ImportSnapshot.
    */
  @js.native
  trait ImportSnapshotResult extends js.Object {
    var Description: js.UndefOr[String]
    var ImportTaskId: js.UndefOr[String]
    var SnapshotTaskDetail: js.UndefOr[SnapshotTaskDetail]
  }

  object ImportSnapshotResult {
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        ImportTaskId: js.UndefOr[String] = js.undefined,
        SnapshotTaskDetail: js.UndefOr[SnapshotTaskDetail] = js.undefined
    ): ImportSnapshotResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImportTaskId" -> ImportTaskId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SnapshotTaskDetail" -> SnapshotTaskDetail.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportSnapshotResult]
    }
  }

  /**
    * Describes an import snapshot task.
    */
  @js.native
  trait ImportSnapshotTask extends js.Object {
    var Description: js.UndefOr[String]
    var ImportTaskId: js.UndefOr[String]
    var SnapshotTaskDetail: js.UndefOr[SnapshotTaskDetail]
  }

  object ImportSnapshotTask {
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        ImportTaskId: js.UndefOr[String] = js.undefined,
        SnapshotTaskDetail: js.UndefOr[SnapshotTaskDetail] = js.undefined
    ): ImportSnapshotTask = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImportTaskId" -> ImportTaskId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SnapshotTaskDetail" -> SnapshotTaskDetail.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportSnapshotTask]
    }
  }

  /**
    * Contains the parameters for ImportVolume.
    */
  @js.native
  trait ImportVolumeRequest extends js.Object {
    var AvailabilityZone: String
    var Image: DiskImageDetail
    var Volume: VolumeDetail
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object ImportVolumeRequest {
    def apply(
        AvailabilityZone: String,
        Image: DiskImageDetail,
        Volume: VolumeDetail,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ImportVolumeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.asInstanceOf[js.Any],
        "Image"            -> Image.asInstanceOf[js.Any],
        "Volume"           -> Volume.asInstanceOf[js.Any],
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportVolumeRequest]
    }
  }

  /**
    * Contains the output for ImportVolume.
    */
  @js.native
  trait ImportVolumeResult extends js.Object {
    var ConversionTask: js.UndefOr[ConversionTask]
  }

  object ImportVolumeResult {
    def apply(
        ConversionTask: js.UndefOr[ConversionTask] = js.undefined
    ): ImportVolumeResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ConversionTask" -> ConversionTask.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportVolumeResult]
    }
  }

  /**
    * Describes an import volume task.
    */
  @js.native
  trait ImportVolumeTaskDetails extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var BytesConverted: js.UndefOr[Double]
    var Description: js.UndefOr[String]
    var Image: js.UndefOr[DiskImageDescription]
    var Volume: js.UndefOr[DiskImageVolumeDescription]
  }

  object ImportVolumeTaskDetails {
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        BytesConverted: js.UndefOr[Double] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        Image: js.UndefOr[DiskImageDescription] = js.undefined,
        Volume: js.UndefOr[DiskImageVolumeDescription] = js.undefined
    ): ImportVolumeTaskDetails = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "BytesConverted" -> BytesConverted.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Image" -> Image.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Volume" -> Volume.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ImportVolumeTaskDetails]
    }
  }

  /**
    * Describes an instance.
    */
  @js.native
  trait Instance extends js.Object {
    var AmiLaunchIndex: js.UndefOr[Int]
    var Architecture: js.UndefOr[ArchitectureValues]
    var BlockDeviceMappings: js.UndefOr[InstanceBlockDeviceMappingList]
    var CapacityReservationId: js.UndefOr[String]
    var CapacityReservationSpecification: js.UndefOr[CapacityReservationSpecificationResponse]
    var ClientToken: js.UndefOr[String]
    var CpuOptions: js.UndefOr[CpuOptions]
    var EbsOptimized: js.UndefOr[Boolean]
    var ElasticGpuAssociations: js.UndefOr[ElasticGpuAssociationList]
    var ElasticInferenceAcceleratorAssociations: js.UndefOr[ElasticInferenceAcceleratorAssociationList]
    var EnaSupport: js.UndefOr[Boolean]
    var HibernationOptions: js.UndefOr[HibernationOptions]
    var Hypervisor: js.UndefOr[HypervisorType]
    var IamInstanceProfile: js.UndefOr[IamInstanceProfile]
    var ImageId: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
    var InstanceLifecycle: js.UndefOr[InstanceLifecycleType]
    var InstanceType: js.UndefOr[InstanceType]
    var KernelId: js.UndefOr[String]
    var KeyName: js.UndefOr[String]
    var LaunchTime: js.UndefOr[DateTime]
    var Licenses: js.UndefOr[LicenseList]
    var Monitoring: js.UndefOr[Monitoring]
    var NetworkInterfaces: js.UndefOr[InstanceNetworkInterfaceList]
    var Placement: js.UndefOr[Placement]
    var Platform: js.UndefOr[PlatformValues]
    var PrivateDnsName: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var PublicDnsName: js.UndefOr[String]
    var PublicIpAddress: js.UndefOr[String]
    var RamdiskId: js.UndefOr[String]
    var RootDeviceName: js.UndefOr[String]
    var RootDeviceType: js.UndefOr[DeviceType]
    var SecurityGroups: js.UndefOr[GroupIdentifierList]
    var SourceDestCheck: js.UndefOr[Boolean]
    var SpotInstanceRequestId: js.UndefOr[String]
    var SriovNetSupport: js.UndefOr[String]
    var State: js.UndefOr[InstanceState]
    var StateReason: js.UndefOr[StateReason]
    var StateTransitionReason: js.UndefOr[String]
    var SubnetId: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
    var VirtualizationType: js.UndefOr[VirtualizationType]
    var VpcId: js.UndefOr[String]
  }

  object Instance {
    def apply(
        AmiLaunchIndex: js.UndefOr[Int] = js.undefined,
        Architecture: js.UndefOr[ArchitectureValues] = js.undefined,
        BlockDeviceMappings: js.UndefOr[InstanceBlockDeviceMappingList] = js.undefined,
        CapacityReservationId: js.UndefOr[String] = js.undefined,
        CapacityReservationSpecification: js.UndefOr[CapacityReservationSpecificationResponse] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        CpuOptions: js.UndefOr[CpuOptions] = js.undefined,
        EbsOptimized: js.UndefOr[Boolean] = js.undefined,
        ElasticGpuAssociations: js.UndefOr[ElasticGpuAssociationList] = js.undefined,
        ElasticInferenceAcceleratorAssociations: js.UndefOr[ElasticInferenceAcceleratorAssociationList] = js.undefined,
        EnaSupport: js.UndefOr[Boolean] = js.undefined,
        HibernationOptions: js.UndefOr[HibernationOptions] = js.undefined,
        Hypervisor: js.UndefOr[HypervisorType] = js.undefined,
        IamInstanceProfile: js.UndefOr[IamInstanceProfile] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        InstanceLifecycle: js.UndefOr[InstanceLifecycleType] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        KernelId: js.UndefOr[String] = js.undefined,
        KeyName: js.UndefOr[String] = js.undefined,
        LaunchTime: js.UndefOr[DateTime] = js.undefined,
        Licenses: js.UndefOr[LicenseList] = js.undefined,
        Monitoring: js.UndefOr[Monitoring] = js.undefined,
        NetworkInterfaces: js.UndefOr[InstanceNetworkInterfaceList] = js.undefined,
        Placement: js.UndefOr[Placement] = js.undefined,
        Platform: js.UndefOr[PlatformValues] = js.undefined,
        PrivateDnsName: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        PublicDnsName: js.UndefOr[String] = js.undefined,
        PublicIpAddress: js.UndefOr[String] = js.undefined,
        RamdiskId: js.UndefOr[String] = js.undefined,
        RootDeviceName: js.UndefOr[String] = js.undefined,
        RootDeviceType: js.UndefOr[DeviceType] = js.undefined,
        SecurityGroups: js.UndefOr[GroupIdentifierList] = js.undefined,
        SourceDestCheck: js.UndefOr[Boolean] = js.undefined,
        SpotInstanceRequestId: js.UndefOr[String] = js.undefined,
        SriovNetSupport: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[InstanceState] = js.undefined,
        StateReason: js.UndefOr[StateReason] = js.undefined,
        StateTransitionReason: js.UndefOr[String] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        VirtualizationType: js.UndefOr[VirtualizationType] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): Instance = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AmiLaunchIndex" -> AmiLaunchIndex.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Architecture" -> Architecture.map { x =>
          x.asInstanceOf[js.Any]
        },
        "BlockDeviceMappings" -> BlockDeviceMappings.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CapacityReservationId" -> CapacityReservationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CapacityReservationSpecification" -> CapacityReservationSpecification.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CpuOptions" -> CpuOptions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EbsOptimized" -> EbsOptimized.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticGpuAssociations" -> ElasticGpuAssociations.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ElasticInferenceAcceleratorAssociations" -> ElasticInferenceAcceleratorAssociations.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EnaSupport" -> EnaSupport.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HibernationOptions" -> HibernationOptions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Hypervisor" -> Hypervisor.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IamInstanceProfile" -> IamInstanceProfile.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImageId" -> ImageId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceLifecycle" -> InstanceLifecycle.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KernelId" -> KernelId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KeyName" -> KeyName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTime" -> LaunchTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Licenses" -> Licenses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Monitoring" -> Monitoring.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaces" -> NetworkInterfaces.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Placement" -> Placement.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Platform" -> Platform.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateDnsName" -> PrivateDnsName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductCodes" -> ProductCodes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicDnsName" -> PublicDnsName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIpAddress" -> PublicIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RamdiskId" -> RamdiskId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RootDeviceName" -> RootDeviceName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RootDeviceType" -> RootDeviceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SecurityGroups" -> SecurityGroups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SourceDestCheck" -> SourceDestCheck.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotInstanceRequestId" -> SpotInstanceRequestId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SriovNetSupport" -> SriovNetSupport.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StateReason" -> StateReason.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StateTransitionReason" -> StateTransitionReason.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VirtualizationType" -> VirtualizationType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[Instance]
    }
  }

  /**
    * Describes an instance attribute.
    */
  @js.native
  trait InstanceAttribute extends js.Object {
    var BlockDeviceMappings: js.UndefOr[InstanceBlockDeviceMappingList]
    var DisableApiTermination: js.UndefOr[AttributeBooleanValue]
    var EbsOptimized: js.UndefOr[AttributeBooleanValue]
    var EnaSupport: js.UndefOr[AttributeBooleanValue]
    var Groups: js.UndefOr[GroupIdentifierList]
    var InstanceId: js.UndefOr[String]
    var InstanceInitiatedShutdownBehavior: js.UndefOr[AttributeValue]
    var InstanceType: js.UndefOr[AttributeValue]
    var KernelId: js.UndefOr[AttributeValue]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var RamdiskId: js.UndefOr[AttributeValue]
    var RootDeviceName: js.UndefOr[AttributeValue]
    var SourceDestCheck: js.UndefOr[AttributeBooleanValue]
    var SriovNetSupport: js.UndefOr[AttributeValue]
    var UserData: js.UndefOr[AttributeValue]
  }

  object InstanceAttribute {
    def apply(
        BlockDeviceMappings: js.UndefOr[InstanceBlockDeviceMappingList] = js.undefined,
        DisableApiTermination: js.UndefOr[AttributeBooleanValue] = js.undefined,
        EbsOptimized: js.UndefOr[AttributeBooleanValue] = js.undefined,
        EnaSupport: js.UndefOr[AttributeBooleanValue] = js.undefined,
        Groups: js.UndefOr[GroupIdentifierList] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        InstanceInitiatedShutdownBehavior: js.UndefOr[AttributeValue] = js.undefined,
        InstanceType: js.UndefOr[AttributeValue] = js.undefined,
        KernelId: js.UndefOr[AttributeValue] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        RamdiskId: js.UndefOr[AttributeValue] = js.undefined,
        RootDeviceName: js.UndefOr[AttributeValue] = js.undefined,
        SourceDestCheck: js.UndefOr[AttributeBooleanValue] = js.undefined,
        SriovNetSupport: js.UndefOr[AttributeValue] = js.undefined,
        UserData: js.UndefOr[AttributeValue] = js.undefined
    ): InstanceAttribute = {
      val _fields = IndexedSeq[(String, js.Any)](
        "BlockDeviceMappings" -> BlockDeviceMappings.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DisableApiTermination" -> DisableApiTermination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EbsOptimized" -> EbsOptimized.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EnaSupport" -> EnaSupport.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Groups" -> Groups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceInitiatedShutdownBehavior" -> InstanceInitiatedShutdownBehavior.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KernelId" -> KernelId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductCodes" -> ProductCodes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RamdiskId" -> RamdiskId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RootDeviceName" -> RootDeviceName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SourceDestCheck" -> SourceDestCheck.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SriovNetSupport" -> SriovNetSupport.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserData" -> UserData.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceAttribute]
    }
  }

  object InstanceAttributeNameEnum {
    val instanceType                      = "instanceType"
    val kernel                            = "kernel"
    val ramdisk                           = "ramdisk"
    val userData                          = "userData"
    val disableApiTermination             = "disableApiTermination"
    val instanceInitiatedShutdownBehavior = "instanceInitiatedShutdownBehavior"
    val rootDeviceName                    = "rootDeviceName"
    val blockDeviceMapping                = "blockDeviceMapping"
    val productCodes                      = "productCodes"
    val sourceDestCheck                   = "sourceDestCheck"
    val groupSet                          = "groupSet"
    val ebsOptimized                      = "ebsOptimized"
    val sriovNetSupport                   = "sriovNetSupport"
    val enaSupport                        = "enaSupport"

    val values = IndexedSeq(
      instanceType,
      kernel,
      ramdisk,
      userData,
      disableApiTermination,
      instanceInitiatedShutdownBehavior,
      rootDeviceName,
      blockDeviceMapping,
      productCodes,
      sourceDestCheck,
      groupSet,
      ebsOptimized,
      sriovNetSupport,
      enaSupport
    )
  }

  /**
    * Describes a block device mapping.
    */
  @js.native
  trait InstanceBlockDeviceMapping extends js.Object {
    var DeviceName: js.UndefOr[String]
    var Ebs: js.UndefOr[EbsInstanceBlockDevice]
  }

  object InstanceBlockDeviceMapping {
    def apply(
        DeviceName: js.UndefOr[String] = js.undefined,
        Ebs: js.UndefOr[EbsInstanceBlockDevice] = js.undefined
    ): InstanceBlockDeviceMapping = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DeviceName" -> DeviceName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ebs" -> Ebs.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceBlockDeviceMapping]
    }
  }

  /**
    * Describes a block device mapping entry.
    */
  @js.native
  trait InstanceBlockDeviceMappingSpecification extends js.Object {
    var DeviceName: js.UndefOr[String]
    var Ebs: js.UndefOr[EbsInstanceBlockDeviceSpecification]
    var NoDevice: js.UndefOr[String]
    var VirtualName: js.UndefOr[String]
  }

  object InstanceBlockDeviceMappingSpecification {
    def apply(
        DeviceName: js.UndefOr[String] = js.undefined,
        Ebs: js.UndefOr[EbsInstanceBlockDeviceSpecification] = js.undefined,
        NoDevice: js.UndefOr[String] = js.undefined,
        VirtualName: js.UndefOr[String] = js.undefined
    ): InstanceBlockDeviceMappingSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DeviceName" -> DeviceName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ebs" -> Ebs.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NoDevice" -> NoDevice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VirtualName" -> VirtualName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceBlockDeviceMappingSpecification]
    }
  }

  /**
    * Information about the instance type that the Dedicated Host supports.
    */
  @js.native
  trait InstanceCapacity extends js.Object {
    var AvailableCapacity: js.UndefOr[Int]
    var InstanceType: js.UndefOr[String]
    var TotalCapacity: js.UndefOr[Int]
  }

  object InstanceCapacity {
    def apply(
        AvailableCapacity: js.UndefOr[Int] = js.undefined,
        InstanceType: js.UndefOr[String] = js.undefined,
        TotalCapacity: js.UndefOr[Int] = js.undefined
    ): InstanceCapacity = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailableCapacity" -> AvailableCapacity.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TotalCapacity" -> TotalCapacity.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceCapacity]
    }
  }

  /**
    * Describes a Reserved Instance listing state.
    */
  @js.native
  trait InstanceCount extends js.Object {
    var InstanceCount: js.UndefOr[Int]
    var State: js.UndefOr[ListingState]
  }

  object InstanceCount {
    def apply(
        InstanceCount: js.UndefOr[Int] = js.undefined,
        State: js.UndefOr[ListingState] = js.undefined
    ): InstanceCount = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceCount" -> InstanceCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceCount]
    }
  }

  /**
    * Describes the credit option for CPU usage of a T2 or T3 instance.
    */
  @js.native
  trait InstanceCreditSpecification extends js.Object {
    var CpuCredits: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
  }

  object InstanceCreditSpecification {
    def apply(
        CpuCredits: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): InstanceCreditSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CpuCredits" -> CpuCredits.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceCreditSpecification]
    }
  }

  /**
    * Describes the credit option for CPU usage of a T2 or T3 instance.
    */
  @js.native
  trait InstanceCreditSpecificationRequest extends js.Object {
    var CpuCredits: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
  }

  object InstanceCreditSpecificationRequest {
    def apply(
        CpuCredits: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): InstanceCreditSpecificationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CpuCredits" -> CpuCredits.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceCreditSpecificationRequest]
    }
  }

  /**
    * Describes an instance to export.
    */
  @js.native
  trait InstanceExportDetails extends js.Object {
    var InstanceId: js.UndefOr[String]
    var TargetEnvironment: js.UndefOr[ExportEnvironment]
  }

  object InstanceExportDetails {
    def apply(
        InstanceId: js.UndefOr[String] = js.undefined,
        TargetEnvironment: js.UndefOr[ExportEnvironment] = js.undefined
    ): InstanceExportDetails = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TargetEnvironment" -> TargetEnvironment.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceExportDetails]
    }
  }

  object InstanceHealthStatusEnum {
    val healthy   = "healthy"
    val unhealthy = "unhealthy"

    val values = IndexedSeq(healthy, unhealthy)
  }

  object InstanceInterruptionBehaviorEnum {
    val hibernate = "hibernate"
    val stop      = "stop"
    val terminate = "terminate"

    val values = IndexedSeq(hibernate, stop, terminate)
  }

  /**
    * Describes an IPv6 address.
    */
  @js.native
  trait InstanceIpv6Address extends js.Object {
    var Ipv6Address: js.UndefOr[String]
  }

  object InstanceIpv6Address {
    def apply(
        Ipv6Address: js.UndefOr[String] = js.undefined
    ): InstanceIpv6Address = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Ipv6Address" -> Ipv6Address.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceIpv6Address]
    }
  }

  /**
    * Describes an IPv6 address.
    */
  @js.native
  trait InstanceIpv6AddressRequest extends js.Object {
    var Ipv6Address: js.UndefOr[String]
  }

  object InstanceIpv6AddressRequest {
    def apply(
        Ipv6Address: js.UndefOr[String] = js.undefined
    ): InstanceIpv6AddressRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Ipv6Address" -> Ipv6Address.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceIpv6AddressRequest]
    }
  }

  object InstanceLifecycleEnum {
    val spot        = "spot"
    val `on-demand` = "on-demand"

    val values = IndexedSeq(spot, `on-demand`)
  }

  object InstanceLifecycleTypeEnum {
    val spot      = "spot"
    val scheduled = "scheduled"

    val values = IndexedSeq(spot, scheduled)
  }

  /**
    * Describes the market (purchasing) option for the instances.
    */
  @js.native
  trait InstanceMarketOptionsRequest extends js.Object {
    var MarketType: js.UndefOr[MarketType]
    var SpotOptions: js.UndefOr[SpotMarketOptions]
  }

  object InstanceMarketOptionsRequest {
    def apply(
        MarketType: js.UndefOr[MarketType] = js.undefined,
        SpotOptions: js.UndefOr[SpotMarketOptions] = js.undefined
    ): InstanceMarketOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "MarketType" -> MarketType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotOptions" -> SpotOptions.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceMarketOptionsRequest]
    }
  }

  object InstanceMatchCriteriaEnum {
    val open     = "open"
    val targeted = "targeted"

    val values = IndexedSeq(open, targeted)
  }

  /**
    * Describes the monitoring of an instance.
    */
  @js.native
  trait InstanceMonitoring extends js.Object {
    var InstanceId: js.UndefOr[String]
    var Monitoring: js.UndefOr[Monitoring]
  }

  object InstanceMonitoring {
    def apply(
        InstanceId: js.UndefOr[String] = js.undefined,
        Monitoring: js.UndefOr[Monitoring] = js.undefined
    ): InstanceMonitoring = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Monitoring" -> Monitoring.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceMonitoring]
    }
  }

  /**
    * Describes a network interface.
    */
  @js.native
  trait InstanceNetworkInterface extends js.Object {
    var Association: js.UndefOr[InstanceNetworkInterfaceAssociation]
    var Attachment: js.UndefOr[InstanceNetworkInterfaceAttachment]
    var Description: js.UndefOr[String]
    var Groups: js.UndefOr[GroupIdentifierList]
    var Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList]
    var MacAddress: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var PrivateDnsName: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PrivateIpAddresses: js.UndefOr[InstancePrivateIpAddressList]
    var SourceDestCheck: js.UndefOr[Boolean]
    var Status: js.UndefOr[NetworkInterfaceStatus]
    var SubnetId: js.UndefOr[String]
    var VpcId: js.UndefOr[String]
  }

  object InstanceNetworkInterface {
    def apply(
        Association: js.UndefOr[InstanceNetworkInterfaceAssociation] = js.undefined,
        Attachment: js.UndefOr[InstanceNetworkInterfaceAttachment] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        Groups: js.UndefOr[GroupIdentifierList] = js.undefined,
        Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList] = js.undefined,
        MacAddress: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        PrivateDnsName: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PrivateIpAddresses: js.UndefOr[InstancePrivateIpAddressList] = js.undefined,
        SourceDestCheck: js.UndefOr[Boolean] = js.undefined,
        Status: js.UndefOr[NetworkInterfaceStatus] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): InstanceNetworkInterface = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Association" -> Association.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Attachment" -> Attachment.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Groups" -> Groups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6Addresses" -> Ipv6Addresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MacAddress" -> MacAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceId" -> NetworkInterfaceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OwnerId" -> OwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateDnsName" -> PrivateDnsName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddresses" -> PrivateIpAddresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SourceDestCheck" -> SourceDestCheck.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceNetworkInterface]
    }
  }

  /**
    * Describes association information for an Elastic IP address (IPv4).
    */
  @js.native
  trait InstanceNetworkInterfaceAssociation extends js.Object {
    var IpOwnerId: js.UndefOr[String]
    var PublicDnsName: js.UndefOr[String]
    var PublicIp: js.UndefOr[String]
  }

  object InstanceNetworkInterfaceAssociation {
    def apply(
        IpOwnerId: js.UndefOr[String] = js.undefined,
        PublicDnsName: js.UndefOr[String] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): InstanceNetworkInterfaceAssociation = {
      val _fields = IndexedSeq[(String, js.Any)](
        "IpOwnerId" -> IpOwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicDnsName" -> PublicDnsName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIp" -> PublicIp.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceNetworkInterfaceAssociation]
    }
  }

  /**
    * Describes a network interface attachment.
    */
  @js.native
  trait InstanceNetworkInterfaceAttachment extends js.Object {
    var AttachTime: js.UndefOr[DateTime]
    var AttachmentId: js.UndefOr[String]
    var DeleteOnTermination: js.UndefOr[Boolean]
    var DeviceIndex: js.UndefOr[Int]
    var Status: js.UndefOr[AttachmentStatus]
  }

  object InstanceNetworkInterfaceAttachment {
    def apply(
        AttachTime: js.UndefOr[DateTime] = js.undefined,
        AttachmentId: js.UndefOr[String] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        DeviceIndex: js.UndefOr[Int] = js.undefined,
        Status: js.UndefOr[AttachmentStatus] = js.undefined
    ): InstanceNetworkInterfaceAttachment = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AttachTime" -> AttachTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AttachmentId" -> AttachmentId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeleteOnTermination" -> DeleteOnTermination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeviceIndex" -> DeviceIndex.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceNetworkInterfaceAttachment]
    }
  }

  /**
    * Describes a network interface.
    */
  @js.native
  trait InstanceNetworkInterfaceSpecification extends js.Object {
    var AssociatePublicIpAddress: js.UndefOr[Boolean]
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Description: js.UndefOr[String]
    var DeviceIndex: js.UndefOr[Int]
    var Groups: js.UndefOr[SecurityGroupIdStringList]
    var Ipv6AddressCount: js.UndefOr[Int]
    var Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList]
    var NetworkInterfaceId: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList]
    var SecondaryPrivateIpAddressCount: js.UndefOr[Int]
    var SubnetId: js.UndefOr[String]
  }

  object InstanceNetworkInterfaceSpecification {
    def apply(
        AssociatePublicIpAddress: js.UndefOr[Boolean] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DeviceIndex: js.UndefOr[Int] = js.undefined,
        Groups: js.UndefOr[SecurityGroupIdStringList] = js.undefined,
        Ipv6AddressCount: js.UndefOr[Int] = js.undefined,
        Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList] = js.undefined,
        SecondaryPrivateIpAddressCount: js.UndefOr[Int] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined
    ): InstanceNetworkInterfaceSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociatePublicIpAddress" -> AssociatePublicIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeleteOnTermination" -> DeleteOnTermination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeviceIndex" -> DeviceIndex.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Groups" -> Groups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6AddressCount" -> Ipv6AddressCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6Addresses" -> Ipv6Addresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceId" -> NetworkInterfaceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddresses" -> PrivateIpAddresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SecondaryPrivateIpAddressCount" -> SecondaryPrivateIpAddressCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceNetworkInterfaceSpecification]
    }
  }

  /**
    * Describes a private IPv4 address.
    */
  @js.native
  trait InstancePrivateIpAddress extends js.Object {
    var Association: js.UndefOr[InstanceNetworkInterfaceAssociation]
    var Primary: js.UndefOr[Boolean]
    var PrivateDnsName: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
  }

  object InstancePrivateIpAddress {
    def apply(
        Association: js.UndefOr[InstanceNetworkInterfaceAssociation] = js.undefined,
        Primary: js.UndefOr[Boolean] = js.undefined,
        PrivateDnsName: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined
    ): InstancePrivateIpAddress = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Association" -> Association.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Primary" -> Primary.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateDnsName" -> PrivateDnsName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstancePrivateIpAddress]
    }
  }

  /**
    * Describes the current state of an instance.
    */
  @js.native
  trait InstanceState extends js.Object {
    var Code: js.UndefOr[Int]
    var Name: js.UndefOr[InstanceStateName]
  }

  object InstanceState {
    def apply(
        Code: js.UndefOr[Int] = js.undefined,
        Name: js.UndefOr[InstanceStateName] = js.undefined
    ): InstanceState = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceState]
    }
  }

  /**
    * Describes an instance state change.
    */
  @js.native
  trait InstanceStateChange extends js.Object {
    var CurrentState: js.UndefOr[InstanceState]
    var InstanceId: js.UndefOr[String]
    var PreviousState: js.UndefOr[InstanceState]
  }

  object InstanceStateChange {
    def apply(
        CurrentState: js.UndefOr[InstanceState] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        PreviousState: js.UndefOr[InstanceState] = js.undefined
    ): InstanceStateChange = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CurrentState" -> CurrentState.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PreviousState" -> PreviousState.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceStateChange]
    }
  }

  object InstanceStateNameEnum {
    val pending         = "pending"
    val running         = "running"
    val `shutting-down` = "shutting-down"
    val terminated      = "terminated"
    val stopping        = "stopping"
    val stopped         = "stopped"

    val values = IndexedSeq(pending, running, `shutting-down`, terminated, stopping, stopped)
  }

  /**
    * Describes the status of an instance.
    */
  @js.native
  trait InstanceStatus extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var Events: js.UndefOr[InstanceStatusEventList]
    var InstanceId: js.UndefOr[String]
    var InstanceState: js.UndefOr[InstanceState]
    var InstanceStatus: js.UndefOr[InstanceStatusSummary]
    var SystemStatus: js.UndefOr[InstanceStatusSummary]
  }

  object InstanceStatus {
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        Events: js.UndefOr[InstanceStatusEventList] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        InstanceState: js.UndefOr[InstanceState] = js.undefined,
        InstanceStatus: js.UndefOr[InstanceStatusSummary] = js.undefined,
        SystemStatus: js.UndefOr[InstanceStatusSummary] = js.undefined
    ): InstanceStatus = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Events" -> Events.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceState" -> InstanceState.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceStatus" -> InstanceStatus.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SystemStatus" -> SystemStatus.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceStatus]
    }
  }

  /**
    * Describes the instance status.
    */
  @js.native
  trait InstanceStatusDetails extends js.Object {
    var ImpairedSince: js.UndefOr[DateTime]
    var Name: js.UndefOr[StatusName]
    var Status: js.UndefOr[StatusType]
  }

  object InstanceStatusDetails {
    def apply(
        ImpairedSince: js.UndefOr[DateTime] = js.undefined,
        Name: js.UndefOr[StatusName] = js.undefined,
        Status: js.UndefOr[StatusType] = js.undefined
    ): InstanceStatusDetails = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ImpairedSince" -> ImpairedSince.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceStatusDetails]
    }
  }

  /**
    * Describes a scheduled event for an instance.
    */
  @js.native
  trait InstanceStatusEvent extends js.Object {
    var Code: js.UndefOr[EventCode]
    var Description: js.UndefOr[String]
    var InstanceEventId: js.UndefOr[InstanceEventId]
    var NotAfter: js.UndefOr[DateTime]
    var NotBefore: js.UndefOr[DateTime]
    var NotBeforeDeadline: js.UndefOr[DateTime]
  }

  object InstanceStatusEvent {
    def apply(
        Code: js.UndefOr[EventCode] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        InstanceEventId: js.UndefOr[InstanceEventId] = js.undefined,
        NotAfter: js.UndefOr[DateTime] = js.undefined,
        NotBefore: js.UndefOr[DateTime] = js.undefined,
        NotBeforeDeadline: js.UndefOr[DateTime] = js.undefined
    ): InstanceStatusEvent = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Code" -> Code.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceEventId" -> InstanceEventId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NotAfter" -> NotAfter.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NotBefore" -> NotBefore.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NotBeforeDeadline" -> NotBeforeDeadline.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceStatusEvent]
    }
  }

  /**
    * Describes the status of an instance.
    */
  @js.native
  trait InstanceStatusSummary extends js.Object {
    var Details: js.UndefOr[InstanceStatusDetailsList]
    var Status: js.UndefOr[SummaryStatus]
  }

  object InstanceStatusSummary {
    def apply(
        Details: js.UndefOr[InstanceStatusDetailsList] = js.undefined,
        Status: js.UndefOr[SummaryStatus] = js.undefined
    ): InstanceStatusSummary = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Details" -> Details.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InstanceStatusSummary]
    }
  }

  object InstanceTypeEnum {
    val `t1.micro`      = "t1.micro"
    val `t2.nano`       = "t2.nano"
    val `t2.micro`      = "t2.micro"
    val `t2.small`      = "t2.small"
    val `t2.medium`     = "t2.medium"
    val `t2.large`      = "t2.large"
    val `t2.xlarge`     = "t2.xlarge"
    val `t2.2xlarge`    = "t2.2xlarge"
    val `t3.nano`       = "t3.nano"
    val `t3.micro`      = "t3.micro"
    val `t3.small`      = "t3.small"
    val `t3.medium`     = "t3.medium"
    val `t3.large`      = "t3.large"
    val `t3.xlarge`     = "t3.xlarge"
    val `t3.2xlarge`    = "t3.2xlarge"
    val `m1.small`      = "m1.small"
    val `m1.medium`     = "m1.medium"
    val `m1.large`      = "m1.large"
    val `m1.xlarge`     = "m1.xlarge"
    val `m3.medium`     = "m3.medium"
    val `m3.large`      = "m3.large"
    val `m3.xlarge`     = "m3.xlarge"
    val `m3.2xlarge`    = "m3.2xlarge"
    val `m4.large`      = "m4.large"
    val `m4.xlarge`     = "m4.xlarge"
    val `m4.2xlarge`    = "m4.2xlarge"
    val `m4.4xlarge`    = "m4.4xlarge"
    val `m4.10xlarge`   = "m4.10xlarge"
    val `m4.16xlarge`   = "m4.16xlarge"
    val `m2.xlarge`     = "m2.xlarge"
    val `m2.2xlarge`    = "m2.2xlarge"
    val `m2.4xlarge`    = "m2.4xlarge"
    val `cr1.8xlarge`   = "cr1.8xlarge"
    val `r3.large`      = "r3.large"
    val `r3.xlarge`     = "r3.xlarge"
    val `r3.2xlarge`    = "r3.2xlarge"
    val `r3.4xlarge`    = "r3.4xlarge"
    val `r3.8xlarge`    = "r3.8xlarge"
    val `r4.large`      = "r4.large"
    val `r4.xlarge`     = "r4.xlarge"
    val `r4.2xlarge`    = "r4.2xlarge"
    val `r4.4xlarge`    = "r4.4xlarge"
    val `r4.8xlarge`    = "r4.8xlarge"
    val `r4.16xlarge`   = "r4.16xlarge"
    val `r5.large`      = "r5.large"
    val `r5.xlarge`     = "r5.xlarge"
    val `r5.2xlarge`    = "r5.2xlarge"
    val `r5.4xlarge`    = "r5.4xlarge"
    val `r5.12xlarge`   = "r5.12xlarge"
    val `r5.24xlarge`   = "r5.24xlarge"
    val `r5.metal`      = "r5.metal"
    val `r5a.large`     = "r5a.large"
    val `r5a.xlarge`    = "r5a.xlarge"
    val `r5a.2xlarge`   = "r5a.2xlarge"
    val `r5a.4xlarge`   = "r5a.4xlarge"
    val `r5a.12xlarge`  = "r5a.12xlarge"
    val `r5a.24xlarge`  = "r5a.24xlarge"
    val `r5d.large`     = "r5d.large"
    val `r5d.xlarge`    = "r5d.xlarge"
    val `r5d.2xlarge`   = "r5d.2xlarge"
    val `r5d.4xlarge`   = "r5d.4xlarge"
    val `r5d.12xlarge`  = "r5d.12xlarge"
    val `r5d.24xlarge`  = "r5d.24xlarge"
    val `r5d.metal`     = "r5d.metal"
    val `r5ad.large`    = "r5ad.large"
    val `r5ad.xlarge`   = "r5ad.xlarge"
    val `r5ad.2xlarge`  = "r5ad.2xlarge"
    val `r5ad.4xlarge`  = "r5ad.4xlarge"
    val `r5ad.8xlarge`  = "r5ad.8xlarge"
    val `r5ad.12xlarge` = "r5ad.12xlarge"
    val `r5ad.16xlarge` = "r5ad.16xlarge"
    val `r5ad.24xlarge` = "r5ad.24xlarge"
    val `x1.16xlarge`   = "x1.16xlarge"
    val `x1.32xlarge`   = "x1.32xlarge"
    val `x1e.xlarge`    = "x1e.xlarge"
    val `x1e.2xlarge`   = "x1e.2xlarge"
    val `x1e.4xlarge`   = "x1e.4xlarge"
    val `x1e.8xlarge`   = "x1e.8xlarge"
    val `x1e.16xlarge`  = "x1e.16xlarge"
    val `x1e.32xlarge`  = "x1e.32xlarge"
    val `i2.xlarge`     = "i2.xlarge"
    val `i2.2xlarge`    = "i2.2xlarge"
    val `i2.4xlarge`    = "i2.4xlarge"
    val `i2.8xlarge`    = "i2.8xlarge"
    val `i3.large`      = "i3.large"
    val `i3.xlarge`     = "i3.xlarge"
    val `i3.2xlarge`    = "i3.2xlarge"
    val `i3.4xlarge`    = "i3.4xlarge"
    val `i3.8xlarge`    = "i3.8xlarge"
    val `i3.16xlarge`   = "i3.16xlarge"
    val `i3.metal`      = "i3.metal"
    val `hi1.4xlarge`   = "hi1.4xlarge"
    val `hs1.8xlarge`   = "hs1.8xlarge"
    val `c1.medium`     = "c1.medium"
    val `c1.xlarge`     = "c1.xlarge"
    val `c3.large`      = "c3.large"
    val `c3.xlarge`     = "c3.xlarge"
    val `c3.2xlarge`    = "c3.2xlarge"
    val `c3.4xlarge`    = "c3.4xlarge"
    val `c3.8xlarge`    = "c3.8xlarge"
    val `c4.large`      = "c4.large"
    val `c4.xlarge`     = "c4.xlarge"
    val `c4.2xlarge`    = "c4.2xlarge"
    val `c4.4xlarge`    = "c4.4xlarge"
    val `c4.8xlarge`    = "c4.8xlarge"
    val `c5.large`      = "c5.large"
    val `c5.xlarge`     = "c5.xlarge"
    val `c5.2xlarge`    = "c5.2xlarge"
    val `c5.4xlarge`    = "c5.4xlarge"
    val `c5.9xlarge`    = "c5.9xlarge"
    val `c5.18xlarge`   = "c5.18xlarge"
    val `c5d.large`     = "c5d.large"
    val `c5d.xlarge`    = "c5d.xlarge"
    val `c5d.2xlarge`   = "c5d.2xlarge"
    val `c5d.4xlarge`   = "c5d.4xlarge"
    val `c5d.9xlarge`   = "c5d.9xlarge"
    val `c5d.18xlarge`  = "c5d.18xlarge"
    val `c5n.large`     = "c5n.large"
    val `c5n.xlarge`    = "c5n.xlarge"
    val `c5n.2xlarge`   = "c5n.2xlarge"
    val `c5n.4xlarge`   = "c5n.4xlarge"
    val `c5n.9xlarge`   = "c5n.9xlarge"
    val `c5n.18xlarge`  = "c5n.18xlarge"
    val `cc1.4xlarge`   = "cc1.4xlarge"
    val `cc2.8xlarge`   = "cc2.8xlarge"
    val `g2.2xlarge`    = "g2.2xlarge"
    val `g2.8xlarge`    = "g2.8xlarge"
    val `g3.4xlarge`    = "g3.4xlarge"
    val `g3.8xlarge`    = "g3.8xlarge"
    val `g3.16xlarge`   = "g3.16xlarge"
    val `g3s.xlarge`    = "g3s.xlarge"
    val `cg1.4xlarge`   = "cg1.4xlarge"
    val `p2.xlarge`     = "p2.xlarge"
    val `p2.8xlarge`    = "p2.8xlarge"
    val `p2.16xlarge`   = "p2.16xlarge"
    val `p3.2xlarge`    = "p3.2xlarge"
    val `p3.8xlarge`    = "p3.8xlarge"
    val `p3.16xlarge`   = "p3.16xlarge"
    val `p3dn.24xlarge` = "p3dn.24xlarge"
    val `d2.xlarge`     = "d2.xlarge"
    val `d2.2xlarge`    = "d2.2xlarge"
    val `d2.4xlarge`    = "d2.4xlarge"
    val `d2.8xlarge`    = "d2.8xlarge"
    val `f1.2xlarge`    = "f1.2xlarge"
    val `f1.4xlarge`    = "f1.4xlarge"
    val `f1.16xlarge`   = "f1.16xlarge"
    val `m5.large`      = "m5.large"
    val `m5.xlarge`     = "m5.xlarge"
    val `m5.2xlarge`    = "m5.2xlarge"
    val `m5.4xlarge`    = "m5.4xlarge"
    val `m5.12xlarge`   = "m5.12xlarge"
    val `m5.24xlarge`   = "m5.24xlarge"
    val `m5.metal`      = "m5.metal"
    val `m5a.large`     = "m5a.large"
    val `m5a.xlarge`    = "m5a.xlarge"
    val `m5a.2xlarge`   = "m5a.2xlarge"
    val `m5a.4xlarge`   = "m5a.4xlarge"
    val `m5a.12xlarge`  = "m5a.12xlarge"
    val `m5a.24xlarge`  = "m5a.24xlarge"
    val `m5d.large`     = "m5d.large"
    val `m5d.xlarge`    = "m5d.xlarge"
    val `m5d.2xlarge`   = "m5d.2xlarge"
    val `m5d.4xlarge`   = "m5d.4xlarge"
    val `m5d.12xlarge`  = "m5d.12xlarge"
    val `m5d.24xlarge`  = "m5d.24xlarge"
    val `m5d.metal`     = "m5d.metal"
    val `m5ad.large`    = "m5ad.large"
    val `m5ad.xlarge`   = "m5ad.xlarge"
    val `m5ad.2xlarge`  = "m5ad.2xlarge"
    val `m5ad.4xlarge`  = "m5ad.4xlarge"
    val `m5ad.8xlarge`  = "m5ad.8xlarge"
    val `m5ad.12xlarge` = "m5ad.12xlarge"
    val `m5ad.16xlarge` = "m5ad.16xlarge"
    val `m5ad.24xlarge` = "m5ad.24xlarge"
    val `h1.2xlarge`    = "h1.2xlarge"
    val `h1.4xlarge`    = "h1.4xlarge"
    val `h1.8xlarge`    = "h1.8xlarge"
    val `h1.16xlarge`   = "h1.16xlarge"
    val `z1d.large`     = "z1d.large"
    val `z1d.xlarge`    = "z1d.xlarge"
    val `z1d.2xlarge`   = "z1d.2xlarge"
    val `z1d.3xlarge`   = "z1d.3xlarge"
    val `z1d.6xlarge`   = "z1d.6xlarge"
    val `z1d.12xlarge`  = "z1d.12xlarge"
    val `z1d.metal`     = "z1d.metal"
    val `u-6tb1.metal`  = "u-6tb1.metal"
    val `u-9tb1.metal`  = "u-9tb1.metal"
    val `u-12tb1.metal` = "u-12tb1.metal"
    val `a1.medium`     = "a1.medium"
    val `a1.large`      = "a1.large"
    val `a1.xlarge`     = "a1.xlarge"
    val `a1.2xlarge`    = "a1.2xlarge"
    val `a1.4xlarge`    = "a1.4xlarge"

    val values = IndexedSeq(
      `t1.micro`,
      `t2.nano`,
      `t2.micro`,
      `t2.small`,
      `t2.medium`,
      `t2.large`,
      `t2.xlarge`,
      `t2.2xlarge`,
      `t3.nano`,
      `t3.micro`,
      `t3.small`,
      `t3.medium`,
      `t3.large`,
      `t3.xlarge`,
      `t3.2xlarge`,
      `m1.small`,
      `m1.medium`,
      `m1.large`,
      `m1.xlarge`,
      `m3.medium`,
      `m3.large`,
      `m3.xlarge`,
      `m3.2xlarge`,
      `m4.large`,
      `m4.xlarge`,
      `m4.2xlarge`,
      `m4.4xlarge`,
      `m4.10xlarge`,
      `m4.16xlarge`,
      `m2.xlarge`,
      `m2.2xlarge`,
      `m2.4xlarge`,
      `cr1.8xlarge`,
      `r3.large`,
      `r3.xlarge`,
      `r3.2xlarge`,
      `r3.4xlarge`,
      `r3.8xlarge`,
      `r4.large`,
      `r4.xlarge`,
      `r4.2xlarge`,
      `r4.4xlarge`,
      `r4.8xlarge`,
      `r4.16xlarge`,
      `r5.large`,
      `r5.xlarge`,
      `r5.2xlarge`,
      `r5.4xlarge`,
      `r5.12xlarge`,
      `r5.24xlarge`,
      `r5.metal`,
      `r5a.large`,
      `r5a.xlarge`,
      `r5a.2xlarge`,
      `r5a.4xlarge`,
      `r5a.12xlarge`,
      `r5a.24xlarge`,
      `r5d.large`,
      `r5d.xlarge`,
      `r5d.2xlarge`,
      `r5d.4xlarge`,
      `r5d.12xlarge`,
      `r5d.24xlarge`,
      `r5d.metal`,
      `r5ad.large`,
      `r5ad.xlarge`,
      `r5ad.2xlarge`,
      `r5ad.4xlarge`,
      `r5ad.8xlarge`,
      `r5ad.12xlarge`,
      `r5ad.16xlarge`,
      `r5ad.24xlarge`,
      `x1.16xlarge`,
      `x1.32xlarge`,
      `x1e.xlarge`,
      `x1e.2xlarge`,
      `x1e.4xlarge`,
      `x1e.8xlarge`,
      `x1e.16xlarge`,
      `x1e.32xlarge`,
      `i2.xlarge`,
      `i2.2xlarge`,
      `i2.4xlarge`,
      `i2.8xlarge`,
      `i3.large`,
      `i3.xlarge`,
      `i3.2xlarge`,
      `i3.4xlarge`,
      `i3.8xlarge`,
      `i3.16xlarge`,
      `i3.metal`,
      `hi1.4xlarge`,
      `hs1.8xlarge`,
      `c1.medium`,
      `c1.xlarge`,
      `c3.large`,
      `c3.xlarge`,
      `c3.2xlarge`,
      `c3.4xlarge`,
      `c3.8xlarge`,
      `c4.large`,
      `c4.xlarge`,
      `c4.2xlarge`,
      `c4.4xlarge`,
      `c4.8xlarge`,
      `c5.large`,
      `c5.xlarge`,
      `c5.2xlarge`,
      `c5.4xlarge`,
      `c5.9xlarge`,
      `c5.18xlarge`,
      `c5d.large`,
      `c5d.xlarge`,
      `c5d.2xlarge`,
      `c5d.4xlarge`,
      `c5d.9xlarge`,
      `c5d.18xlarge`,
      `c5n.large`,
      `c5n.xlarge`,
      `c5n.2xlarge`,
      `c5n.4xlarge`,
      `c5n.9xlarge`,
      `c5n.18xlarge`,
      `cc1.4xlarge`,
      `cc2.8xlarge`,
      `g2.2xlarge`,
      `g2.8xlarge`,
      `g3.4xlarge`,
      `g3.8xlarge`,
      `g3.16xlarge`,
      `g3s.xlarge`,
      `cg1.4xlarge`,
      `p2.xlarge`,
      `p2.8xlarge`,
      `p2.16xlarge`,
      `p3.2xlarge`,
      `p3.8xlarge`,
      `p3.16xlarge`,
      `p3dn.24xlarge`,
      `d2.xlarge`,
      `d2.2xlarge`,
      `d2.4xlarge`,
      `d2.8xlarge`,
      `f1.2xlarge`,
      `f1.4xlarge`,
      `f1.16xlarge`,
      `m5.large`,
      `m5.xlarge`,
      `m5.2xlarge`,
      `m5.4xlarge`,
      `m5.12xlarge`,
      `m5.24xlarge`,
      `m5.metal`,
      `m5a.large`,
      `m5a.xlarge`,
      `m5a.2xlarge`,
      `m5a.4xlarge`,
      `m5a.12xlarge`,
      `m5a.24xlarge`,
      `m5d.large`,
      `m5d.xlarge`,
      `m5d.2xlarge`,
      `m5d.4xlarge`,
      `m5d.12xlarge`,
      `m5d.24xlarge`,
      `m5d.metal`,
      `m5ad.large`,
      `m5ad.xlarge`,
      `m5ad.2xlarge`,
      `m5ad.4xlarge`,
      `m5ad.8xlarge`,
      `m5ad.12xlarge`,
      `m5ad.16xlarge`,
      `m5ad.24xlarge`,
      `h1.2xlarge`,
      `h1.4xlarge`,
      `h1.8xlarge`,
      `h1.16xlarge`,
      `z1d.large`,
      `z1d.xlarge`,
      `z1d.2xlarge`,
      `z1d.3xlarge`,
      `z1d.6xlarge`,
      `z1d.12xlarge`,
      `z1d.metal`,
      `u-6tb1.metal`,
      `u-9tb1.metal`,
      `u-12tb1.metal`,
      `a1.medium`,
      `a1.large`,
      `a1.xlarge`,
      `a1.2xlarge`,
      `a1.4xlarge`
    )
  }

  object InterfacePermissionTypeEnum {
    val `INSTANCE-ATTACH` = "INSTANCE-ATTACH"
    val `EIP-ASSOCIATE`   = "EIP-ASSOCIATE"

    val values = IndexedSeq(`INSTANCE-ATTACH`, `EIP-ASSOCIATE`)
  }

  /**
    * Describes an internet gateway.
    */
  @js.native
  trait InternetGateway extends js.Object {
    var Attachments: js.UndefOr[InternetGatewayAttachmentList]
    var InternetGatewayId: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
  }

  object InternetGateway {
    def apply(
        Attachments: js.UndefOr[InternetGatewayAttachmentList] = js.undefined,
        InternetGatewayId: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): InternetGateway = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Attachments" -> Attachments.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InternetGatewayId" -> InternetGatewayId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OwnerId" -> OwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InternetGateway]
    }
  }

  /**
    * Describes the attachment of a VPC to an internet gateway or an egress-only internet gateway.
    */
  @js.native
  trait InternetGatewayAttachment extends js.Object {
    var State: js.UndefOr[AttachmentStatus]
    var VpcId: js.UndefOr[String]
  }

  object InternetGatewayAttachment {
    def apply(
        State: js.UndefOr[AttachmentStatus] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): InternetGatewayAttachment = {
      val _fields = IndexedSeq[(String, js.Any)](
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[InternetGatewayAttachment]
    }
  }

  /**
    * Describes a set of permissions for a security group rule.
    */
  @js.native
  trait IpPermission extends js.Object {
    var FromPort: js.UndefOr[Int]
    var IpProtocol: js.UndefOr[String]
    var IpRanges: js.UndefOr[IpRangeList]
    var Ipv6Ranges: js.UndefOr[Ipv6RangeList]
    var PrefixListIds: js.UndefOr[PrefixListIdList]
    var ToPort: js.UndefOr[Int]
    var UserIdGroupPairs: js.UndefOr[UserIdGroupPairList]
  }

  object IpPermission {
    def apply(
        FromPort: js.UndefOr[Int] = js.undefined,
        IpProtocol: js.UndefOr[String] = js.undefined,
        IpRanges: js.UndefOr[IpRangeList] = js.undefined,
        Ipv6Ranges: js.UndefOr[Ipv6RangeList] = js.undefined,
        PrefixListIds: js.UndefOr[PrefixListIdList] = js.undefined,
        ToPort: js.UndefOr[Int] = js.undefined,
        UserIdGroupPairs: js.UndefOr[UserIdGroupPairList] = js.undefined
    ): IpPermission = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FromPort" -> FromPort.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IpProtocol" -> IpProtocol.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IpRanges" -> IpRanges.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6Ranges" -> Ipv6Ranges.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrefixListIds" -> PrefixListIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ToPort" -> ToPort.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserIdGroupPairs" -> UserIdGroupPairs.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[IpPermission]
    }
  }

  /**
    * Describes an IPv4 range.
    */
  @js.native
  trait IpRange extends js.Object {
    var CidrIp: js.UndefOr[String]
    var Description: js.UndefOr[String]
  }

  object IpRange {
    def apply(
        CidrIp: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined
    ): IpRange = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CidrIp" -> CidrIp.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[IpRange]
    }
  }

  /**
    * Describes an IPv6 CIDR block.
    */
  @js.native
  trait Ipv6CidrBlock extends js.Object {
    var Ipv6CidrBlock: js.UndefOr[String]
  }

  object Ipv6CidrBlock {
    def apply(
        Ipv6CidrBlock: js.UndefOr[String] = js.undefined
    ): Ipv6CidrBlock = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Ipv6CidrBlock" -> Ipv6CidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[Ipv6CidrBlock]
    }
  }

  /**
    * [EC2-VPC only] Describes an IPv6 range.
    */
  @js.native
  trait Ipv6Range extends js.Object {
    var CidrIpv6: js.UndefOr[String]
    var Description: js.UndefOr[String]
  }

  object Ipv6Range {
    def apply(
        CidrIpv6: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined
    ): Ipv6Range = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CidrIpv6" -> CidrIpv6.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[Ipv6Range]
    }
  }

  object Ipv6SupportValueEnum {
    val enable  = "enable"
    val disable = "disable"

    val values = IndexedSeq(enable, disable)
  }

  /**
    * Describes a key pair.
    */
  @js.native
  trait KeyPair extends js.Object {
    var KeyFingerprint: js.UndefOr[String]
    var KeyMaterial: js.UndefOr[String]
    var KeyName: js.UndefOr[String]
  }

  object KeyPair {
    def apply(
        KeyFingerprint: js.UndefOr[String] = js.undefined,
        KeyMaterial: js.UndefOr[String] = js.undefined,
        KeyName: js.UndefOr[String] = js.undefined
    ): KeyPair = {
      val _fields = IndexedSeq[(String, js.Any)](
        "KeyFingerprint" -> KeyFingerprint.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KeyMaterial" -> KeyMaterial.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KeyName" -> KeyName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[KeyPair]
    }
  }

  /**
    * Describes a key pair.
    */
  @js.native
  trait KeyPairInfo extends js.Object {
    var KeyFingerprint: js.UndefOr[String]
    var KeyName: js.UndefOr[String]
  }

  object KeyPairInfo {
    def apply(
        KeyFingerprint: js.UndefOr[String] = js.undefined,
        KeyName: js.UndefOr[String] = js.undefined
    ): KeyPairInfo = {
      val _fields = IndexedSeq[(String, js.Any)](
        "KeyFingerprint" -> KeyFingerprint.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KeyName" -> KeyName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[KeyPairInfo]
    }
  }

  /**
    * Describes a launch permission.
    */
  @js.native
  trait LaunchPermission extends js.Object {
    var Group: js.UndefOr[PermissionGroup]
    var UserId: js.UndefOr[String]
  }

  object LaunchPermission {
    def apply(
        Group: js.UndefOr[PermissionGroup] = js.undefined,
        UserId: js.UndefOr[String] = js.undefined
    ): LaunchPermission = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Group" -> Group.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserId" -> UserId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchPermission]
    }
  }

  /**
    * Describes a launch permission modification.
    */
  @js.native
  trait LaunchPermissionModifications extends js.Object {
    var Add: js.UndefOr[LaunchPermissionList]
    var Remove: js.UndefOr[LaunchPermissionList]
  }

  object LaunchPermissionModifications {
    def apply(
        Add: js.UndefOr[LaunchPermissionList] = js.undefined,
        Remove: js.UndefOr[LaunchPermissionList] = js.undefined
    ): LaunchPermissionModifications = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Add" -> Add.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Remove" -> Remove.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchPermissionModifications]
    }
  }

  /**
    * Describes the launch specification for an instance.
    */
  @js.native
  trait LaunchSpecification extends js.Object {
    var AddressingType: js.UndefOr[String]
    var BlockDeviceMappings: js.UndefOr[BlockDeviceMappingList]
    var EbsOptimized: js.UndefOr[Boolean]
    var IamInstanceProfile: js.UndefOr[IamInstanceProfileSpecification]
    var ImageId: js.UndefOr[String]
    var InstanceType: js.UndefOr[InstanceType]
    var KernelId: js.UndefOr[String]
    var KeyName: js.UndefOr[String]
    var Monitoring: js.UndefOr[RunInstancesMonitoringEnabled]
    var NetworkInterfaces: js.UndefOr[InstanceNetworkInterfaceSpecificationList]
    var Placement: js.UndefOr[SpotPlacement]
    var RamdiskId: js.UndefOr[String]
    var SecurityGroups: js.UndefOr[GroupIdentifierList]
    var SubnetId: js.UndefOr[String]
    var UserData: js.UndefOr[String]
  }

  object LaunchSpecification {
    def apply(
        AddressingType: js.UndefOr[String] = js.undefined,
        BlockDeviceMappings: js.UndefOr[BlockDeviceMappingList] = js.undefined,
        EbsOptimized: js.UndefOr[Boolean] = js.undefined,
        IamInstanceProfile: js.UndefOr[IamInstanceProfileSpecification] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        KernelId: js.UndefOr[String] = js.undefined,
        KeyName: js.UndefOr[String] = js.undefined,
        Monitoring: js.UndefOr[RunInstancesMonitoringEnabled] = js.undefined,
        NetworkInterfaces: js.UndefOr[InstanceNetworkInterfaceSpecificationList] = js.undefined,
        Placement: js.UndefOr[SpotPlacement] = js.undefined,
        RamdiskId: js.UndefOr[String] = js.undefined,
        SecurityGroups: js.UndefOr[GroupIdentifierList] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        UserData: js.UndefOr[String] = js.undefined
    ): LaunchSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AddressingType" -> AddressingType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "BlockDeviceMappings" -> BlockDeviceMappings.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EbsOptimized" -> EbsOptimized.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IamInstanceProfile" -> IamInstanceProfile.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ImageId" -> ImageId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KernelId" -> KernelId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KeyName" -> KeyName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Monitoring" -> Monitoring.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaces" -> NetworkInterfaces.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Placement" -> Placement.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RamdiskId" -> RamdiskId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SecurityGroups" -> SecurityGroups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserData" -> UserData.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchSpecification]
    }
  }

  /**
    * Describes a launch template.
    */
  @js.native
  trait LaunchTemplate extends js.Object {
    var CreateTime: js.UndefOr[DateTime]
    var CreatedBy: js.UndefOr[String]
    var DefaultVersionNumber: js.UndefOr[Double]
    var LatestVersionNumber: js.UndefOr[Double]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
    var Tags: js.UndefOr[TagList]
  }

  object LaunchTemplate {
    def apply(
        CreateTime: js.UndefOr[DateTime] = js.undefined,
        CreatedBy: js.UndefOr[String] = js.undefined,
        DefaultVersionNumber: js.UndefOr[Double] = js.undefined,
        LatestVersionNumber: js.UndefOr[Double] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): LaunchTemplate = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CreateTime" -> CreateTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CreatedBy" -> CreatedBy.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DefaultVersionNumber" -> DefaultVersionNumber.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LatestVersionNumber" -> LatestVersionNumber.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateId" -> LaunchTemplateId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateName" -> LaunchTemplateName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplate]
    }
  }

  /**
    * Describes a launch template and overrides.
    */
  @js.native
  trait LaunchTemplateAndOverridesResponse extends js.Object {
    var LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecification]
    var Overrides: js.UndefOr[FleetLaunchTemplateOverrides]
  }

  object LaunchTemplateAndOverridesResponse {
    def apply(
        LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecification] = js.undefined,
        Overrides: js.UndefOr[FleetLaunchTemplateOverrides] = js.undefined
    ): LaunchTemplateAndOverridesResponse = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateSpecification" -> LaunchTemplateSpecification.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Overrides" -> Overrides.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateAndOverridesResponse]
    }
  }

  /**
    * Describes a block device mapping.
    */
  @js.native
  trait LaunchTemplateBlockDeviceMapping extends js.Object {
    var DeviceName: js.UndefOr[String]
    var Ebs: js.UndefOr[LaunchTemplateEbsBlockDevice]
    var NoDevice: js.UndefOr[String]
    var VirtualName: js.UndefOr[String]
  }

  object LaunchTemplateBlockDeviceMapping {
    def apply(
        DeviceName: js.UndefOr[String] = js.undefined,
        Ebs: js.UndefOr[LaunchTemplateEbsBlockDevice] = js.undefined,
        NoDevice: js.UndefOr[String] = js.undefined,
        VirtualName: js.UndefOr[String] = js.undefined
    ): LaunchTemplateBlockDeviceMapping = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DeviceName" -> DeviceName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ebs" -> Ebs.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NoDevice" -> NoDevice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VirtualName" -> VirtualName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateBlockDeviceMapping]
    }
  }

  /**
    * Describes a block device mapping.
    */
  @js.native
  trait LaunchTemplateBlockDeviceMappingRequest extends js.Object {
    var DeviceName: js.UndefOr[String]
    var Ebs: js.UndefOr[LaunchTemplateEbsBlockDeviceRequest]
    var NoDevice: js.UndefOr[String]
    var VirtualName: js.UndefOr[String]
  }

  object LaunchTemplateBlockDeviceMappingRequest {
    def apply(
        DeviceName: js.UndefOr[String] = js.undefined,
        Ebs: js.UndefOr[LaunchTemplateEbsBlockDeviceRequest] = js.undefined,
        NoDevice: js.UndefOr[String] = js.undefined,
        VirtualName: js.UndefOr[String] = js.undefined
    ): LaunchTemplateBlockDeviceMappingRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DeviceName" -> DeviceName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ebs" -> Ebs.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NoDevice" -> NoDevice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VirtualName" -> VirtualName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateBlockDeviceMappingRequest]
    }
  }

  /**
    * Describes an instance's Capacity Reservation targeting option. You can specify only one option at a time. Use the <code>CapacityReservationPreference</code> parameter to configure the instance to run in On-Demand capacity or to run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). Use the <code>CapacityReservationTarget</code> parameter to explicitly target a specific Capacity Reservation.
    */
  @js.native
  trait LaunchTemplateCapacityReservationSpecificationRequest extends js.Object {
    var CapacityReservationPreference: js.UndefOr[CapacityReservationPreference]
    var CapacityReservationTarget: js.UndefOr[CapacityReservationTarget]
  }

  object LaunchTemplateCapacityReservationSpecificationRequest {
    def apply(
        CapacityReservationPreference: js.UndefOr[CapacityReservationPreference] = js.undefined,
        CapacityReservationTarget: js.UndefOr[CapacityReservationTarget] = js.undefined
    ): LaunchTemplateCapacityReservationSpecificationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CapacityReservationPreference" -> CapacityReservationPreference.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CapacityReservationTarget" -> CapacityReservationTarget.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[LaunchTemplateCapacityReservationSpecificationRequest]
    }
  }

  /**
    * Information about the Capacity Reservation targeting option.
    */
  @js.native
  trait LaunchTemplateCapacityReservationSpecificationResponse extends js.Object {
    var CapacityReservationPreference: js.UndefOr[CapacityReservationPreference]
    var CapacityReservationTarget: js.UndefOr[CapacityReservationTargetResponse]
  }

  object LaunchTemplateCapacityReservationSpecificationResponse {
    def apply(
        CapacityReservationPreference: js.UndefOr[CapacityReservationPreference] = js.undefined,
        CapacityReservationTarget: js.UndefOr[CapacityReservationTargetResponse] = js.undefined
    ): LaunchTemplateCapacityReservationSpecificationResponse = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CapacityReservationPreference" -> CapacityReservationPreference.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CapacityReservationTarget" -> CapacityReservationTarget.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[LaunchTemplateCapacityReservationSpecificationResponse]
    }
  }

  /**
    * Describes a launch template and overrides.
    */
  @js.native
  trait LaunchTemplateConfig extends js.Object {
    var LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecification]
    var Overrides: js.UndefOr[LaunchTemplateOverridesList]
  }

  object LaunchTemplateConfig {
    def apply(
        LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecification] = js.undefined,
        Overrides: js.UndefOr[LaunchTemplateOverridesList] = js.undefined
    ): LaunchTemplateConfig = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateSpecification" -> LaunchTemplateSpecification.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Overrides" -> Overrides.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateConfig]
    }
  }

  /**
    * The CPU options for the instance.
    */
  @js.native
  trait LaunchTemplateCpuOptions extends js.Object {
    var CoreCount: js.UndefOr[Int]
    var ThreadsPerCore: js.UndefOr[Int]
  }

  object LaunchTemplateCpuOptions {
    def apply(
        CoreCount: js.UndefOr[Int] = js.undefined,
        ThreadsPerCore: js.UndefOr[Int] = js.undefined
    ): LaunchTemplateCpuOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CoreCount" -> CoreCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ThreadsPerCore" -> ThreadsPerCore.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateCpuOptions]
    }
  }

  /**
    * The CPU options for the instance. Both the core count and threads per core must be specified in the request.
    */
  @js.native
  trait LaunchTemplateCpuOptionsRequest extends js.Object {
    var CoreCount: js.UndefOr[Int]
    var ThreadsPerCore: js.UndefOr[Int]
  }

  object LaunchTemplateCpuOptionsRequest {
    def apply(
        CoreCount: js.UndefOr[Int] = js.undefined,
        ThreadsPerCore: js.UndefOr[Int] = js.undefined
    ): LaunchTemplateCpuOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CoreCount" -> CoreCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ThreadsPerCore" -> ThreadsPerCore.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateCpuOptionsRequest]
    }
  }

  /**
    * Describes a block device for an EBS volume.
    */
  @js.native
  trait LaunchTemplateEbsBlockDevice extends js.Object {
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var Iops: js.UndefOr[Int]
    var KmsKeyId: js.UndefOr[String]
    var SnapshotId: js.UndefOr[String]
    var VolumeSize: js.UndefOr[Int]
    var VolumeType: js.UndefOr[VolumeType]
  }

  object LaunchTemplateEbsBlockDevice {
    def apply(
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Iops: js.UndefOr[Int] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        SnapshotId: js.UndefOr[String] = js.undefined,
        VolumeSize: js.UndefOr[Int] = js.undefined,
        VolumeType: js.UndefOr[VolumeType] = js.undefined
    ): LaunchTemplateEbsBlockDevice = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DeleteOnTermination" -> DeleteOnTermination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Encrypted" -> Encrypted.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Iops" -> Iops.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KmsKeyId" -> KmsKeyId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SnapshotId" -> SnapshotId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeSize" -> VolumeSize.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeType" -> VolumeType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateEbsBlockDevice]
    }
  }

  /**
    * The parameters for a block device for an EBS volume.
    */
  @js.native
  trait LaunchTemplateEbsBlockDeviceRequest extends js.Object {
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var Iops: js.UndefOr[Int]
    var KmsKeyId: js.UndefOr[String]
    var SnapshotId: js.UndefOr[String]
    var VolumeSize: js.UndefOr[Int]
    var VolumeType: js.UndefOr[VolumeType]
  }

  object LaunchTemplateEbsBlockDeviceRequest {
    def apply(
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Iops: js.UndefOr[Int] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        SnapshotId: js.UndefOr[String] = js.undefined,
        VolumeSize: js.UndefOr[Int] = js.undefined,
        VolumeType: js.UndefOr[VolumeType] = js.undefined
    ): LaunchTemplateEbsBlockDeviceRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DeleteOnTermination" -> DeleteOnTermination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Encrypted" -> Encrypted.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Iops" -> Iops.map { x =>
          x.asInstanceOf[js.Any]
        },
        "KmsKeyId" -> KmsKeyId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SnapshotId" -> SnapshotId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeSize" -> VolumeSize.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeType" -> VolumeType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateEbsBlockDeviceRequest]
    }
  }

  /**
    * Describes an elastic inference accelerator.
    */
  @js.native
  trait LaunchTemplateElasticInferenceAccelerator extends js.Object {
    var Type: String
  }

  object LaunchTemplateElasticInferenceAccelerator {
    def apply(
        Type: String
    ): LaunchTemplateElasticInferenceAccelerator = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Type" -> Type.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateElasticInferenceAccelerator]
    }
  }

  /**
    * Describes an elastic inference accelerator.
    */
  @js.native
  trait LaunchTemplateElasticInferenceAcceleratorResponse extends js.Object {
    var Type: js.UndefOr[String]
  }

  object LaunchTemplateElasticInferenceAcceleratorResponse {
    def apply(
        Type: js.UndefOr[String] = js.undefined
    ): LaunchTemplateElasticInferenceAcceleratorResponse = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Type" -> Type.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[LaunchTemplateElasticInferenceAcceleratorResponse]
    }
  }

  object LaunchTemplateErrorCodeEnum {
    val launchTemplateIdDoesNotExist      = "launchTemplateIdDoesNotExist"
    val launchTemplateIdMalformed         = "launchTemplateIdMalformed"
    val launchTemplateNameDoesNotExist    = "launchTemplateNameDoesNotExist"
    val launchTemplateNameMalformed       = "launchTemplateNameMalformed"
    val launchTemplateVersionDoesNotExist = "launchTemplateVersionDoesNotExist"
    val unexpectedError                   = "unexpectedError"

    val values = IndexedSeq(
      launchTemplateIdDoesNotExist,
      launchTemplateIdMalformed,
      launchTemplateNameDoesNotExist,
      launchTemplateNameMalformed,
      launchTemplateVersionDoesNotExist,
      unexpectedError
    )
  }

  /**
    * Indicates whether an instance is configured for hibernation.
    */
  @js.native
  trait LaunchTemplateHibernationOptions extends js.Object {
    var Configured: js.UndefOr[Boolean]
  }

  object LaunchTemplateHibernationOptions {
    def apply(
        Configured: js.UndefOr[Boolean] = js.undefined
    ): LaunchTemplateHibernationOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Configured" -> Configured.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateHibernationOptions]
    }
  }

  /**
    * Indicates whether the instance is configured for hibernation. This parameter is valid only if the instance meets the [[https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites|hibernation prerequisites]]. Hibernation is currently supported only for Amazon Linux.
    */
  @js.native
  trait LaunchTemplateHibernationOptionsRequest extends js.Object {
    var Configured: js.UndefOr[Boolean]
  }

  object LaunchTemplateHibernationOptionsRequest {
    def apply(
        Configured: js.UndefOr[Boolean] = js.undefined
    ): LaunchTemplateHibernationOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Configured" -> Configured.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateHibernationOptionsRequest]
    }
  }

  /**
    * Describes an IAM instance profile.
    */
  @js.native
  trait LaunchTemplateIamInstanceProfileSpecification extends js.Object {
    var Arn: js.UndefOr[String]
    var Name: js.UndefOr[String]
  }

  object LaunchTemplateIamInstanceProfileSpecification {
    def apply(
        Arn: js.UndefOr[String] = js.undefined,
        Name: js.UndefOr[String] = js.undefined
    ): LaunchTemplateIamInstanceProfileSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Arn" -> Arn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[LaunchTemplateIamInstanceProfileSpecification]
    }
  }

  /**
    * An IAM instance profile.
    */
  @js.native
  trait LaunchTemplateIamInstanceProfileSpecificationRequest extends js.Object {
    var Arn: js.UndefOr[String]
    var Name: js.UndefOr[String]
  }

  object LaunchTemplateIamInstanceProfileSpecificationRequest {
    def apply(
        Arn: js.UndefOr[String] = js.undefined,
        Name: js.UndefOr[String] = js.undefined
    ): LaunchTemplateIamInstanceProfileSpecificationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Arn" -> Arn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[LaunchTemplateIamInstanceProfileSpecificationRequest]
    }
  }

  /**
    * The market (purchasing) option for the instances.
    */
  @js.native
  trait LaunchTemplateInstanceMarketOptions extends js.Object {
    var MarketType: js.UndefOr[MarketType]
    var SpotOptions: js.UndefOr[LaunchTemplateSpotMarketOptions]
  }

  object LaunchTemplateInstanceMarketOptions {
    def apply(
        MarketType: js.UndefOr[MarketType] = js.undefined,
        SpotOptions: js.UndefOr[LaunchTemplateSpotMarketOptions] = js.undefined
    ): LaunchTemplateInstanceMarketOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "MarketType" -> MarketType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotOptions" -> SpotOptions.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateInstanceMarketOptions]
    }
  }

  /**
    * The market (purchasing) option for the instances.
    */
  @js.native
  trait LaunchTemplateInstanceMarketOptionsRequest extends js.Object {
    var MarketType: js.UndefOr[MarketType]
    var SpotOptions: js.UndefOr[LaunchTemplateSpotMarketOptionsRequest]
  }

  object LaunchTemplateInstanceMarketOptionsRequest {
    def apply(
        MarketType: js.UndefOr[MarketType] = js.undefined,
        SpotOptions: js.UndefOr[LaunchTemplateSpotMarketOptionsRequest] = js.undefined
    ): LaunchTemplateInstanceMarketOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "MarketType" -> MarketType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotOptions" -> SpotOptions.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[LaunchTemplateInstanceMarketOptionsRequest]
    }
  }

  /**
    * Describes a network interface.
    */
  @js.native
  trait LaunchTemplateInstanceNetworkInterfaceSpecification extends js.Object {
    var AssociatePublicIpAddress: js.UndefOr[Boolean]
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Description: js.UndefOr[String]
    var DeviceIndex: js.UndefOr[Int]
    var Groups: js.UndefOr[GroupIdStringList]
    var Ipv6AddressCount: js.UndefOr[Int]
    var Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList]
    var NetworkInterfaceId: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList]
    var SecondaryPrivateIpAddressCount: js.UndefOr[Int]
    var SubnetId: js.UndefOr[String]
  }

  object LaunchTemplateInstanceNetworkInterfaceSpecification {
    def apply(
        AssociatePublicIpAddress: js.UndefOr[Boolean] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DeviceIndex: js.UndefOr[Int] = js.undefined,
        Groups: js.UndefOr[GroupIdStringList] = js.undefined,
        Ipv6AddressCount: js.UndefOr[Int] = js.undefined,
        Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList] = js.undefined,
        SecondaryPrivateIpAddressCount: js.UndefOr[Int] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined
    ): LaunchTemplateInstanceNetworkInterfaceSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociatePublicIpAddress" -> AssociatePublicIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeleteOnTermination" -> DeleteOnTermination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeviceIndex" -> DeviceIndex.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Groups" -> Groups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6AddressCount" -> Ipv6AddressCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6Addresses" -> Ipv6Addresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceId" -> NetworkInterfaceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddresses" -> PrivateIpAddresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SecondaryPrivateIpAddressCount" -> SecondaryPrivateIpAddressCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[LaunchTemplateInstanceNetworkInterfaceSpecification]
    }
  }

  /**
    * The parameters for a network interface.
    */
  @js.native
  trait LaunchTemplateInstanceNetworkInterfaceSpecificationRequest extends js.Object {
    var AssociatePublicIpAddress: js.UndefOr[Boolean]
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Description: js.UndefOr[String]
    var DeviceIndex: js.UndefOr[Int]
    var Groups: js.UndefOr[SecurityGroupIdStringList]
    var Ipv6AddressCount: js.UndefOr[Int]
    var Ipv6Addresses: js.UndefOr[InstanceIpv6AddressListRequest]
    var NetworkInterfaceId: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList]
    var SecondaryPrivateIpAddressCount: js.UndefOr[Int]
    var SubnetId: js.UndefOr[String]
  }

  object LaunchTemplateInstanceNetworkInterfaceSpecificationRequest {
    def apply(
        AssociatePublicIpAddress: js.UndefOr[Boolean] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DeviceIndex: js.UndefOr[Int] = js.undefined,
        Groups: js.UndefOr[SecurityGroupIdStringList] = js.undefined,
        Ipv6AddressCount: js.UndefOr[Int] = js.undefined,
        Ipv6Addresses: js.UndefOr[InstanceIpv6AddressListRequest] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList] = js.undefined,
        SecondaryPrivateIpAddressCount: js.UndefOr[Int] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined
    ): LaunchTemplateInstanceNetworkInterfaceSpecificationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AssociatePublicIpAddress" -> AssociatePublicIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeleteOnTermination" -> DeleteOnTermination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeviceIndex" -> DeviceIndex.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Groups" -> Groups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6AddressCount" -> Ipv6AddressCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6Addresses" -> Ipv6Addresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceId" -> NetworkInterfaceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddresses" -> PrivateIpAddresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SecondaryPrivateIpAddressCount" -> SecondaryPrivateIpAddressCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[LaunchTemplateInstanceNetworkInterfaceSpecificationRequest]
    }
  }

  /**
    * Describes a license configuration.
    */
  @js.native
  trait LaunchTemplateLicenseConfiguration extends js.Object {
    var LicenseConfigurationArn: js.UndefOr[String]
  }

  object LaunchTemplateLicenseConfiguration {
    def apply(
        LicenseConfigurationArn: js.UndefOr[String] = js.undefined
    ): LaunchTemplateLicenseConfiguration = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LicenseConfigurationArn" -> LicenseConfigurationArn.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateLicenseConfiguration]
    }
  }

  /**
    * Describes a license configuration.
    */
  @js.native
  trait LaunchTemplateLicenseConfigurationRequest extends js.Object {
    var LicenseConfigurationArn: js.UndefOr[String]
  }

  object LaunchTemplateLicenseConfigurationRequest {
    def apply(
        LicenseConfigurationArn: js.UndefOr[String] = js.undefined
    ): LaunchTemplateLicenseConfigurationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LicenseConfigurationArn" -> LicenseConfigurationArn.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateLicenseConfigurationRequest]
    }
  }

  /**
    * Describes overrides for a launch template.
    */
  @js.native
  trait LaunchTemplateOverrides extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var InstanceType: js.UndefOr[InstanceType]
    var Priority: js.UndefOr[Double]
    var SpotPrice: js.UndefOr[String]
    var SubnetId: js.UndefOr[String]
    var WeightedCapacity: js.UndefOr[Double]
  }

  object LaunchTemplateOverrides {
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        Priority: js.UndefOr[Double] = js.undefined,
        SpotPrice: js.UndefOr[String] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        WeightedCapacity: js.UndefOr[Double] = js.undefined
    ): LaunchTemplateOverrides = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Priority" -> Priority.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotPrice" -> SpotPrice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "WeightedCapacity" -> WeightedCapacity.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateOverrides]
    }
  }

  /**
    * Describes the placement of an instance.
    */
  @js.native
  trait LaunchTemplatePlacement extends js.Object {
    var Affinity: js.UndefOr[String]
    var AvailabilityZone: js.UndefOr[String]
    var GroupName: js.UndefOr[String]
    var HostId: js.UndefOr[String]
    var SpreadDomain: js.UndefOr[String]
    var Tenancy: js.UndefOr[Tenancy]
  }

  object LaunchTemplatePlacement {
    def apply(
        Affinity: js.UndefOr[String] = js.undefined,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined,
        HostId: js.UndefOr[String] = js.undefined,
        SpreadDomain: js.UndefOr[String] = js.undefined,
        Tenancy: js.UndefOr[Tenancy] = js.undefined
    ): LaunchTemplatePlacement = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Affinity" -> Affinity.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupName" -> GroupName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostId" -> HostId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpreadDomain" -> SpreadDomain.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tenancy" -> Tenancy.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplatePlacement]
    }
  }

  /**
    * Describes the placement of an instance.
    */
  @js.native
  trait LaunchTemplatePlacementRequest extends js.Object {
    var Affinity: js.UndefOr[String]
    var AvailabilityZone: js.UndefOr[String]
    var GroupName: js.UndefOr[String]
    var HostId: js.UndefOr[String]
    var SpreadDomain: js.UndefOr[String]
    var Tenancy: js.UndefOr[Tenancy]
  }

  object LaunchTemplatePlacementRequest {
    def apply(
        Affinity: js.UndefOr[String] = js.undefined,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined,
        HostId: js.UndefOr[String] = js.undefined,
        SpreadDomain: js.UndefOr[String] = js.undefined,
        Tenancy: js.UndefOr[Tenancy] = js.undefined
    ): LaunchTemplatePlacementRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Affinity" -> Affinity.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupName" -> GroupName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostId" -> HostId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpreadDomain" -> SpreadDomain.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tenancy" -> Tenancy.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplatePlacementRequest]
    }
  }

  /**
    * The launch template to use. You must specify either the launch template ID or launch template name in the request, but not both.
    */
  @js.native
  trait LaunchTemplateSpecification extends js.Object {
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[String]
    var Version: js.UndefOr[String]
  }

  object LaunchTemplateSpecification {
    def apply(
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[String] = js.undefined,
        Version: js.UndefOr[String] = js.undefined
    ): LaunchTemplateSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplateId" -> LaunchTemplateId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateName" -> LaunchTemplateName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Version" -> Version.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateSpecification]
    }
  }

  /**
    * The options for Spot Instances.
    */
  @js.native
  trait LaunchTemplateSpotMarketOptions extends js.Object {
    var BlockDurationMinutes: js.UndefOr[Int]
    var InstanceInterruptionBehavior: js.UndefOr[InstanceInterruptionBehavior]
    var MaxPrice: js.UndefOr[String]
    var SpotInstanceType: js.UndefOr[SpotInstanceType]
    var ValidUntil: js.UndefOr[DateTime]
  }

  object LaunchTemplateSpotMarketOptions {
    def apply(
        BlockDurationMinutes: js.UndefOr[Int] = js.undefined,
        InstanceInterruptionBehavior: js.UndefOr[InstanceInterruptionBehavior] = js.undefined,
        MaxPrice: js.UndefOr[String] = js.undefined,
        SpotInstanceType: js.UndefOr[SpotInstanceType] = js.undefined,
        ValidUntil: js.UndefOr[DateTime] = js.undefined
    ): LaunchTemplateSpotMarketOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "BlockDurationMinutes" -> BlockDurationMinutes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceInterruptionBehavior" -> InstanceInterruptionBehavior.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxPrice" -> MaxPrice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotInstanceType" -> SpotInstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ValidUntil" -> ValidUntil.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateSpotMarketOptions]
    }
  }

  /**
    * The options for Spot Instances.
    */
  @js.native
  trait LaunchTemplateSpotMarketOptionsRequest extends js.Object {
    var BlockDurationMinutes: js.UndefOr[Int]
    var InstanceInterruptionBehavior: js.UndefOr[InstanceInterruptionBehavior]
    var MaxPrice: js.UndefOr[String]
    var SpotInstanceType: js.UndefOr[SpotInstanceType]
    var ValidUntil: js.UndefOr[DateTime]
  }

  object LaunchTemplateSpotMarketOptionsRequest {
    def apply(
        BlockDurationMinutes: js.UndefOr[Int] = js.undefined,
        InstanceInterruptionBehavior: js.UndefOr[InstanceInterruptionBehavior] = js.undefined,
        MaxPrice: js.UndefOr[String] = js.undefined,
        SpotInstanceType: js.UndefOr[SpotInstanceType] = js.undefined,
        ValidUntil: js.UndefOr[DateTime] = js.undefined
    ): LaunchTemplateSpotMarketOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "BlockDurationMinutes" -> BlockDurationMinutes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceInterruptionBehavior" -> InstanceInterruptionBehavior.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MaxPrice" -> MaxPrice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpotInstanceType" -> SpotInstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ValidUntil" -> ValidUntil.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateSpotMarketOptionsRequest]
    }
  }

  /**
    * The tag specification for the launch template.
    */
  @js.native
  trait LaunchTemplateTagSpecification extends js.Object {
    var ResourceType: js.UndefOr[ResourceType]
    var Tags: js.UndefOr[TagList]
  }

  object LaunchTemplateTagSpecification {
    def apply(
        ResourceType: js.UndefOr[ResourceType] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): LaunchTemplateTagSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ResourceType" -> ResourceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateTagSpecification]
    }
  }

  /**
    * The tags specification for the launch template.
    */
  @js.native
  trait LaunchTemplateTagSpecificationRequest extends js.Object {
    var ResourceType: js.UndefOr[ResourceType]
    var Tags: js.UndefOr[TagList]
  }

  object LaunchTemplateTagSpecificationRequest {
    def apply(
        ResourceType: js.UndefOr[ResourceType] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): LaunchTemplateTagSpecificationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ResourceType" -> ResourceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateTagSpecificationRequest]
    }
  }

  /**
    * Describes a launch template version.
    */
  @js.native
  trait LaunchTemplateVersion extends js.Object {
    var CreateTime: js.UndefOr[DateTime]
    var CreatedBy: js.UndefOr[String]
    var DefaultVersion: js.UndefOr[Boolean]
    var LaunchTemplateData: js.UndefOr[ResponseLaunchTemplateData]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
    var VersionDescription: js.UndefOr[VersionDescription]
    var VersionNumber: js.UndefOr[Double]
  }

  object LaunchTemplateVersion {
    def apply(
        CreateTime: js.UndefOr[DateTime] = js.undefined,
        CreatedBy: js.UndefOr[String] = js.undefined,
        DefaultVersion: js.UndefOr[Boolean] = js.undefined,
        LaunchTemplateData: js.UndefOr[ResponseLaunchTemplateData] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined,
        VersionDescription: js.UndefOr[VersionDescription] = js.undefined,
        VersionNumber: js.UndefOr[Double] = js.undefined
    ): LaunchTemplateVersion = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CreateTime" -> CreateTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CreatedBy" -> CreatedBy.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DefaultVersion" -> DefaultVersion.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateData" -> LaunchTemplateData.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateId" -> LaunchTemplateId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateName" -> LaunchTemplateName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VersionDescription" -> VersionDescription.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VersionNumber" -> VersionNumber.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplateVersion]
    }
  }

  /**
    * Describes the monitoring for the instance.
    */
  @js.native
  trait LaunchTemplatesMonitoring extends js.Object {
    var Enabled: js.UndefOr[Boolean]
  }

  object LaunchTemplatesMonitoring {
    def apply(
        Enabled: js.UndefOr[Boolean] = js.undefined
    ): LaunchTemplatesMonitoring = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Enabled" -> Enabled.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplatesMonitoring]
    }
  }

  /**
    * Describes the monitoring for the instance.
    */
  @js.native
  trait LaunchTemplatesMonitoringRequest extends js.Object {
    var Enabled: js.UndefOr[Boolean]
  }

  object LaunchTemplatesMonitoringRequest {
    def apply(
        Enabled: js.UndefOr[Boolean] = js.undefined
    ): LaunchTemplatesMonitoringRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Enabled" -> Enabled.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LaunchTemplatesMonitoringRequest]
    }
  }

  /**
    * Describes a license configuration.
    */
  @js.native
  trait LicenseConfiguration extends js.Object {
    var LicenseConfigurationArn: js.UndefOr[String]
  }

  object LicenseConfiguration {
    def apply(
        LicenseConfigurationArn: js.UndefOr[String] = js.undefined
    ): LicenseConfiguration = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LicenseConfigurationArn" -> LicenseConfigurationArn.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LicenseConfiguration]
    }
  }

  /**
    * Describes a license configuration.
    */
  @js.native
  trait LicenseConfigurationRequest extends js.Object {
    var LicenseConfigurationArn: js.UndefOr[String]
  }

  object LicenseConfigurationRequest {
    def apply(
        LicenseConfigurationArn: js.UndefOr[String] = js.undefined
    ): LicenseConfigurationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LicenseConfigurationArn" -> LicenseConfigurationArn.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LicenseConfigurationRequest]
    }
  }

  object ListingStateEnum {
    val available = "available"
    val sold      = "sold"
    val cancelled = "cancelled"
    val pending   = "pending"

    val values = IndexedSeq(available, sold, cancelled, pending)
  }

  object ListingStatusEnum {
    val active    = "active"
    val pending   = "pending"
    val cancelled = "cancelled"
    val closed    = "closed"

    val values = IndexedSeq(active, pending, cancelled, closed)
  }

  /**
    * Describes the Classic Load Balancers and target groups to attach to a Spot Fleet request.
    */
  @js.native
  trait LoadBalancersConfig extends js.Object {
    var ClassicLoadBalancersConfig: js.UndefOr[ClassicLoadBalancersConfig]
    var TargetGroupsConfig: js.UndefOr[TargetGroupsConfig]
  }

  object LoadBalancersConfig {
    def apply(
        ClassicLoadBalancersConfig: js.UndefOr[ClassicLoadBalancersConfig] = js.undefined,
        TargetGroupsConfig: js.UndefOr[TargetGroupsConfig] = js.undefined
    ): LoadBalancersConfig = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClassicLoadBalancersConfig" -> ClassicLoadBalancersConfig.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TargetGroupsConfig" -> TargetGroupsConfig.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LoadBalancersConfig]
    }
  }

  /**
    * Describes a load permission.
    */
  @js.native
  trait LoadPermission extends js.Object {
    var Group: js.UndefOr[PermissionGroup]
    var UserId: js.UndefOr[String]
  }

  object LoadPermission {
    def apply(
        Group: js.UndefOr[PermissionGroup] = js.undefined,
        UserId: js.UndefOr[String] = js.undefined
    ): LoadPermission = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Group" -> Group.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserId" -> UserId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LoadPermission]
    }
  }

  /**
    * Describes modifications to the load permissions of an Amazon FPGA image (AFI).
    */
  @js.native
  trait LoadPermissionModifications extends js.Object {
    var Add: js.UndefOr[LoadPermissionListRequest]
    var Remove: js.UndefOr[LoadPermissionListRequest]
  }

  object LoadPermissionModifications {
    def apply(
        Add: js.UndefOr[LoadPermissionListRequest] = js.undefined,
        Remove: js.UndefOr[LoadPermissionListRequest] = js.undefined
    ): LoadPermissionModifications = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Add" -> Add.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Remove" -> Remove.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LoadPermissionModifications]
    }
  }

  /**
    * Describes a load permission.
    */
  @js.native
  trait LoadPermissionRequest extends js.Object {
    var Group: js.UndefOr[PermissionGroup]
    var UserId: js.UndefOr[String]
  }

  object LoadPermissionRequest {
    def apply(
        Group: js.UndefOr[PermissionGroup] = js.undefined,
        UserId: js.UndefOr[String] = js.undefined
    ): LoadPermissionRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Group" -> Group.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserId" -> UserId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[LoadPermissionRequest]
    }
  }

  object LogDestinationTypeEnum {
    val `cloud-watch-logs` = "cloud-watch-logs"
    val s3                 = "s3"

    val values = IndexedSeq(`cloud-watch-logs`, s3)
  }

  object MarketTypeEnum {
    val spot = "spot"

    val values = IndexedSeq(spot)
  }

  @js.native
  trait ModifyCapacityReservationRequest extends js.Object {
    var CapacityReservationId: String
    var DryRun: js.UndefOr[Boolean]
    var EndDate: js.UndefOr[DateTime]
    var EndDateType: js.UndefOr[EndDateType]
    var InstanceCount: js.UndefOr[Int]
  }

  object ModifyCapacityReservationRequest {
    def apply(
        CapacityReservationId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EndDate: js.UndefOr[DateTime] = js.undefined,
        EndDateType: js.UndefOr[EndDateType] = js.undefined,
        InstanceCount: js.UndefOr[Int] = js.undefined
    ): ModifyCapacityReservationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CapacityReservationId" -> CapacityReservationId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EndDate" -> EndDate.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EndDateType" -> EndDateType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceCount" -> InstanceCount.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyCapacityReservationRequest]
    }
  }

  @js.native
  trait ModifyCapacityReservationResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyCapacityReservationResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyCapacityReservationResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyCapacityReservationResult]
    }
  }

  @js.native
  trait ModifyClientVpnEndpointRequest extends js.Object {
    var ClientVpnEndpointId: String
    var ConnectionLogOptions: js.UndefOr[ConnectionLogOptions]
    var Description: js.UndefOr[String]
    var DnsServers: js.UndefOr[DnsServersOptionsModifyStructure]
    var DryRun: js.UndefOr[Boolean]
    var ServerCertificateArn: js.UndefOr[String]
  }

  object ModifyClientVpnEndpointRequest {
    def apply(
        ClientVpnEndpointId: String,
        ConnectionLogOptions: js.UndefOr[ConnectionLogOptions] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DnsServers: js.UndefOr[DnsServersOptionsModifyStructure] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ServerCertificateArn: js.UndefOr[String] = js.undefined
    ): ModifyClientVpnEndpointRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "ConnectionLogOptions" -> ConnectionLogOptions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DnsServers" -> DnsServers.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ServerCertificateArn" -> ServerCertificateArn.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyClientVpnEndpointRequest]
    }
  }

  @js.native
  trait ModifyClientVpnEndpointResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyClientVpnEndpointResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyClientVpnEndpointResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyClientVpnEndpointResult]
    }
  }

  @js.native
  trait ModifyFleetRequest extends js.Object {
    var FleetId: FleetIdentifier
    var TargetCapacitySpecification: TargetCapacitySpecificationRequest
    var DryRun: js.UndefOr[Boolean]
    var ExcessCapacityTerminationPolicy: js.UndefOr[FleetExcessCapacityTerminationPolicy]
  }

  object ModifyFleetRequest {
    def apply(
        FleetId: FleetIdentifier,
        TargetCapacitySpecification: TargetCapacitySpecificationRequest,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ExcessCapacityTerminationPolicy: js.UndefOr[FleetExcessCapacityTerminationPolicy] = js.undefined
    ): ModifyFleetRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FleetId"                     -> FleetId.asInstanceOf[js.Any],
        "TargetCapacitySpecification" -> TargetCapacitySpecification.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ExcessCapacityTerminationPolicy" -> ExcessCapacityTerminationPolicy.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyFleetRequest]
    }
  }

  @js.native
  trait ModifyFleetResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyFleetResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyFleetResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyFleetResult]
    }
  }

  @js.native
  trait ModifyFpgaImageAttributeRequest extends js.Object {
    var FpgaImageId: String
    var Attribute: js.UndefOr[FpgaImageAttributeName]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var LoadPermission: js.UndefOr[LoadPermissionModifications]
    var Name: js.UndefOr[String]
    var OperationType: js.UndefOr[OperationType]
    var ProductCodes: js.UndefOr[ProductCodeStringList]
    var UserGroups: js.UndefOr[UserGroupStringList]
    var UserIds: js.UndefOr[UserIdStringList]
  }

  object ModifyFpgaImageAttributeRequest {
    def apply(
        FpgaImageId: String,
        Attribute: js.UndefOr[FpgaImageAttributeName] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LoadPermission: js.UndefOr[LoadPermissionModifications] = js.undefined,
        Name: js.UndefOr[String] = js.undefined,
        OperationType: js.UndefOr[OperationType] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeStringList] = js.undefined,
        UserGroups: js.UndefOr[UserGroupStringList] = js.undefined,
        UserIds: js.UndefOr[UserIdStringList] = js.undefined
    ): ModifyFpgaImageAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FpgaImageId" -> FpgaImageId.asInstanceOf[js.Any],
        "Attribute" -> Attribute.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LoadPermission" -> LoadPermission.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Name" -> Name.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OperationType" -> OperationType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductCodes" -> ProductCodes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserGroups" -> UserGroups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserIds" -> UserIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyFpgaImageAttributeRequest]
    }
  }

  @js.native
  trait ModifyFpgaImageAttributeResult extends js.Object {
    var FpgaImageAttribute: js.UndefOr[FpgaImageAttribute]
  }

  object ModifyFpgaImageAttributeResult {
    def apply(
        FpgaImageAttribute: js.UndefOr[FpgaImageAttribute] = js.undefined
    ): ModifyFpgaImageAttributeResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "FpgaImageAttribute" -> FpgaImageAttribute.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyFpgaImageAttributeResult]
    }
  }

  @js.native
  trait ModifyHostsRequest extends js.Object {
    var AutoPlacement: AutoPlacement
    var HostIds: RequestHostIdList
  }

  object ModifyHostsRequest {
    def apply(
        AutoPlacement: AutoPlacement,
        HostIds: RequestHostIdList
    ): ModifyHostsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AutoPlacement" -> AutoPlacement.asInstanceOf[js.Any],
        "HostIds"       -> HostIds.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyHostsRequest]
    }
  }

  @js.native
  trait ModifyHostsResult extends js.Object {
    var Successful: js.UndefOr[ResponseHostIdList]
    var Unsuccessful: js.UndefOr[UnsuccessfulItemList]
  }

  object ModifyHostsResult {
    def apply(
        Successful: js.UndefOr[ResponseHostIdList] = js.undefined,
        Unsuccessful: js.UndefOr[UnsuccessfulItemList] = js.undefined
    ): ModifyHostsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Successful" -> Successful.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Unsuccessful" -> Unsuccessful.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyHostsResult]
    }
  }

  @js.native
  trait ModifyIdFormatRequest extends js.Object {
    var Resource: String
    var UseLongIds: Boolean
  }

  object ModifyIdFormatRequest {
    def apply(
        Resource: String,
        UseLongIds: Boolean
    ): ModifyIdFormatRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Resource"   -> Resource.asInstanceOf[js.Any],
        "UseLongIds" -> UseLongIds.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyIdFormatRequest]
    }
  }

  @js.native
  trait ModifyIdentityIdFormatRequest extends js.Object {
    var PrincipalArn: String
    var Resource: String
    var UseLongIds: Boolean
  }

  object ModifyIdentityIdFormatRequest {
    def apply(
        PrincipalArn: String,
        Resource: String,
        UseLongIds: Boolean
    ): ModifyIdentityIdFormatRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "PrincipalArn" -> PrincipalArn.asInstanceOf[js.Any],
        "Resource"     -> Resource.asInstanceOf[js.Any],
        "UseLongIds"   -> UseLongIds.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyIdentityIdFormatRequest]
    }
  }

  /**
    * Contains the parameters for ModifyImageAttribute.
    */
  @js.native
  trait ModifyImageAttributeRequest extends js.Object {
    var ImageId: String
    var Attribute: js.UndefOr[String]
    var Description: js.UndefOr[AttributeValue]
    var DryRun: js.UndefOr[Boolean]
    var LaunchPermission: js.UndefOr[LaunchPermissionModifications]
    var OperationType: js.UndefOr[OperationType]
    var ProductCodes: js.UndefOr[ProductCodeStringList]
    var UserGroups: js.UndefOr[UserGroupStringList]
    var UserIds: js.UndefOr[UserIdStringList]
    var Value: js.UndefOr[String]
  }

  object ModifyImageAttributeRequest {
    def apply(
        ImageId: String,
        Attribute: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[AttributeValue] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LaunchPermission: js.UndefOr[LaunchPermissionModifications] = js.undefined,
        OperationType: js.UndefOr[OperationType] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeStringList] = js.undefined,
        UserGroups: js.UndefOr[UserGroupStringList] = js.undefined,
        UserIds: js.UndefOr[UserIdStringList] = js.undefined,
        Value: js.UndefOr[String] = js.undefined
    ): ModifyImageAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ImageId" -> ImageId.asInstanceOf[js.Any],
        "Attribute" -> Attribute.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchPermission" -> LaunchPermission.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OperationType" -> OperationType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductCodes" -> ProductCodes.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserGroups" -> UserGroups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserIds" -> UserIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Value" -> Value.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyImageAttributeRequest]
    }
  }

  @js.native
  trait ModifyInstanceAttributeRequest extends js.Object {
    var InstanceId: String
    var Attribute: js.UndefOr[InstanceAttributeName]
    var BlockDeviceMappings: js.UndefOr[InstanceBlockDeviceMappingSpecificationList]
    var DisableApiTermination: js.UndefOr[AttributeBooleanValue]
    var DryRun: js.UndefOr[Boolean]
    var EbsOptimized: js.UndefOr[AttributeBooleanValue]
    var EnaSupport: js.UndefOr[AttributeBooleanValue]
    var Groups: js.UndefOr[GroupIdStringList]
    var InstanceInitiatedShutdownBehavior: js.UndefOr[AttributeValue]
    var InstanceType: js.UndefOr[AttributeValue]
    var Kernel: js.UndefOr[AttributeValue]
    var Ramdisk: js.UndefOr[AttributeValue]
    var SourceDestCheck: js.UndefOr[AttributeBooleanValue]
    var SriovNetSupport: js.UndefOr[AttributeValue]
    var UserData: js.UndefOr[BlobAttributeValue]
    var Value: js.UndefOr[String]
  }

  object ModifyInstanceAttributeRequest {
    def apply(
        InstanceId: String,
        Attribute: js.UndefOr[InstanceAttributeName] = js.undefined,
        BlockDeviceMappings: js.UndefOr[InstanceBlockDeviceMappingSpecificationList] = js.undefined,
        DisableApiTermination: js.UndefOr[AttributeBooleanValue] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EbsOptimized: js.UndefOr[AttributeBooleanValue] = js.undefined,
        EnaSupport: js.UndefOr[AttributeBooleanValue] = js.undefined,
        Groups: js.UndefOr[GroupIdStringList] = js.undefined,
        InstanceInitiatedShutdownBehavior: js.UndefOr[AttributeValue] = js.undefined,
        InstanceType: js.UndefOr[AttributeValue] = js.undefined,
        Kernel: js.UndefOr[AttributeValue] = js.undefined,
        Ramdisk: js.UndefOr[AttributeValue] = js.undefined,
        SourceDestCheck: js.UndefOr[AttributeBooleanValue] = js.undefined,
        SriovNetSupport: js.UndefOr[AttributeValue] = js.undefined,
        UserData: js.UndefOr[BlobAttributeValue] = js.undefined,
        Value: js.UndefOr[String] = js.undefined
    ): ModifyInstanceAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "Attribute" -> Attribute.map { x =>
          x.asInstanceOf[js.Any]
        },
        "BlockDeviceMappings" -> BlockDeviceMappings.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DisableApiTermination" -> DisableApiTermination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EbsOptimized" -> EbsOptimized.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EnaSupport" -> EnaSupport.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Groups" -> Groups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceInitiatedShutdownBehavior" -> InstanceInitiatedShutdownBehavior.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceType" -> InstanceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Kernel" -> Kernel.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ramdisk" -> Ramdisk.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SourceDestCheck" -> SourceDestCheck.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SriovNetSupport" -> SriovNetSupport.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserData" -> UserData.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Value" -> Value.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyInstanceAttributeRequest]
    }
  }

  @js.native
  trait ModifyInstanceCapacityReservationAttributesRequest extends js.Object {
    var CapacityReservationSpecification: CapacityReservationSpecification
    var InstanceId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyInstanceCapacityReservationAttributesRequest {
    def apply(
        CapacityReservationSpecification: CapacityReservationSpecification,
        InstanceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyInstanceCapacityReservationAttributesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CapacityReservationSpecification" -> CapacityReservationSpecification.asInstanceOf[js.Any],
        "InstanceId"                       -> InstanceId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ModifyInstanceCapacityReservationAttributesRequest]
    }
  }

  @js.native
  trait ModifyInstanceCapacityReservationAttributesResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyInstanceCapacityReservationAttributesResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyInstanceCapacityReservationAttributesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ModifyInstanceCapacityReservationAttributesResult]
    }
  }

  @js.native
  trait ModifyInstanceCreditSpecificationRequest extends js.Object {
    var InstanceCreditSpecifications: InstanceCreditSpecificationListRequest
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyInstanceCreditSpecificationRequest {
    def apply(
        InstanceCreditSpecifications: InstanceCreditSpecificationListRequest,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyInstanceCreditSpecificationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceCreditSpecifications" -> InstanceCreditSpecifications.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyInstanceCreditSpecificationRequest]
    }
  }

  @js.native
  trait ModifyInstanceCreditSpecificationResult extends js.Object {
    var SuccessfulInstanceCreditSpecifications: js.UndefOr[SuccessfulInstanceCreditSpecificationSet]
    var UnsuccessfulInstanceCreditSpecifications: js.UndefOr[UnsuccessfulInstanceCreditSpecificationSet]
  }

  object ModifyInstanceCreditSpecificationResult {
    def apply(
        SuccessfulInstanceCreditSpecifications: js.UndefOr[SuccessfulInstanceCreditSpecificationSet] = js.undefined,
        UnsuccessfulInstanceCreditSpecifications: js.UndefOr[UnsuccessfulInstanceCreditSpecificationSet] = js.undefined
    ): ModifyInstanceCreditSpecificationResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SuccessfulInstanceCreditSpecifications" -> SuccessfulInstanceCreditSpecifications.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UnsuccessfulInstanceCreditSpecifications" -> UnsuccessfulInstanceCreditSpecifications.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyInstanceCreditSpecificationResult]
    }
  }

  @js.native
  trait ModifyInstanceEventStartTimeRequest extends js.Object {
    var InstanceEventId: String
    var InstanceId: String
    var NotBefore: DateTime
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyInstanceEventStartTimeRequest {
    def apply(
        InstanceEventId: String,
        InstanceId: String,
        NotBefore: DateTime,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyInstanceEventStartTimeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceEventId" -> InstanceEventId.asInstanceOf[js.Any],
        "InstanceId"      -> InstanceId.asInstanceOf[js.Any],
        "NotBefore"       -> NotBefore.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyInstanceEventStartTimeRequest]
    }
  }

  @js.native
  trait ModifyInstanceEventStartTimeResult extends js.Object {
    var Event: js.UndefOr[InstanceStatusEvent]
  }

  object ModifyInstanceEventStartTimeResult {
    def apply(
        Event: js.UndefOr[InstanceStatusEvent] = js.undefined
    ): ModifyInstanceEventStartTimeResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Event" -> Event.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyInstanceEventStartTimeResult]
    }
  }

  @js.native
  trait ModifyInstancePlacementRequest extends js.Object {
    var InstanceId: String
    var Affinity: js.UndefOr[Affinity]
    var GroupName: js.UndefOr[String]
    var HostId: js.UndefOr[String]
    var PartitionNumber: js.UndefOr[Int]
    var Tenancy: js.UndefOr[HostTenancy]
  }

  object ModifyInstancePlacementRequest {
    def apply(
        InstanceId: String,
        Affinity: js.UndefOr[Affinity] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined,
        HostId: js.UndefOr[String] = js.undefined,
        PartitionNumber: js.UndefOr[Int] = js.undefined,
        Tenancy: js.UndefOr[HostTenancy] = js.undefined
    ): ModifyInstancePlacementRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "Affinity" -> Affinity.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupName" -> GroupName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostId" -> HostId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PartitionNumber" -> PartitionNumber.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tenancy" -> Tenancy.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyInstancePlacementRequest]
    }
  }

  @js.native
  trait ModifyInstancePlacementResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyInstancePlacementResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyInstancePlacementResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyInstancePlacementResult]
    }
  }

  @js.native
  trait ModifyLaunchTemplateRequest extends js.Object {
    var ClientToken: js.UndefOr[String]
    var DefaultVersion: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
  }

  object ModifyLaunchTemplateRequest {
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        DefaultVersion: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined
    ): ModifyLaunchTemplateRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DefaultVersion" -> DefaultVersion.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateId" -> LaunchTemplateId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LaunchTemplateName" -> LaunchTemplateName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyLaunchTemplateRequest]
    }
  }

  @js.native
  trait ModifyLaunchTemplateResult extends js.Object {
    var LaunchTemplate: js.UndefOr[LaunchTemplate]
  }

  object ModifyLaunchTemplateResult {
    def apply(
        LaunchTemplate: js.UndefOr[LaunchTemplate] = js.undefined
    ): ModifyLaunchTemplateResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "LaunchTemplate" -> LaunchTemplate.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyLaunchTemplateResult]
    }
  }

  /**
    * Contains the parameters for ModifyNetworkInterfaceAttribute.
    */
  @js.native
  trait ModifyNetworkInterfaceAttributeRequest extends js.Object {
    var NetworkInterfaceId: String
    var Attachment: js.UndefOr[NetworkInterfaceAttachmentChanges]
    var Description: js.UndefOr[AttributeValue]
    var DryRun: js.UndefOr[Boolean]
    var Groups: js.UndefOr[SecurityGroupIdStringList]
    var SourceDestCheck: js.UndefOr[AttributeBooleanValue]
  }

  object ModifyNetworkInterfaceAttributeRequest {
    def apply(
        NetworkInterfaceId: String,
        Attachment: js.UndefOr[NetworkInterfaceAttachmentChanges] = js.undefined,
        Description: js.UndefOr[AttributeValue] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Groups: js.UndefOr[SecurityGroupIdStringList] = js.undefined,
        SourceDestCheck: js.UndefOr[AttributeBooleanValue] = js.undefined
    ): ModifyNetworkInterfaceAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any],
        "Attachment" -> Attachment.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Groups" -> Groups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SourceDestCheck" -> SourceDestCheck.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyNetworkInterfaceAttributeRequest]
    }
  }

  /**
    * Contains the parameters for ModifyReservedInstances.
    */
  @js.native
  trait ModifyReservedInstancesRequest extends js.Object {
    var ReservedInstancesIds: ReservedInstancesIdStringList
    var TargetConfigurations: ReservedInstancesConfigurationList
    var ClientToken: js.UndefOr[String]
  }

  object ModifyReservedInstancesRequest {
    def apply(
        ReservedInstancesIds: ReservedInstancesIdStringList,
        TargetConfigurations: ReservedInstancesConfigurationList,
        ClientToken: js.UndefOr[String] = js.undefined
    ): ModifyReservedInstancesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReservedInstancesIds" -> ReservedInstancesIds.asInstanceOf[js.Any],
        "TargetConfigurations" -> TargetConfigurations.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyReservedInstancesRequest]
    }
  }

  /**
    * Contains the output of ModifyReservedInstances.
    */
  @js.native
  trait ModifyReservedInstancesResult extends js.Object {
    var ReservedInstancesModificationId: js.UndefOr[String]
  }

  object ModifyReservedInstancesResult {
    def apply(
        ReservedInstancesModificationId: js.UndefOr[String] = js.undefined
    ): ModifyReservedInstancesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReservedInstancesModificationId" -> ReservedInstancesModificationId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyReservedInstancesResult]
    }
  }

  /**
    * Contains the parameters for ModifySnapshotAttribute.
    */
  @js.native
  trait ModifySnapshotAttributeRequest extends js.Object {
    var SnapshotId: String
    var Attribute: js.UndefOr[SnapshotAttributeName]
    var CreateVolumePermission: js.UndefOr[CreateVolumePermissionModifications]
    var DryRun: js.UndefOr[Boolean]
    var GroupNames: js.UndefOr[GroupNameStringList]
    var OperationType: js.UndefOr[OperationType]
    var UserIds: js.UndefOr[UserIdStringList]
  }

  object ModifySnapshotAttributeRequest {
    def apply(
        SnapshotId: String,
        Attribute: js.UndefOr[SnapshotAttributeName] = js.undefined,
        CreateVolumePermission: js.UndefOr[CreateVolumePermissionModifications] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        GroupNames: js.UndefOr[GroupNameStringList] = js.undefined,
        OperationType: js.UndefOr[OperationType] = js.undefined,
        UserIds: js.UndefOr[UserIdStringList] = js.undefined
    ): ModifySnapshotAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SnapshotId" -> SnapshotId.asInstanceOf[js.Any],
        "Attribute" -> Attribute.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CreateVolumePermission" -> CreateVolumePermission.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupNames" -> GroupNames.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OperationType" -> OperationType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UserIds" -> UserIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifySnapshotAttributeRequest]
    }
  }

  /**
    * Contains the parameters for ModifySpotFleetRequest.
    */
  @js.native
  trait ModifySpotFleetRequestRequest extends js.Object {
    var SpotFleetRequestId: String
    var ExcessCapacityTerminationPolicy: js.UndefOr[ExcessCapacityTerminationPolicy]
    var TargetCapacity: js.UndefOr[Int]
  }

  object ModifySpotFleetRequestRequest {
    def apply(
        SpotFleetRequestId: String,
        ExcessCapacityTerminationPolicy: js.UndefOr[ExcessCapacityTerminationPolicy] = js.undefined,
        TargetCapacity: js.UndefOr[Int] = js.undefined
    ): ModifySpotFleetRequestRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SpotFleetRequestId" -> SpotFleetRequestId.asInstanceOf[js.Any],
        "ExcessCapacityTerminationPolicy" -> ExcessCapacityTerminationPolicy.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TargetCapacity" -> TargetCapacity.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifySpotFleetRequestRequest]
    }
  }

  /**
    * Contains the output of ModifySpotFleetRequest.
    */
  @js.native
  trait ModifySpotFleetRequestResponse extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifySpotFleetRequestResponse {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifySpotFleetRequestResponse = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifySpotFleetRequestResponse]
    }
  }

  @js.native
  trait ModifySubnetAttributeRequest extends js.Object {
    var SubnetId: String
    var AssignIpv6AddressOnCreation: js.UndefOr[AttributeBooleanValue]
    var MapPublicIpOnLaunch: js.UndefOr[AttributeBooleanValue]
  }

  object ModifySubnetAttributeRequest {
    def apply(
        SubnetId: String,
        AssignIpv6AddressOnCreation: js.UndefOr[AttributeBooleanValue] = js.undefined,
        MapPublicIpOnLaunch: js.UndefOr[AttributeBooleanValue] = js.undefined
    ): ModifySubnetAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "SubnetId" -> SubnetId.asInstanceOf[js.Any],
        "AssignIpv6AddressOnCreation" -> AssignIpv6AddressOnCreation.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MapPublicIpOnLaunch" -> MapPublicIpOnLaunch.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifySubnetAttributeRequest]
    }
  }

  @js.native
  trait ModifyTransitGatewayVpcAttachmentRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var AddSubnetIds: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var Options: js.UndefOr[ModifyTransitGatewayVpcAttachmentRequestOptions]
    var RemoveSubnetIds: js.UndefOr[ValueStringList]
  }

  object ModifyTransitGatewayVpcAttachmentRequest {
    def apply(
        TransitGatewayAttachmentId: String,
        AddSubnetIds: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Options: js.UndefOr[ModifyTransitGatewayVpcAttachmentRequestOptions] = js.undefined,
        RemoveSubnetIds: js.UndefOr[ValueStringList] = js.undefined
    ): ModifyTransitGatewayVpcAttachmentRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any],
        "AddSubnetIds" -> AddSubnetIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Options" -> Options.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RemoveSubnetIds" -> RemoveSubnetIds.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyTransitGatewayVpcAttachmentRequest]
    }
  }

  /**
    * Describes the options for a VPC attachment.
    */
  @js.native
  trait ModifyTransitGatewayVpcAttachmentRequestOptions extends js.Object {
    var DnsSupport: js.UndefOr[DnsSupportValue]
    var Ipv6Support: js.UndefOr[Ipv6SupportValue]
  }

  object ModifyTransitGatewayVpcAttachmentRequestOptions {
    def apply(
        DnsSupport: js.UndefOr[DnsSupportValue] = js.undefined,
        Ipv6Support: js.UndefOr[Ipv6SupportValue] = js.undefined
    ): ModifyTransitGatewayVpcAttachmentRequestOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DnsSupport" -> DnsSupport.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6Support" -> Ipv6Support.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ModifyTransitGatewayVpcAttachmentRequestOptions]
    }
  }

  @js.native
  trait ModifyTransitGatewayVpcAttachmentResult extends js.Object {
    var TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment]
  }

  object ModifyTransitGatewayVpcAttachmentResult {
    def apply(
        TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment] = js.undefined
    ): ModifyTransitGatewayVpcAttachmentResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "TransitGatewayVpcAttachment" -> TransitGatewayVpcAttachment.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyTransitGatewayVpcAttachmentResult]
    }
  }

  /**
    * Contains the parameters for ModifyVolumeAttribute.
    */
  @js.native
  trait ModifyVolumeAttributeRequest extends js.Object {
    var VolumeId: String
    var AutoEnableIO: js.UndefOr[AttributeBooleanValue]
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyVolumeAttributeRequest {
    def apply(
        VolumeId: String,
        AutoEnableIO: js.UndefOr[AttributeBooleanValue] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyVolumeAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VolumeId" -> VolumeId.asInstanceOf[js.Any],
        "AutoEnableIO" -> AutoEnableIO.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyVolumeAttributeRequest]
    }
  }

  @js.native
  trait ModifyVolumeRequest extends js.Object {
    var VolumeId: String
    var DryRun: js.UndefOr[Boolean]
    var Iops: js.UndefOr[Int]
    var Size: js.UndefOr[Int]
    var VolumeType: js.UndefOr[VolumeType]
  }

  object ModifyVolumeRequest {
    def apply(
        VolumeId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Iops: js.UndefOr[Int] = js.undefined,
        Size: js.UndefOr[Int] = js.undefined,
        VolumeType: js.UndefOr[VolumeType] = js.undefined
    ): ModifyVolumeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VolumeId" -> VolumeId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Iops" -> Iops.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Size" -> Size.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VolumeType" -> VolumeType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyVolumeRequest]
    }
  }

  @js.native
  trait ModifyVolumeResult extends js.Object {
    var VolumeModification: js.UndefOr[VolumeModification]
  }

  object ModifyVolumeResult {
    def apply(
        VolumeModification: js.UndefOr[VolumeModification] = js.undefined
    ): ModifyVolumeResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VolumeModification" -> VolumeModification.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyVolumeResult]
    }
  }

  @js.native
  trait ModifyVpcAttributeRequest extends js.Object {
    var VpcId: String
    var EnableDnsHostnames: js.UndefOr[AttributeBooleanValue]
    var EnableDnsSupport: js.UndefOr[AttributeBooleanValue]
  }

  object ModifyVpcAttributeRequest {
    def apply(
        VpcId: String,
        EnableDnsHostnames: js.UndefOr[AttributeBooleanValue] = js.undefined,
        EnableDnsSupport: js.UndefOr[AttributeBooleanValue] = js.undefined
    ): ModifyVpcAttributeRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcId" -> VpcId.asInstanceOf[js.Any],
        "EnableDnsHostnames" -> EnableDnsHostnames.map { x =>
          x.asInstanceOf[js.Any]
        },
        "EnableDnsSupport" -> EnableDnsSupport.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyVpcAttributeRequest]
    }
  }

  @js.native
  trait ModifyVpcEndpointConnectionNotificationRequest extends js.Object {
    var ConnectionNotificationId: String
    var ConnectionEvents: js.UndefOr[ValueStringList]
    var ConnectionNotificationArn: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyVpcEndpointConnectionNotificationRequest {
    def apply(
        ConnectionNotificationId: String,
        ConnectionEvents: js.UndefOr[ValueStringList] = js.undefined,
        ConnectionNotificationArn: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcEndpointConnectionNotificationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ConnectionNotificationId" -> ConnectionNotificationId.asInstanceOf[js.Any],
        "ConnectionEvents" -> ConnectionEvents.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ConnectionNotificationArn" -> ConnectionNotificationArn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ModifyVpcEndpointConnectionNotificationRequest]
    }
  }

  @js.native
  trait ModifyVpcEndpointConnectionNotificationResult extends js.Object {
    var ReturnValue: js.UndefOr[Boolean]
  }

  object ModifyVpcEndpointConnectionNotificationResult {
    def apply(
        ReturnValue: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcEndpointConnectionNotificationResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReturnValue" -> ReturnValue.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ModifyVpcEndpointConnectionNotificationResult]
    }
  }

  /**
    * Contains the parameters for ModifyVpcEndpoint.
    */
  @js.native
  trait ModifyVpcEndpointRequest extends js.Object {
    var VpcEndpointId: String
    var AddRouteTableIds: js.UndefOr[ValueStringList]
    var AddSecurityGroupIds: js.UndefOr[ValueStringList]
    var AddSubnetIds: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var PolicyDocument: js.UndefOr[String]
    var PrivateDnsEnabled: js.UndefOr[Boolean]
    var RemoveRouteTableIds: js.UndefOr[ValueStringList]
    var RemoveSecurityGroupIds: js.UndefOr[ValueStringList]
    var RemoveSubnetIds: js.UndefOr[ValueStringList]
    var ResetPolicy: js.UndefOr[Boolean]
  }

  object ModifyVpcEndpointRequest {
    def apply(
        VpcEndpointId: String,
        AddRouteTableIds: js.UndefOr[ValueStringList] = js.undefined,
        AddSecurityGroupIds: js.UndefOr[ValueStringList] = js.undefined,
        AddSubnetIds: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PolicyDocument: js.UndefOr[String] = js.undefined,
        PrivateDnsEnabled: js.UndefOr[Boolean] = js.undefined,
        RemoveRouteTableIds: js.UndefOr[ValueStringList] = js.undefined,
        RemoveSecurityGroupIds: js.UndefOr[ValueStringList] = js.undefined,
        RemoveSubnetIds: js.UndefOr[ValueStringList] = js.undefined,
        ResetPolicy: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcEndpointRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcEndpointId" -> VpcEndpointId.asInstanceOf[js.Any],
        "AddRouteTableIds" -> AddRouteTableIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AddSecurityGroupIds" -> AddSecurityGroupIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AddSubnetIds" -> AddSubnetIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PolicyDocument" -> PolicyDocument.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateDnsEnabled" -> PrivateDnsEnabled.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RemoveRouteTableIds" -> RemoveRouteTableIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RemoveSecurityGroupIds" -> RemoveSecurityGroupIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RemoveSubnetIds" -> RemoveSubnetIds.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ResetPolicy" -> ResetPolicy.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyVpcEndpointRequest]
    }
  }

  @js.native
  trait ModifyVpcEndpointResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyVpcEndpointResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcEndpointResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyVpcEndpointResult]
    }
  }

  @js.native
  trait ModifyVpcEndpointServiceConfigurationRequest extends js.Object {
    var ServiceId: String
    var AcceptanceRequired: js.UndefOr[Boolean]
    var AddNetworkLoadBalancerArns: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var RemoveNetworkLoadBalancerArns: js.UndefOr[ValueStringList]
  }

  object ModifyVpcEndpointServiceConfigurationRequest {
    def apply(
        ServiceId: String,
        AcceptanceRequired: js.UndefOr[Boolean] = js.undefined,
        AddNetworkLoadBalancerArns: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        RemoveNetworkLoadBalancerArns: js.UndefOr[ValueStringList] = js.undefined
    ): ModifyVpcEndpointServiceConfigurationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ServiceId" -> ServiceId.asInstanceOf[js.Any],
        "AcceptanceRequired" -> AcceptanceRequired.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AddNetworkLoadBalancerArns" -> AddNetworkLoadBalancerArns.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RemoveNetworkLoadBalancerArns" -> RemoveNetworkLoadBalancerArns.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ModifyVpcEndpointServiceConfigurationRequest]
    }
  }

  @js.native
  trait ModifyVpcEndpointServiceConfigurationResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyVpcEndpointServiceConfigurationResult {
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcEndpointServiceConfigurationResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Return" -> Return.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ModifyVpcEndpointServiceConfigurationResult]
    }
  }

  @js.native
  trait ModifyVpcEndpointServicePermissionsRequest extends js.Object {
    var ServiceId: String
    var AddAllowedPrincipals: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var RemoveAllowedPrincipals: js.UndefOr[ValueStringList]
  }

  object ModifyVpcEndpointServicePermissionsRequest {
    def apply(
        ServiceId: String,
        AddAllowedPrincipals: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        RemoveAllowedPrincipals: js.UndefOr[ValueStringList] = js.undefined
    ): ModifyVpcEndpointServicePermissionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ServiceId" -> ServiceId.asInstanceOf[js.Any],
        "AddAllowedPrincipals" -> AddAllowedPrincipals.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RemoveAllowedPrincipals" -> RemoveAllowedPrincipals.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal
        .applyDynamicNamed("apply")(_fields: _*)
        .asInstanceOf[ModifyVpcEndpointServicePermissionsRequest]
    }
  }

  @js.native
  trait ModifyVpcEndpointServicePermissionsResult extends js.Object {
    var ReturnValue: js.UndefOr[Boolean]
  }

  object ModifyVpcEndpointServicePermissionsResult {
    def apply(
        ReturnValue: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcEndpointServicePermissionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReturnValue" -> ReturnValue.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyVpcEndpointServicePermissionsResult]
    }
  }

  @js.native
  trait ModifyVpcPeeringConnectionOptionsRequest extends js.Object {
    var VpcPeeringConnectionId: String
    var AccepterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptionsRequest]
    var DryRun: js.UndefOr[Boolean]
    var RequesterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptionsRequest]
  }

  object ModifyVpcPeeringConnectionOptionsRequest {
    def apply(
        VpcPeeringConnectionId: String,
        AccepterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptionsRequest] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        RequesterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptionsRequest] = js.undefined
    ): ModifyVpcPeeringConnectionOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "VpcPeeringConnectionId" -> VpcPeeringConnectionId.asInstanceOf[js.Any],
        "AccepterPeeringConnectionOptions" -> AccepterPeeringConnectionOptions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RequesterPeeringConnectionOptions" -> RequesterPeeringConnectionOptions.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyVpcPeeringConnectionOptionsRequest]
    }
  }

  @js.native
  trait ModifyVpcPeeringConnectionOptionsResult extends js.Object {
    var AccepterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptions]
    var RequesterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptions]
  }

  object ModifyVpcPeeringConnectionOptionsResult {
    def apply(
        AccepterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptions] = js.undefined,
        RequesterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptions] = js.undefined
    ): ModifyVpcPeeringConnectionOptionsResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AccepterPeeringConnectionOptions" -> AccepterPeeringConnectionOptions.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RequesterPeeringConnectionOptions" -> RequesterPeeringConnectionOptions.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyVpcPeeringConnectionOptionsResult]
    }
  }

  @js.native
  trait ModifyVpcTenancyRequest extends js.Object {
    var InstanceTenancy: VpcTenancy
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyVpcTenancyRequest {
    def apply(
        InstanceTenancy: VpcTenancy,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcTenancyRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceTenancy" -> InstanceTenancy.asInstanceOf[js.Any],
        "VpcId"           -> VpcId.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyVpcTenancyRequest]
    }
  }

  @js.native
  trait ModifyVpcTenancyResult extends js.Object {
    var ReturnValue: js.UndefOr[Boolean]
  }

  object ModifyVpcTenancyResult {
    def apply(
        ReturnValue: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcTenancyResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ReturnValue" -> ReturnValue.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ModifyVpcTenancyResult]
    }
  }

  @js.native
  trait MonitorInstancesRequest extends js.Object {
    var InstanceIds: InstanceIdStringList
    var DryRun: js.UndefOr[Boolean]
  }

  object MonitorInstancesRequest {
    def apply(
        InstanceIds: InstanceIdStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): MonitorInstancesRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceIds" -> InstanceIds.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[MonitorInstancesRequest]
    }
  }

  @js.native
  trait MonitorInstancesResult extends js.Object {
    var InstanceMonitorings: js.UndefOr[InstanceMonitoringList]
  }

  object MonitorInstancesResult {
    def apply(
        InstanceMonitorings: js.UndefOr[InstanceMonitoringList] = js.undefined
    ): MonitorInstancesResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceMonitorings" -> InstanceMonitorings.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[MonitorInstancesResult]
    }
  }

  /**
    * Describes the monitoring of an instance.
    */
  @js.native
  trait Monitoring extends js.Object {
    var State: js.UndefOr[MonitoringState]
  }

  object Monitoring {
    def apply(
        State: js.UndefOr[MonitoringState] = js.undefined
    ): Monitoring = {
      val _fields = IndexedSeq[(String, js.Any)](
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[Monitoring]
    }
  }

  object MonitoringStateEnum {
    val disabled  = "disabled"
    val disabling = "disabling"
    val enabled   = "enabled"
    val pending   = "pending"

    val values = IndexedSeq(disabled, disabling, enabled, pending)
  }

  @js.native
  trait MoveAddressToVpcRequest extends js.Object {
    var PublicIp: String
    var DryRun: js.UndefOr[Boolean]
  }

  object MoveAddressToVpcRequest {
    def apply(
        PublicIp: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): MoveAddressToVpcRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "PublicIp" -> PublicIp.asInstanceOf[js.Any],
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[MoveAddressToVpcRequest]
    }
  }

  @js.native
  trait MoveAddressToVpcResult extends js.Object {
    var AllocationId: js.UndefOr[String]
    var Status: js.UndefOr[Status]
  }

  object MoveAddressToVpcResult {
    def apply(
        AllocationId: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[Status] = js.undefined
    ): MoveAddressToVpcResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllocationId" -> AllocationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[MoveAddressToVpcResult]
    }
  }

  object MoveStatusEnum {
    val movingToVpc        = "movingToVpc"
    val restoringToClassic = "restoringToClassic"

    val values = IndexedSeq(movingToVpc, restoringToClassic)
  }

  /**
    * Describes the status of a moving Elastic IP address.
    */
  @js.native
  trait MovingAddressStatus extends js.Object {
    var MoveStatus: js.UndefOr[MoveStatus]
    var PublicIp: js.UndefOr[String]
  }

  object MovingAddressStatus {
    def apply(
        MoveStatus: js.UndefOr[MoveStatus] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): MovingAddressStatus = {
      val _fields = IndexedSeq[(String, js.Any)](
        "MoveStatus" -> MoveStatus.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIp" -> PublicIp.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[MovingAddressStatus]
    }
  }

  /**
    * Describes a NAT gateway.
    */
  @js.native
  trait NatGateway extends js.Object {
    var CreateTime: js.UndefOr[DateTime]
    var DeleteTime: js.UndefOr[DateTime]
    var FailureCode: js.UndefOr[String]
    var FailureMessage: js.UndefOr[String]
    var NatGatewayAddresses: js.UndefOr[NatGatewayAddressList]
    var NatGatewayId: js.UndefOr[String]
    var ProvisionedBandwidth: js.UndefOr[ProvisionedBandwidth]
    var State: js.UndefOr[NatGatewayState]
    var SubnetId: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
    var VpcId: js.UndefOr[String]
  }

  object NatGateway {
    def apply(
        CreateTime: js.UndefOr[DateTime] = js.undefined,
        DeleteTime: js.UndefOr[DateTime] = js.undefined,
        FailureCode: js.UndefOr[String] = js.undefined,
        FailureMessage: js.UndefOr[String] = js.undefined,
        NatGatewayAddresses: js.UndefOr[NatGatewayAddressList] = js.undefined,
        NatGatewayId: js.UndefOr[String] = js.undefined,
        ProvisionedBandwidth: js.UndefOr[ProvisionedBandwidth] = js.undefined,
        State: js.UndefOr[NatGatewayState] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): NatGateway = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CreateTime" -> CreateTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeleteTime" -> DeleteTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FailureCode" -> FailureCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FailureMessage" -> FailureMessage.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NatGatewayAddresses" -> NatGatewayAddresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NatGatewayId" -> NatGatewayId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProvisionedBandwidth" -> ProvisionedBandwidth.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NatGateway]
    }
  }

  /**
    * Describes the IP addresses and network interface associated with a NAT gateway.
    */
  @js.native
  trait NatGatewayAddress extends js.Object {
    var AllocationId: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var PrivateIp: js.UndefOr[String]
    var PublicIp: js.UndefOr[String]
  }

  object NatGatewayAddress {
    def apply(
        AllocationId: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        PrivateIp: js.UndefOr[String] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): NatGatewayAddress = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllocationId" -> AllocationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceId" -> NetworkInterfaceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIp" -> PrivateIp.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIp" -> PublicIp.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NatGatewayAddress]
    }
  }

  object NatGatewayStateEnum {
    val pending   = "pending"
    val failed    = "failed"
    val available = "available"
    val deleting  = "deleting"
    val deleted   = "deleted"

    val values = IndexedSeq(pending, failed, available, deleting, deleted)
  }

  /**
    * Describes a network ACL.
    */
  @js.native
  trait NetworkAcl extends js.Object {
    var Associations: js.UndefOr[NetworkAclAssociationList]
    var Entries: js.UndefOr[NetworkAclEntryList]
    var IsDefault: js.UndefOr[Boolean]
    var NetworkAclId: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
    var VpcId: js.UndefOr[String]
  }

  object NetworkAcl {
    def apply(
        Associations: js.UndefOr[NetworkAclAssociationList] = js.undefined,
        Entries: js.UndefOr[NetworkAclEntryList] = js.undefined,
        IsDefault: js.UndefOr[Boolean] = js.undefined,
        NetworkAclId: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): NetworkAcl = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Associations" -> Associations.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Entries" -> Entries.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IsDefault" -> IsDefault.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkAclId" -> NetworkAclId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OwnerId" -> OwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tags" -> Tags.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NetworkAcl]
    }
  }

  /**
    * Describes an association between a network ACL and a subnet.
    */
  @js.native
  trait NetworkAclAssociation extends js.Object {
    var NetworkAclAssociationId: js.UndefOr[String]
    var NetworkAclId: js.UndefOr[String]
    var SubnetId: js.UndefOr[String]
  }

  object NetworkAclAssociation {
    def apply(
        NetworkAclAssociationId: js.UndefOr[String] = js.undefined,
        NetworkAclId: js.UndefOr[String] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined
    ): NetworkAclAssociation = {
      val _fields = IndexedSeq[(String, js.Any)](
        "NetworkAclAssociationId" -> NetworkAclAssociationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkAclId" -> NetworkAclId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NetworkAclAssociation]
    }
  }

  /**
    * Describes an entry in a network ACL.
    */
  @js.native
  trait NetworkAclEntry extends js.Object {
    var CidrBlock: js.UndefOr[String]
    var Egress: js.UndefOr[Boolean]
    var IcmpTypeCode: js.UndefOr[IcmpTypeCode]
    var Ipv6CidrBlock: js.UndefOr[String]
    var PortRange: js.UndefOr[PortRange]
    var Protocol: js.UndefOr[String]
    var RuleAction: js.UndefOr[RuleAction]
    var RuleNumber: js.UndefOr[Int]
  }

  object NetworkAclEntry {
    def apply(
        CidrBlock: js.UndefOr[String] = js.undefined,
        Egress: js.UndefOr[Boolean] = js.undefined,
        IcmpTypeCode: js.UndefOr[IcmpTypeCode] = js.undefined,
        Ipv6CidrBlock: js.UndefOr[String] = js.undefined,
        PortRange: js.UndefOr[PortRange] = js.undefined,
        Protocol: js.UndefOr[String] = js.undefined,
        RuleAction: js.UndefOr[RuleAction] = js.undefined,
        RuleNumber: js.UndefOr[Int] = js.undefined
    ): NetworkAclEntry = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CidrBlock" -> CidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Egress" -> Egress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IcmpTypeCode" -> IcmpTypeCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6CidrBlock" -> Ipv6CidrBlock.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PortRange" -> PortRange.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Protocol" -> Protocol.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RuleAction" -> RuleAction.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RuleNumber" -> RuleNumber.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NetworkAclEntry]
    }
  }

  /**
    * Describes a network interface.
    */
  @js.native
  trait NetworkInterface extends js.Object {
    var Association: js.UndefOr[NetworkInterfaceAssociation]
    var Attachment: js.UndefOr[NetworkInterfaceAttachment]
    var AvailabilityZone: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var Groups: js.UndefOr[GroupIdentifierList]
    var InterfaceType: js.UndefOr[NetworkInterfaceType]
    var Ipv6Addresses: js.UndefOr[NetworkInterfaceIpv6AddressesList]
    var MacAddress: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var PrivateDnsName: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PrivateIpAddresses: js.UndefOr[NetworkInterfacePrivateIpAddressList]
    var RequesterId: js.UndefOr[String]
    var RequesterManaged: js.UndefOr[Boolean]
    var SourceDestCheck: js.UndefOr[Boolean]
    var Status: js.UndefOr[NetworkInterfaceStatus]
    var SubnetId: js.UndefOr[String]
    var TagSet: js.UndefOr[TagList]
    var VpcId: js.UndefOr[String]
  }

  object NetworkInterface {
    def apply(
        Association: js.UndefOr[NetworkInterfaceAssociation] = js.undefined,
        Attachment: js.UndefOr[NetworkInterfaceAttachment] = js.undefined,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        Groups: js.UndefOr[GroupIdentifierList] = js.undefined,
        InterfaceType: js.UndefOr[NetworkInterfaceType] = js.undefined,
        Ipv6Addresses: js.UndefOr[NetworkInterfaceIpv6AddressesList] = js.undefined,
        MacAddress: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        PrivateDnsName: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PrivateIpAddresses: js.UndefOr[NetworkInterfacePrivateIpAddressList] = js.undefined,
        RequesterId: js.UndefOr[String] = js.undefined,
        RequesterManaged: js.UndefOr[Boolean] = js.undefined,
        SourceDestCheck: js.UndefOr[Boolean] = js.undefined,
        Status: js.UndefOr[NetworkInterfaceStatus] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        TagSet: js.UndefOr[TagList] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): NetworkInterface = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Association" -> Association.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Attachment" -> Attachment.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Groups" -> Groups.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InterfaceType" -> InterfaceType.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Ipv6Addresses" -> Ipv6Addresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MacAddress" -> MacAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceId" -> NetworkInterfaceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "OwnerId" -> OwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateDnsName" -> PrivateDnsName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddresses" -> PrivateIpAddresses.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RequesterId" -> RequesterId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RequesterManaged" -> RequesterManaged.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SourceDestCheck" -> SourceDestCheck.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubnetId" -> SubnetId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TagSet" -> TagSet.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VpcId" -> VpcId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NetworkInterface]
    }
  }

  /**
    * Describes association information for an Elastic IP address (IPv4 only).
    */
  @js.native
  trait NetworkInterfaceAssociation extends js.Object {
    var AllocationId: js.UndefOr[String]
    var AssociationId: js.UndefOr[String]
    var IpOwnerId: js.UndefOr[String]
    var PublicDnsName: js.UndefOr[String]
    var PublicIp: js.UndefOr[String]
  }

  object NetworkInterfaceAssociation {
    def apply(
        AllocationId: js.UndefOr[String] = js.undefined,
        AssociationId: js.UndefOr[String] = js.undefined,
        IpOwnerId: js.UndefOr[String] = js.undefined,
        PublicDnsName: js.UndefOr[String] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): NetworkInterfaceAssociation = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllocationId" -> AllocationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AssociationId" -> AssociationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "IpOwnerId" -> IpOwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicDnsName" -> PublicDnsName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PublicIp" -> PublicIp.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NetworkInterfaceAssociation]
    }
  }

  /**
    * Describes a network interface attachment.
    */
  @js.native
  trait NetworkInterfaceAttachment extends js.Object {
    var AttachTime: js.UndefOr[DateTime]
    var AttachmentId: js.UndefOr[String]
    var DeleteOnTermination: js.UndefOr[Boolean]
    var DeviceIndex: js.UndefOr[Int]
    var InstanceId: js.UndefOr[String]
    var InstanceOwnerId: js.UndefOr[String]
    var Status: js.UndefOr[AttachmentStatus]
  }

  object NetworkInterfaceAttachment {
    def apply(
        AttachTime: js.UndefOr[DateTime] = js.undefined,
        AttachmentId: js.UndefOr[String] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        DeviceIndex: js.UndefOr[Int] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        InstanceOwnerId: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[AttachmentStatus] = js.undefined
    ): NetworkInterfaceAttachment = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AttachTime" -> AttachTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AttachmentId" -> AttachmentId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeleteOnTermination" -> DeleteOnTermination.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeviceIndex" -> DeviceIndex.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceId" -> InstanceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceOwnerId" -> InstanceOwnerId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NetworkInterfaceAttachment]
    }
  }

  /**
    * Describes an attachment change.
    */
  @js.native
  trait NetworkInterfaceAttachmentChanges extends js.Object {
    var AttachmentId: js.UndefOr[String]
    var DeleteOnTermination: js.UndefOr[Boolean]
  }

  object NetworkInterfaceAttachmentChanges {
    def apply(
        AttachmentId: js.UndefOr[String] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined
    ): NetworkInterfaceAttachmentChanges = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AttachmentId" -> AttachmentId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DeleteOnTermination" -> DeleteOnTermination.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NetworkInterfaceAttachmentChanges]
    }
  }

  object NetworkInterfaceAttributeEnum {
    val description     = "description"
    val groupSet        = "groupSet"
    val sourceDestCheck = "sourceDestCheck"
    val attachment      = "attachment"

    val values = IndexedSeq(description, groupSet, sourceDestCheck, attachment)
  }

  /**
    * Describes an IPv6 address associated with a network interface.
    */
  @js.native
  trait NetworkInterfaceIpv6Address extends js.Object {
    var Ipv6Address: js.UndefOr[String]
  }

  object NetworkInterfaceIpv6Address {
    def apply(
        Ipv6Address: js.UndefOr[String] = js.undefined
    ): NetworkInterfaceIpv6Address = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Ipv6Address" -> Ipv6Address.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NetworkInterfaceIpv6Address]
    }
  }

  /**
    * Describes a permission for a network interface.
    */
  @js.native
  trait NetworkInterfacePermission extends js.Object {
    var AwsAccountId: js.UndefOr[String]
    var AwsService: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var NetworkInterfacePermissionId: js.UndefOr[String]
    var Permission: js.UndefOr[InterfacePermissionType]
    var PermissionState: js.UndefOr[NetworkInterfacePermissionState]
  }

  object NetworkInterfacePermission {
    def apply(
        AwsAccountId: js.UndefOr[String] = js.undefined,
        AwsService: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        NetworkInterfacePermissionId: js.UndefOr[String] = js.undefined,
        Permission: js.UndefOr[InterfacePermissionType] = js.undefined,
        PermissionState: js.UndefOr[NetworkInterfacePermissionState] = js.undefined
    ): NetworkInterfacePermission = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AwsAccountId" -> AwsAccountId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AwsService" -> AwsService.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfaceId" -> NetworkInterfaceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "NetworkInterfacePermissionId" -> NetworkInterfacePermissionId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Permission" -> Permission.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PermissionState" -> PermissionState.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NetworkInterfacePermission]
    }
  }

  /**
    * Describes the state of a network interface permission.
    */
  @js.native
  trait NetworkInterfacePermissionState extends js.Object {
    var State: js.UndefOr[NetworkInterfacePermissionStateCode]
    var StatusMessage: js.UndefOr[String]
  }

  object NetworkInterfacePermissionState {
    def apply(
        State: js.UndefOr[NetworkInterfacePermissionStateCode] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined
    ): NetworkInterfacePermissionState = {
      val _fields = IndexedSeq[(String, js.Any)](
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "StatusMessage" -> StatusMessage.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NetworkInterfacePermissionState]
    }
  }

  object NetworkInterfacePermissionStateCodeEnum {
    val pending  = "pending"
    val granted  = "granted"
    val revoking = "revoking"
    val revoked  = "revoked"

    val values = IndexedSeq(pending, granted, revoking, revoked)
  }

  /**
    * Describes the private IPv4 address of a network interface.
    */
  @js.native
  trait NetworkInterfacePrivateIpAddress extends js.Object {
    var Association: js.UndefOr[NetworkInterfaceAssociation]
    var Primary: js.UndefOr[Boolean]
    var PrivateDnsName: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
  }

  object NetworkInterfacePrivateIpAddress {
    def apply(
        Association: js.UndefOr[NetworkInterfaceAssociation] = js.undefined,
        Primary: js.UndefOr[Boolean] = js.undefined,
        PrivateDnsName: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined
    ): NetworkInterfacePrivateIpAddress = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Association" -> Association.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Primary" -> Primary.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateDnsName" -> PrivateDnsName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NetworkInterfacePrivateIpAddress]
    }
  }

  object NetworkInterfaceStatusEnum {
    val available  = "available"
    val associated = "associated"
    val attaching  = "attaching"
    val `in-use`   = "in-use"
    val detaching  = "detaching"

    val values = IndexedSeq(available, associated, attaching, `in-use`, detaching)
  }

  object NetworkInterfaceTypeEnum {
    val interface  = "interface"
    val natGateway = "natGateway"

    val values = IndexedSeq(interface, natGateway)
  }

  @js.native
  trait NewDhcpConfiguration extends js.Object {
    var Key: js.UndefOr[String]
    var Values: js.UndefOr[ValueStringList]
  }

  object NewDhcpConfiguration {
    def apply(
        Key: js.UndefOr[String] = js.undefined,
        Values: js.UndefOr[ValueStringList] = js.undefined
    ): NewDhcpConfiguration = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Key" -> Key.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Values" -> Values.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[NewDhcpConfiguration]
    }
  }

  object OfferingClassTypeEnum {
    val standard    = "standard"
    val convertible = "convertible"

    val values = IndexedSeq(standard, convertible)
  }

  object OfferingTypeValuesEnum {
    val `Heavy Utilization`  = "Heavy Utilization"
    val `Medium Utilization` = "Medium Utilization"
    val `Light Utilization`  = "Light Utilization"
    val `No Upfront`         = "No Upfront"
    val `Partial Upfront`    = "Partial Upfront"
    val `All Upfront`        = "All Upfront"

    val values = IndexedSeq(
      `Heavy Utilization`,
      `Medium Utilization`,
      `Light Utilization`,
      `No Upfront`,
      `Partial Upfront`,
      `All Upfront`
    )
  }

  object OnDemandAllocationStrategyEnum {
    val lowestPrice = "lowestPrice"
    val prioritized = "prioritized"

    val values = IndexedSeq(lowestPrice, prioritized)
  }

  /**
    * The allocation strategy of On-Demand Instances in an EC2 Fleet.
    */
  @js.native
  trait OnDemandOptions extends js.Object {
    var AllocationStrategy: js.UndefOr[FleetOnDemandAllocationStrategy]
    var MinTargetCapacity: js.UndefOr[Int]
    var SingleAvailabilityZone: js.UndefOr[Boolean]
    var SingleInstanceType: js.UndefOr[Boolean]
  }

  object OnDemandOptions {
    def apply(
        AllocationStrategy: js.UndefOr[FleetOnDemandAllocationStrategy] = js.undefined,
        MinTargetCapacity: js.UndefOr[Int] = js.undefined,
        SingleAvailabilityZone: js.UndefOr[Boolean] = js.undefined,
        SingleInstanceType: js.UndefOr[Boolean] = js.undefined
    ): OnDemandOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllocationStrategy" -> AllocationStrategy.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MinTargetCapacity" -> MinTargetCapacity.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SingleAvailabilityZone" -> SingleAvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SingleInstanceType" -> SingleInstanceType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[OnDemandOptions]
    }
  }

  /**
    * The allocation strategy of On-Demand Instances in an EC2 Fleet.
    */
  @js.native
  trait OnDemandOptionsRequest extends js.Object {
    var AllocationStrategy: js.UndefOr[FleetOnDemandAllocationStrategy]
    var MinTargetCapacity: js.UndefOr[Int]
    var SingleAvailabilityZone: js.UndefOr[Boolean]
    var SingleInstanceType: js.UndefOr[Boolean]
  }

  object OnDemandOptionsRequest {
    def apply(
        AllocationStrategy: js.UndefOr[FleetOnDemandAllocationStrategy] = js.undefined,
        MinTargetCapacity: js.UndefOr[Int] = js.undefined,
        SingleAvailabilityZone: js.UndefOr[Boolean] = js.undefined,
        SingleInstanceType: js.UndefOr[Boolean] = js.undefined
    ): OnDemandOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllocationStrategy" -> AllocationStrategy.map { x =>
          x.asInstanceOf[js.Any]
        },
        "MinTargetCapacity" -> MinTargetCapacity.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SingleAvailabilityZone" -> SingleAvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SingleInstanceType" -> SingleInstanceType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[OnDemandOptionsRequest]
    }
  }

  object OperationTypeEnum {
    val add    = "add"
    val remove = "remove"

    val values = IndexedSeq(add, remove)
  }

  object PaymentOptionEnum {
    val AllUpfront     = "AllUpfront"
    val PartialUpfront = "PartialUpfront"
    val NoUpfront      = "NoUpfront"

    val values = IndexedSeq(AllUpfront, PartialUpfront, NoUpfront)
  }

  /**
    * Describes the data that identifies an Amazon FPGA image (AFI) on the PCI bus.
    */
  @js.native
  trait PciId extends js.Object {
    var DeviceId: js.UndefOr[String]
    var SubsystemId: js.UndefOr[String]
    var SubsystemVendorId: js.UndefOr[String]
    var VendorId: js.UndefOr[String]
  }

  object PciId {
    def apply(
        DeviceId: js.UndefOr[String] = js.undefined,
        SubsystemId: js.UndefOr[String] = js.undefined,
        SubsystemVendorId: js.UndefOr[String] = js.undefined,
        VendorId: js.UndefOr[String] = js.undefined
    ): PciId = {
      val _fields = IndexedSeq[(String, js.Any)](
        "DeviceId" -> DeviceId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubsystemId" -> SubsystemId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SubsystemVendorId" -> SubsystemVendorId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "VendorId" -> VendorId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PciId]
    }
  }

  /**
    * Describes the VPC peering connection options.
    */
  @js.native
  trait PeeringConnectionOptions extends js.Object {
    var AllowDnsResolutionFromRemoteVpc: js.UndefOr[Boolean]
    var AllowEgressFromLocalClassicLinkToRemoteVpc: js.UndefOr[Boolean]
    var AllowEgressFromLocalVpcToRemoteClassicLink: js.UndefOr[Boolean]
  }

  object PeeringConnectionOptions {
    def apply(
        AllowDnsResolutionFromRemoteVpc: js.UndefOr[Boolean] = js.undefined,
        AllowEgressFromLocalClassicLinkToRemoteVpc: js.UndefOr[Boolean] = js.undefined,
        AllowEgressFromLocalVpcToRemoteClassicLink: js.UndefOr[Boolean] = js.undefined
    ): PeeringConnectionOptions = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllowDnsResolutionFromRemoteVpc" -> AllowDnsResolutionFromRemoteVpc.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AllowEgressFromLocalClassicLinkToRemoteVpc" -> AllowEgressFromLocalClassicLinkToRemoteVpc.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AllowEgressFromLocalVpcToRemoteClassicLink" -> AllowEgressFromLocalVpcToRemoteClassicLink.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PeeringConnectionOptions]
    }
  }

  /**
    * The VPC peering connection options.
    */
  @js.native
  trait PeeringConnectionOptionsRequest extends js.Object {
    var AllowDnsResolutionFromRemoteVpc: js.UndefOr[Boolean]
    var AllowEgressFromLocalClassicLinkToRemoteVpc: js.UndefOr[Boolean]
    var AllowEgressFromLocalVpcToRemoteClassicLink: js.UndefOr[Boolean]
  }

  object PeeringConnectionOptionsRequest {
    def apply(
        AllowDnsResolutionFromRemoteVpc: js.UndefOr[Boolean] = js.undefined,
        AllowEgressFromLocalClassicLinkToRemoteVpc: js.UndefOr[Boolean] = js.undefined,
        AllowEgressFromLocalVpcToRemoteClassicLink: js.UndefOr[Boolean] = js.undefined
    ): PeeringConnectionOptionsRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AllowDnsResolutionFromRemoteVpc" -> AllowDnsResolutionFromRemoteVpc.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AllowEgressFromLocalClassicLinkToRemoteVpc" -> AllowEgressFromLocalClassicLinkToRemoteVpc.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AllowEgressFromLocalVpcToRemoteClassicLink" -> AllowEgressFromLocalVpcToRemoteClassicLink.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PeeringConnectionOptionsRequest]
    }
  }

  object PermissionGroupEnum {
    val all = "all"

    val values = IndexedSeq(all)
  }

  /**
    * Describes the placement of an instance.
    */
  @js.native
  trait Placement extends js.Object {
    var Affinity: js.UndefOr[String]
    var AvailabilityZone: js.UndefOr[String]
    var GroupName: js.UndefOr[String]
    var HostId: js.UndefOr[String]
    var PartitionNumber: js.UndefOr[Int]
    var SpreadDomain: js.UndefOr[String]
    var Tenancy: js.UndefOr[Tenancy]
  }

  object Placement {
    def apply(
        Affinity: js.UndefOr[String] = js.undefined,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined,
        HostId: js.UndefOr[String] = js.undefined,
        PartitionNumber: js.UndefOr[Int] = js.undefined,
        SpreadDomain: js.UndefOr[String] = js.undefined,
        Tenancy: js.UndefOr[Tenancy] = js.undefined
    ): Placement = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Affinity" -> Affinity.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AvailabilityZone" -> AvailabilityZone.map { x =>
          x.asInstanceOf[js.Any]
        },
        "GroupName" -> GroupName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostId" -> HostId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PartitionNumber" -> PartitionNumber.map { x =>
          x.asInstanceOf[js.Any]
        },
        "SpreadDomain" -> SpreadDomain.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Tenancy" -> Tenancy.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[Placement]
    }
  }

  /**
    * Describes a placement group.
    */
  @js.native
  trait PlacementGroup extends js.Object {
    var GroupName: js.UndefOr[String]
    var PartitionCount: js.UndefOr[Int]
    var State: js.UndefOr[PlacementGroupState]
    var Strategy: js.UndefOr[PlacementStrategy]
  }

  object PlacementGroup {
    def apply(
        GroupName: js.UndefOr[String] = js.undefined,
        PartitionCount: js.UndefOr[Int] = js.undefined,
        State: js.UndefOr[PlacementGroupState] = js.undefined,
        Strategy: js.UndefOr[PlacementStrategy] = js.undefined
    ): PlacementGroup = {
      val _fields = IndexedSeq[(String, js.Any)](
        "GroupName" -> GroupName.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PartitionCount" -> PartitionCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "State" -> State.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Strategy" -> Strategy.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PlacementGroup]
    }
  }

  object PlacementGroupStateEnum {
    val pending   = "pending"
    val available = "available"
    val deleting  = "deleting"
    val deleted   = "deleted"

    val values = IndexedSeq(pending, available, deleting, deleted)
  }

  /**
    * Describes the placement of an instance.
    */
  @js.native
  trait PlacementResponse extends js.Object {
    var GroupName: js.UndefOr[String]
  }

  object PlacementResponse {
    def apply(
        GroupName: js.UndefOr[String] = js.undefined
    ): PlacementResponse = {
      val _fields = IndexedSeq[(String, js.Any)](
        "GroupName" -> GroupName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PlacementResponse]
    }
  }

  object PlacementStrategyEnum {
    val cluster   = "cluster"
    val spread    = "spread"
    val partition = "partition"

    val values = IndexedSeq(cluster, spread, partition)
  }

  object PlatformValuesEnum {
    val Windows = "Windows"

    val values = IndexedSeq(Windows)
  }

  /**
    * Describes a range of ports.
    */
  @js.native
  trait PortRange extends js.Object {
    var From: js.UndefOr[Int]
    var To: js.UndefOr[Int]
  }

  object PortRange {
    def apply(
        From: js.UndefOr[Int] = js.undefined,
        To: js.UndefOr[Int] = js.undefined
    ): PortRange = {
      val _fields = IndexedSeq[(String, js.Any)](
        "From" -> From.map { x =>
          x.asInstanceOf[js.Any]
        },
        "To" -> To.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PortRange]
    }
  }

  /**
    * Describes prefixes for AWS services.
    */
  @js.native
  trait PrefixList extends js.Object {
    var Cidrs: js.UndefOr[ValueStringList]
    var PrefixListId: js.UndefOr[String]
    var PrefixListName: js.UndefOr[String]
  }

  object PrefixList {
    def apply(
        Cidrs: js.UndefOr[ValueStringList] = js.undefined,
        PrefixListId: js.UndefOr[String] = js.undefined,
        PrefixListName: js.UndefOr[String] = js.undefined
    ): PrefixList = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Cidrs" -> Cidrs.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrefixListId" -> PrefixListId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrefixListName" -> PrefixListName.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PrefixList]
    }
  }

  /**
    * Describes a prefix list ID.
    */
  @js.native
  trait PrefixListId extends js.Object {
    var Description: js.UndefOr[String]
    var PrefixListId: js.UndefOr[String]
  }

  object PrefixListId {
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        PrefixListId: js.UndefOr[String] = js.undefined
    ): PrefixListId = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrefixListId" -> PrefixListId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PrefixListId]
    }
  }

  /**
    * Describes the price for a Reserved Instance.
    */
  @js.native
  trait PriceSchedule extends js.Object {
    var Active: js.UndefOr[Boolean]
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var Price: js.UndefOr[Double]
    var Term: js.UndefOr[Double]
  }

  object PriceSchedule {
    def apply(
        Active: js.UndefOr[Boolean] = js.undefined,
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        Price: js.UndefOr[Double] = js.undefined,
        Term: js.UndefOr[Double] = js.undefined
    ): PriceSchedule = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Active" -> Active.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CurrencyCode" -> CurrencyCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Price" -> Price.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Term" -> Term.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PriceSchedule]
    }
  }

  /**
    * Describes the price for a Reserved Instance.
    */
  @js.native
  trait PriceScheduleSpecification extends js.Object {
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var Price: js.UndefOr[Double]
    var Term: js.UndefOr[Double]
  }

  object PriceScheduleSpecification {
    def apply(
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        Price: js.UndefOr[Double] = js.undefined,
        Term: js.UndefOr[Double] = js.undefined
    ): PriceScheduleSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CurrencyCode" -> CurrencyCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Price" -> Price.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Term" -> Term.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PriceScheduleSpecification]
    }
  }

  /**
    * Describes a Reserved Instance offering.
    */
  @js.native
  trait PricingDetail extends js.Object {
    var Count: js.UndefOr[Int]
    var Price: js.UndefOr[Double]
  }

  object PricingDetail {
    def apply(
        Count: js.UndefOr[Int] = js.undefined,
        Price: js.UndefOr[Double] = js.undefined
    ): PricingDetail = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Count" -> Count.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Price" -> Price.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PricingDetail]
    }
  }

  /**
    * PrincipalIdFormat description
    */
  @js.native
  trait PrincipalIdFormat extends js.Object {
    var Arn: js.UndefOr[String]
    var Statuses: js.UndefOr[IdFormatList]
  }

  object PrincipalIdFormat {
    def apply(
        Arn: js.UndefOr[String] = js.undefined,
        Statuses: js.UndefOr[IdFormatList] = js.undefined
    ): PrincipalIdFormat = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Arn" -> Arn.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Statuses" -> Statuses.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PrincipalIdFormat]
    }
  }

  object PrincipalTypeEnum {
    val All              = "All"
    val Service          = "Service"
    val OrganizationUnit = "OrganizationUnit"
    val Account          = "Account"
    val User             = "User"
    val Role             = "Role"

    val values = IndexedSeq(All, Service, OrganizationUnit, Account, User, Role)
  }

  /**
    * Describes a secondary private IPv4 address for a network interface.
    */
  @js.native
  trait PrivateIpAddressSpecification extends js.Object {
    var Primary: js.UndefOr[Boolean]
    var PrivateIpAddress: js.UndefOr[String]
  }

  object PrivateIpAddressSpecification {
    def apply(
        Primary: js.UndefOr[Boolean] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined
    ): PrivateIpAddressSpecification = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Primary" -> Primary.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PrivateIpAddress" -> PrivateIpAddress.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PrivateIpAddressSpecification]
    }
  }

  /**
    * Describes a product code.
    */
  @js.native
  trait ProductCode extends js.Object {
    var ProductCodeId: js.UndefOr[String]
    var ProductCodeType: js.UndefOr[ProductCodeValues]
  }

  object ProductCode {
    def apply(
        ProductCodeId: js.UndefOr[String] = js.undefined,
        ProductCodeType: js.UndefOr[ProductCodeValues] = js.undefined
    ): ProductCode = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ProductCodeId" -> ProductCodeId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "ProductCodeType" -> ProductCodeType.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ProductCode]
    }
  }

  object ProductCodeValuesEnum {
    val devpay      = "devpay"
    val marketplace = "marketplace"

    val values = IndexedSeq(devpay, marketplace)
  }

  /**
    * Describes a virtual private gateway propagating route.
    */
  @js.native
  trait PropagatingVgw extends js.Object {
    var GatewayId: js.UndefOr[String]
  }

  object PropagatingVgw {
    def apply(
        GatewayId: js.UndefOr[String] = js.undefined
    ): PropagatingVgw = {
      val _fields = IndexedSeq[(String, js.Any)](
        "GatewayId" -> GatewayId.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PropagatingVgw]
    }
  }

  @js.native
  trait ProvisionByoipCidrRequest extends js.Object {
    var Cidr: String
    var CidrAuthorizationContext: js.UndefOr[CidrAuthorizationContext]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object ProvisionByoipCidrRequest {
    def apply(
        Cidr: String,
        CidrAuthorizationContext: js.UndefOr[CidrAuthorizationContext] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ProvisionByoipCidrRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Cidr" -> Cidr.asInstanceOf[js.Any],
        "CidrAuthorizationContext" -> CidrAuthorizationContext.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "DryRun" -> DryRun.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ProvisionByoipCidrRequest]
    }
  }

  @js.native
  trait ProvisionByoipCidrResult extends js.Object {
    var ByoipCidr: js.UndefOr[ByoipCidr]
  }

  object ProvisionByoipCidrResult {
    def apply(
        ByoipCidr: js.UndefOr[ByoipCidr] = js.undefined
    ): ProvisionByoipCidrResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ByoipCidr" -> ByoipCidr.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ProvisionByoipCidrResult]
    }
  }

  /**
    * Reserved. If you need to sustain traffic greater than the [[https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/vpc-nat-gateway.html|documented limits]], contact us through the [[https://console.aws.amazon.com/support/home?|Support Center]].
    */
  @js.native
  trait ProvisionedBandwidth extends js.Object {
    var ProvisionTime: js.UndefOr[DateTime]
    var Provisioned: js.UndefOr[String]
    var RequestTime: js.UndefOr[DateTime]
    var Requested: js.UndefOr[String]
    var Status: js.UndefOr[String]
  }

  object ProvisionedBandwidth {
    def apply(
        ProvisionTime: js.UndefOr[DateTime] = js.undefined,
        Provisioned: js.UndefOr[String] = js.undefined,
        RequestTime: js.UndefOr[DateTime] = js.undefined,
        Requested: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[String] = js.undefined
    ): ProvisionedBandwidth = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ProvisionTime" -> ProvisionTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Provisioned" -> Provisioned.map { x =>
          x.asInstanceOf[js.Any]
        },
        "RequestTime" -> RequestTime.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Requested" -> Requested.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Status" -> Status.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[ProvisionedBandwidth]
    }
  }

  /**
    * Describes an address pool.
    */
  @js.native
  trait PublicIpv4Pool extends js.Object {
    var Description: js.UndefOr[String]
    var PoolAddressRanges: js.UndefOr[PublicIpv4PoolRangeSet]
    var PoolId: js.UndefOr[String]
    var TotalAddressCount: js.UndefOr[Int]
    var TotalAvailableAddressCount: js.UndefOr[Int]
  }

  object PublicIpv4Pool {
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        PoolAddressRanges: js.UndefOr[PublicIpv4PoolRangeSet] = js.undefined,
        PoolId: js.UndefOr[String] = js.undefined,
        TotalAddressCount: js.UndefOr[Int] = js.undefined,
        TotalAvailableAddressCount: js.UndefOr[Int] = js.undefined
    ): PublicIpv4Pool = {
      val _fields = IndexedSeq[(String, js.Any)](
        "Description" -> Description.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PoolAddressRanges" -> PoolAddressRanges.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PoolId" -> PoolId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TotalAddressCount" -> TotalAddressCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TotalAvailableAddressCount" -> TotalAvailableAddressCount.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PublicIpv4Pool]
    }
  }

  /**
    * Describes an address range of an IPv4 address pool.
    */
  @js.native
  trait PublicIpv4PoolRange extends js.Object {
    var AddressCount: js.UndefOr[Int]
    var AvailableAddressCount: js.UndefOr[Int]
    var FirstAddress: js.UndefOr[String]
    var LastAddress: js.UndefOr[String]
  }

  object PublicIpv4PoolRange {
    def apply(
        AddressCount: js.UndefOr[Int] = js.undefined,
        AvailableAddressCount: js.UndefOr[Int] = js.undefined,
        FirstAddress: js.UndefOr[String] = js.undefined,
        LastAddress: js.UndefOr[String] = js.undefined
    ): PublicIpv4PoolRange = {
      val _fields = IndexedSeq[(String, js.Any)](
        "AddressCount" -> AddressCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "AvailableAddressCount" -> AvailableAddressCount.map { x =>
          x.asInstanceOf[js.Any]
        },
        "FirstAddress" -> FirstAddress.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LastAddress" -> LastAddress.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PublicIpv4PoolRange]
    }
  }

  /**
    * Describes the result of the purchase.
    */
  @js.native
  trait Purchase extends js.Object {
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var Duration: js.UndefOr[Int]
    var HostIdSet: js.UndefOr[ResponseHostIdSet]
    var HostReservationId: js.UndefOr[String]
    var HourlyPrice: js.UndefOr[String]
    var InstanceFamily: js.UndefOr[String]
    var PaymentOption: js.UndefOr[PaymentOption]
    var UpfrontPrice: js.UndefOr[String]
  }

  object Purchase {
    def apply(
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        Duration: js.UndefOr[Int] = js.undefined,
        HostIdSet: js.UndefOr[ResponseHostIdSet] = js.undefined,
        HostReservationId: js.UndefOr[String] = js.undefined,
        HourlyPrice: js.UndefOr[String] = js.undefined,
        InstanceFamily: js.UndefOr[String] = js.undefined,
        PaymentOption: js.UndefOr[PaymentOption] = js.undefined,
        UpfrontPrice: js.UndefOr[String] = js.undefined
    ): Purchase = {
      val _fields = IndexedSeq[(String, js.Any)](
        "CurrencyCode" -> CurrencyCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Duration" -> Duration.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostIdSet" -> HostIdSet.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HostReservationId" -> HostReservationId.map { x =>
          x.asInstanceOf[js.Any]
        },
        "HourlyPrice" -> HourlyPrice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "InstanceFamily" -> InstanceFamily.map { x =>
          x.asInstanceOf[js.Any]
        },
        "PaymentOption" -> PaymentOption.map { x =>
          x.asInstanceOf[js.Any]
        },
        "UpfrontPrice" -> UpfrontPrice.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[Purchase]
    }
  }

  @js.native
  trait PurchaseHostReservationRequest extends js.Object {
    var HostIdSet: RequestHostIdSet
    var OfferingId: String
    var ClientToken: js.UndefOr[String]
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var LimitPrice: js.UndefOr[String]
  }

  object PurchaseHostReservationRequest {
    def apply(
        HostIdSet: RequestHostIdSet,
        OfferingId: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        LimitPrice: js.UndefOr[String] = js.undefined
    ): PurchaseHostReservationRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "HostIdSet"  -> HostIdSet.asInstanceOf[js.Any],
        "OfferingId" -> OfferingId.asInstanceOf[js.Any],
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CurrencyCode" -> CurrencyCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "LimitPrice" -> LimitPrice.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PurchaseHostReservationRequest]
    }
  }

  @js.native
  trait PurchaseHostReservationResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var Purchase: js.UndefOr[PurchaseSet]
    var TotalHourlyPrice: js.UndefOr[String]
    var TotalUpfrontPrice: js.UndefOr[String]
  }

  object PurchaseHostReservationResult {
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        Purchase: js.UndefOr[PurchaseSet] = js.undefined,
        TotalHourlyPrice: js.UndefOr[String] = js.undefined,
        TotalUpfrontPrice: js.UndefOr[String] = js.undefined
    ): PurchaseHostReservationResult = {
      val _fields = IndexedSeq[(String, js.Any)](
        "ClientToken" -> ClientToken.map { x =>
          x.asInstanceOf[js.Any]
        },
        "CurrencyCode" -> CurrencyCode.map { x =>
          x.asInstanceOf[js.Any]
        },
        "Purchase" -> Purchase.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TotalHourlyPrice" -> TotalHourlyPrice.map { x =>
          x.asInstanceOf[js.Any]
        },
        "TotalUpfrontPrice" -> TotalUpfrontPrice.map { x =>
          x.asInstanceOf[js.Any]
        }
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PurchaseHostReservationResult]
    }
  }

  /**
    * Describes a request to purchase Scheduled Instances.
    */
  @js.native
  trait PurchaseRequest extends js.Object {
    var InstanceCount: Int
    var PurchaseToken: String
  }

  object PurchaseRequest {
    def apply(
        InstanceCount: Int,
        PurchaseToken: String
    ): PurchaseRequest = {
      val _fields = IndexedSeq[(String, js.Any)](
        "InstanceCount" -> InstanceCount.asInstanceOf[js.Any],
        "PurchaseToken" -> PurchaseToken.asInstanceOf[js.Any]
      ).filter(_._2 != (js.undefined: js.Any))

      js.Dynamic.literal.applyDynamicNamed("apply")(_fields: _*).asInstanceOf[PurchaseRequest]
    }
  }

  /**
    * Contains the parameters for PurchaseReservedInstancesOffering.
    */
  @js.native
  trait Purch