package facade.amazonaws.services

import scalajs._
import scalajs.js.annotation.JSImport
import scala.scalajs.js.|
import scala.concurrent.Future
import io.scalajs.nodejs
import facade.amazonaws._

package object ec2 {
  type AccountAttributeList                             = js.Array[AccountAttribute]
  type AccountAttributeName                             = String
  type AccountAttributeNameStringList                   = js.Array[AccountAttributeName]
  type AccountAttributeValueList                        = js.Array[AccountAttributeValue]
  type ActiveInstanceSet                                = js.Array[ActiveInstance]
  type ActivityStatus                                   = String
  type AddressList                                      = js.Array[Address]
  type Affinity                                         = String
  type AllocationIdList                                 = js.Array[String]
  type AllocationState                                  = String
  type AllocationStrategy                               = String
  type AllowedPrincipalSet                              = js.Array[AllowedPrincipal]
  type ArchitectureValues                               = String
  type AssignedPrivateIpAddressList                     = js.Array[AssignedPrivateIpAddress]
  type AssociatedNetworkType                            = String
  type AssociatedTargetNetworkSet                       = js.Array[AssociatedTargetNetwork]
  type AssociationIdList                                = js.Array[String]
  type AssociationStatusCode                            = String
  type AttachmentStatus                                 = String
  type AuthorizationRuleSet                             = js.Array[AuthorizationRule]
  type AutoAcceptSharedAttachmentsValue                 = String
  type AutoPlacement                                    = String
  type AvailabilityZoneList                             = js.Array[AvailabilityZone]
  type AvailabilityZoneMessageList                      = js.Array[AvailabilityZoneMessage]
  type AvailabilityZoneState                            = String
  type AvailableInstanceCapacityList                    = js.Array[InstanceCapacity]
  type BatchState                                       = String
  type BillingProductList                               = js.Array[String]
  type Blob                                             = nodejs.buffer.Buffer | nodejs.stream.Readable | js.typedarray.TypedArray[_, _] | js.Array[Byte] | String
  type BlockDeviceMappingList                           = js.Array[BlockDeviceMapping]
  type BlockDeviceMappingRequestList                    = js.Array[BlockDeviceMapping]
  type BundleIdStringList                               = js.Array[String]
  type BundleTaskList                                   = js.Array[BundleTask]
  type BundleTaskState                                  = String
  type ByoipCidrSet                                     = js.Array[ByoipCidr]
  type ByoipCidrState                                   = String
  type CancelBatchErrorCode                             = String
  type CancelSpotFleetRequestsErrorSet                  = js.Array[CancelSpotFleetRequestsErrorItem]
  type CancelSpotFleetRequestsSuccessSet                = js.Array[CancelSpotFleetRequestsSuccessItem]
  type CancelSpotInstanceRequestState                   = String
  type CancelledSpotInstanceRequestList                 = js.Array[CancelledSpotInstanceRequest]
  type CapacityReservationIdSet                         = js.Array[String]
  type CapacityReservationInstancePlatform              = String
  type CapacityReservationPreference                    = String
  type CapacityReservationSet                           = js.Array[CapacityReservation]
  type CapacityReservationState                         = String
  type CapacityReservationTenancy                       = String
  type CidrBlockSet                                     = js.Array[CidrBlock]
  type ClassicLinkDnsSupportList                        = js.Array[ClassicLinkDnsSupport]
  type ClassicLinkInstanceList                          = js.Array[ClassicLinkInstance]
  type ClassicLoadBalancers                             = js.Array[ClassicLoadBalancer]
  type ClientCertificateRevocationListStatusCode        = String
  type ClientVpnAuthenticationList                      = js.Array[ClientVpnAuthentication]
  type ClientVpnAuthenticationRequestList               = js.Array[ClientVpnAuthenticationRequest]
  type ClientVpnAuthenticationType                      = String
  type ClientVpnAuthorizationRuleStatusCode             = String
  type ClientVpnConnectionSet                           = js.Array[ClientVpnConnection]
  type ClientVpnConnectionStatusCode                    = String
  type ClientVpnEndpointStatusCode                      = String
  type ClientVpnRouteSet                                = js.Array[ClientVpnRoute]
  type ClientVpnRouteStatusCode                         = String
  type ClientVpnSecurityGroupIdSet                      = js.Array[String]
  type ConnectionNotificationSet                        = js.Array[ConnectionNotification]
  type ConnectionNotificationState                      = String
  type ConnectionNotificationType                       = String
  type ContainerFormat                                  = String
  type ConversionIdStringList                           = js.Array[String]
  type ConversionTaskState                              = String
  type CopyTagsFromSource                               = String
  type CreateFleetErrorsSet                             = js.Array[CreateFleetError]
  type CreateFleetInstancesSet                          = js.Array[CreateFleetInstance]
  type CreateVolumePermissionList                       = js.Array[CreateVolumePermission]
  type CurrencyCodeValues                               = String
  type CustomerGatewayIdStringList                      = js.Array[String]
  type CustomerGatewayList                              = js.Array[CustomerGateway]
  type DatafeedSubscriptionState                        = String
  type DateTime                                         = js.Date
  type DefaultRouteTableAssociationValue                = String
  type DefaultRouteTablePropagationValue                = String
  type DefaultTargetCapacityType                        = String
  type DeleteFleetErrorCode                             = String
  type DeleteFleetErrorSet                              = js.Array[DeleteFleetErrorItem]
  type DeleteFleetSuccessSet                            = js.Array[DeleteFleetSuccessItem]
  type DeleteLaunchTemplateVersionsResponseErrorSet     = js.Array[DeleteLaunchTemplateVersionsResponseErrorItem]
  type DeleteLaunchTemplateVersionsResponseSuccessSet   = js.Array[DeleteLaunchTemplateVersionsResponseSuccessItem]
  type DescribeByoipCidrsMaxResults                     = Int
  type DescribeCapacityReservationsMaxResults           = Int
  type DescribeClassicLinkInstancesMaxResults           = Int
  type DescribeClientVpnAuthorizationRulesMaxResults    = Int
  type DescribeClientVpnConnectionsMaxResults           = Int
  type DescribeClientVpnEndpointMaxResults              = Int
  type DescribeClientVpnRoutesMaxResults                = Int
  type DescribeClientVpnTargetNetworksMaxResults        = Int
  type DescribeConversionTaskList                       = js.Array[ConversionTask]
  type DescribeDhcpOptionsMaxResults                    = Int
  type DescribeEgressOnlyInternetGatewaysMaxResults     = Int
  type DescribeElasticGpusMaxResults                    = Int
  type DescribeExportImageTasksMaxResults               = Int
  type DescribeFleetsErrorSet                           = js.Array[DescribeFleetError]
  type DescribeFleetsInstancesSet                       = js.Array[DescribeFleetsInstances]
  type DescribeFpgaImagesMaxResults                     = Int
  type DescribeHostReservationsMaxResults               = Int
  type DescribeIamInstanceProfileAssociationsMaxResults = Int
  type DescribeInstanceCreditSpecificationsMaxResults   = Int
  type DescribeInternetGatewaysMaxResults               = Int
  type DescribeLaunchTemplatesMaxResults                = Int
  type DescribeMovingAddressesMaxResults                = Int
  type DescribeNatGatewaysMaxResults                    = Int
  type DescribeNetworkAclsMaxResults                    = Int
  type DescribeNetworkInterfacePermissionsMaxResults    = Int
  type DescribeNetworkInterfacesMaxResults              = Int
  type DescribePrincipalIdFormatMaxResults              = Int
  type DescribeRouteTablesMaxResults                    = Int
  type DescribeScheduledInstanceAvailabilityMaxResults  = Int
  type DescribeSecurityGroupsMaxResults                 = Int
  type DescribeSpotFleetInstancesMaxResults             = Int
  type DescribeSpotFleetRequestHistoryMaxResults        = Int
  type DescribeStaleSecurityGroupsMaxResults            = Int
  type DescribeStaleSecurityGroupsNextToken             = String
  type DescribeSubnetsMaxResults                        = Int
  type DescribeVpcClassicLinkDnsSupportMaxResults       = Int
  type DescribeVpcClassicLinkDnsSupportNextToken        = String
  type DescribeVpcPeeringConnectionsMaxResults          = Int
  type DescribeVpcsMaxResults                           = Int
  type DeviceType                                       = String
  type DhcpConfigurationList                            = js.Array[DhcpConfiguration]
  type DhcpConfigurationValueList                       = js.Array[AttributeValue]
  type DhcpOptionsIdStringList                          = js.Array[String]
  type DhcpOptionsList                                  = js.Array[DhcpOptions]
  type DiskImageFormat                                  = String
  type DiskImageList                                    = js.Array[DiskImage]
  type DnsEntrySet                                      = js.Array[DnsEntry]
  type DnsSupportValue                                  = String
  type DomainType                                       = String
  type EgressOnlyInternetGatewayId                      = String
  type EgressOnlyInternetGatewayIdList                  = js.Array[EgressOnlyInternetGatewayId]
  type EgressOnlyInternetGatewayList                    = js.Array[EgressOnlyInternetGateway]
  type ElasticGpuAssociationList                        = js.Array[ElasticGpuAssociation]
  type ElasticGpuIdSet                                  = js.Array[String]
  type ElasticGpuSet                                    = js.Array[ElasticGpus]
  type ElasticGpuSpecificationList                      = js.Array[ElasticGpuSpecification]
  type ElasticGpuSpecificationResponseList              = js.Array[ElasticGpuSpecificationResponse]
  type ElasticGpuSpecifications                         = js.Array[ElasticGpuSpecification]
  type ElasticGpuState                                  = String
  type ElasticGpuStatus                                 = String
  type ElasticInferenceAcceleratorAssociationList       = js.Array[ElasticInferenceAcceleratorAssociation]
  type ElasticInferenceAccelerators                     = js.Array[ElasticInferenceAccelerator]
  type EndDateType                                      = String
  type EndpointSet                                      = js.Array[ClientVpnEndpoint]
  type EventCode                                        = String
  type EventType                                        = String
  type ExcessCapacityTerminationPolicy                  = String
  type ExecutableByStringList                           = js.Array[String]
  type ExportEnvironment                                = String
  type ExportImageTaskIdList                            = js.Array[String]
  type ExportImageTaskList                              = js.Array[ExportImageTask]
  type ExportTaskIdStringList                           = js.Array[String]
  type ExportTaskList                                   = js.Array[ExportTask]
  type ExportTaskState                                  = String
  type FilterList                                       = js.Array[Filter]
  type FleetActivityStatus                              = String
  type FleetEventType                                   = String
  type FleetExcessCapacityTerminationPolicy             = String
  type FleetIdSet                                       = js.Array[FleetIdentifier]
  type FleetIdentifier                                  = String
  type FleetLaunchTemplateConfigList                    = js.Array[FleetLaunchTemplateConfig]
  type FleetLaunchTemplateConfigListRequest             = js.Array[FleetLaunchTemplateConfigRequest]
  type FleetLaunchTemplateOverridesList                 = js.Array[FleetLaunchTemplateOverrides]
  type FleetLaunchTemplateOverridesListRequest          = js.Array[FleetLaunchTemplateOverridesRequest]
  type FleetOnDemandAllocationStrategy                  = String
  type FleetSet                                         = js.Array[FleetData]
  type FleetStateCode                                   = String
  type FleetType                                        = String
  type FlowLogSet                                       = js.Array[FlowLog]
  type FlowLogsResourceType                             = String
  type FpgaImageAttributeName                           = String
  type FpgaImageIdList                                  = js.Array[String]
  type FpgaImageList                                    = js.Array[FpgaImage]
  type FpgaImageStateCode                               = String
  type GatewayType                                      = String
  type GetCapacityReservationUsageRequestMaxResults     = Int
  type GroupIdStringList                                = js.Array[String]
  type GroupIdentifierList                              = js.Array[GroupIdentifier]
  type GroupIdentifierSet                               = js.Array[SecurityGroupIdentifier]
  type GroupIds                                         = js.Array[String]
  type GroupNameStringList                              = js.Array[String]
  type HistoryRecordSet                                 = js.Array[HistoryRecordEntry]
  type HistoryRecords                                   = js.Array[HistoryRecord]
  type HostInstanceList                                 = js.Array[HostInstance]
  type HostList                                         = js.Array[Host]
  type HostOfferingSet                                  = js.Array[HostOffering]
  type HostRecovery                                     = String
  type HostReservationIdSet                             = js.Array[String]
  type HostReservationSet                               = js.Array[HostReservation]
  type HostTenancy                                      = String
  type HypervisorType                                   = String
  type IamInstanceProfileAssociationSet                 = js.Array[IamInstanceProfileAssociation]
  type IamInstanceProfileAssociationState               = String
  type IdFormatList                                     = js.Array[IdFormat]
  type ImageAttributeName                               = String
  type ImageDiskContainerList                           = js.Array[ImageDiskContainer]
  type ImageIdStringList                                = js.Array[String]
  type ImageList                                        = js.Array[Image]
  type ImageState                                       = String
  type ImageTypeValues                                  = String
  type ImportImageTaskList                              = js.Array[ImportImageTask]
  type ImportInstanceVolumeDetailSet                    = js.Array[ImportInstanceVolumeDetailItem]
  type ImportSnapshotTaskList                           = js.Array[ImportSnapshotTask]
  type ImportTaskIdList                                 = js.Array[String]
  type InstanceAttributeName                            = String
  type InstanceBlockDeviceMappingList                   = js.Array[InstanceBlockDeviceMapping]
  type InstanceBlockDeviceMappingSpecificationList      = js.Array[InstanceBlockDeviceMappingSpecification]
  type InstanceCountList                                = js.Array[InstanceCount]
  type InstanceCreditSpecificationList                  = js.Array[InstanceCreditSpecification]
  type InstanceCreditSpecificationListRequest           = js.Array[InstanceCreditSpecificationRequest]
  type InstanceEventId                                  = String
  type InstanceHealthStatus                             = String
  type InstanceId                                       = String
  type InstanceIdSet                                    = js.Array[String]
  type InstanceIdStringList                             = js.Array[String]
  type InstanceIdsSet                                   = js.Array[InstanceId]
  type InstanceInterruptionBehavior                     = String
  type InstanceIpv6AddressList                          = js.Array[InstanceIpv6Address]
  type InstanceIpv6AddressListRequest                   = js.Array[InstanceIpv6AddressRequest]
  type InstanceLifecycle                                = String
  type InstanceLifecycleType                            = String
  type InstanceList                                     = js.Array[Instance]
  type InstanceMatchCriteria                            = String
  type InstanceMonitoringList                           = js.Array[InstanceMonitoring]
  type InstanceNetworkInterfaceList                     = js.Array[InstanceNetworkInterface]
  type InstanceNetworkInterfaceSpecificationList        = js.Array[InstanceNetworkInterfaceSpecification]
  type InstancePrivateIpAddressList                     = js.Array[InstancePrivateIpAddress]
  type InstanceStateChangeList                          = js.Array[InstanceStateChange]
  type InstanceStateName                                = String
  type InstanceStatusDetailsList                        = js.Array[InstanceStatusDetails]
  type InstanceStatusEventList                          = js.Array[InstanceStatusEvent]
  type InstanceStatusList                               = js.Array[InstanceStatus]
  type InstanceType                                     = String
  type InstanceTypeList                                 = js.Array[InstanceType]
  type InstanceUsageSet                                 = js.Array[InstanceUsage]
  type InterfacePermissionType                          = String
  type InternetGatewayAttachmentList                    = js.Array[InternetGatewayAttachment]
  type InternetGatewayList                              = js.Array[InternetGateway]
  type IpPermissionList                                 = js.Array[IpPermission]
  type IpRangeList                                      = js.Array[IpRange]
  type IpRanges                                         = js.Array[String]
  type Ipv6Address                                      = String
  type Ipv6AddressList                                  = js.Array[String]
  type Ipv6CidrBlockSet                                 = js.Array[Ipv6CidrBlock]
  type Ipv6RangeList                                    = js.Array[Ipv6Range]
  type Ipv6SupportValue                                 = String
  type KeyNameStringList                                = js.Array[String]
  type KeyPairList                                      = js.Array[KeyPairInfo]
  type LaunchPermissionList                             = js.Array[LaunchPermission]
  type LaunchSpecsList                                  = js.Array[SpotFleetLaunchSpecification]
  type LaunchTemplateBlockDeviceMappingList             = js.Array[LaunchTemplateBlockDeviceMapping]
  type LaunchTemplateBlockDeviceMappingRequestList      = js.Array[LaunchTemplateBlockDeviceMappingRequest]
  type LaunchTemplateConfigList                         = js.Array[LaunchTemplateConfig]
  type LaunchTemplateElasticInferenceAcceleratorList    = js.Array[LaunchTemplateElasticInferenceAccelerator]
  type LaunchTemplateElasticInferenceAcceleratorResponseList =
    js.Array[LaunchTemplateElasticInferenceAcceleratorResponse]
  type LaunchTemplateErrorCode = String
  type LaunchTemplateInstanceNetworkInterfaceSpecificationList =
    js.Array[LaunchTemplateInstanceNetworkInterfaceSpecification]
  type LaunchTemplateInstanceNetworkInterfaceSpecificationRequestList =
    js.Array[LaunchTemplateInstanceNetworkInterfaceSpecificationRequest]
  type LaunchTemplateLicenseList                        = js.Array[LaunchTemplateLicenseConfiguration]
  type LaunchTemplateLicenseSpecificationListRequest    = js.Array[LaunchTemplateLicenseConfigurationRequest]
  type LaunchTemplateName                               = String
  type LaunchTemplateNameStringList                     = js.Array[LaunchTemplateName]
  type LaunchTemplateOverridesList                      = js.Array[LaunchTemplateOverrides]
  type LaunchTemplateSet                                = js.Array[LaunchTemplate]
  type LaunchTemplateTagSpecificationList               = js.Array[LaunchTemplateTagSpecification]
  type LaunchTemplateTagSpecificationRequestList        = js.Array[LaunchTemplateTagSpecificationRequest]
  type LaunchTemplateVersionSet                         = js.Array[LaunchTemplateVersion]
  type LicenseList                                      = js.Array[LicenseConfiguration]
  type LicenseSpecificationListRequest                  = js.Array[LicenseConfigurationRequest]
  type ListingState                                     = String
  type ListingStatus                                    = String
  type LoadPermissionList                               = js.Array[LoadPermission]
  type LoadPermissionListRequest                        = js.Array[LoadPermissionRequest]
  type LogDestinationType                               = String
  type MarketType                                       = String
  type MillisecondDateTime                              = js.Date
  type MonitoringState                                  = String
  type MoveStatus                                       = String
  type MovingAddressStatusSet                           = js.Array[MovingAddressStatus]
  type NatGatewayAddressList                            = js.Array[NatGatewayAddress]
  type NatGatewayList                                   = js.Array[NatGateway]
  type NatGatewayState                                  = String
  type NetworkAclAssociationList                        = js.Array[NetworkAclAssociation]
  type NetworkAclEntryList                              = js.Array[NetworkAclEntry]
  type NetworkAclList                                   = js.Array[NetworkAcl]
  type NetworkInterfaceAttribute                        = String
  type NetworkInterfaceCreationType                     = String
  type NetworkInterfaceIdList                           = js.Array[String]
  type NetworkInterfaceIpv6AddressesList                = js.Array[NetworkInterfaceIpv6Address]
  type NetworkInterfaceList                             = js.Array[NetworkInterface]
  type NetworkInterfacePermissionIdList                 = js.Array[String]
  type NetworkInterfacePermissionList                   = js.Array[NetworkInterfacePermission]
  type NetworkInterfacePermissionStateCode              = String
  type NetworkInterfacePrivateIpAddressList             = js.Array[NetworkInterfacePrivateIpAddress]
  type NetworkInterfaceStatus                           = String
  type NetworkInterfaceType                             = String
  type NewDhcpConfigurationList                         = js.Array[NewDhcpConfiguration]
  type NextToken                                        = String
  type OccurrenceDayRequestSet                          = js.Array[Int]
  type OccurrenceDaySet                                 = js.Array[Int]
  type OfferingClassType                                = String
  type OfferingTypeValues                               = String
  type OnDemandAllocationStrategy                       = String
  type OperationType                                    = String
  type OwnerStringList                                  = js.Array[String]
  type PaymentOption                                    = String
  type PermissionGroup                                  = String
  type PlacementGroupList                               = js.Array[PlacementGroup]
  type PlacementGroupState                              = String
  type PlacementGroupStringList                         = js.Array[String]
  type PlacementStrategy                                = String
  type PlatformValues                                   = String
  type PoolMaxResults                                   = Int
  type PrefixListIdList                                 = js.Array[PrefixListId]
  type PrefixListIdSet                                  = js.Array[String]
  type PrefixListSet                                    = js.Array[PrefixList]
  type PriceScheduleList                                = js.Array[PriceSchedule]
  type PriceScheduleSpecificationList                   = js.Array[PriceScheduleSpecification]
  type PricingDetailsList                               = js.Array[PricingDetail]
  type PrincipalIdFormatList                            = js.Array[PrincipalIdFormat]
  type PrincipalType                                    = String
  type PrivateIpAddressConfigSet                        = js.Array[ScheduledInstancesPrivateIpAddressConfig]
  type PrivateIpAddressSpecificationList                = js.Array[PrivateIpAddressSpecification]
  type PrivateIpAddressStringList                       = js.Array[String]
  type ProductCodeList                                  = js.Array[ProductCode]
  type ProductCodeStringList                            = js.Array[String]
  type ProductCodeValues                                = String
  type ProductDescriptionList                           = js.Array[String]
  type PropagatingVgwList                               = js.Array[PropagatingVgw]
  type PublicIpStringList                               = js.Array[String]
  type PublicIpv4PoolRangeSet                           = js.Array[PublicIpv4PoolRange]
  type PublicIpv4PoolSet                                = js.Array[PublicIpv4Pool]
  type PurchaseRequestSet                               = js.Array[PurchaseRequest]
  type PurchaseSet                                      = js.Array[Purchase]
  type PurchasedScheduledInstanceSet                    = js.Array[ScheduledInstance]
  type RIProductDescription                             = String
  type ReasonCodesList                                  = js.Array[ReportInstanceReasonCodes]
  type RecurringChargeFrequency                         = String
  type RecurringChargesList                             = js.Array[RecurringCharge]
  type RegionList                                       = js.Array[Region]
  type RegionNameStringList                             = js.Array[String]
  type ReportInstanceReasonCodes                        = String
  type ReportStatusType                                 = String
  type RequestHostIdList                                = js.Array[String]
  type RequestHostIdSet                                 = js.Array[String]
  type ReservationList                                  = js.Array[Reservation]
  type ReservationState                                 = String
  type ReservedInstanceIdSet                            = js.Array[String]
  type ReservedInstanceReservationValueSet              = js.Array[ReservedInstanceReservationValue]
  type ReservedInstanceState                            = String
  type ReservedInstancesConfigurationList               = js.Array[ReservedInstancesConfiguration]
  type ReservedInstancesIdStringList                    = js.Array[String]
  type ReservedInstancesList                            = js.Array[ReservedInstances]
  type ReservedInstancesListingList                     = js.Array[ReservedInstancesListing]
  type ReservedInstancesModificationIdStringList        = js.Array[String]
  type ReservedInstancesModificationList                = js.Array[ReservedInstancesModification]
  type ReservedInstancesModificationResultList          = js.Array[ReservedInstancesModificationResult]
  type ReservedInstancesOfferingIdStringList            = js.Array[String]
  type ReservedInstancesOfferingList                    = js.Array[ReservedInstancesOffering]
  type ReservedIntancesIds                              = js.Array[ReservedInstancesId]
  type ResetFpgaImageAttributeName                      = String
  type ResetImageAttributeName                          = String
  type ResourceIdList                                   = js.Array[String]
  type ResourceList                                     = js.Array[String]
  type ResourceType                                     = String
  type ResponseHostIdList                               = js.Array[String]
  type ResponseHostIdSet                                = js.Array[String]
  type RestorableByStringList                           = js.Array[String]
  type RouteList                                        = js.Array[Route]
  type RouteOrigin                                      = String
  type RouteState                                       = String
  type RouteTableAssociationList                        = js.Array[RouteTableAssociation]
  type RouteTableList                                   = js.Array[RouteTable]
  type RuleAction                                       = String
  type ScheduledInstanceAvailabilitySet                 = js.Array[ScheduledInstanceAvailability]
  type ScheduledInstanceIdRequestSet                    = js.Array[String]
  type ScheduledInstanceSet                             = js.Array[ScheduledInstance]
  type ScheduledInstancesBlockDeviceMappingSet          = js.Array[ScheduledInstancesBlockDeviceMapping]
  type ScheduledInstancesIpv6AddressList                = js.Array[ScheduledInstancesIpv6Address]
  type ScheduledInstancesNetworkInterfaceSet            = js.Array[ScheduledInstancesNetworkInterface]
  type ScheduledInstancesSecurityGroupIdSet             = js.Array[String]
  type SecurityGroupIdStringList                        = js.Array[String]
  type SecurityGroupList                                = js.Array[SecurityGroup]
  type SecurityGroupReferences                          = js.Array[SecurityGroupReference]
  type SecurityGroupStringList                          = js.Array[String]
  type ServiceConfigurationSet                          = js.Array[ServiceConfiguration]
  type ServiceDetailSet                                 = js.Array[ServiceDetail]
  type ServiceState                                     = String
  type ServiceType                                      = String
  type ServiceTypeDetailSet                             = js.Array[ServiceTypeDetail]
  type ShutdownBehavior                                 = String
  type SnapshotAttributeName                            = String
  type SnapshotDetailList                               = js.Array[SnapshotDetail]
  type SnapshotIdStringList                             = js.Array[String]
  type SnapshotList                                     = js.Array[Snapshot]
  type SnapshotSet                                      = js.Array[SnapshotInfo]
  type SnapshotState                                    = String
  type SpotAllocationStrategy                           = String
  type SpotFleetRequestConfigSet                        = js.Array[SpotFleetRequestConfig]
  type SpotFleetTagSpecificationList                    = js.Array[SpotFleetTagSpecification]
  type SpotInstanceInterruptionBehavior                 = String
  type SpotInstanceRequestIdList                        = js.Array[String]
  type SpotInstanceRequestList                          = js.Array[SpotInstanceRequest]
  type SpotInstanceState                                = String
  type SpotInstanceType                                 = String
  type SpotPriceHistoryList                             = js.Array[SpotPrice]
  type StaleIpPermissionSet                             = js.Array[StaleIpPermission]
  type StaleSecurityGroupSet                            = js.Array[StaleSecurityGroup]
  type State                                            = String
  type Status                                           = String
  type StatusName                                       = String
  type StatusType                                       = String
  type SubnetCidrBlockStateCode                         = String
  type SubnetIdStringList                               = js.Array[String]
  type SubnetIpv6CidrBlockAssociationSet                = js.Array[SubnetIpv6CidrBlockAssociation]
  type SubnetList                                       = js.Array[Subnet]
  type SubnetState                                      = String
  type SuccessfulInstanceCreditSpecificationSet         = js.Array[SuccessfulInstanceCreditSpecificationItem]
  type SummaryStatus                                    = String
  type TagDescriptionList                               = js.Array[TagDescription]
  type TagList                                          = js.Array[Tag]
  type TagSpecificationList                             = js.Array[TagSpecification]
  type TargetConfigurationRequestSet                    = js.Array[TargetConfigurationRequest]
  type TargetGroups                                     = js.Array[TargetGroup]
  type TargetNetworkSet                                 = js.Array[TargetNetwork]
  type TargetReservationValueSet                        = js.Array[TargetReservationValue]
  type TelemetryStatus                                  = String
  type Tenancy                                          = String
  type TerminateConnectionStatusSet                     = js.Array[TerminateConnectionStatus]
  type TrafficDirection                                 = String
  type TrafficMirrorFilterRuleField                     = String
  type TrafficMirrorFilterRuleFieldList                 = js.Array[TrafficMirrorFilterRuleField]
  type TrafficMirrorFilterRuleList                      = js.Array[TrafficMirrorFilterRule]
  type TrafficMirrorFilterSet                           = js.Array[TrafficMirrorFilter]
  type TrafficMirrorNetworkService                      = String
  type TrafficMirrorNetworkServiceList                  = js.Array[TrafficMirrorNetworkService]
  type TrafficMirrorRuleAction                          = String
  type TrafficMirrorSessionField                        = String
  type TrafficMirrorSessionFieldList                    = js.Array[TrafficMirrorSessionField]
  type TrafficMirrorSessionSet                          = js.Array[TrafficMirrorSession]
  type TrafficMirrorTargetSet                           = js.Array[TrafficMirrorTarget]
  type TrafficMirrorTargetType                          = String
  type TrafficMirroringMaxResults                       = Int
  type TrafficType                                      = String
  type TransitGatewayAssociationState                   = String
  type TransitGatewayAttachmentIdStringList             = js.Array[String]
  type TransitGatewayAttachmentList                     = js.Array[TransitGatewayAttachment]
  type TransitGatewayAttachmentPropagationList          = js.Array[TransitGatewayAttachmentPropagation]
  type TransitGatewayAttachmentResourceType             = String
  type TransitGatewayAttachmentState                    = String
  type TransitGatewayIdStringList                       = js.Array[String]
  type TransitGatewayList                               = js.Array[TransitGateway]
  type TransitGatewayMaxResults                         = Int
  type TransitGatewayPropagationState                   = String
  type TransitGatewayRouteAttachmentList                = js.Array[TransitGatewayRouteAttachment]
  type TransitGatewayRouteList                          = js.Array[TransitGatewayRoute]
  type TransitGatewayRouteState                         = String
  type TransitGatewayRouteTableAssociationList          = js.Array[TransitGatewayRouteTableAssociation]
  type TransitGatewayRouteTableIdStringList             = js.Array[String]
  type TransitGatewayRouteTableList                     = js.Array[TransitGatewayRouteTable]
  type TransitGatewayRouteTablePropagationList          = js.Array[TransitGatewayRouteTablePropagation]
  type TransitGatewayRouteTableState                    = String
  type TransitGatewayRouteType                          = String
  type TransitGatewayState                              = String
  type TransitGatewayVpcAttachmentList                  = js.Array[TransitGatewayVpcAttachment]
  type TransportProtocol                                = String
  type TunnelOptionsList                                = js.Array[VpnTunnelOptionsSpecification]
  type UnsuccessfulInstanceCreditSpecificationErrorCode = String
  type UnsuccessfulInstanceCreditSpecificationSet       = js.Array[UnsuccessfulInstanceCreditSpecificationItem]
  type UnsuccessfulItemList                             = js.Array[UnsuccessfulItem]
  type UnsuccessfulItemSet                              = js.Array[UnsuccessfulItem]
  type UserGroupStringList                              = js.Array[String]
  type UserIdGroupPairList                              = js.Array[UserIdGroupPair]
  type UserIdGroupPairSet                               = js.Array[UserIdGroupPair]
  type UserIdStringList                                 = js.Array[String]
  type ValueStringList                                  = js.Array[String]
  type VersionDescription                               = String
  type VersionStringList                                = js.Array[String]
  type VgwTelemetryList                                 = js.Array[VgwTelemetry]
  type VirtualizationType                               = String
  type VolumeAttachmentList                             = js.Array[VolumeAttachment]
  type VolumeAttachmentState                            = String
  type VolumeAttributeName                              = String
  type VolumeIdStringList                               = js.Array[String]
  type VolumeList                                       = js.Array[Volume]
  type VolumeModificationList                           = js.Array[VolumeModification]
  type VolumeModificationState                          = String
  type VolumeState                                      = String
  type VolumeStatusActionsList                          = js.Array[VolumeStatusAction]
  type VolumeStatusDetailsList                          = js.Array[VolumeStatusDetails]
  type VolumeStatusEventsList                           = js.Array[VolumeStatusEvent]
  type VolumeStatusInfoStatus                           = String
  type VolumeStatusList                                 = js.Array[VolumeStatusItem]
  type VolumeStatusName                                 = String
  type VolumeType                                       = String
  type VpcAttachmentList                                = js.Array[VpcAttachment]
  type VpcAttributeName                                 = String
  type VpcCidrBlockAssociationSet                       = js.Array[VpcCidrBlockAssociation]
  type VpcCidrBlockStateCode                            = String
  type VpcClassicLinkIdList                             = js.Array[String]
  type VpcClassicLinkList                               = js.Array[VpcClassicLink]
  type VpcEndpointConnectionSet                         = js.Array[VpcEndpointConnection]
  type VpcEndpointSet                                   = js.Array[VpcEndpoint]
  type VpcEndpointType                                  = String
  type VpcIdStringList                                  = js.Array[String]
  type VpcIpv6CidrBlockAssociationSet                   = js.Array[VpcIpv6CidrBlockAssociation]
  type VpcList                                          = js.Array[Vpc]
  type VpcPeeringConnectionList                         = js.Array[VpcPeeringConnection]
  type VpcPeeringConnectionStateReasonCode              = String
  type VpcState                                         = String
  type VpcTenancy                                       = String
  type VpnConnectionIdStringList                        = js.Array[String]
  type VpnConnectionList                                = js.Array[VpnConnection]
  type VpnEcmpSupportValue                              = String
  type VpnGatewayIdStringList                           = js.Array[String]
  type VpnGatewayList                                   = js.Array[VpnGateway]
  type VpnProtocol                                      = String
  type VpnState                                         = String
  type VpnStaticRouteList                               = js.Array[VpnStaticRoute]
  type VpnStaticRouteSource                             = String
  type ZoneIdStringList                                 = js.Array[String]
  type ZoneNameStringList                               = js.Array[String]
  type scope                                            = String

  implicit final class EC2Ops(private val service: EC2) extends AnyVal {

    @inline def acceptReservedInstancesExchangeQuoteFuture(
        params: AcceptReservedInstancesExchangeQuoteRequest
    ): Future[AcceptReservedInstancesExchangeQuoteResult] =
      service.acceptReservedInstancesExchangeQuote(params).promise.toFuture
    @inline def acceptTransitGatewayVpcAttachmentFuture(
        params: AcceptTransitGatewayVpcAttachmentRequest
    ): Future[AcceptTransitGatewayVpcAttachmentResult] =
      service.acceptTransitGatewayVpcAttachment(params).promise.toFuture
    @inline def acceptVpcEndpointConnectionsFuture(
        params: AcceptVpcEndpointConnectionsRequest
    ): Future[AcceptVpcEndpointConnectionsResult] = service.acceptVpcEndpointConnections(params).promise.toFuture
    @inline def acceptVpcPeeringConnectionFuture(
        params: AcceptVpcPeeringConnectionRequest
    ): Future[AcceptVpcPeeringConnectionResult] = service.acceptVpcPeeringConnection(params).promise.toFuture
    @inline def advertiseByoipCidrFuture(params: AdvertiseByoipCidrRequest): Future[AdvertiseByoipCidrResult] =
      service.advertiseByoipCidr(params).promise.toFuture
    @inline def allocateAddressFuture(params: AllocateAddressRequest): Future[AllocateAddressResult] =
      service.allocateAddress(params).promise.toFuture
    @inline def allocateHostsFuture(params: AllocateHostsRequest): Future[AllocateHostsResult] =
      service.allocateHosts(params).promise.toFuture
    @inline def applySecurityGroupsToClientVpnTargetNetworkFuture(
        params: ApplySecurityGroupsToClientVpnTargetNetworkRequest
    ): Future[ApplySecurityGroupsToClientVpnTargetNetworkResult] =
      service.applySecurityGroupsToClientVpnTargetNetwork(params).promise.toFuture
    @inline def assignIpv6AddressesFuture(params: AssignIpv6AddressesRequest): Future[AssignIpv6AddressesResult] =
      service.assignIpv6Addresses(params).promise.toFuture
    @inline def assignPrivateIpAddressesFuture(
        params: AssignPrivateIpAddressesRequest
    ): Future[AssignPrivateIpAddressesResult] = service.assignPrivateIpAddresses(params).promise.toFuture
    @inline def associateAddressFuture(params: AssociateAddressRequest): Future[AssociateAddressResult] =
      service.associateAddress(params).promise.toFuture
    @inline def associateClientVpnTargetNetworkFuture(
        params: AssociateClientVpnTargetNetworkRequest
    ): Future[AssociateClientVpnTargetNetworkResult] = service.associateClientVpnTargetNetwork(params).promise.toFuture
    @inline def associateDhcpOptionsFuture(params: AssociateDhcpOptionsRequest): Future[js.Object] =
      service.associateDhcpOptions(params).promise.toFuture
    @inline def associateIamInstanceProfileFuture(
        params: AssociateIamInstanceProfileRequest
    ): Future[AssociateIamInstanceProfileResult] = service.associateIamInstanceProfile(params).promise.toFuture
    @inline def associateRouteTableFuture(params: AssociateRouteTableRequest): Future[AssociateRouteTableResult] =
      service.associateRouteTable(params).promise.toFuture
    @inline def associateSubnetCidrBlockFuture(
        params: AssociateSubnetCidrBlockRequest
    ): Future[AssociateSubnetCidrBlockResult] = service.associateSubnetCidrBlock(params).promise.toFuture
    @inline def associateTransitGatewayRouteTableFuture(
        params: AssociateTransitGatewayRouteTableRequest
    ): Future[AssociateTransitGatewayRouteTableResult] =
      service.associateTransitGatewayRouteTable(params).promise.toFuture
    @inline def associateVpcCidrBlockFuture(params: AssociateVpcCidrBlockRequest): Future[AssociateVpcCidrBlockResult] =
      service.associateVpcCidrBlock(params).promise.toFuture
    @inline def attachClassicLinkVpcFuture(params: AttachClassicLinkVpcRequest): Future[AttachClassicLinkVpcResult] =
      service.attachClassicLinkVpc(params).promise.toFuture
    @inline def attachInternetGatewayFuture(params: AttachInternetGatewayRequest): Future[js.Object] =
      service.attachInternetGateway(params).promise.toFuture
    @inline def attachNetworkInterfaceFuture(
        params: AttachNetworkInterfaceRequest
    ): Future[AttachNetworkInterfaceResult] = service.attachNetworkInterface(params).promise.toFuture
    @inline def attachVolumeFuture(params: AttachVolumeRequest): Future[VolumeAttachment] =
      service.attachVolume(params).promise.toFuture
    @inline def attachVpnGatewayFuture(params: AttachVpnGatewayRequest): Future[AttachVpnGatewayResult] =
      service.attachVpnGateway(params).promise.toFuture
    @inline def authorizeClientVpnIngressFuture(
        params: AuthorizeClientVpnIngressRequest
    ): Future[AuthorizeClientVpnIngressResult] = service.authorizeClientVpnIngress(params).promise.toFuture
    @inline def authorizeSecurityGroupEgressFuture(params: AuthorizeSecurityGroupEgressRequest): Future[js.Object] =
      service.authorizeSecurityGroupEgress(params).promise.toFuture
    @inline def authorizeSecurityGroupIngressFuture(params: AuthorizeSecurityGroupIngressRequest): Future[js.Object] =
      service.authorizeSecurityGroupIngress(params).promise.toFuture
    @inline def bundleInstanceFuture(params: BundleInstanceRequest): Future[BundleInstanceResult] =
      service.bundleInstance(params).promise.toFuture
    @inline def cancelBundleTaskFuture(params: CancelBundleTaskRequest): Future[CancelBundleTaskResult] =
      service.cancelBundleTask(params).promise.toFuture
    @inline def cancelCapacityReservationFuture(
        params: CancelCapacityReservationRequest
    ): Future[CancelCapacityReservationResult] = service.cancelCapacityReservation(params).promise.toFuture
    @inline def cancelConversionTaskFuture(params: CancelConversionRequest): Future[js.Object] =
      service.cancelConversionTask(params).promise.toFuture
    @inline def cancelExportTaskFuture(params: CancelExportTaskRequest): Future[js.Object] =
      service.cancelExportTask(params).promise.toFuture
    @inline def cancelImportTaskFuture(params: CancelImportTaskRequest): Future[CancelImportTaskResult] =
      service.cancelImportTask(params).promise.toFuture
    @inline def cancelReservedInstancesListingFuture(
        params: CancelReservedInstancesListingRequest
    ): Future[CancelReservedInstancesListingResult] = service.cancelReservedInstancesListing(params).promise.toFuture
    @inline def cancelSpotFleetRequestsFuture(
        params: CancelSpotFleetRequestsRequest
    ): Future[CancelSpotFleetRequestsResponse] = service.cancelSpotFleetRequests(params).promise.toFuture
    @inline def cancelSpotInstanceRequestsFuture(
        params: CancelSpotInstanceRequestsRequest
    ): Future[CancelSpotInstanceRequestsResult] = service.cancelSpotInstanceRequests(params).promise.toFuture
    @inline def confirmProductInstanceFuture(
        params: ConfirmProductInstanceRequest
    ): Future[ConfirmProductInstanceResult] = service.confirmProductInstance(params).promise.toFuture
    @inline def copyFpgaImageFuture(params: CopyFpgaImageRequest): Future[CopyFpgaImageResult] =
      service.copyFpgaImage(params).promise.toFuture
    @inline def copyImageFuture(params: CopyImageRequest): Future[CopyImageResult] =
      service.copyImage(params).promise.toFuture
    @inline def copySnapshotFuture(params: CopySnapshotRequest): Future[CopySnapshotResult] =
      service.copySnapshot(params).promise.toFuture
    @inline def createCapacityReservationFuture(
        params: CreateCapacityReservationRequest
    ): Future[CreateCapacityReservationResult] = service.createCapacityReservation(params).promise.toFuture
    @inline def createClientVpnEndpointFuture(
        params: CreateClientVpnEndpointRequest
    ): Future[CreateClientVpnEndpointResult] = service.createClientVpnEndpoint(params).promise.toFuture
    @inline def createClientVpnRouteFuture(params: CreateClientVpnRouteRequest): Future[CreateClientVpnRouteResult] =
      service.createClientVpnRoute(params).promise.toFuture
    @inline def createCustomerGatewayFuture(params: CreateCustomerGatewayRequest): Future[CreateCustomerGatewayResult] =
      service.createCustomerGateway(params).promise.toFuture
    @inline def createDefaultSubnetFuture(params: CreateDefaultSubnetRequest): Future[CreateDefaultSubnetResult] =
      service.createDefaultSubnet(params).promise.toFuture
    @inline def createDefaultVpcFuture(params: CreateDefaultVpcRequest): Future[CreateDefaultVpcResult] =
      service.createDefaultVpc(params).promise.toFuture
    @inline def createDhcpOptionsFuture(params: CreateDhcpOptionsRequest): Future[CreateDhcpOptionsResult] =
      service.createDhcpOptions(params).promise.toFuture
    @inline def createEgressOnlyInternetGatewayFuture(
        params: CreateEgressOnlyInternetGatewayRequest
    ): Future[CreateEgressOnlyInternetGatewayResult] = service.createEgressOnlyInternetGateway(params).promise.toFuture
    @inline def createFleetFuture(params: CreateFleetRequest): Future[CreateFleetResult] =
      service.createFleet(params).promise.toFuture
    @inline def createFlowLogsFuture(params: CreateFlowLogsRequest): Future[CreateFlowLogsResult] =
      service.createFlowLogs(params).promise.toFuture
    @inline def createFpgaImageFuture(params: CreateFpgaImageRequest): Future[CreateFpgaImageResult] =
      service.createFpgaImage(params).promise.toFuture
    @inline def createImageFuture(params: CreateImageRequest): Future[CreateImageResult] =
      service.createImage(params).promise.toFuture
    @inline def createInstanceExportTaskFuture(
        params: CreateInstanceExportTaskRequest
    ): Future[CreateInstanceExportTaskResult] = service.createInstanceExportTask(params).promise.toFuture
    @inline def createInternetGatewayFuture(params: CreateInternetGatewayRequest): Future[CreateInternetGatewayResult] =
      service.createInternetGateway(params).promise.toFuture
    @inline def createKeyPairFuture(params: CreateKeyPairRequest): Future[KeyPair] =
      service.createKeyPair(params).promise.toFuture
    @inline def createLaunchTemplateFuture(params: CreateLaunchTemplateRequest): Future[CreateLaunchTemplateResult] =
      service.createLaunchTemplate(params).promise.toFuture
    @inline def createLaunchTemplateVersionFuture(
        params: CreateLaunchTemplateVersionRequest
    ): Future[CreateLaunchTemplateVersionResult] = service.createLaunchTemplateVersion(params).promise.toFuture
    @inline def createNatGatewayFuture(params: CreateNatGatewayRequest): Future[CreateNatGatewayResult] =
      service.createNatGateway(params).promise.toFuture
    @inline def createNetworkAclEntryFuture(params: CreateNetworkAclEntryRequest): Future[js.Object] =
      service.createNetworkAclEntry(params).promise.toFuture
    @inline def createNetworkAclFuture(params: CreateNetworkAclRequest): Future[CreateNetworkAclResult] =
      service.createNetworkAcl(params).promise.toFuture
    @inline def createNetworkInterfaceFuture(
        params: CreateNetworkInterfaceRequest
    ): Future[CreateNetworkInterfaceResult] = service.createNetworkInterface(params).promise.toFuture
    @inline def createNetworkInterfacePermissionFuture(
        params: CreateNetworkInterfacePermissionRequest
    ): Future[CreateNetworkInterfacePermissionResult] =
      service.createNetworkInterfacePermission(params).promise.toFuture
    @inline def createPlacementGroupFuture(params: CreatePlacementGroupRequest): Future[js.Object] =
      service.createPlacementGroup(params).promise.toFuture
    @inline def createReservedInstancesListingFuture(
        params: CreateReservedInstancesListingRequest
    ): Future[CreateReservedInstancesListingResult] = service.createReservedInstancesListing(params).promise.toFuture
    @inline def createRouteFuture(params: CreateRouteRequest): Future[CreateRouteResult] =
      service.createRoute(params).promise.toFuture
    @inline def createRouteTableFuture(params: CreateRouteTableRequest): Future[CreateRouteTableResult] =
      service.createRouteTable(params).promise.toFuture
    @inline def createSecurityGroupFuture(params: CreateSecurityGroupRequest): Future[CreateSecurityGroupResult] =
      service.createSecurityGroup(params).promise.toFuture
    @inline def createSnapshotFuture(params: CreateSnapshotRequest): Future[Snapshot] =
      service.createSnapshot(params).promise.toFuture
    @inline def createSnapshotsFuture(params: CreateSnapshotsRequest): Future[CreateSnapshotsResult] =
      service.createSnapshots(params).promise.toFuture
    @inline def createSpotDatafeedSubscriptionFuture(
        params: CreateSpotDatafeedSubscriptionRequest
    ): Future[CreateSpotDatafeedSubscriptionResult] = service.createSpotDatafeedSubscription(params).promise.toFuture
    @inline def createSubnetFuture(params: CreateSubnetRequest): Future[CreateSubnetResult] =
      service.createSubnet(params).promise.toFuture
    @inline def createTagsFuture(params: CreateTagsRequest): Future[js.Object] =
      service.createTags(params).promise.toFuture
    @inline def createTrafficMirrorFilterFuture(
        params: CreateTrafficMirrorFilterRequest
    ): Future[CreateTrafficMirrorFilterResult] = service.createTrafficMirrorFilter(params).promise.toFuture
    @inline def createTrafficMirrorFilterRuleFuture(
        params: CreateTrafficMirrorFilterRuleRequest
    ): Future[CreateTrafficMirrorFilterRuleResult] = service.createTrafficMirrorFilterRule(params).promise.toFuture
    @inline def createTrafficMirrorSessionFuture(
        params: CreateTrafficMirrorSessionRequest
    ): Future[CreateTrafficMirrorSessionResult] = service.createTrafficMirrorSession(params).promise.toFuture
    @inline def createTrafficMirrorTargetFuture(
        params: CreateTrafficMirrorTargetRequest
    ): Future[CreateTrafficMirrorTargetResult] = service.createTrafficMirrorTarget(params).promise.toFuture
    @inline def createTransitGatewayFuture(params: CreateTransitGatewayRequest): Future[CreateTransitGatewayResult] =
      service.createTransitGateway(params).promise.toFuture
    @inline def createTransitGatewayRouteFuture(
        params: CreateTransitGatewayRouteRequest
    ): Future[CreateTransitGatewayRouteResult] = service.createTransitGatewayRoute(params).promise.toFuture
    @inline def createTransitGatewayRouteTableFuture(
        params: CreateTransitGatewayRouteTableRequest
    ): Future[CreateTransitGatewayRouteTableResult] = service.createTransitGatewayRouteTable(params).promise.toFuture
    @inline def createTransitGatewayVpcAttachmentFuture(
        params: CreateTransitGatewayVpcAttachmentRequest
    ): Future[CreateTransitGatewayVpcAttachmentResult] =
      service.createTransitGatewayVpcAttachment(params).promise.toFuture
    @inline def createVolumeFuture(params: CreateVolumeRequest): Future[Volume] =
      service.createVolume(params).promise.toFuture
    @inline def createVpcEndpointConnectionNotificationFuture(
        params: CreateVpcEndpointConnectionNotificationRequest
    ): Future[CreateVpcEndpointConnectionNotificationResult] =
      service.createVpcEndpointConnectionNotification(params).promise.toFuture
    @inline def createVpcEndpointFuture(params: CreateVpcEndpointRequest): Future[CreateVpcEndpointResult] =
      service.createVpcEndpoint(params).promise.toFuture
    @inline def createVpcEndpointServiceConfigurationFuture(
        params: CreateVpcEndpointServiceConfigurationRequest
    ): Future[CreateVpcEndpointServiceConfigurationResult] =
      service.createVpcEndpointServiceConfiguration(params).promise.toFuture
    @inline def createVpcFuture(params: CreateVpcRequest): Future[CreateVpcResult] =
      service.createVpc(params).promise.toFuture
    @inline def createVpcPeeringConnectionFuture(
        params: CreateVpcPeeringConnectionRequest
    ): Future[CreateVpcPeeringConnectionResult] = service.createVpcPeeringConnection(params).promise.toFuture
    @inline def createVpnConnectionFuture(params: CreateVpnConnectionRequest): Future[CreateVpnConnectionResult] =
      service.createVpnConnection(params).promise.toFuture
    @inline def createVpnConnectionRouteFuture(params: CreateVpnConnectionRouteRequest): Future[js.Object] =
      service.createVpnConnectionRoute(params).promise.toFuture
    @inline def createVpnGatewayFuture(params: CreateVpnGatewayRequest): Future[CreateVpnGatewayResult] =
      service.createVpnGateway(params).promise.toFuture
    @inline def deleteClientVpnEndpointFuture(
        params: DeleteClientVpnEndpointRequest
    ): Future[DeleteClientVpnEndpointResult] = service.deleteClientVpnEndpoint(params).promise.toFuture
    @inline def deleteClientVpnRouteFuture(params: DeleteClientVpnRouteRequest): Future[DeleteClientVpnRouteResult] =
      service.deleteClientVpnRoute(params).promise.toFuture
    @inline def deleteCustomerGatewayFuture(params: DeleteCustomerGatewayRequest): Future[js.Object] =
      service.deleteCustomerGateway(params).promise.toFuture
    @inline def deleteDhcpOptionsFuture(params: DeleteDhcpOptionsRequest): Future[js.Object] =
      service.deleteDhcpOptions(params).promise.toFuture
    @inline def deleteEgressOnlyInternetGatewayFuture(
        params: DeleteEgressOnlyInternetGatewayRequest
    ): Future[DeleteEgressOnlyInternetGatewayResult] = service.deleteEgressOnlyInternetGateway(params).promise.toFuture
    @inline def deleteFleetsFuture(params: DeleteFleetsRequest): Future[DeleteFleetsResult] =
      service.deleteFleets(params).promise.toFuture
    @inline def deleteFlowLogsFuture(params: DeleteFlowLogsRequest): Future[DeleteFlowLogsResult] =
      service.deleteFlowLogs(params).promise.toFuture
    @inline def deleteFpgaImageFuture(params: DeleteFpgaImageRequest): Future[DeleteFpgaImageResult] =
      service.deleteFpgaImage(params).promise.toFuture
    @inline def deleteInternetGatewayFuture(params: DeleteInternetGatewayRequest): Future[js.Object] =
      service.deleteInternetGateway(params).promise.toFuture
    @inline def deleteKeyPairFuture(params: DeleteKeyPairRequest): Future[js.Object] =
      service.deleteKeyPair(params).promise.toFuture
    @inline def deleteLaunchTemplateFuture(params: DeleteLaunchTemplateRequest): Future[DeleteLaunchTemplateResult] =
      service.deleteLaunchTemplate(params).promise.toFuture
    @inline def deleteLaunchTemplateVersionsFuture(
        params: DeleteLaunchTemplateVersionsRequest
    ): Future[DeleteLaunchTemplateVersionsResult] = service.deleteLaunchTemplateVersions(params).promise.toFuture
    @inline def deleteNatGatewayFuture(params: DeleteNatGatewayRequest): Future[DeleteNatGatewayResult] =
      service.deleteNatGateway(params).promise.toFuture
    @inline def deleteNetworkAclEntryFuture(params: DeleteNetworkAclEntryRequest): Future[js.Object] =
      service.deleteNetworkAclEntry(params).promise.toFuture
    @inline def deleteNetworkAclFuture(params: DeleteNetworkAclRequest): Future[js.Object] =
      service.deleteNetworkAcl(params).promise.toFuture
    @inline def deleteNetworkInterfaceFuture(params: DeleteNetworkInterfaceRequest): Future[js.Object] =
      service.deleteNetworkInterface(params).promise.toFuture
    @inline def deleteNetworkInterfacePermissionFuture(
        params: DeleteNetworkInterfacePermissionRequest
    ): Future[DeleteNetworkInterfacePermissionResult] =
      service.deleteNetworkInterfacePermission(params).promise.toFuture
    @inline def deletePlacementGroupFuture(params: DeletePlacementGroupRequest): Future[js.Object] =
      service.deletePlacementGroup(params).promise.toFuture
    @inline def deleteRouteFuture(params: DeleteRouteRequest): Future[js.Object] =
      service.deleteRoute(params).promise.toFuture
    @inline def deleteRouteTableFuture(params: DeleteRouteTableRequest): Future[js.Object] =
      service.deleteRouteTable(params).promise.toFuture
    @inline def deleteSecurityGroupFuture(params: DeleteSecurityGroupRequest): Future[js.Object] =
      service.deleteSecurityGroup(params).promise.toFuture
    @inline def deleteSnapshotFuture(params: DeleteSnapshotRequest): Future[js.Object] =
      service.deleteSnapshot(params).promise.toFuture
    @inline def deleteSpotDatafeedSubscriptionFuture(params: DeleteSpotDatafeedSubscriptionRequest): Future[js.Object] =
      service.deleteSpotDatafeedSubscription(params).promise.toFuture
    @inline def deleteSubnetFuture(params: DeleteSubnetRequest): Future[js.Object] =
      service.deleteSubnet(params).promise.toFuture
    @inline def deleteTagsFuture(params: DeleteTagsRequest): Future[js.Object] =
      service.deleteTags(params).promise.toFuture
    @inline def deleteTrafficMirrorFilterFuture(
        params: DeleteTrafficMirrorFilterRequest
    ): Future[DeleteTrafficMirrorFilterResult] = service.deleteTrafficMirrorFilter(params).promise.toFuture
    @inline def deleteTrafficMirrorFilterRuleFuture(
        params: DeleteTrafficMirrorFilterRuleRequest
    ): Future[DeleteTrafficMirrorFilterRuleResult] = service.deleteTrafficMirrorFilterRule(params).promise.toFuture
    @inline def deleteTrafficMirrorSessionFuture(
        params: DeleteTrafficMirrorSessionRequest
    ): Future[DeleteTrafficMirrorSessionResult] = service.deleteTrafficMirrorSession(params).promise.toFuture
    @inline def deleteTrafficMirrorTargetFuture(
        params: DeleteTrafficMirrorTargetRequest
    ): Future[DeleteTrafficMirrorTargetResult] = service.deleteTrafficMirrorTarget(params).promise.toFuture
    @inline def deleteTransitGatewayFuture(params: DeleteTransitGatewayRequest): Future[DeleteTransitGatewayResult] =
      service.deleteTransitGateway(params).promise.toFuture
    @inline def deleteTransitGatewayRouteFuture(
        params: DeleteTransitGatewayRouteRequest
    ): Future[DeleteTransitGatewayRouteResult] = service.deleteTransitGatewayRoute(params).promise.toFuture
    @inline def deleteTransitGatewayRouteTableFuture(
        params: DeleteTransitGatewayRouteTableRequest
    ): Future[DeleteTransitGatewayRouteTableResult] = service.deleteTransitGatewayRouteTable(params).promise.toFuture
    @inline def deleteTransitGatewayVpcAttachmentFuture(
        params: DeleteTransitGatewayVpcAttachmentRequest
    ): Future[DeleteTransitGatewayVpcAttachmentResult] =
      service.deleteTransitGatewayVpcAttachment(params).promise.toFuture
    @inline def deleteVolumeFuture(params: DeleteVolumeRequest): Future[js.Object] =
      service.deleteVolume(params).promise.toFuture
    @inline def deleteVpcEndpointConnectionNotificationsFuture(
        params: DeleteVpcEndpointConnectionNotificationsRequest
    ): Future[DeleteVpcEndpointConnectionNotificationsResult] =
      service.deleteVpcEndpointConnectionNotifications(params).promise.toFuture
    @inline def deleteVpcEndpointServiceConfigurationsFuture(
        params: DeleteVpcEndpointServiceConfigurationsRequest
    ): Future[DeleteVpcEndpointServiceConfigurationsResult] =
      service.deleteVpcEndpointServiceConfigurations(params).promise.toFuture
    @inline def deleteVpcEndpointsFuture(params: DeleteVpcEndpointsRequest): Future[DeleteVpcEndpointsResult] =
      service.deleteVpcEndpoints(params).promise.toFuture
    @inline def deleteVpcFuture(params: DeleteVpcRequest): Future[js.Object] =
      service.deleteVpc(params).promise.toFuture
    @inline def deleteVpcPeeringConnectionFuture(
        params: DeleteVpcPeeringConnectionRequest
    ): Future[DeleteVpcPeeringConnectionResult] = service.deleteVpcPeeringConnection(params).promise.toFuture
    @inline def deleteVpnConnectionFuture(params: DeleteVpnConnectionRequest): Future[js.Object] =
      service.deleteVpnConnection(params).promise.toFuture
    @inline def deleteVpnConnectionRouteFuture(params: DeleteVpnConnectionRouteRequest): Future[js.Object] =
      service.deleteVpnConnectionRoute(params).promise.toFuture
    @inline def deleteVpnGatewayFuture(params: DeleteVpnGatewayRequest): Future[js.Object] =
      service.deleteVpnGateway(params).promise.toFuture
    @inline def deprovisionByoipCidrFuture(params: DeprovisionByoipCidrRequest): Future[DeprovisionByoipCidrResult] =
      service.deprovisionByoipCidr(params).promise.toFuture
    @inline def deregisterImageFuture(params: DeregisterImageRequest): Future[js.Object] =
      service.deregisterImage(params).promise.toFuture
    @inline def describeAccountAttributesFuture(
        params: DescribeAccountAttributesRequest
    ): Future[DescribeAccountAttributesResult] = service.describeAccountAttributes(params).promise.toFuture
    @inline def describeAddressesFuture(params: DescribeAddressesRequest): Future[DescribeAddressesResult] =
      service.describeAddresses(params).promise.toFuture
    @inline def describeAggregateIdFormatFuture(
        params: DescribeAggregateIdFormatRequest
    ): Future[DescribeAggregateIdFormatResult] = service.describeAggregateIdFormat(params).promise.toFuture
    @inline def describeAvailabilityZonesFuture(
        params: DescribeAvailabilityZonesRequest
    ): Future[DescribeAvailabilityZonesResult] = service.describeAvailabilityZones(params).promise.toFuture
    @inline def describeBundleTasksFuture(params: DescribeBundleTasksRequest): Future[DescribeBundleTasksResult] =
      service.describeBundleTasks(params).promise.toFuture
    @inline def describeByoipCidrsFuture(params: DescribeByoipCidrsRequest): Future[DescribeByoipCidrsResult] =
      service.describeByoipCidrs(params).promise.toFuture
    @inline def describeCapacityReservationsFuture(
        params: DescribeCapacityReservationsRequest
    ): Future[DescribeCapacityReservationsResult] = service.describeCapacityReservations(params).promise.toFuture
    @inline def describeClassicLinkInstancesFuture(
        params: DescribeClassicLinkInstancesRequest
    ): Future[DescribeClassicLinkInstancesResult] = service.describeClassicLinkInstances(params).promise.toFuture
    @inline def describeClientVpnAuthorizationRulesFuture(
        params: DescribeClientVpnAuthorizationRulesRequest
    ): Future[DescribeClientVpnAuthorizationRulesResult] =
      service.describeClientVpnAuthorizationRules(params).promise.toFuture
    @inline def describeClientVpnConnectionsFuture(
        params: DescribeClientVpnConnectionsRequest
    ): Future[DescribeClientVpnConnectionsResult] = service.describeClientVpnConnections(params).promise.toFuture
    @inline def describeClientVpnEndpointsFuture(
        params: DescribeClientVpnEndpointsRequest
    ): Future[DescribeClientVpnEndpointsResult] = service.describeClientVpnEndpoints(params).promise.toFuture
    @inline def describeClientVpnRoutesFuture(
        params: DescribeClientVpnRoutesRequest
    ): Future[DescribeClientVpnRoutesResult] = service.describeClientVpnRoutes(params).promise.toFuture
    @inline def describeClientVpnTargetNetworksFuture(
        params: DescribeClientVpnTargetNetworksRequest
    ): Future[DescribeClientVpnTargetNetworksResult] = service.describeClientVpnTargetNetworks(params).promise.toFuture
    @inline def describeConversionTasksFuture(
        params: DescribeConversionTasksRequest
    ): Future[DescribeConversionTasksResult] = service.describeConversionTasks(params).promise.toFuture
    @inline def describeCustomerGatewaysFuture(
        params: DescribeCustomerGatewaysRequest
    ): Future[DescribeCustomerGatewaysResult] = service.describeCustomerGateways(params).promise.toFuture
    @inline def describeDhcpOptionsFuture(params: DescribeDhcpOptionsRequest): Future[DescribeDhcpOptionsResult] =
      service.describeDhcpOptions(params).promise.toFuture
    @inline def describeEgressOnlyInternetGatewaysFuture(
        params: DescribeEgressOnlyInternetGatewaysRequest
    ): Future[DescribeEgressOnlyInternetGatewaysResult] =
      service.describeEgressOnlyInternetGateways(params).promise.toFuture
    @inline def describeElasticGpusFuture(params: DescribeElasticGpusRequest): Future[DescribeElasticGpusResult] =
      service.describeElasticGpus(params).promise.toFuture
    @inline def describeExportImageTasksFuture(
        params: DescribeExportImageTasksRequest
    ): Future[DescribeExportImageTasksResult] = service.describeExportImageTasks(params).promise.toFuture
    @inline def describeExportTasksFuture(params: DescribeExportTasksRequest): Future[DescribeExportTasksResult] =
      service.describeExportTasks(params).promise.toFuture
    @inline def describeFleetHistoryFuture(params: DescribeFleetHistoryRequest): Future[DescribeFleetHistoryResult] =
      service.describeFleetHistory(params).promise.toFuture
    @inline def describeFleetInstancesFuture(
        params: DescribeFleetInstancesRequest
    ): Future[DescribeFleetInstancesResult] = service.describeFleetInstances(params).promise.toFuture
    @inline def describeFleetsFuture(params: DescribeFleetsRequest): Future[DescribeFleetsResult] =
      service.describeFleets(params).promise.toFuture
    @inline def describeFlowLogsFuture(params: DescribeFlowLogsRequest): Future[DescribeFlowLogsResult] =
      service.describeFlowLogs(params).promise.toFuture
    @inline def describeFpgaImageAttributeFuture(
        params: DescribeFpgaImageAttributeRequest
    ): Future[DescribeFpgaImageAttributeResult] = service.describeFpgaImageAttribute(params).promise.toFuture
    @inline def describeFpgaImagesFuture(params: DescribeFpgaImagesRequest): Future[DescribeFpgaImagesResult] =
      service.describeFpgaImages(params).promise.toFuture
    @inline def describeHostReservationOfferingsFuture(
        params: DescribeHostReservationOfferingsRequest
    ): Future[DescribeHostReservationOfferingsResult] =
      service.describeHostReservationOfferings(params).promise.toFuture
    @inline def describeHostReservationsFuture(
        params: DescribeHostReservationsRequest
    ): Future[DescribeHostReservationsResult] = service.describeHostReservations(params).promise.toFuture
    @inline def describeHostsFuture(params: DescribeHostsRequest): Future[DescribeHostsResult] =
      service.describeHosts(params).promise.toFuture
    @inline def describeIamInstanceProfileAssociationsFuture(
        params: DescribeIamInstanceProfileAssociationsRequest
    ): Future[DescribeIamInstanceProfileAssociationsResult] =
      service.describeIamInstanceProfileAssociations(params).promise.toFuture
    @inline def describeIdFormatFuture(params: DescribeIdFormatRequest): Future[DescribeIdFormatResult] =
      service.describeIdFormat(params).promise.toFuture
    @inline def describeIdentityIdFormatFuture(
        params: DescribeIdentityIdFormatRequest
    ): Future[DescribeIdentityIdFormatResult] = service.describeIdentityIdFormat(params).promise.toFuture
    @inline def describeImageAttributeFuture(params: DescribeImageAttributeRequest): Future[ImageAttribute] =
      service.describeImageAttribute(params).promise.toFuture
    @inline def describeImagesFuture(params: DescribeImagesRequest): Future[DescribeImagesResult] =
      service.describeImages(params).promise.toFuture
    @inline def describeImportImageTasksFuture(
        params: DescribeImportImageTasksRequest
    ): Future[DescribeImportImageTasksResult] = service.describeImportImageTasks(params).promise.toFuture
    @inline def describeImportSnapshotTasksFuture(
        params: DescribeImportSnapshotTasksRequest
    ): Future[DescribeImportSnapshotTasksResult] = service.describeImportSnapshotTasks(params).promise.toFuture
    @inline def describeInstanceAttributeFuture(params: DescribeInstanceAttributeRequest): Future[InstanceAttribute] =
      service.describeInstanceAttribute(params).promise.toFuture
    @inline def describeInstanceCreditSpecificationsFuture(
        params: DescribeInstanceCreditSpecificationsRequest
    ): Future[DescribeInstanceCreditSpecificationsResult] =
      service.describeInstanceCreditSpecifications(params).promise.toFuture
    @inline def describeInstanceStatusFuture(
        params: DescribeInstanceStatusRequest
    ): Future[DescribeInstanceStatusResult] = service.describeInstanceStatus(params).promise.toFuture
    @inline def describeInstancesFuture(params: DescribeInstancesRequest): Future[DescribeInstancesResult] =
      service.describeInstances(params).promise.toFuture
    @inline def describeInternetGatewaysFuture(
        params: DescribeInternetGatewaysRequest
    ): Future[DescribeInternetGatewaysResult] = service.describeInternetGateways(params).promise.toFuture
    @inline def describeKeyPairsFuture(params: DescribeKeyPairsRequest): Future[DescribeKeyPairsResult] =
      service.describeKeyPairs(params).promise.toFuture
    @inline def describeLaunchTemplateVersionsFuture(
        params: DescribeLaunchTemplateVersionsRequest
    ): Future[DescribeLaunchTemplateVersionsResult] = service.describeLaunchTemplateVersions(params).promise.toFuture
    @inline def describeLaunchTemplatesFuture(
        params: DescribeLaunchTemplatesRequest
    ): Future[DescribeLaunchTemplatesResult] = service.describeLaunchTemplates(params).promise.toFuture
    @inline def describeMovingAddressesFuture(
        params: DescribeMovingAddressesRequest
    ): Future[DescribeMovingAddressesResult] = service.describeMovingAddresses(params).promise.toFuture
    @inline def describeNatGatewaysFuture(params: DescribeNatGatewaysRequest): Future[DescribeNatGatewaysResult] =
      service.describeNatGateways(params).promise.toFuture
    @inline def describeNetworkAclsFuture(params: DescribeNetworkAclsRequest): Future[DescribeNetworkAclsResult] =
      service.describeNetworkAcls(params).promise.toFuture
    @inline def describeNetworkInterfaceAttributeFuture(
        params: DescribeNetworkInterfaceAttributeRequest
    ): Future[DescribeNetworkInterfaceAttributeResult] =
      service.describeNetworkInterfaceAttribute(params).promise.toFuture
    @inline def describeNetworkInterfacePermissionsFuture(
        params: DescribeNetworkInterfacePermissionsRequest
    ): Future[DescribeNetworkInterfacePermissionsResult] =
      service.describeNetworkInterfacePermissions(params).promise.toFuture
    @inline def describeNetworkInterfacesFuture(
        params: DescribeNetworkInterfacesRequest
    ): Future[DescribeNetworkInterfacesResult] = service.describeNetworkInterfaces(params).promise.toFuture
    @inline def describePlacementGroupsFuture(
        params: DescribePlacementGroupsRequest
    ): Future[DescribePlacementGroupsResult] = service.describePlacementGroups(params).promise.toFuture
    @inline def describePrefixListsFuture(params: DescribePrefixListsRequest): Future[DescribePrefixListsResult] =
      service.describePrefixLists(params).promise.toFuture
    @inline def describePrincipalIdFormatFuture(
        params: DescribePrincipalIdFormatRequest
    ): Future[DescribePrincipalIdFormatResult] = service.describePrincipalIdFormat(params).promise.toFuture
    @inline def describePublicIpv4PoolsFuture(
        params: DescribePublicIpv4PoolsRequest
    ): Future[DescribePublicIpv4PoolsResult] = service.describePublicIpv4Pools(params).promise.toFuture
    @inline def describeRegionsFuture(params: DescribeRegionsRequest): Future[DescribeRegionsResult] =
      service.describeRegions(params).promise.toFuture
    @inline def describeReservedInstancesFuture(
        params: DescribeReservedInstancesRequest
    ): Future[DescribeReservedInstancesResult] = service.describeReservedInstances(params).promise.toFuture
    @inline def describeReservedInstancesListingsFuture(
        params: DescribeReservedInstancesListingsRequest
    ): Future[DescribeReservedInstancesListingsResult] =
      service.describeReservedInstancesListings(params).promise.toFuture
    @inline def describeReservedInstancesModificationsFuture(
        params: DescribeReservedInstancesModificationsRequest
    ): Future[DescribeReservedInstancesModificationsResult] =
      service.describeReservedInstancesModifications(params).promise.toFuture
    @inline def describeReservedInstancesOfferingsFuture(
        params: DescribeReservedInstancesOfferingsRequest
    ): Future[DescribeReservedInstancesOfferingsResult] =
      service.describeReservedInstancesOfferings(params).promise.toFuture
    @inline def describeRouteTablesFuture(params: DescribeRouteTablesRequest): Future[DescribeRouteTablesResult] =
      service.describeRouteTables(params).promise.toFuture
    @inline def describeScheduledInstanceAvailabilityFuture(
        params: DescribeScheduledInstanceAvailabilityRequest
    ): Future[DescribeScheduledInstanceAvailabilityResult] =
      service.describeScheduledInstanceAvailability(params).promise.toFuture
    @inline def describeScheduledInstancesFuture(
        params: DescribeScheduledInstancesRequest
    ): Future[DescribeScheduledInstancesResult] = service.describeScheduledInstances(params).promise.toFuture
    @inline def describeSecurityGroupReferencesFuture(
        params: DescribeSecurityGroupReferencesRequest
    ): Future[DescribeSecurityGroupReferencesResult] = service.describeSecurityGroupReferences(params).promise.toFuture
    @inline def describeSecurityGroupsFuture(
        params: DescribeSecurityGroupsRequest
    ): Future[DescribeSecurityGroupsResult] = service.describeSecurityGroups(params).promise.toFuture
    @inline def describeSnapshotAttributeFuture(
        params: DescribeSnapshotAttributeRequest
    ): Future[DescribeSnapshotAttributeResult] = service.describeSnapshotAttribute(params).promise.toFuture
    @inline def describeSnapshotsFuture(params: DescribeSnapshotsRequest): Future[DescribeSnapshotsResult] =
      service.describeSnapshots(params).promise.toFuture
    @inline def describeSpotDatafeedSubscriptionFuture(
        params: DescribeSpotDatafeedSubscriptionRequest
    ): Future[DescribeSpotDatafeedSubscriptionResult] =
      service.describeSpotDatafeedSubscription(params).promise.toFuture
    @inline def describeSpotFleetInstancesFuture(
        params: DescribeSpotFleetInstancesRequest
    ): Future[DescribeSpotFleetInstancesResponse] = service.describeSpotFleetInstances(params).promise.toFuture
    @inline def describeSpotFleetRequestHistoryFuture(
        params: DescribeSpotFleetRequestHistoryRequest
    ): Future[DescribeSpotFleetRequestHistoryResponse] =
      service.describeSpotFleetRequestHistory(params).promise.toFuture
    @inline def describeSpotFleetRequestsFuture(
        params: DescribeSpotFleetRequestsRequest
    ): Future[DescribeSpotFleetRequestsResponse] = service.describeSpotFleetRequests(params).promise.toFuture
    @inline def describeSpotInstanceRequestsFuture(
        params: DescribeSpotInstanceRequestsRequest
    ): Future[DescribeSpotInstanceRequestsResult] = service.describeSpotInstanceRequests(params).promise.toFuture
    @inline def describeSpotPriceHistoryFuture(
        params: DescribeSpotPriceHistoryRequest
    ): Future[DescribeSpotPriceHistoryResult] = service.describeSpotPriceHistory(params).promise.toFuture
    @inline def describeStaleSecurityGroupsFuture(
        params: DescribeStaleSecurityGroupsRequest
    ): Future[DescribeStaleSecurityGroupsResult] = service.describeStaleSecurityGroups(params).promise.toFuture
    @inline def describeSubnetsFuture(params: DescribeSubnetsRequest): Future[DescribeSubnetsResult] =
      service.describeSubnets(params).promise.toFuture
    @inline def describeTagsFuture(params: DescribeTagsRequest): Future[DescribeTagsResult] =
      service.describeTags(params).promise.toFuture
    @inline def describeTrafficMirrorFiltersFuture(
        params: DescribeTrafficMirrorFiltersRequest
    ): Future[DescribeTrafficMirrorFiltersResult] = service.describeTrafficMirrorFilters(params).promise.toFuture
    @inline def describeTrafficMirrorSessionsFuture(
        params: DescribeTrafficMirrorSessionsRequest
    ): Future[DescribeTrafficMirrorSessionsResult] = service.describeTrafficMirrorSessions(params).promise.toFuture
    @inline def describeTrafficMirrorTargetsFuture(
        params: DescribeTrafficMirrorTargetsRequest
    ): Future[DescribeTrafficMirrorTargetsResult] = service.describeTrafficMirrorTargets(params).promise.toFuture
    @inline def describeTransitGatewayAttachmentsFuture(
        params: DescribeTransitGatewayAttachmentsRequest
    ): Future[DescribeTransitGatewayAttachmentsResult] =
      service.describeTransitGatewayAttachments(params).promise.toFuture
    @inline def describeTransitGatewayRouteTablesFuture(
        params: DescribeTransitGatewayRouteTablesRequest
    ): Future[DescribeTransitGatewayRouteTablesResult] =
      service.describeTransitGatewayRouteTables(params).promise.toFuture
    @inline def describeTransitGatewayVpcAttachmentsFuture(
        params: DescribeTransitGatewayVpcAttachmentsRequest
    ): Future[DescribeTransitGatewayVpcAttachmentsResult] =
      service.describeTransitGatewayVpcAttachments(params).promise.toFuture
    @inline def describeTransitGatewaysFuture(
        params: DescribeTransitGatewaysRequest
    ): Future[DescribeTransitGatewaysResult] = service.describeTransitGateways(params).promise.toFuture
    @inline def describeVolumeAttributeFuture(
        params: DescribeVolumeAttributeRequest
    ): Future[DescribeVolumeAttributeResult] = service.describeVolumeAttribute(params).promise.toFuture
    @inline def describeVolumeStatusFuture(params: DescribeVolumeStatusRequest): Future[DescribeVolumeStatusResult] =
      service.describeVolumeStatus(params).promise.toFuture
    @inline def describeVolumesFuture(params: DescribeVolumesRequest): Future[DescribeVolumesResult] =
      service.describeVolumes(params).promise.toFuture
    @inline def describeVolumesModificationsFuture(
        params: DescribeVolumesModificationsRequest
    ): Future[DescribeVolumesModificationsResult] = service.describeVolumesModifications(params).promise.toFuture
    @inline def describeVpcAttributeFuture(params: DescribeVpcAttributeRequest): Future[DescribeVpcAttributeResult] =
      service.describeVpcAttribute(params).promise.toFuture
    @inline def describeVpcClassicLinkDnsSupportFuture(
        params: DescribeVpcClassicLinkDnsSupportRequest
    ): Future[DescribeVpcClassicLinkDnsSupportResult] =
      service.describeVpcClassicLinkDnsSupport(params).promise.toFuture
    @inline def describeVpcClassicLinkFuture(
        params: DescribeVpcClassicLinkRequest
    ): Future[DescribeVpcClassicLinkResult] = service.describeVpcClassicLink(params).promise.toFuture
    @inline def describeVpcEndpointConnectionNotificationsFuture(
        params: DescribeVpcEndpointConnectionNotificationsRequest
    ): Future[DescribeVpcEndpointConnectionNotificationsResult] =
      service.describeVpcEndpointConnectionNotifications(params).promise.toFuture
    @inline def describeVpcEndpointConnectionsFuture(
        params: DescribeVpcEndpointConnectionsRequest
    ): Future[DescribeVpcEndpointConnectionsResult] = service.describeVpcEndpointConnections(params).promise.toFuture
    @inline def describeVpcEndpointServiceConfigurationsFuture(
        params: DescribeVpcEndpointServiceConfigurationsRequest
    ): Future[DescribeVpcEndpointServiceConfigurationsResult] =
      service.describeVpcEndpointServiceConfigurations(params).promise.toFuture
    @inline def describeVpcEndpointServicePermissionsFuture(
        params: DescribeVpcEndpointServicePermissionsRequest
    ): Future[DescribeVpcEndpointServicePermissionsResult] =
      service.describeVpcEndpointServicePermissions(params).promise.toFuture
    @inline def describeVpcEndpointServicesFuture(
        params: DescribeVpcEndpointServicesRequest
    ): Future[DescribeVpcEndpointServicesResult] = service.describeVpcEndpointServices(params).promise.toFuture
    @inline def describeVpcEndpointsFuture(params: DescribeVpcEndpointsRequest): Future[DescribeVpcEndpointsResult] =
      service.describeVpcEndpoints(params).promise.toFuture
    @inline def describeVpcPeeringConnectionsFuture(
        params: DescribeVpcPeeringConnectionsRequest
    ): Future[DescribeVpcPeeringConnectionsResult] = service.describeVpcPeeringConnections(params).promise.toFuture
    @inline def describeVpcsFuture(params: DescribeVpcsRequest): Future[DescribeVpcsResult] =
      service.describeVpcs(params).promise.toFuture
    @inline def describeVpnConnectionsFuture(
        params: DescribeVpnConnectionsRequest
    ): Future[DescribeVpnConnectionsResult] = service.describeVpnConnections(params).promise.toFuture
    @inline def describeVpnGatewaysFuture(params: DescribeVpnGatewaysRequest): Future[DescribeVpnGatewaysResult] =
      service.describeVpnGateways(params).promise.toFuture
    @inline def detachClassicLinkVpcFuture(params: DetachClassicLinkVpcRequest): Future[DetachClassicLinkVpcResult] =
      service.detachClassicLinkVpc(params).promise.toFuture
    @inline def detachInternetGatewayFuture(params: DetachInternetGatewayRequest): Future[js.Object] =
      service.detachInternetGateway(params).promise.toFuture
    @inline def detachNetworkInterfaceFuture(params: DetachNetworkInterfaceRequest): Future[js.Object] =
      service.detachNetworkInterface(params).promise.toFuture
    @inline def detachVolumeFuture(params: DetachVolumeRequest): Future[VolumeAttachment] =
      service.detachVolume(params).promise.toFuture
    @inline def detachVpnGatewayFuture(params: DetachVpnGatewayRequest): Future[js.Object] =
      service.detachVpnGateway(params).promise.toFuture
    @inline def disableEbsEncryptionByDefaultFuture(
        params: DisableEbsEncryptionByDefaultRequest
    ): Future[DisableEbsEncryptionByDefaultResult] = service.disableEbsEncryptionByDefault(params).promise.toFuture
    @inline def disableTransitGatewayRouteTablePropagationFuture(
        params: DisableTransitGatewayRouteTablePropagationRequest
    ): Future[DisableTransitGatewayRouteTablePropagationResult] =
      service.disableTransitGatewayRouteTablePropagation(params).promise.toFuture
    @inline def disableVgwRoutePropagationFuture(params: DisableVgwRoutePropagationRequest): Future[js.Object] =
      service.disableVgwRoutePropagation(params).promise.toFuture
    @inline def disableVpcClassicLinkDnsSupportFuture(
        params: DisableVpcClassicLinkDnsSupportRequest
    ): Future[DisableVpcClassicLinkDnsSupportResult] = service.disableVpcClassicLinkDnsSupport(params).promise.toFuture
    @inline def disableVpcClassicLinkFuture(params: DisableVpcClassicLinkRequest): Future[DisableVpcClassicLinkResult] =
      service.disableVpcClassicLink(params).promise.toFuture
    @inline def disassociateAddressFuture(params: DisassociateAddressRequest): Future[js.Object] =
      service.disassociateAddress(params).promise.toFuture
    @inline def disassociateClientVpnTargetNetworkFuture(
        params: DisassociateClientVpnTargetNetworkRequest
    ): Future[DisassociateClientVpnTargetNetworkResult] =
      service.disassociateClientVpnTargetNetwork(params).promise.toFuture
    @inline def disassociateIamInstanceProfileFuture(
        params: DisassociateIamInstanceProfileRequest
    ): Future[DisassociateIamInstanceProfileResult] = service.disassociateIamInstanceProfile(params).promise.toFuture
    @inline def disassociateRouteTableFuture(params: DisassociateRouteTableRequest): Future[js.Object] =
      service.disassociateRouteTable(params).promise.toFuture
    @inline def disassociateSubnetCidrBlockFuture(
        params: DisassociateSubnetCidrBlockRequest
    ): Future[DisassociateSubnetCidrBlockResult] = service.disassociateSubnetCidrBlock(params).promise.toFuture
    @inline def disassociateTransitGatewayRouteTableFuture(
        params: DisassociateTransitGatewayRouteTableRequest
    ): Future[DisassociateTransitGatewayRouteTableResult] =
      service.disassociateTransitGatewayRouteTable(params).promise.toFuture
    @inline def disassociateVpcCidrBlockFuture(
        params: DisassociateVpcCidrBlockRequest
    ): Future[DisassociateVpcCidrBlockResult] = service.disassociateVpcCidrBlock(params).promise.toFuture
    @inline def enableEbsEncryptionByDefaultFuture(
        params: EnableEbsEncryptionByDefaultRequest
    ): Future[EnableEbsEncryptionByDefaultResult] = service.enableEbsEncryptionByDefault(params).promise.toFuture
    @inline def enableTransitGatewayRouteTablePropagationFuture(
        params: EnableTransitGatewayRouteTablePropagationRequest
    ): Future[EnableTransitGatewayRouteTablePropagationResult] =
      service.enableTransitGatewayRouteTablePropagation(params).promise.toFuture
    @inline def enableVgwRoutePropagationFuture(params: EnableVgwRoutePropagationRequest): Future[js.Object] =
      service.enableVgwRoutePropagation(params).promise.toFuture
    @inline def enableVolumeIOFuture(params: EnableVolumeIORequest): Future[js.Object] =
      service.enableVolumeIO(params).promise.toFuture
    @inline def enableVpcClassicLinkDnsSupportFuture(
        params: EnableVpcClassicLinkDnsSupportRequest
    ): Future[EnableVpcClassicLinkDnsSupportResult] = service.enableVpcClassicLinkDnsSupport(params).promise.toFuture
    @inline def enableVpcClassicLinkFuture(params: EnableVpcClassicLinkRequest): Future[EnableVpcClassicLinkResult] =
      service.enableVpcClassicLink(params).promise.toFuture
    @inline def exportClientVpnClientCertificateRevocationListFuture(
        params: ExportClientVpnClientCertificateRevocationListRequest
    ): Future[ExportClientVpnClientCertificateRevocationListResult] =
      service.exportClientVpnClientCertificateRevocationList(params).promise.toFuture
    @inline def exportClientVpnClientConfigurationFuture(
        params: ExportClientVpnClientConfigurationRequest
    ): Future[ExportClientVpnClientConfigurationResult] =
      service.exportClientVpnClientConfiguration(params).promise.toFuture
    @inline def exportImageFuture(params: ExportImageRequest): Future[ExportImageResult] =
      service.exportImage(params).promise.toFuture
    @inline def exportTransitGatewayRoutesFuture(
        params: ExportTransitGatewayRoutesRequest
    ): Future[ExportTransitGatewayRoutesResult] = service.exportTransitGatewayRoutes(params).promise.toFuture
    @inline def getCapacityReservationUsageFuture(
        params: GetCapacityReservationUsageRequest
    ): Future[GetCapacityReservationUsageResult] = service.getCapacityReservationUsage(params).promise.toFuture
    @inline def getConsoleOutputFuture(params: GetConsoleOutputRequest): Future[GetConsoleOutputResult] =
      service.getConsoleOutput(params).promise.toFuture
    @inline def getConsoleScreenshotFuture(params: GetConsoleScreenshotRequest): Future[GetConsoleScreenshotResult] =
      service.getConsoleScreenshot(params).promise.toFuture
    @inline def getEbsDefaultKmsKeyIdFuture(params: GetEbsDefaultKmsKeyIdRequest): Future[GetEbsDefaultKmsKeyIdResult] =
      service.getEbsDefaultKmsKeyId(params).promise.toFuture
    @inline def getEbsEncryptionByDefaultFuture(
        params: GetEbsEncryptionByDefaultRequest
    ): Future[GetEbsEncryptionByDefaultResult] = service.getEbsEncryptionByDefault(params).promise.toFuture
    @inline def getHostReservationPurchasePreviewFuture(
        params: GetHostReservationPurchasePreviewRequest
    ): Future[GetHostReservationPurchasePreviewResult] =
      service.getHostReservationPurchasePreview(params).promise.toFuture
    @inline def getLaunchTemplateDataFuture(params: GetLaunchTemplateDataRequest): Future[GetLaunchTemplateDataResult] =
      service.getLaunchTemplateData(params).promise.toFuture
    @inline def getPasswordDataFuture(params: GetPasswordDataRequest): Future[GetPasswordDataResult] =
      service.getPasswordData(params).promise.toFuture
    @inline def getReservedInstancesExchangeQuoteFuture(
        params: GetReservedInstancesExchangeQuoteRequest
    ): Future[GetReservedInstancesExchangeQuoteResult] =
      service.getReservedInstancesExchangeQuote(params).promise.toFuture
    @inline def getTransitGatewayAttachmentPropagationsFuture(
        params: GetTransitGatewayAttachmentPropagationsRequest
    ): Future[GetTransitGatewayAttachmentPropagationsResult] =
      service.getTransitGatewayAttachmentPropagations(params).promise.toFuture
    @inline def getTransitGatewayRouteTableAssociationsFuture(
        params: GetTransitGatewayRouteTableAssociationsRequest
    ): Future[GetTransitGatewayRouteTableAssociationsResult] =
      service.getTransitGatewayRouteTableAssociations(params).promise.toFuture
    @inline def getTransitGatewayRouteTablePropagationsFuture(
        params: GetTransitGatewayRouteTablePropagationsRequest
    ): Future[GetTransitGatewayRouteTablePropagationsResult] =
      service.getTransitGatewayRouteTablePropagations(params).promise.toFuture
    @inline def importClientVpnClientCertificateRevocationListFuture(
        params: ImportClientVpnClientCertificateRevocationListRequest
    ): Future[ImportClientVpnClientCertificateRevocationListResult] =
      service.importClientVpnClientCertificateRevocationList(params).promise.toFuture
    @inline def importImageFuture(params: ImportImageRequest): Future[ImportImageResult] =
      service.importImage(params).promise.toFuture
    @inline def importInstanceFuture(params: ImportInstanceRequest): Future[ImportInstanceResult] =
      service.importInstance(params).promise.toFuture
    @inline def importKeyPairFuture(params: ImportKeyPairRequest): Future[ImportKeyPairResult] =
      service.importKeyPair(params).promise.toFuture
    @inline def importSnapshotFuture(params: ImportSnapshotRequest): Future[ImportSnapshotResult] =
      service.importSnapshot(params).promise.toFuture
    @inline def importVolumeFuture(params: ImportVolumeRequest): Future[ImportVolumeResult] =
      service.importVolume(params).promise.toFuture
    @inline def modifyCapacityReservationFuture(
        params: ModifyCapacityReservationRequest
    ): Future[ModifyCapacityReservationResult] = service.modifyCapacityReservation(params).promise.toFuture
    @inline def modifyClientVpnEndpointFuture(
        params: ModifyClientVpnEndpointRequest
    ): Future[ModifyClientVpnEndpointResult] = service.modifyClientVpnEndpoint(params).promise.toFuture
    @inline def modifyEbsDefaultKmsKeyIdFuture(
        params: ModifyEbsDefaultKmsKeyIdRequest
    ): Future[ModifyEbsDefaultKmsKeyIdResult] = service.modifyEbsDefaultKmsKeyId(params).promise.toFuture
    @inline def modifyFleetFuture(params: ModifyFleetRequest): Future[ModifyFleetResult] =
      service.modifyFleet(params).promise.toFuture
    @inline def modifyFpgaImageAttributeFuture(
        params: ModifyFpgaImageAttributeRequest
    ): Future[ModifyFpgaImageAttributeResult] = service.modifyFpgaImageAttribute(params).promise.toFuture
    @inline def modifyHostsFuture(params: ModifyHostsRequest): Future[ModifyHostsResult] =
      service.modifyHosts(params).promise.toFuture
    @inline def modifyIdFormatFuture(params: ModifyIdFormatRequest): Future[js.Object] =
      service.modifyIdFormat(params).promise.toFuture
    @inline def modifyIdentityIdFormatFuture(params: ModifyIdentityIdFormatRequest): Future[js.Object] =
      service.modifyIdentityIdFormat(params).promise.toFuture
    @inline def modifyImageAttributeFuture(params: ModifyImageAttributeRequest): Future[js.Object] =
      service.modifyImageAttribute(params).promise.toFuture
    @inline def modifyInstanceAttributeFuture(params: ModifyInstanceAttributeRequest): Future[js.Object] =
      service.modifyInstanceAttribute(params).promise.toFuture
    @inline def modifyInstanceCapacityReservationAttributesFuture(
        params: ModifyInstanceCapacityReservationAttributesRequest
    ): Future[ModifyInstanceCapacityReservationAttributesResult] =
      service.modifyInstanceCapacityReservationAttributes(params).promise.toFuture
    @inline def modifyInstanceCreditSpecificationFuture(
        params: ModifyInstanceCreditSpecificationRequest
    ): Future[ModifyInstanceCreditSpecificationResult] =
      service.modifyInstanceCreditSpecification(params).promise.toFuture
    @inline def modifyInstanceEventStartTimeFuture(
        params: ModifyInstanceEventStartTimeRequest
    ): Future[ModifyInstanceEventStartTimeResult] = service.modifyInstanceEventStartTime(params).promise.toFuture
    @inline def modifyInstancePlacementFuture(
        params: ModifyInstancePlacementRequest
    ): Future[ModifyInstancePlacementResult] = service.modifyInstancePlacement(params).promise.toFuture
    @inline def modifyLaunchTemplateFuture(params: ModifyLaunchTemplateRequest): Future[ModifyLaunchTemplateResult] =
      service.modifyLaunchTemplate(params).promise.toFuture
    @inline def modifyNetworkInterfaceAttributeFuture(
        params: ModifyNetworkInterfaceAttributeRequest
    ): Future[js.Object] = service.modifyNetworkInterfaceAttribute(params).promise.toFuture
    @inline def modifyReservedInstancesFuture(
        params: ModifyReservedInstancesRequest
    ): Future[ModifyReservedInstancesResult] = service.modifyReservedInstances(params).promise.toFuture
    @inline def modifySnapshotAttributeFuture(params: ModifySnapshotAttributeRequest): Future[js.Object] =
      service.modifySnapshotAttribute(params).promise.toFuture
    @inline def modifySpotFleetRequestFuture(
        params: ModifySpotFleetRequestRequest
    ): Future[ModifySpotFleetRequestResponse] = service.modifySpotFleetRequest(params).promise.toFuture
    @inline def modifySubnetAttributeFuture(params: ModifySubnetAttributeRequest): Future[js.Object] =
      service.modifySubnetAttribute(params).promise.toFuture
    @inline def modifyTrafficMirrorFilterNetworkServicesFuture(
        params: ModifyTrafficMirrorFilterNetworkServicesRequest
    ): Future[ModifyTrafficMirrorFilterNetworkServicesResult] =
      service.modifyTrafficMirrorFilterNetworkServices(params).promise.toFuture
    @inline def modifyTrafficMirrorFilterRuleFuture(
        params: ModifyTrafficMirrorFilterRuleRequest
    ): Future[ModifyTrafficMirrorFilterRuleResult] = service.modifyTrafficMirrorFilterRule(params).promise.toFuture
    @inline def modifyTrafficMirrorSessionFuture(
        params: ModifyTrafficMirrorSessionRequest
    ): Future[ModifyTrafficMirrorSessionResult] = service.modifyTrafficMirrorSession(params).promise.toFuture
    @inline def modifyTransitGatewayVpcAttachmentFuture(
        params: ModifyTransitGatewayVpcAttachmentRequest
    ): Future[ModifyTransitGatewayVpcAttachmentResult] =
      service.modifyTransitGatewayVpcAttachment(params).promise.toFuture
    @inline def modifyVolumeAttributeFuture(params: ModifyVolumeAttributeRequest): Future[js.Object] =
      service.modifyVolumeAttribute(params).promise.toFuture
    @inline def modifyVolumeFuture(params: ModifyVolumeRequest): Future[ModifyVolumeResult] =
      service.modifyVolume(params).promise.toFuture
    @inline def modifyVpcAttributeFuture(params: ModifyVpcAttributeRequest): Future[js.Object] =
      service.modifyVpcAttribute(params).promise.toFuture
    @inline def modifyVpcEndpointConnectionNotificationFuture(
        params: ModifyVpcEndpointConnectionNotificationRequest
    ): Future[ModifyVpcEndpointConnectionNotificationResult] =
      service.modifyVpcEndpointConnectionNotification(params).promise.toFuture
    @inline def modifyVpcEndpointFuture(params: ModifyVpcEndpointRequest): Future[ModifyVpcEndpointResult] =
      service.modifyVpcEndpoint(params).promise.toFuture
    @inline def modifyVpcEndpointServiceConfigurationFuture(
        params: ModifyVpcEndpointServiceConfigurationRequest
    ): Future[ModifyVpcEndpointServiceConfigurationResult] =
      service.modifyVpcEndpointServiceConfiguration(params).promise.toFuture
    @inline def modifyVpcEndpointServicePermissionsFuture(
        params: ModifyVpcEndpointServicePermissionsRequest
    ): Future[ModifyVpcEndpointServicePermissionsResult] =
      service.modifyVpcEndpointServicePermissions(params).promise.toFuture
    @inline def modifyVpcPeeringConnectionOptionsFuture(
        params: ModifyVpcPeeringConnectionOptionsRequest
    ): Future[ModifyVpcPeeringConnectionOptionsResult] =
      service.modifyVpcPeeringConnectionOptions(params).promise.toFuture
    @inline def modifyVpcTenancyFuture(params: ModifyVpcTenancyRequest): Future[ModifyVpcTenancyResult] =
      service.modifyVpcTenancy(params).promise.toFuture
    @inline def modifyVpnConnectionFuture(params: ModifyVpnConnectionRequest): Future[ModifyVpnConnectionResult] =
      service.modifyVpnConnection(params).promise.toFuture
    @inline def modifyVpnTunnelCertificateFuture(
        params: ModifyVpnTunnelCertificateRequest
    ): Future[ModifyVpnTunnelCertificateResult] = service.modifyVpnTunnelCertificate(params).promise.toFuture
    @inline def monitorInstancesFuture(params: MonitorInstancesRequest): Future[MonitorInstancesResult] =
      service.monitorInstances(params).promise.toFuture
    @inline def moveAddressToVpcFuture(params: MoveAddressToVpcRequest): Future[MoveAddressToVpcResult] =
      service.moveAddressToVpc(params).promise.toFuture
    @inline def provisionByoipCidrFuture(params: ProvisionByoipCidrRequest): Future[ProvisionByoipCidrResult] =
      service.provisionByoipCidr(params).promise.toFuture
    @inline def purchaseHostReservationFuture(
        params: PurchaseHostReservationRequest
    ): Future[PurchaseHostReservationResult] = service.purchaseHostReservation(params).promise.toFuture
    @inline def purchaseReservedInstancesOfferingFuture(
        params: PurchaseReservedInstancesOfferingRequest
    ): Future[PurchaseReservedInstancesOfferingResult] =
      service.purchaseReservedInstancesOffering(params).promise.toFuture
    @inline def purchaseScheduledInstancesFuture(
        params: PurchaseScheduledInstancesRequest
    ): Future[PurchaseScheduledInstancesResult] = service.purchaseScheduledInstances(params).promise.toFuture
    @inline def rebootInstancesFuture(params: RebootInstancesRequest): Future[js.Object] =
      service.rebootInstances(params).promise.toFuture
    @inline def registerImageFuture(params: RegisterImageRequest): Future[RegisterImageResult] =
      service.registerImage(params).promise.toFuture
    @inline def rejectTransitGatewayVpcAttachmentFuture(
        params: RejectTransitGatewayVpcAttachmentRequest
    ): Future[RejectTransitGatewayVpcAttachmentResult] =
      service.rejectTransitGatewayVpcAttachment(params).promise.toFuture
    @inline def rejectVpcEndpointConnectionsFuture(
        params: RejectVpcEndpointConnectionsRequest
    ): Future[RejectVpcEndpointConnectionsResult] = service.rejectVpcEndpointConnections(params).promise.toFuture
    @inline def rejectVpcPeeringConnectionFuture(
        params: RejectVpcPeeringConnectionRequest
    ): Future[RejectVpcPeeringConnectionResult] = service.rejectVpcPeeringConnection(params).promise.toFuture
    @inline def releaseAddressFuture(params: ReleaseAddressRequest): Future[js.Object] =
      service.releaseAddress(params).promise.toFuture
    @inline def releaseHostsFuture(params: ReleaseHostsRequest): Future[ReleaseHostsResult] =
      service.releaseHosts(params).promise.toFuture
    @inline def replaceIamInstanceProfileAssociationFuture(
        params: ReplaceIamInstanceProfileAssociationRequest
    ): Future[ReplaceIamInstanceProfileAssociationResult] =
      service.replaceIamInstanceProfileAssociation(params).promise.toFuture
    @inline def replaceNetworkAclAssociationFuture(
        params: ReplaceNetworkAclAssociationRequest
    ): Future[ReplaceNetworkAclAssociationResult] = service.replaceNetworkAclAssociation(params).promise.toFuture
    @inline def replaceNetworkAclEntryFuture(params: ReplaceNetworkAclEntryRequest): Future[js.Object] =
      service.replaceNetworkAclEntry(params).promise.toFuture
    @inline def replaceRouteFuture(params: ReplaceRouteRequest): Future[js.Object] =
      service.replaceRoute(params).promise.toFuture
    @inline def replaceRouteTableAssociationFuture(
        params: ReplaceRouteTableAssociationRequest
    ): Future[ReplaceRouteTableAssociationResult] = service.replaceRouteTableAssociation(params).promise.toFuture
    @inline def replaceTransitGatewayRouteFuture(
        params: ReplaceTransitGatewayRouteRequest
    ): Future[ReplaceTransitGatewayRouteResult] = service.replaceTransitGatewayRoute(params).promise.toFuture
    @inline def reportInstanceStatusFuture(params: ReportInstanceStatusRequest): Future[js.Object] =
      service.reportInstanceStatus(params).promise.toFuture
    @inline def requestSpotFleetFuture(params: RequestSpotFleetRequest): Future[RequestSpotFleetResponse] =
      service.requestSpotFleet(params).promise.toFuture
    @inline def requestSpotInstancesFuture(params: RequestSpotInstancesRequest): Future[RequestSpotInstancesResult] =
      service.requestSpotInstances(params).promise.toFuture
    @inline def resetEbsDefaultKmsKeyIdFuture(
        params: ResetEbsDefaultKmsKeyIdRequest
    ): Future[ResetEbsDefaultKmsKeyIdResult] = service.resetEbsDefaultKmsKeyId(params).promise.toFuture
    @inline def resetFpgaImageAttributeFuture(
        params: ResetFpgaImageAttributeRequest
    ): Future[ResetFpgaImageAttributeResult] = service.resetFpgaImageAttribute(params).promise.toFuture
    @inline def resetImageAttributeFuture(params: ResetImageAttributeRequest): Future[js.Object] =
      service.resetImageAttribute(params).promise.toFuture
    @inline def resetInstanceAttributeFuture(params: ResetInstanceAttributeRequest): Future[js.Object] =
      service.resetInstanceAttribute(params).promise.toFuture
    @inline def resetNetworkInterfaceAttributeFuture(params: ResetNetworkInterfaceAttributeRequest): Future[js.Object] =
      service.resetNetworkInterfaceAttribute(params).promise.toFuture
    @inline def resetSnapshotAttributeFuture(params: ResetSnapshotAttributeRequest): Future[js.Object] =
      service.resetSnapshotAttribute(params).promise.toFuture
    @inline def restoreAddressToClassicFuture(
        params: RestoreAddressToClassicRequest
    ): Future[RestoreAddressToClassicResult] = service.restoreAddressToClassic(params).promise.toFuture
    @inline def revokeClientVpnIngressFuture(
        params: RevokeClientVpnIngressRequest
    ): Future[RevokeClientVpnIngressResult] = service.revokeClientVpnIngress(params).promise.toFuture
    @inline def revokeSecurityGroupEgressFuture(params: RevokeSecurityGroupEgressRequest): Future[js.Object] =
      service.revokeSecurityGroupEgress(params).promise.toFuture
    @inline def revokeSecurityGroupIngressFuture(params: RevokeSecurityGroupIngressRequest): Future[js.Object] =
      service.revokeSecurityGroupIngress(params).promise.toFuture
    @inline def runInstancesFuture(params: RunInstancesRequest): Future[Reservation] =
      service.runInstances(params).promise.toFuture
    @inline def runScheduledInstancesFuture(params: RunScheduledInstancesRequest): Future[RunScheduledInstancesResult] =
      service.runScheduledInstances(params).promise.toFuture
    @inline def searchTransitGatewayRoutesFuture(
        params: SearchTransitGatewayRoutesRequest
    ): Future[SearchTransitGatewayRoutesResult] = service.searchTransitGatewayRoutes(params).promise.toFuture
    @inline def sendDiagnosticInterruptFuture(params: SendDiagnosticInterruptRequest): Future[js.Object] =
      service.sendDiagnosticInterrupt(params).promise.toFuture
    @inline def startInstancesFuture(params: StartInstancesRequest): Future[StartInstancesResult] =
      service.startInstances(params).promise.toFuture
    @inline def stopInstancesFuture(params: StopInstancesRequest): Future[StopInstancesResult] =
      service.stopInstances(params).promise.toFuture
    @inline def terminateClientVpnConnectionsFuture(
        params: TerminateClientVpnConnectionsRequest
    ): Future[TerminateClientVpnConnectionsResult] = service.terminateClientVpnConnections(params).promise.toFuture
    @inline def terminateInstancesFuture(params: TerminateInstancesRequest): Future[TerminateInstancesResult] =
      service.terminateInstances(params).promise.toFuture
    @inline def unassignIpv6AddressesFuture(params: UnassignIpv6AddressesRequest): Future[UnassignIpv6AddressesResult] =
      service.unassignIpv6Addresses(params).promise.toFuture
    @inline def unassignPrivateIpAddressesFuture(params: UnassignPrivateIpAddressesRequest): Future[js.Object] =
      service.unassignPrivateIpAddresses(params).promise.toFuture
    @inline def unmonitorInstancesFuture(params: UnmonitorInstancesRequest): Future[UnmonitorInstancesResult] =
      service.unmonitorInstances(params).promise.toFuture
    @inline def updateSecurityGroupRuleDescriptionsEgressFuture(
        params: UpdateSecurityGroupRuleDescriptionsEgressRequest
    ): Future[UpdateSecurityGroupRuleDescriptionsEgressResult] =
      service.updateSecurityGroupRuleDescriptionsEgress(params).promise.toFuture
    @inline def updateSecurityGroupRuleDescriptionsIngressFuture(
        params: UpdateSecurityGroupRuleDescriptionsIngressRequest
    ): Future[UpdateSecurityGroupRuleDescriptionsIngressResult] =
      service.updateSecurityGroupRuleDescriptionsIngress(params).promise.toFuture
    @inline def withdrawByoipCidrFuture(params: WithdrawByoipCidrRequest): Future[WithdrawByoipCidrResult] =
      service.withdrawByoipCidr(params).promise.toFuture
  }
}

package ec2 {
  @js.native
  @JSImport("aws-sdk", "EC2")
  class EC2() extends js.Object {
    def this(config: AWSConfig) = this()

    def acceptReservedInstancesExchangeQuote(
        params: AcceptReservedInstancesExchangeQuoteRequest
    ): Request[AcceptReservedInstancesExchangeQuoteResult] = js.native
    def acceptTransitGatewayVpcAttachment(
        params: AcceptTransitGatewayVpcAttachmentRequest
    ): Request[AcceptTransitGatewayVpcAttachmentResult] = js.native
    def acceptVpcEndpointConnections(
        params: AcceptVpcEndpointConnectionsRequest
    ): Request[AcceptVpcEndpointConnectionsResult] = js.native
    def acceptVpcPeeringConnection(
        params: AcceptVpcPeeringConnectionRequest
    ): Request[AcceptVpcPeeringConnectionResult]                                                 = js.native
    def advertiseByoipCidr(params: AdvertiseByoipCidrRequest): Request[AdvertiseByoipCidrResult] = js.native
    def allocateAddress(params: AllocateAddressRequest): Request[AllocateAddressResult]          = js.native
    def allocateHosts(params: AllocateHostsRequest): Request[AllocateHostsResult]                = js.native
    def applySecurityGroupsToClientVpnTargetNetwork(
        params: ApplySecurityGroupsToClientVpnTargetNetworkRequest
    ): Request[ApplySecurityGroupsToClientVpnTargetNetworkResult]                                   = js.native
    def assignIpv6Addresses(params: AssignIpv6AddressesRequest): Request[AssignIpv6AddressesResult] = js.native
    def assignPrivateIpAddresses(params: AssignPrivateIpAddressesRequest): Request[AssignPrivateIpAddressesResult] =
      js.native
    def associateAddress(params: AssociateAddressRequest): Request[AssociateAddressResult] = js.native
    def associateClientVpnTargetNetwork(
        params: AssociateClientVpnTargetNetworkRequest
    ): Request[AssociateClientVpnTargetNetworkResult]                                 = js.native
    def associateDhcpOptions(params: AssociateDhcpOptionsRequest): Request[js.Object] = js.native
    def associateIamInstanceProfile(
        params: AssociateIamInstanceProfileRequest
    ): Request[AssociateIamInstanceProfileResult]                                                   = js.native
    def associateRouteTable(params: AssociateRouteTableRequest): Request[AssociateRouteTableResult] = js.native
    def associateSubnetCidrBlock(params: AssociateSubnetCidrBlockRequest): Request[AssociateSubnetCidrBlockResult] =
      js.native
    def associateTransitGatewayRouteTable(
        params: AssociateTransitGatewayRouteTableRequest
    ): Request[AssociateTransitGatewayRouteTableResult]                                                      = js.native
    def associateVpcCidrBlock(params: AssociateVpcCidrBlockRequest): Request[AssociateVpcCidrBlockResult]    = js.native
    def attachClassicLinkVpc(params: AttachClassicLinkVpcRequest): Request[AttachClassicLinkVpcResult]       = js.native
    def attachInternetGateway(params: AttachInternetGatewayRequest): Request[js.Object]                      = js.native
    def attachNetworkInterface(params: AttachNetworkInterfaceRequest): Request[AttachNetworkInterfaceResult] = js.native
    def attachVolume(params: AttachVolumeRequest): Request[VolumeAttachment]                                 = js.native
    def attachVpnGateway(params: AttachVpnGatewayRequest): Request[AttachVpnGatewayResult]                   = js.native
    def authorizeClientVpnIngress(params: AuthorizeClientVpnIngressRequest): Request[AuthorizeClientVpnIngressResult] =
      js.native
    def authorizeSecurityGroupEgress(params: AuthorizeSecurityGroupEgressRequest): Request[js.Object]   = js.native
    def authorizeSecurityGroupIngress(params: AuthorizeSecurityGroupIngressRequest): Request[js.Object] = js.native
    def bundleInstance(params: BundleInstanceRequest): Request[BundleInstanceResult]                    = js.native
    def cancelBundleTask(params: CancelBundleTaskRequest): Request[CancelBundleTaskResult]              = js.native
    def cancelCapacityReservation(params: CancelCapacityReservationRequest): Request[CancelCapacityReservationResult] =
      js.native
    def cancelConversionTask(params: CancelConversionRequest): Request[js.Object]          = js.native
    def cancelExportTask(params: CancelExportTaskRequest): Request[js.Object]              = js.native
    def cancelImportTask(params: CancelImportTaskRequest): Request[CancelImportTaskResult] = js.native
    def cancelReservedInstancesListing(
        params: CancelReservedInstancesListingRequest
    ): Request[CancelReservedInstancesListingResult] = js.native
    def cancelSpotFleetRequests(params: CancelSpotFleetRequestsRequest): Request[CancelSpotFleetRequestsResponse] =
      js.native
    def cancelSpotInstanceRequests(
        params: CancelSpotInstanceRequestsRequest
    ): Request[CancelSpotInstanceRequestsResult]                                                             = js.native
    def confirmProductInstance(params: ConfirmProductInstanceRequest): Request[ConfirmProductInstanceResult] = js.native
    def copyFpgaImage(params: CopyFpgaImageRequest): Request[CopyFpgaImageResult]                            = js.native
    def copyImage(params: CopyImageRequest): Request[CopyImageResult]                                        = js.native
    def copySnapshot(params: CopySnapshotRequest): Request[CopySnapshotResult]                               = js.native
    def createCapacityReservation(params: CreateCapacityReservationRequest): Request[CreateCapacityReservationResult] =
      js.native
    def createClientVpnEndpoint(params: CreateClientVpnEndpointRequest): Request[CreateClientVpnEndpointResult] =
      js.native
    def createClientVpnRoute(params: CreateClientVpnRouteRequest): Request[CreateClientVpnRouteResult]    = js.native
    def createCustomerGateway(params: CreateCustomerGatewayRequest): Request[CreateCustomerGatewayResult] = js.native
    def createDefaultSubnet(params: CreateDefaultSubnetRequest): Request[CreateDefaultSubnetResult]       = js.native
    def createDefaultVpc(params: CreateDefaultVpcRequest): Request[CreateDefaultVpcResult]                = js.native
    def createDhcpOptions(params: CreateDhcpOptionsRequest): Request[CreateDhcpOptionsResult]             = js.native
    def createEgressOnlyInternetGateway(
        params: CreateEgressOnlyInternetGatewayRequest
    ): Request[CreateEgressOnlyInternetGatewayResult]                                   = js.native
    def createFleet(params: CreateFleetRequest): Request[CreateFleetResult]             = js.native
    def createFlowLogs(params: CreateFlowLogsRequest): Request[CreateFlowLogsResult]    = js.native
    def createFpgaImage(params: CreateFpgaImageRequest): Request[CreateFpgaImageResult] = js.native
    def createImage(params: CreateImageRequest): Request[CreateImageResult]             = js.native
    def createInstanceExportTask(params: CreateInstanceExportTaskRequest): Request[CreateInstanceExportTaskResult] =
      js.native
    def createInternetGateway(params: CreateInternetGatewayRequest): Request[CreateInternetGatewayResult] = js.native
    def createKeyPair(params: CreateKeyPairRequest): Request[KeyPair]                                     = js.native
    def createLaunchTemplate(params: CreateLaunchTemplateRequest): Request[CreateLaunchTemplateResult]    = js.native
    def createLaunchTemplateVersion(
        params: CreateLaunchTemplateVersionRequest
    ): Request[CreateLaunchTemplateVersionResult]                                                            = js.native
    def createNatGateway(params: CreateNatGatewayRequest): Request[CreateNatGatewayResult]                   = js.native
    def createNetworkAcl(params: CreateNetworkAclRequest): Request[CreateNetworkAclResult]                   = js.native
    def createNetworkAclEntry(params: CreateNetworkAclEntryRequest): Request[js.Object]                      = js.native
    def createNetworkInterface(params: CreateNetworkInterfaceRequest): Request[CreateNetworkInterfaceResult] = js.native
    def createNetworkInterfacePermission(
        params: CreateNetworkInterfacePermissionRequest
    ): Request[CreateNetworkInterfacePermissionResult]                                = js.native
    def createPlacementGroup(params: CreatePlacementGroupRequest): Request[js.Object] = js.native
    def createReservedInstancesListing(
        params: CreateReservedInstancesListingRequest
    ): Request[CreateReservedInstancesListingResult]                                                = js.native
    def createRoute(params: CreateRouteRequest): Request[CreateRouteResult]                         = js.native
    def createRouteTable(params: CreateRouteTableRequest): Request[CreateRouteTableResult]          = js.native
    def createSecurityGroup(params: CreateSecurityGroupRequest): Request[CreateSecurityGroupResult] = js.native
    def createSnapshot(params: CreateSnapshotRequest): Request[Snapshot]                            = js.native
    def createSnapshots(params: CreateSnapshotsRequest): Request[CreateSnapshotsResult]             = js.native
    def createSpotDatafeedSubscription(
        params: CreateSpotDatafeedSubscriptionRequest
    ): Request[CreateSpotDatafeedSubscriptionResult]                           = js.native
    def createSubnet(params: CreateSubnetRequest): Request[CreateSubnetResult] = js.native
    def createTags(params: CreateTagsRequest): Request[js.Object]              = js.native
    def createTrafficMirrorFilter(params: CreateTrafficMirrorFilterRequest): Request[CreateTrafficMirrorFilterResult] =
      js.native
    def createTrafficMirrorFilterRule(
        params: CreateTrafficMirrorFilterRuleRequest
    ): Request[CreateTrafficMirrorFilterRuleResult] = js.native
    def createTrafficMirrorSession(
        params: CreateTrafficMirrorSessionRequest
    ): Request[CreateTrafficMirrorSessionResult] = js.native
    def createTrafficMirrorTarget(params: CreateTrafficMirrorTargetRequest): Request[CreateTrafficMirrorTargetResult] =
      js.native
    def createTransitGateway(params: CreateTransitGatewayRequest): Request[CreateTransitGatewayResult] = js.native
    def createTransitGatewayRoute(params: CreateTransitGatewayRouteRequest): Request[CreateTransitGatewayRouteResult] =
      js.native
    def createTransitGatewayRouteTable(
        params: CreateTransitGatewayRouteTableRequest
    ): Request[CreateTransitGatewayRouteTableResult] = js.native
    def createTransitGatewayVpcAttachment(
        params: CreateTransitGatewayVpcAttachmentRequest
    ): Request[CreateTransitGatewayVpcAttachmentResult]                                       = js.native
    def createVolume(params: CreateVolumeRequest): Request[Volume]                            = js.native
    def createVpc(params: CreateVpcRequest): Request[CreateVpcResult]                         = js.native
    def createVpcEndpoint(params: CreateVpcEndpointRequest): Request[CreateVpcEndpointResult] = js.native
    def createVpcEndpointConnectionNotification(
        params: CreateVpcEndpointConnectionNotificationRequest
    ): Request[CreateVpcEndpointConnectionNotificationResult] = js.native
    def createVpcEndpointServiceConfiguration(
        params: CreateVpcEndpointServiceConfigurationRequest
    ): Request[CreateVpcEndpointServiceConfigurationResult] = js.native
    def createVpcPeeringConnection(
        params: CreateVpcPeeringConnectionRequest
    ): Request[CreateVpcPeeringConnectionResult]                                                    = js.native
    def createVpnConnection(params: CreateVpnConnectionRequest): Request[CreateVpnConnectionResult] = js.native
    def createVpnConnectionRoute(params: CreateVpnConnectionRouteRequest): Request[js.Object]       = js.native
    def createVpnGateway(params: CreateVpnGatewayRequest): Request[CreateVpnGatewayResult]          = js.native
    def deleteClientVpnEndpoint(params: DeleteClientVpnEndpointRequest): Request[DeleteClientVpnEndpointResult] =
      js.native
    def deleteClientVpnRoute(params: DeleteClientVpnRouteRequest): Request[DeleteClientVpnRouteResult] = js.native
    def deleteCustomerGateway(params: DeleteCustomerGatewayRequest): Request[js.Object]                = js.native
    def deleteDhcpOptions(params: DeleteDhcpOptionsRequest): Request[js.Object]                        = js.native
    def deleteEgressOnlyInternetGateway(
        params: DeleteEgressOnlyInternetGatewayRequest
    ): Request[DeleteEgressOnlyInternetGatewayResult]                                                  = js.native
    def deleteFleets(params: DeleteFleetsRequest): Request[DeleteFleetsResult]                         = js.native
    def deleteFlowLogs(params: DeleteFlowLogsRequest): Request[DeleteFlowLogsResult]                   = js.native
    def deleteFpgaImage(params: DeleteFpgaImageRequest): Request[DeleteFpgaImageResult]                = js.native
    def deleteInternetGateway(params: DeleteInternetGatewayRequest): Request[js.Object]                = js.native
    def deleteKeyPair(params: DeleteKeyPairRequest): Request[js.Object]                                = js.native
    def deleteLaunchTemplate(params: DeleteLaunchTemplateRequest): Request[DeleteLaunchTemplateResult] = js.native
    def deleteLaunchTemplateVersions(
        params: DeleteLaunchTemplateVersionsRequest
    ): Request[DeleteLaunchTemplateVersionsResult]                                         = js.native
    def deleteNatGateway(params: DeleteNatGatewayRequest): Request[DeleteNatGatewayResult] = js.native
    def deleteNetworkAcl(params: DeleteNetworkAclRequest): Request[js.Object]              = js.native
    def deleteNetworkAclEntry(params: DeleteNetworkAclEntryRequest): Request[js.Object]    = js.native
    def deleteNetworkInterface(params: DeleteNetworkInterfaceRequest): Request[js.Object]  = js.native
    def deleteNetworkInterfacePermission(
        params: DeleteNetworkInterfacePermissionRequest
    ): Request[DeleteNetworkInterfacePermissionResult]                                                    = js.native
    def deletePlacementGroup(params: DeletePlacementGroupRequest): Request[js.Object]                     = js.native
    def deleteRoute(params: DeleteRouteRequest): Request[js.Object]                                       = js.native
    def deleteRouteTable(params: DeleteRouteTableRequest): Request[js.Object]                             = js.native
    def deleteSecurityGroup(params: DeleteSecurityGroupRequest): Request[js.Object]                       = js.native
    def deleteSnapshot(params: DeleteSnapshotRequest): Request[js.Object]                                 = js.native
    def deleteSpotDatafeedSubscription(params: DeleteSpotDatafeedSubscriptionRequest): Request[js.Object] = js.native
    def deleteSubnet(params: DeleteSubnetRequest): Request[js.Object]                                     = js.native
    def deleteTags(params: DeleteTagsRequest): Request[js.Object]                                         = js.native
    def deleteTrafficMirrorFilter(params: DeleteTrafficMirrorFilterRequest): Request[DeleteTrafficMirrorFilterResult] =
      js.native
    def deleteTrafficMirrorFilterRule(
        params: DeleteTrafficMirrorFilterRuleRequest
    ): Request[DeleteTrafficMirrorFilterRuleResult] = js.native
    def deleteTrafficMirrorSession(
        params: DeleteTrafficMirrorSessionRequest
    ): Request[DeleteTrafficMirrorSessionResult] = js.native
    def deleteTrafficMirrorTarget(params: DeleteTrafficMirrorTargetRequest): Request[DeleteTrafficMirrorTargetResult] =
      js.native
    def deleteTransitGateway(params: DeleteTransitGatewayRequest): Request[DeleteTransitGatewayResult] = js.native
    def deleteTransitGatewayRoute(params: DeleteTransitGatewayRouteRequest): Request[DeleteTransitGatewayRouteResult] =
      js.native
    def deleteTransitGatewayRouteTable(
        params: DeleteTransitGatewayRouteTableRequest
    ): Request[DeleteTransitGatewayRouteTableResult] = js.native
    def deleteTransitGatewayVpcAttachment(
        params: DeleteTransitGatewayVpcAttachmentRequest
    ): Request[DeleteTransitGatewayVpcAttachmentResult]               = js.native
    def deleteVolume(params: DeleteVolumeRequest): Request[js.Object] = js.native
    def deleteVpc(params: DeleteVpcRequest): Request[js.Object]       = js.native
    def deleteVpcEndpointConnectionNotifications(
        params: DeleteVpcEndpointConnectionNotificationsRequest
    ): Request[DeleteVpcEndpointConnectionNotificationsResult] = js.native
    def deleteVpcEndpointServiceConfigurations(
        params: DeleteVpcEndpointServiceConfigurationsRequest
    ): Request[DeleteVpcEndpointServiceConfigurationsResult]                                     = js.native
    def deleteVpcEndpoints(params: DeleteVpcEndpointsRequest): Request[DeleteVpcEndpointsResult] = js.native
    def deleteVpcPeeringConnection(
        params: DeleteVpcPeeringConnectionRequest
    ): Request[DeleteVpcPeeringConnectionResult]                                                       = js.native
    def deleteVpnConnection(params: DeleteVpnConnectionRequest): Request[js.Object]                    = js.native
    def deleteVpnConnectionRoute(params: DeleteVpnConnectionRouteRequest): Request[js.Object]          = js.native
    def deleteVpnGateway(params: DeleteVpnGatewayRequest): Request[js.Object]                          = js.native
    def deprovisionByoipCidr(params: DeprovisionByoipCidrRequest): Request[DeprovisionByoipCidrResult] = js.native
    def deregisterImage(params: DeregisterImageRequest): Request[js.Object]                            = js.native
    def describeAccountAttributes(params: DescribeAccountAttributesRequest): Request[DescribeAccountAttributesResult] =
      js.native
    def describeAddresses(params: DescribeAddressesRequest): Request[DescribeAddressesResult] = js.native
    def describeAggregateIdFormat(params: DescribeAggregateIdFormatRequest): Request[DescribeAggregateIdFormatResult] =
      js.native
    def describeAvailabilityZones(params: DescribeAvailabilityZonesRequest): Request[DescribeAvailabilityZonesResult] =
      js.native
    def describeBundleTasks(params: DescribeBundleTasksRequest): Request[DescribeBundleTasksResult] = js.native
    def describeByoipCidrs(params: DescribeByoipCidrsRequest): Request[DescribeByoipCidrsResult]    = js.native
    def describeCapacityReservations(
        params: DescribeCapacityReservationsRequest
    ): Request[DescribeCapacityReservationsResult] = js.native
    def describeClassicLinkInstances(
        params: DescribeClassicLinkInstancesRequest
    ): Request[DescribeClassicLinkInstancesResult] = js.native
    def describeClientVpnAuthorizationRules(
        params: DescribeClientVpnAuthorizationRulesRequest
    ): Request[DescribeClientVpnAuthorizationRulesResult] = js.native
    def describeClientVpnConnections(
        params: DescribeClientVpnConnectionsRequest
    ): Request[DescribeClientVpnConnectionsResult] = js.native
    def describeClientVpnEndpoints(
        params: DescribeClientVpnEndpointsRequest
    ): Request[DescribeClientVpnEndpointsResult] = js.native
    def describeClientVpnRoutes(params: DescribeClientVpnRoutesRequest): Request[DescribeClientVpnRoutesResult] =
      js.native
    def describeClientVpnTargetNetworks(
        params: DescribeClientVpnTargetNetworksRequest
    ): Request[DescribeClientVpnTargetNetworksResult] = js.native
    def describeConversionTasks(params: DescribeConversionTasksRequest): Request[DescribeConversionTasksResult] =
      js.native
    def describeCustomerGateways(params: DescribeCustomerGatewaysRequest): Request[DescribeCustomerGatewaysResult] =
      js.native
    def describeDhcpOptions(params: DescribeDhcpOptionsRequest): Request[DescribeDhcpOptionsResult] = js.native
    def describeEgressOnlyInternetGateways(
        params: DescribeEgressOnlyInternetGatewaysRequest
    ): Request[DescribeEgressOnlyInternetGatewaysResult]                                            = js.native
    def describeElasticGpus(params: DescribeElasticGpusRequest): Request[DescribeElasticGpusResult] = js.native
    def describeExportImageTasks(params: DescribeExportImageTasksRequest): Request[DescribeExportImageTasksResult] =
      js.native
    def describeExportTasks(params: DescribeExportTasksRequest): Request[DescribeExportTasksResult]          = js.native
    def describeFleetHistory(params: DescribeFleetHistoryRequest): Request[DescribeFleetHistoryResult]       = js.native
    def describeFleetInstances(params: DescribeFleetInstancesRequest): Request[DescribeFleetInstancesResult] = js.native
    def describeFleets(params: DescribeFleetsRequest): Request[DescribeFleetsResult]                         = js.native
    def describeFlowLogs(params: DescribeFlowLogsRequest): Request[DescribeFlowLogsResult]                   = js.native
    def describeFpgaImageAttribute(
        params: DescribeFpgaImageAttributeRequest
    ): Request[DescribeFpgaImageAttributeResult]                                                 = js.native
    def describeFpgaImages(params: DescribeFpgaImagesRequest): Request[DescribeFpgaImagesResult] = js.native
    def describeHostReservationOfferings(
        params: DescribeHostReservationOfferingsRequest
    ): Request[DescribeHostReservationOfferingsResult] = js.native
    def describeHostReservations(params: DescribeHostReservationsRequest): Request[DescribeHostReservationsResult] =
      js.native
    def describeHosts(params: DescribeHostsRequest): Request[DescribeHostsResult] = js.native
    def describeIamInstanceProfileAssociations(
        params: DescribeIamInstanceProfileAssociationsRequest
    ): Request[DescribeIamInstanceProfileAssociationsResult]                               = js.native
    def describeIdFormat(params: DescribeIdFormatRequest): Request[DescribeIdFormatResult] = js.native
    def describeIdentityIdFormat(params: DescribeIdentityIdFormatRequest): Request[DescribeIdentityIdFormatResult] =
      js.native
    def describeImageAttribute(params: DescribeImageAttributeRequest): Request[ImageAttribute] = js.native
    def describeImages(params: DescribeImagesRequest): Request[DescribeImagesResult]           = js.native
    def describeImportImageTasks(params: DescribeImportImageTasksRequest): Request[DescribeImportImageTasksResult] =
      js.native
    def describeImportSnapshotTasks(
        params: DescribeImportSnapshotTasksRequest
    ): Request[DescribeImportSnapshotTasksResult]                                                       = js.native
    def describeInstanceAttribute(params: DescribeInstanceAttributeRequest): Request[InstanceAttribute] = js.native
    def describeInstanceCreditSpecifications(
        params: DescribeInstanceCreditSpecificationsRequest
    ): Request[DescribeInstanceCreditSpecificationsResult]                                                   = js.native
    def describeInstanceStatus(params: DescribeInstanceStatusRequest): Request[DescribeInstanceStatusResult] = js.native
    def describeInstances(params: DescribeInstancesRequest): Request[DescribeInstancesResult]                = js.native
    def describeInternetGateways(params: DescribeInternetGatewaysRequest): Request[DescribeInternetGatewaysResult] =
      js.native
    def describeKeyPairs(params: DescribeKeyPairsRequest): Request[DescribeKeyPairsResult] = js.native
    def describeLaunchTemplateVersions(
        params: DescribeLaunchTemplateVersionsRequest
    ): Request[DescribeLaunchTemplateVersionsResult] = js.native
    def describeLaunchTemplates(params: DescribeLaunchTemplatesRequest): Request[DescribeLaunchTemplatesResult] =
      js.native
    def describeMovingAddresses(params: DescribeMovingAddressesRequest): Request[DescribeMovingAddressesResult] =
      js.native
    def describeNatGateways(params: DescribeNatGatewaysRequest): Request[DescribeNatGatewaysResult] = js.native
    def describeNetworkAcls(params: DescribeNetworkAclsRequest): Request[DescribeNetworkAclsResult] = js.native
    def describeNetworkInterfaceAttribute(
        params: DescribeNetworkInterfaceAttributeRequest
    ): Request[DescribeNetworkInterfaceAttributeResult] = js.native
    def describeNetworkInterfacePermissions(
        params: DescribeNetworkInterfacePermissionsRequest
    ): Request[DescribeNetworkInterfacePermissionsResult] = js.native
    def describeNetworkInterfaces(params: DescribeNetworkInterfacesRequest): Request[DescribeNetworkInterfacesResult] =
      js.native
    def describePlacementGroups(params: DescribePlacementGroupsRequest): Request[DescribePlacementGroupsResult] =
      js.native
    def describePrefixLists(params: DescribePrefixListsRequest): Request[DescribePrefixListsResult] = js.native
    def describePrincipalIdFormat(params: DescribePrincipalIdFormatRequest): Request[DescribePrincipalIdFormatResult] =
      js.native
    def describePublicIpv4Pools(params: DescribePublicIpv4PoolsRequest): Request[DescribePublicIpv4PoolsResult] =
      js.native
    def describeRegions(params: DescribeRegionsRequest): Request[DescribeRegionsResult] = js.native
    def describeReservedInstances(params: DescribeReservedInstancesRequest): Request[DescribeReservedInstancesResult] =
      js.native
    def describeReservedInstancesListings(
        params: DescribeReservedInstancesListingsRequest
    ): Request[DescribeReservedInstancesListingsResult] = js.native
    def describeReservedInstancesModifications(
        params: DescribeReservedInstancesModificationsRequest
    ): Request[DescribeReservedInstancesModificationsResult] = js.native
    def describeReservedInstancesOfferings(
        params: DescribeReservedInstancesOfferingsRequest
    ): Request[DescribeReservedInstancesOfferingsResult]                                            = js.native
    def describeRouteTables(params: DescribeRouteTablesRequest): Request[DescribeRouteTablesResult] = js.native
    def describeScheduledInstanceAvailability(
        params: DescribeScheduledInstanceAvailabilityRequest
    ): Request[DescribeScheduledInstanceAvailabilityResult] = js.native
    def describeScheduledInstances(
        params: DescribeScheduledInstancesRequest
    ): Request[DescribeScheduledInstancesResult] = js.native
    def describeSecurityGroupReferences(
        params: DescribeSecurityGroupReferencesRequest
    ): Request[DescribeSecurityGroupReferencesResult]                                                        = js.native
    def describeSecurityGroups(params: DescribeSecurityGroupsRequest): Request[DescribeSecurityGroupsResult] = js.native
    def describeSnapshotAttribute(params: DescribeSnapshotAttributeRequest): Request[DescribeSnapshotAttributeResult] =
      js.native
    def describeSnapshots(params: DescribeSnapshotsRequest): Request[DescribeSnapshotsResult] = js.native
    def describeSpotDatafeedSubscription(
        params: DescribeSpotDatafeedSubscriptionRequest
    ): Request[DescribeSpotDatafeedSubscriptionResult] = js.native
    def describeSpotFleetInstances(
        params: DescribeSpotFleetInstancesRequest
    ): Request[DescribeSpotFleetInstancesResponse] = js.native
    def describeSpotFleetRequestHistory(
        params: DescribeSpotFleetRequestHistoryRequest
    ): Request[DescribeSpotFleetRequestHistoryResponse] = js.native
    def describeSpotFleetRequests(
        params: DescribeSpotFleetRequestsRequest
    ): Request[DescribeSpotFleetRequestsResponse] = js.native
    def describeSpotInstanceRequests(
        params: DescribeSpotInstanceRequestsRequest
    ): Request[DescribeSpotInstanceRequestsResult] = js.native
    def describeSpotPriceHistory(params: DescribeSpotPriceHistoryRequest): Request[DescribeSpotPriceHistoryResult] =
      js.native
    def describeStaleSecurityGroups(
        params: DescribeStaleSecurityGroupsRequest
    ): Request[DescribeStaleSecurityGroupsResult]                                       = js.native
    def describeSubnets(params: DescribeSubnetsRequest): Request[DescribeSubnetsResult] = js.native
    def describeTags(params: DescribeTagsRequest): Request[DescribeTagsResult]          = js.native
    def describeTrafficMirrorFilters(
        params: DescribeTrafficMirrorFiltersRequest
    ): Request[DescribeTrafficMirrorFiltersResult] = js.native
    def describeTrafficMirrorSessions(
        params: DescribeTrafficMirrorSessionsRequest
    ): Request[DescribeTrafficMirrorSessionsResult] = js.native
    def describeTrafficMirrorTargets(
        params: DescribeTrafficMirrorTargetsRequest
    ): Request[DescribeTrafficMirrorTargetsResult] = js.native
    def describeTransitGatewayAttachments(
        params: DescribeTransitGatewayAttachmentsRequest
    ): Request[DescribeTransitGatewayAttachmentsResult] = js.native
    def describeTransitGatewayRouteTables(
        params: DescribeTransitGatewayRouteTablesRequest
    ): Request[DescribeTransitGatewayRouteTablesResult] = js.native
    def describeTransitGatewayVpcAttachments(
        params: DescribeTransitGatewayVpcAttachmentsRequest
    ): Request[DescribeTransitGatewayVpcAttachmentsResult] = js.native
    def describeTransitGateways(params: DescribeTransitGatewaysRequest): Request[DescribeTransitGatewaysResult] =
      js.native
    def describeVolumeAttribute(params: DescribeVolumeAttributeRequest): Request[DescribeVolumeAttributeResult] =
      js.native
    def describeVolumeStatus(params: DescribeVolumeStatusRequest): Request[DescribeVolumeStatusResult] = js.native
    def describeVolumes(params: DescribeVolumesRequest): Request[DescribeVolumesResult]                = js.native
    def describeVolumesModifications(
        params: DescribeVolumesModificationsRequest
    ): Request[DescribeVolumesModificationsResult]                                                           = js.native
    def describeVpcAttribute(params: DescribeVpcAttributeRequest): Request[DescribeVpcAttributeResult]       = js.native
    def describeVpcClassicLink(params: DescribeVpcClassicLinkRequest): Request[DescribeVpcClassicLinkResult] = js.native
    def describeVpcClassicLinkDnsSupport(
        params: DescribeVpcClassicLinkDnsSupportRequest
    ): Request[DescribeVpcClassicLinkDnsSupportResult] = js.native
    def describeVpcEndpointConnectionNotifications(
        params: DescribeVpcEndpointConnectionNotificationsRequest
    ): Request[DescribeVpcEndpointConnectionNotificationsResult] = js.native
    def describeVpcEndpointConnections(
        params: DescribeVpcEndpointConnectionsRequest
    ): Request[DescribeVpcEndpointConnectionsResult] = js.native
    def describeVpcEndpointServiceConfigurations(
        params: DescribeVpcEndpointServiceConfigurationsRequest
    ): Request[DescribeVpcEndpointServiceConfigurationsResult] = js.native
    def describeVpcEndpointServicePermissions(
        params: DescribeVpcEndpointServicePermissionsRequest
    ): Request[DescribeVpcEndpointServicePermissionsResult] = js.native
    def describeVpcEndpointServices(
        params: DescribeVpcEndpointServicesRequest
    ): Request[DescribeVpcEndpointServicesResult]                                                      = js.native
    def describeVpcEndpoints(params: DescribeVpcEndpointsRequest): Request[DescribeVpcEndpointsResult] = js.native
    def describeVpcPeeringConnections(
        params: DescribeVpcPeeringConnectionsRequest
    ): Request[DescribeVpcPeeringConnectionsResult]                                                          = js.native
    def describeVpcs(params: DescribeVpcsRequest): Request[DescribeVpcsResult]                               = js.native
    def describeVpnConnections(params: DescribeVpnConnectionsRequest): Request[DescribeVpnConnectionsResult] = js.native
    def describeVpnGateways(params: DescribeVpnGatewaysRequest): Request[DescribeVpnGatewaysResult]          = js.native
    def detachClassicLinkVpc(params: DetachClassicLinkVpcRequest): Request[DetachClassicLinkVpcResult]       = js.native
    def detachInternetGateway(params: DetachInternetGatewayRequest): Request[js.Object]                      = js.native
    def detachNetworkInterface(params: DetachNetworkInterfaceRequest): Request[js.Object]                    = js.native
    def detachVolume(params: DetachVolumeRequest): Request[VolumeAttachment]                                 = js.native
    def detachVpnGateway(params: DetachVpnGatewayRequest): Request[js.Object]                                = js.native
    def disableEbsEncryptionByDefault(
        params: DisableEbsEncryptionByDefaultRequest
    ): Request[DisableEbsEncryptionByDefaultResult] = js.native
    def disableTransitGatewayRouteTablePropagation(
        params: DisableTransitGatewayRouteTablePropagationRequest
    ): Request[DisableTransitGatewayRouteTablePropagationResult]                                          = js.native
    def disableVgwRoutePropagation(params: DisableVgwRoutePropagationRequest): Request[js.Object]         = js.native
    def disableVpcClassicLink(params: DisableVpcClassicLinkRequest): Request[DisableVpcClassicLinkResult] = js.native
    def disableVpcClassicLinkDnsSupport(
        params: DisableVpcClassicLinkDnsSupportRequest
    ): Request[DisableVpcClassicLinkDnsSupportResult]                               = js.native
    def disassociateAddress(params: DisassociateAddressRequest): Request[js.Object] = js.native
    def disassociateClientVpnTargetNetwork(
        params: DisassociateClientVpnTargetNetworkRequest
    ): Request[DisassociateClientVpnTargetNetworkResult] = js.native
    def disassociateIamInstanceProfile(
        params: DisassociateIamInstanceProfileRequest
    ): Request[DisassociateIamInstanceProfileResult]                                      = js.native
    def disassociateRouteTable(params: DisassociateRouteTableRequest): Request[js.Object] = js.native
    def disassociateSubnetCidrBlock(
        params: DisassociateSubnetCidrBlockRequest
    ): Request[DisassociateSubnetCidrBlockResult] = js.native
    def disassociateTransitGatewayRouteTable(
        params: DisassociateTransitGatewayRouteTableRequest
    ): Request[DisassociateTransitGatewayRouteTableResult] = js.native
    def disassociateVpcCidrBlock(params: DisassociateVpcCidrBlockRequest): Request[DisassociateVpcCidrBlockResult] =
      js.native
    def enableEbsEncryptionByDefault(
        params: EnableEbsEncryptionByDefaultRequest
    ): Request[EnableEbsEncryptionByDefaultResult] = js.native
    def enableTransitGatewayRouteTablePropagation(
        params: EnableTransitGatewayRouteTablePropagationRequest
    ): Request[EnableTransitGatewayRouteTablePropagationResult]                                        = js.native
    def enableVgwRoutePropagation(params: EnableVgwRoutePropagationRequest): Request[js.Object]        = js.native
    def enableVolumeIO(params: EnableVolumeIORequest): Request[js.Object]                              = js.native
    def enableVpcClassicLink(params: EnableVpcClassicLinkRequest): Request[EnableVpcClassicLinkResult] = js.native
    def enableVpcClassicLinkDnsSupport(
        params: EnableVpcClassicLinkDnsSupportRequest
    ): Request[EnableVpcClassicLinkDnsSupportResult] = js.native
    def exportClientVpnClientCertificateRevocationList(
        params: ExportClientVpnClientCertificateRevocationListRequest
    ): Request[ExportClientVpnClientCertificateRevocationListResult] = js.native
    def exportClientVpnClientConfiguration(
        params: ExportClientVpnClientConfigurationRequest
    ): Request[ExportClientVpnClientConfigurationResult]                    = js.native
    def exportImage(params: ExportImageRequest): Request[ExportImageResult] = js.native
    def exportTransitGatewayRoutes(
        params: ExportTransitGatewayRoutesRequest
    ): Request[ExportTransitGatewayRoutesResult] = js.native
    def getCapacityReservationUsage(
        params: GetCapacityReservationUsageRequest
    ): Request[GetCapacityReservationUsageResult]                                                         = js.native
    def getConsoleOutput(params: GetConsoleOutputRequest): Request[GetConsoleOutputResult]                = js.native
    def getConsoleScreenshot(params: GetConsoleScreenshotRequest): Request[GetConsoleScreenshotResult]    = js.native
    def getEbsDefaultKmsKeyId(params: GetEbsDefaultKmsKeyIdRequest): Request[GetEbsDefaultKmsKeyIdResult] = js.native
    def getEbsEncryptionByDefault(params: GetEbsEncryptionByDefaultRequest): Request[GetEbsEncryptionByDefaultResult] =
      js.native
    def getHostReservationPurchasePreview(
        params: GetHostReservationPurchasePreviewRequest
    ): Request[GetHostReservationPurchasePreviewResult]                                                   = js.native
    def getLaunchTemplateData(params: GetLaunchTemplateDataRequest): Request[GetLaunchTemplateDataResult] = js.native
    def getPasswordData(params: GetPasswordDataRequest): Request[GetPasswordDataResult]                   = js.native
    def getReservedInstancesExchangeQuote(
        params: GetReservedInstancesExchangeQuoteRequest
    ): Request[GetReservedInstancesExchangeQuoteResult] = js.native
    def getTransitGatewayAttachmentPropagations(
        params: GetTransitGatewayAttachmentPropagationsRequest
    ): Request[GetTransitGatewayAttachmentPropagationsResult] = js.native
    def getTransitGatewayRouteTableAssociations(
        params: GetTransitGatewayRouteTableAssociationsRequest
    ): Request[GetTransitGatewayRouteTableAssociationsResult] = js.native
    def getTransitGatewayRouteTablePropagations(
        params: GetTransitGatewayRouteTablePropagationsRequest
    ): Request[GetTransitGatewayRouteTablePropagationsResult] = js.native
    def importClientVpnClientCertificateRevocationList(
        params: ImportClientVpnClientCertificateRevocationListRequest
    ): Request[ImportClientVpnClientCertificateRevocationListResult]                 = js.native
    def importImage(params: ImportImageRequest): Request[ImportImageResult]          = js.native
    def importInstance(params: ImportInstanceRequest): Request[ImportInstanceResult] = js.native
    def importKeyPair(params: ImportKeyPairRequest): Request[ImportKeyPairResult]    = js.native
    def importSnapshot(params: ImportSnapshotRequest): Request[ImportSnapshotResult] = js.native
    def importVolume(params: ImportVolumeRequest): Request[ImportVolumeResult]       = js.native
    def modifyCapacityReservation(params: ModifyCapacityReservationRequest): Request[ModifyCapacityReservationResult] =
      js.native
    def modifyClientVpnEndpoint(params: ModifyClientVpnEndpointRequest): Request[ModifyClientVpnEndpointResult] =
      js.native
    def modifyEbsDefaultKmsKeyId(params: ModifyEbsDefaultKmsKeyIdRequest): Request[ModifyEbsDefaultKmsKeyIdResult] =
      js.native
    def modifyFleet(params: ModifyFleetRequest): Request[ModifyFleetResult] = js.native
    def modifyFpgaImageAttribute(params: ModifyFpgaImageAttributeRequest): Request[ModifyFpgaImageAttributeResult] =
      js.native
    def modifyHosts(params: ModifyHostsRequest): Request[ModifyHostsResult]                 = js.native
    def modifyIdFormat(params: ModifyIdFormatRequest): Request[js.Object]                   = js.native
    def modifyIdentityIdFormat(params: ModifyIdentityIdFormatRequest): Request[js.Object]   = js.native
    def modifyImageAttribute(params: ModifyImageAttributeRequest): Request[js.Object]       = js.native
    def modifyInstanceAttribute(params: ModifyInstanceAttributeRequest): Request[js.Object] = js.native
    def modifyInstanceCapacityReservationAttributes(
        params: ModifyInstanceCapacityReservationAttributesRequest
    ): Request[ModifyInstanceCapacityReservationAttributesResult] = js.native
    def modifyInstanceCreditSpecification(
        params: ModifyInstanceCreditSpecificationRequest
    ): Request[ModifyInstanceCreditSpecificationResult] = js.native
    def modifyInstanceEventStartTime(
        params: ModifyInstanceEventStartTimeRequest
    ): Request[ModifyInstanceEventStartTimeResult] = js.native
    def modifyInstancePlacement(params: ModifyInstancePlacementRequest): Request[ModifyInstancePlacementResult] =
      js.native
    def modifyLaunchTemplate(params: ModifyLaunchTemplateRequest): Request[ModifyLaunchTemplateResult]      = js.native
    def modifyNetworkInterfaceAttribute(params: ModifyNetworkInterfaceAttributeRequest): Request[js.Object] = js.native
    def modifyReservedInstances(params: ModifyReservedInstancesRequest): Request[ModifyReservedInstancesResult] =
      js.native
    def modifySnapshotAttribute(params: ModifySnapshotAttributeRequest): Request[js.Object] = js.native
    def modifySpotFleetRequest(params: ModifySpotFleetRequestRequest): Request[ModifySpotFleetRequestResponse] =
      js.native
    def modifySubnetAttribute(params: ModifySubnetAttributeRequest): Request[js.Object] = js.native
    def modifyTrafficMirrorFilterNetworkServices(
        params: ModifyTrafficMirrorFilterNetworkServicesRequest
    ): Request[ModifyTrafficMirrorFilterNetworkServicesResult] = js.native
    def modifyTrafficMirrorFilterRule(
        params: ModifyTrafficMirrorFilterRuleRequest
    ): Request[ModifyTrafficMirrorFilterRuleResult] = js.native
    def modifyTrafficMirrorSession(
        params: ModifyTrafficMirrorSessionRequest
    ): Request[ModifyTrafficMirrorSessionResult] = js.native
    def modifyTransitGatewayVpcAttachment(
        params: ModifyTransitGatewayVpcAttachmentRequest
    ): Request[ModifyTransitGatewayVpcAttachmentResult]                                       = js.native
    def modifyVolume(params: ModifyVolumeRequest): Request[ModifyVolumeResult]                = js.native
    def modifyVolumeAttribute(params: ModifyVolumeAttributeRequest): Request[js.Object]       = js.native
    def modifyVpcAttribute(params: ModifyVpcAttributeRequest): Request[js.Object]             = js.native
    def modifyVpcEndpoint(params: ModifyVpcEndpointRequest): Request[ModifyVpcEndpointResult] = js.native
    def modifyVpcEndpointConnectionNotification(
        params: ModifyVpcEndpointConnectionNotificationRequest
    ): Request[ModifyVpcEndpointConnectionNotificationResult] = js.native
    def modifyVpcEndpointServiceConfiguration(
        params: ModifyVpcEndpointServiceConfigurationRequest
    ): Request[ModifyVpcEndpointServiceConfigurationResult] = js.native
    def modifyVpcEndpointServicePermissions(
        params: ModifyVpcEndpointServicePermissionsRequest
    ): Request[ModifyVpcEndpointServicePermissionsResult] = js.native
    def modifyVpcPeeringConnectionOptions(
        params: ModifyVpcPeeringConnectionOptionsRequest
    ): Request[ModifyVpcPeeringConnectionOptionsResult]                                             = js.native
    def modifyVpcTenancy(params: ModifyVpcTenancyRequest): Request[ModifyVpcTenancyResult]          = js.native
    def modifyVpnConnection(params: ModifyVpnConnectionRequest): Request[ModifyVpnConnectionResult] = js.native
    def modifyVpnTunnelCertificate(
        params: ModifyVpnTunnelCertificateRequest
    ): Request[ModifyVpnTunnelCertificateResult]                                                 = js.native
    def monitorInstances(params: MonitorInstancesRequest): Request[MonitorInstancesResult]       = js.native
    def moveAddressToVpc(params: MoveAddressToVpcRequest): Request[MoveAddressToVpcResult]       = js.native
    def provisionByoipCidr(params: ProvisionByoipCidrRequest): Request[ProvisionByoipCidrResult] = js.native
    def purchaseHostReservation(params: PurchaseHostReservationRequest): Request[PurchaseHostReservationResult] =
      js.native
    def purchaseReservedInstancesOffering(
        params: PurchaseReservedInstancesOfferingRequest
    ): Request[PurchaseReservedInstancesOfferingResult] = js.native
    def purchaseScheduledInstances(
        params: PurchaseScheduledInstancesRequest
    ): Request[PurchaseScheduledInstancesResult]                                  = js.native
    def rebootInstances(params: RebootInstancesRequest): Request[js.Object]       = js.native
    def registerImage(params: RegisterImageRequest): Request[RegisterImageResult] = js.native
    def rejectTransitGatewayVpcAttachment(
        params: RejectTransitGatewayVpcAttachmentRequest
    ): Request[RejectTransitGatewayVpcAttachmentResult] = js.native
    def rejectVpcEndpointConnections(
        params: RejectVpcEndpointConnectionsRequest
    ): Request[RejectVpcEndpointConnectionsResult] = js.native
    def rejectVpcPeeringConnection(
        params: RejectVpcPeeringConnectionRequest
    ): Request[RejectVpcPeeringConnectionResult]                               = js.native
    def releaseAddress(params: ReleaseAddressRequest): Request[js.Object]      = js.native
    def releaseHosts(params: ReleaseHostsRequest): Request[ReleaseHostsResult] = js.native
    def replaceIamInstanceProfileAssociation(
        params: ReplaceIamInstanceProfileAssociationRequest
    ): Request[ReplaceIamInstanceProfileAssociationResult] = js.native
    def replaceNetworkAclAssociation(
        params: ReplaceNetworkAclAssociationRequest
    ): Request[ReplaceNetworkAclAssociationResult]                                        = js.native
    def replaceNetworkAclEntry(params: ReplaceNetworkAclEntryRequest): Request[js.Object] = js.native
    def replaceRoute(params: ReplaceRouteRequest): Request[js.Object]                     = js.native
    def replaceRouteTableAssociation(
        params: ReplaceRouteTableAssociationRequest
    ): Request[ReplaceRouteTableAssociationResult] = js.native
    def replaceTransitGatewayRoute(
        params: ReplaceTransitGatewayRouteRequest
    ): Request[ReplaceTransitGatewayRouteResult]                                                       = js.native
    def reportInstanceStatus(params: ReportInstanceStatusRequest): Request[js.Object]                  = js.native
    def requestSpotFleet(params: RequestSpotFleetRequest): Request[RequestSpotFleetResponse]           = js.native
    def requestSpotInstances(params: RequestSpotInstancesRequest): Request[RequestSpotInstancesResult] = js.native
    def resetEbsDefaultKmsKeyId(params: ResetEbsDefaultKmsKeyIdRequest): Request[ResetEbsDefaultKmsKeyIdResult] =
      js.native
    def resetFpgaImageAttribute(params: ResetFpgaImageAttributeRequest): Request[ResetFpgaImageAttributeResult] =
      js.native
    def resetImageAttribute(params: ResetImageAttributeRequest): Request[js.Object]                       = js.native
    def resetInstanceAttribute(params: ResetInstanceAttributeRequest): Request[js.Object]                 = js.native
    def resetNetworkInterfaceAttribute(params: ResetNetworkInterfaceAttributeRequest): Request[js.Object] = js.native
    def resetSnapshotAttribute(params: ResetSnapshotAttributeRequest): Request[js.Object]                 = js.native
    def restoreAddressToClassic(params: RestoreAddressToClassicRequest): Request[RestoreAddressToClassicResult] =
      js.native
    def revokeClientVpnIngress(params: RevokeClientVpnIngressRequest): Request[RevokeClientVpnIngressResult] = js.native
    def revokeSecurityGroupEgress(params: RevokeSecurityGroupEgressRequest): Request[js.Object]              = js.native
    def revokeSecurityGroupIngress(params: RevokeSecurityGroupIngressRequest): Request[js.Object]            = js.native
    def runInstances(params: RunInstancesRequest): Request[Reservation]                                      = js.native
    def runScheduledInstances(params: RunScheduledInstancesRequest): Request[RunScheduledInstancesResult]    = js.native
    def searchTransitGatewayRoutes(
        params: SearchTransitGatewayRoutesRequest
    ): Request[SearchTransitGatewayRoutesResult]                                            = js.native
    def sendDiagnosticInterrupt(params: SendDiagnosticInterruptRequest): Request[js.Object] = js.native
    def startInstances(params: StartInstancesRequest): Request[StartInstancesResult]        = js.native
    def stopInstances(params: StopInstancesRequest): Request[StopInstancesResult]           = js.native
    def terminateClientVpnConnections(
        params: TerminateClientVpnConnectionsRequest
    ): Request[TerminateClientVpnConnectionsResult]                                                       = js.native
    def terminateInstances(params: TerminateInstancesRequest): Request[TerminateInstancesResult]          = js.native
    def unassignIpv6Addresses(params: UnassignIpv6AddressesRequest): Request[UnassignIpv6AddressesResult] = js.native
    def unassignPrivateIpAddresses(params: UnassignPrivateIpAddressesRequest): Request[js.Object]         = js.native
    def unmonitorInstances(params: UnmonitorInstancesRequest): Request[UnmonitorInstancesResult]          = js.native
    def updateSecurityGroupRuleDescriptionsEgress(
        params: UpdateSecurityGroupRuleDescriptionsEgressRequest
    ): Request[UpdateSecurityGroupRuleDescriptionsEgressResult] = js.native
    def updateSecurityGroupRuleDescriptionsIngress(
        params: UpdateSecurityGroupRuleDescriptionsIngressRequest
    ): Request[UpdateSecurityGroupRuleDescriptionsIngressResult]                              = js.native
    def withdrawByoipCidr(params: WithdrawByoipCidrRequest): Request[WithdrawByoipCidrResult] = js.native
  }

  /**
    * Contains the parameters for accepting the quote.
    */
  @js.native
  trait AcceptReservedInstancesExchangeQuoteRequest extends js.Object {
    var ReservedInstanceIds: ReservedInstanceIdSet
    var DryRun: js.UndefOr[Boolean]
    var TargetConfigurations: js.UndefOr[TargetConfigurationRequestSet]
  }

  object AcceptReservedInstancesExchangeQuoteRequest {
    @inline
    def apply(
        ReservedInstanceIds: ReservedInstanceIdSet,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TargetConfigurations: js.UndefOr[TargetConfigurationRequestSet] = js.undefined
    ): AcceptReservedInstancesExchangeQuoteRequest = {
      val __obj = js.Dynamic.literal(
        "ReservedInstanceIds" -> ReservedInstanceIds.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      TargetConfigurations.foreach(__v => __obj.updateDynamic("TargetConfigurations")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AcceptReservedInstancesExchangeQuoteRequest]
    }
  }

  /**
    * The result of the exchange and whether it was <code>successful</code>.
    */
  @js.native
  trait AcceptReservedInstancesExchangeQuoteResult extends js.Object {
    var ExchangeId: js.UndefOr[String]
  }

  object AcceptReservedInstancesExchangeQuoteResult {
    @inline
    def apply(
        ExchangeId: js.UndefOr[String] = js.undefined
    ): AcceptReservedInstancesExchangeQuoteResult = {
      val __obj = js.Dynamic.literal()
      ExchangeId.foreach(__v => __obj.updateDynamic("ExchangeId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AcceptReservedInstancesExchangeQuoteResult]
    }
  }

  @js.native
  trait AcceptTransitGatewayVpcAttachmentRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AcceptTransitGatewayVpcAttachmentRequest {
    @inline
    def apply(
        TransitGatewayAttachmentId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AcceptTransitGatewayVpcAttachmentRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AcceptTransitGatewayVpcAttachmentRequest]
    }
  }

  @js.native
  trait AcceptTransitGatewayVpcAttachmentResult extends js.Object {
    var TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment]
  }

  object AcceptTransitGatewayVpcAttachmentResult {
    @inline
    def apply(
        TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment] = js.undefined
    ): AcceptTransitGatewayVpcAttachmentResult = {
      val __obj = js.Dynamic.literal()
      TransitGatewayVpcAttachment.foreach(
        __v => __obj.updateDynamic("TransitGatewayVpcAttachment")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[AcceptTransitGatewayVpcAttachmentResult]
    }
  }

  @js.native
  trait AcceptVpcEndpointConnectionsRequest extends js.Object {
    var ServiceId: String
    var VpcEndpointIds: ValueStringList
    var DryRun: js.UndefOr[Boolean]
  }

  object AcceptVpcEndpointConnectionsRequest {
    @inline
    def apply(
        ServiceId: String,
        VpcEndpointIds: ValueStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AcceptVpcEndpointConnectionsRequest = {
      val __obj = js.Dynamic.literal(
        "ServiceId"      -> ServiceId.asInstanceOf[js.Any],
        "VpcEndpointIds" -> VpcEndpointIds.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AcceptVpcEndpointConnectionsRequest]
    }
  }

  @js.native
  trait AcceptVpcEndpointConnectionsResult extends js.Object {
    var Unsuccessful: js.UndefOr[UnsuccessfulItemSet]
  }

  object AcceptVpcEndpointConnectionsResult {
    @inline
    def apply(
        Unsuccessful: js.UndefOr[UnsuccessfulItemSet] = js.undefined
    ): AcceptVpcEndpointConnectionsResult = {
      val __obj = js.Dynamic.literal()
      Unsuccessful.foreach(__v => __obj.updateDynamic("Unsuccessful")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AcceptVpcEndpointConnectionsResult]
    }
  }

  @js.native
  trait AcceptVpcPeeringConnectionRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var VpcPeeringConnectionId: js.UndefOr[String]
  }

  object AcceptVpcPeeringConnectionRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        VpcPeeringConnectionId: js.UndefOr[String] = js.undefined
    ): AcceptVpcPeeringConnectionRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      VpcPeeringConnectionId.foreach(__v => __obj.updateDynamic("VpcPeeringConnectionId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AcceptVpcPeeringConnectionRequest]
    }
  }

  @js.native
  trait AcceptVpcPeeringConnectionResult extends js.Object {
    var VpcPeeringConnection: js.UndefOr[VpcPeeringConnection]
  }

  object AcceptVpcPeeringConnectionResult {
    @inline
    def apply(
        VpcPeeringConnection: js.UndefOr[VpcPeeringConnection] = js.undefined
    ): AcceptVpcPeeringConnectionResult = {
      val __obj = js.Dynamic.literal()
      VpcPeeringConnection.foreach(__v => __obj.updateDynamic("VpcPeeringConnection")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AcceptVpcPeeringConnectionResult]
    }
  }

  /**
    * Describes an account attribute.
    */
  @js.native
  trait AccountAttribute extends js.Object {
    var AttributeName: js.UndefOr[String]
    var AttributeValues: js.UndefOr[AccountAttributeValueList]
  }

  object AccountAttribute {
    @inline
    def apply(
        AttributeName: js.UndefOr[String] = js.undefined,
        AttributeValues: js.UndefOr[AccountAttributeValueList] = js.undefined
    ): AccountAttribute = {
      val __obj = js.Dynamic.literal()
      AttributeName.foreach(__v => __obj.updateDynamic("AttributeName")(__v.asInstanceOf[js.Any]))
      AttributeValues.foreach(__v => __obj.updateDynamic("AttributeValues")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AccountAttribute]
    }
  }

  object AccountAttributeNameEnum {
    val `supported-platforms` = "supported-platforms"
    val `default-vpc`         = "default-vpc"

    val values = js.Object.freeze(js.Array(`supported-platforms`, `default-vpc`))
  }

  /**
    * Describes a value of an account attribute.
    */
  @js.native
  trait AccountAttributeValue extends js.Object {
    var AttributeValue: js.UndefOr[String]
  }

  object AccountAttributeValue {
    @inline
    def apply(
        AttributeValue: js.UndefOr[String] = js.undefined
    ): AccountAttributeValue = {
      val __obj = js.Dynamic.literal()
      AttributeValue.foreach(__v => __obj.updateDynamic("AttributeValue")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AccountAttributeValue]
    }
  }

  /**
    * Describes a running instance in a Spot Fleet.
    */
  @js.native
  trait ActiveInstance extends js.Object {
    var InstanceHealth: js.UndefOr[InstanceHealthStatus]
    var InstanceId: js.UndefOr[String]
    var InstanceType: js.UndefOr[String]
    var SpotInstanceRequestId: js.UndefOr[String]
  }

  object ActiveInstance {
    @inline
    def apply(
        InstanceHealth: js.UndefOr[InstanceHealthStatus] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[String] = js.undefined,
        SpotInstanceRequestId: js.UndefOr[String] = js.undefined
    ): ActiveInstance = {
      val __obj = js.Dynamic.literal()
      InstanceHealth.foreach(__v => __obj.updateDynamic("InstanceHealth")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      SpotInstanceRequestId.foreach(__v => __obj.updateDynamic("SpotInstanceRequestId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ActiveInstance]
    }
  }

  object ActivityStatusEnum {
    val error               = "error"
    val pending_fulfillment = "pending_fulfillment"
    val pending_termination = "pending_termination"
    val fulfilled           = "fulfilled"

    val values = js.Object.freeze(js.Array(error, pending_fulfillment, pending_termination, fulfilled))
  }

  /**
    * Describes an Elastic IP address.
    */
  @js.native
  trait Address extends js.Object {
    var AllocationId: js.UndefOr[String]
    var AssociationId: js.UndefOr[String]
    var Domain: js.UndefOr[DomainType]
    var InstanceId: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var NetworkInterfaceOwnerId: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PublicIp: js.UndefOr[String]
    var PublicIpv4Pool: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
  }

  object Address {
    @inline
    def apply(
        AllocationId: js.UndefOr[String] = js.undefined,
        AssociationId: js.UndefOr[String] = js.undefined,
        Domain: js.UndefOr[DomainType] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        NetworkInterfaceOwnerId: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined,
        PublicIpv4Pool: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): Address = {
      val __obj = js.Dynamic.literal()
      AllocationId.foreach(__v => __obj.updateDynamic("AllocationId")(__v.asInstanceOf[js.Any]))
      AssociationId.foreach(__v => __obj.updateDynamic("AssociationId")(__v.asInstanceOf[js.Any]))
      Domain.foreach(__v => __obj.updateDynamic("Domain")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceOwnerId.foreach(__v => __obj.updateDynamic("NetworkInterfaceOwnerId")(__v.asInstanceOf[js.Any]))
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      PublicIp.foreach(__v => __obj.updateDynamic("PublicIp")(__v.asInstanceOf[js.Any]))
      PublicIpv4Pool.foreach(__v => __obj.updateDynamic("PublicIpv4Pool")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[Address]
    }
  }

  @js.native
  trait AdvertiseByoipCidrRequest extends js.Object {
    var Cidr: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AdvertiseByoipCidrRequest {
    @inline
    def apply(
        Cidr: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AdvertiseByoipCidrRequest = {
      val __obj = js.Dynamic.literal(
        "Cidr" -> Cidr.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AdvertiseByoipCidrRequest]
    }
  }

  @js.native
  trait AdvertiseByoipCidrResult extends js.Object {
    var ByoipCidr: js.UndefOr[ByoipCidr]
  }

  object AdvertiseByoipCidrResult {
    @inline
    def apply(
        ByoipCidr: js.UndefOr[ByoipCidr] = js.undefined
    ): AdvertiseByoipCidrResult = {
      val __obj = js.Dynamic.literal()
      ByoipCidr.foreach(__v => __obj.updateDynamic("ByoipCidr")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AdvertiseByoipCidrResult]
    }
  }

  object AffinityEnum {
    val default = "default"
    val host    = "host"

    val values = js.Object.freeze(js.Array(default, host))
  }

  @js.native
  trait AllocateAddressRequest extends js.Object {
    var Address: js.UndefOr[String]
    var Domain: js.UndefOr[DomainType]
    var DryRun: js.UndefOr[Boolean]
    var PublicIpv4Pool: js.UndefOr[String]
  }

  object AllocateAddressRequest {
    @inline
    def apply(
        Address: js.UndefOr[String] = js.undefined,
        Domain: js.UndefOr[DomainType] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PublicIpv4Pool: js.UndefOr[String] = js.undefined
    ): AllocateAddressRequest = {
      val __obj = js.Dynamic.literal()
      Address.foreach(__v => __obj.updateDynamic("Address")(__v.asInstanceOf[js.Any]))
      Domain.foreach(__v => __obj.updateDynamic("Domain")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      PublicIpv4Pool.foreach(__v => __obj.updateDynamic("PublicIpv4Pool")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AllocateAddressRequest]
    }
  }

  @js.native
  trait AllocateAddressResult extends js.Object {
    var AllocationId: js.UndefOr[String]
    var Domain: js.UndefOr[DomainType]
    var PublicIp: js.UndefOr[String]
    var PublicIpv4Pool: js.UndefOr[String]
  }

  object AllocateAddressResult {
    @inline
    def apply(
        AllocationId: js.UndefOr[String] = js.undefined,
        Domain: js.UndefOr[DomainType] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined,
        PublicIpv4Pool: js.UndefOr[String] = js.undefined
    ): AllocateAddressResult = {
      val __obj = js.Dynamic.literal()
      AllocationId.foreach(__v => __obj.updateDynamic("AllocationId")(__v.asInstanceOf[js.Any]))
      Domain.foreach(__v => __obj.updateDynamic("Domain")(__v.asInstanceOf[js.Any]))
      PublicIp.foreach(__v => __obj.updateDynamic("PublicIp")(__v.asInstanceOf[js.Any]))
      PublicIpv4Pool.foreach(__v => __obj.updateDynamic("PublicIpv4Pool")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AllocateAddressResult]
    }
  }

  @js.native
  trait AllocateHostsRequest extends js.Object {
    var AvailabilityZone: String
    var InstanceType: String
    var Quantity: Int
    var AutoPlacement: js.UndefOr[AutoPlacement]
    var ClientToken: js.UndefOr[String]
    var HostRecovery: js.UndefOr[HostRecovery]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object AllocateHostsRequest {
    @inline
    def apply(
        AvailabilityZone: String,
        InstanceType: String,
        Quantity: Int,
        AutoPlacement: js.UndefOr[AutoPlacement] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        HostRecovery: js.UndefOr[HostRecovery] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): AllocateHostsRequest = {
      val __obj = js.Dynamic.literal(
        "AvailabilityZone" -> AvailabilityZone.asInstanceOf[js.Any],
        "InstanceType"     -> InstanceType.asInstanceOf[js.Any],
        "Quantity"         -> Quantity.asInstanceOf[js.Any]
      )

      AutoPlacement.foreach(__v => __obj.updateDynamic("AutoPlacement")(__v.asInstanceOf[js.Any]))
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      HostRecovery.foreach(__v => __obj.updateDynamic("HostRecovery")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AllocateHostsRequest]
    }
  }

  /**
    * Contains the output of AllocateHosts.
    */
  @js.native
  trait AllocateHostsResult extends js.Object {
    var HostIds: js.UndefOr[ResponseHostIdList]
  }

  object AllocateHostsResult {
    @inline
    def apply(
        HostIds: js.UndefOr[ResponseHostIdList] = js.undefined
    ): AllocateHostsResult = {
      val __obj = js.Dynamic.literal()
      HostIds.foreach(__v => __obj.updateDynamic("HostIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AllocateHostsResult]
    }
  }

  object AllocationStateEnum {
    val available                    = "available"
    val `under-assessment`           = "under-assessment"
    val `permanent-failure`          = "permanent-failure"
    val released                     = "released"
    val `released-permanent-failure` = "released-permanent-failure"
    val pending                      = "pending"

    val values = js.Object.freeze(
      js.Array(available, `under-assessment`, `permanent-failure`, released, `released-permanent-failure`, pending)
    )
  }

  object AllocationStrategyEnum {
    val lowestPrice       = "lowestPrice"
    val diversified       = "diversified"
    val capacityOptimized = "capacityOptimized"

    val values = js.Object.freeze(js.Array(lowestPrice, diversified, capacityOptimized))
  }

  /**
    * Describes a principal.
    */
  @js.native
  trait AllowedPrincipal extends js.Object {
    var Principal: js.UndefOr[String]
    var PrincipalType: js.UndefOr[PrincipalType]
  }

  object AllowedPrincipal {
    @inline
    def apply(
        Principal: js.UndefOr[String] = js.undefined,
        PrincipalType: js.UndefOr[PrincipalType] = js.undefined
    ): AllowedPrincipal = {
      val __obj = js.Dynamic.literal()
      Principal.foreach(__v => __obj.updateDynamic("Principal")(__v.asInstanceOf[js.Any]))
      PrincipalType.foreach(__v => __obj.updateDynamic("PrincipalType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AllowedPrincipal]
    }
  }

  @js.native
  trait ApplySecurityGroupsToClientVpnTargetNetworkRequest extends js.Object {
    var ClientVpnEndpointId: String
    var SecurityGroupIds: ClientVpnSecurityGroupIdSet
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ApplySecurityGroupsToClientVpnTargetNetworkRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        SecurityGroupIds: ClientVpnSecurityGroupIdSet,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ApplySecurityGroupsToClientVpnTargetNetworkRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "SecurityGroupIds"    -> SecurityGroupIds.asInstanceOf[js.Any],
        "VpcId"               -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ApplySecurityGroupsToClientVpnTargetNetworkRequest]
    }
  }

  @js.native
  trait ApplySecurityGroupsToClientVpnTargetNetworkResult extends js.Object {
    var SecurityGroupIds: js.UndefOr[ClientVpnSecurityGroupIdSet]
  }

  object ApplySecurityGroupsToClientVpnTargetNetworkResult {
    @inline
    def apply(
        SecurityGroupIds: js.UndefOr[ClientVpnSecurityGroupIdSet] = js.undefined
    ): ApplySecurityGroupsToClientVpnTargetNetworkResult = {
      val __obj = js.Dynamic.literal()
      SecurityGroupIds.foreach(__v => __obj.updateDynamic("SecurityGroupIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ApplySecurityGroupsToClientVpnTargetNetworkResult]
    }
  }

  object ArchitectureValuesEnum {
    val i386   = "i386"
    val x86_64 = "x86_64"
    val arm64  = "arm64"

    val values = js.Object.freeze(js.Array(i386, x86_64, arm64))
  }

  @js.native
  trait AssignIpv6AddressesRequest extends js.Object {
    var NetworkInterfaceId: String
    var Ipv6AddressCount: js.UndefOr[Int]
    var Ipv6Addresses: js.UndefOr[Ipv6AddressList]
  }

  object AssignIpv6AddressesRequest {
    @inline
    def apply(
        NetworkInterfaceId: String,
        Ipv6AddressCount: js.UndefOr[Int] = js.undefined,
        Ipv6Addresses: js.UndefOr[Ipv6AddressList] = js.undefined
    ): AssignIpv6AddressesRequest = {
      val __obj = js.Dynamic.literal(
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any]
      )

      Ipv6AddressCount.foreach(__v => __obj.updateDynamic("Ipv6AddressCount")(__v.asInstanceOf[js.Any]))
      Ipv6Addresses.foreach(__v => __obj.updateDynamic("Ipv6Addresses")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssignIpv6AddressesRequest]
    }
  }

  @js.native
  trait AssignIpv6AddressesResult extends js.Object {
    var AssignedIpv6Addresses: js.UndefOr[Ipv6AddressList]
    var NetworkInterfaceId: js.UndefOr[String]
  }

  object AssignIpv6AddressesResult {
    @inline
    def apply(
        AssignedIpv6Addresses: js.UndefOr[Ipv6AddressList] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined
    ): AssignIpv6AddressesResult = {
      val __obj = js.Dynamic.literal()
      AssignedIpv6Addresses.foreach(__v => __obj.updateDynamic("AssignedIpv6Addresses")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssignIpv6AddressesResult]
    }
  }

  /**
    * Contains the parameters for AssignPrivateIpAddresses.
    */
  @js.native
  trait AssignPrivateIpAddressesRequest extends js.Object {
    var NetworkInterfaceId: String
    var AllowReassignment: js.UndefOr[Boolean]
    var PrivateIpAddresses: js.UndefOr[PrivateIpAddressStringList]
    var SecondaryPrivateIpAddressCount: js.UndefOr[Int]
  }

  object AssignPrivateIpAddressesRequest {
    @inline
    def apply(
        NetworkInterfaceId: String,
        AllowReassignment: js.UndefOr[Boolean] = js.undefined,
        PrivateIpAddresses: js.UndefOr[PrivateIpAddressStringList] = js.undefined,
        SecondaryPrivateIpAddressCount: js.UndefOr[Int] = js.undefined
    ): AssignPrivateIpAddressesRequest = {
      val __obj = js.Dynamic.literal(
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any]
      )

      AllowReassignment.foreach(__v => __obj.updateDynamic("AllowReassignment")(__v.asInstanceOf[js.Any]))
      PrivateIpAddresses.foreach(__v => __obj.updateDynamic("PrivateIpAddresses")(__v.asInstanceOf[js.Any]))
      SecondaryPrivateIpAddressCount.foreach(
        __v => __obj.updateDynamic("SecondaryPrivateIpAddressCount")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[AssignPrivateIpAddressesRequest]
    }
  }

  @js.native
  trait AssignPrivateIpAddressesResult extends js.Object {
    var AssignedPrivateIpAddresses: js.UndefOr[AssignedPrivateIpAddressList]
    var NetworkInterfaceId: js.UndefOr[String]
  }

  object AssignPrivateIpAddressesResult {
    @inline
    def apply(
        AssignedPrivateIpAddresses: js.UndefOr[AssignedPrivateIpAddressList] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined
    ): AssignPrivateIpAddressesResult = {
      val __obj = js.Dynamic.literal()
      AssignedPrivateIpAddresses.foreach(
        __v => __obj.updateDynamic("AssignedPrivateIpAddresses")(__v.asInstanceOf[js.Any])
      )
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssignPrivateIpAddressesResult]
    }
  }

  /**
    * Describes the private IP addresses assigned to a network interface.
    */
  @js.native
  trait AssignedPrivateIpAddress extends js.Object {
    var PrivateIpAddress: js.UndefOr[String]
  }

  object AssignedPrivateIpAddress {
    @inline
    def apply(
        PrivateIpAddress: js.UndefOr[String] = js.undefined
    ): AssignedPrivateIpAddress = {
      val __obj = js.Dynamic.literal()
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssignedPrivateIpAddress]
    }
  }

  @js.native
  trait AssociateAddressRequest extends js.Object {
    var AllocationId: js.UndefOr[String]
    var AllowReassociation: js.UndefOr[Boolean]
    var DryRun: js.UndefOr[Boolean]
    var InstanceId: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PublicIp: js.UndefOr[String]
  }

  object AssociateAddressRequest {
    @inline
    def apply(
        AllocationId: js.UndefOr[String] = js.undefined,
        AllowReassociation: js.UndefOr[Boolean] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): AssociateAddressRequest = {
      val __obj = js.Dynamic.literal()
      AllocationId.foreach(__v => __obj.updateDynamic("AllocationId")(__v.asInstanceOf[js.Any]))
      AllowReassociation.foreach(__v => __obj.updateDynamic("AllowReassociation")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      PublicIp.foreach(__v => __obj.updateDynamic("PublicIp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociateAddressRequest]
    }
  }

  @js.native
  trait AssociateAddressResult extends js.Object {
    var AssociationId: js.UndefOr[String]
  }

  object AssociateAddressResult {
    @inline
    def apply(
        AssociationId: js.UndefOr[String] = js.undefined
    ): AssociateAddressResult = {
      val __obj = js.Dynamic.literal()
      AssociationId.foreach(__v => __obj.updateDynamic("AssociationId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociateAddressResult]
    }
  }

  @js.native
  trait AssociateClientVpnTargetNetworkRequest extends js.Object {
    var ClientVpnEndpointId: String
    var SubnetId: String
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object AssociateClientVpnTargetNetworkRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        SubnetId: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AssociateClientVpnTargetNetworkRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "SubnetId"            -> SubnetId.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociateClientVpnTargetNetworkRequest]
    }
  }

  @js.native
  trait AssociateClientVpnTargetNetworkResult extends js.Object {
    var AssociationId: js.UndefOr[String]
    var Status: js.UndefOr[AssociationStatus]
  }

  object AssociateClientVpnTargetNetworkResult {
    @inline
    def apply(
        AssociationId: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[AssociationStatus] = js.undefined
    ): AssociateClientVpnTargetNetworkResult = {
      val __obj = js.Dynamic.literal()
      AssociationId.foreach(__v => __obj.updateDynamic("AssociationId")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociateClientVpnTargetNetworkResult]
    }
  }

  @js.native
  trait AssociateDhcpOptionsRequest extends js.Object {
    var DhcpOptionsId: String
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AssociateDhcpOptionsRequest {
    @inline
    def apply(
        DhcpOptionsId: String,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AssociateDhcpOptionsRequest = {
      val __obj = js.Dynamic.literal(
        "DhcpOptionsId" -> DhcpOptionsId.asInstanceOf[js.Any],
        "VpcId"         -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociateDhcpOptionsRequest]
    }
  }

  @js.native
  trait AssociateIamInstanceProfileRequest extends js.Object {
    var IamInstanceProfile: IamInstanceProfileSpecification
    var InstanceId: String
  }

  object AssociateIamInstanceProfileRequest {
    @inline
    def apply(
        IamInstanceProfile: IamInstanceProfileSpecification,
        InstanceId: String
    ): AssociateIamInstanceProfileRequest = {
      val __obj = js.Dynamic.literal(
        "IamInstanceProfile" -> IamInstanceProfile.asInstanceOf[js.Any],
        "InstanceId"         -> InstanceId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[AssociateIamInstanceProfileRequest]
    }
  }

  @js.native
  trait AssociateIamInstanceProfileResult extends js.Object {
    var IamInstanceProfileAssociation: js.UndefOr[IamInstanceProfileAssociation]
  }

  object AssociateIamInstanceProfileResult {
    @inline
    def apply(
        IamInstanceProfileAssociation: js.UndefOr[IamInstanceProfileAssociation] = js.undefined
    ): AssociateIamInstanceProfileResult = {
      val __obj = js.Dynamic.literal()
      IamInstanceProfileAssociation.foreach(
        __v => __obj.updateDynamic("IamInstanceProfileAssociation")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[AssociateIamInstanceProfileResult]
    }
  }

  @js.native
  trait AssociateRouteTableRequest extends js.Object {
    var RouteTableId: String
    var SubnetId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AssociateRouteTableRequest {
    @inline
    def apply(
        RouteTableId: String,
        SubnetId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AssociateRouteTableRequest = {
      val __obj = js.Dynamic.literal(
        "RouteTableId" -> RouteTableId.asInstanceOf[js.Any],
        "SubnetId"     -> SubnetId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociateRouteTableRequest]
    }
  }

  @js.native
  trait AssociateRouteTableResult extends js.Object {
    var AssociationId: js.UndefOr[String]
  }

  object AssociateRouteTableResult {
    @inline
    def apply(
        AssociationId: js.UndefOr[String] = js.undefined
    ): AssociateRouteTableResult = {
      val __obj = js.Dynamic.literal()
      AssociationId.foreach(__v => __obj.updateDynamic("AssociationId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociateRouteTableResult]
    }
  }

  @js.native
  trait AssociateSubnetCidrBlockRequest extends js.Object {
    var Ipv6CidrBlock: String
    var SubnetId: String
  }

  object AssociateSubnetCidrBlockRequest {
    @inline
    def apply(
        Ipv6CidrBlock: String,
        SubnetId: String
    ): AssociateSubnetCidrBlockRequest = {
      val __obj = js.Dynamic.literal(
        "Ipv6CidrBlock" -> Ipv6CidrBlock.asInstanceOf[js.Any],
        "SubnetId"      -> SubnetId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[AssociateSubnetCidrBlockRequest]
    }
  }

  @js.native
  trait AssociateSubnetCidrBlockResult extends js.Object {
    var Ipv6CidrBlockAssociation: js.UndefOr[SubnetIpv6CidrBlockAssociation]
    var SubnetId: js.UndefOr[String]
  }

  object AssociateSubnetCidrBlockResult {
    @inline
    def apply(
        Ipv6CidrBlockAssociation: js.UndefOr[SubnetIpv6CidrBlockAssociation] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined
    ): AssociateSubnetCidrBlockResult = {
      val __obj = js.Dynamic.literal()
      Ipv6CidrBlockAssociation.foreach(__v => __obj.updateDynamic("Ipv6CidrBlockAssociation")(__v.asInstanceOf[js.Any]))
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociateSubnetCidrBlockResult]
    }
  }

  @js.native
  trait AssociateTransitGatewayRouteTableRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AssociateTransitGatewayRouteTableRequest {
    @inline
    def apply(
        TransitGatewayAttachmentId: String,
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AssociateTransitGatewayRouteTableRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociateTransitGatewayRouteTableRequest]
    }
  }

  @js.native
  trait AssociateTransitGatewayRouteTableResult extends js.Object {
    var Association: js.UndefOr[TransitGatewayAssociation]
  }

  object AssociateTransitGatewayRouteTableResult {
    @inline
    def apply(
        Association: js.UndefOr[TransitGatewayAssociation] = js.undefined
    ): AssociateTransitGatewayRouteTableResult = {
      val __obj = js.Dynamic.literal()
      Association.foreach(__v => __obj.updateDynamic("Association")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociateTransitGatewayRouteTableResult]
    }
  }

  @js.native
  trait AssociateVpcCidrBlockRequest extends js.Object {
    var VpcId: String
    var AmazonProvidedIpv6CidrBlock: js.UndefOr[Boolean]
    var CidrBlock: js.UndefOr[String]
  }

  object AssociateVpcCidrBlockRequest {
    @inline
    def apply(
        VpcId: String,
        AmazonProvidedIpv6CidrBlock: js.UndefOr[Boolean] = js.undefined,
        CidrBlock: js.UndefOr[String] = js.undefined
    ): AssociateVpcCidrBlockRequest = {
      val __obj = js.Dynamic.literal(
        "VpcId" -> VpcId.asInstanceOf[js.Any]
      )

      AmazonProvidedIpv6CidrBlock.foreach(
        __v => __obj.updateDynamic("AmazonProvidedIpv6CidrBlock")(__v.asInstanceOf[js.Any])
      )
      CidrBlock.foreach(__v => __obj.updateDynamic("CidrBlock")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociateVpcCidrBlockRequest]
    }
  }

  @js.native
  trait AssociateVpcCidrBlockResult extends js.Object {
    var CidrBlockAssociation: js.UndefOr[VpcCidrBlockAssociation]
    var Ipv6CidrBlockAssociation: js.UndefOr[VpcIpv6CidrBlockAssociation]
    var VpcId: js.UndefOr[String]
  }

  object AssociateVpcCidrBlockResult {
    @inline
    def apply(
        CidrBlockAssociation: js.UndefOr[VpcCidrBlockAssociation] = js.undefined,
        Ipv6CidrBlockAssociation: js.UndefOr[VpcIpv6CidrBlockAssociation] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): AssociateVpcCidrBlockResult = {
      val __obj = js.Dynamic.literal()
      CidrBlockAssociation.foreach(__v => __obj.updateDynamic("CidrBlockAssociation")(__v.asInstanceOf[js.Any]))
      Ipv6CidrBlockAssociation.foreach(__v => __obj.updateDynamic("Ipv6CidrBlockAssociation")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociateVpcCidrBlockResult]
    }
  }

  object AssociatedNetworkTypeEnum {
    val vpc = "vpc"

    val values = js.Object.freeze(js.Array(vpc))
  }

  /**
    * Describes a target network that is associated with a Client VPN endpoint. A target network is a subnet in a VPC.
    */
  @js.native
  trait AssociatedTargetNetwork extends js.Object {
    var NetworkId: js.UndefOr[String]
    var NetworkType: js.UndefOr[AssociatedNetworkType]
  }

  object AssociatedTargetNetwork {
    @inline
    def apply(
        NetworkId: js.UndefOr[String] = js.undefined,
        NetworkType: js.UndefOr[AssociatedNetworkType] = js.undefined
    ): AssociatedTargetNetwork = {
      val __obj = js.Dynamic.literal()
      NetworkId.foreach(__v => __obj.updateDynamic("NetworkId")(__v.asInstanceOf[js.Any]))
      NetworkType.foreach(__v => __obj.updateDynamic("NetworkType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociatedTargetNetwork]
    }
  }

  /**
    * Describes the state of a target network association.
    */
  @js.native
  trait AssociationStatus extends js.Object {
    var Code: js.UndefOr[AssociationStatusCode]
    var Message: js.UndefOr[String]
  }

  object AssociationStatus {
    @inline
    def apply(
        Code: js.UndefOr[AssociationStatusCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): AssociationStatus = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Message.foreach(__v => __obj.updateDynamic("Message")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AssociationStatus]
    }
  }

  object AssociationStatusCodeEnum {
    val associating          = "associating"
    val associated           = "associated"
    val `association-failed` = "association-failed"
    val disassociating       = "disassociating"
    val disassociated        = "disassociated"

    val values =
      js.Object.freeze(js.Array(associating, associated, `association-failed`, disassociating, disassociated))
  }

  @js.native
  trait AttachClassicLinkVpcRequest extends js.Object {
    var Groups: GroupIdStringList
    var InstanceId: String
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AttachClassicLinkVpcRequest {
    @inline
    def apply(
        Groups: GroupIdStringList,
        InstanceId: String,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AttachClassicLinkVpcRequest = {
      val __obj = js.Dynamic.literal(
        "Groups"     -> Groups.asInstanceOf[js.Any],
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "VpcId"      -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AttachClassicLinkVpcRequest]
    }
  }

  @js.native
  trait AttachClassicLinkVpcResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object AttachClassicLinkVpcResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): AttachClassicLinkVpcResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AttachClassicLinkVpcResult]
    }
  }

  @js.native
  trait AttachInternetGatewayRequest extends js.Object {
    var InternetGatewayId: String
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AttachInternetGatewayRequest {
    @inline
    def apply(
        InternetGatewayId: String,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AttachInternetGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "InternetGatewayId" -> InternetGatewayId.asInstanceOf[js.Any],
        "VpcId"             -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AttachInternetGatewayRequest]
    }
  }

  /**
    * Contains the parameters for AttachNetworkInterface.
    */
  @js.native
  trait AttachNetworkInterfaceRequest extends js.Object {
    var DeviceIndex: Int
    var InstanceId: String
    var NetworkInterfaceId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AttachNetworkInterfaceRequest {
    @inline
    def apply(
        DeviceIndex: Int,
        InstanceId: String,
        NetworkInterfaceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AttachNetworkInterfaceRequest = {
      val __obj = js.Dynamic.literal(
        "DeviceIndex"        -> DeviceIndex.asInstanceOf[js.Any],
        "InstanceId"         -> InstanceId.asInstanceOf[js.Any],
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AttachNetworkInterfaceRequest]
    }
  }

  /**
    * Contains the output of AttachNetworkInterface.
    */
  @js.native
  trait AttachNetworkInterfaceResult extends js.Object {
    var AttachmentId: js.UndefOr[String]
  }

  object AttachNetworkInterfaceResult {
    @inline
    def apply(
        AttachmentId: js.UndefOr[String] = js.undefined
    ): AttachNetworkInterfaceResult = {
      val __obj = js.Dynamic.literal()
      AttachmentId.foreach(__v => __obj.updateDynamic("AttachmentId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AttachNetworkInterfaceResult]
    }
  }

  /**
    * Contains the parameters for AttachVolume.
    */
  @js.native
  trait AttachVolumeRequest extends js.Object {
    var Device: String
    var InstanceId: String
    var VolumeId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AttachVolumeRequest {
    @inline
    def apply(
        Device: String,
        InstanceId: String,
        VolumeId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AttachVolumeRequest = {
      val __obj = js.Dynamic.literal(
        "Device"     -> Device.asInstanceOf[js.Any],
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "VolumeId"   -> VolumeId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AttachVolumeRequest]
    }
  }

  /**
    * Contains the parameters for AttachVpnGateway.
    */
  @js.native
  trait AttachVpnGatewayRequest extends js.Object {
    var VpcId: String
    var VpnGatewayId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object AttachVpnGatewayRequest {
    @inline
    def apply(
        VpcId: String,
        VpnGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AttachVpnGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "VpcId"        -> VpcId.asInstanceOf[js.Any],
        "VpnGatewayId" -> VpnGatewayId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AttachVpnGatewayRequest]
    }
  }

  /**
    * Contains the output of AttachVpnGateway.
    */
  @js.native
  trait AttachVpnGatewayResult extends js.Object {
    var VpcAttachment: js.UndefOr[VpcAttachment]
  }

  object AttachVpnGatewayResult {
    @inline
    def apply(
        VpcAttachment: js.UndefOr[VpcAttachment] = js.undefined
    ): AttachVpnGatewayResult = {
      val __obj = js.Dynamic.literal()
      VpcAttachment.foreach(__v => __obj.updateDynamic("VpcAttachment")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AttachVpnGatewayResult]
    }
  }

  object AttachmentStatusEnum {
    val attaching = "attaching"
    val attached  = "attached"
    val detaching = "detaching"
    val detached  = "detached"

    val values = js.Object.freeze(js.Array(attaching, attached, detaching, detached))
  }

  /**
    * Describes a value for a resource attribute that is a Boolean value.
    */
  @js.native
  trait AttributeBooleanValue extends js.Object {
    var Value: js.UndefOr[Boolean]
  }

  object AttributeBooleanValue {
    @inline
    def apply(
        Value: js.UndefOr[Boolean] = js.undefined
    ): AttributeBooleanValue = {
      val __obj = js.Dynamic.literal()
      Value.foreach(__v => __obj.updateDynamic("Value")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AttributeBooleanValue]
    }
  }

  /**
    * Describes a value for a resource attribute that is a String.
    */
  @js.native
  trait AttributeValue extends js.Object {
    var Value: js.UndefOr[String]
  }

  object AttributeValue {
    @inline
    def apply(
        Value: js.UndefOr[String] = js.undefined
    ): AttributeValue = {
      val __obj = js.Dynamic.literal()
      Value.foreach(__v => __obj.updateDynamic("Value")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AttributeValue]
    }
  }

  /**
    * Information about an authorization rule.
    */
  @js.native
  trait AuthorizationRule extends js.Object {
    var AccessAll: js.UndefOr[Boolean]
    var ClientVpnEndpointId: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DestinationCidr: js.UndefOr[String]
    var GroupId: js.UndefOr[String]
    var Status: js.UndefOr[ClientVpnAuthorizationRuleStatus]
  }

  object AuthorizationRule {
    @inline
    def apply(
        AccessAll: js.UndefOr[Boolean] = js.undefined,
        ClientVpnEndpointId: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DestinationCidr: js.UndefOr[String] = js.undefined,
        GroupId: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[ClientVpnAuthorizationRuleStatus] = js.undefined
    ): AuthorizationRule = {
      val __obj = js.Dynamic.literal()
      AccessAll.foreach(__v => __obj.updateDynamic("AccessAll")(__v.asInstanceOf[js.Any]))
      ClientVpnEndpointId.foreach(__v => __obj.updateDynamic("ClientVpnEndpointId")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DestinationCidr.foreach(__v => __obj.updateDynamic("DestinationCidr")(__v.asInstanceOf[js.Any]))
      GroupId.foreach(__v => __obj.updateDynamic("GroupId")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AuthorizationRule]
    }
  }

  @js.native
  trait AuthorizeClientVpnIngressRequest extends js.Object {
    var ClientVpnEndpointId: String
    var TargetNetworkCidr: String
    var AccessGroupId: js.UndefOr[String]
    var AuthorizeAllGroups: js.UndefOr[Boolean]
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object AuthorizeClientVpnIngressRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        TargetNetworkCidr: String,
        AccessGroupId: js.UndefOr[String] = js.undefined,
        AuthorizeAllGroups: js.UndefOr[Boolean] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): AuthorizeClientVpnIngressRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "TargetNetworkCidr"   -> TargetNetworkCidr.asInstanceOf[js.Any]
      )

      AccessGroupId.foreach(__v => __obj.updateDynamic("AccessGroupId")(__v.asInstanceOf[js.Any]))
      AuthorizeAllGroups.foreach(__v => __obj.updateDynamic("AuthorizeAllGroups")(__v.asInstanceOf[js.Any]))
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AuthorizeClientVpnIngressRequest]
    }
  }

  @js.native
  trait AuthorizeClientVpnIngressResult extends js.Object {
    var Status: js.UndefOr[ClientVpnAuthorizationRuleStatus]
  }

  object AuthorizeClientVpnIngressResult {
    @inline
    def apply(
        Status: js.UndefOr[ClientVpnAuthorizationRuleStatus] = js.undefined
    ): AuthorizeClientVpnIngressResult = {
      val __obj = js.Dynamic.literal()
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AuthorizeClientVpnIngressResult]
    }
  }

  @js.native
  trait AuthorizeSecurityGroupEgressRequest extends js.Object {
    var GroupId: String
    var CidrIp: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var FromPort: js.UndefOr[Int]
    var IpPermissions: js.UndefOr[IpPermissionList]
    var IpProtocol: js.UndefOr[String]
    var SourceSecurityGroupName: js.UndefOr[String]
    var SourceSecurityGroupOwnerId: js.UndefOr[String]
    var ToPort: js.UndefOr[Int]
  }

  object AuthorizeSecurityGroupEgressRequest {
    @inline
    def apply(
        GroupId: String,
        CidrIp: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        FromPort: js.UndefOr[Int] = js.undefined,
        IpPermissions: js.UndefOr[IpPermissionList] = js.undefined,
        IpProtocol: js.UndefOr[String] = js.undefined,
        SourceSecurityGroupName: js.UndefOr[String] = js.undefined,
        SourceSecurityGroupOwnerId: js.UndefOr[String] = js.undefined,
        ToPort: js.UndefOr[Int] = js.undefined
    ): AuthorizeSecurityGroupEgressRequest = {
      val __obj = js.Dynamic.literal(
        "GroupId" -> GroupId.asInstanceOf[js.Any]
      )

      CidrIp.foreach(__v => __obj.updateDynamic("CidrIp")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      FromPort.foreach(__v => __obj.updateDynamic("FromPort")(__v.asInstanceOf[js.Any]))
      IpPermissions.foreach(__v => __obj.updateDynamic("IpPermissions")(__v.asInstanceOf[js.Any]))
      IpProtocol.foreach(__v => __obj.updateDynamic("IpProtocol")(__v.asInstanceOf[js.Any]))
      SourceSecurityGroupName.foreach(__v => __obj.updateDynamic("SourceSecurityGroupName")(__v.asInstanceOf[js.Any]))
      SourceSecurityGroupOwnerId.foreach(
        __v => __obj.updateDynamic("SourceSecurityGroupOwnerId")(__v.asInstanceOf[js.Any])
      )
      ToPort.foreach(__v => __obj.updateDynamic("ToPort")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AuthorizeSecurityGroupEgressRequest]
    }
  }

  @js.native
  trait AuthorizeSecurityGroupIngressRequest extends js.Object {
    var CidrIp: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var FromPort: js.UndefOr[Int]
    var GroupId: js.UndefOr[String]
    var GroupName: js.UndefOr[String]
    var IpPermissions: js.UndefOr[IpPermissionList]
    var IpProtocol: js.UndefOr[String]
    var SourceSecurityGroupName: js.UndefOr[String]
    var SourceSecurityGroupOwnerId: js.UndefOr[String]
    var ToPort: js.UndefOr[Int]
  }

  object AuthorizeSecurityGroupIngressRequest {
    @inline
    def apply(
        CidrIp: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        FromPort: js.UndefOr[Int] = js.undefined,
        GroupId: js.UndefOr[String] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined,
        IpPermissions: js.UndefOr[IpPermissionList] = js.undefined,
        IpProtocol: js.UndefOr[String] = js.undefined,
        SourceSecurityGroupName: js.UndefOr[String] = js.undefined,
        SourceSecurityGroupOwnerId: js.UndefOr[String] = js.undefined,
        ToPort: js.UndefOr[Int] = js.undefined
    ): AuthorizeSecurityGroupIngressRequest = {
      val __obj = js.Dynamic.literal()
      CidrIp.foreach(__v => __obj.updateDynamic("CidrIp")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      FromPort.foreach(__v => __obj.updateDynamic("FromPort")(__v.asInstanceOf[js.Any]))
      GroupId.foreach(__v => __obj.updateDynamic("GroupId")(__v.asInstanceOf[js.Any]))
      GroupName.foreach(__v => __obj.updateDynamic("GroupName")(__v.asInstanceOf[js.Any]))
      IpPermissions.foreach(__v => __obj.updateDynamic("IpPermissions")(__v.asInstanceOf[js.Any]))
      IpProtocol.foreach(__v => __obj.updateDynamic("IpProtocol")(__v.asInstanceOf[js.Any]))
      SourceSecurityGroupName.foreach(__v => __obj.updateDynamic("SourceSecurityGroupName")(__v.asInstanceOf[js.Any]))
      SourceSecurityGroupOwnerId.foreach(
        __v => __obj.updateDynamic("SourceSecurityGroupOwnerId")(__v.asInstanceOf[js.Any])
      )
      ToPort.foreach(__v => __obj.updateDynamic("ToPort")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AuthorizeSecurityGroupIngressRequest]
    }
  }

  object AutoAcceptSharedAttachmentsValueEnum {
    val enable  = "enable"
    val disable = "disable"

    val values = js.Object.freeze(js.Array(enable, disable))
  }

  object AutoPlacementEnum {
    val on  = "on"
    val off = "off"

    val values = js.Object.freeze(js.Array(on, off))
  }

  /**
    * Describes an Availability Zone.
    */
  @js.native
  trait AvailabilityZone extends js.Object {
    var Messages: js.UndefOr[AvailabilityZoneMessageList]
    var RegionName: js.UndefOr[String]
    var State: js.UndefOr[AvailabilityZoneState]
    var ZoneId: js.UndefOr[String]
    var ZoneName: js.UndefOr[String]
  }

  object AvailabilityZone {
    @inline
    def apply(
        Messages: js.UndefOr[AvailabilityZoneMessageList] = js.undefined,
        RegionName: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[AvailabilityZoneState] = js.undefined,
        ZoneId: js.UndefOr[String] = js.undefined,
        ZoneName: js.UndefOr[String] = js.undefined
    ): AvailabilityZone = {
      val __obj = js.Dynamic.literal()
      Messages.foreach(__v => __obj.updateDynamic("Messages")(__v.asInstanceOf[js.Any]))
      RegionName.foreach(__v => __obj.updateDynamic("RegionName")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      ZoneId.foreach(__v => __obj.updateDynamic("ZoneId")(__v.asInstanceOf[js.Any]))
      ZoneName.foreach(__v => __obj.updateDynamic("ZoneName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AvailabilityZone]
    }
  }

  /**
    * Describes a message about an Availability Zone.
    */
  @js.native
  trait AvailabilityZoneMessage extends js.Object {
    var Message: js.UndefOr[String]
  }

  object AvailabilityZoneMessage {
    @inline
    def apply(
        Message: js.UndefOr[String] = js.undefined
    ): AvailabilityZoneMessage = {
      val __obj = js.Dynamic.literal()
      Message.foreach(__v => __obj.updateDynamic("Message")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AvailabilityZoneMessage]
    }
  }

  object AvailabilityZoneStateEnum {
    val available   = "available"
    val information = "information"
    val impaired    = "impaired"
    val unavailable = "unavailable"

    val values = js.Object.freeze(js.Array(available, information, impaired, unavailable))
  }

  /**
    * The capacity information for instances launched onto the Dedicated Host.
    */
  @js.native
  trait AvailableCapacity extends js.Object {
    var AvailableInstanceCapacity: js.UndefOr[AvailableInstanceCapacityList]
    var AvailableVCpus: js.UndefOr[Int]
  }

  object AvailableCapacity {
    @inline
    def apply(
        AvailableInstanceCapacity: js.UndefOr[AvailableInstanceCapacityList] = js.undefined,
        AvailableVCpus: js.UndefOr[Int] = js.undefined
    ): AvailableCapacity = {
      val __obj = js.Dynamic.literal()
      AvailableInstanceCapacity.foreach(
        __v => __obj.updateDynamic("AvailableInstanceCapacity")(__v.asInstanceOf[js.Any])
      )
      AvailableVCpus.foreach(__v => __obj.updateDynamic("AvailableVCpus")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[AvailableCapacity]
    }
  }

  object BatchStateEnum {
    val submitted             = "submitted"
    val active                = "active"
    val cancelled             = "cancelled"
    val failed                = "failed"
    val cancelled_running     = "cancelled_running"
    val cancelled_terminating = "cancelled_terminating"
    val modifying             = "modifying"

    val values = js.Object.freeze(
      js.Array(submitted, active, cancelled, failed, cancelled_running, cancelled_terminating, modifying)
    )
  }

  @js.native
  trait BlobAttributeValue extends js.Object {
    var Value: js.UndefOr[Blob]
  }

  object BlobAttributeValue {
    @inline
    def apply(
        Value: js.UndefOr[Blob] = js.undefined
    ): BlobAttributeValue = {
      val __obj = js.Dynamic.literal()
      Value.foreach(__v => __obj.updateDynamic("Value")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[BlobAttributeValue]
    }
  }

  /**
    * Describes a block device mapping.
    */
  @js.native
  trait BlockDeviceMapping extends js.Object {
    var DeviceName: js.UndefOr[String]
    var Ebs: js.UndefOr[EbsBlockDevice]
    var NoDevice: js.UndefOr[String]
    var VirtualName: js.UndefOr[String]
  }

  object BlockDeviceMapping {
    @inline
    def apply(
        DeviceName: js.UndefOr[String] = js.undefined,
        Ebs: js.UndefOr[EbsBlockDevice] = js.undefined,
        NoDevice: js.UndefOr[String] = js.undefined,
        VirtualName: js.UndefOr[String] = js.undefined
    ): BlockDeviceMapping = {
      val __obj = js.Dynamic.literal()
      DeviceName.foreach(__v => __obj.updateDynamic("DeviceName")(__v.asInstanceOf[js.Any]))
      Ebs.foreach(__v => __obj.updateDynamic("Ebs")(__v.asInstanceOf[js.Any]))
      NoDevice.foreach(__v => __obj.updateDynamic("NoDevice")(__v.asInstanceOf[js.Any]))
      VirtualName.foreach(__v => __obj.updateDynamic("VirtualName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[BlockDeviceMapping]
    }
  }

  /**
    * Contains the parameters for BundleInstance.
    */
  @js.native
  trait BundleInstanceRequest extends js.Object {
    var InstanceId: String
    var Storage: Storage
    var DryRun: js.UndefOr[Boolean]
  }

  object BundleInstanceRequest {
    @inline
    def apply(
        InstanceId: String,
        Storage: Storage,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): BundleInstanceRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "Storage"    -> Storage.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[BundleInstanceRequest]
    }
  }

  /**
    * Contains the output of BundleInstance.
    */
  @js.native
  trait BundleInstanceResult extends js.Object {
    var BundleTask: js.UndefOr[BundleTask]
  }

  object BundleInstanceResult {
    @inline
    def apply(
        BundleTask: js.UndefOr[BundleTask] = js.undefined
    ): BundleInstanceResult = {
      val __obj = js.Dynamic.literal()
      BundleTask.foreach(__v => __obj.updateDynamic("BundleTask")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[BundleInstanceResult]
    }
  }

  /**
    * Describes a bundle task.
    */
  @js.native
  trait BundleTask extends js.Object {
    var BundleId: js.UndefOr[String]
    var BundleTaskError: js.UndefOr[BundleTaskError]
    var InstanceId: js.UndefOr[String]
    var Progress: js.UndefOr[String]
    var StartTime: js.UndefOr[DateTime]
    var State: js.UndefOr[BundleTaskState]
    var Storage: js.UndefOr[Storage]
    var UpdateTime: js.UndefOr[DateTime]
  }

  object BundleTask {
    @inline
    def apply(
        BundleId: js.UndefOr[String] = js.undefined,
        BundleTaskError: js.UndefOr[BundleTaskError] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        Progress: js.UndefOr[String] = js.undefined,
        StartTime: js.UndefOr[DateTime] = js.undefined,
        State: js.UndefOr[BundleTaskState] = js.undefined,
        Storage: js.UndefOr[Storage] = js.undefined,
        UpdateTime: js.UndefOr[DateTime] = js.undefined
    ): BundleTask = {
      val __obj = js.Dynamic.literal()
      BundleId.foreach(__v => __obj.updateDynamic("BundleId")(__v.asInstanceOf[js.Any]))
      BundleTaskError.foreach(__v => __obj.updateDynamic("BundleTaskError")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      Progress.foreach(__v => __obj.updateDynamic("Progress")(__v.asInstanceOf[js.Any]))
      StartTime.foreach(__v => __obj.updateDynamic("StartTime")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      Storage.foreach(__v => __obj.updateDynamic("Storage")(__v.asInstanceOf[js.Any]))
      UpdateTime.foreach(__v => __obj.updateDynamic("UpdateTime")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[BundleTask]
    }
  }

  /**
    * Describes an error for <a>BundleInstance</a>.
    */
  @js.native
  trait BundleTaskError extends js.Object {
    var Code: js.UndefOr[String]
    var Message: js.UndefOr[String]
  }

  object BundleTaskError {
    @inline
    def apply(
        Code: js.UndefOr[String] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): BundleTaskError = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Message.foreach(__v => __obj.updateDynamic("Message")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[BundleTaskError]
    }
  }

  object BundleTaskStateEnum {
    val pending                = "pending"
    val `waiting-for-shutdown` = "waiting-for-shutdown"
    val bundling               = "bundling"
    val storing                = "storing"
    val cancelling             = "cancelling"
    val complete               = "complete"
    val failed                 = "failed"

    val values =
      js.Object.freeze(js.Array(pending, `waiting-for-shutdown`, bundling, storing, cancelling, complete, failed))
  }

  /**
    * Information about an address range that is provisioned for use with your AWS resources through bring your own IP addresses (BYOIP).
    */
  @js.native
  trait ByoipCidr extends js.Object {
    var Cidr: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var State: js.UndefOr[ByoipCidrState]
    var StatusMessage: js.UndefOr[String]
  }

  object ByoipCidr {
    @inline
    def apply(
        Cidr: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[ByoipCidrState] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined
    ): ByoipCidr = {
      val __obj = js.Dynamic.literal()
      Cidr.foreach(__v => __obj.updateDynamic("Cidr")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      StatusMessage.foreach(__v => __obj.updateDynamic("StatusMessage")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ByoipCidr]
    }
  }

  object ByoipCidrStateEnum {
    val advertised            = "advertised"
    val deprovisioned         = "deprovisioned"
    val `failed-deprovision`  = "failed-deprovision"
    val `failed-provision`    = "failed-provision"
    val `pending-deprovision` = "pending-deprovision"
    val `pending-provision`   = "pending-provision"
    val provisioned           = "provisioned"

    val values = js.Object.freeze(
      js.Array(
        advertised,
        deprovisioned,
        `failed-deprovision`,
        `failed-provision`,
        `pending-deprovision`,
        `pending-provision`,
        provisioned
      )
    )
  }

  object CancelBatchErrorCodeEnum {
    val fleetRequestIdDoesNotExist        = "fleetRequestIdDoesNotExist"
    val fleetRequestIdMalformed           = "fleetRequestIdMalformed"
    val fleetRequestNotInCancellableState = "fleetRequestNotInCancellableState"
    val unexpectedError                   = "unexpectedError"

    val values = js.Object.freeze(
      js.Array(fleetRequestIdDoesNotExist, fleetRequestIdMalformed, fleetRequestNotInCancellableState, unexpectedError)
    )
  }

  /**
    * Contains the parameters for CancelBundleTask.
    */
  @js.native
  trait CancelBundleTaskRequest extends js.Object {
    var BundleId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object CancelBundleTaskRequest {
    @inline
    def apply(
        BundleId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CancelBundleTaskRequest = {
      val __obj = js.Dynamic.literal(
        "BundleId" -> BundleId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelBundleTaskRequest]
    }
  }

  /**
    * Contains the output of CancelBundleTask.
    */
  @js.native
  trait CancelBundleTaskResult extends js.Object {
    var BundleTask: js.UndefOr[BundleTask]
  }

  object CancelBundleTaskResult {
    @inline
    def apply(
        BundleTask: js.UndefOr[BundleTask] = js.undefined
    ): CancelBundleTaskResult = {
      val __obj = js.Dynamic.literal()
      BundleTask.foreach(__v => __obj.updateDynamic("BundleTask")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelBundleTaskResult]
    }
  }

  @js.native
  trait CancelCapacityReservationRequest extends js.Object {
    var CapacityReservationId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object CancelCapacityReservationRequest {
    @inline
    def apply(
        CapacityReservationId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CancelCapacityReservationRequest = {
      val __obj = js.Dynamic.literal(
        "CapacityReservationId" -> CapacityReservationId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelCapacityReservationRequest]
    }
  }

  @js.native
  trait CancelCapacityReservationResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object CancelCapacityReservationResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): CancelCapacityReservationResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelCapacityReservationResult]
    }
  }

  @js.native
  trait CancelConversionRequest extends js.Object {
    var ConversionTaskId: String
    var DryRun: js.UndefOr[Boolean]
    var ReasonMessage: js.UndefOr[String]
  }

  object CancelConversionRequest {
    @inline
    def apply(
        ConversionTaskId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ReasonMessage: js.UndefOr[String] = js.undefined
    ): CancelConversionRequest = {
      val __obj = js.Dynamic.literal(
        "ConversionTaskId" -> ConversionTaskId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      ReasonMessage.foreach(__v => __obj.updateDynamic("ReasonMessage")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelConversionRequest]
    }
  }

  @js.native
  trait CancelExportTaskRequest extends js.Object {
    var ExportTaskId: String
  }

  object CancelExportTaskRequest {
    @inline
    def apply(
        ExportTaskId: String
    ): CancelExportTaskRequest = {
      val __obj = js.Dynamic.literal(
        "ExportTaskId" -> ExportTaskId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[CancelExportTaskRequest]
    }
  }

  @js.native
  trait CancelImportTaskRequest extends js.Object {
    var CancelReason: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var ImportTaskId: js.UndefOr[String]
  }

  object CancelImportTaskRequest {
    @inline
    def apply(
        CancelReason: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ImportTaskId: js.UndefOr[String] = js.undefined
    ): CancelImportTaskRequest = {
      val __obj = js.Dynamic.literal()
      CancelReason.foreach(__v => __obj.updateDynamic("CancelReason")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      ImportTaskId.foreach(__v => __obj.updateDynamic("ImportTaskId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelImportTaskRequest]
    }
  }

  @js.native
  trait CancelImportTaskResult extends js.Object {
    var ImportTaskId: js.UndefOr[String]
    var PreviousState: js.UndefOr[String]
    var State: js.UndefOr[String]
  }

  object CancelImportTaskResult {
    @inline
    def apply(
        ImportTaskId: js.UndefOr[String] = js.undefined,
        PreviousState: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[String] = js.undefined
    ): CancelImportTaskResult = {
      val __obj = js.Dynamic.literal()
      ImportTaskId.foreach(__v => __obj.updateDynamic("ImportTaskId")(__v.asInstanceOf[js.Any]))
      PreviousState.foreach(__v => __obj.updateDynamic("PreviousState")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelImportTaskResult]
    }
  }

  /**
    * Contains the parameters for CancelReservedInstancesListing.
    */
  @js.native
  trait CancelReservedInstancesListingRequest extends js.Object {
    var ReservedInstancesListingId: String
  }

  object CancelReservedInstancesListingRequest {
    @inline
    def apply(
        ReservedInstancesListingId: String
    ): CancelReservedInstancesListingRequest = {
      val __obj = js.Dynamic.literal(
        "ReservedInstancesListingId" -> ReservedInstancesListingId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[CancelReservedInstancesListingRequest]
    }
  }

  /**
    * Contains the output of CancelReservedInstancesListing.
    */
  @js.native
  trait CancelReservedInstancesListingResult extends js.Object {
    var ReservedInstancesListings: js.UndefOr[ReservedInstancesListingList]
  }

  object CancelReservedInstancesListingResult {
    @inline
    def apply(
        ReservedInstancesListings: js.UndefOr[ReservedInstancesListingList] = js.undefined
    ): CancelReservedInstancesListingResult = {
      val __obj = js.Dynamic.literal()
      ReservedInstancesListings.foreach(
        __v => __obj.updateDynamic("ReservedInstancesListings")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[CancelReservedInstancesListingResult]
    }
  }

  /**
    * Describes a Spot Fleet error.
    */
  @js.native
  trait CancelSpotFleetRequestsError extends js.Object {
    var Code: js.UndefOr[CancelBatchErrorCode]
    var Message: js.UndefOr[String]
  }

  object CancelSpotFleetRequestsError {
    @inline
    def apply(
        Code: js.UndefOr[CancelBatchErrorCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): CancelSpotFleetRequestsError = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Message.foreach(__v => __obj.updateDynamic("Message")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelSpotFleetRequestsError]
    }
  }

  /**
    * Describes a Spot Fleet request that was not successfully canceled.
    */
  @js.native
  trait CancelSpotFleetRequestsErrorItem extends js.Object {
    var Error: js.UndefOr[CancelSpotFleetRequestsError]
    var SpotFleetRequestId: js.UndefOr[String]
  }

  object CancelSpotFleetRequestsErrorItem {
    @inline
    def apply(
        Error: js.UndefOr[CancelSpotFleetRequestsError] = js.undefined,
        SpotFleetRequestId: js.UndefOr[String] = js.undefined
    ): CancelSpotFleetRequestsErrorItem = {
      val __obj = js.Dynamic.literal()
      Error.foreach(__v => __obj.updateDynamic("Error")(__v.asInstanceOf[js.Any]))
      SpotFleetRequestId.foreach(__v => __obj.updateDynamic("SpotFleetRequestId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelSpotFleetRequestsErrorItem]
    }
  }

  /**
    * Contains the parameters for CancelSpotFleetRequests.
    */
  @js.native
  trait CancelSpotFleetRequestsRequest extends js.Object {
    var SpotFleetRequestIds: ValueStringList
    var TerminateInstances: Boolean
    var DryRun: js.UndefOr[Boolean]
  }

  object CancelSpotFleetRequestsRequest {
    @inline
    def apply(
        SpotFleetRequestIds: ValueStringList,
        TerminateInstances: Boolean,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CancelSpotFleetRequestsRequest = {
      val __obj = js.Dynamic.literal(
        "SpotFleetRequestIds" -> SpotFleetRequestIds.asInstanceOf[js.Any],
        "TerminateInstances"  -> TerminateInstances.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelSpotFleetRequestsRequest]
    }
  }

  /**
    * Contains the output of CancelSpotFleetRequests.
    */
  @js.native
  trait CancelSpotFleetRequestsResponse extends js.Object {
    var SuccessfulFleetRequests: js.UndefOr[CancelSpotFleetRequestsSuccessSet]
    var UnsuccessfulFleetRequests: js.UndefOr[CancelSpotFleetRequestsErrorSet]
  }

  object CancelSpotFleetRequestsResponse {
    @inline
    def apply(
        SuccessfulFleetRequests: js.UndefOr[CancelSpotFleetRequestsSuccessSet] = js.undefined,
        UnsuccessfulFleetRequests: js.UndefOr[CancelSpotFleetRequestsErrorSet] = js.undefined
    ): CancelSpotFleetRequestsResponse = {
      val __obj = js.Dynamic.literal()
      SuccessfulFleetRequests.foreach(__v => __obj.updateDynamic("SuccessfulFleetRequests")(__v.asInstanceOf[js.Any]))
      UnsuccessfulFleetRequests.foreach(
        __v => __obj.updateDynamic("UnsuccessfulFleetRequests")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[CancelSpotFleetRequestsResponse]
    }
  }

  /**
    * Describes a Spot Fleet request that was successfully canceled.
    */
  @js.native
  trait CancelSpotFleetRequestsSuccessItem extends js.Object {
    var CurrentSpotFleetRequestState: js.UndefOr[BatchState]
    var PreviousSpotFleetRequestState: js.UndefOr[BatchState]
    var SpotFleetRequestId: js.UndefOr[String]
  }

  object CancelSpotFleetRequestsSuccessItem {
    @inline
    def apply(
        CurrentSpotFleetRequestState: js.UndefOr[BatchState] = js.undefined,
        PreviousSpotFleetRequestState: js.UndefOr[BatchState] = js.undefined,
        SpotFleetRequestId: js.UndefOr[String] = js.undefined
    ): CancelSpotFleetRequestsSuccessItem = {
      val __obj = js.Dynamic.literal()
      CurrentSpotFleetRequestState.foreach(
        __v => __obj.updateDynamic("CurrentSpotFleetRequestState")(__v.asInstanceOf[js.Any])
      )
      PreviousSpotFleetRequestState.foreach(
        __v => __obj.updateDynamic("PreviousSpotFleetRequestState")(__v.asInstanceOf[js.Any])
      )
      SpotFleetRequestId.foreach(__v => __obj.updateDynamic("SpotFleetRequestId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelSpotFleetRequestsSuccessItem]
    }
  }

  object CancelSpotInstanceRequestStateEnum {
    val active    = "active"
    val open      = "open"
    val closed    = "closed"
    val cancelled = "cancelled"
    val completed = "completed"

    val values = js.Object.freeze(js.Array(active, open, closed, cancelled, completed))
  }

  /**
    * Contains the parameters for CancelSpotInstanceRequests.
    */
  @js.native
  trait CancelSpotInstanceRequestsRequest extends js.Object {
    var SpotInstanceRequestIds: SpotInstanceRequestIdList
    var DryRun: js.UndefOr[Boolean]
  }

  object CancelSpotInstanceRequestsRequest {
    @inline
    def apply(
        SpotInstanceRequestIds: SpotInstanceRequestIdList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CancelSpotInstanceRequestsRequest = {
      val __obj = js.Dynamic.literal(
        "SpotInstanceRequestIds" -> SpotInstanceRequestIds.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelSpotInstanceRequestsRequest]
    }
  }

  /**
    * Contains the output of CancelSpotInstanceRequests.
    */
  @js.native
  trait CancelSpotInstanceRequestsResult extends js.Object {
    var CancelledSpotInstanceRequests: js.UndefOr[CancelledSpotInstanceRequestList]
  }

  object CancelSpotInstanceRequestsResult {
    @inline
    def apply(
        CancelledSpotInstanceRequests: js.UndefOr[CancelledSpotInstanceRequestList] = js.undefined
    ): CancelSpotInstanceRequestsResult = {
      val __obj = js.Dynamic.literal()
      CancelledSpotInstanceRequests.foreach(
        __v => __obj.updateDynamic("CancelledSpotInstanceRequests")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[CancelSpotInstanceRequestsResult]
    }
  }

  /**
    * Describes a request to cancel a Spot Instance.
    */
  @js.native
  trait CancelledSpotInstanceRequest extends js.Object {
    var SpotInstanceRequestId: js.UndefOr[String]
    var State: js.UndefOr[CancelSpotInstanceRequestState]
  }

  object CancelledSpotInstanceRequest {
    @inline
    def apply(
        SpotInstanceRequestId: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[CancelSpotInstanceRequestState] = js.undefined
    ): CancelledSpotInstanceRequest = {
      val __obj = js.Dynamic.literal()
      SpotInstanceRequestId.foreach(__v => __obj.updateDynamic("SpotInstanceRequestId")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CancelledSpotInstanceRequest]
    }
  }

  /**
    * Describes a Capacity Reservation.
    */
  @js.native
  trait CapacityReservation extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var AvailabilityZoneId: js.UndefOr[String]
    var AvailableInstanceCount: js.UndefOr[Int]
    var CapacityReservationArn: js.UndefOr[String]
    var CapacityReservationId: js.UndefOr[String]
    var CreateDate: js.UndefOr[DateTime]
    var EbsOptimized: js.UndefOr[Boolean]
    var EndDate: js.UndefOr[DateTime]
    var EndDateType: js.UndefOr[EndDateType]
    var EphemeralStorage: js.UndefOr[Boolean]
    var InstanceMatchCriteria: js.UndefOr[InstanceMatchCriteria]
    var InstancePlatform: js.UndefOr[CapacityReservationInstancePlatform]
    var InstanceType: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var State: js.UndefOr[CapacityReservationState]
    var Tags: js.UndefOr[TagList]
    var Tenancy: js.UndefOr[CapacityReservationTenancy]
    var TotalInstanceCount: js.UndefOr[Int]
  }

  object CapacityReservation {
    @inline
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        AvailabilityZoneId: js.UndefOr[String] = js.undefined,
        AvailableInstanceCount: js.UndefOr[Int] = js.undefined,
        CapacityReservationArn: js.UndefOr[String] = js.undefined,
        CapacityReservationId: js.UndefOr[String] = js.undefined,
        CreateDate: js.UndefOr[DateTime] = js.undefined,
        EbsOptimized: js.UndefOr[Boolean] = js.undefined,
        EndDate: js.UndefOr[DateTime] = js.undefined,
        EndDateType: js.UndefOr[EndDateType] = js.undefined,
        EphemeralStorage: js.UndefOr[Boolean] = js.undefined,
        InstanceMatchCriteria: js.UndefOr[InstanceMatchCriteria] = js.undefined,
        InstancePlatform: js.UndefOr[CapacityReservationInstancePlatform] = js.undefined,
        InstanceType: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[CapacityReservationState] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        Tenancy: js.UndefOr[CapacityReservationTenancy] = js.undefined,
        TotalInstanceCount: js.UndefOr[Int] = js.undefined
    ): CapacityReservation = {
      val __obj = js.Dynamic.literal()
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      AvailabilityZoneId.foreach(__v => __obj.updateDynamic("AvailabilityZoneId")(__v.asInstanceOf[js.Any]))
      AvailableInstanceCount.foreach(__v => __obj.updateDynamic("AvailableInstanceCount")(__v.asInstanceOf[js.Any]))
      CapacityReservationArn.foreach(__v => __obj.updateDynamic("CapacityReservationArn")(__v.asInstanceOf[js.Any]))
      CapacityReservationId.foreach(__v => __obj.updateDynamic("CapacityReservationId")(__v.asInstanceOf[js.Any]))
      CreateDate.foreach(__v => __obj.updateDynamic("CreateDate")(__v.asInstanceOf[js.Any]))
      EbsOptimized.foreach(__v => __obj.updateDynamic("EbsOptimized")(__v.asInstanceOf[js.Any]))
      EndDate.foreach(__v => __obj.updateDynamic("EndDate")(__v.asInstanceOf[js.Any]))
      EndDateType.foreach(__v => __obj.updateDynamic("EndDateType")(__v.asInstanceOf[js.Any]))
      EphemeralStorage.foreach(__v => __obj.updateDynamic("EphemeralStorage")(__v.asInstanceOf[js.Any]))
      InstanceMatchCriteria.foreach(__v => __obj.updateDynamic("InstanceMatchCriteria")(__v.asInstanceOf[js.Any]))
      InstancePlatform.foreach(__v => __obj.updateDynamic("InstancePlatform")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      OwnerId.foreach(__v => __obj.updateDynamic("OwnerId")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      Tenancy.foreach(__v => __obj.updateDynamic("Tenancy")(__v.asInstanceOf[js.Any]))
      TotalInstanceCount.foreach(__v => __obj.updateDynamic("TotalInstanceCount")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CapacityReservation]
    }
  }

  object CapacityReservationInstancePlatformEnum {
    val `Linux/UNIX`                         = "Linux/UNIX"
    val `Red Hat Enterprise Linux`           = "Red Hat Enterprise Linux"
    val `SUSE Linux`                         = "SUSE Linux"
    val Windows                              = "Windows"
    val `Windows with SQL Server`            = "Windows with SQL Server"
    val `Windows with SQL Server Enterprise` = "Windows with SQL Server Enterprise"
    val `Windows with SQL Server Standard`   = "Windows with SQL Server Standard"
    val `Windows with SQL Server Web`        = "Windows with SQL Server Web"
    val `Linux with SQL Server Standard`     = "Linux with SQL Server Standard"
    val `Linux with SQL Server Web`          = "Linux with SQL Server Web"
    val `Linux with SQL Server Enterprise`   = "Linux with SQL Server Enterprise"

    val values = js.Object.freeze(
      js.Array(
        `Linux/UNIX`,
        `Red Hat Enterprise Linux`,
        `SUSE Linux`,
        Windows,
        `Windows with SQL Server`,
        `Windows with SQL Server Enterprise`,
        `Windows with SQL Server Standard`,
        `Windows with SQL Server Web`,
        `Linux with SQL Server Standard`,
        `Linux with SQL Server Web`,
        `Linux with SQL Server Enterprise`
      )
    )
  }

  object CapacityReservationPreferenceEnum {
    val open = "open"
    val none = "none"

    val values = js.Object.freeze(js.Array(open, none))
  }

  /**
    * Describes an instance's Capacity Reservation targeting option. You can specify only one parameter at a time. If you specify <code>CapacityReservationPreference</code> and <code>CapacityReservationTarget</code>, the request fails.
    *  Use the <code>CapacityReservationPreference</code> parameter to configure the instance to run as an On-Demand Instance or to run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). Use the <code>CapacityReservationTarget</code> parameter to explicitly target a specific Capacity Reservation.
    */
  @js.native
  trait CapacityReservationSpecification extends js.Object {
    var CapacityReservationPreference: js.UndefOr[CapacityReservationPreference]
    var CapacityReservationTarget: js.UndefOr[CapacityReservationTarget]
  }

  object CapacityReservationSpecification {
    @inline
    def apply(
        CapacityReservationPreference: js.UndefOr[CapacityReservationPreference] = js.undefined,
        CapacityReservationTarget: js.UndefOr[CapacityReservationTarget] = js.undefined
    ): CapacityReservationSpecification = {
      val __obj = js.Dynamic.literal()
      CapacityReservationPreference.foreach(
        __v => __obj.updateDynamic("CapacityReservationPreference")(__v.asInstanceOf[js.Any])
      )
      CapacityReservationTarget.foreach(
        __v => __obj.updateDynamic("CapacityReservationTarget")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[CapacityReservationSpecification]
    }
  }

  /**
    * Describes the instance's Capacity Reservation targeting preferences. The action returns the <code>capacityReservationPreference</code> response element if the instance is configured to run in On-Demand capacity, or if it is configured in run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). The action returns the <code>capacityReservationTarget</code> response element if the instance explicily targets a specific Capacity Reservation.
    */
  @js.native
  trait CapacityReservationSpecificationResponse extends js.Object {
    var CapacityReservationPreference: js.UndefOr[CapacityReservationPreference]
    var CapacityReservationTarget: js.UndefOr[CapacityReservationTargetResponse]
  }

  object CapacityReservationSpecificationResponse {
    @inline
    def apply(
        CapacityReservationPreference: js.UndefOr[CapacityReservationPreference] = js.undefined,
        CapacityReservationTarget: js.UndefOr[CapacityReservationTargetResponse] = js.undefined
    ): CapacityReservationSpecificationResponse = {
      val __obj = js.Dynamic.literal()
      CapacityReservationPreference.foreach(
        __v => __obj.updateDynamic("CapacityReservationPreference")(__v.asInstanceOf[js.Any])
      )
      CapacityReservationTarget.foreach(
        __v => __obj.updateDynamic("CapacityReservationTarget")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[CapacityReservationSpecificationResponse]
    }
  }

  object CapacityReservationStateEnum {
    val active    = "active"
    val expired   = "expired"
    val cancelled = "cancelled"
    val pending   = "pending"
    val failed    = "failed"

    val values = js.Object.freeze(js.Array(active, expired, cancelled, pending, failed))
  }

  /**
    * Describes a target Capacity Reservation.
    */
  @js.native
  trait CapacityReservationTarget extends js.Object {
    var CapacityReservationId: js.UndefOr[String]
  }

  object CapacityReservationTarget {
    @inline
    def apply(
        CapacityReservationId: js.UndefOr[String] = js.undefined
    ): CapacityReservationTarget = {
      val __obj = js.Dynamic.literal()
      CapacityReservationId.foreach(__v => __obj.updateDynamic("CapacityReservationId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CapacityReservationTarget]
    }
  }

  /**
    * Describes a target Capacity Reservation.
    */
  @js.native
  trait CapacityReservationTargetResponse extends js.Object {
    var CapacityReservationId: js.UndefOr[String]
  }

  object CapacityReservationTargetResponse {
    @inline
    def apply(
        CapacityReservationId: js.UndefOr[String] = js.undefined
    ): CapacityReservationTargetResponse = {
      val __obj = js.Dynamic.literal()
      CapacityReservationId.foreach(__v => __obj.updateDynamic("CapacityReservationId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CapacityReservationTargetResponse]
    }
  }

  object CapacityReservationTenancyEnum {
    val default   = "default"
    val dedicated = "dedicated"

    val values = js.Object.freeze(js.Array(default, dedicated))
  }

  /**
    * Information about the client certificate used for authentication.
    */
  @js.native
  trait CertificateAuthentication extends js.Object {
    var ClientRootCertificateChain: js.UndefOr[String]
  }

  object CertificateAuthentication {
    @inline
    def apply(
        ClientRootCertificateChain: js.UndefOr[String] = js.undefined
    ): CertificateAuthentication = {
      val __obj = js.Dynamic.literal()
      ClientRootCertificateChain.foreach(
        __v => __obj.updateDynamic("ClientRootCertificateChain")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[CertificateAuthentication]
    }
  }

  /**
    * Information about the client certificate to be used for authentication.
    */
  @js.native
  trait CertificateAuthenticationRequest extends js.Object {
    var ClientRootCertificateChainArn: js.UndefOr[String]
  }

  object CertificateAuthenticationRequest {
    @inline
    def apply(
        ClientRootCertificateChainArn: js.UndefOr[String] = js.undefined
    ): CertificateAuthenticationRequest = {
      val __obj = js.Dynamic.literal()
      ClientRootCertificateChainArn.foreach(
        __v => __obj.updateDynamic("ClientRootCertificateChainArn")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[CertificateAuthenticationRequest]
    }
  }

  /**
    * Provides authorization for Amazon to bring a specific IP address range to a specific AWS account using bring your own IP addresses (BYOIP). For more information, see [[https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip|Prepare to Bring Your Address Range to Your AWS Account]] in the <i>Amazon Elastic Compute Cloud User Guide</i>.
    */
  @js.native
  trait CidrAuthorizationContext extends js.Object {
    var Message: String
    var Signature: String
  }

  object CidrAuthorizationContext {
    @inline
    def apply(
        Message: String,
        Signature: String
    ): CidrAuthorizationContext = {
      val __obj = js.Dynamic.literal(
        "Message"   -> Message.asInstanceOf[js.Any],
        "Signature" -> Signature.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[CidrAuthorizationContext]
    }
  }

  /**
    * Describes an IPv4 CIDR block.
    */
  @js.native
  trait CidrBlock extends js.Object {
    var CidrBlock: js.UndefOr[String]
  }

  object CidrBlock {
    @inline
    def apply(
        CidrBlock: js.UndefOr[String] = js.undefined
    ): CidrBlock = {
      val __obj = js.Dynamic.literal()
      CidrBlock.foreach(__v => __obj.updateDynamic("CidrBlock")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CidrBlock]
    }
  }

  /**
    * Describes the ClassicLink DNS support status of a VPC.
    */
  @js.native
  trait ClassicLinkDnsSupport extends js.Object {
    var ClassicLinkDnsSupported: js.UndefOr[Boolean]
    var VpcId: js.UndefOr[String]
  }

  object ClassicLinkDnsSupport {
    @inline
    def apply(
        ClassicLinkDnsSupported: js.UndefOr[Boolean] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): ClassicLinkDnsSupport = {
      val __obj = js.Dynamic.literal()
      ClassicLinkDnsSupported.foreach(__v => __obj.updateDynamic("ClassicLinkDnsSupported")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClassicLinkDnsSupport]
    }
  }

  /**
    * Describes a linked EC2-Classic instance.
    */
  @js.native
  trait ClassicLinkInstance extends js.Object {
    var Groups: js.UndefOr[GroupIdentifierList]
    var InstanceId: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
    var VpcId: js.UndefOr[String]
  }

  object ClassicLinkInstance {
    @inline
    def apply(
        Groups: js.UndefOr[GroupIdentifierList] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): ClassicLinkInstance = {
      val __obj = js.Dynamic.literal()
      Groups.foreach(__v => __obj.updateDynamic("Groups")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClassicLinkInstance]
    }
  }

  /**
    * Describes a Classic Load Balancer.
    */
  @js.native
  trait ClassicLoadBalancer extends js.Object {
    var Name: js.UndefOr[String]
  }

  object ClassicLoadBalancer {
    @inline
    def apply(
        Name: js.UndefOr[String] = js.undefined
    ): ClassicLoadBalancer = {
      val __obj = js.Dynamic.literal()
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClassicLoadBalancer]
    }
  }

  /**
    * Describes the Classic Load Balancers to attach to a Spot Fleet. Spot Fleet registers the running Spot Instances with these Classic Load Balancers.
    */
  @js.native
  trait ClassicLoadBalancersConfig extends js.Object {
    var ClassicLoadBalancers: js.UndefOr[ClassicLoadBalancers]
  }

  object ClassicLoadBalancersConfig {
    @inline
    def apply(
        ClassicLoadBalancers: js.UndefOr[ClassicLoadBalancers] = js.undefined
    ): ClassicLoadBalancersConfig = {
      val __obj = js.Dynamic.literal()
      ClassicLoadBalancers.foreach(__v => __obj.updateDynamic("ClassicLoadBalancers")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClassicLoadBalancersConfig]
    }
  }

  /**
    * Describes the state of a client certificate revocation list.
    */
  @js.native
  trait ClientCertificateRevocationListStatus extends js.Object {
    var Code: js.UndefOr[ClientCertificateRevocationListStatusCode]
    var Message: js.UndefOr[String]
  }

  object ClientCertificateRevocationListStatus {
    @inline
    def apply(
        Code: js.UndefOr[ClientCertificateRevocationListStatusCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): ClientCertificateRevocationListStatus = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Message.foreach(__v => __obj.updateDynamic("Message")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClientCertificateRevocationListStatus]
    }
  }

  object ClientCertificateRevocationListStatusCodeEnum {
    val pending = "pending"
    val active  = "active"

    val values = js.Object.freeze(js.Array(pending, active))
  }

  /**
    * Describes the client-specific data.
    */
  @js.native
  trait ClientData extends js.Object {
    var Comment: js.UndefOr[String]
    var UploadEnd: js.UndefOr[DateTime]
    var UploadSize: js.UndefOr[Double]
    var UploadStart: js.UndefOr[DateTime]
  }

  object ClientData {
    @inline
    def apply(
        Comment: js.UndefOr[String] = js.undefined,
        UploadEnd: js.UndefOr[DateTime] = js.undefined,
        UploadSize: js.UndefOr[Double] = js.undefined,
        UploadStart: js.UndefOr[DateTime] = js.undefined
    ): ClientData = {
      val __obj = js.Dynamic.literal()
      Comment.foreach(__v => __obj.updateDynamic("Comment")(__v.asInstanceOf[js.Any]))
      UploadEnd.foreach(__v => __obj.updateDynamic("UploadEnd")(__v.asInstanceOf[js.Any]))
      UploadSize.foreach(__v => __obj.updateDynamic("UploadSize")(__v.asInstanceOf[js.Any]))
      UploadStart.foreach(__v => __obj.updateDynamic("UploadStart")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClientData]
    }
  }

  /**
    * Describes the authentication methods used by a Client VPN endpoint. Client VPN supports Active Directory and mutual authentication. For more information, see [[https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication|Authentication]] in the <i>AWS Client VPN Administrator Guide</i>.
    */
  @js.native
  trait ClientVpnAuthentication extends js.Object {
    var ActiveDirectory: js.UndefOr[DirectoryServiceAuthentication]
    var MutualAuthentication: js.UndefOr[CertificateAuthentication]
    var Type: js.UndefOr[ClientVpnAuthenticationType]
  }

  object ClientVpnAuthentication {
    @inline
    def apply(
        ActiveDirectory: js.UndefOr[DirectoryServiceAuthentication] = js.undefined,
        MutualAuthentication: js.UndefOr[CertificateAuthentication] = js.undefined,
        Type: js.UndefOr[ClientVpnAuthenticationType] = js.undefined
    ): ClientVpnAuthentication = {
      val __obj = js.Dynamic.literal()
      ActiveDirectory.foreach(__v => __obj.updateDynamic("ActiveDirectory")(__v.asInstanceOf[js.Any]))
      MutualAuthentication.foreach(__v => __obj.updateDynamic("MutualAuthentication")(__v.asInstanceOf[js.Any]))
      Type.foreach(__v => __obj.updateDynamic("Type")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClientVpnAuthentication]
    }
  }

  /**
    * Describes the authentication method to be used by a Client VPN endpoint. Client VPN supports Active Directory and mutual authentication. For more information, see [[https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication|Authentication]] in the <i>AWS Client VPN Administrator Guide</i>.
    */
  @js.native
  trait ClientVpnAuthenticationRequest extends js.Object {
    var ActiveDirectory: js.UndefOr[DirectoryServiceAuthenticationRequest]
    var MutualAuthentication: js.UndefOr[CertificateAuthenticationRequest]
    var Type: js.UndefOr[ClientVpnAuthenticationType]
  }

  object ClientVpnAuthenticationRequest {
    @inline
    def apply(
        ActiveDirectory: js.UndefOr[DirectoryServiceAuthenticationRequest] = js.undefined,
        MutualAuthentication: js.UndefOr[CertificateAuthenticationRequest] = js.undefined,
        Type: js.UndefOr[ClientVpnAuthenticationType] = js.undefined
    ): ClientVpnAuthenticationRequest = {
      val __obj = js.Dynamic.literal()
      ActiveDirectory.foreach(__v => __obj.updateDynamic("ActiveDirectory")(__v.asInstanceOf[js.Any]))
      MutualAuthentication.foreach(__v => __obj.updateDynamic("MutualAuthentication")(__v.asInstanceOf[js.Any]))
      Type.foreach(__v => __obj.updateDynamic("Type")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClientVpnAuthenticationRequest]
    }
  }

  object ClientVpnAuthenticationTypeEnum {
    val `certificate-authentication`       = "certificate-authentication"
    val `directory-service-authentication` = "directory-service-authentication"

    val values = js.Object.freeze(js.Array(`certificate-authentication`, `directory-service-authentication`))
  }

  /**
    * Describes the state of an authorization rule.
    */
  @js.native
  trait ClientVpnAuthorizationRuleStatus extends js.Object {
    var Code: js.UndefOr[ClientVpnAuthorizationRuleStatusCode]
    var Message: js.UndefOr[String]
  }

  object ClientVpnAuthorizationRuleStatus {
    @inline
    def apply(
        Code: js.UndefOr[ClientVpnAuthorizationRuleStatusCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): ClientVpnAuthorizationRuleStatus = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Message.foreach(__v => __obj.updateDynamic("Message")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClientVpnAuthorizationRuleStatus]
    }
  }

  object ClientVpnAuthorizationRuleStatusCodeEnum {
    val authorizing = "authorizing"
    val active      = "active"
    val failed      = "failed"
    val revoking    = "revoking"

    val values = js.Object.freeze(js.Array(authorizing, active, failed, revoking))
  }

  /**
    * Describes a client connection.
    */
  @js.native
  trait ClientVpnConnection extends js.Object {
    var ClientIp: js.UndefOr[String]
    var ClientVpnEndpointId: js.UndefOr[String]
    var CommonName: js.UndefOr[String]
    var ConnectionEndTime: js.UndefOr[String]
    var ConnectionEstablishedTime: js.UndefOr[String]
    var ConnectionId: js.UndefOr[String]
    var EgressBytes: js.UndefOr[String]
    var EgressPackets: js.UndefOr[String]
    var IngressBytes: js.UndefOr[String]
    var IngressPackets: js.UndefOr[String]
    var Status: js.UndefOr[ClientVpnConnectionStatus]
    var Timestamp: js.UndefOr[String]
    var Username: js.UndefOr[String]
  }

  object ClientVpnConnection {
    @inline
    def apply(
        ClientIp: js.UndefOr[String] = js.undefined,
        ClientVpnEndpointId: js.UndefOr[String] = js.undefined,
        CommonName: js.UndefOr[String] = js.undefined,
        ConnectionEndTime: js.UndefOr[String] = js.undefined,
        ConnectionEstablishedTime: js.UndefOr[String] = js.undefined,
        ConnectionId: js.UndefOr[String] = js.undefined,
        EgressBytes: js.UndefOr[String] = js.undefined,
        EgressPackets: js.UndefOr[String] = js.undefined,
        IngressBytes: js.UndefOr[String] = js.undefined,
        IngressPackets: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[ClientVpnConnectionStatus] = js.undefined,
        Timestamp: js.UndefOr[String] = js.undefined,
        Username: js.UndefOr[String] = js.undefined
    ): ClientVpnConnection = {
      val __obj = js.Dynamic.literal()
      ClientIp.foreach(__v => __obj.updateDynamic("ClientIp")(__v.asInstanceOf[js.Any]))
      ClientVpnEndpointId.foreach(__v => __obj.updateDynamic("ClientVpnEndpointId")(__v.asInstanceOf[js.Any]))
      CommonName.foreach(__v => __obj.updateDynamic("CommonName")(__v.asInstanceOf[js.Any]))
      ConnectionEndTime.foreach(__v => __obj.updateDynamic("ConnectionEndTime")(__v.asInstanceOf[js.Any]))
      ConnectionEstablishedTime.foreach(
        __v => __obj.updateDynamic("ConnectionEstablishedTime")(__v.asInstanceOf[js.Any])
      )
      ConnectionId.foreach(__v => __obj.updateDynamic("ConnectionId")(__v.asInstanceOf[js.Any]))
      EgressBytes.foreach(__v => __obj.updateDynamic("EgressBytes")(__v.asInstanceOf[js.Any]))
      EgressPackets.foreach(__v => __obj.updateDynamic("EgressPackets")(__v.asInstanceOf[js.Any]))
      IngressBytes.foreach(__v => __obj.updateDynamic("IngressBytes")(__v.asInstanceOf[js.Any]))
      IngressPackets.foreach(__v => __obj.updateDynamic("IngressPackets")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      Timestamp.foreach(__v => __obj.updateDynamic("Timestamp")(__v.asInstanceOf[js.Any]))
      Username.foreach(__v => __obj.updateDynamic("Username")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClientVpnConnection]
    }
  }

  /**
    * Describes the status of a client connection.
    */
  @js.native
  trait ClientVpnConnectionStatus extends js.Object {
    var Code: js.UndefOr[ClientVpnConnectionStatusCode]
    var Message: js.UndefOr[String]
  }

  object ClientVpnConnectionStatus {
    @inline
    def apply(
        Code: js.UndefOr[ClientVpnConnectionStatusCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): ClientVpnConnectionStatus = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Message.foreach(__v => __obj.updateDynamic("Message")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClientVpnConnectionStatus]
    }
  }

  object ClientVpnConnectionStatusCodeEnum {
    val active                = "active"
    val `failed-to-terminate` = "failed-to-terminate"
    val terminating           = "terminating"
    val terminated            = "terminated"

    val values = js.Object.freeze(js.Array(active, `failed-to-terminate`, terminating, terminated))
  }

  /**
    * Describes a Client VPN endpoint.
    */
  @js.native
  trait ClientVpnEndpoint extends js.Object {
    var AssociatedTargetNetworks: js.UndefOr[AssociatedTargetNetworkSet]
    var AuthenticationOptions: js.UndefOr[ClientVpnAuthenticationList]
    var ClientCidrBlock: js.UndefOr[String]
    var ClientVpnEndpointId: js.UndefOr[String]
    var ConnectionLogOptions: js.UndefOr[ConnectionLogResponseOptions]
    var CreationTime: js.UndefOr[String]
    var DeletionTime: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DnsName: js.UndefOr[String]
    var DnsServers: js.UndefOr[ValueStringList]
    var ServerCertificateArn: js.UndefOr[String]
    var SplitTunnel: js.UndefOr[Boolean]
    var Status: js.UndefOr[ClientVpnEndpointStatus]
    var Tags: js.UndefOr[TagList]
    var TransportProtocol: js.UndefOr[TransportProtocol]
    var VpnProtocol: js.UndefOr[VpnProtocol]
  }

  object ClientVpnEndpoint {
    @inline
    def apply(
        AssociatedTargetNetworks: js.UndefOr[AssociatedTargetNetworkSet] = js.undefined,
        AuthenticationOptions: js.UndefOr[ClientVpnAuthenticationList] = js.undefined,
        ClientCidrBlock: js.UndefOr[String] = js.undefined,
        ClientVpnEndpointId: js.UndefOr[String] = js.undefined,
        ConnectionLogOptions: js.UndefOr[ConnectionLogResponseOptions] = js.undefined,
        CreationTime: js.UndefOr[String] = js.undefined,
        DeletionTime: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DnsName: js.UndefOr[String] = js.undefined,
        DnsServers: js.UndefOr[ValueStringList] = js.undefined,
        ServerCertificateArn: js.UndefOr[String] = js.undefined,
        SplitTunnel: js.UndefOr[Boolean] = js.undefined,
        Status: js.UndefOr[ClientVpnEndpointStatus] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        TransportProtocol: js.UndefOr[TransportProtocol] = js.undefined,
        VpnProtocol: js.UndefOr[VpnProtocol] = js.undefined
    ): ClientVpnEndpoint = {
      val __obj = js.Dynamic.literal()
      AssociatedTargetNetworks.foreach(__v => __obj.updateDynamic("AssociatedTargetNetworks")(__v.asInstanceOf[js.Any]))
      AuthenticationOptions.foreach(__v => __obj.updateDynamic("AuthenticationOptions")(__v.asInstanceOf[js.Any]))
      ClientCidrBlock.foreach(__v => __obj.updateDynamic("ClientCidrBlock")(__v.asInstanceOf[js.Any]))
      ClientVpnEndpointId.foreach(__v => __obj.updateDynamic("ClientVpnEndpointId")(__v.asInstanceOf[js.Any]))
      ConnectionLogOptions.foreach(__v => __obj.updateDynamic("ConnectionLogOptions")(__v.asInstanceOf[js.Any]))
      CreationTime.foreach(__v => __obj.updateDynamic("CreationTime")(__v.asInstanceOf[js.Any]))
      DeletionTime.foreach(__v => __obj.updateDynamic("DeletionTime")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DnsName.foreach(__v => __obj.updateDynamic("DnsName")(__v.asInstanceOf[js.Any]))
      DnsServers.foreach(__v => __obj.updateDynamic("DnsServers")(__v.asInstanceOf[js.Any]))
      ServerCertificateArn.foreach(__v => __obj.updateDynamic("ServerCertificateArn")(__v.asInstanceOf[js.Any]))
      SplitTunnel.foreach(__v => __obj.updateDynamic("SplitTunnel")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      TransportProtocol.foreach(__v => __obj.updateDynamic("TransportProtocol")(__v.asInstanceOf[js.Any]))
      VpnProtocol.foreach(__v => __obj.updateDynamic("VpnProtocol")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClientVpnEndpoint]
    }
  }

  /**
    * Describes the state of a Client VPN endpoint.
    */
  @js.native
  trait ClientVpnEndpointStatus extends js.Object {
    var Code: js.UndefOr[ClientVpnEndpointStatusCode]
    var Message: js.UndefOr[String]
  }

  object ClientVpnEndpointStatus {
    @inline
    def apply(
        Code: js.UndefOr[ClientVpnEndpointStatusCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): ClientVpnEndpointStatus = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Message.foreach(__v => __obj.updateDynamic("Message")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClientVpnEndpointStatus]
    }
  }

  object ClientVpnEndpointStatusCodeEnum {
    val `pending-associate` = "pending-associate"
    val available           = "available"
    val deleting            = "deleting"
    val deleted             = "deleted"

    val values = js.Object.freeze(js.Array(`pending-associate`, available, deleting, deleted))
  }

  /**
    * Information about a Client VPN endpoint route.
    */
  @js.native
  trait ClientVpnRoute extends js.Object {
    var ClientVpnEndpointId: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DestinationCidr: js.UndefOr[String]
    var Origin: js.UndefOr[String]
    var Status: js.UndefOr[ClientVpnRouteStatus]
    var TargetSubnet: js.UndefOr[String]
    var Type: js.UndefOr[String]
  }

  object ClientVpnRoute {
    @inline
    def apply(
        ClientVpnEndpointId: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DestinationCidr: js.UndefOr[String] = js.undefined,
        Origin: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[ClientVpnRouteStatus] = js.undefined,
        TargetSubnet: js.UndefOr[String] = js.undefined,
        Type: js.UndefOr[String] = js.undefined
    ): ClientVpnRoute = {
      val __obj = js.Dynamic.literal()
      ClientVpnEndpointId.foreach(__v => __obj.updateDynamic("ClientVpnEndpointId")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DestinationCidr.foreach(__v => __obj.updateDynamic("DestinationCidr")(__v.asInstanceOf[js.Any]))
      Origin.foreach(__v => __obj.updateDynamic("Origin")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      TargetSubnet.foreach(__v => __obj.updateDynamic("TargetSubnet")(__v.asInstanceOf[js.Any]))
      Type.foreach(__v => __obj.updateDynamic("Type")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClientVpnRoute]
    }
  }

  /**
    * Describes the state of a Client VPN endpoint route.
    */
  @js.native
  trait ClientVpnRouteStatus extends js.Object {
    var Code: js.UndefOr[ClientVpnRouteStatusCode]
    var Message: js.UndefOr[String]
  }

  object ClientVpnRouteStatus {
    @inline
    def apply(
        Code: js.UndefOr[ClientVpnRouteStatusCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): ClientVpnRouteStatus = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Message.foreach(__v => __obj.updateDynamic("Message")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ClientVpnRouteStatus]
    }
  }

  object ClientVpnRouteStatusCodeEnum {
    val creating = "creating"
    val active   = "active"
    val failed   = "failed"
    val deleting = "deleting"

    val values = js.Object.freeze(js.Array(creating, active, failed, deleting))
  }

  @js.native
  trait ConfirmProductInstanceRequest extends js.Object {
    var InstanceId: String
    var ProductCode: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ConfirmProductInstanceRequest {
    @inline
    def apply(
        InstanceId: String,
        ProductCode: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ConfirmProductInstanceRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceId"  -> InstanceId.asInstanceOf[js.Any],
        "ProductCode" -> ProductCode.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ConfirmProductInstanceRequest]
    }
  }

  @js.native
  trait ConfirmProductInstanceResult extends js.Object {
    var OwnerId: js.UndefOr[String]
    var Return: js.UndefOr[Boolean]
  }

  object ConfirmProductInstanceResult {
    @inline
    def apply(
        OwnerId: js.UndefOr[String] = js.undefined,
        Return: js.UndefOr[Boolean] = js.undefined
    ): ConfirmProductInstanceResult = {
      val __obj = js.Dynamic.literal()
      OwnerId.foreach(__v => __obj.updateDynamic("OwnerId")(__v.asInstanceOf[js.Any]))
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ConfirmProductInstanceResult]
    }
  }

  /**
    * Describes the client connection logging options for the Client VPN endpoint.
    */
  @js.native
  trait ConnectionLogOptions extends js.Object {
    var CloudwatchLogGroup: js.UndefOr[String]
    var CloudwatchLogStream: js.UndefOr[String]
    var Enabled: js.UndefOr[Boolean]
  }

  object ConnectionLogOptions {
    @inline
    def apply(
        CloudwatchLogGroup: js.UndefOr[String] = js.undefined,
        CloudwatchLogStream: js.UndefOr[String] = js.undefined,
        Enabled: js.UndefOr[Boolean] = js.undefined
    ): ConnectionLogOptions = {
      val __obj = js.Dynamic.literal()
      CloudwatchLogGroup.foreach(__v => __obj.updateDynamic("CloudwatchLogGroup")(__v.asInstanceOf[js.Any]))
      CloudwatchLogStream.foreach(__v => __obj.updateDynamic("CloudwatchLogStream")(__v.asInstanceOf[js.Any]))
      Enabled.foreach(__v => __obj.updateDynamic("Enabled")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ConnectionLogOptions]
    }
  }

  /**
    * Information about the client connection logging options for a Client VPN endpoint.
    */
  @js.native
  trait ConnectionLogResponseOptions extends js.Object {
    var CloudwatchLogGroup: js.UndefOr[String]
    var CloudwatchLogStream: js.UndefOr[String]
    var Enabled: js.UndefOr[Boolean]
  }

  object ConnectionLogResponseOptions {
    @inline
    def apply(
        CloudwatchLogGroup: js.UndefOr[String] = js.undefined,
        CloudwatchLogStream: js.UndefOr[String] = js.undefined,
        Enabled: js.UndefOr[Boolean] = js.undefined
    ): ConnectionLogResponseOptions = {
      val __obj = js.Dynamic.literal()
      CloudwatchLogGroup.foreach(__v => __obj.updateDynamic("CloudwatchLogGroup")(__v.asInstanceOf[js.Any]))
      CloudwatchLogStream.foreach(__v => __obj.updateDynamic("CloudwatchLogStream")(__v.asInstanceOf[js.Any]))
      Enabled.foreach(__v => __obj.updateDynamic("Enabled")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ConnectionLogResponseOptions]
    }
  }

  /**
    * Describes a connection notification for a VPC endpoint or VPC endpoint service.
    */
  @js.native
  trait ConnectionNotification extends js.Object {
    var ConnectionEvents: js.UndefOr[ValueStringList]
    var ConnectionNotificationArn: js.UndefOr[String]
    var ConnectionNotificationId: js.UndefOr[String]
    var ConnectionNotificationState: js.UndefOr[ConnectionNotificationState]
    var ConnectionNotificationType: js.UndefOr[ConnectionNotificationType]
    var ServiceId: js.UndefOr[String]
    var VpcEndpointId: js.UndefOr[String]
  }

  object ConnectionNotification {
    @inline
    def apply(
        ConnectionEvents: js.UndefOr[ValueStringList] = js.undefined,
        ConnectionNotificationArn: js.UndefOr[String] = js.undefined,
        ConnectionNotificationId: js.UndefOr[String] = js.undefined,
        ConnectionNotificationState: js.UndefOr[ConnectionNotificationState] = js.undefined,
        ConnectionNotificationType: js.UndefOr[ConnectionNotificationType] = js.undefined,
        ServiceId: js.UndefOr[String] = js.undefined,
        VpcEndpointId: js.UndefOr[String] = js.undefined
    ): ConnectionNotification = {
      val __obj = js.Dynamic.literal()
      ConnectionEvents.foreach(__v => __obj.updateDynamic("ConnectionEvents")(__v.asInstanceOf[js.Any]))
      ConnectionNotificationArn.foreach(
        __v => __obj.updateDynamic("ConnectionNotificationArn")(__v.asInstanceOf[js.Any])
      )
      ConnectionNotificationId.foreach(__v => __obj.updateDynamic("ConnectionNotificationId")(__v.asInstanceOf[js.Any]))
      ConnectionNotificationState.foreach(
        __v => __obj.updateDynamic("ConnectionNotificationState")(__v.asInstanceOf[js.Any])
      )
      ConnectionNotificationType.foreach(
        __v => __obj.updateDynamic("ConnectionNotificationType")(__v.asInstanceOf[js.Any])
      )
      ServiceId.foreach(__v => __obj.updateDynamic("ServiceId")(__v.asInstanceOf[js.Any]))
      VpcEndpointId.foreach(__v => __obj.updateDynamic("VpcEndpointId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ConnectionNotification]
    }
  }

  object ConnectionNotificationStateEnum {
    val Enabled  = "Enabled"
    val Disabled = "Disabled"

    val values = js.Object.freeze(js.Array(Enabled, Disabled))
  }

  object ConnectionNotificationTypeEnum {
    val Topic = "Topic"

    val values = js.Object.freeze(js.Array(Topic))
  }

  object ContainerFormatEnum {
    val ova = "ova"

    val values = js.Object.freeze(js.Array(ova))
  }

  /**
    * Describes a conversion task.
    */
  @js.native
  trait ConversionTask extends js.Object {
    var ConversionTaskId: js.UndefOr[String]
    var ExpirationTime: js.UndefOr[String]
    var ImportInstance: js.UndefOr[ImportInstanceTaskDetails]
    var ImportVolume: js.UndefOr[ImportVolumeTaskDetails]
    var State: js.UndefOr[ConversionTaskState]
    var StatusMessage: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
  }

  object ConversionTask {
    @inline
    def apply(
        ConversionTaskId: js.UndefOr[String] = js.undefined,
        ExpirationTime: js.UndefOr[String] = js.undefined,
        ImportInstance: js.UndefOr[ImportInstanceTaskDetails] = js.undefined,
        ImportVolume: js.UndefOr[ImportVolumeTaskDetails] = js.undefined,
        State: js.UndefOr[ConversionTaskState] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): ConversionTask = {
      val __obj = js.Dynamic.literal()
      ConversionTaskId.foreach(__v => __obj.updateDynamic("ConversionTaskId")(__v.asInstanceOf[js.Any]))
      ExpirationTime.foreach(__v => __obj.updateDynamic("ExpirationTime")(__v.asInstanceOf[js.Any]))
      ImportInstance.foreach(__v => __obj.updateDynamic("ImportInstance")(__v.asInstanceOf[js.Any]))
      ImportVolume.foreach(__v => __obj.updateDynamic("ImportVolume")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      StatusMessage.foreach(__v => __obj.updateDynamic("StatusMessage")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ConversionTask]
    }
  }

  object ConversionTaskStateEnum {
    val active     = "active"
    val cancelling = "cancelling"
    val cancelled  = "cancelled"
    val completed  = "completed"

    val values = js.Object.freeze(js.Array(active, cancelling, cancelled, completed))
  }

  @js.native
  trait CopyFpgaImageRequest extends js.Object {
    var SourceFpgaImageId: String
    var SourceRegion: String
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Name: js.UndefOr[String]
  }

  object CopyFpgaImageRequest {
    @inline
    def apply(
        SourceFpgaImageId: String,
        SourceRegion: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Name: js.UndefOr[String] = js.undefined
    ): CopyFpgaImageRequest = {
      val __obj = js.Dynamic.literal(
        "SourceFpgaImageId" -> SourceFpgaImageId.asInstanceOf[js.Any],
        "SourceRegion"      -> SourceRegion.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CopyFpgaImageRequest]
    }
  }

  @js.native
  trait CopyFpgaImageResult extends js.Object {
    var FpgaImageId: js.UndefOr[String]
  }

  object CopyFpgaImageResult {
    @inline
    def apply(
        FpgaImageId: js.UndefOr[String] = js.undefined
    ): CopyFpgaImageResult = {
      val __obj = js.Dynamic.literal()
      FpgaImageId.foreach(__v => __obj.updateDynamic("FpgaImageId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CopyFpgaImageResult]
    }
  }

  /**
    * Contains the parameters for CopyImage.
    */
  @js.native
  trait CopyImageRequest extends js.Object {
    var Name: String
    var SourceImageId: String
    var SourceRegion: String
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var KmsKeyId: js.UndefOr[String]
  }

  object CopyImageRequest {
    @inline
    def apply(
        Name: String,
        SourceImageId: String,
        SourceRegion: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined
    ): CopyImageRequest = {
      val __obj = js.Dynamic.literal(
        "Name"          -> Name.asInstanceOf[js.Any],
        "SourceImageId" -> SourceImageId.asInstanceOf[js.Any],
        "SourceRegion"  -> SourceRegion.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Encrypted.foreach(__v => __obj.updateDynamic("Encrypted")(__v.asInstanceOf[js.Any]))
      KmsKeyId.foreach(__v => __obj.updateDynamic("KmsKeyId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CopyImageRequest]
    }
  }

  /**
    * Contains the output of CopyImage.
    */
  @js.native
  trait CopyImageResult extends js.Object {
    var ImageId: js.UndefOr[String]
  }

  object CopyImageResult {
    @inline
    def apply(
        ImageId: js.UndefOr[String] = js.undefined
    ): CopyImageResult = {
      val __obj = js.Dynamic.literal()
      ImageId.foreach(__v => __obj.updateDynamic("ImageId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CopyImageResult]
    }
  }

  /**
    * Contains the parameters for CopySnapshot.
    */
  @js.native
  trait CopySnapshotRequest extends js.Object {
    var SourceRegion: String
    var SourceSnapshotId: String
    var Description: js.UndefOr[String]
    var DestinationRegion: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var KmsKeyId: js.UndefOr[String]
    var PresignedUrl: js.UndefOr[String]
  }

  object CopySnapshotRequest {
    @inline
    def apply(
        SourceRegion: String,
        SourceSnapshotId: String,
        Description: js.UndefOr[String] = js.undefined,
        DestinationRegion: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        PresignedUrl: js.UndefOr[String] = js.undefined
    ): CopySnapshotRequest = {
      val __obj = js.Dynamic.literal(
        "SourceRegion"     -> SourceRegion.asInstanceOf[js.Any],
        "SourceSnapshotId" -> SourceSnapshotId.asInstanceOf[js.Any]
      )

      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DestinationRegion.foreach(__v => __obj.updateDynamic("DestinationRegion")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Encrypted.foreach(__v => __obj.updateDynamic("Encrypted")(__v.asInstanceOf[js.Any]))
      KmsKeyId.foreach(__v => __obj.updateDynamic("KmsKeyId")(__v.asInstanceOf[js.Any]))
      PresignedUrl.foreach(__v => __obj.updateDynamic("PresignedUrl")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CopySnapshotRequest]
    }
  }

  /**
    * Contains the output of CopySnapshot.
    */
  @js.native
  trait CopySnapshotResult extends js.Object {
    var SnapshotId: js.UndefOr[String]
  }

  object CopySnapshotResult {
    @inline
    def apply(
        SnapshotId: js.UndefOr[String] = js.undefined
    ): CopySnapshotResult = {
      val __obj = js.Dynamic.literal()
      SnapshotId.foreach(__v => __obj.updateDynamic("SnapshotId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CopySnapshotResult]
    }
  }

  object CopyTagsFromSourceEnum {
    val volume = "volume"

    val values = js.Object.freeze(js.Array(volume))
  }

  /**
    * The CPU options for the instance.
    */
  @js.native
  trait CpuOptions extends js.Object {
    var CoreCount: js.UndefOr[Int]
    var ThreadsPerCore: js.UndefOr[Int]
  }

  object CpuOptions {
    @inline
    def apply(
        CoreCount: js.UndefOr[Int] = js.undefined,
        ThreadsPerCore: js.UndefOr[Int] = js.undefined
    ): CpuOptions = {
      val __obj = js.Dynamic.literal()
      CoreCount.foreach(__v => __obj.updateDynamic("CoreCount")(__v.asInstanceOf[js.Any]))
      ThreadsPerCore.foreach(__v => __obj.updateDynamic("ThreadsPerCore")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CpuOptions]
    }
  }

  /**
    * The CPU options for the instance. Both the core count and threads per core must be specified in the request.
    */
  @js.native
  trait CpuOptionsRequest extends js.Object {
    var CoreCount: js.UndefOr[Int]
    var ThreadsPerCore: js.UndefOr[Int]
  }

  object CpuOptionsRequest {
    @inline
    def apply(
        CoreCount: js.UndefOr[Int] = js.undefined,
        ThreadsPerCore: js.UndefOr[Int] = js.undefined
    ): CpuOptionsRequest = {
      val __obj = js.Dynamic.literal()
      CoreCount.foreach(__v => __obj.updateDynamic("CoreCount")(__v.asInstanceOf[js.Any]))
      ThreadsPerCore.foreach(__v => __obj.updateDynamic("ThreadsPerCore")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CpuOptionsRequest]
    }
  }

  @js.native
  trait CreateCapacityReservationRequest extends js.Object {
    var InstanceCount: Int
    var InstancePlatform: CapacityReservationInstancePlatform
    var InstanceType: String
    var AvailabilityZone: js.UndefOr[String]
    var AvailabilityZoneId: js.UndefOr[String]
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var EbsOptimized: js.UndefOr[Boolean]
    var EndDate: js.UndefOr[DateTime]
    var EndDateType: js.UndefOr[EndDateType]
    var EphemeralStorage: js.UndefOr[Boolean]
    var InstanceMatchCriteria: js.UndefOr[InstanceMatchCriteria]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
    var Tenancy: js.UndefOr[CapacityReservationTenancy]
  }

  object CreateCapacityReservationRequest {
    @inline
    def apply(
        InstanceCount: Int,
        InstancePlatform: CapacityReservationInstancePlatform,
        InstanceType: String,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        AvailabilityZoneId: js.UndefOr[String] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EbsOptimized: js.UndefOr[Boolean] = js.undefined,
        EndDate: js.UndefOr[DateTime] = js.undefined,
        EndDateType: js.UndefOr[EndDateType] = js.undefined,
        EphemeralStorage: js.UndefOr[Boolean] = js.undefined,
        InstanceMatchCriteria: js.UndefOr[InstanceMatchCriteria] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined,
        Tenancy: js.UndefOr[CapacityReservationTenancy] = js.undefined
    ): CreateCapacityReservationRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceCount"    -> InstanceCount.asInstanceOf[js.Any],
        "InstancePlatform" -> InstancePlatform.asInstanceOf[js.Any],
        "InstanceType"     -> InstanceType.asInstanceOf[js.Any]
      )

      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      AvailabilityZoneId.foreach(__v => __obj.updateDynamic("AvailabilityZoneId")(__v.asInstanceOf[js.Any]))
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      EbsOptimized.foreach(__v => __obj.updateDynamic("EbsOptimized")(__v.asInstanceOf[js.Any]))
      EndDate.foreach(__v => __obj.updateDynamic("EndDate")(__v.asInstanceOf[js.Any]))
      EndDateType.foreach(__v => __obj.updateDynamic("EndDateType")(__v.asInstanceOf[js.Any]))
      EphemeralStorage.foreach(__v => __obj.updateDynamic("EphemeralStorage")(__v.asInstanceOf[js.Any]))
      InstanceMatchCriteria.foreach(__v => __obj.updateDynamic("InstanceMatchCriteria")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      Tenancy.foreach(__v => __obj.updateDynamic("Tenancy")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateCapacityReservationRequest]
    }
  }

  @js.native
  trait CreateCapacityReservationResult extends js.Object {
    var CapacityReservation: js.UndefOr[CapacityReservation]
  }

  object CreateCapacityReservationResult {
    @inline
    def apply(
        CapacityReservation: js.UndefOr[CapacityReservation] = js.undefined
    ): CreateCapacityReservationResult = {
      val __obj = js.Dynamic.literal()
      CapacityReservation.foreach(__v => __obj.updateDynamic("CapacityReservation")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateCapacityReservationResult]
    }
  }

  @js.native
  trait CreateClientVpnEndpointRequest extends js.Object {
    var AuthenticationOptions: ClientVpnAuthenticationRequestList
    var ClientCidrBlock: String
    var ConnectionLogOptions: ConnectionLogOptions
    var ServerCertificateArn: String
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DnsServers: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var SplitTunnel: js.UndefOr[Boolean]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
    var TransportProtocol: js.UndefOr[TransportProtocol]
  }

  object CreateClientVpnEndpointRequest {
    @inline
    def apply(
        AuthenticationOptions: ClientVpnAuthenticationRequestList,
        ClientCidrBlock: String,
        ConnectionLogOptions: ConnectionLogOptions,
        ServerCertificateArn: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DnsServers: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        SplitTunnel: js.UndefOr[Boolean] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined,
        TransportProtocol: js.UndefOr[TransportProtocol] = js.undefined
    ): CreateClientVpnEndpointRequest = {
      val __obj = js.Dynamic.literal(
        "AuthenticationOptions" -> AuthenticationOptions.asInstanceOf[js.Any],
        "ClientCidrBlock"       -> ClientCidrBlock.asInstanceOf[js.Any],
        "ConnectionLogOptions"  -> ConnectionLogOptions.asInstanceOf[js.Any],
        "ServerCertificateArn"  -> ServerCertificateArn.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DnsServers.foreach(__v => __obj.updateDynamic("DnsServers")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      SplitTunnel.foreach(__v => __obj.updateDynamic("SplitTunnel")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      TransportProtocol.foreach(__v => __obj.updateDynamic("TransportProtocol")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateClientVpnEndpointRequest]
    }
  }

  @js.native
  trait CreateClientVpnEndpointResult extends js.Object {
    var ClientVpnEndpointId: js.UndefOr[String]
    var DnsName: js.UndefOr[String]
    var Status: js.UndefOr[ClientVpnEndpointStatus]
  }

  object CreateClientVpnEndpointResult {
    @inline
    def apply(
        ClientVpnEndpointId: js.UndefOr[String] = js.undefined,
        DnsName: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[ClientVpnEndpointStatus] = js.undefined
    ): CreateClientVpnEndpointResult = {
      val __obj = js.Dynamic.literal()
      ClientVpnEndpointId.foreach(__v => __obj.updateDynamic("ClientVpnEndpointId")(__v.asInstanceOf[js.Any]))
      DnsName.foreach(__v => __obj.updateDynamic("DnsName")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateClientVpnEndpointResult]
    }
  }

  @js.native
  trait CreateClientVpnRouteRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DestinationCidrBlock: String
    var TargetVpcSubnetId: String
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateClientVpnRouteRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        DestinationCidrBlock: String,
        TargetVpcSubnetId: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateClientVpnRouteRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId"  -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "DestinationCidrBlock" -> DestinationCidrBlock.asInstanceOf[js.Any],
        "TargetVpcSubnetId"    -> TargetVpcSubnetId.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateClientVpnRouteRequest]
    }
  }

  @js.native
  trait CreateClientVpnRouteResult extends js.Object {
    var Status: js.UndefOr[ClientVpnRouteStatus]
  }

  object CreateClientVpnRouteResult {
    @inline
    def apply(
        Status: js.UndefOr[ClientVpnRouteStatus] = js.undefined
    ): CreateClientVpnRouteResult = {
      val __obj = js.Dynamic.literal()
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateClientVpnRouteResult]
    }
  }

  /**
    * Contains the parameters for CreateCustomerGateway.
    */
  @js.native
  trait CreateCustomerGatewayRequest extends js.Object {
    var BgpAsn: Int
    var Type: GatewayType
    var CertificateArn: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var PublicIp: js.UndefOr[String]
  }

  object CreateCustomerGatewayRequest {
    @inline
    def apply(
        BgpAsn: Int,
        Type: GatewayType,
        CertificateArn: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): CreateCustomerGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "BgpAsn" -> BgpAsn.asInstanceOf[js.Any],
        "Type"   -> Type.asInstanceOf[js.Any]
      )

      CertificateArn.foreach(__v => __obj.updateDynamic("CertificateArn")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      PublicIp.foreach(__v => __obj.updateDynamic("PublicIp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateCustomerGatewayRequest]
    }
  }

  /**
    * Contains the output of CreateCustomerGateway.
    */
  @js.native
  trait CreateCustomerGatewayResult extends js.Object {
    var CustomerGateway: js.UndefOr[CustomerGateway]
  }

  object CreateCustomerGatewayResult {
    @inline
    def apply(
        CustomerGateway: js.UndefOr[CustomerGateway] = js.undefined
    ): CreateCustomerGatewayResult = {
      val __obj = js.Dynamic.literal()
      CustomerGateway.foreach(__v => __obj.updateDynamic("CustomerGateway")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateCustomerGatewayResult]
    }
  }

  @js.native
  trait CreateDefaultSubnetRequest extends js.Object {
    var AvailabilityZone: String
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateDefaultSubnetRequest {
    @inline
    def apply(
        AvailabilityZone: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateDefaultSubnetRequest = {
      val __obj = js.Dynamic.literal(
        "AvailabilityZone" -> AvailabilityZone.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateDefaultSubnetRequest]
    }
  }

  @js.native
  trait CreateDefaultSubnetResult extends js.Object {
    var Subnet: js.UndefOr[Subnet]
  }

  object CreateDefaultSubnetResult {
    @inline
    def apply(
        Subnet: js.UndefOr[Subnet] = js.undefined
    ): CreateDefaultSubnetResult = {
      val __obj = js.Dynamic.literal()
      Subnet.foreach(__v => __obj.updateDynamic("Subnet")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateDefaultSubnetResult]
    }
  }

  @js.native
  trait CreateDefaultVpcRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateDefaultVpcRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateDefaultVpcRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateDefaultVpcRequest]
    }
  }

  @js.native
  trait CreateDefaultVpcResult extends js.Object {
    var Vpc: js.UndefOr[Vpc]
  }

  object CreateDefaultVpcResult {
    @inline
    def apply(
        Vpc: js.UndefOr[Vpc] = js.undefined
    ): CreateDefaultVpcResult = {
      val __obj = js.Dynamic.literal()
      Vpc.foreach(__v => __obj.updateDynamic("Vpc")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateDefaultVpcResult]
    }
  }

  @js.native
  trait CreateDhcpOptionsRequest extends js.Object {
    var DhcpConfigurations: NewDhcpConfigurationList
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateDhcpOptionsRequest {
    @inline
    def apply(
        DhcpConfigurations: NewDhcpConfigurationList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateDhcpOptionsRequest = {
      val __obj = js.Dynamic.literal(
        "DhcpConfigurations" -> DhcpConfigurations.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateDhcpOptionsRequest]
    }
  }

  @js.native
  trait CreateDhcpOptionsResult extends js.Object {
    var DhcpOptions: js.UndefOr[DhcpOptions]
  }

  object CreateDhcpOptionsResult {
    @inline
    def apply(
        DhcpOptions: js.UndefOr[DhcpOptions] = js.undefined
    ): CreateDhcpOptionsResult = {
      val __obj = js.Dynamic.literal()
      DhcpOptions.foreach(__v => __obj.updateDynamic("DhcpOptions")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateDhcpOptionsResult]
    }
  }

  @js.native
  trait CreateEgressOnlyInternetGatewayRequest extends js.Object {
    var VpcId: String
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateEgressOnlyInternetGatewayRequest {
    @inline
    def apply(
        VpcId: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateEgressOnlyInternetGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "VpcId" -> VpcId.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateEgressOnlyInternetGatewayRequest]
    }
  }

  @js.native
  trait CreateEgressOnlyInternetGatewayResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var EgressOnlyInternetGateway: js.UndefOr[EgressOnlyInternetGateway]
  }

  object CreateEgressOnlyInternetGatewayResult {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        EgressOnlyInternetGateway: js.UndefOr[EgressOnlyInternetGateway] = js.undefined
    ): CreateEgressOnlyInternetGatewayResult = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      EgressOnlyInternetGateway.foreach(
        __v => __obj.updateDynamic("EgressOnlyInternetGateway")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[CreateEgressOnlyInternetGatewayResult]
    }
  }

  /**
    * Describes the instances that could not be launched by the fleet.
    */
  @js.native
  trait CreateFleetError extends js.Object {
    var ErrorCode: js.UndefOr[String]
    var ErrorMessage: js.UndefOr[String]
    var LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse]
    var Lifecycle: js.UndefOr[InstanceLifecycle]
  }

  object CreateFleetError {
    @inline
    def apply(
        ErrorCode: js.UndefOr[String] = js.undefined,
        ErrorMessage: js.UndefOr[String] = js.undefined,
        LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse] = js.undefined,
        Lifecycle: js.UndefOr[InstanceLifecycle] = js.undefined
    ): CreateFleetError = {
      val __obj = js.Dynamic.literal()
      ErrorCode.foreach(__v => __obj.updateDynamic("ErrorCode")(__v.asInstanceOf[js.Any]))
      ErrorMessage.foreach(__v => __obj.updateDynamic("ErrorMessage")(__v.asInstanceOf[js.Any]))
      LaunchTemplateAndOverrides.foreach(
        __v => __obj.updateDynamic("LaunchTemplateAndOverrides")(__v.asInstanceOf[js.Any])
      )
      Lifecycle.foreach(__v => __obj.updateDynamic("Lifecycle")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateFleetError]
    }
  }

  /**
    * Describes the instances that were launched by the fleet.
    */
  @js.native
  trait CreateFleetInstance extends js.Object {
    var InstanceIds: js.UndefOr[InstanceIdsSet]
    var InstanceType: js.UndefOr[InstanceType]
    var LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse]
    var Lifecycle: js.UndefOr[InstanceLifecycle]
    var Platform: js.UndefOr[PlatformValues]
  }

  object CreateFleetInstance {
    @inline
    def apply(
        InstanceIds: js.UndefOr[InstanceIdsSet] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse] = js.undefined,
        Lifecycle: js.UndefOr[InstanceLifecycle] = js.undefined,
        Platform: js.UndefOr[PlatformValues] = js.undefined
    ): CreateFleetInstance = {
      val __obj = js.Dynamic.literal()
      InstanceIds.foreach(__v => __obj.updateDynamic("InstanceIds")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      LaunchTemplateAndOverrides.foreach(
        __v => __obj.updateDynamic("LaunchTemplateAndOverrides")(__v.asInstanceOf[js.Any])
      )
      Lifecycle.foreach(__v => __obj.updateDynamic("Lifecycle")(__v.asInstanceOf[js.Any]))
      Platform.foreach(__v => __obj.updateDynamic("Platform")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateFleetInstance]
    }
  }

  @js.native
  trait CreateFleetRequest extends js.Object {
    var LaunchTemplateConfigs: FleetLaunchTemplateConfigListRequest
    var TargetCapacitySpecification: TargetCapacitySpecificationRequest
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var ExcessCapacityTerminationPolicy: js.UndefOr[FleetExcessCapacityTerminationPolicy]
    var OnDemandOptions: js.UndefOr[OnDemandOptionsRequest]
    var ReplaceUnhealthyInstances: js.UndefOr[Boolean]
    var SpotOptions: js.UndefOr[SpotOptionsRequest]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
    var TerminateInstancesWithExpiration: js.UndefOr[Boolean]
    var Type: js.UndefOr[FleetType]
    var ValidFrom: js.UndefOr[DateTime]
    var ValidUntil: js.UndefOr[DateTime]
  }

  object CreateFleetRequest {
    @inline
    def apply(
        LaunchTemplateConfigs: FleetLaunchTemplateConfigListRequest,
        TargetCapacitySpecification: TargetCapacitySpecificationRequest,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ExcessCapacityTerminationPolicy: js.UndefOr[FleetExcessCapacityTerminationPolicy] = js.undefined,
        OnDemandOptions: js.UndefOr[OnDemandOptionsRequest] = js.undefined,
        ReplaceUnhealthyInstances: js.UndefOr[Boolean] = js.undefined,
        SpotOptions: js.UndefOr[SpotOptionsRequest] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined,
        TerminateInstancesWithExpiration: js.UndefOr[Boolean] = js.undefined,
        Type: js.UndefOr[FleetType] = js.undefined,
        ValidFrom: js.UndefOr[DateTime] = js.undefined,
        ValidUntil: js.UndefOr[DateTime] = js.undefined
    ): CreateFleetRequest = {
      val __obj = js.Dynamic.literal(
        "LaunchTemplateConfigs"       -> LaunchTemplateConfigs.asInstanceOf[js.Any],
        "TargetCapacitySpecification" -> TargetCapacitySpecification.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      ExcessCapacityTerminationPolicy.foreach(
        __v => __obj.updateDynamic("ExcessCapacityTerminationPolicy")(__v.asInstanceOf[js.Any])
      )
      OnDemandOptions.foreach(__v => __obj.updateDynamic("OnDemandOptions")(__v.asInstanceOf[js.Any]))
      ReplaceUnhealthyInstances.foreach(
        __v => __obj.updateDynamic("ReplaceUnhealthyInstances")(__v.asInstanceOf[js.Any])
      )
      SpotOptions.foreach(__v => __obj.updateDynamic("SpotOptions")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      TerminateInstancesWithExpiration.foreach(
        __v => __obj.updateDynamic("TerminateInstancesWithExpiration")(__v.asInstanceOf[js.Any])
      )
      Type.foreach(__v => __obj.updateDynamic("Type")(__v.asInstanceOf[js.Any]))
      ValidFrom.foreach(__v => __obj.updateDynamic("ValidFrom")(__v.asInstanceOf[js.Any]))
      ValidUntil.foreach(__v => __obj.updateDynamic("ValidUntil")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateFleetRequest]
    }
  }

  @js.native
  trait CreateFleetResult extends js.Object {
    var Errors: js.UndefOr[CreateFleetErrorsSet]
    var FleetId: js.UndefOr[FleetIdentifier]
    var Instances: js.UndefOr[CreateFleetInstancesSet]
  }

  object CreateFleetResult {
    @inline
    def apply(
        Errors: js.UndefOr[CreateFleetErrorsSet] = js.undefined,
        FleetId: js.UndefOr[FleetIdentifier] = js.undefined,
        Instances: js.UndefOr[CreateFleetInstancesSet] = js.undefined
    ): CreateFleetResult = {
      val __obj = js.Dynamic.literal()
      Errors.foreach(__v => __obj.updateDynamic("Errors")(__v.asInstanceOf[js.Any]))
      FleetId.foreach(__v => __obj.updateDynamic("FleetId")(__v.asInstanceOf[js.Any]))
      Instances.foreach(__v => __obj.updateDynamic("Instances")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateFleetResult]
    }
  }

  @js.native
  trait CreateFlowLogsRequest extends js.Object {
    var ResourceIds: ValueStringList
    var ResourceType: FlowLogsResourceType
    var TrafficType: TrafficType
    var ClientToken: js.UndefOr[String]
    var DeliverLogsPermissionArn: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var LogDestination: js.UndefOr[String]
    var LogDestinationType: js.UndefOr[LogDestinationType]
    var LogGroupName: js.UndefOr[String]
  }

  object CreateFlowLogsRequest {
    @inline
    def apply(
        ResourceIds: ValueStringList,
        ResourceType: FlowLogsResourceType,
        TrafficType: TrafficType,
        ClientToken: js.UndefOr[String] = js.undefined,
        DeliverLogsPermissionArn: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LogDestination: js.UndefOr[String] = js.undefined,
        LogDestinationType: js.UndefOr[LogDestinationType] = js.undefined,
        LogGroupName: js.UndefOr[String] = js.undefined
    ): CreateFlowLogsRequest = {
      val __obj = js.Dynamic.literal(
        "ResourceIds"  -> ResourceIds.asInstanceOf[js.Any],
        "ResourceType" -> ResourceType.asInstanceOf[js.Any],
        "TrafficType"  -> TrafficType.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      DeliverLogsPermissionArn.foreach(__v => __obj.updateDynamic("DeliverLogsPermissionArn")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      LogDestination.foreach(__v => __obj.updateDynamic("LogDestination")(__v.asInstanceOf[js.Any]))
      LogDestinationType.foreach(__v => __obj.updateDynamic("LogDestinationType")(__v.asInstanceOf[js.Any]))
      LogGroupName.foreach(__v => __obj.updateDynamic("LogGroupName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateFlowLogsRequest]
    }
  }

  @js.native
  trait CreateFlowLogsResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var FlowLogIds: js.UndefOr[ValueStringList]
    var Unsuccessful: js.UndefOr[UnsuccessfulItemSet]
  }

  object CreateFlowLogsResult {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        FlowLogIds: js.UndefOr[ValueStringList] = js.undefined,
        Unsuccessful: js.UndefOr[UnsuccessfulItemSet] = js.undefined
    ): CreateFlowLogsResult = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      FlowLogIds.foreach(__v => __obj.updateDynamic("FlowLogIds")(__v.asInstanceOf[js.Any]))
      Unsuccessful.foreach(__v => __obj.updateDynamic("Unsuccessful")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateFlowLogsResult]
    }
  }

  @js.native
  trait CreateFpgaImageRequest extends js.Object {
    var InputStorageLocation: StorageLocation
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var LogsStorageLocation: js.UndefOr[StorageLocation]
    var Name: js.UndefOr[String]
  }

  object CreateFpgaImageRequest {
    @inline
    def apply(
        InputStorageLocation: StorageLocation,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LogsStorageLocation: js.UndefOr[StorageLocation] = js.undefined,
        Name: js.UndefOr[String] = js.undefined
    ): CreateFpgaImageRequest = {
      val __obj = js.Dynamic.literal(
        "InputStorageLocation" -> InputStorageLocation.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      LogsStorageLocation.foreach(__v => __obj.updateDynamic("LogsStorageLocation")(__v.asInstanceOf[js.Any]))
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateFpgaImageRequest]
    }
  }

  @js.native
  trait CreateFpgaImageResult extends js.Object {
    var FpgaImageGlobalId: js.UndefOr[String]
    var FpgaImageId: js.UndefOr[String]
  }

  object CreateFpgaImageResult {
    @inline
    def apply(
        FpgaImageGlobalId: js.UndefOr[String] = js.undefined,
        FpgaImageId: js.UndefOr[String] = js.undefined
    ): CreateFpgaImageResult = {
      val __obj = js.Dynamic.literal()
      FpgaImageGlobalId.foreach(__v => __obj.updateDynamic("FpgaImageGlobalId")(__v.asInstanceOf[js.Any]))
      FpgaImageId.foreach(__v => __obj.updateDynamic("FpgaImageId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateFpgaImageResult]
    }
  }

  @js.native
  trait CreateImageRequest extends js.Object {
    var InstanceId: String
    var Name: String
    var BlockDeviceMappings: js.UndefOr[BlockDeviceMappingRequestList]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var NoReboot: js.UndefOr[Boolean]
  }

  object CreateImageRequest {
    @inline
    def apply(
        InstanceId: String,
        Name: String,
        BlockDeviceMappings: js.UndefOr[BlockDeviceMappingRequestList] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        NoReboot: js.UndefOr[Boolean] = js.undefined
    ): CreateImageRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "Name"       -> Name.asInstanceOf[js.Any]
      )

      BlockDeviceMappings.foreach(__v => __obj.updateDynamic("BlockDeviceMappings")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      NoReboot.foreach(__v => __obj.updateDynamic("NoReboot")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateImageRequest]
    }
  }

  @js.native
  trait CreateImageResult extends js.Object {
    var ImageId: js.UndefOr[String]
  }

  object CreateImageResult {
    @inline
    def apply(
        ImageId: js.UndefOr[String] = js.undefined
    ): CreateImageResult = {
      val __obj = js.Dynamic.literal()
      ImageId.foreach(__v => __obj.updateDynamic("ImageId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateImageResult]
    }
  }

  @js.native
  trait CreateInstanceExportTaskRequest extends js.Object {
    var InstanceId: String
    var Description: js.UndefOr[String]
    var ExportToS3Task: js.UndefOr[ExportToS3TaskSpecification]
    var TargetEnvironment: js.UndefOr[ExportEnvironment]
  }

  object CreateInstanceExportTaskRequest {
    @inline
    def apply(
        InstanceId: String,
        Description: js.UndefOr[String] = js.undefined,
        ExportToS3Task: js.UndefOr[ExportToS3TaskSpecification] = js.undefined,
        TargetEnvironment: js.UndefOr[ExportEnvironment] = js.undefined
    ): CreateInstanceExportTaskRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceId" -> InstanceId.asInstanceOf[js.Any]
      )

      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      ExportToS3Task.foreach(__v => __obj.updateDynamic("ExportToS3Task")(__v.asInstanceOf[js.Any]))
      TargetEnvironment.foreach(__v => __obj.updateDynamic("TargetEnvironment")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateInstanceExportTaskRequest]
    }
  }

  @js.native
  trait CreateInstanceExportTaskResult extends js.Object {
    var ExportTask: js.UndefOr[ExportTask]
  }

  object CreateInstanceExportTaskResult {
    @inline
    def apply(
        ExportTask: js.UndefOr[ExportTask] = js.undefined
    ): CreateInstanceExportTaskResult = {
      val __obj = js.Dynamic.literal()
      ExportTask.foreach(__v => __obj.updateDynamic("ExportTask")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateInstanceExportTaskResult]
    }
  }

  @js.native
  trait CreateInternetGatewayRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateInternetGatewayRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateInternetGatewayRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateInternetGatewayRequest]
    }
  }

  @js.native
  trait CreateInternetGatewayResult extends js.Object {
    var InternetGateway: js.UndefOr[InternetGateway]
  }

  object CreateInternetGatewayResult {
    @inline
    def apply(
        InternetGateway: js.UndefOr[InternetGateway] = js.undefined
    ): CreateInternetGatewayResult = {
      val __obj = js.Dynamic.literal()
      InternetGateway.foreach(__v => __obj.updateDynamic("InternetGateway")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateInternetGatewayResult]
    }
  }

  @js.native
  trait CreateKeyPairRequest extends js.Object {
    var KeyName: String
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateKeyPairRequest {
    @inline
    def apply(
        KeyName: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateKeyPairRequest = {
      val __obj = js.Dynamic.literal(
        "KeyName" -> KeyName.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateKeyPairRequest]
    }
  }

  @js.native
  trait CreateLaunchTemplateRequest extends js.Object {
    var LaunchTemplateData: RequestLaunchTemplateData
    var LaunchTemplateName: LaunchTemplateName
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
    var VersionDescription: js.UndefOr[VersionDescription]
  }

  object CreateLaunchTemplateRequest {
    @inline
    def apply(
        LaunchTemplateData: RequestLaunchTemplateData,
        LaunchTemplateName: LaunchTemplateName,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined,
        VersionDescription: js.UndefOr[VersionDescription] = js.undefined
    ): CreateLaunchTemplateRequest = {
      val __obj = js.Dynamic.literal(
        "LaunchTemplateData" -> LaunchTemplateData.asInstanceOf[js.Any],
        "LaunchTemplateName" -> LaunchTemplateName.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      VersionDescription.foreach(__v => __obj.updateDynamic("VersionDescription")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateLaunchTemplateRequest]
    }
  }

  @js.native
  trait CreateLaunchTemplateResult extends js.Object {
    var LaunchTemplate: js.UndefOr[LaunchTemplate]
  }

  object CreateLaunchTemplateResult {
    @inline
    def apply(
        LaunchTemplate: js.UndefOr[LaunchTemplate] = js.undefined
    ): CreateLaunchTemplateResult = {
      val __obj = js.Dynamic.literal()
      LaunchTemplate.foreach(__v => __obj.updateDynamic("LaunchTemplate")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateLaunchTemplateResult]
    }
  }

  @js.native
  trait CreateLaunchTemplateVersionRequest extends js.Object {
    var LaunchTemplateData: RequestLaunchTemplateData
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
    var SourceVersion: js.UndefOr[String]
    var VersionDescription: js.UndefOr[VersionDescription]
  }

  object CreateLaunchTemplateVersionRequest {
    @inline
    def apply(
        LaunchTemplateData: RequestLaunchTemplateData,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined,
        SourceVersion: js.UndefOr[String] = js.undefined,
        VersionDescription: js.UndefOr[VersionDescription] = js.undefined
    ): CreateLaunchTemplateVersionRequest = {
      val __obj = js.Dynamic.literal(
        "LaunchTemplateData" -> LaunchTemplateData.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      LaunchTemplateId.foreach(__v => __obj.updateDynamic("LaunchTemplateId")(__v.asInstanceOf[js.Any]))
      LaunchTemplateName.foreach(__v => __obj.updateDynamic("LaunchTemplateName")(__v.asInstanceOf[js.Any]))
      SourceVersion.foreach(__v => __obj.updateDynamic("SourceVersion")(__v.asInstanceOf[js.Any]))
      VersionDescription.foreach(__v => __obj.updateDynamic("VersionDescription")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateLaunchTemplateVersionRequest]
    }
  }

  @js.native
  trait CreateLaunchTemplateVersionResult extends js.Object {
    var LaunchTemplateVersion: js.UndefOr[LaunchTemplateVersion]
  }

  object CreateLaunchTemplateVersionResult {
    @inline
    def apply(
        LaunchTemplateVersion: js.UndefOr[LaunchTemplateVersion] = js.undefined
    ): CreateLaunchTemplateVersionResult = {
      val __obj = js.Dynamic.literal()
      LaunchTemplateVersion.foreach(__v => __obj.updateDynamic("LaunchTemplateVersion")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateLaunchTemplateVersionResult]
    }
  }

  @js.native
  trait CreateNatGatewayRequest extends js.Object {
    var AllocationId: String
    var SubnetId: String
    var ClientToken: js.UndefOr[String]
  }

  object CreateNatGatewayRequest {
    @inline
    def apply(
        AllocationId: String,
        SubnetId: String,
        ClientToken: js.UndefOr[String] = js.undefined
    ): CreateNatGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "AllocationId" -> AllocationId.asInstanceOf[js.Any],
        "SubnetId"     -> SubnetId.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateNatGatewayRequest]
    }
  }

  @js.native
  trait CreateNatGatewayResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var NatGateway: js.UndefOr[NatGateway]
  }

  object CreateNatGatewayResult {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        NatGateway: js.UndefOr[NatGateway] = js.undefined
    ): CreateNatGatewayResult = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      NatGateway.foreach(__v => __obj.updateDynamic("NatGateway")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateNatGatewayResult]
    }
  }

  @js.native
  trait CreateNetworkAclEntryRequest extends js.Object {
    var Egress: Boolean
    var NetworkAclId: String
    var Protocol: String
    var RuleAction: RuleAction
    var RuleNumber: Int
    var CidrBlock: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var IcmpTypeCode: js.UndefOr[IcmpTypeCode]
    var Ipv6CidrBlock: js.UndefOr[String]
    var PortRange: js.UndefOr[PortRange]
  }

  object CreateNetworkAclEntryRequest {
    @inline
    def apply(
        Egress: Boolean,
        NetworkAclId: String,
        Protocol: String,
        RuleAction: RuleAction,
        RuleNumber: Int,
        CidrBlock: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        IcmpTypeCode: js.UndefOr[IcmpTypeCode] = js.undefined,
        Ipv6CidrBlock: js.UndefOr[String] = js.undefined,
        PortRange: js.UndefOr[PortRange] = js.undefined
    ): CreateNetworkAclEntryRequest = {
      val __obj = js.Dynamic.literal(
        "Egress"       -> Egress.asInstanceOf[js.Any],
        "NetworkAclId" -> NetworkAclId.asInstanceOf[js.Any],
        "Protocol"     -> Protocol.asInstanceOf[js.Any],
        "RuleAction"   -> RuleAction.asInstanceOf[js.Any],
        "RuleNumber"   -> RuleNumber.asInstanceOf[js.Any]
      )

      CidrBlock.foreach(__v => __obj.updateDynamic("CidrBlock")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      IcmpTypeCode.foreach(__v => __obj.updateDynamic("IcmpTypeCode")(__v.asInstanceOf[js.Any]))
      Ipv6CidrBlock.foreach(__v => __obj.updateDynamic("Ipv6CidrBlock")(__v.asInstanceOf[js.Any]))
      PortRange.foreach(__v => __obj.updateDynamic("PortRange")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateNetworkAclEntryRequest]
    }
  }

  @js.native
  trait CreateNetworkAclRequest extends js.Object {
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateNetworkAclRequest {
    @inline
    def apply(
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateNetworkAclRequest = {
      val __obj = js.Dynamic.literal(
        "VpcId" -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateNetworkAclRequest]
    }
  }

  @js.native
  trait CreateNetworkAclResult extends js.Object {
    var NetworkAcl: js.UndefOr[NetworkAcl]
  }

  object CreateNetworkAclResult {
    @inline
    def apply(
        NetworkAcl: js.UndefOr[NetworkAcl] = js.undefined
    ): CreateNetworkAclResult = {
      val __obj = js.Dynamic.literal()
      NetworkAcl.foreach(__v => __obj.updateDynamic("NetworkAcl")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateNetworkAclResult]
    }
  }

  /**
    * Contains the parameters for CreateNetworkInterfacePermission.
    */
  @js.native
  trait CreateNetworkInterfacePermissionRequest extends js.Object {
    var NetworkInterfaceId: String
    var Permission: InterfacePermissionType
    var AwsAccountId: js.UndefOr[String]
    var AwsService: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateNetworkInterfacePermissionRequest {
    @inline
    def apply(
        NetworkInterfaceId: String,
        Permission: InterfacePermissionType,
        AwsAccountId: js.UndefOr[String] = js.undefined,
        AwsService: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateNetworkInterfacePermissionRequest = {
      val __obj = js.Dynamic.literal(
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any],
        "Permission"         -> Permission.asInstanceOf[js.Any]
      )

      AwsAccountId.foreach(__v => __obj.updateDynamic("AwsAccountId")(__v.asInstanceOf[js.Any]))
      AwsService.foreach(__v => __obj.updateDynamic("AwsService")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateNetworkInterfacePermissionRequest]
    }
  }

  /**
    * Contains the output of CreateNetworkInterfacePermission.
    */
  @js.native
  trait CreateNetworkInterfacePermissionResult extends js.Object {
    var InterfacePermission: js.UndefOr[NetworkInterfacePermission]
  }

  object CreateNetworkInterfacePermissionResult {
    @inline
    def apply(
        InterfacePermission: js.UndefOr[NetworkInterfacePermission] = js.undefined
    ): CreateNetworkInterfacePermissionResult = {
      val __obj = js.Dynamic.literal()
      InterfacePermission.foreach(__v => __obj.updateDynamic("InterfacePermission")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateNetworkInterfacePermissionResult]
    }
  }

  /**
    * Contains the parameters for CreateNetworkInterface.
    */
  @js.native
  trait CreateNetworkInterfaceRequest extends js.Object {
    var SubnetId: String
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Groups: js.UndefOr[SecurityGroupIdStringList]
    var InterfaceType: js.UndefOr[NetworkInterfaceCreationType]
    var Ipv6AddressCount: js.UndefOr[Int]
    var Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList]
    var PrivateIpAddress: js.UndefOr[String]
    var PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList]
    var SecondaryPrivateIpAddressCount: js.UndefOr[Int]
  }

  object CreateNetworkInterfaceRequest {
    @inline
    def apply(
        SubnetId: String,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Groups: js.UndefOr[SecurityGroupIdStringList] = js.undefined,
        InterfaceType: js.UndefOr[NetworkInterfaceCreationType] = js.undefined,
        Ipv6AddressCount: js.UndefOr[Int] = js.undefined,
        Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList] = js.undefined,
        SecondaryPrivateIpAddressCount: js.UndefOr[Int] = js.undefined
    ): CreateNetworkInterfaceRequest = {
      val __obj = js.Dynamic.literal(
        "SubnetId" -> SubnetId.asInstanceOf[js.Any]
      )

      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Groups.foreach(__v => __obj.updateDynamic("Groups")(__v.asInstanceOf[js.Any]))
      InterfaceType.foreach(__v => __obj.updateDynamic("InterfaceType")(__v.asInstanceOf[js.Any]))
      Ipv6AddressCount.foreach(__v => __obj.updateDynamic("Ipv6AddressCount")(__v.asInstanceOf[js.Any]))
      Ipv6Addresses.foreach(__v => __obj.updateDynamic("Ipv6Addresses")(__v.asInstanceOf[js.Any]))
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      PrivateIpAddresses.foreach(__v => __obj.updateDynamic("PrivateIpAddresses")(__v.asInstanceOf[js.Any]))
      SecondaryPrivateIpAddressCount.foreach(
        __v => __obj.updateDynamic("SecondaryPrivateIpAddressCount")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[CreateNetworkInterfaceRequest]
    }
  }

  /**
    * Contains the output of CreateNetworkInterface.
    */
  @js.native
  trait CreateNetworkInterfaceResult extends js.Object {
    var NetworkInterface: js.UndefOr[NetworkInterface]
  }

  object CreateNetworkInterfaceResult {
    @inline
    def apply(
        NetworkInterface: js.UndefOr[NetworkInterface] = js.undefined
    ): CreateNetworkInterfaceResult = {
      val __obj = js.Dynamic.literal()
      NetworkInterface.foreach(__v => __obj.updateDynamic("NetworkInterface")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateNetworkInterfaceResult]
    }
  }

  @js.native
  trait CreatePlacementGroupRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var GroupName: js.UndefOr[String]
    var PartitionCount: js.UndefOr[Int]
    var Strategy: js.UndefOr[PlacementStrategy]
  }

  object CreatePlacementGroupRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined,
        PartitionCount: js.UndefOr[Int] = js.undefined,
        Strategy: js.UndefOr[PlacementStrategy] = js.undefined
    ): CreatePlacementGroupRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      GroupName.foreach(__v => __obj.updateDynamic("GroupName")(__v.asInstanceOf[js.Any]))
      PartitionCount.foreach(__v => __obj.updateDynamic("PartitionCount")(__v.asInstanceOf[js.Any]))
      Strategy.foreach(__v => __obj.updateDynamic("Strategy")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreatePlacementGroupRequest]
    }
  }

  /**
    * Contains the parameters for CreateReservedInstancesListing.
    */
  @js.native
  trait CreateReservedInstancesListingRequest extends js.Object {
    var ClientToken: String
    var InstanceCount: Int
    var PriceSchedules: PriceScheduleSpecificationList
    var ReservedInstancesId: String
  }

  object CreateReservedInstancesListingRequest {
    @inline
    def apply(
        ClientToken: String,
        InstanceCount: Int,
        PriceSchedules: PriceScheduleSpecificationList,
        ReservedInstancesId: String
    ): CreateReservedInstancesListingRequest = {
      val __obj = js.Dynamic.literal(
        "ClientToken"         -> ClientToken.asInstanceOf[js.Any],
        "InstanceCount"       -> InstanceCount.asInstanceOf[js.Any],
        "PriceSchedules"      -> PriceSchedules.asInstanceOf[js.Any],
        "ReservedInstancesId" -> ReservedInstancesId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[CreateReservedInstancesListingRequest]
    }
  }

  /**
    * Contains the output of CreateReservedInstancesListing.
    */
  @js.native
  trait CreateReservedInstancesListingResult extends js.Object {
    var ReservedInstancesListings: js.UndefOr[ReservedInstancesListingList]
  }

  object CreateReservedInstancesListingResult {
    @inline
    def apply(
        ReservedInstancesListings: js.UndefOr[ReservedInstancesListingList] = js.undefined
    ): CreateReservedInstancesListingResult = {
      val __obj = js.Dynamic.literal()
      ReservedInstancesListings.foreach(
        __v => __obj.updateDynamic("ReservedInstancesListings")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[CreateReservedInstancesListingResult]
    }
  }

  @js.native
  trait CreateRouteRequest extends js.Object {
    var RouteTableId: String
    var DestinationCidrBlock: js.UndefOr[String]
    var DestinationIpv6CidrBlock: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var EgressOnlyInternetGatewayId: js.UndefOr[String]
    var GatewayId: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
    var NatGatewayId: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var TransitGatewayId: js.UndefOr[String]
    var VpcPeeringConnectionId: js.UndefOr[String]
  }

  object CreateRouteRequest {
    @inline
    def apply(
        RouteTableId: String,
        DestinationCidrBlock: js.UndefOr[String] = js.undefined,
        DestinationIpv6CidrBlock: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EgressOnlyInternetGatewayId: js.UndefOr[String] = js.undefined,
        GatewayId: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        NatGatewayId: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        TransitGatewayId: js.UndefOr[String] = js.undefined,
        VpcPeeringConnectionId: js.UndefOr[String] = js.undefined
    ): CreateRouteRequest = {
      val __obj = js.Dynamic.literal(
        "RouteTableId" -> RouteTableId.asInstanceOf[js.Any]
      )

      DestinationCidrBlock.foreach(__v => __obj.updateDynamic("DestinationCidrBlock")(__v.asInstanceOf[js.Any]))
      DestinationIpv6CidrBlock.foreach(__v => __obj.updateDynamic("DestinationIpv6CidrBlock")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      EgressOnlyInternetGatewayId.foreach(
        __v => __obj.updateDynamic("EgressOnlyInternetGatewayId")(__v.asInstanceOf[js.Any])
      )
      GatewayId.foreach(__v => __obj.updateDynamic("GatewayId")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      NatGatewayId.foreach(__v => __obj.updateDynamic("NatGatewayId")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      TransitGatewayId.foreach(__v => __obj.updateDynamic("TransitGatewayId")(__v.asInstanceOf[js.Any]))
      VpcPeeringConnectionId.foreach(__v => __obj.updateDynamic("VpcPeeringConnectionId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateRouteRequest]
    }
  }

  @js.native
  trait CreateRouteResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object CreateRouteResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): CreateRouteResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateRouteResult]
    }
  }

  @js.native
  trait CreateRouteTableRequest extends js.Object {
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateRouteTableRequest {
    @inline
    def apply(
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateRouteTableRequest = {
      val __obj = js.Dynamic.literal(
        "VpcId" -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateRouteTableRequest]
    }
  }

  @js.native
  trait CreateRouteTableResult extends js.Object {
    var RouteTable: js.UndefOr[RouteTable]
  }

  object CreateRouteTableResult {
    @inline
    def apply(
        RouteTable: js.UndefOr[RouteTable] = js.undefined
    ): CreateRouteTableResult = {
      val __obj = js.Dynamic.literal()
      RouteTable.foreach(__v => __obj.updateDynamic("RouteTable")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateRouteTableResult]
    }
  }

  @js.native
  trait CreateSecurityGroupRequest extends js.Object {
    var Description: String
    var GroupName: String
    var DryRun: js.UndefOr[Boolean]
    var VpcId: js.UndefOr[String]
  }

  object CreateSecurityGroupRequest {
    @inline
    def apply(
        Description: String,
        GroupName: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): CreateSecurityGroupRequest = {
      val __obj = js.Dynamic.literal(
        "Description" -> Description.asInstanceOf[js.Any],
        "GroupName"   -> GroupName.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateSecurityGroupRequest]
    }
  }

  @js.native
  trait CreateSecurityGroupResult extends js.Object {
    var GroupId: js.UndefOr[String]
  }

  object CreateSecurityGroupResult {
    @inline
    def apply(
        GroupId: js.UndefOr[String] = js.undefined
    ): CreateSecurityGroupResult = {
      val __obj = js.Dynamic.literal()
      GroupId.foreach(__v => __obj.updateDynamic("GroupId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateSecurityGroupResult]
    }
  }

  /**
    * Contains the parameters for CreateSnapshot.
    */
  @js.native
  trait CreateSnapshotRequest extends js.Object {
    var VolumeId: String
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object CreateSnapshotRequest {
    @inline
    def apply(
        VolumeId: String,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): CreateSnapshotRequest = {
      val __obj = js.Dynamic.literal(
        "VolumeId" -> VolumeId.asInstanceOf[js.Any]
      )

      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateSnapshotRequest]
    }
  }

  @js.native
  trait CreateSnapshotsRequest extends js.Object {
    var InstanceSpecification: InstanceSpecification
    var CopyTagsFromSource: js.UndefOr[CopyTagsFromSource]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object CreateSnapshotsRequest {
    @inline
    def apply(
        InstanceSpecification: InstanceSpecification,
        CopyTagsFromSource: js.UndefOr[CopyTagsFromSource] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): CreateSnapshotsRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceSpecification" -> InstanceSpecification.asInstanceOf[js.Any]
      )

      CopyTagsFromSource.foreach(__v => __obj.updateDynamic("CopyTagsFromSource")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateSnapshotsRequest]
    }
  }

  @js.native
  trait CreateSnapshotsResult extends js.Object {
    var Snapshots: js.UndefOr[SnapshotSet]
  }

  object CreateSnapshotsResult {
    @inline
    def apply(
        Snapshots: js.UndefOr[SnapshotSet] = js.undefined
    ): CreateSnapshotsResult = {
      val __obj = js.Dynamic.literal()
      Snapshots.foreach(__v => __obj.updateDynamic("Snapshots")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateSnapshotsResult]
    }
  }

  /**
    * Contains the parameters for CreateSpotDatafeedSubscription.
    */
  @js.native
  trait CreateSpotDatafeedSubscriptionRequest extends js.Object {
    var Bucket: String
    var DryRun: js.UndefOr[Boolean]
    var Prefix: js.UndefOr[String]
  }

  object CreateSpotDatafeedSubscriptionRequest {
    @inline
    def apply(
        Bucket: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Prefix: js.UndefOr[String] = js.undefined
    ): CreateSpotDatafeedSubscriptionRequest = {
      val __obj = js.Dynamic.literal(
        "Bucket" -> Bucket.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Prefix.foreach(__v => __obj.updateDynamic("Prefix")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateSpotDatafeedSubscriptionRequest]
    }
  }

  /**
    * Contains the output of CreateSpotDatafeedSubscription.
    */
  @js.native
  trait CreateSpotDatafeedSubscriptionResult extends js.Object {
    var SpotDatafeedSubscription: js.UndefOr[SpotDatafeedSubscription]
  }

  object CreateSpotDatafeedSubscriptionResult {
    @inline
    def apply(
        SpotDatafeedSubscription: js.UndefOr[SpotDatafeedSubscription] = js.undefined
    ): CreateSpotDatafeedSubscriptionResult = {
      val __obj = js.Dynamic.literal()
      SpotDatafeedSubscription.foreach(__v => __obj.updateDynamic("SpotDatafeedSubscription")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateSpotDatafeedSubscriptionResult]
    }
  }

  @js.native
  trait CreateSubnetRequest extends js.Object {
    var CidrBlock: String
    var VpcId: String
    var AvailabilityZone: js.UndefOr[String]
    var AvailabilityZoneId: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Ipv6CidrBlock: js.UndefOr[String]
  }

  object CreateSubnetRequest {
    @inline
    def apply(
        CidrBlock: String,
        VpcId: String,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        AvailabilityZoneId: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Ipv6CidrBlock: js.UndefOr[String] = js.undefined
    ): CreateSubnetRequest = {
      val __obj = js.Dynamic.literal(
        "CidrBlock" -> CidrBlock.asInstanceOf[js.Any],
        "VpcId"     -> VpcId.asInstanceOf[js.Any]
      )

      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      AvailabilityZoneId.foreach(__v => __obj.updateDynamic("AvailabilityZoneId")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Ipv6CidrBlock.foreach(__v => __obj.updateDynamic("Ipv6CidrBlock")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateSubnetRequest]
    }
  }

  @js.native
  trait CreateSubnetResult extends js.Object {
    var Subnet: js.UndefOr[Subnet]
  }

  object CreateSubnetResult {
    @inline
    def apply(
        Subnet: js.UndefOr[Subnet] = js.undefined
    ): CreateSubnetResult = {
      val __obj = js.Dynamic.literal()
      Subnet.foreach(__v => __obj.updateDynamic("Subnet")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateSubnetResult]
    }
  }

  @js.native
  trait CreateTagsRequest extends js.Object {
    var Resources: ResourceIdList
    var Tags: TagList
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateTagsRequest {
    @inline
    def apply(
        Resources: ResourceIdList,
        Tags: TagList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateTagsRequest = {
      val __obj = js.Dynamic.literal(
        "Resources" -> Resources.asInstanceOf[js.Any],
        "Tags"      -> Tags.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTagsRequest]
    }
  }

  @js.native
  trait CreateTrafficMirrorFilterRequest extends js.Object {
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object CreateTrafficMirrorFilterRequest {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): CreateTrafficMirrorFilterRequest = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTrafficMirrorFilterRequest]
    }
  }

  @js.native
  trait CreateTrafficMirrorFilterResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var TrafficMirrorFilter: js.UndefOr[TrafficMirrorFilter]
  }

  object CreateTrafficMirrorFilterResult {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        TrafficMirrorFilter: js.UndefOr[TrafficMirrorFilter] = js.undefined
    ): CreateTrafficMirrorFilterResult = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      TrafficMirrorFilter.foreach(__v => __obj.updateDynamic("TrafficMirrorFilter")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTrafficMirrorFilterResult]
    }
  }

  @js.native
  trait CreateTrafficMirrorFilterRuleRequest extends js.Object {
    var DestinationCidrBlock: String
    var RuleAction: TrafficMirrorRuleAction
    var RuleNumber: Int
    var SourceCidrBlock: String
    var TrafficDirection: TrafficDirection
    var TrafficMirrorFilterId: String
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DestinationPortRange: js.UndefOr[TrafficMirrorPortRangeRequest]
    var DryRun: js.UndefOr[Boolean]
    var Protocol: js.UndefOr[Int]
    var SourcePortRange: js.UndefOr[TrafficMirrorPortRangeRequest]
  }

  object CreateTrafficMirrorFilterRuleRequest {
    @inline
    def apply(
        DestinationCidrBlock: String,
        RuleAction: TrafficMirrorRuleAction,
        RuleNumber: Int,
        SourceCidrBlock: String,
        TrafficDirection: TrafficDirection,
        TrafficMirrorFilterId: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DestinationPortRange: js.UndefOr[TrafficMirrorPortRangeRequest] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Protocol: js.UndefOr[Int] = js.undefined,
        SourcePortRange: js.UndefOr[TrafficMirrorPortRangeRequest] = js.undefined
    ): CreateTrafficMirrorFilterRuleRequest = {
      val __obj = js.Dynamic.literal(
        "DestinationCidrBlock"  -> DestinationCidrBlock.asInstanceOf[js.Any],
        "RuleAction"            -> RuleAction.asInstanceOf[js.Any],
        "RuleNumber"            -> RuleNumber.asInstanceOf[js.Any],
        "SourceCidrBlock"       -> SourceCidrBlock.asInstanceOf[js.Any],
        "TrafficDirection"      -> TrafficDirection.asInstanceOf[js.Any],
        "TrafficMirrorFilterId" -> TrafficMirrorFilterId.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DestinationPortRange.foreach(__v => __obj.updateDynamic("DestinationPortRange")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Protocol.foreach(__v => __obj.updateDynamic("Protocol")(__v.asInstanceOf[js.Any]))
      SourcePortRange.foreach(__v => __obj.updateDynamic("SourcePortRange")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTrafficMirrorFilterRuleRequest]
    }
  }

  @js.native
  trait CreateTrafficMirrorFilterRuleResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var TrafficMirrorFilterRule: js.UndefOr[TrafficMirrorFilterRule]
  }

  object CreateTrafficMirrorFilterRuleResult {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        TrafficMirrorFilterRule: js.UndefOr[TrafficMirrorFilterRule] = js.undefined
    ): CreateTrafficMirrorFilterRuleResult = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      TrafficMirrorFilterRule.foreach(__v => __obj.updateDynamic("TrafficMirrorFilterRule")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTrafficMirrorFilterRuleResult]
    }
  }

  @js.native
  trait CreateTrafficMirrorSessionRequest extends js.Object {
    var NetworkInterfaceId: String
    var SessionNumber: Int
    var TrafficMirrorFilterId: String
    var TrafficMirrorTargetId: String
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var PacketLength: js.UndefOr[Int]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
    var VirtualNetworkId: js.UndefOr[Int]
  }

  object CreateTrafficMirrorSessionRequest {
    @inline
    def apply(
        NetworkInterfaceId: String,
        SessionNumber: Int,
        TrafficMirrorFilterId: String,
        TrafficMirrorTargetId: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PacketLength: js.UndefOr[Int] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined,
        VirtualNetworkId: js.UndefOr[Int] = js.undefined
    ): CreateTrafficMirrorSessionRequest = {
      val __obj = js.Dynamic.literal(
        "NetworkInterfaceId"    -> NetworkInterfaceId.asInstanceOf[js.Any],
        "SessionNumber"         -> SessionNumber.asInstanceOf[js.Any],
        "TrafficMirrorFilterId" -> TrafficMirrorFilterId.asInstanceOf[js.Any],
        "TrafficMirrorTargetId" -> TrafficMirrorTargetId.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      PacketLength.foreach(__v => __obj.updateDynamic("PacketLength")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      VirtualNetworkId.foreach(__v => __obj.updateDynamic("VirtualNetworkId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTrafficMirrorSessionRequest]
    }
  }

  @js.native
  trait CreateTrafficMirrorSessionResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var TrafficMirrorSession: js.UndefOr[TrafficMirrorSession]
  }

  object CreateTrafficMirrorSessionResult {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        TrafficMirrorSession: js.UndefOr[TrafficMirrorSession] = js.undefined
    ): CreateTrafficMirrorSessionResult = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      TrafficMirrorSession.foreach(__v => __obj.updateDynamic("TrafficMirrorSession")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTrafficMirrorSessionResult]
    }
  }

  @js.native
  trait CreateTrafficMirrorTargetRequest extends js.Object {
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var NetworkInterfaceId: js.UndefOr[String]
    var NetworkLoadBalancerArn: js.UndefOr[String]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object CreateTrafficMirrorTargetRequest {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        NetworkLoadBalancerArn: js.UndefOr[String] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): CreateTrafficMirrorTargetRequest = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      NetworkLoadBalancerArn.foreach(__v => __obj.updateDynamic("NetworkLoadBalancerArn")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTrafficMirrorTargetRequest]
    }
  }

  @js.native
  trait CreateTrafficMirrorTargetResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var TrafficMirrorTarget: js.UndefOr[TrafficMirrorTarget]
  }

  object CreateTrafficMirrorTargetResult {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        TrafficMirrorTarget: js.UndefOr[TrafficMirrorTarget] = js.undefined
    ): CreateTrafficMirrorTargetResult = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      TrafficMirrorTarget.foreach(__v => __obj.updateDynamic("TrafficMirrorTarget")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTrafficMirrorTargetResult]
    }
  }

  @js.native
  trait CreateTransitGatewayRequest extends js.Object {
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Options: js.UndefOr[TransitGatewayRequestOptions]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object CreateTransitGatewayRequest {
    @inline
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Options: js.UndefOr[TransitGatewayRequestOptions] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): CreateTransitGatewayRequest = {
      val __obj = js.Dynamic.literal()
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Options.foreach(__v => __obj.updateDynamic("Options")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTransitGatewayRequest]
    }
  }

  @js.native
  trait CreateTransitGatewayResult extends js.Object {
    var TransitGateway: js.UndefOr[TransitGateway]
  }

  object CreateTransitGatewayResult {
    @inline
    def apply(
        TransitGateway: js.UndefOr[TransitGateway] = js.undefined
    ): CreateTransitGatewayResult = {
      val __obj = js.Dynamic.literal()
      TransitGateway.foreach(__v => __obj.updateDynamic("TransitGateway")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTransitGatewayResult]
    }
  }

  @js.native
  trait CreateTransitGatewayRouteRequest extends js.Object {
    var DestinationCidrBlock: String
    var TransitGatewayRouteTableId: String
    var Blackhole: js.UndefOr[Boolean]
    var DryRun: js.UndefOr[Boolean]
    var TransitGatewayAttachmentId: js.UndefOr[String]
  }

  object CreateTransitGatewayRouteRequest {
    @inline
    def apply(
        DestinationCidrBlock: String,
        TransitGatewayRouteTableId: String,
        Blackhole: js.UndefOr[Boolean] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TransitGatewayAttachmentId: js.UndefOr[String] = js.undefined
    ): CreateTransitGatewayRouteRequest = {
      val __obj = js.Dynamic.literal(
        "DestinationCidrBlock"       -> DestinationCidrBlock.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any]
      )

      Blackhole.foreach(__v => __obj.updateDynamic("Blackhole")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      TransitGatewayAttachmentId.foreach(
        __v => __obj.updateDynamic("TransitGatewayAttachmentId")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[CreateTransitGatewayRouteRequest]
    }
  }

  @js.native
  trait CreateTransitGatewayRouteResult extends js.Object {
    var Route: js.UndefOr[TransitGatewayRoute]
  }

  object CreateTransitGatewayRouteResult {
    @inline
    def apply(
        Route: js.UndefOr[TransitGatewayRoute] = js.undefined
    ): CreateTransitGatewayRouteResult = {
      val __obj = js.Dynamic.literal()
      Route.foreach(__v => __obj.updateDynamic("Route")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTransitGatewayRouteResult]
    }
  }

  @js.native
  trait CreateTransitGatewayRouteTableRequest extends js.Object {
    var TransitGatewayId: String
    var DryRun: js.UndefOr[Boolean]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object CreateTransitGatewayRouteTableRequest {
    @inline
    def apply(
        TransitGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): CreateTransitGatewayRouteTableRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayId" -> TransitGatewayId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTransitGatewayRouteTableRequest]
    }
  }

  @js.native
  trait CreateTransitGatewayRouteTableResult extends js.Object {
    var TransitGatewayRouteTable: js.UndefOr[TransitGatewayRouteTable]
  }

  object CreateTransitGatewayRouteTableResult {
    @inline
    def apply(
        TransitGatewayRouteTable: js.UndefOr[TransitGatewayRouteTable] = js.undefined
    ): CreateTransitGatewayRouteTableResult = {
      val __obj = js.Dynamic.literal()
      TransitGatewayRouteTable.foreach(__v => __obj.updateDynamic("TransitGatewayRouteTable")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTransitGatewayRouteTableResult]
    }
  }

  @js.native
  trait CreateTransitGatewayVpcAttachmentRequest extends js.Object {
    var SubnetIds: ValueStringList
    var TransitGatewayId: String
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
    var Options: js.UndefOr[CreateTransitGatewayVpcAttachmentRequestOptions]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
  }

  object CreateTransitGatewayVpcAttachmentRequest {
    @inline
    def apply(
        SubnetIds: ValueStringList,
        TransitGatewayId: String,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Options: js.UndefOr[CreateTransitGatewayVpcAttachmentRequestOptions] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined
    ): CreateTransitGatewayVpcAttachmentRequest = {
      val __obj = js.Dynamic.literal(
        "SubnetIds"        -> SubnetIds.asInstanceOf[js.Any],
        "TransitGatewayId" -> TransitGatewayId.asInstanceOf[js.Any],
        "VpcId"            -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Options.foreach(__v => __obj.updateDynamic("Options")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTransitGatewayVpcAttachmentRequest]
    }
  }

  /**
    * Describes the options for a VPC attachment.
    */
  @js.native
  trait CreateTransitGatewayVpcAttachmentRequestOptions extends js.Object {
    var DnsSupport: js.UndefOr[DnsSupportValue]
    var Ipv6Support: js.UndefOr[Ipv6SupportValue]
  }

  object CreateTransitGatewayVpcAttachmentRequestOptions {
    @inline
    def apply(
        DnsSupport: js.UndefOr[DnsSupportValue] = js.undefined,
        Ipv6Support: js.UndefOr[Ipv6SupportValue] = js.undefined
    ): CreateTransitGatewayVpcAttachmentRequestOptions = {
      val __obj = js.Dynamic.literal()
      DnsSupport.foreach(__v => __obj.updateDynamic("DnsSupport")(__v.asInstanceOf[js.Any]))
      Ipv6Support.foreach(__v => __obj.updateDynamic("Ipv6Support")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateTransitGatewayVpcAttachmentRequestOptions]
    }
  }

  @js.native
  trait CreateTransitGatewayVpcAttachmentResult extends js.Object {
    var TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment]
  }

  object CreateTransitGatewayVpcAttachmentResult {
    @inline
    def apply(
        TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment] = js.undefined
    ): CreateTransitGatewayVpcAttachmentResult = {
      val __obj = js.Dynamic.literal()
      TransitGatewayVpcAttachment.foreach(
        __v => __obj.updateDynamic("TransitGatewayVpcAttachment")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[CreateTransitGatewayVpcAttachmentResult]
    }
  }

  /**
    * Describes the user or group to be added or removed from the list of create volume permissions for a volume.
    */
  @js.native
  trait CreateVolumePermission extends js.Object {
    var Group: js.UndefOr[PermissionGroup]
    var UserId: js.UndefOr[String]
  }

  object CreateVolumePermission {
    @inline
    def apply(
        Group: js.UndefOr[PermissionGroup] = js.undefined,
        UserId: js.UndefOr[String] = js.undefined
    ): CreateVolumePermission = {
      val __obj = js.Dynamic.literal()
      Group.foreach(__v => __obj.updateDynamic("Group")(__v.asInstanceOf[js.Any]))
      UserId.foreach(__v => __obj.updateDynamic("UserId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVolumePermission]
    }
  }

  /**
    * Describes modifications to the list of create volume permissions for a volume.
    */
  @js.native
  trait CreateVolumePermissionModifications extends js.Object {
    var Add: js.UndefOr[CreateVolumePermissionList]
    var Remove: js.UndefOr[CreateVolumePermissionList]
  }

  object CreateVolumePermissionModifications {
    @inline
    def apply(
        Add: js.UndefOr[CreateVolumePermissionList] = js.undefined,
        Remove: js.UndefOr[CreateVolumePermissionList] = js.undefined
    ): CreateVolumePermissionModifications = {
      val __obj = js.Dynamic.literal()
      Add.foreach(__v => __obj.updateDynamic("Add")(__v.asInstanceOf[js.Any]))
      Remove.foreach(__v => __obj.updateDynamic("Remove")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVolumePermissionModifications]
    }
  }

  /**
    * Contains the parameters for CreateVolume.
    */
  @js.native
  trait CreateVolumeRequest extends js.Object {
    var AvailabilityZone: String
    var DryRun: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var Iops: js.UndefOr[Int]
    var KmsKeyId: js.UndefOr[String]
    var Size: js.UndefOr[Int]
    var SnapshotId: js.UndefOr[String]
    var TagSpecifications: js.UndefOr[TagSpecificationList]
    var VolumeType: js.UndefOr[VolumeType]
  }

  object CreateVolumeRequest {
    @inline
    def apply(
        AvailabilityZone: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Iops: js.UndefOr[Int] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        Size: js.UndefOr[Int] = js.undefined,
        SnapshotId: js.UndefOr[String] = js.undefined,
        TagSpecifications: js.UndefOr[TagSpecificationList] = js.undefined,
        VolumeType: js.UndefOr[VolumeType] = js.undefined
    ): CreateVolumeRequest = {
      val __obj = js.Dynamic.literal(
        "AvailabilityZone" -> AvailabilityZone.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Encrypted.foreach(__v => __obj.updateDynamic("Encrypted")(__v.asInstanceOf[js.Any]))
      Iops.foreach(__v => __obj.updateDynamic("Iops")(__v.asInstanceOf[js.Any]))
      KmsKeyId.foreach(__v => __obj.updateDynamic("KmsKeyId")(__v.asInstanceOf[js.Any]))
      Size.foreach(__v => __obj.updateDynamic("Size")(__v.asInstanceOf[js.Any]))
      SnapshotId.foreach(__v => __obj.updateDynamic("SnapshotId")(__v.asInstanceOf[js.Any]))
      TagSpecifications.foreach(__v => __obj.updateDynamic("TagSpecifications")(__v.asInstanceOf[js.Any]))
      VolumeType.foreach(__v => __obj.updateDynamic("VolumeType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVolumeRequest]
    }
  }

  @js.native
  trait CreateVpcEndpointConnectionNotificationRequest extends js.Object {
    var ConnectionEvents: ValueStringList
    var ConnectionNotificationArn: String
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var ServiceId: js.UndefOr[String]
    var VpcEndpointId: js.UndefOr[String]
  }

  object CreateVpcEndpointConnectionNotificationRequest {
    @inline
    def apply(
        ConnectionEvents: ValueStringList,
        ConnectionNotificationArn: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ServiceId: js.UndefOr[String] = js.undefined,
        VpcEndpointId: js.UndefOr[String] = js.undefined
    ): CreateVpcEndpointConnectionNotificationRequest = {
      val __obj = js.Dynamic.literal(
        "ConnectionEvents"          -> ConnectionEvents.asInstanceOf[js.Any],
        "ConnectionNotificationArn" -> ConnectionNotificationArn.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      ServiceId.foreach(__v => __obj.updateDynamic("ServiceId")(__v.asInstanceOf[js.Any]))
      VpcEndpointId.foreach(__v => __obj.updateDynamic("VpcEndpointId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpcEndpointConnectionNotificationRequest]
    }
  }

  @js.native
  trait CreateVpcEndpointConnectionNotificationResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var ConnectionNotification: js.UndefOr[ConnectionNotification]
  }

  object CreateVpcEndpointConnectionNotificationResult {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        ConnectionNotification: js.UndefOr[ConnectionNotification] = js.undefined
    ): CreateVpcEndpointConnectionNotificationResult = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      ConnectionNotification.foreach(__v => __obj.updateDynamic("ConnectionNotification")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpcEndpointConnectionNotificationResult]
    }
  }

  /**
    * Contains the parameters for CreateVpcEndpoint.
    */
  @js.native
  trait CreateVpcEndpointRequest extends js.Object {
    var ServiceName: String
    var VpcId: String
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var PolicyDocument: js.UndefOr[String]
    var PrivateDnsEnabled: js.UndefOr[Boolean]
    var RouteTableIds: js.UndefOr[ValueStringList]
    var SecurityGroupIds: js.UndefOr[ValueStringList]
    var SubnetIds: js.UndefOr[ValueStringList]
    var VpcEndpointType: js.UndefOr[VpcEndpointType]
  }

  object CreateVpcEndpointRequest {
    @inline
    def apply(
        ServiceName: String,
        VpcId: String,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PolicyDocument: js.UndefOr[String] = js.undefined,
        PrivateDnsEnabled: js.UndefOr[Boolean] = js.undefined,
        RouteTableIds: js.UndefOr[ValueStringList] = js.undefined,
        SecurityGroupIds: js.UndefOr[ValueStringList] = js.undefined,
        SubnetIds: js.UndefOr[ValueStringList] = js.undefined,
        VpcEndpointType: js.UndefOr[VpcEndpointType] = js.undefined
    ): CreateVpcEndpointRequest = {
      val __obj = js.Dynamic.literal(
        "ServiceName" -> ServiceName.asInstanceOf[js.Any],
        "VpcId"       -> VpcId.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      PolicyDocument.foreach(__v => __obj.updateDynamic("PolicyDocument")(__v.asInstanceOf[js.Any]))
      PrivateDnsEnabled.foreach(__v => __obj.updateDynamic("PrivateDnsEnabled")(__v.asInstanceOf[js.Any]))
      RouteTableIds.foreach(__v => __obj.updateDynamic("RouteTableIds")(__v.asInstanceOf[js.Any]))
      SecurityGroupIds.foreach(__v => __obj.updateDynamic("SecurityGroupIds")(__v.asInstanceOf[js.Any]))
      SubnetIds.foreach(__v => __obj.updateDynamic("SubnetIds")(__v.asInstanceOf[js.Any]))
      VpcEndpointType.foreach(__v => __obj.updateDynamic("VpcEndpointType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpcEndpointRequest]
    }
  }

  /**
    * Contains the output of CreateVpcEndpoint.
    */
  @js.native
  trait CreateVpcEndpointResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var VpcEndpoint: js.UndefOr[VpcEndpoint]
  }

  object CreateVpcEndpointResult {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        VpcEndpoint: js.UndefOr[VpcEndpoint] = js.undefined
    ): CreateVpcEndpointResult = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      VpcEndpoint.foreach(__v => __obj.updateDynamic("VpcEndpoint")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpcEndpointResult]
    }
  }

  @js.native
  trait CreateVpcEndpointServiceConfigurationRequest extends js.Object {
    var NetworkLoadBalancerArns: ValueStringList
    var AcceptanceRequired: js.UndefOr[Boolean]
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateVpcEndpointServiceConfigurationRequest {
    @inline
    def apply(
        NetworkLoadBalancerArns: ValueStringList,
        AcceptanceRequired: js.UndefOr[Boolean] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateVpcEndpointServiceConfigurationRequest = {
      val __obj = js.Dynamic.literal(
        "NetworkLoadBalancerArns" -> NetworkLoadBalancerArns.asInstanceOf[js.Any]
      )

      AcceptanceRequired.foreach(__v => __obj.updateDynamic("AcceptanceRequired")(__v.asInstanceOf[js.Any]))
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpcEndpointServiceConfigurationRequest]
    }
  }

  @js.native
  trait CreateVpcEndpointServiceConfigurationResult extends js.Object {
    var ClientToken: js.UndefOr[String]
    var ServiceConfiguration: js.UndefOr[ServiceConfiguration]
  }

  object CreateVpcEndpointServiceConfigurationResult {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        ServiceConfiguration: js.UndefOr[ServiceConfiguration] = js.undefined
    ): CreateVpcEndpointServiceConfigurationResult = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      ServiceConfiguration.foreach(__v => __obj.updateDynamic("ServiceConfiguration")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpcEndpointServiceConfigurationResult]
    }
  }

  @js.native
  trait CreateVpcPeeringConnectionRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var PeerOwnerId: js.UndefOr[String]
    var PeerRegion: js.UndefOr[String]
    var PeerVpcId: js.UndefOr[String]
    var VpcId: js.UndefOr[String]
  }

  object CreateVpcPeeringConnectionRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PeerOwnerId: js.UndefOr[String] = js.undefined,
        PeerRegion: js.UndefOr[String] = js.undefined,
        PeerVpcId: js.UndefOr[String] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): CreateVpcPeeringConnectionRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      PeerOwnerId.foreach(__v => __obj.updateDynamic("PeerOwnerId")(__v.asInstanceOf[js.Any]))
      PeerRegion.foreach(__v => __obj.updateDynamic("PeerRegion")(__v.asInstanceOf[js.Any]))
      PeerVpcId.foreach(__v => __obj.updateDynamic("PeerVpcId")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpcPeeringConnectionRequest]
    }
  }

  @js.native
  trait CreateVpcPeeringConnectionResult extends js.Object {
    var VpcPeeringConnection: js.UndefOr[VpcPeeringConnection]
  }

  object CreateVpcPeeringConnectionResult {
    @inline
    def apply(
        VpcPeeringConnection: js.UndefOr[VpcPeeringConnection] = js.undefined
    ): CreateVpcPeeringConnectionResult = {
      val __obj = js.Dynamic.literal()
      VpcPeeringConnection.foreach(__v => __obj.updateDynamic("VpcPeeringConnection")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpcPeeringConnectionResult]
    }
  }

  @js.native
  trait CreateVpcRequest extends js.Object {
    var CidrBlock: String
    var AmazonProvidedIpv6CidrBlock: js.UndefOr[Boolean]
    var DryRun: js.UndefOr[Boolean]
    var InstanceTenancy: js.UndefOr[Tenancy]
  }

  object CreateVpcRequest {
    @inline
    def apply(
        CidrBlock: String,
        AmazonProvidedIpv6CidrBlock: js.UndefOr[Boolean] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        InstanceTenancy: js.UndefOr[Tenancy] = js.undefined
    ): CreateVpcRequest = {
      val __obj = js.Dynamic.literal(
        "CidrBlock" -> CidrBlock.asInstanceOf[js.Any]
      )

      AmazonProvidedIpv6CidrBlock.foreach(
        __v => __obj.updateDynamic("AmazonProvidedIpv6CidrBlock")(__v.asInstanceOf[js.Any])
      )
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      InstanceTenancy.foreach(__v => __obj.updateDynamic("InstanceTenancy")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpcRequest]
    }
  }

  @js.native
  trait CreateVpcResult extends js.Object {
    var Vpc: js.UndefOr[Vpc]
  }

  object CreateVpcResult {
    @inline
    def apply(
        Vpc: js.UndefOr[Vpc] = js.undefined
    ): CreateVpcResult = {
      val __obj = js.Dynamic.literal()
      Vpc.foreach(__v => __obj.updateDynamic("Vpc")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpcResult]
    }
  }

  /**
    * Contains the parameters for CreateVpnConnection.
    */
  @js.native
  trait CreateVpnConnectionRequest extends js.Object {
    var CustomerGatewayId: String
    var Type: String
    var DryRun: js.UndefOr[Boolean]
    var Options: js.UndefOr[VpnConnectionOptionsSpecification]
    var TransitGatewayId: js.UndefOr[String]
    var VpnGatewayId: js.UndefOr[String]
  }

  object CreateVpnConnectionRequest {
    @inline
    def apply(
        CustomerGatewayId: String,
        Type: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Options: js.UndefOr[VpnConnectionOptionsSpecification] = js.undefined,
        TransitGatewayId: js.UndefOr[String] = js.undefined,
        VpnGatewayId: js.UndefOr[String] = js.undefined
    ): CreateVpnConnectionRequest = {
      val __obj = js.Dynamic.literal(
        "CustomerGatewayId" -> CustomerGatewayId.asInstanceOf[js.Any],
        "Type"              -> Type.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Options.foreach(__v => __obj.updateDynamic("Options")(__v.asInstanceOf[js.Any]))
      TransitGatewayId.foreach(__v => __obj.updateDynamic("TransitGatewayId")(__v.asInstanceOf[js.Any]))
      VpnGatewayId.foreach(__v => __obj.updateDynamic("VpnGatewayId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpnConnectionRequest]
    }
  }

  /**
    * Contains the output of CreateVpnConnection.
    */
  @js.native
  trait CreateVpnConnectionResult extends js.Object {
    var VpnConnection: js.UndefOr[VpnConnection]
  }

  object CreateVpnConnectionResult {
    @inline
    def apply(
        VpnConnection: js.UndefOr[VpnConnection] = js.undefined
    ): CreateVpnConnectionResult = {
      val __obj = js.Dynamic.literal()
      VpnConnection.foreach(__v => __obj.updateDynamic("VpnConnection")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpnConnectionResult]
    }
  }

  /**
    * Contains the parameters for CreateVpnConnectionRoute.
    */
  @js.native
  trait CreateVpnConnectionRouteRequest extends js.Object {
    var DestinationCidrBlock: String
    var VpnConnectionId: String
  }

  object CreateVpnConnectionRouteRequest {
    @inline
    def apply(
        DestinationCidrBlock: String,
        VpnConnectionId: String
    ): CreateVpnConnectionRouteRequest = {
      val __obj = js.Dynamic.literal(
        "DestinationCidrBlock" -> DestinationCidrBlock.asInstanceOf[js.Any],
        "VpnConnectionId"      -> VpnConnectionId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[CreateVpnConnectionRouteRequest]
    }
  }

  /**
    * Contains the parameters for CreateVpnGateway.
    */
  @js.native
  trait CreateVpnGatewayRequest extends js.Object {
    var Type: GatewayType
    var AmazonSideAsn: js.UndefOr[Double]
    var AvailabilityZone: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object CreateVpnGatewayRequest {
    @inline
    def apply(
        Type: GatewayType,
        AmazonSideAsn: js.UndefOr[Double] = js.undefined,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): CreateVpnGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "Type" -> Type.asInstanceOf[js.Any]
      )

      AmazonSideAsn.foreach(__v => __obj.updateDynamic("AmazonSideAsn")(__v.asInstanceOf[js.Any]))
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpnGatewayRequest]
    }
  }

  /**
    * Contains the output of CreateVpnGateway.
    */
  @js.native
  trait CreateVpnGatewayResult extends js.Object {
    var VpnGateway: js.UndefOr[VpnGateway]
  }

  object CreateVpnGatewayResult {
    @inline
    def apply(
        VpnGateway: js.UndefOr[VpnGateway] = js.undefined
    ): CreateVpnGatewayResult = {
      val __obj = js.Dynamic.literal()
      VpnGateway.foreach(__v => __obj.updateDynamic("VpnGateway")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreateVpnGatewayResult]
    }
  }

  /**
    * Describes the credit option for CPU usage of a T2 or T3 instance.
    */
  @js.native
  trait CreditSpecification extends js.Object {
    var CpuCredits: js.UndefOr[String]
  }

  object CreditSpecification {
    @inline
    def apply(
        CpuCredits: js.UndefOr[String] = js.undefined
    ): CreditSpecification = {
      val __obj = js.Dynamic.literal()
      CpuCredits.foreach(__v => __obj.updateDynamic("CpuCredits")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CreditSpecification]
    }
  }

  /**
    * The credit option for CPU usage of a T2 or T3 instance.
    */
  @js.native
  trait CreditSpecificationRequest extends js.Object {
    var CpuCredits: String
  }

  object CreditSpecificationRequest {
    @inline
    def apply(
        CpuCredits: String
    ): CreditSpecificationRequest = {
      val __obj = js.Dynamic.literal(
        "CpuCredits" -> CpuCredits.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[CreditSpecificationRequest]
    }
  }

  object CurrencyCodeValuesEnum {
    val USD = "USD"

    val values = js.Object.freeze(js.Array(USD))
  }

  /**
    * Describes a customer gateway.
    */
  @js.native
  trait CustomerGateway extends js.Object {
    var BgpAsn: js.UndefOr[String]
    var CertificateArn: js.UndefOr[String]
    var CustomerGatewayId: js.UndefOr[String]
    var IpAddress: js.UndefOr[String]
    var State: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
    var Type: js.UndefOr[String]
  }

  object CustomerGateway {
    @inline
    def apply(
        BgpAsn: js.UndefOr[String] = js.undefined,
        CertificateArn: js.UndefOr[String] = js.undefined,
        CustomerGatewayId: js.UndefOr[String] = js.undefined,
        IpAddress: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        Type: js.UndefOr[String] = js.undefined
    ): CustomerGateway = {
      val __obj = js.Dynamic.literal()
      BgpAsn.foreach(__v => __obj.updateDynamic("BgpAsn")(__v.asInstanceOf[js.Any]))
      CertificateArn.foreach(__v => __obj.updateDynamic("CertificateArn")(__v.asInstanceOf[js.Any]))
      CustomerGatewayId.foreach(__v => __obj.updateDynamic("CustomerGatewayId")(__v.asInstanceOf[js.Any]))
      IpAddress.foreach(__v => __obj.updateDynamic("IpAddress")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      Type.foreach(__v => __obj.updateDynamic("Type")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[CustomerGateway]
    }
  }

  object DatafeedSubscriptionStateEnum {
    val Active   = "Active"
    val Inactive = "Inactive"

    val values = js.Object.freeze(js.Array(Active, Inactive))
  }

  object DefaultRouteTableAssociationValueEnum {
    val enable  = "enable"
    val disable = "disable"

    val values = js.Object.freeze(js.Array(enable, disable))
  }

  object DefaultRouteTablePropagationValueEnum {
    val enable  = "enable"
    val disable = "disable"

    val values = js.Object.freeze(js.Array(enable, disable))
  }

  object DefaultTargetCapacityTypeEnum {
    val spot        = "spot"
    val `on-demand` = "on-demand"

    val values = js.Object.freeze(js.Array(spot, `on-demand`))
  }

  @js.native
  trait DeleteClientVpnEndpointRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteClientVpnEndpointRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteClientVpnEndpointRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteClientVpnEndpointRequest]
    }
  }

  @js.native
  trait DeleteClientVpnEndpointResult extends js.Object {
    var Status: js.UndefOr[ClientVpnEndpointStatus]
  }

  object DeleteClientVpnEndpointResult {
    @inline
    def apply(
        Status: js.UndefOr[ClientVpnEndpointStatus] = js.undefined
    ): DeleteClientVpnEndpointResult = {
      val __obj = js.Dynamic.literal()
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteClientVpnEndpointResult]
    }
  }

  @js.native
  trait DeleteClientVpnRouteRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DestinationCidrBlock: String
    var DryRun: js.UndefOr[Boolean]
    var TargetVpcSubnetId: js.UndefOr[String]
  }

  object DeleteClientVpnRouteRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        DestinationCidrBlock: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TargetVpcSubnetId: js.UndefOr[String] = js.undefined
    ): DeleteClientVpnRouteRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId"  -> ClientVpnEndpointId.asInstanceOf[js.Any],
        "DestinationCidrBlock" -> DestinationCidrBlock.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      TargetVpcSubnetId.foreach(__v => __obj.updateDynamic("TargetVpcSubnetId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteClientVpnRouteRequest]
    }
  }

  @js.native
  trait DeleteClientVpnRouteResult extends js.Object {
    var Status: js.UndefOr[ClientVpnRouteStatus]
  }

  object DeleteClientVpnRouteResult {
    @inline
    def apply(
        Status: js.UndefOr[ClientVpnRouteStatus] = js.undefined
    ): DeleteClientVpnRouteResult = {
      val __obj = js.Dynamic.literal()
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteClientVpnRouteResult]
    }
  }

  /**
    * Contains the parameters for DeleteCustomerGateway.
    */
  @js.native
  trait DeleteCustomerGatewayRequest extends js.Object {
    var CustomerGatewayId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteCustomerGatewayRequest {
    @inline
    def apply(
        CustomerGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteCustomerGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "CustomerGatewayId" -> CustomerGatewayId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteCustomerGatewayRequest]
    }
  }

  @js.native
  trait DeleteDhcpOptionsRequest extends js.Object {
    var DhcpOptionsId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteDhcpOptionsRequest {
    @inline
    def apply(
        DhcpOptionsId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteDhcpOptionsRequest = {
      val __obj = js.Dynamic.literal(
        "DhcpOptionsId" -> DhcpOptionsId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteDhcpOptionsRequest]
    }
  }

  @js.native
  trait DeleteEgressOnlyInternetGatewayRequest extends js.Object {
    var EgressOnlyInternetGatewayId: EgressOnlyInternetGatewayId
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteEgressOnlyInternetGatewayRequest {
    @inline
    def apply(
        EgressOnlyInternetGatewayId: EgressOnlyInternetGatewayId,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteEgressOnlyInternetGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "EgressOnlyInternetGatewayId" -> EgressOnlyInternetGatewayId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteEgressOnlyInternetGatewayRequest]
    }
  }

  @js.native
  trait DeleteEgressOnlyInternetGatewayResult extends js.Object {
    var ReturnCode: js.UndefOr[Boolean]
  }

  object DeleteEgressOnlyInternetGatewayResult {
    @inline
    def apply(
        ReturnCode: js.UndefOr[Boolean] = js.undefined
    ): DeleteEgressOnlyInternetGatewayResult = {
      val __obj = js.Dynamic.literal()
      ReturnCode.foreach(__v => __obj.updateDynamic("ReturnCode")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteEgressOnlyInternetGatewayResult]
    }
  }

  /**
    * Describes an EC2 Fleet error.
    */
  @js.native
  trait DeleteFleetError extends js.Object {
    var Code: js.UndefOr[DeleteFleetErrorCode]
    var Message: js.UndefOr[String]
  }

  object DeleteFleetError {
    @inline
    def apply(
        Code: js.UndefOr[DeleteFleetErrorCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): DeleteFleetError = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Message.foreach(__v => __obj.updateDynamic("Message")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteFleetError]
    }
  }

  object DeleteFleetErrorCodeEnum {
    val fleetIdDoesNotExist      = "fleetIdDoesNotExist"
    val fleetIdMalformed         = "fleetIdMalformed"
    val fleetNotInDeletableState = "fleetNotInDeletableState"
    val unexpectedError          = "unexpectedError"

    val values =
      js.Object.freeze(js.Array(fleetIdDoesNotExist, fleetIdMalformed, fleetNotInDeletableState, unexpectedError))
  }

  /**
    * Describes an EC2 Fleet that was not successfully deleted.
    */
  @js.native
  trait DeleteFleetErrorItem extends js.Object {
    var Error: js.UndefOr[DeleteFleetError]
    var FleetId: js.UndefOr[FleetIdentifier]
  }

  object DeleteFleetErrorItem {
    @inline
    def apply(
        Error: js.UndefOr[DeleteFleetError] = js.undefined,
        FleetId: js.UndefOr[FleetIdentifier] = js.undefined
    ): DeleteFleetErrorItem = {
      val __obj = js.Dynamic.literal()
      Error.foreach(__v => __obj.updateDynamic("Error")(__v.asInstanceOf[js.Any]))
      FleetId.foreach(__v => __obj.updateDynamic("FleetId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteFleetErrorItem]
    }
  }

  /**
    * Describes an EC2 Fleet that was successfully deleted.
    */
  @js.native
  trait DeleteFleetSuccessItem extends js.Object {
    var CurrentFleetState: js.UndefOr[FleetStateCode]
    var FleetId: js.UndefOr[FleetIdentifier]
    var PreviousFleetState: js.UndefOr[FleetStateCode]
  }

  object DeleteFleetSuccessItem {
    @inline
    def apply(
        CurrentFleetState: js.UndefOr[FleetStateCode] = js.undefined,
        FleetId: js.UndefOr[FleetIdentifier] = js.undefined,
        PreviousFleetState: js.UndefOr[FleetStateCode] = js.undefined
    ): DeleteFleetSuccessItem = {
      val __obj = js.Dynamic.literal()
      CurrentFleetState.foreach(__v => __obj.updateDynamic("CurrentFleetState")(__v.asInstanceOf[js.Any]))
      FleetId.foreach(__v => __obj.updateDynamic("FleetId")(__v.asInstanceOf[js.Any]))
      PreviousFleetState.foreach(__v => __obj.updateDynamic("PreviousFleetState")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteFleetSuccessItem]
    }
  }

  @js.native
  trait DeleteFleetsRequest extends js.Object {
    var FleetIds: FleetIdSet
    var TerminateInstances: Boolean
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteFleetsRequest {
    @inline
    def apply(
        FleetIds: FleetIdSet,
        TerminateInstances: Boolean,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteFleetsRequest = {
      val __obj = js.Dynamic.literal(
        "FleetIds"           -> FleetIds.asInstanceOf[js.Any],
        "TerminateInstances" -> TerminateInstances.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteFleetsRequest]
    }
  }

  @js.native
  trait DeleteFleetsResult extends js.Object {
    var SuccessfulFleetDeletions: js.UndefOr[DeleteFleetSuccessSet]
    var UnsuccessfulFleetDeletions: js.UndefOr[DeleteFleetErrorSet]
  }

  object DeleteFleetsResult {
    @inline
    def apply(
        SuccessfulFleetDeletions: js.UndefOr[DeleteFleetSuccessSet] = js.undefined,
        UnsuccessfulFleetDeletions: js.UndefOr[DeleteFleetErrorSet] = js.undefined
    ): DeleteFleetsResult = {
      val __obj = js.Dynamic.literal()
      SuccessfulFleetDeletions.foreach(__v => __obj.updateDynamic("SuccessfulFleetDeletions")(__v.asInstanceOf[js.Any]))
      UnsuccessfulFleetDeletions.foreach(
        __v => __obj.updateDynamic("UnsuccessfulFleetDeletions")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DeleteFleetsResult]
    }
  }

  @js.native
  trait DeleteFlowLogsRequest extends js.Object {
    var FlowLogIds: ValueStringList
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteFlowLogsRequest {
    @inline
    def apply(
        FlowLogIds: ValueStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteFlowLogsRequest = {
      val __obj = js.Dynamic.literal(
        "FlowLogIds" -> FlowLogIds.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteFlowLogsRequest]
    }
  }

  @js.native
  trait DeleteFlowLogsResult extends js.Object {
    var Unsuccessful: js.UndefOr[UnsuccessfulItemSet]
  }

  object DeleteFlowLogsResult {
    @inline
    def apply(
        Unsuccessful: js.UndefOr[UnsuccessfulItemSet] = js.undefined
    ): DeleteFlowLogsResult = {
      val __obj = js.Dynamic.literal()
      Unsuccessful.foreach(__v => __obj.updateDynamic("Unsuccessful")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteFlowLogsResult]
    }
  }

  @js.native
  trait DeleteFpgaImageRequest extends js.Object {
    var FpgaImageId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteFpgaImageRequest {
    @inline
    def apply(
        FpgaImageId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteFpgaImageRequest = {
      val __obj = js.Dynamic.literal(
        "FpgaImageId" -> FpgaImageId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteFpgaImageRequest]
    }
  }

  @js.native
  trait DeleteFpgaImageResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object DeleteFpgaImageResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): DeleteFpgaImageResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteFpgaImageResult]
    }
  }

  @js.native
  trait DeleteInternetGatewayRequest extends js.Object {
    var InternetGatewayId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteInternetGatewayRequest {
    @inline
    def apply(
        InternetGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteInternetGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "InternetGatewayId" -> InternetGatewayId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteInternetGatewayRequest]
    }
  }

  @js.native
  trait DeleteKeyPairRequest extends js.Object {
    var KeyName: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteKeyPairRequest {
    @inline
    def apply(
        KeyName: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteKeyPairRequest = {
      val __obj = js.Dynamic.literal(
        "KeyName" -> KeyName.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteKeyPairRequest]
    }
  }

  @js.native
  trait DeleteLaunchTemplateRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
  }

  object DeleteLaunchTemplateRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined
    ): DeleteLaunchTemplateRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      LaunchTemplateId.foreach(__v => __obj.updateDynamic("LaunchTemplateId")(__v.asInstanceOf[js.Any]))
      LaunchTemplateName.foreach(__v => __obj.updateDynamic("LaunchTemplateName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteLaunchTemplateRequest]
    }
  }

  @js.native
  trait DeleteLaunchTemplateResult extends js.Object {
    var LaunchTemplate: js.UndefOr[LaunchTemplate]
  }

  object DeleteLaunchTemplateResult {
    @inline
    def apply(
        LaunchTemplate: js.UndefOr[LaunchTemplate] = js.undefined
    ): DeleteLaunchTemplateResult = {
      val __obj = js.Dynamic.literal()
      LaunchTemplate.foreach(__v => __obj.updateDynamic("LaunchTemplate")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteLaunchTemplateResult]
    }
  }

  @js.native
  trait DeleteLaunchTemplateVersionsRequest extends js.Object {
    var Versions: VersionStringList
    var DryRun: js.UndefOr[Boolean]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
  }

  object DeleteLaunchTemplateVersionsRequest {
    @inline
    def apply(
        Versions: VersionStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined
    ): DeleteLaunchTemplateVersionsRequest = {
      val __obj = js.Dynamic.literal(
        "Versions" -> Versions.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      LaunchTemplateId.foreach(__v => __obj.updateDynamic("LaunchTemplateId")(__v.asInstanceOf[js.Any]))
      LaunchTemplateName.foreach(__v => __obj.updateDynamic("LaunchTemplateName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteLaunchTemplateVersionsRequest]
    }
  }

  /**
    * Describes a launch template version that could not be deleted.
    */
  @js.native
  trait DeleteLaunchTemplateVersionsResponseErrorItem extends js.Object {
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[String]
    var ResponseError: js.UndefOr[ResponseError]
    var VersionNumber: js.UndefOr[Double]
  }

  object DeleteLaunchTemplateVersionsResponseErrorItem {
    @inline
    def apply(
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[String] = js.undefined,
        ResponseError: js.UndefOr[ResponseError] = js.undefined,
        VersionNumber: js.UndefOr[Double] = js.undefined
    ): DeleteLaunchTemplateVersionsResponseErrorItem = {
      val __obj = js.Dynamic.literal()
      LaunchTemplateId.foreach(__v => __obj.updateDynamic("LaunchTemplateId")(__v.asInstanceOf[js.Any]))
      LaunchTemplateName.foreach(__v => __obj.updateDynamic("LaunchTemplateName")(__v.asInstanceOf[js.Any]))
      ResponseError.foreach(__v => __obj.updateDynamic("ResponseError")(__v.asInstanceOf[js.Any]))
      VersionNumber.foreach(__v => __obj.updateDynamic("VersionNumber")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteLaunchTemplateVersionsResponseErrorItem]
    }
  }

  /**
    * Describes a launch template version that was successfully deleted.
    */
  @js.native
  trait DeleteLaunchTemplateVersionsResponseSuccessItem extends js.Object {
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[String]
    var VersionNumber: js.UndefOr[Double]
  }

  object DeleteLaunchTemplateVersionsResponseSuccessItem {
    @inline
    def apply(
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[String] = js.undefined,
        VersionNumber: js.UndefOr[Double] = js.undefined
    ): DeleteLaunchTemplateVersionsResponseSuccessItem = {
      val __obj = js.Dynamic.literal()
      LaunchTemplateId.foreach(__v => __obj.updateDynamic("LaunchTemplateId")(__v.asInstanceOf[js.Any]))
      LaunchTemplateName.foreach(__v => __obj.updateDynamic("LaunchTemplateName")(__v.asInstanceOf[js.Any]))
      VersionNumber.foreach(__v => __obj.updateDynamic("VersionNumber")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteLaunchTemplateVersionsResponseSuccessItem]
    }
  }

  @js.native
  trait DeleteLaunchTemplateVersionsResult extends js.Object {
    var SuccessfullyDeletedLaunchTemplateVersions: js.UndefOr[DeleteLaunchTemplateVersionsResponseSuccessSet]
    var UnsuccessfullyDeletedLaunchTemplateVersions: js.UndefOr[DeleteLaunchTemplateVersionsResponseErrorSet]
  }

  object DeleteLaunchTemplateVersionsResult {
    @inline
    def apply(
        SuccessfullyDeletedLaunchTemplateVersions: js.UndefOr[DeleteLaunchTemplateVersionsResponseSuccessSet] =
          js.undefined,
        UnsuccessfullyDeletedLaunchTemplateVersions: js.UndefOr[DeleteLaunchTemplateVersionsResponseErrorSet] =
          js.undefined
    ): DeleteLaunchTemplateVersionsResult = {
      val __obj = js.Dynamic.literal()
      SuccessfullyDeletedLaunchTemplateVersions.foreach(
        __v => __obj.updateDynamic("SuccessfullyDeletedLaunchTemplateVersions")(__v.asInstanceOf[js.Any])
      )
      UnsuccessfullyDeletedLaunchTemplateVersions.foreach(
        __v => __obj.updateDynamic("UnsuccessfullyDeletedLaunchTemplateVersions")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DeleteLaunchTemplateVersionsResult]
    }
  }

  @js.native
  trait DeleteNatGatewayRequest extends js.Object {
    var NatGatewayId: String
  }

  object DeleteNatGatewayRequest {
    @inline
    def apply(
        NatGatewayId: String
    ): DeleteNatGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "NatGatewayId" -> NatGatewayId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[DeleteNatGatewayRequest]
    }
  }

  @js.native
  trait DeleteNatGatewayResult extends js.Object {
    var NatGatewayId: js.UndefOr[String]
  }

  object DeleteNatGatewayResult {
    @inline
    def apply(
        NatGatewayId: js.UndefOr[String] = js.undefined
    ): DeleteNatGatewayResult = {
      val __obj = js.Dynamic.literal()
      NatGatewayId.foreach(__v => __obj.updateDynamic("NatGatewayId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteNatGatewayResult]
    }
  }

  @js.native
  trait DeleteNetworkAclEntryRequest extends js.Object {
    var Egress: Boolean
    var NetworkAclId: String
    var RuleNumber: Int
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteNetworkAclEntryRequest {
    @inline
    def apply(
        Egress: Boolean,
        NetworkAclId: String,
        RuleNumber: Int,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteNetworkAclEntryRequest = {
      val __obj = js.Dynamic.literal(
        "Egress"       -> Egress.asInstanceOf[js.Any],
        "NetworkAclId" -> NetworkAclId.asInstanceOf[js.Any],
        "RuleNumber"   -> RuleNumber.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteNetworkAclEntryRequest]
    }
  }

  @js.native
  trait DeleteNetworkAclRequest extends js.Object {
    var NetworkAclId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteNetworkAclRequest {
    @inline
    def apply(
        NetworkAclId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteNetworkAclRequest = {
      val __obj = js.Dynamic.literal(
        "NetworkAclId" -> NetworkAclId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteNetworkAclRequest]
    }
  }

  /**
    * Contains the parameters for DeleteNetworkInterfacePermission.
    */
  @js.native
  trait DeleteNetworkInterfacePermissionRequest extends js.Object {
    var NetworkInterfacePermissionId: String
    var DryRun: js.UndefOr[Boolean]
    var Force: js.UndefOr[Boolean]
  }

  object DeleteNetworkInterfacePermissionRequest {
    @inline
    def apply(
        NetworkInterfacePermissionId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Force: js.UndefOr[Boolean] = js.undefined
    ): DeleteNetworkInterfacePermissionRequest = {
      val __obj = js.Dynamic.literal(
        "NetworkInterfacePermissionId" -> NetworkInterfacePermissionId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Force.foreach(__v => __obj.updateDynamic("Force")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteNetworkInterfacePermissionRequest]
    }
  }

  /**
    * Contains the output for DeleteNetworkInterfacePermission.
    */
  @js.native
  trait DeleteNetworkInterfacePermissionResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object DeleteNetworkInterfacePermissionResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): DeleteNetworkInterfacePermissionResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteNetworkInterfacePermissionResult]
    }
  }

  /**
    * Contains the parameters for DeleteNetworkInterface.
    */
  @js.native
  trait DeleteNetworkInterfaceRequest extends js.Object {
    var NetworkInterfaceId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteNetworkInterfaceRequest {
    @inline
    def apply(
        NetworkInterfaceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteNetworkInterfaceRequest = {
      val __obj = js.Dynamic.literal(
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteNetworkInterfaceRequest]
    }
  }

  @js.native
  trait DeletePlacementGroupRequest extends js.Object {
    var GroupName: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeletePlacementGroupRequest {
    @inline
    def apply(
        GroupName: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeletePlacementGroupRequest = {
      val __obj = js.Dynamic.literal(
        "GroupName" -> GroupName.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeletePlacementGroupRequest]
    }
  }

  @js.native
  trait DeleteRouteRequest extends js.Object {
    var RouteTableId: String
    var DestinationCidrBlock: js.UndefOr[String]
    var DestinationIpv6CidrBlock: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteRouteRequest {
    @inline
    def apply(
        RouteTableId: String,
        DestinationCidrBlock: js.UndefOr[String] = js.undefined,
        DestinationIpv6CidrBlock: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteRouteRequest = {
      val __obj = js.Dynamic.literal(
        "RouteTableId" -> RouteTableId.asInstanceOf[js.Any]
      )

      DestinationCidrBlock.foreach(__v => __obj.updateDynamic("DestinationCidrBlock")(__v.asInstanceOf[js.Any]))
      DestinationIpv6CidrBlock.foreach(__v => __obj.updateDynamic("DestinationIpv6CidrBlock")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteRouteRequest]
    }
  }

  @js.native
  trait DeleteRouteTableRequest extends js.Object {
    var RouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteRouteTableRequest {
    @inline
    def apply(
        RouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteRouteTableRequest = {
      val __obj = js.Dynamic.literal(
        "RouteTableId" -> RouteTableId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteRouteTableRequest]
    }
  }

  @js.native
  trait DeleteSecurityGroupRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var GroupId: js.UndefOr[String]
    var GroupName: js.UndefOr[String]
  }

  object DeleteSecurityGroupRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        GroupId: js.UndefOr[String] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined
    ): DeleteSecurityGroupRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      GroupId.foreach(__v => __obj.updateDynamic("GroupId")(__v.asInstanceOf[js.Any]))
      GroupName.foreach(__v => __obj.updateDynamic("GroupName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteSecurityGroupRequest]
    }
  }

  /**
    * Contains the parameters for DeleteSnapshot.
    */
  @js.native
  trait DeleteSnapshotRequest extends js.Object {
    var SnapshotId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteSnapshotRequest {
    @inline
    def apply(
        SnapshotId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteSnapshotRequest = {
      val __obj = js.Dynamic.literal(
        "SnapshotId" -> SnapshotId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteSnapshotRequest]
    }
  }

  /**
    * Contains the parameters for DeleteSpotDatafeedSubscription.
    */
  @js.native
  trait DeleteSpotDatafeedSubscriptionRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteSpotDatafeedSubscriptionRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteSpotDatafeedSubscriptionRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteSpotDatafeedSubscriptionRequest]
    }
  }

  @js.native
  trait DeleteSubnetRequest extends js.Object {
    var SubnetId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteSubnetRequest {
    @inline
    def apply(
        SubnetId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteSubnetRequest = {
      val __obj = js.Dynamic.literal(
        "SubnetId" -> SubnetId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteSubnetRequest]
    }
  }

  @js.native
  trait DeleteTagsRequest extends js.Object {
    var Resources: ResourceIdList
    var DryRun: js.UndefOr[Boolean]
    var Tags: js.UndefOr[TagList]
  }

  object DeleteTagsRequest {
    @inline
    def apply(
        Resources: ResourceIdList,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): DeleteTagsRequest = {
      val __obj = js.Dynamic.literal(
        "Resources" -> Resources.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTagsRequest]
    }
  }

  @js.native
  trait DeleteTrafficMirrorFilterRequest extends js.Object {
    var TrafficMirrorFilterId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteTrafficMirrorFilterRequest {
    @inline
    def apply(
        TrafficMirrorFilterId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteTrafficMirrorFilterRequest = {
      val __obj = js.Dynamic.literal(
        "TrafficMirrorFilterId" -> TrafficMirrorFilterId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTrafficMirrorFilterRequest]
    }
  }

  @js.native
  trait DeleteTrafficMirrorFilterResult extends js.Object {
    var TrafficMirrorFilterId: js.UndefOr[String]
  }

  object DeleteTrafficMirrorFilterResult {
    @inline
    def apply(
        TrafficMirrorFilterId: js.UndefOr[String] = js.undefined
    ): DeleteTrafficMirrorFilterResult = {
      val __obj = js.Dynamic.literal()
      TrafficMirrorFilterId.foreach(__v => __obj.updateDynamic("TrafficMirrorFilterId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTrafficMirrorFilterResult]
    }
  }

  @js.native
  trait DeleteTrafficMirrorFilterRuleRequest extends js.Object {
    var TrafficMirrorFilterRuleId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteTrafficMirrorFilterRuleRequest {
    @inline
    def apply(
        TrafficMirrorFilterRuleId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteTrafficMirrorFilterRuleRequest = {
      val __obj = js.Dynamic.literal(
        "TrafficMirrorFilterRuleId" -> TrafficMirrorFilterRuleId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTrafficMirrorFilterRuleRequest]
    }
  }

  @js.native
  trait DeleteTrafficMirrorFilterRuleResult extends js.Object {
    var TrafficMirrorFilterRuleId: js.UndefOr[String]
  }

  object DeleteTrafficMirrorFilterRuleResult {
    @inline
    def apply(
        TrafficMirrorFilterRuleId: js.UndefOr[String] = js.undefined
    ): DeleteTrafficMirrorFilterRuleResult = {
      val __obj = js.Dynamic.literal()
      TrafficMirrorFilterRuleId.foreach(
        __v => __obj.updateDynamic("TrafficMirrorFilterRuleId")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DeleteTrafficMirrorFilterRuleResult]
    }
  }

  @js.native
  trait DeleteTrafficMirrorSessionRequest extends js.Object {
    var TrafficMirrorSessionId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteTrafficMirrorSessionRequest {
    @inline
    def apply(
        TrafficMirrorSessionId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteTrafficMirrorSessionRequest = {
      val __obj = js.Dynamic.literal(
        "TrafficMirrorSessionId" -> TrafficMirrorSessionId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTrafficMirrorSessionRequest]
    }
  }

  @js.native
  trait DeleteTrafficMirrorSessionResult extends js.Object {
    var TrafficMirrorSessionId: js.UndefOr[String]
  }

  object DeleteTrafficMirrorSessionResult {
    @inline
    def apply(
        TrafficMirrorSessionId: js.UndefOr[String] = js.undefined
    ): DeleteTrafficMirrorSessionResult = {
      val __obj = js.Dynamic.literal()
      TrafficMirrorSessionId.foreach(__v => __obj.updateDynamic("TrafficMirrorSessionId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTrafficMirrorSessionResult]
    }
  }

  @js.native
  trait DeleteTrafficMirrorTargetRequest extends js.Object {
    var TrafficMirrorTargetId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteTrafficMirrorTargetRequest {
    @inline
    def apply(
        TrafficMirrorTargetId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteTrafficMirrorTargetRequest = {
      val __obj = js.Dynamic.literal(
        "TrafficMirrorTargetId" -> TrafficMirrorTargetId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTrafficMirrorTargetRequest]
    }
  }

  @js.native
  trait DeleteTrafficMirrorTargetResult extends js.Object {
    var TrafficMirrorTargetId: js.UndefOr[String]
  }

  object DeleteTrafficMirrorTargetResult {
    @inline
    def apply(
        TrafficMirrorTargetId: js.UndefOr[String] = js.undefined
    ): DeleteTrafficMirrorTargetResult = {
      val __obj = js.Dynamic.literal()
      TrafficMirrorTargetId.foreach(__v => __obj.updateDynamic("TrafficMirrorTargetId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTrafficMirrorTargetResult]
    }
  }

  @js.native
  trait DeleteTransitGatewayRequest extends js.Object {
    var TransitGatewayId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteTransitGatewayRequest {
    @inline
    def apply(
        TransitGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteTransitGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayId" -> TransitGatewayId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTransitGatewayRequest]
    }
  }

  @js.native
  trait DeleteTransitGatewayResult extends js.Object {
    var TransitGateway: js.UndefOr[TransitGateway]
  }

  object DeleteTransitGatewayResult {
    @inline
    def apply(
        TransitGateway: js.UndefOr[TransitGateway] = js.undefined
    ): DeleteTransitGatewayResult = {
      val __obj = js.Dynamic.literal()
      TransitGateway.foreach(__v => __obj.updateDynamic("TransitGateway")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTransitGatewayResult]
    }
  }

  @js.native
  trait DeleteTransitGatewayRouteRequest extends js.Object {
    var DestinationCidrBlock: String
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteTransitGatewayRouteRequest {
    @inline
    def apply(
        DestinationCidrBlock: String,
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteTransitGatewayRouteRequest = {
      val __obj = js.Dynamic.literal(
        "DestinationCidrBlock"       -> DestinationCidrBlock.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTransitGatewayRouteRequest]
    }
  }

  @js.native
  trait DeleteTransitGatewayRouteResult extends js.Object {
    var Route: js.UndefOr[TransitGatewayRoute]
  }

  object DeleteTransitGatewayRouteResult {
    @inline
    def apply(
        Route: js.UndefOr[TransitGatewayRoute] = js.undefined
    ): DeleteTransitGatewayRouteResult = {
      val __obj = js.Dynamic.literal()
      Route.foreach(__v => __obj.updateDynamic("Route")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTransitGatewayRouteResult]
    }
  }

  @js.native
  trait DeleteTransitGatewayRouteTableRequest extends js.Object {
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteTransitGatewayRouteTableRequest {
    @inline
    def apply(
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteTransitGatewayRouteTableRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTransitGatewayRouteTableRequest]
    }
  }

  @js.native
  trait DeleteTransitGatewayRouteTableResult extends js.Object {
    var TransitGatewayRouteTable: js.UndefOr[TransitGatewayRouteTable]
  }

  object DeleteTransitGatewayRouteTableResult {
    @inline
    def apply(
        TransitGatewayRouteTable: js.UndefOr[TransitGatewayRouteTable] = js.undefined
    ): DeleteTransitGatewayRouteTableResult = {
      val __obj = js.Dynamic.literal()
      TransitGatewayRouteTable.foreach(__v => __obj.updateDynamic("TransitGatewayRouteTable")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTransitGatewayRouteTableResult]
    }
  }

  @js.native
  trait DeleteTransitGatewayVpcAttachmentRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteTransitGatewayVpcAttachmentRequest {
    @inline
    def apply(
        TransitGatewayAttachmentId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteTransitGatewayVpcAttachmentRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteTransitGatewayVpcAttachmentRequest]
    }
  }

  @js.native
  trait DeleteTransitGatewayVpcAttachmentResult extends js.Object {
    var TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment]
  }

  object DeleteTransitGatewayVpcAttachmentResult {
    @inline
    def apply(
        TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment] = js.undefined
    ): DeleteTransitGatewayVpcAttachmentResult = {
      val __obj = js.Dynamic.literal()
      TransitGatewayVpcAttachment.foreach(
        __v => __obj.updateDynamic("TransitGatewayVpcAttachment")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DeleteTransitGatewayVpcAttachmentResult]
    }
  }

  /**
    * Contains the parameters for DeleteVolume.
    */
  @js.native
  trait DeleteVolumeRequest extends js.Object {
    var VolumeId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVolumeRequest {
    @inline
    def apply(
        VolumeId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVolumeRequest = {
      val __obj = js.Dynamic.literal(
        "VolumeId" -> VolumeId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteVolumeRequest]
    }
  }

  @js.native
  trait DeleteVpcEndpointConnectionNotificationsRequest extends js.Object {
    var ConnectionNotificationIds: ValueStringList
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpcEndpointConnectionNotificationsRequest {
    @inline
    def apply(
        ConnectionNotificationIds: ValueStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpcEndpointConnectionNotificationsRequest = {
      val __obj = js.Dynamic.literal(
        "ConnectionNotificationIds" -> ConnectionNotificationIds.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteVpcEndpointConnectionNotificationsRequest]
    }
  }

  @js.native
  trait DeleteVpcEndpointConnectionNotificationsResult extends js.Object {
    var Unsuccessful: js.UndefOr[UnsuccessfulItemSet]
  }

  object DeleteVpcEndpointConnectionNotificationsResult {
    @inline
    def apply(
        Unsuccessful: js.UndefOr[UnsuccessfulItemSet] = js.undefined
    ): DeleteVpcEndpointConnectionNotificationsResult = {
      val __obj = js.Dynamic.literal()
      Unsuccessful.foreach(__v => __obj.updateDynamic("Unsuccessful")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteVpcEndpointConnectionNotificationsResult]
    }
  }

  @js.native
  trait DeleteVpcEndpointServiceConfigurationsRequest extends js.Object {
    var ServiceIds: ValueStringList
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpcEndpointServiceConfigurationsRequest {
    @inline
    def apply(
        ServiceIds: ValueStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpcEndpointServiceConfigurationsRequest = {
      val __obj = js.Dynamic.literal(
        "ServiceIds" -> ServiceIds.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteVpcEndpointServiceConfigurationsRequest]
    }
  }

  @js.native
  trait DeleteVpcEndpointServiceConfigurationsResult extends js.Object {
    var Unsuccessful: js.UndefOr[UnsuccessfulItemSet]
  }

  object DeleteVpcEndpointServiceConfigurationsResult {
    @inline
    def apply(
        Unsuccessful: js.UndefOr[UnsuccessfulItemSet] = js.undefined
    ): DeleteVpcEndpointServiceConfigurationsResult = {
      val __obj = js.Dynamic.literal()
      Unsuccessful.foreach(__v => __obj.updateDynamic("Unsuccessful")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteVpcEndpointServiceConfigurationsResult]
    }
  }

  /**
    * Contains the parameters for DeleteVpcEndpoints.
    */
  @js.native
  trait DeleteVpcEndpointsRequest extends js.Object {
    var VpcEndpointIds: ValueStringList
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpcEndpointsRequest {
    @inline
    def apply(
        VpcEndpointIds: ValueStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpcEndpointsRequest = {
      val __obj = js.Dynamic.literal(
        "VpcEndpointIds" -> VpcEndpointIds.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteVpcEndpointsRequest]
    }
  }

  /**
    * Contains the output of DeleteVpcEndpoints.
    */
  @js.native
  trait DeleteVpcEndpointsResult extends js.Object {
    var Unsuccessful: js.UndefOr[UnsuccessfulItemSet]
  }

  object DeleteVpcEndpointsResult {
    @inline
    def apply(
        Unsuccessful: js.UndefOr[UnsuccessfulItemSet] = js.undefined
    ): DeleteVpcEndpointsResult = {
      val __obj = js.Dynamic.literal()
      Unsuccessful.foreach(__v => __obj.updateDynamic("Unsuccessful")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteVpcEndpointsResult]
    }
  }

  @js.native
  trait DeleteVpcPeeringConnectionRequest extends js.Object {
    var VpcPeeringConnectionId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpcPeeringConnectionRequest {
    @inline
    def apply(
        VpcPeeringConnectionId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpcPeeringConnectionRequest = {
      val __obj = js.Dynamic.literal(
        "VpcPeeringConnectionId" -> VpcPeeringConnectionId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteVpcPeeringConnectionRequest]
    }
  }

  @js.native
  trait DeleteVpcPeeringConnectionResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object DeleteVpcPeeringConnectionResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpcPeeringConnectionResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteVpcPeeringConnectionResult]
    }
  }

  @js.native
  trait DeleteVpcRequest extends js.Object {
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpcRequest {
    @inline
    def apply(
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpcRequest = {
      val __obj = js.Dynamic.literal(
        "VpcId" -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteVpcRequest]
    }
  }

  /**
    * Contains the parameters for DeleteVpnConnection.
    */
  @js.native
  trait DeleteVpnConnectionRequest extends js.Object {
    var VpnConnectionId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpnConnectionRequest {
    @inline
    def apply(
        VpnConnectionId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpnConnectionRequest = {
      val __obj = js.Dynamic.literal(
        "VpnConnectionId" -> VpnConnectionId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteVpnConnectionRequest]
    }
  }

  /**
    * Contains the parameters for DeleteVpnConnectionRoute.
    */
  @js.native
  trait DeleteVpnConnectionRouteRequest extends js.Object {
    var DestinationCidrBlock: String
    var VpnConnectionId: String
  }

  object DeleteVpnConnectionRouteRequest {
    @inline
    def apply(
        DestinationCidrBlock: String,
        VpnConnectionId: String
    ): DeleteVpnConnectionRouteRequest = {
      val __obj = js.Dynamic.literal(
        "DestinationCidrBlock" -> DestinationCidrBlock.asInstanceOf[js.Any],
        "VpnConnectionId"      -> VpnConnectionId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[DeleteVpnConnectionRouteRequest]
    }
  }

  /**
    * Contains the parameters for DeleteVpnGateway.
    */
  @js.native
  trait DeleteVpnGatewayRequest extends js.Object {
    var VpnGatewayId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeleteVpnGatewayRequest {
    @inline
    def apply(
        VpnGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeleteVpnGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "VpnGatewayId" -> VpnGatewayId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeleteVpnGatewayRequest]
    }
  }

  @js.native
  trait DeprovisionByoipCidrRequest extends js.Object {
    var Cidr: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeprovisionByoipCidrRequest {
    @inline
    def apply(
        Cidr: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeprovisionByoipCidrRequest = {
      val __obj = js.Dynamic.literal(
        "Cidr" -> Cidr.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeprovisionByoipCidrRequest]
    }
  }

  @js.native
  trait DeprovisionByoipCidrResult extends js.Object {
    var ByoipCidr: js.UndefOr[ByoipCidr]
  }

  object DeprovisionByoipCidrResult {
    @inline
    def apply(
        ByoipCidr: js.UndefOr[ByoipCidr] = js.undefined
    ): DeprovisionByoipCidrResult = {
      val __obj = js.Dynamic.literal()
      ByoipCidr.foreach(__v => __obj.updateDynamic("ByoipCidr")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeprovisionByoipCidrResult]
    }
  }

  /**
    * Contains the parameters for DeregisterImage.
    */
  @js.native
  trait DeregisterImageRequest extends js.Object {
    var ImageId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DeregisterImageRequest {
    @inline
    def apply(
        ImageId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DeregisterImageRequest = {
      val __obj = js.Dynamic.literal(
        "ImageId" -> ImageId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DeregisterImageRequest]
    }
  }

  @js.native
  trait DescribeAccountAttributesRequest extends js.Object {
    var AttributeNames: js.UndefOr[AccountAttributeNameStringList]
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeAccountAttributesRequest {
    @inline
    def apply(
        AttributeNames: js.UndefOr[AccountAttributeNameStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeAccountAttributesRequest = {
      val __obj = js.Dynamic.literal()
      AttributeNames.foreach(__v => __obj.updateDynamic("AttributeNames")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeAccountAttributesRequest]
    }
  }

  @js.native
  trait DescribeAccountAttributesResult extends js.Object {
    var AccountAttributes: js.UndefOr[AccountAttributeList]
  }

  object DescribeAccountAttributesResult {
    @inline
    def apply(
        AccountAttributes: js.UndefOr[AccountAttributeList] = js.undefined
    ): DescribeAccountAttributesResult = {
      val __obj = js.Dynamic.literal()
      AccountAttributes.foreach(__v => __obj.updateDynamic("AccountAttributes")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeAccountAttributesResult]
    }
  }

  @js.native
  trait DescribeAddressesRequest extends js.Object {
    var AllocationIds: js.UndefOr[AllocationIdList]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var PublicIps: js.UndefOr[PublicIpStringList]
  }

  object DescribeAddressesRequest {
    @inline
    def apply(
        AllocationIds: js.UndefOr[AllocationIdList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        PublicIps: js.UndefOr[PublicIpStringList] = js.undefined
    ): DescribeAddressesRequest = {
      val __obj = js.Dynamic.literal()
      AllocationIds.foreach(__v => __obj.updateDynamic("AllocationIds")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      PublicIps.foreach(__v => __obj.updateDynamic("PublicIps")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeAddressesRequest]
    }
  }

  @js.native
  trait DescribeAddressesResult extends js.Object {
    var Addresses: js.UndefOr[AddressList]
  }

  object DescribeAddressesResult {
    @inline
    def apply(
        Addresses: js.UndefOr[AddressList] = js.undefined
    ): DescribeAddressesResult = {
      val __obj = js.Dynamic.literal()
      Addresses.foreach(__v => __obj.updateDynamic("Addresses")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeAddressesResult]
    }
  }

  @js.native
  trait DescribeAggregateIdFormatRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeAggregateIdFormatRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeAggregateIdFormatRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeAggregateIdFormatRequest]
    }
  }

  @js.native
  trait DescribeAggregateIdFormatResult extends js.Object {
    var Statuses: js.UndefOr[IdFormatList]
    var UseLongIdsAggregated: js.UndefOr[Boolean]
  }

  object DescribeAggregateIdFormatResult {
    @inline
    def apply(
        Statuses: js.UndefOr[IdFormatList] = js.undefined,
        UseLongIdsAggregated: js.UndefOr[Boolean] = js.undefined
    ): DescribeAggregateIdFormatResult = {
      val __obj = js.Dynamic.literal()
      Statuses.foreach(__v => __obj.updateDynamic("Statuses")(__v.asInstanceOf[js.Any]))
      UseLongIdsAggregated.foreach(__v => __obj.updateDynamic("UseLongIdsAggregated")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeAggregateIdFormatResult]
    }
  }

  @js.native
  trait DescribeAvailabilityZonesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var ZoneIds: js.UndefOr[ZoneIdStringList]
    var ZoneNames: js.UndefOr[ZoneNameStringList]
  }

  object DescribeAvailabilityZonesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        ZoneIds: js.UndefOr[ZoneIdStringList] = js.undefined,
        ZoneNames: js.UndefOr[ZoneNameStringList] = js.undefined
    ): DescribeAvailabilityZonesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      ZoneIds.foreach(__v => __obj.updateDynamic("ZoneIds")(__v.asInstanceOf[js.Any]))
      ZoneNames.foreach(__v => __obj.updateDynamic("ZoneNames")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeAvailabilityZonesRequest]
    }
  }

  @js.native
  trait DescribeAvailabilityZonesResult extends js.Object {
    var AvailabilityZones: js.UndefOr[AvailabilityZoneList]
  }

  object DescribeAvailabilityZonesResult {
    @inline
    def apply(
        AvailabilityZones: js.UndefOr[AvailabilityZoneList] = js.undefined
    ): DescribeAvailabilityZonesResult = {
      val __obj = js.Dynamic.literal()
      AvailabilityZones.foreach(__v => __obj.updateDynamic("AvailabilityZones")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeAvailabilityZonesResult]
    }
  }

  @js.native
  trait DescribeBundleTasksRequest extends js.Object {
    var BundleIds: js.UndefOr[BundleIdStringList]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
  }

  object DescribeBundleTasksRequest {
    @inline
    def apply(
        BundleIds: js.UndefOr[BundleIdStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined
    ): DescribeBundleTasksRequest = {
      val __obj = js.Dynamic.literal()
      BundleIds.foreach(__v => __obj.updateDynamic("BundleIds")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeBundleTasksRequest]
    }
  }

  @js.native
  trait DescribeBundleTasksResult extends js.Object {
    var BundleTasks: js.UndefOr[BundleTaskList]
  }

  object DescribeBundleTasksResult {
    @inline
    def apply(
        BundleTasks: js.UndefOr[BundleTaskList] = js.undefined
    ): DescribeBundleTasksResult = {
      val __obj = js.Dynamic.literal()
      BundleTasks.foreach(__v => __obj.updateDynamic("BundleTasks")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeBundleTasksResult]
    }
  }

  @js.native
  trait DescribeByoipCidrsRequest extends js.Object {
    var MaxResults: DescribeByoipCidrsMaxResults
    var DryRun: js.UndefOr[Boolean]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeByoipCidrsRequest {
    @inline
    def apply(
        MaxResults: DescribeByoipCidrsMaxResults,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeByoipCidrsRequest = {
      val __obj = js.Dynamic.literal(
        "MaxResults" -> MaxResults.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeByoipCidrsRequest]
    }
  }

  @js.native
  trait DescribeByoipCidrsResult extends js.Object {
    var ByoipCidrs: js.UndefOr[ByoipCidrSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeByoipCidrsResult {
    @inline
    def apply(
        ByoipCidrs: js.UndefOr[ByoipCidrSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeByoipCidrsResult = {
      val __obj = js.Dynamic.literal()
      ByoipCidrs.foreach(__v => __obj.updateDynamic("ByoipCidrs")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeByoipCidrsResult]
    }
  }

  @js.native
  trait DescribeCapacityReservationsRequest extends js.Object {
    var CapacityReservationIds: js.UndefOr[CapacityReservationIdSet]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeCapacityReservationsMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeCapacityReservationsRequest {
    @inline
    def apply(
        CapacityReservationIds: js.UndefOr[CapacityReservationIdSet] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeCapacityReservationsMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeCapacityReservationsRequest = {
      val __obj = js.Dynamic.literal()
      CapacityReservationIds.foreach(__v => __obj.updateDynamic("CapacityReservationIds")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeCapacityReservationsRequest]
    }
  }

  @js.native
  trait DescribeCapacityReservationsResult extends js.Object {
    var CapacityReservations: js.UndefOr[CapacityReservationSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeCapacityReservationsResult {
    @inline
    def apply(
        CapacityReservations: js.UndefOr[CapacityReservationSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeCapacityReservationsResult = {
      val __obj = js.Dynamic.literal()
      CapacityReservations.foreach(__v => __obj.updateDynamic("CapacityReservations")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeCapacityReservationsResult]
    }
  }

  @js.native
  trait DescribeClassicLinkInstancesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var InstanceIds: js.UndefOr[InstanceIdStringList]
    var MaxResults: js.UndefOr[DescribeClassicLinkInstancesMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeClassicLinkInstancesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        InstanceIds: js.UndefOr[InstanceIdStringList] = js.undefined,
        MaxResults: js.UndefOr[DescribeClassicLinkInstancesMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeClassicLinkInstancesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      InstanceIds.foreach(__v => __obj.updateDynamic("InstanceIds")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeClassicLinkInstancesRequest]
    }
  }

  @js.native
  trait DescribeClassicLinkInstancesResult extends js.Object {
    var Instances: js.UndefOr[ClassicLinkInstanceList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeClassicLinkInstancesResult {
    @inline
    def apply(
        Instances: js.UndefOr[ClassicLinkInstanceList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeClassicLinkInstancesResult = {
      val __obj = js.Dynamic.literal()
      Instances.foreach(__v => __obj.updateDynamic("Instances")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeClassicLinkInstancesResult]
    }
  }

  @js.native
  trait DescribeClientVpnAuthorizationRulesRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeClientVpnAuthorizationRulesMaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnAuthorizationRulesRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeClientVpnAuthorizationRulesMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnAuthorizationRulesRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeClientVpnAuthorizationRulesRequest]
    }
  }

  @js.native
  trait DescribeClientVpnAuthorizationRulesResult extends js.Object {
    var AuthorizationRules: js.UndefOr[AuthorizationRuleSet]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnAuthorizationRulesResult {
    @inline
    def apply(
        AuthorizationRules: js.UndefOr[AuthorizationRuleSet] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnAuthorizationRulesResult = {
      val __obj = js.Dynamic.literal()
      AuthorizationRules.foreach(__v => __obj.updateDynamic("AuthorizationRules")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeClientVpnAuthorizationRulesResult]
    }
  }

  @js.native
  trait DescribeClientVpnConnectionsRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeClientVpnConnectionsMaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnConnectionsRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeClientVpnConnectionsMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnConnectionsRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeClientVpnConnectionsRequest]
    }
  }

  @js.native
  trait DescribeClientVpnConnectionsResult extends js.Object {
    var Connections: js.UndefOr[ClientVpnConnectionSet]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnConnectionsResult {
    @inline
    def apply(
        Connections: js.UndefOr[ClientVpnConnectionSet] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnConnectionsResult = {
      val __obj = js.Dynamic.literal()
      Connections.foreach(__v => __obj.updateDynamic("Connections")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeClientVpnConnectionsResult]
    }
  }

  @js.native
  trait DescribeClientVpnEndpointsRequest extends js.Object {
    var ClientVpnEndpointIds: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeClientVpnEndpointMaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnEndpointsRequest {
    @inline
    def apply(
        ClientVpnEndpointIds: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeClientVpnEndpointMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnEndpointsRequest = {
      val __obj = js.Dynamic.literal()
      ClientVpnEndpointIds.foreach(__v => __obj.updateDynamic("ClientVpnEndpointIds")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeClientVpnEndpointsRequest]
    }
  }

  @js.native
  trait DescribeClientVpnEndpointsResult extends js.Object {
    var ClientVpnEndpoints: js.UndefOr[EndpointSet]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnEndpointsResult {
    @inline
    def apply(
        ClientVpnEndpoints: js.UndefOr[EndpointSet] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnEndpointsResult = {
      val __obj = js.Dynamic.literal()
      ClientVpnEndpoints.foreach(__v => __obj.updateDynamic("ClientVpnEndpoints")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeClientVpnEndpointsResult]
    }
  }

  @js.native
  trait DescribeClientVpnRoutesRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeClientVpnRoutesMaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnRoutesRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeClientVpnRoutesMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnRoutesRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeClientVpnRoutesRequest]
    }
  }

  @js.native
  trait DescribeClientVpnRoutesResult extends js.Object {
    var NextToken: js.UndefOr[NextToken]
    var Routes: js.UndefOr[ClientVpnRouteSet]
  }

  object DescribeClientVpnRoutesResult {
    @inline
    def apply(
        NextToken: js.UndefOr[NextToken] = js.undefined,
        Routes: js.UndefOr[ClientVpnRouteSet] = js.undefined
    ): DescribeClientVpnRoutesResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      Routes.foreach(__v => __obj.updateDynamic("Routes")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeClientVpnRoutesResult]
    }
  }

  @js.native
  trait DescribeClientVpnTargetNetworksRequest extends js.Object {
    var ClientVpnEndpointId: String
    var AssociationIds: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeClientVpnTargetNetworksMaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnTargetNetworksRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        AssociationIds: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeClientVpnTargetNetworksMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnTargetNetworksRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any]
      )

      AssociationIds.foreach(__v => __obj.updateDynamic("AssociationIds")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeClientVpnTargetNetworksRequest]
    }
  }

  @js.native
  trait DescribeClientVpnTargetNetworksResult extends js.Object {
    var ClientVpnTargetNetworks: js.UndefOr[TargetNetworkSet]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeClientVpnTargetNetworksResult {
    @inline
    def apply(
        ClientVpnTargetNetworks: js.UndefOr[TargetNetworkSet] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeClientVpnTargetNetworksResult = {
      val __obj = js.Dynamic.literal()
      ClientVpnTargetNetworks.foreach(__v => __obj.updateDynamic("ClientVpnTargetNetworks")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeClientVpnTargetNetworksResult]
    }
  }

  @js.native
  trait DescribeConversionTasksRequest extends js.Object {
    var ConversionTaskIds: js.UndefOr[ConversionIdStringList]
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeConversionTasksRequest {
    @inline
    def apply(
        ConversionTaskIds: js.UndefOr[ConversionIdStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeConversionTasksRequest = {
      val __obj = js.Dynamic.literal()
      ConversionTaskIds.foreach(__v => __obj.updateDynamic("ConversionTaskIds")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeConversionTasksRequest]
    }
  }

  @js.native
  trait DescribeConversionTasksResult extends js.Object {
    var ConversionTasks: js.UndefOr[DescribeConversionTaskList]
  }

  object DescribeConversionTasksResult {
    @inline
    def apply(
        ConversionTasks: js.UndefOr[DescribeConversionTaskList] = js.undefined
    ): DescribeConversionTasksResult = {
      val __obj = js.Dynamic.literal()
      ConversionTasks.foreach(__v => __obj.updateDynamic("ConversionTasks")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeConversionTasksResult]
    }
  }

  /**
    * Contains the parameters for DescribeCustomerGateways.
    */
  @js.native
  trait DescribeCustomerGatewaysRequest extends js.Object {
    var CustomerGatewayIds: js.UndefOr[CustomerGatewayIdStringList]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
  }

  object DescribeCustomerGatewaysRequest {
    @inline
    def apply(
        CustomerGatewayIds: js.UndefOr[CustomerGatewayIdStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined
    ): DescribeCustomerGatewaysRequest = {
      val __obj = js.Dynamic.literal()
      CustomerGatewayIds.foreach(__v => __obj.updateDynamic("CustomerGatewayIds")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeCustomerGatewaysRequest]
    }
  }

  /**
    * Contains the output of DescribeCustomerGateways.
    */
  @js.native
  trait DescribeCustomerGatewaysResult extends js.Object {
    var CustomerGateways: js.UndefOr[CustomerGatewayList]
  }

  object DescribeCustomerGatewaysResult {
    @inline
    def apply(
        CustomerGateways: js.UndefOr[CustomerGatewayList] = js.undefined
    ): DescribeCustomerGatewaysResult = {
      val __obj = js.Dynamic.literal()
      CustomerGateways.foreach(__v => __obj.updateDynamic("CustomerGateways")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeCustomerGatewaysResult]
    }
  }

  @js.native
  trait DescribeDhcpOptionsRequest extends js.Object {
    var DhcpOptionsIds: js.UndefOr[DhcpOptionsIdStringList]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeDhcpOptionsMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeDhcpOptionsRequest {
    @inline
    def apply(
        DhcpOptionsIds: js.UndefOr[DhcpOptionsIdStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeDhcpOptionsMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeDhcpOptionsRequest = {
      val __obj = js.Dynamic.literal()
      DhcpOptionsIds.foreach(__v => __obj.updateDynamic("DhcpOptionsIds")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeDhcpOptionsRequest]
    }
  }

  @js.native
  trait DescribeDhcpOptionsResult extends js.Object {
    var DhcpOptions: js.UndefOr[DhcpOptionsList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeDhcpOptionsResult {
    @inline
    def apply(
        DhcpOptions: js.UndefOr[DhcpOptionsList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeDhcpOptionsResult = {
      val __obj = js.Dynamic.literal()
      DhcpOptions.foreach(__v => __obj.updateDynamic("DhcpOptions")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeDhcpOptionsResult]
    }
  }

  @js.native
  trait DescribeEgressOnlyInternetGatewaysRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var EgressOnlyInternetGatewayIds: js.UndefOr[EgressOnlyInternetGatewayIdList]
    var MaxResults: js.UndefOr[DescribeEgressOnlyInternetGatewaysMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeEgressOnlyInternetGatewaysRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EgressOnlyInternetGatewayIds: js.UndefOr[EgressOnlyInternetGatewayIdList] = js.undefined,
        MaxResults: js.UndefOr[DescribeEgressOnlyInternetGatewaysMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeEgressOnlyInternetGatewaysRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      EgressOnlyInternetGatewayIds.foreach(
        __v => __obj.updateDynamic("EgressOnlyInternetGatewayIds")(__v.asInstanceOf[js.Any])
      )
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeEgressOnlyInternetGatewaysRequest]
    }
  }

  @js.native
  trait DescribeEgressOnlyInternetGatewaysResult extends js.Object {
    var EgressOnlyInternetGateways: js.UndefOr[EgressOnlyInternetGatewayList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeEgressOnlyInternetGatewaysResult {
    @inline
    def apply(
        EgressOnlyInternetGateways: js.UndefOr[EgressOnlyInternetGatewayList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeEgressOnlyInternetGatewaysResult = {
      val __obj = js.Dynamic.literal()
      EgressOnlyInternetGateways.foreach(
        __v => __obj.updateDynamic("EgressOnlyInternetGateways")(__v.asInstanceOf[js.Any])
      )
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeEgressOnlyInternetGatewaysResult]
    }
  }

  @js.native
  trait DescribeElasticGpusRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var ElasticGpuIds: js.UndefOr[ElasticGpuIdSet]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeElasticGpusMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeElasticGpusRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ElasticGpuIds: js.UndefOr[ElasticGpuIdSet] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeElasticGpusMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeElasticGpusRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      ElasticGpuIds.foreach(__v => __obj.updateDynamic("ElasticGpuIds")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeElasticGpusRequest]
    }
  }

  @js.native
  trait DescribeElasticGpusResult extends js.Object {
    var ElasticGpuSet: js.UndefOr[ElasticGpuSet]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeElasticGpusResult {
    @inline
    def apply(
        ElasticGpuSet: js.UndefOr[ElasticGpuSet] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeElasticGpusResult = {
      val __obj = js.Dynamic.literal()
      ElasticGpuSet.foreach(__v => __obj.updateDynamic("ElasticGpuSet")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeElasticGpusResult]
    }
  }

  @js.native
  trait DescribeExportImageTasksRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var ExportImageTaskIds: js.UndefOr[ExportImageTaskIdList]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeExportImageTasksMaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeExportImageTasksRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ExportImageTaskIds: js.UndefOr[ExportImageTaskIdList] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeExportImageTasksMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeExportImageTasksRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      ExportImageTaskIds.foreach(__v => __obj.updateDynamic("ExportImageTaskIds")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeExportImageTasksRequest]
    }
  }

  @js.native
  trait DescribeExportImageTasksResult extends js.Object {
    var ExportImageTasks: js.UndefOr[ExportImageTaskList]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeExportImageTasksResult {
    @inline
    def apply(
        ExportImageTasks: js.UndefOr[ExportImageTaskList] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeExportImageTasksResult = {
      val __obj = js.Dynamic.literal()
      ExportImageTasks.foreach(__v => __obj.updateDynamic("ExportImageTasks")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeExportImageTasksResult]
    }
  }

  @js.native
  trait DescribeExportTasksRequest extends js.Object {
    var ExportTaskIds: js.UndefOr[ExportTaskIdStringList]
  }

  object DescribeExportTasksRequest {
    @inline
    def apply(
        ExportTaskIds: js.UndefOr[ExportTaskIdStringList] = js.undefined
    ): DescribeExportTasksRequest = {
      val __obj = js.Dynamic.literal()
      ExportTaskIds.foreach(__v => __obj.updateDynamic("ExportTaskIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeExportTasksRequest]
    }
  }

  @js.native
  trait DescribeExportTasksResult extends js.Object {
    var ExportTasks: js.UndefOr[ExportTaskList]
  }

  object DescribeExportTasksResult {
    @inline
    def apply(
        ExportTasks: js.UndefOr[ExportTaskList] = js.undefined
    ): DescribeExportTasksResult = {
      val __obj = js.Dynamic.literal()
      ExportTasks.foreach(__v => __obj.updateDynamic("ExportTasks")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeExportTasksResult]
    }
  }

  /**
    * Describes the instances that could not be launched by the fleet.
    */
  @js.native
  trait DescribeFleetError extends js.Object {
    var ErrorCode: js.UndefOr[String]
    var ErrorMessage: js.UndefOr[String]
    var LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse]
    var Lifecycle: js.UndefOr[InstanceLifecycle]
  }

  object DescribeFleetError {
    @inline
    def apply(
        ErrorCode: js.UndefOr[String] = js.undefined,
        ErrorMessage: js.UndefOr[String] = js.undefined,
        LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse] = js.undefined,
        Lifecycle: js.UndefOr[InstanceLifecycle] = js.undefined
    ): DescribeFleetError = {
      val __obj = js.Dynamic.literal()
      ErrorCode.foreach(__v => __obj.updateDynamic("ErrorCode")(__v.asInstanceOf[js.Any]))
      ErrorMessage.foreach(__v => __obj.updateDynamic("ErrorMessage")(__v.asInstanceOf[js.Any]))
      LaunchTemplateAndOverrides.foreach(
        __v => __obj.updateDynamic("LaunchTemplateAndOverrides")(__v.asInstanceOf[js.Any])
      )
      Lifecycle.foreach(__v => __obj.updateDynamic("Lifecycle")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFleetError]
    }
  }

  @js.native
  trait DescribeFleetHistoryRequest extends js.Object {
    var FleetId: FleetIdentifier
    var StartTime: DateTime
    var DryRun: js.UndefOr[Boolean]
    var EventType: js.UndefOr[FleetEventType]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFleetHistoryRequest {
    @inline
    def apply(
        FleetId: FleetIdentifier,
        StartTime: DateTime,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EventType: js.UndefOr[FleetEventType] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFleetHistoryRequest = {
      val __obj = js.Dynamic.literal(
        "FleetId"   -> FleetId.asInstanceOf[js.Any],
        "StartTime" -> StartTime.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      EventType.foreach(__v => __obj.updateDynamic("EventType")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFleetHistoryRequest]
    }
  }

  @js.native
  trait DescribeFleetHistoryResult extends js.Object {
    var FleetId: js.UndefOr[FleetIdentifier]
    var HistoryRecords: js.UndefOr[HistoryRecordSet]
    var LastEvaluatedTime: js.UndefOr[DateTime]
    var NextToken: js.UndefOr[String]
    var StartTime: js.UndefOr[DateTime]
  }

  object DescribeFleetHistoryResult {
    @inline
    def apply(
        FleetId: js.UndefOr[FleetIdentifier] = js.undefined,
        HistoryRecords: js.UndefOr[HistoryRecordSet] = js.undefined,
        LastEvaluatedTime: js.UndefOr[DateTime] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        StartTime: js.UndefOr[DateTime] = js.undefined
    ): DescribeFleetHistoryResult = {
      val __obj = js.Dynamic.literal()
      FleetId.foreach(__v => __obj.updateDynamic("FleetId")(__v.asInstanceOf[js.Any]))
      HistoryRecords.foreach(__v => __obj.updateDynamic("HistoryRecords")(__v.asInstanceOf[js.Any]))
      LastEvaluatedTime.foreach(__v => __obj.updateDynamic("LastEvaluatedTime")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      StartTime.foreach(__v => __obj.updateDynamic("StartTime")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFleetHistoryResult]
    }
  }

  @js.native
  trait DescribeFleetInstancesRequest extends js.Object {
    var FleetId: FleetIdentifier
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFleetInstancesRequest {
    @inline
    def apply(
        FleetId: FleetIdentifier,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFleetInstancesRequest = {
      val __obj = js.Dynamic.literal(
        "FleetId" -> FleetId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFleetInstancesRequest]
    }
  }

  @js.native
  trait DescribeFleetInstancesResult extends js.Object {
    var ActiveInstances: js.UndefOr[ActiveInstanceSet]
    var FleetId: js.UndefOr[FleetIdentifier]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFleetInstancesResult {
    @inline
    def apply(
        ActiveInstances: js.UndefOr[ActiveInstanceSet] = js.undefined,
        FleetId: js.UndefOr[FleetIdentifier] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFleetInstancesResult = {
      val __obj = js.Dynamic.literal()
      ActiveInstances.foreach(__v => __obj.updateDynamic("ActiveInstances")(__v.asInstanceOf[js.Any]))
      FleetId.foreach(__v => __obj.updateDynamic("FleetId")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFleetInstancesResult]
    }
  }

  /**
    * Describes the instances that were launched by the fleet.
    */
  @js.native
  trait DescribeFleetsInstances extends js.Object {
    var InstanceIds: js.UndefOr[InstanceIdsSet]
    var InstanceType: js.UndefOr[InstanceType]
    var LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse]
    var Lifecycle: js.UndefOr[InstanceLifecycle]
    var Platform: js.UndefOr[PlatformValues]
  }

  object DescribeFleetsInstances {
    @inline
    def apply(
        InstanceIds: js.UndefOr[InstanceIdsSet] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        LaunchTemplateAndOverrides: js.UndefOr[LaunchTemplateAndOverridesResponse] = js.undefined,
        Lifecycle: js.UndefOr[InstanceLifecycle] = js.undefined,
        Platform: js.UndefOr[PlatformValues] = js.undefined
    ): DescribeFleetsInstances = {
      val __obj = js.Dynamic.literal()
      InstanceIds.foreach(__v => __obj.updateDynamic("InstanceIds")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      LaunchTemplateAndOverrides.foreach(
        __v => __obj.updateDynamic("LaunchTemplateAndOverrides")(__v.asInstanceOf[js.Any])
      )
      Lifecycle.foreach(__v => __obj.updateDynamic("Lifecycle")(__v.asInstanceOf[js.Any]))
      Platform.foreach(__v => __obj.updateDynamic("Platform")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFleetsInstances]
    }
  }

  @js.native
  trait DescribeFleetsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var FleetIds: js.UndefOr[FleetIdSet]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFleetsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        FleetIds: js.UndefOr[FleetIdSet] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFleetsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      FleetIds.foreach(__v => __obj.updateDynamic("FleetIds")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFleetsRequest]
    }
  }

  @js.native
  trait DescribeFleetsResult extends js.Object {
    var Fleets: js.UndefOr[FleetSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFleetsResult {
    @inline
    def apply(
        Fleets: js.UndefOr[FleetSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFleetsResult = {
      val __obj = js.Dynamic.literal()
      Fleets.foreach(__v => __obj.updateDynamic("Fleets")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFleetsResult]
    }
  }

  @js.native
  trait DescribeFlowLogsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filter: js.UndefOr[FilterList]
    var FlowLogIds: js.UndefOr[ValueStringList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFlowLogsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filter: js.UndefOr[FilterList] = js.undefined,
        FlowLogIds: js.UndefOr[ValueStringList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFlowLogsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filter.foreach(__v => __obj.updateDynamic("Filter")(__v.asInstanceOf[js.Any]))
      FlowLogIds.foreach(__v => __obj.updateDynamic("FlowLogIds")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFlowLogsRequest]
    }
  }

  @js.native
  trait DescribeFlowLogsResult extends js.Object {
    var FlowLogs: js.UndefOr[FlowLogSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeFlowLogsResult {
    @inline
    def apply(
        FlowLogs: js.UndefOr[FlowLogSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeFlowLogsResult = {
      val __obj = js.Dynamic.literal()
      FlowLogs.foreach(__v => __obj.updateDynamic("FlowLogs")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFlowLogsResult]
    }
  }

  @js.native
  trait DescribeFpgaImageAttributeRequest extends js.Object {
    var Attribute: FpgaImageAttributeName
    var FpgaImageId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeFpgaImageAttributeRequest {
    @inline
    def apply(
        Attribute: FpgaImageAttributeName,
        FpgaImageId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeFpgaImageAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "Attribute"   -> Attribute.asInstanceOf[js.Any],
        "FpgaImageId" -> FpgaImageId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFpgaImageAttributeRequest]
    }
  }

  @js.native
  trait DescribeFpgaImageAttributeResult extends js.Object {
    var FpgaImageAttribute: js.UndefOr[FpgaImageAttribute]
  }

  object DescribeFpgaImageAttributeResult {
    @inline
    def apply(
        FpgaImageAttribute: js.UndefOr[FpgaImageAttribute] = js.undefined
    ): DescribeFpgaImageAttributeResult = {
      val __obj = js.Dynamic.literal()
      FpgaImageAttribute.foreach(__v => __obj.updateDynamic("FpgaImageAttribute")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFpgaImageAttributeResult]
    }
  }

  @js.native
  trait DescribeFpgaImagesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var FpgaImageIds: js.UndefOr[FpgaImageIdList]
    var MaxResults: js.UndefOr[DescribeFpgaImagesMaxResults]
    var NextToken: js.UndefOr[NextToken]
    var Owners: js.UndefOr[OwnerStringList]
  }

  object DescribeFpgaImagesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        FpgaImageIds: js.UndefOr[FpgaImageIdList] = js.undefined,
        MaxResults: js.UndefOr[DescribeFpgaImagesMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined,
        Owners: js.UndefOr[OwnerStringList] = js.undefined
    ): DescribeFpgaImagesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      FpgaImageIds.foreach(__v => __obj.updateDynamic("FpgaImageIds")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      Owners.foreach(__v => __obj.updateDynamic("Owners")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFpgaImagesRequest]
    }
  }

  @js.native
  trait DescribeFpgaImagesResult extends js.Object {
    var FpgaImages: js.UndefOr[FpgaImageList]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeFpgaImagesResult {
    @inline
    def apply(
        FpgaImages: js.UndefOr[FpgaImageList] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeFpgaImagesResult = {
      val __obj = js.Dynamic.literal()
      FpgaImages.foreach(__v => __obj.updateDynamic("FpgaImages")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeFpgaImagesResult]
    }
  }

  @js.native
  trait DescribeHostReservationOfferingsRequest extends js.Object {
    var Filter: js.UndefOr[FilterList]
    var MaxDuration: js.UndefOr[Int]
    var MaxResults: js.UndefOr[DescribeHostReservationsMaxResults]
    var MinDuration: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var OfferingId: js.UndefOr[String]
  }

  object DescribeHostReservationOfferingsRequest {
    @inline
    def apply(
        Filter: js.UndefOr[FilterList] = js.undefined,
        MaxDuration: js.UndefOr[Int] = js.undefined,
        MaxResults: js.UndefOr[DescribeHostReservationsMaxResults] = js.undefined,
        MinDuration: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        OfferingId: js.UndefOr[String] = js.undefined
    ): DescribeHostReservationOfferingsRequest = {
      val __obj = js.Dynamic.literal()
      Filter.foreach(__v => __obj.updateDynamic("Filter")(__v.asInstanceOf[js.Any]))
      MaxDuration.foreach(__v => __obj.updateDynamic("MaxDuration")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      MinDuration.foreach(__v => __obj.updateDynamic("MinDuration")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      OfferingId.foreach(__v => __obj.updateDynamic("OfferingId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeHostReservationOfferingsRequest]
    }
  }

  @js.native
  trait DescribeHostReservationOfferingsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var OfferingSet: js.UndefOr[HostOfferingSet]
  }

  object DescribeHostReservationOfferingsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        OfferingSet: js.UndefOr[HostOfferingSet] = js.undefined
    ): DescribeHostReservationOfferingsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      OfferingSet.foreach(__v => __obj.updateDynamic("OfferingSet")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeHostReservationOfferingsResult]
    }
  }

  @js.native
  trait DescribeHostReservationsRequest extends js.Object {
    var Filter: js.UndefOr[FilterList]
    var HostReservationIdSet: js.UndefOr[HostReservationIdSet]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeHostReservationsRequest {
    @inline
    def apply(
        Filter: js.UndefOr[FilterList] = js.undefined,
        HostReservationIdSet: js.UndefOr[HostReservationIdSet] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeHostReservationsRequest = {
      val __obj = js.Dynamic.literal()
      Filter.foreach(__v => __obj.updateDynamic("Filter")(__v.asInstanceOf[js.Any]))
      HostReservationIdSet.foreach(__v => __obj.updateDynamic("HostReservationIdSet")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeHostReservationsRequest]
    }
  }

  @js.native
  trait DescribeHostReservationsResult extends js.Object {
    var HostReservationSet: js.UndefOr[HostReservationSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeHostReservationsResult {
    @inline
    def apply(
        HostReservationSet: js.UndefOr[HostReservationSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeHostReservationsResult = {
      val __obj = js.Dynamic.literal()
      HostReservationSet.foreach(__v => __obj.updateDynamic("HostReservationSet")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeHostReservationsResult]
    }
  }

  @js.native
  trait DescribeHostsRequest extends js.Object {
    var Filter: js.UndefOr[FilterList]
    var HostIds: js.UndefOr[RequestHostIdList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeHostsRequest {
    @inline
    def apply(
        Filter: js.UndefOr[FilterList] = js.undefined,
        HostIds: js.UndefOr[RequestHostIdList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeHostsRequest = {
      val __obj = js.Dynamic.literal()
      Filter.foreach(__v => __obj.updateDynamic("Filter")(__v.asInstanceOf[js.Any]))
      HostIds.foreach(__v => __obj.updateDynamic("HostIds")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeHostsRequest]
    }
  }

  @js.native
  trait DescribeHostsResult extends js.Object {
    var Hosts: js.UndefOr[HostList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeHostsResult {
    @inline
    def apply(
        Hosts: js.UndefOr[HostList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeHostsResult = {
      val __obj = js.Dynamic.literal()
      Hosts.foreach(__v => __obj.updateDynamic("Hosts")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeHostsResult]
    }
  }

  @js.native
  trait DescribeIamInstanceProfileAssociationsRequest extends js.Object {
    var AssociationIds: js.UndefOr[AssociationIdList]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeIamInstanceProfileAssociationsMaxResults]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeIamInstanceProfileAssociationsRequest {
    @inline
    def apply(
        AssociationIds: js.UndefOr[AssociationIdList] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeIamInstanceProfileAssociationsMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeIamInstanceProfileAssociationsRequest = {
      val __obj = js.Dynamic.literal()
      AssociationIds.foreach(__v => __obj.updateDynamic("AssociationIds")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeIamInstanceProfileAssociationsRequest]
    }
  }

  @js.native
  trait DescribeIamInstanceProfileAssociationsResult extends js.Object {
    var IamInstanceProfileAssociations: js.UndefOr[IamInstanceProfileAssociationSet]
    var NextToken: js.UndefOr[NextToken]
  }

  object DescribeIamInstanceProfileAssociationsResult {
    @inline
    def apply(
        IamInstanceProfileAssociations: js.UndefOr[IamInstanceProfileAssociationSet] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined
    ): DescribeIamInstanceProfileAssociationsResult = {
      val __obj = js.Dynamic.literal()
      IamInstanceProfileAssociations.foreach(
        __v => __obj.updateDynamic("IamInstanceProfileAssociations")(__v.asInstanceOf[js.Any])
      )
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeIamInstanceProfileAssociationsResult]
    }
  }

  @js.native
  trait DescribeIdFormatRequest extends js.Object {
    var Resource: js.UndefOr[String]
  }

  object DescribeIdFormatRequest {
    @inline
    def apply(
        Resource: js.UndefOr[String] = js.undefined
    ): DescribeIdFormatRequest = {
      val __obj = js.Dynamic.literal()
      Resource.foreach(__v => __obj.updateDynamic("Resource")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeIdFormatRequest]
    }
  }

  @js.native
  trait DescribeIdFormatResult extends js.Object {
    var Statuses: js.UndefOr[IdFormatList]
  }

  object DescribeIdFormatResult {
    @inline
    def apply(
        Statuses: js.UndefOr[IdFormatList] = js.undefined
    ): DescribeIdFormatResult = {
      val __obj = js.Dynamic.literal()
      Statuses.foreach(__v => __obj.updateDynamic("Statuses")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeIdFormatResult]
    }
  }

  @js.native
  trait DescribeIdentityIdFormatRequest extends js.Object {
    var PrincipalArn: String
    var Resource: js.UndefOr[String]
  }

  object DescribeIdentityIdFormatRequest {
    @inline
    def apply(
        PrincipalArn: String,
        Resource: js.UndefOr[String] = js.undefined
    ): DescribeIdentityIdFormatRequest = {
      val __obj = js.Dynamic.literal(
        "PrincipalArn" -> PrincipalArn.asInstanceOf[js.Any]
      )

      Resource.foreach(__v => __obj.updateDynamic("Resource")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeIdentityIdFormatRequest]
    }
  }

  @js.native
  trait DescribeIdentityIdFormatResult extends js.Object {
    var Statuses: js.UndefOr[IdFormatList]
  }

  object DescribeIdentityIdFormatResult {
    @inline
    def apply(
        Statuses: js.UndefOr[IdFormatList] = js.undefined
    ): DescribeIdentityIdFormatResult = {
      val __obj = js.Dynamic.literal()
      Statuses.foreach(__v => __obj.updateDynamic("Statuses")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeIdentityIdFormatResult]
    }
  }

  /**
    * Contains the parameters for DescribeImageAttribute.
    */
  @js.native
  trait DescribeImageAttributeRequest extends js.Object {
    var Attribute: ImageAttributeName
    var ImageId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeImageAttributeRequest {
    @inline
    def apply(
        Attribute: ImageAttributeName,
        ImageId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeImageAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "Attribute" -> Attribute.asInstanceOf[js.Any],
        "ImageId"   -> ImageId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeImageAttributeRequest]
    }
  }

  @js.native
  trait DescribeImagesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var ExecutableUsers: js.UndefOr[ExecutableByStringList]
    var Filters: js.UndefOr[FilterList]
    var ImageIds: js.UndefOr[ImageIdStringList]
    var Owners: js.UndefOr[OwnerStringList]
  }

  object DescribeImagesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ExecutableUsers: js.UndefOr[ExecutableByStringList] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        ImageIds: js.UndefOr[ImageIdStringList] = js.undefined,
        Owners: js.UndefOr[OwnerStringList] = js.undefined
    ): DescribeImagesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      ExecutableUsers.foreach(__v => __obj.updateDynamic("ExecutableUsers")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      ImageIds.foreach(__v => __obj.updateDynamic("ImageIds")(__v.asInstanceOf[js.Any]))
      Owners.foreach(__v => __obj.updateDynamic("Owners")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeImagesRequest]
    }
  }

  @js.native
  trait DescribeImagesResult extends js.Object {
    var Images: js.UndefOr[ImageList]
  }

  object DescribeImagesResult {
    @inline
    def apply(
        Images: js.UndefOr[ImageList] = js.undefined
    ): DescribeImagesResult = {
      val __obj = js.Dynamic.literal()
      Images.foreach(__v => __obj.updateDynamic("Images")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeImagesResult]
    }
  }

  @js.native
  trait DescribeImportImageTasksRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var ImportTaskIds: js.UndefOr[ImportTaskIdList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeImportImageTasksRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        ImportTaskIds: js.UndefOr[ImportTaskIdList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeImportImageTasksRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      ImportTaskIds.foreach(__v => __obj.updateDynamic("ImportTaskIds")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeImportImageTasksRequest]
    }
  }

  @js.native
  trait DescribeImportImageTasksResult extends js.Object {
    var ImportImageTasks: js.UndefOr[ImportImageTaskList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeImportImageTasksResult {
    @inline
    def apply(
        ImportImageTasks: js.UndefOr[ImportImageTaskList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeImportImageTasksResult = {
      val __obj = js.Dynamic.literal()
      ImportImageTasks.foreach(__v => __obj.updateDynamic("ImportImageTasks")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeImportImageTasksResult]
    }
  }

  @js.native
  trait DescribeImportSnapshotTasksRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var ImportTaskIds: js.UndefOr[ImportTaskIdList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeImportSnapshotTasksRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        ImportTaskIds: js.UndefOr[ImportTaskIdList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeImportSnapshotTasksRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      ImportTaskIds.foreach(__v => __obj.updateDynamic("ImportTaskIds")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeImportSnapshotTasksRequest]
    }
  }

  @js.native
  trait DescribeImportSnapshotTasksResult extends js.Object {
    var ImportSnapshotTasks: js.UndefOr[ImportSnapshotTaskList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeImportSnapshotTasksResult {
    @inline
    def apply(
        ImportSnapshotTasks: js.UndefOr[ImportSnapshotTaskList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeImportSnapshotTasksResult = {
      val __obj = js.Dynamic.literal()
      ImportSnapshotTasks.foreach(__v => __obj.updateDynamic("ImportSnapshotTasks")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeImportSnapshotTasksResult]
    }
  }

  @js.native
  trait DescribeInstanceAttributeRequest extends js.Object {
    var Attribute: InstanceAttributeName
    var InstanceId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeInstanceAttributeRequest {
    @inline
    def apply(
        Attribute: InstanceAttributeName,
        InstanceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeInstanceAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "Attribute"  -> Attribute.asInstanceOf[js.Any],
        "InstanceId" -> InstanceId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeInstanceAttributeRequest]
    }
  }

  @js.native
  trait DescribeInstanceCreditSpecificationsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var InstanceIds: js.UndefOr[InstanceIdStringList]
    var MaxResults: js.UndefOr[DescribeInstanceCreditSpecificationsMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInstanceCreditSpecificationsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        InstanceIds: js.UndefOr[InstanceIdStringList] = js.undefined,
        MaxResults: js.UndefOr[DescribeInstanceCreditSpecificationsMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInstanceCreditSpecificationsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      InstanceIds.foreach(__v => __obj.updateDynamic("InstanceIds")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeInstanceCreditSpecificationsRequest]
    }
  }

  @js.native
  trait DescribeInstanceCreditSpecificationsResult extends js.Object {
    var InstanceCreditSpecifications: js.UndefOr[InstanceCreditSpecificationList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInstanceCreditSpecificationsResult {
    @inline
    def apply(
        InstanceCreditSpecifications: js.UndefOr[InstanceCreditSpecificationList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInstanceCreditSpecificationsResult = {
      val __obj = js.Dynamic.literal()
      InstanceCreditSpecifications.foreach(
        __v => __obj.updateDynamic("InstanceCreditSpecifications")(__v.asInstanceOf[js.Any])
      )
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeInstanceCreditSpecificationsResult]
    }
  }

  @js.native
  trait DescribeInstanceStatusRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var IncludeAllInstances: js.UndefOr[Boolean]
    var InstanceIds: js.UndefOr[InstanceIdStringList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInstanceStatusRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        IncludeAllInstances: js.UndefOr[Boolean] = js.undefined,
        InstanceIds: js.UndefOr[InstanceIdStringList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInstanceStatusRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      IncludeAllInstances.foreach(__v => __obj.updateDynamic("IncludeAllInstances")(__v.asInstanceOf[js.Any]))
      InstanceIds.foreach(__v => __obj.updateDynamic("InstanceIds")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeInstanceStatusRequest]
    }
  }

  @js.native
  trait DescribeInstanceStatusResult extends js.Object {
    var InstanceStatuses: js.UndefOr[InstanceStatusList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInstanceStatusResult {
    @inline
    def apply(
        InstanceStatuses: js.UndefOr[InstanceStatusList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInstanceStatusResult = {
      val __obj = js.Dynamic.literal()
      InstanceStatuses.foreach(__v => __obj.updateDynamic("InstanceStatuses")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeInstanceStatusResult]
    }
  }

  @js.native
  trait DescribeInstancesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var InstanceIds: js.UndefOr[InstanceIdStringList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInstancesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        InstanceIds: js.UndefOr[InstanceIdStringList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInstancesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      InstanceIds.foreach(__v => __obj.updateDynamic("InstanceIds")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeInstancesRequest]
    }
  }

  @js.native
  trait DescribeInstancesResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Reservations: js.UndefOr[ReservationList]
  }

  object DescribeInstancesResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Reservations: js.UndefOr[ReservationList] = js.undefined
    ): DescribeInstancesResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      Reservations.foreach(__v => __obj.updateDynamic("Reservations")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeInstancesResult]
    }
  }

  @js.native
  trait DescribeInternetGatewaysRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var InternetGatewayIds: js.UndefOr[ValueStringList]
    var MaxResults: js.UndefOr[DescribeInternetGatewaysMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInternetGatewaysRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        InternetGatewayIds: js.UndefOr[ValueStringList] = js.undefined,
        MaxResults: js.UndefOr[DescribeInternetGatewaysMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInternetGatewaysRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      InternetGatewayIds.foreach(__v => __obj.updateDynamic("InternetGatewayIds")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeInternetGatewaysRequest]
    }
  }

  @js.native
  trait DescribeInternetGatewaysResult extends js.Object {
    var InternetGateways: js.UndefOr[InternetGatewayList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeInternetGatewaysResult {
    @inline
    def apply(
        InternetGateways: js.UndefOr[InternetGatewayList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeInternetGatewaysResult = {
      val __obj = js.Dynamic.literal()
      InternetGateways.foreach(__v => __obj.updateDynamic("InternetGateways")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeInternetGatewaysResult]
    }
  }

  @js.native
  trait DescribeKeyPairsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var KeyNames: js.UndefOr[KeyNameStringList]
  }

  object DescribeKeyPairsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        KeyNames: js.UndefOr[KeyNameStringList] = js.undefined
    ): DescribeKeyPairsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      KeyNames.foreach(__v => __obj.updateDynamic("KeyNames")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeKeyPairsRequest]
    }
  }

  @js.native
  trait DescribeKeyPairsResult extends js.Object {
    var KeyPairs: js.UndefOr[KeyPairList]
  }

  object DescribeKeyPairsResult {
    @inline
    def apply(
        KeyPairs: js.UndefOr[KeyPairList] = js.undefined
    ): DescribeKeyPairsResult = {
      val __obj = js.Dynamic.literal()
      KeyPairs.foreach(__v => __obj.updateDynamic("KeyPairs")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeKeyPairsResult]
    }
  }

  @js.native
  trait DescribeLaunchTemplateVersionsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
    var MaxResults: js.UndefOr[Int]
    var MaxVersion: js.UndefOr[String]
    var MinVersion: js.UndefOr[String]
    var NextToken: js.UndefOr[String]
    var Versions: js.UndefOr[VersionStringList]
  }

  object DescribeLaunchTemplateVersionsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        MaxVersion: js.UndefOr[String] = js.undefined,
        MinVersion: js.UndefOr[String] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        Versions: js.UndefOr[VersionStringList] = js.undefined
    ): DescribeLaunchTemplateVersionsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      LaunchTemplateId.foreach(__v => __obj.updateDynamic("LaunchTemplateId")(__v.asInstanceOf[js.Any]))
      LaunchTemplateName.foreach(__v => __obj.updateDynamic("LaunchTemplateName")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      MaxVersion.foreach(__v => __obj.updateDynamic("MaxVersion")(__v.asInstanceOf[js.Any]))
      MinVersion.foreach(__v => __obj.updateDynamic("MinVersion")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      Versions.foreach(__v => __obj.updateDynamic("Versions")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeLaunchTemplateVersionsRequest]
    }
  }

  @js.native
  trait DescribeLaunchTemplateVersionsResult extends js.Object {
    var LaunchTemplateVersions: js.UndefOr[LaunchTemplateVersionSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeLaunchTemplateVersionsResult {
    @inline
    def apply(
        LaunchTemplateVersions: js.UndefOr[LaunchTemplateVersionSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeLaunchTemplateVersionsResult = {
      val __obj = js.Dynamic.literal()
      LaunchTemplateVersions.foreach(__v => __obj.updateDynamic("LaunchTemplateVersions")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeLaunchTemplateVersionsResult]
    }
  }

  @js.native
  trait DescribeLaunchTemplatesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var LaunchTemplateIds: js.UndefOr[ValueStringList]
    var LaunchTemplateNames: js.UndefOr[LaunchTemplateNameStringList]
    var MaxResults: js.UndefOr[DescribeLaunchTemplatesMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeLaunchTemplatesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        LaunchTemplateIds: js.UndefOr[ValueStringList] = js.undefined,
        LaunchTemplateNames: js.UndefOr[LaunchTemplateNameStringList] = js.undefined,
        MaxResults: js.UndefOr[DescribeLaunchTemplatesMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeLaunchTemplatesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      LaunchTemplateIds.foreach(__v => __obj.updateDynamic("LaunchTemplateIds")(__v.asInstanceOf[js.Any]))
      LaunchTemplateNames.foreach(__v => __obj.updateDynamic("LaunchTemplateNames")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeLaunchTemplatesRequest]
    }
  }

  @js.native
  trait DescribeLaunchTemplatesResult extends js.Object {
    var LaunchTemplates: js.UndefOr[LaunchTemplateSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeLaunchTemplatesResult {
    @inline
    def apply(
        LaunchTemplates: js.UndefOr[LaunchTemplateSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeLaunchTemplatesResult = {
      val __obj = js.Dynamic.literal()
      LaunchTemplates.foreach(__v => __obj.updateDynamic("LaunchTemplates")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeLaunchTemplatesResult]
    }
  }

  @js.native
  trait DescribeMovingAddressesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeMovingAddressesMaxResults]
    var NextToken: js.UndefOr[String]
    var PublicIps: js.UndefOr[ValueStringList]
  }

  object DescribeMovingAddressesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeMovingAddressesMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        PublicIps: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeMovingAddressesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      PublicIps.foreach(__v => __obj.updateDynamic("PublicIps")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeMovingAddressesRequest]
    }
  }

  @js.native
  trait DescribeMovingAddressesResult extends js.Object {
    var MovingAddressStatuses: js.UndefOr[MovingAddressStatusSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeMovingAddressesResult {
    @inline
    def apply(
        MovingAddressStatuses: js.UndefOr[MovingAddressStatusSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeMovingAddressesResult = {
      val __obj = js.Dynamic.literal()
      MovingAddressStatuses.foreach(__v => __obj.updateDynamic("MovingAddressStatuses")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeMovingAddressesResult]
    }
  }

  @js.native
  trait DescribeNatGatewaysRequest extends js.Object {
    var Filter: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeNatGatewaysMaxResults]
    var NatGatewayIds: js.UndefOr[ValueStringList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNatGatewaysRequest {
    @inline
    def apply(
        Filter: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeNatGatewaysMaxResults] = js.undefined,
        NatGatewayIds: js.UndefOr[ValueStringList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNatGatewaysRequest = {
      val __obj = js.Dynamic.literal()
      Filter.foreach(__v => __obj.updateDynamic("Filter")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NatGatewayIds.foreach(__v => __obj.updateDynamic("NatGatewayIds")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeNatGatewaysRequest]
    }
  }

  @js.native
  trait DescribeNatGatewaysResult extends js.Object {
    var NatGateways: js.UndefOr[NatGatewayList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNatGatewaysResult {
    @inline
    def apply(
        NatGateways: js.UndefOr[NatGatewayList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNatGatewaysResult = {
      val __obj = js.Dynamic.literal()
      NatGateways.foreach(__v => __obj.updateDynamic("NatGateways")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeNatGatewaysResult]
    }
  }

  @js.native
  trait DescribeNetworkAclsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeNetworkAclsMaxResults]
    var NetworkAclIds: js.UndefOr[ValueStringList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNetworkAclsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeNetworkAclsMaxResults] = js.undefined,
        NetworkAclIds: js.UndefOr[ValueStringList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNetworkAclsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NetworkAclIds.foreach(__v => __obj.updateDynamic("NetworkAclIds")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeNetworkAclsRequest]
    }
  }

  @js.native
  trait DescribeNetworkAclsResult extends js.Object {
    var NetworkAcls: js.UndefOr[NetworkAclList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNetworkAclsResult {
    @inline
    def apply(
        NetworkAcls: js.UndefOr[NetworkAclList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNetworkAclsResult = {
      val __obj = js.Dynamic.literal()
      NetworkAcls.foreach(__v => __obj.updateDynamic("NetworkAcls")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeNetworkAclsResult]
    }
  }

  /**
    * Contains the parameters for DescribeNetworkInterfaceAttribute.
    */
  @js.native
  trait DescribeNetworkInterfaceAttributeRequest extends js.Object {
    var NetworkInterfaceId: String
    var Attribute: js.UndefOr[NetworkInterfaceAttribute]
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeNetworkInterfaceAttributeRequest {
    @inline
    def apply(
        NetworkInterfaceId: String,
        Attribute: js.UndefOr[NetworkInterfaceAttribute] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeNetworkInterfaceAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any]
      )

      Attribute.foreach(__v => __obj.updateDynamic("Attribute")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeNetworkInterfaceAttributeRequest]
    }
  }

  /**
    * Contains the output of DescribeNetworkInterfaceAttribute.
    */
  @js.native
  trait DescribeNetworkInterfaceAttributeResult extends js.Object {
    var Attachment: js.UndefOr[NetworkInterfaceAttachment]
    var Description: js.UndefOr[AttributeValue]
    var Groups: js.UndefOr[GroupIdentifierList]
    var NetworkInterfaceId: js.UndefOr[String]
    var SourceDestCheck: js.UndefOr[AttributeBooleanValue]
  }

  object DescribeNetworkInterfaceAttributeResult {
    @inline
    def apply(
        Attachment: js.UndefOr[NetworkInterfaceAttachment] = js.undefined,
        Description: js.UndefOr[AttributeValue] = js.undefined,
        Groups: js.UndefOr[GroupIdentifierList] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        SourceDestCheck: js.UndefOr[AttributeBooleanValue] = js.undefined
    ): DescribeNetworkInterfaceAttributeResult = {
      val __obj = js.Dynamic.literal()
      Attachment.foreach(__v => __obj.updateDynamic("Attachment")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      Groups.foreach(__v => __obj.updateDynamic("Groups")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      SourceDestCheck.foreach(__v => __obj.updateDynamic("SourceDestCheck")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeNetworkInterfaceAttributeResult]
    }
  }

  /**
    * Contains the parameters for DescribeNetworkInterfacePermissions.
    */
  @js.native
  trait DescribeNetworkInterfacePermissionsRequest extends js.Object {
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeNetworkInterfacePermissionsMaxResults]
    var NetworkInterfacePermissionIds: js.UndefOr[NetworkInterfacePermissionIdList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNetworkInterfacePermissionsRequest {
    @inline
    def apply(
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeNetworkInterfacePermissionsMaxResults] = js.undefined,
        NetworkInterfacePermissionIds: js.UndefOr[NetworkInterfacePermissionIdList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNetworkInterfacePermissionsRequest = {
      val __obj = js.Dynamic.literal()
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NetworkInterfacePermissionIds.foreach(
        __v => __obj.updateDynamic("NetworkInterfacePermissionIds")(__v.asInstanceOf[js.Any])
      )
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeNetworkInterfacePermissionsRequest]
    }
  }

  /**
    * Contains the output for DescribeNetworkInterfacePermissions.
    */
  @js.native
  trait DescribeNetworkInterfacePermissionsResult extends js.Object {
    var NetworkInterfacePermissions: js.UndefOr[NetworkInterfacePermissionList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNetworkInterfacePermissionsResult {
    @inline
    def apply(
        NetworkInterfacePermissions: js.UndefOr[NetworkInterfacePermissionList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNetworkInterfacePermissionsResult = {
      val __obj = js.Dynamic.literal()
      NetworkInterfacePermissions.foreach(
        __v => __obj.updateDynamic("NetworkInterfacePermissions")(__v.asInstanceOf[js.Any])
      )
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeNetworkInterfacePermissionsResult]
    }
  }

  /**
    * Contains the parameters for DescribeNetworkInterfaces.
    */
  @js.native
  trait DescribeNetworkInterfacesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeNetworkInterfacesMaxResults]
    var NetworkInterfaceIds: js.UndefOr[NetworkInterfaceIdList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNetworkInterfacesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeNetworkInterfacesMaxResults] = js.undefined,
        NetworkInterfaceIds: js.UndefOr[NetworkInterfaceIdList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNetworkInterfacesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceIds.foreach(__v => __obj.updateDynamic("NetworkInterfaceIds")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeNetworkInterfacesRequest]
    }
  }

  /**
    * Contains the output of DescribeNetworkInterfaces.
    */
  @js.native
  trait DescribeNetworkInterfacesResult extends js.Object {
    var NetworkInterfaces: js.UndefOr[NetworkInterfaceList]
    var NextToken: js.UndefOr[String]
  }

  object DescribeNetworkInterfacesResult {
    @inline
    def apply(
        NetworkInterfaces: js.UndefOr[NetworkInterfaceList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeNetworkInterfacesResult = {
      val __obj = js.Dynamic.literal()
      NetworkInterfaces.foreach(__v => __obj.updateDynamic("NetworkInterfaces")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeNetworkInterfacesResult]
    }
  }

  @js.native
  trait DescribePlacementGroupsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var GroupNames: js.UndefOr[PlacementGroupStringList]
  }

  object DescribePlacementGroupsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        GroupNames: js.UndefOr[PlacementGroupStringList] = js.undefined
    ): DescribePlacementGroupsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      GroupNames.foreach(__v => __obj.updateDynamic("GroupNames")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribePlacementGroupsRequest]
    }
  }

  @js.native
  trait DescribePlacementGroupsResult extends js.Object {
    var PlacementGroups: js.UndefOr[PlacementGroupList]
  }

  object DescribePlacementGroupsResult {
    @inline
    def apply(
        PlacementGroups: js.UndefOr[PlacementGroupList] = js.undefined
    ): DescribePlacementGroupsResult = {
      val __obj = js.Dynamic.literal()
      PlacementGroups.foreach(__v => __obj.updateDynamic("PlacementGroups")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribePlacementGroupsResult]
    }
  }

  @js.native
  trait DescribePrefixListsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var PrefixListIds: js.UndefOr[ValueStringList]
  }

  object DescribePrefixListsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        PrefixListIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribePrefixListsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      PrefixListIds.foreach(__v => __obj.updateDynamic("PrefixListIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribePrefixListsRequest]
    }
  }

  @js.native
  trait DescribePrefixListsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var PrefixLists: js.UndefOr[PrefixListSet]
  }

  object DescribePrefixListsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        PrefixLists: js.UndefOr[PrefixListSet] = js.undefined
    ): DescribePrefixListsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      PrefixLists.foreach(__v => __obj.updateDynamic("PrefixLists")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribePrefixListsResult]
    }
  }

  @js.native
  trait DescribePrincipalIdFormatRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var MaxResults: js.UndefOr[DescribePrincipalIdFormatMaxResults]
    var NextToken: js.UndefOr[String]
    var Resources: js.UndefOr[ResourceList]
  }

  object DescribePrincipalIdFormatRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        MaxResults: js.UndefOr[DescribePrincipalIdFormatMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        Resources: js.UndefOr[ResourceList] = js.undefined
    ): DescribePrincipalIdFormatRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      Resources.foreach(__v => __obj.updateDynamic("Resources")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribePrincipalIdFormatRequest]
    }
  }

  @js.native
  trait DescribePrincipalIdFormatResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Principals: js.UndefOr[PrincipalIdFormatList]
  }

  object DescribePrincipalIdFormatResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Principals: js.UndefOr[PrincipalIdFormatList] = js.undefined
    ): DescribePrincipalIdFormatResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      Principals.foreach(__v => __obj.updateDynamic("Principals")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribePrincipalIdFormatResult]
    }
  }

  @js.native
  trait DescribePublicIpv4PoolsRequest extends js.Object {
    var MaxResults: js.UndefOr[PoolMaxResults]
    var NextToken: js.UndefOr[NextToken]
    var PoolIds: js.UndefOr[ValueStringList]
  }

  object DescribePublicIpv4PoolsRequest {
    @inline
    def apply(
        MaxResults: js.UndefOr[PoolMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined,
        PoolIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribePublicIpv4PoolsRequest = {
      val __obj = js.Dynamic.literal()
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      PoolIds.foreach(__v => __obj.updateDynamic("PoolIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribePublicIpv4PoolsRequest]
    }
  }

  @js.native
  trait DescribePublicIpv4PoolsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var PublicIpv4Pools: js.UndefOr[PublicIpv4PoolSet]
  }

  object DescribePublicIpv4PoolsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        PublicIpv4Pools: js.UndefOr[PublicIpv4PoolSet] = js.undefined
    ): DescribePublicIpv4PoolsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      PublicIpv4Pools.foreach(__v => __obj.updateDynamic("PublicIpv4Pools")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribePublicIpv4PoolsResult]
    }
  }

  @js.native
  trait DescribeRegionsRequest extends js.Object {
    var AllRegions: js.UndefOr[Boolean]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var RegionNames: js.UndefOr[RegionNameStringList]
  }

  object DescribeRegionsRequest {
    @inline
    def apply(
        AllRegions: js.UndefOr[Boolean] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        RegionNames: js.UndefOr[RegionNameStringList] = js.undefined
    ): DescribeRegionsRequest = {
      val __obj = js.Dynamic.literal()
      AllRegions.foreach(__v => __obj.updateDynamic("AllRegions")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      RegionNames.foreach(__v => __obj.updateDynamic("RegionNames")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeRegionsRequest]
    }
  }

  @js.native
  trait DescribeRegionsResult extends js.Object {
    var Regions: js.UndefOr[RegionList]
  }

  object DescribeRegionsResult {
    @inline
    def apply(
        Regions: js.UndefOr[RegionList] = js.undefined
    ): DescribeRegionsResult = {
      val __obj = js.Dynamic.literal()
      Regions.foreach(__v => __obj.updateDynamic("Regions")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeRegionsResult]
    }
  }

  /**
    * Contains the parameters for DescribeReservedInstancesListings.
    */
  @js.native
  trait DescribeReservedInstancesListingsRequest extends js.Object {
    var Filters: js.UndefOr[FilterList]
    var ReservedInstancesId: js.UndefOr[String]
    var ReservedInstancesListingId: js.UndefOr[String]
  }

  object DescribeReservedInstancesListingsRequest {
    @inline
    def apply(
        Filters: js.UndefOr[FilterList] = js.undefined,
        ReservedInstancesId: js.UndefOr[String] = js.undefined,
        ReservedInstancesListingId: js.UndefOr[String] = js.undefined
    ): DescribeReservedInstancesListingsRequest = {
      val __obj = js.Dynamic.literal()
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      ReservedInstancesId.foreach(__v => __obj.updateDynamic("ReservedInstancesId")(__v.asInstanceOf[js.Any]))
      ReservedInstancesListingId.foreach(
        __v => __obj.updateDynamic("ReservedInstancesListingId")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeReservedInstancesListingsRequest]
    }
  }

  /**
    * Contains the output of DescribeReservedInstancesListings.
    */
  @js.native
  trait DescribeReservedInstancesListingsResult extends js.Object {
    var ReservedInstancesListings: js.UndefOr[ReservedInstancesListingList]
  }

  object DescribeReservedInstancesListingsResult {
    @inline
    def apply(
        ReservedInstancesListings: js.UndefOr[ReservedInstancesListingList] = js.undefined
    ): DescribeReservedInstancesListingsResult = {
      val __obj = js.Dynamic.literal()
      ReservedInstancesListings.foreach(
        __v => __obj.updateDynamic("ReservedInstancesListings")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeReservedInstancesListingsResult]
    }
  }

  /**
    * Contains the parameters for DescribeReservedInstancesModifications.
    */
  @js.native
  trait DescribeReservedInstancesModificationsRequest extends js.Object {
    var Filters: js.UndefOr[FilterList]
    var NextToken: js.UndefOr[String]
    var ReservedInstancesModificationIds: js.UndefOr[ReservedInstancesModificationIdStringList]
  }

  object DescribeReservedInstancesModificationsRequest {
    @inline
    def apply(
        Filters: js.UndefOr[FilterList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        ReservedInstancesModificationIds: js.UndefOr[ReservedInstancesModificationIdStringList] = js.undefined
    ): DescribeReservedInstancesModificationsRequest = {
      val __obj = js.Dynamic.literal()
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      ReservedInstancesModificationIds.foreach(
        __v => __obj.updateDynamic("ReservedInstancesModificationIds")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeReservedInstancesModificationsRequest]
    }
  }

  /**
    * Contains the output of DescribeReservedInstancesModifications.
    */
  @js.native
  trait DescribeReservedInstancesModificationsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var ReservedInstancesModifications: js.UndefOr[ReservedInstancesModificationList]
  }

  object DescribeReservedInstancesModificationsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        ReservedInstancesModifications: js.UndefOr[ReservedInstancesModificationList] = js.undefined
    ): DescribeReservedInstancesModificationsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      ReservedInstancesModifications.foreach(
        __v => __obj.updateDynamic("ReservedInstancesModifications")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeReservedInstancesModificationsResult]
    }
  }

  /**
    * Contains the parameters for DescribeReservedInstancesOfferings.
    */
  @js.native
  trait DescribeReservedInstancesOfferingsRequest extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var IncludeMarketplace: js.UndefOr[Boolean]
    var InstanceTenancy: js.UndefOr[Tenancy]
    var InstanceType: js.UndefOr[InstanceType]
    var MaxDuration: js.UndefOr[Double]
    var MaxInstanceCount: js.UndefOr[Int]
    var MaxResults: js.UndefOr[Int]
    var MinDuration: js.UndefOr[Double]
    var NextToken: js.UndefOr[String]
    var OfferingClass: js.UndefOr[OfferingClassType]
    var OfferingType: js.UndefOr[OfferingTypeValues]
    var ProductDescription: js.UndefOr[RIProductDescription]
    var ReservedInstancesOfferingIds: js.UndefOr[ReservedInstancesOfferingIdStringList]
  }

  object DescribeReservedInstancesOfferingsRequest {
    @inline
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        IncludeMarketplace: js.UndefOr[Boolean] = js.undefined,
        InstanceTenancy: js.UndefOr[Tenancy] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        MaxDuration: js.UndefOr[Double] = js.undefined,
        MaxInstanceCount: js.UndefOr[Int] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        MinDuration: js.UndefOr[Double] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        OfferingClass: js.UndefOr[OfferingClassType] = js.undefined,
        OfferingType: js.UndefOr[OfferingTypeValues] = js.undefined,
        ProductDescription: js.UndefOr[RIProductDescription] = js.undefined,
        ReservedInstancesOfferingIds: js.UndefOr[ReservedInstancesOfferingIdStringList] = js.undefined
    ): DescribeReservedInstancesOfferingsRequest = {
      val __obj = js.Dynamic.literal()
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      IncludeMarketplace.foreach(__v => __obj.updateDynamic("IncludeMarketplace")(__v.asInstanceOf[js.Any]))
      InstanceTenancy.foreach(__v => __obj.updateDynamic("InstanceTenancy")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      MaxDuration.foreach(__v => __obj.updateDynamic("MaxDuration")(__v.asInstanceOf[js.Any]))
      MaxInstanceCount.foreach(__v => __obj.updateDynamic("MaxInstanceCount")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      MinDuration.foreach(__v => __obj.updateDynamic("MinDuration")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      OfferingClass.foreach(__v => __obj.updateDynamic("OfferingClass")(__v.asInstanceOf[js.Any]))
      OfferingType.foreach(__v => __obj.updateDynamic("OfferingType")(__v.asInstanceOf[js.Any]))
      ProductDescription.foreach(__v => __obj.updateDynamic("ProductDescription")(__v.asInstanceOf[js.Any]))
      ReservedInstancesOfferingIds.foreach(
        __v => __obj.updateDynamic("ReservedInstancesOfferingIds")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeReservedInstancesOfferingsRequest]
    }
  }

  /**
    * Contains the output of DescribeReservedInstancesOfferings.
    */
  @js.native
  trait DescribeReservedInstancesOfferingsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var ReservedInstancesOfferings: js.UndefOr[ReservedInstancesOfferingList]
  }

  object DescribeReservedInstancesOfferingsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        ReservedInstancesOfferings: js.UndefOr[ReservedInstancesOfferingList] = js.undefined
    ): DescribeReservedInstancesOfferingsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      ReservedInstancesOfferings.foreach(
        __v => __obj.updateDynamic("ReservedInstancesOfferings")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeReservedInstancesOfferingsResult]
    }
  }

  /**
    * Contains the parameters for DescribeReservedInstances.
    */
  @js.native
  trait DescribeReservedInstancesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var OfferingClass: js.UndefOr[OfferingClassType]
    var OfferingType: js.UndefOr[OfferingTypeValues]
    var ReservedInstancesIds: js.UndefOr[ReservedInstancesIdStringList]
  }

  object DescribeReservedInstancesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        OfferingClass: js.UndefOr[OfferingClassType] = js.undefined,
        OfferingType: js.UndefOr[OfferingTypeValues] = js.undefined,
        ReservedInstancesIds: js.UndefOr[ReservedInstancesIdStringList] = js.undefined
    ): DescribeReservedInstancesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      OfferingClass.foreach(__v => __obj.updateDynamic("OfferingClass")(__v.asInstanceOf[js.Any]))
      OfferingType.foreach(__v => __obj.updateDynamic("OfferingType")(__v.asInstanceOf[js.Any]))
      ReservedInstancesIds.foreach(__v => __obj.updateDynamic("ReservedInstancesIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeReservedInstancesRequest]
    }
  }

  /**
    * Contains the output for DescribeReservedInstances.
    */
  @js.native
  trait DescribeReservedInstancesResult extends js.Object {
    var ReservedInstances: js.UndefOr[ReservedInstancesList]
  }

  object DescribeReservedInstancesResult {
    @inline
    def apply(
        ReservedInstances: js.UndefOr[ReservedInstancesList] = js.undefined
    ): DescribeReservedInstancesResult = {
      val __obj = js.Dynamic.literal()
      ReservedInstances.foreach(__v => __obj.updateDynamic("ReservedInstances")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeReservedInstancesResult]
    }
  }

  @js.native
  trait DescribeRouteTablesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeRouteTablesMaxResults]
    var NextToken: js.UndefOr[String]
    var RouteTableIds: js.UndefOr[ValueStringList]
  }

  object DescribeRouteTablesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeRouteTablesMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        RouteTableIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeRouteTablesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      RouteTableIds.foreach(__v => __obj.updateDynamic("RouteTableIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeRouteTablesRequest]
    }
  }

  /**
    * Contains the output of DescribeRouteTables.
    */
  @js.native
  trait DescribeRouteTablesResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var RouteTables: js.UndefOr[RouteTableList]
  }

  object DescribeRouteTablesResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        RouteTables: js.UndefOr[RouteTableList] = js.undefined
    ): DescribeRouteTablesResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      RouteTables.foreach(__v => __obj.updateDynamic("RouteTables")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeRouteTablesResult]
    }
  }

  /**
    * Contains the parameters for DescribeScheduledInstanceAvailability.
    */
  @js.native
  trait DescribeScheduledInstanceAvailabilityRequest extends js.Object {
    var FirstSlotStartTimeRange: SlotDateTimeRangeRequest
    var Recurrence: ScheduledInstanceRecurrenceRequest
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeScheduledInstanceAvailabilityMaxResults]
    var MaxSlotDurationInHours: js.UndefOr[Int]
    var MinSlotDurationInHours: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeScheduledInstanceAvailabilityRequest {
    @inline
    def apply(
        FirstSlotStartTimeRange: SlotDateTimeRangeRequest,
        Recurrence: ScheduledInstanceRecurrenceRequest,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeScheduledInstanceAvailabilityMaxResults] = js.undefined,
        MaxSlotDurationInHours: js.UndefOr[Int] = js.undefined,
        MinSlotDurationInHours: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeScheduledInstanceAvailabilityRequest = {
      val __obj = js.Dynamic.literal(
        "FirstSlotStartTimeRange" -> FirstSlotStartTimeRange.asInstanceOf[js.Any],
        "Recurrence"              -> Recurrence.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      MaxSlotDurationInHours.foreach(__v => __obj.updateDynamic("MaxSlotDurationInHours")(__v.asInstanceOf[js.Any]))
      MinSlotDurationInHours.foreach(__v => __obj.updateDynamic("MinSlotDurationInHours")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeScheduledInstanceAvailabilityRequest]
    }
  }

  /**
    * Contains the output of DescribeScheduledInstanceAvailability.
    */
  @js.native
  trait DescribeScheduledInstanceAvailabilityResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var ScheduledInstanceAvailabilitySet: js.UndefOr[ScheduledInstanceAvailabilitySet]
  }

  object DescribeScheduledInstanceAvailabilityResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        ScheduledInstanceAvailabilitySet: js.UndefOr[ScheduledInstanceAvailabilitySet] = js.undefined
    ): DescribeScheduledInstanceAvailabilityResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      ScheduledInstanceAvailabilitySet.foreach(
        __v => __obj.updateDynamic("ScheduledInstanceAvailabilitySet")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeScheduledInstanceAvailabilityResult]
    }
  }

  /**
    * Contains the parameters for DescribeScheduledInstances.
    */
  @js.native
  trait DescribeScheduledInstancesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var ScheduledInstanceIds: js.UndefOr[ScheduledInstanceIdRequestSet]
    var SlotStartTimeRange: js.UndefOr[SlotStartTimeRangeRequest]
  }

  object DescribeScheduledInstancesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        ScheduledInstanceIds: js.UndefOr[ScheduledInstanceIdRequestSet] = js.undefined,
        SlotStartTimeRange: js.UndefOr[SlotStartTimeRangeRequest] = js.undefined
    ): DescribeScheduledInstancesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      ScheduledInstanceIds.foreach(__v => __obj.updateDynamic("ScheduledInstanceIds")(__v.asInstanceOf[js.Any]))
      SlotStartTimeRange.foreach(__v => __obj.updateDynamic("SlotStartTimeRange")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeScheduledInstancesRequest]
    }
  }

  /**
    * Contains the output of DescribeScheduledInstances.
    */
  @js.native
  trait DescribeScheduledInstancesResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var ScheduledInstanceSet: js.UndefOr[ScheduledInstanceSet]
  }

  object DescribeScheduledInstancesResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        ScheduledInstanceSet: js.UndefOr[ScheduledInstanceSet] = js.undefined
    ): DescribeScheduledInstancesResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      ScheduledInstanceSet.foreach(__v => __obj.updateDynamic("ScheduledInstanceSet")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeScheduledInstancesResult]
    }
  }

  @js.native
  trait DescribeSecurityGroupReferencesRequest extends js.Object {
    var GroupId: GroupIds
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeSecurityGroupReferencesRequest {
    @inline
    def apply(
        GroupId: GroupIds,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeSecurityGroupReferencesRequest = {
      val __obj = js.Dynamic.literal(
        "GroupId" -> GroupId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSecurityGroupReferencesRequest]
    }
  }

  @js.native
  trait DescribeSecurityGroupReferencesResult extends js.Object {
    var SecurityGroupReferenceSet: js.UndefOr[SecurityGroupReferences]
  }

  object DescribeSecurityGroupReferencesResult {
    @inline
    def apply(
        SecurityGroupReferenceSet: js.UndefOr[SecurityGroupReferences] = js.undefined
    ): DescribeSecurityGroupReferencesResult = {
      val __obj = js.Dynamic.literal()
      SecurityGroupReferenceSet.foreach(
        __v => __obj.updateDynamic("SecurityGroupReferenceSet")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeSecurityGroupReferencesResult]
    }
  }

  @js.native
  trait DescribeSecurityGroupsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var GroupIds: js.UndefOr[GroupIdStringList]
    var GroupNames: js.UndefOr[GroupNameStringList]
    var MaxResults: js.UndefOr[DescribeSecurityGroupsMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeSecurityGroupsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        GroupIds: js.UndefOr[GroupIdStringList] = js.undefined,
        GroupNames: js.UndefOr[GroupNameStringList] = js.undefined,
        MaxResults: js.UndefOr[DescribeSecurityGroupsMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeSecurityGroupsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      GroupIds.foreach(__v => __obj.updateDynamic("GroupIds")(__v.asInstanceOf[js.Any]))
      GroupNames.foreach(__v => __obj.updateDynamic("GroupNames")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSecurityGroupsRequest]
    }
  }

  @js.native
  trait DescribeSecurityGroupsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var SecurityGroups: js.UndefOr[SecurityGroupList]
  }

  object DescribeSecurityGroupsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        SecurityGroups: js.UndefOr[SecurityGroupList] = js.undefined
    ): DescribeSecurityGroupsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      SecurityGroups.foreach(__v => __obj.updateDynamic("SecurityGroups")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSecurityGroupsResult]
    }
  }

  /**
    * Contains the parameters for DescribeSnapshotAttribute.
    */
  @js.native
  trait DescribeSnapshotAttributeRequest extends js.Object {
    var Attribute: SnapshotAttributeName
    var SnapshotId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeSnapshotAttributeRequest {
    @inline
    def apply(
        Attribute: SnapshotAttributeName,
        SnapshotId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeSnapshotAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "Attribute"  -> Attribute.asInstanceOf[js.Any],
        "SnapshotId" -> SnapshotId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSnapshotAttributeRequest]
    }
  }

  /**
    * Contains the output of DescribeSnapshotAttribute.
    */
  @js.native
  trait DescribeSnapshotAttributeResult extends js.Object {
    var CreateVolumePermissions: js.UndefOr[CreateVolumePermissionList]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var SnapshotId: js.UndefOr[String]
  }

  object DescribeSnapshotAttributeResult {
    @inline
    def apply(
        CreateVolumePermissions: js.UndefOr[CreateVolumePermissionList] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        SnapshotId: js.UndefOr[String] = js.undefined
    ): DescribeSnapshotAttributeResult = {
      val __obj = js.Dynamic.literal()
      CreateVolumePermissions.foreach(__v => __obj.updateDynamic("CreateVolumePermissions")(__v.asInstanceOf[js.Any]))
      ProductCodes.foreach(__v => __obj.updateDynamic("ProductCodes")(__v.asInstanceOf[js.Any]))
      SnapshotId.foreach(__v => __obj.updateDynamic("SnapshotId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSnapshotAttributeResult]
    }
  }

  @js.native
  trait DescribeSnapshotsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var OwnerIds: js.UndefOr[OwnerStringList]
    var RestorableByUserIds: js.UndefOr[RestorableByStringList]
    var SnapshotIds: js.UndefOr[SnapshotIdStringList]
  }

  object DescribeSnapshotsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        OwnerIds: js.UndefOr[OwnerStringList] = js.undefined,
        RestorableByUserIds: js.UndefOr[RestorableByStringList] = js.undefined,
        SnapshotIds: js.UndefOr[SnapshotIdStringList] = js.undefined
    ): DescribeSnapshotsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      OwnerIds.foreach(__v => __obj.updateDynamic("OwnerIds")(__v.asInstanceOf[js.Any]))
      RestorableByUserIds.foreach(__v => __obj.updateDynamic("RestorableByUserIds")(__v.asInstanceOf[js.Any]))
      SnapshotIds.foreach(__v => __obj.updateDynamic("SnapshotIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSnapshotsRequest]
    }
  }

  @js.native
  trait DescribeSnapshotsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Snapshots: js.UndefOr[SnapshotList]
  }

  object DescribeSnapshotsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Snapshots: js.UndefOr[SnapshotList] = js.undefined
    ): DescribeSnapshotsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      Snapshots.foreach(__v => __obj.updateDynamic("Snapshots")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSnapshotsResult]
    }
  }

  /**
    * Contains the parameters for DescribeSpotDatafeedSubscription.
    */
  @js.native
  trait DescribeSpotDatafeedSubscriptionRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeSpotDatafeedSubscriptionRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeSpotDatafeedSubscriptionRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSpotDatafeedSubscriptionRequest]
    }
  }

  /**
    * Contains the output of DescribeSpotDatafeedSubscription.
    */
  @js.native
  trait DescribeSpotDatafeedSubscriptionResult extends js.Object {
    var SpotDatafeedSubscription: js.UndefOr[SpotDatafeedSubscription]
  }

  object DescribeSpotDatafeedSubscriptionResult {
    @inline
    def apply(
        SpotDatafeedSubscription: js.UndefOr[SpotDatafeedSubscription] = js.undefined
    ): DescribeSpotDatafeedSubscriptionResult = {
      val __obj = js.Dynamic.literal()
      SpotDatafeedSubscription.foreach(__v => __obj.updateDynamic("SpotDatafeedSubscription")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSpotDatafeedSubscriptionResult]
    }
  }

  /**
    * Contains the parameters for DescribeSpotFleetInstances.
    */
  @js.native
  trait DescribeSpotFleetInstancesRequest extends js.Object {
    var SpotFleetRequestId: String
    var DryRun: js.UndefOr[Boolean]
    var MaxResults: js.UndefOr[DescribeSpotFleetInstancesMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeSpotFleetInstancesRequest {
    @inline
    def apply(
        SpotFleetRequestId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        MaxResults: js.UndefOr[DescribeSpotFleetInstancesMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeSpotFleetInstancesRequest = {
      val __obj = js.Dynamic.literal(
        "SpotFleetRequestId" -> SpotFleetRequestId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSpotFleetInstancesRequest]
    }
  }

  /**
    * Contains the output of DescribeSpotFleetInstances.
    */
  @js.native
  trait DescribeSpotFleetInstancesResponse extends js.Object {
    var ActiveInstances: js.UndefOr[ActiveInstanceSet]
    var NextToken: js.UndefOr[String]
    var SpotFleetRequestId: js.UndefOr[String]
  }

  object DescribeSpotFleetInstancesResponse {
    @inline
    def apply(
        ActiveInstances: js.UndefOr[ActiveInstanceSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        SpotFleetRequestId: js.UndefOr[String] = js.undefined
    ): DescribeSpotFleetInstancesResponse = {
      val __obj = js.Dynamic.literal()
      ActiveInstances.foreach(__v => __obj.updateDynamic("ActiveInstances")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      SpotFleetRequestId.foreach(__v => __obj.updateDynamic("SpotFleetRequestId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSpotFleetInstancesResponse]
    }
  }

  /**
    * Contains the parameters for DescribeSpotFleetRequestHistory.
    */
  @js.native
  trait DescribeSpotFleetRequestHistoryRequest extends js.Object {
    var SpotFleetRequestId: String
    var StartTime: DateTime
    var DryRun: js.UndefOr[Boolean]
    var EventType: js.UndefOr[EventType]
    var MaxResults: js.UndefOr[DescribeSpotFleetRequestHistoryMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object DescribeSpotFleetRequestHistoryRequest {
    @inline
    def apply(
        SpotFleetRequestId: String,
        StartTime: DateTime,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EventType: js.UndefOr[EventType] = js.undefined,
        MaxResults: js.UndefOr[DescribeSpotFleetRequestHistoryMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeSpotFleetRequestHistoryRequest = {
      val __obj = js.Dynamic.literal(
        "SpotFleetRequestId" -> SpotFleetRequestId.asInstanceOf[js.Any],
        "StartTime"          -> StartTime.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      EventType.foreach(__v => __obj.updateDynamic("EventType")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSpotFleetRequestHistoryRequest]
    }
  }

  /**
    * Contains the output of DescribeSpotFleetRequestHistory.
    */
  @js.native
  trait DescribeSpotFleetRequestHistoryResponse extends js.Object {
    var HistoryRecords: js.UndefOr[HistoryRecords]
    var LastEvaluatedTime: js.UndefOr[DateTime]
    var NextToken: js.UndefOr[String]
    var SpotFleetRequestId: js.UndefOr[String]
    var StartTime: js.UndefOr[DateTime]
  }

  object DescribeSpotFleetRequestHistoryResponse {
    @inline
    def apply(
        HistoryRecords: js.UndefOr[HistoryRecords] = js.undefined,
        LastEvaluatedTime: js.UndefOr[DateTime] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        SpotFleetRequestId: js.UndefOr[String] = js.undefined,
        StartTime: js.UndefOr[DateTime] = js.undefined
    ): DescribeSpotFleetRequestHistoryResponse = {
      val __obj = js.Dynamic.literal()
      HistoryRecords.foreach(__v => __obj.updateDynamic("HistoryRecords")(__v.asInstanceOf[js.Any]))
      LastEvaluatedTime.foreach(__v => __obj.updateDynamic("LastEvaluatedTime")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      SpotFleetRequestId.foreach(__v => __obj.updateDynamic("SpotFleetRequestId")(__v.asInstanceOf[js.Any]))
      StartTime.foreach(__v => __obj.updateDynamic("StartTime")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSpotFleetRequestHistoryResponse]
    }
  }

  /**
    * Contains the parameters for DescribeSpotFleetRequests.
    */
  @js.native
  trait DescribeSpotFleetRequestsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var SpotFleetRequestIds: js.UndefOr[ValueStringList]
  }

  object DescribeSpotFleetRequestsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        SpotFleetRequestIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeSpotFleetRequestsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      SpotFleetRequestIds.foreach(__v => __obj.updateDynamic("SpotFleetRequestIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSpotFleetRequestsRequest]
    }
  }

  /**
    * Contains the output of DescribeSpotFleetRequests.
    */
  @js.native
  trait DescribeSpotFleetRequestsResponse extends js.Object {
    var NextToken: js.UndefOr[String]
    var SpotFleetRequestConfigs: js.UndefOr[SpotFleetRequestConfigSet]
  }

  object DescribeSpotFleetRequestsResponse {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        SpotFleetRequestConfigs: js.UndefOr[SpotFleetRequestConfigSet] = js.undefined
    ): DescribeSpotFleetRequestsResponse = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      SpotFleetRequestConfigs.foreach(__v => __obj.updateDynamic("SpotFleetRequestConfigs")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSpotFleetRequestsResponse]
    }
  }

  /**
    * Contains the parameters for DescribeSpotInstanceRequests.
    */
  @js.native
  trait DescribeSpotInstanceRequestsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var SpotInstanceRequestIds: js.UndefOr[SpotInstanceRequestIdList]
  }

  object DescribeSpotInstanceRequestsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        SpotInstanceRequestIds: js.UndefOr[SpotInstanceRequestIdList] = js.undefined
    ): DescribeSpotInstanceRequestsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      SpotInstanceRequestIds.foreach(__v => __obj.updateDynamic("SpotInstanceRequestIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSpotInstanceRequestsRequest]
    }
  }

  /**
    * Contains the output of DescribeSpotInstanceRequests.
    */
  @js.native
  trait DescribeSpotInstanceRequestsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var SpotInstanceRequests: js.UndefOr[SpotInstanceRequestList]
  }

  object DescribeSpotInstanceRequestsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        SpotInstanceRequests: js.UndefOr[SpotInstanceRequestList] = js.undefined
    ): DescribeSpotInstanceRequestsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      SpotInstanceRequests.foreach(__v => __obj.updateDynamic("SpotInstanceRequests")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSpotInstanceRequestsResult]
    }
  }

  /**
    * Contains the parameters for DescribeSpotPriceHistory.
    */
  @js.native
  trait DescribeSpotPriceHistoryRequest extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var EndTime: js.UndefOr[DateTime]
    var Filters: js.UndefOr[FilterList]
    var InstanceTypes: js.UndefOr[InstanceTypeList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var ProductDescriptions: js.UndefOr[ProductDescriptionList]
    var StartTime: js.UndefOr[DateTime]
  }

  object DescribeSpotPriceHistoryRequest {
    @inline
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EndTime: js.UndefOr[DateTime] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        InstanceTypes: js.UndefOr[InstanceTypeList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        ProductDescriptions: js.UndefOr[ProductDescriptionList] = js.undefined,
        StartTime: js.UndefOr[DateTime] = js.undefined
    ): DescribeSpotPriceHistoryRequest = {
      val __obj = js.Dynamic.literal()
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      EndTime.foreach(__v => __obj.updateDynamic("EndTime")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      InstanceTypes.foreach(__v => __obj.updateDynamic("InstanceTypes")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      ProductDescriptions.foreach(__v => __obj.updateDynamic("ProductDescriptions")(__v.asInstanceOf[js.Any]))
      StartTime.foreach(__v => __obj.updateDynamic("StartTime")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSpotPriceHistoryRequest]
    }
  }

  /**
    * Contains the output of DescribeSpotPriceHistory.
    */
  @js.native
  trait DescribeSpotPriceHistoryResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var SpotPriceHistory: js.UndefOr[SpotPriceHistoryList]
  }

  object DescribeSpotPriceHistoryResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        SpotPriceHistory: js.UndefOr[SpotPriceHistoryList] = js.undefined
    ): DescribeSpotPriceHistoryResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      SpotPriceHistory.foreach(__v => __obj.updateDynamic("SpotPriceHistory")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSpotPriceHistoryResult]
    }
  }

  @js.native
  trait DescribeStaleSecurityGroupsRequest extends js.Object {
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
    var MaxResults: js.UndefOr[DescribeStaleSecurityGroupsMaxResults]
    var NextToken: js.UndefOr[DescribeStaleSecurityGroupsNextToken]
  }

  object DescribeStaleSecurityGroupsRequest {
    @inline
    def apply(
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        MaxResults: js.UndefOr[DescribeStaleSecurityGroupsMaxResults] = js.undefined,
        NextToken: js.UndefOr[DescribeStaleSecurityGroupsNextToken] = js.undefined
    ): DescribeStaleSecurityGroupsRequest = {
      val __obj = js.Dynamic.literal(
        "VpcId" -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeStaleSecurityGroupsRequest]
    }
  }

  @js.native
  trait DescribeStaleSecurityGroupsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var StaleSecurityGroupSet: js.UndefOr[StaleSecurityGroupSet]
  }

  object DescribeStaleSecurityGroupsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        StaleSecurityGroupSet: js.UndefOr[StaleSecurityGroupSet] = js.undefined
    ): DescribeStaleSecurityGroupsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      StaleSecurityGroupSet.foreach(__v => __obj.updateDynamic("StaleSecurityGroupSet")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeStaleSecurityGroupsResult]
    }
  }

  @js.native
  trait DescribeSubnetsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeSubnetsMaxResults]
    var NextToken: js.UndefOr[String]
    var SubnetIds: js.UndefOr[SubnetIdStringList]
  }

  object DescribeSubnetsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeSubnetsMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        SubnetIds: js.UndefOr[SubnetIdStringList] = js.undefined
    ): DescribeSubnetsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      SubnetIds.foreach(__v => __obj.updateDynamic("SubnetIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSubnetsRequest]
    }
  }

  @js.native
  trait DescribeSubnetsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Subnets: js.UndefOr[SubnetList]
  }

  object DescribeSubnetsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Subnets: js.UndefOr[SubnetList] = js.undefined
    ): DescribeSubnetsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      Subnets.foreach(__v => __obj.updateDynamic("Subnets")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeSubnetsResult]
    }
  }

  @js.native
  trait DescribeTagsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeTagsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeTagsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeTagsRequest]
    }
  }

  @js.native
  trait DescribeTagsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Tags: js.UndefOr[TagDescriptionList]
  }

  object DescribeTagsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagDescriptionList] = js.undefined
    ): DescribeTagsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeTagsResult]
    }
  }

  @js.native
  trait DescribeTrafficMirrorFiltersRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TrafficMirroringMaxResults]
    var NextToken: js.UndefOr[NextToken]
    var TrafficMirrorFilterIds: js.UndefOr[ValueStringList]
  }

  object DescribeTrafficMirrorFiltersRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TrafficMirroringMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined,
        TrafficMirrorFilterIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeTrafficMirrorFiltersRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TrafficMirrorFilterIds.foreach(__v => __obj.updateDynamic("TrafficMirrorFilterIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeTrafficMirrorFiltersRequest]
    }
  }

  @js.native
  trait DescribeTrafficMirrorFiltersResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TrafficMirrorFilters: js.UndefOr[TrafficMirrorFilterSet]
  }

  object DescribeTrafficMirrorFiltersResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TrafficMirrorFilters: js.UndefOr[TrafficMirrorFilterSet] = js.undefined
    ): DescribeTrafficMirrorFiltersResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TrafficMirrorFilters.foreach(__v => __obj.updateDynamic("TrafficMirrorFilters")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeTrafficMirrorFiltersResult]
    }
  }

  @js.native
  trait DescribeTrafficMirrorSessionsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TrafficMirroringMaxResults]
    var NextToken: js.UndefOr[NextToken]
    var TrafficMirrorSessionIds: js.UndefOr[ValueStringList]
  }

  object DescribeTrafficMirrorSessionsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TrafficMirroringMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined,
        TrafficMirrorSessionIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeTrafficMirrorSessionsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TrafficMirrorSessionIds.foreach(__v => __obj.updateDynamic("TrafficMirrorSessionIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeTrafficMirrorSessionsRequest]
    }
  }

  @js.native
  trait DescribeTrafficMirrorSessionsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TrafficMirrorSessions: js.UndefOr[TrafficMirrorSessionSet]
  }

  object DescribeTrafficMirrorSessionsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TrafficMirrorSessions: js.UndefOr[TrafficMirrorSessionSet] = js.undefined
    ): DescribeTrafficMirrorSessionsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TrafficMirrorSessions.foreach(__v => __obj.updateDynamic("TrafficMirrorSessions")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeTrafficMirrorSessionsResult]
    }
  }

  @js.native
  trait DescribeTrafficMirrorTargetsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TrafficMirroringMaxResults]
    var NextToken: js.UndefOr[NextToken]
    var TrafficMirrorTargetIds: js.UndefOr[ValueStringList]
  }

  object DescribeTrafficMirrorTargetsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TrafficMirroringMaxResults] = js.undefined,
        NextToken: js.UndefOr[NextToken] = js.undefined,
        TrafficMirrorTargetIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeTrafficMirrorTargetsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TrafficMirrorTargetIds.foreach(__v => __obj.updateDynamic("TrafficMirrorTargetIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeTrafficMirrorTargetsRequest]
    }
  }

  @js.native
  trait DescribeTrafficMirrorTargetsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TrafficMirrorTargets: js.UndefOr[TrafficMirrorTargetSet]
  }

  object DescribeTrafficMirrorTargetsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TrafficMirrorTargets: js.UndefOr[TrafficMirrorTargetSet] = js.undefined
    ): DescribeTrafficMirrorTargetsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TrafficMirrorTargets.foreach(__v => __obj.updateDynamic("TrafficMirrorTargets")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeTrafficMirrorTargetsResult]
    }
  }

  @js.native
  trait DescribeTransitGatewayAttachmentsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
    var TransitGatewayAttachmentIds: js.UndefOr[TransitGatewayAttachmentIdStringList]
  }

  object DescribeTransitGatewayAttachmentsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayAttachmentIds: js.UndefOr[TransitGatewayAttachmentIdStringList] = js.undefined
    ): DescribeTransitGatewayAttachmentsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TransitGatewayAttachmentIds.foreach(
        __v => __obj.updateDynamic("TransitGatewayAttachmentIds")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeTransitGatewayAttachmentsRequest]
    }
  }

  @js.native
  trait DescribeTransitGatewayAttachmentsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TransitGatewayAttachments: js.UndefOr[TransitGatewayAttachmentList]
  }

  object DescribeTransitGatewayAttachmentsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayAttachments: js.UndefOr[TransitGatewayAttachmentList] = js.undefined
    ): DescribeTransitGatewayAttachmentsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TransitGatewayAttachments.foreach(
        __v => __obj.updateDynamic("TransitGatewayAttachments")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeTransitGatewayAttachmentsResult]
    }
  }

  @js.native
  trait DescribeTransitGatewayRouteTablesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
    var TransitGatewayRouteTableIds: js.UndefOr[TransitGatewayRouteTableIdStringList]
  }

  object DescribeTransitGatewayRouteTablesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayRouteTableIds: js.UndefOr[TransitGatewayRouteTableIdStringList] = js.undefined
    ): DescribeTransitGatewayRouteTablesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TransitGatewayRouteTableIds.foreach(
        __v => __obj.updateDynamic("TransitGatewayRouteTableIds")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeTransitGatewayRouteTablesRequest]
    }
  }

  @js.native
  trait DescribeTransitGatewayRouteTablesResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TransitGatewayRouteTables: js.UndefOr[TransitGatewayRouteTableList]
  }

  object DescribeTransitGatewayRouteTablesResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayRouteTables: js.UndefOr[TransitGatewayRouteTableList] = js.undefined
    ): DescribeTransitGatewayRouteTablesResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TransitGatewayRouteTables.foreach(
        __v => __obj.updateDynamic("TransitGatewayRouteTables")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeTransitGatewayRouteTablesResult]
    }
  }

  @js.native
  trait DescribeTransitGatewayVpcAttachmentsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
    var TransitGatewayAttachmentIds: js.UndefOr[TransitGatewayAttachmentIdStringList]
  }

  object DescribeTransitGatewayVpcAttachmentsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayAttachmentIds: js.UndefOr[TransitGatewayAttachmentIdStringList] = js.undefined
    ): DescribeTransitGatewayVpcAttachmentsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TransitGatewayAttachmentIds.foreach(
        __v => __obj.updateDynamic("TransitGatewayAttachmentIds")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeTransitGatewayVpcAttachmentsRequest]
    }
  }

  @js.native
  trait DescribeTransitGatewayVpcAttachmentsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TransitGatewayVpcAttachments: js.UndefOr[TransitGatewayVpcAttachmentList]
  }

  object DescribeTransitGatewayVpcAttachmentsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayVpcAttachments: js.UndefOr[TransitGatewayVpcAttachmentList] = js.undefined
    ): DescribeTransitGatewayVpcAttachmentsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TransitGatewayVpcAttachments.foreach(
        __v => __obj.updateDynamic("TransitGatewayVpcAttachments")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DescribeTransitGatewayVpcAttachmentsResult]
    }
  }

  @js.native
  trait DescribeTransitGatewaysRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
    var TransitGatewayIds: js.UndefOr[TransitGatewayIdStringList]
  }

  object DescribeTransitGatewaysRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayIds: js.UndefOr[TransitGatewayIdStringList] = js.undefined
    ): DescribeTransitGatewaysRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TransitGatewayIds.foreach(__v => __obj.updateDynamic("TransitGatewayIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeTransitGatewaysRequest]
    }
  }

  @js.native
  trait DescribeTransitGatewaysResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TransitGateways: js.UndefOr[TransitGatewayList]
  }

  object DescribeTransitGatewaysResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGateways: js.UndefOr[TransitGatewayList] = js.undefined
    ): DescribeTransitGatewaysResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TransitGateways.foreach(__v => __obj.updateDynamic("TransitGateways")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeTransitGatewaysResult]
    }
  }

  /**
    * Contains the parameters for DescribeVolumeAttribute.
    */
  @js.native
  trait DescribeVolumeAttributeRequest extends js.Object {
    var Attribute: VolumeAttributeName
    var VolumeId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeVolumeAttributeRequest {
    @inline
    def apply(
        Attribute: VolumeAttributeName,
        VolumeId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeVolumeAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "Attribute" -> Attribute.asInstanceOf[js.Any],
        "VolumeId"  -> VolumeId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVolumeAttributeRequest]
    }
  }

  /**
    * Contains the output of DescribeVolumeAttribute.
    */
  @js.native
  trait DescribeVolumeAttributeResult extends js.Object {
    var AutoEnableIO: js.UndefOr[AttributeBooleanValue]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var VolumeId: js.UndefOr[String]
  }

  object DescribeVolumeAttributeResult {
    @inline
    def apply(
        AutoEnableIO: js.UndefOr[AttributeBooleanValue] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        VolumeId: js.UndefOr[String] = js.undefined
    ): DescribeVolumeAttributeResult = {
      val __obj = js.Dynamic.literal()
      AutoEnableIO.foreach(__v => __obj.updateDynamic("AutoEnableIO")(__v.asInstanceOf[js.Any]))
      ProductCodes.foreach(__v => __obj.updateDynamic("ProductCodes")(__v.asInstanceOf[js.Any]))
      VolumeId.foreach(__v => __obj.updateDynamic("VolumeId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVolumeAttributeResult]
    }
  }

  @js.native
  trait DescribeVolumeStatusRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var VolumeIds: js.UndefOr[VolumeIdStringList]
  }

  object DescribeVolumeStatusRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        VolumeIds: js.UndefOr[VolumeIdStringList] = js.undefined
    ): DescribeVolumeStatusRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      VolumeIds.foreach(__v => __obj.updateDynamic("VolumeIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVolumeStatusRequest]
    }
  }

  @js.native
  trait DescribeVolumeStatusResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var VolumeStatuses: js.UndefOr[VolumeStatusList]
  }

  object DescribeVolumeStatusResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        VolumeStatuses: js.UndefOr[VolumeStatusList] = js.undefined
    ): DescribeVolumeStatusResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      VolumeStatuses.foreach(__v => __obj.updateDynamic("VolumeStatuses")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVolumeStatusResult]
    }
  }

  @js.native
  trait DescribeVolumesModificationsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var VolumeIds: js.UndefOr[VolumeIdStringList]
  }

  object DescribeVolumesModificationsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        VolumeIds: js.UndefOr[VolumeIdStringList] = js.undefined
    ): DescribeVolumesModificationsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      VolumeIds.foreach(__v => __obj.updateDynamic("VolumeIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVolumesModificationsRequest]
    }
  }

  @js.native
  trait DescribeVolumesModificationsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var VolumesModifications: js.UndefOr[VolumeModificationList]
  }

  object DescribeVolumesModificationsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        VolumesModifications: js.UndefOr[VolumeModificationList] = js.undefined
    ): DescribeVolumesModificationsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      VolumesModifications.foreach(__v => __obj.updateDynamic("VolumesModifications")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVolumesModificationsResult]
    }
  }

  @js.native
  trait DescribeVolumesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var VolumeIds: js.UndefOr[VolumeIdStringList]
  }

  object DescribeVolumesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        VolumeIds: js.UndefOr[VolumeIdStringList] = js.undefined
    ): DescribeVolumesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      VolumeIds.foreach(__v => __obj.updateDynamic("VolumeIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVolumesRequest]
    }
  }

  @js.native
  trait DescribeVolumesResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Volumes: js.UndefOr[VolumeList]
  }

  object DescribeVolumesResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Volumes: js.UndefOr[VolumeList] = js.undefined
    ): DescribeVolumesResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      Volumes.foreach(__v => __obj.updateDynamic("Volumes")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVolumesResult]
    }
  }

  @js.native
  trait DescribeVpcAttributeRequest extends js.Object {
    var Attribute: VpcAttributeName
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DescribeVpcAttributeRequest {
    @inline
    def apply(
        Attribute: VpcAttributeName,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DescribeVpcAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "Attribute" -> Attribute.asInstanceOf[js.Any],
        "VpcId"     -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcAttributeRequest]
    }
  }

  @js.native
  trait DescribeVpcAttributeResult extends js.Object {
    var EnableDnsHostnames: js.UndefOr[AttributeBooleanValue]
    var EnableDnsSupport: js.UndefOr[AttributeBooleanValue]
    var VpcId: js.UndefOr[String]
  }

  object DescribeVpcAttributeResult {
    @inline
    def apply(
        EnableDnsHostnames: js.UndefOr[AttributeBooleanValue] = js.undefined,
        EnableDnsSupport: js.UndefOr[AttributeBooleanValue] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): DescribeVpcAttributeResult = {
      val __obj = js.Dynamic.literal()
      EnableDnsHostnames.foreach(__v => __obj.updateDynamic("EnableDnsHostnames")(__v.asInstanceOf[js.Any]))
      EnableDnsSupport.foreach(__v => __obj.updateDynamic("EnableDnsSupport")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcAttributeResult]
    }
  }

  @js.native
  trait DescribeVpcClassicLinkDnsSupportRequest extends js.Object {
    var MaxResults: js.UndefOr[DescribeVpcClassicLinkDnsSupportMaxResults]
    var NextToken: js.UndefOr[DescribeVpcClassicLinkDnsSupportNextToken]
    var VpcIds: js.UndefOr[VpcClassicLinkIdList]
  }

  object DescribeVpcClassicLinkDnsSupportRequest {
    @inline
    def apply(
        MaxResults: js.UndefOr[DescribeVpcClassicLinkDnsSupportMaxResults] = js.undefined,
        NextToken: js.UndefOr[DescribeVpcClassicLinkDnsSupportNextToken] = js.undefined,
        VpcIds: js.UndefOr[VpcClassicLinkIdList] = js.undefined
    ): DescribeVpcClassicLinkDnsSupportRequest = {
      val __obj = js.Dynamic.literal()
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      VpcIds.foreach(__v => __obj.updateDynamic("VpcIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcClassicLinkDnsSupportRequest]
    }
  }

  @js.native
  trait DescribeVpcClassicLinkDnsSupportResult extends js.Object {
    var NextToken: js.UndefOr[DescribeVpcClassicLinkDnsSupportNextToken]
    var Vpcs: js.UndefOr[ClassicLinkDnsSupportList]
  }

  object DescribeVpcClassicLinkDnsSupportResult {
    @inline
    def apply(
        NextToken: js.UndefOr[DescribeVpcClassicLinkDnsSupportNextToken] = js.undefined,
        Vpcs: js.UndefOr[ClassicLinkDnsSupportList] = js.undefined
    ): DescribeVpcClassicLinkDnsSupportResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      Vpcs.foreach(__v => __obj.updateDynamic("Vpcs")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcClassicLinkDnsSupportResult]
    }
  }

  @js.native
  trait DescribeVpcClassicLinkRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var VpcIds: js.UndefOr[VpcClassicLinkIdList]
  }

  object DescribeVpcClassicLinkRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        VpcIds: js.UndefOr[VpcClassicLinkIdList] = js.undefined
    ): DescribeVpcClassicLinkRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      VpcIds.foreach(__v => __obj.updateDynamic("VpcIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcClassicLinkRequest]
    }
  }

  @js.native
  trait DescribeVpcClassicLinkResult extends js.Object {
    var Vpcs: js.UndefOr[VpcClassicLinkList]
  }

  object DescribeVpcClassicLinkResult {
    @inline
    def apply(
        Vpcs: js.UndefOr[VpcClassicLinkList] = js.undefined
    ): DescribeVpcClassicLinkResult = {
      val __obj = js.Dynamic.literal()
      Vpcs.foreach(__v => __obj.updateDynamic("Vpcs")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcClassicLinkResult]
    }
  }

  @js.native
  trait DescribeVpcEndpointConnectionNotificationsRequest extends js.Object {
    var ConnectionNotificationId: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeVpcEndpointConnectionNotificationsRequest {
    @inline
    def apply(
        ConnectionNotificationId: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeVpcEndpointConnectionNotificationsRequest = {
      val __obj = js.Dynamic.literal()
      ConnectionNotificationId.foreach(__v => __obj.updateDynamic("ConnectionNotificationId")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcEndpointConnectionNotificationsRequest]
    }
  }

  @js.native
  trait DescribeVpcEndpointConnectionNotificationsResult extends js.Object {
    var ConnectionNotificationSet: js.UndefOr[ConnectionNotificationSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeVpcEndpointConnectionNotificationsResult {
    @inline
    def apply(
        ConnectionNotificationSet: js.UndefOr[ConnectionNotificationSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeVpcEndpointConnectionNotificationsResult = {
      val __obj = js.Dynamic.literal()
      ConnectionNotificationSet.foreach(
        __v => __obj.updateDynamic("ConnectionNotificationSet")(__v.asInstanceOf[js.Any])
      )
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcEndpointConnectionNotificationsResult]
    }
  }

  @js.native
  trait DescribeVpcEndpointConnectionsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeVpcEndpointConnectionsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeVpcEndpointConnectionsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcEndpointConnectionsRequest]
    }
  }

  @js.native
  trait DescribeVpcEndpointConnectionsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var VpcEndpointConnections: js.UndefOr[VpcEndpointConnectionSet]
  }

  object DescribeVpcEndpointConnectionsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        VpcEndpointConnections: js.UndefOr[VpcEndpointConnectionSet] = js.undefined
    ): DescribeVpcEndpointConnectionsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      VpcEndpointConnections.foreach(__v => __obj.updateDynamic("VpcEndpointConnections")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcEndpointConnectionsResult]
    }
  }

  @js.native
  trait DescribeVpcEndpointServiceConfigurationsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var ServiceIds: js.UndefOr[ValueStringList]
  }

  object DescribeVpcEndpointServiceConfigurationsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        ServiceIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeVpcEndpointServiceConfigurationsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      ServiceIds.foreach(__v => __obj.updateDynamic("ServiceIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcEndpointServiceConfigurationsRequest]
    }
  }

  @js.native
  trait DescribeVpcEndpointServiceConfigurationsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var ServiceConfigurations: js.UndefOr[ServiceConfigurationSet]
  }

  object DescribeVpcEndpointServiceConfigurationsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        ServiceConfigurations: js.UndefOr[ServiceConfigurationSet] = js.undefined
    ): DescribeVpcEndpointServiceConfigurationsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      ServiceConfigurations.foreach(__v => __obj.updateDynamic("ServiceConfigurations")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcEndpointServiceConfigurationsResult]
    }
  }

  @js.native
  trait DescribeVpcEndpointServicePermissionsRequest extends js.Object {
    var ServiceId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
  }

  object DescribeVpcEndpointServicePermissionsRequest {
    @inline
    def apply(
        ServiceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeVpcEndpointServicePermissionsRequest = {
      val __obj = js.Dynamic.literal(
        "ServiceId" -> ServiceId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcEndpointServicePermissionsRequest]
    }
  }

  @js.native
  trait DescribeVpcEndpointServicePermissionsResult extends js.Object {
    var AllowedPrincipals: js.UndefOr[AllowedPrincipalSet]
    var NextToken: js.UndefOr[String]
  }

  object DescribeVpcEndpointServicePermissionsResult {
    @inline
    def apply(
        AllowedPrincipals: js.UndefOr[AllowedPrincipalSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): DescribeVpcEndpointServicePermissionsResult = {
      val __obj = js.Dynamic.literal()
      AllowedPrincipals.foreach(__v => __obj.updateDynamic("AllowedPrincipals")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcEndpointServicePermissionsResult]
    }
  }

  /**
    * Contains the parameters for DescribeVpcEndpointServices.
    */
  @js.native
  trait DescribeVpcEndpointServicesRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var ServiceNames: js.UndefOr[ValueStringList]
  }

  object DescribeVpcEndpointServicesRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        ServiceNames: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeVpcEndpointServicesRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      ServiceNames.foreach(__v => __obj.updateDynamic("ServiceNames")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcEndpointServicesRequest]
    }
  }

  /**
    * Contains the output of DescribeVpcEndpointServices.
    */
  @js.native
  trait DescribeVpcEndpointServicesResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var ServiceDetails: js.UndefOr[ServiceDetailSet]
    var ServiceNames: js.UndefOr[ValueStringList]
  }

  object DescribeVpcEndpointServicesResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        ServiceDetails: js.UndefOr[ServiceDetailSet] = js.undefined,
        ServiceNames: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeVpcEndpointServicesResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      ServiceDetails.foreach(__v => __obj.updateDynamic("ServiceDetails")(__v.asInstanceOf[js.Any]))
      ServiceNames.foreach(__v => __obj.updateDynamic("ServiceNames")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcEndpointServicesResult]
    }
  }

  /**
    * Contains the parameters for DescribeVpcEndpoints.
    */
  @js.native
  trait DescribeVpcEndpointsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[Int]
    var NextToken: js.UndefOr[String]
    var VpcEndpointIds: js.UndefOr[ValueStringList]
  }

  object DescribeVpcEndpointsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[Int] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        VpcEndpointIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeVpcEndpointsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      VpcEndpointIds.foreach(__v => __obj.updateDynamic("VpcEndpointIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcEndpointsRequest]
    }
  }

  /**
    * Contains the output of DescribeVpcEndpoints.
    */
  @js.native
  trait DescribeVpcEndpointsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var VpcEndpoints: js.UndefOr[VpcEndpointSet]
  }

  object DescribeVpcEndpointsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        VpcEndpoints: js.UndefOr[VpcEndpointSet] = js.undefined
    ): DescribeVpcEndpointsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      VpcEndpoints.foreach(__v => __obj.updateDynamic("VpcEndpoints")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcEndpointsResult]
    }
  }

  @js.native
  trait DescribeVpcPeeringConnectionsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeVpcPeeringConnectionsMaxResults]
    var NextToken: js.UndefOr[String]
    var VpcPeeringConnectionIds: js.UndefOr[ValueStringList]
  }

  object DescribeVpcPeeringConnectionsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeVpcPeeringConnectionsMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        VpcPeeringConnectionIds: js.UndefOr[ValueStringList] = js.undefined
    ): DescribeVpcPeeringConnectionsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      VpcPeeringConnectionIds.foreach(__v => __obj.updateDynamic("VpcPeeringConnectionIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcPeeringConnectionsRequest]
    }
  }

  @js.native
  trait DescribeVpcPeeringConnectionsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var VpcPeeringConnections: js.UndefOr[VpcPeeringConnectionList]
  }

  object DescribeVpcPeeringConnectionsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        VpcPeeringConnections: js.UndefOr[VpcPeeringConnectionList] = js.undefined
    ): DescribeVpcPeeringConnectionsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      VpcPeeringConnections.foreach(__v => __obj.updateDynamic("VpcPeeringConnections")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcPeeringConnectionsResult]
    }
  }

  @js.native
  trait DescribeVpcsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[DescribeVpcsMaxResults]
    var NextToken: js.UndefOr[String]
    var VpcIds: js.UndefOr[VpcIdStringList]
  }

  object DescribeVpcsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[DescribeVpcsMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        VpcIds: js.UndefOr[VpcIdStringList] = js.undefined
    ): DescribeVpcsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      VpcIds.foreach(__v => __obj.updateDynamic("VpcIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcsRequest]
    }
  }

  @js.native
  trait DescribeVpcsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var Vpcs: js.UndefOr[VpcList]
  }

  object DescribeVpcsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        Vpcs: js.UndefOr[VpcList] = js.undefined
    ): DescribeVpcsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      Vpcs.foreach(__v => __obj.updateDynamic("Vpcs")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpcsResult]
    }
  }

  /**
    * Contains the parameters for DescribeVpnConnections.
    */
  @js.native
  trait DescribeVpnConnectionsRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var VpnConnectionIds: js.UndefOr[VpnConnectionIdStringList]
  }

  object DescribeVpnConnectionsRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        VpnConnectionIds: js.UndefOr[VpnConnectionIdStringList] = js.undefined
    ): DescribeVpnConnectionsRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      VpnConnectionIds.foreach(__v => __obj.updateDynamic("VpnConnectionIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpnConnectionsRequest]
    }
  }

  /**
    * Contains the output of DescribeVpnConnections.
    */
  @js.native
  trait DescribeVpnConnectionsResult extends js.Object {
    var VpnConnections: js.UndefOr[VpnConnectionList]
  }

  object DescribeVpnConnectionsResult {
    @inline
    def apply(
        VpnConnections: js.UndefOr[VpnConnectionList] = js.undefined
    ): DescribeVpnConnectionsResult = {
      val __obj = js.Dynamic.literal()
      VpnConnections.foreach(__v => __obj.updateDynamic("VpnConnections")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpnConnectionsResult]
    }
  }

  /**
    * Contains the parameters for DescribeVpnGateways.
    */
  @js.native
  trait DescribeVpnGatewaysRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var VpnGatewayIds: js.UndefOr[VpnGatewayIdStringList]
  }

  object DescribeVpnGatewaysRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        VpnGatewayIds: js.UndefOr[VpnGatewayIdStringList] = js.undefined
    ): DescribeVpnGatewaysRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      VpnGatewayIds.foreach(__v => __obj.updateDynamic("VpnGatewayIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpnGatewaysRequest]
    }
  }

  /**
    * Contains the output of DescribeVpnGateways.
    */
  @js.native
  trait DescribeVpnGatewaysResult extends js.Object {
    var VpnGateways: js.UndefOr[VpnGatewayList]
  }

  object DescribeVpnGatewaysResult {
    @inline
    def apply(
        VpnGateways: js.UndefOr[VpnGatewayList] = js.undefined
    ): DescribeVpnGatewaysResult = {
      val __obj = js.Dynamic.literal()
      VpnGateways.foreach(__v => __obj.updateDynamic("VpnGateways")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DescribeVpnGatewaysResult]
    }
  }

  @js.native
  trait DetachClassicLinkVpcRequest extends js.Object {
    var InstanceId: String
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DetachClassicLinkVpcRequest {
    @inline
    def apply(
        InstanceId: String,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DetachClassicLinkVpcRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceId" -> InstanceId.asInstanceOf[js.Any],
        "VpcId"      -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DetachClassicLinkVpcRequest]
    }
  }

  @js.native
  trait DetachClassicLinkVpcResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object DetachClassicLinkVpcResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): DetachClassicLinkVpcResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DetachClassicLinkVpcResult]
    }
  }

  @js.native
  trait DetachInternetGatewayRequest extends js.Object {
    var InternetGatewayId: String
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DetachInternetGatewayRequest {
    @inline
    def apply(
        InternetGatewayId: String,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DetachInternetGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "InternetGatewayId" -> InternetGatewayId.asInstanceOf[js.Any],
        "VpcId"             -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DetachInternetGatewayRequest]
    }
  }

  /**
    * Contains the parameters for DetachNetworkInterface.
    */
  @js.native
  trait DetachNetworkInterfaceRequest extends js.Object {
    var AttachmentId: String
    var DryRun: js.UndefOr[Boolean]
    var Force: js.UndefOr[Boolean]
  }

  object DetachNetworkInterfaceRequest {
    @inline
    def apply(
        AttachmentId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Force: js.UndefOr[Boolean] = js.undefined
    ): DetachNetworkInterfaceRequest = {
      val __obj = js.Dynamic.literal(
        "AttachmentId" -> AttachmentId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Force.foreach(__v => __obj.updateDynamic("Force")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DetachNetworkInterfaceRequest]
    }
  }

  /**
    * Contains the parameters for DetachVolume.
    */
  @js.native
  trait DetachVolumeRequest extends js.Object {
    var VolumeId: String
    var Device: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var Force: js.UndefOr[Boolean]
    var InstanceId: js.UndefOr[String]
  }

  object DetachVolumeRequest {
    @inline
    def apply(
        VolumeId: String,
        Device: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Force: js.UndefOr[Boolean] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): DetachVolumeRequest = {
      val __obj = js.Dynamic.literal(
        "VolumeId" -> VolumeId.asInstanceOf[js.Any]
      )

      Device.foreach(__v => __obj.updateDynamic("Device")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Force.foreach(__v => __obj.updateDynamic("Force")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DetachVolumeRequest]
    }
  }

  /**
    * Contains the parameters for DetachVpnGateway.
    */
  @js.native
  trait DetachVpnGatewayRequest extends js.Object {
    var VpcId: String
    var VpnGatewayId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DetachVpnGatewayRequest {
    @inline
    def apply(
        VpcId: String,
        VpnGatewayId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DetachVpnGatewayRequest = {
      val __obj = js.Dynamic.literal(
        "VpcId"        -> VpcId.asInstanceOf[js.Any],
        "VpnGatewayId" -> VpnGatewayId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DetachVpnGatewayRequest]
    }
  }

  object DeviceTypeEnum {
    val ebs              = "ebs"
    val `instance-store` = "instance-store"

    val values = js.Object.freeze(js.Array(ebs, `instance-store`))
  }

  /**
    * Describes a DHCP configuration option.
    */
  @js.native
  trait DhcpConfiguration extends js.Object {
    var Key: js.UndefOr[String]
    var Values: js.UndefOr[DhcpConfigurationValueList]
  }

  object DhcpConfiguration {
    @inline
    def apply(
        Key: js.UndefOr[String] = js.undefined,
        Values: js.UndefOr[DhcpConfigurationValueList] = js.undefined
    ): DhcpConfiguration = {
      val __obj = js.Dynamic.literal()
      Key.foreach(__v => __obj.updateDynamic("Key")(__v.asInstanceOf[js.Any]))
      Values.foreach(__v => __obj.updateDynamic("Values")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DhcpConfiguration]
    }
  }

  /**
    * Describes a set of DHCP options.
    */
  @js.native
  trait DhcpOptions extends js.Object {
    var DhcpConfigurations: js.UndefOr[DhcpConfigurationList]
    var DhcpOptionsId: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
  }

  object DhcpOptions {
    @inline
    def apply(
        DhcpConfigurations: js.UndefOr[DhcpConfigurationList] = js.undefined,
        DhcpOptionsId: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): DhcpOptions = {
      val __obj = js.Dynamic.literal()
      DhcpConfigurations.foreach(__v => __obj.updateDynamic("DhcpConfigurations")(__v.asInstanceOf[js.Any]))
      DhcpOptionsId.foreach(__v => __obj.updateDynamic("DhcpOptionsId")(__v.asInstanceOf[js.Any]))
      OwnerId.foreach(__v => __obj.updateDynamic("OwnerId")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DhcpOptions]
    }
  }

  /**
    * Describes an Active Directory.
    */
  @js.native
  trait DirectoryServiceAuthentication extends js.Object {
    var DirectoryId: js.UndefOr[String]
  }

  object DirectoryServiceAuthentication {
    @inline
    def apply(
        DirectoryId: js.UndefOr[String] = js.undefined
    ): DirectoryServiceAuthentication = {
      val __obj = js.Dynamic.literal()
      DirectoryId.foreach(__v => __obj.updateDynamic("DirectoryId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DirectoryServiceAuthentication]
    }
  }

  /**
    * Describes the Active Directory to be used for client authentication.
    */
  @js.native
  trait DirectoryServiceAuthenticationRequest extends js.Object {
    var DirectoryId: js.UndefOr[String]
  }

  object DirectoryServiceAuthenticationRequest {
    @inline
    def apply(
        DirectoryId: js.UndefOr[String] = js.undefined
    ): DirectoryServiceAuthenticationRequest = {
      val __obj = js.Dynamic.literal()
      DirectoryId.foreach(__v => __obj.updateDynamic("DirectoryId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DirectoryServiceAuthenticationRequest]
    }
  }

  @js.native
  trait DisableEbsEncryptionByDefaultRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object DisableEbsEncryptionByDefaultRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DisableEbsEncryptionByDefaultRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisableEbsEncryptionByDefaultRequest]
    }
  }

  @js.native
  trait DisableEbsEncryptionByDefaultResult extends js.Object {
    var EbsEncryptionByDefault: js.UndefOr[Boolean]
  }

  object DisableEbsEncryptionByDefaultResult {
    @inline
    def apply(
        EbsEncryptionByDefault: js.UndefOr[Boolean] = js.undefined
    ): DisableEbsEncryptionByDefaultResult = {
      val __obj = js.Dynamic.literal()
      EbsEncryptionByDefault.foreach(__v => __obj.updateDynamic("EbsEncryptionByDefault")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisableEbsEncryptionByDefaultResult]
    }
  }

  @js.native
  trait DisableTransitGatewayRouteTablePropagationRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DisableTransitGatewayRouteTablePropagationRequest {
    @inline
    def apply(
        TransitGatewayAttachmentId: String,
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DisableTransitGatewayRouteTablePropagationRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisableTransitGatewayRouteTablePropagationRequest]
    }
  }

  @js.native
  trait DisableTransitGatewayRouteTablePropagationResult extends js.Object {
    var Propagation: js.UndefOr[TransitGatewayPropagation]
  }

  object DisableTransitGatewayRouteTablePropagationResult {
    @inline
    def apply(
        Propagation: js.UndefOr[TransitGatewayPropagation] = js.undefined
    ): DisableTransitGatewayRouteTablePropagationResult = {
      val __obj = js.Dynamic.literal()
      Propagation.foreach(__v => __obj.updateDynamic("Propagation")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisableTransitGatewayRouteTablePropagationResult]
    }
  }

  /**
    * Contains the parameters for DisableVgwRoutePropagation.
    */
  @js.native
  trait DisableVgwRoutePropagationRequest extends js.Object {
    var GatewayId: String
    var RouteTableId: String
  }

  object DisableVgwRoutePropagationRequest {
    @inline
    def apply(
        GatewayId: String,
        RouteTableId: String
    ): DisableVgwRoutePropagationRequest = {
      val __obj = js.Dynamic.literal(
        "GatewayId"    -> GatewayId.asInstanceOf[js.Any],
        "RouteTableId" -> RouteTableId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[DisableVgwRoutePropagationRequest]
    }
  }

  @js.native
  trait DisableVpcClassicLinkDnsSupportRequest extends js.Object {
    var VpcId: js.UndefOr[String]
  }

  object DisableVpcClassicLinkDnsSupportRequest {
    @inline
    def apply(
        VpcId: js.UndefOr[String] = js.undefined
    ): DisableVpcClassicLinkDnsSupportRequest = {
      val __obj = js.Dynamic.literal()
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisableVpcClassicLinkDnsSupportRequest]
    }
  }

  @js.native
  trait DisableVpcClassicLinkDnsSupportResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object DisableVpcClassicLinkDnsSupportResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): DisableVpcClassicLinkDnsSupportResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisableVpcClassicLinkDnsSupportResult]
    }
  }

  @js.native
  trait DisableVpcClassicLinkRequest extends js.Object {
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DisableVpcClassicLinkRequest {
    @inline
    def apply(
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DisableVpcClassicLinkRequest = {
      val __obj = js.Dynamic.literal(
        "VpcId" -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisableVpcClassicLinkRequest]
    }
  }

  @js.native
  trait DisableVpcClassicLinkResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object DisableVpcClassicLinkResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): DisableVpcClassicLinkResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisableVpcClassicLinkResult]
    }
  }

  @js.native
  trait DisassociateAddressRequest extends js.Object {
    var AssociationId: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var PublicIp: js.UndefOr[String]
  }

  object DisassociateAddressRequest {
    @inline
    def apply(
        AssociationId: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): DisassociateAddressRequest = {
      val __obj = js.Dynamic.literal()
      AssociationId.foreach(__v => __obj.updateDynamic("AssociationId")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      PublicIp.foreach(__v => __obj.updateDynamic("PublicIp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisassociateAddressRequest]
    }
  }

  @js.native
  trait DisassociateClientVpnTargetNetworkRequest extends js.Object {
    var AssociationId: String
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DisassociateClientVpnTargetNetworkRequest {
    @inline
    def apply(
        AssociationId: String,
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DisassociateClientVpnTargetNetworkRequest = {
      val __obj = js.Dynamic.literal(
        "AssociationId"       -> AssociationId.asInstanceOf[js.Any],
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisassociateClientVpnTargetNetworkRequest]
    }
  }

  @js.native
  trait DisassociateClientVpnTargetNetworkResult extends js.Object {
    var AssociationId: js.UndefOr[String]
    var Status: js.UndefOr[AssociationStatus]
  }

  object DisassociateClientVpnTargetNetworkResult {
    @inline
    def apply(
        AssociationId: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[AssociationStatus] = js.undefined
    ): DisassociateClientVpnTargetNetworkResult = {
      val __obj = js.Dynamic.literal()
      AssociationId.foreach(__v => __obj.updateDynamic("AssociationId")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisassociateClientVpnTargetNetworkResult]
    }
  }

  @js.native
  trait DisassociateIamInstanceProfileRequest extends js.Object {
    var AssociationId: String
  }

  object DisassociateIamInstanceProfileRequest {
    @inline
    def apply(
        AssociationId: String
    ): DisassociateIamInstanceProfileRequest = {
      val __obj = js.Dynamic.literal(
        "AssociationId" -> AssociationId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[DisassociateIamInstanceProfileRequest]
    }
  }

  @js.native
  trait DisassociateIamInstanceProfileResult extends js.Object {
    var IamInstanceProfileAssociation: js.UndefOr[IamInstanceProfileAssociation]
  }

  object DisassociateIamInstanceProfileResult {
    @inline
    def apply(
        IamInstanceProfileAssociation: js.UndefOr[IamInstanceProfileAssociation] = js.undefined
    ): DisassociateIamInstanceProfileResult = {
      val __obj = js.Dynamic.literal()
      IamInstanceProfileAssociation.foreach(
        __v => __obj.updateDynamic("IamInstanceProfileAssociation")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[DisassociateIamInstanceProfileResult]
    }
  }

  @js.native
  trait DisassociateRouteTableRequest extends js.Object {
    var AssociationId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DisassociateRouteTableRequest {
    @inline
    def apply(
        AssociationId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DisassociateRouteTableRequest = {
      val __obj = js.Dynamic.literal(
        "AssociationId" -> AssociationId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisassociateRouteTableRequest]
    }
  }

  @js.native
  trait DisassociateSubnetCidrBlockRequest extends js.Object {
    var AssociationId: String
  }

  object DisassociateSubnetCidrBlockRequest {
    @inline
    def apply(
        AssociationId: String
    ): DisassociateSubnetCidrBlockRequest = {
      val __obj = js.Dynamic.literal(
        "AssociationId" -> AssociationId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[DisassociateSubnetCidrBlockRequest]
    }
  }

  @js.native
  trait DisassociateSubnetCidrBlockResult extends js.Object {
    var Ipv6CidrBlockAssociation: js.UndefOr[SubnetIpv6CidrBlockAssociation]
    var SubnetId: js.UndefOr[String]
  }

  object DisassociateSubnetCidrBlockResult {
    @inline
    def apply(
        Ipv6CidrBlockAssociation: js.UndefOr[SubnetIpv6CidrBlockAssociation] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined
    ): DisassociateSubnetCidrBlockResult = {
      val __obj = js.Dynamic.literal()
      Ipv6CidrBlockAssociation.foreach(__v => __obj.updateDynamic("Ipv6CidrBlockAssociation")(__v.asInstanceOf[js.Any]))
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisassociateSubnetCidrBlockResult]
    }
  }

  @js.native
  trait DisassociateTransitGatewayRouteTableRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object DisassociateTransitGatewayRouteTableRequest {
    @inline
    def apply(
        TransitGatewayAttachmentId: String,
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): DisassociateTransitGatewayRouteTableRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisassociateTransitGatewayRouteTableRequest]
    }
  }

  @js.native
  trait DisassociateTransitGatewayRouteTableResult extends js.Object {
    var Association: js.UndefOr[TransitGatewayAssociation]
  }

  object DisassociateTransitGatewayRouteTableResult {
    @inline
    def apply(
        Association: js.UndefOr[TransitGatewayAssociation] = js.undefined
    ): DisassociateTransitGatewayRouteTableResult = {
      val __obj = js.Dynamic.literal()
      Association.foreach(__v => __obj.updateDynamic("Association")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisassociateTransitGatewayRouteTableResult]
    }
  }

  @js.native
  trait DisassociateVpcCidrBlockRequest extends js.Object {
    var AssociationId: String
  }

  object DisassociateVpcCidrBlockRequest {
    @inline
    def apply(
        AssociationId: String
    ): DisassociateVpcCidrBlockRequest = {
      val __obj = js.Dynamic.literal(
        "AssociationId" -> AssociationId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[DisassociateVpcCidrBlockRequest]
    }
  }

  @js.native
  trait DisassociateVpcCidrBlockResult extends js.Object {
    var CidrBlockAssociation: js.UndefOr[VpcCidrBlockAssociation]
    var Ipv6CidrBlockAssociation: js.UndefOr[VpcIpv6CidrBlockAssociation]
    var VpcId: js.UndefOr[String]
  }

  object DisassociateVpcCidrBlockResult {
    @inline
    def apply(
        CidrBlockAssociation: js.UndefOr[VpcCidrBlockAssociation] = js.undefined,
        Ipv6CidrBlockAssociation: js.UndefOr[VpcIpv6CidrBlockAssociation] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): DisassociateVpcCidrBlockResult = {
      val __obj = js.Dynamic.literal()
      CidrBlockAssociation.foreach(__v => __obj.updateDynamic("CidrBlockAssociation")(__v.asInstanceOf[js.Any]))
      Ipv6CidrBlockAssociation.foreach(__v => __obj.updateDynamic("Ipv6CidrBlockAssociation")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DisassociateVpcCidrBlockResult]
    }
  }

  /**
    * Describes a disk image.
    */
  @js.native
  trait DiskImage extends js.Object {
    var Description: js.UndefOr[String]
    var Image: js.UndefOr[DiskImageDetail]
    var Volume: js.UndefOr[VolumeDetail]
  }

  object DiskImage {
    @inline
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        Image: js.UndefOr[DiskImageDetail] = js.undefined,
        Volume: js.UndefOr[VolumeDetail] = js.undefined
    ): DiskImage = {
      val __obj = js.Dynamic.literal()
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      Image.foreach(__v => __obj.updateDynamic("Image")(__v.asInstanceOf[js.Any]))
      Volume.foreach(__v => __obj.updateDynamic("Volume")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DiskImage]
    }
  }

  /**
    * Describes a disk image.
    */
  @js.native
  trait DiskImageDescription extends js.Object {
    var Checksum: js.UndefOr[String]
    var Format: js.UndefOr[DiskImageFormat]
    var ImportManifestUrl: js.UndefOr[String]
    var Size: js.UndefOr[Double]
  }

  object DiskImageDescription {
    @inline
    def apply(
        Checksum: js.UndefOr[String] = js.undefined,
        Format: js.UndefOr[DiskImageFormat] = js.undefined,
        ImportManifestUrl: js.UndefOr[String] = js.undefined,
        Size: js.UndefOr[Double] = js.undefined
    ): DiskImageDescription = {
      val __obj = js.Dynamic.literal()
      Checksum.foreach(__v => __obj.updateDynamic("Checksum")(__v.asInstanceOf[js.Any]))
      Format.foreach(__v => __obj.updateDynamic("Format")(__v.asInstanceOf[js.Any]))
      ImportManifestUrl.foreach(__v => __obj.updateDynamic("ImportManifestUrl")(__v.asInstanceOf[js.Any]))
      Size.foreach(__v => __obj.updateDynamic("Size")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DiskImageDescription]
    }
  }

  /**
    * Describes a disk image.
    */
  @js.native
  trait DiskImageDetail extends js.Object {
    var Bytes: Double
    var Format: DiskImageFormat
    var ImportManifestUrl: String
  }

  object DiskImageDetail {
    @inline
    def apply(
        Bytes: Double,
        Format: DiskImageFormat,
        ImportManifestUrl: String
    ): DiskImageDetail = {
      val __obj = js.Dynamic.literal(
        "Bytes"             -> Bytes.asInstanceOf[js.Any],
        "Format"            -> Format.asInstanceOf[js.Any],
        "ImportManifestUrl" -> ImportManifestUrl.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[DiskImageDetail]
    }
  }

  object DiskImageFormatEnum {
    val VMDK = "VMDK"
    val RAW  = "RAW"
    val VHD  = "VHD"

    val values = js.Object.freeze(js.Array(VMDK, RAW, VHD))
  }

  /**
    * Describes a disk image volume.
    */
  @js.native
  trait DiskImageVolumeDescription extends js.Object {
    var Id: js.UndefOr[String]
    var Size: js.UndefOr[Double]
  }

  object DiskImageVolumeDescription {
    @inline
    def apply(
        Id: js.UndefOr[String] = js.undefined,
        Size: js.UndefOr[Double] = js.undefined
    ): DiskImageVolumeDescription = {
      val __obj = js.Dynamic.literal()
      Id.foreach(__v => __obj.updateDynamic("Id")(__v.asInstanceOf[js.Any]))
      Size.foreach(__v => __obj.updateDynamic("Size")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DiskImageVolumeDescription]
    }
  }

  /**
    * Describes a DNS entry.
    */
  @js.native
  trait DnsEntry extends js.Object {
    var DnsName: js.UndefOr[String]
    var HostedZoneId: js.UndefOr[String]
  }

  object DnsEntry {
    @inline
    def apply(
        DnsName: js.UndefOr[String] = js.undefined,
        HostedZoneId: js.UndefOr[String] = js.undefined
    ): DnsEntry = {
      val __obj = js.Dynamic.literal()
      DnsName.foreach(__v => __obj.updateDynamic("DnsName")(__v.asInstanceOf[js.Any]))
      HostedZoneId.foreach(__v => __obj.updateDynamic("HostedZoneId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DnsEntry]
    }
  }

  /**
    * Information about the DNS server to be used.
    */
  @js.native
  trait DnsServersOptionsModifyStructure extends js.Object {
    var CustomDnsServers: js.UndefOr[ValueStringList]
    var Enabled: js.UndefOr[Boolean]
  }

  object DnsServersOptionsModifyStructure {
    @inline
    def apply(
        CustomDnsServers: js.UndefOr[ValueStringList] = js.undefined,
        Enabled: js.UndefOr[Boolean] = js.undefined
    ): DnsServersOptionsModifyStructure = {
      val __obj = js.Dynamic.literal()
      CustomDnsServers.foreach(__v => __obj.updateDynamic("CustomDnsServers")(__v.asInstanceOf[js.Any]))
      Enabled.foreach(__v => __obj.updateDynamic("Enabled")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[DnsServersOptionsModifyStructure]
    }
  }

  object DnsSupportValueEnum {
    val enable  = "enable"
    val disable = "disable"

    val values = js.Object.freeze(js.Array(enable, disable))
  }

  object DomainTypeEnum {
    val vpc      = "vpc"
    val standard = "standard"

    val values = js.Object.freeze(js.Array(vpc, standard))
  }

  /**
    * Describes a block device for an EBS volume.
    */
  @js.native
  trait EbsBlockDevice extends js.Object {
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var Iops: js.UndefOr[Int]
    var KmsKeyId: js.UndefOr[String]
    var SnapshotId: js.UndefOr[String]
    var VolumeSize: js.UndefOr[Int]
    var VolumeType: js.UndefOr[VolumeType]
  }

  object EbsBlockDevice {
    @inline
    def apply(
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Iops: js.UndefOr[Int] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        SnapshotId: js.UndefOr[String] = js.undefined,
        VolumeSize: js.UndefOr[Int] = js.undefined,
        VolumeType: js.UndefOr[VolumeType] = js.undefined
    ): EbsBlockDevice = {
      val __obj = js.Dynamic.literal()
      DeleteOnTermination.foreach(__v => __obj.updateDynamic("DeleteOnTermination")(__v.asInstanceOf[js.Any]))
      Encrypted.foreach(__v => __obj.updateDynamic("Encrypted")(__v.asInstanceOf[js.Any]))
      Iops.foreach(__v => __obj.updateDynamic("Iops")(__v.asInstanceOf[js.Any]))
      KmsKeyId.foreach(__v => __obj.updateDynamic("KmsKeyId")(__v.asInstanceOf[js.Any]))
      SnapshotId.foreach(__v => __obj.updateDynamic("SnapshotId")(__v.asInstanceOf[js.Any]))
      VolumeSize.foreach(__v => __obj.updateDynamic("VolumeSize")(__v.asInstanceOf[js.Any]))
      VolumeType.foreach(__v => __obj.updateDynamic("VolumeType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EbsBlockDevice]
    }
  }

  /**
    * Describes a parameter used to set up an EBS volume in a block device mapping.
    */
  @js.native
  trait EbsInstanceBlockDevice extends js.Object {
    var AttachTime: js.UndefOr[DateTime]
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Status: js.UndefOr[AttachmentStatus]
    var VolumeId: js.UndefOr[String]
  }

  object EbsInstanceBlockDevice {
    @inline
    def apply(
        AttachTime: js.UndefOr[DateTime] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Status: js.UndefOr[AttachmentStatus] = js.undefined,
        VolumeId: js.UndefOr[String] = js.undefined
    ): EbsInstanceBlockDevice = {
      val __obj = js.Dynamic.literal()
      AttachTime.foreach(__v => __obj.updateDynamic("AttachTime")(__v.asInstanceOf[js.Any]))
      DeleteOnTermination.foreach(__v => __obj.updateDynamic("DeleteOnTermination")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      VolumeId.foreach(__v => __obj.updateDynamic("VolumeId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EbsInstanceBlockDevice]
    }
  }

  /**
    * Describes information used to set up an EBS volume specified in a block device mapping.
    */
  @js.native
  trait EbsInstanceBlockDeviceSpecification extends js.Object {
    var DeleteOnTermination: js.UndefOr[Boolean]
    var VolumeId: js.UndefOr[String]
  }

  object EbsInstanceBlockDeviceSpecification {
    @inline
    def apply(
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        VolumeId: js.UndefOr[String] = js.undefined
    ): EbsInstanceBlockDeviceSpecification = {
      val __obj = js.Dynamic.literal()
      DeleteOnTermination.foreach(__v => __obj.updateDynamic("DeleteOnTermination")(__v.asInstanceOf[js.Any]))
      VolumeId.foreach(__v => __obj.updateDynamic("VolumeId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EbsInstanceBlockDeviceSpecification]
    }
  }

  /**
    * Describes an egress-only internet gateway.
    */
  @js.native
  trait EgressOnlyInternetGateway extends js.Object {
    var Attachments: js.UndefOr[InternetGatewayAttachmentList]
    var EgressOnlyInternetGatewayId: js.UndefOr[EgressOnlyInternetGatewayId]
  }

  object EgressOnlyInternetGateway {
    @inline
    def apply(
        Attachments: js.UndefOr[InternetGatewayAttachmentList] = js.undefined,
        EgressOnlyInternetGatewayId: js.UndefOr[EgressOnlyInternetGatewayId] = js.undefined
    ): EgressOnlyInternetGateway = {
      val __obj = js.Dynamic.literal()
      Attachments.foreach(__v => __obj.updateDynamic("Attachments")(__v.asInstanceOf[js.Any]))
      EgressOnlyInternetGatewayId.foreach(
        __v => __obj.updateDynamic("EgressOnlyInternetGatewayId")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[EgressOnlyInternetGateway]
    }
  }

  /**
    * Describes the association between an instance and an Elastic Graphics accelerator.
    */
  @js.native
  trait ElasticGpuAssociation extends js.Object {
    var ElasticGpuAssociationId: js.UndefOr[String]
    var ElasticGpuAssociationState: js.UndefOr[String]
    var ElasticGpuAssociationTime: js.UndefOr[String]
    var ElasticGpuId: js.UndefOr[String]
  }

  object ElasticGpuAssociation {
    @inline
    def apply(
        ElasticGpuAssociationId: js.UndefOr[String] = js.undefined,
        ElasticGpuAssociationState: js.UndefOr[String] = js.undefined,
        ElasticGpuAssociationTime: js.UndefOr[String] = js.undefined,
        ElasticGpuId: js.UndefOr[String] = js.undefined
    ): ElasticGpuAssociation = {
      val __obj = js.Dynamic.literal()
      ElasticGpuAssociationId.foreach(__v => __obj.updateDynamic("ElasticGpuAssociationId")(__v.asInstanceOf[js.Any]))
      ElasticGpuAssociationState.foreach(
        __v => __obj.updateDynamic("ElasticGpuAssociationState")(__v.asInstanceOf[js.Any])
      )
      ElasticGpuAssociationTime.foreach(
        __v => __obj.updateDynamic("ElasticGpuAssociationTime")(__v.asInstanceOf[js.Any])
      )
      ElasticGpuId.foreach(__v => __obj.updateDynamic("ElasticGpuId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ElasticGpuAssociation]
    }
  }

  /**
    * Describes the status of an Elastic Graphics accelerator.
    */
  @js.native
  trait ElasticGpuHealth extends js.Object {
    var Status: js.UndefOr[ElasticGpuStatus]
  }

  object ElasticGpuHealth {
    @inline
    def apply(
        Status: js.UndefOr[ElasticGpuStatus] = js.undefined
    ): ElasticGpuHealth = {
      val __obj = js.Dynamic.literal()
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ElasticGpuHealth]
    }
  }

  /**
    * A specification for an Elastic Graphics accelerator.
    */
  @js.native
  trait ElasticGpuSpecification extends js.Object {
    var Type: String
  }

  object ElasticGpuSpecification {
    @inline
    def apply(
        Type: String
    ): ElasticGpuSpecification = {
      val __obj = js.Dynamic.literal(
        "Type" -> Type.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[ElasticGpuSpecification]
    }
  }

  /**
    * Describes an elastic GPU.
    */
  @js.native
  trait ElasticGpuSpecificationResponse extends js.Object {
    var Type: js.UndefOr[String]
  }

  object ElasticGpuSpecificationResponse {
    @inline
    def apply(
        Type: js.UndefOr[String] = js.undefined
    ): ElasticGpuSpecificationResponse = {
      val __obj = js.Dynamic.literal()
      Type.foreach(__v => __obj.updateDynamic("Type")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ElasticGpuSpecificationResponse]
    }
  }

  object ElasticGpuStateEnum {
    val ATTACHED = "ATTACHED"

    val values = js.Object.freeze(js.Array(ATTACHED))
  }

  object ElasticGpuStatusEnum {
    val OK       = "OK"
    val IMPAIRED = "IMPAIRED"

    val values = js.Object.freeze(js.Array(OK, IMPAIRED))
  }

  /**
    * Describes an Elastic Graphics accelerator.
    */
  @js.native
  trait ElasticGpus extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var ElasticGpuHealth: js.UndefOr[ElasticGpuHealth]
    var ElasticGpuId: js.UndefOr[String]
    var ElasticGpuState: js.UndefOr[ElasticGpuState]
    var ElasticGpuType: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
  }

  object ElasticGpus {
    @inline
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        ElasticGpuHealth: js.UndefOr[ElasticGpuHealth] = js.undefined,
        ElasticGpuId: js.UndefOr[String] = js.undefined,
        ElasticGpuState: js.UndefOr[ElasticGpuState] = js.undefined,
        ElasticGpuType: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): ElasticGpus = {
      val __obj = js.Dynamic.literal()
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      ElasticGpuHealth.foreach(__v => __obj.updateDynamic("ElasticGpuHealth")(__v.asInstanceOf[js.Any]))
      ElasticGpuId.foreach(__v => __obj.updateDynamic("ElasticGpuId")(__v.asInstanceOf[js.Any]))
      ElasticGpuState.foreach(__v => __obj.updateDynamic("ElasticGpuState")(__v.asInstanceOf[js.Any]))
      ElasticGpuType.foreach(__v => __obj.updateDynamic("ElasticGpuType")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ElasticGpus]
    }
  }

  /**
    * Describes an elastic inference accelerator.
    */
  @js.native
  trait ElasticInferenceAccelerator extends js.Object {
    var Type: String
  }

  object ElasticInferenceAccelerator {
    @inline
    def apply(
        Type: String
    ): ElasticInferenceAccelerator = {
      val __obj = js.Dynamic.literal(
        "Type" -> Type.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[ElasticInferenceAccelerator]
    }
  }

  /**
    * Describes the association between an instance and an elastic inference accelerator.
    */
  @js.native
  trait ElasticInferenceAcceleratorAssociation extends js.Object {
    var ElasticInferenceAcceleratorArn: js.UndefOr[String]
    var ElasticInferenceAcceleratorAssociationId: js.UndefOr[String]
    var ElasticInferenceAcceleratorAssociationState: js.UndefOr[String]
    var ElasticInferenceAcceleratorAssociationTime: js.UndefOr[DateTime]
  }

  object ElasticInferenceAcceleratorAssociation {
    @inline
    def apply(
        ElasticInferenceAcceleratorArn: js.UndefOr[String] = js.undefined,
        ElasticInferenceAcceleratorAssociationId: js.UndefOr[String] = js.undefined,
        ElasticInferenceAcceleratorAssociationState: js.UndefOr[String] = js.undefined,
        ElasticInferenceAcceleratorAssociationTime: js.UndefOr[DateTime] = js.undefined
    ): ElasticInferenceAcceleratorAssociation = {
      val __obj = js.Dynamic.literal()
      ElasticInferenceAcceleratorArn.foreach(
        __v => __obj.updateDynamic("ElasticInferenceAcceleratorArn")(__v.asInstanceOf[js.Any])
      )
      ElasticInferenceAcceleratorAssociationId.foreach(
        __v => __obj.updateDynamic("ElasticInferenceAcceleratorAssociationId")(__v.asInstanceOf[js.Any])
      )
      ElasticInferenceAcceleratorAssociationState.foreach(
        __v => __obj.updateDynamic("ElasticInferenceAcceleratorAssociationState")(__v.asInstanceOf[js.Any])
      )
      ElasticInferenceAcceleratorAssociationTime.foreach(
        __v => __obj.updateDynamic("ElasticInferenceAcceleratorAssociationTime")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[ElasticInferenceAcceleratorAssociation]
    }
  }

  @js.native
  trait EnableEbsEncryptionByDefaultRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object EnableEbsEncryptionByDefaultRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): EnableEbsEncryptionByDefaultRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EnableEbsEncryptionByDefaultRequest]
    }
  }

  @js.native
  trait EnableEbsEncryptionByDefaultResult extends js.Object {
    var EbsEncryptionByDefault: js.UndefOr[Boolean]
  }

  object EnableEbsEncryptionByDefaultResult {
    @inline
    def apply(
        EbsEncryptionByDefault: js.UndefOr[Boolean] = js.undefined
    ): EnableEbsEncryptionByDefaultResult = {
      val __obj = js.Dynamic.literal()
      EbsEncryptionByDefault.foreach(__v => __obj.updateDynamic("EbsEncryptionByDefault")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EnableEbsEncryptionByDefaultResult]
    }
  }

  @js.native
  trait EnableTransitGatewayRouteTablePropagationRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object EnableTransitGatewayRouteTablePropagationRequest {
    @inline
    def apply(
        TransitGatewayAttachmentId: String,
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): EnableTransitGatewayRouteTablePropagationRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EnableTransitGatewayRouteTablePropagationRequest]
    }
  }

  @js.native
  trait EnableTransitGatewayRouteTablePropagationResult extends js.Object {
    var Propagation: js.UndefOr[TransitGatewayPropagation]
  }

  object EnableTransitGatewayRouteTablePropagationResult {
    @inline
    def apply(
        Propagation: js.UndefOr[TransitGatewayPropagation] = js.undefined
    ): EnableTransitGatewayRouteTablePropagationResult = {
      val __obj = js.Dynamic.literal()
      Propagation.foreach(__v => __obj.updateDynamic("Propagation")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EnableTransitGatewayRouteTablePropagationResult]
    }
  }

  /**
    * Contains the parameters for EnableVgwRoutePropagation.
    */
  @js.native
  trait EnableVgwRoutePropagationRequest extends js.Object {
    var GatewayId: String
    var RouteTableId: String
  }

  object EnableVgwRoutePropagationRequest {
    @inline
    def apply(
        GatewayId: String,
        RouteTableId: String
    ): EnableVgwRoutePropagationRequest = {
      val __obj = js.Dynamic.literal(
        "GatewayId"    -> GatewayId.asInstanceOf[js.Any],
        "RouteTableId" -> RouteTableId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[EnableVgwRoutePropagationRequest]
    }
  }

  /**
    * Contains the parameters for EnableVolumeIO.
    */
  @js.native
  trait EnableVolumeIORequest extends js.Object {
    var VolumeId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object EnableVolumeIORequest {
    @inline
    def apply(
        VolumeId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): EnableVolumeIORequest = {
      val __obj = js.Dynamic.literal(
        "VolumeId" -> VolumeId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EnableVolumeIORequest]
    }
  }

  @js.native
  trait EnableVpcClassicLinkDnsSupportRequest extends js.Object {
    var VpcId: js.UndefOr[String]
  }

  object EnableVpcClassicLinkDnsSupportRequest {
    @inline
    def apply(
        VpcId: js.UndefOr[String] = js.undefined
    ): EnableVpcClassicLinkDnsSupportRequest = {
      val __obj = js.Dynamic.literal()
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EnableVpcClassicLinkDnsSupportRequest]
    }
  }

  @js.native
  trait EnableVpcClassicLinkDnsSupportResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object EnableVpcClassicLinkDnsSupportResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): EnableVpcClassicLinkDnsSupportResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EnableVpcClassicLinkDnsSupportResult]
    }
  }

  @js.native
  trait EnableVpcClassicLinkRequest extends js.Object {
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object EnableVpcClassicLinkRequest {
    @inline
    def apply(
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): EnableVpcClassicLinkRequest = {
      val __obj = js.Dynamic.literal(
        "VpcId" -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EnableVpcClassicLinkRequest]
    }
  }

  @js.native
  trait EnableVpcClassicLinkResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object EnableVpcClassicLinkResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): EnableVpcClassicLinkResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EnableVpcClassicLinkResult]
    }
  }

  object EndDateTypeEnum {
    val unlimited = "unlimited"
    val limited   = "limited"

    val values = js.Object.freeze(js.Array(unlimited, limited))
  }

  object EventCodeEnum {
    val `instance-reboot`     = "instance-reboot"
    val `system-reboot`       = "system-reboot"
    val `system-maintenance`  = "system-maintenance"
    val `instance-retirement` = "instance-retirement"
    val `instance-stop`       = "instance-stop"

    val values = js.Object.freeze(
      js.Array(`instance-reboot`, `system-reboot`, `system-maintenance`, `instance-retirement`, `instance-stop`)
    )
  }

  /**
    * Describes an EC2 Fleet or Spot Fleet event.
    */
  @js.native
  trait EventInformation extends js.Object {
    var EventDescription: js.UndefOr[String]
    var EventSubType: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
  }

  object EventInformation {
    @inline
    def apply(
        EventDescription: js.UndefOr[String] = js.undefined,
        EventSubType: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): EventInformation = {
      val __obj = js.Dynamic.literal()
      EventDescription.foreach(__v => __obj.updateDynamic("EventDescription")(__v.asInstanceOf[js.Any]))
      EventSubType.foreach(__v => __obj.updateDynamic("EventSubType")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[EventInformation]
    }
  }

  object EventTypeEnum {
    val instanceChange     = "instanceChange"
    val fleetRequestChange = "fleetRequestChange"
    val error              = "error"
    val information        = "information"

    val values = js.Object.freeze(js.Array(instanceChange, fleetRequestChange, error, information))
  }

  object ExcessCapacityTerminationPolicyEnum {
    val noTermination = "noTermination"
    val default       = "default"

    val values = js.Object.freeze(js.Array(noTermination, default))
  }

  @js.native
  trait ExportClientVpnClientCertificateRevocationListRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ExportClientVpnClientCertificateRevocationListRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ExportClientVpnClientCertificateRevocationListRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportClientVpnClientCertificateRevocationListRequest]
    }
  }

  @js.native
  trait ExportClientVpnClientCertificateRevocationListResult extends js.Object {
    var CertificateRevocationList: js.UndefOr[String]
    var Status: js.UndefOr[ClientCertificateRevocationListStatus]
  }

  object ExportClientVpnClientCertificateRevocationListResult {
    @inline
    def apply(
        CertificateRevocationList: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[ClientCertificateRevocationListStatus] = js.undefined
    ): ExportClientVpnClientCertificateRevocationListResult = {
      val __obj = js.Dynamic.literal()
      CertificateRevocationList.foreach(
        __v => __obj.updateDynamic("CertificateRevocationList")(__v.asInstanceOf[js.Any])
      )
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportClientVpnClientCertificateRevocationListResult]
    }
  }

  @js.native
  trait ExportClientVpnClientConfigurationRequest extends js.Object {
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ExportClientVpnClientConfigurationRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ExportClientVpnClientConfigurationRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportClientVpnClientConfigurationRequest]
    }
  }

  @js.native
  trait ExportClientVpnClientConfigurationResult extends js.Object {
    var ClientConfiguration: js.UndefOr[String]
  }

  object ExportClientVpnClientConfigurationResult {
    @inline
    def apply(
        ClientConfiguration: js.UndefOr[String] = js.undefined
    ): ExportClientVpnClientConfigurationResult = {
      val __obj = js.Dynamic.literal()
      ClientConfiguration.foreach(__v => __obj.updateDynamic("ClientConfiguration")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportClientVpnClientConfigurationResult]
    }
  }

  object ExportEnvironmentEnum {
    val citrix    = "citrix"
    val vmware    = "vmware"
    val microsoft = "microsoft"

    val values = js.Object.freeze(js.Array(citrix, vmware, microsoft))
  }

  @js.native
  trait ExportImageRequest extends js.Object {
    var DiskImageFormat: DiskImageFormat
    var ImageId: String
    var S3ExportLocation: ExportTaskS3LocationRequest
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var RoleName: js.UndefOr[String]
  }

  object ExportImageRequest {
    @inline
    def apply(
        DiskImageFormat: DiskImageFormat,
        ImageId: String,
        S3ExportLocation: ExportTaskS3LocationRequest,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        RoleName: js.UndefOr[String] = js.undefined
    ): ExportImageRequest = {
      val __obj = js.Dynamic.literal(
        "DiskImageFormat"  -> DiskImageFormat.asInstanceOf[js.Any],
        "ImageId"          -> ImageId.asInstanceOf[js.Any],
        "S3ExportLocation" -> S3ExportLocation.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      RoleName.foreach(__v => __obj.updateDynamic("RoleName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportImageRequest]
    }
  }

  @js.native
  trait ExportImageResult extends js.Object {
    var Description: js.UndefOr[String]
    var DiskImageFormat: js.UndefOr[DiskImageFormat]
    var ExportImageTaskId: js.UndefOr[String]
    var ImageId: js.UndefOr[String]
    var Progress: js.UndefOr[String]
    var RoleName: js.UndefOr[String]
    var S3ExportLocation: js.UndefOr[ExportTaskS3Location]
    var Status: js.UndefOr[String]
    var StatusMessage: js.UndefOr[String]
  }

  object ExportImageResult {
    @inline
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        DiskImageFormat: js.UndefOr[DiskImageFormat] = js.undefined,
        ExportImageTaskId: js.UndefOr[String] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        Progress: js.UndefOr[String] = js.undefined,
        RoleName: js.UndefOr[String] = js.undefined,
        S3ExportLocation: js.UndefOr[ExportTaskS3Location] = js.undefined,
        Status: js.UndefOr[String] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined
    ): ExportImageResult = {
      val __obj = js.Dynamic.literal()
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DiskImageFormat.foreach(__v => __obj.updateDynamic("DiskImageFormat")(__v.asInstanceOf[js.Any]))
      ExportImageTaskId.foreach(__v => __obj.updateDynamic("ExportImageTaskId")(__v.asInstanceOf[js.Any]))
      ImageId.foreach(__v => __obj.updateDynamic("ImageId")(__v.asInstanceOf[js.Any]))
      Progress.foreach(__v => __obj.updateDynamic("Progress")(__v.asInstanceOf[js.Any]))
      RoleName.foreach(__v => __obj.updateDynamic("RoleName")(__v.asInstanceOf[js.Any]))
      S3ExportLocation.foreach(__v => __obj.updateDynamic("S3ExportLocation")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      StatusMessage.foreach(__v => __obj.updateDynamic("StatusMessage")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportImageResult]
    }
  }

  /**
    * Describes an export image task.
    */
  @js.native
  trait ExportImageTask extends js.Object {
    var Description: js.UndefOr[String]
    var ExportImageTaskId: js.UndefOr[String]
    var ImageId: js.UndefOr[String]
    var Progress: js.UndefOr[String]
    var S3ExportLocation: js.UndefOr[ExportTaskS3Location]
    var Status: js.UndefOr[String]
    var StatusMessage: js.UndefOr[String]
  }

  object ExportImageTask {
    @inline
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        ExportImageTaskId: js.UndefOr[String] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        Progress: js.UndefOr[String] = js.undefined,
        S3ExportLocation: js.UndefOr[ExportTaskS3Location] = js.undefined,
        Status: js.UndefOr[String] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined
    ): ExportImageTask = {
      val __obj = js.Dynamic.literal()
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      ExportImageTaskId.foreach(__v => __obj.updateDynamic("ExportImageTaskId")(__v.asInstanceOf[js.Any]))
      ImageId.foreach(__v => __obj.updateDynamic("ImageId")(__v.asInstanceOf[js.Any]))
      Progress.foreach(__v => __obj.updateDynamic("Progress")(__v.asInstanceOf[js.Any]))
      S3ExportLocation.foreach(__v => __obj.updateDynamic("S3ExportLocation")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      StatusMessage.foreach(__v => __obj.updateDynamic("StatusMessage")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportImageTask]
    }
  }

  /**
    * Describes an instance export task.
    */
  @js.native
  trait ExportTask extends js.Object {
    var Description: js.UndefOr[String]
    var ExportTaskId: js.UndefOr[String]
    var ExportToS3Task: js.UndefOr[ExportToS3Task]
    var InstanceExportDetails: js.UndefOr[InstanceExportDetails]
    var State: js.UndefOr[ExportTaskState]
    var StatusMessage: js.UndefOr[String]
  }

  object ExportTask {
    @inline
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        ExportTaskId: js.UndefOr[String] = js.undefined,
        ExportToS3Task: js.UndefOr[ExportToS3Task] = js.undefined,
        InstanceExportDetails: js.UndefOr[InstanceExportDetails] = js.undefined,
        State: js.UndefOr[ExportTaskState] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined
    ): ExportTask = {
      val __obj = js.Dynamic.literal()
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      ExportTaskId.foreach(__v => __obj.updateDynamic("ExportTaskId")(__v.asInstanceOf[js.Any]))
      ExportToS3Task.foreach(__v => __obj.updateDynamic("ExportToS3Task")(__v.asInstanceOf[js.Any]))
      InstanceExportDetails.foreach(__v => __obj.updateDynamic("InstanceExportDetails")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      StatusMessage.foreach(__v => __obj.updateDynamic("StatusMessage")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportTask]
    }
  }

  /**
    * Describes the destination for an export image task.
    */
  @js.native
  trait ExportTaskS3Location extends js.Object {
    var S3Bucket: js.UndefOr[String]
    var S3Prefix: js.UndefOr[String]
  }

  object ExportTaskS3Location {
    @inline
    def apply(
        S3Bucket: js.UndefOr[String] = js.undefined,
        S3Prefix: js.UndefOr[String] = js.undefined
    ): ExportTaskS3Location = {
      val __obj = js.Dynamic.literal()
      S3Bucket.foreach(__v => __obj.updateDynamic("S3Bucket")(__v.asInstanceOf[js.Any]))
      S3Prefix.foreach(__v => __obj.updateDynamic("S3Prefix")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportTaskS3Location]
    }
  }

  /**
    * Describes the destination for an export image task.
    */
  @js.native
  trait ExportTaskS3LocationRequest extends js.Object {
    var S3Bucket: String
    var S3Prefix: js.UndefOr[String]
  }

  object ExportTaskS3LocationRequest {
    @inline
    def apply(
        S3Bucket: String,
        S3Prefix: js.UndefOr[String] = js.undefined
    ): ExportTaskS3LocationRequest = {
      val __obj = js.Dynamic.literal(
        "S3Bucket" -> S3Bucket.asInstanceOf[js.Any]
      )

      S3Prefix.foreach(__v => __obj.updateDynamic("S3Prefix")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportTaskS3LocationRequest]
    }
  }

  object ExportTaskStateEnum {
    val active     = "active"
    val cancelling = "cancelling"
    val cancelled  = "cancelled"
    val completed  = "completed"

    val values = js.Object.freeze(js.Array(active, cancelling, cancelled, completed))
  }

  /**
    * Describes the format and location for an instance export task.
    */
  @js.native
  trait ExportToS3Task extends js.Object {
    var ContainerFormat: js.UndefOr[ContainerFormat]
    var DiskImageFormat: js.UndefOr[DiskImageFormat]
    var S3Bucket: js.UndefOr[String]
    var S3Key: js.UndefOr[String]
  }

  object ExportToS3Task {
    @inline
    def apply(
        ContainerFormat: js.UndefOr[ContainerFormat] = js.undefined,
        DiskImageFormat: js.UndefOr[DiskImageFormat] = js.undefined,
        S3Bucket: js.UndefOr[String] = js.undefined,
        S3Key: js.UndefOr[String] = js.undefined
    ): ExportToS3Task = {
      val __obj = js.Dynamic.literal()
      ContainerFormat.foreach(__v => __obj.updateDynamic("ContainerFormat")(__v.asInstanceOf[js.Any]))
      DiskImageFormat.foreach(__v => __obj.updateDynamic("DiskImageFormat")(__v.asInstanceOf[js.Any]))
      S3Bucket.foreach(__v => __obj.updateDynamic("S3Bucket")(__v.asInstanceOf[js.Any]))
      S3Key.foreach(__v => __obj.updateDynamic("S3Key")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportToS3Task]
    }
  }

  /**
    * Describes an instance export task.
    */
  @js.native
  trait ExportToS3TaskSpecification extends js.Object {
    var ContainerFormat: js.UndefOr[ContainerFormat]
    var DiskImageFormat: js.UndefOr[DiskImageFormat]
    var S3Bucket: js.UndefOr[String]
    var S3Prefix: js.UndefOr[String]
  }

  object ExportToS3TaskSpecification {
    @inline
    def apply(
        ContainerFormat: js.UndefOr[ContainerFormat] = js.undefined,
        DiskImageFormat: js.UndefOr[DiskImageFormat] = js.undefined,
        S3Bucket: js.UndefOr[String] = js.undefined,
        S3Prefix: js.UndefOr[String] = js.undefined
    ): ExportToS3TaskSpecification = {
      val __obj = js.Dynamic.literal()
      ContainerFormat.foreach(__v => __obj.updateDynamic("ContainerFormat")(__v.asInstanceOf[js.Any]))
      DiskImageFormat.foreach(__v => __obj.updateDynamic("DiskImageFormat")(__v.asInstanceOf[js.Any]))
      S3Bucket.foreach(__v => __obj.updateDynamic("S3Bucket")(__v.asInstanceOf[js.Any]))
      S3Prefix.foreach(__v => __obj.updateDynamic("S3Prefix")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportToS3TaskSpecification]
    }
  }

  @js.native
  trait ExportTransitGatewayRoutesRequest extends js.Object {
    var S3Bucket: String
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
  }

  object ExportTransitGatewayRoutesRequest {
    @inline
    def apply(
        S3Bucket: String,
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined
    ): ExportTransitGatewayRoutesRequest = {
      val __obj = js.Dynamic.literal(
        "S3Bucket"                   -> S3Bucket.asInstanceOf[js.Any],
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportTransitGatewayRoutesRequest]
    }
  }

  @js.native
  trait ExportTransitGatewayRoutesResult extends js.Object {
    var S3Location: js.UndefOr[String]
  }

  object ExportTransitGatewayRoutesResult {
    @inline
    def apply(
        S3Location: js.UndefOr[String] = js.undefined
    ): ExportTransitGatewayRoutesResult = {
      val __obj = js.Dynamic.literal()
      S3Location.foreach(__v => __obj.updateDynamic("S3Location")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ExportTransitGatewayRoutesResult]
    }
  }

  /**
    * A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as tags, attributes, or IDs. The filters supported by a describe operation are documented with the describe operation. For example:
    * * <a>DescribeAvailabilityZones</a>
    *  * <a>DescribeImages</a>
    *  * <a>DescribeInstances</a>
    *  * <a>DescribeKeyPairs</a>
    *  * <a>DescribeSecurityGroups</a>
    *  * <a>DescribeSnapshots</a>
    *  * <a>DescribeSubnets</a>
    *  * <a>DescribeTags</a>
    *  * <a>DescribeVolumes</a>
    *  * <a>DescribeVpcs</a>
    */
  @js.native
  trait Filter extends js.Object {
    var Name: js.UndefOr[String]
    var Values: js.UndefOr[ValueStringList]
  }

  object Filter {
    @inline
    def apply(
        Name: js.UndefOr[String] = js.undefined,
        Values: js.UndefOr[ValueStringList] = js.undefined
    ): Filter = {
      val __obj = js.Dynamic.literal()
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      Values.foreach(__v => __obj.updateDynamic("Values")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[Filter]
    }
  }

  object FleetActivityStatusEnum {
    val error                 = "error"
    val `pending-fulfillment` = "pending-fulfillment"
    val `pending-termination` = "pending-termination"
    val fulfilled             = "fulfilled"

    val values = js.Object.freeze(js.Array(error, `pending-fulfillment`, `pending-termination`, fulfilled))
  }

  /**
    * Describes an EC2 Fleet.
    */
  @js.native
  trait FleetData extends js.Object {
    var ActivityStatus: js.UndefOr[FleetActivityStatus]
    var ClientToken: js.UndefOr[String]
    var CreateTime: js.UndefOr[DateTime]
    var Errors: js.UndefOr[DescribeFleetsErrorSet]
    var ExcessCapacityTerminationPolicy: js.UndefOr[FleetExcessCapacityTerminationPolicy]
    var FleetId: js.UndefOr[FleetIdentifier]
    var FleetState: js.UndefOr[FleetStateCode]
    var FulfilledCapacity: js.UndefOr[Double]
    var FulfilledOnDemandCapacity: js.UndefOr[Double]
    var Instances: js.UndefOr[DescribeFleetsInstancesSet]
    var LaunchTemplateConfigs: js.UndefOr[FleetLaunchTemplateConfigList]
    var OnDemandOptions: js.UndefOr[OnDemandOptions]
    var ReplaceUnhealthyInstances: js.UndefOr[Boolean]
    var SpotOptions: js.UndefOr[SpotOptions]
    var Tags: js.UndefOr[TagList]
    var TargetCapacitySpecification: js.UndefOr[TargetCapacitySpecification]
    var TerminateInstancesWithExpiration: js.UndefOr[Boolean]
    var Type: js.UndefOr[FleetType]
    var ValidFrom: js.UndefOr[DateTime]
    var ValidUntil: js.UndefOr[DateTime]
  }

  object FleetData {
    @inline
    def apply(
        ActivityStatus: js.UndefOr[FleetActivityStatus] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        CreateTime: js.UndefOr[DateTime] = js.undefined,
        Errors: js.UndefOr[DescribeFleetsErrorSet] = js.undefined,
        ExcessCapacityTerminationPolicy: js.UndefOr[FleetExcessCapacityTerminationPolicy] = js.undefined,
        FleetId: js.UndefOr[FleetIdentifier] = js.undefined,
        FleetState: js.UndefOr[FleetStateCode] = js.undefined,
        FulfilledCapacity: js.UndefOr[Double] = js.undefined,
        FulfilledOnDemandCapacity: js.UndefOr[Double] = js.undefined,
        Instances: js.UndefOr[DescribeFleetsInstancesSet] = js.undefined,
        LaunchTemplateConfigs: js.UndefOr[FleetLaunchTemplateConfigList] = js.undefined,
        OnDemandOptions: js.UndefOr[OnDemandOptions] = js.undefined,
        ReplaceUnhealthyInstances: js.UndefOr[Boolean] = js.undefined,
        SpotOptions: js.UndefOr[SpotOptions] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        TargetCapacitySpecification: js.UndefOr[TargetCapacitySpecification] = js.undefined,
        TerminateInstancesWithExpiration: js.UndefOr[Boolean] = js.undefined,
        Type: js.UndefOr[FleetType] = js.undefined,
        ValidFrom: js.UndefOr[DateTime] = js.undefined,
        ValidUntil: js.UndefOr[DateTime] = js.undefined
    ): FleetData = {
      val __obj = js.Dynamic.literal()
      ActivityStatus.foreach(__v => __obj.updateDynamic("ActivityStatus")(__v.asInstanceOf[js.Any]))
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      CreateTime.foreach(__v => __obj.updateDynamic("CreateTime")(__v.asInstanceOf[js.Any]))
      Errors.foreach(__v => __obj.updateDynamic("Errors")(__v.asInstanceOf[js.Any]))
      ExcessCapacityTerminationPolicy.foreach(
        __v => __obj.updateDynamic("ExcessCapacityTerminationPolicy")(__v.asInstanceOf[js.Any])
      )
      FleetId.foreach(__v => __obj.updateDynamic("FleetId")(__v.asInstanceOf[js.Any]))
      FleetState.foreach(__v => __obj.updateDynamic("FleetState")(__v.asInstanceOf[js.Any]))
      FulfilledCapacity.foreach(__v => __obj.updateDynamic("FulfilledCapacity")(__v.asInstanceOf[js.Any]))
      FulfilledOnDemandCapacity.foreach(
        __v => __obj.updateDynamic("FulfilledOnDemandCapacity")(__v.asInstanceOf[js.Any])
      )
      Instances.foreach(__v => __obj.updateDynamic("Instances")(__v.asInstanceOf[js.Any]))
      LaunchTemplateConfigs.foreach(__v => __obj.updateDynamic("LaunchTemplateConfigs")(__v.asInstanceOf[js.Any]))
      OnDemandOptions.foreach(__v => __obj.updateDynamic("OnDemandOptions")(__v.asInstanceOf[js.Any]))
      ReplaceUnhealthyInstances.foreach(
        __v => __obj.updateDynamic("ReplaceUnhealthyInstances")(__v.asInstanceOf[js.Any])
      )
      SpotOptions.foreach(__v => __obj.updateDynamic("SpotOptions")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      TargetCapacitySpecification.foreach(
        __v => __obj.updateDynamic("TargetCapacitySpecification")(__v.asInstanceOf[js.Any])
      )
      TerminateInstancesWithExpiration.foreach(
        __v => __obj.updateDynamic("TerminateInstancesWithExpiration")(__v.asInstanceOf[js.Any])
      )
      Type.foreach(__v => __obj.updateDynamic("Type")(__v.asInstanceOf[js.Any]))
      ValidFrom.foreach(__v => __obj.updateDynamic("ValidFrom")(__v.asInstanceOf[js.Any]))
      ValidUntil.foreach(__v => __obj.updateDynamic("ValidUntil")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[FleetData]
    }
  }

  object FleetEventTypeEnum {
    val `instance-change` = "instance-change"
    val `fleet-change`    = "fleet-change"
    val `service-error`   = "service-error"

    val values = js.Object.freeze(js.Array(`instance-change`, `fleet-change`, `service-error`))
  }

  object FleetExcessCapacityTerminationPolicyEnum {
    val `no-termination` = "no-termination"
    val termination      = "termination"

    val values = js.Object.freeze(js.Array(`no-termination`, termination))
  }

  /**
    * Describes a launch template and overrides.
    */
  @js.native
  trait FleetLaunchTemplateConfig extends js.Object {
    var LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecification]
    var Overrides: js.UndefOr[FleetLaunchTemplateOverridesList]
  }

  object FleetLaunchTemplateConfig {
    @inline
    def apply(
        LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecification] = js.undefined,
        Overrides: js.UndefOr[FleetLaunchTemplateOverridesList] = js.undefined
    ): FleetLaunchTemplateConfig = {
      val __obj = js.Dynamic.literal()
      LaunchTemplateSpecification.foreach(
        __v => __obj.updateDynamic("LaunchTemplateSpecification")(__v.asInstanceOf[js.Any])
      )
      Overrides.foreach(__v => __obj.updateDynamic("Overrides")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[FleetLaunchTemplateConfig]
    }
  }

  /**
    * Describes a launch template and overrides.
    */
  @js.native
  trait FleetLaunchTemplateConfigRequest extends js.Object {
    var LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecificationRequest]
    var Overrides: js.UndefOr[FleetLaunchTemplateOverridesListRequest]
  }

  object FleetLaunchTemplateConfigRequest {
    @inline
    def apply(
        LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecificationRequest] = js.undefined,
        Overrides: js.UndefOr[FleetLaunchTemplateOverridesListRequest] = js.undefined
    ): FleetLaunchTemplateConfigRequest = {
      val __obj = js.Dynamic.literal()
      LaunchTemplateSpecification.foreach(
        __v => __obj.updateDynamic("LaunchTemplateSpecification")(__v.asInstanceOf[js.Any])
      )
      Overrides.foreach(__v => __obj.updateDynamic("Overrides")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[FleetLaunchTemplateConfigRequest]
    }
  }

  /**
    * Describes overrides for a launch template.
    */
  @js.native
  trait FleetLaunchTemplateOverrides extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var InstanceType: js.UndefOr[InstanceType]
    var MaxPrice: js.UndefOr[String]
    var Placement: js.UndefOr[PlacementResponse]
    var Priority: js.UndefOr[Double]
    var SubnetId: js.UndefOr[String]
    var WeightedCapacity: js.UndefOr[Double]
  }

  object FleetLaunchTemplateOverrides {
    @inline
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        MaxPrice: js.UndefOr[String] = js.undefined,
        Placement: js.UndefOr[PlacementResponse] = js.undefined,
        Priority: js.UndefOr[Double] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        WeightedCapacity: js.UndefOr[Double] = js.undefined
    ): FleetLaunchTemplateOverrides = {
      val __obj = js.Dynamic.literal()
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      MaxPrice.foreach(__v => __obj.updateDynamic("MaxPrice")(__v.asInstanceOf[js.Any]))
      Placement.foreach(__v => __obj.updateDynamic("Placement")(__v.asInstanceOf[js.Any]))
      Priority.foreach(__v => __obj.updateDynamic("Priority")(__v.asInstanceOf[js.Any]))
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      WeightedCapacity.foreach(__v => __obj.updateDynamic("WeightedCapacity")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[FleetLaunchTemplateOverrides]
    }
  }

  /**
    * Describes overrides for a launch template.
    */
  @js.native
  trait FleetLaunchTemplateOverridesRequest extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var InstanceType: js.UndefOr[InstanceType]
    var MaxPrice: js.UndefOr[String]
    var Placement: js.UndefOr[Placement]
    var Priority: js.UndefOr[Double]
    var SubnetId: js.UndefOr[String]
    var WeightedCapacity: js.UndefOr[Double]
  }

  object FleetLaunchTemplateOverridesRequest {
    @inline
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        MaxPrice: js.UndefOr[String] = js.undefined,
        Placement: js.UndefOr[Placement] = js.undefined,
        Priority: js.UndefOr[Double] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        WeightedCapacity: js.UndefOr[Double] = js.undefined
    ): FleetLaunchTemplateOverridesRequest = {
      val __obj = js.Dynamic.literal()
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      MaxPrice.foreach(__v => __obj.updateDynamic("MaxPrice")(__v.asInstanceOf[js.Any]))
      Placement.foreach(__v => __obj.updateDynamic("Placement")(__v.asInstanceOf[js.Any]))
      Priority.foreach(__v => __obj.updateDynamic("Priority")(__v.asInstanceOf[js.Any]))
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      WeightedCapacity.foreach(__v => __obj.updateDynamic("WeightedCapacity")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[FleetLaunchTemplateOverridesRequest]
    }
  }

  /**
    * Describes a launch template.
    */
  @js.native
  trait FleetLaunchTemplateSpecification extends js.Object {
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
    var Version: js.UndefOr[String]
  }

  object FleetLaunchTemplateSpecification {
    @inline
    def apply(
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined,
        Version: js.UndefOr[String] = js.undefined
    ): FleetLaunchTemplateSpecification = {
      val __obj = js.Dynamic.literal()
      LaunchTemplateId.foreach(__v => __obj.updateDynamic("LaunchTemplateId")(__v.asInstanceOf[js.Any]))
      LaunchTemplateName.foreach(__v => __obj.updateDynamic("LaunchTemplateName")(__v.asInstanceOf[js.Any]))
      Version.foreach(__v => __obj.updateDynamic("Version")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[FleetLaunchTemplateSpecification]
    }
  }

  /**
    * The launch template to use. You must specify either the launch template ID or launch template name in the request.
    */
  @js.native
  trait FleetLaunchTemplateSpecificationRequest extends js.Object {
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
    var Version: js.UndefOr[String]
  }

  object FleetLaunchTemplateSpecificationRequest {
    @inline
    def apply(
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined,
        Version: js.UndefOr[String] = js.undefined
    ): FleetLaunchTemplateSpecificationRequest = {
      val __obj = js.Dynamic.literal()
      LaunchTemplateId.foreach(__v => __obj.updateDynamic("LaunchTemplateId")(__v.asInstanceOf[js.Any]))
      LaunchTemplateName.foreach(__v => __obj.updateDynamic("LaunchTemplateName")(__v.asInstanceOf[js.Any]))
      Version.foreach(__v => __obj.updateDynamic("Version")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[FleetLaunchTemplateSpecificationRequest]
    }
  }

  object FleetOnDemandAllocationStrategyEnum {
    val `lowest-price` = "lowest-price"
    val prioritized    = "prioritized"

    val values = js.Object.freeze(js.Array(`lowest-price`, prioritized))
  }

  object FleetStateCodeEnum {
    val submitted             = "submitted"
    val active                = "active"
    val deleted               = "deleted"
    val failed                = "failed"
    val `deleted-running`     = "deleted-running"
    val `deleted-terminating` = "deleted-terminating"
    val modifying             = "modifying"

    val values = js.Object.freeze(
      js.Array(submitted, active, deleted, failed, `deleted-running`, `deleted-terminating`, modifying)
    )
  }

  object FleetTypeEnum {
    val request  = "request"
    val maintain = "maintain"
    val instant  = "instant"

    val values = js.Object.freeze(js.Array(request, maintain, instant))
  }

  /**
    * Describes a flow log.
    */
  @js.native
  trait FlowLog extends js.Object {
    var CreationTime: js.UndefOr[DateTime]
    var DeliverLogsErrorMessage: js.UndefOr[String]
    var DeliverLogsPermissionArn: js.UndefOr[String]
    var DeliverLogsStatus: js.UndefOr[String]
    var FlowLogId: js.UndefOr[String]
    var FlowLogStatus: js.UndefOr[String]
    var LogDestination: js.UndefOr[String]
    var LogDestinationType: js.UndefOr[LogDestinationType]
    var LogGroupName: js.UndefOr[String]
    var ResourceId: js.UndefOr[String]
    var TrafficType: js.UndefOr[TrafficType]
  }

  object FlowLog {
    @inline
    def apply(
        CreationTime: js.UndefOr[DateTime] = js.undefined,
        DeliverLogsErrorMessage: js.UndefOr[String] = js.undefined,
        DeliverLogsPermissionArn: js.UndefOr[String] = js.undefined,
        DeliverLogsStatus: js.UndefOr[String] = js.undefined,
        FlowLogId: js.UndefOr[String] = js.undefined,
        FlowLogStatus: js.UndefOr[String] = js.undefined,
        LogDestination: js.UndefOr[String] = js.undefined,
        LogDestinationType: js.UndefOr[LogDestinationType] = js.undefined,
        LogGroupName: js.UndefOr[String] = js.undefined,
        ResourceId: js.UndefOr[String] = js.undefined,
        TrafficType: js.UndefOr[TrafficType] = js.undefined
    ): FlowLog = {
      val __obj = js.Dynamic.literal()
      CreationTime.foreach(__v => __obj.updateDynamic("CreationTime")(__v.asInstanceOf[js.Any]))
      DeliverLogsErrorMessage.foreach(__v => __obj.updateDynamic("DeliverLogsErrorMessage")(__v.asInstanceOf[js.Any]))
      DeliverLogsPermissionArn.foreach(__v => __obj.updateDynamic("DeliverLogsPermissionArn")(__v.asInstanceOf[js.Any]))
      DeliverLogsStatus.foreach(__v => __obj.updateDynamic("DeliverLogsStatus")(__v.asInstanceOf[js.Any]))
      FlowLogId.foreach(__v => __obj.updateDynamic("FlowLogId")(__v.asInstanceOf[js.Any]))
      FlowLogStatus.foreach(__v => __obj.updateDynamic("FlowLogStatus")(__v.asInstanceOf[js.Any]))
      LogDestination.foreach(__v => __obj.updateDynamic("LogDestination")(__v.asInstanceOf[js.Any]))
      LogDestinationType.foreach(__v => __obj.updateDynamic("LogDestinationType")(__v.asInstanceOf[js.Any]))
      LogGroupName.foreach(__v => __obj.updateDynamic("LogGroupName")(__v.asInstanceOf[js.Any]))
      ResourceId.foreach(__v => __obj.updateDynamic("ResourceId")(__v.asInstanceOf[js.Any]))
      TrafficType.foreach(__v => __obj.updateDynamic("TrafficType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[FlowLog]
    }
  }

  object FlowLogsResourceTypeEnum {
    val VPC              = "VPC"
    val Subnet           = "Subnet"
    val NetworkInterface = "NetworkInterface"

    val values = js.Object.freeze(js.Array(VPC, Subnet, NetworkInterface))
  }

  /**
    * Describes an Amazon FPGA image (AFI).
    */
  @js.native
  trait FpgaImage extends js.Object {
    var CreateTime: js.UndefOr[DateTime]
    var DataRetentionSupport: js.UndefOr[Boolean]
    var Description: js.UndefOr[String]
    var FpgaImageGlobalId: js.UndefOr[String]
    var FpgaImageId: js.UndefOr[String]
    var Name: js.UndefOr[String]
    var OwnerAlias: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var PciId: js.UndefOr[PciId]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var Public: js.UndefOr[Boolean]
    var ShellVersion: js.UndefOr[String]
    var State: js.UndefOr[FpgaImageState]
    var Tags: js.UndefOr[TagList]
    var UpdateTime: js.UndefOr[DateTime]
  }

  object FpgaImage {
    @inline
    def apply(
        CreateTime: js.UndefOr[DateTime] = js.undefined,
        DataRetentionSupport: js.UndefOr[Boolean] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        FpgaImageGlobalId: js.UndefOr[String] = js.undefined,
        FpgaImageId: js.UndefOr[String] = js.undefined,
        Name: js.UndefOr[String] = js.undefined,
        OwnerAlias: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        PciId: js.UndefOr[PciId] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        Public: js.UndefOr[Boolean] = js.undefined,
        ShellVersion: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[FpgaImageState] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        UpdateTime: js.UndefOr[DateTime] = js.undefined
    ): FpgaImage = {
      val __obj = js.Dynamic.literal()
      CreateTime.foreach(__v => __obj.updateDynamic("CreateTime")(__v.asInstanceOf[js.Any]))
      DataRetentionSupport.foreach(__v => __obj.updateDynamic("DataRetentionSupport")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      FpgaImageGlobalId.foreach(__v => __obj.updateDynamic("FpgaImageGlobalId")(__v.asInstanceOf[js.Any]))
      FpgaImageId.foreach(__v => __obj.updateDynamic("FpgaImageId")(__v.asInstanceOf[js.Any]))
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      OwnerAlias.foreach(__v => __obj.updateDynamic("OwnerAlias")(__v.asInstanceOf[js.Any]))
      OwnerId.foreach(__v => __obj.updateDynamic("OwnerId")(__v.asInstanceOf[js.Any]))
      PciId.foreach(__v => __obj.updateDynamic("PciId")(__v.asInstanceOf[js.Any]))
      ProductCodes.foreach(__v => __obj.updateDynamic("ProductCodes")(__v.asInstanceOf[js.Any]))
      Public.foreach(__v => __obj.updateDynamic("Public")(__v.asInstanceOf[js.Any]))
      ShellVersion.foreach(__v => __obj.updateDynamic("ShellVersion")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      UpdateTime.foreach(__v => __obj.updateDynamic("UpdateTime")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[FpgaImage]
    }
  }

  /**
    * Describes an Amazon FPGA image (AFI) attribute.
    */
  @js.native
  trait FpgaImageAttribute extends js.Object {
    var Description: js.UndefOr[String]
    var FpgaImageId: js.UndefOr[String]
    var LoadPermissions: js.UndefOr[LoadPermissionList]
    var Name: js.UndefOr[String]
    var ProductCodes: js.UndefOr[ProductCodeList]
  }

  object FpgaImageAttribute {
    @inline
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        FpgaImageId: js.UndefOr[String] = js.undefined,
        LoadPermissions: js.UndefOr[LoadPermissionList] = js.undefined,
        Name: js.UndefOr[String] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined
    ): FpgaImageAttribute = {
      val __obj = js.Dynamic.literal()
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      FpgaImageId.foreach(__v => __obj.updateDynamic("FpgaImageId")(__v.asInstanceOf[js.Any]))
      LoadPermissions.foreach(__v => __obj.updateDynamic("LoadPermissions")(__v.asInstanceOf[js.Any]))
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      ProductCodes.foreach(__v => __obj.updateDynamic("ProductCodes")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[FpgaImageAttribute]
    }
  }

  object FpgaImageAttributeNameEnum {
    val description    = "description"
    val name           = "name"
    val loadPermission = "loadPermission"
    val productCodes   = "productCodes"

    val values = js.Object.freeze(js.Array(description, name, loadPermission, productCodes))
  }

  /**
    * Describes the state of the bitstream generation process for an Amazon FPGA image (AFI).
    */
  @js.native
  trait FpgaImageState extends js.Object {
    var Code: js.UndefOr[FpgaImageStateCode]
    var Message: js.UndefOr[String]
  }

  object FpgaImageState {
    @inline
    def apply(
        Code: js.UndefOr[FpgaImageStateCode] = js.undefined,
        Message: js.UndefOr[String] = js.undefined
    ): FpgaImageState = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Message.foreach(__v => __obj.updateDynamic("Message")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[FpgaImageState]
    }
  }

  object FpgaImageStateCodeEnum {
    val pending     = "pending"
    val failed      = "failed"
    val available   = "available"
    val unavailable = "unavailable"

    val values = js.Object.freeze(js.Array(pending, failed, available, unavailable))
  }

  object GatewayTypeEnum {
    val `ipsec.1` = "ipsec.1"

    val values = js.Object.freeze(js.Array(`ipsec.1`))
  }

  @js.native
  trait GetCapacityReservationUsageRequest extends js.Object {
    var CapacityReservationId: String
    var DryRun: js.UndefOr[Boolean]
    var MaxResults: js.UndefOr[GetCapacityReservationUsageRequestMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object GetCapacityReservationUsageRequest {
    @inline
    def apply(
        CapacityReservationId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        MaxResults: js.UndefOr[GetCapacityReservationUsageRequestMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): GetCapacityReservationUsageRequest = {
      val __obj = js.Dynamic.literal(
        "CapacityReservationId" -> CapacityReservationId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetCapacityReservationUsageRequest]
    }
  }

  @js.native
  trait GetCapacityReservationUsageResult extends js.Object {
    var AvailableInstanceCount: js.UndefOr[Int]
    var CapacityReservationId: js.UndefOr[String]
    var InstanceType: js.UndefOr[String]
    var InstanceUsages: js.UndefOr[InstanceUsageSet]
    var NextToken: js.UndefOr[String]
    var State: js.UndefOr[CapacityReservationState]
    var TotalInstanceCount: js.UndefOr[Int]
  }

  object GetCapacityReservationUsageResult {
    @inline
    def apply(
        AvailableInstanceCount: js.UndefOr[Int] = js.undefined,
        CapacityReservationId: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[String] = js.undefined,
        InstanceUsages: js.UndefOr[InstanceUsageSet] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[CapacityReservationState] = js.undefined,
        TotalInstanceCount: js.UndefOr[Int] = js.undefined
    ): GetCapacityReservationUsageResult = {
      val __obj = js.Dynamic.literal()
      AvailableInstanceCount.foreach(__v => __obj.updateDynamic("AvailableInstanceCount")(__v.asInstanceOf[js.Any]))
      CapacityReservationId.foreach(__v => __obj.updateDynamic("CapacityReservationId")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      InstanceUsages.foreach(__v => __obj.updateDynamic("InstanceUsages")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      TotalInstanceCount.foreach(__v => __obj.updateDynamic("TotalInstanceCount")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetCapacityReservationUsageResult]
    }
  }

  @js.native
  trait GetConsoleOutputRequest extends js.Object {
    var InstanceId: String
    var DryRun: js.UndefOr[Boolean]
    var Latest: js.UndefOr[Boolean]
  }

  object GetConsoleOutputRequest {
    @inline
    def apply(
        InstanceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Latest: js.UndefOr[Boolean] = js.undefined
    ): GetConsoleOutputRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceId" -> InstanceId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Latest.foreach(__v => __obj.updateDynamic("Latest")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetConsoleOutputRequest]
    }
  }

  @js.native
  trait GetConsoleOutputResult extends js.Object {
    var InstanceId: js.UndefOr[String]
    var Output: js.UndefOr[String]
    var Timestamp: js.UndefOr[DateTime]
  }

  object GetConsoleOutputResult {
    @inline
    def apply(
        InstanceId: js.UndefOr[String] = js.undefined,
        Output: js.UndefOr[String] = js.undefined,
        Timestamp: js.UndefOr[DateTime] = js.undefined
    ): GetConsoleOutputResult = {
      val __obj = js.Dynamic.literal()
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      Output.foreach(__v => __obj.updateDynamic("Output")(__v.asInstanceOf[js.Any]))
      Timestamp.foreach(__v => __obj.updateDynamic("Timestamp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetConsoleOutputResult]
    }
  }

  @js.native
  trait GetConsoleScreenshotRequest extends js.Object {
    var InstanceId: String
    var DryRun: js.UndefOr[Boolean]
    var WakeUp: js.UndefOr[Boolean]
  }

  object GetConsoleScreenshotRequest {
    @inline
    def apply(
        InstanceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        WakeUp: js.UndefOr[Boolean] = js.undefined
    ): GetConsoleScreenshotRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceId" -> InstanceId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      WakeUp.foreach(__v => __obj.updateDynamic("WakeUp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetConsoleScreenshotRequest]
    }
  }

  @js.native
  trait GetConsoleScreenshotResult extends js.Object {
    var ImageData: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
  }

  object GetConsoleScreenshotResult {
    @inline
    def apply(
        ImageData: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): GetConsoleScreenshotResult = {
      val __obj = js.Dynamic.literal()
      ImageData.foreach(__v => __obj.updateDynamic("ImageData")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetConsoleScreenshotResult]
    }
  }

  @js.native
  trait GetEbsDefaultKmsKeyIdRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object GetEbsDefaultKmsKeyIdRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): GetEbsDefaultKmsKeyIdRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetEbsDefaultKmsKeyIdRequest]
    }
  }

  @js.native
  trait GetEbsDefaultKmsKeyIdResult extends js.Object {
    var KmsKeyId: js.UndefOr[String]
  }

  object GetEbsDefaultKmsKeyIdResult {
    @inline
    def apply(
        KmsKeyId: js.UndefOr[String] = js.undefined
    ): GetEbsDefaultKmsKeyIdResult = {
      val __obj = js.Dynamic.literal()
      KmsKeyId.foreach(__v => __obj.updateDynamic("KmsKeyId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetEbsDefaultKmsKeyIdResult]
    }
  }

  @js.native
  trait GetEbsEncryptionByDefaultRequest extends js.Object {
    var DryRun: js.UndefOr[Boolean]
  }

  object GetEbsEncryptionByDefaultRequest {
    @inline
    def apply(
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): GetEbsEncryptionByDefaultRequest = {
      val __obj = js.Dynamic.literal()
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetEbsEncryptionByDefaultRequest]
    }
  }

  @js.native
  trait GetEbsEncryptionByDefaultResult extends js.Object {
    var EbsEncryptionByDefault: js.UndefOr[Boolean]
  }

  object GetEbsEncryptionByDefaultResult {
    @inline
    def apply(
        EbsEncryptionByDefault: js.UndefOr[Boolean] = js.undefined
    ): GetEbsEncryptionByDefaultResult = {
      val __obj = js.Dynamic.literal()
      EbsEncryptionByDefault.foreach(__v => __obj.updateDynamic("EbsEncryptionByDefault")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetEbsEncryptionByDefaultResult]
    }
  }

  @js.native
  trait GetHostReservationPurchasePreviewRequest extends js.Object {
    var HostIdSet: RequestHostIdSet
    var OfferingId: String
  }

  object GetHostReservationPurchasePreviewRequest {
    @inline
    def apply(
        HostIdSet: RequestHostIdSet,
        OfferingId: String
    ): GetHostReservationPurchasePreviewRequest = {
      val __obj = js.Dynamic.literal(
        "HostIdSet"  -> HostIdSet.asInstanceOf[js.Any],
        "OfferingId" -> OfferingId.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[GetHostReservationPurchasePreviewRequest]
    }
  }

  @js.native
  trait GetHostReservationPurchasePreviewResult extends js.Object {
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var Purchase: js.UndefOr[PurchaseSet]
    var TotalHourlyPrice: js.UndefOr[String]
    var TotalUpfrontPrice: js.UndefOr[String]
  }

  object GetHostReservationPurchasePreviewResult {
    @inline
    def apply(
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        Purchase: js.UndefOr[PurchaseSet] = js.undefined,
        TotalHourlyPrice: js.UndefOr[String] = js.undefined,
        TotalUpfrontPrice: js.UndefOr[String] = js.undefined
    ): GetHostReservationPurchasePreviewResult = {
      val __obj = js.Dynamic.literal()
      CurrencyCode.foreach(__v => __obj.updateDynamic("CurrencyCode")(__v.asInstanceOf[js.Any]))
      Purchase.foreach(__v => __obj.updateDynamic("Purchase")(__v.asInstanceOf[js.Any]))
      TotalHourlyPrice.foreach(__v => __obj.updateDynamic("TotalHourlyPrice")(__v.asInstanceOf[js.Any]))
      TotalUpfrontPrice.foreach(__v => __obj.updateDynamic("TotalUpfrontPrice")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetHostReservationPurchasePreviewResult]
    }
  }

  @js.native
  trait GetLaunchTemplateDataRequest extends js.Object {
    var InstanceId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object GetLaunchTemplateDataRequest {
    @inline
    def apply(
        InstanceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): GetLaunchTemplateDataRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceId" -> InstanceId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetLaunchTemplateDataRequest]
    }
  }

  @js.native
  trait GetLaunchTemplateDataResult extends js.Object {
    var LaunchTemplateData: js.UndefOr[ResponseLaunchTemplateData]
  }

  object GetLaunchTemplateDataResult {
    @inline
    def apply(
        LaunchTemplateData: js.UndefOr[ResponseLaunchTemplateData] = js.undefined
    ): GetLaunchTemplateDataResult = {
      val __obj = js.Dynamic.literal()
      LaunchTemplateData.foreach(__v => __obj.updateDynamic("LaunchTemplateData")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetLaunchTemplateDataResult]
    }
  }

  @js.native
  trait GetPasswordDataRequest extends js.Object {
    var InstanceId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object GetPasswordDataRequest {
    @inline
    def apply(
        InstanceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): GetPasswordDataRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceId" -> InstanceId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetPasswordDataRequest]
    }
  }

  @js.native
  trait GetPasswordDataResult extends js.Object {
    var InstanceId: js.UndefOr[String]
    var PasswordData: js.UndefOr[String]
    var Timestamp: js.UndefOr[DateTime]
  }

  object GetPasswordDataResult {
    @inline
    def apply(
        InstanceId: js.UndefOr[String] = js.undefined,
        PasswordData: js.UndefOr[String] = js.undefined,
        Timestamp: js.UndefOr[DateTime] = js.undefined
    ): GetPasswordDataResult = {
      val __obj = js.Dynamic.literal()
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      PasswordData.foreach(__v => __obj.updateDynamic("PasswordData")(__v.asInstanceOf[js.Any]))
      Timestamp.foreach(__v => __obj.updateDynamic("Timestamp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetPasswordDataResult]
    }
  }

  /**
    * Contains the parameters for GetReservedInstanceExchangeQuote.
    */
  @js.native
  trait GetReservedInstancesExchangeQuoteRequest extends js.Object {
    var ReservedInstanceIds: ReservedInstanceIdSet
    var DryRun: js.UndefOr[Boolean]
    var TargetConfigurations: js.UndefOr[TargetConfigurationRequestSet]
  }

  object GetReservedInstancesExchangeQuoteRequest {
    @inline
    def apply(
        ReservedInstanceIds: ReservedInstanceIdSet,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TargetConfigurations: js.UndefOr[TargetConfigurationRequestSet] = js.undefined
    ): GetReservedInstancesExchangeQuoteRequest = {
      val __obj = js.Dynamic.literal(
        "ReservedInstanceIds" -> ReservedInstanceIds.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      TargetConfigurations.foreach(__v => __obj.updateDynamic("TargetConfigurations")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetReservedInstancesExchangeQuoteRequest]
    }
  }

  /**
    * Contains the output of GetReservedInstancesExchangeQuote.
    */
  @js.native
  trait GetReservedInstancesExchangeQuoteResult extends js.Object {
    var CurrencyCode: js.UndefOr[String]
    var IsValidExchange: js.UndefOr[Boolean]
    var OutputReservedInstancesWillExpireAt: js.UndefOr[DateTime]
    var PaymentDue: js.UndefOr[String]
    var ReservedInstanceValueRollup: js.UndefOr[ReservationValue]
    var ReservedInstanceValueSet: js.UndefOr[ReservedInstanceReservationValueSet]
    var TargetConfigurationValueRollup: js.UndefOr[ReservationValue]
    var TargetConfigurationValueSet: js.UndefOr[TargetReservationValueSet]
    var ValidationFailureReason: js.UndefOr[String]
  }

  object GetReservedInstancesExchangeQuoteResult {
    @inline
    def apply(
        CurrencyCode: js.UndefOr[String] = js.undefined,
        IsValidExchange: js.UndefOr[Boolean] = js.undefined,
        OutputReservedInstancesWillExpireAt: js.UndefOr[DateTime] = js.undefined,
        PaymentDue: js.UndefOr[String] = js.undefined,
        ReservedInstanceValueRollup: js.UndefOr[ReservationValue] = js.undefined,
        ReservedInstanceValueSet: js.UndefOr[ReservedInstanceReservationValueSet] = js.undefined,
        TargetConfigurationValueRollup: js.UndefOr[ReservationValue] = js.undefined,
        TargetConfigurationValueSet: js.UndefOr[TargetReservationValueSet] = js.undefined,
        ValidationFailureReason: js.UndefOr[String] = js.undefined
    ): GetReservedInstancesExchangeQuoteResult = {
      val __obj = js.Dynamic.literal()
      CurrencyCode.foreach(__v => __obj.updateDynamic("CurrencyCode")(__v.asInstanceOf[js.Any]))
      IsValidExchange.foreach(__v => __obj.updateDynamic("IsValidExchange")(__v.asInstanceOf[js.Any]))
      OutputReservedInstancesWillExpireAt.foreach(
        __v => __obj.updateDynamic("OutputReservedInstancesWillExpireAt")(__v.asInstanceOf[js.Any])
      )
      PaymentDue.foreach(__v => __obj.updateDynamic("PaymentDue")(__v.asInstanceOf[js.Any]))
      ReservedInstanceValueRollup.foreach(
        __v => __obj.updateDynamic("ReservedInstanceValueRollup")(__v.asInstanceOf[js.Any])
      )
      ReservedInstanceValueSet.foreach(__v => __obj.updateDynamic("ReservedInstanceValueSet")(__v.asInstanceOf[js.Any]))
      TargetConfigurationValueRollup.foreach(
        __v => __obj.updateDynamic("TargetConfigurationValueRollup")(__v.asInstanceOf[js.Any])
      )
      TargetConfigurationValueSet.foreach(
        __v => __obj.updateDynamic("TargetConfigurationValueSet")(__v.asInstanceOf[js.Any])
      )
      ValidationFailureReason.foreach(__v => __obj.updateDynamic("ValidationFailureReason")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetReservedInstancesExchangeQuoteResult]
    }
  }

  @js.native
  trait GetTransitGatewayAttachmentPropagationsRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object GetTransitGatewayAttachmentPropagationsRequest {
    @inline
    def apply(
        TransitGatewayAttachmentId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): GetTransitGatewayAttachmentPropagationsRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetTransitGatewayAttachmentPropagationsRequest]
    }
  }

  @js.native
  trait GetTransitGatewayAttachmentPropagationsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TransitGatewayAttachmentPropagations: js.UndefOr[TransitGatewayAttachmentPropagationList]
  }

  object GetTransitGatewayAttachmentPropagationsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayAttachmentPropagations: js.UndefOr[TransitGatewayAttachmentPropagationList] = js.undefined
    ): GetTransitGatewayAttachmentPropagationsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TransitGatewayAttachmentPropagations.foreach(
        __v => __obj.updateDynamic("TransitGatewayAttachmentPropagations")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[GetTransitGatewayAttachmentPropagationsResult]
    }
  }

  @js.native
  trait GetTransitGatewayRouteTableAssociationsRequest extends js.Object {
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object GetTransitGatewayRouteTableAssociationsRequest {
    @inline
    def apply(
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): GetTransitGatewayRouteTableAssociationsRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetTransitGatewayRouteTableAssociationsRequest]
    }
  }

  @js.native
  trait GetTransitGatewayRouteTableAssociationsResult extends js.Object {
    var Associations: js.UndefOr[TransitGatewayRouteTableAssociationList]
    var NextToken: js.UndefOr[String]
  }

  object GetTransitGatewayRouteTableAssociationsResult {
    @inline
    def apply(
        Associations: js.UndefOr[TransitGatewayRouteTableAssociationList] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): GetTransitGatewayRouteTableAssociationsResult = {
      val __obj = js.Dynamic.literal()
      Associations.foreach(__v => __obj.updateDynamic("Associations")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetTransitGatewayRouteTableAssociationsResult]
    }
  }

  @js.native
  trait GetTransitGatewayRouteTablePropagationsRequest extends js.Object {
    var TransitGatewayRouteTableId: String
    var DryRun: js.UndefOr[Boolean]
    var Filters: js.UndefOr[FilterList]
    var MaxResults: js.UndefOr[TransitGatewayMaxResults]
    var NextToken: js.UndefOr[String]
  }

  object GetTransitGatewayRouteTablePropagationsRequest {
    @inline
    def apply(
        TransitGatewayRouteTableId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Filters: js.UndefOr[FilterList] = js.undefined,
        MaxResults: js.UndefOr[TransitGatewayMaxResults] = js.undefined,
        NextToken: js.UndefOr[String] = js.undefined
    ): GetTransitGatewayRouteTablePropagationsRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayRouteTableId" -> TransitGatewayRouteTableId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Filters.foreach(__v => __obj.updateDynamic("Filters")(__v.asInstanceOf[js.Any]))
      MaxResults.foreach(__v => __obj.updateDynamic("MaxResults")(__v.asInstanceOf[js.Any]))
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GetTransitGatewayRouteTablePropagationsRequest]
    }
  }

  @js.native
  trait GetTransitGatewayRouteTablePropagationsResult extends js.Object {
    var NextToken: js.UndefOr[String]
    var TransitGatewayRouteTablePropagations: js.UndefOr[TransitGatewayRouteTablePropagationList]
  }

  object GetTransitGatewayRouteTablePropagationsResult {
    @inline
    def apply(
        NextToken: js.UndefOr[String] = js.undefined,
        TransitGatewayRouteTablePropagations: js.UndefOr[TransitGatewayRouteTablePropagationList] = js.undefined
    ): GetTransitGatewayRouteTablePropagationsResult = {
      val __obj = js.Dynamic.literal()
      NextToken.foreach(__v => __obj.updateDynamic("NextToken")(__v.asInstanceOf[js.Any]))
      TransitGatewayRouteTablePropagations.foreach(
        __v => __obj.updateDynamic("TransitGatewayRouteTablePropagations")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[GetTransitGatewayRouteTablePropagationsResult]
    }
  }

  /**
    * Describes a security group.
    */
  @js.native
  trait GroupIdentifier extends js.Object {
    var GroupId: js.UndefOr[String]
    var GroupName: js.UndefOr[String]
  }

  object GroupIdentifier {
    @inline
    def apply(
        GroupId: js.UndefOr[String] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined
    ): GroupIdentifier = {
      val __obj = js.Dynamic.literal()
      GroupId.foreach(__v => __obj.updateDynamic("GroupId")(__v.asInstanceOf[js.Any]))
      GroupName.foreach(__v => __obj.updateDynamic("GroupName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[GroupIdentifier]
    }
  }

  /**
    * Indicates whether your instance is configured for hibernation. This parameter is valid only if the instance meets the [[https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites|hibernation prerequisites]]. Hibernation is currently supported only for Amazon Linux. For more information, see [[https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html|Hibernate Your Instance]] in the <i>Amazon Elastic Compute Cloud User Guide</i>.
    */
  @js.native
  trait HibernationOptions extends js.Object {
    var Configured: js.UndefOr[Boolean]
  }

  object HibernationOptions {
    @inline
    def apply(
        Configured: js.UndefOr[Boolean] = js.undefined
    ): HibernationOptions = {
      val __obj = js.Dynamic.literal()
      Configured.foreach(__v => __obj.updateDynamic("Configured")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[HibernationOptions]
    }
  }

  /**
    * Indicates whether your instance is configured for hibernation. This parameter is valid only if the instance meets the [[https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites|hibernation prerequisites]]. Hibernation is currently supported only for Amazon Linux. For more information, see [[https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html|Hibernate Your Instance]] in the <i>Amazon Elastic Compute Cloud User Guide</i>.
    */
  @js.native
  trait HibernationOptionsRequest extends js.Object {
    var Configured: js.UndefOr[Boolean]
  }

  object HibernationOptionsRequest {
    @inline
    def apply(
        Configured: js.UndefOr[Boolean] = js.undefined
    ): HibernationOptionsRequest = {
      val __obj = js.Dynamic.literal()
      Configured.foreach(__v => __obj.updateDynamic("Configured")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[HibernationOptionsRequest]
    }
  }

  /**
    * Describes an event in the history of the Spot Fleet request.
    */
  @js.native
  trait HistoryRecord extends js.Object {
    var EventInformation: js.UndefOr[EventInformation]
    var EventType: js.UndefOr[EventType]
    var Timestamp: js.UndefOr[DateTime]
  }

  object HistoryRecord {
    @inline
    def apply(
        EventInformation: js.UndefOr[EventInformation] = js.undefined,
        EventType: js.UndefOr[EventType] = js.undefined,
        Timestamp: js.UndefOr[DateTime] = js.undefined
    ): HistoryRecord = {
      val __obj = js.Dynamic.literal()
      EventInformation.foreach(__v => __obj.updateDynamic("EventInformation")(__v.asInstanceOf[js.Any]))
      EventType.foreach(__v => __obj.updateDynamic("EventType")(__v.asInstanceOf[js.Any]))
      Timestamp.foreach(__v => __obj.updateDynamic("Timestamp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[HistoryRecord]
    }
  }

  /**
    * Describes an event in the history of an EC2 Fleet.
    */
  @js.native
  trait HistoryRecordEntry extends js.Object {
    var EventInformation: js.UndefOr[EventInformation]
    var EventType: js.UndefOr[FleetEventType]
    var Timestamp: js.UndefOr[DateTime]
  }

  object HistoryRecordEntry {
    @inline
    def apply(
        EventInformation: js.UndefOr[EventInformation] = js.undefined,
        EventType: js.UndefOr[FleetEventType] = js.undefined,
        Timestamp: js.UndefOr[DateTime] = js.undefined
    ): HistoryRecordEntry = {
      val __obj = js.Dynamic.literal()
      EventInformation.foreach(__v => __obj.updateDynamic("EventInformation")(__v.asInstanceOf[js.Any]))
      EventType.foreach(__v => __obj.updateDynamic("EventType")(__v.asInstanceOf[js.Any]))
      Timestamp.foreach(__v => __obj.updateDynamic("Timestamp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[HistoryRecordEntry]
    }
  }

  /**
    * Describes the properties of the Dedicated Host.
    */
  @js.native
  trait Host extends js.Object {
    var AllocationTime: js.UndefOr[DateTime]
    var AutoPlacement: js.UndefOr[AutoPlacement]
    var AvailabilityZone: js.UndefOr[String]
    var AvailableCapacity: js.UndefOr[AvailableCapacity]
    var ClientToken: js.UndefOr[String]
    var HostId: js.UndefOr[String]
    var HostProperties: js.UndefOr[HostProperties]
    var HostRecovery: js.UndefOr[HostRecovery]
    var HostReservationId: js.UndefOr[String]
    var Instances: js.UndefOr[HostInstanceList]
    var ReleaseTime: js.UndefOr[DateTime]
    var State: js.UndefOr[AllocationState]
    var Tags: js.UndefOr[TagList]
  }

  object Host {
    @inline
    def apply(
        AllocationTime: js.UndefOr[DateTime] = js.undefined,
        AutoPlacement: js.UndefOr[AutoPlacement] = js.undefined,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        AvailableCapacity: js.UndefOr[AvailableCapacity] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        HostId: js.UndefOr[String] = js.undefined,
        HostProperties: js.UndefOr[HostProperties] = js.undefined,
        HostRecovery: js.UndefOr[HostRecovery] = js.undefined,
        HostReservationId: js.UndefOr[String] = js.undefined,
        Instances: js.UndefOr[HostInstanceList] = js.undefined,
        ReleaseTime: js.UndefOr[DateTime] = js.undefined,
        State: js.UndefOr[AllocationState] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): Host = {
      val __obj = js.Dynamic.literal()
      AllocationTime.foreach(__v => __obj.updateDynamic("AllocationTime")(__v.asInstanceOf[js.Any]))
      AutoPlacement.foreach(__v => __obj.updateDynamic("AutoPlacement")(__v.asInstanceOf[js.Any]))
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      AvailableCapacity.foreach(__v => __obj.updateDynamic("AvailableCapacity")(__v.asInstanceOf[js.Any]))
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      HostId.foreach(__v => __obj.updateDynamic("HostId")(__v.asInstanceOf[js.Any]))
      HostProperties.foreach(__v => __obj.updateDynamic("HostProperties")(__v.asInstanceOf[js.Any]))
      HostRecovery.foreach(__v => __obj.updateDynamic("HostRecovery")(__v.asInstanceOf[js.Any]))
      HostReservationId.foreach(__v => __obj.updateDynamic("HostReservationId")(__v.asInstanceOf[js.Any]))
      Instances.foreach(__v => __obj.updateDynamic("Instances")(__v.asInstanceOf[js.Any]))
      ReleaseTime.foreach(__v => __obj.updateDynamic("ReleaseTime")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[Host]
    }
  }

  /**
    * Describes an instance running on a Dedicated Host.
    */
  @js.native
  trait HostInstance extends js.Object {
    var InstanceId: js.UndefOr[String]
    var InstanceType: js.UndefOr[String]
  }

  object HostInstance {
    @inline
    def apply(
        InstanceId: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[String] = js.undefined
    ): HostInstance = {
      val __obj = js.Dynamic.literal()
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[HostInstance]
    }
  }

  /**
    * Details about the Dedicated Host Reservation offering.
    */
  @js.native
  trait HostOffering extends js.Object {
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var Duration: js.UndefOr[Int]
    var HourlyPrice: js.UndefOr[String]
    var InstanceFamily: js.UndefOr[String]
    var OfferingId: js.UndefOr[String]
    var PaymentOption: js.UndefOr[PaymentOption]
    var UpfrontPrice: js.UndefOr[String]
  }

  object HostOffering {
    @inline
    def apply(
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        Duration: js.UndefOr[Int] = js.undefined,
        HourlyPrice: js.UndefOr[String] = js.undefined,
        InstanceFamily: js.UndefOr[String] = js.undefined,
        OfferingId: js.UndefOr[String] = js.undefined,
        PaymentOption: js.UndefOr[PaymentOption] = js.undefined,
        UpfrontPrice: js.UndefOr[String] = js.undefined
    ): HostOffering = {
      val __obj = js.Dynamic.literal()
      CurrencyCode.foreach(__v => __obj.updateDynamic("CurrencyCode")(__v.asInstanceOf[js.Any]))
      Duration.foreach(__v => __obj.updateDynamic("Duration")(__v.asInstanceOf[js.Any]))
      HourlyPrice.foreach(__v => __obj.updateDynamic("HourlyPrice")(__v.asInstanceOf[js.Any]))
      InstanceFamily.foreach(__v => __obj.updateDynamic("InstanceFamily")(__v.asInstanceOf[js.Any]))
      OfferingId.foreach(__v => __obj.updateDynamic("OfferingId")(__v.asInstanceOf[js.Any]))
      PaymentOption.foreach(__v => __obj.updateDynamic("PaymentOption")(__v.asInstanceOf[js.Any]))
      UpfrontPrice.foreach(__v => __obj.updateDynamic("UpfrontPrice")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[HostOffering]
    }
  }

  /**
    * Describes properties of a Dedicated Host.
    */
  @js.native
  trait HostProperties extends js.Object {
    var Cores: js.UndefOr[Int]
    var InstanceType: js.UndefOr[String]
    var Sockets: js.UndefOr[Int]
    var TotalVCpus: js.UndefOr[Int]
  }

  object HostProperties {
    @inline
    def apply(
        Cores: js.UndefOr[Int] = js.undefined,
        InstanceType: js.UndefOr[String] = js.undefined,
        Sockets: js.UndefOr[Int] = js.undefined,
        TotalVCpus: js.UndefOr[Int] = js.undefined
    ): HostProperties = {
      val __obj = js.Dynamic.literal()
      Cores.foreach(__v => __obj.updateDynamic("Cores")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      Sockets.foreach(__v => __obj.updateDynamic("Sockets")(__v.asInstanceOf[js.Any]))
      TotalVCpus.foreach(__v => __obj.updateDynamic("TotalVCpus")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[HostProperties]
    }
  }

  object HostRecoveryEnum {
    val on  = "on"
    val off = "off"

    val values = js.Object.freeze(js.Array(on, off))
  }

  /**
    * Details about the Dedicated Host Reservation and associated Dedicated Hosts.
    */
  @js.native
  trait HostReservation extends js.Object {
    var Count: js.UndefOr[Int]
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var Duration: js.UndefOr[Int]
    var End: js.UndefOr[DateTime]
    var HostIdSet: js.UndefOr[ResponseHostIdSet]
    var HostReservationId: js.UndefOr[String]
    var HourlyPrice: js.UndefOr[String]
    var InstanceFamily: js.UndefOr[String]
    var OfferingId: js.UndefOr[String]
    var PaymentOption: js.UndefOr[PaymentOption]
    var Start: js.UndefOr[DateTime]
    var State: js.UndefOr[ReservationState]
    var Tags: js.UndefOr[TagList]
    var UpfrontPrice: js.UndefOr[String]
  }

  object HostReservation {
    @inline
    def apply(
        Count: js.UndefOr[Int] = js.undefined,
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        Duration: js.UndefOr[Int] = js.undefined,
        End: js.UndefOr[DateTime] = js.undefined,
        HostIdSet: js.UndefOr[ResponseHostIdSet] = js.undefined,
        HostReservationId: js.UndefOr[String] = js.undefined,
        HourlyPrice: js.UndefOr[String] = js.undefined,
        InstanceFamily: js.UndefOr[String] = js.undefined,
        OfferingId: js.UndefOr[String] = js.undefined,
        PaymentOption: js.UndefOr[PaymentOption] = js.undefined,
        Start: js.UndefOr[DateTime] = js.undefined,
        State: js.UndefOr[ReservationState] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        UpfrontPrice: js.UndefOr[String] = js.undefined
    ): HostReservation = {
      val __obj = js.Dynamic.literal()
      Count.foreach(__v => __obj.updateDynamic("Count")(__v.asInstanceOf[js.Any]))
      CurrencyCode.foreach(__v => __obj.updateDynamic("CurrencyCode")(__v.asInstanceOf[js.Any]))
      Duration.foreach(__v => __obj.updateDynamic("Duration")(__v.asInstanceOf[js.Any]))
      End.foreach(__v => __obj.updateDynamic("End")(__v.asInstanceOf[js.Any]))
      HostIdSet.foreach(__v => __obj.updateDynamic("HostIdSet")(__v.asInstanceOf[js.Any]))
      HostReservationId.foreach(__v => __obj.updateDynamic("HostReservationId")(__v.asInstanceOf[js.Any]))
      HourlyPrice.foreach(__v => __obj.updateDynamic("HourlyPrice")(__v.asInstanceOf[js.Any]))
      InstanceFamily.foreach(__v => __obj.updateDynamic("InstanceFamily")(__v.asInstanceOf[js.Any]))
      OfferingId.foreach(__v => __obj.updateDynamic("OfferingId")(__v.asInstanceOf[js.Any]))
      PaymentOption.foreach(__v => __obj.updateDynamic("PaymentOption")(__v.asInstanceOf[js.Any]))
      Start.foreach(__v => __obj.updateDynamic("Start")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      UpfrontPrice.foreach(__v => __obj.updateDynamic("UpfrontPrice")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[HostReservation]
    }
  }

  object HostTenancyEnum {
    val dedicated = "dedicated"
    val host      = "host"

    val values = js.Object.freeze(js.Array(dedicated, host))
  }

  object HypervisorTypeEnum {
    val ovm = "ovm"
    val xen = "xen"

    val values = js.Object.freeze(js.Array(ovm, xen))
  }

  /**
    * Describes an IAM instance profile.
    */
  @js.native
  trait IamInstanceProfile extends js.Object {
    var Arn: js.UndefOr[String]
    var Id: js.UndefOr[String]
  }

  object IamInstanceProfile {
    @inline
    def apply(
        Arn: js.UndefOr[String] = js.undefined,
        Id: js.UndefOr[String] = js.undefined
    ): IamInstanceProfile = {
      val __obj = js.Dynamic.literal()
      Arn.foreach(__v => __obj.updateDynamic("Arn")(__v.asInstanceOf[js.Any]))
      Id.foreach(__v => __obj.updateDynamic("Id")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[IamInstanceProfile]
    }
  }

  /**
    * Describes an association between an IAM instance profile and an instance.
    */
  @js.native
  trait IamInstanceProfileAssociation extends js.Object {
    var AssociationId: js.UndefOr[String]
    var IamInstanceProfile: js.UndefOr[IamInstanceProfile]
    var InstanceId: js.UndefOr[String]
    var State: js.UndefOr[IamInstanceProfileAssociationState]
    var Timestamp: js.UndefOr[DateTime]
  }

  object IamInstanceProfileAssociation {
    @inline
    def apply(
        AssociationId: js.UndefOr[String] = js.undefined,
        IamInstanceProfile: js.UndefOr[IamInstanceProfile] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[IamInstanceProfileAssociationState] = js.undefined,
        Timestamp: js.UndefOr[DateTime] = js.undefined
    ): IamInstanceProfileAssociation = {
      val __obj = js.Dynamic.literal()
      AssociationId.foreach(__v => __obj.updateDynamic("AssociationId")(__v.asInstanceOf[js.Any]))
      IamInstanceProfile.foreach(__v => __obj.updateDynamic("IamInstanceProfile")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      Timestamp.foreach(__v => __obj.updateDynamic("Timestamp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[IamInstanceProfileAssociation]
    }
  }

  object IamInstanceProfileAssociationStateEnum {
    val associating    = "associating"
    val associated     = "associated"
    val disassociating = "disassociating"
    val disassociated  = "disassociated"

    val values = js.Object.freeze(js.Array(associating, associated, disassociating, disassociated))
  }

  /**
    * Describes an IAM instance profile.
    */
  @js.native
  trait IamInstanceProfileSpecification extends js.Object {
    var Arn: js.UndefOr[String]
    var Name: js.UndefOr[String]
  }

  object IamInstanceProfileSpecification {
    @inline
    def apply(
        Arn: js.UndefOr[String] = js.undefined,
        Name: js.UndefOr[String] = js.undefined
    ): IamInstanceProfileSpecification = {
      val __obj = js.Dynamic.literal()
      Arn.foreach(__v => __obj.updateDynamic("Arn")(__v.asInstanceOf[js.Any]))
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[IamInstanceProfileSpecification]
    }
  }

  /**
    * Describes the ICMP type and code.
    */
  @js.native
  trait IcmpTypeCode extends js.Object {
    var Code: js.UndefOr[Int]
    var Type: js.UndefOr[Int]
  }

  object IcmpTypeCode {
    @inline
    def apply(
        Code: js.UndefOr[Int] = js.undefined,
        Type: js.UndefOr[Int] = js.undefined
    ): IcmpTypeCode = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Type.foreach(__v => __obj.updateDynamic("Type")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[IcmpTypeCode]
    }
  }

  /**
    * Describes the ID format for a resource.
    */
  @js.native
  trait IdFormat extends js.Object {
    var Deadline: js.UndefOr[DateTime]
    var Resource: js.UndefOr[String]
    var UseLongIds: js.UndefOr[Boolean]
  }

  object IdFormat {
    @inline
    def apply(
        Deadline: js.UndefOr[DateTime] = js.undefined,
        Resource: js.UndefOr[String] = js.undefined,
        UseLongIds: js.UndefOr[Boolean] = js.undefined
    ): IdFormat = {
      val __obj = js.Dynamic.literal()
      Deadline.foreach(__v => __obj.updateDynamic("Deadline")(__v.asInstanceOf[js.Any]))
      Resource.foreach(__v => __obj.updateDynamic("Resource")(__v.asInstanceOf[js.Any]))
      UseLongIds.foreach(__v => __obj.updateDynamic("UseLongIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[IdFormat]
    }
  }

  /**
    * Describes an image.
    */
  @js.native
  trait Image extends js.Object {
    var Architecture: js.UndefOr[ArchitectureValues]
    var BlockDeviceMappings: js.UndefOr[BlockDeviceMappingList]
    var CreationDate: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var EnaSupport: js.UndefOr[Boolean]
    var Hypervisor: js.UndefOr[HypervisorType]
    var ImageId: js.UndefOr[String]
    var ImageLocation: js.UndefOr[String]
    var ImageOwnerAlias: js.UndefOr[String]
    var ImageType: js.UndefOr[ImageTypeValues]
    var KernelId: js.UndefOr[String]
    var Name: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var Platform: js.UndefOr[PlatformValues]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var Public: js.UndefOr[Boolean]
    var RamdiskId: js.UndefOr[String]
    var RootDeviceName: js.UndefOr[String]
    var RootDeviceType: js.UndefOr[DeviceType]
    var SriovNetSupport: js.UndefOr[String]
    var State: js.UndefOr[ImageState]
    var StateReason: js.UndefOr[StateReason]
    var Tags: js.UndefOr[TagList]
    var VirtualizationType: js.UndefOr[VirtualizationType]
  }

  object Image {
    @inline
    def apply(
        Architecture: js.UndefOr[ArchitectureValues] = js.undefined,
        BlockDeviceMappings: js.UndefOr[BlockDeviceMappingList] = js.undefined,
        CreationDate: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        EnaSupport: js.UndefOr[Boolean] = js.undefined,
        Hypervisor: js.UndefOr[HypervisorType] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        ImageLocation: js.UndefOr[String] = js.undefined,
        ImageOwnerAlias: js.UndefOr[String] = js.undefined,
        ImageType: js.UndefOr[ImageTypeValues] = js.undefined,
        KernelId: js.UndefOr[String] = js.undefined,
        Name: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        Platform: js.UndefOr[PlatformValues] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        Public: js.UndefOr[Boolean] = js.undefined,
        RamdiskId: js.UndefOr[String] = js.undefined,
        RootDeviceName: js.UndefOr[String] = js.undefined,
        RootDeviceType: js.UndefOr[DeviceType] = js.undefined,
        SriovNetSupport: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[ImageState] = js.undefined,
        StateReason: js.UndefOr[StateReason] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        VirtualizationType: js.UndefOr[VirtualizationType] = js.undefined
    ): Image = {
      val __obj = js.Dynamic.literal()
      Architecture.foreach(__v => __obj.updateDynamic("Architecture")(__v.asInstanceOf[js.Any]))
      BlockDeviceMappings.foreach(__v => __obj.updateDynamic("BlockDeviceMappings")(__v.asInstanceOf[js.Any]))
      CreationDate.foreach(__v => __obj.updateDynamic("CreationDate")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      EnaSupport.foreach(__v => __obj.updateDynamic("EnaSupport")(__v.asInstanceOf[js.Any]))
      Hypervisor.foreach(__v => __obj.updateDynamic("Hypervisor")(__v.asInstanceOf[js.Any]))
      ImageId.foreach(__v => __obj.updateDynamic("ImageId")(__v.asInstanceOf[js.Any]))
      ImageLocation.foreach(__v => __obj.updateDynamic("ImageLocation")(__v.asInstanceOf[js.Any]))
      ImageOwnerAlias.foreach(__v => __obj.updateDynamic("ImageOwnerAlias")(__v.asInstanceOf[js.Any]))
      ImageType.foreach(__v => __obj.updateDynamic("ImageType")(__v.asInstanceOf[js.Any]))
      KernelId.foreach(__v => __obj.updateDynamic("KernelId")(__v.asInstanceOf[js.Any]))
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      OwnerId.foreach(__v => __obj.updateDynamic("OwnerId")(__v.asInstanceOf[js.Any]))
      Platform.foreach(__v => __obj.updateDynamic("Platform")(__v.asInstanceOf[js.Any]))
      ProductCodes.foreach(__v => __obj.updateDynamic("ProductCodes")(__v.asInstanceOf[js.Any]))
      Public.foreach(__v => __obj.updateDynamic("Public")(__v.asInstanceOf[js.Any]))
      RamdiskId.foreach(__v => __obj.updateDynamic("RamdiskId")(__v.asInstanceOf[js.Any]))
      RootDeviceName.foreach(__v => __obj.updateDynamic("RootDeviceName")(__v.asInstanceOf[js.Any]))
      RootDeviceType.foreach(__v => __obj.updateDynamic("RootDeviceType")(__v.asInstanceOf[js.Any]))
      SriovNetSupport.foreach(__v => __obj.updateDynamic("SriovNetSupport")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      StateReason.foreach(__v => __obj.updateDynamic("StateReason")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      VirtualizationType.foreach(__v => __obj.updateDynamic("VirtualizationType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[Image]
    }
  }

  /**
    * Describes an image attribute.
    */
  @js.native
  trait ImageAttribute extends js.Object {
    var BlockDeviceMappings: js.UndefOr[BlockDeviceMappingList]
    var Description: js.UndefOr[AttributeValue]
    var ImageId: js.UndefOr[String]
    var KernelId: js.UndefOr[AttributeValue]
    var LaunchPermissions: js.UndefOr[LaunchPermissionList]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var RamdiskId: js.UndefOr[AttributeValue]
    var SriovNetSupport: js.UndefOr[AttributeValue]
  }

  object ImageAttribute {
    @inline
    def apply(
        BlockDeviceMappings: js.UndefOr[BlockDeviceMappingList] = js.undefined,
        Description: js.UndefOr[AttributeValue] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        KernelId: js.UndefOr[AttributeValue] = js.undefined,
        LaunchPermissions: js.UndefOr[LaunchPermissionList] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        RamdiskId: js.UndefOr[AttributeValue] = js.undefined,
        SriovNetSupport: js.UndefOr[AttributeValue] = js.undefined
    ): ImageAttribute = {
      val __obj = js.Dynamic.literal()
      BlockDeviceMappings.foreach(__v => __obj.updateDynamic("BlockDeviceMappings")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      ImageId.foreach(__v => __obj.updateDynamic("ImageId")(__v.asInstanceOf[js.Any]))
      KernelId.foreach(__v => __obj.updateDynamic("KernelId")(__v.asInstanceOf[js.Any]))
      LaunchPermissions.foreach(__v => __obj.updateDynamic("LaunchPermissions")(__v.asInstanceOf[js.Any]))
      ProductCodes.foreach(__v => __obj.updateDynamic("ProductCodes")(__v.asInstanceOf[js.Any]))
      RamdiskId.foreach(__v => __obj.updateDynamic("RamdiskId")(__v.asInstanceOf[js.Any]))
      SriovNetSupport.foreach(__v => __obj.updateDynamic("SriovNetSupport")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImageAttribute]
    }
  }

  object ImageAttributeNameEnum {
    val description        = "description"
    val kernel             = "kernel"
    val ramdisk            = "ramdisk"
    val launchPermission   = "launchPermission"
    val productCodes       = "productCodes"
    val blockDeviceMapping = "blockDeviceMapping"
    val sriovNetSupport    = "sriovNetSupport"

    val values = js.Object.freeze(
      js.Array(description, kernel, ramdisk, launchPermission, productCodes, blockDeviceMapping, sriovNetSupport)
    )
  }

  /**
    * Describes the disk container object for an import image task.
    */
  @js.native
  trait ImageDiskContainer extends js.Object {
    var Description: js.UndefOr[String]
    var DeviceName: js.UndefOr[String]
    var Format: js.UndefOr[String]
    var SnapshotId: js.UndefOr[String]
    var Url: js.UndefOr[String]
    var UserBucket: js.UndefOr[UserBucket]
  }

  object ImageDiskContainer {
    @inline
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        DeviceName: js.UndefOr[String] = js.undefined,
        Format: js.UndefOr[String] = js.undefined,
        SnapshotId: js.UndefOr[String] = js.undefined,
        Url: js.UndefOr[String] = js.undefined,
        UserBucket: js.UndefOr[UserBucket] = js.undefined
    ): ImageDiskContainer = {
      val __obj = js.Dynamic.literal()
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DeviceName.foreach(__v => __obj.updateDynamic("DeviceName")(__v.asInstanceOf[js.Any]))
      Format.foreach(__v => __obj.updateDynamic("Format")(__v.asInstanceOf[js.Any]))
      SnapshotId.foreach(__v => __obj.updateDynamic("SnapshotId")(__v.asInstanceOf[js.Any]))
      Url.foreach(__v => __obj.updateDynamic("Url")(__v.asInstanceOf[js.Any]))
      UserBucket.foreach(__v => __obj.updateDynamic("UserBucket")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImageDiskContainer]
    }
  }

  object ImageStateEnum {
    val pending      = "pending"
    val available    = "available"
    val invalid      = "invalid"
    val deregistered = "deregistered"
    val transient    = "transient"
    val failed       = "failed"
    val error        = "error"

    val values = js.Object.freeze(js.Array(pending, available, invalid, deregistered, transient, failed, error))
  }

  object ImageTypeValuesEnum {
    val machine = "machine"
    val kernel  = "kernel"
    val ramdisk = "ramdisk"

    val values = js.Object.freeze(js.Array(machine, kernel, ramdisk))
  }

  @js.native
  trait ImportClientVpnClientCertificateRevocationListRequest extends js.Object {
    var CertificateRevocationList: String
    var ClientVpnEndpointId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ImportClientVpnClientCertificateRevocationListRequest {
    @inline
    def apply(
        CertificateRevocationList: String,
        ClientVpnEndpointId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ImportClientVpnClientCertificateRevocationListRequest = {
      val __obj = js.Dynamic.literal(
        "CertificateRevocationList" -> CertificateRevocationList.asInstanceOf[js.Any],
        "ClientVpnEndpointId"       -> ClientVpnEndpointId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportClientVpnClientCertificateRevocationListRequest]
    }
  }

  @js.native
  trait ImportClientVpnClientCertificateRevocationListResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ImportClientVpnClientCertificateRevocationListResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ImportClientVpnClientCertificateRevocationListResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportClientVpnClientCertificateRevocationListResult]
    }
  }

  @js.native
  trait ImportImageRequest extends js.Object {
    var Architecture: js.UndefOr[String]
    var ClientData: js.UndefOr[ClientData]
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DiskContainers: js.UndefOr[ImageDiskContainerList]
    var DryRun: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var Hypervisor: js.UndefOr[String]
    var KmsKeyId: js.UndefOr[String]
    var LicenseType: js.UndefOr[String]
    var Platform: js.UndefOr[String]
    var RoleName: js.UndefOr[String]
  }

  object ImportImageRequest {
    @inline
    def apply(
        Architecture: js.UndefOr[String] = js.undefined,
        ClientData: js.UndefOr[ClientData] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DiskContainers: js.UndefOr[ImageDiskContainerList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Hypervisor: js.UndefOr[String] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        LicenseType: js.UndefOr[String] = js.undefined,
        Platform: js.UndefOr[String] = js.undefined,
        RoleName: js.UndefOr[String] = js.undefined
    ): ImportImageRequest = {
      val __obj = js.Dynamic.literal()
      Architecture.foreach(__v => __obj.updateDynamic("Architecture")(__v.asInstanceOf[js.Any]))
      ClientData.foreach(__v => __obj.updateDynamic("ClientData")(__v.asInstanceOf[js.Any]))
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DiskContainers.foreach(__v => __obj.updateDynamic("DiskContainers")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Encrypted.foreach(__v => __obj.updateDynamic("Encrypted")(__v.asInstanceOf[js.Any]))
      Hypervisor.foreach(__v => __obj.updateDynamic("Hypervisor")(__v.asInstanceOf[js.Any]))
      KmsKeyId.foreach(__v => __obj.updateDynamic("KmsKeyId")(__v.asInstanceOf[js.Any]))
      LicenseType.foreach(__v => __obj.updateDynamic("LicenseType")(__v.asInstanceOf[js.Any]))
      Platform.foreach(__v => __obj.updateDynamic("Platform")(__v.asInstanceOf[js.Any]))
      RoleName.foreach(__v => __obj.updateDynamic("RoleName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportImageRequest]
    }
  }

  @js.native
  trait ImportImageResult extends js.Object {
    var Architecture: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var Encrypted: js.UndefOr[Boolean]
    var Hypervisor: js.UndefOr[String]
    var ImageId: js.UndefOr[String]
    var ImportTaskId: js.UndefOr[String]
    var KmsKeyId: js.UndefOr[String]
    var LicenseType: js.UndefOr[String]
    var Platform: js.UndefOr[String]
    var Progress: js.UndefOr[String]
    var SnapshotDetails: js.UndefOr[SnapshotDetailList]
    var Status: js.UndefOr[String]
    var StatusMessage: js.UndefOr[String]
  }

  object ImportImageResult {
    @inline
    def apply(
        Architecture: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Hypervisor: js.UndefOr[String] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        ImportTaskId: js.UndefOr[String] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        LicenseType: js.UndefOr[String] = js.undefined,
        Platform: js.UndefOr[String] = js.undefined,
        Progress: js.UndefOr[String] = js.undefined,
        SnapshotDetails: js.UndefOr[SnapshotDetailList] = js.undefined,
        Status: js.UndefOr[String] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined
    ): ImportImageResult = {
      val __obj = js.Dynamic.literal()
      Architecture.foreach(__v => __obj.updateDynamic("Architecture")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      Encrypted.foreach(__v => __obj.updateDynamic("Encrypted")(__v.asInstanceOf[js.Any]))
      Hypervisor.foreach(__v => __obj.updateDynamic("Hypervisor")(__v.asInstanceOf[js.Any]))
      ImageId.foreach(__v => __obj.updateDynamic("ImageId")(__v.asInstanceOf[js.Any]))
      ImportTaskId.foreach(__v => __obj.updateDynamic("ImportTaskId")(__v.asInstanceOf[js.Any]))
      KmsKeyId.foreach(__v => __obj.updateDynamic("KmsKeyId")(__v.asInstanceOf[js.Any]))
      LicenseType.foreach(__v => __obj.updateDynamic("LicenseType")(__v.asInstanceOf[js.Any]))
      Platform.foreach(__v => __obj.updateDynamic("Platform")(__v.asInstanceOf[js.Any]))
      Progress.foreach(__v => __obj.updateDynamic("Progress")(__v.asInstanceOf[js.Any]))
      SnapshotDetails.foreach(__v => __obj.updateDynamic("SnapshotDetails")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      StatusMessage.foreach(__v => __obj.updateDynamic("StatusMessage")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportImageResult]
    }
  }

  /**
    * Describes an import image task.
    */
  @js.native
  trait ImportImageTask extends js.Object {
    var Architecture: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var Encrypted: js.UndefOr[Boolean]
    var Hypervisor: js.UndefOr[String]
    var ImageId: js.UndefOr[String]
    var ImportTaskId: js.UndefOr[String]
    var KmsKeyId: js.UndefOr[String]
    var LicenseType: js.UndefOr[String]
    var Platform: js.UndefOr[String]
    var Progress: js.UndefOr[String]
    var SnapshotDetails: js.UndefOr[SnapshotDetailList]
    var Status: js.UndefOr[String]
    var StatusMessage: js.UndefOr[String]
  }

  object ImportImageTask {
    @inline
    def apply(
        Architecture: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Hypervisor: js.UndefOr[String] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        ImportTaskId: js.UndefOr[String] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        LicenseType: js.UndefOr[String] = js.undefined,
        Platform: js.UndefOr[String] = js.undefined,
        Progress: js.UndefOr[String] = js.undefined,
        SnapshotDetails: js.UndefOr[SnapshotDetailList] = js.undefined,
        Status: js.UndefOr[String] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined
    ): ImportImageTask = {
      val __obj = js.Dynamic.literal()
      Architecture.foreach(__v => __obj.updateDynamic("Architecture")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      Encrypted.foreach(__v => __obj.updateDynamic("Encrypted")(__v.asInstanceOf[js.Any]))
      Hypervisor.foreach(__v => __obj.updateDynamic("Hypervisor")(__v.asInstanceOf[js.Any]))
      ImageId.foreach(__v => __obj.updateDynamic("ImageId")(__v.asInstanceOf[js.Any]))
      ImportTaskId.foreach(__v => __obj.updateDynamic("ImportTaskId")(__v.asInstanceOf[js.Any]))
      KmsKeyId.foreach(__v => __obj.updateDynamic("KmsKeyId")(__v.asInstanceOf[js.Any]))
      LicenseType.foreach(__v => __obj.updateDynamic("LicenseType")(__v.asInstanceOf[js.Any]))
      Platform.foreach(__v => __obj.updateDynamic("Platform")(__v.asInstanceOf[js.Any]))
      Progress.foreach(__v => __obj.updateDynamic("Progress")(__v.asInstanceOf[js.Any]))
      SnapshotDetails.foreach(__v => __obj.updateDynamic("SnapshotDetails")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      StatusMessage.foreach(__v => __obj.updateDynamic("StatusMessage")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportImageTask]
    }
  }

  /**
    * Describes the launch specification for VM import.
    */
  @js.native
  trait ImportInstanceLaunchSpecification extends js.Object {
    var AdditionalInfo: js.UndefOr[String]
    var Architecture: js.UndefOr[ArchitectureValues]
    var GroupIds: js.UndefOr[SecurityGroupIdStringList]
    var GroupNames: js.UndefOr[SecurityGroupStringList]
    var InstanceInitiatedShutdownBehavior: js.UndefOr[ShutdownBehavior]
    var InstanceType: js.UndefOr[InstanceType]
    var Monitoring: js.UndefOr[Boolean]
    var Placement: js.UndefOr[Placement]
    var PrivateIpAddress: js.UndefOr[String]
    var SubnetId: js.UndefOr[String]
    var UserData: js.UndefOr[UserData]
  }

  object ImportInstanceLaunchSpecification {
    @inline
    def apply(
        AdditionalInfo: js.UndefOr[String] = js.undefined,
        Architecture: js.UndefOr[ArchitectureValues] = js.undefined,
        GroupIds: js.UndefOr[SecurityGroupIdStringList] = js.undefined,
        GroupNames: js.UndefOr[SecurityGroupStringList] = js.undefined,
        InstanceInitiatedShutdownBehavior: js.UndefOr[ShutdownBehavior] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        Monitoring: js.UndefOr[Boolean] = js.undefined,
        Placement: js.UndefOr[Placement] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        UserData: js.UndefOr[UserData] = js.undefined
    ): ImportInstanceLaunchSpecification = {
      val __obj = js.Dynamic.literal()
      AdditionalInfo.foreach(__v => __obj.updateDynamic("AdditionalInfo")(__v.asInstanceOf[js.Any]))
      Architecture.foreach(__v => __obj.updateDynamic("Architecture")(__v.asInstanceOf[js.Any]))
      GroupIds.foreach(__v => __obj.updateDynamic("GroupIds")(__v.asInstanceOf[js.Any]))
      GroupNames.foreach(__v => __obj.updateDynamic("GroupNames")(__v.asInstanceOf[js.Any]))
      InstanceInitiatedShutdownBehavior.foreach(
        __v => __obj.updateDynamic("InstanceInitiatedShutdownBehavior")(__v.asInstanceOf[js.Any])
      )
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      Monitoring.foreach(__v => __obj.updateDynamic("Monitoring")(__v.asInstanceOf[js.Any]))
      Placement.foreach(__v => __obj.updateDynamic("Placement")(__v.asInstanceOf[js.Any]))
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      UserData.foreach(__v => __obj.updateDynamic("UserData")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportInstanceLaunchSpecification]
    }
  }

  @js.native
  trait ImportInstanceRequest extends js.Object {
    var Platform: PlatformValues
    var Description: js.UndefOr[String]
    var DiskImages: js.UndefOr[DiskImageList]
    var DryRun: js.UndefOr[Boolean]
    var LaunchSpecification: js.UndefOr[ImportInstanceLaunchSpecification]
  }

  object ImportInstanceRequest {
    @inline
    def apply(
        Platform: PlatformValues,
        Description: js.UndefOr[String] = js.undefined,
        DiskImages: js.UndefOr[DiskImageList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LaunchSpecification: js.UndefOr[ImportInstanceLaunchSpecification] = js.undefined
    ): ImportInstanceRequest = {
      val __obj = js.Dynamic.literal(
        "Platform" -> Platform.asInstanceOf[js.Any]
      )

      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DiskImages.foreach(__v => __obj.updateDynamic("DiskImages")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      LaunchSpecification.foreach(__v => __obj.updateDynamic("LaunchSpecification")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportInstanceRequest]
    }
  }

  @js.native
  trait ImportInstanceResult extends js.Object {
    var ConversionTask: js.UndefOr[ConversionTask]
  }

  object ImportInstanceResult {
    @inline
    def apply(
        ConversionTask: js.UndefOr[ConversionTask] = js.undefined
    ): ImportInstanceResult = {
      val __obj = js.Dynamic.literal()
      ConversionTask.foreach(__v => __obj.updateDynamic("ConversionTask")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportInstanceResult]
    }
  }

  /**
    * Describes an import instance task.
    */
  @js.native
  trait ImportInstanceTaskDetails extends js.Object {
    var Description: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
    var Platform: js.UndefOr[PlatformValues]
    var Volumes: js.UndefOr[ImportInstanceVolumeDetailSet]
  }

  object ImportInstanceTaskDetails {
    @inline
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        Platform: js.UndefOr[PlatformValues] = js.undefined,
        Volumes: js.UndefOr[ImportInstanceVolumeDetailSet] = js.undefined
    ): ImportInstanceTaskDetails = {
      val __obj = js.Dynamic.literal()
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      Platform.foreach(__v => __obj.updateDynamic("Platform")(__v.asInstanceOf[js.Any]))
      Volumes.foreach(__v => __obj.updateDynamic("Volumes")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportInstanceTaskDetails]
    }
  }

  /**
    * Describes an import volume task.
    */
  @js.native
  trait ImportInstanceVolumeDetailItem extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var BytesConverted: js.UndefOr[Double]
    var Description: js.UndefOr[String]
    var Image: js.UndefOr[DiskImageDescription]
    var Status: js.UndefOr[String]
    var StatusMessage: js.UndefOr[String]
    var Volume: js.UndefOr[DiskImageVolumeDescription]
  }

  object ImportInstanceVolumeDetailItem {
    @inline
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        BytesConverted: js.UndefOr[Double] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        Image: js.UndefOr[DiskImageDescription] = js.undefined,
        Status: js.UndefOr[String] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined,
        Volume: js.UndefOr[DiskImageVolumeDescription] = js.undefined
    ): ImportInstanceVolumeDetailItem = {
      val __obj = js.Dynamic.literal()
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      BytesConverted.foreach(__v => __obj.updateDynamic("BytesConverted")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      Image.foreach(__v => __obj.updateDynamic("Image")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      StatusMessage.foreach(__v => __obj.updateDynamic("StatusMessage")(__v.asInstanceOf[js.Any]))
      Volume.foreach(__v => __obj.updateDynamic("Volume")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportInstanceVolumeDetailItem]
    }
  }

  @js.native
  trait ImportKeyPairRequest extends js.Object {
    var KeyName: String
    var PublicKeyMaterial: Blob
    var DryRun: js.UndefOr[Boolean]
  }

  object ImportKeyPairRequest {
    @inline
    def apply(
        KeyName: String,
        PublicKeyMaterial: Blob,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ImportKeyPairRequest = {
      val __obj = js.Dynamic.literal(
        "KeyName"           -> KeyName.asInstanceOf[js.Any],
        "PublicKeyMaterial" -> PublicKeyMaterial.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportKeyPairRequest]
    }
  }

  @js.native
  trait ImportKeyPairResult extends js.Object {
    var KeyFingerprint: js.UndefOr[String]
    var KeyName: js.UndefOr[String]
  }

  object ImportKeyPairResult {
    @inline
    def apply(
        KeyFingerprint: js.UndefOr[String] = js.undefined,
        KeyName: js.UndefOr[String] = js.undefined
    ): ImportKeyPairResult = {
      val __obj = js.Dynamic.literal()
      KeyFingerprint.foreach(__v => __obj.updateDynamic("KeyFingerprint")(__v.asInstanceOf[js.Any]))
      KeyName.foreach(__v => __obj.updateDynamic("KeyName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportKeyPairResult]
    }
  }

  @js.native
  trait ImportSnapshotRequest extends js.Object {
    var ClientData: js.UndefOr[ClientData]
    var ClientToken: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var DiskContainer: js.UndefOr[SnapshotDiskContainer]
    var DryRun: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var KmsKeyId: js.UndefOr[String]
    var RoleName: js.UndefOr[String]
  }

  object ImportSnapshotRequest {
    @inline
    def apply(
        ClientData: js.UndefOr[ClientData] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DiskContainer: js.UndefOr[SnapshotDiskContainer] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        RoleName: js.UndefOr[String] = js.undefined
    ): ImportSnapshotRequest = {
      val __obj = js.Dynamic.literal()
      ClientData.foreach(__v => __obj.updateDynamic("ClientData")(__v.asInstanceOf[js.Any]))
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DiskContainer.foreach(__v => __obj.updateDynamic("DiskContainer")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Encrypted.foreach(__v => __obj.updateDynamic("Encrypted")(__v.asInstanceOf[js.Any]))
      KmsKeyId.foreach(__v => __obj.updateDynamic("KmsKeyId")(__v.asInstanceOf[js.Any]))
      RoleName.foreach(__v => __obj.updateDynamic("RoleName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportSnapshotRequest]
    }
  }

  @js.native
  trait ImportSnapshotResult extends js.Object {
    var Description: js.UndefOr[String]
    var ImportTaskId: js.UndefOr[String]
    var SnapshotTaskDetail: js.UndefOr[SnapshotTaskDetail]
  }

  object ImportSnapshotResult {
    @inline
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        ImportTaskId: js.UndefOr[String] = js.undefined,
        SnapshotTaskDetail: js.UndefOr[SnapshotTaskDetail] = js.undefined
    ): ImportSnapshotResult = {
      val __obj = js.Dynamic.literal()
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      ImportTaskId.foreach(__v => __obj.updateDynamic("ImportTaskId")(__v.asInstanceOf[js.Any]))
      SnapshotTaskDetail.foreach(__v => __obj.updateDynamic("SnapshotTaskDetail")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportSnapshotResult]
    }
  }

  /**
    * Describes an import snapshot task.
    */
  @js.native
  trait ImportSnapshotTask extends js.Object {
    var Description: js.UndefOr[String]
    var ImportTaskId: js.UndefOr[String]
    var SnapshotTaskDetail: js.UndefOr[SnapshotTaskDetail]
  }

  object ImportSnapshotTask {
    @inline
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        ImportTaskId: js.UndefOr[String] = js.undefined,
        SnapshotTaskDetail: js.UndefOr[SnapshotTaskDetail] = js.undefined
    ): ImportSnapshotTask = {
      val __obj = js.Dynamic.literal()
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      ImportTaskId.foreach(__v => __obj.updateDynamic("ImportTaskId")(__v.asInstanceOf[js.Any]))
      SnapshotTaskDetail.foreach(__v => __obj.updateDynamic("SnapshotTaskDetail")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportSnapshotTask]
    }
  }

  @js.native
  trait ImportVolumeRequest extends js.Object {
    var AvailabilityZone: String
    var Image: DiskImageDetail
    var Volume: VolumeDetail
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object ImportVolumeRequest {
    @inline
    def apply(
        AvailabilityZone: String,
        Image: DiskImageDetail,
        Volume: VolumeDetail,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ImportVolumeRequest = {
      val __obj = js.Dynamic.literal(
        "AvailabilityZone" -> AvailabilityZone.asInstanceOf[js.Any],
        "Image"            -> Image.asInstanceOf[js.Any],
        "Volume"           -> Volume.asInstanceOf[js.Any]
      )

      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportVolumeRequest]
    }
  }

  @js.native
  trait ImportVolumeResult extends js.Object {
    var ConversionTask: js.UndefOr[ConversionTask]
  }

  object ImportVolumeResult {
    @inline
    def apply(
        ConversionTask: js.UndefOr[ConversionTask] = js.undefined
    ): ImportVolumeResult = {
      val __obj = js.Dynamic.literal()
      ConversionTask.foreach(__v => __obj.updateDynamic("ConversionTask")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportVolumeResult]
    }
  }

  /**
    * Describes an import volume task.
    */
  @js.native
  trait ImportVolumeTaskDetails extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var BytesConverted: js.UndefOr[Double]
    var Description: js.UndefOr[String]
    var Image: js.UndefOr[DiskImageDescription]
    var Volume: js.UndefOr[DiskImageVolumeDescription]
  }

  object ImportVolumeTaskDetails {
    @inline
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        BytesConverted: js.UndefOr[Double] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        Image: js.UndefOr[DiskImageDescription] = js.undefined,
        Volume: js.UndefOr[DiskImageVolumeDescription] = js.undefined
    ): ImportVolumeTaskDetails = {
      val __obj = js.Dynamic.literal()
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      BytesConverted.foreach(__v => __obj.updateDynamic("BytesConverted")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      Image.foreach(__v => __obj.updateDynamic("Image")(__v.asInstanceOf[js.Any]))
      Volume.foreach(__v => __obj.updateDynamic("Volume")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ImportVolumeTaskDetails]
    }
  }

  /**
    * Describes an instance.
    */
  @js.native
  trait Instance extends js.Object {
    var AmiLaunchIndex: js.UndefOr[Int]
    var Architecture: js.UndefOr[ArchitectureValues]
    var BlockDeviceMappings: js.UndefOr[InstanceBlockDeviceMappingList]
    var CapacityReservationId: js.UndefOr[String]
    var CapacityReservationSpecification: js.UndefOr[CapacityReservationSpecificationResponse]
    var ClientToken: js.UndefOr[String]
    var CpuOptions: js.UndefOr[CpuOptions]
    var EbsOptimized: js.UndefOr[Boolean]
    var ElasticGpuAssociations: js.UndefOr[ElasticGpuAssociationList]
    var ElasticInferenceAcceleratorAssociations: js.UndefOr[ElasticInferenceAcceleratorAssociationList]
    var EnaSupport: js.UndefOr[Boolean]
    var HibernationOptions: js.UndefOr[HibernationOptions]
    var Hypervisor: js.UndefOr[HypervisorType]
    var IamInstanceProfile: js.UndefOr[IamInstanceProfile]
    var ImageId: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
    var InstanceLifecycle: js.UndefOr[InstanceLifecycleType]
    var InstanceType: js.UndefOr[InstanceType]
    var KernelId: js.UndefOr[String]
    var KeyName: js.UndefOr[String]
    var LaunchTime: js.UndefOr[DateTime]
    var Licenses: js.UndefOr[LicenseList]
    var Monitoring: js.UndefOr[Monitoring]
    var NetworkInterfaces: js.UndefOr[InstanceNetworkInterfaceList]
    var Placement: js.UndefOr[Placement]
    var Platform: js.UndefOr[PlatformValues]
    var PrivateDnsName: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var PublicDnsName: js.UndefOr[String]
    var PublicIpAddress: js.UndefOr[String]
    var RamdiskId: js.UndefOr[String]
    var RootDeviceName: js.UndefOr[String]
    var RootDeviceType: js.UndefOr[DeviceType]
    var SecurityGroups: js.UndefOr[GroupIdentifierList]
    var SourceDestCheck: js.UndefOr[Boolean]
    var SpotInstanceRequestId: js.UndefOr[String]
    var SriovNetSupport: js.UndefOr[String]
    var State: js.UndefOr[InstanceState]
    var StateReason: js.UndefOr[StateReason]
    var StateTransitionReason: js.UndefOr[String]
    var SubnetId: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
    var VirtualizationType: js.UndefOr[VirtualizationType]
    var VpcId: js.UndefOr[String]
  }

  object Instance {
    @inline
    def apply(
        AmiLaunchIndex: js.UndefOr[Int] = js.undefined,
        Architecture: js.UndefOr[ArchitectureValues] = js.undefined,
        BlockDeviceMappings: js.UndefOr[InstanceBlockDeviceMappingList] = js.undefined,
        CapacityReservationId: js.UndefOr[String] = js.undefined,
        CapacityReservationSpecification: js.UndefOr[CapacityReservationSpecificationResponse] = js.undefined,
        ClientToken: js.UndefOr[String] = js.undefined,
        CpuOptions: js.UndefOr[CpuOptions] = js.undefined,
        EbsOptimized: js.UndefOr[Boolean] = js.undefined,
        ElasticGpuAssociations: js.UndefOr[ElasticGpuAssociationList] = js.undefined,
        ElasticInferenceAcceleratorAssociations: js.UndefOr[ElasticInferenceAcceleratorAssociationList] = js.undefined,
        EnaSupport: js.UndefOr[Boolean] = js.undefined,
        HibernationOptions: js.UndefOr[HibernationOptions] = js.undefined,
        Hypervisor: js.UndefOr[HypervisorType] = js.undefined,
        IamInstanceProfile: js.UndefOr[IamInstanceProfile] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        InstanceLifecycle: js.UndefOr[InstanceLifecycleType] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        KernelId: js.UndefOr[String] = js.undefined,
        KeyName: js.UndefOr[String] = js.undefined,
        LaunchTime: js.UndefOr[DateTime] = js.undefined,
        Licenses: js.UndefOr[LicenseList] = js.undefined,
        Monitoring: js.UndefOr[Monitoring] = js.undefined,
        NetworkInterfaces: js.UndefOr[InstanceNetworkInterfaceList] = js.undefined,
        Placement: js.UndefOr[Placement] = js.undefined,
        Platform: js.UndefOr[PlatformValues] = js.undefined,
        PrivateDnsName: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        PublicDnsName: js.UndefOr[String] = js.undefined,
        PublicIpAddress: js.UndefOr[String] = js.undefined,
        RamdiskId: js.UndefOr[String] = js.undefined,
        RootDeviceName: js.UndefOr[String] = js.undefined,
        RootDeviceType: js.UndefOr[DeviceType] = js.undefined,
        SecurityGroups: js.UndefOr[GroupIdentifierList] = js.undefined,
        SourceDestCheck: js.UndefOr[Boolean] = js.undefined,
        SpotInstanceRequestId: js.UndefOr[String] = js.undefined,
        SriovNetSupport: js.UndefOr[String] = js.undefined,
        State: js.UndefOr[InstanceState] = js.undefined,
        StateReason: js.UndefOr[StateReason] = js.undefined,
        StateTransitionReason: js.UndefOr[String] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        VirtualizationType: js.UndefOr[VirtualizationType] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): Instance = {
      val __obj = js.Dynamic.literal()
      AmiLaunchIndex.foreach(__v => __obj.updateDynamic("AmiLaunchIndex")(__v.asInstanceOf[js.Any]))
      Architecture.foreach(__v => __obj.updateDynamic("Architecture")(__v.asInstanceOf[js.Any]))
      BlockDeviceMappings.foreach(__v => __obj.updateDynamic("BlockDeviceMappings")(__v.asInstanceOf[js.Any]))
      CapacityReservationId.foreach(__v => __obj.updateDynamic("CapacityReservationId")(__v.asInstanceOf[js.Any]))
      CapacityReservationSpecification.foreach(
        __v => __obj.updateDynamic("CapacityReservationSpecification")(__v.asInstanceOf[js.Any])
      )
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      CpuOptions.foreach(__v => __obj.updateDynamic("CpuOptions")(__v.asInstanceOf[js.Any]))
      EbsOptimized.foreach(__v => __obj.updateDynamic("EbsOptimized")(__v.asInstanceOf[js.Any]))
      ElasticGpuAssociations.foreach(__v => __obj.updateDynamic("ElasticGpuAssociations")(__v.asInstanceOf[js.Any]))
      ElasticInferenceAcceleratorAssociations.foreach(
        __v => __obj.updateDynamic("ElasticInferenceAcceleratorAssociations")(__v.asInstanceOf[js.Any])
      )
      EnaSupport.foreach(__v => __obj.updateDynamic("EnaSupport")(__v.asInstanceOf[js.Any]))
      HibernationOptions.foreach(__v => __obj.updateDynamic("HibernationOptions")(__v.asInstanceOf[js.Any]))
      Hypervisor.foreach(__v => __obj.updateDynamic("Hypervisor")(__v.asInstanceOf[js.Any]))
      IamInstanceProfile.foreach(__v => __obj.updateDynamic("IamInstanceProfile")(__v.asInstanceOf[js.Any]))
      ImageId.foreach(__v => __obj.updateDynamic("ImageId")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      InstanceLifecycle.foreach(__v => __obj.updateDynamic("InstanceLifecycle")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      KernelId.foreach(__v => __obj.updateDynamic("KernelId")(__v.asInstanceOf[js.Any]))
      KeyName.foreach(__v => __obj.updateDynamic("KeyName")(__v.asInstanceOf[js.Any]))
      LaunchTime.foreach(__v => __obj.updateDynamic("LaunchTime")(__v.asInstanceOf[js.Any]))
      Licenses.foreach(__v => __obj.updateDynamic("Licenses")(__v.asInstanceOf[js.Any]))
      Monitoring.foreach(__v => __obj.updateDynamic("Monitoring")(__v.asInstanceOf[js.Any]))
      NetworkInterfaces.foreach(__v => __obj.updateDynamic("NetworkInterfaces")(__v.asInstanceOf[js.Any]))
      Placement.foreach(__v => __obj.updateDynamic("Placement")(__v.asInstanceOf[js.Any]))
      Platform.foreach(__v => __obj.updateDynamic("Platform")(__v.asInstanceOf[js.Any]))
      PrivateDnsName.foreach(__v => __obj.updateDynamic("PrivateDnsName")(__v.asInstanceOf[js.Any]))
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      ProductCodes.foreach(__v => __obj.updateDynamic("ProductCodes")(__v.asInstanceOf[js.Any]))
      PublicDnsName.foreach(__v => __obj.updateDynamic("PublicDnsName")(__v.asInstanceOf[js.Any]))
      PublicIpAddress.foreach(__v => __obj.updateDynamic("PublicIpAddress")(__v.asInstanceOf[js.Any]))
      RamdiskId.foreach(__v => __obj.updateDynamic("RamdiskId")(__v.asInstanceOf[js.Any]))
      RootDeviceName.foreach(__v => __obj.updateDynamic("RootDeviceName")(__v.asInstanceOf[js.Any]))
      RootDeviceType.foreach(__v => __obj.updateDynamic("RootDeviceType")(__v.asInstanceOf[js.Any]))
      SecurityGroups.foreach(__v => __obj.updateDynamic("SecurityGroups")(__v.asInstanceOf[js.Any]))
      SourceDestCheck.foreach(__v => __obj.updateDynamic("SourceDestCheck")(__v.asInstanceOf[js.Any]))
      SpotInstanceRequestId.foreach(__v => __obj.updateDynamic("SpotInstanceRequestId")(__v.asInstanceOf[js.Any]))
      SriovNetSupport.foreach(__v => __obj.updateDynamic("SriovNetSupport")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      StateReason.foreach(__v => __obj.updateDynamic("StateReason")(__v.asInstanceOf[js.Any]))
      StateTransitionReason.foreach(__v => __obj.updateDynamic("StateTransitionReason")(__v.asInstanceOf[js.Any]))
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      VirtualizationType.foreach(__v => __obj.updateDynamic("VirtualizationType")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[Instance]
    }
  }

  /**
    * Describes an instance attribute.
    */
  @js.native
  trait InstanceAttribute extends js.Object {
    var BlockDeviceMappings: js.UndefOr[InstanceBlockDeviceMappingList]
    var DisableApiTermination: js.UndefOr[AttributeBooleanValue]
    var EbsOptimized: js.UndefOr[AttributeBooleanValue]
    var EnaSupport: js.UndefOr[AttributeBooleanValue]
    var Groups: js.UndefOr[GroupIdentifierList]
    var InstanceId: js.UndefOr[String]
    var InstanceInitiatedShutdownBehavior: js.UndefOr[AttributeValue]
    var InstanceType: js.UndefOr[AttributeValue]
    var KernelId: js.UndefOr[AttributeValue]
    var ProductCodes: js.UndefOr[ProductCodeList]
    var RamdiskId: js.UndefOr[AttributeValue]
    var RootDeviceName: js.UndefOr[AttributeValue]
    var SourceDestCheck: js.UndefOr[AttributeBooleanValue]
    var SriovNetSupport: js.UndefOr[AttributeValue]
    var UserData: js.UndefOr[AttributeValue]
  }

  object InstanceAttribute {
    @inline
    def apply(
        BlockDeviceMappings: js.UndefOr[InstanceBlockDeviceMappingList] = js.undefined,
        DisableApiTermination: js.UndefOr[AttributeBooleanValue] = js.undefined,
        EbsOptimized: js.UndefOr[AttributeBooleanValue] = js.undefined,
        EnaSupport: js.UndefOr[AttributeBooleanValue] = js.undefined,
        Groups: js.UndefOr[GroupIdentifierList] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        InstanceInitiatedShutdownBehavior: js.UndefOr[AttributeValue] = js.undefined,
        InstanceType: js.UndefOr[AttributeValue] = js.undefined,
        KernelId: js.UndefOr[AttributeValue] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeList] = js.undefined,
        RamdiskId: js.UndefOr[AttributeValue] = js.undefined,
        RootDeviceName: js.UndefOr[AttributeValue] = js.undefined,
        SourceDestCheck: js.UndefOr[AttributeBooleanValue] = js.undefined,
        SriovNetSupport: js.UndefOr[AttributeValue] = js.undefined,
        UserData: js.UndefOr[AttributeValue] = js.undefined
    ): InstanceAttribute = {
      val __obj = js.Dynamic.literal()
      BlockDeviceMappings.foreach(__v => __obj.updateDynamic("BlockDeviceMappings")(__v.asInstanceOf[js.Any]))
      DisableApiTermination.foreach(__v => __obj.updateDynamic("DisableApiTermination")(__v.asInstanceOf[js.Any]))
      EbsOptimized.foreach(__v => __obj.updateDynamic("EbsOptimized")(__v.asInstanceOf[js.Any]))
      EnaSupport.foreach(__v => __obj.updateDynamic("EnaSupport")(__v.asInstanceOf[js.Any]))
      Groups.foreach(__v => __obj.updateDynamic("Groups")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      InstanceInitiatedShutdownBehavior.foreach(
        __v => __obj.updateDynamic("InstanceInitiatedShutdownBehavior")(__v.asInstanceOf[js.Any])
      )
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      KernelId.foreach(__v => __obj.updateDynamic("KernelId")(__v.asInstanceOf[js.Any]))
      ProductCodes.foreach(__v => __obj.updateDynamic("ProductCodes")(__v.asInstanceOf[js.Any]))
      RamdiskId.foreach(__v => __obj.updateDynamic("RamdiskId")(__v.asInstanceOf[js.Any]))
      RootDeviceName.foreach(__v => __obj.updateDynamic("RootDeviceName")(__v.asInstanceOf[js.Any]))
      SourceDestCheck.foreach(__v => __obj.updateDynamic("SourceDestCheck")(__v.asInstanceOf[js.Any]))
      SriovNetSupport.foreach(__v => __obj.updateDynamic("SriovNetSupport")(__v.asInstanceOf[js.Any]))
      UserData.foreach(__v => __obj.updateDynamic("UserData")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceAttribute]
    }
  }

  object InstanceAttributeNameEnum {
    val instanceType                      = "instanceType"
    val kernel                            = "kernel"
    val ramdisk                           = "ramdisk"
    val userData                          = "userData"
    val disableApiTermination             = "disableApiTermination"
    val instanceInitiatedShutdownBehavior = "instanceInitiatedShutdownBehavior"
    val rootDeviceName                    = "rootDeviceName"
    val blockDeviceMapping                = "blockDeviceMapping"
    val productCodes                      = "productCodes"
    val sourceDestCheck                   = "sourceDestCheck"
    val groupSet                          = "groupSet"
    val ebsOptimized                      = "ebsOptimized"
    val sriovNetSupport                   = "sriovNetSupport"
    val enaSupport                        = "enaSupport"

    val values = js.Object.freeze(
      js.Array(
        instanceType,
        kernel,
        ramdisk,
        userData,
        disableApiTermination,
        instanceInitiatedShutdownBehavior,
        rootDeviceName,
        blockDeviceMapping,
        productCodes,
        sourceDestCheck,
        groupSet,
        ebsOptimized,
        sriovNetSupport,
        enaSupport
      )
    )
  }

  /**
    * Describes a block device mapping.
    */
  @js.native
  trait InstanceBlockDeviceMapping extends js.Object {
    var DeviceName: js.UndefOr[String]
    var Ebs: js.UndefOr[EbsInstanceBlockDevice]
  }

  object InstanceBlockDeviceMapping {
    @inline
    def apply(
        DeviceName: js.UndefOr[String] = js.undefined,
        Ebs: js.UndefOr[EbsInstanceBlockDevice] = js.undefined
    ): InstanceBlockDeviceMapping = {
      val __obj = js.Dynamic.literal()
      DeviceName.foreach(__v => __obj.updateDynamic("DeviceName")(__v.asInstanceOf[js.Any]))
      Ebs.foreach(__v => __obj.updateDynamic("Ebs")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceBlockDeviceMapping]
    }
  }

  /**
    * Describes a block device mapping entry.
    */
  @js.native
  trait InstanceBlockDeviceMappingSpecification extends js.Object {
    var DeviceName: js.UndefOr[String]
    var Ebs: js.UndefOr[EbsInstanceBlockDeviceSpecification]
    var NoDevice: js.UndefOr[String]
    var VirtualName: js.UndefOr[String]
  }

  object InstanceBlockDeviceMappingSpecification {
    @inline
    def apply(
        DeviceName: js.UndefOr[String] = js.undefined,
        Ebs: js.UndefOr[EbsInstanceBlockDeviceSpecification] = js.undefined,
        NoDevice: js.UndefOr[String] = js.undefined,
        VirtualName: js.UndefOr[String] = js.undefined
    ): InstanceBlockDeviceMappingSpecification = {
      val __obj = js.Dynamic.literal()
      DeviceName.foreach(__v => __obj.updateDynamic("DeviceName")(__v.asInstanceOf[js.Any]))
      Ebs.foreach(__v => __obj.updateDynamic("Ebs")(__v.asInstanceOf[js.Any]))
      NoDevice.foreach(__v => __obj.updateDynamic("NoDevice")(__v.asInstanceOf[js.Any]))
      VirtualName.foreach(__v => __obj.updateDynamic("VirtualName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceBlockDeviceMappingSpecification]
    }
  }

  /**
    * Information about the instance type that the Dedicated Host supports.
    */
  @js.native
  trait InstanceCapacity extends js.Object {
    var AvailableCapacity: js.UndefOr[Int]
    var InstanceType: js.UndefOr[String]
    var TotalCapacity: js.UndefOr[Int]
  }

  object InstanceCapacity {
    @inline
    def apply(
        AvailableCapacity: js.UndefOr[Int] = js.undefined,
        InstanceType: js.UndefOr[String] = js.undefined,
        TotalCapacity: js.UndefOr[Int] = js.undefined
    ): InstanceCapacity = {
      val __obj = js.Dynamic.literal()
      AvailableCapacity.foreach(__v => __obj.updateDynamic("AvailableCapacity")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      TotalCapacity.foreach(__v => __obj.updateDynamic("TotalCapacity")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceCapacity]
    }
  }

  /**
    * Describes a Reserved Instance listing state.
    */
  @js.native
  trait InstanceCount extends js.Object {
    var InstanceCount: js.UndefOr[Int]
    var State: js.UndefOr[ListingState]
  }

  object InstanceCount {
    @inline
    def apply(
        InstanceCount: js.UndefOr[Int] = js.undefined,
        State: js.UndefOr[ListingState] = js.undefined
    ): InstanceCount = {
      val __obj = js.Dynamic.literal()
      InstanceCount.foreach(__v => __obj.updateDynamic("InstanceCount")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceCount]
    }
  }

  /**
    * Describes the credit option for CPU usage of a T2 or T3 instance.
    */
  @js.native
  trait InstanceCreditSpecification extends js.Object {
    var CpuCredits: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
  }

  object InstanceCreditSpecification {
    @inline
    def apply(
        CpuCredits: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): InstanceCreditSpecification = {
      val __obj = js.Dynamic.literal()
      CpuCredits.foreach(__v => __obj.updateDynamic("CpuCredits")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceCreditSpecification]
    }
  }

  /**
    * Describes the credit option for CPU usage of a T2 or T3 instance.
    */
  @js.native
  trait InstanceCreditSpecificationRequest extends js.Object {
    var CpuCredits: js.UndefOr[String]
    var InstanceId: js.UndefOr[String]
  }

  object InstanceCreditSpecificationRequest {
    @inline
    def apply(
        CpuCredits: js.UndefOr[String] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): InstanceCreditSpecificationRequest = {
      val __obj = js.Dynamic.literal()
      CpuCredits.foreach(__v => __obj.updateDynamic("CpuCredits")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceCreditSpecificationRequest]
    }
  }

  /**
    * Describes an instance to export.
    */
  @js.native
  trait InstanceExportDetails extends js.Object {
    var InstanceId: js.UndefOr[String]
    var TargetEnvironment: js.UndefOr[ExportEnvironment]
  }

  object InstanceExportDetails {
    @inline
    def apply(
        InstanceId: js.UndefOr[String] = js.undefined,
        TargetEnvironment: js.UndefOr[ExportEnvironment] = js.undefined
    ): InstanceExportDetails = {
      val __obj = js.Dynamic.literal()
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      TargetEnvironment.foreach(__v => __obj.updateDynamic("TargetEnvironment")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceExportDetails]
    }
  }

  object InstanceHealthStatusEnum {
    val healthy   = "healthy"
    val unhealthy = "unhealthy"

    val values = js.Object.freeze(js.Array(healthy, unhealthy))
  }

  object InstanceInterruptionBehaviorEnum {
    val hibernate = "hibernate"
    val stop      = "stop"
    val terminate = "terminate"

    val values = js.Object.freeze(js.Array(hibernate, stop, terminate))
  }

  /**
    * Describes an IPv6 address.
    */
  @js.native
  trait InstanceIpv6Address extends js.Object {
    var Ipv6Address: js.UndefOr[String]
  }

  object InstanceIpv6Address {
    @inline
    def apply(
        Ipv6Address: js.UndefOr[String] = js.undefined
    ): InstanceIpv6Address = {
      val __obj = js.Dynamic.literal()
      Ipv6Address.foreach(__v => __obj.updateDynamic("Ipv6Address")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceIpv6Address]
    }
  }

  /**
    * Describes an IPv6 address.
    */
  @js.native
  trait InstanceIpv6AddressRequest extends js.Object {
    var Ipv6Address: js.UndefOr[String]
  }

  object InstanceIpv6AddressRequest {
    @inline
    def apply(
        Ipv6Address: js.UndefOr[String] = js.undefined
    ): InstanceIpv6AddressRequest = {
      val __obj = js.Dynamic.literal()
      Ipv6Address.foreach(__v => __obj.updateDynamic("Ipv6Address")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceIpv6AddressRequest]
    }
  }

  object InstanceLifecycleEnum {
    val spot        = "spot"
    val `on-demand` = "on-demand"

    val values = js.Object.freeze(js.Array(spot, `on-demand`))
  }

  object InstanceLifecycleTypeEnum {
    val spot      = "spot"
    val scheduled = "scheduled"

    val values = js.Object.freeze(js.Array(spot, scheduled))
  }

  /**
    * Describes the market (purchasing) option for the instances.
    */
  @js.native
  trait InstanceMarketOptionsRequest extends js.Object {
    var MarketType: js.UndefOr[MarketType]
    var SpotOptions: js.UndefOr[SpotMarketOptions]
  }

  object InstanceMarketOptionsRequest {
    @inline
    def apply(
        MarketType: js.UndefOr[MarketType] = js.undefined,
        SpotOptions: js.UndefOr[SpotMarketOptions] = js.undefined
    ): InstanceMarketOptionsRequest = {
      val __obj = js.Dynamic.literal()
      MarketType.foreach(__v => __obj.updateDynamic("MarketType")(__v.asInstanceOf[js.Any]))
      SpotOptions.foreach(__v => __obj.updateDynamic("SpotOptions")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceMarketOptionsRequest]
    }
  }

  object InstanceMatchCriteriaEnum {
    val open     = "open"
    val targeted = "targeted"

    val values = js.Object.freeze(js.Array(open, targeted))
  }

  /**
    * Describes the monitoring of an instance.
    */
  @js.native
  trait InstanceMonitoring extends js.Object {
    var InstanceId: js.UndefOr[String]
    var Monitoring: js.UndefOr[Monitoring]
  }

  object InstanceMonitoring {
    @inline
    def apply(
        InstanceId: js.UndefOr[String] = js.undefined,
        Monitoring: js.UndefOr[Monitoring] = js.undefined
    ): InstanceMonitoring = {
      val __obj = js.Dynamic.literal()
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      Monitoring.foreach(__v => __obj.updateDynamic("Monitoring")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceMonitoring]
    }
  }

  /**
    * Describes a network interface.
    */
  @js.native
  trait InstanceNetworkInterface extends js.Object {
    var Association: js.UndefOr[InstanceNetworkInterfaceAssociation]
    var Attachment: js.UndefOr[InstanceNetworkInterfaceAttachment]
    var Description: js.UndefOr[String]
    var Groups: js.UndefOr[GroupIdentifierList]
    var InterfaceType: js.UndefOr[String]
    var Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList]
    var MacAddress: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var PrivateDnsName: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PrivateIpAddresses: js.UndefOr[InstancePrivateIpAddressList]
    var SourceDestCheck: js.UndefOr[Boolean]
    var Status: js.UndefOr[NetworkInterfaceStatus]
    var SubnetId: js.UndefOr[String]
    var VpcId: js.UndefOr[String]
  }

  object InstanceNetworkInterface {
    @inline
    def apply(
        Association: js.UndefOr[InstanceNetworkInterfaceAssociation] = js.undefined,
        Attachment: js.UndefOr[InstanceNetworkInterfaceAttachment] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        Groups: js.UndefOr[GroupIdentifierList] = js.undefined,
        InterfaceType: js.UndefOr[String] = js.undefined,
        Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList] = js.undefined,
        MacAddress: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        PrivateDnsName: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PrivateIpAddresses: js.UndefOr[InstancePrivateIpAddressList] = js.undefined,
        SourceDestCheck: js.UndefOr[Boolean] = js.undefined,
        Status: js.UndefOr[NetworkInterfaceStatus] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): InstanceNetworkInterface = {
      val __obj = js.Dynamic.literal()
      Association.foreach(__v => __obj.updateDynamic("Association")(__v.asInstanceOf[js.Any]))
      Attachment.foreach(__v => __obj.updateDynamic("Attachment")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      Groups.foreach(__v => __obj.updateDynamic("Groups")(__v.asInstanceOf[js.Any]))
      InterfaceType.foreach(__v => __obj.updateDynamic("InterfaceType")(__v.asInstanceOf[js.Any]))
      Ipv6Addresses.foreach(__v => __obj.updateDynamic("Ipv6Addresses")(__v.asInstanceOf[js.Any]))
      MacAddress.foreach(__v => __obj.updateDynamic("MacAddress")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      OwnerId.foreach(__v => __obj.updateDynamic("OwnerId")(__v.asInstanceOf[js.Any]))
      PrivateDnsName.foreach(__v => __obj.updateDynamic("PrivateDnsName")(__v.asInstanceOf[js.Any]))
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      PrivateIpAddresses.foreach(__v => __obj.updateDynamic("PrivateIpAddresses")(__v.asInstanceOf[js.Any]))
      SourceDestCheck.foreach(__v => __obj.updateDynamic("SourceDestCheck")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceNetworkInterface]
    }
  }

  /**
    * Describes association information for an Elastic IP address (IPv4).
    */
  @js.native
  trait InstanceNetworkInterfaceAssociation extends js.Object {
    var IpOwnerId: js.UndefOr[String]
    var PublicDnsName: js.UndefOr[String]
    var PublicIp: js.UndefOr[String]
  }

  object InstanceNetworkInterfaceAssociation {
    @inline
    def apply(
        IpOwnerId: js.UndefOr[String] = js.undefined,
        PublicDnsName: js.UndefOr[String] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): InstanceNetworkInterfaceAssociation = {
      val __obj = js.Dynamic.literal()
      IpOwnerId.foreach(__v => __obj.updateDynamic("IpOwnerId")(__v.asInstanceOf[js.Any]))
      PublicDnsName.foreach(__v => __obj.updateDynamic("PublicDnsName")(__v.asInstanceOf[js.Any]))
      PublicIp.foreach(__v => __obj.updateDynamic("PublicIp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceNetworkInterfaceAssociation]
    }
  }

  /**
    * Describes a network interface attachment.
    */
  @js.native
  trait InstanceNetworkInterfaceAttachment extends js.Object {
    var AttachTime: js.UndefOr[DateTime]
    var AttachmentId: js.UndefOr[String]
    var DeleteOnTermination: js.UndefOr[Boolean]
    var DeviceIndex: js.UndefOr[Int]
    var Status: js.UndefOr[AttachmentStatus]
  }

  object InstanceNetworkInterfaceAttachment {
    @inline
    def apply(
        AttachTime: js.UndefOr[DateTime] = js.undefined,
        AttachmentId: js.UndefOr[String] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        DeviceIndex: js.UndefOr[Int] = js.undefined,
        Status: js.UndefOr[AttachmentStatus] = js.undefined
    ): InstanceNetworkInterfaceAttachment = {
      val __obj = js.Dynamic.literal()
      AttachTime.foreach(__v => __obj.updateDynamic("AttachTime")(__v.asInstanceOf[js.Any]))
      AttachmentId.foreach(__v => __obj.updateDynamic("AttachmentId")(__v.asInstanceOf[js.Any]))
      DeleteOnTermination.foreach(__v => __obj.updateDynamic("DeleteOnTermination")(__v.asInstanceOf[js.Any]))
      DeviceIndex.foreach(__v => __obj.updateDynamic("DeviceIndex")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceNetworkInterfaceAttachment]
    }
  }

  /**
    * Describes a network interface.
    */
  @js.native
  trait InstanceNetworkInterfaceSpecification extends js.Object {
    var AssociatePublicIpAddress: js.UndefOr[Boolean]
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Description: js.UndefOr[String]
    var DeviceIndex: js.UndefOr[Int]
    var Groups: js.UndefOr[SecurityGroupIdStringList]
    var InterfaceType: js.UndefOr[String]
    var Ipv6AddressCount: js.UndefOr[Int]
    var Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList]
    var NetworkInterfaceId: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList]
    var SecondaryPrivateIpAddressCount: js.UndefOr[Int]
    var SubnetId: js.UndefOr[String]
  }

  object InstanceNetworkInterfaceSpecification {
    @inline
    def apply(
        AssociatePublicIpAddress: js.UndefOr[Boolean] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DeviceIndex: js.UndefOr[Int] = js.undefined,
        Groups: js.UndefOr[SecurityGroupIdStringList] = js.undefined,
        InterfaceType: js.UndefOr[String] = js.undefined,
        Ipv6AddressCount: js.UndefOr[Int] = js.undefined,
        Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList] = js.undefined,
        SecondaryPrivateIpAddressCount: js.UndefOr[Int] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined
    ): InstanceNetworkInterfaceSpecification = {
      val __obj = js.Dynamic.literal()
      AssociatePublicIpAddress.foreach(__v => __obj.updateDynamic("AssociatePublicIpAddress")(__v.asInstanceOf[js.Any]))
      DeleteOnTermination.foreach(__v => __obj.updateDynamic("DeleteOnTermination")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DeviceIndex.foreach(__v => __obj.updateDynamic("DeviceIndex")(__v.asInstanceOf[js.Any]))
      Groups.foreach(__v => __obj.updateDynamic("Groups")(__v.asInstanceOf[js.Any]))
      InterfaceType.foreach(__v => __obj.updateDynamic("InterfaceType")(__v.asInstanceOf[js.Any]))
      Ipv6AddressCount.foreach(__v => __obj.updateDynamic("Ipv6AddressCount")(__v.asInstanceOf[js.Any]))
      Ipv6Addresses.foreach(__v => __obj.updateDynamic("Ipv6Addresses")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      PrivateIpAddresses.foreach(__v => __obj.updateDynamic("PrivateIpAddresses")(__v.asInstanceOf[js.Any]))
      SecondaryPrivateIpAddressCount.foreach(
        __v => __obj.updateDynamic("SecondaryPrivateIpAddressCount")(__v.asInstanceOf[js.Any])
      )
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceNetworkInterfaceSpecification]
    }
  }

  /**
    * Describes a private IPv4 address.
    */
  @js.native
  trait InstancePrivateIpAddress extends js.Object {
    var Association: js.UndefOr[InstanceNetworkInterfaceAssociation]
    var Primary: js.UndefOr[Boolean]
    var PrivateDnsName: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
  }

  object InstancePrivateIpAddress {
    @inline
    def apply(
        Association: js.UndefOr[InstanceNetworkInterfaceAssociation] = js.undefined,
        Primary: js.UndefOr[Boolean] = js.undefined,
        PrivateDnsName: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined
    ): InstancePrivateIpAddress = {
      val __obj = js.Dynamic.literal()
      Association.foreach(__v => __obj.updateDynamic("Association")(__v.asInstanceOf[js.Any]))
      Primary.foreach(__v => __obj.updateDynamic("Primary")(__v.asInstanceOf[js.Any]))
      PrivateDnsName.foreach(__v => __obj.updateDynamic("PrivateDnsName")(__v.asInstanceOf[js.Any]))
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstancePrivateIpAddress]
    }
  }

  /**
    * The instance details to specify which volumes should be snapshotted.
    */
  @js.native
  trait InstanceSpecification extends js.Object {
    var ExcludeBootVolume: js.UndefOr[Boolean]
    var InstanceId: js.UndefOr[String]
  }

  object InstanceSpecification {
    @inline
    def apply(
        ExcludeBootVolume: js.UndefOr[Boolean] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined
    ): InstanceSpecification = {
      val __obj = js.Dynamic.literal()
      ExcludeBootVolume.foreach(__v => __obj.updateDynamic("ExcludeBootVolume")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceSpecification]
    }
  }

  /**
    * Describes the current state of an instance.
    */
  @js.native
  trait InstanceState extends js.Object {
    var Code: js.UndefOr[Int]
    var Name: js.UndefOr[InstanceStateName]
  }

  object InstanceState {
    @inline
    def apply(
        Code: js.UndefOr[Int] = js.undefined,
        Name: js.UndefOr[InstanceStateName] = js.undefined
    ): InstanceState = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceState]
    }
  }

  /**
    * Describes an instance state change.
    */
  @js.native
  trait InstanceStateChange extends js.Object {
    var CurrentState: js.UndefOr[InstanceState]
    var InstanceId: js.UndefOr[String]
    var PreviousState: js.UndefOr[InstanceState]
  }

  object InstanceStateChange {
    @inline
    def apply(
        CurrentState: js.UndefOr[InstanceState] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        PreviousState: js.UndefOr[InstanceState] = js.undefined
    ): InstanceStateChange = {
      val __obj = js.Dynamic.literal()
      CurrentState.foreach(__v => __obj.updateDynamic("CurrentState")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      PreviousState.foreach(__v => __obj.updateDynamic("PreviousState")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceStateChange]
    }
  }

  object InstanceStateNameEnum {
    val pending         = "pending"
    val running         = "running"
    val `shutting-down` = "shutting-down"
    val terminated      = "terminated"
    val stopping        = "stopping"
    val stopped         = "stopped"

    val values = js.Object.freeze(js.Array(pending, running, `shutting-down`, terminated, stopping, stopped))
  }

  /**
    * Describes the status of an instance.
    */
  @js.native
  trait InstanceStatus extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var Events: js.UndefOr[InstanceStatusEventList]
    var InstanceId: js.UndefOr[String]
    var InstanceState: js.UndefOr[InstanceState]
    var InstanceStatus: js.UndefOr[InstanceStatusSummary]
    var SystemStatus: js.UndefOr[InstanceStatusSummary]
  }

  object InstanceStatus {
    @inline
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        Events: js.UndefOr[InstanceStatusEventList] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        InstanceState: js.UndefOr[InstanceState] = js.undefined,
        InstanceStatus: js.UndefOr[InstanceStatusSummary] = js.undefined,
        SystemStatus: js.UndefOr[InstanceStatusSummary] = js.undefined
    ): InstanceStatus = {
      val __obj = js.Dynamic.literal()
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      Events.foreach(__v => __obj.updateDynamic("Events")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      InstanceState.foreach(__v => __obj.updateDynamic("InstanceState")(__v.asInstanceOf[js.Any]))
      InstanceStatus.foreach(__v => __obj.updateDynamic("InstanceStatus")(__v.asInstanceOf[js.Any]))
      SystemStatus.foreach(__v => __obj.updateDynamic("SystemStatus")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceStatus]
    }
  }

  /**
    * Describes the instance status.
    */
  @js.native
  trait InstanceStatusDetails extends js.Object {
    var ImpairedSince: js.UndefOr[DateTime]
    var Name: js.UndefOr[StatusName]
    var Status: js.UndefOr[StatusType]
  }

  object InstanceStatusDetails {
    @inline
    def apply(
        ImpairedSince: js.UndefOr[DateTime] = js.undefined,
        Name: js.UndefOr[StatusName] = js.undefined,
        Status: js.UndefOr[StatusType] = js.undefined
    ): InstanceStatusDetails = {
      val __obj = js.Dynamic.literal()
      ImpairedSince.foreach(__v => __obj.updateDynamic("ImpairedSince")(__v.asInstanceOf[js.Any]))
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceStatusDetails]
    }
  }

  /**
    * Describes a scheduled event for an instance.
    */
  @js.native
  trait InstanceStatusEvent extends js.Object {
    var Code: js.UndefOr[EventCode]
    var Description: js.UndefOr[String]
    var InstanceEventId: js.UndefOr[InstanceEventId]
    var NotAfter: js.UndefOr[DateTime]
    var NotBefore: js.UndefOr[DateTime]
    var NotBeforeDeadline: js.UndefOr[DateTime]
  }

  object InstanceStatusEvent {
    @inline
    def apply(
        Code: js.UndefOr[EventCode] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        InstanceEventId: js.UndefOr[InstanceEventId] = js.undefined,
        NotAfter: js.UndefOr[DateTime] = js.undefined,
        NotBefore: js.UndefOr[DateTime] = js.undefined,
        NotBeforeDeadline: js.UndefOr[DateTime] = js.undefined
    ): InstanceStatusEvent = {
      val __obj = js.Dynamic.literal()
      Code.foreach(__v => __obj.updateDynamic("Code")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      InstanceEventId.foreach(__v => __obj.updateDynamic("InstanceEventId")(__v.asInstanceOf[js.Any]))
      NotAfter.foreach(__v => __obj.updateDynamic("NotAfter")(__v.asInstanceOf[js.Any]))
      NotBefore.foreach(__v => __obj.updateDynamic("NotBefore")(__v.asInstanceOf[js.Any]))
      NotBeforeDeadline.foreach(__v => __obj.updateDynamic("NotBeforeDeadline")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceStatusEvent]
    }
  }

  /**
    * Describes the status of an instance.
    */
  @js.native
  trait InstanceStatusSummary extends js.Object {
    var Details: js.UndefOr[InstanceStatusDetailsList]
    var Status: js.UndefOr[SummaryStatus]
  }

  object InstanceStatusSummary {
    @inline
    def apply(
        Details: js.UndefOr[InstanceStatusDetailsList] = js.undefined,
        Status: js.UndefOr[SummaryStatus] = js.undefined
    ): InstanceStatusSummary = {
      val __obj = js.Dynamic.literal()
      Details.foreach(__v => __obj.updateDynamic("Details")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceStatusSummary]
    }
  }

  object InstanceTypeEnum {
    val `t1.micro`      = "t1.micro"
    val `t2.nano`       = "t2.nano"
    val `t2.micro`      = "t2.micro"
    val `t2.small`      = "t2.small"
    val `t2.medium`     = "t2.medium"
    val `t2.large`      = "t2.large"
    val `t2.xlarge`     = "t2.xlarge"
    val `t2.2xlarge`    = "t2.2xlarge"
    val `t3.nano`       = "t3.nano"
    val `t3.micro`      = "t3.micro"
    val `t3.small`      = "t3.small"
    val `t3.medium`     = "t3.medium"
    val `t3.large`      = "t3.large"
    val `t3.xlarge`     = "t3.xlarge"
    val `t3.2xlarge`    = "t3.2xlarge"
    val `t3a.nano`      = "t3a.nano"
    val `t3a.micro`     = "t3a.micro"
    val `t3a.small`     = "t3a.small"
    val `t3a.medium`    = "t3a.medium"
    val `t3a.large`     = "t3a.large"
    val `t3a.xlarge`    = "t3a.xlarge"
    val `t3a.2xlarge`   = "t3a.2xlarge"
    val `m1.small`      = "m1.small"
    val `m1.medium`     = "m1.medium"
    val `m1.large`      = "m1.large"
    val `m1.xlarge`     = "m1.xlarge"
    val `m3.medium`     = "m3.medium"
    val `m3.large`      = "m3.large"
    val `m3.xlarge`     = "m3.xlarge"
    val `m3.2xlarge`    = "m3.2xlarge"
    val `m4.large`      = "m4.large"
    val `m4.xlarge`     = "m4.xlarge"
    val `m4.2xlarge`    = "m4.2xlarge"
    val `m4.4xlarge`    = "m4.4xlarge"
    val `m4.10xlarge`   = "m4.10xlarge"
    val `m4.16xlarge`   = "m4.16xlarge"
    val `m2.xlarge`     = "m2.xlarge"
    val `m2.2xlarge`    = "m2.2xlarge"
    val `m2.4xlarge`    = "m2.4xlarge"
    val `cr1.8xlarge`   = "cr1.8xlarge"
    val `r3.large`      = "r3.large"
    val `r3.xlarge`     = "r3.xlarge"
    val `r3.2xlarge`    = "r3.2xlarge"
    val `r3.4xlarge`    = "r3.4xlarge"
    val `r3.8xlarge`    = "r3.8xlarge"
    val `r4.large`      = "r4.large"
    val `r4.xlarge`     = "r4.xlarge"
    val `r4.2xlarge`    = "r4.2xlarge"
    val `r4.4xlarge`    = "r4.4xlarge"
    val `r4.8xlarge`    = "r4.8xlarge"
    val `r4.16xlarge`   = "r4.16xlarge"
    val `r5.large`      = "r5.large"
    val `r5.xlarge`     = "r5.xlarge"
    val `r5.2xlarge`    = "r5.2xlarge"
    val `r5.4xlarge`    = "r5.4xlarge"
    val `r5.8xlarge`    = "r5.8xlarge"
    val `r5.12xlarge`   = "r5.12xlarge"
    val `r5.16xlarge`   = "r5.16xlarge"
    val `r5.24xlarge`   = "r5.24xlarge"
    val `r5.metal`      = "r5.metal"
    val `r5a.large`     = "r5a.large"
    val `r5a.xlarge`    = "r5a.xlarge"
    val `r5a.2xlarge`   = "r5a.2xlarge"
    val `r5a.4xlarge`   = "r5a.4xlarge"
    val `r5a.8xlarge`   = "r5a.8xlarge"
    val `r5a.12xlarge`  = "r5a.12xlarge"
    val `r5a.16xlarge`  = "r5a.16xlarge"
    val `r5a.24xlarge`  = "r5a.24xlarge"
    val `r5d.large`     = "r5d.large"
    val `r5d.xlarge`    = "r5d.xlarge"
    val `r5d.2xlarge`   = "r5d.2xlarge"
    val `r5d.4xlarge`   = "r5d.4xlarge"
    val `r5d.8xlarge`   = "r5d.8xlarge"
    val `r5d.12xlarge`  = "r5d.12xlarge"
    val `r5d.16xlarge`  = "r5d.16xlarge"
    val `r5d.24xlarge`  = "r5d.24xlarge"
    val `r5d.metal`     = "r5d.metal"
    val `r5ad.large`    = "r5ad.large"
    val `r5ad.xlarge`   = "r5ad.xlarge"
    val `r5ad.2xlarge`  = "r5ad.2xlarge"
    val `r5ad.4xlarge`  = "r5ad.4xlarge"
    val `r5ad.8xlarge`  = "r5ad.8xlarge"
    val `r5ad.12xlarge` = "r5ad.12xlarge"
    val `r5ad.16xlarge` = "r5ad.16xlarge"
    val `r5ad.24xlarge` = "r5ad.24xlarge"
    val `x1.16xlarge`   = "x1.16xlarge"
    val `x1.32xlarge`   = "x1.32xlarge"
    val `x1e.xlarge`    = "x1e.xlarge"
    val `x1e.2xlarge`   = "x1e.2xlarge"
    val `x1e.4xlarge`   = "x1e.4xlarge"
    val `x1e.8xlarge`   = "x1e.8xlarge"
    val `x1e.16xlarge`  = "x1e.16xlarge"
    val `x1e.32xlarge`  = "x1e.32xlarge"
    val `i2.xlarge`     = "i2.xlarge"
    val `i2.2xlarge`    = "i2.2xlarge"
    val `i2.4xlarge`    = "i2.4xlarge"
    val `i2.8xlarge`    = "i2.8xlarge"
    val `i3.large`      = "i3.large"
    val `i3.xlarge`     = "i3.xlarge"
    val `i3.2xlarge`    = "i3.2xlarge"
    val `i3.4xlarge`    = "i3.4xlarge"
    val `i3.8xlarge`    = "i3.8xlarge"
    val `i3.16xlarge`   = "i3.16xlarge"
    val `i3.metal`      = "i3.metal"
    val `i3en.large`    = "i3en.large"
    val `i3en.xlarge`   = "i3en.xlarge"
    val `i3en.2xlarge`  = "i3en.2xlarge"
    val `i3en.3xlarge`  = "i3en.3xlarge"
    val `i3en.6xlarge`  = "i3en.6xlarge"
    val `i3en.12xlarge` = "i3en.12xlarge"
    val `i3en.24xlarge` = "i3en.24xlarge"
    val `i3en.metal`    = "i3en.metal"
    val `hi1.4xlarge`   = "hi1.4xlarge"
    val `hs1.8xlarge`   = "hs1.8xlarge"
    val `c1.medium`     = "c1.medium"
    val `c1.xlarge`     = "c1.xlarge"
    val `c3.large`      = "c3.large"
    val `c3.xlarge`     = "c3.xlarge"
    val `c3.2xlarge`    = "c3.2xlarge"
    val `c3.4xlarge`    = "c3.4xlarge"
    val `c3.8xlarge`    = "c3.8xlarge"
    val `c4.large`      = "c4.large"
    val `c4.xlarge`     = "c4.xlarge"
    val `c4.2xlarge`    = "c4.2xlarge"
    val `c4.4xlarge`    = "c4.4xlarge"
    val `c4.8xlarge`    = "c4.8xlarge"
    val `c5.large`      = "c5.large"
    val `c5.xlarge`     = "c5.xlarge"
    val `c5.2xlarge`    = "c5.2xlarge"
    val `c5.4xlarge`    = "c5.4xlarge"
    val `c5.9xlarge`    = "c5.9xlarge"
    val `c5.12xlarge`   = "c5.12xlarge"
    val `c5.18xlarge`   = "c5.18xlarge"
    val `c5.24xlarge`   = "c5.24xlarge"
    val `c5.metal`      = "c5.metal"
    val `c5d.large`     = "c5d.large"
    val `c5d.xlarge`    = "c5d.xlarge"
    val `c5d.2xlarge`   = "c5d.2xlarge"
    val `c5d.4xlarge`   = "c5d.4xlarge"
    val `c5d.9xlarge`   = "c5d.9xlarge"
    val `c5d.18xlarge`  = "c5d.18xlarge"
    val `c5n.large`     = "c5n.large"
    val `c5n.xlarge`    = "c5n.xlarge"
    val `c5n.2xlarge`   = "c5n.2xlarge"
    val `c5n.4xlarge`   = "c5n.4xlarge"
    val `c5n.9xlarge`   = "c5n.9xlarge"
    val `c5n.18xlarge`  = "c5n.18xlarge"
    val `cc1.4xlarge`   = "cc1.4xlarge"
    val `cc2.8xlarge`   = "cc2.8xlarge"
    val `g2.2xlarge`    = "g2.2xlarge"
    val `g2.8xlarge`    = "g2.8xlarge"
    val `g3.4xlarge`    = "g3.4xlarge"
    val `g3.8xlarge`    = "g3.8xlarge"
    val `g3.16xlarge`   = "g3.16xlarge"
    val `g3s.xlarge`    = "g3s.xlarge"
    val `cg1.4xlarge`   = "cg1.4xlarge"
    val `p2.xlarge`     = "p2.xlarge"
    val `p2.8xlarge`    = "p2.8xlarge"
    val `p2.16xlarge`   = "p2.16xlarge"
    val `p3.2xlarge`    = "p3.2xlarge"
    val `p3.8xlarge`    = "p3.8xlarge"
    val `p3.16xlarge`   = "p3.16xlarge"
    val `p3dn.24xlarge` = "p3dn.24xlarge"
    val `d2.xlarge`     = "d2.xlarge"
    val `d2.2xlarge`    = "d2.2xlarge"
    val `d2.4xlarge`    = "d2.4xlarge"
    val `d2.8xlarge`    = "d2.8xlarge"
    val `f1.2xlarge`    = "f1.2xlarge"
    val `f1.4xlarge`    = "f1.4xlarge"
    val `f1.16xlarge`   = "f1.16xlarge"
    val `m5.large`      = "m5.large"
    val `m5.xlarge`     = "m5.xlarge"
    val `m5.2xlarge`    = "m5.2xlarge"
    val `m5.4xlarge`    = "m5.4xlarge"
    val `m5.8xlarge`    = "m5.8xlarge"
    val `m5.12xlarge`   = "m5.12xlarge"
    val `m5.16xlarge`   = "m5.16xlarge"
    val `m5.24xlarge`   = "m5.24xlarge"
    val `m5.metal`      = "m5.metal"
    val `m5a.large`     = "m5a.large"
    val `m5a.xlarge`    = "m5a.xlarge"
    val `m5a.2xlarge`   = "m5a.2xlarge"
    val `m5a.4xlarge`   = "m5a.4xlarge"
    val `m5a.8xlarge`   = "m5a.8xlarge"
    val `m5a.12xlarge`  = "m5a.12xlarge"
    val `m5a.16xlarge`  = "m5a.16xlarge"
    val `m5a.24xlarge`  = "m5a.24xlarge"
    val `m5d.large`     = "m5d.large"
    val `m5d.xlarge`    = "m5d.xlarge"
    val `m5d.2xlarge`   = "m5d.2xlarge"
    val `m5d.4xlarge`   = "m5d.4xlarge"
    val `m5d.8xlarge`   = "m5d.8xlarge"
    val `m5d.12xlarge`  = "m5d.12xlarge"
    val `m5d.16xlarge`  = "m5d.16xlarge"
    val `m5d.24xlarge`  = "m5d.24xlarge"
    val `m5d.metal`     = "m5d.metal"
    val `m5ad.large`    = "m5ad.large"
    val `m5ad.xlarge`   = "m5ad.xlarge"
    val `m5ad.2xlarge`  = "m5ad.2xlarge"
    val `m5ad.4xlarge`  = "m5ad.4xlarge"
    val `m5ad.8xlarge`  = "m5ad.8xlarge"
    val `m5ad.12xlarge` = "m5ad.12xlarge"
    val `m5ad.16xlarge` = "m5ad.16xlarge"
    val `m5ad.24xlarge` = "m5ad.24xlarge"
    val `h1.2xlarge`    = "h1.2xlarge"
    val `h1.4xlarge`    = "h1.4xlarge"
    val `h1.8xlarge`    = "h1.8xlarge"
    val `h1.16xlarge`   = "h1.16xlarge"
    val `z1d.large`     = "z1d.large"
    val `z1d.xlarge`    = "z1d.xlarge"
    val `z1d.2xlarge`   = "z1d.2xlarge"
    val `z1d.3xlarge`   = "z1d.3xlarge"
    val `z1d.6xlarge`   = "z1d.6xlarge"
    val `z1d.12xlarge`  = "z1d.12xlarge"
    val `z1d.metal`     = "z1d.metal"
    val `u-6tb1.metal`  = "u-6tb1.metal"
    val `u-9tb1.metal`  = "u-9tb1.metal"
    val `u-12tb1.metal` = "u-12tb1.metal"
    val `a1.medium`     = "a1.medium"
    val `a1.large`      = "a1.large"
    val `a1.xlarge`     = "a1.xlarge"
    val `a1.2xlarge`    = "a1.2xlarge"
    val `a1.4xlarge`    = "a1.4xlarge"

    val values = js.Object.freeze(
      js.Array(
        `t1.micro`,
        `t2.nano`,
        `t2.micro`,
        `t2.small`,
        `t2.medium`,
        `t2.large`,
        `t2.xlarge`,
        `t2.2xlarge`,
        `t3.nano`,
        `t3.micro`,
        `t3.small`,
        `t3.medium`,
        `t3.large`,
        `t3.xlarge`,
        `t3.2xlarge`,
        `t3a.nano`,
        `t3a.micro`,
        `t3a.small`,
        `t3a.medium`,
        `t3a.large`,
        `t3a.xlarge`,
        `t3a.2xlarge`,
        `m1.small`,
        `m1.medium`,
        `m1.large`,
        `m1.xlarge`,
        `m3.medium`,
        `m3.large`,
        `m3.xlarge`,
        `m3.2xlarge`,
        `m4.large`,
        `m4.xlarge`,
        `m4.2xlarge`,
        `m4.4xlarge`,
        `m4.10xlarge`,
        `m4.16xlarge`,
        `m2.xlarge`,
        `m2.2xlarge`,
        `m2.4xlarge`,
        `cr1.8xlarge`,
        `r3.large`,
        `r3.xlarge`,
        `r3.2xlarge`,
        `r3.4xlarge`,
        `r3.8xlarge`,
        `r4.large`,
        `r4.xlarge`,
        `r4.2xlarge`,
        `r4.4xlarge`,
        `r4.8xlarge`,
        `r4.16xlarge`,
        `r5.large`,
        `r5.xlarge`,
        `r5.2xlarge`,
        `r5.4xlarge`,
        `r5.8xlarge`,
        `r5.12xlarge`,
        `r5.16xlarge`,
        `r5.24xlarge`,
        `r5.metal`,
        `r5a.large`,
        `r5a.xlarge`,
        `r5a.2xlarge`,
        `r5a.4xlarge`,
        `r5a.8xlarge`,
        `r5a.12xlarge`,
        `r5a.16xlarge`,
        `r5a.24xlarge`,
        `r5d.large`,
        `r5d.xlarge`,
        `r5d.2xlarge`,
        `r5d.4xlarge`,
        `r5d.8xlarge`,
        `r5d.12xlarge`,
        `r5d.16xlarge`,
        `r5d.24xlarge`,
        `r5d.metal`,
        `r5ad.large`,
        `r5ad.xlarge`,
        `r5ad.2xlarge`,
        `r5ad.4xlarge`,
        `r5ad.8xlarge`,
        `r5ad.12xlarge`,
        `r5ad.16xlarge`,
        `r5ad.24xlarge`,
        `x1.16xlarge`,
        `x1.32xlarge`,
        `x1e.xlarge`,
        `x1e.2xlarge`,
        `x1e.4xlarge`,
        `x1e.8xlarge`,
        `x1e.16xlarge`,
        `x1e.32xlarge`,
        `i2.xlarge`,
        `i2.2xlarge`,
        `i2.4xlarge`,
        `i2.8xlarge`,
        `i3.large`,
        `i3.xlarge`,
        `i3.2xlarge`,
        `i3.4xlarge`,
        `i3.8xlarge`,
        `i3.16xlarge`,
        `i3.metal`,
        `i3en.large`,
        `i3en.xlarge`,
        `i3en.2xlarge`,
        `i3en.3xlarge`,
        `i3en.6xlarge`,
        `i3en.12xlarge`,
        `i3en.24xlarge`,
        `i3en.metal`,
        `hi1.4xlarge`,
        `hs1.8xlarge`,
        `c1.medium`,
        `c1.xlarge`,
        `c3.large`,
        `c3.xlarge`,
        `c3.2xlarge`,
        `c3.4xlarge`,
        `c3.8xlarge`,
        `c4.large`,
        `c4.xlarge`,
        `c4.2xlarge`,
        `c4.4xlarge`,
        `c4.8xlarge`,
        `c5.large`,
        `c5.xlarge`,
        `c5.2xlarge`,
        `c5.4xlarge`,
        `c5.9xlarge`,
        `c5.12xlarge`,
        `c5.18xlarge`,
        `c5.24xlarge`,
        `c5.metal`,
        `c5d.large`,
        `c5d.xlarge`,
        `c5d.2xlarge`,
        `c5d.4xlarge`,
        `c5d.9xlarge`,
        `c5d.18xlarge`,
        `c5n.large`,
        `c5n.xlarge`,
        `c5n.2xlarge`,
        `c5n.4xlarge`,
        `c5n.9xlarge`,
        `c5n.18xlarge`,
        `cc1.4xlarge`,
        `cc2.8xlarge`,
        `g2.2xlarge`,
        `g2.8xlarge`,
        `g3.4xlarge`,
        `g3.8xlarge`,
        `g3.16xlarge`,
        `g3s.xlarge`,
        `cg1.4xlarge`,
        `p2.xlarge`,
        `p2.8xlarge`,
        `p2.16xlarge`,
        `p3.2xlarge`,
        `p3.8xlarge`,
        `p3.16xlarge`,
        `p3dn.24xlarge`,
        `d2.xlarge`,
        `d2.2xlarge`,
        `d2.4xlarge`,
        `d2.8xlarge`,
        `f1.2xlarge`,
        `f1.4xlarge`,
        `f1.16xlarge`,
        `m5.large`,
        `m5.xlarge`,
        `m5.2xlarge`,
        `m5.4xlarge`,
        `m5.8xlarge`,
        `m5.12xlarge`,
        `m5.16xlarge`,
        `m5.24xlarge`,
        `m5.metal`,
        `m5a.large`,
        `m5a.xlarge`,
        `m5a.2xlarge`,
        `m5a.4xlarge`,
        `m5a.8xlarge`,
        `m5a.12xlarge`,
        `m5a.16xlarge`,
        `m5a.24xlarge`,
        `m5d.large`,
        `m5d.xlarge`,
        `m5d.2xlarge`,
        `m5d.4xlarge`,
        `m5d.8xlarge`,
        `m5d.12xlarge`,
        `m5d.16xlarge`,
        `m5d.24xlarge`,
        `m5d.metal`,
        `m5ad.large`,
        `m5ad.xlarge`,
        `m5ad.2xlarge`,
        `m5ad.4xlarge`,
        `m5ad.8xlarge`,
        `m5ad.12xlarge`,
        `m5ad.16xlarge`,
        `m5ad.24xlarge`,
        `h1.2xlarge`,
        `h1.4xlarge`,
        `h1.8xlarge`,
        `h1.16xlarge`,
        `z1d.large`,
        `z1d.xlarge`,
        `z1d.2xlarge`,
        `z1d.3xlarge`,
        `z1d.6xlarge`,
        `z1d.12xlarge`,
        `z1d.metal`,
        `u-6tb1.metal`,
        `u-9tb1.metal`,
        `u-12tb1.metal`,
        `a1.medium`,
        `a1.large`,
        `a1.xlarge`,
        `a1.2xlarge`,
        `a1.4xlarge`
      )
    )
  }

  /**
    * Information about the Capacity Reservation usage.
    */
  @js.native
  trait InstanceUsage extends js.Object {
    var AccountId: js.UndefOr[String]
    var UsedInstanceCount: js.UndefOr[Int]
  }

  object InstanceUsage {
    @inline
    def apply(
        AccountId: js.UndefOr[String] = js.undefined,
        UsedInstanceCount: js.UndefOr[Int] = js.undefined
    ): InstanceUsage = {
      val __obj = js.Dynamic.literal()
      AccountId.foreach(__v => __obj.updateDynamic("AccountId")(__v.asInstanceOf[js.Any]))
      UsedInstanceCount.foreach(__v => __obj.updateDynamic("UsedInstanceCount")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InstanceUsage]
    }
  }

  object InterfacePermissionTypeEnum {
    val `INSTANCE-ATTACH` = "INSTANCE-ATTACH"
    val `EIP-ASSOCIATE`   = "EIP-ASSOCIATE"

    val values = js.Object.freeze(js.Array(`INSTANCE-ATTACH`, `EIP-ASSOCIATE`))
  }

  /**
    * Describes an internet gateway.
    */
  @js.native
  trait InternetGateway extends js.Object {
    var Attachments: js.UndefOr[InternetGatewayAttachmentList]
    var InternetGatewayId: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
  }

  object InternetGateway {
    @inline
    def apply(
        Attachments: js.UndefOr[InternetGatewayAttachmentList] = js.undefined,
        InternetGatewayId: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): InternetGateway = {
      val __obj = js.Dynamic.literal()
      Attachments.foreach(__v => __obj.updateDynamic("Attachments")(__v.asInstanceOf[js.Any]))
      InternetGatewayId.foreach(__v => __obj.updateDynamic("InternetGatewayId")(__v.asInstanceOf[js.Any]))
      OwnerId.foreach(__v => __obj.updateDynamic("OwnerId")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InternetGateway]
    }
  }

  /**
    * Describes the attachment of a VPC to an internet gateway or an egress-only internet gateway.
    */
  @js.native
  trait InternetGatewayAttachment extends js.Object {
    var State: js.UndefOr[AttachmentStatus]
    var VpcId: js.UndefOr[String]
  }

  object InternetGatewayAttachment {
    @inline
    def apply(
        State: js.UndefOr[AttachmentStatus] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): InternetGatewayAttachment = {
      val __obj = js.Dynamic.literal()
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[InternetGatewayAttachment]
    }
  }

  /**
    * Describes a set of permissions for a security group rule.
    */
  @js.native
  trait IpPermission extends js.Object {
    var FromPort: js.UndefOr[Int]
    var IpProtocol: js.UndefOr[String]
    var IpRanges: js.UndefOr[IpRangeList]
    var Ipv6Ranges: js.UndefOr[Ipv6RangeList]
    var PrefixListIds: js.UndefOr[PrefixListIdList]
    var ToPort: js.UndefOr[Int]
    var UserIdGroupPairs: js.UndefOr[UserIdGroupPairList]
  }

  object IpPermission {
    @inline
    def apply(
        FromPort: js.UndefOr[Int] = js.undefined,
        IpProtocol: js.UndefOr[String] = js.undefined,
        IpRanges: js.UndefOr[IpRangeList] = js.undefined,
        Ipv6Ranges: js.UndefOr[Ipv6RangeList] = js.undefined,
        PrefixListIds: js.UndefOr[PrefixListIdList] = js.undefined,
        ToPort: js.UndefOr[Int] = js.undefined,
        UserIdGroupPairs: js.UndefOr[UserIdGroupPairList] = js.undefined
    ): IpPermission = {
      val __obj = js.Dynamic.literal()
      FromPort.foreach(__v => __obj.updateDynamic("FromPort")(__v.asInstanceOf[js.Any]))
      IpProtocol.foreach(__v => __obj.updateDynamic("IpProtocol")(__v.asInstanceOf[js.Any]))
      IpRanges.foreach(__v => __obj.updateDynamic("IpRanges")(__v.asInstanceOf[js.Any]))
      Ipv6Ranges.foreach(__v => __obj.updateDynamic("Ipv6Ranges")(__v.asInstanceOf[js.Any]))
      PrefixListIds.foreach(__v => __obj.updateDynamic("PrefixListIds")(__v.asInstanceOf[js.Any]))
      ToPort.foreach(__v => __obj.updateDynamic("ToPort")(__v.asInstanceOf[js.Any]))
      UserIdGroupPairs.foreach(__v => __obj.updateDynamic("UserIdGroupPairs")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[IpPermission]
    }
  }

  /**
    * Describes an IPv4 range.
    */
  @js.native
  trait IpRange extends js.Object {
    var CidrIp: js.UndefOr[String]
    var Description: js.UndefOr[String]
  }

  object IpRange {
    @inline
    def apply(
        CidrIp: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined
    ): IpRange = {
      val __obj = js.Dynamic.literal()
      CidrIp.foreach(__v => __obj.updateDynamic("CidrIp")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[IpRange]
    }
  }

  /**
    * Describes an IPv6 CIDR block.
    */
  @js.native
  trait Ipv6CidrBlock extends js.Object {
    var Ipv6CidrBlock: js.UndefOr[String]
  }

  object Ipv6CidrBlock {
    @inline
    def apply(
        Ipv6CidrBlock: js.UndefOr[String] = js.undefined
    ): Ipv6CidrBlock = {
      val __obj = js.Dynamic.literal()
      Ipv6CidrBlock.foreach(__v => __obj.updateDynamic("Ipv6CidrBlock")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[Ipv6CidrBlock]
    }
  }

  /**
    * [EC2-VPC only] Describes an IPv6 range.
    */
  @js.native
  trait Ipv6Range extends js.Object {
    var CidrIpv6: js.UndefOr[String]
    var Description: js.UndefOr[String]
  }

  object Ipv6Range {
    @inline
    def apply(
        CidrIpv6: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined
    ): Ipv6Range = {
      val __obj = js.Dynamic.literal()
      CidrIpv6.foreach(__v => __obj.updateDynamic("CidrIpv6")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[Ipv6Range]
    }
  }

  object Ipv6SupportValueEnum {
    val enable  = "enable"
    val disable = "disable"

    val values = js.Object.freeze(js.Array(enable, disable))
  }

  /**
    * Describes a key pair.
    */
  @js.native
  trait KeyPair extends js.Object {
    var KeyFingerprint: js.UndefOr[String]
    var KeyMaterial: js.UndefOr[String]
    var KeyName: js.UndefOr[String]
  }

  object KeyPair {
    @inline
    def apply(
        KeyFingerprint: js.UndefOr[String] = js.undefined,
        KeyMaterial: js.UndefOr[String] = js.undefined,
        KeyName: js.UndefOr[String] = js.undefined
    ): KeyPair = {
      val __obj = js.Dynamic.literal()
      KeyFingerprint.foreach(__v => __obj.updateDynamic("KeyFingerprint")(__v.asInstanceOf[js.Any]))
      KeyMaterial.foreach(__v => __obj.updateDynamic("KeyMaterial")(__v.asInstanceOf[js.Any]))
      KeyName.foreach(__v => __obj.updateDynamic("KeyName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[KeyPair]
    }
  }

  /**
    * Describes a key pair.
    */
  @js.native
  trait KeyPairInfo extends js.Object {
    var KeyFingerprint: js.UndefOr[String]
    var KeyName: js.UndefOr[String]
  }

  object KeyPairInfo {
    @inline
    def apply(
        KeyFingerprint: js.UndefOr[String] = js.undefined,
        KeyName: js.UndefOr[String] = js.undefined
    ): KeyPairInfo = {
      val __obj = js.Dynamic.literal()
      KeyFingerprint.foreach(__v => __obj.updateDynamic("KeyFingerprint")(__v.asInstanceOf[js.Any]))
      KeyName.foreach(__v => __obj.updateDynamic("KeyName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[KeyPairInfo]
    }
  }

  /**
    * Describes a launch permission.
    */
  @js.native
  trait LaunchPermission extends js.Object {
    var Group: js.UndefOr[PermissionGroup]
    var UserId: js.UndefOr[String]
  }

  object LaunchPermission {
    @inline
    def apply(
        Group: js.UndefOr[PermissionGroup] = js.undefined,
        UserId: js.UndefOr[String] = js.undefined
    ): LaunchPermission = {
      val __obj = js.Dynamic.literal()
      Group.foreach(__v => __obj.updateDynamic("Group")(__v.asInstanceOf[js.Any]))
      UserId.foreach(__v => __obj.updateDynamic("UserId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchPermission]
    }
  }

  /**
    * Describes a launch permission modification.
    */
  @js.native
  trait LaunchPermissionModifications extends js.Object {
    var Add: js.UndefOr[LaunchPermissionList]
    var Remove: js.UndefOr[LaunchPermissionList]
  }

  object LaunchPermissionModifications {
    @inline
    def apply(
        Add: js.UndefOr[LaunchPermissionList] = js.undefined,
        Remove: js.UndefOr[LaunchPermissionList] = js.undefined
    ): LaunchPermissionModifications = {
      val __obj = js.Dynamic.literal()
      Add.foreach(__v => __obj.updateDynamic("Add")(__v.asInstanceOf[js.Any]))
      Remove.foreach(__v => __obj.updateDynamic("Remove")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchPermissionModifications]
    }
  }

  /**
    * Describes the launch specification for an instance.
    */
  @js.native
  trait LaunchSpecification extends js.Object {
    var AddressingType: js.UndefOr[String]
    var BlockDeviceMappings: js.UndefOr[BlockDeviceMappingList]
    var EbsOptimized: js.UndefOr[Boolean]
    var IamInstanceProfile: js.UndefOr[IamInstanceProfileSpecification]
    var ImageId: js.UndefOr[String]
    var InstanceType: js.UndefOr[InstanceType]
    var KernelId: js.UndefOr[String]
    var KeyName: js.UndefOr[String]
    var Monitoring: js.UndefOr[RunInstancesMonitoringEnabled]
    var NetworkInterfaces: js.UndefOr[InstanceNetworkInterfaceSpecificationList]
    var Placement: js.UndefOr[SpotPlacement]
    var RamdiskId: js.UndefOr[String]
    var SecurityGroups: js.UndefOr[GroupIdentifierList]
    var SubnetId: js.UndefOr[String]
    var UserData: js.UndefOr[String]
  }

  object LaunchSpecification {
    @inline
    def apply(
        AddressingType: js.UndefOr[String] = js.undefined,
        BlockDeviceMappings: js.UndefOr[BlockDeviceMappingList] = js.undefined,
        EbsOptimized: js.UndefOr[Boolean] = js.undefined,
        IamInstanceProfile: js.UndefOr[IamInstanceProfileSpecification] = js.undefined,
        ImageId: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        KernelId: js.UndefOr[String] = js.undefined,
        KeyName: js.UndefOr[String] = js.undefined,
        Monitoring: js.UndefOr[RunInstancesMonitoringEnabled] = js.undefined,
        NetworkInterfaces: js.UndefOr[InstanceNetworkInterfaceSpecificationList] = js.undefined,
        Placement: js.UndefOr[SpotPlacement] = js.undefined,
        RamdiskId: js.UndefOr[String] = js.undefined,
        SecurityGroups: js.UndefOr[GroupIdentifierList] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        UserData: js.UndefOr[String] = js.undefined
    ): LaunchSpecification = {
      val __obj = js.Dynamic.literal()
      AddressingType.foreach(__v => __obj.updateDynamic("AddressingType")(__v.asInstanceOf[js.Any]))
      BlockDeviceMappings.foreach(__v => __obj.updateDynamic("BlockDeviceMappings")(__v.asInstanceOf[js.Any]))
      EbsOptimized.foreach(__v => __obj.updateDynamic("EbsOptimized")(__v.asInstanceOf[js.Any]))
      IamInstanceProfile.foreach(__v => __obj.updateDynamic("IamInstanceProfile")(__v.asInstanceOf[js.Any]))
      ImageId.foreach(__v => __obj.updateDynamic("ImageId")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      KernelId.foreach(__v => __obj.updateDynamic("KernelId")(__v.asInstanceOf[js.Any]))
      KeyName.foreach(__v => __obj.updateDynamic("KeyName")(__v.asInstanceOf[js.Any]))
      Monitoring.foreach(__v => __obj.updateDynamic("Monitoring")(__v.asInstanceOf[js.Any]))
      NetworkInterfaces.foreach(__v => __obj.updateDynamic("NetworkInterfaces")(__v.asInstanceOf[js.Any]))
      Placement.foreach(__v => __obj.updateDynamic("Placement")(__v.asInstanceOf[js.Any]))
      RamdiskId.foreach(__v => __obj.updateDynamic("RamdiskId")(__v.asInstanceOf[js.Any]))
      SecurityGroups.foreach(__v => __obj.updateDynamic("SecurityGroups")(__v.asInstanceOf[js.Any]))
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      UserData.foreach(__v => __obj.updateDynamic("UserData")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchSpecification]
    }
  }

  /**
    * Describes a launch template.
    */
  @js.native
  trait LaunchTemplate extends js.Object {
    var CreateTime: js.UndefOr[DateTime]
    var CreatedBy: js.UndefOr[String]
    var DefaultVersionNumber: js.UndefOr[Double]
    var LatestVersionNumber: js.UndefOr[Double]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
    var Tags: js.UndefOr[TagList]
  }

  object LaunchTemplate {
    @inline
    def apply(
        CreateTime: js.UndefOr[DateTime] = js.undefined,
        CreatedBy: js.UndefOr[String] = js.undefined,
        DefaultVersionNumber: js.UndefOr[Double] = js.undefined,
        LatestVersionNumber: js.UndefOr[Double] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): LaunchTemplate = {
      val __obj = js.Dynamic.literal()
      CreateTime.foreach(__v => __obj.updateDynamic("CreateTime")(__v.asInstanceOf[js.Any]))
      CreatedBy.foreach(__v => __obj.updateDynamic("CreatedBy")(__v.asInstanceOf[js.Any]))
      DefaultVersionNumber.foreach(__v => __obj.updateDynamic("DefaultVersionNumber")(__v.asInstanceOf[js.Any]))
      LatestVersionNumber.foreach(__v => __obj.updateDynamic("LatestVersionNumber")(__v.asInstanceOf[js.Any]))
      LaunchTemplateId.foreach(__v => __obj.updateDynamic("LaunchTemplateId")(__v.asInstanceOf[js.Any]))
      LaunchTemplateName.foreach(__v => __obj.updateDynamic("LaunchTemplateName")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplate]
    }
  }

  /**
    * Describes a launch template and overrides.
    */
  @js.native
  trait LaunchTemplateAndOverridesResponse extends js.Object {
    var LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecification]
    var Overrides: js.UndefOr[FleetLaunchTemplateOverrides]
  }

  object LaunchTemplateAndOverridesResponse {
    @inline
    def apply(
        LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecification] = js.undefined,
        Overrides: js.UndefOr[FleetLaunchTemplateOverrides] = js.undefined
    ): LaunchTemplateAndOverridesResponse = {
      val __obj = js.Dynamic.literal()
      LaunchTemplateSpecification.foreach(
        __v => __obj.updateDynamic("LaunchTemplateSpecification")(__v.asInstanceOf[js.Any])
      )
      Overrides.foreach(__v => __obj.updateDynamic("Overrides")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateAndOverridesResponse]
    }
  }

  /**
    * Describes a block device mapping.
    */
  @js.native
  trait LaunchTemplateBlockDeviceMapping extends js.Object {
    var DeviceName: js.UndefOr[String]
    var Ebs: js.UndefOr[LaunchTemplateEbsBlockDevice]
    var NoDevice: js.UndefOr[String]
    var VirtualName: js.UndefOr[String]
  }

  object LaunchTemplateBlockDeviceMapping {
    @inline
    def apply(
        DeviceName: js.UndefOr[String] = js.undefined,
        Ebs: js.UndefOr[LaunchTemplateEbsBlockDevice] = js.undefined,
        NoDevice: js.UndefOr[String] = js.undefined,
        VirtualName: js.UndefOr[String] = js.undefined
    ): LaunchTemplateBlockDeviceMapping = {
      val __obj = js.Dynamic.literal()
      DeviceName.foreach(__v => __obj.updateDynamic("DeviceName")(__v.asInstanceOf[js.Any]))
      Ebs.foreach(__v => __obj.updateDynamic("Ebs")(__v.asInstanceOf[js.Any]))
      NoDevice.foreach(__v => __obj.updateDynamic("NoDevice")(__v.asInstanceOf[js.Any]))
      VirtualName.foreach(__v => __obj.updateDynamic("VirtualName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateBlockDeviceMapping]
    }
  }

  /**
    * Describes a block device mapping.
    */
  @js.native
  trait LaunchTemplateBlockDeviceMappingRequest extends js.Object {
    var DeviceName: js.UndefOr[String]
    var Ebs: js.UndefOr[LaunchTemplateEbsBlockDeviceRequest]
    var NoDevice: js.UndefOr[String]
    var VirtualName: js.UndefOr[String]
  }

  object LaunchTemplateBlockDeviceMappingRequest {
    @inline
    def apply(
        DeviceName: js.UndefOr[String] = js.undefined,
        Ebs: js.UndefOr[LaunchTemplateEbsBlockDeviceRequest] = js.undefined,
        NoDevice: js.UndefOr[String] = js.undefined,
        VirtualName: js.UndefOr[String] = js.undefined
    ): LaunchTemplateBlockDeviceMappingRequest = {
      val __obj = js.Dynamic.literal()
      DeviceName.foreach(__v => __obj.updateDynamic("DeviceName")(__v.asInstanceOf[js.Any]))
      Ebs.foreach(__v => __obj.updateDynamic("Ebs")(__v.asInstanceOf[js.Any]))
      NoDevice.foreach(__v => __obj.updateDynamic("NoDevice")(__v.asInstanceOf[js.Any]))
      VirtualName.foreach(__v => __obj.updateDynamic("VirtualName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateBlockDeviceMappingRequest]
    }
  }

  /**
    * Describes an instance's Capacity Reservation targeting option. You can specify only one option at a time. Use the <code>CapacityReservationPreference</code> parameter to configure the instance to run in On-Demand capacity or to run in any <code>open</code> Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). Use the <code>CapacityReservationTarget</code> parameter to explicitly target a specific Capacity Reservation.
    */
  @js.native
  trait LaunchTemplateCapacityReservationSpecificationRequest extends js.Object {
    var CapacityReservationPreference: js.UndefOr[CapacityReservationPreference]
    var CapacityReservationTarget: js.UndefOr[CapacityReservationTarget]
  }

  object LaunchTemplateCapacityReservationSpecificationRequest {
    @inline
    def apply(
        CapacityReservationPreference: js.UndefOr[CapacityReservationPreference] = js.undefined,
        CapacityReservationTarget: js.UndefOr[CapacityReservationTarget] = js.undefined
    ): LaunchTemplateCapacityReservationSpecificationRequest = {
      val __obj = js.Dynamic.literal()
      CapacityReservationPreference.foreach(
        __v => __obj.updateDynamic("CapacityReservationPreference")(__v.asInstanceOf[js.Any])
      )
      CapacityReservationTarget.foreach(
        __v => __obj.updateDynamic("CapacityReservationTarget")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[LaunchTemplateCapacityReservationSpecificationRequest]
    }
  }

  /**
    * Information about the Capacity Reservation targeting option.
    */
  @js.native
  trait LaunchTemplateCapacityReservationSpecificationResponse extends js.Object {
    var CapacityReservationPreference: js.UndefOr[CapacityReservationPreference]
    var CapacityReservationTarget: js.UndefOr[CapacityReservationTargetResponse]
  }

  object LaunchTemplateCapacityReservationSpecificationResponse {
    @inline
    def apply(
        CapacityReservationPreference: js.UndefOr[CapacityReservationPreference] = js.undefined,
        CapacityReservationTarget: js.UndefOr[CapacityReservationTargetResponse] = js.undefined
    ): LaunchTemplateCapacityReservationSpecificationResponse = {
      val __obj = js.Dynamic.literal()
      CapacityReservationPreference.foreach(
        __v => __obj.updateDynamic("CapacityReservationPreference")(__v.asInstanceOf[js.Any])
      )
      CapacityReservationTarget.foreach(
        __v => __obj.updateDynamic("CapacityReservationTarget")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[LaunchTemplateCapacityReservationSpecificationResponse]
    }
  }

  /**
    * Describes a launch template and overrides.
    */
  @js.native
  trait LaunchTemplateConfig extends js.Object {
    var LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecification]
    var Overrides: js.UndefOr[LaunchTemplateOverridesList]
  }

  object LaunchTemplateConfig {
    @inline
    def apply(
        LaunchTemplateSpecification: js.UndefOr[FleetLaunchTemplateSpecification] = js.undefined,
        Overrides: js.UndefOr[LaunchTemplateOverridesList] = js.undefined
    ): LaunchTemplateConfig = {
      val __obj = js.Dynamic.literal()
      LaunchTemplateSpecification.foreach(
        __v => __obj.updateDynamic("LaunchTemplateSpecification")(__v.asInstanceOf[js.Any])
      )
      Overrides.foreach(__v => __obj.updateDynamic("Overrides")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateConfig]
    }
  }

  /**
    * The CPU options for the instance.
    */
  @js.native
  trait LaunchTemplateCpuOptions extends js.Object {
    var CoreCount: js.UndefOr[Int]
    var ThreadsPerCore: js.UndefOr[Int]
  }

  object LaunchTemplateCpuOptions {
    @inline
    def apply(
        CoreCount: js.UndefOr[Int] = js.undefined,
        ThreadsPerCore: js.UndefOr[Int] = js.undefined
    ): LaunchTemplateCpuOptions = {
      val __obj = js.Dynamic.literal()
      CoreCount.foreach(__v => __obj.updateDynamic("CoreCount")(__v.asInstanceOf[js.Any]))
      ThreadsPerCore.foreach(__v => __obj.updateDynamic("ThreadsPerCore")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateCpuOptions]
    }
  }

  /**
    * The CPU options for the instance. Both the core count and threads per core must be specified in the request.
    */
  @js.native
  trait LaunchTemplateCpuOptionsRequest extends js.Object {
    var CoreCount: js.UndefOr[Int]
    var ThreadsPerCore: js.UndefOr[Int]
  }

  object LaunchTemplateCpuOptionsRequest {
    @inline
    def apply(
        CoreCount: js.UndefOr[Int] = js.undefined,
        ThreadsPerCore: js.UndefOr[Int] = js.undefined
    ): LaunchTemplateCpuOptionsRequest = {
      val __obj = js.Dynamic.literal()
      CoreCount.foreach(__v => __obj.updateDynamic("CoreCount")(__v.asInstanceOf[js.Any]))
      ThreadsPerCore.foreach(__v => __obj.updateDynamic("ThreadsPerCore")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateCpuOptionsRequest]
    }
  }

  /**
    * Describes a block device for an EBS volume.
    */
  @js.native
  trait LaunchTemplateEbsBlockDevice extends js.Object {
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var Iops: js.UndefOr[Int]
    var KmsKeyId: js.UndefOr[String]
    var SnapshotId: js.UndefOr[String]
    var VolumeSize: js.UndefOr[Int]
    var VolumeType: js.UndefOr[VolumeType]
  }

  object LaunchTemplateEbsBlockDevice {
    @inline
    def apply(
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Iops: js.UndefOr[Int] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        SnapshotId: js.UndefOr[String] = js.undefined,
        VolumeSize: js.UndefOr[Int] = js.undefined,
        VolumeType: js.UndefOr[VolumeType] = js.undefined
    ): LaunchTemplateEbsBlockDevice = {
      val __obj = js.Dynamic.literal()
      DeleteOnTermination.foreach(__v => __obj.updateDynamic("DeleteOnTermination")(__v.asInstanceOf[js.Any]))
      Encrypted.foreach(__v => __obj.updateDynamic("Encrypted")(__v.asInstanceOf[js.Any]))
      Iops.foreach(__v => __obj.updateDynamic("Iops")(__v.asInstanceOf[js.Any]))
      KmsKeyId.foreach(__v => __obj.updateDynamic("KmsKeyId")(__v.asInstanceOf[js.Any]))
      SnapshotId.foreach(__v => __obj.updateDynamic("SnapshotId")(__v.asInstanceOf[js.Any]))
      VolumeSize.foreach(__v => __obj.updateDynamic("VolumeSize")(__v.asInstanceOf[js.Any]))
      VolumeType.foreach(__v => __obj.updateDynamic("VolumeType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateEbsBlockDevice]
    }
  }

  /**
    * The parameters for a block device for an EBS volume.
    */
  @js.native
  trait LaunchTemplateEbsBlockDeviceRequest extends js.Object {
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Encrypted: js.UndefOr[Boolean]
    var Iops: js.UndefOr[Int]
    var KmsKeyId: js.UndefOr[String]
    var SnapshotId: js.UndefOr[String]
    var VolumeSize: js.UndefOr[Int]
    var VolumeType: js.UndefOr[VolumeType]
  }

  object LaunchTemplateEbsBlockDeviceRequest {
    @inline
    def apply(
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Encrypted: js.UndefOr[Boolean] = js.undefined,
        Iops: js.UndefOr[Int] = js.undefined,
        KmsKeyId: js.UndefOr[String] = js.undefined,
        SnapshotId: js.UndefOr[String] = js.undefined,
        VolumeSize: js.UndefOr[Int] = js.undefined,
        VolumeType: js.UndefOr[VolumeType] = js.undefined
    ): LaunchTemplateEbsBlockDeviceRequest = {
      val __obj = js.Dynamic.literal()
      DeleteOnTermination.foreach(__v => __obj.updateDynamic("DeleteOnTermination")(__v.asInstanceOf[js.Any]))
      Encrypted.foreach(__v => __obj.updateDynamic("Encrypted")(__v.asInstanceOf[js.Any]))
      Iops.foreach(__v => __obj.updateDynamic("Iops")(__v.asInstanceOf[js.Any]))
      KmsKeyId.foreach(__v => __obj.updateDynamic("KmsKeyId")(__v.asInstanceOf[js.Any]))
      SnapshotId.foreach(__v => __obj.updateDynamic("SnapshotId")(__v.asInstanceOf[js.Any]))
      VolumeSize.foreach(__v => __obj.updateDynamic("VolumeSize")(__v.asInstanceOf[js.Any]))
      VolumeType.foreach(__v => __obj.updateDynamic("VolumeType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateEbsBlockDeviceRequest]
    }
  }

  /**
    * Describes an elastic inference accelerator.
    */
  @js.native
  trait LaunchTemplateElasticInferenceAccelerator extends js.Object {
    var Type: String
  }

  object LaunchTemplateElasticInferenceAccelerator {
    @inline
    def apply(
        Type: String
    ): LaunchTemplateElasticInferenceAccelerator = {
      val __obj = js.Dynamic.literal(
        "Type" -> Type.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[LaunchTemplateElasticInferenceAccelerator]
    }
  }

  /**
    * Describes an elastic inference accelerator.
    */
  @js.native
  trait LaunchTemplateElasticInferenceAcceleratorResponse extends js.Object {
    var Type: js.UndefOr[String]
  }

  object LaunchTemplateElasticInferenceAcceleratorResponse {
    @inline
    def apply(
        Type: js.UndefOr[String] = js.undefined
    ): LaunchTemplateElasticInferenceAcceleratorResponse = {
      val __obj = js.Dynamic.literal()
      Type.foreach(__v => __obj.updateDynamic("Type")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateElasticInferenceAcceleratorResponse]
    }
  }

  object LaunchTemplateErrorCodeEnum {
    val launchTemplateIdDoesNotExist      = "launchTemplateIdDoesNotExist"
    val launchTemplateIdMalformed         = "launchTemplateIdMalformed"
    val launchTemplateNameDoesNotExist    = "launchTemplateNameDoesNotExist"
    val launchTemplateNameMalformed       = "launchTemplateNameMalformed"
    val launchTemplateVersionDoesNotExist = "launchTemplateVersionDoesNotExist"
    val unexpectedError                   = "unexpectedError"

    val values = js.Object.freeze(
      js.Array(
        launchTemplateIdDoesNotExist,
        launchTemplateIdMalformed,
        launchTemplateNameDoesNotExist,
        launchTemplateNameMalformed,
        launchTemplateVersionDoesNotExist,
        unexpectedError
      )
    )
  }

  /**
    * Indicates whether an instance is configured for hibernation.
    */
  @js.native
  trait LaunchTemplateHibernationOptions extends js.Object {
    var Configured: js.UndefOr[Boolean]
  }

  object LaunchTemplateHibernationOptions {
    @inline
    def apply(
        Configured: js.UndefOr[Boolean] = js.undefined
    ): LaunchTemplateHibernationOptions = {
      val __obj = js.Dynamic.literal()
      Configured.foreach(__v => __obj.updateDynamic("Configured")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateHibernationOptions]
    }
  }

  /**
    * Indicates whether the instance is configured for hibernation. This parameter is valid only if the instance meets the [[https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Hibernate.html#hibernating-prerequisites|hibernation prerequisites]]. Hibernation is currently supported only for Amazon Linux.
    */
  @js.native
  trait LaunchTemplateHibernationOptionsRequest extends js.Object {
    var Configured: js.UndefOr[Boolean]
  }

  object LaunchTemplateHibernationOptionsRequest {
    @inline
    def apply(
        Configured: js.UndefOr[Boolean] = js.undefined
    ): LaunchTemplateHibernationOptionsRequest = {
      val __obj = js.Dynamic.literal()
      Configured.foreach(__v => __obj.updateDynamic("Configured")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateHibernationOptionsRequest]
    }
  }

  /**
    * Describes an IAM instance profile.
    */
  @js.native
  trait LaunchTemplateIamInstanceProfileSpecification extends js.Object {
    var Arn: js.UndefOr[String]
    var Name: js.UndefOr[String]
  }

  object LaunchTemplateIamInstanceProfileSpecification {
    @inline
    def apply(
        Arn: js.UndefOr[String] = js.undefined,
        Name: js.UndefOr[String] = js.undefined
    ): LaunchTemplateIamInstanceProfileSpecification = {
      val __obj = js.Dynamic.literal()
      Arn.foreach(__v => __obj.updateDynamic("Arn")(__v.asInstanceOf[js.Any]))
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateIamInstanceProfileSpecification]
    }
  }

  /**
    * An IAM instance profile.
    */
  @js.native
  trait LaunchTemplateIamInstanceProfileSpecificationRequest extends js.Object {
    var Arn: js.UndefOr[String]
    var Name: js.UndefOr[String]
  }

  object LaunchTemplateIamInstanceProfileSpecificationRequest {
    @inline
    def apply(
        Arn: js.UndefOr[String] = js.undefined,
        Name: js.UndefOr[String] = js.undefined
    ): LaunchTemplateIamInstanceProfileSpecificationRequest = {
      val __obj = js.Dynamic.literal()
      Arn.foreach(__v => __obj.updateDynamic("Arn")(__v.asInstanceOf[js.Any]))
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateIamInstanceProfileSpecificationRequest]
    }
  }

  /**
    * The market (purchasing) option for the instances.
    */
  @js.native
  trait LaunchTemplateInstanceMarketOptions extends js.Object {
    var MarketType: js.UndefOr[MarketType]
    var SpotOptions: js.UndefOr[LaunchTemplateSpotMarketOptions]
  }

  object LaunchTemplateInstanceMarketOptions {
    @inline
    def apply(
        MarketType: js.UndefOr[MarketType] = js.undefined,
        SpotOptions: js.UndefOr[LaunchTemplateSpotMarketOptions] = js.undefined
    ): LaunchTemplateInstanceMarketOptions = {
      val __obj = js.Dynamic.literal()
      MarketType.foreach(__v => __obj.updateDynamic("MarketType")(__v.asInstanceOf[js.Any]))
      SpotOptions.foreach(__v => __obj.updateDynamic("SpotOptions")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateInstanceMarketOptions]
    }
  }

  /**
    * The market (purchasing) option for the instances.
    */
  @js.native
  trait LaunchTemplateInstanceMarketOptionsRequest extends js.Object {
    var MarketType: js.UndefOr[MarketType]
    var SpotOptions: js.UndefOr[LaunchTemplateSpotMarketOptionsRequest]
  }

  object LaunchTemplateInstanceMarketOptionsRequest {
    @inline
    def apply(
        MarketType: js.UndefOr[MarketType] = js.undefined,
        SpotOptions: js.UndefOr[LaunchTemplateSpotMarketOptionsRequest] = js.undefined
    ): LaunchTemplateInstanceMarketOptionsRequest = {
      val __obj = js.Dynamic.literal()
      MarketType.foreach(__v => __obj.updateDynamic("MarketType")(__v.asInstanceOf[js.Any]))
      SpotOptions.foreach(__v => __obj.updateDynamic("SpotOptions")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateInstanceMarketOptionsRequest]
    }
  }

  /**
    * Describes a network interface.
    */
  @js.native
  trait LaunchTemplateInstanceNetworkInterfaceSpecification extends js.Object {
    var AssociatePublicIpAddress: js.UndefOr[Boolean]
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Description: js.UndefOr[String]
    var DeviceIndex: js.UndefOr[Int]
    var Groups: js.UndefOr[GroupIdStringList]
    var InterfaceType: js.UndefOr[String]
    var Ipv6AddressCount: js.UndefOr[Int]
    var Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList]
    var NetworkInterfaceId: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList]
    var SecondaryPrivateIpAddressCount: js.UndefOr[Int]
    var SubnetId: js.UndefOr[String]
  }

  object LaunchTemplateInstanceNetworkInterfaceSpecification {
    @inline
    def apply(
        AssociatePublicIpAddress: js.UndefOr[Boolean] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DeviceIndex: js.UndefOr[Int] = js.undefined,
        Groups: js.UndefOr[GroupIdStringList] = js.undefined,
        InterfaceType: js.UndefOr[String] = js.undefined,
        Ipv6AddressCount: js.UndefOr[Int] = js.undefined,
        Ipv6Addresses: js.UndefOr[InstanceIpv6AddressList] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList] = js.undefined,
        SecondaryPrivateIpAddressCount: js.UndefOr[Int] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined
    ): LaunchTemplateInstanceNetworkInterfaceSpecification = {
      val __obj = js.Dynamic.literal()
      AssociatePublicIpAddress.foreach(__v => __obj.updateDynamic("AssociatePublicIpAddress")(__v.asInstanceOf[js.Any]))
      DeleteOnTermination.foreach(__v => __obj.updateDynamic("DeleteOnTermination")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DeviceIndex.foreach(__v => __obj.updateDynamic("DeviceIndex")(__v.asInstanceOf[js.Any]))
      Groups.foreach(__v => __obj.updateDynamic("Groups")(__v.asInstanceOf[js.Any]))
      InterfaceType.foreach(__v => __obj.updateDynamic("InterfaceType")(__v.asInstanceOf[js.Any]))
      Ipv6AddressCount.foreach(__v => __obj.updateDynamic("Ipv6AddressCount")(__v.asInstanceOf[js.Any]))
      Ipv6Addresses.foreach(__v => __obj.updateDynamic("Ipv6Addresses")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      PrivateIpAddresses.foreach(__v => __obj.updateDynamic("PrivateIpAddresses")(__v.asInstanceOf[js.Any]))
      SecondaryPrivateIpAddressCount.foreach(
        __v => __obj.updateDynamic("SecondaryPrivateIpAddressCount")(__v.asInstanceOf[js.Any])
      )
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateInstanceNetworkInterfaceSpecification]
    }
  }

  /**
    * The parameters for a network interface.
    */
  @js.native
  trait LaunchTemplateInstanceNetworkInterfaceSpecificationRequest extends js.Object {
    var AssociatePublicIpAddress: js.UndefOr[Boolean]
    var DeleteOnTermination: js.UndefOr[Boolean]
    var Description: js.UndefOr[String]
    var DeviceIndex: js.UndefOr[Int]
    var Groups: js.UndefOr[SecurityGroupIdStringList]
    var InterfaceType: js.UndefOr[String]
    var Ipv6AddressCount: js.UndefOr[Int]
    var Ipv6Addresses: js.UndefOr[InstanceIpv6AddressListRequest]
    var NetworkInterfaceId: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList]
    var SecondaryPrivateIpAddressCount: js.UndefOr[Int]
    var SubnetId: js.UndefOr[String]
  }

  object LaunchTemplateInstanceNetworkInterfaceSpecificationRequest {
    @inline
    def apply(
        AssociatePublicIpAddress: js.UndefOr[Boolean] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DeviceIndex: js.UndefOr[Int] = js.undefined,
        Groups: js.UndefOr[SecurityGroupIdStringList] = js.undefined,
        InterfaceType: js.UndefOr[String] = js.undefined,
        Ipv6AddressCount: js.UndefOr[Int] = js.undefined,
        Ipv6Addresses: js.UndefOr[InstanceIpv6AddressListRequest] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PrivateIpAddresses: js.UndefOr[PrivateIpAddressSpecificationList] = js.undefined,
        SecondaryPrivateIpAddressCount: js.UndefOr[Int] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined
    ): LaunchTemplateInstanceNetworkInterfaceSpecificationRequest = {
      val __obj = js.Dynamic.literal()
      AssociatePublicIpAddress.foreach(__v => __obj.updateDynamic("AssociatePublicIpAddress")(__v.asInstanceOf[js.Any]))
      DeleteOnTermination.foreach(__v => __obj.updateDynamic("DeleteOnTermination")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DeviceIndex.foreach(__v => __obj.updateDynamic("DeviceIndex")(__v.asInstanceOf[js.Any]))
      Groups.foreach(__v => __obj.updateDynamic("Groups")(__v.asInstanceOf[js.Any]))
      InterfaceType.foreach(__v => __obj.updateDynamic("InterfaceType")(__v.asInstanceOf[js.Any]))
      Ipv6AddressCount.foreach(__v => __obj.updateDynamic("Ipv6AddressCount")(__v.asInstanceOf[js.Any]))
      Ipv6Addresses.foreach(__v => __obj.updateDynamic("Ipv6Addresses")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      PrivateIpAddresses.foreach(__v => __obj.updateDynamic("PrivateIpAddresses")(__v.asInstanceOf[js.Any]))
      SecondaryPrivateIpAddressCount.foreach(
        __v => __obj.updateDynamic("SecondaryPrivateIpAddressCount")(__v.asInstanceOf[js.Any])
      )
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateInstanceNetworkInterfaceSpecificationRequest]
    }
  }

  /**
    * Describes a license configuration.
    */
  @js.native
  trait LaunchTemplateLicenseConfiguration extends js.Object {
    var LicenseConfigurationArn: js.UndefOr[String]
  }

  object LaunchTemplateLicenseConfiguration {
    @inline
    def apply(
        LicenseConfigurationArn: js.UndefOr[String] = js.undefined
    ): LaunchTemplateLicenseConfiguration = {
      val __obj = js.Dynamic.literal()
      LicenseConfigurationArn.foreach(__v => __obj.updateDynamic("LicenseConfigurationArn")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateLicenseConfiguration]
    }
  }

  /**
    * Describes a license configuration.
    */
  @js.native
  trait LaunchTemplateLicenseConfigurationRequest extends js.Object {
    var LicenseConfigurationArn: js.UndefOr[String]
  }

  object LaunchTemplateLicenseConfigurationRequest {
    @inline
    def apply(
        LicenseConfigurationArn: js.UndefOr[String] = js.undefined
    ): LaunchTemplateLicenseConfigurationRequest = {
      val __obj = js.Dynamic.literal()
      LicenseConfigurationArn.foreach(__v => __obj.updateDynamic("LicenseConfigurationArn")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateLicenseConfigurationRequest]
    }
  }

  /**
    * Describes overrides for a launch template.
    */
  @js.native
  trait LaunchTemplateOverrides extends js.Object {
    var AvailabilityZone: js.UndefOr[String]
    var InstanceType: js.UndefOr[InstanceType]
    var Priority: js.UndefOr[Double]
    var SpotPrice: js.UndefOr[String]
    var SubnetId: js.UndefOr[String]
    var WeightedCapacity: js.UndefOr[Double]
  }

  object LaunchTemplateOverrides {
    @inline
    def apply(
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        InstanceType: js.UndefOr[InstanceType] = js.undefined,
        Priority: js.UndefOr[Double] = js.undefined,
        SpotPrice: js.UndefOr[String] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        WeightedCapacity: js.UndefOr[Double] = js.undefined
    ): LaunchTemplateOverrides = {
      val __obj = js.Dynamic.literal()
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      Priority.foreach(__v => __obj.updateDynamic("Priority")(__v.asInstanceOf[js.Any]))
      SpotPrice.foreach(__v => __obj.updateDynamic("SpotPrice")(__v.asInstanceOf[js.Any]))
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      WeightedCapacity.foreach(__v => __obj.updateDynamic("WeightedCapacity")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateOverrides]
    }
  }

  /**
    * Describes the placement of an instance.
    */
  @js.native
  trait LaunchTemplatePlacement extends js.Object {
    var Affinity: js.UndefOr[String]
    var AvailabilityZone: js.UndefOr[String]
    var GroupName: js.UndefOr[String]
    var HostId: js.UndefOr[String]
    var SpreadDomain: js.UndefOr[String]
    var Tenancy: js.UndefOr[Tenancy]
  }

  object LaunchTemplatePlacement {
    @inline
    def apply(
        Affinity: js.UndefOr[String] = js.undefined,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined,
        HostId: js.UndefOr[String] = js.undefined,
        SpreadDomain: js.UndefOr[String] = js.undefined,
        Tenancy: js.UndefOr[Tenancy] = js.undefined
    ): LaunchTemplatePlacement = {
      val __obj = js.Dynamic.literal()
      Affinity.foreach(__v => __obj.updateDynamic("Affinity")(__v.asInstanceOf[js.Any]))
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      GroupName.foreach(__v => __obj.updateDynamic("GroupName")(__v.asInstanceOf[js.Any]))
      HostId.foreach(__v => __obj.updateDynamic("HostId")(__v.asInstanceOf[js.Any]))
      SpreadDomain.foreach(__v => __obj.updateDynamic("SpreadDomain")(__v.asInstanceOf[js.Any]))
      Tenancy.foreach(__v => __obj.updateDynamic("Tenancy")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplatePlacement]
    }
  }

  /**
    * Describes the placement of an instance.
    */
  @js.native
  trait LaunchTemplatePlacementRequest extends js.Object {
    var Affinity: js.UndefOr[String]
    var AvailabilityZone: js.UndefOr[String]
    var GroupName: js.UndefOr[String]
    var HostId: js.UndefOr[String]
    var SpreadDomain: js.UndefOr[String]
    var Tenancy: js.UndefOr[Tenancy]
  }

  object LaunchTemplatePlacementRequest {
    @inline
    def apply(
        Affinity: js.UndefOr[String] = js.undefined,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined,
        HostId: js.UndefOr[String] = js.undefined,
        SpreadDomain: js.UndefOr[String] = js.undefined,
        Tenancy: js.UndefOr[Tenancy] = js.undefined
    ): LaunchTemplatePlacementRequest = {
      val __obj = js.Dynamic.literal()
      Affinity.foreach(__v => __obj.updateDynamic("Affinity")(__v.asInstanceOf[js.Any]))
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      GroupName.foreach(__v => __obj.updateDynamic("GroupName")(__v.asInstanceOf[js.Any]))
      HostId.foreach(__v => __obj.updateDynamic("HostId")(__v.asInstanceOf[js.Any]))
      SpreadDomain.foreach(__v => __obj.updateDynamic("SpreadDomain")(__v.asInstanceOf[js.Any]))
      Tenancy.foreach(__v => __obj.updateDynamic("Tenancy")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplatePlacementRequest]
    }
  }

  /**
    * The launch template to use. You must specify either the launch template ID or launch template name in the request, but not both.
    */
  @js.native
  trait LaunchTemplateSpecification extends js.Object {
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[String]
    var Version: js.UndefOr[String]
  }

  object LaunchTemplateSpecification {
    @inline
    def apply(
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[String] = js.undefined,
        Version: js.UndefOr[String] = js.undefined
    ): LaunchTemplateSpecification = {
      val __obj = js.Dynamic.literal()
      LaunchTemplateId.foreach(__v => __obj.updateDynamic("LaunchTemplateId")(__v.asInstanceOf[js.Any]))
      LaunchTemplateName.foreach(__v => __obj.updateDynamic("LaunchTemplateName")(__v.asInstanceOf[js.Any]))
      Version.foreach(__v => __obj.updateDynamic("Version")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateSpecification]
    }
  }

  /**
    * The options for Spot Instances.
    */
  @js.native
  trait LaunchTemplateSpotMarketOptions extends js.Object {
    var BlockDurationMinutes: js.UndefOr[Int]
    var InstanceInterruptionBehavior: js.UndefOr[InstanceInterruptionBehavior]
    var MaxPrice: js.UndefOr[String]
    var SpotInstanceType: js.UndefOr[SpotInstanceType]
    var ValidUntil: js.UndefOr[DateTime]
  }

  object LaunchTemplateSpotMarketOptions {
    @inline
    def apply(
        BlockDurationMinutes: js.UndefOr[Int] = js.undefined,
        InstanceInterruptionBehavior: js.UndefOr[InstanceInterruptionBehavior] = js.undefined,
        MaxPrice: js.UndefOr[String] = js.undefined,
        SpotInstanceType: js.UndefOr[SpotInstanceType] = js.undefined,
        ValidUntil: js.UndefOr[DateTime] = js.undefined
    ): LaunchTemplateSpotMarketOptions = {
      val __obj = js.Dynamic.literal()
      BlockDurationMinutes.foreach(__v => __obj.updateDynamic("BlockDurationMinutes")(__v.asInstanceOf[js.Any]))
      InstanceInterruptionBehavior.foreach(
        __v => __obj.updateDynamic("InstanceInterruptionBehavior")(__v.asInstanceOf[js.Any])
      )
      MaxPrice.foreach(__v => __obj.updateDynamic("MaxPrice")(__v.asInstanceOf[js.Any]))
      SpotInstanceType.foreach(__v => __obj.updateDynamic("SpotInstanceType")(__v.asInstanceOf[js.Any]))
      ValidUntil.foreach(__v => __obj.updateDynamic("ValidUntil")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateSpotMarketOptions]
    }
  }

  /**
    * The options for Spot Instances.
    */
  @js.native
  trait LaunchTemplateSpotMarketOptionsRequest extends js.Object {
    var BlockDurationMinutes: js.UndefOr[Int]
    var InstanceInterruptionBehavior: js.UndefOr[InstanceInterruptionBehavior]
    var MaxPrice: js.UndefOr[String]
    var SpotInstanceType: js.UndefOr[SpotInstanceType]
    var ValidUntil: js.UndefOr[DateTime]
  }

  object LaunchTemplateSpotMarketOptionsRequest {
    @inline
    def apply(
        BlockDurationMinutes: js.UndefOr[Int] = js.undefined,
        InstanceInterruptionBehavior: js.UndefOr[InstanceInterruptionBehavior] = js.undefined,
        MaxPrice: js.UndefOr[String] = js.undefined,
        SpotInstanceType: js.UndefOr[SpotInstanceType] = js.undefined,
        ValidUntil: js.UndefOr[DateTime] = js.undefined
    ): LaunchTemplateSpotMarketOptionsRequest = {
      val __obj = js.Dynamic.literal()
      BlockDurationMinutes.foreach(__v => __obj.updateDynamic("BlockDurationMinutes")(__v.asInstanceOf[js.Any]))
      InstanceInterruptionBehavior.foreach(
        __v => __obj.updateDynamic("InstanceInterruptionBehavior")(__v.asInstanceOf[js.Any])
      )
      MaxPrice.foreach(__v => __obj.updateDynamic("MaxPrice")(__v.asInstanceOf[js.Any]))
      SpotInstanceType.foreach(__v => __obj.updateDynamic("SpotInstanceType")(__v.asInstanceOf[js.Any]))
      ValidUntil.foreach(__v => __obj.updateDynamic("ValidUntil")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateSpotMarketOptionsRequest]
    }
  }

  /**
    * The tag specification for the launch template.
    */
  @js.native
  trait LaunchTemplateTagSpecification extends js.Object {
    var ResourceType: js.UndefOr[ResourceType]
    var Tags: js.UndefOr[TagList]
  }

  object LaunchTemplateTagSpecification {
    @inline
    def apply(
        ResourceType: js.UndefOr[ResourceType] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): LaunchTemplateTagSpecification = {
      val __obj = js.Dynamic.literal()
      ResourceType.foreach(__v => __obj.updateDynamic("ResourceType")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateTagSpecification]
    }
  }

  /**
    * The tags specification for the launch template.
    */
  @js.native
  trait LaunchTemplateTagSpecificationRequest extends js.Object {
    var ResourceType: js.UndefOr[ResourceType]
    var Tags: js.UndefOr[TagList]
  }

  object LaunchTemplateTagSpecificationRequest {
    @inline
    def apply(
        ResourceType: js.UndefOr[ResourceType] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined
    ): LaunchTemplateTagSpecificationRequest = {
      val __obj = js.Dynamic.literal()
      ResourceType.foreach(__v => __obj.updateDynamic("ResourceType")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateTagSpecificationRequest]
    }
  }

  /**
    * Describes a launch template version.
    */
  @js.native
  trait LaunchTemplateVersion extends js.Object {
    var CreateTime: js.UndefOr[DateTime]
    var CreatedBy: js.UndefOr[String]
    var DefaultVersion: js.UndefOr[Boolean]
    var LaunchTemplateData: js.UndefOr[ResponseLaunchTemplateData]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
    var VersionDescription: js.UndefOr[VersionDescription]
    var VersionNumber: js.UndefOr[Double]
  }

  object LaunchTemplateVersion {
    @inline
    def apply(
        CreateTime: js.UndefOr[DateTime] = js.undefined,
        CreatedBy: js.UndefOr[String] = js.undefined,
        DefaultVersion: js.UndefOr[Boolean] = js.undefined,
        LaunchTemplateData: js.UndefOr[ResponseLaunchTemplateData] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined,
        VersionDescription: js.UndefOr[VersionDescription] = js.undefined,
        VersionNumber: js.UndefOr[Double] = js.undefined
    ): LaunchTemplateVersion = {
      val __obj = js.Dynamic.literal()
      CreateTime.foreach(__v => __obj.updateDynamic("CreateTime")(__v.asInstanceOf[js.Any]))
      CreatedBy.foreach(__v => __obj.updateDynamic("CreatedBy")(__v.asInstanceOf[js.Any]))
      DefaultVersion.foreach(__v => __obj.updateDynamic("DefaultVersion")(__v.asInstanceOf[js.Any]))
      LaunchTemplateData.foreach(__v => __obj.updateDynamic("LaunchTemplateData")(__v.asInstanceOf[js.Any]))
      LaunchTemplateId.foreach(__v => __obj.updateDynamic("LaunchTemplateId")(__v.asInstanceOf[js.Any]))
      LaunchTemplateName.foreach(__v => __obj.updateDynamic("LaunchTemplateName")(__v.asInstanceOf[js.Any]))
      VersionDescription.foreach(__v => __obj.updateDynamic("VersionDescription")(__v.asInstanceOf[js.Any]))
      VersionNumber.foreach(__v => __obj.updateDynamic("VersionNumber")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplateVersion]
    }
  }

  /**
    * Describes the monitoring for the instance.
    */
  @js.native
  trait LaunchTemplatesMonitoring extends js.Object {
    var Enabled: js.UndefOr[Boolean]
  }

  object LaunchTemplatesMonitoring {
    @inline
    def apply(
        Enabled: js.UndefOr[Boolean] = js.undefined
    ): LaunchTemplatesMonitoring = {
      val __obj = js.Dynamic.literal()
      Enabled.foreach(__v => __obj.updateDynamic("Enabled")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplatesMonitoring]
    }
  }

  /**
    * Describes the monitoring for the instance.
    */
  @js.native
  trait LaunchTemplatesMonitoringRequest extends js.Object {
    var Enabled: js.UndefOr[Boolean]
  }

  object LaunchTemplatesMonitoringRequest {
    @inline
    def apply(
        Enabled: js.UndefOr[Boolean] = js.undefined
    ): LaunchTemplatesMonitoringRequest = {
      val __obj = js.Dynamic.literal()
      Enabled.foreach(__v => __obj.updateDynamic("Enabled")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LaunchTemplatesMonitoringRequest]
    }
  }

  /**
    * Describes a license configuration.
    */
  @js.native
  trait LicenseConfiguration extends js.Object {
    var LicenseConfigurationArn: js.UndefOr[String]
  }

  object LicenseConfiguration {
    @inline
    def apply(
        LicenseConfigurationArn: js.UndefOr[String] = js.undefined
    ): LicenseConfiguration = {
      val __obj = js.Dynamic.literal()
      LicenseConfigurationArn.foreach(__v => __obj.updateDynamic("LicenseConfigurationArn")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LicenseConfiguration]
    }
  }

  /**
    * Describes a license configuration.
    */
  @js.native
  trait LicenseConfigurationRequest extends js.Object {
    var LicenseConfigurationArn: js.UndefOr[String]
  }

  object LicenseConfigurationRequest {
    @inline
    def apply(
        LicenseConfigurationArn: js.UndefOr[String] = js.undefined
    ): LicenseConfigurationRequest = {
      val __obj = js.Dynamic.literal()
      LicenseConfigurationArn.foreach(__v => __obj.updateDynamic("LicenseConfigurationArn")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LicenseConfigurationRequest]
    }
  }

  object ListingStateEnum {
    val available = "available"
    val sold      = "sold"
    val cancelled = "cancelled"
    val pending   = "pending"

    val values = js.Object.freeze(js.Array(available, sold, cancelled, pending))
  }

  object ListingStatusEnum {
    val active    = "active"
    val pending   = "pending"
    val cancelled = "cancelled"
    val closed    = "closed"

    val values = js.Object.freeze(js.Array(active, pending, cancelled, closed))
  }

  /**
    * Describes the Classic Load Balancers and target groups to attach to a Spot Fleet request.
    */
  @js.native
  trait LoadBalancersConfig extends js.Object {
    var ClassicLoadBalancersConfig: js.UndefOr[ClassicLoadBalancersConfig]
    var TargetGroupsConfig: js.UndefOr[TargetGroupsConfig]
  }

  object LoadBalancersConfig {
    @inline
    def apply(
        ClassicLoadBalancersConfig: js.UndefOr[ClassicLoadBalancersConfig] = js.undefined,
        TargetGroupsConfig: js.UndefOr[TargetGroupsConfig] = js.undefined
    ): LoadBalancersConfig = {
      val __obj = js.Dynamic.literal()
      ClassicLoadBalancersConfig.foreach(
        __v => __obj.updateDynamic("ClassicLoadBalancersConfig")(__v.asInstanceOf[js.Any])
      )
      TargetGroupsConfig.foreach(__v => __obj.updateDynamic("TargetGroupsConfig")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LoadBalancersConfig]
    }
  }

  /**
    * Describes a load permission.
    */
  @js.native
  trait LoadPermission extends js.Object {
    var Group: js.UndefOr[PermissionGroup]
    var UserId: js.UndefOr[String]
  }

  object LoadPermission {
    @inline
    def apply(
        Group: js.UndefOr[PermissionGroup] = js.undefined,
        UserId: js.UndefOr[String] = js.undefined
    ): LoadPermission = {
      val __obj = js.Dynamic.literal()
      Group.foreach(__v => __obj.updateDynamic("Group")(__v.asInstanceOf[js.Any]))
      UserId.foreach(__v => __obj.updateDynamic("UserId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LoadPermission]
    }
  }

  /**
    * Describes modifications to the load permissions of an Amazon FPGA image (AFI).
    */
  @js.native
  trait LoadPermissionModifications extends js.Object {
    var Add: js.UndefOr[LoadPermissionListRequest]
    var Remove: js.UndefOr[LoadPermissionListRequest]
  }

  object LoadPermissionModifications {
    @inline
    def apply(
        Add: js.UndefOr[LoadPermissionListRequest] = js.undefined,
        Remove: js.UndefOr[LoadPermissionListRequest] = js.undefined
    ): LoadPermissionModifications = {
      val __obj = js.Dynamic.literal()
      Add.foreach(__v => __obj.updateDynamic("Add")(__v.asInstanceOf[js.Any]))
      Remove.foreach(__v => __obj.updateDynamic("Remove")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LoadPermissionModifications]
    }
  }

  /**
    * Describes a load permission.
    */
  @js.native
  trait LoadPermissionRequest extends js.Object {
    var Group: js.UndefOr[PermissionGroup]
    var UserId: js.UndefOr[String]
  }

  object LoadPermissionRequest {
    @inline
    def apply(
        Group: js.UndefOr[PermissionGroup] = js.undefined,
        UserId: js.UndefOr[String] = js.undefined
    ): LoadPermissionRequest = {
      val __obj = js.Dynamic.literal()
      Group.foreach(__v => __obj.updateDynamic("Group")(__v.asInstanceOf[js.Any]))
      UserId.foreach(__v => __obj.updateDynamic("UserId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[LoadPermissionRequest]
    }
  }

  object LogDestinationTypeEnum {
    val `cloud-watch-logs` = "cloud-watch-logs"
    val s3                 = "s3"

    val values = js.Object.freeze(js.Array(`cloud-watch-logs`, s3))
  }

  object MarketTypeEnum {
    val spot = "spot"

    val values = js.Object.freeze(js.Array(spot))
  }

  @js.native
  trait ModifyCapacityReservationRequest extends js.Object {
    var CapacityReservationId: String
    var DryRun: js.UndefOr[Boolean]
    var EndDate: js.UndefOr[DateTime]
    var EndDateType: js.UndefOr[EndDateType]
    var InstanceCount: js.UndefOr[Int]
  }

  object ModifyCapacityReservationRequest {
    @inline
    def apply(
        CapacityReservationId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EndDate: js.UndefOr[DateTime] = js.undefined,
        EndDateType: js.UndefOr[EndDateType] = js.undefined,
        InstanceCount: js.UndefOr[Int] = js.undefined
    ): ModifyCapacityReservationRequest = {
      val __obj = js.Dynamic.literal(
        "CapacityReservationId" -> CapacityReservationId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      EndDate.foreach(__v => __obj.updateDynamic("EndDate")(__v.asInstanceOf[js.Any]))
      EndDateType.foreach(__v => __obj.updateDynamic("EndDateType")(__v.asInstanceOf[js.Any]))
      InstanceCount.foreach(__v => __obj.updateDynamic("InstanceCount")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyCapacityReservationRequest]
    }
  }

  @js.native
  trait ModifyCapacityReservationResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyCapacityReservationResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyCapacityReservationResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyCapacityReservationResult]
    }
  }

  @js.native
  trait ModifyClientVpnEndpointRequest extends js.Object {
    var ClientVpnEndpointId: String
    var ConnectionLogOptions: js.UndefOr[ConnectionLogOptions]
    var Description: js.UndefOr[String]
    var DnsServers: js.UndefOr[DnsServersOptionsModifyStructure]
    var DryRun: js.UndefOr[Boolean]
    var ServerCertificateArn: js.UndefOr[String]
    var SplitTunnel: js.UndefOr[Boolean]
  }

  object ModifyClientVpnEndpointRequest {
    @inline
    def apply(
        ClientVpnEndpointId: String,
        ConnectionLogOptions: js.UndefOr[ConnectionLogOptions] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DnsServers: js.UndefOr[DnsServersOptionsModifyStructure] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ServerCertificateArn: js.UndefOr[String] = js.undefined,
        SplitTunnel: js.UndefOr[Boolean] = js.undefined
    ): ModifyClientVpnEndpointRequest = {
      val __obj = js.Dynamic.literal(
        "ClientVpnEndpointId" -> ClientVpnEndpointId.asInstanceOf[js.Any]
      )

      ConnectionLogOptions.foreach(__v => __obj.updateDynamic("ConnectionLogOptions")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DnsServers.foreach(__v => __obj.updateDynamic("DnsServers")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      ServerCertificateArn.foreach(__v => __obj.updateDynamic("ServerCertificateArn")(__v.asInstanceOf[js.Any]))
      SplitTunnel.foreach(__v => __obj.updateDynamic("SplitTunnel")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyClientVpnEndpointRequest]
    }
  }

  @js.native
  trait ModifyClientVpnEndpointResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyClientVpnEndpointResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyClientVpnEndpointResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyClientVpnEndpointResult]
    }
  }

  @js.native
  trait ModifyEbsDefaultKmsKeyIdRequest extends js.Object {
    var KmsKeyId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyEbsDefaultKmsKeyIdRequest {
    @inline
    def apply(
        KmsKeyId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyEbsDefaultKmsKeyIdRequest = {
      val __obj = js.Dynamic.literal(
        "KmsKeyId" -> KmsKeyId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyEbsDefaultKmsKeyIdRequest]
    }
  }

  @js.native
  trait ModifyEbsDefaultKmsKeyIdResult extends js.Object {
    var KmsKeyId: js.UndefOr[String]
  }

  object ModifyEbsDefaultKmsKeyIdResult {
    @inline
    def apply(
        KmsKeyId: js.UndefOr[String] = js.undefined
    ): ModifyEbsDefaultKmsKeyIdResult = {
      val __obj = js.Dynamic.literal()
      KmsKeyId.foreach(__v => __obj.updateDynamic("KmsKeyId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyEbsDefaultKmsKeyIdResult]
    }
  }

  @js.native
  trait ModifyFleetRequest extends js.Object {
    var FleetId: FleetIdentifier
    var TargetCapacitySpecification: TargetCapacitySpecificationRequest
    var DryRun: js.UndefOr[Boolean]
    var ExcessCapacityTerminationPolicy: js.UndefOr[FleetExcessCapacityTerminationPolicy]
  }

  object ModifyFleetRequest {
    @inline
    def apply(
        FleetId: FleetIdentifier,
        TargetCapacitySpecification: TargetCapacitySpecificationRequest,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        ExcessCapacityTerminationPolicy: js.UndefOr[FleetExcessCapacityTerminationPolicy] = js.undefined
    ): ModifyFleetRequest = {
      val __obj = js.Dynamic.literal(
        "FleetId"                     -> FleetId.asInstanceOf[js.Any],
        "TargetCapacitySpecification" -> TargetCapacitySpecification.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      ExcessCapacityTerminationPolicy.foreach(
        __v => __obj.updateDynamic("ExcessCapacityTerminationPolicy")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[ModifyFleetRequest]
    }
  }

  @js.native
  trait ModifyFleetResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyFleetResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyFleetResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyFleetResult]
    }
  }

  @js.native
  trait ModifyFpgaImageAttributeRequest extends js.Object {
    var FpgaImageId: String
    var Attribute: js.UndefOr[FpgaImageAttributeName]
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var LoadPermission: js.UndefOr[LoadPermissionModifications]
    var Name: js.UndefOr[String]
    var OperationType: js.UndefOr[OperationType]
    var ProductCodes: js.UndefOr[ProductCodeStringList]
    var UserGroups: js.UndefOr[UserGroupStringList]
    var UserIds: js.UndefOr[UserIdStringList]
  }

  object ModifyFpgaImageAttributeRequest {
    @inline
    def apply(
        FpgaImageId: String,
        Attribute: js.UndefOr[FpgaImageAttributeName] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LoadPermission: js.UndefOr[LoadPermissionModifications] = js.undefined,
        Name: js.UndefOr[String] = js.undefined,
        OperationType: js.UndefOr[OperationType] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeStringList] = js.undefined,
        UserGroups: js.UndefOr[UserGroupStringList] = js.undefined,
        UserIds: js.UndefOr[UserIdStringList] = js.undefined
    ): ModifyFpgaImageAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "FpgaImageId" -> FpgaImageId.asInstanceOf[js.Any]
      )

      Attribute.foreach(__v => __obj.updateDynamic("Attribute")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      LoadPermission.foreach(__v => __obj.updateDynamic("LoadPermission")(__v.asInstanceOf[js.Any]))
      Name.foreach(__v => __obj.updateDynamic("Name")(__v.asInstanceOf[js.Any]))
      OperationType.foreach(__v => __obj.updateDynamic("OperationType")(__v.asInstanceOf[js.Any]))
      ProductCodes.foreach(__v => __obj.updateDynamic("ProductCodes")(__v.asInstanceOf[js.Any]))
      UserGroups.foreach(__v => __obj.updateDynamic("UserGroups")(__v.asInstanceOf[js.Any]))
      UserIds.foreach(__v => __obj.updateDynamic("UserIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyFpgaImageAttributeRequest]
    }
  }

  @js.native
  trait ModifyFpgaImageAttributeResult extends js.Object {
    var FpgaImageAttribute: js.UndefOr[FpgaImageAttribute]
  }

  object ModifyFpgaImageAttributeResult {
    @inline
    def apply(
        FpgaImageAttribute: js.UndefOr[FpgaImageAttribute] = js.undefined
    ): ModifyFpgaImageAttributeResult = {
      val __obj = js.Dynamic.literal()
      FpgaImageAttribute.foreach(__v => __obj.updateDynamic("FpgaImageAttribute")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyFpgaImageAttributeResult]
    }
  }

  @js.native
  trait ModifyHostsRequest extends js.Object {
    var HostIds: RequestHostIdList
    var AutoPlacement: js.UndefOr[AutoPlacement]
    var HostRecovery: js.UndefOr[HostRecovery]
  }

  object ModifyHostsRequest {
    @inline
    def apply(
        HostIds: RequestHostIdList,
        AutoPlacement: js.UndefOr[AutoPlacement] = js.undefined,
        HostRecovery: js.UndefOr[HostRecovery] = js.undefined
    ): ModifyHostsRequest = {
      val __obj = js.Dynamic.literal(
        "HostIds" -> HostIds.asInstanceOf[js.Any]
      )

      AutoPlacement.foreach(__v => __obj.updateDynamic("AutoPlacement")(__v.asInstanceOf[js.Any]))
      HostRecovery.foreach(__v => __obj.updateDynamic("HostRecovery")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyHostsRequest]
    }
  }

  @js.native
  trait ModifyHostsResult extends js.Object {
    var Successful: js.UndefOr[ResponseHostIdList]
    var Unsuccessful: js.UndefOr[UnsuccessfulItemList]
  }

  object ModifyHostsResult {
    @inline
    def apply(
        Successful: js.UndefOr[ResponseHostIdList] = js.undefined,
        Unsuccessful: js.UndefOr[UnsuccessfulItemList] = js.undefined
    ): ModifyHostsResult = {
      val __obj = js.Dynamic.literal()
      Successful.foreach(__v => __obj.updateDynamic("Successful")(__v.asInstanceOf[js.Any]))
      Unsuccessful.foreach(__v => __obj.updateDynamic("Unsuccessful")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyHostsResult]
    }
  }

  @js.native
  trait ModifyIdFormatRequest extends js.Object {
    var Resource: String
    var UseLongIds: Boolean
  }

  object ModifyIdFormatRequest {
    @inline
    def apply(
        Resource: String,
        UseLongIds: Boolean
    ): ModifyIdFormatRequest = {
      val __obj = js.Dynamic.literal(
        "Resource"   -> Resource.asInstanceOf[js.Any],
        "UseLongIds" -> UseLongIds.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[ModifyIdFormatRequest]
    }
  }

  @js.native
  trait ModifyIdentityIdFormatRequest extends js.Object {
    var PrincipalArn: String
    var Resource: String
    var UseLongIds: Boolean
  }

  object ModifyIdentityIdFormatRequest {
    @inline
    def apply(
        PrincipalArn: String,
        Resource: String,
        UseLongIds: Boolean
    ): ModifyIdentityIdFormatRequest = {
      val __obj = js.Dynamic.literal(
        "PrincipalArn" -> PrincipalArn.asInstanceOf[js.Any],
        "Resource"     -> Resource.asInstanceOf[js.Any],
        "UseLongIds"   -> UseLongIds.asInstanceOf[js.Any]
      )

      __obj.asInstanceOf[ModifyIdentityIdFormatRequest]
    }
  }

  /**
    * Contains the parameters for ModifyImageAttribute.
    */
  @js.native
  trait ModifyImageAttributeRequest extends js.Object {
    var ImageId: String
    var Attribute: js.UndefOr[String]
    var Description: js.UndefOr[AttributeValue]
    var DryRun: js.UndefOr[Boolean]
    var LaunchPermission: js.UndefOr[LaunchPermissionModifications]
    var OperationType: js.UndefOr[OperationType]
    var ProductCodes: js.UndefOr[ProductCodeStringList]
    var UserGroups: js.UndefOr[UserGroupStringList]
    var UserIds: js.UndefOr[UserIdStringList]
    var Value: js.UndefOr[String]
  }

  object ModifyImageAttributeRequest {
    @inline
    def apply(
        ImageId: String,
        Attribute: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[AttributeValue] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LaunchPermission: js.UndefOr[LaunchPermissionModifications] = js.undefined,
        OperationType: js.UndefOr[OperationType] = js.undefined,
        ProductCodes: js.UndefOr[ProductCodeStringList] = js.undefined,
        UserGroups: js.UndefOr[UserGroupStringList] = js.undefined,
        UserIds: js.UndefOr[UserIdStringList] = js.undefined,
        Value: js.UndefOr[String] = js.undefined
    ): ModifyImageAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "ImageId" -> ImageId.asInstanceOf[js.Any]
      )

      Attribute.foreach(__v => __obj.updateDynamic("Attribute")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      LaunchPermission.foreach(__v => __obj.updateDynamic("LaunchPermission")(__v.asInstanceOf[js.Any]))
      OperationType.foreach(__v => __obj.updateDynamic("OperationType")(__v.asInstanceOf[js.Any]))
      ProductCodes.foreach(__v => __obj.updateDynamic("ProductCodes")(__v.asInstanceOf[js.Any]))
      UserGroups.foreach(__v => __obj.updateDynamic("UserGroups")(__v.asInstanceOf[js.Any]))
      UserIds.foreach(__v => __obj.updateDynamic("UserIds")(__v.asInstanceOf[js.Any]))
      Value.foreach(__v => __obj.updateDynamic("Value")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyImageAttributeRequest]
    }
  }

  @js.native
  trait ModifyInstanceAttributeRequest extends js.Object {
    var InstanceId: String
    var Attribute: js.UndefOr[InstanceAttributeName]
    var BlockDeviceMappings: js.UndefOr[InstanceBlockDeviceMappingSpecificationList]
    var DisableApiTermination: js.UndefOr[AttributeBooleanValue]
    var DryRun: js.UndefOr[Boolean]
    var EbsOptimized: js.UndefOr[AttributeBooleanValue]
    var EnaSupport: js.UndefOr[AttributeBooleanValue]
    var Groups: js.UndefOr[GroupIdStringList]
    var InstanceInitiatedShutdownBehavior: js.UndefOr[AttributeValue]
    var InstanceType: js.UndefOr[AttributeValue]
    var Kernel: js.UndefOr[AttributeValue]
    var Ramdisk: js.UndefOr[AttributeValue]
    var SourceDestCheck: js.UndefOr[AttributeBooleanValue]
    var SriovNetSupport: js.UndefOr[AttributeValue]
    var UserData: js.UndefOr[BlobAttributeValue]
    var Value: js.UndefOr[String]
  }

  object ModifyInstanceAttributeRequest {
    @inline
    def apply(
        InstanceId: String,
        Attribute: js.UndefOr[InstanceAttributeName] = js.undefined,
        BlockDeviceMappings: js.UndefOr[InstanceBlockDeviceMappingSpecificationList] = js.undefined,
        DisableApiTermination: js.UndefOr[AttributeBooleanValue] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        EbsOptimized: js.UndefOr[AttributeBooleanValue] = js.undefined,
        EnaSupport: js.UndefOr[AttributeBooleanValue] = js.undefined,
        Groups: js.UndefOr[GroupIdStringList] = js.undefined,
        InstanceInitiatedShutdownBehavior: js.UndefOr[AttributeValue] = js.undefined,
        InstanceType: js.UndefOr[AttributeValue] = js.undefined,
        Kernel: js.UndefOr[AttributeValue] = js.undefined,
        Ramdisk: js.UndefOr[AttributeValue] = js.undefined,
        SourceDestCheck: js.UndefOr[AttributeBooleanValue] = js.undefined,
        SriovNetSupport: js.UndefOr[AttributeValue] = js.undefined,
        UserData: js.UndefOr[BlobAttributeValue] = js.undefined,
        Value: js.UndefOr[String] = js.undefined
    ): ModifyInstanceAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceId" -> InstanceId.asInstanceOf[js.Any]
      )

      Attribute.foreach(__v => __obj.updateDynamic("Attribute")(__v.asInstanceOf[js.Any]))
      BlockDeviceMappings.foreach(__v => __obj.updateDynamic("BlockDeviceMappings")(__v.asInstanceOf[js.Any]))
      DisableApiTermination.foreach(__v => __obj.updateDynamic("DisableApiTermination")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      EbsOptimized.foreach(__v => __obj.updateDynamic("EbsOptimized")(__v.asInstanceOf[js.Any]))
      EnaSupport.foreach(__v => __obj.updateDynamic("EnaSupport")(__v.asInstanceOf[js.Any]))
      Groups.foreach(__v => __obj.updateDynamic("Groups")(__v.asInstanceOf[js.Any]))
      InstanceInitiatedShutdownBehavior.foreach(
        __v => __obj.updateDynamic("InstanceInitiatedShutdownBehavior")(__v.asInstanceOf[js.Any])
      )
      InstanceType.foreach(__v => __obj.updateDynamic("InstanceType")(__v.asInstanceOf[js.Any]))
      Kernel.foreach(__v => __obj.updateDynamic("Kernel")(__v.asInstanceOf[js.Any]))
      Ramdisk.foreach(__v => __obj.updateDynamic("Ramdisk")(__v.asInstanceOf[js.Any]))
      SourceDestCheck.foreach(__v => __obj.updateDynamic("SourceDestCheck")(__v.asInstanceOf[js.Any]))
      SriovNetSupport.foreach(__v => __obj.updateDynamic("SriovNetSupport")(__v.asInstanceOf[js.Any]))
      UserData.foreach(__v => __obj.updateDynamic("UserData")(__v.asInstanceOf[js.Any]))
      Value.foreach(__v => __obj.updateDynamic("Value")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyInstanceAttributeRequest]
    }
  }

  @js.native
  trait ModifyInstanceCapacityReservationAttributesRequest extends js.Object {
    var CapacityReservationSpecification: CapacityReservationSpecification
    var InstanceId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyInstanceCapacityReservationAttributesRequest {
    @inline
    def apply(
        CapacityReservationSpecification: CapacityReservationSpecification,
        InstanceId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyInstanceCapacityReservationAttributesRequest = {
      val __obj = js.Dynamic.literal(
        "CapacityReservationSpecification" -> CapacityReservationSpecification.asInstanceOf[js.Any],
        "InstanceId"                       -> InstanceId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyInstanceCapacityReservationAttributesRequest]
    }
  }

  @js.native
  trait ModifyInstanceCapacityReservationAttributesResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyInstanceCapacityReservationAttributesResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyInstanceCapacityReservationAttributesResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyInstanceCapacityReservationAttributesResult]
    }
  }

  @js.native
  trait ModifyInstanceCreditSpecificationRequest extends js.Object {
    var InstanceCreditSpecifications: InstanceCreditSpecificationListRequest
    var ClientToken: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyInstanceCreditSpecificationRequest {
    @inline
    def apply(
        InstanceCreditSpecifications: InstanceCreditSpecificationListRequest,
        ClientToken: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyInstanceCreditSpecificationRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceCreditSpecifications" -> InstanceCreditSpecifications.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyInstanceCreditSpecificationRequest]
    }
  }

  @js.native
  trait ModifyInstanceCreditSpecificationResult extends js.Object {
    var SuccessfulInstanceCreditSpecifications: js.UndefOr[SuccessfulInstanceCreditSpecificationSet]
    var UnsuccessfulInstanceCreditSpecifications: js.UndefOr[UnsuccessfulInstanceCreditSpecificationSet]
  }

  object ModifyInstanceCreditSpecificationResult {
    @inline
    def apply(
        SuccessfulInstanceCreditSpecifications: js.UndefOr[SuccessfulInstanceCreditSpecificationSet] = js.undefined,
        UnsuccessfulInstanceCreditSpecifications: js.UndefOr[UnsuccessfulInstanceCreditSpecificationSet] = js.undefined
    ): ModifyInstanceCreditSpecificationResult = {
      val __obj = js.Dynamic.literal()
      SuccessfulInstanceCreditSpecifications.foreach(
        __v => __obj.updateDynamic("SuccessfulInstanceCreditSpecifications")(__v.asInstanceOf[js.Any])
      )
      UnsuccessfulInstanceCreditSpecifications.foreach(
        __v => __obj.updateDynamic("UnsuccessfulInstanceCreditSpecifications")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[ModifyInstanceCreditSpecificationResult]
    }
  }

  @js.native
  trait ModifyInstanceEventStartTimeRequest extends js.Object {
    var InstanceEventId: String
    var InstanceId: String
    var NotBefore: DateTime
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyInstanceEventStartTimeRequest {
    @inline
    def apply(
        InstanceEventId: String,
        InstanceId: String,
        NotBefore: DateTime,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyInstanceEventStartTimeRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceEventId" -> InstanceEventId.asInstanceOf[js.Any],
        "InstanceId"      -> InstanceId.asInstanceOf[js.Any],
        "NotBefore"       -> NotBefore.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyInstanceEventStartTimeRequest]
    }
  }

  @js.native
  trait ModifyInstanceEventStartTimeResult extends js.Object {
    var Event: js.UndefOr[InstanceStatusEvent]
  }

  object ModifyInstanceEventStartTimeResult {
    @inline
    def apply(
        Event: js.UndefOr[InstanceStatusEvent] = js.undefined
    ): ModifyInstanceEventStartTimeResult = {
      val __obj = js.Dynamic.literal()
      Event.foreach(__v => __obj.updateDynamic("Event")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyInstanceEventStartTimeResult]
    }
  }

  @js.native
  trait ModifyInstancePlacementRequest extends js.Object {
    var InstanceId: String
    var Affinity: js.UndefOr[Affinity]
    var GroupName: js.UndefOr[String]
    var HostId: js.UndefOr[String]
    var PartitionNumber: js.UndefOr[Int]
    var Tenancy: js.UndefOr[HostTenancy]
  }

  object ModifyInstancePlacementRequest {
    @inline
    def apply(
        InstanceId: String,
        Affinity: js.UndefOr[Affinity] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined,
        HostId: js.UndefOr[String] = js.undefined,
        PartitionNumber: js.UndefOr[Int] = js.undefined,
        Tenancy: js.UndefOr[HostTenancy] = js.undefined
    ): ModifyInstancePlacementRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceId" -> InstanceId.asInstanceOf[js.Any]
      )

      Affinity.foreach(__v => __obj.updateDynamic("Affinity")(__v.asInstanceOf[js.Any]))
      GroupName.foreach(__v => __obj.updateDynamic("GroupName")(__v.asInstanceOf[js.Any]))
      HostId.foreach(__v => __obj.updateDynamic("HostId")(__v.asInstanceOf[js.Any]))
      PartitionNumber.foreach(__v => __obj.updateDynamic("PartitionNumber")(__v.asInstanceOf[js.Any]))
      Tenancy.foreach(__v => __obj.updateDynamic("Tenancy")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyInstancePlacementRequest]
    }
  }

  @js.native
  trait ModifyInstancePlacementResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyInstancePlacementResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyInstancePlacementResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyInstancePlacementResult]
    }
  }

  @js.native
  trait ModifyLaunchTemplateRequest extends js.Object {
    var ClientToken: js.UndefOr[String]
    var DefaultVersion: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var LaunchTemplateId: js.UndefOr[String]
    var LaunchTemplateName: js.UndefOr[LaunchTemplateName]
  }

  object ModifyLaunchTemplateRequest {
    @inline
    def apply(
        ClientToken: js.UndefOr[String] = js.undefined,
        DefaultVersion: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        LaunchTemplateId: js.UndefOr[String] = js.undefined,
        LaunchTemplateName: js.UndefOr[LaunchTemplateName] = js.undefined
    ): ModifyLaunchTemplateRequest = {
      val __obj = js.Dynamic.literal()
      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      DefaultVersion.foreach(__v => __obj.updateDynamic("DefaultVersion")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      LaunchTemplateId.foreach(__v => __obj.updateDynamic("LaunchTemplateId")(__v.asInstanceOf[js.Any]))
      LaunchTemplateName.foreach(__v => __obj.updateDynamic("LaunchTemplateName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyLaunchTemplateRequest]
    }
  }

  @js.native
  trait ModifyLaunchTemplateResult extends js.Object {
    var LaunchTemplate: js.UndefOr[LaunchTemplate]
  }

  object ModifyLaunchTemplateResult {
    @inline
    def apply(
        LaunchTemplate: js.UndefOr[LaunchTemplate] = js.undefined
    ): ModifyLaunchTemplateResult = {
      val __obj = js.Dynamic.literal()
      LaunchTemplate.foreach(__v => __obj.updateDynamic("LaunchTemplate")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyLaunchTemplateResult]
    }
  }

  /**
    * Contains the parameters for ModifyNetworkInterfaceAttribute.
    */
  @js.native
  trait ModifyNetworkInterfaceAttributeRequest extends js.Object {
    var NetworkInterfaceId: String
    var Attachment: js.UndefOr[NetworkInterfaceAttachmentChanges]
    var Description: js.UndefOr[AttributeValue]
    var DryRun: js.UndefOr[Boolean]
    var Groups: js.UndefOr[SecurityGroupIdStringList]
    var SourceDestCheck: js.UndefOr[AttributeBooleanValue]
  }

  object ModifyNetworkInterfaceAttributeRequest {
    @inline
    def apply(
        NetworkInterfaceId: String,
        Attachment: js.UndefOr[NetworkInterfaceAttachmentChanges] = js.undefined,
        Description: js.UndefOr[AttributeValue] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Groups: js.UndefOr[SecurityGroupIdStringList] = js.undefined,
        SourceDestCheck: js.UndefOr[AttributeBooleanValue] = js.undefined
    ): ModifyNetworkInterfaceAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "NetworkInterfaceId" -> NetworkInterfaceId.asInstanceOf[js.Any]
      )

      Attachment.foreach(__v => __obj.updateDynamic("Attachment")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Groups.foreach(__v => __obj.updateDynamic("Groups")(__v.asInstanceOf[js.Any]))
      SourceDestCheck.foreach(__v => __obj.updateDynamic("SourceDestCheck")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyNetworkInterfaceAttributeRequest]
    }
  }

  /**
    * Contains the parameters for ModifyReservedInstances.
    */
  @js.native
  trait ModifyReservedInstancesRequest extends js.Object {
    var ReservedInstancesIds: ReservedInstancesIdStringList
    var TargetConfigurations: ReservedInstancesConfigurationList
    var ClientToken: js.UndefOr[String]
  }

  object ModifyReservedInstancesRequest {
    @inline
    def apply(
        ReservedInstancesIds: ReservedInstancesIdStringList,
        TargetConfigurations: ReservedInstancesConfigurationList,
        ClientToken: js.UndefOr[String] = js.undefined
    ): ModifyReservedInstancesRequest = {
      val __obj = js.Dynamic.literal(
        "ReservedInstancesIds" -> ReservedInstancesIds.asInstanceOf[js.Any],
        "TargetConfigurations" -> TargetConfigurations.asInstanceOf[js.Any]
      )

      ClientToken.foreach(__v => __obj.updateDynamic("ClientToken")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyReservedInstancesRequest]
    }
  }

  /**
    * Contains the output of ModifyReservedInstances.
    */
  @js.native
  trait ModifyReservedInstancesResult extends js.Object {
    var ReservedInstancesModificationId: js.UndefOr[String]
  }

  object ModifyReservedInstancesResult {
    @inline
    def apply(
        ReservedInstancesModificationId: js.UndefOr[String] = js.undefined
    ): ModifyReservedInstancesResult = {
      val __obj = js.Dynamic.literal()
      ReservedInstancesModificationId.foreach(
        __v => __obj.updateDynamic("ReservedInstancesModificationId")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[ModifyReservedInstancesResult]
    }
  }

  /**
    * Contains the parameters for ModifySnapshotAttribute.
    */
  @js.native
  trait ModifySnapshotAttributeRequest extends js.Object {
    var SnapshotId: String
    var Attribute: js.UndefOr[SnapshotAttributeName]
    var CreateVolumePermission: js.UndefOr[CreateVolumePermissionModifications]
    var DryRun: js.UndefOr[Boolean]
    var GroupNames: js.UndefOr[GroupNameStringList]
    var OperationType: js.UndefOr[OperationType]
    var UserIds: js.UndefOr[UserIdStringList]
  }

  object ModifySnapshotAttributeRequest {
    @inline
    def apply(
        SnapshotId: String,
        Attribute: js.UndefOr[SnapshotAttributeName] = js.undefined,
        CreateVolumePermission: js.UndefOr[CreateVolumePermissionModifications] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        GroupNames: js.UndefOr[GroupNameStringList] = js.undefined,
        OperationType: js.UndefOr[OperationType] = js.undefined,
        UserIds: js.UndefOr[UserIdStringList] = js.undefined
    ): ModifySnapshotAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "SnapshotId" -> SnapshotId.asInstanceOf[js.Any]
      )

      Attribute.foreach(__v => __obj.updateDynamic("Attribute")(__v.asInstanceOf[js.Any]))
      CreateVolumePermission.foreach(__v => __obj.updateDynamic("CreateVolumePermission")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      GroupNames.foreach(__v => __obj.updateDynamic("GroupNames")(__v.asInstanceOf[js.Any]))
      OperationType.foreach(__v => __obj.updateDynamic("OperationType")(__v.asInstanceOf[js.Any]))
      UserIds.foreach(__v => __obj.updateDynamic("UserIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifySnapshotAttributeRequest]
    }
  }

  /**
    * Contains the parameters for ModifySpotFleetRequest.
    */
  @js.native
  trait ModifySpotFleetRequestRequest extends js.Object {
    var SpotFleetRequestId: String
    var ExcessCapacityTerminationPolicy: js.UndefOr[ExcessCapacityTerminationPolicy]
    var OnDemandTargetCapacity: js.UndefOr[Int]
    var TargetCapacity: js.UndefOr[Int]
  }

  object ModifySpotFleetRequestRequest {
    @inline
    def apply(
        SpotFleetRequestId: String,
        ExcessCapacityTerminationPolicy: js.UndefOr[ExcessCapacityTerminationPolicy] = js.undefined,
        OnDemandTargetCapacity: js.UndefOr[Int] = js.undefined,
        TargetCapacity: js.UndefOr[Int] = js.undefined
    ): ModifySpotFleetRequestRequest = {
      val __obj = js.Dynamic.literal(
        "SpotFleetRequestId" -> SpotFleetRequestId.asInstanceOf[js.Any]
      )

      ExcessCapacityTerminationPolicy.foreach(
        __v => __obj.updateDynamic("ExcessCapacityTerminationPolicy")(__v.asInstanceOf[js.Any])
      )
      OnDemandTargetCapacity.foreach(__v => __obj.updateDynamic("OnDemandTargetCapacity")(__v.asInstanceOf[js.Any]))
      TargetCapacity.foreach(__v => __obj.updateDynamic("TargetCapacity")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifySpotFleetRequestRequest]
    }
  }

  /**
    * Contains the output of ModifySpotFleetRequest.
    */
  @js.native
  trait ModifySpotFleetRequestResponse extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifySpotFleetRequestResponse {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifySpotFleetRequestResponse = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifySpotFleetRequestResponse]
    }
  }

  @js.native
  trait ModifySubnetAttributeRequest extends js.Object {
    var SubnetId: String
    var AssignIpv6AddressOnCreation: js.UndefOr[AttributeBooleanValue]
    var MapPublicIpOnLaunch: js.UndefOr[AttributeBooleanValue]
  }

  object ModifySubnetAttributeRequest {
    @inline
    def apply(
        SubnetId: String,
        AssignIpv6AddressOnCreation: js.UndefOr[AttributeBooleanValue] = js.undefined,
        MapPublicIpOnLaunch: js.UndefOr[AttributeBooleanValue] = js.undefined
    ): ModifySubnetAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "SubnetId" -> SubnetId.asInstanceOf[js.Any]
      )

      AssignIpv6AddressOnCreation.foreach(
        __v => __obj.updateDynamic("AssignIpv6AddressOnCreation")(__v.asInstanceOf[js.Any])
      )
      MapPublicIpOnLaunch.foreach(__v => __obj.updateDynamic("MapPublicIpOnLaunch")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifySubnetAttributeRequest]
    }
  }

  @js.native
  trait ModifyTrafficMirrorFilterNetworkServicesRequest extends js.Object {
    var TrafficMirrorFilterId: String
    var AddNetworkServices: js.UndefOr[TrafficMirrorNetworkServiceList]
    var DryRun: js.UndefOr[Boolean]
    var RemoveNetworkServices: js.UndefOr[TrafficMirrorNetworkServiceList]
  }

  object ModifyTrafficMirrorFilterNetworkServicesRequest {
    @inline
    def apply(
        TrafficMirrorFilterId: String,
        AddNetworkServices: js.UndefOr[TrafficMirrorNetworkServiceList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        RemoveNetworkServices: js.UndefOr[TrafficMirrorNetworkServiceList] = js.undefined
    ): ModifyTrafficMirrorFilterNetworkServicesRequest = {
      val __obj = js.Dynamic.literal(
        "TrafficMirrorFilterId" -> TrafficMirrorFilterId.asInstanceOf[js.Any]
      )

      AddNetworkServices.foreach(__v => __obj.updateDynamic("AddNetworkServices")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      RemoveNetworkServices.foreach(__v => __obj.updateDynamic("RemoveNetworkServices")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyTrafficMirrorFilterNetworkServicesRequest]
    }
  }

  @js.native
  trait ModifyTrafficMirrorFilterNetworkServicesResult extends js.Object {
    var TrafficMirrorFilter: js.UndefOr[TrafficMirrorFilter]
  }

  object ModifyTrafficMirrorFilterNetworkServicesResult {
    @inline
    def apply(
        TrafficMirrorFilter: js.UndefOr[TrafficMirrorFilter] = js.undefined
    ): ModifyTrafficMirrorFilterNetworkServicesResult = {
      val __obj = js.Dynamic.literal()
      TrafficMirrorFilter.foreach(__v => __obj.updateDynamic("TrafficMirrorFilter")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyTrafficMirrorFilterNetworkServicesResult]
    }
  }

  @js.native
  trait ModifyTrafficMirrorFilterRuleRequest extends js.Object {
    var TrafficMirrorFilterRuleId: String
    var Description: js.UndefOr[String]
    var DestinationCidrBlock: js.UndefOr[String]
    var DestinationPortRange: js.UndefOr[TrafficMirrorPortRangeRequest]
    var DryRun: js.UndefOr[Boolean]
    var Protocol: js.UndefOr[Int]
    var RemoveFields: js.UndefOr[TrafficMirrorFilterRuleFieldList]
    var RuleAction: js.UndefOr[TrafficMirrorRuleAction]
    var RuleNumber: js.UndefOr[Int]
    var SourceCidrBlock: js.UndefOr[String]
    var SourcePortRange: js.UndefOr[TrafficMirrorPortRangeRequest]
    var TrafficDirection: js.UndefOr[TrafficDirection]
  }

  object ModifyTrafficMirrorFilterRuleRequest {
    @inline
    def apply(
        TrafficMirrorFilterRuleId: String,
        Description: js.UndefOr[String] = js.undefined,
        DestinationCidrBlock: js.UndefOr[String] = js.undefined,
        DestinationPortRange: js.UndefOr[TrafficMirrorPortRangeRequest] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Protocol: js.UndefOr[Int] = js.undefined,
        RemoveFields: js.UndefOr[TrafficMirrorFilterRuleFieldList] = js.undefined,
        RuleAction: js.UndefOr[TrafficMirrorRuleAction] = js.undefined,
        RuleNumber: js.UndefOr[Int] = js.undefined,
        SourceCidrBlock: js.UndefOr[String] = js.undefined,
        SourcePortRange: js.UndefOr[TrafficMirrorPortRangeRequest] = js.undefined,
        TrafficDirection: js.UndefOr[TrafficDirection] = js.undefined
    ): ModifyTrafficMirrorFilterRuleRequest = {
      val __obj = js.Dynamic.literal(
        "TrafficMirrorFilterRuleId" -> TrafficMirrorFilterRuleId.asInstanceOf[js.Any]
      )

      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DestinationCidrBlock.foreach(__v => __obj.updateDynamic("DestinationCidrBlock")(__v.asInstanceOf[js.Any]))
      DestinationPortRange.foreach(__v => __obj.updateDynamic("DestinationPortRange")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Protocol.foreach(__v => __obj.updateDynamic("Protocol")(__v.asInstanceOf[js.Any]))
      RemoveFields.foreach(__v => __obj.updateDynamic("RemoveFields")(__v.asInstanceOf[js.Any]))
      RuleAction.foreach(__v => __obj.updateDynamic("RuleAction")(__v.asInstanceOf[js.Any]))
      RuleNumber.foreach(__v => __obj.updateDynamic("RuleNumber")(__v.asInstanceOf[js.Any]))
      SourceCidrBlock.foreach(__v => __obj.updateDynamic("SourceCidrBlock")(__v.asInstanceOf[js.Any]))
      SourcePortRange.foreach(__v => __obj.updateDynamic("SourcePortRange")(__v.asInstanceOf[js.Any]))
      TrafficDirection.foreach(__v => __obj.updateDynamic("TrafficDirection")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyTrafficMirrorFilterRuleRequest]
    }
  }

  @js.native
  trait ModifyTrafficMirrorFilterRuleResult extends js.Object {
    var TrafficMirrorFilterRule: js.UndefOr[TrafficMirrorFilterRule]
  }

  object ModifyTrafficMirrorFilterRuleResult {
    @inline
    def apply(
        TrafficMirrorFilterRule: js.UndefOr[TrafficMirrorFilterRule] = js.undefined
    ): ModifyTrafficMirrorFilterRuleResult = {
      val __obj = js.Dynamic.literal()
      TrafficMirrorFilterRule.foreach(__v => __obj.updateDynamic("TrafficMirrorFilterRule")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyTrafficMirrorFilterRuleResult]
    }
  }

  @js.native
  trait ModifyTrafficMirrorSessionRequest extends js.Object {
    var TrafficMirrorSessionId: String
    var Description: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var PacketLength: js.UndefOr[Int]
    var RemoveFields: js.UndefOr[TrafficMirrorSessionFieldList]
    var SessionNumber: js.UndefOr[Int]
    var TrafficMirrorFilterId: js.UndefOr[String]
    var TrafficMirrorTargetId: js.UndefOr[String]
    var VirtualNetworkId: js.UndefOr[Int]
  }

  object ModifyTrafficMirrorSessionRequest {
    @inline
    def apply(
        TrafficMirrorSessionId: String,
        Description: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PacketLength: js.UndefOr[Int] = js.undefined,
        RemoveFields: js.UndefOr[TrafficMirrorSessionFieldList] = js.undefined,
        SessionNumber: js.UndefOr[Int] = js.undefined,
        TrafficMirrorFilterId: js.UndefOr[String] = js.undefined,
        TrafficMirrorTargetId: js.UndefOr[String] = js.undefined,
        VirtualNetworkId: js.UndefOr[Int] = js.undefined
    ): ModifyTrafficMirrorSessionRequest = {
      val __obj = js.Dynamic.literal(
        "TrafficMirrorSessionId" -> TrafficMirrorSessionId.asInstanceOf[js.Any]
      )

      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      PacketLength.foreach(__v => __obj.updateDynamic("PacketLength")(__v.asInstanceOf[js.Any]))
      RemoveFields.foreach(__v => __obj.updateDynamic("RemoveFields")(__v.asInstanceOf[js.Any]))
      SessionNumber.foreach(__v => __obj.updateDynamic("SessionNumber")(__v.asInstanceOf[js.Any]))
      TrafficMirrorFilterId.foreach(__v => __obj.updateDynamic("TrafficMirrorFilterId")(__v.asInstanceOf[js.Any]))
      TrafficMirrorTargetId.foreach(__v => __obj.updateDynamic("TrafficMirrorTargetId")(__v.asInstanceOf[js.Any]))
      VirtualNetworkId.foreach(__v => __obj.updateDynamic("VirtualNetworkId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyTrafficMirrorSessionRequest]
    }
  }

  @js.native
  trait ModifyTrafficMirrorSessionResult extends js.Object {
    var TrafficMirrorSession: js.UndefOr[TrafficMirrorSession]
  }

  object ModifyTrafficMirrorSessionResult {
    @inline
    def apply(
        TrafficMirrorSession: js.UndefOr[TrafficMirrorSession] = js.undefined
    ): ModifyTrafficMirrorSessionResult = {
      val __obj = js.Dynamic.literal()
      TrafficMirrorSession.foreach(__v => __obj.updateDynamic("TrafficMirrorSession")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyTrafficMirrorSessionResult]
    }
  }

  @js.native
  trait ModifyTransitGatewayVpcAttachmentRequest extends js.Object {
    var TransitGatewayAttachmentId: String
    var AddSubnetIds: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var Options: js.UndefOr[ModifyTransitGatewayVpcAttachmentRequestOptions]
    var RemoveSubnetIds: js.UndefOr[ValueStringList]
  }

  object ModifyTransitGatewayVpcAttachmentRequest {
    @inline
    def apply(
        TransitGatewayAttachmentId: String,
        AddSubnetIds: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Options: js.UndefOr[ModifyTransitGatewayVpcAttachmentRequestOptions] = js.undefined,
        RemoveSubnetIds: js.UndefOr[ValueStringList] = js.undefined
    ): ModifyTransitGatewayVpcAttachmentRequest = {
      val __obj = js.Dynamic.literal(
        "TransitGatewayAttachmentId" -> TransitGatewayAttachmentId.asInstanceOf[js.Any]
      )

      AddSubnetIds.foreach(__v => __obj.updateDynamic("AddSubnetIds")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Options.foreach(__v => __obj.updateDynamic("Options")(__v.asInstanceOf[js.Any]))
      RemoveSubnetIds.foreach(__v => __obj.updateDynamic("RemoveSubnetIds")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyTransitGatewayVpcAttachmentRequest]
    }
  }

  /**
    * Describes the options for a VPC attachment.
    */
  @js.native
  trait ModifyTransitGatewayVpcAttachmentRequestOptions extends js.Object {
    var DnsSupport: js.UndefOr[DnsSupportValue]
    var Ipv6Support: js.UndefOr[Ipv6SupportValue]
  }

  object ModifyTransitGatewayVpcAttachmentRequestOptions {
    @inline
    def apply(
        DnsSupport: js.UndefOr[DnsSupportValue] = js.undefined,
        Ipv6Support: js.UndefOr[Ipv6SupportValue] = js.undefined
    ): ModifyTransitGatewayVpcAttachmentRequestOptions = {
      val __obj = js.Dynamic.literal()
      DnsSupport.foreach(__v => __obj.updateDynamic("DnsSupport")(__v.asInstanceOf[js.Any]))
      Ipv6Support.foreach(__v => __obj.updateDynamic("Ipv6Support")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyTransitGatewayVpcAttachmentRequestOptions]
    }
  }

  @js.native
  trait ModifyTransitGatewayVpcAttachmentResult extends js.Object {
    var TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment]
  }

  object ModifyTransitGatewayVpcAttachmentResult {
    @inline
    def apply(
        TransitGatewayVpcAttachment: js.UndefOr[TransitGatewayVpcAttachment] = js.undefined
    ): ModifyTransitGatewayVpcAttachmentResult = {
      val __obj = js.Dynamic.literal()
      TransitGatewayVpcAttachment.foreach(
        __v => __obj.updateDynamic("TransitGatewayVpcAttachment")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[ModifyTransitGatewayVpcAttachmentResult]
    }
  }

  /**
    * Contains the parameters for ModifyVolumeAttribute.
    */
  @js.native
  trait ModifyVolumeAttributeRequest extends js.Object {
    var VolumeId: String
    var AutoEnableIO: js.UndefOr[AttributeBooleanValue]
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyVolumeAttributeRequest {
    @inline
    def apply(
        VolumeId: String,
        AutoEnableIO: js.UndefOr[AttributeBooleanValue] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyVolumeAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "VolumeId" -> VolumeId.asInstanceOf[js.Any]
      )

      AutoEnableIO.foreach(__v => __obj.updateDynamic("AutoEnableIO")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVolumeAttributeRequest]
    }
  }

  @js.native
  trait ModifyVolumeRequest extends js.Object {
    var VolumeId: String
    var DryRun: js.UndefOr[Boolean]
    var Iops: js.UndefOr[Int]
    var Size: js.UndefOr[Int]
    var VolumeType: js.UndefOr[VolumeType]
  }

  object ModifyVolumeRequest {
    @inline
    def apply(
        VolumeId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        Iops: js.UndefOr[Int] = js.undefined,
        Size: js.UndefOr[Int] = js.undefined,
        VolumeType: js.UndefOr[VolumeType] = js.undefined
    ): ModifyVolumeRequest = {
      val __obj = js.Dynamic.literal(
        "VolumeId" -> VolumeId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      Iops.foreach(__v => __obj.updateDynamic("Iops")(__v.asInstanceOf[js.Any]))
      Size.foreach(__v => __obj.updateDynamic("Size")(__v.asInstanceOf[js.Any]))
      VolumeType.foreach(__v => __obj.updateDynamic("VolumeType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVolumeRequest]
    }
  }

  @js.native
  trait ModifyVolumeResult extends js.Object {
    var VolumeModification: js.UndefOr[VolumeModification]
  }

  object ModifyVolumeResult {
    @inline
    def apply(
        VolumeModification: js.UndefOr[VolumeModification] = js.undefined
    ): ModifyVolumeResult = {
      val __obj = js.Dynamic.literal()
      VolumeModification.foreach(__v => __obj.updateDynamic("VolumeModification")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVolumeResult]
    }
  }

  @js.native
  trait ModifyVpcAttributeRequest extends js.Object {
    var VpcId: String
    var EnableDnsHostnames: js.UndefOr[AttributeBooleanValue]
    var EnableDnsSupport: js.UndefOr[AttributeBooleanValue]
  }

  object ModifyVpcAttributeRequest {
    @inline
    def apply(
        VpcId: String,
        EnableDnsHostnames: js.UndefOr[AttributeBooleanValue] = js.undefined,
        EnableDnsSupport: js.UndefOr[AttributeBooleanValue] = js.undefined
    ): ModifyVpcAttributeRequest = {
      val __obj = js.Dynamic.literal(
        "VpcId" -> VpcId.asInstanceOf[js.Any]
      )

      EnableDnsHostnames.foreach(__v => __obj.updateDynamic("EnableDnsHostnames")(__v.asInstanceOf[js.Any]))
      EnableDnsSupport.foreach(__v => __obj.updateDynamic("EnableDnsSupport")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpcAttributeRequest]
    }
  }

  @js.native
  trait ModifyVpcEndpointConnectionNotificationRequest extends js.Object {
    var ConnectionNotificationId: String
    var ConnectionEvents: js.UndefOr[ValueStringList]
    var ConnectionNotificationArn: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyVpcEndpointConnectionNotificationRequest {
    @inline
    def apply(
        ConnectionNotificationId: String,
        ConnectionEvents: js.UndefOr[ValueStringList] = js.undefined,
        ConnectionNotificationArn: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcEndpointConnectionNotificationRequest = {
      val __obj = js.Dynamic.literal(
        "ConnectionNotificationId" -> ConnectionNotificationId.asInstanceOf[js.Any]
      )

      ConnectionEvents.foreach(__v => __obj.updateDynamic("ConnectionEvents")(__v.asInstanceOf[js.Any]))
      ConnectionNotificationArn.foreach(
        __v => __obj.updateDynamic("ConnectionNotificationArn")(__v.asInstanceOf[js.Any])
      )
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpcEndpointConnectionNotificationRequest]
    }
  }

  @js.native
  trait ModifyVpcEndpointConnectionNotificationResult extends js.Object {
    var ReturnValue: js.UndefOr[Boolean]
  }

  object ModifyVpcEndpointConnectionNotificationResult {
    @inline
    def apply(
        ReturnValue: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcEndpointConnectionNotificationResult = {
      val __obj = js.Dynamic.literal()
      ReturnValue.foreach(__v => __obj.updateDynamic("ReturnValue")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpcEndpointConnectionNotificationResult]
    }
  }

  /**
    * Contains the parameters for ModifyVpcEndpoint.
    */
  @js.native
  trait ModifyVpcEndpointRequest extends js.Object {
    var VpcEndpointId: String
    var AddRouteTableIds: js.UndefOr[ValueStringList]
    var AddSecurityGroupIds: js.UndefOr[ValueStringList]
    var AddSubnetIds: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var PolicyDocument: js.UndefOr[String]
    var PrivateDnsEnabled: js.UndefOr[Boolean]
    var RemoveRouteTableIds: js.UndefOr[ValueStringList]
    var RemoveSecurityGroupIds: js.UndefOr[ValueStringList]
    var RemoveSubnetIds: js.UndefOr[ValueStringList]
    var ResetPolicy: js.UndefOr[Boolean]
  }

  object ModifyVpcEndpointRequest {
    @inline
    def apply(
        VpcEndpointId: String,
        AddRouteTableIds: js.UndefOr[ValueStringList] = js.undefined,
        AddSecurityGroupIds: js.UndefOr[ValueStringList] = js.undefined,
        AddSubnetIds: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        PolicyDocument: js.UndefOr[String] = js.undefined,
        PrivateDnsEnabled: js.UndefOr[Boolean] = js.undefined,
        RemoveRouteTableIds: js.UndefOr[ValueStringList] = js.undefined,
        RemoveSecurityGroupIds: js.UndefOr[ValueStringList] = js.undefined,
        RemoveSubnetIds: js.UndefOr[ValueStringList] = js.undefined,
        ResetPolicy: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcEndpointRequest = {
      val __obj = js.Dynamic.literal(
        "VpcEndpointId" -> VpcEndpointId.asInstanceOf[js.Any]
      )

      AddRouteTableIds.foreach(__v => __obj.updateDynamic("AddRouteTableIds")(__v.asInstanceOf[js.Any]))
      AddSecurityGroupIds.foreach(__v => __obj.updateDynamic("AddSecurityGroupIds")(__v.asInstanceOf[js.Any]))
      AddSubnetIds.foreach(__v => __obj.updateDynamic("AddSubnetIds")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      PolicyDocument.foreach(__v => __obj.updateDynamic("PolicyDocument")(__v.asInstanceOf[js.Any]))
      PrivateDnsEnabled.foreach(__v => __obj.updateDynamic("PrivateDnsEnabled")(__v.asInstanceOf[js.Any]))
      RemoveRouteTableIds.foreach(__v => __obj.updateDynamic("RemoveRouteTableIds")(__v.asInstanceOf[js.Any]))
      RemoveSecurityGroupIds.foreach(__v => __obj.updateDynamic("RemoveSecurityGroupIds")(__v.asInstanceOf[js.Any]))
      RemoveSubnetIds.foreach(__v => __obj.updateDynamic("RemoveSubnetIds")(__v.asInstanceOf[js.Any]))
      ResetPolicy.foreach(__v => __obj.updateDynamic("ResetPolicy")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpcEndpointRequest]
    }
  }

  @js.native
  trait ModifyVpcEndpointResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyVpcEndpointResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcEndpointResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpcEndpointResult]
    }
  }

  @js.native
  trait ModifyVpcEndpointServiceConfigurationRequest extends js.Object {
    var ServiceId: String
    var AcceptanceRequired: js.UndefOr[Boolean]
    var AddNetworkLoadBalancerArns: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var RemoveNetworkLoadBalancerArns: js.UndefOr[ValueStringList]
  }

  object ModifyVpcEndpointServiceConfigurationRequest {
    @inline
    def apply(
        ServiceId: String,
        AcceptanceRequired: js.UndefOr[Boolean] = js.undefined,
        AddNetworkLoadBalancerArns: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        RemoveNetworkLoadBalancerArns: js.UndefOr[ValueStringList] = js.undefined
    ): ModifyVpcEndpointServiceConfigurationRequest = {
      val __obj = js.Dynamic.literal(
        "ServiceId" -> ServiceId.asInstanceOf[js.Any]
      )

      AcceptanceRequired.foreach(__v => __obj.updateDynamic("AcceptanceRequired")(__v.asInstanceOf[js.Any]))
      AddNetworkLoadBalancerArns.foreach(
        __v => __obj.updateDynamic("AddNetworkLoadBalancerArns")(__v.asInstanceOf[js.Any])
      )
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      RemoveNetworkLoadBalancerArns.foreach(
        __v => __obj.updateDynamic("RemoveNetworkLoadBalancerArns")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[ModifyVpcEndpointServiceConfigurationRequest]
    }
  }

  @js.native
  trait ModifyVpcEndpointServiceConfigurationResult extends js.Object {
    var Return: js.UndefOr[Boolean]
  }

  object ModifyVpcEndpointServiceConfigurationResult {
    @inline
    def apply(
        Return: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcEndpointServiceConfigurationResult = {
      val __obj = js.Dynamic.literal()
      Return.foreach(__v => __obj.updateDynamic("Return")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpcEndpointServiceConfigurationResult]
    }
  }

  @js.native
  trait ModifyVpcEndpointServicePermissionsRequest extends js.Object {
    var ServiceId: String
    var AddAllowedPrincipals: js.UndefOr[ValueStringList]
    var DryRun: js.UndefOr[Boolean]
    var RemoveAllowedPrincipals: js.UndefOr[ValueStringList]
  }

  object ModifyVpcEndpointServicePermissionsRequest {
    @inline
    def apply(
        ServiceId: String,
        AddAllowedPrincipals: js.UndefOr[ValueStringList] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        RemoveAllowedPrincipals: js.UndefOr[ValueStringList] = js.undefined
    ): ModifyVpcEndpointServicePermissionsRequest = {
      val __obj = js.Dynamic.literal(
        "ServiceId" -> ServiceId.asInstanceOf[js.Any]
      )

      AddAllowedPrincipals.foreach(__v => __obj.updateDynamic("AddAllowedPrincipals")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      RemoveAllowedPrincipals.foreach(__v => __obj.updateDynamic("RemoveAllowedPrincipals")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpcEndpointServicePermissionsRequest]
    }
  }

  @js.native
  trait ModifyVpcEndpointServicePermissionsResult extends js.Object {
    var ReturnValue: js.UndefOr[Boolean]
  }

  object ModifyVpcEndpointServicePermissionsResult {
    @inline
    def apply(
        ReturnValue: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcEndpointServicePermissionsResult = {
      val __obj = js.Dynamic.literal()
      ReturnValue.foreach(__v => __obj.updateDynamic("ReturnValue")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpcEndpointServicePermissionsResult]
    }
  }

  @js.native
  trait ModifyVpcPeeringConnectionOptionsRequest extends js.Object {
    var VpcPeeringConnectionId: String
    var AccepterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptionsRequest]
    var DryRun: js.UndefOr[Boolean]
    var RequesterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptionsRequest]
  }

  object ModifyVpcPeeringConnectionOptionsRequest {
    @inline
    def apply(
        VpcPeeringConnectionId: String,
        AccepterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptionsRequest] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        RequesterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptionsRequest] = js.undefined
    ): ModifyVpcPeeringConnectionOptionsRequest = {
      val __obj = js.Dynamic.literal(
        "VpcPeeringConnectionId" -> VpcPeeringConnectionId.asInstanceOf[js.Any]
      )

      AccepterPeeringConnectionOptions.foreach(
        __v => __obj.updateDynamic("AccepterPeeringConnectionOptions")(__v.asInstanceOf[js.Any])
      )
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      RequesterPeeringConnectionOptions.foreach(
        __v => __obj.updateDynamic("RequesterPeeringConnectionOptions")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[ModifyVpcPeeringConnectionOptionsRequest]
    }
  }

  @js.native
  trait ModifyVpcPeeringConnectionOptionsResult extends js.Object {
    var AccepterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptions]
    var RequesterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptions]
  }

  object ModifyVpcPeeringConnectionOptionsResult {
    @inline
    def apply(
        AccepterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptions] = js.undefined,
        RequesterPeeringConnectionOptions: js.UndefOr[PeeringConnectionOptions] = js.undefined
    ): ModifyVpcPeeringConnectionOptionsResult = {
      val __obj = js.Dynamic.literal()
      AccepterPeeringConnectionOptions.foreach(
        __v => __obj.updateDynamic("AccepterPeeringConnectionOptions")(__v.asInstanceOf[js.Any])
      )
      RequesterPeeringConnectionOptions.foreach(
        __v => __obj.updateDynamic("RequesterPeeringConnectionOptions")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[ModifyVpcPeeringConnectionOptionsResult]
    }
  }

  @js.native
  trait ModifyVpcTenancyRequest extends js.Object {
    var InstanceTenancy: VpcTenancy
    var VpcId: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyVpcTenancyRequest {
    @inline
    def apply(
        InstanceTenancy: VpcTenancy,
        VpcId: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcTenancyRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceTenancy" -> InstanceTenancy.asInstanceOf[js.Any],
        "VpcId"           -> VpcId.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpcTenancyRequest]
    }
  }

  @js.native
  trait ModifyVpcTenancyResult extends js.Object {
    var ReturnValue: js.UndefOr[Boolean]
  }

  object ModifyVpcTenancyResult {
    @inline
    def apply(
        ReturnValue: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpcTenancyResult = {
      val __obj = js.Dynamic.literal()
      ReturnValue.foreach(__v => __obj.updateDynamic("ReturnValue")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpcTenancyResult]
    }
  }

  @js.native
  trait ModifyVpnConnectionRequest extends js.Object {
    var VpnConnectionId: String
    var CustomerGatewayId: js.UndefOr[String]
    var DryRun: js.UndefOr[Boolean]
    var TransitGatewayId: js.UndefOr[String]
    var VpnGatewayId: js.UndefOr[String]
  }

  object ModifyVpnConnectionRequest {
    @inline
    def apply(
        VpnConnectionId: String,
        CustomerGatewayId: js.UndefOr[String] = js.undefined,
        DryRun: js.UndefOr[Boolean] = js.undefined,
        TransitGatewayId: js.UndefOr[String] = js.undefined,
        VpnGatewayId: js.UndefOr[String] = js.undefined
    ): ModifyVpnConnectionRequest = {
      val __obj = js.Dynamic.literal(
        "VpnConnectionId" -> VpnConnectionId.asInstanceOf[js.Any]
      )

      CustomerGatewayId.foreach(__v => __obj.updateDynamic("CustomerGatewayId")(__v.asInstanceOf[js.Any]))
      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      TransitGatewayId.foreach(__v => __obj.updateDynamic("TransitGatewayId")(__v.asInstanceOf[js.Any]))
      VpnGatewayId.foreach(__v => __obj.updateDynamic("VpnGatewayId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpnConnectionRequest]
    }
  }

  @js.native
  trait ModifyVpnConnectionResult extends js.Object {
    var VpnConnection: js.UndefOr[VpnConnection]
  }

  object ModifyVpnConnectionResult {
    @inline
    def apply(
        VpnConnection: js.UndefOr[VpnConnection] = js.undefined
    ): ModifyVpnConnectionResult = {
      val __obj = js.Dynamic.literal()
      VpnConnection.foreach(__v => __obj.updateDynamic("VpnConnection")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpnConnectionResult]
    }
  }

  @js.native
  trait ModifyVpnTunnelCertificateRequest extends js.Object {
    var VpnConnectionId: String
    var VpnTunnelOutsideIpAddress: String
    var DryRun: js.UndefOr[Boolean]
  }

  object ModifyVpnTunnelCertificateRequest {
    @inline
    def apply(
        VpnConnectionId: String,
        VpnTunnelOutsideIpAddress: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): ModifyVpnTunnelCertificateRequest = {
      val __obj = js.Dynamic.literal(
        "VpnConnectionId"           -> VpnConnectionId.asInstanceOf[js.Any],
        "VpnTunnelOutsideIpAddress" -> VpnTunnelOutsideIpAddress.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpnTunnelCertificateRequest]
    }
  }

  @js.native
  trait ModifyVpnTunnelCertificateResult extends js.Object {
    var VpnConnection: js.UndefOr[VpnConnection]
  }

  object ModifyVpnTunnelCertificateResult {
    @inline
    def apply(
        VpnConnection: js.UndefOr[VpnConnection] = js.undefined
    ): ModifyVpnTunnelCertificateResult = {
      val __obj = js.Dynamic.literal()
      VpnConnection.foreach(__v => __obj.updateDynamic("VpnConnection")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[ModifyVpnTunnelCertificateResult]
    }
  }

  @js.native
  trait MonitorInstancesRequest extends js.Object {
    var InstanceIds: InstanceIdStringList
    var DryRun: js.UndefOr[Boolean]
  }

  object MonitorInstancesRequest {
    @inline
    def apply(
        InstanceIds: InstanceIdStringList,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): MonitorInstancesRequest = {
      val __obj = js.Dynamic.literal(
        "InstanceIds" -> InstanceIds.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[MonitorInstancesRequest]
    }
  }

  @js.native
  trait MonitorInstancesResult extends js.Object {
    var InstanceMonitorings: js.UndefOr[InstanceMonitoringList]
  }

  object MonitorInstancesResult {
    @inline
    def apply(
        InstanceMonitorings: js.UndefOr[InstanceMonitoringList] = js.undefined
    ): MonitorInstancesResult = {
      val __obj = js.Dynamic.literal()
      InstanceMonitorings.foreach(__v => __obj.updateDynamic("InstanceMonitorings")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[MonitorInstancesResult]
    }
  }

  /**
    * Describes the monitoring of an instance.
    */
  @js.native
  trait Monitoring extends js.Object {
    var State: js.UndefOr[MonitoringState]
  }

  object Monitoring {
    @inline
    def apply(
        State: js.UndefOr[MonitoringState] = js.undefined
    ): Monitoring = {
      val __obj = js.Dynamic.literal()
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[Monitoring]
    }
  }

  object MonitoringStateEnum {
    val disabled  = "disabled"
    val disabling = "disabling"
    val enabled   = "enabled"
    val pending   = "pending"

    val values = js.Object.freeze(js.Array(disabled, disabling, enabled, pending))
  }

  @js.native
  trait MoveAddressToVpcRequest extends js.Object {
    var PublicIp: String
    var DryRun: js.UndefOr[Boolean]
  }

  object MoveAddressToVpcRequest {
    @inline
    def apply(
        PublicIp: String,
        DryRun: js.UndefOr[Boolean] = js.undefined
    ): MoveAddressToVpcRequest = {
      val __obj = js.Dynamic.literal(
        "PublicIp" -> PublicIp.asInstanceOf[js.Any]
      )

      DryRun.foreach(__v => __obj.updateDynamic("DryRun")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[MoveAddressToVpcRequest]
    }
  }

  @js.native
  trait MoveAddressToVpcResult extends js.Object {
    var AllocationId: js.UndefOr[String]
    var Status: js.UndefOr[Status]
  }

  object MoveAddressToVpcResult {
    @inline
    def apply(
        AllocationId: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[Status] = js.undefined
    ): MoveAddressToVpcResult = {
      val __obj = js.Dynamic.literal()
      AllocationId.foreach(__v => __obj.updateDynamic("AllocationId")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[MoveAddressToVpcResult]
    }
  }

  object MoveStatusEnum {
    val movingToVpc        = "movingToVpc"
    val restoringToClassic = "restoringToClassic"

    val values = js.Object.freeze(js.Array(movingToVpc, restoringToClassic))
  }

  /**
    * Describes the status of a moving Elastic IP address.
    */
  @js.native
  trait MovingAddressStatus extends js.Object {
    var MoveStatus: js.UndefOr[MoveStatus]
    var PublicIp: js.UndefOr[String]
  }

  object MovingAddressStatus {
    @inline
    def apply(
        MoveStatus: js.UndefOr[MoveStatus] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): MovingAddressStatus = {
      val __obj = js.Dynamic.literal()
      MoveStatus.foreach(__v => __obj.updateDynamic("MoveStatus")(__v.asInstanceOf[js.Any]))
      PublicIp.foreach(__v => __obj.updateDynamic("PublicIp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[MovingAddressStatus]
    }
  }

  /**
    * Describes a NAT gateway.
    */
  @js.native
  trait NatGateway extends js.Object {
    var CreateTime: js.UndefOr[DateTime]
    var DeleteTime: js.UndefOr[DateTime]
    var FailureCode: js.UndefOr[String]
    var FailureMessage: js.UndefOr[String]
    var NatGatewayAddresses: js.UndefOr[NatGatewayAddressList]
    var NatGatewayId: js.UndefOr[String]
    var ProvisionedBandwidth: js.UndefOr[ProvisionedBandwidth]
    var State: js.UndefOr[NatGatewayState]
    var SubnetId: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
    var VpcId: js.UndefOr[String]
  }

  object NatGateway {
    @inline
    def apply(
        CreateTime: js.UndefOr[DateTime] = js.undefined,
        DeleteTime: js.UndefOr[DateTime] = js.undefined,
        FailureCode: js.UndefOr[String] = js.undefined,
        FailureMessage: js.UndefOr[String] = js.undefined,
        NatGatewayAddresses: js.UndefOr[NatGatewayAddressList] = js.undefined,
        NatGatewayId: js.UndefOr[String] = js.undefined,
        ProvisionedBandwidth: js.UndefOr[ProvisionedBandwidth] = js.undefined,
        State: js.UndefOr[NatGatewayState] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): NatGateway = {
      val __obj = js.Dynamic.literal()
      CreateTime.foreach(__v => __obj.updateDynamic("CreateTime")(__v.asInstanceOf[js.Any]))
      DeleteTime.foreach(__v => __obj.updateDynamic("DeleteTime")(__v.asInstanceOf[js.Any]))
      FailureCode.foreach(__v => __obj.updateDynamic("FailureCode")(__v.asInstanceOf[js.Any]))
      FailureMessage.foreach(__v => __obj.updateDynamic("FailureMessage")(__v.asInstanceOf[js.Any]))
      NatGatewayAddresses.foreach(__v => __obj.updateDynamic("NatGatewayAddresses")(__v.asInstanceOf[js.Any]))
      NatGatewayId.foreach(__v => __obj.updateDynamic("NatGatewayId")(__v.asInstanceOf[js.Any]))
      ProvisionedBandwidth.foreach(__v => __obj.updateDynamic("ProvisionedBandwidth")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NatGateway]
    }
  }

  /**
    * Describes the IP addresses and network interface associated with a NAT gateway.
    */
  @js.native
  trait NatGatewayAddress extends js.Object {
    var AllocationId: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var PrivateIp: js.UndefOr[String]
    var PublicIp: js.UndefOr[String]
  }

  object NatGatewayAddress {
    @inline
    def apply(
        AllocationId: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        PrivateIp: js.UndefOr[String] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): NatGatewayAddress = {
      val __obj = js.Dynamic.literal()
      AllocationId.foreach(__v => __obj.updateDynamic("AllocationId")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      PrivateIp.foreach(__v => __obj.updateDynamic("PrivateIp")(__v.asInstanceOf[js.Any]))
      PublicIp.foreach(__v => __obj.updateDynamic("PublicIp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NatGatewayAddress]
    }
  }

  object NatGatewayStateEnum {
    val pending   = "pending"
    val failed    = "failed"
    val available = "available"
    val deleting  = "deleting"
    val deleted   = "deleted"

    val values = js.Object.freeze(js.Array(pending, failed, available, deleting, deleted))
  }

  /**
    * Describes a network ACL.
    */
  @js.native
  trait NetworkAcl extends js.Object {
    var Associations: js.UndefOr[NetworkAclAssociationList]
    var Entries: js.UndefOr[NetworkAclEntryList]
    var IsDefault: js.UndefOr[Boolean]
    var NetworkAclId: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var Tags: js.UndefOr[TagList]
    var VpcId: js.UndefOr[String]
  }

  object NetworkAcl {
    @inline
    def apply(
        Associations: js.UndefOr[NetworkAclAssociationList] = js.undefined,
        Entries: js.UndefOr[NetworkAclEntryList] = js.undefined,
        IsDefault: js.UndefOr[Boolean] = js.undefined,
        NetworkAclId: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        Tags: js.UndefOr[TagList] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): NetworkAcl = {
      val __obj = js.Dynamic.literal()
      Associations.foreach(__v => __obj.updateDynamic("Associations")(__v.asInstanceOf[js.Any]))
      Entries.foreach(__v => __obj.updateDynamic("Entries")(__v.asInstanceOf[js.Any]))
      IsDefault.foreach(__v => __obj.updateDynamic("IsDefault")(__v.asInstanceOf[js.Any]))
      NetworkAclId.foreach(__v => __obj.updateDynamic("NetworkAclId")(__v.asInstanceOf[js.Any]))
      OwnerId.foreach(__v => __obj.updateDynamic("OwnerId")(__v.asInstanceOf[js.Any]))
      Tags.foreach(__v => __obj.updateDynamic("Tags")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NetworkAcl]
    }
  }

  /**
    * Describes an association between a network ACL and a subnet.
    */
  @js.native
  trait NetworkAclAssociation extends js.Object {
    var NetworkAclAssociationId: js.UndefOr[String]
    var NetworkAclId: js.UndefOr[String]
    var SubnetId: js.UndefOr[String]
  }

  object NetworkAclAssociation {
    @inline
    def apply(
        NetworkAclAssociationId: js.UndefOr[String] = js.undefined,
        NetworkAclId: js.UndefOr[String] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined
    ): NetworkAclAssociation = {
      val __obj = js.Dynamic.literal()
      NetworkAclAssociationId.foreach(__v => __obj.updateDynamic("NetworkAclAssociationId")(__v.asInstanceOf[js.Any]))
      NetworkAclId.foreach(__v => __obj.updateDynamic("NetworkAclId")(__v.asInstanceOf[js.Any]))
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NetworkAclAssociation]
    }
  }

  /**
    * Describes an entry in a network ACL.
    */
  @js.native
  trait NetworkAclEntry extends js.Object {
    var CidrBlock: js.UndefOr[String]
    var Egress: js.UndefOr[Boolean]
    var IcmpTypeCode: js.UndefOr[IcmpTypeCode]
    var Ipv6CidrBlock: js.UndefOr[String]
    var PortRange: js.UndefOr[PortRange]
    var Protocol: js.UndefOr[String]
    var RuleAction: js.UndefOr[RuleAction]
    var RuleNumber: js.UndefOr[Int]
  }

  object NetworkAclEntry {
    @inline
    def apply(
        CidrBlock: js.UndefOr[String] = js.undefined,
        Egress: js.UndefOr[Boolean] = js.undefined,
        IcmpTypeCode: js.UndefOr[IcmpTypeCode] = js.undefined,
        Ipv6CidrBlock: js.UndefOr[String] = js.undefined,
        PortRange: js.UndefOr[PortRange] = js.undefined,
        Protocol: js.UndefOr[String] = js.undefined,
        RuleAction: js.UndefOr[RuleAction] = js.undefined,
        RuleNumber: js.UndefOr[Int] = js.undefined
    ): NetworkAclEntry = {
      val __obj = js.Dynamic.literal()
      CidrBlock.foreach(__v => __obj.updateDynamic("CidrBlock")(__v.asInstanceOf[js.Any]))
      Egress.foreach(__v => __obj.updateDynamic("Egress")(__v.asInstanceOf[js.Any]))
      IcmpTypeCode.foreach(__v => __obj.updateDynamic("IcmpTypeCode")(__v.asInstanceOf[js.Any]))
      Ipv6CidrBlock.foreach(__v => __obj.updateDynamic("Ipv6CidrBlock")(__v.asInstanceOf[js.Any]))
      PortRange.foreach(__v => __obj.updateDynamic("PortRange")(__v.asInstanceOf[js.Any]))
      Protocol.foreach(__v => __obj.updateDynamic("Protocol")(__v.asInstanceOf[js.Any]))
      RuleAction.foreach(__v => __obj.updateDynamic("RuleAction")(__v.asInstanceOf[js.Any]))
      RuleNumber.foreach(__v => __obj.updateDynamic("RuleNumber")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NetworkAclEntry]
    }
  }

  /**
    * Describes a network interface.
    */
  @js.native
  trait NetworkInterface extends js.Object {
    var Association: js.UndefOr[NetworkInterfaceAssociation]
    var Attachment: js.UndefOr[NetworkInterfaceAttachment]
    var AvailabilityZone: js.UndefOr[String]
    var Description: js.UndefOr[String]
    var Groups: js.UndefOr[GroupIdentifierList]
    var InterfaceType: js.UndefOr[NetworkInterfaceType]
    var Ipv6Addresses: js.UndefOr[NetworkInterfaceIpv6AddressesList]
    var MacAddress: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var OwnerId: js.UndefOr[String]
    var PrivateDnsName: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
    var PrivateIpAddresses: js.UndefOr[NetworkInterfacePrivateIpAddressList]
    var RequesterId: js.UndefOr[String]
    var RequesterManaged: js.UndefOr[Boolean]
    var SourceDestCheck: js.UndefOr[Boolean]
    var Status: js.UndefOr[NetworkInterfaceStatus]
    var SubnetId: js.UndefOr[String]
    var TagSet: js.UndefOr[TagList]
    var VpcId: js.UndefOr[String]
  }

  object NetworkInterface {
    @inline
    def apply(
        Association: js.UndefOr[NetworkInterfaceAssociation] = js.undefined,
        Attachment: js.UndefOr[NetworkInterfaceAttachment] = js.undefined,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        Description: js.UndefOr[String] = js.undefined,
        Groups: js.UndefOr[GroupIdentifierList] = js.undefined,
        InterfaceType: js.UndefOr[NetworkInterfaceType] = js.undefined,
        Ipv6Addresses: js.UndefOr[NetworkInterfaceIpv6AddressesList] = js.undefined,
        MacAddress: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        OwnerId: js.UndefOr[String] = js.undefined,
        PrivateDnsName: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined,
        PrivateIpAddresses: js.UndefOr[NetworkInterfacePrivateIpAddressList] = js.undefined,
        RequesterId: js.UndefOr[String] = js.undefined,
        RequesterManaged: js.UndefOr[Boolean] = js.undefined,
        SourceDestCheck: js.UndefOr[Boolean] = js.undefined,
        Status: js.UndefOr[NetworkInterfaceStatus] = js.undefined,
        SubnetId: js.UndefOr[String] = js.undefined,
        TagSet: js.UndefOr[TagList] = js.undefined,
        VpcId: js.UndefOr[String] = js.undefined
    ): NetworkInterface = {
      val __obj = js.Dynamic.literal()
      Association.foreach(__v => __obj.updateDynamic("Association")(__v.asInstanceOf[js.Any]))
      Attachment.foreach(__v => __obj.updateDynamic("Attachment")(__v.asInstanceOf[js.Any]))
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      Groups.foreach(__v => __obj.updateDynamic("Groups")(__v.asInstanceOf[js.Any]))
      InterfaceType.foreach(__v => __obj.updateDynamic("InterfaceType")(__v.asInstanceOf[js.Any]))
      Ipv6Addresses.foreach(__v => __obj.updateDynamic("Ipv6Addresses")(__v.asInstanceOf[js.Any]))
      MacAddress.foreach(__v => __obj.updateDynamic("MacAddress")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      OwnerId.foreach(__v => __obj.updateDynamic("OwnerId")(__v.asInstanceOf[js.Any]))
      PrivateDnsName.foreach(__v => __obj.updateDynamic("PrivateDnsName")(__v.asInstanceOf[js.Any]))
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      PrivateIpAddresses.foreach(__v => __obj.updateDynamic("PrivateIpAddresses")(__v.asInstanceOf[js.Any]))
      RequesterId.foreach(__v => __obj.updateDynamic("RequesterId")(__v.asInstanceOf[js.Any]))
      RequesterManaged.foreach(__v => __obj.updateDynamic("RequesterManaged")(__v.asInstanceOf[js.Any]))
      SourceDestCheck.foreach(__v => __obj.updateDynamic("SourceDestCheck")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      SubnetId.foreach(__v => __obj.updateDynamic("SubnetId")(__v.asInstanceOf[js.Any]))
      TagSet.foreach(__v => __obj.updateDynamic("TagSet")(__v.asInstanceOf[js.Any]))
      VpcId.foreach(__v => __obj.updateDynamic("VpcId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NetworkInterface]
    }
  }

  /**
    * Describes association information for an Elastic IP address (IPv4 only).
    */
  @js.native
  trait NetworkInterfaceAssociation extends js.Object {
    var AllocationId: js.UndefOr[String]
    var AssociationId: js.UndefOr[String]
    var IpOwnerId: js.UndefOr[String]
    var PublicDnsName: js.UndefOr[String]
    var PublicIp: js.UndefOr[String]
  }

  object NetworkInterfaceAssociation {
    @inline
    def apply(
        AllocationId: js.UndefOr[String] = js.undefined,
        AssociationId: js.UndefOr[String] = js.undefined,
        IpOwnerId: js.UndefOr[String] = js.undefined,
        PublicDnsName: js.UndefOr[String] = js.undefined,
        PublicIp: js.UndefOr[String] = js.undefined
    ): NetworkInterfaceAssociation = {
      val __obj = js.Dynamic.literal()
      AllocationId.foreach(__v => __obj.updateDynamic("AllocationId")(__v.asInstanceOf[js.Any]))
      AssociationId.foreach(__v => __obj.updateDynamic("AssociationId")(__v.asInstanceOf[js.Any]))
      IpOwnerId.foreach(__v => __obj.updateDynamic("IpOwnerId")(__v.asInstanceOf[js.Any]))
      PublicDnsName.foreach(__v => __obj.updateDynamic("PublicDnsName")(__v.asInstanceOf[js.Any]))
      PublicIp.foreach(__v => __obj.updateDynamic("PublicIp")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NetworkInterfaceAssociation]
    }
  }

  /**
    * Describes a network interface attachment.
    */
  @js.native
  trait NetworkInterfaceAttachment extends js.Object {
    var AttachTime: js.UndefOr[DateTime]
    var AttachmentId: js.UndefOr[String]
    var DeleteOnTermination: js.UndefOr[Boolean]
    var DeviceIndex: js.UndefOr[Int]
    var InstanceId: js.UndefOr[String]
    var InstanceOwnerId: js.UndefOr[String]
    var Status: js.UndefOr[AttachmentStatus]
  }

  object NetworkInterfaceAttachment {
    @inline
    def apply(
        AttachTime: js.UndefOr[DateTime] = js.undefined,
        AttachmentId: js.UndefOr[String] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined,
        DeviceIndex: js.UndefOr[Int] = js.undefined,
        InstanceId: js.UndefOr[String] = js.undefined,
        InstanceOwnerId: js.UndefOr[String] = js.undefined,
        Status: js.UndefOr[AttachmentStatus] = js.undefined
    ): NetworkInterfaceAttachment = {
      val __obj = js.Dynamic.literal()
      AttachTime.foreach(__v => __obj.updateDynamic("AttachTime")(__v.asInstanceOf[js.Any]))
      AttachmentId.foreach(__v => __obj.updateDynamic("AttachmentId")(__v.asInstanceOf[js.Any]))
      DeleteOnTermination.foreach(__v => __obj.updateDynamic("DeleteOnTermination")(__v.asInstanceOf[js.Any]))
      DeviceIndex.foreach(__v => __obj.updateDynamic("DeviceIndex")(__v.asInstanceOf[js.Any]))
      InstanceId.foreach(__v => __obj.updateDynamic("InstanceId")(__v.asInstanceOf[js.Any]))
      InstanceOwnerId.foreach(__v => __obj.updateDynamic("InstanceOwnerId")(__v.asInstanceOf[js.Any]))
      Status.foreach(__v => __obj.updateDynamic("Status")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NetworkInterfaceAttachment]
    }
  }

  /**
    * Describes an attachment change.
    */
  @js.native
  trait NetworkInterfaceAttachmentChanges extends js.Object {
    var AttachmentId: js.UndefOr[String]
    var DeleteOnTermination: js.UndefOr[Boolean]
  }

  object NetworkInterfaceAttachmentChanges {
    @inline
    def apply(
        AttachmentId: js.UndefOr[String] = js.undefined,
        DeleteOnTermination: js.UndefOr[Boolean] = js.undefined
    ): NetworkInterfaceAttachmentChanges = {
      val __obj = js.Dynamic.literal()
      AttachmentId.foreach(__v => __obj.updateDynamic("AttachmentId")(__v.asInstanceOf[js.Any]))
      DeleteOnTermination.foreach(__v => __obj.updateDynamic("DeleteOnTermination")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NetworkInterfaceAttachmentChanges]
    }
  }

  object NetworkInterfaceAttributeEnum {
    val description     = "description"
    val groupSet        = "groupSet"
    val sourceDestCheck = "sourceDestCheck"
    val attachment      = "attachment"

    val values = js.Object.freeze(js.Array(description, groupSet, sourceDestCheck, attachment))
  }

  object NetworkInterfaceCreationTypeEnum {
    val efa = "efa"

    val values = js.Object.freeze(js.Array(efa))
  }

  /**
    * Describes an IPv6 address associated with a network interface.
    */
  @js.native
  trait NetworkInterfaceIpv6Address extends js.Object {
    var Ipv6Address: js.UndefOr[String]
  }

  object NetworkInterfaceIpv6Address {
    @inline
    def apply(
        Ipv6Address: js.UndefOr[String] = js.undefined
    ): NetworkInterfaceIpv6Address = {
      val __obj = js.Dynamic.literal()
      Ipv6Address.foreach(__v => __obj.updateDynamic("Ipv6Address")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NetworkInterfaceIpv6Address]
    }
  }

  /**
    * Describes a permission for a network interface.
    */
  @js.native
  trait NetworkInterfacePermission extends js.Object {
    var AwsAccountId: js.UndefOr[String]
    var AwsService: js.UndefOr[String]
    var NetworkInterfaceId: js.UndefOr[String]
    var NetworkInterfacePermissionId: js.UndefOr[String]
    var Permission: js.UndefOr[InterfacePermissionType]
    var PermissionState: js.UndefOr[NetworkInterfacePermissionState]
  }

  object NetworkInterfacePermission {
    @inline
    def apply(
        AwsAccountId: js.UndefOr[String] = js.undefined,
        AwsService: js.UndefOr[String] = js.undefined,
        NetworkInterfaceId: js.UndefOr[String] = js.undefined,
        NetworkInterfacePermissionId: js.UndefOr[String] = js.undefined,
        Permission: js.UndefOr[InterfacePermissionType] = js.undefined,
        PermissionState: js.UndefOr[NetworkInterfacePermissionState] = js.undefined
    ): NetworkInterfacePermission = {
      val __obj = js.Dynamic.literal()
      AwsAccountId.foreach(__v => __obj.updateDynamic("AwsAccountId")(__v.asInstanceOf[js.Any]))
      AwsService.foreach(__v => __obj.updateDynamic("AwsService")(__v.asInstanceOf[js.Any]))
      NetworkInterfaceId.foreach(__v => __obj.updateDynamic("NetworkInterfaceId")(__v.asInstanceOf[js.Any]))
      NetworkInterfacePermissionId.foreach(
        __v => __obj.updateDynamic("NetworkInterfacePermissionId")(__v.asInstanceOf[js.Any])
      )
      Permission.foreach(__v => __obj.updateDynamic("Permission")(__v.asInstanceOf[js.Any]))
      PermissionState.foreach(__v => __obj.updateDynamic("PermissionState")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NetworkInterfacePermission]
    }
  }

  /**
    * Describes the state of a network interface permission.
    */
  @js.native
  trait NetworkInterfacePermissionState extends js.Object {
    var State: js.UndefOr[NetworkInterfacePermissionStateCode]
    var StatusMessage: js.UndefOr[String]
  }

  object NetworkInterfacePermissionState {
    @inline
    def apply(
        State: js.UndefOr[NetworkInterfacePermissionStateCode] = js.undefined,
        StatusMessage: js.UndefOr[String] = js.undefined
    ): NetworkInterfacePermissionState = {
      val __obj = js.Dynamic.literal()
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      StatusMessage.foreach(__v => __obj.updateDynamic("StatusMessage")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NetworkInterfacePermissionState]
    }
  }

  object NetworkInterfacePermissionStateCodeEnum {
    val pending  = "pending"
    val granted  = "granted"
    val revoking = "revoking"
    val revoked  = "revoked"

    val values = js.Object.freeze(js.Array(pending, granted, revoking, revoked))
  }

  /**
    * Describes the private IPv4 address of a network interface.
    */
  @js.native
  trait NetworkInterfacePrivateIpAddress extends js.Object {
    var Association: js.UndefOr[NetworkInterfaceAssociation]
    var Primary: js.UndefOr[Boolean]
    var PrivateDnsName: js.UndefOr[String]
    var PrivateIpAddress: js.UndefOr[String]
  }

  object NetworkInterfacePrivateIpAddress {
    @inline
    def apply(
        Association: js.UndefOr[NetworkInterfaceAssociation] = js.undefined,
        Primary: js.UndefOr[Boolean] = js.undefined,
        PrivateDnsName: js.UndefOr[String] = js.undefined,
        PrivateIpAddress: js.UndefOr[String] = js.undefined
    ): NetworkInterfacePrivateIpAddress = {
      val __obj = js.Dynamic.literal()
      Association.foreach(__v => __obj.updateDynamic("Association")(__v.asInstanceOf[js.Any]))
      Primary.foreach(__v => __obj.updateDynamic("Primary")(__v.asInstanceOf[js.Any]))
      PrivateDnsName.foreach(__v => __obj.updateDynamic("PrivateDnsName")(__v.asInstanceOf[js.Any]))
      PrivateIpAddress.foreach(__v => __obj.updateDynamic("PrivateIpAddress")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NetworkInterfacePrivateIpAddress]
    }
  }

  object NetworkInterfaceStatusEnum {
    val available  = "available"
    val associated = "associated"
    val attaching  = "attaching"
    val `in-use`   = "in-use"
    val detaching  = "detaching"

    val values = js.Object.freeze(js.Array(available, associated, attaching, `in-use`, detaching))
  }

  object NetworkInterfaceTypeEnum {
    val interface  = "interface"
    val natGateway = "natGateway"
    val efa        = "efa"

    val values = js.Object.freeze(js.Array(interface, natGateway, efa))
  }

  @js.native
  trait NewDhcpConfiguration extends js.Object {
    var Key: js.UndefOr[String]
    var Values: js.UndefOr[ValueStringList]
  }

  object NewDhcpConfiguration {
    @inline
    def apply(
        Key: js.UndefOr[String] = js.undefined,
        Values: js.UndefOr[ValueStringList] = js.undefined
    ): NewDhcpConfiguration = {
      val __obj = js.Dynamic.literal()
      Key.foreach(__v => __obj.updateDynamic("Key")(__v.asInstanceOf[js.Any]))
      Values.foreach(__v => __obj.updateDynamic("Values")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[NewDhcpConfiguration]
    }
  }

  object OfferingClassTypeEnum {
    val standard    = "standard"
    val convertible = "convertible"

    val values = js.Object.freeze(js.Array(standard, convertible))
  }

  object OfferingTypeValuesEnum {
    val `Heavy Utilization`  = "Heavy Utilization"
    val `Medium Utilization` = "Medium Utilization"
    val `Light Utilization`  = "Light Utilization"
    val `No Upfront`         = "No Upfront"
    val `Partial Upfront`    = "Partial Upfront"
    val `All Upfront`        = "All Upfront"

    val values = js.Object.freeze(
      js.Array(
        `Heavy Utilization`,
        `Medium Utilization`,
        `Light Utilization`,
        `No Upfront`,
        `Partial Upfront`,
        `All Upfront`
      )
    )
  }

  object OnDemandAllocationStrategyEnum {
    val lowestPrice = "lowestPrice"
    val prioritized = "prioritized"

    val values = js.Object.freeze(js.Array(lowestPrice, prioritized))
  }

  /**
    * Describes the configuration of On-Demand Instances in an EC2 Fleet.
    */
  @js.native
  trait OnDemandOptions extends js.Object {
    var AllocationStrategy: js.UndefOr[FleetOnDemandAllocationStrategy]
    var MaxTotalPrice: js.UndefOr[String]
    var MinTargetCapacity: js.UndefOr[Int]
    var SingleAvailabilityZone: js.UndefOr[Boolean]
    var SingleInstanceType: js.UndefOr[Boolean]
  }

  object OnDemandOptions {
    @inline
    def apply(
        AllocationStrategy: js.UndefOr[FleetOnDemandAllocationStrategy] = js.undefined,
        MaxTotalPrice: js.UndefOr[String] = js.undefined,
        MinTargetCapacity: js.UndefOr[Int] = js.undefined,
        SingleAvailabilityZone: js.UndefOr[Boolean] = js.undefined,
        SingleInstanceType: js.UndefOr[Boolean] = js.undefined
    ): OnDemandOptions = {
      val __obj = js.Dynamic.literal()
      AllocationStrategy.foreach(__v => __obj.updateDynamic("AllocationStrategy")(__v.asInstanceOf[js.Any]))
      MaxTotalPrice.foreach(__v => __obj.updateDynamic("MaxTotalPrice")(__v.asInstanceOf[js.Any]))
      MinTargetCapacity.foreach(__v => __obj.updateDynamic("MinTargetCapacity")(__v.asInstanceOf[js.Any]))
      SingleAvailabilityZone.foreach(__v => __obj.updateDynamic("SingleAvailabilityZone")(__v.asInstanceOf[js.Any]))
      SingleInstanceType.foreach(__v => __obj.updateDynamic("SingleInstanceType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[OnDemandOptions]
    }
  }

  /**
    * Describes the configuration of On-Demand Instances in an EC2 Fleet.
    */
  @js.native
  trait OnDemandOptionsRequest extends js.Object {
    var AllocationStrategy: js.UndefOr[FleetOnDemandAllocationStrategy]
    var MaxTotalPrice: js.UndefOr[String]
    var MinTargetCapacity: js.UndefOr[Int]
    var SingleAvailabilityZone: js.UndefOr[Boolean]
    var SingleInstanceType: js.UndefOr[Boolean]
  }

  object OnDemandOptionsRequest {
    @inline
    def apply(
        AllocationStrategy: js.UndefOr[FleetOnDemandAllocationStrategy] = js.undefined,
        MaxTotalPrice: js.UndefOr[String] = js.undefined,
        MinTargetCapacity: js.UndefOr[Int] = js.undefined,
        SingleAvailabilityZone: js.UndefOr[Boolean] = js.undefined,
        SingleInstanceType: js.UndefOr[Boolean] = js.undefined
    ): OnDemandOptionsRequest = {
      val __obj = js.Dynamic.literal()
      AllocationStrategy.foreach(__v => __obj.updateDynamic("AllocationStrategy")(__v.asInstanceOf[js.Any]))
      MaxTotalPrice.foreach(__v => __obj.updateDynamic("MaxTotalPrice")(__v.asInstanceOf[js.Any]))
      MinTargetCapacity.foreach(__v => __obj.updateDynamic("MinTargetCapacity")(__v.asInstanceOf[js.Any]))
      SingleAvailabilityZone.foreach(__v => __obj.updateDynamic("SingleAvailabilityZone")(__v.asInstanceOf[js.Any]))
      SingleInstanceType.foreach(__v => __obj.updateDynamic("SingleInstanceType")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[OnDemandOptionsRequest]
    }
  }

  object OperationTypeEnum {
    val add    = "add"
    val remove = "remove"

    val values = js.Object.freeze(js.Array(add, remove))
  }

  object PaymentOptionEnum {
    val AllUpfront     = "AllUpfront"
    val PartialUpfront = "PartialUpfront"
    val NoUpfront      = "NoUpfront"

    val values = js.Object.freeze(js.Array(AllUpfront, PartialUpfront, NoUpfront))
  }

  /**
    * Describes the data that identifies an Amazon FPGA image (AFI) on the PCI bus.
    */
  @js.native
  trait PciId extends js.Object {
    var DeviceId: js.UndefOr[String]
    var SubsystemId: js.UndefOr[String]
    var SubsystemVendorId: js.UndefOr[String]
    var VendorId: js.UndefOr[String]
  }

  object PciId {
    @inline
    def apply(
        DeviceId: js.UndefOr[String] = js.undefined,
        SubsystemId: js.UndefOr[String] = js.undefined,
        SubsystemVendorId: js.UndefOr[String] = js.undefined,
        VendorId: js.UndefOr[String] = js.undefined
    ): PciId = {
      val __obj = js.Dynamic.literal()
      DeviceId.foreach(__v => __obj.updateDynamic("DeviceId")(__v.asInstanceOf[js.Any]))
      SubsystemId.foreach(__v => __obj.updateDynamic("SubsystemId")(__v.asInstanceOf[js.Any]))
      SubsystemVendorId.foreach(__v => __obj.updateDynamic("SubsystemVendorId")(__v.asInstanceOf[js.Any]))
      VendorId.foreach(__v => __obj.updateDynamic("VendorId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[PciId]
    }
  }

  /**
    * Describes the VPC peering connection options.
    */
  @js.native
  trait PeeringConnectionOptions extends js.Object {
    var AllowDnsResolutionFromRemoteVpc: js.UndefOr[Boolean]
    var AllowEgressFromLocalClassicLinkToRemoteVpc: js.UndefOr[Boolean]
    var AllowEgressFromLocalVpcToRemoteClassicLink: js.UndefOr[Boolean]
  }

  object PeeringConnectionOptions {
    @inline
    def apply(
        AllowDnsResolutionFromRemoteVpc: js.UndefOr[Boolean] = js.undefined,
        AllowEgressFromLocalClassicLinkToRemoteVpc: js.UndefOr[Boolean] = js.undefined,
        AllowEgressFromLocalVpcToRemoteClassicLink: js.UndefOr[Boolean] = js.undefined
    ): PeeringConnectionOptions = {
      val __obj = js.Dynamic.literal()
      AllowDnsResolutionFromRemoteVpc.foreach(
        __v => __obj.updateDynamic("AllowDnsResolutionFromRemoteVpc")(__v.asInstanceOf[js.Any])
      )
      AllowEgressFromLocalClassicLinkToRemoteVpc.foreach(
        __v => __obj.updateDynamic("AllowEgressFromLocalClassicLinkToRemoteVpc")(__v.asInstanceOf[js.Any])
      )
      AllowEgressFromLocalVpcToRemoteClassicLink.foreach(
        __v => __obj.updateDynamic("AllowEgressFromLocalVpcToRemoteClassicLink")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[PeeringConnectionOptions]
    }
  }

  /**
    * The VPC peering connection options.
    */
  @js.native
  trait PeeringConnectionOptionsRequest extends js.Object {
    var AllowDnsResolutionFromRemoteVpc: js.UndefOr[Boolean]
    var AllowEgressFromLocalClassicLinkToRemoteVpc: js.UndefOr[Boolean]
    var AllowEgressFromLocalVpcToRemoteClassicLink: js.UndefOr[Boolean]
  }

  object PeeringConnectionOptionsRequest {
    @inline
    def apply(
        AllowDnsResolutionFromRemoteVpc: js.UndefOr[Boolean] = js.undefined,
        AllowEgressFromLocalClassicLinkToRemoteVpc: js.UndefOr[Boolean] = js.undefined,
        AllowEgressFromLocalVpcToRemoteClassicLink: js.UndefOr[Boolean] = js.undefined
    ): PeeringConnectionOptionsRequest = {
      val __obj = js.Dynamic.literal()
      AllowDnsResolutionFromRemoteVpc.foreach(
        __v => __obj.updateDynamic("AllowDnsResolutionFromRemoteVpc")(__v.asInstanceOf[js.Any])
      )
      AllowEgressFromLocalClassicLinkToRemoteVpc.foreach(
        __v => __obj.updateDynamic("AllowEgressFromLocalClassicLinkToRemoteVpc")(__v.asInstanceOf[js.Any])
      )
      AllowEgressFromLocalVpcToRemoteClassicLink.foreach(
        __v => __obj.updateDynamic("AllowEgressFromLocalVpcToRemoteClassicLink")(__v.asInstanceOf[js.Any])
      )
      __obj.asInstanceOf[PeeringConnectionOptionsRequest]
    }
  }

  object PermissionGroupEnum {
    val all = "all"

    val values = js.Object.freeze(js.Array(all))
  }

  /**
    * Describes the placement of an instance.
    */
  @js.native
  trait Placement extends js.Object {
    var Affinity: js.UndefOr[String]
    var AvailabilityZone: js.UndefOr[String]
    var GroupName: js.UndefOr[String]
    var HostId: js.UndefOr[String]
    var PartitionNumber: js.UndefOr[Int]
    var SpreadDomain: js.UndefOr[String]
    var Tenancy: js.UndefOr[Tenancy]
  }

  object Placement {
    @inline
    def apply(
        Affinity: js.UndefOr[String] = js.undefined,
        AvailabilityZone: js.UndefOr[String] = js.undefined,
        GroupName: js.UndefOr[String] = js.undefined,
        HostId: js.UndefOr[String] = js.undefined,
        PartitionNumber: js.UndefOr[Int] = js.undefined,
        SpreadDomain: js.UndefOr[String] = js.undefined,
        Tenancy: js.UndefOr[Tenancy] = js.undefined
    ): Placement = {
      val __obj = js.Dynamic.literal()
      Affinity.foreach(__v => __obj.updateDynamic("Affinity")(__v.asInstanceOf[js.Any]))
      AvailabilityZone.foreach(__v => __obj.updateDynamic("AvailabilityZone")(__v.asInstanceOf[js.Any]))
      GroupName.foreach(__v => __obj.updateDynamic("GroupName")(__v.asInstanceOf[js.Any]))
      HostId.foreach(__v => __obj.updateDynamic("HostId")(__v.asInstanceOf[js.Any]))
      PartitionNumber.foreach(__v => __obj.updateDynamic("PartitionNumber")(__v.asInstanceOf[js.Any]))
      SpreadDomain.foreach(__v => __obj.updateDynamic("SpreadDomain")(__v.asInstanceOf[js.Any]))
      Tenancy.foreach(__v => __obj.updateDynamic("Tenancy")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[Placement]
    }
  }

  /**
    * Describes a placement group.
    */
  @js.native
  trait PlacementGroup extends js.Object {
    var GroupName: js.UndefOr[String]
    var PartitionCount: js.UndefOr[Int]
    var State: js.UndefOr[PlacementGroupState]
    var Strategy: js.UndefOr[PlacementStrategy]
  }

  object PlacementGroup {
    @inline
    def apply(
        GroupName: js.UndefOr[String] = js.undefined,
        PartitionCount: js.UndefOr[Int] = js.undefined,
        State: js.UndefOr[PlacementGroupState] = js.undefined,
        Strategy: js.UndefOr[PlacementStrategy] = js.undefined
    ): PlacementGroup = {
      val __obj = js.Dynamic.literal()
      GroupName.foreach(__v => __obj.updateDynamic("GroupName")(__v.asInstanceOf[js.Any]))
      PartitionCount.foreach(__v => __obj.updateDynamic("PartitionCount")(__v.asInstanceOf[js.Any]))
      State.foreach(__v => __obj.updateDynamic("State")(__v.asInstanceOf[js.Any]))
      Strategy.foreach(__v => __obj.updateDynamic("Strategy")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[PlacementGroup]
    }
  }

  object PlacementGroupStateEnum {
    val pending   = "pending"
    val available = "available"
    val deleting  = "deleting"
    val deleted   = "deleted"

    val values = js.Object.freeze(js.Array(pending, available, deleting, deleted))
  }

  /**
    * Describes the placement of an instance.
    */
  @js.native
  trait PlacementResponse extends js.Object {
    var GroupName: js.UndefOr[String]
  }

  object PlacementResponse {
    @inline
    def apply(
        GroupName: js.UndefOr[String] = js.undefined
    ): PlacementResponse = {
      val __obj = js.Dynamic.literal()
      GroupName.foreach(__v => __obj.updateDynamic("GroupName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[PlacementResponse]
    }
  }

  object PlacementStrategyEnum {
    val cluster   = "cluster"
    val spread    = "spread"
    val partition = "partition"

    val values = js.Object.freeze(js.Array(cluster, spread, partition))
  }

  object PlatformValuesEnum {
    val Windows = "Windows"

    val values = js.Object.freeze(js.Array(Windows))
  }

  /**
    * Describes a range of ports.
    */
  @js.native
  trait PortRange extends js.Object {
    var From: js.UndefOr[Int]
    var To: js.UndefOr[Int]
  }

  object PortRange {
    @inline
    def apply(
        From: js.UndefOr[Int] = js.undefined,
        To: js.UndefOr[Int] = js.undefined
    ): PortRange = {
      val __obj = js.Dynamic.literal()
      From.foreach(__v => __obj.updateDynamic("From")(__v.asInstanceOf[js.Any]))
      To.foreach(__v => __obj.updateDynamic("To")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[PortRange]
    }
  }

  /**
    * Describes prefixes for AWS services.
    */
  @js.native
  trait PrefixList extends js.Object {
    var Cidrs: js.UndefOr[ValueStringList]
    var PrefixListId: js.UndefOr[String]
    var PrefixListName: js.UndefOr[String]
  }

  object PrefixList {
    @inline
    def apply(
        Cidrs: js.UndefOr[ValueStringList] = js.undefined,
        PrefixListId: js.UndefOr[String] = js.undefined,
        PrefixListName: js.UndefOr[String] = js.undefined
    ): PrefixList = {
      val __obj = js.Dynamic.literal()
      Cidrs.foreach(__v => __obj.updateDynamic("Cidrs")(__v.asInstanceOf[js.Any]))
      PrefixListId.foreach(__v => __obj.updateDynamic("PrefixListId")(__v.asInstanceOf[js.Any]))
      PrefixListName.foreach(__v => __obj.updateDynamic("PrefixListName")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[PrefixList]
    }
  }

  /**
    * Describes a prefix list ID.
    */
  @js.native
  trait PrefixListId extends js.Object {
    var Description: js.UndefOr[String]
    var PrefixListId: js.UndefOr[String]
  }

  object PrefixListId {
    @inline
    def apply(
        Description: js.UndefOr[String] = js.undefined,
        PrefixListId: js.UndefOr[String] = js.undefined
    ): PrefixListId = {
      val __obj = js.Dynamic.literal()
      Description.foreach(__v => __obj.updateDynamic("Description")(__v.asInstanceOf[js.Any]))
      PrefixListId.foreach(__v => __obj.updateDynamic("PrefixListId")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[PrefixListId]
    }
  }

  /**
    * Describes the price for a Reserved Instance.
    */
  @js.native
  trait PriceSchedule extends js.Object {
    var Active: js.UndefOr[Boolean]
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var Price: js.UndefOr[Double]
    var Term: js.UndefOr[Double]
  }

  object PriceSchedule {
    @inline
    def apply(
        Active: js.UndefOr[Boolean] = js.undefined,
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        Price: js.UndefOr[Double] = js.undefined,
        Term: js.UndefOr[Double] = js.undefined
    ): PriceSchedule = {
      val __obj = js.Dynamic.literal()
      Active.foreach(__v => __obj.updateDynamic("Active")(__v.asInstanceOf[js.Any]))
      CurrencyCode.foreach(__v => __obj.updateDynamic("CurrencyCode")(__v.asInstanceOf[js.Any]))
      Price.foreach(__v => __obj.updateDynamic("Price")(__v.asInstanceOf[js.Any]))
      Term.foreach(__v => __obj.updateDynamic("Term")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[PriceSchedule]
    }
  }

  /**
    * Describes the price for a Reserved Instance.
    */
  @js.native
  trait PriceScheduleSpecification extends js.Object {
    var CurrencyCode: js.UndefOr[CurrencyCodeValues]
    var Price: js.UndefOr[Double]
    var Term: js.UndefOr[Double]
  }

  object PriceScheduleSpecification {
    @inline
    def apply(
        CurrencyCode: js.UndefOr[CurrencyCodeValues] = js.undefined,
        Price: js.UndefOr[Double] = js.undefined,
        Term: js.UndefOr[Double] = js.undefined
    ): PriceScheduleSpecification = {
      val __obj = js.Dynamic.literal()
      CurrencyCode.foreach(__v => __obj.updateDynamic("CurrencyCode")(__v.asInstanceOf[js.Any]))
      Price.foreach(__v => __obj.updateDynamic("Price")(__v.asInstanceOf[js.Any]))
      Term.foreach(__v => __obj.updateDynamic("Term")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[PriceScheduleSpecification]
    }
  }

  /**
    * Describes a Reserved Instance offering.
    */
  @js.native
  trait PricingDetail extends js.Object {
    var Count: js.UndefOr[Int]
    var Price: js.UndefOr[Double]
  }

  object PricingDetail {
    @inline
    def apply(
        Count: js.UndefOr[Int] = js.undefined,
        Price: js.UndefOr[Double] = js.undefined
    ): PricingDetail = {
      val __obj = js.Dynamic.literal()
      Count.foreach(__v => __obj.updateDynamic("Count")(__v.asInstanceOf[js.Any]))
      Price.foreach(__v => __obj.updateDynamic("Price")(__v.asInstanceOf[js.Any]))
      __obj.asInstanceOf[PricingDetail]
    }
  }

  /**
    * PrincipalIdFormat description
    */
  @js.native
  trait PrincipalIdFormat extends js.Object {
    var Arn: js.UndefOr[String]
    var Statuses: js.UndefOr[IdFormatList]
  }

  object PrincipalIdFormat {
    @inline
    def apply(
        Arn: js