/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.web.core.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;

public abstract class ExcluedableFilter
extends OncePerRequestFilter {
    private String[] excludeServletPath;

    public void setExcludeServletPath(String[] excludeServletPath) {
        this.excludeServletPath = excludeServletPath;
    }

    public ExcluedableFilter() {
    }

    public ExcluedableFilter(String ... excludeServletPath) {
        this.excludeServletPath = excludeServletPath;
    }

    protected final void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String servletPath = request.getServletPath();
        if (this.excludeServletPath != null) {
            for (String each : this.excludeServletPath) {
                if (!servletPath.endsWith(each)) continue;
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        this.doFilterIn(request, response, filterChain);
    }

    protected abstract void doFilterIn(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws ServletException, IOException;
}

