/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.web.core.base.response;

import net.eulerframework.common.base.log.LogSupport;
import net.eulerframework.web.config.WebConfig;
import net.eulerframework.web.core.base.response.BaseResponse;
import net.eulerframework.web.core.exception.web.WebException;

public class ErrorResponse
extends LogSupport
implements BaseResponse {
    private String error;
    private Integer error_code;
    private String error_description;

    public ErrorResponse() {
        this.error = WebException.WebError.UNDEFINED_ERROR.getReasonPhrase();
        this.error_code = WebException.WebError.UNDEFINED_ERROR.value();
    }

    public ErrorResponse(WebException webException) {
        if (WebConfig.isDebugMode()) {
            this.logger.error("WebException throwed, error: " + webException.getError() + " code: " + webException.getCode() + " message: " + webException.getMessage(), (Throwable)webException);
        }
        this.error = webException.getError();
        this.error_code = webException.getCode();
        this.error_description = webException.getLocalizedMessage();
    }

    public String getError() {
        return this.error;
    }

    public Integer getError_code() {
        return this.error_code;
    }

    public String getError_description() {
        return this.error_description;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        buffer.append('{');
        if (this.error != null) {
            buffer.append("\"error\":");
            buffer.append('\"');
            buffer.append(this.error);
            buffer.append('\"');
            first = false;
        }
        if (this.error_code != null) {
            if (!first) {
                buffer.append(',');
            }
            buffer.append("\"error_code\":");
            buffer.append(this.error_code);
            first = false;
        }
        if (this.error_description != null) {
            if (!first) {
                buffer.append(',');
            }
            buffer.append("\"error_description\":");
            buffer.append('\"');
            buffer.append(this.error_description);
            buffer.append('\"');
        }
        buffer.append('}');
        return buffer.toString();
    }
}

