/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.web.core.base.dao.impl.hibernate5;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.eulerframework.common.base.log.LogSupport;
import net.eulerframework.common.util.Assert;
import net.eulerframework.common.util.DateUtils;
import net.eulerframework.common.util.JavaObjectUtils;
import net.eulerframework.common.util.StringUtils;
import net.eulerframework.web.core.base.dao.IBaseDao;
import net.eulerframework.web.core.base.entity.BaseEntity;
import net.eulerframework.web.core.base.request.PageQueryRequest;
import net.eulerframework.web.core.base.request.QueryRequest;
import net.eulerframework.web.core.base.response.easyuisupport.EasyUIPageResponse;
import net.eulerframework.web.core.extend.hibernate5.RestrictionsX;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public abstract class BaseDao<T extends BaseEntity<?>>
extends LogSupport
implements IBaseDao<T> {
    private SessionFactory sessionFactory;
    protected final Class<T> entityClass = JavaObjectUtils.findSuperClassGenricType(this.getClass(), (int)0);

    public Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public T load(Serializable id) {
        Assert.notNull((Object)id);
        BaseEntity entity = (BaseEntity)this.getCurrentSession().get(this.entityClass, id);
        this.evict(entity);
        return (T)entity;
    }

    @Override
    public List<T> load(Collection<Serializable> ids) {
        Assert.notNull(ids);
        Serializable[] idArray = ids.toArray(new Serializable[0]);
        return this.load(idArray);
    }

    @Override
    public List<T> load(Serializable[] idArray) {
        Assert.notNull((Object)idArray);
        ArrayList<T> ret = new ArrayList<T>();
        for (Serializable id : idArray) {
            T entity = this.load(id);
            if (entity == null) continue;
            ret.add(entity);
        }
        return ret;
    }

    @Override
    public Serializable save(T entity) {
        Assert.notNull(entity);
        this.cleanBean(entity);
        return this.getSessionFactory().getCurrentSession().save(entity);
    }

    @Override
    public void update(T entity) {
        Assert.notNull(entity);
        this.cleanBean(entity);
        this.getSessionFactory().getCurrentSession().update(entity);
    }

    @Override
    protected void update(String hql) {
        Assert.notNull((Object)hql);
        this.getSessionFactory().getCurrentSession().createQuery(hql).executeUpdate();
    }

    protected void update(String hql, Object ... params) {
        Assert.notNull((Object)hql);
        Assert.notNull((Object)params);
        Query query = this.getSessionFactory().getCurrentSession().createQuery(hql);
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i, params[i]);
        }
        query.executeUpdate();
    }

    @Override
    public void saveOrUpdate(T entity) {
        Assert.notNull(entity);
        this.cleanBean(entity);
        this.getSessionFactory().getCurrentSession().saveOrUpdate(entity);
    }

    @Override
    public void saveOrUpdateBatch(Collection<T> entities) {
        Assert.notNull(entities);
        this.cleanBeans(entities);
        for (BaseEntity entity : entities) {
            this.saveOrUpdate(entity);
        }
    }

    @Override
    public void delete(T entity) {
        Assert.notNull(entity);
        this.getCurrentSession().delete(entity);
    }

    @Override
    public void deleteBatch(Collection<T> entities) {
        Assert.notNull(entities);
        if (entities == null || entities.isEmpty()) {
            return;
        }
        for (BaseEntity entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    public void deleteById(Serializable id) {
        try {
            this.logger.info("!!!!delete by id");
            BaseEntity entity = (BaseEntity)this.entityClass.newInstance();
            entity.setSerializableId(id);
            this.delete(entity);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteByIds(Serializable[] idArray) {
        for (Serializable id : idArray) {
            this.deleteById(id);
        }
    }

    @Override
    public void deleteByIds(Collection<Serializable> ids) {
        Serializable[] idArray = ids.toArray(new Serializable[0]);
        this.deleteByIds(idArray);
    }

    @Override
    public List<T> queryByEntity(T entity) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(this.entityClass);
        detachedCriteria.add((Criterion)Example.create(entity));
        detachedCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List<T> result = this.query(detachedCriteria);
        this.evict(result);
        return result;
    }

    @Override
    public List<T> queryAll() {
        StringBuffer hqlBuffer = new StringBuffer();
        hqlBuffer.append("select en from ");
        hqlBuffer.append(this.entityClass.getSimpleName());
        hqlBuffer.append(" en");
        String hql = hqlBuffer.toString();
        List<T> result = this.query(hql);
        return result;
    }

    @Override
    public long countAll() {
        StringBuffer hqlBuffer = new StringBuffer();
        hqlBuffer.append("select count(*) from ");
        hqlBuffer.append(this.entityClass.getSimpleName());
        String hql = hqlBuffer.toString();
        List<T> l = this.query(hql);
        if (l != null && l.size() == 1) {
            return (Long)l.get(0);
        }
        return 0L;
    }

    @Override
    public EasyUIPageResponse<T> pageQuery(PageQueryRequest pageQueryRequest) {
        DetachedCriteria detachedCriteria = this.analyzeQueryRequest(pageQueryRequest);
        int pageIndex = pageQueryRequest.getPageIndex();
        int pageSize = pageQueryRequest.getPageSize();
        return this.pageQuery(detachedCriteria, pageIndex, pageSize);
    }

    @Override
    public EasyUIPageResponse<T> pageQuery(PageQueryRequest pageQueryRequest, String ... propertySetToSelectMode) {
        DetachedCriteria detachedCriteria = this.analyzeQueryRequest(pageQueryRequest);
        for (String c : propertySetToSelectMode) {
            detachedCriteria.setFetchMode(c, FetchMode.SELECT);
        }
        int pageIndex = pageQueryRequest.getPageIndex();
        int pageSize = pageQueryRequest.getPageSize();
        return this.pageQuery(detachedCriteria, pageIndex, pageSize);
    }

    @Override
    public void flushSession() {
        this.getCurrentSession().flush();
    }

    @Override
    public boolean isMyEntity(Class<? extends T> clazz) {
        return clazz.equals(this.entityClass);
    }

    protected List<T> query(String hql) {
        List result = this.getSessionFactory().getCurrentSession().createQuery(hql).list();
        this.evict(result);
        return result;
    }

    protected List<T> query(String hql, Object ... params) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(hql);
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i, params[i]);
        }
        List result = query.list();
        this.evict(result);
        return result;
    }

    protected List<T> query(DetachedCriteria detachedCriteria) {
        List result = detachedCriteria.getExecutableCriteria(this.getSessionFactory().getCurrentSession()).list();
        this.evict(result);
        return result;
    }

    protected List<T> limitQuery(String hql, int maxResults) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(hql);
        query.setMaxResults(maxResults);
        List result = query.list();
        this.evict(result);
        return result;
    }

    protected List<T> limitQuery(String hql, int maxResults, Object ... params) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(hql);
        query.setMaxResults(maxResults);
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i, params[i]);
        }
        List result = query.list();
        this.evict(result);
        return result;
    }

    protected List<T> limitQuery(DetachedCriteria detachedCriteria, int maxResults) {
        Criteria criteria = detachedCriteria.getExecutableCriteria(this.getSessionFactory().getCurrentSession());
        criteria.setMaxResults(maxResults);
        List result = criteria.list();
        this.evict(result);
        return result;
    }

    protected EasyUIPageResponse<T> pageQuery(DetachedCriteria detachedCriteria, int pageIndex, int pageSize) {
        return this.pageQuery(detachedCriteria, pageIndex, pageSize, null);
    }

    protected EasyUIPageResponse<T> pageQuery(DetachedCriteria detachedCriteria, int pageIndex, int pageSize, Projection projection) {
        detachedCriteria.setProjection(Projections.rowCount());
        long total = (Long)detachedCriteria.getExecutableCriteria(this.getSessionFactory().getCurrentSession()).list().get(0);
        detachedCriteria.setProjection(projection);
        if (projection != null) {
            detachedCriteria.setResultTransformer(Transformers.aliasToBean(this.entityClass));
        }
        Criteria criteria = detachedCriteria.getExecutableCriteria(this.getSessionFactory().getCurrentSession());
        criteria.setFirstResult((pageIndex - 1) * pageSize);
        criteria.setMaxResults(pageSize);
        List result = criteria.list();
        this.evict(result);
        return new EasyUIPageResponse(result, total, pageIndex, pageSize);
    }

    protected final void evict(Object entity) {
        if (entity == null || !BaseEntity.class.isAssignableFrom(entity.getClass())) {
            return;
        }
        this.getCurrentSession().evict(entity);
    }

    protected void evict(Collection<?> entities) {
        if (entities == null) {
            return;
        }
        for (Object entity : entities) {
            if (entity == null) continue;
            this.evict(entity);
        }
    }

    protected void cleanBeans(Collection<T> entities) {
        for (BaseEntity entity : entities) {
            this.cleanBean(entity);
        }
    }

    protected void cleanBean(T entity) {
        JavaObjectUtils.clearEmptyProperty(entity);
    }

    protected DetachedCriteria analyzeQueryRequest(QueryRequest queryRequest) {
        Object value;
        String property;
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(this.entityClass);
        Map<String, String> queryMap = queryRequest.getQueryMap();
        if (queryRequest.useOr()) {
            ArrayList<Criterion> criterions = new ArrayList<Criterion>();
            for (Map.Entry<String, String> entry : queryMap.entrySet()) {
                property = entry.getKey();
                value = entry.getValue();
                if (StringUtils.isNull((String)value)) continue;
                QueryRequest.QueryMode queryMode = queryRequest.getQueryMode(property);
                try {
                    criterions.add(this.generateRestriction(property, (String)value, queryMode));
                }
                catch (NumberFormatException e) {
                    this.logger.warn(e.getMessage() + " property:" + property);
                }
            }
            detachedCriteria.add((Criterion)Restrictions.or((Criterion[])criterions.toArray(new Criterion[0])));
        } else {
            for (Map.Entry<String, String> entry : queryMap.entrySet()) {
                String string = entry.getKey();
                String value2 = entry.getValue();
                if (StringUtils.isNull((String)value2)) continue;
                QueryRequest.QueryMode queryMode = queryRequest.getQueryMode(string);
                detachedCriteria.add(this.generateRestriction(string, value2, queryMode));
            }
        }
        LinkedHashMap<String, QueryRequest.OrderMode> sortMap = queryRequest.getSortMap();
        for (Map.Entry<String, Object> entry : sortMap.entrySet()) {
            property = entry.getKey();
            value = (QueryRequest.OrderMode)((Object)entry.getValue());
            if (value == null) continue;
            detachedCriteria.addOrder(this.analyzeOrderMode(property, (QueryRequest.OrderMode)((Object)value)));
        }
        return detachedCriteria;
    }

    protected Order analyzeOrderMode(String property, QueryRequest.OrderMode orderMode) {
        try {
            this.entityClass.getDeclaredField(property);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Property '" + property + "' not exist");
        }
        switch (orderMode) {
            case ASC: {
                return Order.asc((String)property);
            }
            case DESC: {
                return Order.desc((String)property);
            }
        }
        throw new IllegalArgumentException("Unknown order mode: " + (Object)((Object)orderMode));
    }

    protected Criterion generateRestriction(String property, String value, QueryRequest.QueryMode queryMode) {
        Field field;
        try {
            field = this.entityClass.getDeclaredField(property);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Property '" + property + "' not exist");
        }
        switch (queryMode) {
            case ANYWHERE: {
                return RestrictionsX.like(property, value, MatchMode.ANYWHERE);
            }
            case START: {
                return RestrictionsX.like(property, value, MatchMode.START);
            }
            case END: {
                return RestrictionsX.like(property, value, MatchMode.END);
            }
            case EXACT: {
                return RestrictionsX.like(property, value, MatchMode.EXACT);
            }
            case GE: {
                return Restrictions.ge((String)property, (Object)this.analyzeValue(value, field.getType()));
            }
            case GT: {
                return Restrictions.gt((String)property, (Object)this.analyzeValue(value, field.getType()));
            }
            case LE: {
                return Restrictions.le((String)property, (Object)this.analyzeValue(value, field.getType()));
            }
            case LT: {
                return Restrictions.lt((String)property, (Object)this.analyzeValue(value, field.getType()));
            }
            case IN: {
                return RestrictionsX.in(property, this.analyzeInterval(value, field.getType()));
            }
            case NOTIN: {
                return Restrictions.not((Criterion)RestrictionsX.in(property, this.analyzeInterval(value, field.getType())));
            }
            case IS: {
                return Restrictions.eq((String)property, (Object)this.analyzeValue(value, field.getType()));
            }
            case NOT: {
                return Restrictions.ne((String)property, (Object)this.analyzeValue(value, field.getType()));
            }
            case BETWEEN: {
                Object[] array1 = this.analyzeInterval(value, field.getType());
                return Restrictions.between((String)property, (Object)array1[0], (Object)array1[1]);
            }
            case OUTSIDE: {
                Object[] array2 = this.analyzeInterval(value, field.getType());
                return Restrictions.not((Criterion)Restrictions.between((String)property, (Object)array2[0], (Object)array2[1]));
            }
        }
        throw new IllegalArgumentException("Unknown query mode: " + (Object)((Object)queryMode));
    }

    private Object[] analyzeInterval(String value, Class<?> clazz) {
        String[] valueArray = value.split(",");
        Object[] result = new Object[valueArray.length];
        for (int i = 0; i < valueArray.length; ++i) {
            result[i] = this.analyzeValue(valueArray[i], clazz);
        }
        return result;
    }

    private Object analyzeValue(String value, Class<?> clazz) {
        if (String.class.equals(clazz)) {
            return value;
        }
        if (Integer.class.equals(clazz) || "int".equals(clazz.toString())) {
            return Integer.parseInt(value);
        }
        if (Long.class.equals(clazz) || "long".equals(clazz.toString())) {
            return Long.parseLong(value);
        }
        if (Short.class.equals(clazz) || "short".equals(clazz.toString())) {
            return Short.parseShort(value);
        }
        if (Float.class.equals(clazz) || "float".equals(clazz.toString())) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class.equals(clazz) || "double".equals(clazz.toString())) {
            return Double.parseDouble(value);
        }
        if (Boolean.class.equals(clazz) || "boolean".equals(clazz.toString())) {
            return Boolean.parseBoolean(value);
        }
        if (Character.class.equals(clazz) || "char".equals(clazz.toString())) {
            if (value.length() > 0) {
                this.logger.warn("Query property type is Character, only use the first char of value");
            }
            return Character.valueOf(value.toCharArray()[0]);
        }
        if (Date.class.equals(clazz)) {
            Date ret = null;
            try {
                ret = new Date(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                try {
                    ret = DateUtils.parseDate((String)value, (String)"yyyy-MM-dd HH:mm:ss");
                }
                catch (ParseException e1) {
                    try {
                        ret = DateUtils.parseDate((String)value, (String)"yyyy-MM-dd");
                    }
                    catch (ParseException e2) {
                        throw new IllegalArgumentException("Date property value '" + value + "' format doesn't match timesamp(3) or 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'");
                    }
                }
            }
            return ret;
        }
        if (BigDecimal.class.equals(clazz)) {
            return new BigDecimal(value);
        }
        throw new IllegalArgumentException("Unsupport query property type: " + clazz);
    }
}

