/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.web.core.base.controller;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.eulerframework.common.util.Assert;
import net.eulerframework.common.util.StringUtils;
import net.eulerframework.web.config.WebConfig;
import net.eulerframework.web.core.base.WebContextAccessable;
import net.eulerframework.web.core.base.controller.AbstractWebController;
import net.eulerframework.web.core.exception.PageNotFoundException;
import net.eulerframework.web.core.exception.web.UndefinedWebException;
import net.eulerframework.web.core.exception.web.WebException;
import net.eulerframework.web.core.exception.web.api.ResourceNotFoundException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;

public abstract class JspSupportWebController
extends AbstractWebController {
    private String webControllerName;

    protected void setWebControllerName(String webControllerName) {
        Assert.notNull((Object)webControllerName);
        while (webControllerName.startsWith("/")) {
            webControllerName = webControllerName.substring(1);
        }
        Assert.hasText((String)webControllerName);
        this.webControllerName = webControllerName;
    }

    private String getWebControllerName() {
        if (StringUtils.hasText((String)this.webControllerName)) {
            return this.webControllerName;
        }
        String className = ((Object)((Object)this)).getClass().getSimpleName();
        int indexOfWebController = className.lastIndexOf("WebController");
        if (indexOfWebController <= 0) {
            throw new RuntimeException("If you want to use this.display(), WebController's class name must end with 'WebController'");
        }
        return StringUtils.toLowerCaseFirstChar((String)className.substring(0, className.lastIndexOf("WebController")));
    }

    protected String theme() {
        String themeParamName = "_theme";
        String theme = this.getRequest().getParameter(themeParamName);
        if (StringUtils.isEmpty((Object)theme)) {
            Cookie[] cookies = this.getRequest().getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(themeParamName)) continue;
                    theme = cookie.getValue();
                }
            }
        } else {
            Cookie cookie = new Cookie(themeParamName, theme);
            this.getResponse().addCookie(cookie);
        }
        if (StringUtils.isNull((String)theme)) {
            theme = WebConfig.getDefaultTheme();
        }
        return theme;
    }

    protected String display(String view) {
        Assert.notNull((Object)view, (String)"view path is empty");
        if (!view.startsWith("/")) {
            return this.theme() + "/" + this.getWebControllerName() + "/" + view;
        }
        return this.theme() + view;
    }

    protected String redirect(String action) {
        Assert.notNull((Object)action, (String)"action path is empty");
        if (!action.startsWith("/")) {
            return "redirect:/" + this.getWebControllerName() + "/" + action;
        }
        return "redirect:" + action;
    }

    protected String jump(String message, Target target, int wait) {
        Assert.notNull((Object)message, (String)"Jump message can not be null");
        target = target == null ? Target.HOME_TARGET : target;
        HttpServletRequest request = this.getRequest();
        request.setAttribute("__message", (Object)message);
        request.setAttribute("__target", (Object)target);
        request.setAttribute("__wait", (Object)wait);
        return this.display("/common/jump");
    }

    protected String error() {
        return this.error(new UndefinedWebException());
    }

    protected String error(String message) {
        return this.error(new UndefinedWebException(message));
    }

    private String error(WebException viewException) {
        Assert.notNull((Object)viewException, (String)"Error exception can not be null");
        this.getRequest().setAttribute("__error_description", (Object)viewException.getLocalizedMessage());
        this.getRequest().setAttribute("__error", (Object)viewException.getError());
        this.getRequest().setAttribute("__code", (Object)viewException.getCode());
        return this.display("/common/error");
    }

    protected String success() {
        return this.success(null, Target.HOME_TARGET);
    }

    protected String success(String message) {
        return this.success(message, Target.HOME_TARGET);
    }

    protected String success(String message, Target ... target) {
        this.getRequest().setAttribute("__message", (Object)message);
        this.getRequest().setAttribute("__targets", (Object)target);
        return this.display("/common/success");
    }

    protected String notfound() {
        this.getResponse().setStatus(HttpStatus.NOT_FOUND.value());
        return this.display("/error/404");
    }

    protected String crashPage(Throwable e) {
        this.logger.error(e.getMessage(), e);
        if (WebConfig.isDebugMode()) {
            this.getRequest().setAttribute("__crashInfo", (Object)e.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.getRequest().setAttribute("__crashStackTrace", (Object)sw.toString());
        }
        this.getResponse().setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return this.display("/error/500");
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public String resourceNotFoundException(ResourceNotFoundException e) {
        this.logger.warn(e.getMessage(), (Throwable)e);
        return this.notfound();
    }

    @ExceptionHandler(value={PageNotFoundException.class})
    public String pageNotFoundException(PageNotFoundException e) {
        this.logger.warn(e.getMessage());
        return this.notfound();
    }

    @ExceptionHandler(value={WebException.class})
    public String webException(WebException e) {
        if (WebConfig.isDebugMode()) {
            this.logger.error("Error Code: " + e.getCode() + "message: " + e.getMessage(), (Throwable)e);
        }
        return this.error(e);
    }

    @ExceptionHandler(value={Exception.class})
    public String exception(Exception e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return this.crashPage(e);
    }

    public static class Target
    extends WebContextAccessable {
        private String href;
        private String name;
        public static final Target HOME_TARGET = new Target("/", "_GO_HOME");

        public String getHref() {
            return this.href;
        }

        public String getName() {
            return this.name;
        }

        public Target(String href) {
            this(href, null);
        }

        public Target(String href, String name) {
            Assert.notNull((Object)href, (String)"Target href exception can not be null");
            String contextPath = this.getServletContext().getContextPath();
            if (!contextPath.endsWith("/")) {
                contextPath = contextPath + "/";
            }
            if (href.startsWith("/")) {
                href = href.length() == 1 ? "" : href.substring(1);
            }
            this.href = contextPath + href;
            this.name = name == null ? href : name;
        }
    }
}

