/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.web.core.base.controller;

import net.eulerframework.web.core.base.controller.BaseController;
import net.eulerframework.web.core.base.response.ErrorResponse;
import net.eulerframework.web.core.exception.web.DefaultWebException;
import net.eulerframework.web.core.exception.web.WebException;
import net.eulerframework.web.core.exception.web.api.ResourceNotFoundException;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class AbstractApiEndpoint
extends BaseController {
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BindException.class})
    public Object bindException(BindException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return new ErrorResponse(new DefaultWebException(e.getMessage(), WebException.WebError.ILLEGAL_PARAMETER, (Throwable)e));
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ResourceNotFoundException.class})
    public Object resourceNotFoundException(ResourceNotFoundException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return new ErrorResponse();
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={AccessDeniedException.class})
    public Object accessDeniedException(AccessDeniedException e) {
        return new ErrorResponse(new DefaultWebException(e.getMessage(), WebException.WebError.ACCESS_DENIED, (Throwable)e));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Object missingServletRequestParameterException(MissingServletRequestParameterException e) {
        return new ErrorResponse(new DefaultWebException(e.getMessage(), WebException.WebError.ILLEGAL_PARAMETER, (Throwable)e));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={IllegalArgumentException.class})
    public Object illegalArgumentException(IllegalArgumentException e) {
        return new ErrorResponse(new DefaultWebException(e.getMessage(), WebException.WebError.ILLEGAL_ARGUMENT, (Throwable)e));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={WebException.class})
    public Object webException(WebException e) {
        return new ErrorResponse(e);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public Object exception(Exception e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return new ErrorResponse();
    }
}

