/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.web.config;

import net.eulerframework.cache.inMemoryCache.AbstractObjectCache;
import net.eulerframework.cache.inMemoryCache.DefaultObjectCache;
import net.eulerframework.cache.inMemoryCache.ObjectCachePool;
import net.eulerframework.common.util.CommonUtils;
import net.eulerframework.common.util.StringUtils;
import net.eulerframework.common.util.property.PropertyNotFoundException;
import net.eulerframework.common.util.property.PropertyReader;
import net.eulerframework.web.config.ApiAuthenticationType;
import net.eulerframework.web.config.MultiPartConfig;
import net.eulerframework.web.config.OAuthServerType;
import net.eulerframework.web.config.ProjectMode;
import net.eulerframework.web.config.WebAuthenticationType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.ContextLoader;

@Configuration
public abstract class WebConfig {
    private static final DefaultObjectCache<String, Object> CONFIG_CAHCE = ObjectCachePool.generateDefaultObjectCache((long)Long.MAX_VALUE);
    private static final PropertyReader properties = new PropertyReader("/config.properties");
    protected static final Logger log = LogManager.getLogger();

    public static boolean clearWebConfigCache() {
        properties.refresh();
        return CONFIG_CAHCE.clear();
    }

    public static int getI18nRefreshFreq() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"core.cache.i18n.refreshFreq", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.getIntValue("core.cache.i18n.refreshFreq", 86400);
            }
        });
        return (Integer)cachedConfig;
    }

    public static WebAuthenticationType getWebAuthenticationType() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"security.web.authenticationType", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.getEnumValue("security.web.authenticationType", (Enum)WebConfigDefault.SECURITY_WEB_AUTHENTICATION_TYPE, true);
            }
        });
        return (WebAuthenticationType)((Object)cachedConfig);
    }

    public static ApiAuthenticationType getApiAuthenticationType() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"security.api.authenticationType", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.getEnumValue("security.api.authenticationType", (Enum)WebConfigDefault.SECURITY_API_AUTHENTICATION_TYPE, true);
            }
        });
        return (ApiAuthenticationType)((Object)cachedConfig);
    }

    public static OAuthServerType getOAuthSeverType() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"security.oauth.severType", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.getEnumValue("security.oauth.severType", (Enum)WebConfigDefault.SECURITY_OAUTH_SERVER_TYPE, true);
            }
        });
        return (OAuthServerType)((Object)cachedConfig);
    }

    @Bean
    public static String getApiRootPath() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"web.api.rootPath", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                String result;
                try {
                    result = properties.get("web.api.rootPath");
                }
                catch (PropertyNotFoundException e) {
                    throw new RuntimeException("web.api.rootPath can not be empty");
                }
                if (!StringUtils.hasText((String)result)) {
                    throw new RuntimeException("web.api.rootPathcan not be empty");
                }
                while (result.endsWith("*")) {
                    result = result.substring(0, result.length() - 1);
                }
                if (!(result = CommonUtils.convertDirToUnixFormat((String)result)).startsWith("/")) {
                    result = "/" + result;
                }
                return result;
            }
        });
        return (String)cachedConfig;
    }

    public static String getAdminRootPath() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"web.admin.rootPath", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                String result;
                try {
                    result = properties.get("web.admin.rootPath");
                }
                catch (PropertyNotFoundException e) {
                    throw new RuntimeException("web.admin.rootPath can not be empty");
                }
                if (!StringUtils.hasText((String)result)) {
                    throw new RuntimeException("web.admin.rootPath can not be empty");
                }
                while (result.endsWith("*")) {
                    result = result.substring(0, result.length() - 1);
                }
                if (!(result = CommonUtils.convertDirToUnixFormat((String)result)).startsWith("/")) {
                    result = "/" + result;
                }
                return result;
            }
        });
        return (String)cachedConfig;
    }

    public static String getUploadPath() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"web.uploadPath", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                String result;
                try {
                    result = CommonUtils.convertDirToUnixFormat((String)properties.get("web.uploadPath"));
                }
                catch (PropertyNotFoundException e) {
                    if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                        log.info("OS is windows");
                        result = "file://C:\\euler-framework-data\\archive\\files";
                    } else {
                        log.info("OS isn't windows");
                        result = "file:///var/lib/euler-framework/archive/files";
                    }
                    log.warn("Couldn't load web.uploadPath , use " + result + " for default.");
                }
                if (!result.startsWith("/") && !result.startsWith("file://")) {
                    result = ContextLoader.getCurrentWebApplicationContext().getServletContext().getRealPath(result);
                } else if (result.startsWith("file://")) {
                    result = result.substring("file://".length());
                }
                return result;
            }
        });
        return (String)cachedConfig;
    }

    public static String getJspPath() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"web.jspPath", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                String result = CommonUtils.convertDirToUnixFormat((String)properties.get("web.jspPath", "/WEB-INF/jsp/themes"));
                result = result + "/";
                return result;
            }
        });
        return (String)cachedConfig;
    }

    public static String getAdminJspPath() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"web.admin.JspPath", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                String result = CommonUtils.convertDirToUnixFormat((String)properties.get("web.admin.JspPath", "/WEB-INF/jsp/admin/themes"));
                result = result + "/";
                return result;
            }
        });
        return (String)cachedConfig;
    }

    public static long getRamCacheCleanFreq() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"core.cache.ramCachePool.cleanFreq", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.getLongValue("core.cache.ramCachePool.cleanFreq", 60000L);
            }
        });
        return (Long)cachedConfig;
    }

    public static MultiPartConfig getMultiPartConfig() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"web.multipart", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                String location = properties.get("web.multiPart.location", WebConfigDefault.WEB_MULITPART_LOCATION);
                long maxFileSize = properties.getLongValue("web.multiPart.maxFileSize", 51200L);
                long maxRequestSize = properties.getLongValue("web.multiPart.maxRequestSize", 51200L);
                int fileSizeThreshold = properties.getIntValue("web.multiPart.fileSizeThreshold", 1024);
                MultiPartConfig result = new MultiPartConfig(location, maxFileSize, maxRequestSize, fileSizeThreshold);
                return result;
            }
        });
        return (MultiPartConfig)cachedConfig;
    }

    public static int getMinPasswordLength() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"security.signup.password.minLength", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                int result = properties.getIntValue("security.signup.password.minLength", 6);
                if (result > WebConfig.getMaxPasswordLength()) {
                    result = WebConfig.getMaxPasswordLength();
                    log.warn("Password length must less than " + result + ", use " + result + " as " + "security.signup.password.minLength");
                }
                return result;
            }
        });
        return (Integer)cachedConfig;
    }

    public static int getMaxPasswordLength() {
        return 20;
    }

    public static String getUsernameFormat() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"security.signup.username.format", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("security.signup.username.format", "^[A-Za-z][A-Za-z0-9_\\-\\.]+[A-Za-z0-9]$");
            }
        });
        return (String)cachedConfig;
    }

    public static String getEmailFormat() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"security.signup.email.format", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("security.signup.email.format", "^[A-Za-z0-9_\\-\\.]+@[a-zA-Z0-9_\\-]+(\\.[a-zA-Z0-9_\\-]+)+$");
            }
        });
        return (String)cachedConfig;
    }

    public static String getPasswordFormat() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"security.signup.password.format", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("security.signup.password.format", "^[\\u0021-\\u007e]+$");
            }
        });
        return (String)cachedConfig;
    }

    public static boolean isEnableEmailSignin() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"security.authentication.enableEmailSignin", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.getBooleanValue("security.authentication.enableEmailSignin", false);
            }
        });
        return (Boolean)cachedConfig;
    }

    public static boolean isEnableMobileSignin() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"security.authentication.enableMobileSignin", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.getBooleanValue("security.authentication.enableMobileSignin", false);
            }
        });
        return (Boolean)cachedConfig;
    }

    public static long getUserContextCacheLife() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"security.authentication.userContext.cacheLife", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.getLongValue("security.authentication.userContext.cacheLife", 600000L);
            }
        });
        return (Long)cachedConfig;
    }

    public static boolean isEnableAutoSigninAfterSignup() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"security.signup.autoSignin", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.getBooleanValue("security.signup.autoSignin", true);
            }
        });
        return (Boolean)cachedConfig;
    }

    public static boolean isEnableAutoAuthorizeAfterSignup() {
        return false;
    }

    public static String[] getAutoAuthorizeGroupId() {
        return new String[]{"8a775fcf-6f3e-4b57-8a1a-a9bd96a4bf49"};
    }

    public static ProjectMode getProjectMode() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"project.mode", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.getEnumValue("project.mode", (Enum)WebConfigDefault.PROJECT_MODE, true);
            }
        });
        return (ProjectMode)((Object)cachedConfig);
    }

    public static String getProjectVersion() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"project.verison", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                try {
                    return properties.get("project.verison");
                }
                catch (PropertyNotFoundException e) {
                    throw new RuntimeException("Couldn't load project.verison");
                }
            }
        });
        return (String)cachedConfig;
    }

    public static String getProjectBuildtime() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"project.buildtime", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                try {
                    return properties.get("project.buildtime");
                }
                catch (PropertyNotFoundException e) {
                    throw new RuntimeException("Couldn't load project.buildtime");
                }
            }
        });
        return (String)cachedConfig;
    }

    public static String getCopyrightHolder() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"project.copyrightHolder", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("project.copyrightHolder", "Copyright Holder");
            }
        });
        return (String)cachedConfig;
    }

    public static String getSitename() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"web.sitename", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("web.sitename", "DEMO");
            }
        });
        return (String)cachedConfig;
    }

    public static String getAssetsPath() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"web.asstesPath", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("web.asstesPath", "/assets");
            }
        });
        return (String)cachedConfig;
    }

    public static boolean isDebugMode() {
        return WebConfig.getProjectMode().equals((Object)ProjectMode.DEVELOP) || WebConfig.getProjectMode().equals((Object)ProjectMode.DEBUG);
    }

    public static String getDefaultTheme() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"web.defaultTheme", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("web.defaultTheme", "default");
            }
        });
        return (String)cachedConfig;
    }

    public static String getAdminDashboardBrandIcon() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"web.admin.dashboardBrandIcon", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("web.admin.dashboardBrandIcon", "/assets/system/admin-dashboard-brand.png");
            }
        });
        return (String)cachedConfig;
    }

    public static String getAdminDashboardBrandText() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"web.admin.dashboardBrandText", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("web.admin.dashboardBrandText", "Manage Dashboard");
            }
        });
        return (String)cachedConfig;
    }

    public static String getRootContextConfigClassName() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"core.rootContextConfigClass", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("core.rootContextConfigClass", "net.eulerframework.config.RootContextConfig");
            }
        });
        return (String)cachedConfig;
    }

    public static String getWebConfigClassName() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"core.webConfigClass", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("core.webConfigClass", "net.eulerframework.config.WebServletContextConfig");
            }
        });
        return (String)cachedConfig;
    }

    public static String getAjaxConfigClassName() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"core.webAjaxConfigClass", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("core.webAjaxConfigClass", "net.eulerframework.config.AjaxServletContextConfig");
            }
        });
        return (String)cachedConfig;
    }

    public static String getAdminWebConfigClassName() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"core.adminWebConfigClass", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("core.adminWebConfigClass", "net.eulerframework.config.AdminWebServletContextConfig");
            }
        });
        return (String)cachedConfig;
    }

    public static String getAdminAjaxConfigClassName() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"core.adminWebAjaxConfigClass", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("core.adminWebAjaxConfigClass", "net.eulerframework.config.AdminAjaxServletContextConfig");
            }
        });
        return (String)cachedConfig;
    }

    public static String getApiConfigClassName() {
        Object cachedConfig = CONFIG_CAHCE.get((Object)"core.apiConfigClass", (AbstractObjectCache.DataGetter)new AbstractObjectCache.DataGetter<String, Object>(){

            public Object getData(String key) {
                return properties.get("core.apiConfigClass", "net.eulerframework.config.ApiServletContextConfig");
            }
        });
        return (String)cachedConfig;
    }

    private static class WebConfigDefault {
        private static final String PROJECT_COPYRIGHT_HOLDER = "Copyright Holder";
        private static final ProjectMode PROJECT_MODE = ProjectMode.DEBUG;
        private static final String CORE_ROOT_CONTEXT_CONFIG_CLASS = "net.eulerframework.config.RootContextConfig";
        private static final String CORE_WEB_CONFIG_CLASS = "net.eulerframework.config.WebServletContextConfig";
        private static final String CORE_AJAX_CONFIG_CLASS = "net.eulerframework.config.AjaxServletContextConfig";
        private static final String CORE_ADMIN_WEB_CONFIG_CLASS = "net.eulerframework.config.AdminWebServletContextConfig";
        private static final String CORE_ADMIN_AJAX_CONFIG_CLASS = "net.eulerframework.config.AdminAjaxServletContextConfig";
        private static final String CORE_API_CONFIG_CLASS = "net.eulerframework.config.ApiServletContextConfig";
        private static final int CORE_CACHE_I18N_REFRESH_FREQ = 86400;
        private static final long CORE_CAHCE_RAMCACHE_POOL_CLEAN_FREQ = 60000L;
        private static final String WEB_SITENAME = "DEMO";
        private static final String WEB_DEFAULT_THEME = "default";
        private static final String WEB_UPLOAD_PATH_UNIX = "file:///var/lib/euler-framework/archive/files";
        private static final String WEB_UPLOAD_PATH_WIN = "file://C:\\euler-framework-data\\archive\\files";
        private static final String WEB_JSP_PATH = "/WEB-INF/jsp/themes";
        private static final String WEB_ADMIN_JSP_PATH = "/WEB-INF/jsp/admin/themes";
        private static final String WEB_ADMIN_DASHBOARD_BRAND_ICON = "/assets/system/admin-dashboard-brand.png";
        private static final String WEB_ADMIN_DASHBOARD_BRAND_TEXT = "Manage Dashboard";
        private static final String WEB_ASSETS_PATH = "/assets";
        private static final String WEB_MULITPART_LOCATION = null;
        private static final long WEB_MULITPART_MAX_FILE_SIZE = 51200L;
        private static final long WEB_MULITPART_MAX_REQUEST_SIZE = 51200L;
        private static final int WEB_MULITPART_FILE_SIZE_THRESHOLD = 1024;
        private static final WebAuthenticationType SECURITY_WEB_AUTHENTICATION_TYPE = WebAuthenticationType.LOCAL;
        private static final ApiAuthenticationType SECURITY_API_AUTHENTICATION_TYPE = ApiAuthenticationType.NONE;
        private static final OAuthServerType SECURITY_OAUTH_SERVER_TYPE = OAuthServerType.NEITHER;
        private static final boolean SECURITY_AUTHENTICATION_ENABLE_EMAIL_SIGNIN = false;
        private static final boolean SECURITY_AUTHENTICATION_ENABLE_MOBILE_SIGNIN = false;
        private static final long SECURITY_AUTHENTICATION_USERCONTEXT_CAHCE_LIFE = 600000L;
        private static final String SECURITY_SIGNUP_USERNAME_FORMAT = "^[A-Za-z][A-Za-z0-9_\\-\\.]+[A-Za-z0-9]$";
        private static final String SECURITY_SIGNUP_EMAIL_FORMAT = "^[A-Za-z0-9_\\-\\.]+@[a-zA-Z0-9_\\-]+(\\.[a-zA-Z0-9_\\-]+)+$";
        private static final String SECURITY_SIGNUP_PASSWORD_FORMAT = "^[\\u0021-\\u007e]+$";
        private static final int SECURITY_SIGNUP_PASSWORD_MIN_LENGTH = 6;
        private static final boolean SECURITY_SIGNUP_AUTO_SIGNIN = true;

        private WebConfigDefault() {
        }
    }

    private static class WebConfigKey {
        private static final String PROJECT_VERSION = "project.verison";
        private static final String PROJECT_MODE = "project.mode";
        private static final String PROJECT_BUILDTIME = "project.buildtime";
        private static final String PROJECT_COPYRIGHT_HOLDER = "project.copyrightHolder";
        private static final String CORE_ROOT_CONTEXT_CONFIG_CLASS = "core.rootContextConfigClass";
        private static final String CORE_WEB_CONFIG_CLASS = "core.webConfigClass";
        private static final String CORE_AJAX_CONFIG_CLASS = "core.webAjaxConfigClass";
        private static final String CORE_ADMIN_WEB_CONFIG_CLASS = "core.adminWebConfigClass";
        private static final String CORE_ADMIN_AJAX_CONFIG_CLASS = "core.adminWebAjaxConfigClass";
        private static final String CORE_API_CONFIG_CLASS = "core.apiConfigClass";
        private static final String CORE_CACHE_I18N_REFRESH_FREQ = "core.cache.i18n.refreshFreq";
        private static final String CORE_CAHCE_RAMCACHE_POOL_CLEAN_FREQ = "core.cache.ramCachePool.cleanFreq";
        private static final String WEB_SITENAME = "web.sitename";
        private static final String WEB_DEFAULT_THEME = "web.defaultTheme";
        private static final String WEB_UPLOAD_PATH = "web.uploadPath";
        private static final String WEB_JSP_PATH = "web.jspPath";
        private static final String WEB_ADMIN_JSP_PATH = "web.admin.JspPath";
        private static final String WEB_ADMIN_ROOT_PATH = "web.admin.rootPath";
        private static final String WEB_ADMIN_DASHBOARD_BRAND_ICON = "web.admin.dashboardBrandIcon";
        private static final String WEB_ADMIN_DASHBOARD_BRAND_TEXT = "web.admin.dashboardBrandText";
        private static final String WEB_API_ROOT_PATH = "web.api.rootPath";
        private static final String WEB_ASSETS_PATH = "web.asstesPath";
        private static final String WEB_MULITPART = "web.multipart";
        private static final String WEB_MULITPART_LOCATION = "web.multiPart.location";
        private static final String WEB_MULITPART_MAX_FILE_SIZE = "web.multiPart.maxFileSize";
        private static final String WEB_MULITPART_MAX_REQUEST_SIZE = "web.multiPart.maxRequestSize";
        private static final String WEB_MULITPART_FILE_SIZE_THRESHOLD = "web.multiPart.fileSizeThreshold";
        private static final String SECURITY_WEB_AUTHENTICATION_TYPE = "security.web.authenticationType";
        private static final String SECURITY_API_AUTHENTICATION_TYPE = "security.api.authenticationType";
        private static final String SECURITY_OAUTH_SERVER_TYPE = "security.oauth.severType";
        private static final String SECURITY_AUTHENTICATION_ENABLE_EMAIL_SIGNIN = "security.authentication.enableEmailSignin";
        private static final String SECURITY_AUTHENTICATION_ENABLE_MOBILE_SIGNIN = "security.authentication.enableMobileSignin";
        private static final String SECURITY_AUTHENTICATION_USERCONTEXT_CAHCE_LIFE = "security.authentication.userContext.cacheLife";
        private static final String SECURITY_SIGNUP_USERNAME_FORMAT = "security.signup.username.format";
        private static final String SECURITY_SIGNUP_EMAIL_FORMAT = "security.signup.email.format";
        private static final String SECURITY_SIGNUP_PASSWORD_FORMAT = "security.signup.password.format";
        private static final String SECURITY_SIGNUP_PASSWORD_MIN_LENGTH = "security.signup.password.minLength";
        private static final String SECURITY_SIGNUP_AUTO_SIGNIN = "security.signup.autoSignin";

        private WebConfigKey() {
        }
    }
}

