/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import net.eulerframework.web.config.WebConfig;
import net.eulerframework.web.core.annotation.WebController;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ImportResource;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

@Configuration
@EnableWebMvc
@ComponentScan(basePackages={"**.web.**.controller"}, useDefaultFilters=false, includeFilters={@ComponentScan.Filter(value={WebController.class})}, excludeFilters={@ComponentScan.Filter(type=FilterType.ASPECTJ, pattern={"*..web..controller.admin..*", "*..web..controller.api..*", "*..web..controller.ajax..*"})})
@ImportResource(value={"classpath*:config/controller-security.xml"})
public class WebServletContextConfig
extends WebMvcConfigurerAdapter {
    @Resource
    private SpringValidatorAdapter validator;
    @Resource(name="objectMapper")
    ObjectMapper objectMapper;

    @Bean
    public ViewResolver viewResolver() {
        InternalResourceViewResolver resolver = new InternalResourceViewResolver();
        resolver.setViewClass(JstlView.class);
        resolver.setPrefix(WebConfig.getJspPath());
        resolver.setSuffix(".jsp");
        return resolver;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
        jsonConverter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON_UTF8, MediaType.valueOf((String)"text/json;charset=UTF-8")));
        jsonConverter.setObjectMapper(this.objectMapper);
        converters.add((HttpMessageConverter<?>)jsonConverter);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        HashMap<String, MediaType> mediaTypes = new HashMap<String, MediaType>();
        mediaTypes.put("json", MediaType.APPLICATION_JSON_UTF8);
        configurer.favorPathExtension(false).favorParameter(false).ignoreAcceptHeader(false).defaultContentType(MediaType.APPLICATION_JSON_UTF8).mediaTypes(mediaTypes);
    }
}

