/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.bootstrap;

import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import net.eulerframework.common.base.log.LogSupport;
import net.eulerframework.web.config.MultiPartConfig;
import net.eulerframework.web.config.SystemProperties;
import net.eulerframework.web.config.WebConfig;
import net.eulerframework.web.core.filter.CrosFilter;
import net.eulerframework.web.core.filter.LocaleFilter;
import net.eulerframework.web.core.filter.RequestIdFilter;
import net.eulerframework.web.core.listener.EulerFrameworkCoreListener;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

@Order(value=0)
public class EulerFrameworkBootstrap
extends LogSupport
implements WebApplicationInitializer {
    private static final String WEB_SECURITY_LOCAL = "web-security-local";
    private static final String WEB_SECURITY_LDAP = "web-security-ldap";
    private static final String WEB_SECURITY_CAS = "web-security-cas";
    private static final String REST_SECURITY_OAUTH = "rest-security-oauth";
    private static final String REST_SECURITY_BASIC = "rest-security-basic";
    private static final String REST_SECURITY_WEB = "rest-security-web";
    private static final String REST_SECURITY_NONE = "rest-security-none";
    private static final String OAUTH_AUTHORIZATION_SERVER = "oauth-authorization-server";
    private static final String OAUTH_RESOURCE_SERVER = "oauth-resource-server";

    public void onStartup(ServletContext container) throws ServletException {
        this.logger.info("Executing Euler-Framework bootstrap.");
        AnnotationConfigWebApplicationContext rootContext = new AnnotationConfigWebApplicationContext();
        try {
            rootContext.register(new Class[]{Class.forName(WebConfig.getRootContextConfigClassName())});
        }
        catch (ClassNotFoundException e) {
            rootContext.close();
            throw new ServletException((Throwable)e);
        }
        this.setConfigurableEnvironment((AbstractApplicationContext)rootContext);
        container.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)rootContext));
        container.addListener((EventListener)((Object)new EulerFrameworkCoreListener()));
        this.initSpringMVCDispatcher(container, "springWebDispatcherServlet", 1, WebConfig.getWebConfigClassName(), "/");
        this.initSpringMVCDispatcher(container, "springAdminWebDispatcherServlet", 1, WebConfig.getAdminWebConfigClassName(), WebConfig.getAdminRootPath() + "/*");
        this.initSpringMVCDispatcher(container, "springApiDispatcherServlet", 1, WebConfig.getApiConfigClassName(), WebConfig.getApiRootPath() + "/*");
        this.initBaseData(container);
        FilterRegistration.Dynamic requestIdFilter = container.addFilter("requestIdFilter", (Filter)new RequestIdFilter());
        requestIdFilter.addMappingForUrlPatterns(null, false, new String[]{"/*"});
        FilterRegistration.Dynamic localeFilter = container.addFilter("localeFilter", (Filter)new LocaleFilter());
        localeFilter.addMappingForServletNames(null, false, new String[]{"springWebDispatcherServlet", "springAdminWebDispatcherServlet"});
        FilterRegistration.Dynamic crosFilter = container.addFilter("crosFilter", (Filter)new CrosFilter());
        crosFilter.addMappingForUrlPatterns(null, false, new String[]{"/oauth/check_token", "/oauth/token"});
    }

    private void setConfigurableEnvironment(AbstractApplicationContext rootContext) {
        ConfigurableEnvironment configurableEnvironment = rootContext.getEnvironment();
        switch (WebConfig.getWebAuthenticationType()) {
            case LOCAL: {
                configurableEnvironment.addActiveProfile(WEB_SECURITY_LOCAL);
                break;
            }
            case LDAP: {
                configurableEnvironment.addActiveProfile(WEB_SECURITY_LDAP);
                break;
            }
            case CAS: {
                configurableEnvironment.addActiveProfile(WEB_SECURITY_CAS);
            }
        }
        switch (WebConfig.getApiAuthenticationType()) {
            case OAUTH: {
                configurableEnvironment.addActiveProfile(REST_SECURITY_OAUTH);
                break;
            }
            case BASIC: {
                configurableEnvironment.addActiveProfile(REST_SECURITY_BASIC);
                break;
            }
            case WEB: {
                configurableEnvironment.addActiveProfile(REST_SECURITY_WEB);
                break;
            }
            case NONE: {
                configurableEnvironment.addActiveProfile(REST_SECURITY_NONE);
            }
        }
        switch (WebConfig.getOAuthSeverType()) {
            case AUTHORIZATION_SERVER: {
                configurableEnvironment.addActiveProfile(OAUTH_AUTHORIZATION_SERVER);
                break;
            }
            case RESOURCE_SERVER: {
                configurableEnvironment.addActiveProfile(OAUTH_RESOURCE_SERVER);
                break;
            }
            case BOTH: {
                configurableEnvironment.addActiveProfile(OAUTH_AUTHORIZATION_SERVER);
                configurableEnvironment.addActiveProfile(OAUTH_RESOURCE_SERVER);
                break;
            }
        }
    }

    private void initSpringMVCDispatcher(ServletContext container, String servletName, int loadOnStartup, String configClassName, String ... urlPatterns) throws ServletException {
        AnnotationConfigWebApplicationContext springDispatcherServletContext = new AnnotationConfigWebApplicationContext();
        try {
            springDispatcherServletContext.register(new Class[]{Class.forName(configClassName)});
        }
        catch (ClassNotFoundException e) {
            springDispatcherServletContext.close();
            throw new ServletException((Throwable)e);
        }
        DispatcherServlet springDispatcherServlet = new DispatcherServlet((WebApplicationContext)springDispatcherServletContext);
        springDispatcherServlet.setDispatchOptionsRequest(true);
        ServletRegistration.Dynamic springDispatcherServletDynamic = container.addServlet(servletName, (Servlet)springDispatcherServlet);
        springDispatcherServletDynamic.setLoadOnStartup(loadOnStartup);
        MultiPartConfig multiPartConfig = WebConfig.getMultiPartConfig();
        springDispatcherServletDynamic.setMultipartConfig(new MultipartConfigElement(multiPartConfig.getLocation(), multiPartConfig.getMaxFileSize(), multiPartConfig.getMaxRequestSize(), multiPartConfig.getFileSizeThreshold()));
        springDispatcherServletDynamic.addMapping(urlPatterns);
    }

    private void initBaseData(ServletContext container) {
        String contextPath = container.getContextPath();
        container.setAttribute("__CONTEXT_PATH", (Object)contextPath);
        container.setAttribute("__ASSETS_PATH", (Object)(contextPath + WebConfig.getAssetsPath()));
        container.setAttribute("__FILE_DOWNLOAD_PATH", (Object)(contextPath + "/file"));
        container.setAttribute("__FILE_UPLOAD_ACTION", (Object)(contextPath + "/uploadFile"));
        container.setAttribute("__DEBUG_MODE", (Object)WebConfig.isDebugMode());
        container.setAttribute("__PROJECT_VERSION", (Object)WebConfig.getProjectVersion());
        container.setAttribute("__PROJECT_MODE", (Object)WebConfig.getProjectMode());
        container.setAttribute("__PROJECT_BUILDTIME", (Object)WebConfig.getProjectBuildtime());
        container.setAttribute("__SITENAME", (Object)WebConfig.getSitename());
        container.setAttribute("__COPYRIGHT_HOLDER", (Object)WebConfig.getCopyrightHolder());
        container.setAttribute("__ADMIN_DASHBOARD_BRAND_ICON", (Object)(contextPath + WebConfig.getAdminDashboardBrandIcon()));
        container.setAttribute("__ADMIN_DASHBOARD_BRAND_TEXT", (Object)WebConfig.getAdminDashboardBrandText());
        container.setAttribute("__FRAMEWORK_VERSION", (Object)SystemProperties.frameworkVersion());
    }
}

