/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.cache.inMemoryCache.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.eulerframework.cache.inMemoryCache.AbstractObjectCache;
import net.eulerframework.cache.inMemoryCache.DataNotFoundException;
import net.eulerframework.cache.inMemoryCache.DefaultObjectCache;

public class FuzzyObjectCache<DATA_T>
extends DefaultObjectCache<String, DATA_T> {
    public FuzzyObjectCache() {
    }

    public FuzzyObjectCache(long dataLife) {
        super(dataLife);
    }

    public List<DATA_T> getFuzzy(String key) {
        Set keySet = this.dataMap.keySet();
        HashSet<String> targetKeySet = new HashSet<String>();
        for (String each : keySet) {
            if (!each.toUpperCase().contains(key.toUpperCase())) continue;
            targetKeySet.add(each);
        }
        return this.getAll(targetKeySet);
    }

    public List<DATA_T> getAll(Set<String> keySet) {
        ArrayList result = new ArrayList();
        for (String key : keySet) {
            Object data;
            try {
                data = super.get(key);
            }
            catch (DataNotFoundException e) {
                return null;
            }
            result.add(data);
        }
        return result;
    }

    public boolean putAll(Map<String, DATA_T> dataMap) {
        if (this.dataLife <= 0L) {
            return false;
        }
        if (this.cacheWriteLock.tryLock()) {
            try {
                HashMap<String, AbstractObjectCache.DataStore<DATA_T>> dataStoreMap = new HashMap<String, AbstractObjectCache.DataStore<DATA_T>>();
                Set<Map.Entry<String, DATA_T>> entrySet = dataMap.entrySet();
                for (Map.Entry<String, DATA_T> entry : entrySet) {
                    String key = entry.getKey();
                    DATA_T obj = entry.getValue();
                    dataStoreMap.put(key, new AbstractObjectCache.DataStore<DATA_T>(obj));
                }
                this.dataMap.putAll(dataStoreMap);
                return true;
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
        return false;
    }
}

