/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.cache.inMemoryCache;

import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.eulerframework.cache.inMemoryCache.AbstractObjectCache;
import net.eulerframework.cache.inMemoryCache.CacheTimerObjectCache;
import net.eulerframework.cache.inMemoryCache.DefaultObjectCache;

public class ObjectCachePool {
    private static final Set<AbstractObjectCache<?, ?>> CACHE_POOL = new HashSet();

    public static void clean() {
        for (AbstractObjectCache<?, ?> cache : CACHE_POOL) {
            if (!cache.isEnable()) continue;
            cache.clean();
        }
    }

    public static void add(AbstractObjectCache<?, ?> cache) {
        CACHE_POOL.add(cache);
    }

    public static void remove(AbstractObjectCache<?, ?> cache) {
        CACHE_POOL.remove(cache);
    }

    public static <T extends AbstractObjectCache<?, ?>> T generateObjectCache(T newCache) {
        ObjectCachePool.add(newCache);
        return newCache;
    }

    public static <KEY_T, DATA_T> DefaultObjectCache<KEY_T, DATA_T> generateDefaultObjectCache(long dataLife) {
        DefaultObjectCache newCache = new DefaultObjectCache(dataLife);
        CACHE_POOL.add(newCache);
        return newCache;
    }

    public static <KEY_T, DATA_T> CacheTimerObjectCache<KEY_T, DATA_T> generateCacheTimerObjectCache(CacheTimerObjectCache.CacheTimer<DATA_T> cacheTimer) {
        CacheTimerObjectCache newCache = new CacheTimerObjectCache(cacheTimer);
        CACHE_POOL.add(newCache);
        return newCache;
    }

    public static void initEulerCachePoolCleaner(long delay, long period) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ObjectCachePool.clean();
            }
        }, delay, period);
    }
}

