/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.cache.inMemoryCache;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import net.eulerframework.cache.inMemoryCache.DataNotFoundException;
import net.eulerframework.common.base.log.LogSupport;

public abstract class AbstractObjectCache<KEY_T, DATA_T>
extends LogSupport {
    protected final HashMap<KEY_T, DataStore<DATA_T>> dataMap = new HashMap();
    protected ReentrantLock cacheWriteLock = new ReentrantLock();

    public boolean put(KEY_T key, DATA_T data) {
        if (!this.isEnable()) {
            return false;
        }
        if (this.cacheWriteLock.tryLock()) {
            try {
                this.dataMap.put(key, new DataStore<DATA_T>(data));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Data key '" + key + "' has been added to cache.");
                }
                return true;
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
        return false;
    }

    public boolean remove(KEY_T key) {
        if (this.cacheWriteLock.tryLock()) {
            try {
                this.dataMap.remove(key);
                return true;
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
        return false;
    }

    public boolean clear() {
        if (this.cacheWriteLock.tryLock()) {
            try {
                this.dataMap.clear();
                return true;
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
        return false;
    }

    public void clean() {
        Set<KEY_T> keySet = this.dataMap.keySet();
        HashSet<KEY_T> keySetNeedRemove = new HashSet<KEY_T>();
        for (Object key : keySet) {
            DataStore<DATA_T> storedData = this.dataMap.get(key);
            if (!this.isExpired(storedData)) continue;
            keySetNeedRemove.add(key);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Data key '" + key + "' was time out and will be removed.");
        }
        for (Object key : keySetNeedRemove) {
            this.remove(key);
        }
    }

    public DATA_T get(KEY_T key) throws DataNotFoundException {
        if (!this.isEnable()) {
            throw new DataNotFoundException();
        }
        DataStore<DATA_T> storedData = this.dataMap.get(key);
        if (storedData == null) {
            throw new DataNotFoundException();
        }
        if (this.isExpired(storedData)) {
            this.remove(key);
            throw new DataNotFoundException();
        }
        return storedData.getData();
    }

    public DATA_T get(KEY_T key, DataGetter<KEY_T, DATA_T> dataGetter) {
        DATA_T data;
        try {
            data = this.get(key);
        }
        catch (DataNotFoundException e) {
            data = dataGetter.getData(key);
            this.put(key, data);
        }
        return data;
    }

    public abstract boolean isExpired(DataStore<DATA_T> var1);

    public abstract boolean isEnable();

    public static interface DataGetter<KEY_T, DATA_T> {
        public DATA_T getData(KEY_T var1);
    }

    protected class DataStore<T> {
        private final T data;
        private final long addTime;

        public DataStore(T data) {
            this.data = data;
            this.addTime = new Date().getTime();
        }

        public T getData() {
            return this.data;
        }

        public long getAddTime() {
            return this.addTime;
        }
    }
}

