/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.cache.inMemoryCache;

import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.eulerframework.cache.inMemoryCache.DataStore;

public class ObjectCache<KEY_T, DATA_T> {
    protected final HashMap<KEY_T, DataStore<DATA_T>> dataMap = new HashMap();
    protected long dataLife;
    protected ReentrantLock cacheWritelock = new ReentrantLock();

    protected ObjectCache() {
        this.dataLife = 0L;
    }

    protected ObjectCache(long dataLife) {
        this.dataLife = dataLife;
    }

    public void setDataLife(long milliseconds) {
        this.dataLife = milliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(KEY_T key, DATA_T data) {
        if (this.dataLife <= 0L) {
            return false;
        }
        if (this.cacheWritelock.tryLock()) {
            try {
                this.dataMap.put(key, new DataStore<DATA_T>(data));
                boolean bl = true;
                return bl;
            }
            finally {
                this.cacheWritelock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(KEY_T key) {
        if (this.cacheWritelock.tryLock()) {
            try {
                this.dataMap.remove(key);
                boolean bl = true;
                return bl;
            }
            finally {
                this.cacheWritelock.unlock();
            }
        }
        return false;
    }

    public DATA_T get(KEY_T key) {
        if (this.dataLife <= 0L) {
            return null;
        }
        DataStore<DATA_T> cacheStore = this.dataMap.get(key);
        if (cacheStore == null) {
            return null;
        }
        if (new Date().getTime() - cacheStore.getAddTime() >= this.dataLife) {
            this.remove(key);
            return null;
        }
        return cacheStore.getData();
    }
}

