/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.cache.inMemoryCache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.eulerframework.cache.inMemoryCache.DataStore;
import net.eulerframework.cache.inMemoryCache.DefaultObjectCache;

public class FuzzyObjectCache<DATA_T>
extends DefaultObjectCache<String, DATA_T> {
    protected FuzzyObjectCache() {
    }

    protected FuzzyObjectCache(long dataLife) {
        super(dataLife);
    }

    public List<DATA_T> getFuzzy(String key) {
        Set keySet = this.dataMap.keySet();
        HashSet<String> targetKeySet = new HashSet<String>();
        for (String each : keySet) {
            if (!each.toUpperCase().contains(key.toUpperCase())) continue;
            targetKeySet.add(each);
        }
        return this.getAll(targetKeySet);
    }

    public List<DATA_T> getAll(Set<String> keySet) {
        ArrayList result = new ArrayList();
        for (String key : keySet) {
            Object data = super.get(key);
            if (data == null) {
                return null;
            }
            result.add(data);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putAll(Map<String, DATA_T> dataMap) {
        if (this.dataLife <= 0L) {
            return false;
        }
        if (this.cacheWriteLock.tryLock()) {
            try {
                HashMap<String, DataStore<DATA_T>> dataStoreMap = new HashMap<String, DataStore<DATA_T>>();
                Set<Map.Entry<String, DATA_T>> entrySet = dataMap.entrySet();
                for (Map.Entry<String, DATA_T> entry : entrySet) {
                    String key = entry.getKey();
                    DATA_T obj = entry.getValue();
                    dataStoreMap.put(key, new DataStore<DATA_T>(obj));
                }
                this.dataMap.putAll(dataStoreMap);
                boolean bl = true;
                return bl;
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
        return false;
    }
}

