/*
 * Decompiled with CFR 0.152.
 */
package net.eulerframework.cache.inMemoryCache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import net.eulerframework.cache.inMemoryCache.DataStore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractObjectCache<KEY_T, DATA_T> {
    protected Logger logger = LogManager.getLogger(this.getClass());
    protected final HashMap<KEY_T, DataStore<DATA_T>> dataMap = new HashMap();
    protected ReentrantLock cacheWriteLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(KEY_T key, DATA_T data) {
        if (!this.isEnable()) {
            return false;
        }
        if (this.cacheWriteLock.tryLock()) {
            try {
                this.dataMap.put(key, new DataStore<DATA_T>(data));
                boolean bl = true;
                return bl;
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(KEY_T key) {
        if (this.cacheWriteLock.tryLock()) {
            try {
                this.dataMap.remove(key);
                boolean bl = true;
                return bl;
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clear() {
        if (this.cacheWriteLock.tryLock()) {
            try {
                this.dataMap.clear();
                boolean bl = true;
                return bl;
            }
            finally {
                this.cacheWriteLock.unlock();
            }
        }
        return false;
    }

    public void clean() {
        Set<KEY_T> keySet = this.dataMap.keySet();
        HashSet<KEY_T> keySetNeedRemove = new HashSet<KEY_T>();
        for (Object key : keySet) {
            DataStore<DATA_T> storedData = this.dataMap.get(key);
            if (!this.isTimeout(storedData)) continue;
            keySetNeedRemove.add(key);
            this.logger.info("Data key = " + key + " was time out and will be removed.");
        }
        for (Object key : keySetNeedRemove) {
            this.remove(key);
        }
    }

    public DATA_T get(KEY_T key) {
        if (!this.isEnable()) {
            return null;
        }
        DataStore<DATA_T> storedData = this.dataMap.get(key);
        if (storedData == null) {
            return null;
        }
        if (this.isTimeout(storedData)) {
            this.remove(key);
            return null;
        }
        return storedData.getData();
    }

    public abstract boolean isTimeout(DataStore<DATA_T> var1);

    public abstract boolean isEnable();
}

