/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommentHelper {
    public static final CommentHelper INSTANCE = new CommentHelper();
    private static Map<String, CommentInner> comments;

    private CommentHelper() {
        comments = new HashMap<String, CommentInner>();
        try {
            this.parse();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void parse() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        factory.setValidating(false);
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("mybatis-generator-docs.xml");){
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = null;
            try {
                document = builder.parse(is);
            }
            catch (Exception e) {
                throw new RuntimeException("can't parse docs.xml");
            }
            if (document == null) {
                throw new RuntimeException("can't parse docs.xml");
            }
            Element rootNode = document.getDocumentElement();
            this.parseRootNode(rootNode);
        }
    }

    private void parseRootNode(Element rootNode) {
        NodeList nodeList = rootNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1 || !"doc".equals(childNode.getNodeName())) continue;
            this.parseNode(childNode);
        }
    }

    private void parseNode(Node childNode) {
        Properties properties = this.parseAttributes(childNode);
        String key = properties.getProperty("key");
        String category = properties.getProperty("category", "");
        String tag = properties.getProperty("tag", "");
        String value = childNode.getTextContent();
        String[] lines = StringUtils.split((String)value, (char)'\n');
        ArrayList<String> commentLines = new ArrayList<String>();
        Arrays.asList(lines).forEach(str -> {
            String trim = StringUtils.trim((String)str);
            if (StringUtils.isNotEmpty((CharSequence)trim)) {
                commentLines.add(trim);
            }
        });
        String computedKey = key.concat(category).concat(tag);
        comments.putIfAbsent(computedKey, CommentInner.builder().category(category).tag(tag).lines(commentLines).build());
    }

    protected Properties parseAttributes(Node node) {
        Properties attributes = new Properties();
        NamedNodeMap nnm = node.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node attribute = nnm.item(i);
            String value = attribute.getNodeValue();
            attributes.put(attribute.getNodeName(), value);
        }
        return attributes;
    }

    public List<String> getComments(String key) {
        return this.getComments(key, "", "", Collections.emptyMap());
    }

    public List<String> getComments(String key, String category) {
        return this.getComments(key, category, "", Collections.emptyMap());
    }

    public List<String> getComments(String key, String category, String tag) {
        return this.getComments(key, category, tag, Collections.emptyMap());
    }

    public List<String> getComments(String key, String category, Map<String, Object> variables) {
        return this.getComments(key, category, "", variables);
    }

    public List<String> getComments(String key, String category, String tag, Map<String, Object> variables) {
        String computedKey = StringUtils.defaultString((String)key, (String)"").concat(StringUtils.defaultString((String)category, (String)"")).concat(StringUtils.defaultString((String)tag, (String)""));
        if (comments.containsKey(computedKey)) {
            CommentInner inner = comments.get(computedKey);
            ArrayList<String> result = new ArrayList<String>();
            inner.lines.forEach(line -> result.add(this.replace((String)line, variables)));
            return result;
        }
        return Collections.emptyList();
    }

    private String replace(String target, Map<String, Object> variables) {
        if (variables == null || variables.size() == 0) {
            return target;
        }
        String[] searchStrings = new String[variables.size()];
        String[] replaceStrings = new String[variables.size()];
        AtomicInteger index = new AtomicInteger(0);
        variables.forEach((key, value) -> {
            searchStrings[index.get()] = "{" + key + "}";
            replaceStrings[index.get()] = String.valueOf(value);
            index.getAndIncrement();
        });
        return StringUtils.replaceEachRepeatedly((String)target, (String[])searchStrings, (String[])replaceStrings);
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.join(INSTANCE.getComments("test"), (String)"\n"));
    }

    public static class CommentInner {
        private String key;
        private String category;
        private String tag;
        private List<String> lines;

        CommentInner(String key, String category, String tag, List<String> lines) {
            this.key = key;
            this.category = category;
            this.tag = tag;
            this.lines = lines;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getKey() {
            return this.key;
        }

        public String getCategory() {
            return this.category;
        }

        public String getTag() {
            return this.tag;
        }

        public List<String> getLines() {
            return this.lines;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public void setLines(List<String> lines) {
            this.lines = lines;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommentInner)) {
                return false;
            }
            CommentInner other = (CommentInner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
                return false;
            }
            List<String> this$lines = this.getLines();
            List<String> other$lines = other.getLines();
            return !(this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CommentInner;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            List<String> $lines = this.getLines();
            result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
            return result;
        }

        public String toString() {
            return "CommentHelper.CommentInner(key=" + this.getKey() + ", category=" + this.getCategory() + ", tag=" + this.getTag() + ", lines=" + this.getLines() + ")";
        }

        public static class Builder {
            private String key;
            private String category;
            private String tag;
            private List<String> lines;

            Builder() {
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder category(String category) {
                this.category = category;
                return this;
            }

            public Builder tag(String tag) {
                this.tag = tag;
                return this;
            }

            public Builder lines(List<String> lines) {
                this.lines = lines;
                return this;
            }

            public CommentInner build() {
                return new CommentInner(this.key, this.category, this.tag, this.lines);
            }

            public String toString() {
                return "CommentHelper.CommentInner.Builder(key=" + this.key + ", category=" + this.category + ", tag=" + this.tag + ", lines=" + this.lines + ")";
            }
        }
    }
}

