/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.typescript.runtime;

import java.time.LocalDateTime;
import net.entframework.kernel.db.generator.config.Relation;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.config.JoinTarget;

public class ModelField {
    private final Field field;
    private final IntrospectedColumn column;

    public ModelField(Field field, IntrospectedColumn column) {
        this.field = field;
        this.column = column;
    }

    public FullyQualifiedJavaType getJavaType() {
        return this.field.getType();
    }

    public String getName() {
        return this.field.getName();
    }

    public String getDescription() {
        return this.field.getDescription();
    }

    public int getLength() {
        return this.column.getLength();
    }

    public boolean isRequired() {
        return !this.column.isNullable();
    }

    public int getScale() {
        return this.column.getScale();
    }

    public String getFieldType() {
        if (StringUtils.equalsAny((CharSequence)this.field.getType().getShortName(), (CharSequence[])new CharSequence[]{"boolean", "Boolean"})) {
            return "boolean";
        }
        if (this.field.getAttribute("TABLE_ENUM_FIELD_ATTR") != null) {
            return "enum";
        }
        if (this.field.getAttribute("TARGET_FIELD_RELATION") != null) {
            return "relation";
        }
        if (this.column.isStringColumn()) {
            return "string";
        }
        if (this.column.isNumberColumn()) {
            return "number";
        }
        if (this.column.isBLOBColumn()) {
            return "blob";
        }
        if (this.column.isJDBCDateColumn()) {
            return "date";
        }
        if (this.column.isJDBCTimeColumn()) {
            return "time";
        }
        if (StringUtils.equals((CharSequence)LocalDateTime.class.getName(), (CharSequence)this.column.getFullyQualifiedJavaType().getFullyQualifiedName())) {
            return "date-time";
        }
        return "string";
    }

    public String getRemarks() {
        return this.column.getRemarks();
    }

    public String getDefaultValue() {
        return this.column.getDefaultValue();
    }

    public boolean isBasic() {
        return this.field.getAttribute("FIELD_EXT_ATTR") == null;
    }

    public boolean isRelationField() {
        return GeneratorUtils.isRelationField(this.field);
    }

    public boolean isManyToOne() {
        return this.isRelationField() && this.isRelationType(JoinTarget.JoinType.MANY_TO_ONE);
    }

    public boolean isRelationMany() {
        return this.isRelationField() && this.isRelationType(JoinTarget.JoinType.ONE_TO_MANY);
    }

    private boolean isRelationType(JoinTarget.JoinType joinType) {
        Relation relation = (Relation)this.field.getAttribute("FIELD_RELATION");
        return relation.getJoinType() != null && relation.getJoinType() == joinType;
    }

    public Relation getRelation() {
        return (Relation)this.field.getAttribute("FIELD_RELATION");
    }

    public Relation getTargetRelation() {
        return (Relation)this.field.getAttribute("TARGET_FIELD_RELATION");
    }
}

