/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.typescript;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.entframework.kernel.db.generator.typescript.runtime.FullyQualifiedTypescriptType;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.JavaTypeResolver;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.db.ActualTableName;
import org.mybatis.generator.internal.util.StringUtility;

public class TypescriptResolverDefaultImpl
implements JavaTypeResolver {
    protected List<String> warnings;
    protected final Properties properties = new Properties();
    protected Context context;
    protected boolean convertLongToString;
    protected final Map<Integer, JdbcTypeInformation> typeMap = new HashMap<Integer, JdbcTypeInformation>();

    public TypescriptResolverDefaultImpl() {
        this.typeMap.put(2003, new JdbcTypeInformation("ARRAY", new FullyQualifiedTypescriptType("any")));
        this.typeMap.put(-5, new JdbcTypeInformation("BIGINT", new FullyQualifiedTypescriptType("number")));
        this.typeMap.put(-2, new JdbcTypeInformation("BINARY", new FullyQualifiedTypescriptType("byte[]")));
        this.typeMap.put(-7, new JdbcTypeInformation("BIT", new FullyQualifiedTypescriptType("boolean")));
        this.typeMap.put(2004, new JdbcTypeInformation("BLOB", new FullyQualifiedTypescriptType("byte[]")));
        this.typeMap.put(16, new JdbcTypeInformation("BOOLEAN", new FullyQualifiedTypescriptType("boolean")));
        this.typeMap.put(1, new JdbcTypeInformation("CHAR", new FullyQualifiedTypescriptType("string")));
        this.typeMap.put(2005, new JdbcTypeInformation("CLOB", new FullyQualifiedTypescriptType("string")));
        this.typeMap.put(70, new JdbcTypeInformation("DATALINK", new FullyQualifiedTypescriptType("any")));
        this.typeMap.put(91, new JdbcTypeInformation("DATE", new FullyQualifiedTypescriptType("Date")));
        this.typeMap.put(3, new JdbcTypeInformation("DECIMAL", new FullyQualifiedTypescriptType("number")));
        this.typeMap.put(2001, new JdbcTypeInformation("DISTINCT", new FullyQualifiedTypescriptType("any")));
        this.typeMap.put(8, new JdbcTypeInformation("DOUBLE", new FullyQualifiedTypescriptType("number")));
        this.typeMap.put(6, new JdbcTypeInformation("FLOAT", new FullyQualifiedTypescriptType("number")));
        this.typeMap.put(4, new JdbcTypeInformation("INTEGER", new FullyQualifiedTypescriptType("number")));
        this.typeMap.put(2000, new JdbcTypeInformation("JAVA_OBJECT", new FullyQualifiedTypescriptType("any")));
        this.typeMap.put(-16, new JdbcTypeInformation("LONGNVARCHAR", new FullyQualifiedTypescriptType("string")));
        this.typeMap.put(-4, new JdbcTypeInformation("LONGVARBINARY", new FullyQualifiedTypescriptType("byte[]")));
        this.typeMap.put(-1, new JdbcTypeInformation("LONGVARCHAR", new FullyQualifiedTypescriptType("string")));
        this.typeMap.put(-15, new JdbcTypeInformation("NCHAR", new FullyQualifiedTypescriptType("string")));
        this.typeMap.put(2011, new JdbcTypeInformation("NCLOB", new FullyQualifiedTypescriptType("string")));
        this.typeMap.put(-9, new JdbcTypeInformation("NVARCHAR", new FullyQualifiedTypescriptType("string")));
        this.typeMap.put(0, new JdbcTypeInformation("NULL", new FullyQualifiedTypescriptType("any")));
        this.typeMap.put(2, new JdbcTypeInformation("NUMERIC", new FullyQualifiedTypescriptType("number")));
        this.typeMap.put(1111, new JdbcTypeInformation("OTHER", new FullyQualifiedTypescriptType("any")));
        this.typeMap.put(7, new JdbcTypeInformation("REAL", new FullyQualifiedTypescriptType("number")));
        this.typeMap.put(2006, new JdbcTypeInformation("REF", new FullyQualifiedTypescriptType("any")));
        this.typeMap.put(5, new JdbcTypeInformation("SMALLINT", new FullyQualifiedTypescriptType("number")));
        this.typeMap.put(2002, new JdbcTypeInformation("STRUCT", new FullyQualifiedTypescriptType("any")));
        this.typeMap.put(92, new JdbcTypeInformation("TIME", new FullyQualifiedTypescriptType("Date")));
        this.typeMap.put(93, new JdbcTypeInformation("TIMESTAMP", new FullyQualifiedTypescriptType("Date")));
        this.typeMap.put(-6, new JdbcTypeInformation("TINYINT", new FullyQualifiedTypescriptType("number")));
        this.typeMap.put(-3, new JdbcTypeInformation("VARBINARY", new FullyQualifiedTypescriptType("byte[]")));
        this.typeMap.put(12, new JdbcTypeInformation("VARCHAR", new FullyQualifiedTypescriptType("string")));
        this.typeMap.put(2013, new JdbcTypeInformation("TIME_WITH_TIMEZONE", new FullyQualifiedTypescriptType("java.time.OffsetTime")));
        this.typeMap.put(2014, new JdbcTypeInformation("TIMESTAMP_WITH_TIMEZONE", new FullyQualifiedTypescriptType("java.time.OffsetDateTime")));
    }

    public void addConfigurationProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        this.convertLongToString = StringUtility.isTrue((String)properties.getProperty("convertLongToString"));
    }

    public FullyQualifiedTypescriptType calculateJavaType(ActualTableName actualTable, IntrospectedColumn introspectedColumn) {
        FullyQualifiedTypescriptType answer = null;
        JdbcTypeInformation jdbcTypeInformation = this.typeMap.get(introspectedColumn.getJdbcType());
        if (jdbcTypeInformation != null) {
            answer = jdbcTypeInformation.getFullyQualifiedJavaType();
            answer = this.overrideDefaultType(introspectedColumn, answer);
        }
        return answer;
    }

    protected FullyQualifiedTypescriptType overrideDefaultType(IntrospectedColumn column, FullyQualifiedTypescriptType defaultType) {
        FullyQualifiedTypescriptType answer = defaultType;
        switch (column.getJdbcType()) {
            case -7: {
                answer = this.calculateBitReplacement(column, defaultType);
                break;
            }
            case 2: 
            case 3: {
                answer = this.calculateBigDecimalReplacement(column, defaultType);
                break;
            }
            case -5: {
                answer = this.calculateBigintType(column, defaultType);
                break;
            }
        }
        return answer;
    }

    protected FullyQualifiedTypescriptType calculateBigintType(IntrospectedColumn column, FullyQualifiedTypescriptType defaultType) {
        FullyQualifiedTypescriptType answer = this.convertLongToString ? new FullyQualifiedTypescriptType("string") : defaultType;
        return answer;
    }

    protected FullyQualifiedTypescriptType calculateBitReplacement(IntrospectedColumn column, FullyQualifiedTypescriptType defaultType) {
        FullyQualifiedTypescriptType answer = column.getLength() > 1 ? new FullyQualifiedTypescriptType("byte[]") : defaultType;
        return answer;
    }

    protected FullyQualifiedTypescriptType calculateBigDecimalReplacement(IntrospectedColumn column, FullyQualifiedTypescriptType defaultType) {
        return new FullyQualifiedTypescriptType("number");
    }

    public String calculateJdbcTypeName(IntrospectedColumn introspectedColumn) {
        String answer = null;
        JdbcTypeInformation jdbcTypeInformation = this.typeMap.get(introspectedColumn.getJdbcType());
        if (jdbcTypeInformation != null) {
            answer = jdbcTypeInformation.getJdbcTypeName();
        }
        return answer;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public static class JdbcTypeInformation {
        private final String jdbcTypeName;
        private final FullyQualifiedTypescriptType fullyQualifiedJavaType;

        public JdbcTypeInformation(String jdbcTypeName, FullyQualifiedTypescriptType fullyQualifiedJavaType) {
            this.jdbcTypeName = jdbcTypeName;
            this.fullyQualifiedJavaType = fullyQualifiedJavaType;
        }

        public String getJdbcTypeName() {
            return this.jdbcTypeName;
        }

        public FullyQualifiedTypescriptType getFullyQualifiedJavaType() {
            return this.fullyQualifiedJavaType;
        }
    }
}

