/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.typescript;

import java.util.ArrayList;
import java.util.List;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import net.entframework.kernel.db.generator.plugin.generator.RestMethodAndImports;
import net.entframework.kernel.db.generator.plugin.generator.WebRestMethodsGenerator;
import net.entframework.kernel.db.generator.typescript.render.RenderingUtilities;
import net.entframework.kernel.db.generator.typescript.runtime.FullyQualifiedTypescriptType;
import net.entframework.kernel.db.generator.typescript.runtime.TypescriptTopLevelClass;
import net.entframework.kernel.db.generator.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.WriteMode;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.codegen.AbstractJavaClientGenerator;
import org.mybatis.generator.codegen.AbstractXmlGenerator;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.messages.Messages;

public class TypescriptClientGenerator
extends AbstractJavaClientGenerator {
    protected String projectRootAlias = "";
    protected String apiDefaultPrefix = "";
    protected String apiEnvName = "";

    public TypescriptClientGenerator(String project) {
        super(project, false);
    }

    public List<CompilationUnit> getCompilationUnits() {
        this.progressCallback.startTask(Messages.getString((String)"Progress.17", (Object[])new Object[]{this.introspectedTable.getFullyQualifiedTable().toString()}));
        this.preCalculate();
        Interface interfaze = this.createBasicInterface();
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        answer.add((CompilationUnit)this.generateRestApiClass());
        return answer;
    }

    protected void preCalculate() {
        this.projectRootAlias = this.context.getProperty("projectRootAlias");
        if (StringUtils.isBlank((CharSequence)this.projectRootAlias)) {
            this.projectRootAlias = "";
        }
        this.apiDefaultPrefix = this.context.getProperty("apiDefaultPrefix");
        if (StringUtils.isBlank((CharSequence)this.apiDefaultPrefix)) {
            this.apiDefaultPrefix = "";
        }
        this.apiEnvName = this.context.getProperty("apiEnvName");
        if (StringUtils.isBlank((CharSequence)this.apiEnvName)) {
            this.apiEnvName = "";
        }
    }

    protected Interface createBasicInterface() {
        FullyQualifiedTable table = this.introspectedTable.getFullyQualifiedTable();
        String camelCaseName = JavaBeansUtil.convertCamelCase((String)table.getDomainObjectName(), (String)"-");
        String typescriptModelPackage = this.context.getJavaClientGeneratorConfiguration().getTargetPackage();
        FullyQualifiedTypescriptType type = new FullyQualifiedTypescriptType("", typescriptModelPackage + "." + camelCaseName + "." + table.getDomainObjectName(), true);
        Interface interfaze = new Interface((FullyQualifiedJavaType)type);
        interfaze.setVisibility(JavaVisibility.PUBLIC);
        this.context.getCommentGenerator().addJavaFileComment((CompilationUnit)interfaze);
        return interfaze;
    }

    private TypescriptTopLevelClass generateRestApiClass() {
        FullyQualifiedTable table = this.introspectedTable.getFullyQualifiedTable();
        String modelObjectName = table.getDomainObjectName();
        String camelCaseName = JavaBeansUtil.convertCamelCase((String)modelObjectName, (String)"-");
        FullyQualifiedTypescriptType tsApiModelJavaType = new FullyQualifiedTypescriptType(this.projectRootAlias, this.context.getJavaClientGeneratorConfiguration().getTargetPackage() + "." + camelCaseName + "." + modelObjectName, true);
        TypescriptTopLevelClass tsBaseModelClass = new TypescriptTopLevelClass(tsApiModelJavaType);
        tsBaseModelClass.setWriteMode(WriteMode.OVER_WRITE);
        tsBaseModelClass.setVisibility(JavaVisibility.PUBLIC);
        String typescriptModelPackage = this.context.getJavaModelGeneratorConfiguration().getTargetPackage();
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(typescriptModelPackage + "." + modelObjectName);
        FullyQualifiedTypescriptType requestJavaType = new FullyQualifiedTypescriptType(this.projectRootAlias, typescriptModelPackage + "." + WebUtils.getFileName(modelObjectName) + "." + modelObjectName, true);
        IntrospectedColumn pkColumn = GeneratorUtils.getPrimaryKey(this.introspectedTable);
        WebRestMethodsGenerator restMethodsGenerator = new WebRestMethodsGenerator(recordType, requestJavaType, "", pkColumn, false);
        restMethodsGenerator.generate();
        RestMethodAndImports methodAndImports = restMethodsGenerator.build();
        methodAndImports.getMethods().forEach(method -> {
            String methodName = method.getName();
            Object returnTypeName = "void";
            if (method.getReturnType().isPresent()) {
                FullyQualifiedJavaType returnType = (FullyQualifiedJavaType)method.getReturnType().get();
                if (returnType.getFullyQualifiedNameWithoutTypeParameters().equals("net.entframework.kernel.db.api.pojo.page.PageResult")) {
                    FullyQualifiedJavaType arg = (FullyQualifiedJavaType)returnType.getTypeArguments().get(0);
                    String newTypeName = arg.getShortName() + "PageModel";
                    FullyQualifiedTypescriptType newType = new FullyQualifiedTypescriptType(this.projectRootAlias, typescriptModelPackage + "." + JavaBeansUtil.convertCamelCase((String)arg.getShortName(), (String)"-") + "." + newTypeName, true);
                    returnTypeName = newTypeName;
                    method.setReturnType(newType);
                    methodAndImports.getImports().removeIf(javaType -> javaType.equals((Object)returnType));
                    methodAndImports.getImports().add(newType);
                } else {
                    returnTypeName = RenderingUtilities.calculateTypescriptTypeName(null, returnType);
                }
            }
            Parameter parameter = (Parameter)method.getParameters().get(0);
            if (StringUtils.equals((CharSequence)"POST", (CharSequence)method.getHttpMethod())) {
                method.addBodyLine(String.format("defHttp.post<%s>({ url: '%s%s', data: %s });", returnTypeName, this.apiDefaultPrefix, method.getRestPath(), parameter.getName()));
            }
            if (StringUtils.equals((CharSequence)"GET", (CharSequence)method.getHttpMethod())) {
                method.addBodyLine(String.format("defHttp.get<%s>({ url: '%s%s', params: %s });", returnTypeName, this.apiDefaultPrefix, method.getRestPath(), parameter.getName()));
            }
            method.setName(modelObjectName + StringUtils.capitalize((String)methodName));
        });
        methodAndImports.getMethods().forEach(arg_0 -> ((TypescriptTopLevelClass)tsBaseModelClass).addMethod(arg_0));
        tsBaseModelClass.addImportedTypes(methodAndImports.getImports());
        tsBaseModelClass.setAttribute("WEB_PROJECT_ROOT_ALIAS", this.projectRootAlias);
        tsBaseModelClass.addImportedType(new FullyQualifiedTypescriptType("", "fe-ent-core.es.utils.http.defHttp", false));
        return tsBaseModelClass;
    }

    public AbstractXmlGenerator getMatchedXMLGenerator() {
        return null;
    }
}

