/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.web;

import java.util.List;
import net.entframework.kernel.db.generator.config.Relation;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import net.entframework.kernel.db.generator.plugin.web.AbstractWebPlugin;
import net.entframework.kernel.db.generator.utils.WebUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JoinEntry;
import org.mybatis.generator.config.JoinTable;
import org.mybatis.generator.config.JoinTarget;
import org.mybatis.generator.internal.util.JavaBeansUtil;

public class TypescriptModelPlugin
extends AbstractWebPlugin {
    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String tableName = introspectedTable.getFullyQualifiedTable().getIntrospectedTableName();
        JoinEntry joinEntry = this.context.getJoinConfig().getJoinEntry(tableName);
        if (joinEntry != null) {
            joinEntry.validate();
            this.addJoinField(topLevelClass, joinEntry);
        }
        return true;
    }

    private void addJoinField(TopLevelClass topLevelClass, JoinEntry joinEntry) {
        IntrospectedTable rightTable;
        for (Pair detail : joinEntry.getDetails()) {
            JoinTarget target = (JoinTarget)detail.getRight();
            rightTable = GeneratorUtils.getIntrospectedTable(this.context, target.getRightTable());
            IntrospectedTable leftTable = GeneratorUtils.getIntrospectedTable(this.context, joinEntry.getLeftTable());
            FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(rightTable.getBaseRecordType());
            recordType = WebUtils.convertToTypescriptType(this.context, recordType);
            FullyQualifiedJavaType listReturnType = FullyQualifiedJavaType.getNewListInstance();
            listReturnType.addTypeArgument(recordType);
            FullyQualifiedJavaType filedType = target.getType() == JoinTarget.JoinType.ONE_TO_MANY ? listReturnType : recordType;
            IntrospectedColumn introspectedColumn = new IntrospectedColumn();
            introspectedColumn.setJavaProperty(target.getFieldName());
            introspectedColumn.setContext(this.context);
            introspectedColumn.setIntrospectedTable(rightTable);
            introspectedColumn.setFullyQualifiedJavaType(filedType);
            introspectedColumn.setActualColumnName(target.getJoinColumn());
            IntrospectedColumn rightTableColumn = GeneratorUtils.getIntrospectedColumnByColumn(rightTable, target.getJoinColumn());
            Field field = JavaBeansUtil.getJavaBeansFieldWithGeneratedAnnotation((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)rightTable, (CompilationUnit)topLevelClass);
            field.setAttribute("FIELD_RELATION", (Object)true);
            if (!this.context.getPlugins().modelFieldGenerated(field, topLevelClass, introspectedColumn, rightTable, Plugin.ModelClassType.BASE_RECORD)) continue;
            Relation.Builder builder = Relation.builder();
            topLevelClass.addImportedType(recordType);
            if (target.getType() == JoinTarget.JoinType.ONE_TO_MANY) {
                topLevelClass.addImportedType(FullyQualifiedJavaType.getNewListInstance());
                IntrospectedColumn leftKeyColumn = GeneratorUtils.getIntrospectedColumnByColumn(leftTable, (String)detail.getKey());
                field.setDescription(GeneratorUtils.getFileDescription(rightTable));
                builder.joinType(JoinTarget.JoinType.ONE_TO_MANY).bindField(field).sourceField(GeneratorUtils.getFieldByName(topLevelClass, leftKeyColumn.getJavaProperty())).targetTable(rightTable).targetColumn(rightTableColumn);
            }
            if (target.getType() == JoinTarget.JoinType.MANY_TO_ONE) {
                String columnName = (String)detail.getKey();
                IntrospectedColumn leftColumn = GeneratorUtils.getIntrospectedColumnByColumn(leftTable, columnName);
                Field relatedField = GeneratorUtils.getFieldByName(topLevelClass, leftColumn.getJavaProperty());
                field.setDescription(GeneratorUtils.getFileDescription(rightTable));
                builder.sourceField(relatedField).joinType(JoinTarget.JoinType.MANY_TO_ONE).bindField(field).targetTable(rightTable).displayField(rightTable.getTableConfiguration().getDisplayField()).targetColumn(GeneratorUtils.getIntrospectedColumnByColumn(rightTable, target.getJoinColumn()));
            }
            field.setAttribute("FIELD_RELATION", (Object)builder.build());
            field.getJavaDocLines().clear();
            GeneratorUtils.addComment((JavaElement)field, field.getDescription());
            topLevelClass.addField(field);
        }
        List joinTables = joinEntry.getJoinTables();
        for (JoinTable joinTable : joinTables) {
            rightTable = GeneratorUtils.getIntrospectedTable(this.context, joinTable.getRightTable());
            FullyQualifiedJavaType targetBindType = new FullyQualifiedJavaType(rightTable.getBaseRecordType());
            targetBindType = WebUtils.convertToTypescriptType(this.context, targetBindType);
            IntrospectedColumn introspectedColumn = new IntrospectedColumn();
            introspectedColumn.setJavaProperty(joinTable.getProperty());
            introspectedColumn.setContext(this.context);
            introspectedColumn.setIntrospectedTable(rightTable);
            introspectedColumn.setFullyQualifiedJavaType(new FullyQualifiedJavaType(rightTable.getBaseRecordType()));
            introspectedColumn.setActualColumnName("");
            FullyQualifiedJavaType listJavaType = FullyQualifiedJavaType.getNewListInstance();
            listJavaType.addTypeArgument(targetBindType);
            topLevelClass.addImportedType(targetBindType);
            Field field = new Field(joinTable.getProperty(), listJavaType);
            field.setDescription(GeneratorUtils.getFileDescription(rightTable));
            GeneratorUtils.addComment((JavaElement)field, field.getDescription());
            field.setAttribute("FIELD_RELATION", (Object)true);
            if (!this.context.getPlugins().modelFieldGenerated(field, topLevelClass, introspectedColumn, rightTable, Plugin.ModelClassType.BASE_RECORD)) continue;
            Relation.Builder builder = Relation.builder();
            builder.joinType(JoinTarget.JoinType.MANY_TO_MANY);
            field.setVisibility(JavaVisibility.PRIVATE);
            field.setAttribute("FIELD_RELATION", (Object)builder.build());
            topLevelClass.addField(field);
        }
    }
}

