/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.entframework.kernel.db.generator.config.Relation;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import net.entframework.kernel.db.generator.plugin.web.AbstractTemplatePlugin;
import net.entframework.kernel.db.generator.typescript.runtime.FullyQualifiedTypescriptType;
import net.entframework.kernel.db.generator.typescript.runtime.ModelField;
import net.entframework.kernel.db.generator.typescript.runtime.TemplateGeneratedFile;
import net.entframework.kernel.db.generator.typescript.runtime.TypescriptTopLevelClass;
import net.entframework.kernel.db.generator.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.GeneratedFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.WriteMode;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.JoinTarget;
import org.mybatis.generator.internal.util.JavaBeansUtil;

public class TemplateModelViewPlugin
extends AbstractTemplatePlugin {
    private final List<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generatedFiles.add(this.generateModelClass(topLevelClass, introspectedTable));
        return true;
    }

    private GeneratedFile generateModelClass(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String modelObjectName = topLevelClass.getType().getShortNameWithoutTypeArguments();
        String camelCaseName = JavaBeansUtil.convertCamelCase((String)modelObjectName, (String)"-");
        FullyQualifiedTypescriptType tsBaseModelJavaType = this.enableSubPackages ? new FullyQualifiedTypescriptType(this.targetPackage + "." + camelCaseName + "." + modelObjectName, true) : new FullyQualifiedTypescriptType(this.targetPackage + "." + modelObjectName, true);
        TypescriptTopLevelClass tsApiClass = new TypescriptTopLevelClass(tsBaseModelJavaType);
        tsApiClass.setWriteMode(this.writeMode == null ? WriteMode.SKIP_ON_EXIST : this.writeMode);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("projectRootAlias", this.projectRootAlias);
        data.put("modelPackage", this.typescriptModelPackage.replaceAll("\\.", "/"));
        data.put("modelName", modelObjectName);
        data.put("modelDescription", topLevelClass.getDescription());
        data.put("camelModelName", camelCaseName);
        data.put("modelPath", this.modelPath);
        data.putAll(this.getAdditionalPropertyMap());
        IntrospectedColumn pkColumn = GeneratorUtils.getPrimaryKey(introspectedTable);
        List<Field> fields = WebUtils.getFieldsWithoutPrimaryKey(topLevelClass.getFields(), pkColumn.getJavaProperty());
        data.put("fields", fields);
        data.put("listFields", this.convert(WebUtils.getListFields(fields, this.getListIgnoreFields()), introspectedTable));
        data.put("searchFields", this.convert(WebUtils.getSearchFields(fields, this.getListIgnoreFields()), introspectedTable));
        data.put("inputFields", this.convert(WebUtils.getInputFields(fields, this.getInputIgnoreFields()), introspectedTable));
        List<Field> enumFields = fields.stream().filter(field -> field.getAttribute("TABLE_ENUM_FIELD_ATTR") != null && !GeneratorUtils.isLogicDeleteField(field)).collect(Collectors.toSet()).stream().toList();
        data.put("enumFields", this.convert(enumFields, introspectedTable));
        data.put("relationFields", this.convert(WebUtils.getRelationFields(fields), introspectedTable));
        data.put("pk", new ModelField(GeneratorUtils.getFieldByName(topLevelClass, pkColumn.getJavaProperty()), pkColumn));
        String apiPath = StringUtils.replace((String)this.apiPackage, (String)".", (String)"/");
        data.put("apiPath", apiPath);
        data.put("viewPath", StringUtils.replace((String)this.viewPackage, (String)".", (String)"/"));
        return new TemplateGeneratedFile(tsApiClass, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), data, this.templatePath, this.fileName, this.fileExt);
    }

    public List<GeneratedFile> contextGenerateAdditionalFiles() {
        return this.generatedFiles;
    }

    protected List<ModelField> convert(List<Field> fields, IntrospectedTable introspectedTable) {
        ArrayList<ModelField> modelFields = new ArrayList<ModelField>();
        for (Field field : fields) {
            IntrospectedColumn column = null;
            if (GeneratorUtils.isRelationField(introspectedTable, field)) {
                Relation relation = (Relation)field.getAttribute("FIELD_RELATION");
                if (relation.getJoinType() != JoinTarget.JoinType.MANY_TO_ONE) continue;
                column = GeneratorUtils.safeGetIntrospectedColumnByJavaProperty(introspectedTable, relation.getSourceField().getName());
            } else {
                column = GeneratorUtils.safeGetIntrospectedColumnByJavaProperty(introspectedTable, field.getName());
            }
            if (column == null) {
                this.log.warn("Can't find column in table: " + introspectedTable.getFullyQualifiedTable().getIntrospectedTableName() + " by field name: " + field.getName());
                continue;
            }
            ModelField modelField = new ModelField(field, column);
            modelFields.add(modelField);
        }
        return modelFields;
    }
}

