/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.web;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.entframework.kernel.db.generator.plugin.AbstractDynamicSQLPlugin;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.WriteMode;

public class AbstractWebPlugin
extends AbstractDynamicSQLPlugin {
    public static final String API_ROOT = "api";
    public static final String MODEL_ROOT = "model";
    public static final String ROUTER_ROOT = "routes";
    public static final String VIEW_ROOT = "views";
    protected String projectRootAlias = "";
    protected String typescriptModelPackage;
    protected String apiPackage;
    protected String viewPackage;
    protected String enumPackage;
    protected String codingStyle;
    protected String outputSubFolder;

    public boolean validate(List<String> warnings) {
        this.typescriptModelPackage = this.context.getJavaModelGeneratorConfiguration().getTargetPackage();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.typescriptModelPackage})) {
            warnings.add("\u8bf7\u5728javaModelGenerator\u8282\u70b9\u4e2dtargetPackage\u5c5e\u6027");
            return false;
        }
        this.apiPackage = API_ROOT;
        this.enumPackage = "model.enum";
        this.viewPackage = VIEW_ROOT;
        this.outputSubFolder = this.context.getProperty("outputSubFolder");
        if (StringUtils.isNotEmpty((CharSequence)this.outputSubFolder)) {
            this.apiPackage = "api." + this.outputSubFolder;
            this.enumPackage = "model." + this.outputSubFolder + ".enum";
            this.viewPackage = "views." + this.outputSubFolder;
        }
        this.codingStyle = this.context.getProperty("generatedCodeStyle");
        if (StringUtils.isEmpty((CharSequence)this.codingStyle)) {
            this.codingStyle = "ENT";
        }
        this.projectRootAlias = this.context.getProperty("projectRootAlias");
        String mode = this.properties.getProperty("writeMode");
        if (StringUtils.isNotEmpty((CharSequence)mode)) {
            WriteMode writeMode = this.convert(mode);
            if (writeMode != null) {
                this.writeMode = writeMode;
            } else {
                warnings.add(((Object)((Object)this)).getClass().getName() + "\u914d\u7f6e\u4e86\u9519\u8bef\u7684WriteMode, \u53ef\u7528\u503c: NEVER,OVER_WRITE,SKIP_ON_EXIST");
                return false;
            }
        }
        return true;
    }

    protected Set<String> getListIgnoreFields() {
        HashSet<String> fields = new HashSet<String>();
        String listIgnoreFields = this.context.getProperty("listIgnoreFields");
        if (StringUtils.isNotBlank((CharSequence)listIgnoreFields)) {
            fields.addAll(List.of(StringUtils.split((String)listIgnoreFields, (String)",")));
        }
        if (StringUtils.isNotBlank((CharSequence)(listIgnoreFields = this.properties.getProperty("listIgnoreFields")))) {
            fields.addAll(List.of(StringUtils.split((String)listIgnoreFields, (String)",")));
        }
        return fields;
    }

    protected Set<String> getInputIgnoreFields() {
        HashSet<String> fields = new HashSet<String>();
        String listIgnoreFields = this.context.getProperty("inputIgnoreFields");
        if (StringUtils.isNotBlank((CharSequence)listIgnoreFields)) {
            fields.addAll(List.of(StringUtils.split((String)listIgnoreFields, (String)",")));
        }
        if (StringUtils.isNotBlank((CharSequence)(listIgnoreFields = this.properties.getProperty("inputIgnoreFields")))) {
            fields.addAll(List.of(StringUtils.split((String)listIgnoreFields, (String)",")));
        }
        return fields;
    }
}

