/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server.methods.repository;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import net.entframework.kernel.db.generator.plugin.server.methods.AbstractMethodGenerator;
import net.entframework.kernel.db.generator.plugin.server.methods.MethodAndImports;
import net.entframework.kernel.db.generator.plugin.server.methods.Utils;
import net.entframework.kernel.db.generator.utils.CommentHelper;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;

public class RepSelectByPrimaryKeyMethodGenerator
extends AbstractMethodGenerator {
    public RepSelectByPrimaryKeyMethodGenerator(AbstractMethodGenerator.BuildConfig builder) {
        super(builder);
    }

    @Override
    public MethodAndImports generateMethodAndImports() {
        if (!Utils.generateSelectByPrimaryKey(this.introspectedTable)) {
            return null;
        }
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        imports.add(this.recordType);
        Method getByPrimaryKey = new Method("get");
        getByPrimaryKey.setAbstract(this.isAbstract);
        getByPrimaryKey.setReturnType(this.recordType);
        IntrospectedColumn pk = GeneratorUtils.getPrimaryKey(this.introspectedTable);
        Parameter parameter = new Parameter(new FullyQualifiedJavaType("Serializable"), pk.getJavaProperty());
        imports.add(new FullyQualifiedJavaType("java.io.Serializable"));
        getByPrimaryKey.addParameter(parameter);
        if (this.isAbstract) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("RepositoryName", this.getRepositoryJavaType().getShortName());
            variables.put("EntityName", this.recordType.getShortName());
            variables.put("MapperName", this.getMapperJavaType().getShortName());
            variables.put("ParamType", pk.getFullyQualifiedJavaType().getFullyQualifiedName());
            GeneratorUtils.addComment((JavaElement)getByPrimaryKey, CommentHelper.INSTANCE.getComments("get", "Repository", variables));
        } else {
            GeneratorUtils.addComment((JavaElement)getByPrimaryKey, "{@inheritDoc}");
        }
        MethodAndImports.Builder builder = MethodAndImports.withMethod(getByPrimaryKey).withImports(imports);
        if (!this.isAbstract) {
            getByPrimaryKey.addAnnotation("@Override");
            getByPrimaryKey.setVisibility(JavaVisibility.PUBLIC);
            builder.withImport(new FullyQualifiedJavaType("java.util.Optional"));
            if (GeneratorUtils.hasRelation(this.context, this.introspectedTable)) {
                getByPrimaryKey.addBodyLine(String.format("%s %sQuery = new %s();", this.recordType.getShortName(), StringUtils.uncapitalize((String)this.recordType.getShortName()), this.recordType.getShortName()));
                getByPrimaryKey.addBodyLine(String.format("ReflectionKit.setFieldValue(%sQuery, \"%s\", %s);", StringUtils.uncapitalize((String)this.recordType.getShortName()), pk.getJavaProperty(), pk.getJavaProperty()));
                getByPrimaryKey.addBodyLine(String.format("Optional<%s> row = this.selectOne(%sQuery);", this.recordType.getShortName(), StringUtils.uncapitalize((String)this.recordType.getShortName())));
                builder.withImport("net.entframework.kernel.core.util.ReflectionKit");
                this.addLogicDeletedConvert(getByPrimaryKey, builder, pk);
            } else {
                getByPrimaryKey.addBodyLine(String.format("Optional<%s> row = baseMapper.selectByPrimaryKey(getEntityClass(), %s);", this.recordType.getShortName(), pk.getJavaProperty()));
                this.addLogicDeletedConvert(getByPrimaryKey, builder, pk);
            }
        }
        return builder.build();
    }

    public void addLogicDeletedConvert(Method getByPrimaryKey, MethodAndImports.Builder builder, IntrospectedColumn pk) {
        Optional<IntrospectedColumn> logicDelete = GeneratorUtils.getLogicDeleteColumn(this.introspectedTable);
        if (logicDelete.isPresent()) {
            IntrospectedColumn column = logicDelete.get();
            getByPrimaryKey.addBodyLine("if (row.isPresent()) {");
            getByPrimaryKey.addBodyLine(String.format("%s %s =  row.get();", this.recordType.getShortName(), StringUtils.uncapitalize((String)this.recordType.getShortName())));
            getByPrimaryKey.addBodyLine(String.format("if (%s.get%s() != YesOrNotEnum.N) {", StringUtils.uncapitalize((String)this.recordType.getShortName()), StringUtils.capitalize((String)column.getJavaProperty())));
            getByPrimaryKey.addBodyLine(String.format("throw new DaoException(DaoExceptionEnum.GET_RECORD_ERROR, %s);", pk.getJavaProperty()));
            getByPrimaryKey.addBodyLine("}");
            getByPrimaryKey.addBodyLine(String.format("return %s;", StringUtils.uncapitalize((String)this.recordType.getShortName())));
            getByPrimaryKey.addBodyLine("}");
            getByPrimaryKey.addBodyLine(String.format("throw new DaoException(DaoExceptionEnum.GET_RECORD_ERROR, %s);", pk.getJavaProperty()));
            builder.withImport(new FullyQualifiedJavaType("net.entframework.kernel.db.api.exception.DaoException"));
            builder.withImport(new FullyQualifiedJavaType("net.entframework.kernel.db.api.exception.enums.DaoExceptionEnum"));
            builder.withImport(new FullyQualifiedJavaType("net.entframework.kernel.core.enums.YesOrNotEnum"));
        } else {
            getByPrimaryKey.addBodyLine(String.format("return row.orElseThrow(() -> new DaoException(DaoExceptionEnum.GET_RECORD_ERROR, %s));", pk.getJavaProperty()));
        }
    }
}

