/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server.methods.repository;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import net.entframework.kernel.db.generator.plugin.server.methods.AbstractMethodGenerator;
import net.entframework.kernel.db.generator.plugin.server.methods.MethodAndImports;
import net.entframework.kernel.db.generator.plugin.server.methods.Utils;
import net.entframework.kernel.db.generator.utils.CommentHelper;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;

public class RepDeleteByPrimaryKeyMethodGenerator
extends AbstractMethodGenerator {
    public RepDeleteByPrimaryKeyMethodGenerator(AbstractMethodGenerator.BuildConfig builder) {
        super(builder);
    }

    @Override
    public MethodAndImports generateMethodAndImports() {
        if (!Utils.generateDeleteByPrimaryKey(this.introspectedTable)) {
            return null;
        }
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        Method method = new Method("delete");
        method.setAbstract(this.isAbstract);
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, this.introspectedTable, imports);
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.addParameter(new Parameter(this.recordType, "row"));
        if (this.isAbstract) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("RepositoryName", this.getRepositoryJavaType().getShortName());
            variables.put("EntityName", this.recordType.getShortName());
            GeneratorUtils.addComment((JavaElement)method, CommentHelper.INSTANCE.getComments("deleteById", "Repository", variables));
        } else {
            GeneratorUtils.addComment((JavaElement)method, "{@inheritDoc}");
        }
        MethodAndImports.Builder builder = MethodAndImports.withMethod(method).withImports(imports);
        if (!this.isAbstract) {
            method.addAnnotation("@Override");
            method.setVisibility(JavaVisibility.PUBLIC);
            FullyQualifiedJavaType mapperSupportJavaType = this.getMapperSupportJavaType();
            IntrospectedColumn pk = GeneratorUtils.getPrimaryKey(this.introspectedTable);
            Optional<IntrospectedColumn> logicDelete = GeneratorUtils.getLogicDeleteColumn(this.introspectedTable);
            method.addBodyLine(String.format("if (row == null || row.get%s() == null) {", StringUtils.capitalize((String)pk.getJavaProperty())));
            method.addBodyLine("throw new ServiceException(DefaultBusinessExceptionEnum.WRONG_ARGS_ERROR);");
            method.addBodyLine("}");
            builder.withImport(" net.entframework.kernel.core.exception.base.ServiceException");
            builder.withImport(" net.entframework.kernel.core.exception.enums.defaults.DefaultBusinessExceptionEnum");
            if (logicDelete.isPresent()) {
                IntrospectedColumn logicDeleteColumn = logicDelete.get();
                method.addBodyLine(String.format("row.set%s(YesOrNotEnum.Y);", StringUtils.capitalize((String)logicDeleteColumn.getJavaProperty())));
                method.addBodyLine("return baseMapper.updateByPrimaryKey(row, false);");
            } else {
                Optional<IntrospectedColumn> version = GeneratorUtils.getVersionColumn(this.introspectedTable);
                if (version.isPresent()) {
                    builder.withImport(mapperSupportJavaType);
                    builder.withImport("org.mybatis.dynamic.sql.delete.DeleteDSL");
                    builder.withImport("org.mybatis.dynamic.sql.delete.DeleteModel");
                    builder.withImport("java.util.Objects");
                    builder.withStaticImport("org.mybatis.dynamic.sql.SqlBuilder.isEqualTo");
                    method.addBodyLine(String.format("return baseMapper.delete(%s.class, c -> {", this.recordType.getShortName()));
                    method.addBodyLine("DeleteDSL<DeleteModel>.DeleteWhereBuilder deleteDSL = c.where();");
                    method.addBodyLine(String.format("deleteDSL.and(%s.%s, isEqualTo(row.get%s()).filter(Objects::nonNull));", mapperSupportJavaType.getShortName(), pk.getJavaProperty(), StringUtils.capitalize((String)pk.getJavaProperty())));
                    IntrospectedColumn versionColumn = version.get();
                    method.addBodyLine(String.format("deleteDSL.and(%s.%s, isEqualTo(row.get%s()).filter(Objects::nonNull));", mapperSupportJavaType.getShortName(), versionColumn.getJavaProperty(), StringUtils.capitalize((String)versionColumn.getJavaProperty())));
                    method.addBodyLine("return deleteDSL;");
                    method.addBodyLine("}");
                    method.addBodyLine(");");
                } else {
                    method.addBodyLine(String.format("return super.deleteByPrimaryKey(row.get%s());", StringUtils.capitalize((String)pk.getJavaProperty())));
                }
            }
        }
        return builder.build();
    }
}

