/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server.methods;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.config.JoinTarget;

public class Utils {
    public static boolean generateDeleteByPrimaryKey(IntrospectedTable introspectedTable) {
        return introspectedTable.hasPrimaryKeyColumns();
    }

    public static boolean generateMultipleRowInsert(IntrospectedTable introspectedTable) {
        return introspectedTable.getGeneratedKey().map(GeneratedKey::isJdbcStandard).orElse(true);
    }

    public static boolean canRetrieveMultiRowGeneratedKeys(IntrospectedTable introspectedTable) {
        return introspectedTable.getGeneratedKey().map(GeneratedKey::isJdbcStandard).orElse(false);
    }

    public static boolean generateSelectByPrimaryKey(IntrospectedTable introspectedTable) {
        return introspectedTable.hasPrimaryKeyColumns() && (introspectedTable.hasBaseColumns() || introspectedTable.hasBLOBColumns());
    }

    public static boolean generateUpdateByPrimaryKey(IntrospectedTable introspectedTable) {
        if (ListUtilities.removeGeneratedAlwaysColumns((List)introspectedTable.getNonPrimaryKeyColumns()).isEmpty()) {
            return false;
        }
        return introspectedTable.hasPrimaryKeyColumns() && (introspectedTable.hasBLOBColumns() || introspectedTable.hasBaseColumns());
    }

    public static Set<FullyQualifiedJavaType> getRelatedFieldType(IntrospectedTable introspectedTable) {
        List<Field> fields;
        HashSet<FullyQualifiedJavaType> relatedFieldType = new HashSet<FullyQualifiedJavaType>();
        TopLevelClass modelClass = (TopLevelClass)introspectedTable.getAttribute("INTROSPECTED_TABLE_MODEL_CLASS");
        if (GeneratorUtils.hasRelation(modelClass, JoinTarget.JoinType.MANY_TO_ONE) && (fields = GeneratorUtils.getRelatedFields(modelClass, JoinTarget.JoinType.MANY_TO_ONE)).size() > 0) {
            for (Field field : fields) {
                relatedFieldType.add(field.getType());
            }
        }
        if (GeneratorUtils.hasRelation(modelClass, JoinTarget.JoinType.ONE_TO_MANY) && (fields = GeneratorUtils.getRelatedFields(modelClass, JoinTarget.JoinType.ONE_TO_MANY)).size() > 0) {
            for (Field field : fields) {
                relatedFieldType.add((FullyQualifiedJavaType)field.getType().getTypeArguments().get(0));
            }
        }
        return relatedFieldType;
    }
}

