/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server.methods;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Method;

public class MethodAndImports {
    private final List<Method> methods;
    private final Set<FullyQualifiedJavaType> imports;
    private final Set<String> staticImports;

    private MethodAndImports(Builder builder) {
        this.methods = builder.methods;
        this.imports = builder.imports;
        this.staticImports = builder.staticImports;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public Set<FullyQualifiedJavaType> getImports() {
        return this.imports;
    }

    public Set<String> getStaticImports() {
        return this.staticImports;
    }

    public static Builder withMethod(Method method) {
        return new Builder().withMethod(method);
    }

    public static class Builder {
        private final List<Method> methods = new ArrayList<Method>();
        private final Set<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        private final Set<String> staticImports = new HashSet<String>();

        public Builder withMethod(Method method) {
            this.methods.add(method);
            return this;
        }

        public Builder withImport(FullyQualifiedJavaType importedType) {
            this.imports.add(importedType);
            return this;
        }

        public Builder withImport(String importedType) {
            this.imports.add(new FullyQualifiedJavaType(importedType));
            return this;
        }

        public Builder withImports(Set<FullyQualifiedJavaType> imports) {
            this.imports.addAll(imports);
            return this;
        }

        public Builder withStaticImport(String staticImport) {
            this.staticImports.add(staticImport);
            return this;
        }

        public Builder withStaticImports(Set<String> staticImports) {
            this.staticImports.addAll(staticImports);
            return this;
        }

        public MethodAndImports build() {
            return new MethodAndImports(this);
        }
    }
}

