/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server;

import java.util.List;
import net.entframework.kernel.db.generator.plugin.generator.FieldAndImports;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import net.entframework.kernel.db.generator.plugin.generator.VoFieldsGenerator;
import net.entframework.kernel.db.generator.plugin.server.AbstractServerPlugin;
import net.entframework.kernel.db.generator.plugin.server.LombokAnnotation;
import net.entframework.kernel.db.generator.utils.ClassInfo;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.WriteMode;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class VoPlugin
extends AbstractServerPlugin {
    @Override
    public boolean validate(List<String> warnings) {
        boolean validate = super.validate(warnings);
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.voTargetPackage, this.voSuffix, this.mapstructTargetPackage, this.mapstructSuffix})) {
            warnings.add("\u8bf7\u68c0\u67e5PojoPlugin\u914d\u7f6e");
            return false;
        }
        return validate;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        ClassInfo classInfo;
        TopLevelClass parentEntityClass;
        FullyQualifiedJavaType qualifiedJavaType = topLevelClass.getType();
        VoFieldsGenerator pojoFieldsGenerator = new VoFieldsGenerator(this.context, this.codingStyle, this.voTargetPackage, this.voSuffix, qualifiedJavaType);
        String rootClass = this.context.getJavaModelGeneratorConfiguration().getProperty("rootClass");
        if (StringUtils.isNotEmpty((CharSequence)rootClass) && (parentEntityClass = (classInfo = ClassInfo.getInstance(rootClass)).toTopLevelClass()) != null) {
            topLevelClass.setAttribute("PARENT_ENTITY_CLASS", (Object)parentEntityClass);
        }
        this.generatedJavaFiles.add(this.generateVO(topLevelClass, introspectedTable, pojoFieldsGenerator));
        return true;
    }

    private GeneratedJavaFile generateVO(TopLevelClass topLevelClass, IntrospectedTable introspectedTable, VoFieldsGenerator pojoFieldsGenerator) {
        IntrospectedTable parentTable;
        String modelObjectName = topLevelClass.getType().getShortNameWithoutTypeArguments();
        FullyQualifiedJavaType voJavaType = this.getVoJavaType(modelObjectName);
        TopLevelClass voClass = new TopLevelClass(voJavaType);
        voClass.setVisibility(JavaVisibility.PUBLIC);
        boolean voParentTableFound = false;
        if (StringUtils.isNotEmpty((CharSequence)introspectedTable.getTableConfiguration().getParentTable()) && (parentTable = this.findParentTable(this.context.getIntrospectedTables(), introspectedTable.getTableConfiguration().getParentTable())) != null) {
            voParentTableFound = true;
            FullyQualifiedJavaType parent = this.getVoJavaType(parentTable.getFullyQualifiedTable().getDomainObjectName());
            voClass.setSuperClass(parent);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.voRootClass)) {
            ClassInfo classInfo;
            TopLevelClass parentRequestClass;
            if (!voParentTableFound) {
                voClass.setSuperClass(this.voRootClass);
                voClass.addImportedType(this.voRootClass);
            }
            if ((parentRequestClass = (classInfo = ClassInfo.getInstance(this.voRootClass)).toTopLevelClass()) != null) {
                voClass.setAttribute("PARENT_REQUEST_CLASS", (Object)parentRequestClass);
            }
        }
        voClass.setWriteMode(this.writeMode == null ? WriteMode.OVER_WRITE : this.writeMode);
        GeneratorUtils.addComment((JavaElement)voClass, topLevelClass.getDescription() + " VO\u7c7b");
        this.addLombokAnnotation(voClass);
        FieldAndImports fieldAndImports = pojoFieldsGenerator.generateVo(topLevelClass, introspectedTable);
        fieldAndImports.getFields().forEach(arg_0 -> ((TopLevelClass)voClass).addField(arg_0));
        fieldAndImports.getImports().forEach(arg_0 -> ((TopLevelClass)voClass).addImportedType(arg_0));
        GeneratedJavaFile generatedJavaFile = new GeneratedJavaFile((CompilationUnit)voClass, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
        generatedJavaFile.setOutputDirectory(this.getOutputDirectory());
        return generatedJavaFile;
    }

    private void addLombokAnnotation(TopLevelClass topLevelClass) {
        topLevelClass.addImportedType(LombokAnnotation.DATA.getJavaType());
        topLevelClass.addAnnotation(LombokAnnotation.DATA.getName());
        topLevelClass.addImportedType(LombokAnnotation.EqualsAndHashCode.getJavaType());
        topLevelClass.addAnnotation(LombokAnnotation.EqualsAndHashCode.getName());
        topLevelClass.addImportedType(LombokAnnotation.ALL_ARGS_CONSTRUCTOR.getJavaType());
        topLevelClass.addAnnotation(LombokAnnotation.ALL_ARGS_CONSTRUCTOR.getName());
        topLevelClass.addImportedType(LombokAnnotation.NO_ARGS_CONSTRUCTOR.getJavaType());
        topLevelClass.addAnnotation(LombokAnnotation.NO_ARGS_CONSTRUCTOR.getName());
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles() {
        return this.generatedJavaFiles;
    }
}

