/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.entframework.kernel.db.generator.plugin.server.AbstractServerPlugin;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.GeneratedFile;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.GeneratedPlainFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.WriteMode;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class SpringAutoConfigurationPlugin
extends AbstractServerPlugin {
    private String springConfigJavaFile;

    @Override
    public boolean validate(List<String> warnings) {
        boolean validate = super.validate(warnings);
        this.springConfigJavaFile = this.properties.getProperty("springConfigJavaFile");
        if (StringUtils.isEmpty((CharSequence)this.springConfigJavaFile)) {
            warnings.add("\u8bf7\u68c0\u67e5SpringAutoConfigurationPlugin\u914d\u7f6e");
            return false;
        }
        return validate;
    }

    private GeneratedJavaFile generateServiceConfig() {
        TopLevelClass configBaseClass = new TopLevelClass(this.springConfigJavaFile);
        configBaseClass.setVisibility(JavaVisibility.PUBLIC);
        configBaseClass.setWriteMode(this.writeMode == null ? WriteMode.OVER_WRITE : this.writeMode);
        List tables = this.context.getIntrospectedTables();
        for (IntrospectedTable introspectedTable : tables) {
            String baseRecordType = introspectedTable.getBaseRecordType();
            FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(baseRecordType);
            FullyQualifiedJavaType baseRepositoryJavaType = this.getRepositoryJavaType(recordType.getShortName());
            FullyQualifiedJavaType baseRepositoryImplJavaType = this.getRepositoryImplJavaType(recordType.getShortName());
            Method repositoryMethod = new Method(StringUtils.uncapitalize((String)baseRepositoryJavaType.getShortName()));
            repositoryMethod.addAnnotation("@Bean");
            repositoryMethod.setVisibility(JavaVisibility.PUBLIC);
            repositoryMethod.setReturnType(baseRepositoryJavaType);
            FullyQualifiedJavaType parameterType = this.getMapperJavaType(recordType.getShortName());
            configBaseClass.addImportedType(parameterType);
            repositoryMethod.addParameter(new Parameter(parameterType, StringUtils.uncapitalize((String)parameterType.getShortName())));
            repositoryMethod.addAnnotation(String.format("@ConditionalOnMissingBean(%s.class)", baseRepositoryJavaType.getShortName()));
            repositoryMethod.addBodyLine(String.format("return new %s(%s);", baseRepositoryImplJavaType.getShortName(), repositoryMethod.getParameters().stream().map(Parameter::getName).collect(Collectors.joining(", "))));
            configBaseClass.addMethod(repositoryMethod);
            configBaseClass.addImportedType(baseRepositoryJavaType);
            configBaseClass.addImportedType(baseRepositoryImplJavaType);
            FullyQualifiedJavaType baseServiceJavaType = this.getServiceJavaType(recordType.getShortName());
            FullyQualifiedJavaType baseServiceImplJavaType = this.getServiceImplJavaType(recordType.getShortName());
            Method serviceMethod = new Method(StringUtils.uncapitalize((String)baseServiceJavaType.getShortName()));
            Parameter p1 = new Parameter(baseRepositoryJavaType, StringUtils.uncapitalize((String)baseRepositoryJavaType.getShortName()));
            serviceMethod.addParameter(p1);
            serviceMethod.addBodyLine(String.format("return new %s(%s);", baseServiceImplJavaType.getShortName(), StringUtils.uncapitalize((String)baseRepositoryJavaType.getShortName())));
            serviceMethod.addAnnotation("@Bean");
            serviceMethod.setVisibility(JavaVisibility.PUBLIC);
            serviceMethod.setReturnType(baseServiceJavaType);
            serviceMethod.addAnnotation(String.format("@ConditionalOnMissingBean(%s.class)", baseServiceJavaType.getShortName()));
            configBaseClass.addMethod(serviceMethod);
            configBaseClass.addImportedType(baseServiceJavaType);
            configBaseClass.addImportedType(baseServiceImplJavaType);
        }
        configBaseClass.addImportedType("org.springframework.context.annotation.Bean");
        configBaseClass.addImportedType("org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean");
        FullyQualifiedJavaType baseServiceType = new FullyQualifiedJavaType("org.springframework.context.annotation.Configuration");
        configBaseClass.addAnnotation("@Configuration");
        configBaseClass.addImportedType(baseServiceType);
        ArrayList<CallSite> scanPackages = new ArrayList<CallSite>();
        scanPackages.add((CallSite)((Object)("\"" + this.controllerTargetPackage + "\"")));
        scanPackages.add((CallSite)((Object)("\"" + this.mapstructTargetPackage + "\"")));
        scanPackages.add((CallSite)((Object)("\"" + this.serviceTargetPackage + "\"")));
        configBaseClass.addAnnotation(String.format("@ComponentScan(basePackages = {%s})", StringUtils.join(scanPackages, (String)", ")));
        configBaseClass.addAnnotation(String.format("@MapperScan(basePackages = \"%s\")", this.context.getJavaClientGeneratorConfiguration().getTargetPackage()));
        configBaseClass.addAnnotation(String.format("@EntityScan(\"%s\")", this.context.getJavaModelGeneratorConfiguration().getTargetPackage()));
        configBaseClass.addImportedType("org.springframework.boot.autoconfigure.domain.EntityScan");
        configBaseClass.addImportedType("org.springframework.context.annotation.ComponentScan");
        configBaseClass.addImportedType("org.mybatis.spring.annotation.MapperScan");
        GeneratedJavaFile gjf = new GeneratedJavaFile((CompilationUnit)configBaseClass, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
        gjf.setOutputDirectory(this.getOutputDirectory());
        return gjf;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles() {
        this.generatedJavaFiles.add(this.generateServiceConfig());
        return this.generatedJavaFiles;
    }

    public List<GeneratedFile> contextGenerateAdditionalFiles() {
        ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
        generatedFiles.add(this.generateFactoryFile());
        return generatedFiles;
    }

    private GeneratedFile generateFactoryFile() {
        GeneratedPlainFile factoryFile = new GeneratedPlainFile("src/main/resources", "org.springframework.boot.autoconfigure.AutoConfiguration.imports", "META-INF.spring");
        factoryFile.setOutputDirectory(this.getOutputDirectory());
        factoryFile.setMergeable(true);
        factoryFile.addBodyLine(this.springConfigJavaFile);
        return factoryFile;
    }
}

