/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server;

import java.util.List;
import java.util.stream.Collectors;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import net.entframework.kernel.db.generator.plugin.server.AbstractServerPlugin;
import net.entframework.kernel.db.generator.plugin.server.methods.AbstractMethodGenerator;
import net.entframework.kernel.db.generator.plugin.server.methods.MethodAndImports;
import net.entframework.kernel.db.generator.plugin.server.methods.repository.RepConstructorGenerator;
import net.entframework.kernel.db.generator.plugin.server.methods.repository.RepEnhancedCreateAndUpdateMethodGenerator;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.WriteMode;
import org.mybatis.generator.api.dom.java.AbstractJavaType;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class RepositoryPlugin
extends AbstractServerPlugin {
    @Override
    public boolean validate(List<String> warnings) {
        boolean validate = super.validate(warnings);
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.repositoryTargetPackage, this.repositorySuffix})) {
            warnings.add("\u8bf7\u68c0\u67e5RepositoryPlugin\u914d\u7f6e");
            return false;
        }
        return validate;
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        boolean hasGeneratedKeys = introspectedTable.getGeneratedKey().isPresent();
        this.generatedJavaFiles.add(this.generateRepositoryInterface(interfaze, introspectedTable, hasGeneratedKeys));
        this.generatedJavaFiles.add(this.generateRepositoryImpl(interfaze, introspectedTable, hasGeneratedKeys));
        return true;
    }

    private GeneratedJavaFile generateRepositoryInterface(Interface clientInterface, IntrospectedTable introspectedTable, boolean hasGeneratedKeys) {
        String baseRecordType = introspectedTable.getBaseRecordType();
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(baseRecordType);
        FullyQualifiedJavaType repositoryJavaType = this.getRepositoryJavaType(recordType.getShortName());
        Interface repositoryInterface = new Interface(repositoryJavaType);
        repositoryInterface.setVisibility(JavaVisibility.PUBLIC);
        repositoryInterface.setWriteMode(WriteMode.OVER_WRITE);
        IntrospectedColumn pkColumn = GeneratorUtils.getPrimaryKey(introspectedTable);
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("net.entframework.kernel.db.dao.repository.BaseRepository");
        fqjt.addTypeArgument(new FullyQualifiedJavaType(introspectedTable.getBaseRecordType()));
        fqjt.addTypeArgument(pkColumn.getFullyQualifiedJavaType());
        repositoryInterface.addSuperInterface(fqjt);
        repositoryInterface.addImportedType(fqjt);
        GeneratedJavaFile gjf = new GeneratedJavaFile((CompilationUnit)repositoryInterface, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
        gjf.setOutputDirectory(this.getOutputDirectory());
        return gjf;
    }

    private GeneratedJavaFile generateRepositoryImpl(Interface interfaze, IntrospectedTable introspectedTable, boolean hasGeneratedKeys) {
        String baseRecordType = introspectedTable.getBaseRecordType();
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(baseRecordType);
        FullyQualifiedJavaType repositoryImplJavaType = this.getRepositoryImplJavaType(recordType.getShortName());
        TopLevelClass repositoryInterfaceImplClass = new TopLevelClass(repositoryImplJavaType);
        repositoryInterfaceImplClass.setWriteMode(WriteMode.OVER_WRITE);
        repositoryInterfaceImplClass.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType interfaceType = this.getRepositoryJavaType(recordType.getShortName());
        repositoryInterfaceImplClass.addSuperInterface(interfaceType);
        repositoryInterfaceImplClass.addImportedType(interfaceType);
        IntrospectedColumn pkColumn = GeneratorUtils.getPrimaryKey(introspectedTable);
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("net.entframework.kernel.db.dao.repository.BaseRepositoryImpl");
        fqjt.addTypeArgument(new FullyQualifiedJavaType(introspectedTable.getBaseRecordType()));
        fqjt.addTypeArgument(pkColumn.getFullyQualifiedJavaType());
        repositoryInterfaceImplClass.setSuperClass(fqjt);
        repositoryInterfaceImplClass.addImportedType(fqjt);
        AbstractMethodGenerator.BuildConfig buildConfig = this.getConfig(interfaze, (AbstractJavaType)repositoryInterfaceImplClass, introspectedTable, recordType, false);
        this.generate((AbstractJavaType)repositoryInterfaceImplClass, new RepConstructorGenerator(buildConfig));
        this.generate((AbstractJavaType)repositoryInterfaceImplClass, new RepEnhancedCreateAndUpdateMethodGenerator(buildConfig));
        GeneratedJavaFile gjf = new GeneratedJavaFile((CompilationUnit)repositoryInterfaceImplClass, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
        gjf.setOutputDirectory(this.getOutputDirectory());
        return gjf;
    }

    private GeneratedJavaFile generateBaseRepository(Interface interfaze, IntrospectedTable introspectedTable, boolean hasGeneratedKeys) {
        String baseRecordType = introspectedTable.getBaseRecordType();
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(baseRecordType);
        FullyQualifiedJavaType repositoryImplJavaType = this.getRepositoryJavaType(recordType.getShortName());
        TopLevelClass repositoryInterfaceImplClass = new TopLevelClass(repositoryImplJavaType);
        repositoryInterfaceImplClass.setWriteMode(WriteMode.OVER_WRITE);
        repositoryInterfaceImplClass.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType interfaceType = this.getRepositoryJavaType(recordType.getShortName());
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("net.entframework.kernel.db.mds.repository.BaseRepositoryImpl");
        fqjt.addTypeArgument(new FullyQualifiedJavaType(introspectedTable.getBaseRecordType()));
        repositoryInterfaceImplClass.setSuperClass(fqjt);
        repositoryInterfaceImplClass.addImportedType(fqjt);
        repositoryInterfaceImplClass.addAnnotation("@Repository");
        repositoryInterfaceImplClass.addImportedType("org.springframework.stereotype.Repository");
        GeneratedJavaFile gjf = new GeneratedJavaFile((CompilationUnit)repositoryInterfaceImplClass, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
        gjf.setOutputDirectory(this.getOutputDirectory());
        return gjf;
    }

    private List<Method> removeStatementDefinedMethod(List<Method> methods) {
        return methods.stream().filter(method -> {
            Parameter parameter;
            String paramType;
            if (method.isStatic()) {
                return false;
            }
            return method.getParameters().size() <= 0 || !StringUtils.equals((CharSequence)(paramType = (parameter = (Parameter)method.getParameters().get(0)).getType().getFullyQualifiedNameWithoutTypeParameters()), (CharSequence)"org.mybatis.dynamic.sql.select.render.SelectStatementProvider") || !StringUtils.equalsAny((CharSequence)method.getName(), (CharSequence[])new CharSequence[]{"leftJoinSelectOne", "leftJoinSelectMany"});
        }).collect(Collectors.toList());
    }

    private AbstractMethodGenerator.BuildConfig getConfig(Interface clientInterface, AbstractJavaType interfaze, IntrospectedTable introspectedTable, FullyQualifiedJavaType recordType, boolean isAbstract) {
        return new AbstractMethodGenerator.BuildConfig().withContext(this.context).withIntrospectedTable(introspectedTable).withHostJavaClass(interfaze).withClientInterface(clientInterface).withTableFieldName("").withAbstract(isAbstract).withRecordType(recordType);
    }

    protected boolean generate(AbstractJavaType javaType, AbstractMethodGenerator generator) {
        MethodAndImports mi = generator.generateMethodAndImports();
        if (mi != null) {
            if (javaType instanceof Interface) {
                Interface interfaze = (Interface)javaType;
                mi.getMethods().forEach(arg_0 -> ((Interface)interfaze).addMethod(arg_0));
                interfaze.addImportedTypes(mi.getImports());
                interfaze.addStaticImports(mi.getStaticImports());
            }
            if (javaType instanceof TopLevelClass) {
                TopLevelClass topLevelClass = (TopLevelClass)javaType;
                mi.getMethods().forEach(arg_0 -> ((TopLevelClass)topLevelClass).addMethod(arg_0));
                topLevelClass.addImportedTypes(mi.getImports());
                topLevelClass.addStaticImports(mi.getStaticImports());
            }
            return true;
        }
        return false;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles() {
        return this.generatedJavaFiles;
    }
}

