/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server;

import java.util.List;
import net.entframework.kernel.db.generator.config.Relation;
import net.entframework.kernel.db.generator.plugin.AbstractDynamicSQLPlugin;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JoinEntry;
import org.mybatis.generator.config.JoinTable;
import org.mybatis.generator.config.JoinTarget;
import org.mybatis.generator.internal.util.JavaBeansUtil;

public class MyBatisExtPlugin
extends AbstractDynamicSQLPlugin {
    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        GeneratorUtils.addFieldComment(field, introspectedColumn);
        String fieldDescription = GeneratorUtils.getFieldDescription(introspectedColumn);
        field.setDescription(fieldDescription);
        if (GeneratorUtils.isPrimaryKey(introspectedTable, introspectedColumn)) {
            field.addAnnotation("@Id");
            topLevelClass.addImportedType("jakarta.persistence.Id");
        }
        introspectedTable.getGeneratedKey().ifPresent(generatedKey -> {
            if (generatedKey.getColumn().equals(introspectedColumn.getActualColumnName())) {
                field.addAnnotation("@GeneratedValue");
                topLevelClass.addImportedType("jakarta.persistence.GeneratedValue");
            }
        });
        if (!GeneratorUtils.isRelationField(field)) {
            StringBuilder columnSB = new StringBuilder(String.format("@Column(name = \"%s\"", introspectedColumn.getActualColumnName()));
            if (introspectedColumn.isStringColumn() && introspectedColumn.getLength() > 0 && introspectedColumn.getLength() != 255) {
                columnSB.append(", length=").append(introspectedColumn.getLength());
            }
            if (!introspectedColumn.isNullable()) {
                columnSB.append(", nullable=").append("false");
            }
            if (introspectedColumn.isNumberColumn() && introspectedColumn.getScale() > 0) {
                columnSB.append(", scale=").append(introspectedColumn.getScale());
            }
            columnSB.append(")");
            field.addAnnotation(columnSB.toString());
            topLevelClass.addImportedType("jakarta.persistence.Column");
            StringBuilder columnSql = new StringBuilder("@SqlColumn(");
            if (StringUtils.equals((CharSequence)"OTHER", (CharSequence)introspectedColumn.getJdbcTypeName())) {
                throw new RuntimeException("Can't determine jdbc type for column: " + introspectedColumn.getActualColumnName() + " in table :" + introspectedTable.getFullyQualifiedTableNameAtRuntime());
            }
            columnSql.append("jdbcType = JDBCType.").append(introspectedColumn.getJdbcTypeName());
            topLevelClass.addImportedType(new FullyQualifiedJavaType("java.sql.JDBCType"));
            if (StringUtils.isNotEmpty((CharSequence)introspectedColumn.getTypeHandler())) {
                FullyQualifiedJavaType typeHandler = new FullyQualifiedJavaType(introspectedColumn.getTypeHandler());
                topLevelClass.addImportedType(typeHandler);
                columnSql.append(", typeHandler = ").append(typeHandler.getShortName()).append(".class");
            }
            columnSql.append(")");
            field.addAnnotation(columnSql.toString());
            topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.SqlColumn");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)introspectedColumn.getActualColumnName(), (CharSequence)introspectedTable.getTableConfiguration().getLogicDeleteColumn())) {
            field.addAnnotation("@LogicDelete");
            topLevelClass.addImportedType("org.mybatis.dynamic.sql.annotation.LogicDelete");
            field.setAttribute("FIELD_LOGIC_DELETE_ATTR", (Object)true);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)introspectedColumn.getActualColumnName(), (CharSequence)introspectedTable.getTableConfiguration().getVersionColumn())) {
            field.addAnnotation("@Version");
            topLevelClass.addImportedType("jakarta.persistence.Version");
            field.setAttribute("FIELD_VERSION_ATTR", (Object)true);
        }
        introspectedColumn.getProperties().put("INTROSPECTED_COLUMN_FIELD_BINDING", field);
        if (!GeneratorUtils.isPrimaryKey(introspectedTable, introspectedColumn) && !GeneratorUtils.isRelationField(field)) {
            if (!introspectedColumn.isNullable()) {
                if (GeneratorUtils.isStringField(field)) {
                    field.addAnnotation(String.format("@NotBlank(message = \"%s\u4e0d\u80fd\u4e3a\u7a7a\")", fieldDescription));
                    topLevelClass.addImportedType("jakarta.validation.constraints.NotBlank");
                } else {
                    field.addAnnotation(String.format("@NotNull(message = \"%s\u4e0d\u80fd\u4e3a\u7a7a\")", fieldDescription));
                    topLevelClass.addImportedType("jakarta.validation.constraints.NotNull");
                }
            }
            if (GeneratorUtils.isStringField(field) && !introspectedColumn.isBLOBColumn()) {
                field.addAnnotation(String.format("@Size(max = %s, message = \"%s\u957f\u5ea6\u8d85\u51fa\")", introspectedColumn.getLength(), fieldDescription));
                topLevelClass.addImportedType("jakarta.validation.constraints.Size");
            }
        }
        if (introspectedColumn.isBlobColumn() || introspectedColumn.isClobColumn()) {
            field.addAnnotation("@Lob");
            topLevelClass.addImportedType("jakarta.persistence.Lob");
        }
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String tableName = introspectedTable.getFullyQualifiedTable().getIntrospectedTableName();
        JoinEntry joinEntry = this.context.getJoinConfig().getJoinEntry(tableName);
        if (joinEntry != null) {
            this.addJoinField(topLevelClass, joinEntry);
        }
        String fileDescription = GeneratorUtils.getFileDescription(introspectedTable);
        topLevelClass.setDescription(fileDescription);
        introspectedTable.setAttribute("INTROSPECTED_TABLE_MODEL_CLASS", (Object)topLevelClass);
        if (introspectedTable.isMappedSuperclass()) {
            topLevelClass.addAnnotation("@MappedSuperclass");
            topLevelClass.addImportedType("jakarta.persistence.MappedSuperclass");
        }
        topLevelClass.addAnnotation("@Entity");
        topLevelClass.addImportedType("jakarta.persistence.Entity");
        topLevelClass.addAnnotation(String.format("@Table(name = \"%s\")", introspectedTable.getFullyQualifiedTableNameAtRuntime()));
        topLevelClass.addImportedType("jakarta.persistence.Table");
        return true;
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        String tableName = introspectedTable.getFullyQualifiedTable().getIntrospectedTableName();
        JoinEntry joinEntry = this.context.getJoinConfig().getJoinEntry(tableName);
        if (joinEntry != null) {
            joinEntry.validate();
        }
        String fileDescription = GeneratorUtils.getFileDescription(introspectedTable);
        interfaze.setDescription(fileDescription);
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("net.entframework.kernel.db.mybatis.mapper.BaseMapper");
        fqjt.addTypeArgument(new FullyQualifiedJavaType(introspectedTable.getBaseRecordType()));
        interfaze.addSuperInterface(fqjt);
        interfaze.addImportedType(fqjt);
        return true;
    }

    private void addJoinField(TopLevelClass topLevelClass, JoinEntry joinEntry) {
        IntrospectedTable rightTable;
        for (Pair detail : joinEntry.getDetails()) {
            JoinTarget target = (JoinTarget)detail.getRight();
            rightTable = GeneratorUtils.getIntrospectedTable(this.context, target.getRightTable());
            IntrospectedTable leftTable = GeneratorUtils.getIntrospectedTable(this.context, joinEntry.getLeftTable());
            FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(rightTable.getBaseRecordType());
            FullyQualifiedJavaType listReturnType = FullyQualifiedJavaType.getNewListInstance();
            listReturnType.addTypeArgument(recordType);
            FullyQualifiedJavaType filedType = target.getType() == JoinTarget.JoinType.ONE_TO_MANY ? listReturnType : recordType;
            IntrospectedColumn introspectedColumn = new IntrospectedColumn();
            introspectedColumn.setJavaProperty(target.getFieldName());
            introspectedColumn.setContext(this.context);
            introspectedColumn.setIntrospectedTable(rightTable);
            introspectedColumn.setFullyQualifiedJavaType(filedType);
            introspectedColumn.setActualColumnName(target.getJoinColumn());
            IntrospectedColumn rightTableColumn = GeneratorUtils.getIntrospectedColumnByColumn(rightTable, target.getJoinColumn());
            Field field = JavaBeansUtil.getJavaBeansFieldWithGeneratedAnnotation((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)rightTable, (CompilationUnit)topLevelClass);
            field.setAttribute("FIELD_RELATION", (Object)true);
            if (this.context.getPlugins().modelFieldGenerated(field, topLevelClass, introspectedColumn, rightTable, Plugin.ModelClassType.BASE_RECORD)) {
                Relation.Builder builder = Relation.builder();
                topLevelClass.addImportedType(recordType);
                if (target.getType() == JoinTarget.JoinType.ONE_TO_MANY) {
                    topLevelClass.addImportedType(FullyQualifiedJavaType.getNewListInstance());
                    IntrospectedColumn leftTableColumn = GeneratorUtils.getIntrospectedColumnByColumn(leftTable, (String)detail.getLeft());
                    IntrospectedColumn leftKeyColumn = GeneratorUtils.getIntrospectedColumnByColumn(leftTable, (String)detail.getKey());
                    field.setDescription(GeneratorUtils.getFileDescription(rightTable));
                    builder.joinType(JoinTarget.JoinType.ONE_TO_MANY).bindField(field).sourceField(GeneratorUtils.getFieldByName(topLevelClass, leftKeyColumn.getJavaProperty())).targetTable(rightTable).targetColumn(rightTableColumn);
                    field.addAnnotation("@OneToMany");
                    field.addAnnotation(String.format("@JoinColumn(name = \"%s\", referencedColumnName = \"%s\")", leftTableColumn.getActualColumnName(), rightTableColumn.getActualColumnName()));
                    topLevelClass.addImportedType("jakarta.persistence.OneToMany");
                    topLevelClass.addImportedType("jakarta.persistence.JoinColumn");
                }
                if (target.getType() == JoinTarget.JoinType.MANY_TO_ONE) {
                    String columnName = (String)detail.getKey();
                    IntrospectedColumn leftColumn = GeneratorUtils.getIntrospectedColumnByColumn(leftTable, columnName);
                    Field relatedField = GeneratorUtils.getFieldByName(topLevelClass, leftColumn.getJavaProperty());
                    field.setDescription(relatedField.getDescription());
                    builder.sourceField(relatedField).joinType(JoinTarget.JoinType.MANY_TO_ONE).bindField(field).targetTable(rightTable).displayField(rightTable.getTableConfiguration().getDisplayField()).targetColumn(GeneratorUtils.getIntrospectedColumnByColumn(rightTable, target.getJoinColumn()));
                    field.addAnnotation("@ManyToOne");
                    field.addAnnotation(String.format("@JoinColumn(name = \"%s\", referencedColumnName = \"%s\")", leftColumn.getActualColumnName(), rightTableColumn.getActualColumnName()));
                    topLevelClass.addImportedType("jakarta.persistence.ManyToOne");
                    topLevelClass.addImportedType("jakarta.persistence.JoinColumn");
                }
                field.setAttribute("FIELD_RELATION", (Object)builder.build());
                field.getJavaDocLines().clear();
                GeneratorUtils.addComment((JavaElement)field, field.getDescription());
                topLevelClass.addField(field);
            }
            Method method = JavaBeansUtil.getJavaBeansGetterWithGeneratedAnnotation((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)rightTable, (CompilationUnit)topLevelClass);
            if (this.context.getPlugins().modelGetterMethodGenerated(method, topLevelClass, introspectedColumn, rightTable, Plugin.ModelClassType.BASE_RECORD)) {
                topLevelClass.addMethod(method);
            }
            if (rightTable.isImmutable()) continue;
            method = JavaBeansUtil.getJavaBeansSetterWithGeneratedAnnotation((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)rightTable, (CompilationUnit)topLevelClass);
            if (!this.context.getPlugins().modelSetterMethodGenerated(method, topLevelClass, introspectedColumn, rightTable, Plugin.ModelClassType.BASE_RECORD)) continue;
            topLevelClass.addMethod(method);
        }
        List joinTables = joinEntry.getJoinTables();
        for (JoinTable joinTable : joinTables) {
            rightTable = GeneratorUtils.getIntrospectedTable(this.context, joinTable.getRightTable());
            IntrospectedTable middleTable = GeneratorUtils.getIntrospectedTable(this.context, joinTable.getMiddleTable());
            FullyQualifiedJavaType targetBindType = new FullyQualifiedJavaType(rightTable.getBaseRecordType());
            IntrospectedColumn introspectedColumn = new IntrospectedColumn();
            introspectedColumn.setJavaProperty(joinTable.getProperty());
            introspectedColumn.setContext(this.context);
            introspectedColumn.setIntrospectedTable(rightTable);
            introspectedColumn.setFullyQualifiedJavaType(new FullyQualifiedJavaType(rightTable.getBaseRecordType()));
            introspectedColumn.setActualColumnName("");
            FullyQualifiedJavaType listJavaType = FullyQualifiedJavaType.getNewListInstance();
            listJavaType.addTypeArgument(targetBindType);
            topLevelClass.addImportedType(listJavaType);
            Field field = new Field(joinTable.getProperty(), listJavaType);
            field.setAttribute("FIELD_RELATION", (Object)true);
            if (!this.context.getPlugins().modelFieldGenerated(field, topLevelClass, introspectedColumn, rightTable, Plugin.ModelClassType.BASE_RECORD)) continue;
            Relation.Builder builder = Relation.builder();
            builder.joinType(JoinTarget.JoinType.MANY_TO_MANY);
            field.setVisibility(JavaVisibility.PRIVATE);
            field.setAttribute("FIELD_RELATION", (Object)builder.build());
            field.addAnnotation("@ManyToMany");
            field.addAnnotation(String.format("@JoinTable(name = \"%s\", joinColumns = @JoinColumn(name = \"%s\", referencedColumnName = \"%s\"), inverseJoinColumns = @JoinColumn(name = \"%s\", referencedColumnName = \"%s\"))", middleTable.getFullyQualifiedTableNameAtRuntime(), joinTable.getJoinColumn().getLeft(), joinTable.getJoinColumn().getRight(), joinTable.getInverseJoinColumn().getLeft(), joinTable.getInverseJoinColumn().getRight()));
            topLevelClass.addImportedType("jakarta.persistence.ManyToMany");
            topLevelClass.addImportedType("jakarta.persistence.JoinTable");
            topLevelClass.addImportedType("jakarta.persistence.JoinColumn");
            topLevelClass.addField(field);
        }
    }
}

