/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.entframework.kernel.db.generator.plugin.server.AbstractServerPlugin;
import net.entframework.kernel.db.generator.plugin.server.Utils;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerInterface;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class MapstructPlugin
extends AbstractServerPlugin {
    @Override
    public boolean validate(List<String> warnings) {
        boolean validate = super.validate(warnings);
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.mapstructTargetPackage, this.mapstructSuffix})) {
            warnings.add("\u8bf7\u68c0\u67e5MapstructPlugin\u914d\u7f6e");
            return false;
        }
        return validate;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generatedJavaFiles.add(this.generateMapstruct(topLevelClass, introspectedTable));
        return true;
    }

    private GeneratedJavaFile generateMapstruct(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String modelObjectName = topLevelClass.getType().getShortNameWithoutTypeArguments();
        FullyQualifiedJavaType mapstructJavaType = this.getMapstructJavaType(modelObjectName);
        Interface mapstructInterface = new Interface(mapstructJavaType);
        mapstructInterface.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType pojoRequestJavaType = this.getVoJavaType(modelObjectName);
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        mapstructInterface.addImportedType(pojoRequestJavaType);
        mapstructInterface.addImportedType(topLevelClass.getType());
        Set<FullyQualifiedJavaType> relations = Utils.getRelatedFieldType(introspectedTable);
        InnerInterface entityToVoConverter = this.createInnerMapper(mapstructInterface, "EntityToVoConverter", recordType, pojoRequestJavaType);
        mapstructInterface.addImportedTypes(this.addDefaultRelation(relations, recordType, entityToVoConverter, false));
        mapstructInterface.addInnerInterface(entityToVoConverter);
        InnerInterface voToEntityConverter = this.createInnerMapper(mapstructInterface, "VoToEntityConverter", pojoRequestJavaType, recordType);
        mapstructInterface.addImportedTypes(this.addDefaultRelation(relations, recordType, voToEntityConverter, true));
        mapstructInterface.addInnerInterface(voToEntityConverter);
        GeneratedJavaFile generatedJavaFile = new GeneratedJavaFile((CompilationUnit)mapstructInterface, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
        generatedJavaFile.setOutputDirectory(this.getOutputDirectory());
        return generatedJavaFile;
    }

    private Set<FullyQualifiedJavaType> addDefaultRelation(Set<FullyQualifiedJavaType> relations, FullyQualifiedJavaType recordType, InnerInterface innerInterface, boolean isRequest) {
        if (relations.isEmpty()) {
            return new HashSet<FullyQualifiedJavaType>();
        }
        HashSet<FullyQualifiedJavaType> importTypes = new HashSet<FullyQualifiedJavaType>();
        relations.forEach(relationType -> {
            FullyQualifiedJavaType voJavaType = this.getVoJavaType(relationType.getShortName());
            if (!relationType.equals((Object)recordType)) {
                if (isRequest) {
                    importTypes.addAll(this.createDefaultConverterMethod(innerInterface, voJavaType, (FullyQualifiedJavaType)relationType));
                } else {
                    importTypes.addAll(this.createDefaultConverterMethod(innerInterface, (FullyQualifiedJavaType)relationType, voJavaType));
                }
            }
        });
        return importTypes;
    }

    private Set<FullyQualifiedJavaType> createDefaultConverterMethod(InnerInterface innerInterface, FullyQualifiedJavaType sourceType, FullyQualifiedJavaType targetType) {
        HashSet<FullyQualifiedJavaType> importTypes = new HashSet<FullyQualifiedJavaType>();
        importTypes.add(sourceType);
        importTypes.add(targetType);
        Method method = new Method(String.format("map%sTo%s", sourceType.getShortName(), targetType.getShortName()));
        method.setDefault(true);
        method.setReturnType(targetType);
        method.addParameter(new Parameter(sourceType, StringUtils.uncapitalize((String)sourceType.getShortName())));
        method.addBodyLine("ObjectConversionService converterService = SpringUtil.getBean(ObjectConversionService.class);");
        method.addBodyLine(String.format("return converterService.convert(%s, %s.class);", StringUtils.uncapitalize((String)sourceType.getShortName()), targetType.getShortName()));
        importTypes.add(new FullyQualifiedJavaType("net.entframework.kernel.converter.support.ObjectConversionService"));
        importTypes.add(new FullyQualifiedJavaType("cn.hutool.extra.spring.SpringUtil"));
        innerInterface.addMethod(method);
        return importTypes;
    }

    private InnerInterface createInnerMapper(Interface mapstructInterface, String interfaceName, FullyQualifiedJavaType sourceType, FullyQualifiedJavaType targetType) {
        InnerInterface innerInterface = new InnerInterface(new FullyQualifiedJavaType(interfaceName));
        mapstructInterface.addImportedType(new FullyQualifiedJavaType("org.mapstruct.Mapper"));
        mapstructInterface.addImportedType(new FullyQualifiedJavaType("org.mapstruct.NullValueCheckStrategy"));
        mapstructInterface.addImportedType(new FullyQualifiedJavaType("org.mapstruct.NullValuePropertyMappingStrategy"));
        innerInterface.addAnnotation("@Mapper(componentModel = \"spring\", nullValueCheckStrategy = NullValueCheckStrategy.ALWAYS, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)");
        innerInterface.addSuperInterface(this.generatorConverter(mapstructInterface, sourceType, targetType));
        return innerInterface;
    }

    private FullyQualifiedJavaType generatorConverter(Interface mapstructInterface, FullyQualifiedJavaType sourceType, FullyQualifiedJavaType targetType) {
        FullyQualifiedJavaType converter = new FullyQualifiedJavaType("net.entframework.kernel.converter.support.ObjectConverter");
        mapstructInterface.addImportedType(converter);
        converter.addTypeArgument(sourceType);
        converter.addTypeArgument(targetType);
        return converter;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles() {
        return this.generatedJavaFiles;
    }
}

