/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server;

import java.util.List;
import net.entframework.kernel.db.generator.plugin.generator.GeneratorUtils;
import net.entframework.kernel.db.generator.plugin.generator.RestMethod;
import net.entframework.kernel.db.generator.plugin.generator.RestMethodAndImports;
import net.entframework.kernel.db.generator.plugin.generator.ServerRestMethodsGenerator;
import net.entframework.kernel.db.generator.plugin.server.AbstractServerPlugin;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.WriteMode;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class ControllerPlugin
extends AbstractServerPlugin {
    private String responseBodyWrapper = "net.entframework.kernel.core.vo.ResponseData";
    private String responseBodySuccessStaticMethod = "ok";
    private boolean enableControllerParentMode = false;

    @Override
    public boolean validate(List<String> warnings) {
        boolean validate = super.validate(warnings);
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.controllerTargetPackage})) {
            warnings.add("\u8bf7\u68c0\u67e5ControllerPlugin\u914d\u7f6e");
            return false;
        }
        String enableControllerParentMode = this.properties.getProperty("enableControllerParentMode");
        if (StringUtility.stringHasValue((String)enableControllerParentMode) && StringUtility.isTrue((String)enableControllerParentMode)) {
            this.enableControllerParentMode = true;
        }
        return validate;
    }

    public boolean clientGenerated(Interface interfaze, IntrospectedTable introspectedTable) {
        String relTable = introspectedTable.getTableConfiguration().getProperty(this.pluginName);
        if (relTable != null && relTable.equalsIgnoreCase("false")) {
            return true;
        }
        if (super.isManyToManyMiddleTable(introspectedTable)) {
            return true;
        }
        String baseRecordType = introspectedTable.getBaseRecordType();
        FullyQualifiedJavaType recordType = new FullyQualifiedJavaType(baseRecordType);
        FullyQualifiedJavaType baseControllerJavaType = this.getControllerJavaType(recordType.getShortName());
        if (this.enableControllerParentMode) {
            baseControllerJavaType = this.getBaseControllerJavaType(recordType.getShortName());
        }
        TopLevelClass baseControllerJavaClass = new TopLevelClass(baseControllerJavaType);
        baseControllerJavaClass.setVisibility(JavaVisibility.PUBLIC);
        baseControllerJavaClass.setAbstract(this.enableControllerParentMode);
        if (this.enableControllerParentMode) {
            baseControllerJavaClass.setWriteMode(WriteMode.OVER_WRITE);
        }
        FullyQualifiedJavaType converterServiceJavaType = new FullyQualifiedJavaType("net.entframework.kernel.converter.support.ConverterService");
        baseControllerJavaClass.addImportedType(converterServiceJavaType);
        String csFieldName = super.lowerCaseFirstChar(converterServiceJavaType.getShortName());
        Field csField = new Field(csFieldName, converterServiceJavaType);
        csField.setVisibility(JavaVisibility.PROTECTED);
        csField.addAnnotation("@Autowired");
        csField.addAnnotation("@Lazy");
        baseControllerJavaClass.addImportedType("org.springframework.beans.factory.annotation.Autowired");
        baseControllerJavaClass.addImportedType("org.springframework.context.annotation.Lazy");
        baseControllerJavaClass.addField(csField);
        FullyQualifiedJavaType serviceJavaType = this.getServiceJavaType(recordType.getShortName());
        baseControllerJavaClass.addImportedType(serviceJavaType);
        String serviceFieldName = super.lowerCaseFirstChar(serviceJavaType.getShortName());
        Field serviceField = new Field(serviceFieldName, serviceJavaType);
        serviceField.setVisibility(JavaVisibility.PROTECTED);
        serviceField.addAnnotation("@Resource");
        baseControllerJavaClass.addImportedType("jakarta.annotation.Resource");
        baseControllerJavaClass.addField(serviceField);
        String modelDescription = interfaze.getDescription();
        TopLevelClass modelClass = (TopLevelClass)introspectedTable.getAttribute("INTROSPECTED_TABLE_MODEL_CLASS");
        FullyQualifiedJavaType voJavaType = this.getVoJavaType(recordType.getShortName());
        IntrospectedColumn pkColumn = GeneratorUtils.getPrimaryKey(introspectedTable);
        ServerRestMethodsGenerator restMethodsGenerator = new ServerRestMethodsGenerator(recordType, voJavaType, serviceFieldName, pkColumn, true);
        if (StringUtils.isNotEmpty((CharSequence)this.voRootClass)) {
            restMethodsGenerator.setBaseVoType(new FullyQualifiedJavaType(this.voRootClass));
        }
        restMethodsGenerator.generate();
        RestMethodAndImports methodAndImports = restMethodsGenerator.build();
        methodAndImports.getMethods().forEach(method -> {
            if (StringUtils.equals((CharSequence)"POST", (CharSequence)method.getHttpMethod())) {
                this.addPostMapping(baseControllerJavaClass, (RestMethod)((Object)method), modelDescription);
            }
            if (StringUtils.equals((CharSequence)"GET", (CharSequence)method.getHttpMethod())) {
                this.addGetMapping(baseControllerJavaClass, (RestMethod)((Object)method), modelDescription);
            }
            if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.responseBodyWrapper, this.responseBodySuccessStaticMethod})) {
                method.addBodyLine("return result;");
            } else {
                FullyQualifiedJavaType responseWrapJavaType = new FullyQualifiedJavaType(this.responseBodyWrapper);
                FullyQualifiedJavaType responseBodyWrapperType = new FullyQualifiedJavaType(this.responseBodyWrapper);
                baseControllerJavaClass.addImportedType(responseWrapJavaType);
                if (method.getReturnType().isPresent()) {
                    responseBodyWrapperType.addTypeArgument((FullyQualifiedJavaType)method.getReturnType().get());
                    method.setReturnType(responseBodyWrapperType);
                }
                method.addBodyLine(String.format("return %s.%s(result);", responseWrapJavaType.getShortName(), this.responseBodySuccessStaticMethod));
            }
        });
        methodAndImports.getMethods().forEach(arg_0 -> ((TopLevelClass)baseControllerJavaClass).addMethod(arg_0));
        baseControllerJavaClass.addImportedTypes(methodAndImports.getImports());
        GeneratedJavaFile baseControllerJavaFile = new GeneratedJavaFile((CompilationUnit)baseControllerJavaClass, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
        baseControllerJavaFile.setOutputDirectory(this.getOutputDirectory());
        if (this.enableControllerParentMode) {
            FullyQualifiedJavaType controllerJavaType = this.getControllerJavaType(recordType.getShortName());
            TopLevelClass controllerJavaClass = new TopLevelClass(controllerJavaType);
            controllerJavaClass.setVisibility(JavaVisibility.PUBLIC);
            controllerJavaClass.addAnnotation("@RestController");
            controllerJavaClass.addImportedType(new FullyQualifiedJavaType("org.springframework.web.bind.annotation.RestController"));
            controllerJavaClass.setSuperClass(baseControllerJavaType);
            controllerJavaClass.addImportedType(baseControllerJavaType);
            if (this.codingStyle.equals("ENT")) {
                controllerJavaClass.addAnnotation(String.format("@ApiResource(displayName = \"%s\")", modelClass.getDescription()));
                controllerJavaClass.addImportedType("net.entframework.kernel.scanner.api.annotation.ApiResource");
            }
            controllerJavaClass.setWriteMode(this.writeMode == null ? WriteMode.SKIP_ON_EXIST : this.writeMode);
            GeneratedJavaFile controllerJavaFile = new GeneratedJavaFile((CompilationUnit)controllerJavaClass, this.context.getJavaModelGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
            controllerJavaFile.setOutputDirectory(this.getOutputDirectory());
            this.generatedJavaFiles.add(controllerJavaFile);
        } else if (this.codingStyle.equals("ENT")) {
            baseControllerJavaClass.addAnnotation(String.format("@ApiResource(displayName = \"%s\")", modelClass.getDescription()));
            baseControllerJavaClass.addImportedType("net.entframework.kernel.scanner.api.annotation.ApiResource");
        }
        this.generatedJavaFiles.add(baseControllerJavaFile);
        return true;
    }

    private void addPostMapping(TopLevelClass controllerJavaClass, RestMethod method, String modelDescription) {
        if (this.codingStyle.equals("ENT")) {
            method.addAnnotation(String.format("@PostResource(displayName = \"%s-%s\", path = \"%s\")", modelDescription, method.getOperation(), method.getRestPath()));
            controllerJavaClass.addImportedType("net.entframework.kernel.scanner.api.annotation.PostResource");
        } else {
            method.addAnnotation(String.format("@PostMapping(\"%s\")", method.getRestPath()));
            controllerJavaClass.addImportedType("org.springframework.web.bind.annotation.PostMapping");
        }
    }

    private void addGetMapping(TopLevelClass controllerJavaClass, RestMethod method, String modelDescription) {
        if (this.codingStyle.equals("ENT")) {
            method.addAnnotation(String.format("@GetResource(displayName = \"%s-%s\", path = \"%s\")", modelDescription, method.getOperation(), method.getRestPath()));
            controllerJavaClass.addImportedType("net.entframework.kernel.scanner.api.annotation.GetResource");
        } else {
            method.addAnnotation(String.format("@GetMapping(\"/%s\")", method.getRestPath()));
            controllerJavaClass.addImportedType("org.springframework.web.bind.annotation.GetMapping");
        }
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles() {
        return this.generatedJavaFiles;
    }
}

