/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.server;

import java.util.ArrayList;
import java.util.List;
import net.entframework.kernel.db.generator.plugin.AbstractDynamicSQLPlugin;
import net.entframework.kernel.db.generator.utils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.WriteMode;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.config.JoinEntry;

public abstract class AbstractServerPlugin
extends AbstractDynamicSQLPlugin {
    protected String pluginName = ((Object)((Object)this)).getClass().getName();
    protected List<GeneratedJavaFile> generatedJavaFiles = new ArrayList<GeneratedJavaFile>();
    protected String voTargetPackage;
    protected String voSuffix = "";
    protected String voRootClass = "";
    protected String mapstructTargetPackage;
    protected String mapstructSuffix = "";
    protected String serviceTargetPackage;
    protected String serviceSuffix = "";
    protected String baseServicePrefix = "";
    protected String servicePrefix = "";
    protected String repositoryTargetPackage;
    protected String repositorySuffix = "";
    protected String controllerTargetPackage;
    protected String controllerSuffix = "Controller";
    protected String controllerPrefix = "";
    protected String codingStyle;

    protected IntrospectedTable findParentTable(List<IntrospectedTable> tables, String parentTable) {
        return tables.stream().filter(introspectedTable1 -> introspectedTable1.getFullyQualifiedTable().getIntrospectedTableName().equals(parentTable)).findFirst().orElse(null);
    }

    public boolean validate(List<String> warnings) {
        if (!"MyBatis3DynamicSql".equalsIgnoreCase(this.context.getTargetRuntime())) {
            warnings.add("EntCrudPlugin \u76ee\u524d\u652f\u6301 runtime=MyBatis3DynamicSql");
            return false;
        }
        this.codingStyle = this.context.getProperty("generatedCodeStyle");
        if (StringUtils.isEmpty((CharSequence)this.codingStyle)) {
            this.codingStyle = "ENT";
        }
        this.voTargetPackage = this.context.getProperty("voTargetPackage");
        this.voSuffix = PropertyUtils.getProperty(this.context, "voSuffix", "Vo");
        this.voRootClass = this.context.getProperty("voRootClass");
        this.mapstructTargetPackage = this.context.getProperty("mapstructTargetPackage");
        this.mapstructSuffix = PropertyUtils.getProperty(this.context, "mapstructSuffix", "Converter");
        this.serviceTargetPackage = this.context.getProperty("serviceTargetPackage");
        this.serviceSuffix = PropertyUtils.getProperty(this.context, "serviceSuffix", "Service");
        this.baseServicePrefix = PropertyUtils.getProperty(this.context, "baseServicePrefix", "Base");
        this.servicePrefix = PropertyUtils.getProperty(this.context, "servicePrefix", "");
        this.repositoryTargetPackage = this.context.getProperty("repositoryTargetPackage");
        this.repositorySuffix = PropertyUtils.getProperty(this.context, "repositorySuffix", "Repository");
        this.controllerTargetPackage = this.context.getProperty("controllerTargetPackage");
        this.controllerPrefix = PropertyUtils.getProperty(this.context, "controllerPrefix", "Base");
        String mode = this.properties.getProperty("writeMode");
        if (StringUtils.isNotEmpty((CharSequence)mode)) {
            WriteMode writeMode = this.convert(mode);
            if (writeMode != null) {
                this.writeMode = writeMode;
            } else {
                warnings.add(((Object)((Object)this)).getClass().getName() + "\u914d\u7f6e\u4e86\u9519\u8bef\u7684WriteMode, \u53ef\u7528\u503c: NEVER,OVER_WRITE,SKIP_ON_EXIST");
            }
        }
        return true;
    }

    public FullyQualifiedJavaType getMapperJavaType(String modelObjectName) {
        return new FullyQualifiedJavaType(this.context.getJavaClientGeneratorConfiguration().getTargetPackage() + "." + modelObjectName + "Mapper");
    }

    public FullyQualifiedJavaType getVoJavaType(String modelObjectName) {
        return new FullyQualifiedJavaType(this.voTargetPackage + "." + modelObjectName + this.voSuffix);
    }

    public FullyQualifiedJavaType getMapstructJavaType(String modelObjectName) {
        return new FullyQualifiedJavaType(this.mapstructTargetPackage + "." + modelObjectName + this.mapstructSuffix);
    }

    public FullyQualifiedJavaType getBaseServiceJavaType(String modelObjectName) {
        return new FullyQualifiedJavaType(this.serviceTargetPackage + ".base." + this.baseServicePrefix + modelObjectName + this.serviceSuffix);
    }

    public FullyQualifiedJavaType getBaseServiceImplJavaType(String modelObjectName) {
        return new FullyQualifiedJavaType(this.serviceTargetPackage + ".base.impl." + this.baseServicePrefix + modelObjectName + this.serviceSuffix + "Impl");
    }

    public FullyQualifiedJavaType getServiceJavaType(String modelObjectName) {
        return new FullyQualifiedJavaType(this.serviceTargetPackage + "." + this.servicePrefix + modelObjectName + this.serviceSuffix);
    }

    public FullyQualifiedJavaType getServiceImplJavaType(String modelObjectName) {
        return new FullyQualifiedJavaType(this.serviceTargetPackage + ".impl." + this.servicePrefix + modelObjectName + this.serviceSuffix + "Impl");
    }

    public FullyQualifiedJavaType getRepositoryJavaType(String modelObjectName) {
        return new FullyQualifiedJavaType(this.repositoryTargetPackage + "." + modelObjectName + this.repositorySuffix);
    }

    public FullyQualifiedJavaType getRepositoryImplJavaType(String modelObjectName) {
        return new FullyQualifiedJavaType(this.repositoryTargetPackage + ".impl." + modelObjectName + this.repositorySuffix + "Impl");
    }

    public FullyQualifiedJavaType getBaseControllerJavaType(String modelObjectName) {
        return new FullyQualifiedJavaType(this.controllerTargetPackage + ".base." + this.controllerPrefix + modelObjectName + this.controllerSuffix);
    }

    public FullyQualifiedJavaType getControllerJavaType(String modelObjectName) {
        return new FullyQualifiedJavaType(this.controllerTargetPackage + "." + modelObjectName + this.controllerSuffix);
    }

    public boolean isManyToManyMiddleTable(IntrospectedTable table) {
        String tableName = table.getFullyQualifiedTableNameAtRuntime();
        for (JoinEntry joinEntry : this.context.getJoinConfig().getJoinDetailMap().values()) {
            if (!joinEntry.getJoinTables().stream().anyMatch(joinTable -> StringUtils.equals((CharSequence)joinTable.getMiddleTable(), (CharSequence)tableName))) continue;
            return true;
        }
        return false;
    }
}

