/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.plugin.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.entframework.kernel.db.generator.plugin.generator.RestMethod;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;

public class RestMethodAndImports {
    private final List<RestMethod> methods;
    private final Set<FullyQualifiedJavaType> imports;
    private final Set<String> staticImports;

    private RestMethodAndImports(Builder builder) {
        this.methods = builder.methods;
        this.imports = builder.imports;
        this.staticImports = builder.staticImports;
    }

    public List<RestMethod> getMethods() {
        return this.methods;
    }

    public Set<FullyQualifiedJavaType> getImports() {
        return this.imports;
    }

    public Set<String> getStaticImports() {
        return this.staticImports;
    }

    public static Builder withMethod(RestMethod method) {
        return new Builder().withMethod(method);
    }

    public static class Builder {
        private final List<RestMethod> methods = new ArrayList<RestMethod>();
        private final Set<FullyQualifiedJavaType> imports = new TreeSet<FullyQualifiedJavaType>();
        private final Set<String> staticImports = new TreeSet<String>();

        public Builder withMethod(RestMethod method) {
            this.methods.add(method);
            return this;
        }

        public Builder withImport(FullyQualifiedJavaType importedType) {
            this.imports.add(importedType);
            return this;
        }

        public Builder withImport(String importedType) {
            this.imports.add(new FullyQualifiedJavaType(importedType));
            return this;
        }

        public Builder withImports(Set<FullyQualifiedJavaType> imports) {
            this.imports.addAll(imports);
            return this;
        }

        public Builder withStaticImport(String staticImport) {
            this.staticImports.add(staticImport);
            return this;
        }

        public Builder withStaticImports(Set<String> staticImports) {
            this.staticImports.addAll(staticImports);
            return this;
        }

        public RestMethodAndImports build() {
            return new RestMethodAndImports(this);
        }
    }
}

