/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.comment;

import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.DefaultCommentGenerator;
import org.mybatis.generator.internal.util.StringUtility;

public class SimpleCommentGenerator
extends DefaultCommentGenerator {
    private final Properties properties = new Properties();
    private boolean suppressDate = false;
    private boolean suppressAllComments = false;
    private boolean addRemarkComments = true;
    private SimpleDateFormat dateFormat;

    public void addConfigurationProperties(Properties props) {
        String dateFormatString;
        this.properties.putAll((Map<?, ?>)props);
        if (StringUtility.stringHasValue((String)this.properties.getProperty("suppressDate"))) {
            this.suppressDate = StringUtility.isTrue((String)this.properties.getProperty("suppressDate"));
        }
        if (StringUtility.stringHasValue((String)this.properties.getProperty("suppressAllComments"))) {
            this.suppressAllComments = StringUtility.isTrue((String)this.properties.getProperty("suppressAllComments"));
        }
        if (StringUtility.stringHasValue((String)this.properties.getProperty("addRemarkComments"))) {
            this.addRemarkComments = StringUtility.isTrue((String)this.properties.getProperty("addRemarkComments"));
        }
        if (StringUtility.stringHasValue((String)(dateFormatString = this.properties.getProperty("dateFormat")))) {
            this.dateFormat = new SimpleDateFormat(dateFormatString);
        }
    }

    public void addGeneralMethodAnnotation(Method method, IntrospectedTable introspectedTable, Set<FullyQualifiedJavaType> imports) {
    }

    public void addGeneralMethodAnnotation(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn, Set<FullyQualifiedJavaType> imports) {
    }

    public void addFieldAnnotation(Field field, IntrospectedTable introspectedTable, Set<FullyQualifiedJavaType> imports) {
    }

    public void addFieldAnnotation(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn, Set<FullyQualifiedJavaType> imports) {
    }

    public void addClassAnnotation(InnerClass innerClass, IntrospectedTable introspectedTable, Set<FullyQualifiedJavaType> imports) {
    }

    public void addGetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
    }

    public void addSetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
    }

    public void addEnumComment(InnerEnum innerEnum, IntrospectedTable introspectedTable) {
    }

    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (this.suppressAllComments || !this.addRemarkComments) {
            return;
        }
        topLevelClass.addJavaDocLine("/**");
        String remarks = introspectedTable.getRemarks();
        if (this.addRemarkComments && StringUtility.stringHasValue((String)remarks)) {
            String[] remarkLines;
            for (String remarkLine : remarkLines = remarks.split(System.getProperty("line.separator"))) {
                topLevelClass.addJavaDocLine(" * " + remarkLine);
            }
        }
        topLevelClass.addJavaDocLine(" */");
    }
}

