/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.entframework.kernel.db.generator.utils.FormatTools;
import net.entframework.kernel.db.generator.utils.JavaElementGeneratorTools;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.java.TopLevelEnumeration;
import org.mybatis.generator.internal.util.StringUtility;

public class EnumInfo {
    private static final String ENUM_HANDLER = "net.entframework.kernel.core.annotation.EnumHandler";
    private static final String ENUM_VALUE = "net.entframework.kernel.core.annotation.EnumValue";
    private static final String REMARKS_REGEX = "([\\u4e00-\\u9fa5a-zA-Z0-9]+)\\[([a-zA-Z0-9]+\\(\\S*\\):\\S*\\,?\\s*)*\\]";
    private static final String ITEM_REGEX = "(\\w+)\\s*\\(\\s*([\\u4e00-\\u9fa5_\\-a-zA-Z0-9]+)\\s*\\)\\s*:\\s*([\\u4e00-\\u9fa5_\\-a-zA-Z0-9]+)";
    private static final Pattern REMARKS_PATTERN = Pattern.compile("([\\u4e00-\\u9fa5a-zA-Z0-9]+)\\[([a-zA-Z0-9]+\\(\\S*\\):\\S*\\,?\\s*)*\\]");
    private final List<EnumItemInfo> items = new ArrayList<EnumItemInfo>();
    private final IntrospectedColumn column;
    private String description = "";

    public EnumInfo() {
        this.column = null;
    }

    public EnumInfo(IntrospectedColumn column) throws NotSupportTypeException, CannotParseException {
        String javaType = column.getFullyQualifiedJavaType().getFullyQualifiedName();
        if (!(Short.class.getTypeName().equals(javaType) || Integer.class.getTypeName().equals(javaType) || Long.class.getTypeName().equals(javaType) || Boolean.class.getTypeName().equals(javaType) || Double.class.getTypeName().equals(javaType) || Float.class.getTypeName().equals(javaType) || BigDecimal.class.getTypeName().equals(javaType) || Byte.class.getTypeName().equals(javaType) || String.class.getTypeName().equals(javaType))) {
            throw new NotSupportTypeException();
        }
        this.column = column;
    }

    public void addItem(String name, String comment, Object value) {
        this.items.add(new EnumItemInfo(this.column, name, comment, value));
    }

    public boolean hasItems() {
        return this.items.size() > 0;
    }

    public void parseRemarks() throws CannotParseException {
        Matcher matcher;
        String remarks = this.column.getRemarks();
        if (StringUtility.stringHasValue((String)remarks) && remarks.matches(REMARKS_REGEX) && (matcher = REMARKS_PATTERN.matcher(remarks)).find() && matcher.groupCount() == 2) {
            String[] enumInfoStrs;
            this.description = matcher.group(1);
            String enumInfoStr = matcher.group(2);
            for (String enumInfoItemStr : enumInfoStrs = enumInfoStr.split(",")) {
                Pattern pattern = Pattern.compile(ITEM_REGEX);
                matcher = pattern.matcher(enumInfoItemStr.trim());
                if (!matcher.find() || matcher.groupCount() != 3) continue;
                this.addItem(matcher.group(1), matcher.group(3), matcher.group(2));
            }
        }
    }

    public List<EnumItemInfo> getItems() {
        return this.items;
    }

    public String getDescription() {
        return this.description;
    }

    public TopLevelEnumeration generateEnum(TopLevelClass topLevelClass) {
        String enumName = StringUtils.capitalize((String)this.column.getJavaProperty());
        TopLevelEnumeration innerEnum = new TopLevelEnumeration(new FullyQualifiedJavaType(enumName));
        innerEnum.setVisibility(JavaVisibility.PUBLIC);
        for (EnumItemInfo item : this.items) {
            innerEnum.addEnumConstant(item.getConstant() + "(" + item.getValue() + ", \"" + item.getLabel() + "\")");
        }
        innerEnum.addAnnotation("@EnumHandler");
        topLevelClass.addImportedType(ENUM_HANDLER);
        Field fValue = new Field("value", this.column.getFullyQualifiedJavaType());
        fValue.setVisibility(JavaVisibility.PRIVATE);
        fValue.setFinal(true);
        fValue.addAnnotation("@JsonValue");
        fValue.addAnnotation("@EnumValue");
        topLevelClass.addImportedType("com.fasterxml.jackson.annotation.JsonValue");
        topLevelClass.addImportedType(ENUM_VALUE);
        innerEnum.addField(fValue);
        Field fName = new Field("label", FullyQualifiedJavaType.getStringInstance());
        fName.setVisibility(JavaVisibility.PRIVATE);
        fName.setFinal(true);
        innerEnum.addField(fName);
        Method mInc = new Method(enumName);
        mInc.setConstructor(true);
        mInc.addBodyLine("this.value = value;");
        mInc.addBodyLine("this.label = label;");
        mInc.addParameter(new Parameter(fValue.getType(), "value"));
        mInc.addParameter(new Parameter(fName.getType(), "label"));
        FormatTools.addMethodWithBestPosition((InnerEnum)innerEnum, mInc);
        Method mValue = JavaElementGeneratorTools.generateGetterMethod(fValue);
        FormatTools.addMethodWithBestPosition((InnerEnum)innerEnum, mValue);
        Method mValue1 = JavaElementGeneratorTools.generateGetterMethod(fValue);
        mValue1.setName("value");
        FormatTools.addMethodWithBestPosition((InnerEnum)innerEnum, mValue1);
        Method mName = JavaElementGeneratorTools.generateGetterMethod(fName);
        FormatTools.addMethodWithBestPosition((InnerEnum)innerEnum, mName);
        Method mParseValue = JavaElementGeneratorTools.generateMethod("parseValue", JavaVisibility.PUBLIC, innerEnum.getType(), new Parameter(fValue.getType(), "value"));
        mParseValue.addAnnotation("@JsonCreator");
        topLevelClass.addImportedType(new FullyQualifiedJavaType("com.fasterxml.jackson.annotation.JsonCreator"));
        mParseValue.setStatic(true);
        mParseValue.addBodyLine("if (value != null) {");
        mParseValue.addBodyLine("for (" + innerEnum.getType().getShortName() + " item : values()) {");
        mParseValue.addBodyLine("if (item.value.equals(value)) {");
        mParseValue.addBodyLine("return item;");
        mParseValue.addBodyLine("}");
        mParseValue.addBodyLine("}");
        mParseValue.addBodyLine("}");
        mParseValue.addBodyLine("return null;");
        FormatTools.addMethodWithBestPosition((InnerEnum)innerEnum, mParseValue);
        return innerEnum;
    }

    public static void main(String[] args) {
        String remarks = "\u6ce8\u91ca[success(0):\u6210\u529f,,fail(1):\u5931\u8d25,,,fdd(3):\u5931\u8d25]";
        Matcher matcher = REMARKS_PATTERN.matcher(remarks);
        System.out.println(matcher.groupCount());
    }

    public static class NotSupportTypeException
    extends Exception {
    }

    public static class EnumItemInfo {
        private final IntrospectedColumn column;
        private final String constant;
        private final String label;
        private final Object value;

        public EnumItemInfo(IntrospectedColumn column, String name, String label, Object value) {
            this.column = column;
            this.constant = name.trim();
            this.label = label.trim();
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public String getConstant() {
            return this.constant.toUpperCase();
        }

        public String getValue() {
            String javaType = this.column.getFullyQualifiedJavaType().getShortName();
            if (Objects.isNull(this.value) || "NULL".equalsIgnoreCase(String.valueOf(this.value))) {
                return "null";
            }
            if ("String".equals(javaType)) {
                return "\"" + this.value + "\"";
            }
            return "new " + javaType + "(\"" + this.value + "\")";
        }

        public Object getOriginalValue() {
            return this.value;
        }
    }

    public static class CannotParseException
    extends Exception {
    }
}

