/*
 * Decompiled with CFR 0.152.
 */
package net.entframework.kernel.db.generator.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.entframework.kernel.db.generator.typescript.runtime.FullyQualifiedTypescriptType;
import net.entframework.kernel.db.generator.utils.EnumInfo;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.java.TopLevelEnumeration;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.JavaBeansUtil;

public class ClassInfo {
    private static final Map<String, ClassInfo> ROOT_CLASS_INFO_MAP;
    private static Class<?> supperEnum;
    private FullyQualifiedJavaType javaType;
    private boolean genericMode = false;
    private boolean isEnum = false;
    private List<Field> enuConstants = new ArrayList<Field>();
    private List<Field> memberFields = new ArrayList<Field>();

    public static ClassInfo getInstance(String className) {
        return ROOT_CLASS_INFO_MAP.computeIfAbsent(className, ClassInfo::parse);
    }

    public static void reset() {
        ROOT_CLASS_INFO_MAP.clear();
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    private static ClassInfo parse(String className) {
        ClassInfo classInfo = new ClassInfo(className);
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(className);
        String nameWithoutGenerics = fqjt.getFullyQualifiedNameWithoutTypeParameters();
        if (!nameWithoutGenerics.equals(className)) {
            classInfo.genericMode = true;
        }
        classInfo.javaType = fqjt;
        Class clazz = null;
        try {
            clazz = ObjectFactory.externalClassForName((String)nameWithoutGenerics);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null) {
            if (clazz.isEnum() && supperEnum != null && supperEnum.isAssignableFrom(clazz)) {
                classInfo.isEnum = true;
                ClassInfo.parseEnum(classInfo, clazz);
            } else {
                ClassInfo.parseClass(classInfo, clazz);
            }
        }
        return classInfo;
    }

    private static void parseClass(ClassInfo classInfo, Class<?> clazz) {
        List fields = FieldUtils.getAllFieldsList(clazz);
        fields.forEach(field -> {
            if (!Modifier.isStatic(field.getModifiers())) {
                classInfo.memberFields.add((Field)field);
            }
        });
    }

    private static void parseEnum(ClassInfo classInfo, Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        Arrays.asList(fields).forEach(field -> {
            if (field.isEnumConstant()) {
                classInfo.enuConstants.add((Field)field);
            } else if (!Modifier.isStatic(field.getModifiers())) {
                classInfo.memberFields.add((Field)field);
            }
        });
    }

    private ClassInfo(String className) {
        this.javaType = new FullyQualifiedJavaType(className);
    }

    public TopLevelClass toTopLevelClass() {
        TopLevelClass topLevelClass = new TopLevelClass(this.javaType);
        if (this.memberFields != null) {
            for (Field field : this.memberFields) {
                FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(field.getType().getName());
                org.mybatis.generator.api.dom.java.Field javaField = new org.mybatis.generator.api.dom.java.Field(field.getName(), fqjt);
                topLevelClass.addField(javaField);
                topLevelClass.addImportedType(fqjt);
            }
        }
        return topLevelClass;
    }

    public TopLevelEnumeration toTopLevelEnumeration(String enumTargetPackage, String shortName, String projectRootAlias) {
        String camelCaseName = JavaBeansUtil.convertCamelCase((String)shortName, (String)"-");
        FullyQualifiedTypescriptType enumType = new FullyQualifiedTypescriptType(projectRootAlias, enumTargetPackage + "." + camelCaseName + "." + shortName, true);
        TopLevelEnumeration topLevelEnumeration = new TopLevelEnumeration((FullyQualifiedJavaType)enumType);
        if (this.enuConstants != null) {
            EnumInfo enumInfo = new EnumInfo();
            for (Field field : this.enuConstants) {
                try {
                    Object enumValue = field.get(null);
                    if (enumValue == null) continue;
                    Method nameField = enumValue.getClass().getMethod("name", new Class[0]);
                    Method labelField = enumValue.getClass().getMethod("getLabel", new Class[0]);
                    Method valueField = enumValue.getClass().getMethod("getValue", new Class[0]);
                    enumInfo.addItem((String)nameField.invoke(enumValue, new Object[0]), (String)labelField.invoke(enumValue, new Object[0]), valueField.invoke(enumValue, new Object[0]));
                }
                catch (Exception enumValue) {}
            }
            topLevelEnumeration.setAttribute("TABLE_ENUM_FIELD_ATTR_SOURCE", (Object)enumInfo);
            for (Field field : this.memberFields) {
                FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(field.getType().getName());
                org.mybatis.generator.api.dom.java.Field javaField = new org.mybatis.generator.api.dom.java.Field(field.getName(), fqjt);
                topLevelEnumeration.addField(javaField);
                topLevelEnumeration.addImportedType(fqjt);
            }
        }
        return topLevelEnumeration;
    }

    public static void main(String[] args) {
        ClassInfo classInfo = ClassInfo.getInstance("net.entframework.kernel.core.enums.StatusEnum");
        TopLevelEnumeration topLevelEnumeration = classInfo.toTopLevelEnumeration("", "", "");
        ClassInfo classInfo2 = ClassInfo.getInstance("net.entframework.kernel.core.pojo.request.BaseQuery");
        classInfo2.toTopLevelClass();
    }

    static {
        supperEnum = null;
        ROOT_CLASS_INFO_MAP = Collections.synchronizedMap(new HashMap());
        try {
            supperEnum = ObjectFactory.externalClassForName((String)"net.entframework.kernel.core.enums.SupperEnum");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

